/*
 * Decompiled with CFR 0.152.
 */
package com.olacabs.fabric.compute.util;

import com.olacabs.fabric.common.util.PropertyReader;
import com.olacabs.fabric.model.common.ComponentMetadata;
import java.util.Properties;

public final class ComponentPropertyReader {
    private ComponentPropertyReader() {
    }

    public static String readString(Properties properties, Properties global, String propertyName, String instanceId, ComponentMetadata componentMetadata) {
        return ComponentPropertyReader.readString(properties, global, propertyName, instanceId, componentMetadata, null);
    }

    public static String readString(Properties properties, Properties global, String propertyName, String instanceId, ComponentMetadata componentMetadata, String defaultValue) {
        String key = ComponentPropertyReader.generateKey(propertyName, instanceId, componentMetadata);
        return PropertyReader.readString((Properties)properties, (Properties)global, (String)key, (String)defaultValue);
    }

    public static Integer readInteger(Properties properties, Properties global, String propertyName, String instanceId, ComponentMetadata componentMetadata) {
        return ComponentPropertyReader.readInteger(properties, global, propertyName, instanceId, componentMetadata, null);
    }

    public static Integer readInteger(Properties properties, Properties global, String propertyName, String instanceId, ComponentMetadata componentMetadata, Integer defaultValue) {
        String key = ComponentPropertyReader.generateKey(propertyName, instanceId, componentMetadata);
        return PropertyReader.readInt((Properties)properties, (Properties)global, (String)key, (Integer)defaultValue);
    }

    public static Long readLong(Properties properties, Properties global, String propertyName, String instanceId, ComponentMetadata componentMetadata) {
        return ComponentPropertyReader.readLong(properties, global, propertyName, instanceId, componentMetadata, null);
    }

    public static Long readLong(Properties properties, Properties global, String propertyName, String instanceId, ComponentMetadata componentMetadata, Long defaultValue) {
        String key = ComponentPropertyReader.generateKey(propertyName, instanceId, componentMetadata);
        return PropertyReader.readLong((Properties)properties, (Properties)global, (String)key, (Long)defaultValue);
    }

    public static Boolean readBoolean(Properties properties, Properties global, String propertyName, String instanceId, ComponentMetadata componentMetadata) {
        return ComponentPropertyReader.readBoolean(properties, global, propertyName, instanceId, componentMetadata, null);
    }

    public static Boolean readBoolean(Properties properties, Properties global, String propertyName, String instanceId, ComponentMetadata componentMetadata, Boolean defaultValue) {
        String key = ComponentPropertyReader.generateKey(propertyName, instanceId, componentMetadata);
        return PropertyReader.readBoolean((Properties)properties, (Properties)global, (String)key, (Boolean)defaultValue);
    }

    private static String generateKey(String propertyName, String instanceId, ComponentMetadata componentMetadata) {
        return String.format("%s.%s.%s", componentMetadata.getType().name().toLowerCase(), instanceId, propertyName);
    }
}

