/*
 * Decompiled with CFR 0.152.
 */
package com.olacabs.fabric.model.computation;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.google.common.collect.Maps;
import com.olacabs.fabric.model.computation.ComponentInstance;
import com.olacabs.fabric.model.computation.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.Email;
import org.hibernate.validator.constraints.NotEmpty;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ComputationSpec {
    private Properties properties = new Properties();
    private String id;
    @NotNull
    @NotEmpty
    private String name;
    @NotNull
    @Email
    private String email;
    @NotNull
    private String description;
    @NotNull
    private Map<String, String> attributes = Maps.newHashMap();
    @NotNull
    @NotEmpty
    private Set<ComponentInstance> sources;
    @NotNull
    @NotEmpty
    private Set<ComponentInstance> processors;
    @NotNull
    @NotEmpty
    private List<Connection> connections;

    public void addProperty(String key, String value) {
        this.properties.put(key, value);
    }

    public static ComputationSpecBuilder builder() {
        return new ComputationSpecBuilder();
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getEmail() {
        return this.email;
    }

    public String getDescription() {
        return this.description;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public Set<ComponentInstance> getSources() {
        return this.sources;
    }

    public Set<ComponentInstance> getProcessors() {
        return this.processors;
    }

    public List<Connection> getConnections() {
        return this.connections;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public void setSources(Set<ComponentInstance> sources) {
        this.sources = sources;
    }

    public void setProcessors(Set<ComponentInstance> processors) {
        this.processors = processors;
    }

    public void setConnections(List<Connection> connections) {
        this.connections = connections;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ComputationSpec)) {
            return false;
        }
        ComputationSpec other = (ComputationSpec)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Properties this$properties = this.getProperties();
        Properties other$properties = other.getProperties();
        if (this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$email = this.getEmail();
        String other$email = other.getEmail();
        if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        Map<String, String> this$attributes = this.getAttributes();
        Map<String, String> other$attributes = other.getAttributes();
        if (this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes)) {
            return false;
        }
        Set<ComponentInstance> this$sources = this.getSources();
        Set<ComponentInstance> other$sources = other.getSources();
        if (this$sources == null ? other$sources != null : !((Object)this$sources).equals(other$sources)) {
            return false;
        }
        Set<ComponentInstance> this$processors = this.getProcessors();
        Set<ComponentInstance> other$processors = other.getProcessors();
        if (this$processors == null ? other$processors != null : !((Object)this$processors).equals(other$processors)) {
            return false;
        }
        List<Connection> this$connections = this.getConnections();
        List<Connection> other$connections = other.getConnections();
        return !(this$connections == null ? other$connections != null : !((Object)this$connections).equals(other$connections));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ComputationSpec;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Properties $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        Map<String, String> $attributes = this.getAttributes();
        result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
        Set<ComponentInstance> $sources = this.getSources();
        result = result * 59 + ($sources == null ? 43 : ((Object)$sources).hashCode());
        Set<ComponentInstance> $processors = this.getProcessors();
        result = result * 59 + ($processors == null ? 43 : ((Object)$processors).hashCode());
        List<Connection> $connections = this.getConnections();
        result = result * 59 + ($connections == null ? 43 : ((Object)$connections).hashCode());
        return result;
    }

    public String toString() {
        return "ComputationSpec(properties=" + this.getProperties() + ", id=" + this.getId() + ", name=" + this.getName() + ", email=" + this.getEmail() + ", description=" + this.getDescription() + ", attributes=" + this.getAttributes() + ", sources=" + this.getSources() + ", processors=" + this.getProcessors() + ", connections=" + this.getConnections() + ")";
    }

    public ComputationSpec(Properties properties, String id, String name, String email, String description, Map<String, String> attributes, Set<ComponentInstance> sources, Set<ComponentInstance> processors, List<Connection> connections) {
        this.properties = properties;
        this.id = id;
        this.name = name;
        this.email = email;
        this.description = description;
        this.attributes = attributes;
        this.sources = sources;
        this.processors = processors;
        this.connections = connections;
    }

    public ComputationSpec() {
    }

    public static class ComputationSpecBuilder {
        private Properties properties;
        private String id;
        private String name;
        private String email;
        private String description;
        private ArrayList<String> attributes$key;
        private ArrayList<String> attributes$value;
        private ArrayList<ComponentInstance> sources;
        private ArrayList<ComponentInstance> processors;
        private ArrayList<Connection> connections;

        ComputationSpecBuilder() {
        }

        public ComputationSpecBuilder properties(Properties properties) {
            this.properties = properties;
            return this;
        }

        public ComputationSpecBuilder id(String id) {
            this.id = id;
            return this;
        }

        public ComputationSpecBuilder name(String name) {
            this.name = name;
            return this;
        }

        public ComputationSpecBuilder email(String email) {
            this.email = email;
            return this;
        }

        public ComputationSpecBuilder description(String description) {
            this.description = description;
            return this;
        }

        public ComputationSpecBuilder attribute(String attributeKey, String attributeValue) {
            if (this.attributes$key == null) {
                this.attributes$key = new ArrayList();
                this.attributes$value = new ArrayList();
            }
            this.attributes$key.add(attributeKey);
            this.attributes$value.add(attributeValue);
            return this;
        }

        public ComputationSpecBuilder attributes(Map<? extends String, ? extends String> attributes) {
            if (this.attributes$key == null) {
                this.attributes$key = new ArrayList();
                this.attributes$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : attributes.entrySet()) {
                this.attributes$key.add($lombokEntry.getKey());
                this.attributes$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public ComputationSpecBuilder clearAttributes() {
            if (this.attributes$key != null) {
                this.attributes$key.clear();
                this.attributes$value.clear();
            }
            return this;
        }

        public ComputationSpecBuilder source(ComponentInstance source) {
            if (this.sources == null) {
                this.sources = new ArrayList();
            }
            this.sources.add(source);
            return this;
        }

        public ComputationSpecBuilder sources(Collection<? extends ComponentInstance> sources) {
            if (this.sources == null) {
                this.sources = new ArrayList();
            }
            this.sources.addAll(sources);
            return this;
        }

        public ComputationSpecBuilder clearSources() {
            if (this.sources != null) {
                this.sources.clear();
            }
            return this;
        }

        public ComputationSpecBuilder processor(ComponentInstance processor) {
            if (this.processors == null) {
                this.processors = new ArrayList();
            }
            this.processors.add(processor);
            return this;
        }

        public ComputationSpecBuilder processors(Collection<? extends ComponentInstance> processors) {
            if (this.processors == null) {
                this.processors = new ArrayList();
            }
            this.processors.addAll(processors);
            return this;
        }

        public ComputationSpecBuilder clearProcessors() {
            if (this.processors != null) {
                this.processors.clear();
            }
            return this;
        }

        public ComputationSpecBuilder connection(Connection connection) {
            if (this.connections == null) {
                this.connections = new ArrayList();
            }
            this.connections.add(connection);
            return this;
        }

        public ComputationSpecBuilder connections(Collection<? extends Connection> connections) {
            if (this.connections == null) {
                this.connections = new ArrayList();
            }
            this.connections.addAll(connections);
            return this;
        }

        public ComputationSpecBuilder clearConnections() {
            if (this.connections != null) {
                this.connections.clear();
            }
            return this;
        }

        public ComputationSpec build() {
            List<Connection> connections;
            Set<Object> processors;
            Set<Object> sources;
            Map<Object, Object> attributes;
            switch (this.attributes$key == null ? 0 : this.attributes$key.size()) {
                case 0: {
                    attributes = Collections.emptyMap();
                    break;
                }
                case 1: {
                    attributes = Collections.singletonMap(this.attributes$key.get(0), this.attributes$value.get(0));
                    break;
                }
                default: {
                    attributes = new LinkedHashMap(this.attributes$key.size() < 0x40000000 ? 1 + this.attributes$key.size() + (this.attributes$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.attributes$key.size(); ++$i) {
                        attributes.put(this.attributes$key.get($i), this.attributes$value.get($i));
                    }
                    attributes = Collections.unmodifiableMap(attributes);
                }
            }
            switch (this.sources == null ? 0 : this.sources.size()) {
                case 0: {
                    sources = Collections.emptySet();
                    break;
                }
                case 1: {
                    sources = Collections.singleton(this.sources.get(0));
                    break;
                }
                default: {
                    sources = new LinkedHashSet(this.sources.size() < 0x40000000 ? 1 + this.sources.size() + (this.sources.size() - 3) / 3 : Integer.MAX_VALUE);
                    sources.addAll(this.sources);
                    sources = Collections.unmodifiableSet(sources);
                }
            }
            switch (this.processors == null ? 0 : this.processors.size()) {
                case 0: {
                    processors = Collections.emptySet();
                    break;
                }
                case 1: {
                    processors = Collections.singleton(this.processors.get(0));
                    break;
                }
                default: {
                    processors = new LinkedHashSet(this.processors.size() < 0x40000000 ? 1 + this.processors.size() + (this.processors.size() - 3) / 3 : Integer.MAX_VALUE);
                    processors.addAll(this.processors);
                    processors = Collections.unmodifiableSet(processors);
                }
            }
            switch (this.connections == null ? 0 : this.connections.size()) {
                case 0: {
                    connections = Collections.emptyList();
                    break;
                }
                case 1: {
                    connections = Collections.singletonList(this.connections.get(0));
                    break;
                }
                default: {
                    connections = Collections.unmodifiableList(new ArrayList<Connection>(this.connections));
                }
            }
            return new ComputationSpec(this.properties, this.id, this.name, this.email, this.description, attributes, sources, processors, connections);
        }

        public String toString() {
            return "ComputationSpec.ComputationSpecBuilder(properties=" + this.properties + ", id=" + this.id + ", name=" + this.name + ", email=" + this.email + ", description=" + this.description + ", attributes$key=" + this.attributes$key + ", attributes$value=" + this.attributes$value + ", sources=" + this.sources + ", processors=" + this.processors + ", connections=" + this.connections + ")";
        }
    }
}

