/*
 * Decompiled with CFR 0.152.
 */
package com.omarnyte.handler;

import com.omarnyte.Directory;
import com.omarnyte.handler.Handler;
import com.omarnyte.http.MessageHeader;
import com.omarnyte.request.Request;
import com.omarnyte.response.Response;
import com.omarnyte.util.ResponseUtil;
import java.util.Arrays;
import java.util.List;

public class DirectoryHandler
implements Handler {
    private static final List<String> SUPPORTED_METHODS = Arrays.asList("GET", "HEAD", "OPTIONS");
    private Directory directory;
    private String subdirectoryUri;

    public DirectoryHandler(Directory directory) {
        this.directory = directory;
        this.subdirectoryUri = "";
    }

    public DirectoryHandler(Directory directory, String subdirectoryUri) {
        this.directory = directory;
        this.subdirectoryUri = subdirectoryUri;
    }

    @Override
    public Response generateResponse(Request request) {
        String method;
        switch (method = request.getMethod()) {
            case "OPTIONS": {
                return ResponseUtil.buildOptionsResponse(SUPPORTED_METHODS);
            }
            case "HEAD": {
                return this.buildHeadResponse();
            }
            case "GET": {
                return this.buildGetResponse();
            }
        }
        return ResponseUtil.buildMethodNotAllowedResponse(SUPPORTED_METHODS);
    }

    private Response buildHeadResponse() {
        String messageBody = this.createMessageBody();
        int contentLength = MessageHeader.determineContentLength(messageBody);
        return new Response.Builder(200).setHeader("Content-Length", contentLength).setHeader("Content-Type", "text/html").build();
    }

    private Response buildGetResponse() {
        String messageBody = this.createMessageBody();
        int contentLength = MessageHeader.determineContentLength(messageBody);
        return new Response.Builder(200).setHeader("Content-Length", contentLength).setHeader("Content-Type", "text/html").messageBody(messageBody).build();
    }

    private String createMessageBody() {
        String[] fileNames;
        Object htmlResponse = "";
        for (String fileName : fileNames = this.directory.listContent()) {
            htmlResponse = (String)htmlResponse + String.format("<a href=\"%s/%s\">%s</a><br>", this.subdirectoryUri, fileName, fileName);
        }
        return htmlResponse;
    }
}

