/*
 * Decompiled with CFR 0.152.
 */
package com.omarnyte.handler;

import com.omarnyte.handler.Handler;
import com.omarnyte.http.MessageHeader;
import com.omarnyte.request.Request;
import com.omarnyte.response.Response;
import java.text.SimpleDateFormat;
import java.util.Date;

public class EchoHandler
implements Handler {
    private static final String TIME_FORMAT = "hh:mm:ss";

    @Override
    public Response generateResponse(Request request) {
        String method;
        switch (method = request.getMethod()) {
            case "HEAD": {
                return this.buildHeadResponse();
            }
            case "GET": {
                return this.buildGetResponse();
            }
        }
        return new Response.Builder(405).build();
    }

    private Response buildHeadResponse() {
        String messageBody = this.createMessageBody();
        int contentLength = MessageHeader.determineContentLength(messageBody);
        return new Response.Builder(200).setHeader("Content-Type", "text/plain").setHeader("Content-Length", contentLength).build();
    }

    private Response buildGetResponse() {
        String messageBody = this.createMessageBody();
        int contentLength = MessageHeader.determineContentLength(messageBody);
        return new Response.Builder(200).setHeader("Content-Type", "text/plain").setHeader("Content-Length", contentLength).messageBody(messageBody).build();
    }

    private String createMessageBody() {
        return "Hello, world: " + this.getFormattedTime();
    }

    private String getFormattedTime() {
        SimpleDateFormat dateFormat = new SimpleDateFormat(TIME_FORMAT);
        return dateFormat.format(new Date());
    }
}

