/*
 * Decompiled with CFR 0.152.
 */
package com.omarnyte.jsonpatch;

import com.omarnyte.exception.BadRequestException;
import com.omarnyte.exception.UnprocessableEntityException;
import com.omarnyte.jsonpatch.JsonPatchOperation;
import org.json.JSONObject;

public class JsonPatchMove
extends JsonPatchOperation {
    String from;

    public JsonPatchMove(String op, String from, String path) {
        super(op, path);
        this.from = from;
    }

    @Override
    public String applyOperation(String original) throws BadRequestException, UnprocessableEntityException {
        JSONObject originalAsJson = new JSONObject(original);
        String[] fromKeys = this.extractKeys(this.from);
        String[] pathKeys = this.extractKeys(this.path);
        originalAsJson = this.moveValue(originalAsJson, fromKeys, pathKeys);
        return originalAsJson.toString();
    }

    private JSONObject moveValue(JSONObject jsonObject, String[] fromKeys, String[] pathKeys) throws UnprocessableEntityException {
        String toBeRemoved = this.getValueFromJsonObjectGivenKeys(jsonObject, fromKeys);
        jsonObject = this.removeValue(jsonObject, fromKeys);
        jsonObject = this.addValue(toBeRemoved, jsonObject, pathKeys);
        return jsonObject;
    }
}

