/*
 * Decompiled with CFR 0.152.
 */
package com.omarnyte.response;

import com.omarnyte.response.HttpStatusCode;
import java.util.HashMap;

public class Response {
    private byte[] messageBody;
    private String reasonPhrase;
    private int statusCode;
    private String version;
    private HashMap<String, String> headers;

    private Response(Builder builder) {
        this.version = builder.version;
        this.statusCode = builder.statusCode;
        this.reasonPhrase = builder.reasonPhrase;
        this.messageBody = builder.messageBody;
        this.headers = builder.headers;
    }

    public String getHTTPVersion() {
        return this.version;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getReasonPhrase() {
        return this.reasonPhrase;
    }

    public byte[] getMessageBody() {
        return this.messageBody;
    }

    public String getHeader(String headerField) {
        return this.headers.get(headerField);
    }

    public HashMap<String, String> getHeaders() {
        return this.headers;
    }

    public static class Builder {
        private HashMap<String, String> headers;
        private byte[] messageBody;
        private String reasonPhrase;
        private int statusCode;
        private String version;

        public Builder(Response oldResponse) {
            this.statusCode = oldResponse.statusCode;
            this.reasonPhrase = oldResponse.reasonPhrase;
            this.version = oldResponse.version;
            this.headers = oldResponse.headers;
            this.messageBody = oldResponse.messageBody;
        }

        public Builder(int statusCode) {
            this.statusCode = statusCode;
            this.reasonPhrase = HttpStatusCode.getReasonPhrase(statusCode);
            this.version = "1.1";
            this.headers = new HashMap();
            this.messageBody = "".getBytes();
        }

        public Builder httpVersion(String version) {
            this.version = version;
            return this;
        }

        public Builder statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        public Builder reasonPhrase(String reasonPhrase) {
            this.reasonPhrase = reasonPhrase;
            return this;
        }

        public Builder messageBody(byte[] messageBody) {
            this.messageBody = messageBody;
            return this;
        }

        public Builder messageBody(String messageBody) {
            this.messageBody = messageBody.getBytes();
            return this;
        }

        public Builder setHeader(String headerField, String value) {
            this.headers.put(headerField, value);
            return this;
        }

        public Builder setHeader(String headerField, int value) {
            String stringifiedValue = Integer.toString(value);
            this.headers.put(headerField, stringifiedValue);
            return this;
        }

        public Builder headers(HashMap<String, String> headers) {
            this.headers = headers;
            return this;
        }

        public Response build() {
            return new Response(this);
        }
    }
}

