/*
 * Decompiled with CFR 0.152.
 */
package com.omarnyte.handler;

import com.omarnyte.Directory;
import com.omarnyte.handler.Handler;
import com.omarnyte.request.Request;
import com.omarnyte.response.Response;
import com.omarnyte.util.ResponseUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class FileHandler
implements Handler {
    private static final List<String> SUPPORTED_METHODS = Arrays.asList("DELETE", "GET", "HEAD", "OPTIONS");
    private Directory directory;

    public FileHandler(Directory directory) {
        this.directory = directory;
    }

    @Override
    public Response generateResponse(Request request) {
        switch (request.getMethod()) {
            case "OPTIONS": {
                List<String> supportedMethods = this.getSupportedMethods(request.getURI());
                return ResponseUtil.buildOptionsResponse(supportedMethods);
            }
            case "GET": {
                return this.buildGetResponse(request.getURI());
            }
            case "HEAD": {
                return this.buildHeadResponse(request.getURI());
            }
            case "PUT": {
                return this.handlePutRequest(request);
            }
            case "DELETE": {
                return this.handleDeleteRequest(request.getURI());
            }
        }
        return new Response.Builder(405).build();
    }

    private List<String> getSupportedMethods(String uri) {
        ArrayList<String> supportedMethods = new ArrayList<String>(SUPPORTED_METHODS);
        if (this.isPatchable(uri)) {
            supportedMethods.add("PATCH");
        }
        if (this.isPutable(uri)) {
            supportedMethods.add("PUT");
        }
        Collections.sort(supportedMethods);
        return supportedMethods;
    }

    private boolean isPatchable(String uri) {
        String fileType = this.directory.getFileType(uri);
        return fileType.equals("application/json");
    }

    private boolean isPutable(String uri) {
        String fileType = this.directory.getFileType(uri);
        return fileType.equals("application/json") || fileType.equals("text/plain");
    }

    private Response buildGetResponse(String uri) {
        byte[] messageBody = this.directory.readFile(uri);
        int contentLength = messageBody.length;
        String contentType = this.directory.getFileType(uri);
        return new Response.Builder(200).messageBody(messageBody).setHeader("Content-Length", contentLength).setHeader("Content-Type", contentType).build();
    }

    private Response buildHeadResponse(String uri) {
        byte[] messageBody = this.directory.readFile(uri);
        int contentLength = messageBody.length;
        String contentType = this.directory.getFileType(uri);
        return new Response.Builder(200).setHeader("Content-Length", contentLength).setHeader("Content-Type", contentType).build();
    }

    public Response handlePutRequest(Request request) {
        byte[] content = request.getBody().getBytes();
        String uri = request.getURI();
        return this.directory.overwriteFileWithContent(uri, content) ? this.buildPutResponse(request) : this.buildInternalServerErrorResponse();
    }

    private Response buildPutResponse(Request request) {
        return new Response.Builder(200).build();
    }

    private Response handleDeleteRequest(String uri) {
        return this.directory.deleteFile(uri) ? this.buildDeleteResponse() : this.buildInternalServerErrorResponse();
    }

    private Response buildDeleteResponse() {
        return new Response.Builder(204).build();
    }

    private Response buildInternalServerErrorResponse() {
        return new Response.Builder(500).build();
    }
}

