/*
 * Decompiled with CFR 0.152.
 */
package com.omarnyte.handler;

import com.omarnyte.handler.Handler;
import com.omarnyte.http.MessageHeader;
import com.omarnyte.request.Request;
import com.omarnyte.request.UrlDecoder;
import com.omarnyte.response.Response;
import com.omarnyte.util.ResponseUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class QueryHandler
implements Handler {
    private static final List<String> SUPPORTED_METHODS = Arrays.asList("GET", "HEAD", "OPTIONS");
    private UrlDecoder urlDecoder;

    public QueryHandler(UrlDecoder urlDecoder) {
        this.urlDecoder = urlDecoder;
    }

    @Override
    public Response generateResponse(Request request) {
        switch (request.getMethod()) {
            case "OPTIONS": {
                return ResponseUtil.buildOptionsResponse(SUPPORTED_METHODS);
            }
            case "HEAD": {
                return this.buildHeadResponse(request);
            }
            case "GET": {
                return this.buildGetResponse(request);
            }
        }
        return new Response.Builder(405).build();
    }

    private Response buildHeadResponse(Request request) {
        String messageBody = this.createMessageBody(request.getQuery());
        int contentLength = MessageHeader.determineContentLength(messageBody);
        HashMap<String, String> headers = this.getHeaders(contentLength);
        return new Response.Builder(200).headers(headers).build();
    }

    private Response buildGetResponse(Request request) {
        try {
            String messageBody = this.createMessageBody(request.getQuery());
            int contentLength = MessageHeader.determineContentLength(messageBody);
            HashMap<String, String> headers = this.getHeaders(contentLength);
            return new Response.Builder(200).headers(headers).messageBody(messageBody).build();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return new Response.Builder(400).build();
        }
    }

    private HashMap<String, String> getHeaders(int contentLength) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "text/plain");
        headers.put("Content-Length", Integer.toString(contentLength));
        return headers;
    }

    private String createMessageBody(String query) {
        String[] splitQuery;
        Object body = "";
        for (String paramPair : splitQuery = query.split("&")) {
            String[] splitParameters = paramPair.split("=");
            String key = splitParameters[0];
            String val = splitParameters[1];
            String decodedKey = this.urlDecoder.decodeString(key);
            String decodedVal = this.urlDecoder.decodeString(val);
            body = (String)body + decodedKey + " : " + decodedVal + "\n";
        }
        return body;
    }
}

