/* Copyright 2018 Outpace Systems, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package outpace.memory_estimator;

import java.lang.instrument.Instrumentation;

@SuppressWarnings("unused")
public class Estimator {
    private static final Estimator INSTANCE = new Estimator();
    private Instrumentation instrumentation;

    private static void premain(String args, Instrumentation instrumentation) {
        INSTANCE.instrumentation = instrumentation;
    }

    public static Estimator getInstance() {
        if (INSTANCE.instrumentation == null) {
            System.err.println("The Outpace Memory Estimator agent has not been loaded.");
        }
        return INSTANCE;
    }

    public long getSize(Object o) {
        if (instrumentation == null) {
            return 0;
        } else {
            return instrumentation.getObjectSize(o);
        }
    }
}
