(ns
 com.palletops.awaze.autoscaling
 (:require [com.palletops.awaze.common]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :autoscaling
  [___1561__auto__
   ^com.amazonaws.auth.BasicAWSCredentials credentials__1562__auto__]
  (new
   com.amazonaws.services.autoscaling.AmazonAutoScalingClient
   credentials__1562__auto__))
 (clojure.core/defn
  ^com.amazonaws.services.autoscaling.model.Ebs ebs
  [m2915]
  (clojure.core/let
   [bean2914 (new com.amazonaws.services.autoscaling.model.Ebs)]
   (clojure.core/when-let
    [v2916 (:snapshot-id m2915)]
    (. bean2914 setSnapshotId (clojure.core/str v2916)))
   (clojure.core/when-let
    [v2916 (:volume-size m2915)]
    (. bean2914 setVolumeSize (clojure.core/int v2916)))
   bean2914))
 (clojure.core/defn
  ^com.amazonaws.services.autoscaling.model.Tag tag
  [m2918]
  (clojure.core/let
   [bean2917 (new com.amazonaws.services.autoscaling.model.Tag)]
   (clojure.core/when-let
    [v2919 (:value m2918)]
    (. bean2917 setValue (clojure.core/str v2919)))
   (clojure.core/when-let
    [v2919 (:resource-id m2918)]
    (. bean2917 setResourceId (clojure.core/str v2919)))
   (clojure.core/when-let
    [v2919 (:resource-type m2918)]
    (. bean2917 setResourceType (clojure.core/str v2919)))
   (clojure.core/when-let
    [v2919 (:key m2918)]
    (. bean2917 setKey (clojure.core/str v2919)))
   (clojure.core/when-let
    [v2919 (:propagate-at-launch m2918)]
    (. bean2917 setPropagateAtLaunch (clojure.core/boolean v2919)))
   bean2917))
 (clojure.core/defn
  ^com.amazonaws.services.autoscaling.model.BlockDeviceMapping block-device-mapping
  [m2921]
  (clojure.core/let
   [bean2920
    (new com.amazonaws.services.autoscaling.model.BlockDeviceMapping)]
   (clojure.core/when-let
    [v2922 (:virtual-name m2921)]
    (. bean2920 setVirtualName (clojure.core/str v2922)))
   (clojure.core/when-let
    [v2922 (:device-name m2921)]
    (. bean2920 setDeviceName (clojure.core/str v2922)))
   (clojure.core/when-let
    [v2922 (:ebs m2921)]
    (. bean2920 setEbs (ebs v2922)))
   bean2920))
 (clojure.core/defn
  ^com.amazonaws.services.autoscaling.model.InstanceMonitoring instance-monitoring
  [m2924]
  (clojure.core/let
   [bean2923
    (new com.amazonaws.services.autoscaling.model.InstanceMonitoring)]
   (clojure.core/when-let
    [v2925 (:enabled m2924)]
    (. bean2923 setEnabled (clojure.core/boolean v2925)))
   bean2923))
 (clojure.core/defn
  ^com.amazonaws.services.autoscaling.model.Filter filter
  [m2927]
  (clojure.core/let
   [bean2926 (new com.amazonaws.services.autoscaling.model.Filter)]
   (clojure.core/when-let
    [v2928 (:name m2927)]
    (. bean2926 setName (clojure.core/str v2928)))
   (clojure.core/when-let
    [v2928 (:values m2927)]
    (.
     bean2926
     setValues
     (clojure.core/map
      (clojure.core/fn [arg2932] (clojure.core/str arg2932))
      v2928)))
   bean2926))
 (clojure.core/defn
  ^com.amazonaws.services.autoscaling.model.SetDesiredCapacityRequest set-desired-capacity-request
  [m2930]
  (clojure.core/let
   [bean2929
    (new
     com.amazonaws.services.autoscaling.model.SetDesiredCapacityRequest)]
   (clojure.core/when-let
    [v2931 (:desired-capacity m2930)]
    (. bean2929 setDesiredCapacity (clojure.core/int v2931)))
   (clojure.core/when-let
    [v2931 (:auto-scaling-group-name m2930)]
    (. bean2929 setAutoScalingGroupName (clojure.core/str v2931)))
   (clojure.core/when-let
    [v2931 (:honor-cooldown m2930)]
    (. bean2929 setHonorCooldown (clojure.core/boolean v2931)))
   bean2929))
 (clojure.core/defn
  ^com.amazonaws.services.autoscaling.model.EnableMetricsCollectionRequest enable-metrics-collection-request
  [m2934]
  (clojure.core/let
   [bean2933
    (new
     com.amazonaws.services.autoscaling.model.EnableMetricsCollectionRequest)]
   (clojure.core/when-let
    [v2935 (:auto-scaling-group-name m2934)]
    (. bean2933 setAutoScalingGroupName (clojure.core/str v2935)))
   (clojure.core/when-let
    [v2935 (:metrics m2934)]
    (.
     bean2933
     setMetrics
     (clojure.core/map
      (clojure.core/fn [arg2939] (clojure.core/str arg2939))
      v2935)))
   (clojure.core/when-let
    [v2935 (:granularity m2934)]
    (. bean2933 setGranularity (clojure.core/str v2935)))
   bean2933))
 (clojure.core/defn
  ^com.amazonaws.services.autoscaling.model.DeletePolicyRequest delete-policy-request
  [m2937]
  (clojure.core/let
   [bean2936
    (new com.amazonaws.services.autoscaling.model.DeletePolicyRequest)]
   (clojure.core/when-let
    [v2938 (:auto-scaling-group-name m2937)]
    (. bean2936 setAutoScalingGroupName (clojure.core/str v2938)))
   (clojure.core/when-let
    [v2938 (:policy-name m2937)]
    (. bean2936 setPolicyName (clojure.core/str v2938)))
   bean2936))
 (clojure.core/defn
  ^com.amazonaws.services.autoscaling.model.SetInstanceHealthRequest set-instance-health-request
  [m2941]
  (clojure.core/let
   [bean2940
    (new
     com.amazonaws.services.autoscaling.model.SetInstanceHealthRequest)]
   (clojure.core/when-let
    [v2942 (:health-status m2941)]
    (. bean2940 setHealthStatus (clojure.core/str v2942)))
   (clojure.core/when-let
    [v2942 (:should-respect-grace-period m2941)]
    (.
     bean2940
     setShouldRespectGracePeriod
     (clojure.core/boolean v2942)))
   (clojure.core/when-let
    [v2942 (:instance-id m2941)]
    (. bean2940 setInstanceId (clojure.core/str v2942)))
   bean2940))
 (clojure.core/defn
  ^com.amazonaws.services.autoscaling.model.DescribeLaunchConfigurationsRequest describe-launch-configurations-request
  [m2944]
  (clojure.core/let
   [bean2943
    (new
     com.amazonaws.services.autoscaling.model.DescribeLaunchConfigurationsRequest)]
   (clojure.core/when-let
    [v2945 (:next-token m2944)]
    (. bean2943 setNextToken (clojure.core/str v2945)))
   (clojure.core/when-let
    [v2945 (:launch-configuration-names m2944)]
    (.
     bean2943
     setLaunchConfigurationNames
     (clojure.core/map
      (clojure.core/fn [arg2949] (clojure.core/str arg2949))
      v2945)))
   (clojure.core/when-let
    [v2945 (:max-records m2944)]
    (. bean2943 setMaxRecords (clojure.core/int v2945)))
   bean2943))
 (clojure.core/defn
  ^com.amazonaws.services.autoscaling.model.DeleteTagsRequest delete-tags-request
  [m2947]
  (clojure.core/let
   [bean2946
    (new com.amazonaws.services.autoscaling.model.DeleteTagsRequest)]
   (clojure.core/when-let
    [v2948 (:tags m2947)]
    (.
     bean2946
     setTags
     (clojure.core/map
      (clojure.core/fn [arg2953] (tag arg2953))
      v2948)))
   bean2946))
 (clojure.core/defn
  ^com.amazonaws.services.autoscaling.model.DescribeAutoScalingInstancesRequest describe-auto-scaling-instances-request
  [m2951]
  (clojure.core/let
   [bean2950
    (new
     com.amazonaws.services.autoscaling.model.DescribeAutoScalingInstancesRequest)]
   (clojure.core/when-let
    [v2952 (:next-token m2951)]
    (. bean2950 setNextToken (clojure.core/str v2952)))
   (clojure.core/when-let
    [v2952 (:instance-ids m2951)]
    (.
     bean2950
     setInstanceIds
     (clojure.core/map
      (clojure.core/fn [arg2957] (clojure.core/str arg2957))
      v2952)))
   (clojure.core/when-let
    [v2952 (:max-records m2951)]
    (. bean2950 setMaxRecords (clojure.core/int v2952)))
   bean2950))
 (clojure.core/defn
  ^com.amazonaws.services.autoscaling.model.DescribeNotificationConfigurationsRequest describe-notification-configurations-request
  [m2955]
  (clojure.core/let
   [bean2954
    (new
     com.amazonaws.services.autoscaling.model.DescribeNotificationConfigurationsRequest)]
   (clojure.core/when-let
    [v2956 (:next-token m2955)]
    (. bean2954 setNextToken (clojure.core/str v2956)))
   (clojure.core/when-let
    [v2956 (:max-records m2955)]
    (. bean2954 setMaxRecords (clojure.core/int v2956)))
   (clojure.core/when-let
    [v2956 (:auto-scaling-group-names m2955)]
    (.
     bean2954
     setAutoScalingGroupNames
     (clojure.core/map
      (clojure.core/fn [arg2961] (clojure.core/str arg2961))
      v2956)))
   bean2954))
 (clojure.core/defn
  ^com.amazonaws.services.autoscaling.model.DescribeAutoScalingNotificationTypesRequest describe-auto-scaling-notification-types-request
  [m2959]
  (clojure.core/let
   [bean2958
    (new
     com.amazonaws.services.autoscaling.model.DescribeAutoScalingNotificationTypesRequest)]
   bean2958))
 (clojure.core/defn
  ^com.amazonaws.services.autoscaling.model.PutNotificationConfigurationRequest put-notification-configuration-request
  [m2963]
  (clojure.core/let
   [bean2962
    (new
     com.amazonaws.services.autoscaling.model.PutNotificationConfigurationRequest)]
   (clojure.core/when-let
    [v2964 (:topic-arn m2963)]
    (. bean2962 setTopicARN (clojure.core/str v2964)))
   (clojure.core/when-let
    [v2964 (:notification-types m2963)]
    (.
     bean2962
     setNotificationTypes
     (clojure.core/map
      (clojure.core/fn [arg2968] (clojure.core/str arg2968))
      v2964)))
   (clojure.core/when-let
    [v2964 (:auto-scaling-group-name m2963)]
    (. bean2962 setAutoScalingGroupName (clojure.core/str v2964)))
   bean2962))
 (clojure.core/defn
  ^com.amazonaws.services.autoscaling.model.DescribePoliciesRequest describe-policies-request
  [m2966]
  (clojure.core/let
   [bean2965
    (new
     com.amazonaws.services.autoscaling.model.DescribePoliciesRequest)]
   (clojure.core/when-let
    [v2967 (:next-token m2966)]
    (. bean2965 setNextToken (clojure.core/str v2967)))
   (clojure.core/when-let
    [v2967 (:auto-scaling-group-name m2966)]
    (. bean2965 setAutoScalingGroupName (clojure.core/str v2967)))
   (clojure.core/when-let
    [v2967 (:max-records m2966)]
    (. bean2965 setMaxRecords (clojure.core/int v2967)))
   (clojure.core/when-let
    [v2967 (:policy-names m2966)]
    (.
     bean2965
     setPolicyNames
     (clojure.core/map
      (clojure.core/fn [arg2972] (clojure.core/str arg2972))
      v2967)))
   bean2965))
 (clojure.core/defn
  ^com.amazonaws.services.autoscaling.model.SuspendProcessesRequest suspend-processes-request
  [m2970]
  (clojure.core/let
   [bean2969
    (new
     com.amazonaws.services.autoscaling.model.SuspendProcessesRequest)]
   (clojure.core/when-let
    [v2971 (:auto-scaling-group-name m2970)]
    (. bean2969 setAutoScalingGroupName (clojure.core/str v2971)))
   (clojure.core/when-let
    [v2971 (:scaling-processes m2970)]
    (.
     bean2969
     setScalingProcesses
     (clojure.core/map
      (clojure.core/fn [arg2976] (clojure.core/str arg2976))
      v2971)))
   bean2969))
 (clojure.core/defn
  ^com.amazonaws.services.autoscaling.model.CreateAutoScalingGroupRequest create-auto-scaling-group-request
  [m2974]
  (clojure.core/let
   [bean2973
    (new
     com.amazonaws.services.autoscaling.model.CreateAutoScalingGroupRequest)]
   (clojure.core/when-let
    [v2975 (:desired-capacity m2974)]
    (. bean2973 setDesiredCapacity (clojure.core/int v2975)))
   (clojure.core/when-let
    [v2975 (:tags m2974)]
    (.
     bean2973
     setTags
     (clojure.core/map
      (clojure.core/fn [arg2980] (tag arg2980))
      v2975)))
   (clojure.core/when-let
    [v2975 (:auto-scaling-group-name m2974)]
    (. bean2973 setAutoScalingGroupName (clojure.core/str v2975)))
   (clojure.core/when-let
    [v2975 (:launch-configuration-name m2974)]
    (. bean2973 setLaunchConfigurationName (clojure.core/str v2975)))
   (clojure.core/when-let
    [v2975 (:min-size m2974)]
    (. bean2973 setMinSize (clojure.core/int v2975)))
   (clojure.core/when-let
    [v2975 (:max-size m2974)]
    (. bean2973 setMaxSize (clojure.core/int v2975)))
   (clojure.core/when-let
    [v2975 (:default-cooldown m2974)]
    (. bean2973 setDefaultCooldown (clojure.core/int v2975)))
   (clojure.core/when-let
    [v2975 (:availability-zones m2974)]
    (.
     bean2973
     setAvailabilityZones
     (clojure.core/map
      (clojure.core/fn [arg2981] (clojure.core/str arg2981))
      v2975)))
   (clojure.core/when-let
    [v2975 (:health-check-type m2974)]
    (. bean2973 setHealthCheckType (clojure.core/str v2975)))
   (clojure.core/when-let
    [v2975 (:health-check-grace-period m2974)]
    (. bean2973 setHealthCheckGracePeriod (clojure.core/int v2975)))
   (clojure.core/when-let
    [v2975 (:placement-group m2974)]
    (. bean2973 setPlacementGroup (clojure.core/str v2975)))
   (clojure.core/when-let
    [v2975 (:vpczone-identifier m2974)]
    (. bean2973 setVPCZoneIdentifier (clojure.core/str v2975)))
   (clojure.core/when-let
    [v2975 (:termination-policies m2974)]
    (.
     bean2973
     setTerminationPolicies
     (clojure.core/map
      (clojure.core/fn [arg2982] (clojure.core/str arg2982))
      v2975)))
   (clojure.core/when-let
    [v2975 (:load-balancer-names m2974)]
    (.
     bean2973
     setLoadBalancerNames
     (clojure.core/map
      (clojure.core/fn [arg2983] (clojure.core/str arg2983))
      v2975)))
   bean2973))
 (clojure.core/defn
  ^com.amazonaws.services.autoscaling.model.DescribeAutoScalingGroupsRequest describe-auto-scaling-groups-request
  [m2978]
  (clojure.core/let
   [bean2977
    (new
     com.amazonaws.services.autoscaling.model.DescribeAutoScalingGroupsRequest)]
   (clojure.core/when-let
    [v2979 (:next-token m2978)]
    (. bean2977 setNextToken (clojure.core/str v2979)))
   (clojure.core/when-let
    [v2979 (:max-records m2978)]
    (. bean2977 setMaxRecords (clojure.core/int v2979)))
   (clojure.core/when-let
    [v2979 (:auto-scaling-group-names m2978)]
    (.
     bean2977
     setAutoScalingGroupNames
     (clojure.core/map
      (clojure.core/fn [arg2987] (clojure.core/str arg2987))
      v2979)))
   bean2977))
 (clojure.core/defn
  ^com.amazonaws.services.autoscaling.model.PutScalingPolicyRequest put-scaling-policy-request
  [m2985]
  (clojure.core/let
   [bean2984
    (new
     com.amazonaws.services.autoscaling.model.PutScalingPolicyRequest)]
   (clojure.core/when-let
    [v2986 (:scaling-adjustment m2985)]
    (. bean2984 setScalingAdjustment (clojure.core/int v2986)))
   (clojure.core/when-let
    [v2986 (:adjustment-type m2985)]
    (. bean2984 setAdjustmentType (clojure.core/str v2986)))
   (clojure.core/when-let
    [v2986 (:cooldown m2985)]
    (. bean2984 setCooldown (clojure.core/int v2986)))
   (clojure.core/when-let
    [v2986 (:min-adjustment-step m2985)]
    (. bean2984 setMinAdjustmentStep (clojure.core/int v2986)))
   (clojure.core/when-let
    [v2986 (:auto-scaling-group-name m2985)]
    (. bean2984 setAutoScalingGroupName (clojure.core/str v2986)))
   (clojure.core/when-let
    [v2986 (:policy-name m2985)]
    (. bean2984 setPolicyName (clojure.core/str v2986)))
   bean2984))
 (clojure.core/defn
  ^com.amazonaws.services.autoscaling.model.ExecutePolicyRequest execute-policy-request
  [m2989]
  (clojure.core/let
   [bean2988
    (new
     com.amazonaws.services.autoscaling.model.ExecutePolicyRequest)]
   (clojure.core/when-let
    [v2990 (:auto-scaling-group-name m2989)]
    (. bean2988 setAutoScalingGroupName (clojure.core/str v2990)))
   (clojure.core/when-let
    [v2990 (:policy-name m2989)]
    (. bean2988 setPolicyName (clojure.core/str v2990)))
   (clojure.core/when-let
    [v2990 (:honor-cooldown m2989)]
    (. bean2988 setHonorCooldown (clojure.core/boolean v2990)))
   bean2988))
 (clojure.core/defn
  ^com.amazonaws.services.autoscaling.model.CreateLaunchConfigurationRequest create-launch-configuration-request
  [m2992]
  (clojure.core/let
   [bean2991
    (new
     com.amazonaws.services.autoscaling.model.CreateLaunchConfigurationRequest)]
   (clojure.core/when-let
    [v2993 (:launch-configuration-name m2992)]
    (. bean2991 setLaunchConfigurationName (clojure.core/str v2993)))
   (clojure.core/when-let
    [v2993 (:image-id m2992)]
    (. bean2991 setImageId (clojure.core/str v2993)))
   (clojure.core/when-let
    [v2993 (:key-name m2992)]
    (. bean2991 setKeyName (clojure.core/str v2993)))
   (clojure.core/when-let
    [v2993 (:security-groups m2992)]
    (.
     bean2991
     setSecurityGroups
     (clojure.core/map
      (clojure.core/fn [arg2997] (clojure.core/str arg2997))
      v2993)))
   (clojure.core/when-let
    [v2993 (:user-data m2992)]
    (. bean2991 setUserData (clojure.core/str v2993)))
   (clojure.core/when-let
    [v2993 (:instance-type m2992)]
    (. bean2991 setInstanceType (clojure.core/str v2993)))
   (clojure.core/when-let
    [v2993 (:kernel-id m2992)]
    (. bean2991 setKernelId (clojure.core/str v2993)))
   (clojure.core/when-let
    [v2993 (:ramdisk-id m2992)]
    (. bean2991 setRamdiskId (clojure.core/str v2993)))
   (clojure.core/when-let
    [v2993 (:block-device-mappings m2992)]
    (.
     bean2991
     setBlockDeviceMappings
     (clojure.core/map
      (clojure.core/fn [arg2998] (block-device-mapping arg2998))
      v2993)))
   (clojure.core/when-let
    [v2993 (:instance-monitoring m2992)]
    (. bean2991 setInstanceMonitoring (instance-monitoring v2993)))
   (clojure.core/when-let
    [v2993 (:spot-price m2992)]
    (. bean2991 setSpotPrice (clojure.core/str v2993)))
   (clojure.core/when-let
    [v2993 (:iam-instance-profile m2992)]
    (. bean2991 setIamInstanceProfile (clojure.core/str v2993)))
   (clojure.core/when-let
    [v2993 (:ebs-optimized m2992)]
    (. bean2991 setEbsOptimized (clojure.core/boolean v2993)))
   (clojure.core/when-let
    [v2993 (:associate-public-ip-address m2992)]
    (.
     bean2991
     setAssociatePublicIpAddress
     (clojure.core/boolean v2993)))
   bean2991))
 (clojure.core/defn
  ^com.amazonaws.services.autoscaling.model.DescribeTerminationPolicyTypesRequest describe-termination-policy-types-request
  [m2995]
  (clojure.core/let
   [bean2994
    (new
     com.amazonaws.services.autoscaling.model.DescribeTerminationPolicyTypesRequest)]
   bean2994))
 (clojure.core/defn
  ^com.amazonaws.services.autoscaling.model.DescribeScalingActivitiesRequest describe-scaling-activities-request
  [m3000]
  (clojure.core/let
   [bean2999
    (new
     com.amazonaws.services.autoscaling.model.DescribeScalingActivitiesRequest)]
   (clojure.core/when-let
    [v3001 (:next-token m3000)]
    (. bean2999 setNextToken (clojure.core/str v3001)))
   (clojure.core/when-let
    [v3001 (:auto-scaling-group-name m3000)]
    (. bean2999 setAutoScalingGroupName (clojure.core/str v3001)))
   (clojure.core/when-let
    [v3001 (:max-records m3000)]
    (. bean2999 setMaxRecords (clojure.core/int v3001)))
   (clojure.core/when-let
    [v3001 (:activity-ids m3000)]
    (.
     bean2999
     setActivityIds
     (clojure.core/map
      (clojure.core/fn [arg3005] (clojure.core/str arg3005))
      v3001)))
   bean2999))
 (clojure.core/defn
  ^com.amazonaws.services.autoscaling.model.DescribeScheduledActionsRequest describe-scheduled-actions-request
  [m3003]
  (clojure.core/let
   [bean3002
    (new
     com.amazonaws.services.autoscaling.model.DescribeScheduledActionsRequest)]
   (clojure.core/when-let
    [v3004 (:next-token m3003)]
    (. bean3002 setNextToken (clojure.core/str v3004)))
   (clojure.core/when-let
    [v3004 (:auto-scaling-group-name m3003)]
    (. bean3002 setAutoScalingGroupName (clojure.core/str v3004)))
   (clojure.core/when-let
    [v3004 (:scheduled-action-names m3003)]
    (.
     bean3002
     setScheduledActionNames
     (clojure.core/map
      (clojure.core/fn [arg3009] (clojure.core/str arg3009))
      v3004)))
   (clojure.core/when-let
    [v3004 (:start-time m3003)]
    (.
     bean3002
     setStartTime
     (com.palletops.awaze.common/to-date v3004)))
   (clojure.core/when-let
    [v3004 (:max-records m3003)]
    (. bean3002 setMaxRecords (clojure.core/int v3004)))
   (clojure.core/when-let
    [v3004 (:end-time m3003)]
    (. bean3002 setEndTime (com.palletops.awaze.common/to-date v3004)))
   bean3002))
 (clojure.core/defn
  ^com.amazonaws.services.autoscaling.model.DescribeAdjustmentTypesRequest describe-adjustment-types-request
  [m3007]
  (clojure.core/let
   [bean3006
    (new
     com.amazonaws.services.autoscaling.model.DescribeAdjustmentTypesRequest)]
   bean3006))
 (clojure.core/defn
  ^com.amazonaws.services.autoscaling.model.DescribeTagsRequest describe-tags-request
  [m3011]
  (clojure.core/let
   [bean3010
    (new com.amazonaws.services.autoscaling.model.DescribeTagsRequest)]
   (clojure.core/when-let
    [v3012 (:filters m3011)]
    (.
     bean3010
     setFilters
     (clojure.core/map
      (clojure.core/fn [arg3016] (filter arg3016))
      v3012)))
   (clojure.core/when-let
    [v3012 (:next-token m3011)]
    (. bean3010 setNextToken (clojure.core/str v3012)))
   (clojure.core/when-let
    [v3012 (:max-records m3011)]
    (. bean3010 setMaxRecords (clojure.core/int v3012)))
   bean3010))
 (clojure.core/defn
  ^com.amazonaws.services.autoscaling.model.ResumeProcessesRequest resume-processes-request
  [m3014]
  (clojure.core/let
   [bean3013
    (new
     com.amazonaws.services.autoscaling.model.ResumeProcessesRequest)]
   (clojure.core/when-let
    [v3015 (:auto-scaling-group-name m3014)]
    (. bean3013 setAutoScalingGroupName (clojure.core/str v3015)))
   (clojure.core/when-let
    [v3015 (:scaling-processes m3014)]
    (.
     bean3013
     setScalingProcesses
     (clojure.core/map
      (clojure.core/fn [arg3020] (clojure.core/str arg3020))
      v3015)))
   bean3013))
 (clojure.core/defn
  ^com.amazonaws.services.autoscaling.model.DeleteLaunchConfigurationRequest delete-launch-configuration-request
  [m3018]
  (clojure.core/let
   [bean3017
    (new
     com.amazonaws.services.autoscaling.model.DeleteLaunchConfigurationRequest)]
   (clojure.core/when-let
    [v3019 (:launch-configuration-name m3018)]
    (. bean3017 setLaunchConfigurationName (clojure.core/str v3019)))
   bean3017))
 (clojure.core/defn
  ^com.amazonaws.services.autoscaling.model.DisableMetricsCollectionRequest disable-metrics-collection-request
  [m3022]
  (clojure.core/let
   [bean3021
    (new
     com.amazonaws.services.autoscaling.model.DisableMetricsCollectionRequest)]
   (clojure.core/when-let
    [v3023 (:auto-scaling-group-name m3022)]
    (. bean3021 setAutoScalingGroupName (clojure.core/str v3023)))
   (clojure.core/when-let
    [v3023 (:metrics m3022)]
    (.
     bean3021
     setMetrics
     (clojure.core/map
      (clojure.core/fn [arg3027] (clojure.core/str arg3027))
      v3023)))
   bean3021))
 (clojure.core/defn
  ^com.amazonaws.services.autoscaling.model.PutScheduledUpdateGroupActionRequest put-scheduled-update-group-action-request
  [m3025]
  (clojure.core/let
   [bean3024
    (new
     com.amazonaws.services.autoscaling.model.PutScheduledUpdateGroupActionRequest)]
   (clojure.core/when-let
    [v3026 (:time m3025)]
    (. bean3024 setTime (com.palletops.awaze.common/to-date v3026)))
   (clojure.core/when-let
    [v3026 (:desired-capacity m3025)]
    (. bean3024 setDesiredCapacity (clojure.core/int v3026)))
   (clojure.core/when-let
    [v3026 (:auto-scaling-group-name m3025)]
    (. bean3024 setAutoScalingGroupName (clojure.core/str v3026)))
   (clojure.core/when-let
    [v3026 (:min-size m3025)]
    (. bean3024 setMinSize (clojure.core/int v3026)))
   (clojure.core/when-let
    [v3026 (:max-size m3025)]
    (. bean3024 setMaxSize (clojure.core/int v3026)))
   (clojure.core/when-let
    [v3026 (:start-time m3025)]
    (.
     bean3024
     setStartTime
     (com.palletops.awaze.common/to-date v3026)))
   (clojure.core/when-let
    [v3026 (:end-time m3025)]
    (. bean3024 setEndTime (com.palletops.awaze.common/to-date v3026)))
   (clojure.core/when-let
    [v3026 (:scheduled-action-name m3025)]
    (. bean3024 setScheduledActionName (clojure.core/str v3026)))
   (clojure.core/when-let
    [v3026 (:recurrence m3025)]
    (. bean3024 setRecurrence (clojure.core/str v3026)))
   bean3024))
 (clojure.core/defn
  ^com.amazonaws.services.autoscaling.model.DescribeScalingProcessTypesRequest describe-scaling-process-types-request
  [m3029]
  (clojure.core/let
   [bean3028
    (new
     com.amazonaws.services.autoscaling.model.DescribeScalingProcessTypesRequest)]
   bean3028))
 (clojure.core/defn
  ^com.amazonaws.services.autoscaling.model.DescribeMetricCollectionTypesRequest describe-metric-collection-types-request
  [m3032]
  (clojure.core/let
   [bean3031
    (new
     com.amazonaws.services.autoscaling.model.DescribeMetricCollectionTypesRequest)]
   bean3031))
 (clojure.core/defn
  ^com.amazonaws.services.autoscaling.model.DeleteScheduledActionRequest delete-scheduled-action-request
  [m3035]
  (clojure.core/let
   [bean3034
    (new
     com.amazonaws.services.autoscaling.model.DeleteScheduledActionRequest)]
   (clojure.core/when-let
    [v3036 (:auto-scaling-group-name m3035)]
    (. bean3034 setAutoScalingGroupName (clojure.core/str v3036)))
   (clojure.core/when-let
    [v3036 (:scheduled-action-name m3035)]
    (. bean3034 setScheduledActionName (clojure.core/str v3036)))
   bean3034))
 (clojure.core/defn
  ^com.amazonaws.services.autoscaling.model.UpdateAutoScalingGroupRequest update-auto-scaling-group-request
  [m3038]
  (clojure.core/let
   [bean3037
    (new
     com.amazonaws.services.autoscaling.model.UpdateAutoScalingGroupRequest)]
   (clojure.core/when-let
    [v3039 (:desired-capacity m3038)]
    (. bean3037 setDesiredCapacity (clojure.core/int v3039)))
   (clojure.core/when-let
    [v3039 (:auto-scaling-group-name m3038)]
    (. bean3037 setAutoScalingGroupName (clojure.core/str v3039)))
   (clojure.core/when-let
    [v3039 (:launch-configuration-name m3038)]
    (. bean3037 setLaunchConfigurationName (clojure.core/str v3039)))
   (clojure.core/when-let
    [v3039 (:min-size m3038)]
    (. bean3037 setMinSize (clojure.core/int v3039)))
   (clojure.core/when-let
    [v3039 (:max-size m3038)]
    (. bean3037 setMaxSize (clojure.core/int v3039)))
   (clojure.core/when-let
    [v3039 (:default-cooldown m3038)]
    (. bean3037 setDefaultCooldown (clojure.core/int v3039)))
   (clojure.core/when-let
    [v3039 (:availability-zones m3038)]
    (.
     bean3037
     setAvailabilityZones
     (clojure.core/map
      (clojure.core/fn [arg3043] (clojure.core/str arg3043))
      v3039)))
   (clojure.core/when-let
    [v3039 (:health-check-type m3038)]
    (. bean3037 setHealthCheckType (clojure.core/str v3039)))
   (clojure.core/when-let
    [v3039 (:health-check-grace-period m3038)]
    (. bean3037 setHealthCheckGracePeriod (clojure.core/int v3039)))
   (clojure.core/when-let
    [v3039 (:placement-group m3038)]
    (. bean3037 setPlacementGroup (clojure.core/str v3039)))
   (clojure.core/when-let
    [v3039 (:vpczone-identifier m3038)]
    (. bean3037 setVPCZoneIdentifier (clojure.core/str v3039)))
   (clojure.core/when-let
    [v3039 (:termination-policies m3038)]
    (.
     bean3037
     setTerminationPolicies
     (clojure.core/map
      (clojure.core/fn [arg3044] (clojure.core/str arg3044))
      v3039)))
   bean3037))
 (clojure.core/defn
  ^com.amazonaws.services.autoscaling.model.DeleteNotificationConfigurationRequest delete-notification-configuration-request
  [m3041]
  (clojure.core/let
   [bean3040
    (new
     com.amazonaws.services.autoscaling.model.DeleteNotificationConfigurationRequest)]
   (clojure.core/when-let
    [v3042 (:topic-arn m3041)]
    (. bean3040 setTopicARN (clojure.core/str v3042)))
   (clojure.core/when-let
    [v3042 (:auto-scaling-group-name m3041)]
    (. bean3040 setAutoScalingGroupName (clojure.core/str v3042)))
   bean3040))
 (clojure.core/defn
  ^com.amazonaws.services.autoscaling.model.TerminateInstanceInAutoScalingGroupRequest terminate-instance-in-auto-scaling-group-request
  [m3046]
  (clojure.core/let
   [bean3045
    (new
     com.amazonaws.services.autoscaling.model.TerminateInstanceInAutoScalingGroupRequest)]
   (clojure.core/when-let
    [v3047 (:instance-id m3046)]
    (. bean3045 setInstanceId (clojure.core/str v3047)))
   (clojure.core/when-let
    [v3047 (:should-decrement-desired-capacity m3046)]
    (.
     bean3045
     setShouldDecrementDesiredCapacity
     (clojure.core/boolean v3047)))
   bean3045))
 (clojure.core/defn
  ^com.amazonaws.services.autoscaling.model.DeleteAutoScalingGroupRequest delete-auto-scaling-group-request
  [m3049]
  (clojure.core/let
   [bean3048
    (new
     com.amazonaws.services.autoscaling.model.DeleteAutoScalingGroupRequest)]
   (clojure.core/when-let
    [v3050 (:auto-scaling-group-name m3049)]
    (. bean3048 setAutoScalingGroupName (clojure.core/str v3050)))
   (clojure.core/when-let
    [v3050 (:force-delete m3049)]
    (. bean3048 setForceDelete (clojure.core/boolean v3050)))
   bean3048))
 (clojure.core/defn
  ^com.amazonaws.services.autoscaling.model.CreateOrUpdateTagsRequest create-or-update-tags-request
  [m3052]
  (clojure.core/let
   [bean3051
    (new
     com.amazonaws.services.autoscaling.model.CreateOrUpdateTagsRequest)]
   (clojure.core/when-let
    [v3053 (:tags m3052)]
    (.
     bean3051
     setTags
     (clojure.core/map
      (clojure.core/fn [arg3054] (tag arg3054))
      v3053)))
   bean3051))
 (clojure.core/defmulti
  autoscaling
  (clojure.core/fn
   autoscaling
   [m__1641__auto__]
   (:fn m__1641__auto__)))
 (do
  (clojure.core/defmethod
   autoscaling
   :set-desired-capacity
   [m3055]
   (clojure.core/let
    [credentials3056 (:credentials m3055) args3057 (:args m3055)]
    (clojure.core/let
     [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3058
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3056)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3058
       setDesiredCapacity
       (set-desired-capacity-request (clojure.core/nth args3057 0)))))))
  (clojure.core/defn
   set-desired-capacity-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         honor-cooldown
                         desired-capacity
                         auto-scaling-group-name]}]]),
    :doc "Generate map for setDesiredCapacity"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :set-desired-capacity,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   set-desired-capacity
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         honor-cooldown
                         desired-capacity
                         auto-scaling-group-name]}]]),
    :doc "Call setDesiredCapacity"}
   [credentials3060 & args3061]
   (clojure.core/let
    [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3062
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3060)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3062
      setDesiredCapacity
      (set-desired-capacity-request (clojure.core/nth args3061 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :enable-metrics-collection
   [m3063]
   (clojure.core/let
    [credentials3064 (:credentials m3063) args3065 (:args m3063)]
    (clojure.core/let
     [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3066
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3064)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3066
       enableMetricsCollection
       (enable-metrics-collection-request
        (clojure.core/nth args3065 0)))))))
  (clojure.core/defn
   enable-metrics-collection-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         metrics
                         granularity
                         auto-scaling-group-name]}]]),
    :doc "Generate map for enableMetricsCollection"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :enable-metrics-collection,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   enable-metrics-collection
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         metrics
                         granularity
                         auto-scaling-group-name]}]]),
    :doc "Call enableMetricsCollection"}
   [credentials3068 & args3069]
   (clojure.core/let
    [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3070
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3068)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3070
      enableMetricsCollection
      (enable-metrics-collection-request
       (clojure.core/nth args3069 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :delete-policy
   [m3071]
   (clojure.core/let
    [credentials3072 (:credentials m3071) args3073 (:args m3071)]
    (clojure.core/let
     [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3074
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3072)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3074
       deletePolicy
       (delete-policy-request (clojure.core/nth args3073 0)))))))
  (clojure.core/defn
   delete-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         policy-name
                         auto-scaling-group-name]}]]),
    :doc "Generate map for deletePolicy"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :delete-policy,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   delete-policy
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         policy-name
                         auto-scaling-group-name]}]]),
    :doc "Call deletePolicy"}
   [credentials3076 & args3077]
   (clojure.core/let
    [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3078
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3076)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3078
      deletePolicy
      (delete-policy-request (clojure.core/nth args3077 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :set-instance-health
   [m3079]
   (clojure.core/let
    [credentials3080 (:credentials m3079) args3081 (:args m3079)]
    (clojure.core/let
     [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3082
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3080)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3082
       setInstanceHealth
       (set-instance-health-request (clojure.core/nth args3081 0)))))))
  (clojure.core/defn
   set-instance-health-map
   {:arglists (quote
               [[credentials
                 {:keys [should-respect-grace-period
                         request-metric-collector
                         instance-id
                         health-status]}]]),
    :doc "Generate map for setInstanceHealth"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :set-instance-health,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   set-instance-health
   {:arglists (quote
               [[credentials
                 {:keys [should-respect-grace-period
                         request-metric-collector
                         instance-id
                         health-status]}]]),
    :doc "Call setInstanceHealth"}
   [credentials3084 & args3085]
   (clojure.core/let
    [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3086
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3084)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3086
      setInstanceHealth
      (set-instance-health-request (clojure.core/nth args3085 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-launch-configurations
   [m3087]
   (clojure.core/let
    [credentials3088 (:credentials m3087) args3089 (:args m3087)]
    (clojure.core/let
     [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3090
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3088)]
     (clojure.core/case
      (clojure.core/count args3089)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3090
        describeLaunchConfigurations))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3090
        describeLaunchConfigurations
        (describe-launch-configurations-request
         (clojure.core/nth args3089 0))))))))
  (clojure.core/defn
   describe-launch-configurations-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [request-metric-collector
                         next-token
                         max-records
                         launch-configuration-names]}]]),
    :doc "Generate map for describeLaunchConfigurations, describeLaunchConfigurations"}
   ([credentials__1609__auto__]
    {:args [],
     :client :autoscaling,
     :fn :describe-launch-configurations,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :describe-launch-configurations,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-launch-configurations
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [request-metric-collector
                         next-token
                         max-records
                         launch-configuration-names]}]]),
    :doc "Call describeLaunchConfigurations, describeLaunchConfigurations"}
   [credentials3092 & args3093]
   (clojure.core/let
    [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3094
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3092)]
    (clojure.core/case
     (clojure.core/count args3093)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3094
       describeLaunchConfigurations))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3094
       describeLaunchConfigurations
       (describe-launch-configurations-request
        (clojure.core/nth args3093 0))))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :delete-tags
   [m3095]
   (clojure.core/let
    [credentials3096 (:credentials m3095) args3097 (:args m3095)]
    (clojure.core/let
     [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3098
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3096)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3098
       deleteTags
       (delete-tags-request (clojure.core/nth args3097 0)))))))
  (clojure.core/defn
   delete-tags-map
   {:arglists (quote
               [[credentials {:keys [tags request-metric-collector]}]]),
    :doc "Generate map for deleteTags"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :delete-tags,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   delete-tags
   {:arglists (quote
               [[credentials {:keys [tags request-metric-collector]}]]),
    :doc "Call deleteTags"}
   [credentials3100 & args3101]
   (clojure.core/let
    [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3102
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3100)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3102
      deleteTags
      (delete-tags-request (clojure.core/nth args3101 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-auto-scaling-instances
   [m3103]
   (clojure.core/let
    [credentials3104 (:credentials m3103) args3105 (:args m3103)]
    (clojure.core/let
     [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3106
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3104)]
     (clojure.core/case
      (clojure.core/count args3105)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3106
        describeAutoScalingInstances))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3106
        describeAutoScalingInstances
        (describe-auto-scaling-instances-request
         (clojure.core/nth args3105 0))))))))
  (clojure.core/defn
   describe-auto-scaling-instances-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [request-metric-collector
                         next-token
                         max-records
                         instance-ids]}]]),
    :doc "Generate map for describeAutoScalingInstances, describeAutoScalingInstances"}
   ([credentials__1609__auto__]
    {:args [],
     :client :autoscaling,
     :fn :describe-auto-scaling-instances,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :describe-auto-scaling-instances,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-auto-scaling-instances
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [request-metric-collector
                         next-token
                         max-records
                         instance-ids]}]]),
    :doc "Call describeAutoScalingInstances, describeAutoScalingInstances"}
   [credentials3108 & args3109]
   (clojure.core/let
    [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3110
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3108)]
    (clojure.core/case
     (clojure.core/count args3109)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3110
       describeAutoScalingInstances))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3110
       describeAutoScalingInstances
       (describe-auto-scaling-instances-request
        (clojure.core/nth args3109 0))))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-notification-configurations
   [m3111]
   (clojure.core/let
    [credentials3112 (:credentials m3111) args3113 (:args m3111)]
    (clojure.core/let
     [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3114
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3112)]
     (clojure.core/case
      (clojure.core/count args3113)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3114
        describeNotificationConfigurations))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3114
        describeNotificationConfigurations
        (describe-notification-configurations-request
         (clojure.core/nth args3113 0))))))))
  (clojure.core/defn
   describe-notification-configurations-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [request-metric-collector
                         next-token
                         max-records
                         auto-scaling-group-names]}]]),
    :doc "Generate map for describeNotificationConfigurations, describeNotificationConfigurations"}
   ([credentials__1609__auto__]
    {:args [],
     :client :autoscaling,
     :fn :describe-notification-configurations,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :describe-notification-configurations,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-notification-configurations
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [request-metric-collector
                         next-token
                         max-records
                         auto-scaling-group-names]}]]),
    :doc "Call describeNotificationConfigurations, describeNotificationConfigurations"}
   [credentials3116 & args3117]
   (clojure.core/let
    [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3118
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3116)]
    (clojure.core/case
     (clojure.core/count args3117)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3118
       describeNotificationConfigurations))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3118
       describeNotificationConfigurations
       (describe-notification-configurations-request
        (clojure.core/nth args3117 0))))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-auto-scaling-notification-types
   [m3119]
   (clojure.core/let
    [credentials3120 (:credentials m3119) args3121 (:args m3119)]
    (clojure.core/let
     [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3122
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3120)]
     (clojure.core/case
      (clojure.core/count args3121)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3122
        describeAutoScalingNotificationTypes
        (describe-auto-scaling-notification-types-request
         (clojure.core/nth args3121 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3122
        describeAutoScalingNotificationTypes))))))
  (clojure.core/defn
   describe-auto-scaling-notification-types-map
   {:arglists (quote
               [[credentials {:keys [request-metric-collector]}]
                [credentials]]),
    :doc "Generate map for describeAutoScalingNotificationTypes, describeAutoScalingNotificationTypes"}
   ([credentials__1609__auto__]
    {:args [],
     :client :autoscaling,
     :fn :describe-auto-scaling-notification-types,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :describe-auto-scaling-notification-types,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-auto-scaling-notification-types
   {:arglists (quote
               [[credentials {:keys [request-metric-collector]}]
                [credentials]]),
    :doc "Call describeAutoScalingNotificationTypes, describeAutoScalingNotificationTypes"}
   [credentials3124 & args3125]
   (clojure.core/let
    [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3126
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3124)]
    (clojure.core/case
     (clojure.core/count args3125)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3126
       describeAutoScalingNotificationTypes
       (describe-auto-scaling-notification-types-request
        (clojure.core/nth args3125 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3126
       describeAutoScalingNotificationTypes))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :put-notification-configuration
   [m3127]
   (clojure.core/let
    [credentials3128 (:credentials m3127) args3129 (:args m3127)]
    (clojure.core/let
     [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3130
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3128)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3130
       putNotificationConfiguration
       (put-notification-configuration-request
        (clojure.core/nth args3129 0)))))))
  (clojure.core/defn
   put-notification-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [topic-arn
                         request-metric-collector
                         notification-types
                         auto-scaling-group-name]}]]),
    :doc "Generate map for putNotificationConfiguration"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :put-notification-configuration,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   put-notification-configuration
   {:arglists (quote
               [[credentials
                 {:keys [topic-arn
                         request-metric-collector
                         notification-types
                         auto-scaling-group-name]}]]),
    :doc "Call putNotificationConfiguration"}
   [credentials3132 & args3133]
   (clojure.core/let
    [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3134
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3132)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3134
      putNotificationConfiguration
      (put-notification-configuration-request
       (clojure.core/nth args3133 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-policies
   [m3135]
   (clojure.core/let
    [credentials3136 (:credentials m3135) args3137 (:args m3135)]
    (clojure.core/let
     [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3138
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3136)]
     (clojure.core/case
      (clojure.core/count args3137)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3138
        describePolicies))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3138
        describePolicies
        (describe-policies-request (clojure.core/nth args3137 0))))))))
  (clojure.core/defn
   describe-policies-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [request-metric-collector
                         policy-names
                         next-token
                         max-records
                         auto-scaling-group-name]}]]),
    :doc "Generate map for describePolicies, describePolicies"}
   ([credentials__1609__auto__]
    {:args [],
     :client :autoscaling,
     :fn :describe-policies,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :describe-policies,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-policies
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [request-metric-collector
                         policy-names
                         next-token
                         max-records
                         auto-scaling-group-name]}]]),
    :doc "Call describePolicies, describePolicies"}
   [credentials3140 & args3141]
   (clojure.core/let
    [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3142
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3140)]
    (clojure.core/case
     (clojure.core/count args3141)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3142
       describePolicies))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3142
       describePolicies
       (describe-policies-request (clojure.core/nth args3141 0))))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :suspend-processes
   [m3143]
   (clojure.core/let
    [credentials3144 (:credentials m3143) args3145 (:args m3143)]
    (clojure.core/let
     [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3146
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3144)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3146
       suspendProcesses
       (suspend-processes-request (clojure.core/nth args3145 0)))))))
  (clojure.core/defn
   suspend-processes-map
   {:arglists (quote
               [[credentials
                 {:keys [scaling-processes
                         request-metric-collector
                         auto-scaling-group-name]}]]),
    :doc "Generate map for suspendProcesses"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :suspend-processes,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   suspend-processes
   {:arglists (quote
               [[credentials
                 {:keys [scaling-processes
                         request-metric-collector
                         auto-scaling-group-name]}]]),
    :doc "Call suspendProcesses"}
   [credentials3148 & args3149]
   (clojure.core/let
    [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3150
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3148)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3150
      suspendProcesses
      (suspend-processes-request (clojure.core/nth args3149 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :create-auto-scaling-group
   [m3151]
   (clojure.core/let
    [credentials3152 (:credentials m3151) args3153 (:args m3151)]
    (clojure.core/let
     [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3154
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3152)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3154
       createAutoScalingGroup
       (create-auto-scaling-group-request
        (clojure.core/nth args3153 0)))))))
  (clojure.core/defn
   create-auto-scaling-group-map
   {:arglists (quote
               [[credentials
                 {:keys [load-balancer-names
                         health-check-grace-period
                         placement-group
                         request-metric-collector
                         launch-configuration-name
                         termination-policies
                         vpczone-identifier
                         desired-capacity
                         availability-zones
                         min-size
                         default-cooldown
                         max-size
                         health-check-type
                         auto-scaling-group-name
                         tags]}]]),
    :doc "Generate map for createAutoScalingGroup"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :create-auto-scaling-group,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   create-auto-scaling-group
   {:arglists (quote
               [[credentials
                 {:keys [load-balancer-names
                         health-check-grace-period
                         placement-group
                         request-metric-collector
                         launch-configuration-name
                         termination-policies
                         vpczone-identifier
                         desired-capacity
                         availability-zones
                         min-size
                         default-cooldown
                         max-size
                         health-check-type
                         auto-scaling-group-name
                         tags]}]]),
    :doc "Call createAutoScalingGroup"}
   [credentials3156 & args3157]
   (clojure.core/let
    [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3158
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3156)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3158
      createAutoScalingGroup
      (create-auto-scaling-group-request
       (clojure.core/nth args3157 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-auto-scaling-groups
   [m3159]
   (clojure.core/let
    [credentials3160 (:credentials m3159) args3161 (:args m3159)]
    (clojure.core/let
     [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3162
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3160)]
     (clojure.core/case
      (clojure.core/count args3161)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3162
        describeAutoScalingGroups
        (describe-auto-scaling-groups-request
         (clojure.core/nth args3161 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3162
        describeAutoScalingGroups))))))
  (clojure.core/defn
   describe-auto-scaling-groups-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         next-token
                         max-records
                         auto-scaling-group-names]}]
                [credentials]]),
    :doc "Generate map for describeAutoScalingGroups, describeAutoScalingGroups"}
   ([credentials__1609__auto__]
    {:args [],
     :client :autoscaling,
     :fn :describe-auto-scaling-groups,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :describe-auto-scaling-groups,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-auto-scaling-groups
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         next-token
                         max-records
                         auto-scaling-group-names]}]
                [credentials]]),
    :doc "Call describeAutoScalingGroups, describeAutoScalingGroups"}
   [credentials3164 & args3165]
   (clojure.core/let
    [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3166
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3164)]
    (clojure.core/case
     (clojure.core/count args3165)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3166
       describeAutoScalingGroups
       (describe-auto-scaling-groups-request
        (clojure.core/nth args3165 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3166
       describeAutoScalingGroups))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :put-scaling-policy
   [m3167]
   (clojure.core/let
    [credentials3168 (:credentials m3167) args3169 (:args m3167)]
    (clojure.core/let
     [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3170
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3168)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3170
       putScalingPolicy
       (put-scaling-policy-request (clojure.core/nth args3169 0)))))))
  (clojure.core/defn
   put-scaling-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [min-adjustment-step
                         scaling-adjustment
                         cooldown
                         auto-scaling-group-name
                         policy-name
                         adjustment-type
                         request-metric-collector]}]]),
    :doc "Generate map for putScalingPolicy"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :put-scaling-policy,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   put-scaling-policy
   {:arglists (quote
               [[credentials
                 {:keys [min-adjustment-step
                         scaling-adjustment
                         cooldown
                         auto-scaling-group-name
                         policy-name
                         adjustment-type
                         request-metric-collector]}]]),
    :doc "Call putScalingPolicy"}
   [credentials3172 & args3173]
   (clojure.core/let
    [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3174
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3172)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3174
      putScalingPolicy
      (put-scaling-policy-request (clojure.core/nth args3173 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :execute-policy
   [m3175]
   (clojure.core/let
    [credentials3176 (:credentials m3175) args3177 (:args m3175)]
    (clojure.core/let
     [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3178
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3176)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3178
       executePolicy
       (execute-policy-request (clojure.core/nth args3177 0)))))))
  (clojure.core/defn
   execute-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         policy-name
                         honor-cooldown
                         auto-scaling-group-name]}]]),
    :doc "Generate map for executePolicy"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :execute-policy,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   execute-policy
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         policy-name
                         honor-cooldown
                         auto-scaling-group-name]}]]),
    :doc "Call executePolicy"}
   [credentials3180 & args3181]
   (clojure.core/let
    [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3182
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3180)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3182
      executePolicy
      (execute-policy-request (clojure.core/nth args3181 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :create-launch-configuration
   [m3183]
   (clojure.core/let
    [credentials3184 (:credentials m3183) args3185 (:args m3183)]
    (clojure.core/let
     [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3186
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3184)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3186
       createLaunchConfiguration
       (create-launch-configuration-request
        (clojure.core/nth args3185 0)))))))
  (clojure.core/defn
   create-launch-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [instance-type
                         kernel-id
                         associate-public-ip-address
                         request-metric-collector
                         launch-configuration-name
                         ebs-optimized
                         block-device-mappings
                         spot-price
                         user-data
                         security-groups
                         ramdisk-id
                         instance-monitoring
                         iam-instance-profile
                         key-name
                         image-id]}]]),
    :doc "Generate map for createLaunchConfiguration"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :create-launch-configuration,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   create-launch-configuration
   {:arglists (quote
               [[credentials
                 {:keys [instance-type
                         kernel-id
                         associate-public-ip-address
                         request-metric-collector
                         launch-configuration-name
                         ebs-optimized
                         block-device-mappings
                         spot-price
                         user-data
                         security-groups
                         ramdisk-id
                         instance-monitoring
                         iam-instance-profile
                         key-name
                         image-id]}]]),
    :doc "Call createLaunchConfiguration"}
   [credentials3188 & args3189]
   (clojure.core/let
    [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3190
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3188)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3190
      createLaunchConfiguration
      (create-launch-configuration-request
       (clojure.core/nth args3189 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-termination-policy-types
   [m3191]
   (clojure.core/let
    [credentials3192 (:credentials m3191) args3193 (:args m3191)]
    (clojure.core/let
     [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3194
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3192)]
     (clojure.core/case
      (clojure.core/count args3193)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3194
        describeTerminationPolicyTypes
        (describe-termination-policy-types-request
         (clojure.core/nth args3193 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3194
        describeTerminationPolicyTypes))))))
  (clojure.core/defn
   describe-termination-policy-types-map
   {:arglists (quote
               [[credentials {:keys [request-metric-collector]}]
                [credentials]]),
    :doc "Generate map for describeTerminationPolicyTypes, describeTerminationPolicyTypes"}
   ([credentials__1609__auto__]
    {:args [],
     :client :autoscaling,
     :fn :describe-termination-policy-types,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :describe-termination-policy-types,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-termination-policy-types
   {:arglists (quote
               [[credentials {:keys [request-metric-collector]}]
                [credentials]]),
    :doc "Call describeTerminationPolicyTypes, describeTerminationPolicyTypes"}
   [credentials3196 & args3197]
   (clojure.core/let
    [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3198
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3196)]
    (clojure.core/case
     (clojure.core/count args3197)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3198
       describeTerminationPolicyTypes
       (describe-termination-policy-types-request
        (clojure.core/nth args3197 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3198
       describeTerminationPolicyTypes))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-scaling-activities
   [m3199]
   (clojure.core/let
    [credentials3200 (:credentials m3199) args3201 (:args m3199)]
    (clojure.core/let
     [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3202
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3200)]
     (clojure.core/case
      (clojure.core/count args3201)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3202
        describeScalingActivities))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3202
        describeScalingActivities
        (describe-scaling-activities-request
         (clojure.core/nth args3201 0))))))))
  (clojure.core/defn
   describe-scaling-activities-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [request-metric-collector
                         next-token
                         max-records
                         auto-scaling-group-name
                         activity-ids]}]]),
    :doc "Generate map for describeScalingActivities, describeScalingActivities"}
   ([credentials__1609__auto__]
    {:args [],
     :client :autoscaling,
     :fn :describe-scaling-activities,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :describe-scaling-activities,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-scaling-activities
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [request-metric-collector
                         next-token
                         max-records
                         auto-scaling-group-name
                         activity-ids]}]]),
    :doc "Call describeScalingActivities, describeScalingActivities"}
   [credentials3204 & args3205]
   (clojure.core/let
    [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3206
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3204)]
    (clojure.core/case
     (clojure.core/count args3205)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3206
       describeScalingActivities))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3206
       describeScalingActivities
       (describe-scaling-activities-request
        (clojure.core/nth args3205 0))))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-scheduled-actions
   [m3207]
   (clojure.core/let
    [credentials3208 (:credentials m3207) args3209 (:args m3207)]
    (clojure.core/let
     [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3210
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3208)]
     (clojure.core/case
      (clojure.core/count args3209)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3210
        describeScheduledActions
        (describe-scheduled-actions-request
         (clojure.core/nth args3209 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3210
        describeScheduledActions))))))
  (clojure.core/defn
   describe-scheduled-actions-map
   {:arglists (quote
               [[credentials
                 {:keys [start-time
                         end-time
                         auto-scaling-group-name
                         max-records
                         scheduled-action-names
                         next-token
                         request-metric-collector]}]
                [credentials]]),
    :doc "Generate map for describeScheduledActions, describeScheduledActions"}
   ([credentials__1609__auto__]
    {:args [],
     :client :autoscaling,
     :fn :describe-scheduled-actions,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :describe-scheduled-actions,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-scheduled-actions
   {:arglists (quote
               [[credentials
                 {:keys [start-time
                         end-time
                         auto-scaling-group-name
                         max-records
                         scheduled-action-names
                         next-token
                         request-metric-collector]}]
                [credentials]]),
    :doc "Call describeScheduledActions, describeScheduledActions"}
   [credentials3212 & args3213]
   (clojure.core/let
    [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3214
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3212)]
    (clojure.core/case
     (clojure.core/count args3213)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3214
       describeScheduledActions
       (describe-scheduled-actions-request
        (clojure.core/nth args3213 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3214
       describeScheduledActions))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-adjustment-types
   [m3215]
   (clojure.core/let
    [credentials3216 (:credentials m3215) args3217 (:args m3215)]
    (clojure.core/let
     [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3218
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3216)]
     (clojure.core/case
      (clojure.core/count args3217)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3218
        describeAdjustmentTypes
        (describe-adjustment-types-request
         (clojure.core/nth args3217 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3218
        describeAdjustmentTypes))))))
  (clojure.core/defn
   describe-adjustment-types-map
   {:arglists (quote
               [[credentials {:keys [request-metric-collector]}]
                [credentials]]),
    :doc "Generate map for describeAdjustmentTypes, describeAdjustmentTypes"}
   ([credentials__1609__auto__]
    {:args [],
     :client :autoscaling,
     :fn :describe-adjustment-types,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :describe-adjustment-types,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-adjustment-types
   {:arglists (quote
               [[credentials {:keys [request-metric-collector]}]
                [credentials]]),
    :doc "Call describeAdjustmentTypes, describeAdjustmentTypes"}
   [credentials3220 & args3221]
   (clojure.core/let
    [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3222
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3220)]
    (clojure.core/case
     (clojure.core/count args3221)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3222
       describeAdjustmentTypes
       (describe-adjustment-types-request
        (clojure.core/nth args3221 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3222
       describeAdjustmentTypes))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-tags
   [m3223]
   (clojure.core/let
    [credentials3224 (:credentials m3223) args3225 (:args m3223)]
    (clojure.core/let
     [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3226
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3224)]
     (clojure.core/case
      (clojure.core/count args3225)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3226
        describeTags
        (describe-tags-request (clojure.core/nth args3225 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3226
        describeTags))))))
  (clojure.core/defn
   describe-tags-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         next-token
                         max-records
                         filters]}]
                [credentials]]),
    :doc "Generate map for describeTags, describeTags"}
   ([credentials__1609__auto__]
    {:args [],
     :client :autoscaling,
     :fn :describe-tags,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :describe-tags,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-tags
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         next-token
                         max-records
                         filters]}]
                [credentials]]),
    :doc "Call describeTags, describeTags"}
   [credentials3228 & args3229]
   (clojure.core/let
    [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3230
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3228)]
    (clojure.core/case
     (clojure.core/count args3229)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3230
       describeTags
       (describe-tags-request (clojure.core/nth args3229 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3230
       describeTags))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :resume-processes
   [m3231]
   (clojure.core/let
    [credentials3232 (:credentials m3231) args3233 (:args m3231)]
    (clojure.core/let
     [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3234
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3232)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3234
       resumeProcesses
       (resume-processes-request (clojure.core/nth args3233 0)))))))
  (clojure.core/defn
   resume-processes-map
   {:arglists (quote
               [[credentials
                 {:keys [scaling-processes
                         request-metric-collector
                         auto-scaling-group-name]}]]),
    :doc "Generate map for resumeProcesses"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :resume-processes,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   resume-processes
   {:arglists (quote
               [[credentials
                 {:keys [scaling-processes
                         request-metric-collector
                         auto-scaling-group-name]}]]),
    :doc "Call resumeProcesses"}
   [credentials3236 & args3237]
   (clojure.core/let
    [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3238
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3236)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3238
      resumeProcesses
      (resume-processes-request (clojure.core/nth args3237 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :delete-launch-configuration
   [m3239]
   (clojure.core/let
    [credentials3240 (:credentials m3239) args3241 (:args m3239)]
    (clojure.core/let
     [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3242
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3240)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3242
       deleteLaunchConfiguration
       (delete-launch-configuration-request
        (clojure.core/nth args3241 0)))))))
  (clojure.core/defn
   delete-launch-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         launch-configuration-name]}]]),
    :doc "Generate map for deleteLaunchConfiguration"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :delete-launch-configuration,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   delete-launch-configuration
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         launch-configuration-name]}]]),
    :doc "Call deleteLaunchConfiguration"}
   [credentials3244 & args3245]
   (clojure.core/let
    [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3246
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3244)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3246
      deleteLaunchConfiguration
      (delete-launch-configuration-request
       (clojure.core/nth args3245 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :disable-metrics-collection
   [m3247]
   (clojure.core/let
    [credentials3248 (:credentials m3247) args3249 (:args m3247)]
    (clojure.core/let
     [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3250
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3248)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3250
       disableMetricsCollection
       (disable-metrics-collection-request
        (clojure.core/nth args3249 0)))))))
  (clojure.core/defn
   disable-metrics-collection-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         metrics
                         auto-scaling-group-name]}]]),
    :doc "Generate map for disableMetricsCollection"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :disable-metrics-collection,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   disable-metrics-collection
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         metrics
                         auto-scaling-group-name]}]]),
    :doc "Call disableMetricsCollection"}
   [credentials3252 & args3253]
   (clojure.core/let
    [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3254
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3252)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3254
      disableMetricsCollection
      (disable-metrics-collection-request
       (clojure.core/nth args3253 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :put-scheduled-update-group-action
   [m3255]
   (clojure.core/let
    [credentials3256 (:credentials m3255) args3257 (:args m3255)]
    (clojure.core/let
     [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3258
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3256)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3258
       putScheduledUpdateGroupAction
       (put-scheduled-update-group-action-request
        (clojure.core/nth args3257 0)))))))
  (clojure.core/defn
   put-scheduled-update-group-action-map
   {:arglists (quote
               [[credentials
                 {:keys [end-time
                         request-metric-collector
                         desired-capacity
                         recurrence
                         start-time
                         min-size
                         time
                         max-size
                         scheduled-action-name
                         auto-scaling-group-name]}]]),
    :doc "Generate map for putScheduledUpdateGroupAction"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :put-scheduled-update-group-action,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   put-scheduled-update-group-action
   {:arglists (quote
               [[credentials
                 {:keys [end-time
                         request-metric-collector
                         desired-capacity
                         recurrence
                         start-time
                         min-size
                         time
                         max-size
                         scheduled-action-name
                         auto-scaling-group-name]}]]),
    :doc "Call putScheduledUpdateGroupAction"}
   [credentials3260 & args3261]
   (clojure.core/let
    [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3262
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3260)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3262
      putScheduledUpdateGroupAction
      (put-scheduled-update-group-action-request
       (clojure.core/nth args3261 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-scaling-process-types
   [m3263]
   (clojure.core/let
    [credentials3264 (:credentials m3263) args3265 (:args m3263)]
    (clojure.core/let
     [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3266
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3264)]
     (clojure.core/case
      (clojure.core/count args3265)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3266
        describeScalingProcessTypes))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3266
        describeScalingProcessTypes
        (describe-scaling-process-types-request
         (clojure.core/nth args3265 0))))))))
  (clojure.core/defn
   describe-scaling-process-types-map
   {:arglists (quote
               [[credentials]
                [credentials {:keys [request-metric-collector]}]]),
    :doc "Generate map for describeScalingProcessTypes, describeScalingProcessTypes"}
   ([credentials__1609__auto__]
    {:args [],
     :client :autoscaling,
     :fn :describe-scaling-process-types,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :describe-scaling-process-types,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-scaling-process-types
   {:arglists (quote
               [[credentials]
                [credentials {:keys [request-metric-collector]}]]),
    :doc "Call describeScalingProcessTypes, describeScalingProcessTypes"}
   [credentials3268 & args3269]
   (clojure.core/let
    [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3270
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3268)]
    (clojure.core/case
     (clojure.core/count args3269)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3270
       describeScalingProcessTypes))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3270
       describeScalingProcessTypes
       (describe-scaling-process-types-request
        (clojure.core/nth args3269 0))))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-metric-collection-types
   [m3271]
   (clojure.core/let
    [credentials3272 (:credentials m3271) args3273 (:args m3271)]
    (clojure.core/let
     [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3274
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3272)]
     (clojure.core/case
      (clojure.core/count args3273)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3274
        describeMetricCollectionTypes))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3274
        describeMetricCollectionTypes
        (describe-metric-collection-types-request
         (clojure.core/nth args3273 0))))))))
  (clojure.core/defn
   describe-metric-collection-types-map
   {:arglists (quote
               [[credentials]
                [credentials {:keys [request-metric-collector]}]]),
    :doc "Generate map for describeMetricCollectionTypes, describeMetricCollectionTypes"}
   ([credentials__1609__auto__]
    {:args [],
     :client :autoscaling,
     :fn :describe-metric-collection-types,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :describe-metric-collection-types,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-metric-collection-types
   {:arglists (quote
               [[credentials]
                [credentials {:keys [request-metric-collector]}]]),
    :doc "Call describeMetricCollectionTypes, describeMetricCollectionTypes"}
   [credentials3276 & args3277]
   (clojure.core/let
    [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3278
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3276)]
    (clojure.core/case
     (clojure.core/count args3277)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3278
       describeMetricCollectionTypes))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3278
       describeMetricCollectionTypes
       (describe-metric-collection-types-request
        (clojure.core/nth args3277 0))))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :delete-scheduled-action
   [m3279]
   (clojure.core/let
    [credentials3280 (:credentials m3279) args3281 (:args m3279)]
    (clojure.core/let
     [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3282
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3280)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3282
       deleteScheduledAction
       (delete-scheduled-action-request (clojure.core/nth args3281 0)))))))
  (clojure.core/defn
   delete-scheduled-action-map
   {:arglists (quote
               [[credentials
                 {:keys [scheduled-action-name
                         request-metric-collector
                         auto-scaling-group-name]}]]),
    :doc "Generate map for deleteScheduledAction"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :delete-scheduled-action,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   delete-scheduled-action
   {:arglists (quote
               [[credentials
                 {:keys [scheduled-action-name
                         request-metric-collector
                         auto-scaling-group-name]}]]),
    :doc "Call deleteScheduledAction"}
   [credentials3284 & args3285]
   (clojure.core/let
    [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3286
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3284)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3286
      deleteScheduledAction
      (delete-scheduled-action-request (clojure.core/nth args3285 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :update-auto-scaling-group
   [m3287]
   (clojure.core/let
    [credentials3288 (:credentials m3287) args3289 (:args m3287)]
    (clojure.core/let
     [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3290
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3288)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3290
       updateAutoScalingGroup
       (update-auto-scaling-group-request
        (clojure.core/nth args3289 0)))))))
  (clojure.core/defn
   update-auto-scaling-group-map
   {:arglists (quote
               [[credentials
                 {:keys [health-check-grace-period
                         placement-group
                         request-metric-collector
                         launch-configuration-name
                         termination-policies
                         vpczone-identifier
                         desired-capacity
                         availability-zones
                         min-size
                         default-cooldown
                         max-size
                         health-check-type
                         auto-scaling-group-name]}]]),
    :doc "Generate map for updateAutoScalingGroup"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :update-auto-scaling-group,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   update-auto-scaling-group
   {:arglists (quote
               [[credentials
                 {:keys [health-check-grace-period
                         placement-group
                         request-metric-collector
                         launch-configuration-name
                         termination-policies
                         vpczone-identifier
                         desired-capacity
                         availability-zones
                         min-size
                         default-cooldown
                         max-size
                         health-check-type
                         auto-scaling-group-name]}]]),
    :doc "Call updateAutoScalingGroup"}
   [credentials3292 & args3293]
   (clojure.core/let
    [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3294
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3292)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3294
      updateAutoScalingGroup
      (update-auto-scaling-group-request
       (clojure.core/nth args3293 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :delete-notification-configuration
   [m3295]
   (clojure.core/let
    [credentials3296 (:credentials m3295) args3297 (:args m3295)]
    (clojure.core/let
     [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3298
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3296)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3298
       deleteNotificationConfiguration
       (delete-notification-configuration-request
        (clojure.core/nth args3297 0)))))))
  (clojure.core/defn
   delete-notification-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [topic-arn
                         request-metric-collector
                         auto-scaling-group-name]}]]),
    :doc "Generate map for deleteNotificationConfiguration"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :delete-notification-configuration,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   delete-notification-configuration
   {:arglists (quote
               [[credentials
                 {:keys [topic-arn
                         request-metric-collector
                         auto-scaling-group-name]}]]),
    :doc "Call deleteNotificationConfiguration"}
   [credentials3300 & args3301]
   (clojure.core/let
    [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3302
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3300)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3302
      deleteNotificationConfiguration
      (delete-notification-configuration-request
       (clojure.core/nth args3301 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :terminate-instance-in-auto-scaling-group
   [m3303]
   (clojure.core/let
    [credentials3304 (:credentials m3303) args3305 (:args m3303)]
    (clojure.core/let
     [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3306
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3304)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3306
       terminateInstanceInAutoScalingGroup
       (terminate-instance-in-auto-scaling-group-request
        (clojure.core/nth args3305 0)))))))
  (clojure.core/defn
   terminate-instance-in-auto-scaling-group-map
   {:arglists (quote
               [[credentials
                 {:keys [should-decrement-desired-capacity
                         request-metric-collector
                         instance-id]}]]),
    :doc "Generate map for terminateInstanceInAutoScalingGroup"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :terminate-instance-in-auto-scaling-group,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   terminate-instance-in-auto-scaling-group
   {:arglists (quote
               [[credentials
                 {:keys [should-decrement-desired-capacity
                         request-metric-collector
                         instance-id]}]]),
    :doc "Call terminateInstanceInAutoScalingGroup"}
   [credentials3308 & args3309]
   (clojure.core/let
    [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3310
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3308)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3310
      terminateInstanceInAutoScalingGroup
      (terminate-instance-in-auto-scaling-group-request
       (clojure.core/nth args3309 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :delete-auto-scaling-group
   [m3311]
   (clojure.core/let
    [credentials3312 (:credentials m3311) args3313 (:args m3311)]
    (clojure.core/let
     [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3314
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3312)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3314
       deleteAutoScalingGroup
       (delete-auto-scaling-group-request
        (clojure.core/nth args3313 0)))))))
  (clojure.core/defn
   delete-auto-scaling-group-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         force-delete
                         auto-scaling-group-name]}]]),
    :doc "Generate map for deleteAutoScalingGroup"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :delete-auto-scaling-group,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   delete-auto-scaling-group
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         force-delete
                         auto-scaling-group-name]}]]),
    :doc "Call deleteAutoScalingGroup"}
   [credentials3316 & args3317]
   (clojure.core/let
    [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3318
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3316)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3318
      deleteAutoScalingGroup
      (delete-auto-scaling-group-request
       (clojure.core/nth args3317 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :create-or-update-tags
   [m3319]
   (clojure.core/let
    [credentials3320 (:credentials m3319) args3321 (:args m3319)]
    (clojure.core/let
     [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3322
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3320)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3322
       createOrUpdateTags
       (create-or-update-tags-request (clojure.core/nth args3321 0)))))))
  (clojure.core/defn
   create-or-update-tags-map
   {:arglists (quote
               [[credentials {:keys [tags request-metric-collector]}]]),
    :doc "Generate map for createOrUpdateTags"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :create-or-update-tags,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   create-or-update-tags
   {:arglists (quote
               [[credentials {:keys [tags request-metric-collector]}]]),
    :doc "Call createOrUpdateTags"}
   [credentials3324 & args3325]
   (clojure.core/let
    [^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3326
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3324)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.autoscaling.AmazonAutoScalingClient client3326
      createOrUpdateTags
      (create-or-update-tags-request (clojure.core/nth args3325 0))))))))
