(ns
 com.palletops.awaze.cloudformation
 (:require [com.palletops.awaze.common]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :cloudformation
  [___1561__auto__
   ^com.amazonaws.auth.BasicAWSCredentials credentials__1562__auto__]
  (new
   com.amazonaws.services.cloudformation.AmazonCloudFormationClient
   credentials__1562__auto__))
 (clojure.core/defn
  ^com.amazonaws.services.cloudformation.model.Parameter parameter
  [m7991]
  (clojure.core/let
   [bean7990
    (new com.amazonaws.services.cloudformation.model.Parameter)]
   (clojure.core/when-let
    [v7992 (:parameter-value m7991)]
    (. bean7990 setParameterValue (clojure.core/str v7992)))
   (clojure.core/when-let
    [v7992 (:parameter-key m7991)]
    (. bean7990 setParameterKey (clojure.core/str v7992)))
   bean7990))
 (clojure.core/defn
  ^com.amazonaws.services.cloudformation.model.Tag tag
  [m7994]
  (clojure.core/let
   [bean7993 (new com.amazonaws.services.cloudformation.model.Tag)]
   (clojure.core/when-let
    [v7995 (:value m7994)]
    (. bean7993 setValue (clojure.core/str v7995)))
   (clojure.core/when-let
    [v7995 (:key m7994)]
    (. bean7993 setKey (clojure.core/str v7995)))
   bean7993))
 (clojure.core/defn
  ^com.amazonaws.services.cloudformation.model.OnFailure on-failure
  [m7997]
  (java.lang.Enum/valueOf
   com.amazonaws.services.cloudformation.model.OnFailure
   (clojure.core/name m7997)))
 (clojure.core/defn
  ^com.amazonaws.services.cloudformation.model.DescribeStackEventsRequest describe-stack-events-request
  [m8000]
  (clojure.core/let
   [bean7999
    (new
     com.amazonaws.services.cloudformation.model.DescribeStackEventsRequest)]
   (clojure.core/when-let
    [v8001 (:next-token m8000)]
    (. bean7999 setNextToken (clojure.core/str v8001)))
   (clojure.core/when-let
    [v8001 (:stack-name m8000)]
    (. bean7999 setStackName (clojure.core/str v8001)))
   bean7999))
 (clojure.core/defn
  ^com.amazonaws.services.cloudformation.model.DescribeStacksRequest describe-stacks-request
  [m8003]
  (clojure.core/let
   [bean8002
    (new
     com.amazonaws.services.cloudformation.model.DescribeStacksRequest)]
   (clojure.core/when-let
    [v8004 (:next-token m8003)]
    (. bean8002 setNextToken (clojure.core/str v8004)))
   (clojure.core/when-let
    [v8004 (:stack-name m8003)]
    (. bean8002 setStackName (clojure.core/str v8004)))
   bean8002))
 (clojure.core/defn
  ^com.amazonaws.services.cloudformation.model.GetTemplateRequest get-template-request
  [m8006]
  (clojure.core/let
   [bean8005
    (new
     com.amazonaws.services.cloudformation.model.GetTemplateRequest)]
   (clojure.core/when-let
    [v8007 (:stack-name m8006)]
    (. bean8005 setStackName (clojure.core/str v8007)))
   bean8005))
 (clojure.core/defn
  ^com.amazonaws.services.cloudformation.model.ListStacksRequest list-stacks-request
  [m8009]
  (clojure.core/let
   [bean8008
    (new
     com.amazonaws.services.cloudformation.model.ListStacksRequest)]
   (clojure.core/when-let
    [v8010 (:next-token m8009)]
    (. bean8008 setNextToken (clojure.core/str v8010)))
   (clojure.core/when-let
    [v8010 (:stack-status-filters m8009)]
    (.
     bean8008
     setStackStatusFilters
     (clojure.core/map
      (clojure.core/fn [arg8014] (clojure.core/str arg8014))
      v8010)))
   bean8008))
 (clojure.core/defn
  ^com.amazonaws.services.cloudformation.model.DeleteStackRequest delete-stack-request
  [m8012]
  (clojure.core/let
   [bean8011
    (new
     com.amazonaws.services.cloudformation.model.DeleteStackRequest)]
   (clojure.core/when-let
    [v8013 (:stack-name m8012)]
    (. bean8011 setStackName (clojure.core/str v8013)))
   bean8011))
 (clojure.core/defn
  ^com.amazonaws.services.cloudformation.model.EstimateTemplateCostRequest estimate-template-cost-request
  [m8016]
  (clojure.core/let
   [bean8015
    (new
     com.amazonaws.services.cloudformation.model.EstimateTemplateCostRequest)]
   (clojure.core/when-let
    [v8017 (:parameters m8016)]
    (.
     bean8015
     setParameters
     (clojure.core/map
      (clojure.core/fn [arg8021] (parameter arg8021))
      v8017)))
   (clojure.core/when-let
    [v8017 (:template-body m8016)]
    (. bean8015 setTemplateBody (clojure.core/str v8017)))
   (clojure.core/when-let
    [v8017 (:template-url m8016)]
    (. bean8015 setTemplateURL (clojure.core/str v8017)))
   bean8015))
 (clojure.core/defn
  ^com.amazonaws.services.cloudformation.model.ValidateTemplateRequest validate-template-request
  [m8019]
  (clojure.core/let
   [bean8018
    (new
     com.amazonaws.services.cloudformation.model.ValidateTemplateRequest)]
   (clojure.core/when-let
    [v8020 (:template-body m8019)]
    (. bean8018 setTemplateBody (clojure.core/str v8020)))
   (clojure.core/when-let
    [v8020 (:template-url m8019)]
    (. bean8018 setTemplateURL (clojure.core/str v8020)))
   bean8018))
 (clojure.core/defn
  ^com.amazonaws.services.cloudformation.model.UpdateStackRequest update-stack-request
  [m8023]
  (clojure.core/let
   [bean8022
    (new
     com.amazonaws.services.cloudformation.model.UpdateStackRequest)]
   (clojure.core/when-let
    [v8024 (:parameters m8023)]
    (.
     bean8022
     setParameters
     (clojure.core/map
      (clojure.core/fn [arg8028] (parameter arg8028))
      v8024)))
   (clojure.core/when-let
    [v8024 (:template-body m8023)]
    (. bean8022 setTemplateBody (clojure.core/str v8024)))
   (clojure.core/when-let
    [v8024 (:template-url m8023)]
    (. bean8022 setTemplateURL (clojure.core/str v8024)))
   (clojure.core/when-let
    [v8024 (:capabilities m8023)]
    (.
     bean8022
     setCapabilities
     (clojure.core/map
      (clojure.core/fn [arg8029] (clojure.core/str arg8029))
      v8024)))
   (clojure.core/when-let
    [v8024 (:stack-name m8023)]
    (. bean8022 setStackName (clojure.core/str v8024)))
   bean8022))
 (clojure.core/defn
  ^com.amazonaws.services.cloudformation.model.DescribeStackResourcesRequest describe-stack-resources-request
  [m8026]
  (clojure.core/let
   [bean8025
    (new
     com.amazonaws.services.cloudformation.model.DescribeStackResourcesRequest)]
   (clojure.core/when-let
    [v8027 (:stack-name m8026)]
    (. bean8025 setStackName (clojure.core/str v8027)))
   (clojure.core/when-let
    [v8027 (:logical-resource-id m8026)]
    (. bean8025 setLogicalResourceId (clojure.core/str v8027)))
   (clojure.core/when-let
    [v8027 (:physical-resource-id m8026)]
    (. bean8025 setPhysicalResourceId (clojure.core/str v8027)))
   bean8025))
 (clojure.core/defn
  ^com.amazonaws.services.cloudformation.model.CancelUpdateStackRequest cancel-update-stack-request
  [m8031]
  (clojure.core/let
   [bean8030
    (new
     com.amazonaws.services.cloudformation.model.CancelUpdateStackRequest)]
   (clojure.core/when-let
    [v8032 (:stack-name m8031)]
    (. bean8030 setStackName (clojure.core/str v8032)))
   bean8030))
 (clojure.core/defn
  ^com.amazonaws.services.cloudformation.model.CreateStackRequest create-stack-request
  [m8034]
  (clojure.core/let
   [bean8033
    (new
     com.amazonaws.services.cloudformation.model.CreateStackRequest)]
   (clojure.core/when-let
    [v8035 (:parameters m8034)]
    (.
     bean8033
     setParameters
     (clojure.core/map
      (clojure.core/fn [arg8039] (parameter arg8039))
      v8035)))
   (clojure.core/when-let
    [v8035 (:tags m8034)]
    (.
     bean8033
     setTags
     (clojure.core/map
      (clojure.core/fn [arg8040] (tag arg8040))
      v8035)))
   (clojure.core/when-let
    [v8035 (:template-body m8034)]
    (. bean8033 setTemplateBody (clojure.core/str v8035)))
   (clojure.core/when-let
    [v8035 (:template-url m8034)]
    (. bean8033 setTemplateURL (clojure.core/str v8035)))
   (clojure.core/when-let
    [v8035 (:capabilities m8034)]
    (.
     bean8033
     setCapabilities
     (clojure.core/map
      (clojure.core/fn [arg8041] (clojure.core/str arg8041))
      v8035)))
   (clojure.core/when-let
    [v8035 (:stack-name m8034)]
    (. bean8033 setStackName (clojure.core/str v8035)))
   (clojure.core/when-let
    [v8035 (:disable-rollback m8034)]
    (. bean8033 setDisableRollback (clojure.core/boolean v8035)))
   (clojure.core/when-let
    [v8035 (:timeout-in-minutes m8034)]
    (. bean8033 setTimeoutInMinutes (clojure.core/int v8035)))
   (clojure.core/when-let
    [v8035 (:notification-arns m8034)]
    (.
     bean8033
     setNotificationARNs
     (clojure.core/map
      (clojure.core/fn [arg8042] (clojure.core/str arg8042))
      v8035)))
   (clojure.core/when-let
    [v8035 (:on-failure m8034)]
    (. bean8033 setOnFailure (on-failure v8035)))
   (clojure.core/when-let
    [v8035 (:on-failure m8034)]
    (. bean8033 setOnFailure (clojure.core/str v8035)))
   bean8033))
 (clojure.core/defn
  ^com.amazonaws.services.cloudformation.model.DescribeStackResourceRequest describe-stack-resource-request
  [m8037]
  (clojure.core/let
   [bean8036
    (new
     com.amazonaws.services.cloudformation.model.DescribeStackResourceRequest)]
   (clojure.core/when-let
    [v8038 (:stack-name m8037)]
    (. bean8036 setStackName (clojure.core/str v8038)))
   (clojure.core/when-let
    [v8038 (:logical-resource-id m8037)]
    (. bean8036 setLogicalResourceId (clojure.core/str v8038)))
   bean8036))
 (clojure.core/defn
  ^com.amazonaws.services.cloudformation.model.ListStackResourcesRequest list-stack-resources-request
  [m8044]
  (clojure.core/let
   [bean8043
    (new
     com.amazonaws.services.cloudformation.model.ListStackResourcesRequest)]
   (clojure.core/when-let
    [v8045 (:next-token m8044)]
    (. bean8043 setNextToken (clojure.core/str v8045)))
   (clojure.core/when-let
    [v8045 (:stack-name m8044)]
    (. bean8043 setStackName (clojure.core/str v8045)))
   bean8043))
 (clojure.core/defmulti
  cloudformation
  (clojure.core/fn
   cloudformation
   [m__1641__auto__]
   (:fn m__1641__auto__)))
 (do
  (clojure.core/defmethod
   cloudformation
   :describe-stack-events
   [m8046]
   (clojure.core/let
    [credentials8047 (:credentials m8046) args8048 (:args m8046)]
    (clojure.core/let
     [^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client8049
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials8047)]
     (clojure.core/case
      (clojure.core/count args8048)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client8049
        describeStackEvents
        (describe-stack-events-request (clojure.core/nth args8048 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client8049
        describeStackEvents))))))
  (clojure.core/defn
   describe-stack-events-map
   {:arglists (quote
               [[credentials
                 {:keys [stack-name
                         request-metric-collector
                         next-token]}]
                [credentials]]),
    :doc "Generate map for describeStackEvents, describeStackEvents"}
   ([credentials__1609__auto__]
    {:args [],
     :client :cloudformation,
     :fn :describe-stack-events,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :cloudformation,
     :fn :describe-stack-events,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-stack-events
   {:arglists (quote
               [[credentials
                 {:keys [stack-name
                         request-metric-collector
                         next-token]}]
                [credentials]]),
    :doc "Call describeStackEvents, describeStackEvents"}
   [credentials8051 & args8052]
   (clojure.core/let
    [^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client8053
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials8051)]
    (clojure.core/case
     (clojure.core/count args8052)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client8053
       describeStackEvents
       (describe-stack-events-request (clojure.core/nth args8052 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client8053
       describeStackEvents))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :describe-stacks
   [m8054]
   (clojure.core/let
    [credentials8055 (:credentials m8054) args8056 (:args m8054)]
    (clojure.core/let
     [^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client8057
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials8055)]
     (clojure.core/case
      (clojure.core/count args8056)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client8057
        describeStacks))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client8057
        describeStacks
        (describe-stacks-request (clojure.core/nth args8056 0))))))))
  (clojure.core/defn
   describe-stacks-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [stack-name
                         request-metric-collector
                         next-token]}]]),
    :doc "Generate map for describeStacks, describeStacks"}
   ([credentials__1609__auto__]
    {:args [],
     :client :cloudformation,
     :fn :describe-stacks,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :cloudformation,
     :fn :describe-stacks,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-stacks
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [stack-name
                         request-metric-collector
                         next-token]}]]),
    :doc "Call describeStacks, describeStacks"}
   [credentials8059 & args8060]
   (clojure.core/let
    [^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client8061
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials8059)]
    (clojure.core/case
     (clojure.core/count args8060)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client8061
       describeStacks))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client8061
       describeStacks
       (describe-stacks-request (clojure.core/nth args8060 0))))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :get-template
   [m8062]
   (clojure.core/let
    [credentials8063 (:credentials m8062) args8064 (:args m8062)]
    (clojure.core/let
     [^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client8065
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials8063)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client8065
       getTemplate
       (get-template-request (clojure.core/nth args8064 0)))))))
  (clojure.core/defn
   get-template-map
   {:arglists (quote
               [[credentials
                 {:keys [stack-name request-metric-collector]}]]),
    :doc "Generate map for getTemplate"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :cloudformation,
     :fn :get-template,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   get-template
   {:arglists (quote
               [[credentials
                 {:keys [stack-name request-metric-collector]}]]),
    :doc "Call getTemplate"}
   [credentials8067 & args8068]
   (clojure.core/let
    [^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client8069
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials8067)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client8069
      getTemplate
      (get-template-request (clojure.core/nth args8068 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :list-stacks
   [m8070]
   (clojure.core/let
    [credentials8071 (:credentials m8070) args8072 (:args m8070)]
    (clojure.core/let
     [^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client8073
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials8071)]
     (clojure.core/case
      (clojure.core/count args8072)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client8073
        listStacks
        (list-stacks-request (clojure.core/nth args8072 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client8073
        listStacks))))))
  (clojure.core/defn
   list-stacks-map
   {:arglists (quote
               [[credentials
                 {:keys [stack-status-filters
                         request-metric-collector
                         next-token]}]
                [credentials]]),
    :doc "Generate map for listStacks, listStacks"}
   ([credentials__1609__auto__]
    {:args [],
     :client :cloudformation,
     :fn :list-stacks,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :cloudformation,
     :fn :list-stacks,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   list-stacks
   {:arglists (quote
               [[credentials
                 {:keys [stack-status-filters
                         request-metric-collector
                         next-token]}]
                [credentials]]),
    :doc "Call listStacks, listStacks"}
   [credentials8075 & args8076]
   (clojure.core/let
    [^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client8077
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials8075)]
    (clojure.core/case
     (clojure.core/count args8076)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client8077
       listStacks
       (list-stacks-request (clojure.core/nth args8076 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client8077
       listStacks))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :delete-stack
   [m8078]
   (clojure.core/let
    [credentials8079 (:credentials m8078) args8080 (:args m8078)]
    (clojure.core/let
     [^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client8081
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials8079)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client8081
       deleteStack
       (delete-stack-request (clojure.core/nth args8080 0)))))))
  (clojure.core/defn
   delete-stack-map
   {:arglists (quote
               [[credentials
                 {:keys [stack-name request-metric-collector]}]]),
    :doc "Generate map for deleteStack"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :cloudformation,
     :fn :delete-stack,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   delete-stack
   {:arglists (quote
               [[credentials
                 {:keys [stack-name request-metric-collector]}]]),
    :doc "Call deleteStack"}
   [credentials8083 & args8084]
   (clojure.core/let
    [^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client8085
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials8083)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client8085
      deleteStack
      (delete-stack-request (clojure.core/nth args8084 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :estimate-template-cost
   [m8086]
   (clojure.core/let
    [credentials8087 (:credentials m8086) args8088 (:args m8086)]
    (clojure.core/let
     [^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client8089
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials8087)]
     (clojure.core/case
      (clojure.core/count args8088)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client8089
        estimateTemplateCost))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client8089
        estimateTemplateCost
        (estimate-template-cost-request (clojure.core/nth args8088 0))))))))
  (clojure.core/defn
   estimate-template-cost-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [template-url
                         template-body
                         request-metric-collector
                         parameters]}]]),
    :doc "Generate map for estimateTemplateCost, estimateTemplateCost"}
   ([credentials__1609__auto__]
    {:args [],
     :client :cloudformation,
     :fn :estimate-template-cost,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :cloudformation,
     :fn :estimate-template-cost,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   estimate-template-cost
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [template-url
                         template-body
                         request-metric-collector
                         parameters]}]]),
    :doc "Call estimateTemplateCost, estimateTemplateCost"}
   [credentials8091 & args8092]
   (clojure.core/let
    [^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client8093
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials8091)]
    (clojure.core/case
     (clojure.core/count args8092)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client8093
       estimateTemplateCost))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client8093
       estimateTemplateCost
       (estimate-template-cost-request (clojure.core/nth args8092 0))))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :validate-template
   [m8094]
   (clojure.core/let
    [credentials8095 (:credentials m8094) args8096 (:args m8094)]
    (clojure.core/let
     [^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client8097
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials8095)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client8097
       validateTemplate
       (validate-template-request (clojure.core/nth args8096 0)))))))
  (clojure.core/defn
   validate-template-map
   {:arglists (quote
               [[credentials
                 {:keys [template-url
                         template-body
                         request-metric-collector]}]]),
    :doc "Generate map for validateTemplate"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :cloudformation,
     :fn :validate-template,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   validate-template
   {:arglists (quote
               [[credentials
                 {:keys [template-url
                         template-body
                         request-metric-collector]}]]),
    :doc "Call validateTemplate"}
   [credentials8099 & args8100]
   (clojure.core/let
    [^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client8101
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials8099)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client8101
      validateTemplate
      (validate-template-request (clojure.core/nth args8100 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :update-stack
   [m8102]
   (clojure.core/let
    [credentials8103 (:credentials m8102) args8104 (:args m8102)]
    (clojure.core/let
     [^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client8105
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials8103)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client8105
       updateStack
       (update-stack-request (clojure.core/nth args8104 0)))))))
  (clojure.core/defn
   update-stack-map
   {:arglists (quote
               [[credentials
                 {:keys [template-url
                         template-body
                         stack-name
                         request-metric-collector
                         parameters
                         capabilities]}]]),
    :doc "Generate map for updateStack"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :cloudformation,
     :fn :update-stack,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   update-stack
   {:arglists (quote
               [[credentials
                 {:keys [template-url
                         template-body
                         stack-name
                         request-metric-collector
                         parameters
                         capabilities]}]]),
    :doc "Call updateStack"}
   [credentials8107 & args8108]
   (clojure.core/let
    [^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client8109
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials8107)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client8109
      updateStack
      (update-stack-request (clojure.core/nth args8108 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :describe-stack-resources
   [m8110]
   (clojure.core/let
    [credentials8111 (:credentials m8110) args8112 (:args m8110)]
    (clojure.core/let
     [^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client8113
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials8111)]
     (clojure.core/case
      (clojure.core/count args8112)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client8113
        describeStackResources))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client8113
        describeStackResources
        (describe-stack-resources-request
         (clojure.core/nth args8112 0))))))))
  (clojure.core/defn
   describe-stack-resources-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [stack-name
                         request-metric-collector
                         physical-resource-id
                         logical-resource-id]}]]),
    :doc "Generate map for describeStackResources, describeStackResources"}
   ([credentials__1609__auto__]
    {:args [],
     :client :cloudformation,
     :fn :describe-stack-resources,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :cloudformation,
     :fn :describe-stack-resources,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-stack-resources
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [stack-name
                         request-metric-collector
                         physical-resource-id
                         logical-resource-id]}]]),
    :doc "Call describeStackResources, describeStackResources"}
   [credentials8115 & args8116]
   (clojure.core/let
    [^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client8117
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials8115)]
    (clojure.core/case
     (clojure.core/count args8116)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client8117
       describeStackResources))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client8117
       describeStackResources
       (describe-stack-resources-request
        (clojure.core/nth args8116 0))))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :cancel-update-stack
   [m8118]
   (clojure.core/let
    [credentials8119 (:credentials m8118) args8120 (:args m8118)]
    (clojure.core/let
     [^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client8121
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials8119)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client8121
       cancelUpdateStack
       (cancel-update-stack-request (clojure.core/nth args8120 0)))))))
  (clojure.core/defn
   cancel-update-stack-map
   {:arglists (quote
               [[credentials
                 {:keys [stack-name request-metric-collector]}]]),
    :doc "Generate map for cancelUpdateStack"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :cloudformation,
     :fn :cancel-update-stack,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   cancel-update-stack
   {:arglists (quote
               [[credentials
                 {:keys [stack-name request-metric-collector]}]]),
    :doc "Call cancelUpdateStack"}
   [credentials8123 & args8124]
   (clojure.core/let
    [^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client8125
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials8123)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client8125
      cancelUpdateStack
      (cancel-update-stack-request (clojure.core/nth args8124 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :create-stack
   [m8126]
   (clojure.core/let
    [credentials8127 (:credentials m8126) args8128 (:args m8126)]
    (clojure.core/let
     [^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client8129
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials8127)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client8129
       createStack
       (create-stack-request (clojure.core/nth args8128 0)))))))
  (clojure.core/defn
   create-stack-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         disable-rollback
                         template-body
                         capabilities
                         stack-name
                         notification-arns
                         parameters
                         template-url
                         on-failure
                         timeout-in-minutes
                         tags]}]]),
    :doc "Generate map for createStack"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :cloudformation,
     :fn :create-stack,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   create-stack
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         disable-rollback
                         template-body
                         capabilities
                         stack-name
                         notification-arns
                         parameters
                         template-url
                         on-failure
                         timeout-in-minutes
                         tags]}]]),
    :doc "Call createStack"}
   [credentials8131 & args8132]
   (clojure.core/let
    [^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client8133
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials8131)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client8133
      createStack
      (create-stack-request (clojure.core/nth args8132 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :describe-stack-resource
   [m8134]
   (clojure.core/let
    [credentials8135 (:credentials m8134) args8136 (:args m8134)]
    (clojure.core/let
     [^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client8137
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials8135)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client8137
       describeStackResource
       (describe-stack-resource-request (clojure.core/nth args8136 0)))))))
  (clojure.core/defn
   describe-stack-resource-map
   {:arglists (quote
               [[credentials
                 {:keys [stack-name
                         request-metric-collector
                         logical-resource-id]}]]),
    :doc "Generate map for describeStackResource"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :cloudformation,
     :fn :describe-stack-resource,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-stack-resource
   {:arglists (quote
               [[credentials
                 {:keys [stack-name
                         request-metric-collector
                         logical-resource-id]}]]),
    :doc "Call describeStackResource"}
   [credentials8139 & args8140]
   (clojure.core/let
    [^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client8141
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials8139)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client8141
      describeStackResource
      (describe-stack-resource-request (clojure.core/nth args8140 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :list-stack-resources
   [m8142]
   (clojure.core/let
    [credentials8143 (:credentials m8142) args8144 (:args m8142)]
    (clojure.core/let
     [^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client8145
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials8143)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client8145
       listStackResources
       (list-stack-resources-request (clojure.core/nth args8144 0)))))))
  (clojure.core/defn
   list-stack-resources-map
   {:arglists (quote
               [[credentials
                 {:keys [stack-name
                         request-metric-collector
                         next-token]}]]),
    :doc "Generate map for listStackResources"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :cloudformation,
     :fn :list-stack-resources,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   list-stack-resources
   {:arglists (quote
               [[credentials
                 {:keys [stack-name
                         request-metric-collector
                         next-token]}]]),
    :doc "Call listStackResources"}
   [credentials8147 & args8148]
   (clojure.core/let
    [^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client8149
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials8147)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.cloudformation.AmazonCloudFormationClient client8149
      listStackResources
      (list-stack-resources-request (clojure.core/nth args8148 0))))))))
