(ns
 com.palletops.awaze.cloudfront
 (:require [com.palletops.awaze.common]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :cloudfront
  [___1561__auto__
   ^com.amazonaws.auth.BasicAWSCredentials credentials__1562__auto__]
  (new
   com.amazonaws.services.cloudfront.AmazonCloudFrontClient
   credentials__1562__auto__))
 (clojure.core/defn
  ^com.amazonaws.services.cloudfront.model.CookieNames cookie-names
  [m1912]
  (clojure.core/let
   [bean1911
    (new com.amazonaws.services.cloudfront.model.CookieNames)]
   (clojure.core/when-let
    [v1913 (:quantity m1912)]
    (. bean1911 setQuantity (clojure.core/int v1913)))
   (clojure.core/when-let
    [v1913 (:items m1912)]
    (.
     bean1911
     setItems
     (clojure.core/map
      (clojure.core/fn [arg1917] (clojure.core/str arg1917))
      v1913)))
   bean1911))
 (clojure.core/defn
  ^com.amazonaws.services.cloudfront.model.ItemSelection item-selection
  [m1915]
  (java.lang.Enum/valueOf
   com.amazonaws.services.cloudfront.model.ItemSelection
   (clojure.core/name m1915)))
 (clojure.core/defn
  ^com.amazonaws.services.cloudfront.model.OriginProtocolPolicy origin-protocol-policy
  [m1919]
  (java.lang.Enum/valueOf
   com.amazonaws.services.cloudfront.model.OriginProtocolPolicy
   (clojure.core/name m1919)))
 (clojure.core/defn
  ^com.amazonaws.services.cloudfront.model.CookiePreference cookie-preference
  [m1922]
  (clojure.core/let
   [bean1921
    (new com.amazonaws.services.cloudfront.model.CookiePreference)]
   (clojure.core/when-let
    [v1923 (:whitelisted-names m1922)]
    (. bean1921 setWhitelistedNames (cookie-names v1923)))
   (clojure.core/when-let
    [v1923 (:forward m1922)]
    (. bean1921 setForward (clojure.core/str v1923)))
   (clojure.core/when-let
    [v1923 (:forward m1922)]
    (. bean1921 setForward (item-selection v1923)))
   bean1921))
 (clojure.core/defn
  ^com.amazonaws.services.cloudfront.model.S3OriginConfig s3origin-config
  [m1925]
  (clojure.core/let
   [bean1924
    (new com.amazonaws.services.cloudfront.model.S3OriginConfig)]
   (clojure.core/when-let
    [v1926 (:origin-access-identity m1925)]
    (. bean1924 setOriginAccessIdentity (clojure.core/str v1926)))
   bean1924))
 (clojure.core/defn
  ^com.amazonaws.services.cloudfront.model.CustomOriginConfig custom-origin-config
  [m1928]
  (clojure.core/let
   [bean1927
    (new com.amazonaws.services.cloudfront.model.CustomOriginConfig)]
   (clojure.core/when-let
    [v1929 (:httpport m1928)]
    (. bean1927 setHTTPPort (clojure.core/int v1929)))
   (clojure.core/when-let
    [v1929 (:httpsport m1928)]
    (. bean1927 setHTTPSPort (clojure.core/int v1929)))
   (clojure.core/when-let
    [v1929 (:origin-protocol-policy m1928)]
    (. bean1927 setOriginProtocolPolicy (clojure.core/str v1929)))
   (clojure.core/when-let
    [v1929 (:origin-protocol-policy m1928)]
    (.
     bean1927
     setOriginProtocolPolicy
     (origin-protocol-policy v1929)))
   bean1927))
 (clojure.core/defn
  ^com.amazonaws.services.cloudfront.model.TrustedSigners trusted-signers
  [m1931]
  (clojure.core/let
   [bean1930
    (new com.amazonaws.services.cloudfront.model.TrustedSigners)]
   (clojure.core/when-let
    [v1932 (:enabled m1931)]
    (. bean1930 setEnabled (clojure.core/boolean v1932)))
   (clojure.core/when-let
    [v1932 (:quantity m1931)]
    (. bean1930 setQuantity (clojure.core/int v1932)))
   (clojure.core/when-let
    [v1932 (:items m1931)]
    (.
     bean1930
     setItems
     (clojure.core/map
      (clojure.core/fn [arg1936] (clojure.core/str arg1936))
      v1932)))
   bean1930))
 (clojure.core/defn
  ^com.amazonaws.services.cloudfront.model.ForwardedValues forwarded-values
  [m1934]
  (clojure.core/let
   [bean1933
    (new com.amazonaws.services.cloudfront.model.ForwardedValues)]
   (clojure.core/when-let
    [v1935 (:query-string m1934)]
    (. bean1933 setQueryString (clojure.core/boolean v1935)))
   (clojure.core/when-let
    [v1935 (:cookies m1934)]
    (. bean1933 setCookies (cookie-preference v1935)))
   bean1933))
 (clojure.core/defn
  ^com.amazonaws.services.cloudfront.model.ViewerProtocolPolicy viewer-protocol-policy
  [m1938]
  (java.lang.Enum/valueOf
   com.amazonaws.services.cloudfront.model.ViewerProtocolPolicy
   (clojure.core/name m1938)))
 (clojure.core/defn
  ^com.amazonaws.services.cloudfront.model.AllowedMethods allowed-methods
  [m1941]
  (clojure.core/let
   [bean1940
    (new com.amazonaws.services.cloudfront.model.AllowedMethods)]
   (clojure.core/when-let
    [v1942 (:quantity m1941)]
    (. bean1940 setQuantity (clojure.core/int v1942)))
   (clojure.core/when-let
    [v1942 (:items m1941)]
    (.
     bean1940
     setItems
     (clojure.core/map
      (clojure.core/fn [arg1946] (clojure.core/str arg1946))
      v1942)))
   bean1940))
 (clojure.core/defn
  ^com.amazonaws.services.cloudfront.model.Origin origin
  [m1944]
  (clojure.core/let
   [bean1943 (new com.amazonaws.services.cloudfront.model.Origin)]
   (clojure.core/when-let
    [v1945 (:s3origin-config m1944)]
    (. bean1943 setS3OriginConfig (s3origin-config v1945)))
   (clojure.core/when-let
    [v1945 (:custom-origin-config m1944)]
    (. bean1943 setCustomOriginConfig (custom-origin-config v1945)))
   (clojure.core/when-let
    [v1945 (:id m1944)]
    (. bean1943 setId (clojure.core/str v1945)))
   (clojure.core/when-let
    [v1945 (:domain-name m1944)]
    (. bean1943 setDomainName (clojure.core/str v1945)))
   bean1943))
 (clojure.core/defn
  ^com.amazonaws.services.cloudfront.model.CacheBehavior cache-behavior
  [m1948]
  (clojure.core/let
   [bean1947
    (new com.amazonaws.services.cloudfront.model.CacheBehavior)]
   (clojure.core/when-let
    [v1949 (:trusted-signers m1948)]
    (. bean1947 setTrustedSigners (trusted-signers v1949)))
   (clojure.core/when-let
    [v1949 (:path-pattern m1948)]
    (. bean1947 setPathPattern (clojure.core/str v1949)))
   (clojure.core/when-let
    [v1949 (:target-origin-id m1948)]
    (. bean1947 setTargetOriginId (clojure.core/str v1949)))
   (clojure.core/when-let
    [v1949 (:forwarded-values m1948)]
    (. bean1947 setForwardedValues (forwarded-values v1949)))
   (clojure.core/when-let
    [v1949 (:viewer-protocol-policy m1948)]
    (. bean1947 setViewerProtocolPolicy (clojure.core/str v1949)))
   (clojure.core/when-let
    [v1949 (:viewer-protocol-policy m1948)]
    (.
     bean1947
     setViewerProtocolPolicy
     (viewer-protocol-policy v1949)))
   (clojure.core/when-let
    [v1949 (:min-ttl m1948)]
    (. bean1947 setMinTTL (clojure.core/long v1949)))
   (clojure.core/when-let
    [v1949 (:allowed-methods m1948)]
    (. bean1947 setAllowedMethods (allowed-methods v1949)))
   bean1947))
 (clojure.core/defn
  ^com.amazonaws.services.cloudfront.model.CustomErrorResponse custom-error-response
  [m1951]
  (clojure.core/let
   [bean1950
    (new com.amazonaws.services.cloudfront.model.CustomErrorResponse)]
   (clojure.core/when-let
    [v1952 (:error-code m1951)]
    (. bean1950 setErrorCode (clojure.core/int v1952)))
   (clojure.core/when-let
    [v1952 (:response-page-path m1951)]
    (. bean1950 setResponsePagePath (clojure.core/str v1952)))
   (clojure.core/when-let
    [v1952 (:response-code m1951)]
    (. bean1950 setResponseCode (clojure.core/str v1952)))
   (clojure.core/when-let
    [v1952 (:error-caching-min-ttl m1951)]
    (. bean1950 setErrorCachingMinTTL (clojure.core/long v1952)))
   bean1950))
 (clojure.core/defn
  ^com.amazonaws.services.cloudfront.model.S3Origin s3origin
  [m1954]
  (clojure.core/let
   [bean1953 (new com.amazonaws.services.cloudfront.model.S3Origin)]
   (clojure.core/when-let
    [v1955 (:domain-name m1954)]
    (. bean1953 setDomainName (clojure.core/str v1955)))
   (clojure.core/when-let
    [v1955 (:origin-access-identity m1954)]
    (. bean1953 setOriginAccessIdentity (clojure.core/str v1955)))
   bean1953))
 (clojure.core/defn
  ^com.amazonaws.services.cloudfront.model.Aliases aliases
  [m1957]
  (clojure.core/let
   [bean1956 (new com.amazonaws.services.cloudfront.model.Aliases)]
   (clojure.core/when-let
    [v1958 (:quantity m1957)]
    (. bean1956 setQuantity (clojure.core/int v1958)))
   (clojure.core/when-let
    [v1958 (:items m1957)]
    (.
     bean1956
     setItems
     (clojure.core/map
      (clojure.core/fn [arg1962] (clojure.core/str arg1962))
      v1958)))
   bean1956))
 (clojure.core/defn
  ^com.amazonaws.services.cloudfront.model.StreamingLoggingConfig streaming-logging-config
  [m1960]
  (clojure.core/let
   [bean1959
    (new
     com.amazonaws.services.cloudfront.model.StreamingLoggingConfig)]
   (clojure.core/when-let
    [v1961 (:enabled m1960)]
    (. bean1959 setEnabled (clojure.core/boolean v1961)))
   (clojure.core/when-let
    [v1961 (:prefix m1960)]
    (. bean1959 setPrefix (clojure.core/str v1961)))
   (clojure.core/when-let
    [v1961 (:bucket m1960)]
    (. bean1959 setBucket (clojure.core/str v1961)))
   bean1959))
 (clojure.core/defn
  ^com.amazonaws.services.cloudfront.model.PriceClass price-class
  [m1964]
  (java.lang.Enum/valueOf
   com.amazonaws.services.cloudfront.model.PriceClass
   (clojure.core/name m1964)))
 (clojure.core/defn
  ^com.amazonaws.services.cloudfront.model.LoggingConfig logging-config
  [m1967]
  (clojure.core/let
   [bean1966
    (new com.amazonaws.services.cloudfront.model.LoggingConfig)]
   (clojure.core/when-let
    [v1968 (:enabled m1967)]
    (. bean1966 setEnabled (clojure.core/boolean v1968)))
   (clojure.core/when-let
    [v1968 (:prefix m1967)]
    (. bean1966 setPrefix (clojure.core/str v1968)))
   (clojure.core/when-let
    [v1968 (:bucket m1967)]
    (. bean1966 setBucket (clojure.core/str v1968)))
   (clojure.core/when-let
    [v1968 (:include-cookies m1967)]
    (. bean1966 setIncludeCookies (clojure.core/boolean v1968)))
   bean1966))
 (clojure.core/defn
  ^com.amazonaws.services.cloudfront.model.Origins origins
  [m1970]
  (clojure.core/let
   [bean1969 (new com.amazonaws.services.cloudfront.model.Origins)]
   (clojure.core/when-let
    [v1971 (:quantity m1970)]
    (. bean1969 setQuantity (clojure.core/int v1971)))
   (clojure.core/when-let
    [v1971 (:items m1970)]
    (.
     bean1969
     setItems
     (clojure.core/map
      (clojure.core/fn [arg1975] (origin arg1975))
      v1971)))
   bean1969))
 (clojure.core/defn
  ^com.amazonaws.services.cloudfront.model.DefaultCacheBehavior default-cache-behavior
  [m1973]
  (clojure.core/let
   [bean1972
    (new com.amazonaws.services.cloudfront.model.DefaultCacheBehavior)]
   (clojure.core/when-let
    [v1974 (:trusted-signers m1973)]
    (. bean1972 setTrustedSigners (trusted-signers v1974)))
   (clojure.core/when-let
    [v1974 (:target-origin-id m1973)]
    (. bean1972 setTargetOriginId (clojure.core/str v1974)))
   (clojure.core/when-let
    [v1974 (:forwarded-values m1973)]
    (. bean1972 setForwardedValues (forwarded-values v1974)))
   (clojure.core/when-let
    [v1974 (:viewer-protocol-policy m1973)]
    (. bean1972 setViewerProtocolPolicy (clojure.core/str v1974)))
   (clojure.core/when-let
    [v1974 (:viewer-protocol-policy m1973)]
    (.
     bean1972
     setViewerProtocolPolicy
     (viewer-protocol-policy v1974)))
   (clojure.core/when-let
    [v1974 (:min-ttl m1973)]
    (. bean1972 setMinTTL (clojure.core/long v1974)))
   (clojure.core/when-let
    [v1974 (:allowed-methods m1973)]
    (. bean1972 setAllowedMethods (allowed-methods v1974)))
   bean1972))
 (clojure.core/defn
  ^com.amazonaws.services.cloudfront.model.CacheBehaviors cache-behaviors
  [m1977]
  (clojure.core/let
   [bean1976
    (new com.amazonaws.services.cloudfront.model.CacheBehaviors)]
   (clojure.core/when-let
    [v1978 (:quantity m1977)]
    (. bean1976 setQuantity (clojure.core/int v1978)))
   (clojure.core/when-let
    [v1978 (:items m1977)]
    (.
     bean1976
     setItems
     (clojure.core/map
      (clojure.core/fn [arg1982] (cache-behavior arg1982))
      v1978)))
   bean1976))
 (clojure.core/defn
  ^com.amazonaws.services.cloudfront.model.CustomErrorResponses custom-error-responses
  [m1980]
  (clojure.core/let
   [bean1979
    (new com.amazonaws.services.cloudfront.model.CustomErrorResponses)]
   (clojure.core/when-let
    [v1981 (:quantity m1980)]
    (. bean1979 setQuantity (clojure.core/int v1981)))
   (clojure.core/when-let
    [v1981 (:items m1980)]
    (.
     bean1979
     setItems
     (clojure.core/map
      (clojure.core/fn [arg1986] (custom-error-response arg1986))
      v1981)))
   bean1979))
 (clojure.core/defn
  ^com.amazonaws.services.cloudfront.model.ViewerCertificate viewer-certificate
  [m1984]
  (clojure.core/let
   [bean1983
    (new com.amazonaws.services.cloudfront.model.ViewerCertificate)]
   (clojure.core/when-let
    [v1985 (:iamcertificate-id m1984)]
    (. bean1983 setIAMCertificateId (clojure.core/str v1985)))
   (clojure.core/when-let
    [v1985 (:cloud-front-default-certificate m1984)]
    (.
     bean1983
     setCloudFrontDefaultCertificate
     (clojure.core/boolean v1985)))
   bean1983))
 (clojure.core/defn
  ^com.amazonaws.services.cloudfront.model.Paths paths
  [m1988]
  (clojure.core/let
   [bean1987 (new com.amazonaws.services.cloudfront.model.Paths)]
   (clojure.core/when-let
    [v1989 (:quantity m1988)]
    (. bean1987 setQuantity (clojure.core/int v1989)))
   (clojure.core/when-let
    [v1989 (:items m1988)]
    (.
     bean1987
     setItems
     (clojure.core/map
      (clojure.core/fn [arg1993] (clojure.core/str arg1993))
      v1989)))
   bean1987))
 (clojure.core/defn
  ^com.amazonaws.services.cloudfront.model.StreamingDistributionConfig streaming-distribution-config
  [m1991]
  (clojure.core/let
   [bean1990
    (new
     com.amazonaws.services.cloudfront.model.StreamingDistributionConfig)]
   (clojure.core/when-let
    [v1992 (:comment m1991)]
    (. bean1990 setComment (clojure.core/str v1992)))
   (clojure.core/when-let
    [v1992 (:caller-reference m1991)]
    (. bean1990 setCallerReference (clojure.core/str v1992)))
   (clojure.core/when-let
    [v1992 (:s3origin m1991)]
    (. bean1990 setS3Origin (s3origin v1992)))
   (clojure.core/when-let
    [v1992 (:aliases m1991)]
    (. bean1990 setAliases (aliases v1992)))
   (clojure.core/when-let
    [v1992 (:logging m1991)]
    (. bean1990 setLogging (streaming-logging-config v1992)))
   (clojure.core/when-let
    [v1992 (:trusted-signers m1991)]
    (. bean1990 setTrustedSigners (trusted-signers v1992)))
   (clojure.core/when-let
    [v1992 (:price-class m1991)]
    (. bean1990 setPriceClass (clojure.core/str v1992)))
   (clojure.core/when-let
    [v1992 (:price-class m1991)]
    (. bean1990 setPriceClass (price-class v1992)))
   (clojure.core/when-let
    [v1992 (:enabled m1991)]
    (. bean1990 setEnabled (clojure.core/boolean v1992)))
   bean1990))
 (clojure.core/defn
  ^com.amazonaws.services.cloudfront.model.CloudFrontOriginAccessIdentityConfig cloud-front-origin-access-identity-config
  [m1995]
  (clojure.core/let
   [bean1994
    (new
     com.amazonaws.services.cloudfront.model.CloudFrontOriginAccessIdentityConfig)]
   (clojure.core/when-let
    [v1996 (:comment m1995)]
    (. bean1994 setComment (clojure.core/str v1996)))
   (clojure.core/when-let
    [v1996 (:caller-reference m1995)]
    (. bean1994 setCallerReference (clojure.core/str v1996)))
   bean1994))
 (clojure.core/defn
  ^com.amazonaws.services.cloudfront.model.DistributionConfig distribution-config
  [m1998]
  (clojure.core/let
   [bean1997
    (new com.amazonaws.services.cloudfront.model.DistributionConfig)]
   (clojure.core/when-let
    [v1999 (:comment m1998)]
    (. bean1997 setComment (clojure.core/str v1999)))
   (clojure.core/when-let
    [v1999 (:caller-reference m1998)]
    (. bean1997 setCallerReference (clojure.core/str v1999)))
   (clojure.core/when-let
    [v1999 (:aliases m1998)]
    (. bean1997 setAliases (aliases v1999)))
   (clojure.core/when-let
    [v1999 (:logging m1998)]
    (. bean1997 setLogging (logging-config v1999)))
   (clojure.core/when-let
    [v1999 (:price-class m1998)]
    (. bean1997 setPriceClass (clojure.core/str v1999)))
   (clojure.core/when-let
    [v1999 (:price-class m1998)]
    (. bean1997 setPriceClass (price-class v1999)))
   (clojure.core/when-let
    [v1999 (:enabled m1998)]
    (. bean1997 setEnabled (clojure.core/boolean v1999)))
   (clojure.core/when-let
    [v1999 (:default-root-object m1998)]
    (. bean1997 setDefaultRootObject (clojure.core/str v1999)))
   (clojure.core/when-let
    [v1999 (:origins m1998)]
    (. bean1997 setOrigins (origins v1999)))
   (clojure.core/when-let
    [v1999 (:default-cache-behavior m1998)]
    (.
     bean1997
     setDefaultCacheBehavior
     (default-cache-behavior v1999)))
   (clojure.core/when-let
    [v1999 (:cache-behaviors m1998)]
    (. bean1997 setCacheBehaviors (cache-behaviors v1999)))
   (clojure.core/when-let
    [v1999 (:custom-error-responses m1998)]
    (.
     bean1997
     setCustomErrorResponses
     (custom-error-responses v1999)))
   (clojure.core/when-let
    [v1999 (:viewer-certificate m1998)]
    (. bean1997 setViewerCertificate (viewer-certificate v1999)))
   bean1997))
 (clojure.core/defn
  ^com.amazonaws.services.cloudfront.model.InvalidationBatch invalidation-batch
  [m2001]
  (clojure.core/let
   [bean2000
    (new com.amazonaws.services.cloudfront.model.InvalidationBatch)]
   (clojure.core/when-let
    [v2002 (:caller-reference m2001)]
    (. bean2000 setCallerReference (clojure.core/str v2002)))
   (clojure.core/when-let
    [v2002 (:paths m2001)]
    (. bean2000 setPaths (paths v2002)))
   bean2000))
 (clojure.core/defn
  ^com.amazonaws.services.cloudfront.model.ListStreamingDistributionsRequest list-streaming-distributions-request
  [m2004]
  (clojure.core/let
   [bean2003
    (new
     com.amazonaws.services.cloudfront.model.ListStreamingDistributionsRequest)]
   (clojure.core/when-let
    [v2005 (:max-items m2004)]
    (. bean2003 setMaxItems (clojure.core/str v2005)))
   (clojure.core/when-let
    [v2005 (:marker m2004)]
    (. bean2003 setMarker (clojure.core/str v2005)))
   bean2003))
 (clojure.core/defn
  ^com.amazonaws.services.cloudfront.model.GetCloudFrontOriginAccessIdentityConfigRequest get-cloud-front-origin-access-identity-config-request
  [m2007]
  (clojure.core/let
   [bean2006
    (new
     com.amazonaws.services.cloudfront.model.GetCloudFrontOriginAccessIdentityConfigRequest)]
   (clojure.core/when-let
    [v2008 (:id m2007)]
    (. bean2006 setId (clojure.core/str v2008)))
   bean2006))
 (clojure.core/defn
  ^com.amazonaws.services.cloudfront.model.UpdateStreamingDistributionRequest update-streaming-distribution-request
  [m2010]
  (clojure.core/let
   [bean2009
    (new
     com.amazonaws.services.cloudfront.model.UpdateStreamingDistributionRequest)]
   (clojure.core/when-let
    [v2011 (:streaming-distribution-config m2010)]
    (.
     bean2009
     setStreamingDistributionConfig
     (streaming-distribution-config v2011)))
   (clojure.core/when-let
    [v2011 (:id m2010)]
    (. bean2009 setId (clojure.core/str v2011)))
   (clojure.core/when-let
    [v2011 (:if-match m2010)]
    (. bean2009 setIfMatch (clojure.core/str v2011)))
   bean2009))
 (clojure.core/defn
  ^com.amazonaws.services.cloudfront.model.CreateCloudFrontOriginAccessIdentityRequest create-cloud-front-origin-access-identity-request
  [m2013]
  (clojure.core/let
   [bean2012
    (new
     com.amazonaws.services.cloudfront.model.CreateCloudFrontOriginAccessIdentityRequest)]
   (clojure.core/when-let
    [v2014 (:cloud-front-origin-access-identity-config m2013)]
    (.
     bean2012
     setCloudFrontOriginAccessIdentityConfig
     (cloud-front-origin-access-identity-config v2014)))
   bean2012))
 (clojure.core/defn
  ^com.amazonaws.services.cloudfront.model.ListCloudFrontOriginAccessIdentitiesRequest list-cloud-front-origin-access-identities-request
  [m2016]
  (clojure.core/let
   [bean2015
    (new
     com.amazonaws.services.cloudfront.model.ListCloudFrontOriginAccessIdentitiesRequest)]
   (clojure.core/when-let
    [v2017 (:max-items m2016)]
    (. bean2015 setMaxItems (clojure.core/str v2017)))
   (clojure.core/when-let
    [v2017 (:marker m2016)]
    (. bean2015 setMarker (clojure.core/str v2017)))
   bean2015))
 (clojure.core/defn
  ^com.amazonaws.services.cloudfront.model.GetDistributionConfigRequest get-distribution-config-request
  [m2019]
  (clojure.core/let
   [bean2018
    (new
     com.amazonaws.services.cloudfront.model.GetDistributionConfigRequest)]
   (clojure.core/when-let
    [v2020 (:id m2019)]
    (. bean2018 setId (clojure.core/str v2020)))
   bean2018))
 (clojure.core/defn
  ^com.amazonaws.services.cloudfront.model.GetStreamingDistributionConfigRequest get-streaming-distribution-config-request
  [m2022]
  (clojure.core/let
   [bean2021
    (new
     com.amazonaws.services.cloudfront.model.GetStreamingDistributionConfigRequest)]
   (clojure.core/when-let
    [v2023 (:id m2022)]
    (. bean2021 setId (clojure.core/str v2023)))
   bean2021))
 (clojure.core/defn
  ^com.amazonaws.services.cloudfront.model.CreateDistributionRequest create-distribution-request
  [m2025]
  (clojure.core/let
   [bean2024
    (new
     com.amazonaws.services.cloudfront.model.CreateDistributionRequest)]
   (clojure.core/when-let
    [v2026 (:distribution-config m2025)]
    (. bean2024 setDistributionConfig (distribution-config v2026)))
   bean2024))
 (clojure.core/defn
  ^com.amazonaws.services.cloudfront.model.CreateInvalidationRequest create-invalidation-request
  [m2028]
  (clojure.core/let
   [bean2027
    (new
     com.amazonaws.services.cloudfront.model.CreateInvalidationRequest)]
   (clojure.core/when-let
    [v2029 (:distribution-id m2028)]
    (. bean2027 setDistributionId (clojure.core/str v2029)))
   (clojure.core/when-let
    [v2029 (:invalidation-batch m2028)]
    (. bean2027 setInvalidationBatch (invalidation-batch v2029)))
   bean2027))
 (clojure.core/defn
  ^com.amazonaws.services.cloudfront.model.UpdateDistributionRequest update-distribution-request
  [m2031]
  (clojure.core/let
   [bean2030
    (new
     com.amazonaws.services.cloudfront.model.UpdateDistributionRequest)]
   (clojure.core/when-let
    [v2032 (:id m2031)]
    (. bean2030 setId (clojure.core/str v2032)))
   (clojure.core/when-let
    [v2032 (:if-match m2031)]
    (. bean2030 setIfMatch (clojure.core/str v2032)))
   (clojure.core/when-let
    [v2032 (:distribution-config m2031)]
    (. bean2030 setDistributionConfig (distribution-config v2032)))
   bean2030))
 (clojure.core/defn
  ^com.amazonaws.services.cloudfront.model.GetStreamingDistributionRequest get-streaming-distribution-request
  [m2034]
  (clojure.core/let
   [bean2033
    (new
     com.amazonaws.services.cloudfront.model.GetStreamingDistributionRequest)]
   (clojure.core/when-let
    [v2035 (:id m2034)]
    (. bean2033 setId (clojure.core/str v2035)))
   bean2033))
 (clojure.core/defn
  ^com.amazonaws.services.cloudfront.model.ListInvalidationsRequest list-invalidations-request
  [m2037]
  (clojure.core/let
   [bean2036
    (new
     com.amazonaws.services.cloudfront.model.ListInvalidationsRequest)]
   (clojure.core/when-let
    [v2038 (:max-items m2037)]
    (. bean2036 setMaxItems (clojure.core/str v2038)))
   (clojure.core/when-let
    [v2038 (:marker m2037)]
    (. bean2036 setMarker (clojure.core/str v2038)))
   (clojure.core/when-let
    [v2038 (:distribution-id m2037)]
    (. bean2036 setDistributionId (clojure.core/str v2038)))
   bean2036))
 (clojure.core/defn
  ^com.amazonaws.services.cloudfront.model.DeleteDistributionRequest delete-distribution-request
  [m2040]
  (clojure.core/let
   [bean2039
    (new
     com.amazonaws.services.cloudfront.model.DeleteDistributionRequest)]
   (clojure.core/when-let
    [v2041 (:id m2040)]
    (. bean2039 setId (clojure.core/str v2041)))
   (clojure.core/when-let
    [v2041 (:if-match m2040)]
    (. bean2039 setIfMatch (clojure.core/str v2041)))
   bean2039))
 (clojure.core/defn
  ^com.amazonaws.services.cloudfront.model.CreateStreamingDistributionRequest create-streaming-distribution-request
  [m2043]
  (clojure.core/let
   [bean2042
    (new
     com.amazonaws.services.cloudfront.model.CreateStreamingDistributionRequest)]
   (clojure.core/when-let
    [v2044 (:streaming-distribution-config m2043)]
    (.
     bean2042
     setStreamingDistributionConfig
     (streaming-distribution-config v2044)))
   bean2042))
 (clojure.core/defn
  ^com.amazonaws.services.cloudfront.model.ListDistributionsRequest list-distributions-request
  [m2046]
  (clojure.core/let
   [bean2045
    (new
     com.amazonaws.services.cloudfront.model.ListDistributionsRequest)]
   (clojure.core/when-let
    [v2047 (:max-items m2046)]
    (. bean2045 setMaxItems (clojure.core/str v2047)))
   (clojure.core/when-let
    [v2047 (:marker m2046)]
    (. bean2045 setMarker (clojure.core/str v2047)))
   bean2045))
 (clojure.core/defn
  ^com.amazonaws.services.cloudfront.model.UpdateCloudFrontOriginAccessIdentityRequest update-cloud-front-origin-access-identity-request
  [m2049]
  (clojure.core/let
   [bean2048
    (new
     com.amazonaws.services.cloudfront.model.UpdateCloudFrontOriginAccessIdentityRequest)]
   (clojure.core/when-let
    [v2050 (:id m2049)]
    (. bean2048 setId (clojure.core/str v2050)))
   (clojure.core/when-let
    [v2050 (:cloud-front-origin-access-identity-config m2049)]
    (.
     bean2048
     setCloudFrontOriginAccessIdentityConfig
     (cloud-front-origin-access-identity-config v2050)))
   (clojure.core/when-let
    [v2050 (:if-match m2049)]
    (. bean2048 setIfMatch (clojure.core/str v2050)))
   bean2048))
 (clojure.core/defn
  ^com.amazonaws.services.cloudfront.model.GetInvalidationRequest get-invalidation-request
  [m2052]
  (clojure.core/let
   [bean2051
    (new
     com.amazonaws.services.cloudfront.model.GetInvalidationRequest)]
   (clojure.core/when-let
    [v2053 (:id m2052)]
    (. bean2051 setId (clojure.core/str v2053)))
   (clojure.core/when-let
    [v2053 (:distribution-id m2052)]
    (. bean2051 setDistributionId (clojure.core/str v2053)))
   bean2051))
 (clojure.core/defn
  ^com.amazonaws.services.cloudfront.model.DeleteStreamingDistributionRequest delete-streaming-distribution-request
  [m2055]
  (clojure.core/let
   [bean2054
    (new
     com.amazonaws.services.cloudfront.model.DeleteStreamingDistributionRequest)]
   (clojure.core/when-let
    [v2056 (:id m2055)]
    (. bean2054 setId (clojure.core/str v2056)))
   (clojure.core/when-let
    [v2056 (:if-match m2055)]
    (. bean2054 setIfMatch (clojure.core/str v2056)))
   bean2054))
 (clojure.core/defn
  ^com.amazonaws.services.cloudfront.model.GetDistributionRequest get-distribution-request
  [m2058]
  (clojure.core/let
   [bean2057
    (new
     com.amazonaws.services.cloudfront.model.GetDistributionRequest)]
   (clojure.core/when-let
    [v2059 (:id m2058)]
    (. bean2057 setId (clojure.core/str v2059)))
   bean2057))
 (clojure.core/defn
  ^com.amazonaws.services.cloudfront.model.DeleteCloudFrontOriginAccessIdentityRequest delete-cloud-front-origin-access-identity-request
  [m2061]
  (clojure.core/let
   [bean2060
    (new
     com.amazonaws.services.cloudfront.model.DeleteCloudFrontOriginAccessIdentityRequest)]
   (clojure.core/when-let
    [v2062 (:id m2061)]
    (. bean2060 setId (clojure.core/str v2062)))
   (clojure.core/when-let
    [v2062 (:if-match m2061)]
    (. bean2060 setIfMatch (clojure.core/str v2062)))
   bean2060))
 (clojure.core/defn
  ^com.amazonaws.services.cloudfront.model.GetCloudFrontOriginAccessIdentityRequest get-cloud-front-origin-access-identity-request
  [m2064]
  (clojure.core/let
   [bean2063
    (new
     com.amazonaws.services.cloudfront.model.GetCloudFrontOriginAccessIdentityRequest)]
   (clojure.core/when-let
    [v2065 (:id m2064)]
    (. bean2063 setId (clojure.core/str v2065)))
   bean2063))
 (clojure.core/defmulti
  cloudfront
  (clojure.core/fn cloudfront [m__1641__auto__] (:fn m__1641__auto__)))
 (do
  (clojure.core/defmethod
   cloudfront
   :list-streaming-distributions
   [m2066]
   (clojure.core/let
    [credentials2067 (:credentials m2066) args2068 (:args m2066)]
    (clojure.core/let
     [^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client2069
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials2067)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client2069
       listStreamingDistributions
       (list-streaming-distributions-request
        (clojure.core/nth args2068 0)))))))
  (clojure.core/defn
   list-streaming-distributions-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector max-items marker]}]]),
    :doc "Generate map for listStreamingDistributions"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :cloudfront,
     :fn :list-streaming-distributions,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   list-streaming-distributions
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector max-items marker]}]]),
    :doc "Call listStreamingDistributions"}
   [credentials2071 & args2072]
   (clojure.core/let
    [^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client2073
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials2071)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client2073
      listStreamingDistributions
      (list-streaming-distributions-request
       (clojure.core/nth args2072 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :get-cloud-front-origin-access-identity-config
   [m2074]
   (clojure.core/let
    [credentials2075 (:credentials m2074) args2076 (:args m2074)]
    (clojure.core/let
     [^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client2077
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials2075)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client2077
       getCloudFrontOriginAccessIdentityConfig
       (get-cloud-front-origin-access-identity-config-request
        (clojure.core/nth args2076 0)))))))
  (clojure.core/defn
   get-cloud-front-origin-access-identity-config-map
   {:arglists (quote
               [[credentials {:keys [request-metric-collector id]}]]),
    :doc "Generate map for getCloudFrontOriginAccessIdentityConfig"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :cloudfront,
     :fn :get-cloud-front-origin-access-identity-config,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   get-cloud-front-origin-access-identity-config
   {:arglists (quote
               [[credentials {:keys [request-metric-collector id]}]]),
    :doc "Call getCloudFrontOriginAccessIdentityConfig"}
   [credentials2079 & args2080]
   (clojure.core/let
    [^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client2081
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials2079)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client2081
      getCloudFrontOriginAccessIdentityConfig
      (get-cloud-front-origin-access-identity-config-request
       (clojure.core/nth args2080 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :update-streaming-distribution
   [m2082]
   (clojure.core/let
    [credentials2083 (:credentials m2082) args2084 (:args m2082)]
    (clojure.core/let
     [^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client2085
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials2083)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client2085
       updateStreamingDistribution
       (update-streaming-distribution-request
        (clojure.core/nth args2084 0)))))))
  (clojure.core/defn
   update-streaming-distribution-map
   {:arglists (quote
               [[credentials
                 {:keys [streaming-distribution-config
                         request-metric-collector
                         if-match
                         id]}]]),
    :doc "Generate map for updateStreamingDistribution"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :cloudfront,
     :fn :update-streaming-distribution,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   update-streaming-distribution
   {:arglists (quote
               [[credentials
                 {:keys [streaming-distribution-config
                         request-metric-collector
                         if-match
                         id]}]]),
    :doc "Call updateStreamingDistribution"}
   [credentials2087 & args2088]
   (clojure.core/let
    [^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client2089
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials2087)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client2089
      updateStreamingDistribution
      (update-streaming-distribution-request
       (clojure.core/nth args2088 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :create-cloud-front-origin-access-identity
   [m2090]
   (clojure.core/let
    [credentials2091 (:credentials m2090) args2092 (:args m2090)]
    (clojure.core/let
     [^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client2093
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials2091)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client2093
       createCloudFrontOriginAccessIdentity
       (create-cloud-front-origin-access-identity-request
        (clojure.core/nth args2092 0)))))))
  (clojure.core/defn
   create-cloud-front-origin-access-identity-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         cloud-front-origin-access-identity-config]}]]),
    :doc "Generate map for createCloudFrontOriginAccessIdentity"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :cloudfront,
     :fn :create-cloud-front-origin-access-identity,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   create-cloud-front-origin-access-identity
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         cloud-front-origin-access-identity-config]}]]),
    :doc "Call createCloudFrontOriginAccessIdentity"}
   [credentials2095 & args2096]
   (clojure.core/let
    [^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client2097
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials2095)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client2097
      createCloudFrontOriginAccessIdentity
      (create-cloud-front-origin-access-identity-request
       (clojure.core/nth args2096 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :list-cloud-front-origin-access-identities
   [m2098]
   (clojure.core/let
    [credentials2099 (:credentials m2098) args2100 (:args m2098)]
    (clojure.core/let
     [^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client2101
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials2099)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client2101
       listCloudFrontOriginAccessIdentities
       (list-cloud-front-origin-access-identities-request
        (clojure.core/nth args2100 0)))))))
  (clojure.core/defn
   list-cloud-front-origin-access-identities-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector max-items marker]}]]),
    :doc "Generate map for listCloudFrontOriginAccessIdentities"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :cloudfront,
     :fn :list-cloud-front-origin-access-identities,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   list-cloud-front-origin-access-identities
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector max-items marker]}]]),
    :doc "Call listCloudFrontOriginAccessIdentities"}
   [credentials2103 & args2104]
   (clojure.core/let
    [^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client2105
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials2103)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client2105
      listCloudFrontOriginAccessIdentities
      (list-cloud-front-origin-access-identities-request
       (clojure.core/nth args2104 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :get-distribution-config
   [m2106]
   (clojure.core/let
    [credentials2107 (:credentials m2106) args2108 (:args m2106)]
    (clojure.core/let
     [^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client2109
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials2107)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client2109
       getDistributionConfig
       (get-distribution-config-request (clojure.core/nth args2108 0)))))))
  (clojure.core/defn
   get-distribution-config-map
   {:arglists (quote
               [[credentials {:keys [request-metric-collector id]}]]),
    :doc "Generate map for getDistributionConfig"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :cloudfront,
     :fn :get-distribution-config,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   get-distribution-config
   {:arglists (quote
               [[credentials {:keys [request-metric-collector id]}]]),
    :doc "Call getDistributionConfig"}
   [credentials2111 & args2112]
   (clojure.core/let
    [^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client2113
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials2111)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client2113
      getDistributionConfig
      (get-distribution-config-request (clojure.core/nth args2112 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :get-streaming-distribution-config
   [m2114]
   (clojure.core/let
    [credentials2115 (:credentials m2114) args2116 (:args m2114)]
    (clojure.core/let
     [^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client2117
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials2115)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client2117
       getStreamingDistributionConfig
       (get-streaming-distribution-config-request
        (clojure.core/nth args2116 0)))))))
  (clojure.core/defn
   get-streaming-distribution-config-map
   {:arglists (quote
               [[credentials {:keys [request-metric-collector id]}]]),
    :doc "Generate map for getStreamingDistributionConfig"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :cloudfront,
     :fn :get-streaming-distribution-config,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   get-streaming-distribution-config
   {:arglists (quote
               [[credentials {:keys [request-metric-collector id]}]]),
    :doc "Call getStreamingDistributionConfig"}
   [credentials2119 & args2120]
   (clojure.core/let
    [^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client2121
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials2119)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client2121
      getStreamingDistributionConfig
      (get-streaming-distribution-config-request
       (clojure.core/nth args2120 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :create-distribution
   [m2122]
   (clojure.core/let
    [credentials2123 (:credentials m2122) args2124 (:args m2122)]
    (clojure.core/let
     [^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client2125
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials2123)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client2125
       createDistribution
       (create-distribution-request (clojure.core/nth args2124 0)))))))
  (clojure.core/defn
   create-distribution-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector distribution-config]}]]),
    :doc "Generate map for createDistribution"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :cloudfront,
     :fn :create-distribution,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   create-distribution
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector distribution-config]}]]),
    :doc "Call createDistribution"}
   [credentials2127 & args2128]
   (clojure.core/let
    [^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client2129
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials2127)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client2129
      createDistribution
      (create-distribution-request (clojure.core/nth args2128 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :create-invalidation
   [m2130]
   (clojure.core/let
    [credentials2131 (:credentials m2130) args2132 (:args m2130)]
    (clojure.core/let
     [^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client2133
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials2131)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client2133
       createInvalidation
       (create-invalidation-request (clojure.core/nth args2132 0)))))))
  (clojure.core/defn
   create-invalidation-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         invalidation-batch
                         distribution-id]}]]),
    :doc "Generate map for createInvalidation"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :cloudfront,
     :fn :create-invalidation,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   create-invalidation
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         invalidation-batch
                         distribution-id]}]]),
    :doc "Call createInvalidation"}
   [credentials2135 & args2136]
   (clojure.core/let
    [^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client2137
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials2135)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client2137
      createInvalidation
      (create-invalidation-request (clojure.core/nth args2136 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :update-distribution
   [m2138]
   (clojure.core/let
    [credentials2139 (:credentials m2138) args2140 (:args m2138)]
    (clojure.core/let
     [^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client2141
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials2139)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client2141
       updateDistribution
       (update-distribution-request (clojure.core/nth args2140 0)))))))
  (clojure.core/defn
   update-distribution-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         if-match
                         id
                         distribution-config]}]]),
    :doc "Generate map for updateDistribution"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :cloudfront,
     :fn :update-distribution,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   update-distribution
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         if-match
                         id
                         distribution-config]}]]),
    :doc "Call updateDistribution"}
   [credentials2143 & args2144]
   (clojure.core/let
    [^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client2145
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials2143)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client2145
      updateDistribution
      (update-distribution-request (clojure.core/nth args2144 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :get-streaming-distribution
   [m2146]
   (clojure.core/let
    [credentials2147 (:credentials m2146) args2148 (:args m2146)]
    (clojure.core/let
     [^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client2149
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials2147)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client2149
       getStreamingDistribution
       (get-streaming-distribution-request
        (clojure.core/nth args2148 0)))))))
  (clojure.core/defn
   get-streaming-distribution-map
   {:arglists (quote
               [[credentials {:keys [request-metric-collector id]}]]),
    :doc "Generate map for getStreamingDistribution"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :cloudfront,
     :fn :get-streaming-distribution,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   get-streaming-distribution
   {:arglists (quote
               [[credentials {:keys [request-metric-collector id]}]]),
    :doc "Call getStreamingDistribution"}
   [credentials2151 & args2152]
   (clojure.core/let
    [^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client2153
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials2151)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client2153
      getStreamingDistribution
      (get-streaming-distribution-request
       (clojure.core/nth args2152 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :list-invalidations
   [m2154]
   (clojure.core/let
    [credentials2155 (:credentials m2154) args2156 (:args m2154)]
    (clojure.core/let
     [^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client2157
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials2155)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client2157
       listInvalidations
       (list-invalidations-request (clojure.core/nth args2156 0)))))))
  (clojure.core/defn
   list-invalidations-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         max-items
                         marker
                         distribution-id]}]]),
    :doc "Generate map for listInvalidations"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :cloudfront,
     :fn :list-invalidations,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   list-invalidations
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         max-items
                         marker
                         distribution-id]}]]),
    :doc "Call listInvalidations"}
   [credentials2159 & args2160]
   (clojure.core/let
    [^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client2161
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials2159)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client2161
      listInvalidations
      (list-invalidations-request (clojure.core/nth args2160 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :delete-distribution
   [m2162]
   (clojure.core/let
    [credentials2163 (:credentials m2162) args2164 (:args m2162)]
    (clojure.core/let
     [^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client2165
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials2163)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client2165
       deleteDistribution
       (delete-distribution-request (clojure.core/nth args2164 0)))))))
  (clojure.core/defn
   delete-distribution-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector if-match id]}]]),
    :doc "Generate map for deleteDistribution"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :cloudfront,
     :fn :delete-distribution,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   delete-distribution
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector if-match id]}]]),
    :doc "Call deleteDistribution"}
   [credentials2167 & args2168]
   (clojure.core/let
    [^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client2169
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials2167)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client2169
      deleteDistribution
      (delete-distribution-request (clojure.core/nth args2168 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :create-streaming-distribution
   [m2170]
   (clojure.core/let
    [credentials2171 (:credentials m2170) args2172 (:args m2170)]
    (clojure.core/let
     [^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client2173
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials2171)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client2173
       createStreamingDistribution
       (create-streaming-distribution-request
        (clojure.core/nth args2172 0)))))))
  (clojure.core/defn
   create-streaming-distribution-map
   {:arglists (quote
               [[credentials
                 {:keys [streaming-distribution-config
                         request-metric-collector]}]]),
    :doc "Generate map for createStreamingDistribution"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :cloudfront,
     :fn :create-streaming-distribution,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   create-streaming-distribution
   {:arglists (quote
               [[credentials
                 {:keys [streaming-distribution-config
                         request-metric-collector]}]]),
    :doc "Call createStreamingDistribution"}
   [credentials2175 & args2176]
   (clojure.core/let
    [^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client2177
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials2175)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client2177
      createStreamingDistribution
      (create-streaming-distribution-request
       (clojure.core/nth args2176 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :list-distributions
   [m2178]
   (clojure.core/let
    [credentials2179 (:credentials m2178) args2180 (:args m2178)]
    (clojure.core/let
     [^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client2181
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials2179)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client2181
       listDistributions
       (list-distributions-request (clojure.core/nth args2180 0)))))))
  (clojure.core/defn
   list-distributions-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector max-items marker]}]]),
    :doc "Generate map for listDistributions"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :cloudfront,
     :fn :list-distributions,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   list-distributions
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector max-items marker]}]]),
    :doc "Call listDistributions"}
   [credentials2183 & args2184]
   (clojure.core/let
    [^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client2185
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials2183)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client2185
      listDistributions
      (list-distributions-request (clojure.core/nth args2184 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :update-cloud-front-origin-access-identity
   [m2186]
   (clojure.core/let
    [credentials2187 (:credentials m2186) args2188 (:args m2186)]
    (clojure.core/let
     [^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client2189
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials2187)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client2189
       updateCloudFrontOriginAccessIdentity
       (update-cloud-front-origin-access-identity-request
        (clojure.core/nth args2188 0)))))))
  (clojure.core/defn
   update-cloud-front-origin-access-identity-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         if-match
                         id
                         cloud-front-origin-access-identity-config]}]]),
    :doc "Generate map for updateCloudFrontOriginAccessIdentity"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :cloudfront,
     :fn :update-cloud-front-origin-access-identity,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   update-cloud-front-origin-access-identity
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         if-match
                         id
                         cloud-front-origin-access-identity-config]}]]),
    :doc "Call updateCloudFrontOriginAccessIdentity"}
   [credentials2191 & args2192]
   (clojure.core/let
    [^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client2193
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials2191)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client2193
      updateCloudFrontOriginAccessIdentity
      (update-cloud-front-origin-access-identity-request
       (clojure.core/nth args2192 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :get-invalidation
   [m2194]
   (clojure.core/let
    [credentials2195 (:credentials m2194) args2196 (:args m2194)]
    (clojure.core/let
     [^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client2197
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials2195)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client2197
       getInvalidation
       (get-invalidation-request (clojure.core/nth args2196 0)))))))
  (clojure.core/defn
   get-invalidation-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector id distribution-id]}]]),
    :doc "Generate map for getInvalidation"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :cloudfront,
     :fn :get-invalidation,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   get-invalidation
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector id distribution-id]}]]),
    :doc "Call getInvalidation"}
   [credentials2199 & args2200]
   (clojure.core/let
    [^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client2201
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials2199)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client2201
      getInvalidation
      (get-invalidation-request (clojure.core/nth args2200 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :delete-streaming-distribution
   [m2202]
   (clojure.core/let
    [credentials2203 (:credentials m2202) args2204 (:args m2202)]
    (clojure.core/let
     [^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client2205
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials2203)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client2205
       deleteStreamingDistribution
       (delete-streaming-distribution-request
        (clojure.core/nth args2204 0)))))))
  (clojure.core/defn
   delete-streaming-distribution-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector if-match id]}]]),
    :doc "Generate map for deleteStreamingDistribution"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :cloudfront,
     :fn :delete-streaming-distribution,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   delete-streaming-distribution
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector if-match id]}]]),
    :doc "Call deleteStreamingDistribution"}
   [credentials2207 & args2208]
   (clojure.core/let
    [^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client2209
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials2207)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client2209
      deleteStreamingDistribution
      (delete-streaming-distribution-request
       (clojure.core/nth args2208 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :get-distribution
   [m2210]
   (clojure.core/let
    [credentials2211 (:credentials m2210) args2212 (:args m2210)]
    (clojure.core/let
     [^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client2213
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials2211)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client2213
       getDistribution
       (get-distribution-request (clojure.core/nth args2212 0)))))))
  (clojure.core/defn
   get-distribution-map
   {:arglists (quote
               [[credentials {:keys [request-metric-collector id]}]]),
    :doc "Generate map for getDistribution"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :cloudfront,
     :fn :get-distribution,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   get-distribution
   {:arglists (quote
               [[credentials {:keys [request-metric-collector id]}]]),
    :doc "Call getDistribution"}
   [credentials2215 & args2216]
   (clojure.core/let
    [^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client2217
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials2215)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client2217
      getDistribution
      (get-distribution-request (clojure.core/nth args2216 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :delete-cloud-front-origin-access-identity
   [m2218]
   (clojure.core/let
    [credentials2219 (:credentials m2218) args2220 (:args m2218)]
    (clojure.core/let
     [^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client2221
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials2219)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client2221
       deleteCloudFrontOriginAccessIdentity
       (delete-cloud-front-origin-access-identity-request
        (clojure.core/nth args2220 0)))))))
  (clojure.core/defn
   delete-cloud-front-origin-access-identity-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector if-match id]}]]),
    :doc "Generate map for deleteCloudFrontOriginAccessIdentity"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :cloudfront,
     :fn :delete-cloud-front-origin-access-identity,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   delete-cloud-front-origin-access-identity
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector if-match id]}]]),
    :doc "Call deleteCloudFrontOriginAccessIdentity"}
   [credentials2223 & args2224]
   (clojure.core/let
    [^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client2225
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials2223)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client2225
      deleteCloudFrontOriginAccessIdentity
      (delete-cloud-front-origin-access-identity-request
       (clojure.core/nth args2224 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :get-cloud-front-origin-access-identity
   [m2226]
   (clojure.core/let
    [credentials2227 (:credentials m2226) args2228 (:args m2226)]
    (clojure.core/let
     [^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client2229
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials2227)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client2229
       getCloudFrontOriginAccessIdentity
       (get-cloud-front-origin-access-identity-request
        (clojure.core/nth args2228 0)))))))
  (clojure.core/defn
   get-cloud-front-origin-access-identity-map
   {:arglists (quote
               [[credentials {:keys [request-metric-collector id]}]]),
    :doc "Generate map for getCloudFrontOriginAccessIdentity"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :cloudfront,
     :fn :get-cloud-front-origin-access-identity,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   get-cloud-front-origin-access-identity
   {:arglists (quote
               [[credentials {:keys [request-metric-collector id]}]]),
    :doc "Call getCloudFrontOriginAccessIdentity"}
   [credentials2231 & args2232]
   (clojure.core/let
    [^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client2233
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials2231)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.cloudfront.AmazonCloudFrontClient client2233
      getCloudFrontOriginAccessIdentity
      (get-cloud-front-origin-access-identity-request
       (clojure.core/nth args2232 0))))))))
