(ns
 com.palletops.awaze.cloudsearch
 (:require [com.palletops.awaze.common]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :cloudsearch
  [___1561__auto__
   ^com.amazonaws.auth.BasicAWSCredentials credentials__1562__auto__]
  (new
   com.amazonaws.services.cloudsearch.AmazonCloudSearchClient
   credentials__1562__auto__))
 (clojure.core/defn
  ^com.amazonaws.services.cloudsearch.model.SourceDataFunction source-data-function
  [m8151]
  (java.lang.Enum/valueOf
   com.amazonaws.services.cloudsearch.model.SourceDataFunction
   (clojure.core/name m8151)))
 (clojure.core/defn
  ^com.amazonaws.services.cloudsearch.model.SourceData source-data
  [m8154]
  (clojure.core/let
   [bean8153
    (new com.amazonaws.services.cloudsearch.model.SourceData)]
   (clojure.core/when-let
    [v8155 (:source-name m8154)]
    (. bean8153 setSourceName (clojure.core/str v8155)))
   (clojure.core/when-let
    [v8155 (:default-value m8154)]
    (. bean8153 setDefaultValue (clojure.core/str v8155)))
   bean8153))
 (clojure.core/defn
  ^com.amazonaws.services.cloudsearch.model.SourceDataTrimTitle source-data-trim-title
  [m8157]
  (clojure.core/let
   [bean8156
    (new com.amazonaws.services.cloudsearch.model.SourceDataTrimTitle)]
   (clojure.core/when-let
    [v8158 (:source-name m8157)]
    (. bean8156 setSourceName (clojure.core/str v8158)))
   (clojure.core/when-let
    [v8158 (:separator m8157)]
    (. bean8156 setSeparator (clojure.core/str v8158)))
   (clojure.core/when-let
    [v8158 (:language m8157)]
    (. bean8156 setLanguage (clojure.core/str v8158)))
   (clojure.core/when-let
    [v8158 (:default-value m8157)]
    (. bean8156 setDefaultValue (clojure.core/str v8158)))
   bean8156))
 (clojure.core/defn
  ^com.amazonaws.services.cloudsearch.model.SourceDataMap source-data-map
  [m8160]
  (clojure.core/let
   [bean8159
    (new com.amazonaws.services.cloudsearch.model.SourceDataMap)]
   (clojure.core/when-let
    [v8161 (:source-name m8160)]
    (. bean8159 setSourceName (clojure.core/str v8161)))
   (clojure.core/when-let
    [v8161 (:cases m8160)]
    (.
     bean8159
     setCases
     (clojure.core/zipmap
      (clojure.core/map
       (clojure.core/fn [arg8165] (clojure.core/str arg8165))
       (clojure.core/keys v8161))
      (clojure.core/map
       (clojure.core/fn [arg8165] (clojure.core/str arg8165))
       (clojure.core/vals v8161)))))
   (clojure.core/when-let
    [v8161 (:default-value m8160)]
    (. bean8159 setDefaultValue (clojure.core/str v8161)))
   bean8159))
 (clojure.core/defn
  ^com.amazonaws.services.cloudsearch.model.IndexFieldType index-field-type
  [m8163]
  (java.lang.Enum/valueOf
   com.amazonaws.services.cloudsearch.model.IndexFieldType
   (clojure.core/name m8163)))
 (clojure.core/defn
  ^com.amazonaws.services.cloudsearch.model.UIntOptions uint-options
  [m8167]
  (clojure.core/let
   [bean8166
    (new com.amazonaws.services.cloudsearch.model.UIntOptions)]
   (clojure.core/when-let
    [v8168 (:default-value m8167)]
    (. bean8166 setDefaultValue (clojure.core/int v8168)))
   bean8166))
 (clojure.core/defn
  ^com.amazonaws.services.cloudsearch.model.LiteralOptions literal-options
  [m8170]
  (clojure.core/let
   [bean8169
    (new com.amazonaws.services.cloudsearch.model.LiteralOptions)]
   (clojure.core/when-let
    [v8171 (:search-enabled m8170)]
    (. bean8169 setSearchEnabled (clojure.core/boolean v8171)))
   (clojure.core/when-let
    [v8171 (:facet-enabled m8170)]
    (. bean8169 setFacetEnabled (clojure.core/boolean v8171)))
   (clojure.core/when-let
    [v8171 (:result-enabled m8170)]
    (. bean8169 setResultEnabled (clojure.core/boolean v8171)))
   (clojure.core/when-let
    [v8171 (:default-value m8170)]
    (. bean8169 setDefaultValue (clojure.core/str v8171)))
   bean8169))
 (clojure.core/defn
  ^com.amazonaws.services.cloudsearch.model.TextOptions text-options
  [m8173]
  (clojure.core/let
   [bean8172
    (new com.amazonaws.services.cloudsearch.model.TextOptions)]
   (clojure.core/when-let
    [v8174 (:facet-enabled m8173)]
    (. bean8172 setFacetEnabled (clojure.core/boolean v8174)))
   (clojure.core/when-let
    [v8174 (:result-enabled m8173)]
    (. bean8172 setResultEnabled (clojure.core/boolean v8174)))
   (clojure.core/when-let
    [v8174 (:text-processor m8173)]
    (. bean8172 setTextProcessor (clojure.core/str v8174)))
   (clojure.core/when-let
    [v8174 (:default-value m8173)]
    (. bean8172 setDefaultValue (clojure.core/str v8174)))
   bean8172))
 (clojure.core/defn
  ^com.amazonaws.services.cloudsearch.model.SourceAttribute source-attribute
  [m8176]
  (clojure.core/let
   [bean8175
    (new com.amazonaws.services.cloudsearch.model.SourceAttribute)]
   (clojure.core/when-let
    [v8177 (:source-data-function m8176)]
    (. bean8175 setSourceDataFunction (clojure.core/str v8177)))
   (clojure.core/when-let
    [v8177 (:source-data-function m8176)]
    (. bean8175 setSourceDataFunction (source-data-function v8177)))
   (clojure.core/when-let
    [v8177 (:source-data-copy m8176)]
    (. bean8175 setSourceDataCopy (source-data v8177)))
   (clojure.core/when-let
    [v8177 (:source-data-trim-title m8176)]
    (. bean8175 setSourceDataTrimTitle (source-data-trim-title v8177)))
   (clojure.core/when-let
    [v8177 (:source-data-map m8176)]
    (. bean8175 setSourceDataMap (source-data-map v8177)))
   bean8175))
 (clojure.core/defn
  ^com.amazonaws.services.cloudsearch.model.IndexField index-field
  [m8179]
  (clojure.core/let
   [bean8178
    (new com.amazonaws.services.cloudsearch.model.IndexField)]
   (clojure.core/when-let
    [v8180 (:index-field-type m8179)]
    (. bean8178 setIndexFieldType (clojure.core/str v8180)))
   (clojure.core/when-let
    [v8180 (:index-field-type m8179)]
    (. bean8178 setIndexFieldType (index-field-type v8180)))
   (clojure.core/when-let
    [v8180 (:uint-options m8179)]
    (. bean8178 setUIntOptions (uint-options v8180)))
   (clojure.core/when-let
    [v8180 (:literal-options m8179)]
    (. bean8178 setLiteralOptions (literal-options v8180)))
   (clojure.core/when-let
    [v8180 (:text-options m8179)]
    (. bean8178 setTextOptions (text-options v8180)))
   (clojure.core/when-let
    [v8180 (:source-attributes m8179)]
    (.
     bean8178
     setSourceAttributes
     (clojure.core/map
      (clojure.core/fn [arg8184] (source-attribute arg8184))
      v8180)))
   (clojure.core/when-let
    [v8180 (:index-field-name m8179)]
    (. bean8178 setIndexFieldName (clojure.core/str v8180)))
   bean8178))
 (clojure.core/defn
  ^com.amazonaws.services.cloudsearch.model.NamedRankExpression named-rank-expression
  [m8182]
  (clojure.core/let
   [bean8181
    (new com.amazonaws.services.cloudsearch.model.NamedRankExpression)]
   (clojure.core/when-let
    [v8183 (:rank-name m8182)]
    (. bean8181 setRankName (clojure.core/str v8183)))
   (clojure.core/when-let
    [v8183 (:rank-expression m8182)]
    (. bean8181 setRankExpression (clojure.core/str v8183)))
   bean8181))
 (clojure.core/defn
  ^com.amazonaws.services.cloudsearch.model.UpdateDefaultSearchFieldRequest update-default-search-field-request
  [m8186]
  (clojure.core/let
   [bean8185
    (new
     com.amazonaws.services.cloudsearch.model.UpdateDefaultSearchFieldRequest)]
   (clojure.core/when-let
    [v8187 (:domain-name m8186)]
    (. bean8185 setDomainName (clojure.core/str v8187)))
   (clojure.core/when-let
    [v8187 (:default-search-field m8186)]
    (. bean8185 setDefaultSearchField (clojure.core/str v8187)))
   bean8185))
 (clojure.core/defn
  ^com.amazonaws.services.cloudsearch.model.DescribeServiceAccessPoliciesRequest describe-service-access-policies-request
  [m8189]
  (clojure.core/let
   [bean8188
    (new
     com.amazonaws.services.cloudsearch.model.DescribeServiceAccessPoliciesRequest)]
   (clojure.core/when-let
    [v8190 (:domain-name m8189)]
    (. bean8188 setDomainName (clojure.core/str v8190)))
   bean8188))
 (clojure.core/defn
  ^com.amazonaws.services.cloudsearch.model.DescribeDomainsRequest describe-domains-request
  [m8192]
  (clojure.core/let
   [bean8191
    (new
     com.amazonaws.services.cloudsearch.model.DescribeDomainsRequest)]
   (clojure.core/when-let
    [v8193 (:domain-names m8192)]
    (.
     bean8191
     setDomainNames
     (clojure.core/map
      (clojure.core/fn [arg8197] (clojure.core/str arg8197))
      v8193)))
   bean8191))
 (clojure.core/defn
  ^com.amazonaws.services.cloudsearch.model.DefineIndexFieldRequest define-index-field-request
  [m8195]
  (clojure.core/let
   [bean8194
    (new
     com.amazonaws.services.cloudsearch.model.DefineIndexFieldRequest)]
   (clojure.core/when-let
    [v8196 (:domain-name m8195)]
    (. bean8194 setDomainName (clojure.core/str v8196)))
   (clojure.core/when-let
    [v8196 (:index-field m8195)]
    (. bean8194 setIndexField (index-field v8196)))
   bean8194))
 (clojure.core/defn
  ^com.amazonaws.services.cloudsearch.model.DefineRankExpressionRequest define-rank-expression-request
  [m8199]
  (clojure.core/let
   [bean8198
    (new
     com.amazonaws.services.cloudsearch.model.DefineRankExpressionRequest)]
   (clojure.core/when-let
    [v8200 (:domain-name m8199)]
    (. bean8198 setDomainName (clojure.core/str v8200)))
   (clojure.core/when-let
    [v8200 (:rank-expression m8199)]
    (. bean8198 setRankExpression (named-rank-expression v8200)))
   bean8198))
 (clojure.core/defn
  ^com.amazonaws.services.cloudsearch.model.UpdateStopwordOptionsRequest update-stopword-options-request
  [m8202]
  (clojure.core/let
   [bean8201
    (new
     com.amazonaws.services.cloudsearch.model.UpdateStopwordOptionsRequest)]
   (clojure.core/when-let
    [v8203 (:domain-name m8202)]
    (. bean8201 setDomainName (clojure.core/str v8203)))
   (clojure.core/when-let
    [v8203 (:stopwords m8202)]
    (. bean8201 setStopwords (clojure.core/str v8203)))
   bean8201))
 (clojure.core/defn
  ^com.amazonaws.services.cloudsearch.model.DeleteRankExpressionRequest delete-rank-expression-request
  [m8205]
  (clojure.core/let
   [bean8204
    (new
     com.amazonaws.services.cloudsearch.model.DeleteRankExpressionRequest)]
   (clojure.core/when-let
    [v8206 (:rank-name m8205)]
    (. bean8204 setRankName (clojure.core/str v8206)))
   (clojure.core/when-let
    [v8206 (:domain-name m8205)]
    (. bean8204 setDomainName (clojure.core/str v8206)))
   bean8204))
 (clojure.core/defn
  ^com.amazonaws.services.cloudsearch.model.DescribeDefaultSearchFieldRequest describe-default-search-field-request
  [m8208]
  (clojure.core/let
   [bean8207
    (new
     com.amazonaws.services.cloudsearch.model.DescribeDefaultSearchFieldRequest)]
   (clojure.core/when-let
    [v8209 (:domain-name m8208)]
    (. bean8207 setDomainName (clojure.core/str v8209)))
   bean8207))
 (clojure.core/defn
  ^com.amazonaws.services.cloudsearch.model.CreateDomainRequest create-domain-request
  [m8211]
  (clojure.core/let
   [bean8210
    (new com.amazonaws.services.cloudsearch.model.CreateDomainRequest)]
   (clojure.core/when-let
    [v8212 (:domain-name m8211)]
    (. bean8210 setDomainName (clojure.core/str v8212)))
   bean8210))
 (clojure.core/defn
  ^com.amazonaws.services.cloudsearch.model.DescribeStemmingOptionsRequest describe-stemming-options-request
  [m8214]
  (clojure.core/let
   [bean8213
    (new
     com.amazonaws.services.cloudsearch.model.DescribeStemmingOptionsRequest)]
   (clojure.core/when-let
    [v8215 (:domain-name m8214)]
    (. bean8213 setDomainName (clojure.core/str v8215)))
   bean8213))
 (clojure.core/defn
  ^com.amazonaws.services.cloudsearch.model.DescribeIndexFieldsRequest describe-index-fields-request
  [m8217]
  (clojure.core/let
   [bean8216
    (new
     com.amazonaws.services.cloudsearch.model.DescribeIndexFieldsRequest)]
   (clojure.core/when-let
    [v8218 (:domain-name m8217)]
    (. bean8216 setDomainName (clojure.core/str v8218)))
   (clojure.core/when-let
    [v8218 (:field-names m8217)]
    (.
     bean8216
     setFieldNames
     (clojure.core/map
      (clojure.core/fn [arg8222] (clojure.core/str arg8222))
      v8218)))
   bean8216))
 (clojure.core/defn
  ^com.amazonaws.services.cloudsearch.model.DeleteIndexFieldRequest delete-index-field-request
  [m8220]
  (clojure.core/let
   [bean8219
    (new
     com.amazonaws.services.cloudsearch.model.DeleteIndexFieldRequest)]
   (clojure.core/when-let
    [v8221 (:domain-name m8220)]
    (. bean8219 setDomainName (clojure.core/str v8221)))
   (clojure.core/when-let
    [v8221 (:index-field-name m8220)]
    (. bean8219 setIndexFieldName (clojure.core/str v8221)))
   bean8219))
 (clojure.core/defn
  ^com.amazonaws.services.cloudsearch.model.DescribeStopwordOptionsRequest describe-stopword-options-request
  [m8224]
  (clojure.core/let
   [bean8223
    (new
     com.amazonaws.services.cloudsearch.model.DescribeStopwordOptionsRequest)]
   (clojure.core/when-let
    [v8225 (:domain-name m8224)]
    (. bean8223 setDomainName (clojure.core/str v8225)))
   bean8223))
 (clojure.core/defn
  ^com.amazonaws.services.cloudsearch.model.DescribeSynonymOptionsRequest describe-synonym-options-request
  [m8227]
  (clojure.core/let
   [bean8226
    (new
     com.amazonaws.services.cloudsearch.model.DescribeSynonymOptionsRequest)]
   (clojure.core/when-let
    [v8228 (:domain-name m8227)]
    (. bean8226 setDomainName (clojure.core/str v8228)))
   bean8226))
 (clojure.core/defn
  ^com.amazonaws.services.cloudsearch.model.UpdateSynonymOptionsRequest update-synonym-options-request
  [m8230]
  (clojure.core/let
   [bean8229
    (new
     com.amazonaws.services.cloudsearch.model.UpdateSynonymOptionsRequest)]
   (clojure.core/when-let
    [v8231 (:domain-name m8230)]
    (. bean8229 setDomainName (clojure.core/str v8231)))
   (clojure.core/when-let
    [v8231 (:synonyms m8230)]
    (. bean8229 setSynonyms (clojure.core/str v8231)))
   bean8229))
 (clojure.core/defn
  ^com.amazonaws.services.cloudsearch.model.DeleteDomainRequest delete-domain-request
  [m8233]
  (clojure.core/let
   [bean8232
    (new com.amazonaws.services.cloudsearch.model.DeleteDomainRequest)]
   (clojure.core/when-let
    [v8234 (:domain-name m8233)]
    (. bean8232 setDomainName (clojure.core/str v8234)))
   bean8232))
 (clojure.core/defn
  ^com.amazonaws.services.cloudsearch.model.DescribeRankExpressionsRequest describe-rank-expressions-request
  [m8236]
  (clojure.core/let
   [bean8235
    (new
     com.amazonaws.services.cloudsearch.model.DescribeRankExpressionsRequest)]
   (clojure.core/when-let
    [v8237 (:domain-name m8236)]
    (. bean8235 setDomainName (clojure.core/str v8237)))
   (clojure.core/when-let
    [v8237 (:rank-names m8236)]
    (.
     bean8235
     setRankNames
     (clojure.core/map
      (clojure.core/fn [arg8241] (clojure.core/str arg8241))
      v8237)))
   bean8235))
 (clojure.core/defn
  ^com.amazonaws.services.cloudsearch.model.IndexDocumentsRequest index-documents-request
  [m8239]
  (clojure.core/let
   [bean8238
    (new
     com.amazonaws.services.cloudsearch.model.IndexDocumentsRequest)]
   (clojure.core/when-let
    [v8240 (:domain-name m8239)]
    (. bean8238 setDomainName (clojure.core/str v8240)))
   bean8238))
 (clojure.core/defn
  ^com.amazonaws.services.cloudsearch.model.UpdateServiceAccessPoliciesRequest update-service-access-policies-request
  [m8243]
  (clojure.core/let
   [bean8242
    (new
     com.amazonaws.services.cloudsearch.model.UpdateServiceAccessPoliciesRequest)]
   (clojure.core/when-let
    [v8244 (:domain-name m8243)]
    (. bean8242 setDomainName (clojure.core/str v8244)))
   (clojure.core/when-let
    [v8244 (:access-policies m8243)]
    (. bean8242 setAccessPolicies (clojure.core/str v8244)))
   bean8242))
 (clojure.core/defn
  ^com.amazonaws.services.cloudsearch.model.UpdateStemmingOptionsRequest update-stemming-options-request
  [m8246]
  (clojure.core/let
   [bean8245
    (new
     com.amazonaws.services.cloudsearch.model.UpdateStemmingOptionsRequest)]
   (clojure.core/when-let
    [v8247 (:domain-name m8246)]
    (. bean8245 setDomainName (clojure.core/str v8247)))
   (clojure.core/when-let
    [v8247 (:stems m8246)]
    (. bean8245 setStems (clojure.core/str v8247)))
   bean8245))
 (clojure.core/defmulti
  cloudsearch
  (clojure.core/fn
   cloudsearch
   [m__1641__auto__]
   (:fn m__1641__auto__)))
 (do
  (clojure.core/defmethod
   cloudsearch
   :update-default-search-field
   [m8248]
   (clojure.core/let
    [credentials8249 (:credentials m8248) args8250 (:args m8248)]
    (clojure.core/let
     [^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client8251
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials8249)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client8251
       updateDefaultSearchField
       (update-default-search-field-request
        (clojure.core/nth args8250 0)))))))
  (clojure.core/defn
   update-default-search-field-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         domain-name
                         default-search-field]}]]),
    :doc "Generate map for updateDefaultSearchField"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :cloudsearch,
     :fn :update-default-search-field,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   update-default-search-field
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         domain-name
                         default-search-field]}]]),
    :doc "Call updateDefaultSearchField"}
   [credentials8253 & args8254]
   (clojure.core/let
    [^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client8255
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials8253)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client8255
      updateDefaultSearchField
      (update-default-search-field-request
       (clojure.core/nth args8254 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :describe-service-access-policies
   [m8256]
   (clojure.core/let
    [credentials8257 (:credentials m8256) args8258 (:args m8256)]
    (clojure.core/let
     [^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client8259
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials8257)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client8259
       describeServiceAccessPolicies
       (describe-service-access-policies-request
        (clojure.core/nth args8258 0)))))))
  (clojure.core/defn
   describe-service-access-policies-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector domain-name]}]]),
    :doc "Generate map for describeServiceAccessPolicies"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :cloudsearch,
     :fn :describe-service-access-policies,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-service-access-policies
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector domain-name]}]]),
    :doc "Call describeServiceAccessPolicies"}
   [credentials8261 & args8262]
   (clojure.core/let
    [^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client8263
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials8261)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client8263
      describeServiceAccessPolicies
      (describe-service-access-policies-request
       (clojure.core/nth args8262 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :describe-domains
   [m8264]
   (clojure.core/let
    [credentials8265 (:credentials m8264) args8266 (:args m8264)]
    (clojure.core/let
     [^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client8267
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials8265)]
     (clojure.core/case
      (clojure.core/count args8266)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client8267
        describeDomains
        (describe-domains-request (clojure.core/nth args8266 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client8267
        describeDomains))))))
  (clojure.core/defn
   describe-domains-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector domain-names]}]
                [credentials]]),
    :doc "Generate map for describeDomains, describeDomains"}
   ([credentials__1609__auto__]
    {:args [],
     :client :cloudsearch,
     :fn :describe-domains,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :cloudsearch,
     :fn :describe-domains,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-domains
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector domain-names]}]
                [credentials]]),
    :doc "Call describeDomains, describeDomains"}
   [credentials8269 & args8270]
   (clojure.core/let
    [^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client8271
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials8269)]
    (clojure.core/case
     (clojure.core/count args8270)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client8271
       describeDomains
       (describe-domains-request (clojure.core/nth args8270 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client8271
       describeDomains))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :define-index-field
   [m8272]
   (clojure.core/let
    [credentials8273 (:credentials m8272) args8274 (:args m8272)]
    (clojure.core/let
     [^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client8275
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials8273)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client8275
       defineIndexField
       (define-index-field-request (clojure.core/nth args8274 0)))))))
  (clojure.core/defn
   define-index-field-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         index-field
                         domain-name]}]]),
    :doc "Generate map for defineIndexField"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :cloudsearch,
     :fn :define-index-field,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   define-index-field
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         index-field
                         domain-name]}]]),
    :doc "Call defineIndexField"}
   [credentials8277 & args8278]
   (clojure.core/let
    [^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client8279
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials8277)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client8279
      defineIndexField
      (define-index-field-request (clojure.core/nth args8278 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :define-rank-expression
   [m8280]
   (clojure.core/let
    [credentials8281 (:credentials m8280) args8282 (:args m8280)]
    (clojure.core/let
     [^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client8283
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials8281)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client8283
       defineRankExpression
       (define-rank-expression-request (clojure.core/nth args8282 0)))))))
  (clojure.core/defn
   define-rank-expression-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         rank-expression
                         domain-name]}]]),
    :doc "Generate map for defineRankExpression"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :cloudsearch,
     :fn :define-rank-expression,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   define-rank-expression
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         rank-expression
                         domain-name]}]]),
    :doc "Call defineRankExpression"}
   [credentials8285 & args8286]
   (clojure.core/let
    [^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client8287
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials8285)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client8287
      defineRankExpression
      (define-rank-expression-request (clojure.core/nth args8286 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :update-stopword-options
   [m8288]
   (clojure.core/let
    [credentials8289 (:credentials m8288) args8290 (:args m8288)]
    (clojure.core/let
     [^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client8291
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials8289)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client8291
       updateStopwordOptions
       (update-stopword-options-request (clojure.core/nth args8290 0)))))))
  (clojure.core/defn
   update-stopword-options-map
   {:arglists (quote
               [[credentials
                 {:keys [stopwords
                         request-metric-collector
                         domain-name]}]]),
    :doc "Generate map for updateStopwordOptions"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :cloudsearch,
     :fn :update-stopword-options,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   update-stopword-options
   {:arglists (quote
               [[credentials
                 {:keys [stopwords
                         request-metric-collector
                         domain-name]}]]),
    :doc "Call updateStopwordOptions"}
   [credentials8293 & args8294]
   (clojure.core/let
    [^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client8295
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials8293)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client8295
      updateStopwordOptions
      (update-stopword-options-request (clojure.core/nth args8294 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :delete-rank-expression
   [m8296]
   (clojure.core/let
    [credentials8297 (:credentials m8296) args8298 (:args m8296)]
    (clojure.core/let
     [^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client8299
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials8297)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client8299
       deleteRankExpression
       (delete-rank-expression-request (clojure.core/nth args8298 0)))))))
  (clojure.core/defn
   delete-rank-expression-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         rank-name
                         domain-name]}]]),
    :doc "Generate map for deleteRankExpression"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :cloudsearch,
     :fn :delete-rank-expression,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   delete-rank-expression
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         rank-name
                         domain-name]}]]),
    :doc "Call deleteRankExpression"}
   [credentials8301 & args8302]
   (clojure.core/let
    [^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client8303
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials8301)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client8303
      deleteRankExpression
      (delete-rank-expression-request (clojure.core/nth args8302 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :describe-default-search-field
   [m8304]
   (clojure.core/let
    [credentials8305 (:credentials m8304) args8306 (:args m8304)]
    (clojure.core/let
     [^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client8307
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials8305)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client8307
       describeDefaultSearchField
       (describe-default-search-field-request
        (clojure.core/nth args8306 0)))))))
  (clojure.core/defn
   describe-default-search-field-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector domain-name]}]]),
    :doc "Generate map for describeDefaultSearchField"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :cloudsearch,
     :fn :describe-default-search-field,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-default-search-field
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector domain-name]}]]),
    :doc "Call describeDefaultSearchField"}
   [credentials8309 & args8310]
   (clojure.core/let
    [^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client8311
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials8309)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client8311
      describeDefaultSearchField
      (describe-default-search-field-request
       (clojure.core/nth args8310 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :create-domain
   [m8312]
   (clojure.core/let
    [credentials8313 (:credentials m8312) args8314 (:args m8312)]
    (clojure.core/let
     [^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client8315
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials8313)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client8315
       createDomain
       (create-domain-request (clojure.core/nth args8314 0)))))))
  (clojure.core/defn
   create-domain-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector domain-name]}]]),
    :doc "Generate map for createDomain"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :cloudsearch,
     :fn :create-domain,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   create-domain
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector domain-name]}]]),
    :doc "Call createDomain"}
   [credentials8317 & args8318]
   (clojure.core/let
    [^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client8319
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials8317)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client8319
      createDomain
      (create-domain-request (clojure.core/nth args8318 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :describe-stemming-options
   [m8320]
   (clojure.core/let
    [credentials8321 (:credentials m8320) args8322 (:args m8320)]
    (clojure.core/let
     [^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client8323
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials8321)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client8323
       describeStemmingOptions
       (describe-stemming-options-request
        (clojure.core/nth args8322 0)))))))
  (clojure.core/defn
   describe-stemming-options-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector domain-name]}]]),
    :doc "Generate map for describeStemmingOptions"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :cloudsearch,
     :fn :describe-stemming-options,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-stemming-options
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector domain-name]}]]),
    :doc "Call describeStemmingOptions"}
   [credentials8325 & args8326]
   (clojure.core/let
    [^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client8327
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials8325)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client8327
      describeStemmingOptions
      (describe-stemming-options-request
       (clojure.core/nth args8326 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :describe-index-fields
   [m8328]
   (clojure.core/let
    [credentials8329 (:credentials m8328) args8330 (:args m8328)]
    (clojure.core/let
     [^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client8331
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials8329)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client8331
       describeIndexFields
       (describe-index-fields-request (clojure.core/nth args8330 0)))))))
  (clojure.core/defn
   describe-index-fields-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         field-names
                         domain-name]}]]),
    :doc "Generate map for describeIndexFields"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :cloudsearch,
     :fn :describe-index-fields,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-index-fields
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         field-names
                         domain-name]}]]),
    :doc "Call describeIndexFields"}
   [credentials8333 & args8334]
   (clojure.core/let
    [^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client8335
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials8333)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client8335
      describeIndexFields
      (describe-index-fields-request (clojure.core/nth args8334 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :delete-index-field
   [m8336]
   (clojure.core/let
    [credentials8337 (:credentials m8336) args8338 (:args m8336)]
    (clojure.core/let
     [^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client8339
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials8337)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client8339
       deleteIndexField
       (delete-index-field-request (clojure.core/nth args8338 0)))))))
  (clojure.core/defn
   delete-index-field-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         index-field-name
                         domain-name]}]]),
    :doc "Generate map for deleteIndexField"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :cloudsearch,
     :fn :delete-index-field,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   delete-index-field
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         index-field-name
                         domain-name]}]]),
    :doc "Call deleteIndexField"}
   [credentials8341 & args8342]
   (clojure.core/let
    [^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client8343
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials8341)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client8343
      deleteIndexField
      (delete-index-field-request (clojure.core/nth args8342 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :describe-stopword-options
   [m8344]
   (clojure.core/let
    [credentials8345 (:credentials m8344) args8346 (:args m8344)]
    (clojure.core/let
     [^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client8347
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials8345)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client8347
       describeStopwordOptions
       (describe-stopword-options-request
        (clojure.core/nth args8346 0)))))))
  (clojure.core/defn
   describe-stopword-options-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector domain-name]}]]),
    :doc "Generate map for describeStopwordOptions"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :cloudsearch,
     :fn :describe-stopword-options,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-stopword-options
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector domain-name]}]]),
    :doc "Call describeStopwordOptions"}
   [credentials8349 & args8350]
   (clojure.core/let
    [^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client8351
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials8349)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client8351
      describeStopwordOptions
      (describe-stopword-options-request
       (clojure.core/nth args8350 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :describe-synonym-options
   [m8352]
   (clojure.core/let
    [credentials8353 (:credentials m8352) args8354 (:args m8352)]
    (clojure.core/let
     [^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client8355
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials8353)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client8355
       describeSynonymOptions
       (describe-synonym-options-request
        (clojure.core/nth args8354 0)))))))
  (clojure.core/defn
   describe-synonym-options-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector domain-name]}]]),
    :doc "Generate map for describeSynonymOptions"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :cloudsearch,
     :fn :describe-synonym-options,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-synonym-options
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector domain-name]}]]),
    :doc "Call describeSynonymOptions"}
   [credentials8357 & args8358]
   (clojure.core/let
    [^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client8359
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials8357)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client8359
      describeSynonymOptions
      (describe-synonym-options-request (clojure.core/nth args8358 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :update-synonym-options
   [m8360]
   (clojure.core/let
    [credentials8361 (:credentials m8360) args8362 (:args m8360)]
    (clojure.core/let
     [^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client8363
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials8361)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client8363
       updateSynonymOptions
       (update-synonym-options-request (clojure.core/nth args8362 0)))))))
  (clojure.core/defn
   update-synonym-options-map
   {:arglists (quote
               [[credentials
                 {:keys [synonyms
                         request-metric-collector
                         domain-name]}]]),
    :doc "Generate map for updateSynonymOptions"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :cloudsearch,
     :fn :update-synonym-options,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   update-synonym-options
   {:arglists (quote
               [[credentials
                 {:keys [synonyms
                         request-metric-collector
                         domain-name]}]]),
    :doc "Call updateSynonymOptions"}
   [credentials8365 & args8366]
   (clojure.core/let
    [^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client8367
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials8365)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client8367
      updateSynonymOptions
      (update-synonym-options-request (clojure.core/nth args8366 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :delete-domain
   [m8368]
   (clojure.core/let
    [credentials8369 (:credentials m8368) args8370 (:args m8368)]
    (clojure.core/let
     [^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client8371
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials8369)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client8371
       deleteDomain
       (delete-domain-request (clojure.core/nth args8370 0)))))))
  (clojure.core/defn
   delete-domain-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector domain-name]}]]),
    :doc "Generate map for deleteDomain"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :cloudsearch,
     :fn :delete-domain,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   delete-domain
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector domain-name]}]]),
    :doc "Call deleteDomain"}
   [credentials8373 & args8374]
   (clojure.core/let
    [^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client8375
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials8373)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client8375
      deleteDomain
      (delete-domain-request (clojure.core/nth args8374 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :describe-rank-expressions
   [m8376]
   (clojure.core/let
    [credentials8377 (:credentials m8376) args8378 (:args m8376)]
    (clojure.core/let
     [^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client8379
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials8377)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client8379
       describeRankExpressions
       (describe-rank-expressions-request
        (clojure.core/nth args8378 0)))))))
  (clojure.core/defn
   describe-rank-expressions-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         rank-names
                         domain-name]}]]),
    :doc "Generate map for describeRankExpressions"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :cloudsearch,
     :fn :describe-rank-expressions,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-rank-expressions
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         rank-names
                         domain-name]}]]),
    :doc "Call describeRankExpressions"}
   [credentials8381 & args8382]
   (clojure.core/let
    [^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client8383
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials8381)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client8383
      describeRankExpressions
      (describe-rank-expressions-request
       (clojure.core/nth args8382 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :index-documents
   [m8384]
   (clojure.core/let
    [credentials8385 (:credentials m8384) args8386 (:args m8384)]
    (clojure.core/let
     [^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client8387
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials8385)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client8387
       indexDocuments
       (index-documents-request (clojure.core/nth args8386 0)))))))
  (clojure.core/defn
   index-documents-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector domain-name]}]]),
    :doc "Generate map for indexDocuments"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :cloudsearch,
     :fn :index-documents,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   index-documents
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector domain-name]}]]),
    :doc "Call indexDocuments"}
   [credentials8389 & args8390]
   (clojure.core/let
    [^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client8391
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials8389)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client8391
      indexDocuments
      (index-documents-request (clojure.core/nth args8390 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :update-service-access-policies
   [m8392]
   (clojure.core/let
    [credentials8393 (:credentials m8392) args8394 (:args m8392)]
    (clojure.core/let
     [^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client8395
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials8393)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client8395
       updateServiceAccessPolicies
       (update-service-access-policies-request
        (clojure.core/nth args8394 0)))))))
  (clojure.core/defn
   update-service-access-policies-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         domain-name
                         access-policies]}]]),
    :doc "Generate map for updateServiceAccessPolicies"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :cloudsearch,
     :fn :update-service-access-policies,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   update-service-access-policies
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         domain-name
                         access-policies]}]]),
    :doc "Call updateServiceAccessPolicies"}
   [credentials8397 & args8398]
   (clojure.core/let
    [^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client8399
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials8397)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client8399
      updateServiceAccessPolicies
      (update-service-access-policies-request
       (clojure.core/nth args8398 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :update-stemming-options
   [m8400]
   (clojure.core/let
    [credentials8401 (:credentials m8400) args8402 (:args m8400)]
    (clojure.core/let
     [^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client8403
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials8401)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client8403
       updateStemmingOptions
       (update-stemming-options-request (clojure.core/nth args8402 0)))))))
  (clojure.core/defn
   update-stemming-options-map
   {:arglists (quote
               [[credentials
                 {:keys [stems request-metric-collector domain-name]}]]),
    :doc "Generate map for updateStemmingOptions"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :cloudsearch,
     :fn :update-stemming-options,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   update-stemming-options
   {:arglists (quote
               [[credentials
                 {:keys [stems request-metric-collector domain-name]}]]),
    :doc "Call updateStemmingOptions"}
   [credentials8405 & args8406]
   (clojure.core/let
    [^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client8407
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials8405)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.cloudsearch.AmazonCloudSearchClient client8407
      updateStemmingOptions
      (update-stemming-options-request (clojure.core/nth args8406 0))))))))
