(ns
 com.palletops.awaze.cloudwatch
 (:require [com.palletops.awaze.common]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :cloudwatch
  [___1561__auto__
   ^com.amazonaws.auth.BasicAWSCredentials credentials__1562__auto__]
  (new
   com.amazonaws.services.cloudwatch.AmazonCloudWatchClient
   credentials__1562__auto__))
 (clojure.core/defn
  ^com.amazonaws.services.cloudwatch.model.Dimension dimension
  [m8409]
  (clojure.core/let
   [bean8408 (new com.amazonaws.services.cloudwatch.model.Dimension)]
   (clojure.core/when-let
    [v8410 (:name m8409)]
    (. bean8408 setName (clojure.core/str v8410)))
   (clojure.core/when-let
    [v8410 (:value m8409)]
    (. bean8408 setValue (clojure.core/str v8410)))
   bean8408))
 (clojure.core/defn
  ^com.amazonaws.services.cloudwatch.model.StandardUnit standard-unit
  [m8412]
  (java.lang.Enum/valueOf
   com.amazonaws.services.cloudwatch.model.StandardUnit
   (clojure.core/name m8412)))
 (clojure.core/defn
  ^com.amazonaws.services.cloudwatch.model.StatisticSet statistic-set
  [m8415]
  (clojure.core/let
   [bean8414
    (new com.amazonaws.services.cloudwatch.model.StatisticSet)]
   (clojure.core/when-let
    [v8416 (:sample-count m8415)]
    (. bean8414 setSampleCount (clojure.core/double v8416)))
   (clojure.core/when-let
    [v8416 (:sum m8415)]
    (. bean8414 setSum (clojure.core/double v8416)))
   (clojure.core/when-let
    [v8416 (:minimum m8415)]
    (. bean8414 setMinimum (clojure.core/double v8416)))
   (clojure.core/when-let
    [v8416 (:maximum m8415)]
    (. bean8414 setMaximum (clojure.core/double v8416)))
   bean8414))
 (clojure.core/defn
  ^com.amazonaws.services.cloudwatch.model.Statistic statistic
  [m8418]
  (java.lang.Enum/valueOf
   com.amazonaws.services.cloudwatch.model.Statistic
   (clojure.core/name m8418)))
 (clojure.core/defn
  ^com.amazonaws.services.cloudwatch.model.ComparisonOperator comparison-operator
  [m8421]
  (java.lang.Enum/valueOf
   com.amazonaws.services.cloudwatch.model.ComparisonOperator
   (clojure.core/name m8421)))
 (clojure.core/defn
  ^com.amazonaws.services.cloudwatch.model.HistoryItemType history-item-type
  [m8424]
  (java.lang.Enum/valueOf
   com.amazonaws.services.cloudwatch.model.HistoryItemType
   (clojure.core/name m8424)))
 (clojure.core/defn
  ^com.amazonaws.services.cloudwatch.model.StateValue state-value
  [m8427]
  (java.lang.Enum/valueOf
   com.amazonaws.services.cloudwatch.model.StateValue
   (clojure.core/name m8427)))
 (clojure.core/defn
  ^com.amazonaws.services.cloudwatch.model.DimensionFilter dimension-filter
  [m8430]
  (clojure.core/let
   [bean8429
    (new com.amazonaws.services.cloudwatch.model.DimensionFilter)]
   (clojure.core/when-let
    [v8431 (:name m8430)]
    (. bean8429 setName (clojure.core/str v8431)))
   (clojure.core/when-let
    [v8431 (:value m8430)]
    (. bean8429 setValue (clojure.core/str v8431)))
   bean8429))
 (clojure.core/defn
  ^com.amazonaws.services.cloudwatch.model.MetricDatum metric-datum
  [m8433]
  (clojure.core/let
   [bean8432
    (new com.amazonaws.services.cloudwatch.model.MetricDatum)]
   (clojure.core/when-let
    [v8434 (:value m8433)]
    (. bean8432 setValue (clojure.core/double v8434)))
   (clojure.core/when-let
    [v8434 (:timestamp m8433)]
    (.
     bean8432
     setTimestamp
     (com.palletops.awaze.common/to-date v8434)))
   (clojure.core/when-let
    [v8434 (:metric-name m8433)]
    (. bean8432 setMetricName (clojure.core/str v8434)))
   (clojure.core/when-let
    [v8434 (:dimensions m8433)]
    (.
     bean8432
     setDimensions
     (clojure.core/map
      (clojure.core/fn [arg8438] (dimension arg8438))
      v8434)))
   (clojure.core/when-let
    [v8434 (:unit m8433)]
    (. bean8432 setUnit (standard-unit v8434)))
   (clojure.core/when-let
    [v8434 (:unit m8433)]
    (. bean8432 setUnit (clojure.core/str v8434)))
   (clojure.core/when-let
    [v8434 (:statistic-values m8433)]
    (. bean8432 setStatisticValues (statistic-set v8434)))
   bean8432))
 (clojure.core/defn
  ^com.amazonaws.services.cloudwatch.model.PutMetricAlarmRequest put-metric-alarm-request
  [m8436]
  (clojure.core/let
   [bean8435
    (new
     com.amazonaws.services.cloudwatch.model.PutMetricAlarmRequest)]
   (clojure.core/when-let
    [v8437 (:threshold m8436)]
    (. bean8435 setThreshold (clojure.core/double v8437)))
   (clojure.core/when-let
    [v8437 (:alarm-name m8436)]
    (. bean8435 setAlarmName (clojure.core/str v8437)))
   (clojure.core/when-let
    [v8437 (:alarm-description m8436)]
    (. bean8435 setAlarmDescription (clojure.core/str v8437)))
   (clojure.core/when-let
    [v8437 (:actions-enabled m8436)]
    (. bean8435 setActionsEnabled (clojure.core/boolean v8437)))
   (clojure.core/when-let
    [v8437 (:okactions m8436)]
    (.
     bean8435
     setOKActions
     (clojure.core/map
      (clojure.core/fn [arg8442] (clojure.core/str arg8442))
      v8437)))
   (clojure.core/when-let
    [v8437 (:alarm-actions m8436)]
    (.
     bean8435
     setAlarmActions
     (clojure.core/map
      (clojure.core/fn [arg8443] (clojure.core/str arg8443))
      v8437)))
   (clojure.core/when-let
    [v8437 (:insufficient-data-actions m8436)]
    (.
     bean8435
     setInsufficientDataActions
     (clojure.core/map
      (clojure.core/fn [arg8444] (clojure.core/str arg8444))
      v8437)))
   (clojure.core/when-let
    [v8437 (:metric-name m8436)]
    (. bean8435 setMetricName (clojure.core/str v8437)))
   (clojure.core/when-let
    [v8437 (:statistic m8436)]
    (. bean8435 setStatistic (clojure.core/str v8437)))
   (clojure.core/when-let
    [v8437 (:statistic m8436)]
    (. bean8435 setStatistic (statistic v8437)))
   (clojure.core/when-let
    [v8437 (:dimensions m8436)]
    (.
     bean8435
     setDimensions
     (clojure.core/map
      (clojure.core/fn [arg8445] (dimension arg8445))
      v8437)))
   (clojure.core/when-let
    [v8437 (:period m8436)]
    (. bean8435 setPeriod (clojure.core/int v8437)))
   (clojure.core/when-let
    [v8437 (:unit m8436)]
    (. bean8435 setUnit (standard-unit v8437)))
   (clojure.core/when-let
    [v8437 (:unit m8436)]
    (. bean8435 setUnit (clojure.core/str v8437)))
   (clojure.core/when-let
    [v8437 (:evaluation-periods m8436)]
    (. bean8435 setEvaluationPeriods (clojure.core/int v8437)))
   (clojure.core/when-let
    [v8437 (:comparison-operator m8436)]
    (. bean8435 setComparisonOperator (clojure.core/str v8437)))
   (clojure.core/when-let
    [v8437 (:comparison-operator m8436)]
    (. bean8435 setComparisonOperator (comparison-operator v8437)))
   (clojure.core/when-let
    [v8437 (:namespace m8436)]
    (. bean8435 setNamespace (clojure.core/str v8437)))
   bean8435))
 (clojure.core/defn
  ^com.amazonaws.services.cloudwatch.model.DescribeAlarmHistoryRequest describe-alarm-history-request
  [m8440]
  (clojure.core/let
   [bean8439
    (new
     com.amazonaws.services.cloudwatch.model.DescribeAlarmHistoryRequest)]
   (clojure.core/when-let
    [v8441 (:alarm-name m8440)]
    (. bean8439 setAlarmName (clojure.core/str v8441)))
   (clojure.core/when-let
    [v8441 (:next-token m8440)]
    (. bean8439 setNextToken (clojure.core/str v8441)))
   (clojure.core/when-let
    [v8441 (:history-item-type m8440)]
    (. bean8439 setHistoryItemType (clojure.core/str v8441)))
   (clojure.core/when-let
    [v8441 (:history-item-type m8440)]
    (. bean8439 setHistoryItemType (history-item-type v8441)))
   (clojure.core/when-let
    [v8441 (:start-date m8440)]
    (.
     bean8439
     setStartDate
     (com.palletops.awaze.common/to-date v8441)))
   (clojure.core/when-let
    [v8441 (:end-date m8440)]
    (. bean8439 setEndDate (com.palletops.awaze.common/to-date v8441)))
   (clojure.core/when-let
    [v8441 (:max-records m8440)]
    (. bean8439 setMaxRecords (clojure.core/int v8441)))
   bean8439))
 (clojure.core/defn
  ^com.amazonaws.services.cloudwatch.model.SetAlarmStateRequest set-alarm-state-request
  [m8447]
  (clojure.core/let
   [bean8446
    (new com.amazonaws.services.cloudwatch.model.SetAlarmStateRequest)]
   (clojure.core/when-let
    [v8448 (:alarm-name m8447)]
    (. bean8446 setAlarmName (clojure.core/str v8448)))
   (clojure.core/when-let
    [v8448 (:state-value m8447)]
    (. bean8446 setStateValue (state-value v8448)))
   (clojure.core/when-let
    [v8448 (:state-value m8447)]
    (. bean8446 setStateValue (clojure.core/str v8448)))
   (clojure.core/when-let
    [v8448 (:state-reason m8447)]
    (. bean8446 setStateReason (clojure.core/str v8448)))
   (clojure.core/when-let
    [v8448 (:state-reason-data m8447)]
    (. bean8446 setStateReasonData (clojure.core/str v8448)))
   bean8446))
 (clojure.core/defn
  ^com.amazonaws.services.cloudwatch.model.ListMetricsRequest list-metrics-request
  [m8450]
  (clojure.core/let
   [bean8449
    (new com.amazonaws.services.cloudwatch.model.ListMetricsRequest)]
   (clojure.core/when-let
    [v8451 (:metric-name m8450)]
    (. bean8449 setMetricName (clojure.core/str v8451)))
   (clojure.core/when-let
    [v8451 (:dimensions m8450)]
    (.
     bean8449
     setDimensions
     (clojure.core/map
      (clojure.core/fn [arg8455] (dimension-filter arg8455))
      v8451)))
   (clojure.core/when-let
    [v8451 (:next-token m8450)]
    (. bean8449 setNextToken (clojure.core/str v8451)))
   (clojure.core/when-let
    [v8451 (:namespace m8450)]
    (. bean8449 setNamespace (clojure.core/str v8451)))
   bean8449))
 (clojure.core/defn
  ^com.amazonaws.services.cloudwatch.model.GetMetricStatisticsRequest get-metric-statistics-request
  [m8453]
  (clojure.core/let
   [bean8452
    (new
     com.amazonaws.services.cloudwatch.model.GetMetricStatisticsRequest)]
   (clojure.core/when-let
    [v8454 (:metric-name m8453)]
    (. bean8452 setMetricName (clojure.core/str v8454)))
   (clojure.core/when-let
    [v8454 (:dimensions m8453)]
    (.
     bean8452
     setDimensions
     (clojure.core/map
      (clojure.core/fn [arg8459] (dimension arg8459))
      v8454)))
   (clojure.core/when-let
    [v8454 (:period m8453)]
    (. bean8452 setPeriod (clojure.core/int v8454)))
   (clojure.core/when-let
    [v8454 (:unit m8453)]
    (. bean8452 setUnit (clojure.core/str v8454)))
   (clojure.core/when-let
    [v8454 (:unit m8453)]
    (. bean8452 setUnit (standard-unit v8454)))
   (clojure.core/when-let
    [v8454 (:statistics m8453)]
    (.
     bean8452
     setStatistics
     (clojure.core/map
      (clojure.core/fn [arg8460] (clojure.core/str arg8460))
      v8454)))
   (clojure.core/when-let
    [v8454 (:start-time m8453)]
    (.
     bean8452
     setStartTime
     (com.palletops.awaze.common/to-date v8454)))
   (clojure.core/when-let
    [v8454 (:end-time m8453)]
    (. bean8452 setEndTime (com.palletops.awaze.common/to-date v8454)))
   (clojure.core/when-let
    [v8454 (:namespace m8453)]
    (. bean8452 setNamespace (clojure.core/str v8454)))
   bean8452))
 (clojure.core/defn
  ^com.amazonaws.services.cloudwatch.model.DisableAlarmActionsRequest disable-alarm-actions-request
  [m8457]
  (clojure.core/let
   [bean8456
    (new
     com.amazonaws.services.cloudwatch.model.DisableAlarmActionsRequest)]
   (clojure.core/when-let
    [v8458 (:alarm-names m8457)]
    (.
     bean8456
     setAlarmNames
     (clojure.core/map
      (clojure.core/fn [arg8464] (clojure.core/str arg8464))
      v8458)))
   bean8456))
 (clojure.core/defn
  ^com.amazonaws.services.cloudwatch.model.EnableAlarmActionsRequest enable-alarm-actions-request
  [m8462]
  (clojure.core/let
   [bean8461
    (new
     com.amazonaws.services.cloudwatch.model.EnableAlarmActionsRequest)]
   (clojure.core/when-let
    [v8463 (:alarm-names m8462)]
    (.
     bean8461
     setAlarmNames
     (clojure.core/map
      (clojure.core/fn [arg8468] (clojure.core/str arg8468))
      v8463)))
   bean8461))
 (clojure.core/defn
  ^com.amazonaws.services.cloudwatch.model.PutMetricDataRequest put-metric-data-request
  [m8466]
  (clojure.core/let
   [bean8465
    (new com.amazonaws.services.cloudwatch.model.PutMetricDataRequest)]
   (clojure.core/when-let
    [v8467 (:metric-data m8466)]
    (.
     bean8465
     setMetricData
     (clojure.core/map
      (clojure.core/fn [arg8472] (metric-datum arg8472))
      v8467)))
   (clojure.core/when-let
    [v8467 (:namespace m8466)]
    (. bean8465 setNamespace (clojure.core/str v8467)))
   bean8465))
 (clojure.core/defn
  ^com.amazonaws.services.cloudwatch.model.DescribeAlarmsForMetricRequest describe-alarms-for-metric-request
  [m8470]
  (clojure.core/let
   [bean8469
    (new
     com.amazonaws.services.cloudwatch.model.DescribeAlarmsForMetricRequest)]
   (clojure.core/when-let
    [v8471 (:metric-name m8470)]
    (. bean8469 setMetricName (clojure.core/str v8471)))
   (clojure.core/when-let
    [v8471 (:statistic m8470)]
    (. bean8469 setStatistic (statistic v8471)))
   (clojure.core/when-let
    [v8471 (:statistic m8470)]
    (. bean8469 setStatistic (clojure.core/str v8471)))
   (clojure.core/when-let
    [v8471 (:dimensions m8470)]
    (.
     bean8469
     setDimensions
     (clojure.core/map
      (clojure.core/fn [arg8476] (dimension arg8476))
      v8471)))
   (clojure.core/when-let
    [v8471 (:period m8470)]
    (. bean8469 setPeriod (clojure.core/int v8471)))
   (clojure.core/when-let
    [v8471 (:unit m8470)]
    (. bean8469 setUnit (standard-unit v8471)))
   (clojure.core/when-let
    [v8471 (:unit m8470)]
    (. bean8469 setUnit (clojure.core/str v8471)))
   (clojure.core/when-let
    [v8471 (:namespace m8470)]
    (. bean8469 setNamespace (clojure.core/str v8471)))
   bean8469))
 (clojure.core/defn
  ^com.amazonaws.services.cloudwatch.model.DescribeAlarmsRequest describe-alarms-request
  [m8474]
  (clojure.core/let
   [bean8473
    (new
     com.amazonaws.services.cloudwatch.model.DescribeAlarmsRequest)]
   (clojure.core/when-let
    [v8475 (:alarm-names m8474)]
    (.
     bean8473
     setAlarmNames
     (clojure.core/map
      (clojure.core/fn [arg8480] (clojure.core/str arg8480))
      v8475)))
   (clojure.core/when-let
    [v8475 (:alarm-name-prefix m8474)]
    (. bean8473 setAlarmNamePrefix (clojure.core/str v8475)))
   (clojure.core/when-let
    [v8475 (:state-value m8474)]
    (. bean8473 setStateValue (clojure.core/str v8475)))
   (clojure.core/when-let
    [v8475 (:state-value m8474)]
    (. bean8473 setStateValue (state-value v8475)))
   (clojure.core/when-let
    [v8475 (:action-prefix m8474)]
    (. bean8473 setActionPrefix (clojure.core/str v8475)))
   (clojure.core/when-let
    [v8475 (:next-token m8474)]
    (. bean8473 setNextToken (clojure.core/str v8475)))
   (clojure.core/when-let
    [v8475 (:max-records m8474)]
    (. bean8473 setMaxRecords (clojure.core/int v8475)))
   bean8473))
 (clojure.core/defn
  ^com.amazonaws.services.cloudwatch.model.DeleteAlarmsRequest delete-alarms-request
  [m8478]
  (clojure.core/let
   [bean8477
    (new com.amazonaws.services.cloudwatch.model.DeleteAlarmsRequest)]
   (clojure.core/when-let
    [v8479 (:alarm-names m8478)]
    (.
     bean8477
     setAlarmNames
     (clojure.core/map
      (clojure.core/fn [arg8481] (clojure.core/str arg8481))
      v8479)))
   bean8477))
 (clojure.core/defmulti
  cloudwatch
  (clojure.core/fn cloudwatch [m__1641__auto__] (:fn m__1641__auto__)))
 (do
  (clojure.core/defmethod
   cloudwatch
   :put-metric-alarm
   [m8482]
   (clojure.core/let
    [credentials8483 (:credentials m8482) args8484 (:args m8482)]
    (clojure.core/let
     [^com.amazonaws.services.cloudwatch.AmazonCloudWatchClient client8485
      (com.palletops.awaze.common/aws-client
       :cloudwatch
       credentials8483)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudwatch.AmazonCloudWatchClient client8485
       putMetricAlarm
       (put-metric-alarm-request (clojure.core/nth args8484 0)))))))
  (clojure.core/defn
   put-metric-alarm-map
   {:arglists (quote
               [[credentials
                 {:keys [period
                         evaluation-periods
                         request-metric-collector
                         metric-name
                         namespace
                         insufficient-data-actions
                         alarm-actions
                         threshold
                         alarm-description
                         comparison-operator
                         statistic
                         alarm-name
                         unit
                         okactions
                         dimensions
                         actions-enabled]}]]),
    :doc "Generate map for putMetricAlarm"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :cloudwatch,
     :fn :put-metric-alarm,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   put-metric-alarm
   {:arglists (quote
               [[credentials
                 {:keys [period
                         evaluation-periods
                         request-metric-collector
                         metric-name
                         namespace
                         insufficient-data-actions
                         alarm-actions
                         threshold
                         alarm-description
                         comparison-operator
                         statistic
                         alarm-name
                         unit
                         okactions
                         dimensions
                         actions-enabled]}]]),
    :doc "Call putMetricAlarm"}
   [credentials8487 & args8488]
   (clojure.core/let
    [^com.amazonaws.services.cloudwatch.AmazonCloudWatchClient client8489
     (com.palletops.awaze.common/aws-client
      :cloudwatch
      credentials8487)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.cloudwatch.AmazonCloudWatchClient client8489
      putMetricAlarm
      (put-metric-alarm-request (clojure.core/nth args8488 0)))))))
 (do
  (clojure.core/defmethod
   cloudwatch
   :describe-alarm-history
   [m8490]
   (clojure.core/let
    [credentials8491 (:credentials m8490) args8492 (:args m8490)]
    (clojure.core/let
     [^com.amazonaws.services.cloudwatch.AmazonCloudWatchClient client8493
      (com.palletops.awaze.common/aws-client
       :cloudwatch
       credentials8491)]
     (clojure.core/case
      (clojure.core/count args8492)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.cloudwatch.AmazonCloudWatchClient client8493
        describeAlarmHistory))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.cloudwatch.AmazonCloudWatchClient client8493
        describeAlarmHistory
        (describe-alarm-history-request (clojure.core/nth args8492 0))))))))
  (clojure.core/defn
   describe-alarm-history-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [alarm-name
                         history-item-type
                         max-records
                         start-date
                         next-token
                         request-metric-collector
                         end-date]}]]),
    :doc "Generate map for describeAlarmHistory, describeAlarmHistory"}
   ([credentials__1609__auto__]
    {:args [],
     :client :cloudwatch,
     :fn :describe-alarm-history,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :cloudwatch,
     :fn :describe-alarm-history,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-alarm-history
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [alarm-name
                         history-item-type
                         max-records
                         start-date
                         next-token
                         request-metric-collector
                         end-date]}]]),
    :doc "Call describeAlarmHistory, describeAlarmHistory"}
   [credentials8495 & args8496]
   (clojure.core/let
    [^com.amazonaws.services.cloudwatch.AmazonCloudWatchClient client8497
     (com.palletops.awaze.common/aws-client
      :cloudwatch
      credentials8495)]
    (clojure.core/case
     (clojure.core/count args8496)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudwatch.AmazonCloudWatchClient client8497
       describeAlarmHistory))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudwatch.AmazonCloudWatchClient client8497
       describeAlarmHistory
       (describe-alarm-history-request (clojure.core/nth args8496 0))))))))
 (do
  (clojure.core/defmethod
   cloudwatch
   :set-alarm-state
   [m8498]
   (clojure.core/let
    [credentials8499 (:credentials m8498) args8500 (:args m8498)]
    (clojure.core/let
     [^com.amazonaws.services.cloudwatch.AmazonCloudWatchClient client8501
      (com.palletops.awaze.common/aws-client
       :cloudwatch
       credentials8499)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudwatch.AmazonCloudWatchClient client8501
       setAlarmState
       (set-alarm-state-request (clojure.core/nth args8500 0)))))))
  (clojure.core/defn
   set-alarm-state-map
   {:arglists (quote
               [[credentials
                 {:keys [state-value
                         state-reason-data
                         state-reason
                         request-metric-collector
                         alarm-name]}]]),
    :doc "Generate map for setAlarmState"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :cloudwatch,
     :fn :set-alarm-state,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   set-alarm-state
   {:arglists (quote
               [[credentials
                 {:keys [state-value
                         state-reason-data
                         state-reason
                         request-metric-collector
                         alarm-name]}]]),
    :doc "Call setAlarmState"}
   [credentials8503 & args8504]
   (clojure.core/let
    [^com.amazonaws.services.cloudwatch.AmazonCloudWatchClient client8505
     (com.palletops.awaze.common/aws-client
      :cloudwatch
      credentials8503)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.cloudwatch.AmazonCloudWatchClient client8505
      setAlarmState
      (set-alarm-state-request (clojure.core/nth args8504 0)))))))
 (do
  (clojure.core/defmethod
   cloudwatch
   :list-metrics
   [m8506]
   (clojure.core/let
    [credentials8507 (:credentials m8506) args8508 (:args m8506)]
    (clojure.core/let
     [^com.amazonaws.services.cloudwatch.AmazonCloudWatchClient client8509
      (com.palletops.awaze.common/aws-client
       :cloudwatch
       credentials8507)]
     (clojure.core/case
      (clojure.core/count args8508)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.cloudwatch.AmazonCloudWatchClient client8509
        listMetrics
        (list-metrics-request (clojure.core/nth args8508 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.cloudwatch.AmazonCloudWatchClient client8509
        listMetrics))))))
  (clojure.core/defn
   list-metrics-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         next-token
                         namespace
                         metric-name
                         dimensions]}]
                [credentials]]),
    :doc "Generate map for listMetrics, listMetrics"}
   ([credentials__1609__auto__]
    {:args [],
     :client :cloudwatch,
     :fn :list-metrics,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :cloudwatch,
     :fn :list-metrics,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   list-metrics
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         next-token
                         namespace
                         metric-name
                         dimensions]}]
                [credentials]]),
    :doc "Call listMetrics, listMetrics"}
   [credentials8511 & args8512]
   (clojure.core/let
    [^com.amazonaws.services.cloudwatch.AmazonCloudWatchClient client8513
     (com.palletops.awaze.common/aws-client
      :cloudwatch
      credentials8511)]
    (clojure.core/case
     (clojure.core/count args8512)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudwatch.AmazonCloudWatchClient client8513
       listMetrics
       (list-metrics-request (clojure.core/nth args8512 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudwatch.AmazonCloudWatchClient client8513
       listMetrics))))))
 (do
  (clojure.core/defmethod
   cloudwatch
   :get-metric-statistics
   [m8514]
   (clojure.core/let
    [credentials8515 (:credentials m8514) args8516 (:args m8514)]
    (clojure.core/let
     [^com.amazonaws.services.cloudwatch.AmazonCloudWatchClient client8517
      (com.palletops.awaze.common/aws-client
       :cloudwatch
       credentials8515)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudwatch.AmazonCloudWatchClient client8517
       getMetricStatistics
       (get-metric-statistics-request (clojure.core/nth args8516 0)))))))
  (clojure.core/defn
   get-metric-statistics-map
   {:arglists (quote
               [[credentials
                 {:keys [end-time
                         period
                         request-metric-collector
                         metric-name
                         namespace
                         start-time
                         unit
                         dimensions
                         statistics]}]]),
    :doc "Generate map for getMetricStatistics"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :cloudwatch,
     :fn :get-metric-statistics,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   get-metric-statistics
   {:arglists (quote
               [[credentials
                 {:keys [end-time
                         period
                         request-metric-collector
                         metric-name
                         namespace
                         start-time
                         unit
                         dimensions
                         statistics]}]]),
    :doc "Call getMetricStatistics"}
   [credentials8519 & args8520]
   (clojure.core/let
    [^com.amazonaws.services.cloudwatch.AmazonCloudWatchClient client8521
     (com.palletops.awaze.common/aws-client
      :cloudwatch
      credentials8519)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.cloudwatch.AmazonCloudWatchClient client8521
      getMetricStatistics
      (get-metric-statistics-request (clojure.core/nth args8520 0)))))))
 (do
  (clojure.core/defmethod
   cloudwatch
   :disable-alarm-actions
   [m8522]
   (clojure.core/let
    [credentials8523 (:credentials m8522) args8524 (:args m8522)]
    (clojure.core/let
     [^com.amazonaws.services.cloudwatch.AmazonCloudWatchClient client8525
      (com.palletops.awaze.common/aws-client
       :cloudwatch
       credentials8523)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudwatch.AmazonCloudWatchClient client8525
       disableAlarmActions
       (disable-alarm-actions-request (clojure.core/nth args8524 0)))))))
  (clojure.core/defn
   disable-alarm-actions-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector alarm-names]}]]),
    :doc "Generate map for disableAlarmActions"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :cloudwatch,
     :fn :disable-alarm-actions,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   disable-alarm-actions
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector alarm-names]}]]),
    :doc "Call disableAlarmActions"}
   [credentials8527 & args8528]
   (clojure.core/let
    [^com.amazonaws.services.cloudwatch.AmazonCloudWatchClient client8529
     (com.palletops.awaze.common/aws-client
      :cloudwatch
      credentials8527)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.cloudwatch.AmazonCloudWatchClient client8529
      disableAlarmActions
      (disable-alarm-actions-request (clojure.core/nth args8528 0)))))))
 (do
  (clojure.core/defmethod
   cloudwatch
   :enable-alarm-actions
   [m8530]
   (clojure.core/let
    [credentials8531 (:credentials m8530) args8532 (:args m8530)]
    (clojure.core/let
     [^com.amazonaws.services.cloudwatch.AmazonCloudWatchClient client8533
      (com.palletops.awaze.common/aws-client
       :cloudwatch
       credentials8531)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudwatch.AmazonCloudWatchClient client8533
       enableAlarmActions
       (enable-alarm-actions-request (clojure.core/nth args8532 0)))))))
  (clojure.core/defn
   enable-alarm-actions-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector alarm-names]}]]),
    :doc "Generate map for enableAlarmActions"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :cloudwatch,
     :fn :enable-alarm-actions,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   enable-alarm-actions
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector alarm-names]}]]),
    :doc "Call enableAlarmActions"}
   [credentials8535 & args8536]
   (clojure.core/let
    [^com.amazonaws.services.cloudwatch.AmazonCloudWatchClient client8537
     (com.palletops.awaze.common/aws-client
      :cloudwatch
      credentials8535)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.cloudwatch.AmazonCloudWatchClient client8537
      enableAlarmActions
      (enable-alarm-actions-request (clojure.core/nth args8536 0)))))))
 (do
  (clojure.core/defmethod
   cloudwatch
   :put-metric-data
   [m8538]
   (clojure.core/let
    [credentials8539 (:credentials m8538) args8540 (:args m8538)]
    (clojure.core/let
     [^com.amazonaws.services.cloudwatch.AmazonCloudWatchClient client8541
      (com.palletops.awaze.common/aws-client
       :cloudwatch
       credentials8539)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudwatch.AmazonCloudWatchClient client8541
       putMetricData
       (put-metric-data-request (clojure.core/nth args8540 0)))))))
  (clojure.core/defn
   put-metric-data-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         namespace
                         metric-data]}]]),
    :doc "Generate map for putMetricData"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :cloudwatch,
     :fn :put-metric-data,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   put-metric-data
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         namespace
                         metric-data]}]]),
    :doc "Call putMetricData"}
   [credentials8543 & args8544]
   (clojure.core/let
    [^com.amazonaws.services.cloudwatch.AmazonCloudWatchClient client8545
     (com.palletops.awaze.common/aws-client
      :cloudwatch
      credentials8543)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.cloudwatch.AmazonCloudWatchClient client8545
      putMetricData
      (put-metric-data-request (clojure.core/nth args8544 0)))))))
 (do
  (clojure.core/defmethod
   cloudwatch
   :describe-alarms-for-metric
   [m8546]
   (clojure.core/let
    [credentials8547 (:credentials m8546) args8548 (:args m8546)]
    (clojure.core/let
     [^com.amazonaws.services.cloudwatch.AmazonCloudWatchClient client8549
      (com.palletops.awaze.common/aws-client
       :cloudwatch
       credentials8547)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudwatch.AmazonCloudWatchClient client8549
       describeAlarmsForMetric
       (describe-alarms-for-metric-request
        (clojure.core/nth args8548 0)))))))
  (clojure.core/defn
   describe-alarms-for-metric-map
   {:arglists (quote
               [[credentials
                 {:keys [dimensions
                         unit
                         statistic
                         namespace
                         metric-name
                         request-metric-collector
                         period]}]]),
    :doc "Generate map for describeAlarmsForMetric"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :cloudwatch,
     :fn :describe-alarms-for-metric,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-alarms-for-metric
   {:arglists (quote
               [[credentials
                 {:keys [dimensions
                         unit
                         statistic
                         namespace
                         metric-name
                         request-metric-collector
                         period]}]]),
    :doc "Call describeAlarmsForMetric"}
   [credentials8551 & args8552]
   (clojure.core/let
    [^com.amazonaws.services.cloudwatch.AmazonCloudWatchClient client8553
     (com.palletops.awaze.common/aws-client
      :cloudwatch
      credentials8551)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.cloudwatch.AmazonCloudWatchClient client8553
      describeAlarmsForMetric
      (describe-alarms-for-metric-request
       (clojure.core/nth args8552 0)))))))
 (do
  (clojure.core/defmethod
   cloudwatch
   :describe-alarms
   [m8554]
   (clojure.core/let
    [credentials8555 (:credentials m8554) args8556 (:args m8554)]
    (clojure.core/let
     [^com.amazonaws.services.cloudwatch.AmazonCloudWatchClient client8557
      (com.palletops.awaze.common/aws-client
       :cloudwatch
       credentials8555)]
     (clojure.core/case
      (clojure.core/count args8556)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.cloudwatch.AmazonCloudWatchClient client8557
        describeAlarms))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.cloudwatch.AmazonCloudWatchClient client8557
        describeAlarms
        (describe-alarms-request (clojure.core/nth args8556 0))))))))
  (clojure.core/defn
   describe-alarms-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [alarm-names
                         action-prefix
                         max-records
                         state-value
                         next-token
                         alarm-name-prefix
                         request-metric-collector]}]]),
    :doc "Generate map for describeAlarms, describeAlarms"}
   ([credentials__1609__auto__]
    {:args [],
     :client :cloudwatch,
     :fn :describe-alarms,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :cloudwatch,
     :fn :describe-alarms,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-alarms
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [alarm-names
                         action-prefix
                         max-records
                         state-value
                         next-token
                         alarm-name-prefix
                         request-metric-collector]}]]),
    :doc "Call describeAlarms, describeAlarms"}
   [credentials8559 & args8560]
   (clojure.core/let
    [^com.amazonaws.services.cloudwatch.AmazonCloudWatchClient client8561
     (com.palletops.awaze.common/aws-client
      :cloudwatch
      credentials8559)]
    (clojure.core/case
     (clojure.core/count args8560)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudwatch.AmazonCloudWatchClient client8561
       describeAlarms))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudwatch.AmazonCloudWatchClient client8561
       describeAlarms
       (describe-alarms-request (clojure.core/nth args8560 0))))))))
 (do
  (clojure.core/defmethod
   cloudwatch
   :delete-alarms
   [m8562]
   (clojure.core/let
    [credentials8563 (:credentials m8562) args8564 (:args m8562)]
    (clojure.core/let
     [^com.amazonaws.services.cloudwatch.AmazonCloudWatchClient client8565
      (com.palletops.awaze.common/aws-client
       :cloudwatch
       credentials8563)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.cloudwatch.AmazonCloudWatchClient client8565
       deleteAlarms
       (delete-alarms-request (clojure.core/nth args8564 0)))))))
  (clojure.core/defn
   delete-alarms-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector alarm-names]}]]),
    :doc "Generate map for deleteAlarms"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :cloudwatch,
     :fn :delete-alarms,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   delete-alarms
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector alarm-names]}]]),
    :doc "Call deleteAlarms"}
   [credentials8567 & args8568]
   (clojure.core/let
    [^com.amazonaws.services.cloudwatch.AmazonCloudWatchClient client8569
     (com.palletops.awaze.common/aws-client
      :cloudwatch
      credentials8567)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.cloudwatch.AmazonCloudWatchClient client8569
      deleteAlarms
      (delete-alarms-request (clojure.core/nth args8568 0))))))))
