(ns
 com.palletops.awaze.datapipeline
 (:require [com.palletops.awaze.common]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :datapipeline
  [___1561__auto__
   ^com.amazonaws.auth.BasicAWSCredentials credentials__1562__auto__]
  (new
   com.amazonaws.services.datapipeline.DataPipelineClient
   credentials__1562__auto__))
 (clojure.core/defn
  ^com.amazonaws.services.datapipeline.model.OperatorType operator-type
  [m8976]
  (java.lang.Enum/valueOf
   com.amazonaws.services.datapipeline.model.OperatorType
   (clojure.core/name m8976)))
 (clojure.core/defn
  ^com.amazonaws.services.datapipeline.model.Operator operator
  [m8979]
  (clojure.core/let
   [bean8978 (new com.amazonaws.services.datapipeline.model.Operator)]
   (clojure.core/when-let
    [v8980 (:values m8979)]
    (.
     bean8978
     setValues
     (clojure.core/map
      (clojure.core/fn [arg8984] (clojure.core/str arg8984))
      v8980)))
   (clojure.core/when-let
    [v8980 (:type m8979)]
    (. bean8978 setType (clojure.core/str v8980)))
   (clojure.core/when-let
    [v8980 (:type m8979)]
    (. bean8978 setType (operator-type v8980)))
   bean8978))
 (clojure.core/defn
  ^com.amazonaws.services.datapipeline.model.Selector selector
  [m8982]
  (clojure.core/let
   [bean8981 (new com.amazonaws.services.datapipeline.model.Selector)]
   (clojure.core/when-let
    [v8983 (:field-name m8982)]
    (. bean8981 setFieldName (clojure.core/str v8983)))
   (clojure.core/when-let
    [v8983 (:operator m8982)]
    (. bean8981 setOperator (operator v8983)))
   bean8981))
 (clojure.core/defn
  ^com.amazonaws.services.datapipeline.model.Field field
  [m8986]
  (clojure.core/let
   [bean8985 (new com.amazonaws.services.datapipeline.model.Field)]
   (clojure.core/when-let
    [v8987 (:string-value m8986)]
    (. bean8985 setStringValue (clojure.core/str v8987)))
   (clojure.core/when-let
    [v8987 (:ref-value m8986)]
    (. bean8985 setRefValue (clojure.core/str v8987)))
   (clojure.core/when-let
    [v8987 (:key m8986)]
    (. bean8985 setKey (clojure.core/str v8987)))
   bean8985))
 (clojure.core/defn
  ^com.amazonaws.services.datapipeline.model.Query query
  [m8989]
  (clojure.core/let
   [bean8988 (new com.amazonaws.services.datapipeline.model.Query)]
   (clojure.core/when-let
    [v8990 (:selectors m8989)]
    (.
     bean8988
     setSelectors
     (clojure.core/map
      (clojure.core/fn [arg8994] (selector arg8994))
      v8990)))
   bean8988))
 (clojure.core/defn
  ^com.amazonaws.services.datapipeline.model.InstanceIdentity instance-identity
  [m8992]
  (clojure.core/let
   [bean8991
    (new com.amazonaws.services.datapipeline.model.InstanceIdentity)]
   (clojure.core/when-let
    [v8993 (:document m8992)]
    (. bean8991 setDocument (clojure.core/str v8993)))
   (clojure.core/when-let
    [v8993 (:signature m8992)]
    (. bean8991 setSignature (clojure.core/str v8993)))
   bean8991))
 (clojure.core/defn
  ^com.amazonaws.services.datapipeline.model.PipelineObject pipeline-object
  [m8996]
  (clojure.core/let
   [bean8995
    (new com.amazonaws.services.datapipeline.model.PipelineObject)]
   (clojure.core/when-let
    [v8997 (:name m8996)]
    (. bean8995 setName (clojure.core/str v8997)))
   (clojure.core/when-let
    [v8997 (:id m8996)]
    (. bean8995 setId (clojure.core/str v8997)))
   (clojure.core/when-let
    [v8997 (:fields m8996)]
    (.
     bean8995
     setFields
     (clojure.core/map
      (clojure.core/fn [arg9001] (field arg9001))
      v8997)))
   bean8995))
 (clojure.core/defn
  ^com.amazonaws.services.datapipeline.model.TaskStatus task-status
  [m8999]
  (java.lang.Enum/valueOf
   com.amazonaws.services.datapipeline.model.TaskStatus
   (clojure.core/name m8999)))
 (clojure.core/defn
  ^com.amazonaws.services.datapipeline.model.DescribeObjectsRequest describe-objects-request
  [m9003]
  (clojure.core/let
   [bean9002
    (new
     com.amazonaws.services.datapipeline.model.DescribeObjectsRequest)]
   (clojure.core/when-let
    [v9004 (:marker m9003)]
    (. bean9002 setMarker (clojure.core/str v9004)))
   (clojure.core/when-let
    [v9004 (:pipeline-id m9003)]
    (. bean9002 setPipelineId (clojure.core/str v9004)))
   (clojure.core/when-let
    [v9004 (:object-ids m9003)]
    (.
     bean9002
     setObjectIds
     (clojure.core/map
      (clojure.core/fn [arg9008] (clojure.core/str arg9008))
      v9004)))
   (clojure.core/when-let
    [v9004 (:evaluate-expressions m9003)]
    (. bean9002 setEvaluateExpressions (clojure.core/boolean v9004)))
   bean9002))
 (clojure.core/defn
  ^com.amazonaws.services.datapipeline.model.ReportTaskRunnerHeartbeatRequest report-task-runner-heartbeat-request
  [m9006]
  (clojure.core/let
   [bean9005
    (new
     com.amazonaws.services.datapipeline.model.ReportTaskRunnerHeartbeatRequest)]
   (clojure.core/when-let
    [v9007 (:taskrunner-id m9006)]
    (. bean9005 setTaskrunnerId (clojure.core/str v9007)))
   (clojure.core/when-let
    [v9007 (:worker-group m9006)]
    (. bean9005 setWorkerGroup (clojure.core/str v9007)))
   (clojure.core/when-let
    [v9007 (:hostname m9006)]
    (. bean9005 setHostname (clojure.core/str v9007)))
   bean9005))
 (clojure.core/defn
  ^com.amazonaws.services.datapipeline.model.QueryObjectsRequest query-objects-request
  [m9010]
  (clojure.core/let
   [bean9009
    (new
     com.amazonaws.services.datapipeline.model.QueryObjectsRequest)]
   (clojure.core/when-let
    [v9011 (:marker m9010)]
    (. bean9009 setMarker (clojure.core/str v9011)))
   (clojure.core/when-let
    [v9011 (:pipeline-id m9010)]
    (. bean9009 setPipelineId (clojure.core/str v9011)))
   (clojure.core/when-let
    [v9011 (:query m9010)]
    (. bean9009 setQuery (query v9011)))
   (clojure.core/when-let
    [v9011 (:sphere m9010)]
    (. bean9009 setSphere (clojure.core/str v9011)))
   (clojure.core/when-let
    [v9011 (:limit m9010)]
    (. bean9009 setLimit (clojure.core/int v9011)))
   bean9009))
 (clojure.core/defn
  ^com.amazonaws.services.datapipeline.model.DescribePipelinesRequest describe-pipelines-request
  [m9013]
  (clojure.core/let
   [bean9012
    (new
     com.amazonaws.services.datapipeline.model.DescribePipelinesRequest)]
   (clojure.core/when-let
    [v9014 (:pipeline-ids m9013)]
    (.
     bean9012
     setPipelineIds
     (clojure.core/map
      (clojure.core/fn [arg9018] (clojure.core/str arg9018))
      v9014)))
   bean9012))
 (clojure.core/defn
  ^com.amazonaws.services.datapipeline.model.ActivatePipelineRequest activate-pipeline-request
  [m9016]
  (clojure.core/let
   [bean9015
    (new
     com.amazonaws.services.datapipeline.model.ActivatePipelineRequest)]
   (clojure.core/when-let
    [v9017 (:pipeline-id m9016)]
    (. bean9015 setPipelineId (clojure.core/str v9017)))
   bean9015))
 (clojure.core/defn
  ^com.amazonaws.services.datapipeline.model.SetStatusRequest set-status-request
  [m9020]
  (clojure.core/let
   [bean9019
    (new com.amazonaws.services.datapipeline.model.SetStatusRequest)]
   (clojure.core/when-let
    [v9021 (:pipeline-id m9020)]
    (. bean9019 setPipelineId (clojure.core/str v9021)))
   (clojure.core/when-let
    [v9021 (:object-ids m9020)]
    (.
     bean9019
     setObjectIds
     (clojure.core/map
      (clojure.core/fn [arg9025] (clojure.core/str arg9025))
      v9021)))
   (clojure.core/when-let
    [v9021 (:status m9020)]
    (. bean9019 setStatus (clojure.core/str v9021)))
   bean9019))
 (clojure.core/defn
  ^com.amazonaws.services.datapipeline.model.GetPipelineDefinitionRequest get-pipeline-definition-request
  [m9023]
  (clojure.core/let
   [bean9022
    (new
     com.amazonaws.services.datapipeline.model.GetPipelineDefinitionRequest)]
   (clojure.core/when-let
    [v9024 (:pipeline-id m9023)]
    (. bean9022 setPipelineId (clojure.core/str v9024)))
   (clojure.core/when-let
    [v9024 (:version m9023)]
    (. bean9022 setVersion (clojure.core/str v9024)))
   bean9022))
 (clojure.core/defn
  ^com.amazonaws.services.datapipeline.model.PollForTaskRequest poll-for-task-request
  [m9027]
  (clojure.core/let
   [bean9026
    (new com.amazonaws.services.datapipeline.model.PollForTaskRequest)]
   (clojure.core/when-let
    [v9028 (:worker-group m9027)]
    (. bean9026 setWorkerGroup (clojure.core/str v9028)))
   (clojure.core/when-let
    [v9028 (:hostname m9027)]
    (. bean9026 setHostname (clojure.core/str v9028)))
   (clojure.core/when-let
    [v9028 (:instance-identity m9027)]
    (. bean9026 setInstanceIdentity (instance-identity v9028)))
   bean9026))
 (clojure.core/defn
  ^com.amazonaws.services.datapipeline.model.ReportTaskProgressRequest report-task-progress-request
  [m9030]
  (clojure.core/let
   [bean9029
    (new
     com.amazonaws.services.datapipeline.model.ReportTaskProgressRequest)]
   (clojure.core/when-let
    [v9031 (:task-id m9030)]
    (. bean9029 setTaskId (clojure.core/str v9031)))
   bean9029))
 (clojure.core/defn
  ^com.amazonaws.services.datapipeline.model.DeletePipelineRequest delete-pipeline-request
  [m9033]
  (clojure.core/let
   [bean9032
    (new
     com.amazonaws.services.datapipeline.model.DeletePipelineRequest)]
   (clojure.core/when-let
    [v9034 (:pipeline-id m9033)]
    (. bean9032 setPipelineId (clojure.core/str v9034)))
   bean9032))
 (clojure.core/defn
  ^com.amazonaws.services.datapipeline.model.CreatePipelineRequest create-pipeline-request
  [m9036]
  (clojure.core/let
   [bean9035
    (new
     com.amazonaws.services.datapipeline.model.CreatePipelineRequest)]
   (clojure.core/when-let
    [v9037 (:name m9036)]
    (. bean9035 setName (clojure.core/str v9037)))
   (clojure.core/when-let
    [v9037 (:unique-id m9036)]
    (. bean9035 setUniqueId (clojure.core/str v9037)))
   (clojure.core/when-let
    [v9037 (:description m9036)]
    (. bean9035 setDescription (clojure.core/str v9037)))
   bean9035))
 (clojure.core/defn
  ^com.amazonaws.services.datapipeline.model.EvaluateExpressionRequest evaluate-expression-request
  [m9039]
  (clojure.core/let
   [bean9038
    (new
     com.amazonaws.services.datapipeline.model.EvaluateExpressionRequest)]
   (clojure.core/when-let
    [v9040 (:expression m9039)]
    (. bean9038 setExpression (clojure.core/str v9040)))
   (clojure.core/when-let
    [v9040 (:pipeline-id m9039)]
    (. bean9038 setPipelineId (clojure.core/str v9040)))
   (clojure.core/when-let
    [v9040 (:object-id m9039)]
    (. bean9038 setObjectId (clojure.core/str v9040)))
   bean9038))
 (clojure.core/defn
  ^com.amazonaws.services.datapipeline.model.PutPipelineDefinitionRequest put-pipeline-definition-request
  [m9042]
  (clojure.core/let
   [bean9041
    (new
     com.amazonaws.services.datapipeline.model.PutPipelineDefinitionRequest)]
   (clojure.core/when-let
    [v9043 (:pipeline-id m9042)]
    (. bean9041 setPipelineId (clojure.core/str v9043)))
   (clojure.core/when-let
    [v9043 (:pipeline-objects m9042)]
    (.
     bean9041
     setPipelineObjects
     (clojure.core/map
      (clojure.core/fn [arg9047] (pipeline-object arg9047))
      v9043)))
   bean9041))
 (clojure.core/defn
  ^com.amazonaws.services.datapipeline.model.ListPipelinesRequest list-pipelines-request
  [m9045]
  (clojure.core/let
   [bean9044
    (new
     com.amazonaws.services.datapipeline.model.ListPipelinesRequest)]
   (clojure.core/when-let
    [v9046 (:marker m9045)]
    (. bean9044 setMarker (clojure.core/str v9046)))
   bean9044))
 (clojure.core/defn
  ^com.amazonaws.services.datapipeline.model.SetTaskStatusRequest set-task-status-request
  [m9049]
  (clojure.core/let
   [bean9048
    (new
     com.amazonaws.services.datapipeline.model.SetTaskStatusRequest)]
   (clojure.core/when-let
    [v9050 (:task-status m9049)]
    (. bean9048 setTaskStatus (clojure.core/str v9050)))
   (clojure.core/when-let
    [v9050 (:task-status m9049)]
    (. bean9048 setTaskStatus (task-status v9050)))
   (clojure.core/when-let
    [v9050 (:task-id m9049)]
    (. bean9048 setTaskId (clojure.core/str v9050)))
   (clojure.core/when-let
    [v9050 (:error-id m9049)]
    (. bean9048 setErrorId (clojure.core/str v9050)))
   (clojure.core/when-let
    [v9050 (:error-message m9049)]
    (. bean9048 setErrorMessage (clojure.core/str v9050)))
   (clojure.core/when-let
    [v9050 (:error-stack-trace m9049)]
    (. bean9048 setErrorStackTrace (clojure.core/str v9050)))
   bean9048))
 (clojure.core/defn
  ^com.amazonaws.services.datapipeline.model.ValidatePipelineDefinitionRequest validate-pipeline-definition-request
  [m9052]
  (clojure.core/let
   [bean9051
    (new
     com.amazonaws.services.datapipeline.model.ValidatePipelineDefinitionRequest)]
   (clojure.core/when-let
    [v9053 (:pipeline-id m9052)]
    (. bean9051 setPipelineId (clojure.core/str v9053)))
   (clojure.core/when-let
    [v9053 (:pipeline-objects m9052)]
    (.
     bean9051
     setPipelineObjects
     (clojure.core/map
      (clojure.core/fn [arg9054] (pipeline-object arg9054))
      v9053)))
   bean9051))
 (clojure.core/defmulti
  datapipeline
  (clojure.core/fn
   datapipeline
   [m__1641__auto__]
   (:fn m__1641__auto__)))
 (do
  (clojure.core/defmethod
   datapipeline
   :describe-objects
   [m9055]
   (clojure.core/let
    [credentials9056 (:credentials m9055) args9057 (:args m9055)]
    (clojure.core/let
     [^com.amazonaws.services.datapipeline.DataPipelineClient client9058
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials9056)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.datapipeline.DataPipelineClient client9058
       describeObjects
       (describe-objects-request (clojure.core/nth args9057 0)))))))
  (clojure.core/defn
   describe-objects-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         pipeline-id
                         object-ids
                         marker
                         evaluate-expressions]}]]),
    :doc "Generate map for describeObjects"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :datapipeline,
     :fn :describe-objects,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-objects
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         pipeline-id
                         object-ids
                         marker
                         evaluate-expressions]}]]),
    :doc "Call describeObjects"}
   [credentials9060 & args9061]
   (clojure.core/let
    [^com.amazonaws.services.datapipeline.DataPipelineClient client9062
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials9060)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.datapipeline.DataPipelineClient client9062
      describeObjects
      (describe-objects-request (clojure.core/nth args9061 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :report-task-runner-heartbeat
   [m9063]
   (clojure.core/let
    [credentials9064 (:credentials m9063) args9065 (:args m9063)]
    (clojure.core/let
     [^com.amazonaws.services.datapipeline.DataPipelineClient client9066
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials9064)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.datapipeline.DataPipelineClient client9066
       reportTaskRunnerHeartbeat
       (report-task-runner-heartbeat-request
        (clojure.core/nth args9065 0)))))))
  (clojure.core/defn
   report-task-runner-heartbeat-map
   {:arglists (quote
               [[credentials
                 {:keys [worker-group
                         taskrunner-id
                         request-metric-collector
                         hostname]}]]),
    :doc "Generate map for reportTaskRunnerHeartbeat"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :datapipeline,
     :fn :report-task-runner-heartbeat,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   report-task-runner-heartbeat
   {:arglists (quote
               [[credentials
                 {:keys [worker-group
                         taskrunner-id
                         request-metric-collector
                         hostname]}]]),
    :doc "Call reportTaskRunnerHeartbeat"}
   [credentials9068 & args9069]
   (clojure.core/let
    [^com.amazonaws.services.datapipeline.DataPipelineClient client9070
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials9068)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.datapipeline.DataPipelineClient client9070
      reportTaskRunnerHeartbeat
      (report-task-runner-heartbeat-request
       (clojure.core/nth args9069 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :query-objects
   [m9071]
   (clojure.core/let
    [credentials9072 (:credentials m9071) args9073 (:args m9071)]
    (clojure.core/let
     [^com.amazonaws.services.datapipeline.DataPipelineClient client9074
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials9072)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.datapipeline.DataPipelineClient client9074
       queryObjects
       (query-objects-request (clojure.core/nth args9073 0)))))))
  (clojure.core/defn
   query-objects-map
   {:arglists (quote
               [[credentials
                 {:keys [sphere
                         request-metric-collector
                         query
                         pipeline-id
                         marker
                         limit]}]]),
    :doc "Generate map for queryObjects"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :datapipeline,
     :fn :query-objects,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   query-objects
   {:arglists (quote
               [[credentials
                 {:keys [sphere
                         request-metric-collector
                         query
                         pipeline-id
                         marker
                         limit]}]]),
    :doc "Call queryObjects"}
   [credentials9076 & args9077]
   (clojure.core/let
    [^com.amazonaws.services.datapipeline.DataPipelineClient client9078
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials9076)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.datapipeline.DataPipelineClient client9078
      queryObjects
      (query-objects-request (clojure.core/nth args9077 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :describe-pipelines
   [m9079]
   (clojure.core/let
    [credentials9080 (:credentials m9079) args9081 (:args m9079)]
    (clojure.core/let
     [^com.amazonaws.services.datapipeline.DataPipelineClient client9082
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials9080)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.datapipeline.DataPipelineClient client9082
       describePipelines
       (describe-pipelines-request (clojure.core/nth args9081 0)))))))
  (clojure.core/defn
   describe-pipelines-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector pipeline-ids]}]]),
    :doc "Generate map for describePipelines"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :datapipeline,
     :fn :describe-pipelines,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-pipelines
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector pipeline-ids]}]]),
    :doc "Call describePipelines"}
   [credentials9084 & args9085]
   (clojure.core/let
    [^com.amazonaws.services.datapipeline.DataPipelineClient client9086
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials9084)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.datapipeline.DataPipelineClient client9086
      describePipelines
      (describe-pipelines-request (clojure.core/nth args9085 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :activate-pipeline
   [m9087]
   (clojure.core/let
    [credentials9088 (:credentials m9087) args9089 (:args m9087)]
    (clojure.core/let
     [^com.amazonaws.services.datapipeline.DataPipelineClient client9090
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials9088)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.datapipeline.DataPipelineClient client9090
       activatePipeline
       (activate-pipeline-request (clojure.core/nth args9089 0)))))))
  (clojure.core/defn
   activate-pipeline-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector pipeline-id]}]]),
    :doc "Generate map for activatePipeline"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :datapipeline,
     :fn :activate-pipeline,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   activate-pipeline
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector pipeline-id]}]]),
    :doc "Call activatePipeline"}
   [credentials9092 & args9093]
   (clojure.core/let
    [^com.amazonaws.services.datapipeline.DataPipelineClient client9094
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials9092)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.datapipeline.DataPipelineClient client9094
      activatePipeline
      (activate-pipeline-request (clojure.core/nth args9093 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :set-status
   [m9095]
   (clojure.core/let
    [credentials9096 (:credentials m9095) args9097 (:args m9095)]
    (clojure.core/let
     [^com.amazonaws.services.datapipeline.DataPipelineClient client9098
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials9096)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.datapipeline.DataPipelineClient client9098
       setStatus
       (set-status-request (clojure.core/nth args9097 0)))))))
  (clojure.core/defn
   set-status-map
   {:arglists (quote
               [[credentials
                 {:keys [status
                         request-metric-collector
                         pipeline-id
                         object-ids]}]]),
    :doc "Generate map for setStatus"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :datapipeline,
     :fn :set-status,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   set-status
   {:arglists (quote
               [[credentials
                 {:keys [status
                         request-metric-collector
                         pipeline-id
                         object-ids]}]]),
    :doc "Call setStatus"}
   [credentials9100 & args9101]
   (clojure.core/let
    [^com.amazonaws.services.datapipeline.DataPipelineClient client9102
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials9100)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.datapipeline.DataPipelineClient client9102
      setStatus
      (set-status-request (clojure.core/nth args9101 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :get-pipeline-definition
   [m9103]
   (clojure.core/let
    [credentials9104 (:credentials m9103) args9105 (:args m9103)]
    (clojure.core/let
     [^com.amazonaws.services.datapipeline.DataPipelineClient client9106
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials9104)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.datapipeline.DataPipelineClient client9106
       getPipelineDefinition
       (get-pipeline-definition-request (clojure.core/nth args9105 0)))))))
  (clojure.core/defn
   get-pipeline-definition-map
   {:arglists (quote
               [[credentials
                 {:keys [version request-metric-collector pipeline-id]}]]),
    :doc "Generate map for getPipelineDefinition"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :datapipeline,
     :fn :get-pipeline-definition,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   get-pipeline-definition
   {:arglists (quote
               [[credentials
                 {:keys [version request-metric-collector pipeline-id]}]]),
    :doc "Call getPipelineDefinition"}
   [credentials9108 & args9109]
   (clojure.core/let
    [^com.amazonaws.services.datapipeline.DataPipelineClient client9110
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials9108)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.datapipeline.DataPipelineClient client9110
      getPipelineDefinition
      (get-pipeline-definition-request (clojure.core/nth args9109 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :poll-for-task
   [m9111]
   (clojure.core/let
    [credentials9112 (:credentials m9111) args9113 (:args m9111)]
    (clojure.core/let
     [^com.amazonaws.services.datapipeline.DataPipelineClient client9114
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials9112)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.datapipeline.DataPipelineClient client9114
       pollForTask
       (poll-for-task-request (clojure.core/nth args9113 0)))))))
  (clojure.core/defn
   poll-for-task-map
   {:arglists (quote
               [[credentials
                 {:keys [worker-group
                         request-metric-collector
                         instance-identity
                         hostname]}]]),
    :doc "Generate map for pollForTask"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :datapipeline,
     :fn :poll-for-task,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   poll-for-task
   {:arglists (quote
               [[credentials
                 {:keys [worker-group
                         request-metric-collector
                         instance-identity
                         hostname]}]]),
    :doc "Call pollForTask"}
   [credentials9116 & args9117]
   (clojure.core/let
    [^com.amazonaws.services.datapipeline.DataPipelineClient client9118
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials9116)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.datapipeline.DataPipelineClient client9118
      pollForTask
      (poll-for-task-request (clojure.core/nth args9117 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :report-task-progress
   [m9119]
   (clojure.core/let
    [credentials9120 (:credentials m9119) args9121 (:args m9119)]
    (clojure.core/let
     [^com.amazonaws.services.datapipeline.DataPipelineClient client9122
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials9120)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.datapipeline.DataPipelineClient client9122
       reportTaskProgress
       (report-task-progress-request (clojure.core/nth args9121 0)))))))
  (clojure.core/defn
   report-task-progress-map
   {:arglists (quote
               [[credentials
                 {:keys [task-id request-metric-collector]}]]),
    :doc "Generate map for reportTaskProgress"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :datapipeline,
     :fn :report-task-progress,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   report-task-progress
   {:arglists (quote
               [[credentials
                 {:keys [task-id request-metric-collector]}]]),
    :doc "Call reportTaskProgress"}
   [credentials9124 & args9125]
   (clojure.core/let
    [^com.amazonaws.services.datapipeline.DataPipelineClient client9126
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials9124)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.datapipeline.DataPipelineClient client9126
      reportTaskProgress
      (report-task-progress-request (clojure.core/nth args9125 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :delete-pipeline
   [m9127]
   (clojure.core/let
    [credentials9128 (:credentials m9127) args9129 (:args m9127)]
    (clojure.core/let
     [^com.amazonaws.services.datapipeline.DataPipelineClient client9130
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials9128)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.datapipeline.DataPipelineClient client9130
       deletePipeline
       (delete-pipeline-request (clojure.core/nth args9129 0)))))))
  (clojure.core/defn
   delete-pipeline-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector pipeline-id]}]]),
    :doc "Generate map for deletePipeline"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :datapipeline,
     :fn :delete-pipeline,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   delete-pipeline
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector pipeline-id]}]]),
    :doc "Call deletePipeline"}
   [credentials9132 & args9133]
   (clojure.core/let
    [^com.amazonaws.services.datapipeline.DataPipelineClient client9134
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials9132)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.datapipeline.DataPipelineClient client9134
      deletePipeline
      (delete-pipeline-request (clojure.core/nth args9133 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :create-pipeline
   [m9135]
   (clojure.core/let
    [credentials9136 (:credentials m9135) args9137 (:args m9135)]
    (clojure.core/let
     [^com.amazonaws.services.datapipeline.DataPipelineClient client9138
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials9136)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.datapipeline.DataPipelineClient client9138
       createPipeline
       (create-pipeline-request (clojure.core/nth args9137 0)))))))
  (clojure.core/defn
   create-pipeline-map
   {:arglists (quote
               [[credentials
                 {:keys [unique-id
                         request-metric-collector
                         name
                         description]}]]),
    :doc "Generate map for createPipeline"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :datapipeline,
     :fn :create-pipeline,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   create-pipeline
   {:arglists (quote
               [[credentials
                 {:keys [unique-id
                         request-metric-collector
                         name
                         description]}]]),
    :doc "Call createPipeline"}
   [credentials9140 & args9141]
   (clojure.core/let
    [^com.amazonaws.services.datapipeline.DataPipelineClient client9142
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials9140)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.datapipeline.DataPipelineClient client9142
      createPipeline
      (create-pipeline-request (clojure.core/nth args9141 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :evaluate-expression
   [m9143]
   (clojure.core/let
    [credentials9144 (:credentials m9143) args9145 (:args m9143)]
    (clojure.core/let
     [^com.amazonaws.services.datapipeline.DataPipelineClient client9146
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials9144)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.datapipeline.DataPipelineClient client9146
       evaluateExpression
       (evaluate-expression-request (clojure.core/nth args9145 0)))))))
  (clojure.core/defn
   evaluate-expression-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         pipeline-id
                         object-id
                         expression]}]]),
    :doc "Generate map for evaluateExpression"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :datapipeline,
     :fn :evaluate-expression,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   evaluate-expression
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         pipeline-id
                         object-id
                         expression]}]]),
    :doc "Call evaluateExpression"}
   [credentials9148 & args9149]
   (clojure.core/let
    [^com.amazonaws.services.datapipeline.DataPipelineClient client9150
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials9148)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.datapipeline.DataPipelineClient client9150
      evaluateExpression
      (evaluate-expression-request (clojure.core/nth args9149 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :put-pipeline-definition
   [m9151]
   (clojure.core/let
    [credentials9152 (:credentials m9151) args9153 (:args m9151)]
    (clojure.core/let
     [^com.amazonaws.services.datapipeline.DataPipelineClient client9154
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials9152)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.datapipeline.DataPipelineClient client9154
       putPipelineDefinition
       (put-pipeline-definition-request (clojure.core/nth args9153 0)))))))
  (clojure.core/defn
   put-pipeline-definition-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         pipeline-objects
                         pipeline-id]}]]),
    :doc "Generate map for putPipelineDefinition"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :datapipeline,
     :fn :put-pipeline-definition,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   put-pipeline-definition
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         pipeline-objects
                         pipeline-id]}]]),
    :doc "Call putPipelineDefinition"}
   [credentials9156 & args9157]
   (clojure.core/let
    [^com.amazonaws.services.datapipeline.DataPipelineClient client9158
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials9156)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.datapipeline.DataPipelineClient client9158
      putPipelineDefinition
      (put-pipeline-definition-request (clojure.core/nth args9157 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :list-pipelines
   [m9159]
   (clojure.core/let
    [credentials9160 (:credentials m9159) args9161 (:args m9159)]
    (clojure.core/let
     [^com.amazonaws.services.datapipeline.DataPipelineClient client9162
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials9160)]
     (clojure.core/case
      (clojure.core/count args9161)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.datapipeline.DataPipelineClient client9162
        listPipelines))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.datapipeline.DataPipelineClient client9162
        listPipelines
        (list-pipelines-request (clojure.core/nth args9161 0))))))))
  (clojure.core/defn
   list-pipelines-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [request-metric-collector marker]}]]),
    :doc "Generate map for listPipelines, listPipelines"}
   ([credentials__1609__auto__]
    {:args [],
     :client :datapipeline,
     :fn :list-pipelines,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :datapipeline,
     :fn :list-pipelines,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   list-pipelines
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [request-metric-collector marker]}]]),
    :doc "Call listPipelines, listPipelines"}
   [credentials9164 & args9165]
   (clojure.core/let
    [^com.amazonaws.services.datapipeline.DataPipelineClient client9166
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials9164)]
    (clojure.core/case
     (clojure.core/count args9165)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.datapipeline.DataPipelineClient client9166
       listPipelines))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.datapipeline.DataPipelineClient client9166
       listPipelines
       (list-pipelines-request (clojure.core/nth args9165 0))))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :set-task-status
   [m9167]
   (clojure.core/let
    [credentials9168 (:credentials m9167) args9169 (:args m9167)]
    (clojure.core/let
     [^com.amazonaws.services.datapipeline.DataPipelineClient client9170
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials9168)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.datapipeline.DataPipelineClient client9170
       setTaskStatus
       (set-task-status-request (clojure.core/nth args9169 0)))))))
  (clojure.core/defn
   set-task-status-map
   {:arglists (quote
               [[credentials
                 {:keys [task-status
                         task-id
                         request-metric-collector
                         error-stack-trace
                         error-message
                         error-id]}]]),
    :doc "Generate map for setTaskStatus"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :datapipeline,
     :fn :set-task-status,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   set-task-status
   {:arglists (quote
               [[credentials
                 {:keys [task-status
                         task-id
                         request-metric-collector
                         error-stack-trace
                         error-message
                         error-id]}]]),
    :doc "Call setTaskStatus"}
   [credentials9172 & args9173]
   (clojure.core/let
    [^com.amazonaws.services.datapipeline.DataPipelineClient client9174
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials9172)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.datapipeline.DataPipelineClient client9174
      setTaskStatus
      (set-task-status-request (clojure.core/nth args9173 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :validate-pipeline-definition
   [m9175]
   (clojure.core/let
    [credentials9176 (:credentials m9175) args9177 (:args m9175)]
    (clojure.core/let
     [^com.amazonaws.services.datapipeline.DataPipelineClient client9178
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials9176)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.datapipeline.DataPipelineClient client9178
       validatePipelineDefinition
       (validate-pipeline-definition-request
        (clojure.core/nth args9177 0)))))))
  (clojure.core/defn
   validate-pipeline-definition-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         pipeline-objects
                         pipeline-id]}]]),
    :doc "Generate map for validatePipelineDefinition"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :datapipeline,
     :fn :validate-pipeline-definition,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   validate-pipeline-definition
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         pipeline-objects
                         pipeline-id]}]]),
    :doc "Call validatePipelineDefinition"}
   [credentials9180 & args9181]
   (clojure.core/let
    [^com.amazonaws.services.datapipeline.DataPipelineClient client9182
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials9180)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.datapipeline.DataPipelineClient client9182
      validatePipelineDefinition
      (validate-pipeline-definition-request
       (clojure.core/nth args9181 0))))))))
