(ns
 com.palletops.awaze.directconnect
 (:require [com.palletops.awaze.common]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :directconnect
  [___1561__auto__
   ^com.amazonaws.auth.BasicAWSCredentials credentials__1562__auto__]
  (new
   com.amazonaws.services.directconnect.AmazonDirectConnectClient
   credentials__1562__auto__))
 (clojure.core/defn
  ^com.amazonaws.services.directconnect.model.RouteFilterPrefix route-filter-prefix
  [m3328]
  (clojure.core/let
   [bean3327
    (new com.amazonaws.services.directconnect.model.RouteFilterPrefix)]
   (clojure.core/when-let
    [v3329 (:cidr m3328)]
    (. bean3327 setCidr (clojure.core/str v3329)))
   bean3327))
 (clojure.core/defn
  ^com.amazonaws.services.directconnect.model.NewPublicVirtualInterface new-public-virtual-interface
  [m3331]
  (clojure.core/let
   [bean3330
    (new
     com.amazonaws.services.directconnect.model.NewPublicVirtualInterface)]
   (clojure.core/when-let
    [v3332 (:asn m3331)]
    (. bean3330 setAsn (clojure.core/int v3332)))
   (clojure.core/when-let
    [v3332 (:auth-key m3331)]
    (. bean3330 setAuthKey (clojure.core/str v3332)))
   (clojure.core/when-let
    [v3332 (:vlan m3331)]
    (. bean3330 setVlan (clojure.core/int v3332)))
   (clojure.core/when-let
    [v3332 (:amazon-address m3331)]
    (. bean3330 setAmazonAddress (clojure.core/str v3332)))
   (clojure.core/when-let
    [v3332 (:customer-address m3331)]
    (. bean3330 setCustomerAddress (clojure.core/str v3332)))
   (clojure.core/when-let
    [v3332 (:virtual-interface-name m3331)]
    (. bean3330 setVirtualInterfaceName (clojure.core/str v3332)))
   (clojure.core/when-let
    [v3332 (:route-filter-prefixes m3331)]
    (.
     bean3330
     setRouteFilterPrefixes
     (clojure.core/map
      (clojure.core/fn [arg3336] (route-filter-prefix arg3336))
      v3332)))
   bean3330))
 (clojure.core/defn
  ^com.amazonaws.services.directconnect.model.NewPrivateVirtualInterface new-private-virtual-interface
  [m3334]
  (clojure.core/let
   [bean3333
    (new
     com.amazonaws.services.directconnect.model.NewPrivateVirtualInterface)]
   (clojure.core/when-let
    [v3335 (:asn m3334)]
    (. bean3333 setAsn (clojure.core/int v3335)))
   (clojure.core/when-let
    [v3335 (:auth-key m3334)]
    (. bean3333 setAuthKey (clojure.core/str v3335)))
   (clojure.core/when-let
    [v3335 (:vlan m3334)]
    (. bean3333 setVlan (clojure.core/int v3335)))
   (clojure.core/when-let
    [v3335 (:amazon-address m3334)]
    (. bean3333 setAmazonAddress (clojure.core/str v3335)))
   (clojure.core/when-let
    [v3335 (:customer-address m3334)]
    (. bean3333 setCustomerAddress (clojure.core/str v3335)))
   (clojure.core/when-let
    [v3335 (:virtual-gateway-id m3334)]
    (. bean3333 setVirtualGatewayId (clojure.core/str v3335)))
   (clojure.core/when-let
    [v3335 (:virtual-interface-name m3334)]
    (. bean3333 setVirtualInterfaceName (clojure.core/str v3335)))
   bean3333))
 (clojure.core/defn
  ^com.amazonaws.services.directconnect.model.NewPrivateVirtualInterfaceAllocation new-private-virtual-interface-allocation
  [m3338]
  (clojure.core/let
   [bean3337
    (new
     com.amazonaws.services.directconnect.model.NewPrivateVirtualInterfaceAllocation)]
   (clojure.core/when-let
    [v3339 (:asn m3338)]
    (. bean3337 setAsn (clojure.core/int v3339)))
   (clojure.core/when-let
    [v3339 (:auth-key m3338)]
    (. bean3337 setAuthKey (clojure.core/str v3339)))
   (clojure.core/when-let
    [v3339 (:vlan m3338)]
    (. bean3337 setVlan (clojure.core/int v3339)))
   (clojure.core/when-let
    [v3339 (:amazon-address m3338)]
    (. bean3337 setAmazonAddress (clojure.core/str v3339)))
   (clojure.core/when-let
    [v3339 (:customer-address m3338)]
    (. bean3337 setCustomerAddress (clojure.core/str v3339)))
   (clojure.core/when-let
    [v3339 (:virtual-interface-name m3338)]
    (. bean3337 setVirtualInterfaceName (clojure.core/str v3339)))
   bean3337))
 (clojure.core/defn
  ^com.amazonaws.services.directconnect.model.NewPublicVirtualInterfaceAllocation new-public-virtual-interface-allocation
  [m3341]
  (clojure.core/let
   [bean3340
    (new
     com.amazonaws.services.directconnect.model.NewPublicVirtualInterfaceAllocation)]
   (clojure.core/when-let
    [v3342 (:asn m3341)]
    (. bean3340 setAsn (clojure.core/int v3342)))
   (clojure.core/when-let
    [v3342 (:auth-key m3341)]
    (. bean3340 setAuthKey (clojure.core/str v3342)))
   (clojure.core/when-let
    [v3342 (:vlan m3341)]
    (. bean3340 setVlan (clojure.core/int v3342)))
   (clojure.core/when-let
    [v3342 (:amazon-address m3341)]
    (. bean3340 setAmazonAddress (clojure.core/str v3342)))
   (clojure.core/when-let
    [v3342 (:customer-address m3341)]
    (. bean3340 setCustomerAddress (clojure.core/str v3342)))
   (clojure.core/when-let
    [v3342 (:virtual-interface-name m3341)]
    (. bean3340 setVirtualInterfaceName (clojure.core/str v3342)))
   (clojure.core/when-let
    [v3342 (:route-filter-prefixes m3341)]
    (.
     bean3340
     setRouteFilterPrefixes
     (clojure.core/map
      (clojure.core/fn [arg3346] (route-filter-prefix arg3346))
      v3342)))
   bean3340))
 (clojure.core/defn
  ^com.amazonaws.services.directconnect.model.DeleteConnectionRequest delete-connection-request
  [m3344]
  (clojure.core/let
   [bean3343
    (new
     com.amazonaws.services.directconnect.model.DeleteConnectionRequest)]
   (clojure.core/when-let
    [v3345 (:connection-id m3344)]
    (. bean3343 setConnectionId (clojure.core/str v3345)))
   bean3343))
 (clojure.core/defn
  ^com.amazonaws.services.directconnect.model.DescribeConnectionsOnInterconnectRequest describe-connections-on-interconnect-request
  [m3348]
  (clojure.core/let
   [bean3347
    (new
     com.amazonaws.services.directconnect.model.DescribeConnectionsOnInterconnectRequest)]
   (clojure.core/when-let
    [v3349 (:interconnect-id m3348)]
    (. bean3347 setInterconnectId (clojure.core/str v3349)))
   bean3347))
 (clojure.core/defn
  ^com.amazonaws.services.directconnect.model.DescribeLocationsRequest describe-locations-request
  [m3351]
  (clojure.core/let
   [bean3350
    (new
     com.amazonaws.services.directconnect.model.DescribeLocationsRequest)]
   bean3350))
 (clojure.core/defn
  ^com.amazonaws.services.directconnect.model.AllocateConnectionOnInterconnectRequest allocate-connection-on-interconnect-request
  [m3354]
  (clojure.core/let
   [bean3353
    (new
     com.amazonaws.services.directconnect.model.AllocateConnectionOnInterconnectRequest)]
   (clojure.core/when-let
    [v3355 (:interconnect-id m3354)]
    (. bean3353 setInterconnectId (clojure.core/str v3355)))
   (clojure.core/when-let
    [v3355 (:bandwidth m3354)]
    (. bean3353 setBandwidth (clojure.core/str v3355)))
   (clojure.core/when-let
    [v3355 (:connection-name m3354)]
    (. bean3353 setConnectionName (clojure.core/str v3355)))
   (clojure.core/when-let
    [v3355 (:vlan m3354)]
    (. bean3353 setVlan (clojure.core/int v3355)))
   (clojure.core/when-let
    [v3355 (:owner-account m3354)]
    (. bean3353 setOwnerAccount (clojure.core/str v3355)))
   bean3353))
 (clojure.core/defn
  ^com.amazonaws.services.directconnect.model.CreatePublicVirtualInterfaceRequest create-public-virtual-interface-request
  [m3357]
  (clojure.core/let
   [bean3356
    (new
     com.amazonaws.services.directconnect.model.CreatePublicVirtualInterfaceRequest)]
   (clojure.core/when-let
    [v3358 (:connection-id m3357)]
    (. bean3356 setConnectionId (clojure.core/str v3358)))
   (clojure.core/when-let
    [v3358 (:new-public-virtual-interface m3357)]
    (.
     bean3356
     setNewPublicVirtualInterface
     (new-public-virtual-interface v3358)))
   bean3356))
 (clojure.core/defn
  ^com.amazonaws.services.directconnect.model.ConfirmConnectionRequest confirm-connection-request
  [m3360]
  (clojure.core/let
   [bean3359
    (new
     com.amazonaws.services.directconnect.model.ConfirmConnectionRequest)]
   (clojure.core/when-let
    [v3361 (:connection-id m3360)]
    (. bean3359 setConnectionId (clojure.core/str v3361)))
   bean3359))
 (clojure.core/defn
  ^com.amazonaws.services.directconnect.model.ConfirmPrivateVirtualInterfaceRequest confirm-private-virtual-interface-request
  [m3363]
  (clojure.core/let
   [bean3362
    (new
     com.amazonaws.services.directconnect.model.ConfirmPrivateVirtualInterfaceRequest)]
   (clojure.core/when-let
    [v3364 (:virtual-interface-id m3363)]
    (. bean3362 setVirtualInterfaceId (clojure.core/str v3364)))
   (clojure.core/when-let
    [v3364 (:virtual-gateway-id m3363)]
    (. bean3362 setVirtualGatewayId (clojure.core/str v3364)))
   bean3362))
 (clojure.core/defn
  ^com.amazonaws.services.directconnect.model.CreateInterconnectRequest create-interconnect-request
  [m3366]
  (clojure.core/let
   [bean3365
    (new
     com.amazonaws.services.directconnect.model.CreateInterconnectRequest)]
   (clojure.core/when-let
    [v3367 (:location m3366)]
    (. bean3365 setLocation (clojure.core/str v3367)))
   (clojure.core/when-let
    [v3367 (:bandwidth m3366)]
    (. bean3365 setBandwidth (clojure.core/str v3367)))
   (clojure.core/when-let
    [v3367 (:interconnect-name m3366)]
    (. bean3365 setInterconnectName (clojure.core/str v3367)))
   bean3365))
 (clojure.core/defn
  ^com.amazonaws.services.directconnect.model.ConfirmPublicVirtualInterfaceRequest confirm-public-virtual-interface-request
  [m3369]
  (clojure.core/let
   [bean3368
    (new
     com.amazonaws.services.directconnect.model.ConfirmPublicVirtualInterfaceRequest)]
   (clojure.core/when-let
    [v3370 (:virtual-interface-id m3369)]
    (. bean3368 setVirtualInterfaceId (clojure.core/str v3370)))
   bean3368))
 (clojure.core/defn
  ^com.amazonaws.services.directconnect.model.DeleteVirtualInterfaceRequest delete-virtual-interface-request
  [m3372]
  (clojure.core/let
   [bean3371
    (new
     com.amazonaws.services.directconnect.model.DeleteVirtualInterfaceRequest)]
   (clojure.core/when-let
    [v3373 (:virtual-interface-id m3372)]
    (. bean3371 setVirtualInterfaceId (clojure.core/str v3373)))
   bean3371))
 (clojure.core/defn
  ^com.amazonaws.services.directconnect.model.CreatePrivateVirtualInterfaceRequest create-private-virtual-interface-request
  [m3375]
  (clojure.core/let
   [bean3374
    (new
     com.amazonaws.services.directconnect.model.CreatePrivateVirtualInterfaceRequest)]
   (clojure.core/when-let
    [v3376 (:connection-id m3375)]
    (. bean3374 setConnectionId (clojure.core/str v3376)))
   (clojure.core/when-let
    [v3376 (:new-private-virtual-interface m3375)]
    (.
     bean3374
     setNewPrivateVirtualInterface
     (new-private-virtual-interface v3376)))
   bean3374))
 (clojure.core/defn
  ^com.amazonaws.services.directconnect.model.AllocatePrivateVirtualInterfaceRequest allocate-private-virtual-interface-request
  [m3378]
  (clojure.core/let
   [bean3377
    (new
     com.amazonaws.services.directconnect.model.AllocatePrivateVirtualInterfaceRequest)]
   (clojure.core/when-let
    [v3379 (:connection-id m3378)]
    (. bean3377 setConnectionId (clojure.core/str v3379)))
   (clojure.core/when-let
    [v3379 (:new-private-virtual-interface-allocation m3378)]
    (.
     bean3377
     setNewPrivateVirtualInterfaceAllocation
     (new-private-virtual-interface-allocation v3379)))
   (clojure.core/when-let
    [v3379 (:owner-account m3378)]
    (. bean3377 setOwnerAccount (clojure.core/str v3379)))
   bean3377))
 (clojure.core/defn
  ^com.amazonaws.services.directconnect.model.DescribeVirtualInterfacesRequest describe-virtual-interfaces-request
  [m3381]
  (clojure.core/let
   [bean3380
    (new
     com.amazonaws.services.directconnect.model.DescribeVirtualInterfacesRequest)]
   (clojure.core/when-let
    [v3382 (:connection-id m3381)]
    (. bean3380 setConnectionId (clojure.core/str v3382)))
   (clojure.core/when-let
    [v3382 (:virtual-interface-id m3381)]
    (. bean3380 setVirtualInterfaceId (clojure.core/str v3382)))
   bean3380))
 (clojure.core/defn
  ^com.amazonaws.services.directconnect.model.DescribeConnectionsRequest describe-connections-request
  [m3384]
  (clojure.core/let
   [bean3383
    (new
     com.amazonaws.services.directconnect.model.DescribeConnectionsRequest)]
   (clojure.core/when-let
    [v3385 (:connection-id m3384)]
    (. bean3383 setConnectionId (clojure.core/str v3385)))
   bean3383))
 (clojure.core/defn
  ^com.amazonaws.services.directconnect.model.AllocatePublicVirtualInterfaceRequest allocate-public-virtual-interface-request
  [m3387]
  (clojure.core/let
   [bean3386
    (new
     com.amazonaws.services.directconnect.model.AllocatePublicVirtualInterfaceRequest)]
   (clojure.core/when-let
    [v3388 (:connection-id m3387)]
    (. bean3386 setConnectionId (clojure.core/str v3388)))
   (clojure.core/when-let
    [v3388 (:new-public-virtual-interface-allocation m3387)]
    (.
     bean3386
     setNewPublicVirtualInterfaceAllocation
     (new-public-virtual-interface-allocation v3388)))
   (clojure.core/when-let
    [v3388 (:owner-account m3387)]
    (. bean3386 setOwnerAccount (clojure.core/str v3388)))
   bean3386))
 (clojure.core/defn
  ^com.amazonaws.services.directconnect.model.DescribeInterconnectsRequest describe-interconnects-request
  [m3390]
  (clojure.core/let
   [bean3389
    (new
     com.amazonaws.services.directconnect.model.DescribeInterconnectsRequest)]
   (clojure.core/when-let
    [v3391 (:interconnect-id m3390)]
    (. bean3389 setInterconnectId (clojure.core/str v3391)))
   bean3389))
 (clojure.core/defn
  ^com.amazonaws.services.directconnect.model.CreateConnectionRequest create-connection-request
  [m3393]
  (clojure.core/let
   [bean3392
    (new
     com.amazonaws.services.directconnect.model.CreateConnectionRequest)]
   (clojure.core/when-let
    [v3394 (:location m3393)]
    (. bean3392 setLocation (clojure.core/str v3394)))
   (clojure.core/when-let
    [v3394 (:bandwidth m3393)]
    (. bean3392 setBandwidth (clojure.core/str v3394)))
   (clojure.core/when-let
    [v3394 (:connection-name m3393)]
    (. bean3392 setConnectionName (clojure.core/str v3394)))
   bean3392))
 (clojure.core/defn
  ^com.amazonaws.services.directconnect.model.DeleteInterconnectRequest delete-interconnect-request
  [m3396]
  (clojure.core/let
   [bean3395
    (new
     com.amazonaws.services.directconnect.model.DeleteInterconnectRequest)]
   (clojure.core/when-let
    [v3397 (:interconnect-id m3396)]
    (. bean3395 setInterconnectId (clojure.core/str v3397)))
   bean3395))
 (clojure.core/defn
  ^com.amazonaws.services.directconnect.model.DescribeVirtualGatewaysRequest describe-virtual-gateways-request
  [m3399]
  (clojure.core/let
   [bean3398
    (new
     com.amazonaws.services.directconnect.model.DescribeVirtualGatewaysRequest)]
   bean3398))
 (clojure.core/defmulti
  directconnect
  (clojure.core/fn
   directconnect
   [m__1641__auto__]
   (:fn m__1641__auto__)))
 (do
  (clojure.core/defmethod
   directconnect
   :delete-connection
   [m3401]
   (clojure.core/let
    [credentials3402 (:credentials m3401) args3403 (:args m3401)]
    (clojure.core/let
     [^com.amazonaws.services.directconnect.AmazonDirectConnectClient client3404
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials3402)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.directconnect.AmazonDirectConnectClient client3404
       deleteConnection
       (delete-connection-request (clojure.core/nth args3403 0)))))))
  (clojure.core/defn
   delete-connection-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector connection-id]}]]),
    :doc "Generate map for deleteConnection"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :directconnect,
     :fn :delete-connection,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   delete-connection
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector connection-id]}]]),
    :doc "Call deleteConnection"}
   [credentials3406 & args3407]
   (clojure.core/let
    [^com.amazonaws.services.directconnect.AmazonDirectConnectClient client3408
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials3406)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.directconnect.AmazonDirectConnectClient client3408
      deleteConnection
      (delete-connection-request (clojure.core/nth args3407 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :describe-connections-on-interconnect
   [m3409]
   (clojure.core/let
    [credentials3410 (:credentials m3409) args3411 (:args m3409)]
    (clojure.core/let
     [^com.amazonaws.services.directconnect.AmazonDirectConnectClient client3412
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials3410)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.directconnect.AmazonDirectConnectClient client3412
       describeConnectionsOnInterconnect
       (describe-connections-on-interconnect-request
        (clojure.core/nth args3411 0)))))))
  (clojure.core/defn
   describe-connections-on-interconnect-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector interconnect-id]}]]),
    :doc "Generate map for describeConnectionsOnInterconnect"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :directconnect,
     :fn :describe-connections-on-interconnect,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-connections-on-interconnect
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector interconnect-id]}]]),
    :doc "Call describeConnectionsOnInterconnect"}
   [credentials3414 & args3415]
   (clojure.core/let
    [^com.amazonaws.services.directconnect.AmazonDirectConnectClient client3416
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials3414)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.directconnect.AmazonDirectConnectClient client3416
      describeConnectionsOnInterconnect
      (describe-connections-on-interconnect-request
       (clojure.core/nth args3415 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :describe-locations
   [m3417]
   (clojure.core/let
    [credentials3418 (:credentials m3417) args3419 (:args m3417)]
    (clojure.core/let
     [^com.amazonaws.services.directconnect.AmazonDirectConnectClient client3420
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials3418)]
     (clojure.core/case
      (clojure.core/count args3419)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.directconnect.AmazonDirectConnectClient client3420
        describeLocations
        (describe-locations-request (clojure.core/nth args3419 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.directconnect.AmazonDirectConnectClient client3420
        describeLocations))))))
  (clojure.core/defn
   describe-locations-map
   {:arglists (quote
               [[credentials {:keys [request-metric-collector]}]
                [credentials]]),
    :doc "Generate map for describeLocations, describeLocations"}
   ([credentials__1609__auto__]
    {:args [],
     :client :directconnect,
     :fn :describe-locations,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :directconnect,
     :fn :describe-locations,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-locations
   {:arglists (quote
               [[credentials {:keys [request-metric-collector]}]
                [credentials]]),
    :doc "Call describeLocations, describeLocations"}
   [credentials3422 & args3423]
   (clojure.core/let
    [^com.amazonaws.services.directconnect.AmazonDirectConnectClient client3424
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials3422)]
    (clojure.core/case
     (clojure.core/count args3423)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.directconnect.AmazonDirectConnectClient client3424
       describeLocations
       (describe-locations-request (clojure.core/nth args3423 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.directconnect.AmazonDirectConnectClient client3424
       describeLocations))))))
 (do
  (clojure.core/defmethod
   directconnect
   :allocate-connection-on-interconnect
   [m3425]
   (clojure.core/let
    [credentials3426 (:credentials m3425) args3427 (:args m3425)]
    (clojure.core/let
     [^com.amazonaws.services.directconnect.AmazonDirectConnectClient client3428
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials3426)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.directconnect.AmazonDirectConnectClient client3428
       allocateConnectionOnInterconnect
       (allocate-connection-on-interconnect-request
        (clojure.core/nth args3427 0)))))))
  (clojure.core/defn
   allocate-connection-on-interconnect-map
   {:arglists (quote
               [[credentials
                 {:keys [vlan
                         request-metric-collector
                         owner-account
                         interconnect-id
                         connection-name
                         bandwidth]}]]),
    :doc "Generate map for allocateConnectionOnInterconnect"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :directconnect,
     :fn :allocate-connection-on-interconnect,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   allocate-connection-on-interconnect
   {:arglists (quote
               [[credentials
                 {:keys [vlan
                         request-metric-collector
                         owner-account
                         interconnect-id
                         connection-name
                         bandwidth]}]]),
    :doc "Call allocateConnectionOnInterconnect"}
   [credentials3430 & args3431]
   (clojure.core/let
    [^com.amazonaws.services.directconnect.AmazonDirectConnectClient client3432
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials3430)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.directconnect.AmazonDirectConnectClient client3432
      allocateConnectionOnInterconnect
      (allocate-connection-on-interconnect-request
       (clojure.core/nth args3431 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :create-public-virtual-interface
   [m3433]
   (clojure.core/let
    [credentials3434 (:credentials m3433) args3435 (:args m3433)]
    (clojure.core/let
     [^com.amazonaws.services.directconnect.AmazonDirectConnectClient client3436
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials3434)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.directconnect.AmazonDirectConnectClient client3436
       createPublicVirtualInterface
       (create-public-virtual-interface-request
        (clojure.core/nth args3435 0)))))))
  (clojure.core/defn
   create-public-virtual-interface-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         new-public-virtual-interface
                         connection-id]}]]),
    :doc "Generate map for createPublicVirtualInterface"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :directconnect,
     :fn :create-public-virtual-interface,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   create-public-virtual-interface
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         new-public-virtual-interface
                         connection-id]}]]),
    :doc "Call createPublicVirtualInterface"}
   [credentials3438 & args3439]
   (clojure.core/let
    [^com.amazonaws.services.directconnect.AmazonDirectConnectClient client3440
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials3438)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.directconnect.AmazonDirectConnectClient client3440
      createPublicVirtualInterface
      (create-public-virtual-interface-request
       (clojure.core/nth args3439 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :confirm-connection
   [m3441]
   (clojure.core/let
    [credentials3442 (:credentials m3441) args3443 (:args m3441)]
    (clojure.core/let
     [^com.amazonaws.services.directconnect.AmazonDirectConnectClient client3444
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials3442)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.directconnect.AmazonDirectConnectClient client3444
       confirmConnection
       (confirm-connection-request (clojure.core/nth args3443 0)))))))
  (clojure.core/defn
   confirm-connection-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector connection-id]}]]),
    :doc "Generate map for confirmConnection"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :directconnect,
     :fn :confirm-connection,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   confirm-connection
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector connection-id]}]]),
    :doc "Call confirmConnection"}
   [credentials3446 & args3447]
   (clojure.core/let
    [^com.amazonaws.services.directconnect.AmazonDirectConnectClient client3448
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials3446)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.directconnect.AmazonDirectConnectClient client3448
      confirmConnection
      (confirm-connection-request (clojure.core/nth args3447 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :confirm-private-virtual-interface
   [m3449]
   (clojure.core/let
    [credentials3450 (:credentials m3449) args3451 (:args m3449)]
    (clojure.core/let
     [^com.amazonaws.services.directconnect.AmazonDirectConnectClient client3452
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials3450)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.directconnect.AmazonDirectConnectClient client3452
       confirmPrivateVirtualInterface
       (confirm-private-virtual-interface-request
        (clojure.core/nth args3451 0)))))))
  (clojure.core/defn
   confirm-private-virtual-interface-map
   {:arglists (quote
               [[credentials
                 {:keys [virtual-interface-id
                         virtual-gateway-id
                         request-metric-collector]}]]),
    :doc "Generate map for confirmPrivateVirtualInterface"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :directconnect,
     :fn :confirm-private-virtual-interface,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   confirm-private-virtual-interface
   {:arglists (quote
               [[credentials
                 {:keys [virtual-interface-id
                         virtual-gateway-id
                         request-metric-collector]}]]),
    :doc "Call confirmPrivateVirtualInterface"}
   [credentials3454 & args3455]
   (clojure.core/let
    [^com.amazonaws.services.directconnect.AmazonDirectConnectClient client3456
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials3454)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.directconnect.AmazonDirectConnectClient client3456
      confirmPrivateVirtualInterface
      (confirm-private-virtual-interface-request
       (clojure.core/nth args3455 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :create-interconnect
   [m3457]
   (clojure.core/let
    [credentials3458 (:credentials m3457) args3459 (:args m3457)]
    (clojure.core/let
     [^com.amazonaws.services.directconnect.AmazonDirectConnectClient client3460
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials3458)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.directconnect.AmazonDirectConnectClient client3460
       createInterconnect
       (create-interconnect-request (clojure.core/nth args3459 0)))))))
  (clojure.core/defn
   create-interconnect-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         location
                         interconnect-name
                         bandwidth]}]]),
    :doc "Generate map for createInterconnect"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :directconnect,
     :fn :create-interconnect,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   create-interconnect
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         location
                         interconnect-name
                         bandwidth]}]]),
    :doc "Call createInterconnect"}
   [credentials3462 & args3463]
   (clojure.core/let
    [^com.amazonaws.services.directconnect.AmazonDirectConnectClient client3464
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials3462)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.directconnect.AmazonDirectConnectClient client3464
      createInterconnect
      (create-interconnect-request (clojure.core/nth args3463 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :confirm-public-virtual-interface
   [m3465]
   (clojure.core/let
    [credentials3466 (:credentials m3465) args3467 (:args m3465)]
    (clojure.core/let
     [^com.amazonaws.services.directconnect.AmazonDirectConnectClient client3468
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials3466)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.directconnect.AmazonDirectConnectClient client3468
       confirmPublicVirtualInterface
       (confirm-public-virtual-interface-request
        (clojure.core/nth args3467 0)))))))
  (clojure.core/defn
   confirm-public-virtual-interface-map
   {:arglists (quote
               [[credentials
                 {:keys [virtual-interface-id
                         request-metric-collector]}]]),
    :doc "Generate map for confirmPublicVirtualInterface"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :directconnect,
     :fn :confirm-public-virtual-interface,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   confirm-public-virtual-interface
   {:arglists (quote
               [[credentials
                 {:keys [virtual-interface-id
                         request-metric-collector]}]]),
    :doc "Call confirmPublicVirtualInterface"}
   [credentials3470 & args3471]
   (clojure.core/let
    [^com.amazonaws.services.directconnect.AmazonDirectConnectClient client3472
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials3470)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.directconnect.AmazonDirectConnectClient client3472
      confirmPublicVirtualInterface
      (confirm-public-virtual-interface-request
       (clojure.core/nth args3471 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :delete-virtual-interface
   [m3473]
   (clojure.core/let
    [credentials3474 (:credentials m3473) args3475 (:args m3473)]
    (clojure.core/let
     [^com.amazonaws.services.directconnect.AmazonDirectConnectClient client3476
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials3474)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.directconnect.AmazonDirectConnectClient client3476
       deleteVirtualInterface
       (delete-virtual-interface-request
        (clojure.core/nth args3475 0)))))))
  (clojure.core/defn
   delete-virtual-interface-map
   {:arglists (quote
               [[credentials
                 {:keys [virtual-interface-id
                         request-metric-collector]}]]),
    :doc "Generate map for deleteVirtualInterface"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :directconnect,
     :fn :delete-virtual-interface,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   delete-virtual-interface
   {:arglists (quote
               [[credentials
                 {:keys [virtual-interface-id
                         request-metric-collector]}]]),
    :doc "Call deleteVirtualInterface"}
   [credentials3478 & args3479]
   (clojure.core/let
    [^com.amazonaws.services.directconnect.AmazonDirectConnectClient client3480
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials3478)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.directconnect.AmazonDirectConnectClient client3480
      deleteVirtualInterface
      (delete-virtual-interface-request (clojure.core/nth args3479 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :create-private-virtual-interface
   [m3481]
   (clojure.core/let
    [credentials3482 (:credentials m3481) args3483 (:args m3481)]
    (clojure.core/let
     [^com.amazonaws.services.directconnect.AmazonDirectConnectClient client3484
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials3482)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.directconnect.AmazonDirectConnectClient client3484
       createPrivateVirtualInterface
       (create-private-virtual-interface-request
        (clojure.core/nth args3483 0)))))))
  (clojure.core/defn
   create-private-virtual-interface-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         new-private-virtual-interface
                         connection-id]}]]),
    :doc "Generate map for createPrivateVirtualInterface"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :directconnect,
     :fn :create-private-virtual-interface,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   create-private-virtual-interface
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         new-private-virtual-interface
                         connection-id]}]]),
    :doc "Call createPrivateVirtualInterface"}
   [credentials3486 & args3487]
   (clojure.core/let
    [^com.amazonaws.services.directconnect.AmazonDirectConnectClient client3488
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials3486)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.directconnect.AmazonDirectConnectClient client3488
      createPrivateVirtualInterface
      (create-private-virtual-interface-request
       (clojure.core/nth args3487 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :allocate-private-virtual-interface
   [m3489]
   (clojure.core/let
    [credentials3490 (:credentials m3489) args3491 (:args m3489)]
    (clojure.core/let
     [^com.amazonaws.services.directconnect.AmazonDirectConnectClient client3492
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials3490)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.directconnect.AmazonDirectConnectClient client3492
       allocatePrivateVirtualInterface
       (allocate-private-virtual-interface-request
        (clojure.core/nth args3491 0)))))))
  (clojure.core/defn
   allocate-private-virtual-interface-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         owner-account
                         new-private-virtual-interface-allocation
                         connection-id]}]]),
    :doc "Generate map for allocatePrivateVirtualInterface"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :directconnect,
     :fn :allocate-private-virtual-interface,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   allocate-private-virtual-interface
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         owner-account
                         new-private-virtual-interface-allocation
                         connection-id]}]]),
    :doc "Call allocatePrivateVirtualInterface"}
   [credentials3494 & args3495]
   (clojure.core/let
    [^com.amazonaws.services.directconnect.AmazonDirectConnectClient client3496
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials3494)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.directconnect.AmazonDirectConnectClient client3496
      allocatePrivateVirtualInterface
      (allocate-private-virtual-interface-request
       (clojure.core/nth args3495 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :describe-virtual-interfaces
   [m3497]
   (clojure.core/let
    [credentials3498 (:credentials m3497) args3499 (:args m3497)]
    (clojure.core/let
     [^com.amazonaws.services.directconnect.AmazonDirectConnectClient client3500
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials3498)]
     (clojure.core/case
      (clojure.core/count args3499)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.directconnect.AmazonDirectConnectClient client3500
        describeVirtualInterfaces))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.directconnect.AmazonDirectConnectClient client3500
        describeVirtualInterfaces
        (describe-virtual-interfaces-request
         (clojure.core/nth args3499 0))))))))
  (clojure.core/defn
   describe-virtual-interfaces-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [virtual-interface-id
                         request-metric-collector
                         connection-id]}]]),
    :doc "Generate map for describeVirtualInterfaces, describeVirtualInterfaces"}
   ([credentials__1609__auto__]
    {:args [],
     :client :directconnect,
     :fn :describe-virtual-interfaces,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :directconnect,
     :fn :describe-virtual-interfaces,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-virtual-interfaces
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [virtual-interface-id
                         request-metric-collector
                         connection-id]}]]),
    :doc "Call describeVirtualInterfaces, describeVirtualInterfaces"}
   [credentials3502 & args3503]
   (clojure.core/let
    [^com.amazonaws.services.directconnect.AmazonDirectConnectClient client3504
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials3502)]
    (clojure.core/case
     (clojure.core/count args3503)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.directconnect.AmazonDirectConnectClient client3504
       describeVirtualInterfaces))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.directconnect.AmazonDirectConnectClient client3504
       describeVirtualInterfaces
       (describe-virtual-interfaces-request
        (clojure.core/nth args3503 0))))))))
 (do
  (clojure.core/defmethod
   directconnect
   :describe-connections
   [m3505]
   (clojure.core/let
    [credentials3506 (:credentials m3505) args3507 (:args m3505)]
    (clojure.core/let
     [^com.amazonaws.services.directconnect.AmazonDirectConnectClient client3508
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials3506)]
     (clojure.core/case
      (clojure.core/count args3507)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.directconnect.AmazonDirectConnectClient client3508
        describeConnections))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.directconnect.AmazonDirectConnectClient client3508
        describeConnections
        (describe-connections-request (clojure.core/nth args3507 0))))))))
  (clojure.core/defn
   describe-connections-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [request-metric-collector connection-id]}]]),
    :doc "Generate map for describeConnections, describeConnections"}
   ([credentials__1609__auto__]
    {:args [],
     :client :directconnect,
     :fn :describe-connections,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :directconnect,
     :fn :describe-connections,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-connections
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [request-metric-collector connection-id]}]]),
    :doc "Call describeConnections, describeConnections"}
   [credentials3510 & args3511]
   (clojure.core/let
    [^com.amazonaws.services.directconnect.AmazonDirectConnectClient client3512
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials3510)]
    (clojure.core/case
     (clojure.core/count args3511)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.directconnect.AmazonDirectConnectClient client3512
       describeConnections))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.directconnect.AmazonDirectConnectClient client3512
       describeConnections
       (describe-connections-request (clojure.core/nth args3511 0))))))))
 (do
  (clojure.core/defmethod
   directconnect
   :allocate-public-virtual-interface
   [m3513]
   (clojure.core/let
    [credentials3514 (:credentials m3513) args3515 (:args m3513)]
    (clojure.core/let
     [^com.amazonaws.services.directconnect.AmazonDirectConnectClient client3516
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials3514)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.directconnect.AmazonDirectConnectClient client3516
       allocatePublicVirtualInterface
       (allocate-public-virtual-interface-request
        (clojure.core/nth args3515 0)))))))
  (clojure.core/defn
   allocate-public-virtual-interface-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         owner-account
                         new-public-virtual-interface-allocation
                         connection-id]}]]),
    :doc "Generate map for allocatePublicVirtualInterface"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :directconnect,
     :fn :allocate-public-virtual-interface,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   allocate-public-virtual-interface
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         owner-account
                         new-public-virtual-interface-allocation
                         connection-id]}]]),
    :doc "Call allocatePublicVirtualInterface"}
   [credentials3518 & args3519]
   (clojure.core/let
    [^com.amazonaws.services.directconnect.AmazonDirectConnectClient client3520
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials3518)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.directconnect.AmazonDirectConnectClient client3520
      allocatePublicVirtualInterface
      (allocate-public-virtual-interface-request
       (clojure.core/nth args3519 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :describe-interconnects
   [m3521]
   (clojure.core/let
    [credentials3522 (:credentials m3521) args3523 (:args m3521)]
    (clojure.core/let
     [^com.amazonaws.services.directconnect.AmazonDirectConnectClient client3524
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials3522)]
     (clojure.core/case
      (clojure.core/count args3523)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.directconnect.AmazonDirectConnectClient client3524
        describeInterconnects
        (describe-interconnects-request (clojure.core/nth args3523 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.directconnect.AmazonDirectConnectClient client3524
        describeInterconnects))))))
  (clojure.core/defn
   describe-interconnects-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector interconnect-id]}]
                [credentials]]),
    :doc "Generate map for describeInterconnects, describeInterconnects"}
   ([credentials__1609__auto__]
    {:args [],
     :client :directconnect,
     :fn :describe-interconnects,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :directconnect,
     :fn :describe-interconnects,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-interconnects
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector interconnect-id]}]
                [credentials]]),
    :doc "Call describeInterconnects, describeInterconnects"}
   [credentials3526 & args3527]
   (clojure.core/let
    [^com.amazonaws.services.directconnect.AmazonDirectConnectClient client3528
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials3526)]
    (clojure.core/case
     (clojure.core/count args3527)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.directconnect.AmazonDirectConnectClient client3528
       describeInterconnects
       (describe-interconnects-request (clojure.core/nth args3527 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.directconnect.AmazonDirectConnectClient client3528
       describeInterconnects))))))
 (do
  (clojure.core/defmethod
   directconnect
   :create-connection
   [m3529]
   (clojure.core/let
    [credentials3530 (:credentials m3529) args3531 (:args m3529)]
    (clojure.core/let
     [^com.amazonaws.services.directconnect.AmazonDirectConnectClient client3532
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials3530)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.directconnect.AmazonDirectConnectClient client3532
       createConnection
       (create-connection-request (clojure.core/nth args3531 0)))))))
  (clojure.core/defn
   create-connection-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         location
                         connection-name
                         bandwidth]}]]),
    :doc "Generate map for createConnection"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :directconnect,
     :fn :create-connection,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   create-connection
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         location
                         connection-name
                         bandwidth]}]]),
    :doc "Call createConnection"}
   [credentials3534 & args3535]
   (clojure.core/let
    [^com.amazonaws.services.directconnect.AmazonDirectConnectClient client3536
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials3534)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.directconnect.AmazonDirectConnectClient client3536
      createConnection
      (create-connection-request (clojure.core/nth args3535 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :delete-interconnect
   [m3537]
   (clojure.core/let
    [credentials3538 (:credentials m3537) args3539 (:args m3537)]
    (clojure.core/let
     [^com.amazonaws.services.directconnect.AmazonDirectConnectClient client3540
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials3538)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.directconnect.AmazonDirectConnectClient client3540
       deleteInterconnect
       (delete-interconnect-request (clojure.core/nth args3539 0)))))))
  (clojure.core/defn
   delete-interconnect-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector interconnect-id]}]]),
    :doc "Generate map for deleteInterconnect"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :directconnect,
     :fn :delete-interconnect,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   delete-interconnect
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector interconnect-id]}]]),
    :doc "Call deleteInterconnect"}
   [credentials3542 & args3543]
   (clojure.core/let
    [^com.amazonaws.services.directconnect.AmazonDirectConnectClient client3544
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials3542)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.directconnect.AmazonDirectConnectClient client3544
      deleteInterconnect
      (delete-interconnect-request (clojure.core/nth args3543 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :describe-virtual-gateways
   [m3545]
   (clojure.core/let
    [credentials3546 (:credentials m3545) args3547 (:args m3545)]
    (clojure.core/let
     [^com.amazonaws.services.directconnect.AmazonDirectConnectClient client3548
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials3546)]
     (clojure.core/case
      (clojure.core/count args3547)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.directconnect.AmazonDirectConnectClient client3548
        describeVirtualGateways))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.directconnect.AmazonDirectConnectClient client3548
        describeVirtualGateways
        (describe-virtual-gateways-request
         (clojure.core/nth args3547 0))))))))
  (clojure.core/defn
   describe-virtual-gateways-map
   {:arglists (quote
               [[credentials]
                [credentials {:keys [request-metric-collector]}]]),
    :doc "Generate map for describeVirtualGateways, describeVirtualGateways"}
   ([credentials__1609__auto__]
    {:args [],
     :client :directconnect,
     :fn :describe-virtual-gateways,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :directconnect,
     :fn :describe-virtual-gateways,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-virtual-gateways
   {:arglists (quote
               [[credentials]
                [credentials {:keys [request-metric-collector]}]]),
    :doc "Call describeVirtualGateways, describeVirtualGateways"}
   [credentials3550 & args3551]
   (clojure.core/let
    [^com.amazonaws.services.directconnect.AmazonDirectConnectClient client3552
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials3550)]
    (clojure.core/case
     (clojure.core/count args3551)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.directconnect.AmazonDirectConnectClient client3552
       describeVirtualGateways))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.directconnect.AmazonDirectConnectClient client3552
       describeVirtualGateways
       (describe-virtual-gateways-request
        (clojure.core/nth args3551 0)))))))))
