(ns
 com.palletops.awaze.ec2
 (:refer-clojure :exclude [filter])
 (:require [com.palletops.awaze.common]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :ec2
  [___1561__auto__
   ^com.amazonaws.auth.BasicAWSCredentials credentials__1562__auto__]
  (new
   com.amazonaws.services.ec2.AmazonEC2Client
   credentials__1562__auto__))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.VolumeType volume-type
  [m5259]
  (java.lang.Enum/valueOf
   com.amazonaws.services.ec2.model.VolumeType
   (clojure.core/name m5259)))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.PermissionGroup permission-group
  [m5262]
  (java.lang.Enum/valueOf
   com.amazonaws.services.ec2.model.PermissionGroup
   (clojure.core/name m5262)))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.Tenancy tenancy
  [m5265]
  (java.lang.Enum/valueOf
   com.amazonaws.services.ec2.model.Tenancy
   (clojure.core/name m5265)))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DiskImageFormat disk-image-format
  [m5268]
  (java.lang.Enum/valueOf
   com.amazonaws.services.ec2.model.DiskImageFormat
   (clojure.core/name m5268)))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.PrivateIpAddressSpecification private-ip-address-specification
  [m5271]
  (clojure.core/let
   [bean5270
    (new
     com.amazonaws.services.ec2.model.PrivateIpAddressSpecification)]
   (clojure.core/when-let
    [v5272 (:private-ip-address m5271)]
    (. bean5270 setPrivateIpAddress (clojure.core/str v5272)))
   (clojure.core/when-let
    [v5272 (:primary m5271)]
    (. bean5270 setPrimary (clojure.core/boolean v5272)))
   bean5270))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.EbsBlockDevice ebs-block-device
  [m5274]
  (clojure.core/let
   [bean5273 (new com.amazonaws.services.ec2.model.EbsBlockDevice)]
   (clojure.core/when-let
    [v5275 (:snapshot-id m5274)]
    (. bean5273 setSnapshotId (clojure.core/str v5275)))
   (clojure.core/when-let
    [v5275 (:volume-size m5274)]
    (. bean5273 setVolumeSize (clojure.core/int v5275)))
   (clojure.core/when-let
    [v5275 (:iops m5274)]
    (. bean5273 setIops (clojure.core/int v5275)))
   (clojure.core/when-let
    [v5275 (:volume-type m5274)]
    (. bean5273 setVolumeType (volume-type v5275)))
   (clojure.core/when-let
    [v5275 (:volume-type m5274)]
    (. bean5273 setVolumeType (clojure.core/str v5275)))
   (clojure.core/when-let
    [v5275 (:delete-on-termination m5274)]
    (. bean5273 setDeleteOnTermination (clojure.core/boolean v5275)))
   bean5273))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.UserIdGroupPair user-id-group-pair
  [m5277]
  (clojure.core/let
   [bean5276 (new com.amazonaws.services.ec2.model.UserIdGroupPair)]
   (clojure.core/when-let
    [v5278 (:group-name m5277)]
    (. bean5276 setGroupName (clojure.core/str v5278)))
   (clojure.core/when-let
    [v5278 (:group-id m5277)]
    (. bean5276 setGroupId (clojure.core/str v5278)))
   (clojure.core/when-let
    [v5278 (:user-id m5277)]
    (. bean5276 setUserId (clojure.core/str v5278)))
   bean5276))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.CurrencyCodeValues currency-code-values
  [m5280]
  (java.lang.Enum/valueOf
   com.amazonaws.services.ec2.model.CurrencyCodeValues
   (clojure.core/name m5280)))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.LaunchPermission launch-permission
  [m5283]
  (clojure.core/let
   [bean5282 (new com.amazonaws.services.ec2.model.LaunchPermission)]
   (clojure.core/when-let
    [v5284 (:user-id m5283)]
    (. bean5282 setUserId (clojure.core/str v5284)))
   (clojure.core/when-let
    [v5284 (:group m5283)]
    (. bean5282 setGroup (clojure.core/str v5284)))
   (clojure.core/when-let
    [v5284 (:group m5283)]
    (. bean5282 setGroup (permission-group v5284)))
   bean5282))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.CreateVolumePermission create-volume-permission
  [m5286]
  (clojure.core/let
   [bean5285
    (new com.amazonaws.services.ec2.model.CreateVolumePermission)]
   (clojure.core/when-let
    [v5287 (:user-id m5286)]
    (. bean5285 setUserId (clojure.core/str v5287)))
   (clojure.core/when-let
    [v5287 (:group m5286)]
    (. bean5285 setGroup (clojure.core/str v5287)))
   (clojure.core/when-let
    [v5287 (:group m5286)]
    (. bean5285 setGroup (permission-group v5287)))
   bean5285))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.InstanceType instance-type
  [m5289]
  (.
   com.amazonaws.services.ec2.model.InstanceType
   fromValue
   (clojure.core/name m5289)))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.ShutdownBehavior shutdown-behavior
  [m5292]
  (java.lang.Enum/valueOf
   com.amazonaws.services.ec2.model.ShutdownBehavior
   (clojure.core/name m5292)))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.Placement placement
  [m5295]
  (clojure.core/let
   [bean5294 (new com.amazonaws.services.ec2.model.Placement)]
   (clojure.core/when-let
    [v5296 (:group-name m5295)]
    (. bean5294 setGroupName (clojure.core/str v5296)))
   (clojure.core/when-let
    [v5296 (:availability-zone m5295)]
    (. bean5294 setAvailabilityZone (clojure.core/str v5296)))
   (clojure.core/when-let
    [v5296 (:tenancy m5295)]
    (. bean5294 setTenancy (clojure.core/str v5296)))
   (clojure.core/when-let
    [v5296 (:tenancy m5295)]
    (. bean5294 setTenancy (tenancy v5296)))
   bean5294))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.ArchitectureValues architecture-values
  [m5298]
  (java.lang.Enum/valueOf
   com.amazonaws.services.ec2.model.ArchitectureValues
   (clojure.core/name m5298)))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DiskImageDetail disk-image-detail
  [m5301]
  (clojure.core/let
   [bean5300 (new com.amazonaws.services.ec2.model.DiskImageDetail)]
   (clojure.core/when-let
    [v5302 (:bytes m5301)]
    (. bean5300 setBytes (clojure.core/long v5302)))
   (clojure.core/when-let
    [v5302 (:import-manifest-url m5301)]
    (. bean5300 setImportManifestUrl (clojure.core/str v5302)))
   (clojure.core/when-let
    [v5302 (:format m5301)]
    (. bean5300 setFormat (disk-image-format v5302)))
   (clojure.core/when-let
    [v5302 (:format m5301)]
    (. bean5300 setFormat (clojure.core/str v5302)))
   bean5300))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.VolumeDetail volume-detail
  [m5304]
  (clojure.core/let
   [bean5303 (new com.amazonaws.services.ec2.model.VolumeDetail)]
   (clojure.core/when-let
    [v5305 (:size m5304)]
    (. bean5303 setSize (clojure.core/long v5305)))
   bean5303))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.EbsInstanceBlockDeviceSpecification ebs-instance-block-device-specification
  [m5307]
  (clojure.core/let
   [bean5306
    (new
     com.amazonaws.services.ec2.model.EbsInstanceBlockDeviceSpecification)]
   (clojure.core/when-let
    [v5308 (:volume-id m5307)]
    (. bean5306 setVolumeId (clojure.core/str v5308)))
   (clojure.core/when-let
    [v5308 (:delete-on-termination m5307)]
    (. bean5306 setDeleteOnTermination (clojure.core/boolean v5308)))
   bean5306))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.S3Storage s3storage
  [m5310]
  (clojure.core/let
   [bean5309 (new com.amazonaws.services.ec2.model.S3Storage)]
   (clojure.core/when-let
    [v5311 (:awsaccess-key-id m5310)]
    (. bean5309 setAWSAccessKeyId (clojure.core/str v5311)))
   (clojure.core/when-let
    [v5311 (:upload-policy m5310)]
    (. bean5309 setUploadPolicy (clojure.core/str v5311)))
   (clojure.core/when-let
    [v5311 (:upload-policy-signature m5310)]
    (. bean5309 setUploadPolicySignature (clojure.core/str v5311)))
   (clojure.core/when-let
    [v5311 (:prefix m5310)]
    (. bean5309 setPrefix (clojure.core/str v5311)))
   (clojure.core/when-let
    [v5311 (:bucket m5310)]
    (. bean5309 setBucket (clojure.core/str v5311)))
   bean5309))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.ContainerFormat container-format
  [m5313]
  (java.lang.Enum/valueOf
   com.amazonaws.services.ec2.model.ContainerFormat
   (clojure.core/name m5313)))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.InstanceNetworkInterfaceSpecification instance-network-interface-specification
  [m5316]
  (clojure.core/let
   [bean5315
    (new
     com.amazonaws.services.ec2.model.InstanceNetworkInterfaceSpecification)]
   (clojure.core/when-let
    [v5317 (:network-interface-id m5316)]
    (. bean5315 setNetworkInterfaceId (clojure.core/str v5317)))
   (clojure.core/when-let
    [v5317 (:subnet-id m5316)]
    (. bean5315 setSubnetId (clojure.core/str v5317)))
   (clojure.core/when-let
    [v5317 (:private-ip-address m5316)]
    (. bean5315 setPrivateIpAddress (clojure.core/str v5317)))
   (clojure.core/when-let
    [v5317 (:groups m5316)]
    (.
     bean5315
     setGroups
     (clojure.core/map
      (clojure.core/fn [arg5321] (clojure.core/str arg5321))
      v5317)))
   (clojure.core/when-let
    [v5317 (:private-ip-addresses m5316)]
    (.
     bean5315
     setPrivateIpAddresses
     (clojure.core/map
      (clojure.core/fn
       [arg5322]
       (private-ip-address-specification arg5322))
      v5317)))
   (clojure.core/when-let
    [v5317 (:secondary-private-ip-address-count m5316)]
    (.
     bean5315
     setSecondaryPrivateIpAddressCount
     (clojure.core/int v5317)))
   (clojure.core/when-let
    [v5317 (:device-index m5316)]
    (. bean5315 setDeviceIndex (clojure.core/int v5317)))
   (clojure.core/when-let
    [v5317 (:associate-public-ip-address m5316)]
    (.
     bean5315
     setAssociatePublicIpAddress
     (clojure.core/boolean v5317)))
   (clojure.core/when-let
    [v5317 (:description m5316)]
    (. bean5315 setDescription (clojure.core/str v5317)))
   (clojure.core/when-let
    [v5317 (:delete-on-termination m5316)]
    (. bean5315 setDeleteOnTermination (clojure.core/boolean v5317)))
   bean5315))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.BlockDeviceMapping block-device-mapping
  [m5319]
  (clojure.core/let
   [bean5318
    (new com.amazonaws.services.ec2.model.BlockDeviceMapping)]
   (clojure.core/when-let
    [v5320 (:virtual-name m5319)]
    (. bean5318 setVirtualName (clojure.core/str v5320)))
   (clojure.core/when-let
    [v5320 (:device-name m5319)]
    (. bean5318 setDeviceName (clojure.core/str v5320)))
   (clojure.core/when-let
    [v5320 (:ebs m5319)]
    (. bean5318 setEbs (ebs-block-device v5320)))
   (clojure.core/when-let
    [v5320 (:no-device m5319)]
    (. bean5318 setNoDevice (clojure.core/str v5320)))
   bean5318))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.IamInstanceProfileSpecification iam-instance-profile-specification
  [m5324]
  (clojure.core/let
   [bean5323
    (new
     com.amazonaws.services.ec2.model.IamInstanceProfileSpecification)]
   (clojure.core/when-let
    [v5325 (:name m5324)]
    (. bean5323 setName (clojure.core/str v5325)))
   (clojure.core/when-let
    [v5325 (:arn m5324)]
    (. bean5323 setArn (clojure.core/str v5325)))
   bean5323))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.SpotPlacement spot-placement
  [m5327]
  (clojure.core/let
   [bean5326 (new com.amazonaws.services.ec2.model.SpotPlacement)]
   (clojure.core/when-let
    [v5328 (:group-name m5327)]
    (. bean5326 setGroupName (clojure.core/str v5328)))
   (clojure.core/when-let
    [v5328 (:availability-zone m5327)]
    (. bean5326 setAvailabilityZone (clojure.core/str v5328)))
   bean5326))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.GroupIdentifier group-identifier
  [m5330]
  (clojure.core/let
   [bean5329 (new com.amazonaws.services.ec2.model.GroupIdentifier)]
   (clojure.core/when-let
    [v5331 (:group-name m5330)]
    (. bean5329 setGroupName (clojure.core/str v5331)))
   (clojure.core/when-let
    [v5331 (:group-id m5330)]
    (. bean5329 setGroupId (clojure.core/str v5331)))
   bean5329))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.Filter filter
  [m5333]
  (clojure.core/let
   [bean5332 (new com.amazonaws.services.ec2.model.Filter)]
   (clojure.core/when-let
    [v5334 (:name m5333)]
    (. bean5332 setName (clojure.core/str v5334)))
   (clojure.core/when-let
    [v5334 (:values m5333)]
    (.
     bean5332
     setValues
     (clojure.core/map
      (clojure.core/fn [arg5338] (clojure.core/str arg5338))
      v5334)))
   bean5332))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.RuleAction rule-action
  [m5336]
  (java.lang.Enum/valueOf
   com.amazonaws.services.ec2.model.RuleAction
   (clojure.core/name m5336)))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.IcmpTypeCode icmp-type-code
  [m5340]
  (clojure.core/let
   [bean5339 (new com.amazonaws.services.ec2.model.IcmpTypeCode)]
   (clojure.core/when-let
    [v5341 (:type m5340)]
    (. bean5339 setType (clojure.core/int v5341)))
   (clojure.core/when-let
    [v5341 (:code m5340)]
    (. bean5339 setCode (clojure.core/int v5341)))
   bean5339))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.PortRange port-range
  [m5343]
  (clojure.core/let
   [bean5342 (new com.amazonaws.services.ec2.model.PortRange)]
   (clojure.core/when-let
    [v5344 (:to m5343)]
    (. bean5342 setTo (clojure.core/int v5344)))
   (clojure.core/when-let
    [v5344 (:from m5343)]
    (. bean5342 setFrom (clojure.core/int v5344)))
   bean5342))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.IpPermission ip-permission
  [m5346]
  (clojure.core/let
   [bean5345 (new com.amazonaws.services.ec2.model.IpPermission)]
   (clojure.core/when-let
    [v5347 (:ip-protocol m5346)]
    (. bean5345 setIpProtocol (clojure.core/str v5347)))
   (clojure.core/when-let
    [v5347 (:from-port m5346)]
    (. bean5345 setFromPort (clojure.core/int v5347)))
   (clojure.core/when-let
    [v5347 (:to-port m5346)]
    (. bean5345 setToPort (clojure.core/int v5347)))
   (clojure.core/when-let
    [v5347 (:user-id-group-pairs m5346)]
    (.
     bean5345
     setUserIdGroupPairs
     (clojure.core/map
      (clojure.core/fn [arg5351] (user-id-group-pair arg5351))
      v5347)))
   (clojure.core/when-let
    [v5347 (:ip-ranges m5346)]
    (.
     bean5345
     setIpRanges
     (clojure.core/map
      (clojure.core/fn [arg5352] (clojure.core/str arg5352))
      v5347)))
   bean5345))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.PriceScheduleSpecification price-schedule-specification
  [m5349]
  (clojure.core/let
   [bean5348
    (new com.amazonaws.services.ec2.model.PriceScheduleSpecification)]
   (clojure.core/when-let
    [v5350 (:currency-code m5349)]
    (. bean5348 setCurrencyCode (currency-code-values v5350)))
   (clojure.core/when-let
    [v5350 (:currency-code m5349)]
    (. bean5348 setCurrencyCode (clojure.core/str v5350)))
   (clojure.core/when-let
    [v5350 (:term m5349)]
    (. bean5348 setTerm (clojure.core/long v5350)))
   (clojure.core/when-let
    [v5350 (:price m5349)]
    (. bean5348 setPrice (clojure.core/double v5350)))
   bean5348))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.ResetImageAttributeName reset-image-attribute-name
  [m5354]
  (java.lang.Enum/valueOf
   com.amazonaws.services.ec2.model.ResetImageAttributeName
   (clojure.core/name m5354)))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.LaunchPermissionModifications launch-permission-modifications
  [m5357]
  (clojure.core/let
   [bean5356
    (new
     com.amazonaws.services.ec2.model.LaunchPermissionModifications)]
   (clojure.core/when-let
    [v5358 (:add m5357)]
    (.
     bean5356
     setAdd
     (clojure.core/map
      (clojure.core/fn [arg5362] (launch-permission arg5362))
      v5358)))
   (clojure.core/when-let
    [v5358 (:remove m5357)]
    (.
     bean5356
     setRemove
     (clojure.core/map
      (clojure.core/fn [arg5363] (launch-permission arg5363))
      v5358)))
   bean5356))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.SnapshotAttributeName snapshot-attribute-name
  [m5360]
  (java.lang.Enum/valueOf
   com.amazonaws.services.ec2.model.SnapshotAttributeName
   (clojure.core/name m5360)))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.ImageAttributeName image-attribute-name
  [m5365]
  (java.lang.Enum/valueOf
   com.amazonaws.services.ec2.model.ImageAttributeName
   (clojure.core/name m5365)))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.ReportStatusType report-status-type
  [m5368]
  (java.lang.Enum/valueOf
   com.amazonaws.services.ec2.model.ReportStatusType
   (clojure.core/name m5368)))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.Tag tag
  [m5371]
  (clojure.core/let
   [bean5370 (new com.amazonaws.services.ec2.model.Tag)]
   (clojure.core/when-let
    [v5372 (:value m5371)]
    (. bean5370 setValue (clojure.core/str v5372)))
   (clojure.core/when-let
    [v5372 (:key m5371)]
    (. bean5370 setKey (clojure.core/str v5372)))
   bean5370))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.CreateVolumePermissionModifications create-volume-permission-modifications
  [m5374]
  (clojure.core/let
   [bean5373
    (new
     com.amazonaws.services.ec2.model.CreateVolumePermissionModifications)]
   (clojure.core/when-let
    [v5375 (:add m5374)]
    (.
     bean5373
     setAdd
     (clojure.core/map
      (clojure.core/fn [arg5379] (create-volume-permission arg5379))
      v5375)))
   (clojure.core/when-let
    [v5375 (:remove m5374)]
    (.
     bean5373
     setRemove
     (clojure.core/map
      (clojure.core/fn [arg5380] (create-volume-permission arg5380))
      v5375)))
   bean5373))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.PlacementStrategy placement-strategy
  [m5377]
  (java.lang.Enum/valueOf
   com.amazonaws.services.ec2.model.PlacementStrategy
   (clojure.core/name m5377)))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.ReservedInstancesConfiguration reserved-instances-configuration
  [m5382]
  (clojure.core/let
   [bean5381
    (new
     com.amazonaws.services.ec2.model.ReservedInstancesConfiguration)]
   (clojure.core/when-let
    [v5383 (:platform m5382)]
    (. bean5381 setPlatform (clojure.core/str v5383)))
   (clojure.core/when-let
    [v5383 (:instance-type m5382)]
    (. bean5381 setInstanceType (instance-type v5383)))
   (clojure.core/when-let
    [v5383 (:instance-type m5382)]
    (. bean5381 setInstanceType (clojure.core/str v5383)))
   (clojure.core/when-let
    [v5383 (:availability-zone m5382)]
    (. bean5381 setAvailabilityZone (clojure.core/str v5383)))
   (clojure.core/when-let
    [v5383 (:instance-count m5382)]
    (. bean5381 setInstanceCount (clojure.core/int v5383)))
   bean5381))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.VpcAttributeName vpc-attribute-name
  [m5385]
  (java.lang.Enum/valueOf
   com.amazonaws.services.ec2.model.VpcAttributeName
   (clojure.core/name m5385)))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.InstanceLicenseSpecification instance-license-specification
  [m5388]
  (clojure.core/let
   [bean5387
    (new
     com.amazonaws.services.ec2.model.InstanceLicenseSpecification)]
   (clojure.core/when-let
    [v5389 (:pool m5388)]
    (. bean5387 setPool (clojure.core/str v5389)))
   bean5387))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.OfferingTypeValues offering-type-values
  [m5391]
  (java.lang.Enum/valueOf
   com.amazonaws.services.ec2.model.OfferingTypeValues
   (clojure.core/name m5391)))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.PlatformValues platform-values
  [m5394]
  (java.lang.Enum/valueOf
   com.amazonaws.services.ec2.model.PlatformValues
   (clojure.core/name m5394)))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.ImportInstanceLaunchSpecification import-instance-launch-specification
  [m5397]
  (clojure.core/let
   [bean5396
    (new
     com.amazonaws.services.ec2.model.ImportInstanceLaunchSpecification)]
   (clojure.core/when-let
    [v5398 (:additional-info m5397)]
    (. bean5396 setAdditionalInfo (clojure.core/str v5398)))
   (clojure.core/when-let
    [v5398 (:group-names m5397)]
    (.
     bean5396
     setGroupNames
     (clojure.core/map
      (clojure.core/fn [arg5402] (clojure.core/str arg5402))
      v5398)))
   (clojure.core/when-let
    [v5398 (:subnet-id m5397)]
    (. bean5396 setSubnetId (clojure.core/str v5398)))
   (clojure.core/when-let
    [v5398 (:private-ip-address m5397)]
    (. bean5396 setPrivateIpAddress (clojure.core/str v5398)))
   (clojure.core/when-let
    [v5398 (:monitoring m5397)]
    (. bean5396 setMonitoring (clojure.core/boolean v5398)))
   (clojure.core/when-let
    [v5398 (:instance-initiated-shutdown-behavior m5397)]
    (.
     bean5396
     setInstanceInitiatedShutdownBehavior
     (clojure.core/str v5398)))
   (clojure.core/when-let
    [v5398 (:instance-initiated-shutdown-behavior m5397)]
    (.
     bean5396
     setInstanceInitiatedShutdownBehavior
     (shutdown-behavior v5398)))
   (clojure.core/when-let
    [v5398 (:user-data m5397)]
    (. bean5396 setUserData (clojure.core/str v5398)))
   (clojure.core/when-let
    [v5398 (:instance-type m5397)]
    (. bean5396 setInstanceType (instance-type v5398)))
   (clojure.core/when-let
    [v5398 (:instance-type m5397)]
    (. bean5396 setInstanceType (clojure.core/str v5398)))
   (clojure.core/when-let
    [v5398 (:placement m5397)]
    (. bean5396 setPlacement (placement v5398)))
   (clojure.core/when-let
    [v5398 (:architecture m5397)]
    (. bean5396 setArchitecture (architecture-values v5398)))
   (clojure.core/when-let
    [v5398 (:architecture m5397)]
    (. bean5396 setArchitecture (clojure.core/str v5398)))
   bean5396))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DiskImage disk-image
  [m5400]
  (clojure.core/let
   [bean5399 (new com.amazonaws.services.ec2.model.DiskImage)]
   (clojure.core/when-let
    [v5401 (:image m5400)]
    (. bean5399 setImage (disk-image-detail v5401)))
   (clojure.core/when-let
    [v5401 (:volume m5400)]
    (. bean5399 setVolume (volume-detail v5401)))
   (clojure.core/when-let
    [v5401 (:description m5400)]
    (. bean5399 setDescription (clojure.core/str v5401)))
   bean5399))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DomainType domain-type
  [m5404]
  (java.lang.Enum/valueOf
   com.amazonaws.services.ec2.model.DomainType
   (clojure.core/name m5404)))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.NetworkInterfaceAttachmentChanges network-interface-attachment-changes
  [m5407]
  (clojure.core/let
   [bean5406
    (new
     com.amazonaws.services.ec2.model.NetworkInterfaceAttachmentChanges)]
   (clojure.core/when-let
    [v5408 (:attachment-id m5407)]
    (. bean5406 setAttachmentId (clojure.core/str v5408)))
   (clojure.core/when-let
    [v5408 (:delete-on-termination m5407)]
    (. bean5406 setDeleteOnTermination (clojure.core/boolean v5408)))
   bean5406))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.VolumeAttributeName volume-attribute-name
  [m5410]
  (java.lang.Enum/valueOf
   com.amazonaws.services.ec2.model.VolumeAttributeName
   (clojure.core/name m5410)))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.InstanceBlockDeviceMappingSpecification instance-block-device-mapping-specification
  [m5413]
  (clojure.core/let
   [bean5412
    (new
     com.amazonaws.services.ec2.model.InstanceBlockDeviceMappingSpecification)]
   (clojure.core/when-let
    [v5414 (:virtual-name m5413)]
    (. bean5412 setVirtualName (clojure.core/str v5414)))
   (clojure.core/when-let
    [v5414 (:device-name m5413)]
    (. bean5412 setDeviceName (clojure.core/str v5414)))
   (clojure.core/when-let
    [v5414 (:ebs m5413)]
    (.
     bean5412
     setEbs
     (ebs-instance-block-device-specification v5414)))
   (clojure.core/when-let
    [v5414 (:no-device m5413)]
    (. bean5412 setNoDevice (clojure.core/str v5414)))
   bean5412))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.InstanceAttributeName instance-attribute-name
  [m5416]
  (java.lang.Enum/valueOf
   com.amazonaws.services.ec2.model.InstanceAttributeName
   (clojure.core/name m5416)))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.Storage storage
  [m5419]
  (clojure.core/let
   [bean5418 (new com.amazonaws.services.ec2.model.Storage)]
   (clojure.core/when-let
    [v5420 (:s3 m5419)]
    (. bean5418 setS3 (s3storage v5420)))
   bean5418))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.ReservedInstanceLimitPrice reserved-instance-limit-price
  [m5422]
  (clojure.core/let
   [bean5421
    (new com.amazonaws.services.ec2.model.ReservedInstanceLimitPrice)]
   (clojure.core/when-let
    [v5423 (:currency-code m5422)]
    (. bean5421 setCurrencyCode (clojure.core/str v5423)))
   (clojure.core/when-let
    [v5423 (:currency-code m5422)]
    (. bean5421 setCurrencyCode (currency-code-values v5423)))
   (clojure.core/when-let
    [v5423 (:amount m5422)]
    (. bean5421 setAmount (clojure.core/double v5423)))
   bean5421))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.GatewayType gateway-type
  [m5425]
  (java.lang.Enum/valueOf
   com.amazonaws.services.ec2.model.GatewayType
   (clojure.core/name m5425)))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.RIProductDescription riproduct-description
  [m5428]
  (java.lang.Enum/valueOf
   com.amazonaws.services.ec2.model.RIProductDescription
   (clojure.core/name m5428)))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.ExportEnvironment export-environment
  [m5431]
  (java.lang.Enum/valueOf
   com.amazonaws.services.ec2.model.ExportEnvironment
   (clojure.core/name m5431)))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.ExportToS3TaskSpecification export-to-s3task-specification
  [m5434]
  (clojure.core/let
   [bean5433
    (new com.amazonaws.services.ec2.model.ExportToS3TaskSpecification)]
   (clojure.core/when-let
    [v5435 (:disk-image-format m5434)]
    (. bean5433 setDiskImageFormat (clojure.core/str v5435)))
   (clojure.core/when-let
    [v5435 (:disk-image-format m5434)]
    (. bean5433 setDiskImageFormat (disk-image-format v5435)))
   (clojure.core/when-let
    [v5435 (:container-format m5434)]
    (. bean5433 setContainerFormat (clojure.core/str v5435)))
   (clojure.core/when-let
    [v5435 (:container-format m5434)]
    (. bean5433 setContainerFormat (container-format v5435)))
   (clojure.core/when-let
    [v5435 (:s3bucket m5434)]
    (. bean5433 setS3Bucket (clojure.core/str v5435)))
   (clojure.core/when-let
    [v5435 (:s3prefix m5434)]
    (. bean5433 setS3Prefix (clojure.core/str v5435)))
   bean5433))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.VpnConnectionOptionsSpecification vpn-connection-options-specification
  [m5437]
  (clojure.core/let
   [bean5436
    (new
     com.amazonaws.services.ec2.model.VpnConnectionOptionsSpecification)]
   (clojure.core/when-let
    [v5438 (:static-routes-only m5437)]
    (. bean5436 setStaticRoutesOnly (clojure.core/boolean v5438)))
   bean5436))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.LaunchSpecification launch-specification
  [m5440]
  (clojure.core/let
   [bean5439
    (new com.amazonaws.services.ec2.model.LaunchSpecification)]
   (clojure.core/when-let
    [v5441 (:network-interfaces m5440)]
    (.
     bean5439
     setNetworkInterfaces
     (clojure.core/map
      (clojure.core/fn
       [arg5445]
       (instance-network-interface-specification arg5445))
      v5441)))
   (clojure.core/when-let
    [v5441 (:subnet-id m5440)]
    (. bean5439 setSubnetId (clojure.core/str v5441)))
   (clojure.core/when-let
    [v5441 (:image-id m5440)]
    (. bean5439 setImageId (clojure.core/str v5441)))
   (clojure.core/when-let
    [v5441 (:key-name m5440)]
    (. bean5439 setKeyName (clojure.core/str v5441)))
   (clojure.core/when-let
    [v5441 (:security-groups m5440)]
    (.
     bean5439
     setSecurityGroups
     (clojure.core/map
      (clojure.core/fn [arg5446] (clojure.core/str arg5446))
      v5441)))
   (clojure.core/when-let
    [v5441 (:user-data m5440)]
    (. bean5439 setUserData (clojure.core/str v5441)))
   (clojure.core/when-let
    [v5441 (:instance-type m5440)]
    (. bean5439 setInstanceType (instance-type v5441)))
   (clojure.core/when-let
    [v5441 (:instance-type m5440)]
    (. bean5439 setInstanceType (clojure.core/str v5441)))
   (clojure.core/when-let
    [v5441 (:kernel-id m5440)]
    (. bean5439 setKernelId (clojure.core/str v5441)))
   (clojure.core/when-let
    [v5441 (:ramdisk-id m5440)]
    (. bean5439 setRamdiskId (clojure.core/str v5441)))
   (clojure.core/when-let
    [v5441 (:block-device-mappings m5440)]
    (.
     bean5439
     setBlockDeviceMappings
     (clojure.core/map
      (clojure.core/fn [arg5447] (block-device-mapping arg5447))
      v5441)))
   (clojure.core/when-let
    [v5441 (:iam-instance-profile m5440)]
    (.
     bean5439
     setIamInstanceProfile
     (iam-instance-profile-specification v5441)))
   (clojure.core/when-let
    [v5441 (:ebs-optimized m5440)]
    (. bean5439 setEbsOptimized (clojure.core/boolean v5441)))
   (clojure.core/when-let
    [v5441 (:placement m5440)]
    (. bean5439 setPlacement (spot-placement v5441)))
   (clojure.core/when-let
    [v5441 (:all-security-groups m5440)]
    (.
     bean5439
     setAllSecurityGroups
     (clojure.core/map
      (clojure.core/fn [arg5448] (group-identifier arg5448))
      v5441)))
   (clojure.core/when-let
    [v5441 (:addressing-type m5440)]
    (. bean5439 setAddressingType (clojure.core/str v5441)))
   (clojure.core/when-let
    [v5441 (:monitoring-enabled m5440)]
    (. bean5439 setMonitoringEnabled (clojure.core/boolean v5441)))
   bean5439))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.SpotInstanceType spot-instance-type
  [m5443]
  (java.lang.Enum/valueOf
   com.amazonaws.services.ec2.model.SpotInstanceType
   (clojure.core/name m5443)))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DhcpConfiguration dhcp-configuration
  [m5450]
  (clojure.core/let
   [bean5449 (new com.amazonaws.services.ec2.model.DhcpConfiguration)]
   (clojure.core/when-let
    [v5451 (:values m5450)]
    (.
     bean5449
     setValues
     (clojure.core/map
      (clojure.core/fn [arg5455] (clojure.core/str arg5455))
      v5451)))
   (clojure.core/when-let
    [v5451 (:key m5450)]
    (. bean5449 setKey (clojure.core/str v5451)))
   bean5449))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DescribeSecurityGroupsRequest describe-security-groups-request
  [m5453]
  (clojure.core/let
   [bean5452
    (new
     com.amazonaws.services.ec2.model.DescribeSecurityGroupsRequest)]
   (clojure.core/when-let
    [v5454 (:filters m5453)]
    (.
     bean5452
     setFilters
     (clojure.core/map
      (clojure.core/fn [arg5459] (filter arg5459))
      v5454)))
   (clojure.core/when-let
    [v5454 (:group-names m5453)]
    (.
     bean5452
     setGroupNames
     (clojure.core/map
      (clojure.core/fn [arg5460] (clojure.core/str arg5460))
      v5454)))
   (clojure.core/when-let
    [v5454 (:group-ids m5453)]
    (.
     bean5452
     setGroupIds
     (clojure.core/map
      (clojure.core/fn [arg5461] (clojure.core/str arg5461))
      v5454)))
   bean5452))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.CreateVpcRequest create-vpc-request
  [m5457]
  (clojure.core/let
   [bean5456 (new com.amazonaws.services.ec2.model.CreateVpcRequest)]
   (clojure.core/when-let
    [v5458 (:cidr-block m5457)]
    (. bean5456 setCidrBlock (clojure.core/str v5458)))
   (clojure.core/when-let
    [v5458 (:instance-tenancy m5457)]
    (. bean5456 setInstanceTenancy (clojure.core/str v5458)))
   (clojure.core/when-let
    [v5458 (:instance-tenancy m5457)]
    (. bean5456 setInstanceTenancy (tenancy v5458)))
   bean5456))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DeregisterImageRequest deregister-image-request
  [m5463]
  (clojure.core/let
   [bean5462
    (new com.amazonaws.services.ec2.model.DeregisterImageRequest)]
   (clojure.core/when-let
    [v5464 (:image-id m5463)]
    (. bean5462 setImageId (clojure.core/str v5464)))
   bean5462))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.CreateNetworkAclEntryRequest create-network-acl-entry-request
  [m5466]
  (clojure.core/let
   [bean5465
    (new
     com.amazonaws.services.ec2.model.CreateNetworkAclEntryRequest)]
   (clojure.core/when-let
    [v5467 (:protocol m5466)]
    (. bean5465 setProtocol (clojure.core/str v5467)))
   (clojure.core/when-let
    [v5467 (:network-acl-id m5466)]
    (. bean5465 setNetworkAclId (clojure.core/str v5467)))
   (clojure.core/when-let
    [v5467 (:rule-number m5466)]
    (. bean5465 setRuleNumber (clojure.core/int v5467)))
   (clojure.core/when-let
    [v5467 (:rule-action m5466)]
    (. bean5465 setRuleAction (clojure.core/str v5467)))
   (clojure.core/when-let
    [v5467 (:rule-action m5466)]
    (. bean5465 setRuleAction (rule-action v5467)))
   (clojure.core/when-let
    [v5467 (:egress m5466)]
    (. bean5465 setEgress (clojure.core/boolean v5467)))
   (clojure.core/when-let
    [v5467 (:cidr-block m5466)]
    (. bean5465 setCidrBlock (clojure.core/str v5467)))
   (clojure.core/when-let
    [v5467 (:icmp-type-code m5466)]
    (. bean5465 setIcmpTypeCode (icmp-type-code v5467)))
   (clojure.core/when-let
    [v5467 (:port-range m5466)]
    (. bean5465 setPortRange (port-range v5467)))
   bean5465))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.CancelExportTaskRequest cancel-export-task-request
  [m5469]
  (clojure.core/let
   [bean5468
    (new com.amazonaws.services.ec2.model.CancelExportTaskRequest)]
   (clojure.core/when-let
    [v5470 (:export-task-id m5469)]
    (. bean5468 setExportTaskId (clojure.core/str v5470)))
   bean5468))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.RevokeSecurityGroupIngressRequest revoke-security-group-ingress-request
  [m5472]
  (clojure.core/let
   [bean5471
    (new
     com.amazonaws.services.ec2.model.RevokeSecurityGroupIngressRequest)]
   (clojure.core/when-let
    [v5473 (:group-name m5472)]
    (. bean5471 setGroupName (clojure.core/str v5473)))
   (clojure.core/when-let
    [v5473 (:group-id m5472)]
    (. bean5471 setGroupId (clojure.core/str v5473)))
   (clojure.core/when-let
    [v5473 (:source-security-group-name m5472)]
    (. bean5471 setSourceSecurityGroupName (clojure.core/str v5473)))
   (clojure.core/when-let
    [v5473 (:source-security-group-owner-id m5472)]
    (.
     bean5471
     setSourceSecurityGroupOwnerId
     (clojure.core/str v5473)))
   (clojure.core/when-let
    [v5473 (:ip-protocol m5472)]
    (. bean5471 setIpProtocol (clojure.core/str v5473)))
   (clojure.core/when-let
    [v5473 (:from-port m5472)]
    (. bean5471 setFromPort (clojure.core/int v5473)))
   (clojure.core/when-let
    [v5473 (:to-port m5472)]
    (. bean5471 setToPort (clojure.core/int v5473)))
   (clojure.core/when-let
    [v5473 (:cidr-ip m5472)]
    (. bean5471 setCidrIp (clojure.core/str v5473)))
   (clojure.core/when-let
    [v5473 (:ip-permissions m5472)]
    (.
     bean5471
     setIpPermissions
     (clojure.core/map
      (clojure.core/fn [arg5477] (ip-permission arg5477))
      v5473)))
   bean5471))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DescribeRouteTablesRequest describe-route-tables-request
  [m5475]
  (clojure.core/let
   [bean5474
    (new com.amazonaws.services.ec2.model.DescribeRouteTablesRequest)]
   (clojure.core/when-let
    [v5476 (:filters m5475)]
    (.
     bean5474
     setFilters
     (clojure.core/map
      (clojure.core/fn [arg5481] (filter arg5481))
      v5476)))
   (clojure.core/when-let
    [v5476 (:route-table-ids m5475)]
    (.
     bean5474
     setRouteTableIds
     (clojure.core/map
      (clojure.core/fn [arg5482] (clojure.core/str arg5482))
      v5476)))
   bean5474))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.CreateReservedInstancesListingRequest create-reserved-instances-listing-request
  [m5479]
  (clojure.core/let
   [bean5478
    (new
     com.amazonaws.services.ec2.model.CreateReservedInstancesListingRequest)]
   (clojure.core/when-let
    [v5480 (:client-token m5479)]
    (. bean5478 setClientToken (clojure.core/str v5480)))
   (clojure.core/when-let
    [v5480 (:reserved-instances-id m5479)]
    (. bean5478 setReservedInstancesId (clojure.core/str v5480)))
   (clojure.core/when-let
    [v5480 (:price-schedules m5479)]
    (.
     bean5478
     setPriceSchedules
     (clojure.core/map
      (clojure.core/fn
       [arg5486]
       (price-schedule-specification arg5486))
      v5480)))
   (clojure.core/when-let
    [v5480 (:instance-count m5479)]
    (. bean5478 setInstanceCount (clojure.core/int v5480)))
   bean5478))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.ResetImageAttributeRequest reset-image-attribute-request
  [m5484]
  (clojure.core/let
   [bean5483
    (new com.amazonaws.services.ec2.model.ResetImageAttributeRequest)]
   (clojure.core/when-let
    [v5485 (:image-id m5484)]
    (. bean5483 setImageId (clojure.core/str v5485)))
   (clojure.core/when-let
    [v5485 (:attribute m5484)]
    (. bean5483 setAttribute (clojure.core/str v5485)))
   (clojure.core/when-let
    [v5485 (:attribute m5484)]
    (. bean5483 setAttribute (reset-image-attribute-name v5485)))
   bean5483))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DescribeAvailabilityZonesRequest describe-availability-zones-request
  [m5488]
  (clojure.core/let
   [bean5487
    (new
     com.amazonaws.services.ec2.model.DescribeAvailabilityZonesRequest)]
   (clojure.core/when-let
    [v5489 (:filters m5488)]
    (.
     bean5487
     setFilters
     (clojure.core/map
      (clojure.core/fn [arg5493] (filter arg5493))
      v5489)))
   (clojure.core/when-let
    [v5489 (:zone-names m5488)]
    (.
     bean5487
     setZoneNames
     (clojure.core/map
      (clojure.core/fn [arg5494] (clojure.core/str arg5494))
      v5489)))
   bean5487))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DescribeNetworkAclsRequest describe-network-acls-request
  [m5491]
  (clojure.core/let
   [bean5490
    (new com.amazonaws.services.ec2.model.DescribeNetworkAclsRequest)]
   (clojure.core/when-let
    [v5492 (:filters m5491)]
    (.
     bean5490
     setFilters
     (clojure.core/map
      (clojure.core/fn [arg5498] (filter arg5498))
      v5492)))
   (clojure.core/when-let
    [v5492 (:network-acl-ids m5491)]
    (.
     bean5490
     setNetworkAclIds
     (clojure.core/map
      (clojure.core/fn [arg5499] (clojure.core/str arg5499))
      v5492)))
   bean5490))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DescribeVpnGatewaysRequest describe-vpn-gateways-request
  [m5496]
  (clojure.core/let
   [bean5495
    (new com.amazonaws.services.ec2.model.DescribeVpnGatewaysRequest)]
   (clojure.core/when-let
    [v5497 (:filters m5496)]
    (.
     bean5495
     setFilters
     (clojure.core/map
      (clojure.core/fn [arg5503] (filter arg5503))
      v5497)))
   (clojure.core/when-let
    [v5497 (:vpn-gateway-ids m5496)]
    (.
     bean5495
     setVpnGatewayIds
     (clojure.core/map
      (clojure.core/fn [arg5504] (clojure.core/str arg5504))
      v5497)))
   bean5495))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DescribeSnapshotsRequest describe-snapshots-request
  [m5501]
  (clojure.core/let
   [bean5500
    (new com.amazonaws.services.ec2.model.DescribeSnapshotsRequest)]
   (clojure.core/when-let
    [v5502 (:filters m5501)]
    (.
     bean5500
     setFilters
     (clojure.core/map
      (clojure.core/fn [arg5508] (filter arg5508))
      v5502)))
   (clojure.core/when-let
    [v5502 (:snapshot-ids m5501)]
    (.
     bean5500
     setSnapshotIds
     (clojure.core/map
      (clojure.core/fn [arg5509] (clojure.core/str arg5509))
      v5502)))
   (clojure.core/when-let
    [v5502 (:owner-ids m5501)]
    (.
     bean5500
     setOwnerIds
     (clojure.core/map
      (clojure.core/fn [arg5510] (clojure.core/str arg5510))
      v5502)))
   (clojure.core/when-let
    [v5502 (:restorable-by-user-ids m5501)]
    (.
     bean5500
     setRestorableByUserIds
     (clojure.core/map
      (clojure.core/fn [arg5511] (clojure.core/str arg5511))
      v5502)))
   bean5500))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.ModifyImageAttributeRequest modify-image-attribute-request
  [m5506]
  (clojure.core/let
   [bean5505
    (new com.amazonaws.services.ec2.model.ModifyImageAttributeRequest)]
   (clojure.core/when-let
    [v5507 (:value m5506)]
    (. bean5505 setValue (clojure.core/str v5507)))
   (clojure.core/when-let
    [v5507 (:operation-type m5506)]
    (. bean5505 setOperationType (clojure.core/str v5507)))
   (clojure.core/when-let
    [v5507 (:user-ids m5506)]
    (.
     bean5505
     setUserIds
     (clojure.core/map
      (clojure.core/fn [arg5515] (clojure.core/str arg5515))
      v5507)))
   (clojure.core/when-let
    [v5507 (:user-groups m5506)]
    (.
     bean5505
     setUserGroups
     (clojure.core/map
      (clojure.core/fn [arg5516] (clojure.core/str arg5516))
      v5507)))
   (clojure.core/when-let
    [v5507 (:product-codes m5506)]
    (.
     bean5505
     setProductCodes
     (clojure.core/map
      (clojure.core/fn [arg5517] (clojure.core/str arg5517))
      v5507)))
   (clojure.core/when-let
    [v5507 (:launch-permission m5506)]
    (.
     bean5505
     setLaunchPermission
     (launch-permission-modifications v5507)))
   (clojure.core/when-let
    [v5507 (:image-id m5506)]
    (. bean5505 setImageId (clojure.core/str v5507)))
   (clojure.core/when-let
    [v5507 (:attribute m5506)]
    (. bean5505 setAttribute (clojure.core/str v5507)))
   (clojure.core/when-let
    [v5507 (:description m5506)]
    (. bean5505 setDescription (clojure.core/str v5507)))
   bean5505))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DescribeVolumesRequest describe-volumes-request
  [m5513]
  (clojure.core/let
   [bean5512
    (new com.amazonaws.services.ec2.model.DescribeVolumesRequest)]
   (clojure.core/when-let
    [v5514 (:filters m5513)]
    (.
     bean5512
     setFilters
     (clojure.core/map
      (clojure.core/fn [arg5521] (filter arg5521))
      v5514)))
   (clojure.core/when-let
    [v5514 (:volume-ids m5513)]
    (.
     bean5512
     setVolumeIds
     (clojure.core/map
      (clojure.core/fn [arg5522] (clojure.core/str arg5522))
      v5514)))
   bean5512))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.AttachInternetGatewayRequest attach-internet-gateway-request
  [m5519]
  (clojure.core/let
   [bean5518
    (new
     com.amazonaws.services.ec2.model.AttachInternetGatewayRequest)]
   (clojure.core/when-let
    [v5520 (:internet-gateway-id m5519)]
    (. bean5518 setInternetGatewayId (clojure.core/str v5520)))
   (clojure.core/when-let
    [v5520 (:vpc-id m5519)]
    (. bean5518 setVpcId (clojure.core/str v5520)))
   bean5518))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DescribeLicensesRequest describe-licenses-request
  [m5524]
  (clojure.core/let
   [bean5523
    (new com.amazonaws.services.ec2.model.DescribeLicensesRequest)]
   (clojure.core/when-let
    [v5525 (:filters m5524)]
    (.
     bean5523
     setFilters
     (clojure.core/map
      (clojure.core/fn [arg5529] (filter arg5529))
      v5525)))
   (clojure.core/when-let
    [v5525 (:license-ids m5524)]
    (.
     bean5523
     setLicenseIds
     (clojure.core/map
      (clojure.core/fn [arg5530] (clojure.core/str arg5530))
      v5525)))
   bean5523))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DeleteSecurityGroupRequest delete-security-group-request
  [m5527]
  (clojure.core/let
   [bean5526
    (new com.amazonaws.services.ec2.model.DeleteSecurityGroupRequest)]
   (clojure.core/when-let
    [v5528 (:group-name m5527)]
    (. bean5526 setGroupName (clojure.core/str v5528)))
   (clojure.core/when-let
    [v5528 (:group-id m5527)]
    (. bean5526 setGroupId (clojure.core/str v5528)))
   bean5526))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DetachVolumeRequest detach-volume-request
  [m5532]
  (clojure.core/let
   [bean5531
    (new com.amazonaws.services.ec2.model.DetachVolumeRequest)]
   (clojure.core/when-let
    [v5533 (:volume-id m5532)]
    (. bean5531 setVolumeId (clojure.core/str v5533)))
   (clojure.core/when-let
    [v5533 (:device m5532)]
    (. bean5531 setDevice (clojure.core/str v5533)))
   (clojure.core/when-let
    [v5533 (:force m5532)]
    (. bean5531 setForce (clojure.core/boolean v5533)))
   (clojure.core/when-let
    [v5533 (:instance-id m5532)]
    (. bean5531 setInstanceId (clojure.core/str v5533)))
   bean5531))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.ReleaseAddressRequest release-address-request
  [m5535]
  (clojure.core/let
   [bean5534
    (new com.amazonaws.services.ec2.model.ReleaseAddressRequest)]
   (clojure.core/when-let
    [v5536 (:public-ip m5535)]
    (. bean5534 setPublicIp (clojure.core/str v5536)))
   (clojure.core/when-let
    [v5536 (:allocation-id m5535)]
    (. bean5534 setAllocationId (clojure.core/str v5536)))
   bean5534))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.ImportVolumeRequest import-volume-request
  [m5538]
  (clojure.core/let
   [bean5537
    (new com.amazonaws.services.ec2.model.ImportVolumeRequest)]
   (clojure.core/when-let
    [v5539 (:image m5538)]
    (. bean5537 setImage (disk-image-detail v5539)))
   (clojure.core/when-let
    [v5539 (:volume m5538)]
    (. bean5537 setVolume (volume-detail v5539)))
   (clojure.core/when-let
    [v5539 (:availability-zone m5538)]
    (. bean5537 setAvailabilityZone (clojure.core/str v5539)))
   (clojure.core/when-let
    [v5539 (:description m5538)]
    (. bean5537 setDescription (clojure.core/str v5539)))
   bean5537))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DeleteRouteTableRequest delete-route-table-request
  [m5541]
  (clojure.core/let
   [bean5540
    (new com.amazonaws.services.ec2.model.DeleteRouteTableRequest)]
   (clojure.core/when-let
    [v5542 (:route-table-id m5541)]
    (. bean5540 setRouteTableId (clojure.core/str v5542)))
   bean5540))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DescribeSnapshotAttributeRequest describe-snapshot-attribute-request
  [m5544]
  (clojure.core/let
   [bean5543
    (new
     com.amazonaws.services.ec2.model.DescribeSnapshotAttributeRequest)]
   (clojure.core/when-let
    [v5545 (:snapshot-id m5544)]
    (. bean5543 setSnapshotId (clojure.core/str v5545)))
   (clojure.core/when-let
    [v5545 (:attribute m5544)]
    (. bean5543 setAttribute (clojure.core/str v5545)))
   (clojure.core/when-let
    [v5545 (:attribute m5544)]
    (. bean5543 setAttribute (snapshot-attribute-name v5545)))
   bean5543))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DescribeInstanceStatusRequest describe-instance-status-request
  [m5547]
  (clojure.core/let
   [bean5546
    (new
     com.amazonaws.services.ec2.model.DescribeInstanceStatusRequest)]
   (clojure.core/when-let
    [v5548 (:filters m5547)]
    (.
     bean5546
     setFilters
     (clojure.core/map
      (clojure.core/fn [arg5552] (filter arg5552))
      v5548)))
   (clojure.core/when-let
    [v5548 (:next-token m5547)]
    (. bean5546 setNextToken (clojure.core/str v5548)))
   (clojure.core/when-let
    [v5548 (:max-results m5547)]
    (. bean5546 setMaxResults (clojure.core/int v5548)))
   (clojure.core/when-let
    [v5548 (:instance-ids m5547)]
    (.
     bean5546
     setInstanceIds
     (clojure.core/map
      (clojure.core/fn [arg5553] (clojure.core/str arg5553))
      v5548)))
   (clojure.core/when-let
    [v5548 (:include-all-instances m5547)]
    (. bean5546 setIncludeAllInstances (clojure.core/boolean v5548)))
   bean5546))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DescribeImageAttributeRequest describe-image-attribute-request
  [m5550]
  (clojure.core/let
   [bean5549
    (new
     com.amazonaws.services.ec2.model.DescribeImageAttributeRequest)]
   (clojure.core/when-let
    [v5551 (:image-id m5550)]
    (. bean5549 setImageId (clojure.core/str v5551)))
   (clojure.core/when-let
    [v5551 (:attribute m5550)]
    (. bean5549 setAttribute (clojure.core/str v5551)))
   (clojure.core/when-let
    [v5551 (:attribute m5550)]
    (. bean5549 setAttribute (image-attribute-name v5551)))
   bean5549))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.ReportInstanceStatusRequest report-instance-status-request
  [m5555]
  (clojure.core/let
   [bean5554
    (new com.amazonaws.services.ec2.model.ReportInstanceStatusRequest)]
   (clojure.core/when-let
    [v5556 (:instances m5555)]
    (.
     bean5554
     setInstances
     (clojure.core/map
      (clojure.core/fn [arg5560] (clojure.core/str arg5560))
      v5556)))
   (clojure.core/when-let
    [v5556 (:reason-codes m5555)]
    (.
     bean5554
     setReasonCodes
     (clojure.core/map
      (clojure.core/fn [arg5561] (clojure.core/str arg5561))
      v5556)))
   (clojure.core/when-let
    [v5556 (:status m5555)]
    (. bean5554 setStatus (report-status-type v5556)))
   (clojure.core/when-let
    [v5556 (:status m5555)]
    (. bean5554 setStatus (clojure.core/str v5556)))
   (clojure.core/when-let
    [v5556 (:description m5555)]
    (. bean5554 setDescription (clojure.core/str v5556)))
   (clojure.core/when-let
    [v5556 (:start-time m5555)]
    (.
     bean5554
     setStartTime
     (com.palletops.awaze.common/to-date v5556)))
   (clojure.core/when-let
    [v5556 (:end-time m5555)]
    (. bean5554 setEndTime (com.palletops.awaze.common/to-date v5556)))
   bean5554))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DeleteTagsRequest delete-tags-request
  [m5558]
  (clojure.core/let
   [bean5557 (new com.amazonaws.services.ec2.model.DeleteTagsRequest)]
   (clojure.core/when-let
    [v5559 (:resources m5558)]
    (.
     bean5557
     setResources
     (clojure.core/map
      (clojure.core/fn [arg5565] (clojure.core/str arg5565))
      v5559)))
   (clojure.core/when-let
    [v5559 (:tags m5558)]
    (.
     bean5557
     setTags
     (clojure.core/map
      (clojure.core/fn [arg5566] (tag arg5566))
      v5559)))
   bean5557))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.ResetSnapshotAttributeRequest reset-snapshot-attribute-request
  [m5563]
  (clojure.core/let
   [bean5562
    (new
     com.amazonaws.services.ec2.model.ResetSnapshotAttributeRequest)]
   (clojure.core/when-let
    [v5564 (:snapshot-id m5563)]
    (. bean5562 setSnapshotId (clojure.core/str v5564)))
   (clojure.core/when-let
    [v5564 (:attribute m5563)]
    (. bean5562 setAttribute (clojure.core/str v5564)))
   (clojure.core/when-let
    [v5564 (:attribute m5563)]
    (. bean5562 setAttribute (snapshot-attribute-name v5564)))
   bean5562))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.AssociateDhcpOptionsRequest associate-dhcp-options-request
  [m5568]
  (clojure.core/let
   [bean5567
    (new com.amazonaws.services.ec2.model.AssociateDhcpOptionsRequest)]
   (clojure.core/when-let
    [v5569 (:dhcp-options-id m5568)]
    (. bean5567 setDhcpOptionsId (clojure.core/str v5569)))
   (clojure.core/when-let
    [v5569 (:vpc-id m5568)]
    (. bean5567 setVpcId (clojure.core/str v5569)))
   bean5567))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.ModifySnapshotAttributeRequest modify-snapshot-attribute-request
  [m5571]
  (clojure.core/let
   [bean5570
    (new
     com.amazonaws.services.ec2.model.ModifySnapshotAttributeRequest)]
   (clojure.core/when-let
    [v5572 (:snapshot-id m5571)]
    (. bean5570 setSnapshotId (clojure.core/str v5572)))
   (clojure.core/when-let
    [v5572 (:group-names m5571)]
    (.
     bean5570
     setGroupNames
     (clojure.core/map
      (clojure.core/fn [arg5576] (clojure.core/str arg5576))
      v5572)))
   (clojure.core/when-let
    [v5572 (:operation-type m5571)]
    (. bean5570 setOperationType (clojure.core/str v5572)))
   (clojure.core/when-let
    [v5572 (:user-ids m5571)]
    (.
     bean5570
     setUserIds
     (clojure.core/map
      (clojure.core/fn [arg5577] (clojure.core/str arg5577))
      v5572)))
   (clojure.core/when-let
    [v5572 (:create-volume-permission m5571)]
    (.
     bean5570
     setCreateVolumePermission
     (create-volume-permission-modifications v5572)))
   (clojure.core/when-let
    [v5572 (:attribute m5571)]
    (. bean5570 setAttribute (clojure.core/str v5572)))
   (clojure.core/when-let
    [v5572 (:attribute m5571)]
    (. bean5570 setAttribute (snapshot-attribute-name v5572)))
   bean5570))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.ModifyVolumeAttributeRequest modify-volume-attribute-request
  [m5574]
  (clojure.core/let
   [bean5573
    (new
     com.amazonaws.services.ec2.model.ModifyVolumeAttributeRequest)]
   (clojure.core/when-let
    [v5575 (:volume-id m5574)]
    (. bean5573 setVolumeId (clojure.core/str v5575)))
   (clojure.core/when-let
    [v5575 (:auto-enable-io m5574)]
    (. bean5573 setAutoEnableIO (clojure.core/boolean v5575)))
   bean5573))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.CreatePlacementGroupRequest create-placement-group-request
  [m5579]
  (clojure.core/let
   [bean5578
    (new com.amazonaws.services.ec2.model.CreatePlacementGroupRequest)]
   (clojure.core/when-let
    [v5580 (:group-name m5579)]
    (. bean5578 setGroupName (clojure.core/str v5580)))
   (clojure.core/when-let
    [v5580 (:strategy m5579)]
    (. bean5578 setStrategy (clojure.core/str v5580)))
   (clojure.core/when-let
    [v5580 (:strategy m5579)]
    (. bean5578 setStrategy (placement-strategy v5580)))
   bean5578))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DescribeVpnConnectionsRequest describe-vpn-connections-request
  [m5582]
  (clojure.core/let
   [bean5581
    (new
     com.amazonaws.services.ec2.model.DescribeVpnConnectionsRequest)]
   (clojure.core/when-let
    [v5583 (:filters m5582)]
    (.
     bean5581
     setFilters
     (clojure.core/map
      (clojure.core/fn [arg5587] (filter arg5587))
      v5583)))
   (clojure.core/when-let
    [v5583 (:vpn-connection-ids m5582)]
    (.
     bean5581
     setVpnConnectionIds
     (clojure.core/map
      (clojure.core/fn [arg5588] (clojure.core/str arg5588))
      v5583)))
   bean5581))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DescribeSpotPriceHistoryRequest describe-spot-price-history-request
  [m5585]
  (clojure.core/let
   [bean5584
    (new
     com.amazonaws.services.ec2.model.DescribeSpotPriceHistoryRequest)]
   (clojure.core/when-let
    [v5586 (:filters m5585)]
    (.
     bean5584
     setFilters
     (clojure.core/map
      (clojure.core/fn [arg5592] (filter arg5592))
      v5586)))
   (clojure.core/when-let
    [v5586 (:next-token m5585)]
    (. bean5584 setNextToken (clojure.core/str v5586)))
   (clojure.core/when-let
    [v5586 (:instance-types m5585)]
    (.
     bean5584
     setInstanceTypes
     (clojure.core/map
      (clojure.core/fn [arg5593] (clojure.core/str arg5593))
      v5586)))
   (clojure.core/when-let
    [v5586 (:product-descriptions m5585)]
    (.
     bean5584
     setProductDescriptions
     (clojure.core/map
      (clojure.core/fn [arg5594] (clojure.core/str arg5594))
      v5586)))
   (clojure.core/when-let
    [v5586 (:max-results m5585)]
    (. bean5584 setMaxResults (clojure.core/int v5586)))
   (clojure.core/when-let
    [v5586 (:availability-zone m5585)]
    (. bean5584 setAvailabilityZone (clojure.core/str v5586)))
   (clojure.core/when-let
    [v5586 (:start-time m5585)]
    (.
     bean5584
     setStartTime
     (com.palletops.awaze.common/to-date v5586)))
   (clojure.core/when-let
    [v5586 (:end-time m5585)]
    (. bean5584 setEndTime (com.palletops.awaze.common/to-date v5586)))
   bean5584))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DeleteVpcRequest delete-vpc-request
  [m5590]
  (clojure.core/let
   [bean5589 (new com.amazonaws.services.ec2.model.DeleteVpcRequest)]
   (clojure.core/when-let
    [v5591 (:vpc-id m5590)]
    (. bean5589 setVpcId (clojure.core/str v5591)))
   bean5589))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.CreateRouteTableRequest create-route-table-request
  [m5596]
  (clojure.core/let
   [bean5595
    (new com.amazonaws.services.ec2.model.CreateRouteTableRequest)]
   (clojure.core/when-let
    [v5597 (:vpc-id m5596)]
    (. bean5595 setVpcId (clojure.core/str v5597)))
   bean5595))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.TerminateInstancesRequest terminate-instances-request
  [m5599]
  (clojure.core/let
   [bean5598
    (new com.amazonaws.services.ec2.model.TerminateInstancesRequest)]
   (clojure.core/when-let
    [v5600 (:instance-ids m5599)]
    (.
     bean5598
     setInstanceIds
     (clojure.core/map
      (clojure.core/fn [arg5604] (clojure.core/str arg5604))
      v5600)))
   bean5598))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DescribeBundleTasksRequest describe-bundle-tasks-request
  [m5602]
  (clojure.core/let
   [bean5601
    (new com.amazonaws.services.ec2.model.DescribeBundleTasksRequest)]
   (clojure.core/when-let
    [v5603 (:filters m5602)]
    (.
     bean5601
     setFilters
     (clojure.core/map
      (clojure.core/fn [arg5608] (filter arg5608))
      v5603)))
   (clojure.core/when-let
    [v5603 (:bundle-ids m5602)]
    (.
     bean5601
     setBundleIds
     (clojure.core/map
      (clojure.core/fn [arg5609] (clojure.core/str arg5609))
      v5603)))
   bean5601))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.AssociateAddressRequest associate-address-request
  [m5606]
  (clojure.core/let
   [bean5605
    (new com.amazonaws.services.ec2.model.AssociateAddressRequest)]
   (clojure.core/when-let
    [v5607 (:network-interface-id m5606)]
    (. bean5605 setNetworkInterfaceId (clojure.core/str v5607)))
   (clojure.core/when-let
    [v5607 (:private-ip-address m5606)]
    (. bean5605 setPrivateIpAddress (clojure.core/str v5607)))
   (clojure.core/when-let
    [v5607 (:public-ip m5606)]
    (. bean5605 setPublicIp (clojure.core/str v5607)))
   (clojure.core/when-let
    [v5607 (:allocation-id m5606)]
    (. bean5605 setAllocationId (clojure.core/str v5607)))
   (clojure.core/when-let
    [v5607 (:allow-reassociation m5606)]
    (. bean5605 setAllowReassociation (clojure.core/boolean v5607)))
   (clojure.core/when-let
    [v5607 (:instance-id m5606)]
    (. bean5605 setInstanceId (clojure.core/str v5607)))
   bean5605))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.CreateVolumeRequest create-volume-request
  [m5611]
  (clojure.core/let
   [bean5610
    (new com.amazonaws.services.ec2.model.CreateVolumeRequest)]
   (clojure.core/when-let
    [v5612 (:size m5611)]
    (. bean5610 setSize (clojure.core/int v5612)))
   (clojure.core/when-let
    [v5612 (:snapshot-id m5611)]
    (. bean5610 setSnapshotId (clojure.core/str v5612)))
   (clojure.core/when-let
    [v5612 (:iops m5611)]
    (. bean5610 setIops (clojure.core/int v5612)))
   (clojure.core/when-let
    [v5612 (:availability-zone m5611)]
    (. bean5610 setAvailabilityZone (clojure.core/str v5612)))
   (clojure.core/when-let
    [v5612 (:volume-type m5611)]
    (. bean5610 setVolumeType (clojure.core/str v5612)))
   (clojure.core/when-let
    [v5612 (:volume-type m5611)]
    (. bean5610 setVolumeType (volume-type v5612)))
   bean5610))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.ModifyReservedInstancesRequest modify-reserved-instances-request
  [m5614]
  (clojure.core/let
   [bean5613
    (new
     com.amazonaws.services.ec2.model.ModifyReservedInstancesRequest)]
   (clojure.core/when-let
    [v5615 (:client-token m5614)]
    (. bean5613 setClientToken (clojure.core/str v5615)))
   (clojure.core/when-let
    [v5615 (:reserved-instances-ids m5614)]
    (.
     bean5613
     setReservedInstancesIds
     (clojure.core/map
      (clojure.core/fn [arg5619] (clojure.core/str arg5619))
      v5615)))
   (clojure.core/when-let
    [v5615 (:target-configurations m5614)]
    (.
     bean5613
     setTargetConfigurations
     (clojure.core/map
      (clojure.core/fn
       [arg5620]
       (reserved-instances-configuration arg5620))
      v5615)))
   bean5613))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DescribeVpcAttributeRequest describe-vpc-attribute-request
  [m5617]
  (clojure.core/let
   [bean5616
    (new com.amazonaws.services.ec2.model.DescribeVpcAttributeRequest)]
   (clojure.core/when-let
    [v5618 (:attribute m5617)]
    (. bean5616 setAttribute (clojure.core/str v5618)))
   (clojure.core/when-let
    [v5618 (:attribute m5617)]
    (. bean5616 setAttribute (vpc-attribute-name v5618)))
   (clojure.core/when-let
    [v5618 (:vpc-id m5617)]
    (. bean5616 setVpcId (clojure.core/str v5618)))
   bean5616))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.AuthorizeSecurityGroupEgressRequest authorize-security-group-egress-request
  [m5622]
  (clojure.core/let
   [bean5621
    (new
     com.amazonaws.services.ec2.model.AuthorizeSecurityGroupEgressRequest)]
   (clojure.core/when-let
    [v5623 (:group-id m5622)]
    (. bean5621 setGroupId (clojure.core/str v5623)))
   (clojure.core/when-let
    [v5623 (:source-security-group-name m5622)]
    (. bean5621 setSourceSecurityGroupName (clojure.core/str v5623)))
   (clojure.core/when-let
    [v5623 (:source-security-group-owner-id m5622)]
    (.
     bean5621
     setSourceSecurityGroupOwnerId
     (clojure.core/str v5623)))
   (clojure.core/when-let
    [v5623 (:ip-protocol m5622)]
    (. bean5621 setIpProtocol (clojure.core/str v5623)))
   (clojure.core/when-let
    [v5623 (:from-port m5622)]
    (. bean5621 setFromPort (clojure.core/int v5623)))
   (clojure.core/when-let
    [v5623 (:to-port m5622)]
    (. bean5621 setToPort (clojure.core/int v5623)))
   (clojure.core/when-let
    [v5623 (:cidr-ip m5622)]
    (. bean5621 setCidrIp (clojure.core/str v5623)))
   (clojure.core/when-let
    [v5623 (:ip-permissions m5622)]
    (.
     bean5621
     setIpPermissions
     (clojure.core/map
      (clojure.core/fn [arg5627] (ip-permission arg5627))
      v5623)))
   bean5621))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DeleteCustomerGatewayRequest delete-customer-gateway-request
  [m5625]
  (clojure.core/let
   [bean5624
    (new
     com.amazonaws.services.ec2.model.DeleteCustomerGatewayRequest)]
   (clojure.core/when-let
    [v5626 (:customer-gateway-id m5625)]
    (. bean5624 setCustomerGatewayId (clojure.core/str v5626)))
   bean5624))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.ReplaceNetworkAclEntryRequest replace-network-acl-entry-request
  [m5629]
  (clojure.core/let
   [bean5628
    (new
     com.amazonaws.services.ec2.model.ReplaceNetworkAclEntryRequest)]
   (clojure.core/when-let
    [v5630 (:protocol m5629)]
    (. bean5628 setProtocol (clojure.core/str v5630)))
   (clojure.core/when-let
    [v5630 (:network-acl-id m5629)]
    (. bean5628 setNetworkAclId (clojure.core/str v5630)))
   (clojure.core/when-let
    [v5630 (:rule-number m5629)]
    (. bean5628 setRuleNumber (clojure.core/int v5630)))
   (clojure.core/when-let
    [v5630 (:rule-action m5629)]
    (. bean5628 setRuleAction (clojure.core/str v5630)))
   (clojure.core/when-let
    [v5630 (:rule-action m5629)]
    (. bean5628 setRuleAction (rule-action v5630)))
   (clojure.core/when-let
    [v5630 (:egress m5629)]
    (. bean5628 setEgress (clojure.core/boolean v5630)))
   (clojure.core/when-let
    [v5630 (:cidr-block m5629)]
    (. bean5628 setCidrBlock (clojure.core/str v5630)))
   (clojure.core/when-let
    [v5630 (:icmp-type-code m5629)]
    (. bean5628 setIcmpTypeCode (icmp-type-code v5630)))
   (clojure.core/when-let
    [v5630 (:port-range m5629)]
    (. bean5628 setPortRange (port-range v5630)))
   bean5628))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DescribeSubnetsRequest describe-subnets-request
  [m5632]
  (clojure.core/let
   [bean5631
    (new com.amazonaws.services.ec2.model.DescribeSubnetsRequest)]
   (clojure.core/when-let
    [v5633 (:filters m5632)]
    (.
     bean5631
     setFilters
     (clojure.core/map
      (clojure.core/fn [arg5637] (filter arg5637))
      v5633)))
   (clojure.core/when-let
    [v5633 (:subnet-ids m5632)]
    (.
     bean5631
     setSubnetIds
     (clojure.core/map
      (clojure.core/fn [arg5638] (clojure.core/str arg5638))
      v5633)))
   bean5631))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.GetConsoleOutputRequest get-console-output-request
  [m5635]
  (clojure.core/let
   [bean5634
    (new com.amazonaws.services.ec2.model.GetConsoleOutputRequest)]
   (clojure.core/when-let
    [v5636 (:instance-id m5635)]
    (. bean5634 setInstanceId (clojure.core/str v5636)))
   bean5634))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.CancelConversionTaskRequest cancel-conversion-task-request
  [m5640]
  (clojure.core/let
   [bean5639
    (new com.amazonaws.services.ec2.model.CancelConversionTaskRequest)]
   (clojure.core/when-let
    [v5641 (:conversion-task-id m5640)]
    (. bean5639 setConversionTaskId (clojure.core/str v5641)))
   (clojure.core/when-let
    [v5641 (:reason-message m5640)]
    (. bean5639 setReasonMessage (clojure.core/str v5641)))
   bean5639))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.AttachVpnGatewayRequest attach-vpn-gateway-request
  [m5643]
  (clojure.core/let
   [bean5642
    (new com.amazonaws.services.ec2.model.AttachVpnGatewayRequest)]
   (clojure.core/when-let
    [v5644 (:vpn-gateway-id m5643)]
    (. bean5642 setVpnGatewayId (clojure.core/str v5644)))
   (clojure.core/when-let
    [v5644 (:vpc-id m5643)]
    (. bean5642 setVpcId (clojure.core/str v5644)))
   bean5642))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DeleteVpnConnectionRouteRequest delete-vpn-connection-route-request
  [m5646]
  (clojure.core/let
   [bean5645
    (new
     com.amazonaws.services.ec2.model.DeleteVpnConnectionRouteRequest)]
   (clojure.core/when-let
    [v5647 (:destination-cidr-block m5646)]
    (. bean5645 setDestinationCidrBlock (clojure.core/str v5647)))
   (clojure.core/when-let
    [v5647 (:vpn-connection-id m5646)]
    (. bean5645 setVpnConnectionId (clojure.core/str v5647)))
   bean5645))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.RunInstancesRequest run-instances-request
  [m5649]
  (clojure.core/let
   [bean5648
    (new com.amazonaws.services.ec2.model.RunInstancesRequest)]
   (clojure.core/when-let
    [v5650 (:client-token m5649)]
    (. bean5648 setClientToken (clojure.core/str v5650)))
   (clojure.core/when-let
    [v5650 (:additional-info m5649)]
    (. bean5648 setAdditionalInfo (clojure.core/str v5650)))
   (clojure.core/when-let
    [v5650 (:network-interfaces m5649)]
    (.
     bean5648
     setNetworkInterfaces
     (clojure.core/map
      (clojure.core/fn
       [arg5654]
       (instance-network-interface-specification arg5654))
      v5650)))
   (clojure.core/when-let
    [v5650 (:subnet-id m5649)]
    (. bean5648 setSubnetId (clojure.core/str v5650)))
   (clojure.core/when-let
    [v5650 (:private-ip-address m5649)]
    (. bean5648 setPrivateIpAddress (clojure.core/str v5650)))
   (clojure.core/when-let
    [v5650 (:min-count m5649)]
    (. bean5648 setMinCount (clojure.core/int v5650)))
   (clojure.core/when-let
    [v5650 (:max-count m5649)]
    (. bean5648 setMaxCount (clojure.core/int v5650)))
   (clojure.core/when-let
    [v5650 (:security-group-ids m5649)]
    (.
     bean5648
     setSecurityGroupIds
     (clojure.core/map
      (clojure.core/fn [arg5655] (clojure.core/str arg5655))
      v5650)))
   (clojure.core/when-let
    [v5650 (:monitoring m5649)]
    (. bean5648 setMonitoring (clojure.core/boolean v5650)))
   (clojure.core/when-let
    [v5650 (:disable-api-termination m5649)]
    (. bean5648 setDisableApiTermination (clojure.core/boolean v5650)))
   (clojure.core/when-let
    [v5650 (:instance-initiated-shutdown-behavior m5649)]
    (.
     bean5648
     setInstanceInitiatedShutdownBehavior
     (clojure.core/str v5650)))
   (clojure.core/when-let
    [v5650 (:instance-initiated-shutdown-behavior m5649)]
    (.
     bean5648
     setInstanceInitiatedShutdownBehavior
     (shutdown-behavior v5650)))
   (clojure.core/when-let
    [v5650 (:license m5649)]
    (. bean5648 setLicense (instance-license-specification v5650)))
   (clojure.core/when-let
    [v5650 (:image-id m5649)]
    (. bean5648 setImageId (clojure.core/str v5650)))
   (clojure.core/when-let
    [v5650 (:key-name m5649)]
    (. bean5648 setKeyName (clojure.core/str v5650)))
   (clojure.core/when-let
    [v5650 (:security-groups m5649)]
    (.
     bean5648
     setSecurityGroups
     (clojure.core/map
      (clojure.core/fn [arg5656] (clojure.core/str arg5656))
      v5650)))
   (clojure.core/when-let
    [v5650 (:user-data m5649)]
    (. bean5648 setUserData (clojure.core/str v5650)))
   (clojure.core/when-let
    [v5650 (:instance-type m5649)]
    (. bean5648 setInstanceType (instance-type v5650)))
   (clojure.core/when-let
    [v5650 (:instance-type m5649)]
    (. bean5648 setInstanceType (clojure.core/str v5650)))
   (clojure.core/when-let
    [v5650 (:kernel-id m5649)]
    (. bean5648 setKernelId (clojure.core/str v5650)))
   (clojure.core/when-let
    [v5650 (:ramdisk-id m5649)]
    (. bean5648 setRamdiskId (clojure.core/str v5650)))
   (clojure.core/when-let
    [v5650 (:block-device-mappings m5649)]
    (.
     bean5648
     setBlockDeviceMappings
     (clojure.core/map
      (clojure.core/fn [arg5657] (block-device-mapping arg5657))
      v5650)))
   (clojure.core/when-let
    [v5650 (:iam-instance-profile m5649)]
    (.
     bean5648
     setIamInstanceProfile
     (iam-instance-profile-specification v5650)))
   (clojure.core/when-let
    [v5650 (:ebs-optimized m5649)]
    (. bean5648 setEbsOptimized (clojure.core/boolean v5650)))
   (clojure.core/when-let
    [v5650 (:placement m5649)]
    (. bean5648 setPlacement (placement v5650)))
   bean5648))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.RegisterImageRequest register-image-request
  [m5652]
  (clojure.core/let
   [bean5651
    (new com.amazonaws.services.ec2.model.RegisterImageRequest)]
   (clojure.core/when-let
    [v5653 (:name m5652)]
    (. bean5651 setName (clojure.core/str v5653)))
   (clojure.core/when-let
    [v5653 (:kernel-id m5652)]
    (. bean5651 setKernelId (clojure.core/str v5653)))
   (clojure.core/when-let
    [v5653 (:ramdisk-id m5652)]
    (. bean5651 setRamdiskId (clojure.core/str v5653)))
   (clojure.core/when-let
    [v5653 (:block-device-mappings m5652)]
    (.
     bean5651
     setBlockDeviceMappings
     (clojure.core/map
      (clojure.core/fn [arg5661] (block-device-mapping arg5661))
      v5653)))
   (clojure.core/when-let
    [v5653 (:description m5652)]
    (. bean5651 setDescription (clojure.core/str v5653)))
   (clojure.core/when-let
    [v5653 (:image-location m5652)]
    (. bean5651 setImageLocation (clojure.core/str v5653)))
   (clojure.core/when-let
    [v5653 (:architecture m5652)]
    (. bean5651 setArchitecture (clojure.core/str v5653)))
   (clojure.core/when-let
    [v5653 (:architecture m5652)]
    (. bean5651 setArchitecture (architecture-values v5653)))
   (clojure.core/when-let
    [v5653 (:root-device-name m5652)]
    (. bean5651 setRootDeviceName (clojure.core/str v5653)))
   bean5651))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DescribeTagsRequest describe-tags-request
  [m5659]
  (clojure.core/let
   [bean5658
    (new com.amazonaws.services.ec2.model.DescribeTagsRequest)]
   (clojure.core/when-let
    [v5660 (:filters m5659)]
    (.
     bean5658
     setFilters
     (clojure.core/map
      (clojure.core/fn [arg5665] (filter arg5665))
      v5660)))
   bean5658))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DescribeReservedInstancesRequest describe-reserved-instances-request
  [m5663]
  (clojure.core/let
   [bean5662
    (new
     com.amazonaws.services.ec2.model.DescribeReservedInstancesRequest)]
   (clojure.core/when-let
    [v5664 (:filters m5663)]
    (.
     bean5662
     setFilters
     (clojure.core/map
      (clojure.core/fn [arg5669] (filter arg5669))
      v5664)))
   (clojure.core/when-let
    [v5664 (:reserved-instances-ids m5663)]
    (.
     bean5662
     setReservedInstancesIds
     (clojure.core/map
      (clojure.core/fn [arg5670] (clojure.core/str arg5670))
      v5664)))
   (clojure.core/when-let
    [v5664 (:offering-type m5663)]
    (. bean5662 setOfferingType (clojure.core/str v5664)))
   (clojure.core/when-let
    [v5664 (:offering-type m5663)]
    (. bean5662 setOfferingType (offering-type-values v5664)))
   bean5662))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DetachVpnGatewayRequest detach-vpn-gateway-request
  [m5667]
  (clojure.core/let
   [bean5666
    (new com.amazonaws.services.ec2.model.DetachVpnGatewayRequest)]
   (clojure.core/when-let
    [v5668 (:vpn-gateway-id m5667)]
    (. bean5666 setVpnGatewayId (clojure.core/str v5668)))
   (clojure.core/when-let
    [v5668 (:vpc-id m5667)]
    (. bean5666 setVpcId (clojure.core/str v5668)))
   bean5666))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DescribeCustomerGatewaysRequest describe-customer-gateways-request
  [m5672]
  (clojure.core/let
   [bean5671
    (new
     com.amazonaws.services.ec2.model.DescribeCustomerGatewaysRequest)]
   (clojure.core/when-let
    [v5673 (:filters m5672)]
    (.
     bean5671
     setFilters
     (clojure.core/map
      (clojure.core/fn [arg5677] (filter arg5677))
      v5673)))
   (clojure.core/when-let
    [v5673 (:customer-gateway-ids m5672)]
    (.
     bean5671
     setCustomerGatewayIds
     (clojure.core/map
      (clojure.core/fn [arg5678] (clojure.core/str arg5678))
      v5673)))
   bean5671))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DescribeNetworkInterfaceAttributeRequest describe-network-interface-attribute-request
  [m5675]
  (clojure.core/let
   [bean5674
    (new
     com.amazonaws.services.ec2.model.DescribeNetworkInterfaceAttributeRequest)]
   (clojure.core/when-let
    [v5676 (:network-interface-id m5675)]
    (. bean5674 setNetworkInterfaceId (clojure.core/str v5676)))
   (clojure.core/when-let
    [v5676 (:attachment m5675)]
    (. bean5674 setAttachment (clojure.core/str v5676)))
   (clojure.core/when-let
    [v5676 (:groups m5675)]
    (. bean5674 setGroups (clojure.core/str v5676)))
   (clojure.core/when-let
    [v5676 (:source-dest-check m5675)]
    (. bean5674 setSourceDestCheck (clojure.core/str v5676)))
   (clojure.core/when-let
    [v5676 (:description m5675)]
    (. bean5674 setDescription (clojure.core/str v5676)))
   bean5674))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.ActivateLicenseRequest activate-license-request
  [m5680]
  (clojure.core/let
   [bean5679
    (new com.amazonaws.services.ec2.model.ActivateLicenseRequest)]
   (clojure.core/when-let
    [v5681 (:license-id m5680)]
    (. bean5679 setLicenseId (clojure.core/str v5681)))
   (clojure.core/when-let
    [v5681 (:capacity m5680)]
    (. bean5679 setCapacity (clojure.core/int v5681)))
   bean5679))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.ImportKeyPairRequest import-key-pair-request
  [m5683]
  (clojure.core/let
   [bean5682
    (new com.amazonaws.services.ec2.model.ImportKeyPairRequest)]
   (clojure.core/when-let
    [v5684 (:public-key-material m5683)]
    (. bean5682 setPublicKeyMaterial (clojure.core/str v5684)))
   (clojure.core/when-let
    [v5684 (:key-name m5683)]
    (. bean5682 setKeyName (clojure.core/str v5684)))
   bean5682))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.ImportInstanceRequest import-instance-request
  [m5686]
  (clojure.core/let
   [bean5685
    (new com.amazonaws.services.ec2.model.ImportInstanceRequest)]
   (clojure.core/when-let
    [v5687 (:platform m5686)]
    (. bean5685 setPlatform (clojure.core/str v5687)))
   (clojure.core/when-let
    [v5687 (:platform m5686)]
    (. bean5685 setPlatform (platform-values v5687)))
   (clojure.core/when-let
    [v5687 (:launch-specification m5686)]
    (.
     bean5685
     setLaunchSpecification
     (import-instance-launch-specification v5687)))
   (clojure.core/when-let
    [v5687 (:disk-images m5686)]
    (.
     bean5685
     setDiskImages
     (clojure.core/map
      (clojure.core/fn [arg5691] (disk-image arg5691))
      v5687)))
   (clojure.core/when-let
    [v5687 (:description m5686)]
    (. bean5685 setDescription (clojure.core/str v5687)))
   bean5685))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.AllocateAddressRequest allocate-address-request
  [m5689]
  (clojure.core/let
   [bean5688
    (new com.amazonaws.services.ec2.model.AllocateAddressRequest)]
   (clojure.core/when-let
    [v5690 (:domain m5689)]
    (. bean5688 setDomain (clojure.core/str v5690)))
   (clojure.core/when-let
    [v5690 (:domain m5689)]
    (. bean5688 setDomain (domain-type v5690)))
   bean5688))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DescribeSpotInstanceRequestsRequest describe-spot-instance-requests-request
  [m5693]
  (clojure.core/let
   [bean5692
    (new
     com.amazonaws.services.ec2.model.DescribeSpotInstanceRequestsRequest)]
   (clojure.core/when-let
    [v5694 (:filters m5693)]
    (.
     bean5692
     setFilters
     (clojure.core/map
      (clojure.core/fn [arg5698] (filter arg5698))
      v5694)))
   (clojure.core/when-let
    [v5694 (:spot-instance-request-ids m5693)]
    (.
     bean5692
     setSpotInstanceRequestIds
     (clojure.core/map
      (clojure.core/fn [arg5699] (clojure.core/str arg5699))
      v5694)))
   bean5692))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DeleteSpotDatafeedSubscriptionRequest delete-spot-datafeed-subscription-request
  [m5696]
  (clojure.core/let
   [bean5695
    (new
     com.amazonaws.services.ec2.model.DeleteSpotDatafeedSubscriptionRequest)]
   bean5695))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DescribeConversionTasksRequest describe-conversion-tasks-request
  [m5701]
  (clojure.core/let
   [bean5700
    (new
     com.amazonaws.services.ec2.model.DescribeConversionTasksRequest)]
   (clojure.core/when-let
    [v5702 (:filters m5701)]
    (.
     bean5700
     setFilters
     (clojure.core/map
      (clojure.core/fn [arg5706] (filter arg5706))
      v5702)))
   (clojure.core/when-let
    [v5702 (:conversion-task-ids m5701)]
    (.
     bean5700
     setConversionTaskIds
     (clojure.core/map
      (clojure.core/fn [arg5707] (clojure.core/str arg5707))
      v5702)))
   bean5700))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.ReplaceRouteTableAssociationRequest replace-route-table-association-request
  [m5704]
  (clojure.core/let
   [bean5703
    (new
     com.amazonaws.services.ec2.model.ReplaceRouteTableAssociationRequest)]
   (clojure.core/when-let
    [v5705 (:route-table-id m5704)]
    (. bean5703 setRouteTableId (clojure.core/str v5705)))
   (clojure.core/when-let
    [v5705 (:association-id m5704)]
    (. bean5703 setAssociationId (clojure.core/str v5705)))
   bean5703))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DeleteSubnetRequest delete-subnet-request
  [m5709]
  (clojure.core/let
   [bean5708
    (new com.amazonaws.services.ec2.model.DeleteSubnetRequest)]
   (clojure.core/when-let
    [v5710 (:subnet-id m5709)]
    (. bean5708 setSubnetId (clojure.core/str v5710)))
   bean5708))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.ModifyVpcAttributeRequest modify-vpc-attribute-request
  [m5712]
  (clojure.core/let
   [bean5711
    (new com.amazonaws.services.ec2.model.ModifyVpcAttributeRequest)]
   (clojure.core/when-let
    [v5713 (:enable-dns-support m5712)]
    (. bean5711 setEnableDnsSupport (clojure.core/boolean v5713)))
   (clojure.core/when-let
    [v5713 (:enable-dns-hostnames m5712)]
    (. bean5711 setEnableDnsHostnames (clojure.core/boolean v5713)))
   (clojure.core/when-let
    [v5713 (:vpc-id m5712)]
    (. bean5711 setVpcId (clojure.core/str v5713)))
   bean5711))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DetachInternetGatewayRequest detach-internet-gateway-request
  [m5715]
  (clojure.core/let
   [bean5714
    (new
     com.amazonaws.services.ec2.model.DetachInternetGatewayRequest)]
   (clojure.core/when-let
    [v5716 (:internet-gateway-id m5715)]
    (. bean5714 setInternetGatewayId (clojure.core/str v5716)))
   (clojure.core/when-let
    [v5716 (:vpc-id m5715)]
    (. bean5714 setVpcId (clojure.core/str v5716)))
   bean5714))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DescribeReservedInstancesModificationsRequest describe-reserved-instances-modifications-request
  [m5718]
  (clojure.core/let
   [bean5717
    (new
     com.amazonaws.services.ec2.model.DescribeReservedInstancesModificationsRequest)]
   (clojure.core/when-let
    [v5719 (:filters m5718)]
    (.
     bean5717
     setFilters
     (clojure.core/map
      (clojure.core/fn [arg5723] (filter arg5723))
      v5719)))
   (clojure.core/when-let
    [v5719 (:next-token m5718)]
    (. bean5717 setNextToken (clojure.core/str v5719)))
   (clojure.core/when-let
    [v5719 (:reserved-instances-modification-ids m5718)]
    (.
     bean5717
     setReservedInstancesModificationIds
     (clojure.core/map
      (clojure.core/fn [arg5724] (clojure.core/str arg5724))
      v5719)))
   bean5717))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.GetPasswordDataRequest get-password-data-request
  [m5721]
  (clojure.core/let
   [bean5720
    (new com.amazonaws.services.ec2.model.GetPasswordDataRequest)]
   (clojure.core/when-let
    [v5722 (:instance-id m5721)]
    (. bean5720 setInstanceId (clojure.core/str v5722)))
   bean5720))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.UnassignPrivateIpAddressesRequest unassign-private-ip-addresses-request
  [m5726]
  (clojure.core/let
   [bean5725
    (new
     com.amazonaws.services.ec2.model.UnassignPrivateIpAddressesRequest)]
   (clojure.core/when-let
    [v5727 (:network-interface-id m5726)]
    (. bean5725 setNetworkInterfaceId (clojure.core/str v5727)))
   (clojure.core/when-let
    [v5727 (:private-ip-addresses m5726)]
    (.
     bean5725
     setPrivateIpAddresses
     (clojure.core/map
      (clojure.core/fn [arg5731] (clojure.core/str arg5731))
      v5727)))
   bean5725))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.ModifyNetworkInterfaceAttributeRequest modify-network-interface-attribute-request
  [m5729]
  (clojure.core/let
   [bean5728
    (new
     com.amazonaws.services.ec2.model.ModifyNetworkInterfaceAttributeRequest)]
   (clojure.core/when-let
    [v5730 (:network-interface-id m5729)]
    (. bean5728 setNetworkInterfaceId (clojure.core/str v5730)))
   (clojure.core/when-let
    [v5730 (:attachment m5729)]
    (.
     bean5728
     setAttachment
     (network-interface-attachment-changes v5730)))
   (clojure.core/when-let
    [v5730 (:groups m5729)]
    (.
     bean5728
     setGroups
     (clojure.core/map
      (clojure.core/fn [arg5735] (clojure.core/str arg5735))
      v5730)))
   (clojure.core/when-let
    [v5730 (:source-dest-check m5729)]
    (. bean5728 setSourceDestCheck (clojure.core/boolean v5730)))
   (clojure.core/when-let
    [v5730 (:description m5729)]
    (. bean5728 setDescription (clojure.core/str v5730)))
   bean5728))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.ResetNetworkInterfaceAttributeRequest reset-network-interface-attribute-request
  [m5733]
  (clojure.core/let
   [bean5732
    (new
     com.amazonaws.services.ec2.model.ResetNetworkInterfaceAttributeRequest)]
   (clojure.core/when-let
    [v5734 (:network-interface-id m5733)]
    (. bean5732 setNetworkInterfaceId (clojure.core/str v5734)))
   (clojure.core/when-let
    [v5734 (:source-dest-check m5733)]
    (. bean5732 setSourceDestCheck (clojure.core/str v5734)))
   bean5732))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DescribeVpcsRequest describe-vpcs-request
  [m5737]
  (clojure.core/let
   [bean5736
    (new com.amazonaws.services.ec2.model.DescribeVpcsRequest)]
   (clojure.core/when-let
    [v5738 (:filters m5737)]
    (.
     bean5736
     setFilters
     (clojure.core/map
      (clojure.core/fn [arg5742] (filter arg5742))
      v5738)))
   (clojure.core/when-let
    [v5738 (:vpc-ids m5737)]
    (.
     bean5736
     setVpcIds
     (clojure.core/map
      (clojure.core/fn [arg5743] (clojure.core/str arg5743))
      v5738)))
   bean5736))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.RebootInstancesRequest reboot-instances-request
  [m5740]
  (clojure.core/let
   [bean5739
    (new com.amazonaws.services.ec2.model.RebootInstancesRequest)]
   (clojure.core/when-let
    [v5741 (:instance-ids m5740)]
    (.
     bean5739
     setInstanceIds
     (clojure.core/map
      (clojure.core/fn [arg5747] (clojure.core/str arg5747))
      v5741)))
   bean5739))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DescribeVolumeAttributeRequest describe-volume-attribute-request
  [m5745]
  (clojure.core/let
   [bean5744
    (new
     com.amazonaws.services.ec2.model.DescribeVolumeAttributeRequest)]
   (clojure.core/when-let
    [v5746 (:volume-id m5745)]
    (. bean5744 setVolumeId (clojure.core/str v5746)))
   (clojure.core/when-let
    [v5746 (:attribute m5745)]
    (. bean5744 setAttribute (clojure.core/str v5746)))
   (clojure.core/when-let
    [v5746 (:attribute m5745)]
    (. bean5744 setAttribute (volume-attribute-name v5746)))
   bean5744))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.ModifyInstanceAttributeRequest modify-instance-attribute-request
  [m5749]
  (clojure.core/let
   [bean5748
    (new
     com.amazonaws.services.ec2.model.ModifyInstanceAttributeRequest)]
   (clojure.core/when-let
    [v5750 (:value m5749)]
    (. bean5748 setValue (clojure.core/str v5750)))
   (clojure.core/when-let
    [v5750 (:groups m5749)]
    (.
     bean5748
     setGroups
     (clojure.core/map
      (clojure.core/fn [arg5754] (clojure.core/str arg5754))
      v5750)))
   (clojure.core/when-let
    [v5750 (:disable-api-termination m5749)]
    (. bean5748 setDisableApiTermination (clojure.core/boolean v5750)))
   (clojure.core/when-let
    [v5750 (:instance-initiated-shutdown-behavior m5749)]
    (.
     bean5748
     setInstanceInitiatedShutdownBehavior
     (clojure.core/str v5750)))
   (clojure.core/when-let
    [v5750 (:source-dest-check m5749)]
    (. bean5748 setSourceDestCheck (clojure.core/boolean v5750)))
   (clojure.core/when-let
    [v5750 (:kernel m5749)]
    (. bean5748 setKernel (clojure.core/str v5750)))
   (clojure.core/when-let
    [v5750 (:ramdisk m5749)]
    (. bean5748 setRamdisk (clojure.core/str v5750)))
   (clojure.core/when-let
    [v5750 (:user-data m5749)]
    (. bean5748 setUserData (clojure.core/str v5750)))
   (clojure.core/when-let
    [v5750 (:instance-type m5749)]
    (. bean5748 setInstanceType (clojure.core/str v5750)))
   (clojure.core/when-let
    [v5750 (:block-device-mappings m5749)]
    (.
     bean5748
     setBlockDeviceMappings
     (clojure.core/map
      (clojure.core/fn
       [arg5755]
       (instance-block-device-mapping-specification arg5755))
      v5750)))
   (clojure.core/when-let
    [v5750 (:ebs-optimized m5749)]
    (. bean5748 setEbsOptimized (clojure.core/boolean v5750)))
   (clojure.core/when-let
    [v5750 (:attribute m5749)]
    (. bean5748 setAttribute (instance-attribute-name v5750)))
   (clojure.core/when-let
    [v5750 (:attribute m5749)]
    (. bean5748 setAttribute (clojure.core/str v5750)))
   (clojure.core/when-let
    [v5750 (:instance-id m5749)]
    (. bean5748 setInstanceId (clojure.core/str v5750)))
   bean5748))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DeleteKeyPairRequest delete-key-pair-request
  [m5752]
  (clojure.core/let
   [bean5751
    (new com.amazonaws.services.ec2.model.DeleteKeyPairRequest)]
   (clojure.core/when-let
    [v5753 (:key-name m5752)]
    (. bean5751 setKeyName (clojure.core/str v5753)))
   bean5751))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.EnableVgwRoutePropagationRequest enable-vgw-route-propagation-request
  [m5757]
  (clojure.core/let
   [bean5756
    (new
     com.amazonaws.services.ec2.model.EnableVgwRoutePropagationRequest)]
   (clojure.core/when-let
    [v5758 (:gateway-id m5757)]
    (. bean5756 setGatewayId (clojure.core/str v5758)))
   (clojure.core/when-let
    [v5758 (:route-table-id m5757)]
    (. bean5756 setRouteTableId (clojure.core/str v5758)))
   bean5756))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.BundleInstanceRequest bundle-instance-request
  [m5760]
  (clojure.core/let
   [bean5759
    (new com.amazonaws.services.ec2.model.BundleInstanceRequest)]
   (clojure.core/when-let
    [v5761 (:instance-id m5760)]
    (. bean5759 setInstanceId (clojure.core/str v5761)))
   (clojure.core/when-let
    [v5761 (:storage m5760)]
    (. bean5759 setStorage (storage v5761)))
   bean5759))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.CreateInternetGatewayRequest create-internet-gateway-request
  [m5763]
  (clojure.core/let
   [bean5762
    (new
     com.amazonaws.services.ec2.model.CreateInternetGatewayRequest)]
   bean5762))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DescribeVolumeStatusRequest describe-volume-status-request
  [m5766]
  (clojure.core/let
   [bean5765
    (new com.amazonaws.services.ec2.model.DescribeVolumeStatusRequest)]
   (clojure.core/when-let
    [v5767 (:filters m5766)]
    (.
     bean5765
     setFilters
     (clojure.core/map
      (clojure.core/fn [arg5771] (filter arg5771))
      v5767)))
   (clojure.core/when-let
    [v5767 (:next-token m5766)]
    (. bean5765 setNextToken (clojure.core/str v5767)))
   (clojure.core/when-let
    [v5767 (:max-results m5766)]
    (. bean5765 setMaxResults (clojure.core/int v5767)))
   (clojure.core/when-let
    [v5767 (:volume-ids m5766)]
    (.
     bean5765
     setVolumeIds
     (clojure.core/map
      (clojure.core/fn [arg5772] (clojure.core/str arg5772))
      v5767)))
   bean5765))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.CopyImageRequest copy-image-request
  [m5769]
  (clojure.core/let
   [bean5768 (new com.amazonaws.services.ec2.model.CopyImageRequest)]
   (clojure.core/when-let
    [v5770 (:name m5769)]
    (. bean5768 setName (clojure.core/str v5770)))
   (clojure.core/when-let
    [v5770 (:client-token m5769)]
    (. bean5768 setClientToken (clojure.core/str v5770)))
   (clojure.core/when-let
    [v5770 (:source-region m5769)]
    (. bean5768 setSourceRegion (clojure.core/str v5770)))
   (clojure.core/when-let
    [v5770 (:source-image-id m5769)]
    (. bean5768 setSourceImageId (clojure.core/str v5770)))
   (clojure.core/when-let
    [v5770 (:description m5769)]
    (. bean5768 setDescription (clojure.core/str v5770)))
   bean5768))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DescribeKeyPairsRequest describe-key-pairs-request
  [m5774]
  (clojure.core/let
   [bean5773
    (new com.amazonaws.services.ec2.model.DescribeKeyPairsRequest)]
   (clojure.core/when-let
    [v5775 (:filters m5774)]
    (.
     bean5773
     setFilters
     (clojure.core/map
      (clojure.core/fn [arg5779] (filter arg5779))
      v5775)))
   (clojure.core/when-let
    [v5775 (:key-names m5774)]
    (.
     bean5773
     setKeyNames
     (clojure.core/map
      (clojure.core/fn [arg5780] (clojure.core/str arg5780))
      v5775)))
   bean5773))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DeleteNetworkAclEntryRequest delete-network-acl-entry-request
  [m5777]
  (clojure.core/let
   [bean5776
    (new
     com.amazonaws.services.ec2.model.DeleteNetworkAclEntryRequest)]
   (clojure.core/when-let
    [v5778 (:network-acl-id m5777)]
    (. bean5776 setNetworkAclId (clojure.core/str v5778)))
   (clojure.core/when-let
    [v5778 (:rule-number m5777)]
    (. bean5776 setRuleNumber (clojure.core/int v5778)))
   (clojure.core/when-let
    [v5778 (:egress m5777)]
    (. bean5776 setEgress (clojure.core/boolean v5778)))
   bean5776))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.PurchaseReservedInstancesOfferingRequest purchase-reserved-instances-offering-request
  [m5782]
  (clojure.core/let
   [bean5781
    (new
     com.amazonaws.services.ec2.model.PurchaseReservedInstancesOfferingRequest)]
   (clojure.core/when-let
    [v5783 (:limit-price m5782)]
    (. bean5781 setLimitPrice (reserved-instance-limit-price v5783)))
   (clojure.core/when-let
    [v5783 (:reserved-instances-offering-id m5782)]
    (.
     bean5781
     setReservedInstancesOfferingId
     (clojure.core/str v5783)))
   (clojure.core/when-let
    [v5783 (:instance-count m5782)]
    (. bean5781 setInstanceCount (clojure.core/int v5783)))
   bean5781))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.CancelReservedInstancesListingRequest cancel-reserved-instances-listing-request
  [m5785]
  (clojure.core/let
   [bean5784
    (new
     com.amazonaws.services.ec2.model.CancelReservedInstancesListingRequest)]
   (clojure.core/when-let
    [v5786 (:reserved-instances-listing-id m5785)]
    (.
     bean5784
     setReservedInstancesListingId
     (clojure.core/str v5786)))
   bean5784))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.RevokeSecurityGroupEgressRequest revoke-security-group-egress-request
  [m5788]
  (clojure.core/let
   [bean5787
    (new
     com.amazonaws.services.ec2.model.RevokeSecurityGroupEgressRequest)]
   (clojure.core/when-let
    [v5789 (:group-id m5788)]
    (. bean5787 setGroupId (clojure.core/str v5789)))
   (clojure.core/when-let
    [v5789 (:source-security-group-name m5788)]
    (. bean5787 setSourceSecurityGroupName (clojure.core/str v5789)))
   (clojure.core/when-let
    [v5789 (:source-security-group-owner-id m5788)]
    (.
     bean5787
     setSourceSecurityGroupOwnerId
     (clojure.core/str v5789)))
   (clojure.core/when-let
    [v5789 (:ip-protocol m5788)]
    (. bean5787 setIpProtocol (clojure.core/str v5789)))
   (clojure.core/when-let
    [v5789 (:from-port m5788)]
    (. bean5787 setFromPort (clojure.core/int v5789)))
   (clojure.core/when-let
    [v5789 (:to-port m5788)]
    (. bean5787 setToPort (clojure.core/int v5789)))
   (clojure.core/when-let
    [v5789 (:cidr-ip m5788)]
    (. bean5787 setCidrIp (clojure.core/str v5789)))
   (clojure.core/when-let
    [v5789 (:ip-permissions m5788)]
    (.
     bean5787
     setIpPermissions
     (clojure.core/map
      (clojure.core/fn [arg5793] (ip-permission arg5793))
      v5789)))
   bean5787))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DeactivateLicenseRequest deactivate-license-request
  [m5791]
  (clojure.core/let
   [bean5790
    (new com.amazonaws.services.ec2.model.DeactivateLicenseRequest)]
   (clojure.core/when-let
    [v5792 (:license-id m5791)]
    (. bean5790 setLicenseId (clojure.core/str v5792)))
   (clojure.core/when-let
    [v5792 (:capacity m5791)]
    (. bean5790 setCapacity (clojure.core/int v5792)))
   bean5790))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.CreateSpotDatafeedSubscriptionRequest create-spot-datafeed-subscription-request
  [m5795]
  (clojure.core/let
   [bean5794
    (new
     com.amazonaws.services.ec2.model.CreateSpotDatafeedSubscriptionRequest)]
   (clojure.core/when-let
    [v5796 (:prefix m5795)]
    (. bean5794 setPrefix (clojure.core/str v5796)))
   (clojure.core/when-let
    [v5796 (:bucket m5795)]
    (. bean5794 setBucket (clojure.core/str v5796)))
   bean5794))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.EnableVolumeIORequest enable-volume-iorequest
  [m5798]
  (clojure.core/let
   [bean5797
    (new com.amazonaws.services.ec2.model.EnableVolumeIORequest)]
   (clojure.core/when-let
    [v5799 (:volume-id m5798)]
    (. bean5797 setVolumeId (clojure.core/str v5799)))
   bean5797))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.ReplaceNetworkAclAssociationRequest replace-network-acl-association-request
  [m5801]
  (clojure.core/let
   [bean5800
    (new
     com.amazonaws.services.ec2.model.ReplaceNetworkAclAssociationRequest)]
   (clojure.core/when-let
    [v5802 (:association-id m5801)]
    (. bean5800 setAssociationId (clojure.core/str v5802)))
   (clojure.core/when-let
    [v5802 (:network-acl-id m5801)]
    (. bean5800 setNetworkAclId (clojure.core/str v5802)))
   bean5800))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.CopySnapshotRequest copy-snapshot-request
  [m5804]
  (clojure.core/let
   [bean5803
    (new com.amazonaws.services.ec2.model.CopySnapshotRequest)]
   (clojure.core/when-let
    [v5805 (:source-region m5804)]
    (. bean5803 setSourceRegion (clojure.core/str v5805)))
   (clojure.core/when-let
    [v5805 (:description m5804)]
    (. bean5803 setDescription (clojure.core/str v5805)))
   (clojure.core/when-let
    [v5805 (:source-snapshot-id m5804)]
    (. bean5803 setSourceSnapshotId (clojure.core/str v5805)))
   bean5803))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.CreateCustomerGatewayRequest create-customer-gateway-request
  [m5807]
  (clojure.core/let
   [bean5806
    (new
     com.amazonaws.services.ec2.model.CreateCustomerGatewayRequest)]
   (clojure.core/when-let
    [v5808 (:public-ip m5807)]
    (. bean5806 setPublicIp (clojure.core/str v5808)))
   (clojure.core/when-let
    [v5808 (:bgp-asn m5807)]
    (. bean5806 setBgpAsn (clojure.core/int v5808)))
   (clojure.core/when-let
    [v5808 (:type m5807)]
    (. bean5806 setType (gateway-type v5808)))
   (clojure.core/when-let
    [v5808 (:type m5807)]
    (. bean5806 setType (clojure.core/str v5808)))
   bean5806))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DescribeReservedInstancesOfferingsRequest describe-reserved-instances-offerings-request
  [m5810]
  (clojure.core/let
   [bean5809
    (new
     com.amazonaws.services.ec2.model.DescribeReservedInstancesOfferingsRequest)]
   (clojure.core/when-let
    [v5811 (:filters m5810)]
    (.
     bean5809
     setFilters
     (clojure.core/map
      (clojure.core/fn [arg5815] (filter arg5815))
      v5811)))
   (clojure.core/when-let
    [v5811 (:next-token m5810)]
    (. bean5809 setNextToken (clojure.core/str v5811)))
   (clojure.core/when-let
    [v5811 (:product-description m5810)]
    (. bean5809 setProductDescription (riproduct-description v5811)))
   (clojure.core/when-let
    [v5811 (:product-description m5810)]
    (. bean5809 setProductDescription (clojure.core/str v5811)))
   (clojure.core/when-let
    [v5811 (:max-results m5810)]
    (. bean5809 setMaxResults (clojure.core/int v5811)))
   (clojure.core/when-let
    [v5811 (:instance-tenancy m5810)]
    (. bean5809 setInstanceTenancy (clojure.core/str v5811)))
   (clojure.core/when-let
    [v5811 (:instance-tenancy m5810)]
    (. bean5809 setInstanceTenancy (tenancy v5811)))
   (clojure.core/when-let
    [v5811 (:instance-type m5810)]
    (. bean5809 setInstanceType (instance-type v5811)))
   (clojure.core/when-let
    [v5811 (:instance-type m5810)]
    (. bean5809 setInstanceType (clojure.core/str v5811)))
   (clojure.core/when-let
    [v5811 (:availability-zone m5810)]
    (. bean5809 setAvailabilityZone (clojure.core/str v5811)))
   (clojure.core/when-let
    [v5811 (:offering-type m5810)]
    (. bean5809 setOfferingType (clojure.core/str v5811)))
   (clojure.core/when-let
    [v5811 (:offering-type m5810)]
    (. bean5809 setOfferingType (offering-type-values v5811)))
   (clojure.core/when-let
    [v5811 (:reserved-instances-offering-ids m5810)]
    (.
     bean5809
     setReservedInstancesOfferingIds
     (clojure.core/map
      (clojure.core/fn [arg5816] (clojure.core/str arg5816))
      v5811)))
   (clojure.core/when-let
    [v5811 (:include-marketplace m5810)]
    (. bean5809 setIncludeMarketplace (clojure.core/boolean v5811)))
   (clojure.core/when-let
    [v5811 (:min-duration m5810)]
    (. bean5809 setMinDuration (clojure.core/long v5811)))
   (clojure.core/when-let
    [v5811 (:max-duration m5810)]
    (. bean5809 setMaxDuration (clojure.core/long v5811)))
   (clojure.core/when-let
    [v5811 (:max-instance-count m5810)]
    (. bean5809 setMaxInstanceCount (clojure.core/int v5811)))
   bean5809))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.CancelBundleTaskRequest cancel-bundle-task-request
  [m5813]
  (clojure.core/let
   [bean5812
    (new com.amazonaws.services.ec2.model.CancelBundleTaskRequest)]
   (clojure.core/when-let
    [v5814 (:bundle-id m5813)]
    (. bean5812 setBundleId (clojure.core/str v5814)))
   bean5812))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DescribeImagesRequest describe-images-request
  [m5818]
  (clojure.core/let
   [bean5817
    (new com.amazonaws.services.ec2.model.DescribeImagesRequest)]
   (clojure.core/when-let
    [v5819 (:filters m5818)]
    (.
     bean5817
     setFilters
     (clojure.core/map
      (clojure.core/fn [arg5823] (filter arg5823))
      v5819)))
   (clojure.core/when-let
    [v5819 (:image-ids m5818)]
    (.
     bean5817
     setImageIds
     (clojure.core/map
      (clojure.core/fn [arg5824] (clojure.core/str arg5824))
      v5819)))
   (clojure.core/when-let
    [v5819 (:owners m5818)]
    (.
     bean5817
     setOwners
     (clojure.core/map
      (clojure.core/fn [arg5825] (clojure.core/str arg5825))
      v5819)))
   (clojure.core/when-let
    [v5819 (:executable-users m5818)]
    (.
     bean5817
     setExecutableUsers
     (clojure.core/map
      (clojure.core/fn [arg5826] (clojure.core/str arg5826))
      v5819)))
   bean5817))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DescribeDhcpOptionsRequest describe-dhcp-options-request
  [m5821]
  (clojure.core/let
   [bean5820
    (new com.amazonaws.services.ec2.model.DescribeDhcpOptionsRequest)]
   (clojure.core/when-let
    [v5822 (:filters m5821)]
    (.
     bean5820
     setFilters
     (clojure.core/map
      (clojure.core/fn [arg5830] (filter arg5830))
      v5822)))
   (clojure.core/when-let
    [v5822 (:dhcp-options-ids m5821)]
    (.
     bean5820
     setDhcpOptionsIds
     (clojure.core/map
      (clojure.core/fn [arg5831] (clojure.core/str arg5831))
      v5822)))
   bean5820))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DeleteVpnConnectionRequest delete-vpn-connection-request
  [m5828]
  (clojure.core/let
   [bean5827
    (new com.amazonaws.services.ec2.model.DeleteVpnConnectionRequest)]
   (clojure.core/when-let
    [v5829 (:vpn-connection-id m5828)]
    (. bean5827 setVpnConnectionId (clojure.core/str v5829)))
   bean5827))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.CreateVpnConnectionRouteRequest create-vpn-connection-route-request
  [m5833]
  (clojure.core/let
   [bean5832
    (new
     com.amazonaws.services.ec2.model.CreateVpnConnectionRouteRequest)]
   (clojure.core/when-let
    [v5834 (:destination-cidr-block m5833)]
    (. bean5832 setDestinationCidrBlock (clojure.core/str v5834)))
   (clojure.core/when-let
    [v5834 (:vpn-connection-id m5833)]
    (. bean5832 setVpnConnectionId (clojure.core/str v5834)))
   bean5832))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.CreateKeyPairRequest create-key-pair-request
  [m5836]
  (clojure.core/let
   [bean5835
    (new com.amazonaws.services.ec2.model.CreateKeyPairRequest)]
   (clojure.core/when-let
    [v5837 (:key-name m5836)]
    (. bean5835 setKeyName (clojure.core/str v5837)))
   bean5835))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DescribeAccountAttributesRequest describe-account-attributes-request
  [m5839]
  (clojure.core/let
   [bean5838
    (new
     com.amazonaws.services.ec2.model.DescribeAccountAttributesRequest)]
   (clojure.core/when-let
    [v5840 (:attribute-names m5839)]
    (.
     bean5838
     setAttributeNames
     (clojure.core/map
      (clojure.core/fn [arg5844] (clojure.core/str arg5844))
      v5840)))
   bean5838))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DescribeSpotDatafeedSubscriptionRequest describe-spot-datafeed-subscription-request
  [m5842]
  (clojure.core/let
   [bean5841
    (new
     com.amazonaws.services.ec2.model.DescribeSpotDatafeedSubscriptionRequest)]
   bean5841))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DescribeInternetGatewaysRequest describe-internet-gateways-request
  [m5846]
  (clojure.core/let
   [bean5845
    (new
     com.amazonaws.services.ec2.model.DescribeInternetGatewaysRequest)]
   (clojure.core/when-let
    [v5847 (:filters m5846)]
    (.
     bean5845
     setFilters
     (clojure.core/map
      (clojure.core/fn [arg5851] (filter arg5851))
      v5847)))
   (clojure.core/when-let
    [v5847 (:internet-gateway-ids m5846)]
    (.
     bean5845
     setInternetGatewayIds
     (clojure.core/map
      (clojure.core/fn [arg5852] (clojure.core/str arg5852))
      v5847)))
   bean5845))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.StartInstancesRequest start-instances-request
  [m5849]
  (clojure.core/let
   [bean5848
    (new com.amazonaws.services.ec2.model.StartInstancesRequest)]
   (clojure.core/when-let
    [v5850 (:additional-info m5849)]
    (. bean5848 setAdditionalInfo (clojure.core/str v5850)))
   (clojure.core/when-let
    [v5850 (:instance-ids m5849)]
    (.
     bean5848
     setInstanceIds
     (clojure.core/map
      (clojure.core/fn [arg5856] (clojure.core/str arg5856))
      v5850)))
   bean5848))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.AttachNetworkInterfaceRequest attach-network-interface-request
  [m5854]
  (clojure.core/let
   [bean5853
    (new
     com.amazonaws.services.ec2.model.AttachNetworkInterfaceRequest)]
   (clojure.core/when-let
    [v5855 (:network-interface-id m5854)]
    (. bean5853 setNetworkInterfaceId (clojure.core/str v5855)))
   (clojure.core/when-let
    [v5855 (:device-index m5854)]
    (. bean5853 setDeviceIndex (clojure.core/int v5855)))
   (clojure.core/when-let
    [v5855 (:instance-id m5854)]
    (. bean5853 setInstanceId (clojure.core/str v5855)))
   bean5853))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.CreateRouteRequest create-route-request
  [m5858]
  (clojure.core/let
   [bean5857
    (new com.amazonaws.services.ec2.model.CreateRouteRequest)]
   (clojure.core/when-let
    [v5859 (:network-interface-id m5858)]
    (. bean5857 setNetworkInterfaceId (clojure.core/str v5859)))
   (clojure.core/when-let
    [v5859 (:gateway-id m5858)]
    (. bean5857 setGatewayId (clojure.core/str v5859)))
   (clojure.core/when-let
    [v5859 (:route-table-id m5858)]
    (. bean5857 setRouteTableId (clojure.core/str v5859)))
   (clojure.core/when-let
    [v5859 (:destination-cidr-block m5858)]
    (. bean5857 setDestinationCidrBlock (clojure.core/str v5859)))
   (clojure.core/when-let
    [v5859 (:instance-id m5858)]
    (. bean5857 setInstanceId (clojure.core/str v5859)))
   bean5857))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.UnmonitorInstancesRequest unmonitor-instances-request
  [m5861]
  (clojure.core/let
   [bean5860
    (new com.amazonaws.services.ec2.model.UnmonitorInstancesRequest)]
   (clojure.core/when-let
    [v5862 (:instance-ids m5861)]
    (.
     bean5860
     setInstanceIds
     (clojure.core/map
      (clojure.core/fn [arg5866] (clojure.core/str arg5866))
      v5862)))
   bean5860))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DeleteNetworkInterfaceRequest delete-network-interface-request
  [m5864]
  (clojure.core/let
   [bean5863
    (new
     com.amazonaws.services.ec2.model.DeleteNetworkInterfaceRequest)]
   (clojure.core/when-let
    [v5865 (:network-interface-id m5864)]
    (. bean5863 setNetworkInterfaceId (clojure.core/str v5865)))
   bean5863))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.MonitorInstancesRequest monitor-instances-request
  [m5868]
  (clojure.core/let
   [bean5867
    (new com.amazonaws.services.ec2.model.MonitorInstancesRequest)]
   (clojure.core/when-let
    [v5869 (:instance-ids m5868)]
    (.
     bean5867
     setInstanceIds
     (clojure.core/map
      (clojure.core/fn [arg5873] (clojure.core/str arg5873))
      v5869)))
   bean5867))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DescribeReservedInstancesListingsRequest describe-reserved-instances-listings-request
  [m5871]
  (clojure.core/let
   [bean5870
    (new
     com.amazonaws.services.ec2.model.DescribeReservedInstancesListingsRequest)]
   (clojure.core/when-let
    [v5872 (:filters m5871)]
    (.
     bean5870
     setFilters
     (clojure.core/map
      (clojure.core/fn [arg5877] (filter arg5877))
      v5872)))
   (clojure.core/when-let
    [v5872 (:reserved-instances-id m5871)]
    (. bean5870 setReservedInstancesId (clojure.core/str v5872)))
   (clojure.core/when-let
    [v5872 (:reserved-instances-listing-id m5871)]
    (.
     bean5870
     setReservedInstancesListingId
     (clojure.core/str v5872)))
   bean5870))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.CreateTagsRequest create-tags-request
  [m5875]
  (clojure.core/let
   [bean5874 (new com.amazonaws.services.ec2.model.CreateTagsRequest)]
   (clojure.core/when-let
    [v5876 (:resources m5875)]
    (.
     bean5874
     setResources
     (clojure.core/map
      (clojure.core/fn [arg5881] (clojure.core/str arg5881))
      v5876)))
   (clojure.core/when-let
    [v5876 (:tags m5875)]
    (.
     bean5874
     setTags
     (clojure.core/map
      (clojure.core/fn [arg5882] (tag arg5882))
      v5876)))
   bean5874))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.ConfirmProductInstanceRequest confirm-product-instance-request
  [m5879]
  (clojure.core/let
   [bean5878
    (new
     com.amazonaws.services.ec2.model.ConfirmProductInstanceRequest)]
   (clojure.core/when-let
    [v5880 (:instance-id m5879)]
    (. bean5878 setInstanceId (clojure.core/str v5880)))
   (clojure.core/when-let
    [v5880 (:product-code m5879)]
    (. bean5878 setProductCode (clojure.core/str v5880)))
   bean5878))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DisassociateRouteTableRequest disassociate-route-table-request
  [m5884]
  (clojure.core/let
   [bean5883
    (new
     com.amazonaws.services.ec2.model.DisassociateRouteTableRequest)]
   (clojure.core/when-let
    [v5885 (:association-id m5884)]
    (. bean5883 setAssociationId (clojure.core/str v5885)))
   bean5883))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DisassociateAddressRequest disassociate-address-request
  [m5887]
  (clojure.core/let
   [bean5886
    (new com.amazonaws.services.ec2.model.DisassociateAddressRequest)]
   (clojure.core/when-let
    [v5888 (:public-ip m5887)]
    (. bean5886 setPublicIp (clojure.core/str v5888)))
   (clojure.core/when-let
    [v5888 (:association-id m5887)]
    (. bean5886 setAssociationId (clojure.core/str v5888)))
   bean5886))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DetachNetworkInterfaceRequest detach-network-interface-request
  [m5890]
  (clojure.core/let
   [bean5889
    (new
     com.amazonaws.services.ec2.model.DetachNetworkInterfaceRequest)]
   (clojure.core/when-let
    [v5891 (:force m5890)]
    (. bean5889 setForce (clojure.core/boolean v5891)))
   (clojure.core/when-let
    [v5891 (:attachment-id m5890)]
    (. bean5889 setAttachmentId (clojure.core/str v5891)))
   bean5889))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DescribeExportTasksRequest describe-export-tasks-request
  [m5893]
  (clojure.core/let
   [bean5892
    (new com.amazonaws.services.ec2.model.DescribeExportTasksRequest)]
   (clojure.core/when-let
    [v5894 (:export-task-ids m5893)]
    (.
     bean5892
     setExportTaskIds
     (clojure.core/map
      (clojure.core/fn [arg5898] (clojure.core/str arg5898))
      v5894)))
   bean5892))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DescribeAddressesRequest describe-addresses-request
  [m5896]
  (clojure.core/let
   [bean5895
    (new com.amazonaws.services.ec2.model.DescribeAddressesRequest)]
   (clojure.core/when-let
    [v5897 (:filters m5896)]
    (.
     bean5895
     setFilters
     (clojure.core/map
      (clojure.core/fn [arg5902] (filter arg5902))
      v5897)))
   (clojure.core/when-let
    [v5897 (:public-ips m5896)]
    (.
     bean5895
     setPublicIps
     (clojure.core/map
      (clojure.core/fn [arg5903] (clojure.core/str arg5903))
      v5897)))
   (clojure.core/when-let
    [v5897 (:allocation-ids m5896)]
    (.
     bean5895
     setAllocationIds
     (clojure.core/map
      (clojure.core/fn [arg5904] (clojure.core/str arg5904))
      v5897)))
   bean5895))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.CreateInstanceExportTaskRequest create-instance-export-task-request
  [m5900]
  (clojure.core/let
   [bean5899
    (new
     com.amazonaws.services.ec2.model.CreateInstanceExportTaskRequest)]
   (clojure.core/when-let
    [v5901 (:target-environment m5900)]
    (. bean5899 setTargetEnvironment (clojure.core/str v5901)))
   (clojure.core/when-let
    [v5901 (:target-environment m5900)]
    (. bean5899 setTargetEnvironment (export-environment v5901)))
   (clojure.core/when-let
    [v5901 (:export-to-s3task m5900)]
    (.
     bean5899
     setExportToS3Task
     (export-to-s3task-specification v5901)))
   (clojure.core/when-let
    [v5901 (:description m5900)]
    (. bean5899 setDescription (clojure.core/str v5901)))
   (clojure.core/when-let
    [v5901 (:instance-id m5900)]
    (. bean5899 setInstanceId (clojure.core/str v5901)))
   bean5899))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.CreateImageRequest create-image-request
  [m5906]
  (clojure.core/let
   [bean5905
    (new com.amazonaws.services.ec2.model.CreateImageRequest)]
   (clojure.core/when-let
    [v5907 (:name m5906)]
    (. bean5905 setName (clojure.core/str v5907)))
   (clojure.core/when-let
    [v5907 (:block-device-mappings m5906)]
    (.
     bean5905
     setBlockDeviceMappings
     (clojure.core/map
      (clojure.core/fn [arg5911] (block-device-mapping arg5911))
      v5907)))
   (clojure.core/when-let
    [v5907 (:description m5906)]
    (. bean5905 setDescription (clojure.core/str v5907)))
   (clojure.core/when-let
    [v5907 (:instance-id m5906)]
    (. bean5905 setInstanceId (clojure.core/str v5907)))
   (clojure.core/when-let
    [v5907 (:no-reboot m5906)]
    (. bean5905 setNoReboot (clojure.core/boolean v5907)))
   bean5905))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.CreateSecurityGroupRequest create-security-group-request
  [m5909]
  (clojure.core/let
   [bean5908
    (new com.amazonaws.services.ec2.model.CreateSecurityGroupRequest)]
   (clojure.core/when-let
    [v5910 (:group-name m5909)]
    (. bean5908 setGroupName (clojure.core/str v5910)))
   (clojure.core/when-let
    [v5910 (:vpc-id m5909)]
    (. bean5908 setVpcId (clojure.core/str v5910)))
   (clojure.core/when-let
    [v5910 (:description m5909)]
    (. bean5908 setDescription (clojure.core/str v5910)))
   bean5908))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.CreateSubnetRequest create-subnet-request
  [m5913]
  (clojure.core/let
   [bean5912
    (new com.amazonaws.services.ec2.model.CreateSubnetRequest)]
   (clojure.core/when-let
    [v5914 (:cidr-block m5913)]
    (. bean5912 setCidrBlock (clojure.core/str v5914)))
   (clojure.core/when-let
    [v5914 (:availability-zone m5913)]
    (. bean5912 setAvailabilityZone (clojure.core/str v5914)))
   (clojure.core/when-let
    [v5914 (:vpc-id m5913)]
    (. bean5912 setVpcId (clojure.core/str v5914)))
   bean5912))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DeleteNetworkAclRequest delete-network-acl-request
  [m5916]
  (clojure.core/let
   [bean5915
    (new com.amazonaws.services.ec2.model.DeleteNetworkAclRequest)]
   (clojure.core/when-let
    [v5917 (:network-acl-id m5916)]
    (. bean5915 setNetworkAclId (clojure.core/str v5917)))
   bean5915))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.CreateNetworkInterfaceRequest create-network-interface-request
  [m5919]
  (clojure.core/let
   [bean5918
    (new
     com.amazonaws.services.ec2.model.CreateNetworkInterfaceRequest)]
   (clojure.core/when-let
    [v5920 (:subnet-id m5919)]
    (. bean5918 setSubnetId (clojure.core/str v5920)))
   (clojure.core/when-let
    [v5920 (:private-ip-address m5919)]
    (. bean5918 setPrivateIpAddress (clojure.core/str v5920)))
   (clojure.core/when-let
    [v5920 (:groups m5919)]
    (.
     bean5918
     setGroups
     (clojure.core/map
      (clojure.core/fn [arg5924] (clojure.core/str arg5924))
      v5920)))
   (clojure.core/when-let
    [v5920 (:private-ip-addresses m5919)]
    (.
     bean5918
     setPrivateIpAddresses
     (clojure.core/map
      (clojure.core/fn
       [arg5925]
       (private-ip-address-specification arg5925))
      v5920)))
   (clojure.core/when-let
    [v5920 (:secondary-private-ip-address-count m5919)]
    (.
     bean5918
     setSecondaryPrivateIpAddressCount
     (clojure.core/int v5920)))
   (clojure.core/when-let
    [v5920 (:description m5919)]
    (. bean5918 setDescription (clojure.core/str v5920)))
   bean5918))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DeleteVpnGatewayRequest delete-vpn-gateway-request
  [m5922]
  (clojure.core/let
   [bean5921
    (new com.amazonaws.services.ec2.model.DeleteVpnGatewayRequest)]
   (clojure.core/when-let
    [v5923 (:vpn-gateway-id m5922)]
    (. bean5921 setVpnGatewayId (clojure.core/str v5923)))
   bean5921))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.AttachVolumeRequest attach-volume-request
  [m5927]
  (clojure.core/let
   [bean5926
    (new com.amazonaws.services.ec2.model.AttachVolumeRequest)]
   (clojure.core/when-let
    [v5928 (:volume-id m5927)]
    (. bean5926 setVolumeId (clojure.core/str v5928)))
   (clojure.core/when-let
    [v5928 (:device m5927)]
    (. bean5926 setDevice (clojure.core/str v5928)))
   (clojure.core/when-let
    [v5928 (:instance-id m5927)]
    (. bean5926 setInstanceId (clojure.core/str v5928)))
   bean5926))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.CreateVpnConnectionRequest create-vpn-connection-request
  [m5930]
  (clojure.core/let
   [bean5929
    (new com.amazonaws.services.ec2.model.CreateVpnConnectionRequest)]
   (clojure.core/when-let
    [v5931 (:options m5930)]
    (.
     bean5929
     setOptions
     (vpn-connection-options-specification v5931)))
   (clojure.core/when-let
    [v5931 (:vpn-gateway-id m5930)]
    (. bean5929 setVpnGatewayId (clojure.core/str v5931)))
   (clojure.core/when-let
    [v5931 (:customer-gateway-id m5930)]
    (. bean5929 setCustomerGatewayId (clojure.core/str v5931)))
   (clojure.core/when-let
    [v5931 (:type m5930)]
    (. bean5929 setType (clojure.core/str v5931)))
   bean5929))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DeletePlacementGroupRequest delete-placement-group-request
  [m5933]
  (clojure.core/let
   [bean5932
    (new com.amazonaws.services.ec2.model.DeletePlacementGroupRequest)]
   (clojure.core/when-let
    [v5934 (:group-name m5933)]
    (. bean5932 setGroupName (clojure.core/str v5934)))
   bean5932))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.ResetInstanceAttributeRequest reset-instance-attribute-request
  [m5936]
  (clojure.core/let
   [bean5935
    (new
     com.amazonaws.services.ec2.model.ResetInstanceAttributeRequest)]
   (clojure.core/when-let
    [v5937 (:attribute m5936)]
    (. bean5935 setAttribute (clojure.core/str v5937)))
   (clojure.core/when-let
    [v5937 (:attribute m5936)]
    (. bean5935 setAttribute (instance-attribute-name v5937)))
   (clojure.core/when-let
    [v5937 (:instance-id m5936)]
    (. bean5935 setInstanceId (clojure.core/str v5937)))
   bean5935))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.CreateSnapshotRequest create-snapshot-request
  [m5939]
  (clojure.core/let
   [bean5938
    (new com.amazonaws.services.ec2.model.CreateSnapshotRequest)]
   (clojure.core/when-let
    [v5940 (:volume-id m5939)]
    (. bean5938 setVolumeId (clojure.core/str v5940)))
   (clojure.core/when-let
    [v5940 (:description m5939)]
    (. bean5938 setDescription (clojure.core/str v5940)))
   bean5938))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.RequestSpotInstancesRequest request-spot-instances-request
  [m5942]
  (clojure.core/let
   [bean5941
    (new com.amazonaws.services.ec2.model.RequestSpotInstancesRequest)]
   (clojure.core/when-let
    [v5943 (:launch-specification m5942)]
    (. bean5941 setLaunchSpecification (launch-specification v5943)))
   (clojure.core/when-let
    [v5943 (:valid-from m5942)]
    (.
     bean5941
     setValidFrom
     (com.palletops.awaze.common/to-date v5943)))
   (clojure.core/when-let
    [v5943 (:valid-until m5942)]
    (.
     bean5941
     setValidUntil
     (com.palletops.awaze.common/to-date v5943)))
   (clojure.core/when-let
    [v5943 (:launch-group m5942)]
    (. bean5941 setLaunchGroup (clojure.core/str v5943)))
   (clojure.core/when-let
    [v5943 (:availability-zone-group m5942)]
    (. bean5941 setAvailabilityZoneGroup (clojure.core/str v5943)))
   (clojure.core/when-let
    [v5943 (:spot-price m5942)]
    (. bean5941 setSpotPrice (clojure.core/str v5943)))
   (clojure.core/when-let
    [v5943 (:type m5942)]
    (. bean5941 setType (spot-instance-type v5943)))
   (clojure.core/when-let
    [v5943 (:type m5942)]
    (. bean5941 setType (clojure.core/str v5943)))
   (clojure.core/when-let
    [v5943 (:instance-count m5942)]
    (. bean5941 setInstanceCount (clojure.core/int v5943)))
   bean5941))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DescribeNetworkInterfacesRequest describe-network-interfaces-request
  [m5945]
  (clojure.core/let
   [bean5944
    (new
     com.amazonaws.services.ec2.model.DescribeNetworkInterfacesRequest)]
   (clojure.core/when-let
    [v5946 (:filters m5945)]
    (.
     bean5944
     setFilters
     (clojure.core/map
      (clojure.core/fn [arg5950] (filter arg5950))
      v5946)))
   (clojure.core/when-let
    [v5946 (:network-interface-ids m5945)]
    (.
     bean5944
     setNetworkInterfaceIds
     (clojure.core/map
      (clojure.core/fn [arg5951] (clojure.core/str arg5951))
      v5946)))
   bean5944))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DeleteVolumeRequest delete-volume-request
  [m5948]
  (clojure.core/let
   [bean5947
    (new com.amazonaws.services.ec2.model.DeleteVolumeRequest)]
   (clojure.core/when-let
    [v5949 (:volume-id m5948)]
    (. bean5947 setVolumeId (clojure.core/str v5949)))
   bean5947))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DeleteSnapshotRequest delete-snapshot-request
  [m5953]
  (clojure.core/let
   [bean5952
    (new com.amazonaws.services.ec2.model.DeleteSnapshotRequest)]
   (clojure.core/when-let
    [v5954 (:snapshot-id m5953)]
    (. bean5952 setSnapshotId (clojure.core/str v5954)))
   bean5952))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DescribeInstancesRequest describe-instances-request
  [m5956]
  (clojure.core/let
   [bean5955
    (new com.amazonaws.services.ec2.model.DescribeInstancesRequest)]
   (clojure.core/when-let
    [v5957 (:filters m5956)]
    (.
     bean5955
     setFilters
     (clojure.core/map
      (clojure.core/fn [arg5961] (filter arg5961))
      v5957)))
   (clojure.core/when-let
    [v5957 (:instance-ids m5956)]
    (.
     bean5955
     setInstanceIds
     (clojure.core/map
      (clojure.core/fn [arg5962] (clojure.core/str arg5962))
      v5957)))
   bean5955))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.AssociateRouteTableRequest associate-route-table-request
  [m5959]
  (clojure.core/let
   [bean5958
    (new com.amazonaws.services.ec2.model.AssociateRouteTableRequest)]
   (clojure.core/when-let
    [v5960 (:route-table-id m5959)]
    (. bean5958 setRouteTableId (clojure.core/str v5960)))
   (clojure.core/when-let
    [v5960 (:subnet-id m5959)]
    (. bean5958 setSubnetId (clojure.core/str v5960)))
   bean5958))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DisableVgwRoutePropagationRequest disable-vgw-route-propagation-request
  [m5964]
  (clojure.core/let
   [bean5963
    (new
     com.amazonaws.services.ec2.model.DisableVgwRoutePropagationRequest)]
   (clojure.core/when-let
    [v5965 (:gateway-id m5964)]
    (. bean5963 setGatewayId (clojure.core/str v5965)))
   (clojure.core/when-let
    [v5965 (:route-table-id m5964)]
    (. bean5963 setRouteTableId (clojure.core/str v5965)))
   bean5963))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DescribeInstanceAttributeRequest describe-instance-attribute-request
  [m5967]
  (clojure.core/let
   [bean5966
    (new
     com.amazonaws.services.ec2.model.DescribeInstanceAttributeRequest)]
   (clojure.core/when-let
    [v5968 (:attribute m5967)]
    (. bean5966 setAttribute (clojure.core/str v5968)))
   (clojure.core/when-let
    [v5968 (:attribute m5967)]
    (. bean5966 setAttribute (instance-attribute-name v5968)))
   (clojure.core/when-let
    [v5968 (:instance-id m5967)]
    (. bean5966 setInstanceId (clojure.core/str v5968)))
   bean5966))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.CreateVpnGatewayRequest create-vpn-gateway-request
  [m5970]
  (clojure.core/let
   [bean5969
    (new com.amazonaws.services.ec2.model.CreateVpnGatewayRequest)]
   (clojure.core/when-let
    [v5971 (:type m5970)]
    (. bean5969 setType (clojure.core/str v5971)))
   (clojure.core/when-let
    [v5971 (:type m5970)]
    (. bean5969 setType (gateway-type v5971)))
   (clojure.core/when-let
    [v5971 (:availability-zone m5970)]
    (. bean5969 setAvailabilityZone (clojure.core/str v5971)))
   bean5969))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.CreateNetworkAclRequest create-network-acl-request
  [m5973]
  (clojure.core/let
   [bean5972
    (new com.amazonaws.services.ec2.model.CreateNetworkAclRequest)]
   (clojure.core/when-let
    [v5974 (:vpc-id m5973)]
    (. bean5972 setVpcId (clojure.core/str v5974)))
   bean5972))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.ReplaceRouteRequest replace-route-request
  [m5976]
  (clojure.core/let
   [bean5975
    (new com.amazonaws.services.ec2.model.ReplaceRouteRequest)]
   (clojure.core/when-let
    [v5977 (:network-interface-id m5976)]
    (. bean5975 setNetworkInterfaceId (clojure.core/str v5977)))
   (clojure.core/when-let
    [v5977 (:gateway-id m5976)]
    (. bean5975 setGatewayId (clojure.core/str v5977)))
   (clojure.core/when-let
    [v5977 (:route-table-id m5976)]
    (. bean5975 setRouteTableId (clojure.core/str v5977)))
   (clojure.core/when-let
    [v5977 (:destination-cidr-block m5976)]
    (. bean5975 setDestinationCidrBlock (clojure.core/str v5977)))
   (clojure.core/when-let
    [v5977 (:instance-id m5976)]
    (. bean5975 setInstanceId (clojure.core/str v5977)))
   bean5975))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DescribeRegionsRequest describe-regions-request
  [m5979]
  (clojure.core/let
   [bean5978
    (new com.amazonaws.services.ec2.model.DescribeRegionsRequest)]
   (clojure.core/when-let
    [v5980 (:filters m5979)]
    (.
     bean5978
     setFilters
     (clojure.core/map
      (clojure.core/fn [arg5984] (filter arg5984))
      v5980)))
   (clojure.core/when-let
    [v5980 (:region-names m5979)]
    (.
     bean5978
     setRegionNames
     (clojure.core/map
      (clojure.core/fn [arg5985] (clojure.core/str arg5985))
      v5980)))
   bean5978))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DeleteInternetGatewayRequest delete-internet-gateway-request
  [m5982]
  (clojure.core/let
   [bean5981
    (new
     com.amazonaws.services.ec2.model.DeleteInternetGatewayRequest)]
   (clojure.core/when-let
    [v5983 (:internet-gateway-id m5982)]
    (. bean5981 setInternetGatewayId (clojure.core/str v5983)))
   bean5981))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DeleteRouteRequest delete-route-request
  [m5987]
  (clojure.core/let
   [bean5986
    (new com.amazonaws.services.ec2.model.DeleteRouteRequest)]
   (clojure.core/when-let
    [v5988 (:route-table-id m5987)]
    (. bean5986 setRouteTableId (clojure.core/str v5988)))
   (clojure.core/when-let
    [v5988 (:destination-cidr-block m5987)]
    (. bean5986 setDestinationCidrBlock (clojure.core/str v5988)))
   bean5986))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.AssignPrivateIpAddressesRequest assign-private-ip-addresses-request
  [m5990]
  (clojure.core/let
   [bean5989
    (new
     com.amazonaws.services.ec2.model.AssignPrivateIpAddressesRequest)]
   (clojure.core/when-let
    [v5991 (:network-interface-id m5990)]
    (. bean5989 setNetworkInterfaceId (clojure.core/str v5991)))
   (clojure.core/when-let
    [v5991 (:private-ip-addresses m5990)]
    (.
     bean5989
     setPrivateIpAddresses
     (clojure.core/map
      (clojure.core/fn [arg5995] (clojure.core/str arg5995))
      v5991)))
   (clojure.core/when-let
    [v5991 (:secondary-private-ip-address-count m5990)]
    (.
     bean5989
     setSecondaryPrivateIpAddressCount
     (clojure.core/int v5991)))
   (clojure.core/when-let
    [v5991 (:allow-reassignment m5990)]
    (. bean5989 setAllowReassignment (clojure.core/boolean v5991)))
   bean5989))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DeleteDhcpOptionsRequest delete-dhcp-options-request
  [m5993]
  (clojure.core/let
   [bean5992
    (new com.amazonaws.services.ec2.model.DeleteDhcpOptionsRequest)]
   (clojure.core/when-let
    [v5994 (:dhcp-options-id m5993)]
    (. bean5992 setDhcpOptionsId (clojure.core/str v5994)))
   bean5992))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.CancelSpotInstanceRequestsRequest cancel-spot-instance-requests-request
  [m5997]
  (clojure.core/let
   [bean5996
    (new
     com.amazonaws.services.ec2.model.CancelSpotInstanceRequestsRequest)]
   (clojure.core/when-let
    [v5998 (:spot-instance-request-ids m5997)]
    (.
     bean5996
     setSpotInstanceRequestIds
     (clojure.core/map
      (clojure.core/fn [arg6002] (clojure.core/str arg6002))
      v5998)))
   bean5996))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.CreateDhcpOptionsRequest create-dhcp-options-request
  [m6000]
  (clojure.core/let
   [bean5999
    (new com.amazonaws.services.ec2.model.CreateDhcpOptionsRequest)]
   (clojure.core/when-let
    [v6001 (:dhcp-configurations m6000)]
    (.
     bean5999
     setDhcpConfigurations
     (clojure.core/map
      (clojure.core/fn [arg6006] (dhcp-configuration arg6006))
      v6001)))
   bean5999))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.StopInstancesRequest stop-instances-request
  [m6004]
  (clojure.core/let
   [bean6003
    (new com.amazonaws.services.ec2.model.StopInstancesRequest)]
   (clojure.core/when-let
    [v6005 (:force m6004)]
    (. bean6003 setForce (clojure.core/boolean v6005)))
   (clojure.core/when-let
    [v6005 (:instance-ids m6004)]
    (.
     bean6003
     setInstanceIds
     (clojure.core/map
      (clojure.core/fn [arg6010] (clojure.core/str arg6010))
      v6005)))
   bean6003))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.AuthorizeSecurityGroupIngressRequest authorize-security-group-ingress-request
  [m6008]
  (clojure.core/let
   [bean6007
    (new
     com.amazonaws.services.ec2.model.AuthorizeSecurityGroupIngressRequest)]
   (clojure.core/when-let
    [v6009 (:group-name m6008)]
    (. bean6007 setGroupName (clojure.core/str v6009)))
   (clojure.core/when-let
    [v6009 (:group-id m6008)]
    (. bean6007 setGroupId (clojure.core/str v6009)))
   (clojure.core/when-let
    [v6009 (:source-security-group-name m6008)]
    (. bean6007 setSourceSecurityGroupName (clojure.core/str v6009)))
   (clojure.core/when-let
    [v6009 (:source-security-group-owner-id m6008)]
    (.
     bean6007
     setSourceSecurityGroupOwnerId
     (clojure.core/str v6009)))
   (clojure.core/when-let
    [v6009 (:ip-protocol m6008)]
    (. bean6007 setIpProtocol (clojure.core/str v6009)))
   (clojure.core/when-let
    [v6009 (:from-port m6008)]
    (. bean6007 setFromPort (clojure.core/int v6009)))
   (clojure.core/when-let
    [v6009 (:to-port m6008)]
    (. bean6007 setToPort (clojure.core/int v6009)))
   (clojure.core/when-let
    [v6009 (:cidr-ip m6008)]
    (. bean6007 setCidrIp (clojure.core/str v6009)))
   (clojure.core/when-let
    [v6009 (:ip-permissions m6008)]
    (.
     bean6007
     setIpPermissions
     (clojure.core/map
      (clojure.core/fn [arg6014] (ip-permission arg6014))
      v6009)))
   bean6007))
 (clojure.core/defn
  ^com.amazonaws.services.ec2.model.DescribePlacementGroupsRequest describe-placement-groups-request
  [m6012]
  (clojure.core/let
   [bean6011
    (new
     com.amazonaws.services.ec2.model.DescribePlacementGroupsRequest)]
   (clojure.core/when-let
    [v6013 (:filters m6012)]
    (.
     bean6011
     setFilters
     (clojure.core/map
      (clojure.core/fn [arg6015] (filter arg6015))
      v6013)))
   (clojure.core/when-let
    [v6013 (:group-names m6012)]
    (.
     bean6011
     setGroupNames
     (clojure.core/map
      (clojure.core/fn [arg6016] (clojure.core/str arg6016))
      v6013)))
   bean6011))
 (clojure.core/defmulti
  ec2
  (clojure.core/fn ec2 [m__1641__auto__] (:fn m__1641__auto__)))
 (do
  (clojure.core/defmethod
   ec2
   :describe-security-groups
   [m6017]
   (clojure.core/let
    [credentials6018 (:credentials m6017) args6019 (:args m6017)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6020
      (com.palletops.awaze.common/aws-client :ec2 credentials6018)]
     (clojure.core/case
      (clojure.core/count args6019)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client6020
        describeSecurityGroups
        (describe-security-groups-request
         (clojure.core/nth args6019 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client6020
        describeSecurityGroups))))))
  (clojure.core/defn
   describe-security-groups-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         group-names
                         group-ids
                         filters
                         dry-run-request]}]
                [credentials]]),
    :doc "Generate map for describeSecurityGroups, describeSecurityGroups"}
   ([credentials__1609__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-security-groups,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-security-groups,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-security-groups
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         group-names
                         group-ids
                         filters
                         dry-run-request]}]
                [credentials]]),
    :doc "Call describeSecurityGroups, describeSecurityGroups"}
   [credentials6022 & args6023]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6024
     (com.palletops.awaze.common/aws-client :ec2 credentials6022)]
    (clojure.core/case
     (clojure.core/count args6023)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6024
       describeSecurityGroups
       (describe-security-groups-request
        (clojure.core/nth args6023 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6024
       describeSecurityGroups))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-vpc
   [m6025]
   (clojure.core/let
    [credentials6026 (:credentials m6025) args6027 (:args m6025)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6028
      (com.palletops.awaze.common/aws-client :ec2 credentials6026)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6028
       createVpc
       (create-vpc-request (clojure.core/nth args6027 0)))))))
  (clojure.core/defn
   create-vpc-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         instance-tenancy
                         dry-run-request
                         cidr-block]}]]),
    :doc "Generate map for createVpc"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :create-vpc,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   create-vpc
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         instance-tenancy
                         dry-run-request
                         cidr-block]}]]),
    :doc "Call createVpc"}
   [credentials6030 & args6031]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6032
     (com.palletops.awaze.common/aws-client :ec2 credentials6030)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client6032
      createVpc
      (create-vpc-request (clojure.core/nth args6031 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :deregister-image
   [m6033]
   (clojure.core/let
    [credentials6034 (:credentials m6033) args6035 (:args m6033)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6036
      (com.palletops.awaze.common/aws-client :ec2 credentials6034)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6036
       deregisterImage
       (deregister-image-request (clojure.core/nth args6035 0)))))))
  (clojure.core/defn
   deregister-image-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         image-id
                         dry-run-request]}]]),
    :doc "Generate map for deregisterImage"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :deregister-image,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   deregister-image
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         image-id
                         dry-run-request]}]]),
    :doc "Call deregisterImage"}
   [credentials6038 & args6039]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6040
     (com.palletops.awaze.common/aws-client :ec2 credentials6038)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client6040
      deregisterImage
      (deregister-image-request (clojure.core/nth args6039 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-network-acl-entry
   [m6041]
   (clojure.core/let
    [credentials6042 (:credentials m6041) args6043 (:args m6041)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6044
      (com.palletops.awaze.common/aws-client :ec2 credentials6042)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6044
       createNetworkAclEntry
       (create-network-acl-entry-request
        (clojure.core/nth args6043 0)))))))
  (clojure.core/defn
   create-network-acl-entry-map
   {:arglists (quote
               [[credentials
                 {:keys [protocol
                         dry-run-request
                         request-metric-collector
                         icmp-type-code
                         network-acl-id
                         rule-number
                         cidr-block
                         egress
                         port-range
                         rule-action]}]]),
    :doc "Generate map for createNetworkAclEntry"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :create-network-acl-entry,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   create-network-acl-entry
   {:arglists (quote
               [[credentials
                 {:keys [protocol
                         dry-run-request
                         request-metric-collector
                         icmp-type-code
                         network-acl-id
                         rule-number
                         cidr-block
                         egress
                         port-range
                         rule-action]}]]),
    :doc "Call createNetworkAclEntry"}
   [credentials6046 & args6047]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6048
     (com.palletops.awaze.common/aws-client :ec2 credentials6046)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client6048
      createNetworkAclEntry
      (create-network-acl-entry-request (clojure.core/nth args6047 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :cancel-export-task
   [m6049]
   (clojure.core/let
    [credentials6050 (:credentials m6049) args6051 (:args m6049)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6052
      (com.palletops.awaze.common/aws-client :ec2 credentials6050)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6052
       cancelExportTask
       (cancel-export-task-request (clojure.core/nth args6051 0)))))))
  (clojure.core/defn
   cancel-export-task-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector export-task-id]}]]),
    :doc "Generate map for cancelExportTask"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :cancel-export-task,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   cancel-export-task
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector export-task-id]}]]),
    :doc "Call cancelExportTask"}
   [credentials6054 & args6055]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6056
     (com.palletops.awaze.common/aws-client :ec2 credentials6054)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client6056
      cancelExportTask
      (cancel-export-task-request (clojure.core/nth args6055 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :revoke-security-group-ingress
   [m6057]
   (clojure.core/let
    [credentials6058 (:credentials m6057) args6059 (:args m6057)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6060
      (com.palletops.awaze.common/aws-client :ec2 credentials6058)]
     (clojure.core/case
      (clojure.core/count args6059)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client6060
        revokeSecurityGroupIngress
        (revoke-security-group-ingress-request
         (clojure.core/nth args6059 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client6060
        revokeSecurityGroupIngress))))))
  (clojure.core/defn
   revoke-security-group-ingress-map
   {:arglists (quote
               [[credentials
                 {:keys [dry-run-request
                         source-security-group-name
                         request-metric-collector
                         group-id
                         from-port
                         ip-permissions
                         to-port
                         cidr-ip
                         ip-protocol
                         source-security-group-owner-id
                         group-name]}]
                [credentials]]),
    :doc "Generate map for revokeSecurityGroupIngress, revokeSecurityGroupIngress"}
   ([credentials__1609__auto__]
    {:args [],
     :client :ec2,
     :fn :revoke-security-group-ingress,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :revoke-security-group-ingress,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   revoke-security-group-ingress
   {:arglists (quote
               [[credentials
                 {:keys [dry-run-request
                         source-security-group-name
                         request-metric-collector
                         group-id
                         from-port
                         ip-permissions
                         to-port
                         cidr-ip
                         ip-protocol
                         source-security-group-owner-id
                         group-name]}]
                [credentials]]),
    :doc "Call revokeSecurityGroupIngress, revokeSecurityGroupIngress"}
   [credentials6062 & args6063]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6064
     (com.palletops.awaze.common/aws-client :ec2 credentials6062)]
    (clojure.core/case
     (clojure.core/count args6063)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6064
       revokeSecurityGroupIngress
       (revoke-security-group-ingress-request
        (clojure.core/nth args6063 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6064
       revokeSecurityGroupIngress))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-route-tables
   [m6065]
   (clojure.core/let
    [credentials6066 (:credentials m6065) args6067 (:args m6065)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6068
      (com.palletops.awaze.common/aws-client :ec2 credentials6066)]
     (clojure.core/case
      (clojure.core/count args6067)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client6068
        describeRouteTables))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client6068
        describeRouteTables
        (describe-route-tables-request (clojure.core/nth args6067 0))))))))
  (clojure.core/defn
   describe-route-tables-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [route-table-ids
                         request-metric-collector
                         filters
                         dry-run-request]}]]),
    :doc "Generate map for describeRouteTables, describeRouteTables"}
   ([credentials__1609__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-route-tables,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-route-tables,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-route-tables
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [route-table-ids
                         request-metric-collector
                         filters
                         dry-run-request]}]]),
    :doc "Call describeRouteTables, describeRouteTables"}
   [credentials6070 & args6071]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6072
     (com.palletops.awaze.common/aws-client :ec2 credentials6070)]
    (clojure.core/case
     (clojure.core/count args6071)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6072
       describeRouteTables))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6072
       describeRouteTables
       (describe-route-tables-request (clojure.core/nth args6071 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-reserved-instances-listing
   [m6073]
   (clojure.core/let
    [credentials6074 (:credentials m6073) args6075 (:args m6073)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6076
      (com.palletops.awaze.common/aws-client :ec2 credentials6074)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6076
       createReservedInstancesListing
       (create-reserved-instances-listing-request
        (clojure.core/nth args6075 0)))))))
  (clojure.core/defn
   create-reserved-instances-listing-map
   {:arglists (quote
               [[credentials
                 {:keys [reserved-instances-id
                         request-metric-collector
                         price-schedules
                         instance-count
                         client-token]}]]),
    :doc "Generate map for createReservedInstancesListing"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :create-reserved-instances-listing,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   create-reserved-instances-listing
   {:arglists (quote
               [[credentials
                 {:keys [reserved-instances-id
                         request-metric-collector
                         price-schedules
                         instance-count
                         client-token]}]]),
    :doc "Call createReservedInstancesListing"}
   [credentials6078 & args6079]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6080
     (com.palletops.awaze.common/aws-client :ec2 credentials6078)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client6080
      createReservedInstancesListing
      (create-reserved-instances-listing-request
       (clojure.core/nth args6079 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :reset-image-attribute
   [m6081]
   (clojure.core/let
    [credentials6082 (:credentials m6081) args6083 (:args m6081)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6084
      (com.palletops.awaze.common/aws-client :ec2 credentials6082)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6084
       resetImageAttribute
       (reset-image-attribute-request (clojure.core/nth args6083 0)))))))
  (clojure.core/defn
   reset-image-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         image-id
                         dry-run-request
                         attribute]}]]),
    :doc "Generate map for resetImageAttribute"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :reset-image-attribute,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   reset-image-attribute
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         image-id
                         dry-run-request
                         attribute]}]]),
    :doc "Call resetImageAttribute"}
   [credentials6086 & args6087]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6088
     (com.palletops.awaze.common/aws-client :ec2 credentials6086)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client6088
      resetImageAttribute
      (reset-image-attribute-request (clojure.core/nth args6087 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-availability-zones
   [m6089]
   (clojure.core/let
    [credentials6090 (:credentials m6089) args6091 (:args m6089)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6092
      (com.palletops.awaze.common/aws-client :ec2 credentials6090)]
     (clojure.core/case
      (clojure.core/count args6091)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client6092
        describeAvailabilityZones
        (describe-availability-zones-request
         (clojure.core/nth args6091 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client6092
        describeAvailabilityZones))))))
  (clojure.core/defn
   describe-availability-zones-map
   {:arglists (quote
               [[credentials
                 {:keys [zone-names
                         request-metric-collector
                         filters
                         dry-run-request]}]
                [credentials]]),
    :doc "Generate map for describeAvailabilityZones, describeAvailabilityZones"}
   ([credentials__1609__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-availability-zones,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-availability-zones,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-availability-zones
   {:arglists (quote
               [[credentials
                 {:keys [zone-names
                         request-metric-collector
                         filters
                         dry-run-request]}]
                [credentials]]),
    :doc "Call describeAvailabilityZones, describeAvailabilityZones"}
   [credentials6094 & args6095]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6096
     (com.palletops.awaze.common/aws-client :ec2 credentials6094)]
    (clojure.core/case
     (clojure.core/count args6095)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6096
       describeAvailabilityZones
       (describe-availability-zones-request
        (clojure.core/nth args6095 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6096
       describeAvailabilityZones))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-network-acls
   [m6097]
   (clojure.core/let
    [credentials6098 (:credentials m6097) args6099 (:args m6097)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6100
      (com.palletops.awaze.common/aws-client :ec2 credentials6098)]
     (clojure.core/case
      (clojure.core/count args6099)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client6100
        describeNetworkAcls))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client6100
        describeNetworkAcls
        (describe-network-acls-request (clojure.core/nth args6099 0))))))))
  (clojure.core/defn
   describe-network-acls-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [request-metric-collector
                         network-acl-ids
                         filters
                         dry-run-request]}]]),
    :doc "Generate map for describeNetworkAcls, describeNetworkAcls"}
   ([credentials__1609__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-network-acls,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-network-acls,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-network-acls
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [request-metric-collector
                         network-acl-ids
                         filters
                         dry-run-request]}]]),
    :doc "Call describeNetworkAcls, describeNetworkAcls"}
   [credentials6102 & args6103]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6104
     (com.palletops.awaze.common/aws-client :ec2 credentials6102)]
    (clojure.core/case
     (clojure.core/count args6103)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6104
       describeNetworkAcls))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6104
       describeNetworkAcls
       (describe-network-acls-request (clojure.core/nth args6103 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-vpn-gateways
   [m6105]
   (clojure.core/let
    [credentials6106 (:credentials m6105) args6107 (:args m6105)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6108
      (com.palletops.awaze.common/aws-client :ec2 credentials6106)]
     (clojure.core/case
      (clojure.core/count args6107)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client6108
        describeVpnGateways
        (describe-vpn-gateways-request (clojure.core/nth args6107 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client6108
        describeVpnGateways))))))
  (clojure.core/defn
   describe-vpn-gateways-map
   {:arglists (quote
               [[credentials
                 {:keys [vpn-gateway-ids
                         request-metric-collector
                         filters
                         dry-run-request]}]
                [credentials]]),
    :doc "Generate map for describeVpnGateways, describeVpnGateways"}
   ([credentials__1609__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-vpn-gateways,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-vpn-gateways,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-vpn-gateways
   {:arglists (quote
               [[credentials
                 {:keys [vpn-gateway-ids
                         request-metric-collector
                         filters
                         dry-run-request]}]
                [credentials]]),
    :doc "Call describeVpnGateways, describeVpnGateways"}
   [credentials6110 & args6111]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6112
     (com.palletops.awaze.common/aws-client :ec2 credentials6110)]
    (clojure.core/case
     (clojure.core/count args6111)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6112
       describeVpnGateways
       (describe-vpn-gateways-request (clojure.core/nth args6111 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6112
       describeVpnGateways))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-snapshots
   [m6113]
   (clojure.core/let
    [credentials6114 (:credentials m6113) args6115 (:args m6113)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6116
      (com.palletops.awaze.common/aws-client :ec2 credentials6114)]
     (clojure.core/case
      (clojure.core/count args6115)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client6116
        describeSnapshots
        (describe-snapshots-request (clojure.core/nth args6115 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client6116
        describeSnapshots))))))
  (clojure.core/defn
   describe-snapshots-map
   {:arglists (quote
               [[credentials
                 {:keys [snapshot-ids
                         restorable-by-user-ids
                         request-metric-collector
                         owner-ids
                         filters
                         dry-run-request]}]
                [credentials]]),
    :doc "Generate map for describeSnapshots, describeSnapshots"}
   ([credentials__1609__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-snapshots,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-snapshots,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-snapshots
   {:arglists (quote
               [[credentials
                 {:keys [snapshot-ids
                         restorable-by-user-ids
                         request-metric-collector
                         owner-ids
                         filters
                         dry-run-request]}]
                [credentials]]),
    :doc "Call describeSnapshots, describeSnapshots"}
   [credentials6118 & args6119]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6120
     (com.palletops.awaze.common/aws-client :ec2 credentials6118)]
    (clojure.core/case
     (clojure.core/count args6119)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6120
       describeSnapshots
       (describe-snapshots-request (clojure.core/nth args6119 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6120
       describeSnapshots))))))
 (do
  (clojure.core/defmethod
   ec2
   :modify-image-attribute
   [m6121]
   (clojure.core/let
    [credentials6122 (:credentials m6121) args6123 (:args m6121)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6124
      (com.palletops.awaze.common/aws-client :ec2 credentials6122)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6124
       modifyImageAttribute
       (modify-image-attribute-request (clojure.core/nth args6123 0)))))))
  (clojure.core/defn
   modify-image-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [user-groups
                         dry-run-request
                         launch-permission
                         request-metric-collector
                         user-ids
                         operation-type
                         attribute
                         image-id
                         product-codes
                         value
                         description]}]]),
    :doc "Generate map for modifyImageAttribute"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :modify-image-attribute,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   modify-image-attribute
   {:arglists (quote
               [[credentials
                 {:keys [user-groups
                         dry-run-request
                         launch-permission
                         request-metric-collector
                         user-ids
                         operation-type
                         attribute
                         image-id
                         product-codes
                         value
                         description]}]]),
    :doc "Call modifyImageAttribute"}
   [credentials6126 & args6127]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6128
     (com.palletops.awaze.common/aws-client :ec2 credentials6126)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client6128
      modifyImageAttribute
      (modify-image-attribute-request (clojure.core/nth args6127 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-volumes
   [m6129]
   (clojure.core/let
    [credentials6130 (:credentials m6129) args6131 (:args m6129)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6132
      (com.palletops.awaze.common/aws-client :ec2 credentials6130)]
     (clojure.core/case
      (clojure.core/count args6131)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client6132
        describeVolumes
        (describe-volumes-request (clojure.core/nth args6131 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client6132
        describeVolumes))))))
  (clojure.core/defn
   describe-volumes-map
   {:arglists (quote
               [[credentials
                 {:keys [volume-ids
                         request-metric-collector
                         filters
                         dry-run-request]}]
                [credentials]]),
    :doc "Generate map for describeVolumes, describeVolumes"}
   ([credentials__1609__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-volumes,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-volumes,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-volumes
   {:arglists (quote
               [[credentials
                 {:keys [volume-ids
                         request-metric-collector
                         filters
                         dry-run-request]}]
                [credentials]]),
    :doc "Call describeVolumes, describeVolumes"}
   [credentials6134 & args6135]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6136
     (com.palletops.awaze.common/aws-client :ec2 credentials6134)]
    (clojure.core/case
     (clojure.core/count args6135)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6136
       describeVolumes
       (describe-volumes-request (clojure.core/nth args6135 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6136
       describeVolumes))))))
 (do
  (clojure.core/defmethod
   ec2
   :attach-internet-gateway
   [m6137]
   (clojure.core/let
    [credentials6138 (:credentials m6137) args6139 (:args m6137)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6140
      (com.palletops.awaze.common/aws-client :ec2 credentials6138)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6140
       attachInternetGateway
       (attach-internet-gateway-request (clojure.core/nth args6139 0)))))))
  (clojure.core/defn
   attach-internet-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [vpc-id
                         request-metric-collector
                         internet-gateway-id
                         dry-run-request]}]]),
    :doc "Generate map for attachInternetGateway"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :attach-internet-gateway,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   attach-internet-gateway
   {:arglists (quote
               [[credentials
                 {:keys [vpc-id
                         request-metric-collector
                         internet-gateway-id
                         dry-run-request]}]]),
    :doc "Call attachInternetGateway"}
   [credentials6142 & args6143]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6144
     (com.palletops.awaze.common/aws-client :ec2 credentials6142)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client6144
      attachInternetGateway
      (attach-internet-gateway-request (clojure.core/nth args6143 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-licenses
   [m6145]
   (clojure.core/let
    [credentials6146 (:credentials m6145) args6147 (:args m6145)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6148
      (com.palletops.awaze.common/aws-client :ec2 credentials6146)]
     (clojure.core/case
      (clojure.core/count args6147)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client6148
        describeLicenses
        (describe-licenses-request (clojure.core/nth args6147 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client6148
        describeLicenses))))))
  (clojure.core/defn
   describe-licenses-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         license-ids
                         filters
                         dry-run-request]}]
                [credentials]]),
    :doc "Generate map for describeLicenses, describeLicenses"}
   ([credentials__1609__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-licenses,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-licenses,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-licenses
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         license-ids
                         filters
                         dry-run-request]}]
                [credentials]]),
    :doc "Call describeLicenses, describeLicenses"}
   [credentials6150 & args6151]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6152
     (com.palletops.awaze.common/aws-client :ec2 credentials6150)]
    (clojure.core/case
     (clojure.core/count args6151)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6152
       describeLicenses
       (describe-licenses-request (clojure.core/nth args6151 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6152
       describeLicenses))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-security-group
   [m6153]
   (clojure.core/let
    [credentials6154 (:credentials m6153) args6155 (:args m6153)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6156
      (com.palletops.awaze.common/aws-client :ec2 credentials6154)]
     (clojure.core/case
      (clojure.core/count args6155)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client6156
        deleteSecurityGroup))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client6156
        deleteSecurityGroup
        (delete-security-group-request (clojure.core/nth args6155 0))))))))
  (clojure.core/defn
   delete-security-group-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [request-metric-collector
                         group-name
                         group-id
                         dry-run-request]}]]),
    :doc "Generate map for deleteSecurityGroup, deleteSecurityGroup"}
   ([credentials__1609__auto__]
    {:args [],
     :client :ec2,
     :fn :delete-security-group,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :delete-security-group,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   delete-security-group
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [request-metric-collector
                         group-name
                         group-id
                         dry-run-request]}]]),
    :doc "Call deleteSecurityGroup, deleteSecurityGroup"}
   [credentials6158 & args6159]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6160
     (com.palletops.awaze.common/aws-client :ec2 credentials6158)]
    (clojure.core/case
     (clojure.core/count args6159)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6160
       deleteSecurityGroup))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6160
       deleteSecurityGroup
       (delete-security-group-request (clojure.core/nth args6159 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :detach-volume
   [m6161]
   (clojure.core/let
    [credentials6162 (:credentials m6161) args6163 (:args m6161)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6164
      (com.palletops.awaze.common/aws-client :ec2 credentials6162)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6164
       detachVolume
       (detach-volume-request (clojure.core/nth args6163 0)))))))
  (clojure.core/defn
   detach-volume-map
   {:arglists (quote
               [[credentials
                 {:keys [volume-id
                         request-metric-collector
                         instance-id
                         force
                         dry-run-request
                         device]}]]),
    :doc "Generate map for detachVolume"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :detach-volume,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   detach-volume
   {:arglists (quote
               [[credentials
                 {:keys [volume-id
                         request-metric-collector
                         instance-id
                         force
                         dry-run-request
                         device]}]]),
    :doc "Call detachVolume"}
   [credentials6166 & args6167]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6168
     (com.palletops.awaze.common/aws-client :ec2 credentials6166)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client6168
      detachVolume
      (detach-volume-request (clojure.core/nth args6167 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :release-address
   [m6169]
   (clojure.core/let
    [credentials6170 (:credentials m6169) args6171 (:args m6169)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6172
      (com.palletops.awaze.common/aws-client :ec2 credentials6170)]
     (clojure.core/case
      (clojure.core/count args6171)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client6172
        releaseAddress
        (release-address-request (clojure.core/nth args6171 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client6172
        releaseAddress))))))
  (clojure.core/defn
   release-address-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         public-ip
                         dry-run-request
                         allocation-id]}]
                [credentials]]),
    :doc "Generate map for releaseAddress, releaseAddress"}
   ([credentials__1609__auto__]
    {:args [],
     :client :ec2,
     :fn :release-address,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :release-address,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   release-address
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         public-ip
                         dry-run-request
                         allocation-id]}]
                [credentials]]),
    :doc "Call releaseAddress, releaseAddress"}
   [credentials6174 & args6175]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6176
     (com.palletops.awaze.common/aws-client :ec2 credentials6174)]
    (clojure.core/case
     (clojure.core/count args6175)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6176
       releaseAddress
       (release-address-request (clojure.core/nth args6175 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6176
       releaseAddress))))))
 (do
  (clojure.core/defmethod
   ec2
   :import-volume
   [m6177]
   (clojure.core/let
    [credentials6178 (:credentials m6177) args6179 (:args m6177)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6180
      (com.palletops.awaze.common/aws-client :ec2 credentials6178)]
     (clojure.core/case
      (clojure.core/count args6179)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client6180
        importVolume))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client6180
        importVolume
        (import-volume-request (clojure.core/nth args6179 0))))))))
  (clojure.core/defn
   import-volume-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [volume
                         request-metric-collector
                         image
                         dry-run-request
                         description
                         availability-zone]}]]),
    :doc "Generate map for importVolume, importVolume"}
   ([credentials__1609__auto__]
    {:args [],
     :client :ec2,
     :fn :import-volume,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :import-volume,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   import-volume
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [volume
                         request-metric-collector
                         image
                         dry-run-request
                         description
                         availability-zone]}]]),
    :doc "Call importVolume, importVolume"}
   [credentials6182 & args6183]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6184
     (com.palletops.awaze.common/aws-client :ec2 credentials6182)]
    (clojure.core/case
     (clojure.core/count args6183)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6184
       importVolume))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6184
       importVolume
       (import-volume-request (clojure.core/nth args6183 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-route-table
   [m6185]
   (clojure.core/let
    [credentials6186 (:credentials m6185) args6187 (:args m6185)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6188
      (com.palletops.awaze.common/aws-client :ec2 credentials6186)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6188
       deleteRouteTable
       (delete-route-table-request (clojure.core/nth args6187 0)))))))
  (clojure.core/defn
   delete-route-table-map
   {:arglists (quote
               [[credentials
                 {:keys [route-table-id
                         request-metric-collector
                         dry-run-request]}]]),
    :doc "Generate map for deleteRouteTable"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :delete-route-table,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   delete-route-table
   {:arglists (quote
               [[credentials
                 {:keys [route-table-id
                         request-metric-collector
                         dry-run-request]}]]),
    :doc "Call deleteRouteTable"}
   [credentials6190 & args6191]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6192
     (com.palletops.awaze.common/aws-client :ec2 credentials6190)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client6192
      deleteRouteTable
      (delete-route-table-request (clojure.core/nth args6191 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-snapshot-attribute
   [m6193]
   (clojure.core/let
    [credentials6194 (:credentials m6193) args6195 (:args m6193)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6196
      (com.palletops.awaze.common/aws-client :ec2 credentials6194)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6196
       describeSnapshotAttribute
       (describe-snapshot-attribute-request
        (clojure.core/nth args6195 0)))))))
  (clojure.core/defn
   describe-snapshot-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [snapshot-id
                         request-metric-collector
                         dry-run-request
                         attribute]}]]),
    :doc "Generate map for describeSnapshotAttribute"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-snapshot-attribute,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-snapshot-attribute
   {:arglists (quote
               [[credentials
                 {:keys [snapshot-id
                         request-metric-collector
                         dry-run-request
                         attribute]}]]),
    :doc "Call describeSnapshotAttribute"}
   [credentials6198 & args6199]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6200
     (com.palletops.awaze.common/aws-client :ec2 credentials6198)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client6200
      describeSnapshotAttribute
      (describe-snapshot-attribute-request
       (clojure.core/nth args6199 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-instance-status
   [m6201]
   (clojure.core/let
    [credentials6202 (:credentials m6201) args6203 (:args m6201)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6204
      (com.palletops.awaze.common/aws-client :ec2 credentials6202)]
     (clojure.core/case
      (clojure.core/count args6203)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client6204
        describeInstanceStatus))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client6204
        describeInstanceStatus
        (describe-instance-status-request
         (clojure.core/nth args6203 0))))))))
  (clojure.core/defn
   describe-instance-status-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [dry-run-request
                         instance-ids
                         next-token
                         filters
                         request-metric-collector
                         include-all-instances
                         max-results]}]]),
    :doc "Generate map for describeInstanceStatus, describeInstanceStatus"}
   ([credentials__1609__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-instance-status,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-instance-status,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-instance-status
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [dry-run-request
                         instance-ids
                         next-token
                         filters
                         request-metric-collector
                         include-all-instances
                         max-results]}]]),
    :doc "Call describeInstanceStatus, describeInstanceStatus"}
   [credentials6206 & args6207]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6208
     (com.palletops.awaze.common/aws-client :ec2 credentials6206)]
    (clojure.core/case
     (clojure.core/count args6207)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6208
       describeInstanceStatus))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6208
       describeInstanceStatus
       (describe-instance-status-request
        (clojure.core/nth args6207 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-image-attribute
   [m6209]
   (clojure.core/let
    [credentials6210 (:credentials m6209) args6211 (:args m6209)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6212
      (com.palletops.awaze.common/aws-client :ec2 credentials6210)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6212
       describeImageAttribute
       (describe-image-attribute-request
        (clojure.core/nth args6211 0)))))))
  (clojure.core/defn
   describe-image-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         image-id
                         dry-run-request
                         attribute]}]]),
    :doc "Generate map for describeImageAttribute"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-image-attribute,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-image-attribute
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         image-id
                         dry-run-request
                         attribute]}]]),
    :doc "Call describeImageAttribute"}
   [credentials6214 & args6215]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6216
     (com.palletops.awaze.common/aws-client :ec2 credentials6214)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client6216
      describeImageAttribute
      (describe-image-attribute-request (clojure.core/nth args6215 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :report-instance-status
   [m6217]
   (clojure.core/let
    [credentials6218 (:credentials m6217) args6219 (:args m6217)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6220
      (com.palletops.awaze.common/aws-client :ec2 credentials6218)]
     (clojure.core/case
      (clojure.core/count args6219)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client6220
        reportInstanceStatus))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client6220
        reportInstanceStatus
        (report-instance-status-request (clojure.core/nth args6219 0))))))))
  (clojure.core/defn
   report-instance-status-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [end-time
                         status
                         dry-run-request
                         request-metric-collector
                         reason-codes
                         start-time
                         description
                         instances]}]]),
    :doc "Generate map for reportInstanceStatus, reportInstanceStatus"}
   ([credentials__1609__auto__]
    {:args [],
     :client :ec2,
     :fn :report-instance-status,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :report-instance-status,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   report-instance-status
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [end-time
                         status
                         dry-run-request
                         request-metric-collector
                         reason-codes
                         start-time
                         description
                         instances]}]]),
    :doc "Call reportInstanceStatus, reportInstanceStatus"}
   [credentials6222 & args6223]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6224
     (com.palletops.awaze.common/aws-client :ec2 credentials6222)]
    (clojure.core/case
     (clojure.core/count args6223)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6224
       reportInstanceStatus))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6224
       reportInstanceStatus
       (report-instance-status-request (clojure.core/nth args6223 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-tags
   [m6225]
   (clojure.core/let
    [credentials6226 (:credentials m6225) args6227 (:args m6225)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6228
      (com.palletops.awaze.common/aws-client :ec2 credentials6226)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6228
       deleteTags
       (delete-tags-request (clojure.core/nth args6227 0)))))))
  (clojure.core/defn
   delete-tags-map
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         resources
                         request-metric-collector
                         dry-run-request]}]]),
    :doc "Generate map for deleteTags"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :delete-tags,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   delete-tags
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         resources
                         request-metric-collector
                         dry-run-request]}]]),
    :doc "Call deleteTags"}
   [credentials6230 & args6231]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6232
     (com.palletops.awaze.common/aws-client :ec2 credentials6230)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client6232
      deleteTags
      (delete-tags-request (clojure.core/nth args6231 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :reset-snapshot-attribute
   [m6233]
   (clojure.core/let
    [credentials6234 (:credentials m6233) args6235 (:args m6233)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6236
      (com.palletops.awaze.common/aws-client :ec2 credentials6234)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6236
       resetSnapshotAttribute
       (reset-snapshot-attribute-request
        (clojure.core/nth args6235 0)))))))
  (clojure.core/defn
   reset-snapshot-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [snapshot-id
                         request-metric-collector
                         dry-run-request
                         attribute]}]]),
    :doc "Generate map for resetSnapshotAttribute"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :reset-snapshot-attribute,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   reset-snapshot-attribute
   {:arglists (quote
               [[credentials
                 {:keys [snapshot-id
                         request-metric-collector
                         dry-run-request
                         attribute]}]]),
    :doc "Call resetSnapshotAttribute"}
   [credentials6238 & args6239]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6240
     (com.palletops.awaze.common/aws-client :ec2 credentials6238)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client6240
      resetSnapshotAttribute
      (reset-snapshot-attribute-request (clojure.core/nth args6239 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :associate-dhcp-options
   [m6241]
   (clojure.core/let
    [credentials6242 (:credentials m6241) args6243 (:args m6241)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6244
      (com.palletops.awaze.common/aws-client :ec2 credentials6242)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6244
       associateDhcpOptions
       (associate-dhcp-options-request (clojure.core/nth args6243 0)))))))
  (clojure.core/defn
   associate-dhcp-options-map
   {:arglists (quote
               [[credentials
                 {:keys [vpc-id
                         request-metric-collector
                         dry-run-request
                         dhcp-options-id]}]]),
    :doc "Generate map for associateDhcpOptions"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :associate-dhcp-options,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   associate-dhcp-options
   {:arglists (quote
               [[credentials
                 {:keys [vpc-id
                         request-metric-collector
                         dry-run-request
                         dhcp-options-id]}]]),
    :doc "Call associateDhcpOptions"}
   [credentials6246 & args6247]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6248
     (com.palletops.awaze.common/aws-client :ec2 credentials6246)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client6248
      associateDhcpOptions
      (associate-dhcp-options-request (clojure.core/nth args6247 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :modify-snapshot-attribute
   [m6249]
   (clojure.core/let
    [credentials6250 (:credentials m6249) args6251 (:args m6249)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6252
      (com.palletops.awaze.common/aws-client :ec2 credentials6250)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6252
       modifySnapshotAttribute
       (modify-snapshot-attribute-request
        (clojure.core/nth args6251 0)))))))
  (clojure.core/defn
   modify-snapshot-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [dry-run-request
                         request-metric-collector
                         group-names
                         snapshot-id
                         user-ids
                         operation-type
                         attribute
                         create-volume-permission]}]]),
    :doc "Generate map for modifySnapshotAttribute"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :modify-snapshot-attribute,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   modify-snapshot-attribute
   {:arglists (quote
               [[credentials
                 {:keys [dry-run-request
                         request-metric-collector
                         group-names
                         snapshot-id
                         user-ids
                         operation-type
                         attribute
                         create-volume-permission]}]]),
    :doc "Call modifySnapshotAttribute"}
   [credentials6254 & args6255]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6256
     (com.palletops.awaze.common/aws-client :ec2 credentials6254)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client6256
      modifySnapshotAttribute
      (modify-snapshot-attribute-request
       (clojure.core/nth args6255 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :modify-volume-attribute
   [m6257]
   (clojure.core/let
    [credentials6258 (:credentials m6257) args6259 (:args m6257)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6260
      (com.palletops.awaze.common/aws-client :ec2 credentials6258)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6260
       modifyVolumeAttribute
       (modify-volume-attribute-request (clojure.core/nth args6259 0)))))))
  (clojure.core/defn
   modify-volume-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [volume-id
                         request-metric-collector
                         dry-run-request
                         auto-enable-io]}]]),
    :doc "Generate map for modifyVolumeAttribute"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :modify-volume-attribute,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   modify-volume-attribute
   {:arglists (quote
               [[credentials
                 {:keys [volume-id
                         request-metric-collector
                         dry-run-request
                         auto-enable-io]}]]),
    :doc "Call modifyVolumeAttribute"}
   [credentials6262 & args6263]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6264
     (com.palletops.awaze.common/aws-client :ec2 credentials6262)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client6264
      modifyVolumeAttribute
      (modify-volume-attribute-request (clojure.core/nth args6263 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-placement-group
   [m6265]
   (clojure.core/let
    [credentials6266 (:credentials m6265) args6267 (:args m6265)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6268
      (com.palletops.awaze.common/aws-client :ec2 credentials6266)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6268
       createPlacementGroup
       (create-placement-group-request (clojure.core/nth args6267 0)))))))
  (clojure.core/defn
   create-placement-group-map
   {:arglists (quote
               [[credentials
                 {:keys [strategy
                         request-metric-collector
                         group-name
                         dry-run-request]}]]),
    :doc "Generate map for createPlacementGroup"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :create-placement-group,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   create-placement-group
   {:arglists (quote
               [[credentials
                 {:keys [strategy
                         request-metric-collector
                         group-name
                         dry-run-request]}]]),
    :doc "Call createPlacementGroup"}
   [credentials6270 & args6271]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6272
     (com.palletops.awaze.common/aws-client :ec2 credentials6270)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client6272
      createPlacementGroup
      (create-placement-group-request (clojure.core/nth args6271 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-vpn-connections
   [m6273]
   (clojure.core/let
    [credentials6274 (:credentials m6273) args6275 (:args m6273)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6276
      (com.palletops.awaze.common/aws-client :ec2 credentials6274)]
     (clojure.core/case
      (clojure.core/count args6275)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client6276
        describeVpnConnections))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client6276
        describeVpnConnections
        (describe-vpn-connections-request
         (clojure.core/nth args6275 0))))))))
  (clojure.core/defn
   describe-vpn-connections-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [vpn-connection-ids
                         request-metric-collector
                         filters
                         dry-run-request]}]]),
    :doc "Generate map for describeVpnConnections, describeVpnConnections"}
   ([credentials__1609__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-vpn-connections,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-vpn-connections,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-vpn-connections
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [vpn-connection-ids
                         request-metric-collector
                         filters
                         dry-run-request]}]]),
    :doc "Call describeVpnConnections, describeVpnConnections"}
   [credentials6278 & args6279]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6280
     (com.palletops.awaze.common/aws-client :ec2 credentials6278)]
    (clojure.core/case
     (clojure.core/count args6279)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6280
       describeVpnConnections))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6280
       describeVpnConnections
       (describe-vpn-connections-request
        (clojure.core/nth args6279 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-spot-price-history
   [m6281]
   (clojure.core/let
    [credentials6282 (:credentials m6281) args6283 (:args m6281)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6284
      (com.palletops.awaze.common/aws-client :ec2 credentials6282)]
     (clojure.core/case
      (clojure.core/count args6283)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client6284
        describeSpotPriceHistory
        (describe-spot-price-history-request
         (clojure.core/nth args6283 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client6284
        describeSpotPriceHistory))))))
  (clojure.core/defn
   describe-spot-price-history-map
   {:arglists (quote
               [[credentials
                 {:keys [end-time
                         instance-types
                         dry-run-request
                         request-metric-collector
                         product-descriptions
                         filters
                         availability-zone
                         max-results
                         start-time
                         next-token]}]
                [credentials]]),
    :doc "Generate map for describeSpotPriceHistory, describeSpotPriceHistory"}
   ([credentials__1609__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-spot-price-history,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-spot-price-history,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-spot-price-history
   {:arglists (quote
               [[credentials
                 {:keys [end-time
                         instance-types
                         dry-run-request
                         request-metric-collector
                         product-descriptions
                         filters
                         availability-zone
                         max-results
                         start-time
                         next-token]}]
                [credentials]]),
    :doc "Call describeSpotPriceHistory, describeSpotPriceHistory"}
   [credentials6286 & args6287]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6288
     (com.palletops.awaze.common/aws-client :ec2 credentials6286)]
    (clojure.core/case
     (clojure.core/count args6287)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6288
       describeSpotPriceHistory
       (describe-spot-price-history-request
        (clojure.core/nth args6287 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6288
       describeSpotPriceHistory))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-vpc
   [m6289]
   (clojure.core/let
    [credentials6290 (:credentials m6289) args6291 (:args m6289)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6292
      (com.palletops.awaze.common/aws-client :ec2 credentials6290)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6292
       deleteVpc
       (delete-vpc-request (clojure.core/nth args6291 0)))))))
  (clojure.core/defn
   delete-vpc-map
   {:arglists (quote
               [[credentials
                 {:keys [vpc-id
                         request-metric-collector
                         dry-run-request]}]]),
    :doc "Generate map for deleteVpc"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :delete-vpc,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   delete-vpc
   {:arglists (quote
               [[credentials
                 {:keys [vpc-id
                         request-metric-collector
                         dry-run-request]}]]),
    :doc "Call deleteVpc"}
   [credentials6294 & args6295]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6296
     (com.palletops.awaze.common/aws-client :ec2 credentials6294)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client6296
      deleteVpc
      (delete-vpc-request (clojure.core/nth args6295 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-route-table
   [m6297]
   (clojure.core/let
    [credentials6298 (:credentials m6297) args6299 (:args m6297)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6300
      (com.palletops.awaze.common/aws-client :ec2 credentials6298)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6300
       createRouteTable
       (create-route-table-request (clojure.core/nth args6299 0)))))))
  (clojure.core/defn
   create-route-table-map
   {:arglists (quote
               [[credentials
                 {:keys [vpc-id
                         request-metric-collector
                         dry-run-request]}]]),
    :doc "Generate map for createRouteTable"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :create-route-table,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   create-route-table
   {:arglists (quote
               [[credentials
                 {:keys [vpc-id
                         request-metric-collector
                         dry-run-request]}]]),
    :doc "Call createRouteTable"}
   [credentials6302 & args6303]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6304
     (com.palletops.awaze.common/aws-client :ec2 credentials6302)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client6304
      createRouteTable
      (create-route-table-request (clojure.core/nth args6303 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :terminate-instances
   [m6305]
   (clojure.core/let
    [credentials6306 (:credentials m6305) args6307 (:args m6305)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6308
      (com.palletops.awaze.common/aws-client :ec2 credentials6306)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6308
       terminateInstances
       (terminate-instances-request (clojure.core/nth args6307 0)))))))
  (clojure.core/defn
   terminate-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         instance-ids
                         dry-run-request]}]]),
    :doc "Generate map for terminateInstances"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :terminate-instances,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   terminate-instances
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         instance-ids
                         dry-run-request]}]]),
    :doc "Call terminateInstances"}
   [credentials6310 & args6311]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6312
     (com.palletops.awaze.common/aws-client :ec2 credentials6310)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client6312
      terminateInstances
      (terminate-instances-request (clojure.core/nth args6311 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-bundle-tasks
   [m6313]
   (clojure.core/let
    [credentials6314 (:credentials m6313) args6315 (:args m6313)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6316
      (com.palletops.awaze.common/aws-client :ec2 credentials6314)]
     (clojure.core/case
      (clojure.core/count args6315)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client6316
        describeBundleTasks))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client6316
        describeBundleTasks
        (describe-bundle-tasks-request (clojure.core/nth args6315 0))))))))
  (clojure.core/defn
   describe-bundle-tasks-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [request-metric-collector
                         filters
                         dry-run-request
                         bundle-ids]}]]),
    :doc "Generate map for describeBundleTasks, describeBundleTasks"}
   ([credentials__1609__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-bundle-tasks,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-bundle-tasks,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-bundle-tasks
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [request-metric-collector
                         filters
                         dry-run-request
                         bundle-ids]}]]),
    :doc "Call describeBundleTasks, describeBundleTasks"}
   [credentials6318 & args6319]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6320
     (com.palletops.awaze.common/aws-client :ec2 credentials6318)]
    (clojure.core/case
     (clojure.core/count args6319)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6320
       describeBundleTasks))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6320
       describeBundleTasks
       (describe-bundle-tasks-request (clojure.core/nth args6319 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :associate-address
   [m6321]
   (clojure.core/let
    [credentials6322 (:credentials m6321) args6323 (:args m6321)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6324
      (com.palletops.awaze.common/aws-client :ec2 credentials6322)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6324
       associateAddress
       (associate-address-request (clojure.core/nth args6323 0)))))))
  (clojure.core/defn
   associate-address-map
   {:arglists (quote
               [[credentials
                 {:keys [dry-run-request
                         request-metric-collector
                         allocation-id
                         public-ip
                         private-ip-address
                         allow-reassociation
                         network-interface-id
                         instance-id]}]]),
    :doc "Generate map for associateAddress"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :associate-address,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   associate-address
   {:arglists (quote
               [[credentials
                 {:keys [dry-run-request
                         request-metric-collector
                         allocation-id
                         public-ip
                         private-ip-address
                         allow-reassociation
                         network-interface-id
                         instance-id]}]]),
    :doc "Call associateAddress"}
   [credentials6326 & args6327]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6328
     (com.palletops.awaze.common/aws-client :ec2 credentials6326)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client6328
      associateAddress
      (associate-address-request (clojure.core/nth args6327 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-volume
   [m6329]
   (clojure.core/let
    [credentials6330 (:credentials m6329) args6331 (:args m6329)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6332
      (com.palletops.awaze.common/aws-client :ec2 credentials6330)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6332
       createVolume
       (create-volume-request (clojure.core/nth args6331 0)))))))
  (clojure.core/defn
   create-volume-map
   {:arglists (quote
               [[credentials
                 {:keys [availability-zone
                         volume-type
                         size
                         dry-run-request
                         request-metric-collector
                         iops
                         snapshot-id]}]]),
    :doc "Generate map for createVolume"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :create-volume,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   create-volume
   {:arglists (quote
               [[credentials
                 {:keys [availability-zone
                         volume-type
                         size
                         dry-run-request
                         request-metric-collector
                         iops
                         snapshot-id]}]]),
    :doc "Call createVolume"}
   [credentials6334 & args6335]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6336
     (com.palletops.awaze.common/aws-client :ec2 credentials6334)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client6336
      createVolume
      (create-volume-request (clojure.core/nth args6335 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :modify-reserved-instances
   [m6337]
   (clojure.core/let
    [credentials6338 (:credentials m6337) args6339 (:args m6337)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6340
      (com.palletops.awaze.common/aws-client :ec2 credentials6338)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6340
       modifyReservedInstances
       (modify-reserved-instances-request
        (clojure.core/nth args6339 0)))))))
  (clojure.core/defn
   modify-reserved-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [target-configurations
                         reserved-instances-ids
                         request-metric-collector
                         client-token]}]]),
    :doc "Generate map for modifyReservedInstances"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :modify-reserved-instances,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   modify-reserved-instances
   {:arglists (quote
               [[credentials
                 {:keys [target-configurations
                         reserved-instances-ids
                         request-metric-collector
                         client-token]}]]),
    :doc "Call modifyReservedInstances"}
   [credentials6342 & args6343]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6344
     (com.palletops.awaze.common/aws-client :ec2 credentials6342)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client6344
      modifyReservedInstances
      (modify-reserved-instances-request
       (clojure.core/nth args6343 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-vpc-attribute
   [m6345]
   (clojure.core/let
    [credentials6346 (:credentials m6345) args6347 (:args m6345)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6348
      (com.palletops.awaze.common/aws-client :ec2 credentials6346)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6348
       describeVpcAttribute
       (describe-vpc-attribute-request (clojure.core/nth args6347 0)))))))
  (clojure.core/defn
   describe-vpc-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [vpc-id
                         request-metric-collector
                         dry-run-request
                         attribute]}]]),
    :doc "Generate map for describeVpcAttribute"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-vpc-attribute,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-vpc-attribute
   {:arglists (quote
               [[credentials
                 {:keys [vpc-id
                         request-metric-collector
                         dry-run-request
                         attribute]}]]),
    :doc "Call describeVpcAttribute"}
   [credentials6350 & args6351]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6352
     (com.palletops.awaze.common/aws-client :ec2 credentials6350)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client6352
      describeVpcAttribute
      (describe-vpc-attribute-request (clojure.core/nth args6351 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :authorize-security-group-egress
   [m6353]
   (clojure.core/let
    [credentials6354 (:credentials m6353) args6355 (:args m6353)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6356
      (com.palletops.awaze.common/aws-client :ec2 credentials6354)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6356
       authorizeSecurityGroupEgress
       (authorize-security-group-egress-request
        (clojure.core/nth args6355 0)))))))
  (clojure.core/defn
   authorize-security-group-egress-map
   {:arglists (quote
               [[credentials
                 {:keys [dry-run-request
                         source-security-group-name
                         request-metric-collector
                         group-id
                         from-port
                         ip-permissions
                         to-port
                         cidr-ip
                         ip-protocol
                         source-security-group-owner-id]}]]),
    :doc "Generate map for authorizeSecurityGroupEgress"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :authorize-security-group-egress,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   authorize-security-group-egress
   {:arglists (quote
               [[credentials
                 {:keys [dry-run-request
                         source-security-group-name
                         request-metric-collector
                         group-id
                         from-port
                         ip-permissions
                         to-port
                         cidr-ip
                         ip-protocol
                         source-security-group-owner-id]}]]),
    :doc "Call authorizeSecurityGroupEgress"}
   [credentials6358 & args6359]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6360
     (com.palletops.awaze.common/aws-client :ec2 credentials6358)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client6360
      authorizeSecurityGroupEgress
      (authorize-security-group-egress-request
       (clojure.core/nth args6359 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-customer-gateway
   [m6361]
   (clojure.core/let
    [credentials6362 (:credentials m6361) args6363 (:args m6361)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6364
      (com.palletops.awaze.common/aws-client :ec2 credentials6362)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6364
       deleteCustomerGateway
       (delete-customer-gateway-request (clojure.core/nth args6363 0)))))))
  (clojure.core/defn
   delete-customer-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         dry-run-request
                         customer-gateway-id]}]]),
    :doc "Generate map for deleteCustomerGateway"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :delete-customer-gateway,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   delete-customer-gateway
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         dry-run-request
                         customer-gateway-id]}]]),
    :doc "Call deleteCustomerGateway"}
   [credentials6366 & args6367]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6368
     (com.palletops.awaze.common/aws-client :ec2 credentials6366)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client6368
      deleteCustomerGateway
      (delete-customer-gateway-request (clojure.core/nth args6367 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :replace-network-acl-entry
   [m6369]
   (clojure.core/let
    [credentials6370 (:credentials m6369) args6371 (:args m6369)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6372
      (com.palletops.awaze.common/aws-client :ec2 credentials6370)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6372
       replaceNetworkAclEntry
       (replace-network-acl-entry-request
        (clojure.core/nth args6371 0)))))))
  (clojure.core/defn
   replace-network-acl-entry-map
   {:arglists (quote
               [[credentials
                 {:keys [protocol
                         dry-run-request
                         request-metric-collector
                         icmp-type-code
                         network-acl-id
                         rule-number
                         cidr-block
                         egress
                         port-range
                         rule-action]}]]),
    :doc "Generate map for replaceNetworkAclEntry"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :replace-network-acl-entry,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   replace-network-acl-entry
   {:arglists (quote
               [[credentials
                 {:keys [protocol
                         dry-run-request
                         request-metric-collector
                         icmp-type-code
                         network-acl-id
                         rule-number
                         cidr-block
                         egress
                         port-range
                         rule-action]}]]),
    :doc "Call replaceNetworkAclEntry"}
   [credentials6374 & args6375]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6376
     (com.palletops.awaze.common/aws-client :ec2 credentials6374)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client6376
      replaceNetworkAclEntry
      (replace-network-acl-entry-request
       (clojure.core/nth args6375 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-subnets
   [m6377]
   (clojure.core/let
    [credentials6378 (:credentials m6377) args6379 (:args m6377)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6380
      (com.palletops.awaze.common/aws-client :ec2 credentials6378)]
     (clojure.core/case
      (clojure.core/count args6379)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client6380
        describeSubnets
        (describe-subnets-request (clojure.core/nth args6379 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client6380
        describeSubnets))))))
  (clojure.core/defn
   describe-subnets-map
   {:arglists (quote
               [[credentials
                 {:keys [subnet-ids
                         request-metric-collector
                         filters
                         dry-run-request]}]
                [credentials]]),
    :doc "Generate map for describeSubnets, describeSubnets"}
   ([credentials__1609__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-subnets,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-subnets,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-subnets
   {:arglists (quote
               [[credentials
                 {:keys [subnet-ids
                         request-metric-collector
                         filters
                         dry-run-request]}]
                [credentials]]),
    :doc "Call describeSubnets, describeSubnets"}
   [credentials6382 & args6383]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6384
     (com.palletops.awaze.common/aws-client :ec2 credentials6382)]
    (clojure.core/case
     (clojure.core/count args6383)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6384
       describeSubnets
       (describe-subnets-request (clojure.core/nth args6383 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6384
       describeSubnets))))))
 (do
  (clojure.core/defmethod
   ec2
   :get-console-output
   [m6385]
   (clojure.core/let
    [credentials6386 (:credentials m6385) args6387 (:args m6385)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6388
      (com.palletops.awaze.common/aws-client :ec2 credentials6386)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6388
       getConsoleOutput
       (get-console-output-request (clojure.core/nth args6387 0)))))))
  (clojure.core/defn
   get-console-output-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         instance-id
                         dry-run-request]}]]),
    :doc "Generate map for getConsoleOutput"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :get-console-output,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   get-console-output
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         instance-id
                         dry-run-request]}]]),
    :doc "Call getConsoleOutput"}
   [credentials6390 & args6391]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6392
     (com.palletops.awaze.common/aws-client :ec2 credentials6390)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client6392
      getConsoleOutput
      (get-console-output-request (clojure.core/nth args6391 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :cancel-conversion-task
   [m6393]
   (clojure.core/let
    [credentials6394 (:credentials m6393) args6395 (:args m6393)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6396
      (com.palletops.awaze.common/aws-client :ec2 credentials6394)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6396
       cancelConversionTask
       (cancel-conversion-task-request (clojure.core/nth args6395 0)))))))
  (clojure.core/defn
   cancel-conversion-task-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         reason-message
                         dry-run-request
                         conversion-task-id]}]]),
    :doc "Generate map for cancelConversionTask"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :cancel-conversion-task,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   cancel-conversion-task
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         reason-message
                         dry-run-request
                         conversion-task-id]}]]),
    :doc "Call cancelConversionTask"}
   [credentials6398 & args6399]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6400
     (com.palletops.awaze.common/aws-client :ec2 credentials6398)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client6400
      cancelConversionTask
      (cancel-conversion-task-request (clojure.core/nth args6399 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :attach-vpn-gateway
   [m6401]
   (clojure.core/let
    [credentials6402 (:credentials m6401) args6403 (:args m6401)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6404
      (com.palletops.awaze.common/aws-client :ec2 credentials6402)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6404
       attachVpnGateway
       (attach-vpn-gateway-request (clojure.core/nth args6403 0)))))))
  (clojure.core/defn
   attach-vpn-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [vpn-gateway-id
                         vpc-id
                         request-metric-collector
                         dry-run-request]}]]),
    :doc "Generate map for attachVpnGateway"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :attach-vpn-gateway,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   attach-vpn-gateway
   {:arglists (quote
               [[credentials
                 {:keys [vpn-gateway-id
                         vpc-id
                         request-metric-collector
                         dry-run-request]}]]),
    :doc "Call attachVpnGateway"}
   [credentials6406 & args6407]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6408
     (com.palletops.awaze.common/aws-client :ec2 credentials6406)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client6408
      attachVpnGateway
      (attach-vpn-gateway-request (clojure.core/nth args6407 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-vpn-connection-route
   [m6409]
   (clojure.core/let
    [credentials6410 (:credentials m6409) args6411 (:args m6409)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6412
      (com.palletops.awaze.common/aws-client :ec2 credentials6410)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6412
       deleteVpnConnectionRoute
       (delete-vpn-connection-route-request
        (clojure.core/nth args6411 0)))))))
  (clojure.core/defn
   delete-vpn-connection-route-map
   {:arglists (quote
               [[credentials
                 {:keys [vpn-connection-id
                         request-metric-collector
                         destination-cidr-block]}]]),
    :doc "Generate map for deleteVpnConnectionRoute"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :delete-vpn-connection-route,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   delete-vpn-connection-route
   {:arglists (quote
               [[credentials
                 {:keys [vpn-connection-id
                         request-metric-collector
                         destination-cidr-block]}]]),
    :doc "Call deleteVpnConnectionRoute"}
   [credentials6414 & args6415]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6416
     (com.palletops.awaze.common/aws-client :ec2 credentials6414)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client6416
      deleteVpnConnectionRoute
      (delete-vpn-connection-route-request
       (clojure.core/nth args6415 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :run-instances
   [m6417]
   (clojure.core/let
    [credentials6418 (:credentials m6417) args6419 (:args m6417)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6420
      (com.palletops.awaze.common/aws-client :ec2 credentials6418)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6420
       runInstances
       (run-instances-request (clojure.core/nth args6419 0)))))))
  (clojure.core/defn
   run-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [instance-type
                         license
                         kernel-id
                         dry-run-request
                         request-metric-collector
                         additional-info
                         ebs-optimized
                         subnet-id
                         max-count
                         block-device-mappings
                         network-interfaces
                         placement
                         private-ip-address
                         disable-api-termination
                         user-data
                         security-groups
                         ramdisk-id
                         iam-instance-profile
                         min-count
                         security-group-ids
                         key-name
                         client-token
                         image-id
                         monitoring
                         instance-initiated-shutdown-behavior]}]]),
    :doc "Generate map for runInstances"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :run-instances,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   run-instances
   {:arglists (quote
               [[credentials
                 {:keys [instance-type
                         license
                         kernel-id
                         dry-run-request
                         request-metric-collector
                         additional-info
                         ebs-optimized
                         subnet-id
                         max-count
                         block-device-mappings
                         network-interfaces
                         placement
                         private-ip-address
                         disable-api-termination
                         user-data
                         security-groups
                         ramdisk-id
                         iam-instance-profile
                         min-count
                         security-group-ids
                         key-name
                         client-token
                         image-id
                         monitoring
                         instance-initiated-shutdown-behavior]}]]),
    :doc "Call runInstances"}
   [credentials6422 & args6423]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6424
     (com.palletops.awaze.common/aws-client :ec2 credentials6422)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client6424
      runInstances
      (run-instances-request (clojure.core/nth args6423 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :register-image
   [m6425]
   (clojure.core/let
    [credentials6426 (:credentials m6425) args6427 (:args m6425)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6428
      (com.palletops.awaze.common/aws-client :ec2 credentials6426)]
     (clojure.core/case
      (clojure.core/count args6427)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client6428
        registerImage
        (register-image-request (clojure.core/nth args6427 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client6428
        registerImage))))))
  (clojure.core/defn
   register-image-map
   {:arglists (quote
               [[credentials
                 {:keys [kernel-id
                         dry-run-request
                         request-metric-collector
                         name
                         root-device-name
                         block-device-mappings
                         image-location
                         ramdisk-id
                         architecture
                         description]}]
                [credentials]]),
    :doc "Generate map for registerImage, registerImage"}
   ([credentials__1609__auto__]
    {:args [],
     :client :ec2,
     :fn :register-image,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :register-image,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   register-image
   {:arglists (quote
               [[credentials
                 {:keys [kernel-id
                         dry-run-request
                         request-metric-collector
                         name
                         root-device-name
                         block-device-mappings
                         image-location
                         ramdisk-id
                         architecture
                         description]}]
                [credentials]]),
    :doc "Call registerImage, registerImage"}
   [credentials6430 & args6431]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6432
     (com.palletops.awaze.common/aws-client :ec2 credentials6430)]
    (clojure.core/case
     (clojure.core/count args6431)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6432
       registerImage
       (register-image-request (clojure.core/nth args6431 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6432
       registerImage))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-tags
   [m6433]
   (clojure.core/let
    [credentials6434 (:credentials m6433) args6435 (:args m6433)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6436
      (com.palletops.awaze.common/aws-client :ec2 credentials6434)]
     (clojure.core/case
      (clojure.core/count args6435)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client6436
        describeTags))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client6436
        describeTags
        (describe-tags-request (clojure.core/nth args6435 0))))))))
  (clojure.core/defn
   describe-tags-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [request-metric-collector
                         filters
                         dry-run-request]}]]),
    :doc "Generate map for describeTags, describeTags"}
   ([credentials__1609__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-tags,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-tags,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-tags
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [request-metric-collector
                         filters
                         dry-run-request]}]]),
    :doc "Call describeTags, describeTags"}
   [credentials6438 & args6439]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6440
     (com.palletops.awaze.common/aws-client :ec2 credentials6438)]
    (clojure.core/case
     (clojure.core/count args6439)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6440
       describeTags))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6440
       describeTags
       (describe-tags-request (clojure.core/nth args6439 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-reserved-instances
   [m6441]
   (clojure.core/let
    [credentials6442 (:credentials m6441) args6443 (:args m6441)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6444
      (com.palletops.awaze.common/aws-client :ec2 credentials6442)]
     (clojure.core/case
      (clojure.core/count args6443)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client6444
        describeReservedInstances))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client6444
        describeReservedInstances
        (describe-reserved-instances-request
         (clojure.core/nth args6443 0))))))))
  (clojure.core/defn
   describe-reserved-instances-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [reserved-instances-ids
                         request-metric-collector
                         offering-type
                         filters
                         dry-run-request]}]]),
    :doc "Generate map for describeReservedInstances, describeReservedInstances"}
   ([credentials__1609__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-reserved-instances,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-reserved-instances,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-reserved-instances
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [reserved-instances-ids
                         request-metric-collector
                         offering-type
                         filters
                         dry-run-request]}]]),
    :doc "Call describeReservedInstances, describeReservedInstances"}
   [credentials6446 & args6447]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6448
     (com.palletops.awaze.common/aws-client :ec2 credentials6446)]
    (clojure.core/case
     (clojure.core/count args6447)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6448
       describeReservedInstances))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6448
       describeReservedInstances
       (describe-reserved-instances-request
        (clojure.core/nth args6447 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :detach-vpn-gateway
   [m6449]
   (clojure.core/let
    [credentials6450 (:credentials m6449) args6451 (:args m6449)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6452
      (com.palletops.awaze.common/aws-client :ec2 credentials6450)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6452
       detachVpnGateway
       (detach-vpn-gateway-request (clojure.core/nth args6451 0)))))))
  (clojure.core/defn
   detach-vpn-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [vpn-gateway-id
                         vpc-id
                         request-metric-collector
                         dry-run-request]}]]),
    :doc "Generate map for detachVpnGateway"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :detach-vpn-gateway,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   detach-vpn-gateway
   {:arglists (quote
               [[credentials
                 {:keys [vpn-gateway-id
                         vpc-id
                         request-metric-collector
                         dry-run-request]}]]),
    :doc "Call detachVpnGateway"}
   [credentials6454 & args6455]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6456
     (com.palletops.awaze.common/aws-client :ec2 credentials6454)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client6456
      detachVpnGateway
      (detach-vpn-gateway-request (clojure.core/nth args6455 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-customer-gateways
   [m6457]
   (clojure.core/let
    [credentials6458 (:credentials m6457) args6459 (:args m6457)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6460
      (com.palletops.awaze.common/aws-client :ec2 credentials6458)]
     (clojure.core/case
      (clojure.core/count args6459)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client6460
        describeCustomerGateways
        (describe-customer-gateways-request
         (clojure.core/nth args6459 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client6460
        describeCustomerGateways))))))
  (clojure.core/defn
   describe-customer-gateways-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         filters
                         dry-run-request
                         customer-gateway-ids]}]
                [credentials]]),
    :doc "Generate map for describeCustomerGateways, describeCustomerGateways"}
   ([credentials__1609__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-customer-gateways,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-customer-gateways,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-customer-gateways
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         filters
                         dry-run-request
                         customer-gateway-ids]}]
                [credentials]]),
    :doc "Call describeCustomerGateways, describeCustomerGateways"}
   [credentials6462 & args6463]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6464
     (com.palletops.awaze.common/aws-client :ec2 credentials6462)]
    (clojure.core/case
     (clojure.core/count args6463)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6464
       describeCustomerGateways
       (describe-customer-gateways-request
        (clojure.core/nth args6463 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6464
       describeCustomerGateways))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-network-interface-attribute
   [m6465]
   (clojure.core/let
    [credentials6466 (:credentials m6465) args6467 (:args m6465)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6468
      (com.palletops.awaze.common/aws-client :ec2 credentials6466)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6468
       describeNetworkInterfaceAttribute
       (describe-network-interface-attribute-request
        (clojure.core/nth args6467 0)))))))
  (clojure.core/defn
   describe-network-interface-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         network-interface-id
                         attachment
                         groups
                         dry-run-request
                         request-metric-collector
                         source-dest-check]}]]),
    :doc "Generate map for describeNetworkInterfaceAttribute"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-network-interface-attribute,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-network-interface-attribute
   {:arglists (quote
               [[credentials
                 {:keys [description
                         network-interface-id
                         attachment
                         groups
                         dry-run-request
                         request-metric-collector
                         source-dest-check]}]]),
    :doc "Call describeNetworkInterfaceAttribute"}
   [credentials6470 & args6471]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6472
     (com.palletops.awaze.common/aws-client :ec2 credentials6470)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client6472
      describeNetworkInterfaceAttribute
      (describe-network-interface-attribute-request
       (clojure.core/nth args6471 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :activate-license
   [m6473]
   (clojure.core/let
    [credentials6474 (:credentials m6473) args6475 (:args m6473)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6476
      (com.palletops.awaze.common/aws-client :ec2 credentials6474)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6476
       activateLicense
       (activate-license-request (clojure.core/nth args6475 0)))))))
  (clojure.core/defn
   activate-license-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         license-id
                         dry-run-request
                         capacity]}]]),
    :doc "Generate map for activateLicense"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :activate-license,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   activate-license
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         license-id
                         dry-run-request
                         capacity]}]]),
    :doc "Call activateLicense"}
   [credentials6478 & args6479]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6480
     (com.palletops.awaze.common/aws-client :ec2 credentials6478)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client6480
      activateLicense
      (activate-license-request (clojure.core/nth args6479 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :import-key-pair
   [m6481]
   (clojure.core/let
    [credentials6482 (:credentials m6481) args6483 (:args m6481)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6484
      (com.palletops.awaze.common/aws-client :ec2 credentials6482)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6484
       importKeyPair
       (import-key-pair-request (clojure.core/nth args6483 0)))))))
  (clojure.core/defn
   import-key-pair-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         public-key-material
                         key-name
                         dry-run-request]}]]),
    :doc "Generate map for importKeyPair"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :import-key-pair,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   import-key-pair
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         public-key-material
                         key-name
                         dry-run-request]}]]),
    :doc "Call importKeyPair"}
   [credentials6486 & args6487]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6488
     (com.palletops.awaze.common/aws-client :ec2 credentials6486)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client6488
      importKeyPair
      (import-key-pair-request (clojure.core/nth args6487 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :import-instance
   [m6489]
   (clojure.core/let
    [credentials6490 (:credentials m6489) args6491 (:args m6489)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6492
      (com.palletops.awaze.common/aws-client :ec2 credentials6490)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6492
       importInstance
       (import-instance-request (clojure.core/nth args6491 0)))))))
  (clojure.core/defn
   import-instance-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         platform
                         launch-specification
                         dry-run-request
                         disk-images
                         description]}]]),
    :doc "Generate map for importInstance"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :import-instance,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   import-instance
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         platform
                         launch-specification
                         dry-run-request
                         disk-images
                         description]}]]),
    :doc "Call importInstance"}
   [credentials6494 & args6495]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6496
     (com.palletops.awaze.common/aws-client :ec2 credentials6494)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client6496
      importInstance
      (import-instance-request (clojure.core/nth args6495 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :allocate-address
   [m6497]
   (clojure.core/let
    [credentials6498 (:credentials m6497) args6499 (:args m6497)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6500
      (com.palletops.awaze.common/aws-client :ec2 credentials6498)]
     (clojure.core/case
      (clojure.core/count args6499)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client6500
        allocateAddress))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client6500
        allocateAddress
        (allocate-address-request (clojure.core/nth args6499 0))))))))
  (clojure.core/defn
   allocate-address-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [request-metric-collector
                         dry-run-request
                         domain]}]]),
    :doc "Generate map for allocateAddress, allocateAddress"}
   ([credentials__1609__auto__]
    {:args [],
     :client :ec2,
     :fn :allocate-address,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :allocate-address,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   allocate-address
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [request-metric-collector
                         dry-run-request
                         domain]}]]),
    :doc "Call allocateAddress, allocateAddress"}
   [credentials6502 & args6503]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6504
     (com.palletops.awaze.common/aws-client :ec2 credentials6502)]
    (clojure.core/case
     (clojure.core/count args6503)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6504
       allocateAddress))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6504
       allocateAddress
       (allocate-address-request (clojure.core/nth args6503 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-spot-instance-requests
   [m6505]
   (clojure.core/let
    [credentials6506 (:credentials m6505) args6507 (:args m6505)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6508
      (com.palletops.awaze.common/aws-client :ec2 credentials6506)]
     (clojure.core/case
      (clojure.core/count args6507)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client6508
        describeSpotInstanceRequests
        (describe-spot-instance-requests-request
         (clojure.core/nth args6507 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client6508
        describeSpotInstanceRequests))))))
  (clojure.core/defn
   describe-spot-instance-requests-map
   {:arglists (quote
               [[credentials
                 {:keys [spot-instance-request-ids
                         request-metric-collector
                         filters
                         dry-run-request]}]
                [credentials]]),
    :doc "Generate map for describeSpotInstanceRequests, describeSpotInstanceRequests"}
   ([credentials__1609__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-spot-instance-requests,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-spot-instance-requests,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-spot-instance-requests
   {:arglists (quote
               [[credentials
                 {:keys [spot-instance-request-ids
                         request-metric-collector
                         filters
                         dry-run-request]}]
                [credentials]]),
    :doc "Call describeSpotInstanceRequests, describeSpotInstanceRequests"}
   [credentials6510 & args6511]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6512
     (com.palletops.awaze.common/aws-client :ec2 credentials6510)]
    (clojure.core/case
     (clojure.core/count args6511)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6512
       describeSpotInstanceRequests
       (describe-spot-instance-requests-request
        (clojure.core/nth args6511 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6512
       describeSpotInstanceRequests))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-spot-datafeed-subscription
   [m6513]
   (clojure.core/let
    [credentials6514 (:credentials m6513) args6515 (:args m6513)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6516
      (com.palletops.awaze.common/aws-client :ec2 credentials6514)]
     (clojure.core/case
      (clojure.core/count args6515)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client6516
        deleteSpotDatafeedSubscription))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client6516
        deleteSpotDatafeedSubscription
        (delete-spot-datafeed-subscription-request
         (clojure.core/nth args6515 0))))))))
  (clojure.core/defn
   delete-spot-datafeed-subscription-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [request-metric-collector dry-run-request]}]]),
    :doc "Generate map for deleteSpotDatafeedSubscription, deleteSpotDatafeedSubscription"}
   ([credentials__1609__auto__]
    {:args [],
     :client :ec2,
     :fn :delete-spot-datafeed-subscription,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :delete-spot-datafeed-subscription,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   delete-spot-datafeed-subscription
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [request-metric-collector dry-run-request]}]]),
    :doc "Call deleteSpotDatafeedSubscription, deleteSpotDatafeedSubscription"}
   [credentials6518 & args6519]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6520
     (com.palletops.awaze.common/aws-client :ec2 credentials6518)]
    (clojure.core/case
     (clojure.core/count args6519)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6520
       deleteSpotDatafeedSubscription))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6520
       deleteSpotDatafeedSubscription
       (delete-spot-datafeed-subscription-request
        (clojure.core/nth args6519 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-conversion-tasks
   [m6521]
   (clojure.core/let
    [credentials6522 (:credentials m6521) args6523 (:args m6521)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6524
      (com.palletops.awaze.common/aws-client :ec2 credentials6522)]
     (clojure.core/case
      (clojure.core/count args6523)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client6524
        describeConversionTasks
        (describe-conversion-tasks-request
         (clojure.core/nth args6523 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client6524
        describeConversionTasks))))))
  (clojure.core/defn
   describe-conversion-tasks-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         filters
                         dry-run-request
                         conversion-task-ids]}]
                [credentials]]),
    :doc "Generate map for describeConversionTasks, describeConversionTasks"}
   ([credentials__1609__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-conversion-tasks,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-conversion-tasks,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-conversion-tasks
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         filters
                         dry-run-request
                         conversion-task-ids]}]
                [credentials]]),
    :doc "Call describeConversionTasks, describeConversionTasks"}
   [credentials6526 & args6527]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6528
     (com.palletops.awaze.common/aws-client :ec2 credentials6526)]
    (clojure.core/case
     (clojure.core/count args6527)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6528
       describeConversionTasks
       (describe-conversion-tasks-request
        (clojure.core/nth args6527 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6528
       describeConversionTasks))))))
 (do
  (clojure.core/defmethod
   ec2
   :replace-route-table-association
   [m6529]
   (clojure.core/let
    [credentials6530 (:credentials m6529) args6531 (:args m6529)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6532
      (com.palletops.awaze.common/aws-client :ec2 credentials6530)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6532
       replaceRouteTableAssociation
       (replace-route-table-association-request
        (clojure.core/nth args6531 0)))))))
  (clojure.core/defn
   replace-route-table-association-map
   {:arglists (quote
               [[credentials
                 {:keys [route-table-id
                         request-metric-collector
                         dry-run-request
                         association-id]}]]),
    :doc "Generate map for replaceRouteTableAssociation"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :replace-route-table-association,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   replace-route-table-association
   {:arglists (quote
               [[credentials
                 {:keys [route-table-id
                         request-metric-collector
                         dry-run-request
                         association-id]}]]),
    :doc "Call replaceRouteTableAssociation"}
   [credentials6534 & args6535]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6536
     (com.palletops.awaze.common/aws-client :ec2 credentials6534)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client6536
      replaceRouteTableAssociation
      (replace-route-table-association-request
       (clojure.core/nth args6535 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-subnet
   [m6537]
   (clojure.core/let
    [credentials6538 (:credentials m6537) args6539 (:args m6537)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6540
      (com.palletops.awaze.common/aws-client :ec2 credentials6538)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6540
       deleteSubnet
       (delete-subnet-request (clojure.core/nth args6539 0)))))))
  (clojure.core/defn
   delete-subnet-map
   {:arglists (quote
               [[credentials
                 {:keys [subnet-id
                         request-metric-collector
                         dry-run-request]}]]),
    :doc "Generate map for deleteSubnet"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :delete-subnet,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   delete-subnet
   {:arglists (quote
               [[credentials
                 {:keys [subnet-id
                         request-metric-collector
                         dry-run-request]}]]),
    :doc "Call deleteSubnet"}
   [credentials6542 & args6543]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6544
     (com.palletops.awaze.common/aws-client :ec2 credentials6542)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client6544
      deleteSubnet
      (delete-subnet-request (clojure.core/nth args6543 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :modify-vpc-attribute
   [m6545]
   (clojure.core/let
    [credentials6546 (:credentials m6545) args6547 (:args m6545)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6548
      (com.palletops.awaze.common/aws-client :ec2 credentials6546)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6548
       modifyVpcAttribute
       (modify-vpc-attribute-request (clojure.core/nth args6547 0)))))))
  (clojure.core/defn
   modify-vpc-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [vpc-id
                         request-metric-collector
                         enable-dns-support
                         enable-dns-hostnames]}]]),
    :doc "Generate map for modifyVpcAttribute"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :modify-vpc-attribute,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   modify-vpc-attribute
   {:arglists (quote
               [[credentials
                 {:keys [vpc-id
                         request-metric-collector
                         enable-dns-support
                         enable-dns-hostnames]}]]),
    :doc "Call modifyVpcAttribute"}
   [credentials6550 & args6551]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6552
     (com.palletops.awaze.common/aws-client :ec2 credentials6550)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client6552
      modifyVpcAttribute
      (modify-vpc-attribute-request (clojure.core/nth args6551 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :detach-internet-gateway
   [m6553]
   (clojure.core/let
    [credentials6554 (:credentials m6553) args6555 (:args m6553)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6556
      (com.palletops.awaze.common/aws-client :ec2 credentials6554)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6556
       detachInternetGateway
       (detach-internet-gateway-request (clojure.core/nth args6555 0)))))))
  (clojure.core/defn
   detach-internet-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [vpc-id
                         request-metric-collector
                         internet-gateway-id
                         dry-run-request]}]]),
    :doc "Generate map for detachInternetGateway"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :detach-internet-gateway,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   detach-internet-gateway
   {:arglists (quote
               [[credentials
                 {:keys [vpc-id
                         request-metric-collector
                         internet-gateway-id
                         dry-run-request]}]]),
    :doc "Call detachInternetGateway"}
   [credentials6558 & args6559]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6560
     (com.palletops.awaze.common/aws-client :ec2 credentials6558)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client6560
      detachInternetGateway
      (detach-internet-gateway-request (clojure.core/nth args6559 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-reserved-instances-modifications
   [m6561]
   (clojure.core/let
    [credentials6562 (:credentials m6561) args6563 (:args m6561)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6564
      (com.palletops.awaze.common/aws-client :ec2 credentials6562)]
     (clojure.core/case
      (clojure.core/count args6563)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client6564
        describeReservedInstancesModifications
        (describe-reserved-instances-modifications-request
         (clojure.core/nth args6563 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client6564
        describeReservedInstancesModifications))))))
  (clojure.core/defn
   describe-reserved-instances-modifications-map
   {:arglists (quote
               [[credentials
                 {:keys [reserved-instances-modification-ids
                         request-metric-collector
                         next-token
                         filters]}]
                [credentials]]),
    :doc "Generate map for describeReservedInstancesModifications, describeReservedInstancesModifications"}
   ([credentials__1609__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-reserved-instances-modifications,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-reserved-instances-modifications,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-reserved-instances-modifications
   {:arglists (quote
               [[credentials
                 {:keys [reserved-instances-modification-ids
                         request-metric-collector
                         next-token
                         filters]}]
                [credentials]]),
    :doc "Call describeReservedInstancesModifications, describeReservedInstancesModifications"}
   [credentials6566 & args6567]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6568
     (com.palletops.awaze.common/aws-client :ec2 credentials6566)]
    (clojure.core/case
     (clojure.core/count args6567)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6568
       describeReservedInstancesModifications
       (describe-reserved-instances-modifications-request
        (clojure.core/nth args6567 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6568
       describeReservedInstancesModifications))))))
 (do
  (clojure.core/defmethod
   ec2
   :get-password-data
   [m6569]
   (clojure.core/let
    [credentials6570 (:credentials m6569) args6571 (:args m6569)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6572
      (com.palletops.awaze.common/aws-client :ec2 credentials6570)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6572
       getPasswordData
       (get-password-data-request (clojure.core/nth args6571 0)))))))
  (clojure.core/defn
   get-password-data-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         instance-id
                         dry-run-request]}]]),
    :doc "Generate map for getPasswordData"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :get-password-data,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   get-password-data
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         instance-id
                         dry-run-request]}]]),
    :doc "Call getPasswordData"}
   [credentials6574 & args6575]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6576
     (com.palletops.awaze.common/aws-client :ec2 credentials6574)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client6576
      getPasswordData
      (get-password-data-request (clojure.core/nth args6575 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :unassign-private-ip-addresses
   [m6577]
   (clojure.core/let
    [credentials6578 (:credentials m6577) args6579 (:args m6577)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6580
      (com.palletops.awaze.common/aws-client :ec2 credentials6578)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6580
       unassignPrivateIpAddresses
       (unassign-private-ip-addresses-request
        (clojure.core/nth args6579 0)))))))
  (clojure.core/defn
   unassign-private-ip-addresses-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         private-ip-addresses
                         network-interface-id]}]]),
    :doc "Generate map for unassignPrivateIpAddresses"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :unassign-private-ip-addresses,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   unassign-private-ip-addresses
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         private-ip-addresses
                         network-interface-id]}]]),
    :doc "Call unassignPrivateIpAddresses"}
   [credentials6582 & args6583]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6584
     (com.palletops.awaze.common/aws-client :ec2 credentials6582)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client6584
      unassignPrivateIpAddresses
      (unassign-private-ip-addresses-request
       (clojure.core/nth args6583 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :modify-network-interface-attribute
   [m6585]
   (clojure.core/let
    [credentials6586 (:credentials m6585) args6587 (:args m6585)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6588
      (com.palletops.awaze.common/aws-client :ec2 credentials6586)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6588
       modifyNetworkInterfaceAttribute
       (modify-network-interface-attribute-request
        (clojure.core/nth args6587 0)))))))
  (clojure.core/defn
   modify-network-interface-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         network-interface-id
                         attachment
                         groups
                         dry-run-request
                         request-metric-collector
                         source-dest-check]}]]),
    :doc "Generate map for modifyNetworkInterfaceAttribute"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :modify-network-interface-attribute,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   modify-network-interface-attribute
   {:arglists (quote
               [[credentials
                 {:keys [description
                         network-interface-id
                         attachment
                         groups
                         dry-run-request
                         request-metric-collector
                         source-dest-check]}]]),
    :doc "Call modifyNetworkInterfaceAttribute"}
   [credentials6590 & args6591]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6592
     (com.palletops.awaze.common/aws-client :ec2 credentials6590)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client6592
      modifyNetworkInterfaceAttribute
      (modify-network-interface-attribute-request
       (clojure.core/nth args6591 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :reset-network-interface-attribute
   [m6593]
   (clojure.core/let
    [credentials6594 (:credentials m6593) args6595 (:args m6593)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6596
      (com.palletops.awaze.common/aws-client :ec2 credentials6594)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6596
       resetNetworkInterfaceAttribute
       (reset-network-interface-attribute-request
        (clojure.core/nth args6595 0)))))))
  (clojure.core/defn
   reset-network-interface-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [source-dest-check
                         request-metric-collector
                         network-interface-id
                         dry-run-request]}]]),
    :doc "Generate map for resetNetworkInterfaceAttribute"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :reset-network-interface-attribute,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   reset-network-interface-attribute
   {:arglists (quote
               [[credentials
                 {:keys [source-dest-check
                         request-metric-collector
                         network-interface-id
                         dry-run-request]}]]),
    :doc "Call resetNetworkInterfaceAttribute"}
   [credentials6598 & args6599]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6600
     (com.palletops.awaze.common/aws-client :ec2 credentials6598)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client6600
      resetNetworkInterfaceAttribute
      (reset-network-interface-attribute-request
       (clojure.core/nth args6599 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-vpcs
   [m6601]
   (clojure.core/let
    [credentials6602 (:credentials m6601) args6603 (:args m6601)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6604
      (com.palletops.awaze.common/aws-client :ec2 credentials6602)]
     (clojure.core/case
      (clojure.core/count args6603)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client6604
        describeVpcs))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client6604
        describeVpcs
        (describe-vpcs-request (clojure.core/nth args6603 0))))))))
  (clojure.core/defn
   describe-vpcs-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [vpc-ids
                         request-metric-collector
                         filters
                         dry-run-request]}]]),
    :doc "Generate map for describeVpcs, describeVpcs"}
   ([credentials__1609__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-vpcs,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-vpcs,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-vpcs
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [vpc-ids
                         request-metric-collector
                         filters
                         dry-run-request]}]]),
    :doc "Call describeVpcs, describeVpcs"}
   [credentials6606 & args6607]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6608
     (com.palletops.awaze.common/aws-client :ec2 credentials6606)]
    (clojure.core/case
     (clojure.core/count args6607)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6608
       describeVpcs))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6608
       describeVpcs
       (describe-vpcs-request (clojure.core/nth args6607 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :reboot-instances
   [m6609]
   (clojure.core/let
    [credentials6610 (:credentials m6609) args6611 (:args m6609)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6612
      (com.palletops.awaze.common/aws-client :ec2 credentials6610)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6612
       rebootInstances
       (reboot-instances-request (clojure.core/nth args6611 0)))))))
  (clojure.core/defn
   reboot-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         instance-ids
                         dry-run-request]}]]),
    :doc "Generate map for rebootInstances"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :reboot-instances,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   reboot-instances
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         instance-ids
                         dry-run-request]}]]),
    :doc "Call rebootInstances"}
   [credentials6614 & args6615]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6616
     (com.palletops.awaze.common/aws-client :ec2 credentials6614)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client6616
      rebootInstances
      (reboot-instances-request (clojure.core/nth args6615 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-volume-attribute
   [m6617]
   (clojure.core/let
    [credentials6618 (:credentials m6617) args6619 (:args m6617)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6620
      (com.palletops.awaze.common/aws-client :ec2 credentials6618)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6620
       describeVolumeAttribute
       (describe-volume-attribute-request
        (clojure.core/nth args6619 0)))))))
  (clojure.core/defn
   describe-volume-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [volume-id
                         request-metric-collector
                         dry-run-request
                         attribute]}]]),
    :doc "Generate map for describeVolumeAttribute"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-volume-attribute,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-volume-attribute
   {:arglists (quote
               [[credentials
                 {:keys [volume-id
                         request-metric-collector
                         dry-run-request
                         attribute]}]]),
    :doc "Call describeVolumeAttribute"}
   [credentials6622 & args6623]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6624
     (com.palletops.awaze.common/aws-client :ec2 credentials6622)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client6624
      describeVolumeAttribute
      (describe-volume-attribute-request
       (clojure.core/nth args6623 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :modify-instance-attribute
   [m6625]
   (clojure.core/let
    [credentials6626 (:credentials m6625) args6627 (:args m6625)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6628
      (com.palletops.awaze.common/aws-client :ec2 credentials6626)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6628
       modifyInstanceAttribute
       (modify-instance-attribute-request
        (clojure.core/nth args6627 0)))))))
  (clojure.core/defn
   modify-instance-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [instance-type
                         dry-run-request
                         request-metric-collector
                         ebs-optimized
                         source-dest-check
                         block-device-mappings
                         kernel
                         disable-api-termination
                         user-data
                         groups
                         ramdisk
                         attribute
                         instance-id
                         instance-initiated-shutdown-behavior
                         value]}]]),
    :doc "Generate map for modifyInstanceAttribute"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :modify-instance-attribute,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   modify-instance-attribute
   {:arglists (quote
               [[credentials
                 {:keys [instance-type
                         dry-run-request
                         request-metric-collector
                         ebs-optimized
                         source-dest-check
                         block-device-mappings
                         kernel
                         disable-api-termination
                         user-data
                         groups
                         ramdisk
                         attribute
                         instance-id
                         instance-initiated-shutdown-behavior
                         value]}]]),
    :doc "Call modifyInstanceAttribute"}
   [credentials6630 & args6631]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6632
     (com.palletops.awaze.common/aws-client :ec2 credentials6630)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client6632
      modifyInstanceAttribute
      (modify-instance-attribute-request
       (clojure.core/nth args6631 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-key-pair
   [m6633]
   (clojure.core/let
    [credentials6634 (:credentials m6633) args6635 (:args m6633)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6636
      (com.palletops.awaze.common/aws-client :ec2 credentials6634)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6636
       deleteKeyPair
       (delete-key-pair-request (clojure.core/nth args6635 0)))))))
  (clojure.core/defn
   delete-key-pair-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         key-name
                         dry-run-request]}]]),
    :doc "Generate map for deleteKeyPair"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :delete-key-pair,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   delete-key-pair
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         key-name
                         dry-run-request]}]]),
    :doc "Call deleteKeyPair"}
   [credentials6638 & args6639]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6640
     (com.palletops.awaze.common/aws-client :ec2 credentials6638)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client6640
      deleteKeyPair
      (delete-key-pair-request (clojure.core/nth args6639 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :enable-vgw-route-propagation
   [m6641]
   (clojure.core/let
    [credentials6642 (:credentials m6641) args6643 (:args m6641)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6644
      (com.palletops.awaze.common/aws-client :ec2 credentials6642)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6644
       enableVgwRoutePropagation
       (enable-vgw-route-propagation-request
        (clojure.core/nth args6643 0)))))))
  (clojure.core/defn
   enable-vgw-route-propagation-map
   {:arglists (quote
               [[credentials
                 {:keys [route-table-id
                         request-metric-collector
                         gateway-id]}]]),
    :doc "Generate map for enableVgwRoutePropagation"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :enable-vgw-route-propagation,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   enable-vgw-route-propagation
   {:arglists (quote
               [[credentials
                 {:keys [route-table-id
                         request-metric-collector
                         gateway-id]}]]),
    :doc "Call enableVgwRoutePropagation"}
   [credentials6646 & args6647]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6648
     (com.palletops.awaze.common/aws-client :ec2 credentials6646)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client6648
      enableVgwRoutePropagation
      (enable-vgw-route-propagation-request
       (clojure.core/nth args6647 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :bundle-instance
   [m6649]
   (clojure.core/let
    [credentials6650 (:credentials m6649) args6651 (:args m6649)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6652
      (com.palletops.awaze.common/aws-client :ec2 credentials6650)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6652
       bundleInstance
       (bundle-instance-request (clojure.core/nth args6651 0)))))))
  (clojure.core/defn
   bundle-instance-map
   {:arglists (quote
               [[credentials
                 {:keys [storage
                         request-metric-collector
                         instance-id
                         dry-run-request]}]]),
    :doc "Generate map for bundleInstance"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :bundle-instance,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   bundle-instance
   {:arglists (quote
               [[credentials
                 {:keys [storage
                         request-metric-collector
                         instance-id
                         dry-run-request]}]]),
    :doc "Call bundleInstance"}
   [credentials6654 & args6655]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6656
     (com.palletops.awaze.common/aws-client :ec2 credentials6654)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client6656
      bundleInstance
      (bundle-instance-request (clojure.core/nth args6655 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-internet-gateway
   [m6657]
   (clojure.core/let
    [credentials6658 (:credentials m6657) args6659 (:args m6657)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6660
      (com.palletops.awaze.common/aws-client :ec2 credentials6658)]
     (clojure.core/case
      (clojure.core/count args6659)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client6660
        createInternetGateway))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client6660
        createInternetGateway
        (create-internet-gateway-request
         (clojure.core/nth args6659 0))))))))
  (clojure.core/defn
   create-internet-gateway-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [request-metric-collector dry-run-request]}]]),
    :doc "Generate map for createInternetGateway, createInternetGateway"}
   ([credentials__1609__auto__]
    {:args [],
     :client :ec2,
     :fn :create-internet-gateway,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :create-internet-gateway,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   create-internet-gateway
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [request-metric-collector dry-run-request]}]]),
    :doc "Call createInternetGateway, createInternetGateway"}
   [credentials6662 & args6663]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6664
     (com.palletops.awaze.common/aws-client :ec2 credentials6662)]
    (clojure.core/case
     (clojure.core/count args6663)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6664
       createInternetGateway))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6664
       createInternetGateway
       (create-internet-gateway-request (clojure.core/nth args6663 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-volume-status
   [m6665]
   (clojure.core/let
    [credentials6666 (:credentials m6665) args6667 (:args m6665)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6668
      (com.palletops.awaze.common/aws-client :ec2 credentials6666)]
     (clojure.core/case
      (clojure.core/count args6667)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client6668
        describeVolumeStatus
        (describe-volume-status-request (clojure.core/nth args6667 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client6668
        describeVolumeStatus))))))
  (clojure.core/defn
   describe-volume-status-map
   {:arglists (quote
               [[credentials
                 {:keys [volume-ids
                         request-metric-collector
                         next-token
                         max-results
                         filters
                         dry-run-request]}]
                [credentials]]),
    :doc "Generate map for describeVolumeStatus, describeVolumeStatus"}
   ([credentials__1609__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-volume-status,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-volume-status,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-volume-status
   {:arglists (quote
               [[credentials
                 {:keys [volume-ids
                         request-metric-collector
                         next-token
                         max-results
                         filters
                         dry-run-request]}]
                [credentials]]),
    :doc "Call describeVolumeStatus, describeVolumeStatus"}
   [credentials6670 & args6671]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6672
     (com.palletops.awaze.common/aws-client :ec2 credentials6670)]
    (clojure.core/case
     (clojure.core/count args6671)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6672
       describeVolumeStatus
       (describe-volume-status-request (clojure.core/nth args6671 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6672
       describeVolumeStatus))))))
 (do
  (clojure.core/defmethod
   ec2
   :copy-image
   [m6673]
   (clojure.core/let
    [credentials6674 (:credentials m6673) args6675 (:args m6673)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6676
      (com.palletops.awaze.common/aws-client :ec2 credentials6674)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6676
       copyImage
       (copy-image-request (clojure.core/nth args6675 0)))))))
  (clojure.core/defn
   copy-image-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         source-image-id
                         source-region
                         client-token
                         dry-run-request
                         name
                         request-metric-collector]}]]),
    :doc "Generate map for copyImage"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :copy-image,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   copy-image
   {:arglists (quote
               [[credentials
                 {:keys [description
                         source-image-id
                         source-region
                         client-token
                         dry-run-request
                         name
                         request-metric-collector]}]]),
    :doc "Call copyImage"}
   [credentials6678 & args6679]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6680
     (com.palletops.awaze.common/aws-client :ec2 credentials6678)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client6680
      copyImage
      (copy-image-request (clojure.core/nth args6679 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-key-pairs
   [m6681]
   (clojure.core/let
    [credentials6682 (:credentials m6681) args6683 (:args m6681)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6684
      (com.palletops.awaze.common/aws-client :ec2 credentials6682)]
     (clojure.core/case
      (clojure.core/count args6683)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client6684
        describeKeyPairs))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client6684
        describeKeyPairs
        (describe-key-pairs-request (clojure.core/nth args6683 0))))))))
  (clojure.core/defn
   describe-key-pairs-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [request-metric-collector
                         key-names
                         filters
                         dry-run-request]}]]),
    :doc "Generate map for describeKeyPairs, describeKeyPairs"}
   ([credentials__1609__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-key-pairs,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-key-pairs,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-key-pairs
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [request-metric-collector
                         key-names
                         filters
                         dry-run-request]}]]),
    :doc "Call describeKeyPairs, describeKeyPairs"}
   [credentials6686 & args6687]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6688
     (com.palletops.awaze.common/aws-client :ec2 credentials6686)]
    (clojure.core/case
     (clojure.core/count args6687)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6688
       describeKeyPairs))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6688
       describeKeyPairs
       (describe-key-pairs-request (clojure.core/nth args6687 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-network-acl-entry
   [m6689]
   (clojure.core/let
    [credentials6690 (:credentials m6689) args6691 (:args m6689)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6692
      (com.palletops.awaze.common/aws-client :ec2 credentials6690)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6692
       deleteNetworkAclEntry
       (delete-network-acl-entry-request
        (clojure.core/nth args6691 0)))))))
  (clojure.core/defn
   delete-network-acl-entry-map
   {:arglists (quote
               [[credentials
                 {:keys [rule-number
                         request-metric-collector
                         network-acl-id
                         egress
                         dry-run-request]}]]),
    :doc "Generate map for deleteNetworkAclEntry"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :delete-network-acl-entry,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   delete-network-acl-entry
   {:arglists (quote
               [[credentials
                 {:keys [rule-number
                         request-metric-collector
                         network-acl-id
                         egress
                         dry-run-request]}]]),
    :doc "Call deleteNetworkAclEntry"}
   [credentials6694 & args6695]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6696
     (com.palletops.awaze.common/aws-client :ec2 credentials6694)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client6696
      deleteNetworkAclEntry
      (delete-network-acl-entry-request (clojure.core/nth args6695 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :purchase-reserved-instances-offering
   [m6697]
   (clojure.core/let
    [credentials6698 (:credentials m6697) args6699 (:args m6697)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6700
      (com.palletops.awaze.common/aws-client :ec2 credentials6698)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6700
       purchaseReservedInstancesOffering
       (purchase-reserved-instances-offering-request
        (clojure.core/nth args6699 0)))))))
  (clojure.core/defn
   purchase-reserved-instances-offering-map
   {:arglists (quote
               [[credentials
                 {:keys [reserved-instances-offering-id
                         request-metric-collector
                         limit-price
                         instance-count
                         dry-run-request]}]]),
    :doc "Generate map for purchaseReservedInstancesOffering"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :purchase-reserved-instances-offering,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   purchase-reserved-instances-offering
   {:arglists (quote
               [[credentials
                 {:keys [reserved-instances-offering-id
                         request-metric-collector
                         limit-price
                         instance-count
                         dry-run-request]}]]),
    :doc "Call purchaseReservedInstancesOffering"}
   [credentials6702 & args6703]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6704
     (com.palletops.awaze.common/aws-client :ec2 credentials6702)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client6704
      purchaseReservedInstancesOffering
      (purchase-reserved-instances-offering-request
       (clojure.core/nth args6703 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :cancel-reserved-instances-listing
   [m6705]
   (clojure.core/let
    [credentials6706 (:credentials m6705) args6707 (:args m6705)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6708
      (com.palletops.awaze.common/aws-client :ec2 credentials6706)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6708
       cancelReservedInstancesListing
       (cancel-reserved-instances-listing-request
        (clojure.core/nth args6707 0)))))))
  (clojure.core/defn
   cancel-reserved-instances-listing-map
   {:arglists (quote
               [[credentials
                 {:keys [reserved-instances-listing-id
                         request-metric-collector]}]]),
    :doc "Generate map for cancelReservedInstancesListing"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :cancel-reserved-instances-listing,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   cancel-reserved-instances-listing
   {:arglists (quote
               [[credentials
                 {:keys [reserved-instances-listing-id
                         request-metric-collector]}]]),
    :doc "Call cancelReservedInstancesListing"}
   [credentials6710 & args6711]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6712
     (com.palletops.awaze.common/aws-client :ec2 credentials6710)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client6712
      cancelReservedInstancesListing
      (cancel-reserved-instances-listing-request
       (clojure.core/nth args6711 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :revoke-security-group-egress
   [m6713]
   (clojure.core/let
    [credentials6714 (:credentials m6713) args6715 (:args m6713)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6716
      (com.palletops.awaze.common/aws-client :ec2 credentials6714)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6716
       revokeSecurityGroupEgress
       (revoke-security-group-egress-request
        (clojure.core/nth args6715 0)))))))
  (clojure.core/defn
   revoke-security-group-egress-map
   {:arglists (quote
               [[credentials
                 {:keys [dry-run-request
                         source-security-group-name
                         request-metric-collector
                         group-id
                         from-port
                         ip-permissions
                         to-port
                         cidr-ip
                         ip-protocol
                         source-security-group-owner-id]}]]),
    :doc "Generate map for revokeSecurityGroupEgress"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :revoke-security-group-egress,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   revoke-security-group-egress
   {:arglists (quote
               [[credentials
                 {:keys [dry-run-request
                         source-security-group-name
                         request-metric-collector
                         group-id
                         from-port
                         ip-permissions
                         to-port
                         cidr-ip
                         ip-protocol
                         source-security-group-owner-id]}]]),
    :doc "Call revokeSecurityGroupEgress"}
   [credentials6718 & args6719]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6720
     (com.palletops.awaze.common/aws-client :ec2 credentials6718)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client6720
      revokeSecurityGroupEgress
      (revoke-security-group-egress-request
       (clojure.core/nth args6719 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :deactivate-license
   [m6721]
   (clojure.core/let
    [credentials6722 (:credentials m6721) args6723 (:args m6721)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6724
      (com.palletops.awaze.common/aws-client :ec2 credentials6722)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6724
       deactivateLicense
       (deactivate-license-request (clojure.core/nth args6723 0)))))))
  (clojure.core/defn
   deactivate-license-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         license-id
                         dry-run-request
                         capacity]}]]),
    :doc "Generate map for deactivateLicense"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :deactivate-license,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   deactivate-license
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         license-id
                         dry-run-request
                         capacity]}]]),
    :doc "Call deactivateLicense"}
   [credentials6726 & args6727]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6728
     (com.palletops.awaze.common/aws-client :ec2 credentials6726)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client6728
      deactivateLicense
      (deactivate-license-request (clojure.core/nth args6727 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-spot-datafeed-subscription
   [m6729]
   (clojure.core/let
    [credentials6730 (:credentials m6729) args6731 (:args m6729)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6732
      (com.palletops.awaze.common/aws-client :ec2 credentials6730)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6732
       createSpotDatafeedSubscription
       (create-spot-datafeed-subscription-request
        (clojure.core/nth args6731 0)))))))
  (clojure.core/defn
   create-spot-datafeed-subscription-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         prefix
                         dry-run-request
                         bucket]}]]),
    :doc "Generate map for createSpotDatafeedSubscription"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :create-spot-datafeed-subscription,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   create-spot-datafeed-subscription
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         prefix
                         dry-run-request
                         bucket]}]]),
    :doc "Call createSpotDatafeedSubscription"}
   [credentials6734 & args6735]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6736
     (com.palletops.awaze.common/aws-client :ec2 credentials6734)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client6736
      createSpotDatafeedSubscription
      (create-spot-datafeed-subscription-request
       (clojure.core/nth args6735 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :enable-volume-io
   [m6737]
   (clojure.core/let
    [credentials6738 (:credentials m6737) args6739 (:args m6737)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6740
      (com.palletops.awaze.common/aws-client :ec2 credentials6738)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6740
       enableVolumeIO
       (enable-volume-iorequest (clojure.core/nth args6739 0)))))))
  (clojure.core/defn
   enable-volume-io-map
   {:arglists (quote
               [[credentials
                 {:keys [volume-id
                         request-metric-collector
                         dry-run-request]}]]),
    :doc "Generate map for enableVolumeIO"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :enable-volume-io,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   enable-volume-io
   {:arglists (quote
               [[credentials
                 {:keys [volume-id
                         request-metric-collector
                         dry-run-request]}]]),
    :doc "Call enableVolumeIO"}
   [credentials6742 & args6743]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6744
     (com.palletops.awaze.common/aws-client :ec2 credentials6742)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client6744
      enableVolumeIO
      (enable-volume-iorequest (clojure.core/nth args6743 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :replace-network-acl-association
   [m6745]
   (clojure.core/let
    [credentials6746 (:credentials m6745) args6747 (:args m6745)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6748
      (com.palletops.awaze.common/aws-client :ec2 credentials6746)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6748
       replaceNetworkAclAssociation
       (replace-network-acl-association-request
        (clojure.core/nth args6747 0)))))))
  (clojure.core/defn
   replace-network-acl-association-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         network-acl-id
                         dry-run-request
                         association-id]}]]),
    :doc "Generate map for replaceNetworkAclAssociation"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :replace-network-acl-association,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   replace-network-acl-association
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         network-acl-id
                         dry-run-request
                         association-id]}]]),
    :doc "Call replaceNetworkAclAssociation"}
   [credentials6750 & args6751]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6752
     (com.palletops.awaze.common/aws-client :ec2 credentials6750)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client6752
      replaceNetworkAclAssociation
      (replace-network-acl-association-request
       (clojure.core/nth args6751 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :copy-snapshot
   [m6753]
   (clojure.core/let
    [credentials6754 (:credentials m6753) args6755 (:args m6753)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6756
      (com.palletops.awaze.common/aws-client :ec2 credentials6754)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6756
       copySnapshot
       (copy-snapshot-request (clojure.core/nth args6755 0)))))))
  (clojure.core/defn
   copy-snapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [source-snapshot-id
                         source-region
                         request-metric-collector
                         dry-run-request
                         description]}]]),
    :doc "Generate map for copySnapshot"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :copy-snapshot,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   copy-snapshot
   {:arglists (quote
               [[credentials
                 {:keys [source-snapshot-id
                         source-region
                         request-metric-collector
                         dry-run-request
                         description]}]]),
    :doc "Call copySnapshot"}
   [credentials6758 & args6759]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6760
     (com.palletops.awaze.common/aws-client :ec2 credentials6758)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client6760
      copySnapshot
      (copy-snapshot-request (clojure.core/nth args6759 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-customer-gateway
   [m6761]
   (clojure.core/let
    [credentials6762 (:credentials m6761) args6763 (:args m6761)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6764
      (com.palletops.awaze.common/aws-client :ec2 credentials6762)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6764
       createCustomerGateway
       (create-customer-gateway-request (clojure.core/nth args6763 0)))))))
  (clojure.core/defn
   create-customer-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [type
                         request-metric-collector
                         public-ip
                         dry-run-request
                         bgp-asn]}]]),
    :doc "Generate map for createCustomerGateway"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :create-customer-gateway,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   create-customer-gateway
   {:arglists (quote
               [[credentials
                 {:keys [type
                         request-metric-collector
                         public-ip
                         dry-run-request
                         bgp-asn]}]]),
    :doc "Call createCustomerGateway"}
   [credentials6766 & args6767]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6768
     (com.palletops.awaze.common/aws-client :ec2 credentials6766)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client6768
      createCustomerGateway
      (create-customer-gateway-request (clojure.core/nth args6767 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-reserved-instances-offerings
   [m6769]
   (clojure.core/let
    [credentials6770 (:credentials m6769) args6771 (:args m6769)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6772
      (com.palletops.awaze.common/aws-client :ec2 credentials6770)]
     (clojure.core/case
      (clojure.core/count args6771)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client6772
        describeReservedInstancesOfferings))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client6772
        describeReservedInstancesOfferings
        (describe-reserved-instances-offerings-request
         (clojure.core/nth args6771 0))))))))
  (clojure.core/defn
   describe-reserved-instances-offerings-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [instance-type
                         reserved-instances-offering-ids
                         dry-run-request
                         request-metric-collector
                         min-duration
                         filters
                         max-duration
                         availability-zone
                         max-instance-count
                         max-results
                         product-description
                         next-token
                         offering-type
                         instance-tenancy
                         include-marketplace]}]]),
    :doc "Generate map for describeReservedInstancesOfferings, describeReservedInstancesOfferings"}
   ([credentials__1609__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-reserved-instances-offerings,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-reserved-instances-offerings,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-reserved-instances-offerings
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [instance-type
                         reserved-instances-offering-ids
                         dry-run-request
                         request-metric-collector
                         min-duration
                         filters
                         max-duration
                         availability-zone
                         max-instance-count
                         max-results
                         product-description
                         next-token
                         offering-type
                         instance-tenancy
                         include-marketplace]}]]),
    :doc "Call describeReservedInstancesOfferings, describeReservedInstancesOfferings"}
   [credentials6774 & args6775]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6776
     (com.palletops.awaze.common/aws-client :ec2 credentials6774)]
    (clojure.core/case
     (clojure.core/count args6775)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6776
       describeReservedInstancesOfferings))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6776
       describeReservedInstancesOfferings
       (describe-reserved-instances-offerings-request
        (clojure.core/nth args6775 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :cancel-bundle-task
   [m6777]
   (clojure.core/let
    [credentials6778 (:credentials m6777) args6779 (:args m6777)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6780
      (com.palletops.awaze.common/aws-client :ec2 credentials6778)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6780
       cancelBundleTask
       (cancel-bundle-task-request (clojure.core/nth args6779 0)))))))
  (clojure.core/defn
   cancel-bundle-task-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         dry-run-request
                         bundle-id]}]]),
    :doc "Generate map for cancelBundleTask"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :cancel-bundle-task,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   cancel-bundle-task
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         dry-run-request
                         bundle-id]}]]),
    :doc "Call cancelBundleTask"}
   [credentials6782 & args6783]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6784
     (com.palletops.awaze.common/aws-client :ec2 credentials6782)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client6784
      cancelBundleTask
      (cancel-bundle-task-request (clojure.core/nth args6783 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-images
   [m6785]
   (clojure.core/let
    [credentials6786 (:credentials m6785) args6787 (:args m6785)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6788
      (com.palletops.awaze.common/aws-client :ec2 credentials6786)]
     (clojure.core/case
      (clojure.core/count args6787)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client6788
        describeImages
        (describe-images-request (clojure.core/nth args6787 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client6788
        describeImages))))))
  (clojure.core/defn
   describe-images-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         owners
                         image-ids
                         filters
                         executable-users
                         dry-run-request]}]
                [credentials]]),
    :doc "Generate map for describeImages, describeImages"}
   ([credentials__1609__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-images,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-images,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-images
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         owners
                         image-ids
                         filters
                         executable-users
                         dry-run-request]}]
                [credentials]]),
    :doc "Call describeImages, describeImages"}
   [credentials6790 & args6791]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6792
     (com.palletops.awaze.common/aws-client :ec2 credentials6790)]
    (clojure.core/case
     (clojure.core/count args6791)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6792
       describeImages
       (describe-images-request (clojure.core/nth args6791 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6792
       describeImages))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-dhcp-options
   [m6793]
   (clojure.core/let
    [credentials6794 (:credentials m6793) args6795 (:args m6793)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6796
      (com.palletops.awaze.common/aws-client :ec2 credentials6794)]
     (clojure.core/case
      (clojure.core/count args6795)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client6796
        describeDhcpOptions
        (describe-dhcp-options-request (clojure.core/nth args6795 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client6796
        describeDhcpOptions))))))
  (clojure.core/defn
   describe-dhcp-options-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         filters
                         dry-run-request
                         dhcp-options-ids]}]
                [credentials]]),
    :doc "Generate map for describeDhcpOptions, describeDhcpOptions"}
   ([credentials__1609__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-dhcp-options,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-dhcp-options,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-dhcp-options
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         filters
                         dry-run-request
                         dhcp-options-ids]}]
                [credentials]]),
    :doc "Call describeDhcpOptions, describeDhcpOptions"}
   [credentials6798 & args6799]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6800
     (com.palletops.awaze.common/aws-client :ec2 credentials6798)]
    (clojure.core/case
     (clojure.core/count args6799)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6800
       describeDhcpOptions
       (describe-dhcp-options-request (clojure.core/nth args6799 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6800
       describeDhcpOptions))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-vpn-connection
   [m6801]
   (clojure.core/let
    [credentials6802 (:credentials m6801) args6803 (:args m6801)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6804
      (com.palletops.awaze.common/aws-client :ec2 credentials6802)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6804
       deleteVpnConnection
       (delete-vpn-connection-request (clojure.core/nth args6803 0)))))))
  (clojure.core/defn
   delete-vpn-connection-map
   {:arglists (quote
               [[credentials
                 {:keys [vpn-connection-id
                         request-metric-collector
                         dry-run-request]}]]),
    :doc "Generate map for deleteVpnConnection"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :delete-vpn-connection,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   delete-vpn-connection
   {:arglists (quote
               [[credentials
                 {:keys [vpn-connection-id
                         request-metric-collector
                         dry-run-request]}]]),
    :doc "Call deleteVpnConnection"}
   [credentials6806 & args6807]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6808
     (com.palletops.awaze.common/aws-client :ec2 credentials6806)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client6808
      deleteVpnConnection
      (delete-vpn-connection-request (clojure.core/nth args6807 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-vpn-connection-route
   [m6809]
   (clojure.core/let
    [credentials6810 (:credentials m6809) args6811 (:args m6809)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6812
      (com.palletops.awaze.common/aws-client :ec2 credentials6810)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6812
       createVpnConnectionRoute
       (create-vpn-connection-route-request
        (clojure.core/nth args6811 0)))))))
  (clojure.core/defn
   create-vpn-connection-route-map
   {:arglists (quote
               [[credentials
                 {:keys [vpn-connection-id
                         request-metric-collector
                         destination-cidr-block]}]]),
    :doc "Generate map for createVpnConnectionRoute"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :create-vpn-connection-route,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   create-vpn-connection-route
   {:arglists (quote
               [[credentials
                 {:keys [vpn-connection-id
                         request-metric-collector
                         destination-cidr-block]}]]),
    :doc "Call createVpnConnectionRoute"}
   [credentials6814 & args6815]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6816
     (com.palletops.awaze.common/aws-client :ec2 credentials6814)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client6816
      createVpnConnectionRoute
      (create-vpn-connection-route-request
       (clojure.core/nth args6815 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-key-pair
   [m6817]
   (clojure.core/let
    [credentials6818 (:credentials m6817) args6819 (:args m6817)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6820
      (com.palletops.awaze.common/aws-client :ec2 credentials6818)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6820
       createKeyPair
       (create-key-pair-request (clojure.core/nth args6819 0)))))))
  (clojure.core/defn
   create-key-pair-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         key-name
                         dry-run-request]}]]),
    :doc "Generate map for createKeyPair"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :create-key-pair,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   create-key-pair
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         key-name
                         dry-run-request]}]]),
    :doc "Call createKeyPair"}
   [credentials6822 & args6823]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6824
     (com.palletops.awaze.common/aws-client :ec2 credentials6822)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client6824
      createKeyPair
      (create-key-pair-request (clojure.core/nth args6823 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-account-attributes
   [m6825]
   (clojure.core/let
    [credentials6826 (:credentials m6825) args6827 (:args m6825)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6828
      (com.palletops.awaze.common/aws-client :ec2 credentials6826)]
     (clojure.core/case
      (clojure.core/count args6827)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client6828
        describeAccountAttributes))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client6828
        describeAccountAttributes
        (describe-account-attributes-request
         (clojure.core/nth args6827 0))))))))
  (clojure.core/defn
   describe-account-attributes-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [request-metric-collector
                         dry-run-request
                         attribute-names]}]]),
    :doc "Generate map for describeAccountAttributes, describeAccountAttributes"}
   ([credentials__1609__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-account-attributes,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-account-attributes,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-account-attributes
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [request-metric-collector
                         dry-run-request
                         attribute-names]}]]),
    :doc "Call describeAccountAttributes, describeAccountAttributes"}
   [credentials6830 & args6831]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6832
     (com.palletops.awaze.common/aws-client :ec2 credentials6830)]
    (clojure.core/case
     (clojure.core/count args6831)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6832
       describeAccountAttributes))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6832
       describeAccountAttributes
       (describe-account-attributes-request
        (clojure.core/nth args6831 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-spot-datafeed-subscription
   [m6833]
   (clojure.core/let
    [credentials6834 (:credentials m6833) args6835 (:args m6833)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6836
      (com.palletops.awaze.common/aws-client :ec2 credentials6834)]
     (clojure.core/case
      (clojure.core/count args6835)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client6836
        describeSpotDatafeedSubscription))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client6836
        describeSpotDatafeedSubscription
        (describe-spot-datafeed-subscription-request
         (clojure.core/nth args6835 0))))))))
  (clojure.core/defn
   describe-spot-datafeed-subscription-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [request-metric-collector dry-run-request]}]]),
    :doc "Generate map for describeSpotDatafeedSubscription, describeSpotDatafeedSubscription"}
   ([credentials__1609__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-spot-datafeed-subscription,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-spot-datafeed-subscription,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-spot-datafeed-subscription
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [request-metric-collector dry-run-request]}]]),
    :doc "Call describeSpotDatafeedSubscription, describeSpotDatafeedSubscription"}
   [credentials6838 & args6839]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6840
     (com.palletops.awaze.common/aws-client :ec2 credentials6838)]
    (clojure.core/case
     (clojure.core/count args6839)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6840
       describeSpotDatafeedSubscription))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6840
       describeSpotDatafeedSubscription
       (describe-spot-datafeed-subscription-request
        (clojure.core/nth args6839 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-internet-gateways
   [m6841]
   (clojure.core/let
    [credentials6842 (:credentials m6841) args6843 (:args m6841)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6844
      (com.palletops.awaze.common/aws-client :ec2 credentials6842)]
     (clojure.core/case
      (clojure.core/count args6843)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client6844
        describeInternetGateways))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client6844
        describeInternetGateways
        (describe-internet-gateways-request
         (clojure.core/nth args6843 0))))))))
  (clojure.core/defn
   describe-internet-gateways-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [request-metric-collector
                         internet-gateway-ids
                         filters
                         dry-run-request]}]]),
    :doc "Generate map for describeInternetGateways, describeInternetGateways"}
   ([credentials__1609__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-internet-gateways,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-internet-gateways,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-internet-gateways
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [request-metric-collector
                         internet-gateway-ids
                         filters
                         dry-run-request]}]]),
    :doc "Call describeInternetGateways, describeInternetGateways"}
   [credentials6846 & args6847]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6848
     (com.palletops.awaze.common/aws-client :ec2 credentials6846)]
    (clojure.core/case
     (clojure.core/count args6847)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6848
       describeInternetGateways))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6848
       describeInternetGateways
       (describe-internet-gateways-request
        (clojure.core/nth args6847 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :start-instances
   [m6849]
   (clojure.core/let
    [credentials6850 (:credentials m6849) args6851 (:args m6849)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6852
      (com.palletops.awaze.common/aws-client :ec2 credentials6850)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6852
       startInstances
       (start-instances-request (clojure.core/nth args6851 0)))))))
  (clojure.core/defn
   start-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         instance-ids
                         dry-run-request
                         additional-info]}]]),
    :doc "Generate map for startInstances"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :start-instances,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   start-instances
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         instance-ids
                         dry-run-request
                         additional-info]}]]),
    :doc "Call startInstances"}
   [credentials6854 & args6855]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6856
     (com.palletops.awaze.common/aws-client :ec2 credentials6854)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client6856
      startInstances
      (start-instances-request (clojure.core/nth args6855 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :attach-network-interface
   [m6857]
   (clojure.core/let
    [credentials6858 (:credentials m6857) args6859 (:args m6857)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6860
      (com.palletops.awaze.common/aws-client :ec2 credentials6858)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6860
       attachNetworkInterface
       (attach-network-interface-request
        (clojure.core/nth args6859 0)))))))
  (clojure.core/defn
   attach-network-interface-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         network-interface-id
                         instance-id
                         dry-run-request
                         device-index]}]]),
    :doc "Generate map for attachNetworkInterface"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :attach-network-interface,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   attach-network-interface
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         network-interface-id
                         instance-id
                         dry-run-request
                         device-index]}]]),
    :doc "Call attachNetworkInterface"}
   [credentials6862 & args6863]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6864
     (com.palletops.awaze.common/aws-client :ec2 credentials6862)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client6864
      attachNetworkInterface
      (attach-network-interface-request (clojure.core/nth args6863 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-route
   [m6865]
   (clojure.core/let
    [credentials6866 (:credentials m6865) args6867 (:args m6865)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6868
      (com.palletops.awaze.common/aws-client :ec2 credentials6866)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6868
       createRoute
       (create-route-request (clojure.core/nth args6867 0)))))))
  (clojure.core/defn
   create-route-map
   {:arglists (quote
               [[credentials
                 {:keys [network-interface-id
                         route-table-id
                         dry-run-request
                         destination-cidr-block
                         instance-id
                         request-metric-collector
                         gateway-id]}]]),
    :doc "Generate map for createRoute"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :create-route,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   create-route
   {:arglists (quote
               [[credentials
                 {:keys [network-interface-id
                         route-table-id
                         dry-run-request
                         destination-cidr-block
                         instance-id
                         request-metric-collector
                         gateway-id]}]]),
    :doc "Call createRoute"}
   [credentials6870 & args6871]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6872
     (com.palletops.awaze.common/aws-client :ec2 credentials6870)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client6872
      createRoute
      (create-route-request (clojure.core/nth args6871 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :unmonitor-instances
   [m6873]
   (clojure.core/let
    [credentials6874 (:credentials m6873) args6875 (:args m6873)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6876
      (com.palletops.awaze.common/aws-client :ec2 credentials6874)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6876
       unmonitorInstances
       (unmonitor-instances-request (clojure.core/nth args6875 0)))))))
  (clojure.core/defn
   unmonitor-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         instance-ids
                         dry-run-request]}]]),
    :doc "Generate map for unmonitorInstances"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :unmonitor-instances,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   unmonitor-instances
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         instance-ids
                         dry-run-request]}]]),
    :doc "Call unmonitorInstances"}
   [credentials6878 & args6879]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6880
     (com.palletops.awaze.common/aws-client :ec2 credentials6878)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client6880
      unmonitorInstances
      (unmonitor-instances-request (clojure.core/nth args6879 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-network-interface
   [m6881]
   (clojure.core/let
    [credentials6882 (:credentials m6881) args6883 (:args m6881)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6884
      (com.palletops.awaze.common/aws-client :ec2 credentials6882)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6884
       deleteNetworkInterface
       (delete-network-interface-request
        (clojure.core/nth args6883 0)))))))
  (clojure.core/defn
   delete-network-interface-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         network-interface-id
                         dry-run-request]}]]),
    :doc "Generate map for deleteNetworkInterface"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :delete-network-interface,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   delete-network-interface
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         network-interface-id
                         dry-run-request]}]]),
    :doc "Call deleteNetworkInterface"}
   [credentials6886 & args6887]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6888
     (com.palletops.awaze.common/aws-client :ec2 credentials6886)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client6888
      deleteNetworkInterface
      (delete-network-interface-request (clojure.core/nth args6887 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :monitor-instances
   [m6889]
   (clojure.core/let
    [credentials6890 (:credentials m6889) args6891 (:args m6889)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6892
      (com.palletops.awaze.common/aws-client :ec2 credentials6890)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6892
       monitorInstances
       (monitor-instances-request (clojure.core/nth args6891 0)))))))
  (clojure.core/defn
   monitor-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         instance-ids
                         dry-run-request]}]]),
    :doc "Generate map for monitorInstances"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :monitor-instances,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   monitor-instances
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         instance-ids
                         dry-run-request]}]]),
    :doc "Call monitorInstances"}
   [credentials6894 & args6895]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6896
     (com.palletops.awaze.common/aws-client :ec2 credentials6894)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client6896
      monitorInstances
      (monitor-instances-request (clojure.core/nth args6895 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-reserved-instances-listings
   [m6897]
   (clojure.core/let
    [credentials6898 (:credentials m6897) args6899 (:args m6897)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6900
      (com.palletops.awaze.common/aws-client :ec2 credentials6898)]
     (clojure.core/case
      (clojure.core/count args6899)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client6900
        describeReservedInstancesListings))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client6900
        describeReservedInstancesListings
        (describe-reserved-instances-listings-request
         (clojure.core/nth args6899 0))))))))
  (clojure.core/defn
   describe-reserved-instances-listings-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [reserved-instances-listing-id
                         reserved-instances-id
                         request-metric-collector
                         filters]}]]),
    :doc "Generate map for describeReservedInstancesListings, describeReservedInstancesListings"}
   ([credentials__1609__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-reserved-instances-listings,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-reserved-instances-listings,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-reserved-instances-listings
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [reserved-instances-listing-id
                         reserved-instances-id
                         request-metric-collector
                         filters]}]]),
    :doc "Call describeReservedInstancesListings, describeReservedInstancesListings"}
   [credentials6902 & args6903]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6904
     (com.palletops.awaze.common/aws-client :ec2 credentials6902)]
    (clojure.core/case
     (clojure.core/count args6903)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6904
       describeReservedInstancesListings))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6904
       describeReservedInstancesListings
       (describe-reserved-instances-listings-request
        (clojure.core/nth args6903 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-tags
   [m6905]
   (clojure.core/let
    [credentials6906 (:credentials m6905) args6907 (:args m6905)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6908
      (com.palletops.awaze.common/aws-client :ec2 credentials6906)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6908
       createTags
       (create-tags-request (clojure.core/nth args6907 0)))))))
  (clojure.core/defn
   create-tags-map
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         resources
                         request-metric-collector
                         dry-run-request]}]]),
    :doc "Generate map for createTags"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :create-tags,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   create-tags
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         resources
                         request-metric-collector
                         dry-run-request]}]]),
    :doc "Call createTags"}
   [credentials6910 & args6911]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6912
     (com.palletops.awaze.common/aws-client :ec2 credentials6910)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client6912
      createTags
      (create-tags-request (clojure.core/nth args6911 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :confirm-product-instance
   [m6913]
   (clojure.core/let
    [credentials6914 (:credentials m6913) args6915 (:args m6913)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6916
      (com.palletops.awaze.common/aws-client :ec2 credentials6914)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6916
       confirmProductInstance
       (confirm-product-instance-request
        (clojure.core/nth args6915 0)))))))
  (clojure.core/defn
   confirm-product-instance-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         product-code
                         instance-id
                         dry-run-request]}]]),
    :doc "Generate map for confirmProductInstance"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :confirm-product-instance,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   confirm-product-instance
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         product-code
                         instance-id
                         dry-run-request]}]]),
    :doc "Call confirmProductInstance"}
   [credentials6918 & args6919]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6920
     (com.palletops.awaze.common/aws-client :ec2 credentials6918)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client6920
      confirmProductInstance
      (confirm-product-instance-request (clojure.core/nth args6919 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :disassociate-route-table
   [m6921]
   (clojure.core/let
    [credentials6922 (:credentials m6921) args6923 (:args m6921)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6924
      (com.palletops.awaze.common/aws-client :ec2 credentials6922)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6924
       disassociateRouteTable
       (disassociate-route-table-request
        (clojure.core/nth args6923 0)))))))
  (clojure.core/defn
   disassociate-route-table-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         dry-run-request
                         association-id]}]]),
    :doc "Generate map for disassociateRouteTable"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :disassociate-route-table,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   disassociate-route-table
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         dry-run-request
                         association-id]}]]),
    :doc "Call disassociateRouteTable"}
   [credentials6926 & args6927]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6928
     (com.palletops.awaze.common/aws-client :ec2 credentials6926)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client6928
      disassociateRouteTable
      (disassociate-route-table-request (clojure.core/nth args6927 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :disassociate-address
   [m6929]
   (clojure.core/let
    [credentials6930 (:credentials m6929) args6931 (:args m6929)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6932
      (com.palletops.awaze.common/aws-client :ec2 credentials6930)]
     (clojure.core/case
      (clojure.core/count args6931)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client6932
        disassociateAddress
        (disassociate-address-request (clojure.core/nth args6931 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client6932
        disassociateAddress))))))
  (clojure.core/defn
   disassociate-address-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         public-ip
                         dry-run-request
                         association-id]}]
                [credentials]]),
    :doc "Generate map for disassociateAddress, disassociateAddress"}
   ([credentials__1609__auto__]
    {:args [],
     :client :ec2,
     :fn :disassociate-address,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :disassociate-address,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   disassociate-address
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         public-ip
                         dry-run-request
                         association-id]}]
                [credentials]]),
    :doc "Call disassociateAddress, disassociateAddress"}
   [credentials6934 & args6935]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6936
     (com.palletops.awaze.common/aws-client :ec2 credentials6934)]
    (clojure.core/case
     (clojure.core/count args6935)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6936
       disassociateAddress
       (disassociate-address-request (clojure.core/nth args6935 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6936
       disassociateAddress))))))
 (do
  (clojure.core/defmethod
   ec2
   :detach-network-interface
   [m6937]
   (clojure.core/let
    [credentials6938 (:credentials m6937) args6939 (:args m6937)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6940
      (com.palletops.awaze.common/aws-client :ec2 credentials6938)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6940
       detachNetworkInterface
       (detach-network-interface-request
        (clojure.core/nth args6939 0)))))))
  (clojure.core/defn
   detach-network-interface-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         force
                         dry-run-request
                         attachment-id]}]]),
    :doc "Generate map for detachNetworkInterface"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :detach-network-interface,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   detach-network-interface
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         force
                         dry-run-request
                         attachment-id]}]]),
    :doc "Call detachNetworkInterface"}
   [credentials6942 & args6943]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6944
     (com.palletops.awaze.common/aws-client :ec2 credentials6942)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client6944
      detachNetworkInterface
      (detach-network-interface-request (clojure.core/nth args6943 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-export-tasks
   [m6945]
   (clojure.core/let
    [credentials6946 (:credentials m6945) args6947 (:args m6945)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6948
      (com.palletops.awaze.common/aws-client :ec2 credentials6946)]
     (clojure.core/case
      (clojure.core/count args6947)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client6948
        describeExportTasks))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client6948
        describeExportTasks
        (describe-export-tasks-request (clojure.core/nth args6947 0))))))))
  (clojure.core/defn
   describe-export-tasks-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [request-metric-collector export-task-ids]}]]),
    :doc "Generate map for describeExportTasks, describeExportTasks"}
   ([credentials__1609__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-export-tasks,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-export-tasks,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-export-tasks
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [request-metric-collector export-task-ids]}]]),
    :doc "Call describeExportTasks, describeExportTasks"}
   [credentials6950 & args6951]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6952
     (com.palletops.awaze.common/aws-client :ec2 credentials6950)]
    (clojure.core/case
     (clojure.core/count args6951)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6952
       describeExportTasks))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6952
       describeExportTasks
       (describe-export-tasks-request (clojure.core/nth args6951 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-addresses
   [m6953]
   (clojure.core/let
    [credentials6954 (:credentials m6953) args6955 (:args m6953)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6956
      (com.palletops.awaze.common/aws-client :ec2 credentials6954)]
     (clojure.core/case
      (clojure.core/count args6955)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client6956
        describeAddresses))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client6956
        describeAddresses
        (describe-addresses-request (clojure.core/nth args6955 0))))))))
  (clojure.core/defn
   describe-addresses-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [request-metric-collector
                         public-ips
                         filters
                         dry-run-request
                         allocation-ids]}]]),
    :doc "Generate map for describeAddresses, describeAddresses"}
   ([credentials__1609__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-addresses,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-addresses,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-addresses
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [request-metric-collector
                         public-ips
                         filters
                         dry-run-request
                         allocation-ids]}]]),
    :doc "Call describeAddresses, describeAddresses"}
   [credentials6958 & args6959]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6960
     (com.palletops.awaze.common/aws-client :ec2 credentials6958)]
    (clojure.core/case
     (clojure.core/count args6959)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6960
       describeAddresses))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6960
       describeAddresses
       (describe-addresses-request (clojure.core/nth args6959 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-instance-export-task
   [m6961]
   (clojure.core/let
    [credentials6962 (:credentials m6961) args6963 (:args m6961)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6964
      (com.palletops.awaze.common/aws-client :ec2 credentials6962)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6964
       createInstanceExportTask
       (create-instance-export-task-request
        (clojure.core/nth args6963 0)))))))
  (clojure.core/defn
   create-instance-export-task-map
   {:arglists (quote
               [[credentials
                 {:keys [target-environment
                         request-metric-collector
                         instance-id
                         export-to-s3task
                         description]}]]),
    :doc "Generate map for createInstanceExportTask"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :create-instance-export-task,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   create-instance-export-task
   {:arglists (quote
               [[credentials
                 {:keys [target-environment
                         request-metric-collector
                         instance-id
                         export-to-s3task
                         description]}]]),
    :doc "Call createInstanceExportTask"}
   [credentials6966 & args6967]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6968
     (com.palletops.awaze.common/aws-client :ec2 credentials6966)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client6968
      createInstanceExportTask
      (create-instance-export-task-request
       (clojure.core/nth args6967 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-image
   [m6969]
   (clojure.core/let
    [credentials6970 (:credentials m6969) args6971 (:args m6969)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6972
      (com.palletops.awaze.common/aws-client :ec2 credentials6970)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6972
       createImage
       (create-image-request (clojure.core/nth args6971 0)))))))
  (clojure.core/defn
   create-image-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         block-device-mappings
                         dry-run-request
                         name
                         instance-id
                         no-reboot
                         request-metric-collector]}]]),
    :doc "Generate map for createImage"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :create-image,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   create-image
   {:arglists (quote
               [[credentials
                 {:keys [description
                         block-device-mappings
                         dry-run-request
                         name
                         instance-id
                         no-reboot
                         request-metric-collector]}]]),
    :doc "Call createImage"}
   [credentials6974 & args6975]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6976
     (com.palletops.awaze.common/aws-client :ec2 credentials6974)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client6976
      createImage
      (create-image-request (clojure.core/nth args6975 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-security-group
   [m6977]
   (clojure.core/let
    [credentials6978 (:credentials m6977) args6979 (:args m6977)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6980
      (com.palletops.awaze.common/aws-client :ec2 credentials6978)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6980
       createSecurityGroup
       (create-security-group-request (clojure.core/nth args6979 0)))))))
  (clojure.core/defn
   create-security-group-map
   {:arglists (quote
               [[credentials
                 {:keys [vpc-id
                         request-metric-collector
                         group-name
                         dry-run-request
                         description]}]]),
    :doc "Generate map for createSecurityGroup"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :create-security-group,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   create-security-group
   {:arglists (quote
               [[credentials
                 {:keys [vpc-id
                         request-metric-collector
                         group-name
                         dry-run-request
                         description]}]]),
    :doc "Call createSecurityGroup"}
   [credentials6982 & args6983]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6984
     (com.palletops.awaze.common/aws-client :ec2 credentials6982)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client6984
      createSecurityGroup
      (create-security-group-request (clojure.core/nth args6983 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-subnet
   [m6985]
   (clojure.core/let
    [credentials6986 (:credentials m6985) args6987 (:args m6985)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6988
      (com.palletops.awaze.common/aws-client :ec2 credentials6986)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6988
       createSubnet
       (create-subnet-request (clojure.core/nth args6987 0)))))))
  (clojure.core/defn
   create-subnet-map
   {:arglists (quote
               [[credentials
                 {:keys [vpc-id
                         request-metric-collector
                         dry-run-request
                         cidr-block
                         availability-zone]}]]),
    :doc "Generate map for createSubnet"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :create-subnet,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   create-subnet
   {:arglists (quote
               [[credentials
                 {:keys [vpc-id
                         request-metric-collector
                         dry-run-request
                         cidr-block
                         availability-zone]}]]),
    :doc "Call createSubnet"}
   [credentials6990 & args6991]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client6992
     (com.palletops.awaze.common/aws-client :ec2 credentials6990)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client6992
      createSubnet
      (create-subnet-request (clojure.core/nth args6991 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-network-acl
   [m6993]
   (clojure.core/let
    [credentials6994 (:credentials m6993) args6995 (:args m6993)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client6996
      (com.palletops.awaze.common/aws-client :ec2 credentials6994)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client6996
       deleteNetworkAcl
       (delete-network-acl-request (clojure.core/nth args6995 0)))))))
  (clojure.core/defn
   delete-network-acl-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         network-acl-id
                         dry-run-request]}]]),
    :doc "Generate map for deleteNetworkAcl"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :delete-network-acl,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   delete-network-acl
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         network-acl-id
                         dry-run-request]}]]),
    :doc "Call deleteNetworkAcl"}
   [credentials6998 & args6999]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client7000
     (com.palletops.awaze.common/aws-client :ec2 credentials6998)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client7000
      deleteNetworkAcl
      (delete-network-acl-request (clojure.core/nth args6999 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-network-interface
   [m7001]
   (clojure.core/let
    [credentials7002 (:credentials m7001) args7003 (:args m7001)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client7004
      (com.palletops.awaze.common/aws-client :ec2 credentials7002)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client7004
       createNetworkInterface
       (create-network-interface-request
        (clojure.core/nth args7003 0)))))))
  (clojure.core/defn
   create-network-interface-map
   {:arglists (quote
               [[credentials
                 {:keys [dry-run-request
                         request-metric-collector
                         secondary-private-ip-address-count
                         subnet-id
                         private-ip-address
                         groups
                         private-ip-addresses
                         description]}]]),
    :doc "Generate map for createNetworkInterface"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :create-network-interface,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   create-network-interface
   {:arglists (quote
               [[credentials
                 {:keys [dry-run-request
                         request-metric-collector
                         secondary-private-ip-address-count
                         subnet-id
                         private-ip-address
                         groups
                         private-ip-addresses
                         description]}]]),
    :doc "Call createNetworkInterface"}
   [credentials7006 & args7007]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client7008
     (com.palletops.awaze.common/aws-client :ec2 credentials7006)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client7008
      createNetworkInterface
      (create-network-interface-request (clojure.core/nth args7007 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-vpn-gateway
   [m7009]
   (clojure.core/let
    [credentials7010 (:credentials m7009) args7011 (:args m7009)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client7012
      (com.palletops.awaze.common/aws-client :ec2 credentials7010)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client7012
       deleteVpnGateway
       (delete-vpn-gateway-request (clojure.core/nth args7011 0)))))))
  (clojure.core/defn
   delete-vpn-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [vpn-gateway-id
                         request-metric-collector
                         dry-run-request]}]]),
    :doc "Generate map for deleteVpnGateway"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :delete-vpn-gateway,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   delete-vpn-gateway
   {:arglists (quote
               [[credentials
                 {:keys [vpn-gateway-id
                         request-metric-collector
                         dry-run-request]}]]),
    :doc "Call deleteVpnGateway"}
   [credentials7014 & args7015]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client7016
     (com.palletops.awaze.common/aws-client :ec2 credentials7014)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client7016
      deleteVpnGateway
      (delete-vpn-gateway-request (clojure.core/nth args7015 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :attach-volume
   [m7017]
   (clojure.core/let
    [credentials7018 (:credentials m7017) args7019 (:args m7017)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client7020
      (com.palletops.awaze.common/aws-client :ec2 credentials7018)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client7020
       attachVolume
       (attach-volume-request (clojure.core/nth args7019 0)))))))
  (clojure.core/defn
   attach-volume-map
   {:arglists (quote
               [[credentials
                 {:keys [volume-id
                         request-metric-collector
                         instance-id
                         dry-run-request
                         device]}]]),
    :doc "Generate map for attachVolume"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :attach-volume,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   attach-volume
   {:arglists (quote
               [[credentials
                 {:keys [volume-id
                         request-metric-collector
                         instance-id
                         dry-run-request
                         device]}]]),
    :doc "Call attachVolume"}
   [credentials7022 & args7023]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client7024
     (com.palletops.awaze.common/aws-client :ec2 credentials7022)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client7024
      attachVolume
      (attach-volume-request (clojure.core/nth args7023 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-vpn-connection
   [m7025]
   (clojure.core/let
    [credentials7026 (:credentials m7025) args7027 (:args m7025)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client7028
      (com.palletops.awaze.common/aws-client :ec2 credentials7026)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client7028
       createVpnConnection
       (create-vpn-connection-request (clojure.core/nth args7027 0)))))))
  (clojure.core/defn
   create-vpn-connection-map
   {:arglists (quote
               [[credentials
                 {:keys [vpn-gateway-id
                         type
                         request-metric-collector
                         options
                         dry-run-request
                         customer-gateway-id]}]]),
    :doc "Generate map for createVpnConnection"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :create-vpn-connection,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   create-vpn-connection
   {:arglists (quote
               [[credentials
                 {:keys [vpn-gateway-id
                         type
                         request-metric-collector
                         options
                         dry-run-request
                         customer-gateway-id]}]]),
    :doc "Call createVpnConnection"}
   [credentials7030 & args7031]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client7032
     (com.palletops.awaze.common/aws-client :ec2 credentials7030)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client7032
      createVpnConnection
      (create-vpn-connection-request (clojure.core/nth args7031 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-placement-group
   [m7033]
   (clojure.core/let
    [credentials7034 (:credentials m7033) args7035 (:args m7033)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client7036
      (com.palletops.awaze.common/aws-client :ec2 credentials7034)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client7036
       deletePlacementGroup
       (delete-placement-group-request (clojure.core/nth args7035 0)))))))
  (clojure.core/defn
   delete-placement-group-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         group-name
                         dry-run-request]}]]),
    :doc "Generate map for deletePlacementGroup"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :delete-placement-group,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   delete-placement-group
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         group-name
                         dry-run-request]}]]),
    :doc "Call deletePlacementGroup"}
   [credentials7038 & args7039]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client7040
     (com.palletops.awaze.common/aws-client :ec2 credentials7038)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client7040
      deletePlacementGroup
      (delete-placement-group-request (clojure.core/nth args7039 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :reset-instance-attribute
   [m7041]
   (clojure.core/let
    [credentials7042 (:credentials m7041) args7043 (:args m7041)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client7044
      (com.palletops.awaze.common/aws-client :ec2 credentials7042)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client7044
       resetInstanceAttribute
       (reset-instance-attribute-request
        (clojure.core/nth args7043 0)))))))
  (clojure.core/defn
   reset-instance-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         instance-id
                         dry-run-request
                         attribute]}]]),
    :doc "Generate map for resetInstanceAttribute"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :reset-instance-attribute,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   reset-instance-attribute
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         instance-id
                         dry-run-request
                         attribute]}]]),
    :doc "Call resetInstanceAttribute"}
   [credentials7046 & args7047]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client7048
     (com.palletops.awaze.common/aws-client :ec2 credentials7046)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client7048
      resetInstanceAttribute
      (reset-instance-attribute-request (clojure.core/nth args7047 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-snapshot
   [m7049]
   (clojure.core/let
    [credentials7050 (:credentials m7049) args7051 (:args m7049)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client7052
      (com.palletops.awaze.common/aws-client :ec2 credentials7050)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client7052
       createSnapshot
       (create-snapshot-request (clojure.core/nth args7051 0)))))))
  (clojure.core/defn
   create-snapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [volume-id
                         request-metric-collector
                         dry-run-request
                         description]}]]),
    :doc "Generate map for createSnapshot"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :create-snapshot,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   create-snapshot
   {:arglists (quote
               [[credentials
                 {:keys [volume-id
                         request-metric-collector
                         dry-run-request
                         description]}]]),
    :doc "Call createSnapshot"}
   [credentials7054 & args7055]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client7056
     (com.palletops.awaze.common/aws-client :ec2 credentials7054)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client7056
      createSnapshot
      (create-snapshot-request (clojure.core/nth args7055 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :request-spot-instances
   [m7057]
   (clojure.core/let
    [credentials7058 (:credentials m7057) args7059 (:args m7057)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client7060
      (com.palletops.awaze.common/aws-client :ec2 credentials7058)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client7060
       requestSpotInstances
       (request-spot-instances-request (clojure.core/nth args7059 0)))))))
  (clojure.core/defn
   request-spot-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [dry-run-request
                         request-metric-collector
                         valid-from
                         spot-price
                         launch-group
                         instance-count
                         launch-specification
                         type
                         availability-zone-group
                         valid-until]}]]),
    :doc "Generate map for requestSpotInstances"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :request-spot-instances,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   request-spot-instances
   {:arglists (quote
               [[credentials
                 {:keys [dry-run-request
                         request-metric-collector
                         valid-from
                         spot-price
                         launch-group
                         instance-count
                         launch-specification
                         type
                         availability-zone-group
                         valid-until]}]]),
    :doc "Call requestSpotInstances"}
   [credentials7062 & args7063]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client7064
     (com.palletops.awaze.common/aws-client :ec2 credentials7062)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client7064
      requestSpotInstances
      (request-spot-instances-request (clojure.core/nth args7063 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-network-interfaces
   [m7065]
   (clojure.core/let
    [credentials7066 (:credentials m7065) args7067 (:args m7065)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client7068
      (com.palletops.awaze.common/aws-client :ec2 credentials7066)]
     (clojure.core/case
      (clojure.core/count args7067)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client7068
        describeNetworkInterfaces
        (describe-network-interfaces-request
         (clojure.core/nth args7067 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client7068
        describeNetworkInterfaces))))))
  (clojure.core/defn
   describe-network-interfaces-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         network-interface-ids
                         filters
                         dry-run-request]}]
                [credentials]]),
    :doc "Generate map for describeNetworkInterfaces, describeNetworkInterfaces"}
   ([credentials__1609__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-network-interfaces,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-network-interfaces,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-network-interfaces
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         network-interface-ids
                         filters
                         dry-run-request]}]
                [credentials]]),
    :doc "Call describeNetworkInterfaces, describeNetworkInterfaces"}
   [credentials7070 & args7071]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client7072
     (com.palletops.awaze.common/aws-client :ec2 credentials7070)]
    (clojure.core/case
     (clojure.core/count args7071)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client7072
       describeNetworkInterfaces
       (describe-network-interfaces-request
        (clojure.core/nth args7071 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client7072
       describeNetworkInterfaces))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-volume
   [m7073]
   (clojure.core/let
    [credentials7074 (:credentials m7073) args7075 (:args m7073)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client7076
      (com.palletops.awaze.common/aws-client :ec2 credentials7074)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client7076
       deleteVolume
       (delete-volume-request (clojure.core/nth args7075 0)))))))
  (clojure.core/defn
   delete-volume-map
   {:arglists (quote
               [[credentials
                 {:keys [volume-id
                         request-metric-collector
                         dry-run-request]}]]),
    :doc "Generate map for deleteVolume"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :delete-volume,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   delete-volume
   {:arglists (quote
               [[credentials
                 {:keys [volume-id
                         request-metric-collector
                         dry-run-request]}]]),
    :doc "Call deleteVolume"}
   [credentials7078 & args7079]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client7080
     (com.palletops.awaze.common/aws-client :ec2 credentials7078)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client7080
      deleteVolume
      (delete-volume-request (clojure.core/nth args7079 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-snapshot
   [m7081]
   (clojure.core/let
    [credentials7082 (:credentials m7081) args7083 (:args m7081)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client7084
      (com.palletops.awaze.common/aws-client :ec2 credentials7082)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client7084
       deleteSnapshot
       (delete-snapshot-request (clojure.core/nth args7083 0)))))))
  (clojure.core/defn
   delete-snapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [snapshot-id
                         request-metric-collector
                         dry-run-request]}]]),
    :doc "Generate map for deleteSnapshot"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :delete-snapshot,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   delete-snapshot
   {:arglists (quote
               [[credentials
                 {:keys [snapshot-id
                         request-metric-collector
                         dry-run-request]}]]),
    :doc "Call deleteSnapshot"}
   [credentials7086 & args7087]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client7088
     (com.palletops.awaze.common/aws-client :ec2 credentials7086)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client7088
      deleteSnapshot
      (delete-snapshot-request (clojure.core/nth args7087 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-instances
   [m7089]
   (clojure.core/let
    [credentials7090 (:credentials m7089) args7091 (:args m7089)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client7092
      (com.palletops.awaze.common/aws-client :ec2 credentials7090)]
     (clojure.core/case
      (clojure.core/count args7091)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client7092
        describeInstances
        (describe-instances-request (clojure.core/nth args7091 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client7092
        describeInstances))))))
  (clojure.core/defn
   describe-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         instance-ids
                         filters
                         dry-run-request]}]
                [credentials]]),
    :doc "Generate map for describeInstances, describeInstances"}
   ([credentials__1609__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-instances,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-instances,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-instances
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         instance-ids
                         filters
                         dry-run-request]}]
                [credentials]]),
    :doc "Call describeInstances, describeInstances"}
   [credentials7094 & args7095]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client7096
     (com.palletops.awaze.common/aws-client :ec2 credentials7094)]
    (clojure.core/case
     (clojure.core/count args7095)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client7096
       describeInstances
       (describe-instances-request (clojure.core/nth args7095 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client7096
       describeInstances))))))
 (do
  (clojure.core/defmethod
   ec2
   :associate-route-table
   [m7097]
   (clojure.core/let
    [credentials7098 (:credentials m7097) args7099 (:args m7097)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client7100
      (com.palletops.awaze.common/aws-client :ec2 credentials7098)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client7100
       associateRouteTable
       (associate-route-table-request (clojure.core/nth args7099 0)))))))
  (clojure.core/defn
   associate-route-table-map
   {:arglists (quote
               [[credentials
                 {:keys [subnet-id
                         route-table-id
                         request-metric-collector
                         dry-run-request]}]]),
    :doc "Generate map for associateRouteTable"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :associate-route-table,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   associate-route-table
   {:arglists (quote
               [[credentials
                 {:keys [subnet-id
                         route-table-id
                         request-metric-collector
                         dry-run-request]}]]),
    :doc "Call associateRouteTable"}
   [credentials7102 & args7103]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client7104
     (com.palletops.awaze.common/aws-client :ec2 credentials7102)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client7104
      associateRouteTable
      (associate-route-table-request (clojure.core/nth args7103 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :disable-vgw-route-propagation
   [m7105]
   (clojure.core/let
    [credentials7106 (:credentials m7105) args7107 (:args m7105)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client7108
      (com.palletops.awaze.common/aws-client :ec2 credentials7106)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client7108
       disableVgwRoutePropagation
       (disable-vgw-route-propagation-request
        (clojure.core/nth args7107 0)))))))
  (clojure.core/defn
   disable-vgw-route-propagation-map
   {:arglists (quote
               [[credentials
                 {:keys [route-table-id
                         request-metric-collector
                         gateway-id]}]]),
    :doc "Generate map for disableVgwRoutePropagation"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :disable-vgw-route-propagation,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   disable-vgw-route-propagation
   {:arglists (quote
               [[credentials
                 {:keys [route-table-id
                         request-metric-collector
                         gateway-id]}]]),
    :doc "Call disableVgwRoutePropagation"}
   [credentials7110 & args7111]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client7112
     (com.palletops.awaze.common/aws-client :ec2 credentials7110)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client7112
      disableVgwRoutePropagation
      (disable-vgw-route-propagation-request
       (clojure.core/nth args7111 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-instance-attribute
   [m7113]
   (clojure.core/let
    [credentials7114 (:credentials m7113) args7115 (:args m7113)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client7116
      (com.palletops.awaze.common/aws-client :ec2 credentials7114)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client7116
       describeInstanceAttribute
       (describe-instance-attribute-request
        (clojure.core/nth args7115 0)))))))
  (clojure.core/defn
   describe-instance-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         instance-id
                         dry-run-request
                         attribute]}]]),
    :doc "Generate map for describeInstanceAttribute"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-instance-attribute,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-instance-attribute
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         instance-id
                         dry-run-request
                         attribute]}]]),
    :doc "Call describeInstanceAttribute"}
   [credentials7118 & args7119]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client7120
     (com.palletops.awaze.common/aws-client :ec2 credentials7118)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client7120
      describeInstanceAttribute
      (describe-instance-attribute-request
       (clojure.core/nth args7119 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-vpn-gateway
   [m7121]
   (clojure.core/let
    [credentials7122 (:credentials m7121) args7123 (:args m7121)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client7124
      (com.palletops.awaze.common/aws-client :ec2 credentials7122)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client7124
       createVpnGateway
       (create-vpn-gateway-request (clojure.core/nth args7123 0)))))))
  (clojure.core/defn
   create-vpn-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [type
                         request-metric-collector
                         dry-run-request
                         availability-zone]}]]),
    :doc "Generate map for createVpnGateway"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :create-vpn-gateway,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   create-vpn-gateway
   {:arglists (quote
               [[credentials
                 {:keys [type
                         request-metric-collector
                         dry-run-request
                         availability-zone]}]]),
    :doc "Call createVpnGateway"}
   [credentials7126 & args7127]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client7128
     (com.palletops.awaze.common/aws-client :ec2 credentials7126)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client7128
      createVpnGateway
      (create-vpn-gateway-request (clojure.core/nth args7127 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-network-acl
   [m7129]
   (clojure.core/let
    [credentials7130 (:credentials m7129) args7131 (:args m7129)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client7132
      (com.palletops.awaze.common/aws-client :ec2 credentials7130)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client7132
       createNetworkAcl
       (create-network-acl-request (clojure.core/nth args7131 0)))))))
  (clojure.core/defn
   create-network-acl-map
   {:arglists (quote
               [[credentials
                 {:keys [vpc-id
                         request-metric-collector
                         dry-run-request]}]]),
    :doc "Generate map for createNetworkAcl"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :create-network-acl,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   create-network-acl
   {:arglists (quote
               [[credentials
                 {:keys [vpc-id
                         request-metric-collector
                         dry-run-request]}]]),
    :doc "Call createNetworkAcl"}
   [credentials7134 & args7135]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client7136
     (com.palletops.awaze.common/aws-client :ec2 credentials7134)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client7136
      createNetworkAcl
      (create-network-acl-request (clojure.core/nth args7135 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :replace-route
   [m7137]
   (clojure.core/let
    [credentials7138 (:credentials m7137) args7139 (:args m7137)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client7140
      (com.palletops.awaze.common/aws-client :ec2 credentials7138)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client7140
       replaceRoute
       (replace-route-request (clojure.core/nth args7139 0)))))))
  (clojure.core/defn
   replace-route-map
   {:arglists (quote
               [[credentials
                 {:keys [network-interface-id
                         route-table-id
                         dry-run-request
                         destination-cidr-block
                         instance-id
                         request-metric-collector
                         gateway-id]}]]),
    :doc "Generate map for replaceRoute"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :replace-route,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   replace-route
   {:arglists (quote
               [[credentials
                 {:keys [network-interface-id
                         route-table-id
                         dry-run-request
                         destination-cidr-block
                         instance-id
                         request-metric-collector
                         gateway-id]}]]),
    :doc "Call replaceRoute"}
   [credentials7142 & args7143]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client7144
     (com.palletops.awaze.common/aws-client :ec2 credentials7142)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client7144
      replaceRoute
      (replace-route-request (clojure.core/nth args7143 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-regions
   [m7145]
   (clojure.core/let
    [credentials7146 (:credentials m7145) args7147 (:args m7145)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client7148
      (com.palletops.awaze.common/aws-client :ec2 credentials7146)]
     (clojure.core/case
      (clojure.core/count args7147)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client7148
        describeRegions))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client7148
        describeRegions
        (describe-regions-request (clojure.core/nth args7147 0))))))))
  (clojure.core/defn
   describe-regions-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [request-metric-collector
                         region-names
                         filters
                         dry-run-request]}]]),
    :doc "Generate map for describeRegions, describeRegions"}
   ([credentials__1609__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-regions,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-regions,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-regions
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [request-metric-collector
                         region-names
                         filters
                         dry-run-request]}]]),
    :doc "Call describeRegions, describeRegions"}
   [credentials7150 & args7151]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client7152
     (com.palletops.awaze.common/aws-client :ec2 credentials7150)]
    (clojure.core/case
     (clojure.core/count args7151)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client7152
       describeRegions))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client7152
       describeRegions
       (describe-regions-request (clojure.core/nth args7151 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-internet-gateway
   [m7153]
   (clojure.core/let
    [credentials7154 (:credentials m7153) args7155 (:args m7153)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client7156
      (com.palletops.awaze.common/aws-client :ec2 credentials7154)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client7156
       deleteInternetGateway
       (delete-internet-gateway-request (clojure.core/nth args7155 0)))))))
  (clojure.core/defn
   delete-internet-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         internet-gateway-id
                         dry-run-request]}]]),
    :doc "Generate map for deleteInternetGateway"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :delete-internet-gateway,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   delete-internet-gateway
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         internet-gateway-id
                         dry-run-request]}]]),
    :doc "Call deleteInternetGateway"}
   [credentials7158 & args7159]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client7160
     (com.palletops.awaze.common/aws-client :ec2 credentials7158)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client7160
      deleteInternetGateway
      (delete-internet-gateway-request (clojure.core/nth args7159 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-route
   [m7161]
   (clojure.core/let
    [credentials7162 (:credentials m7161) args7163 (:args m7161)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client7164
      (com.palletops.awaze.common/aws-client :ec2 credentials7162)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client7164
       deleteRoute
       (delete-route-request (clojure.core/nth args7163 0)))))))
  (clojure.core/defn
   delete-route-map
   {:arglists (quote
               [[credentials
                 {:keys [route-table-id
                         request-metric-collector
                         dry-run-request
                         destination-cidr-block]}]]),
    :doc "Generate map for deleteRoute"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :delete-route,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   delete-route
   {:arglists (quote
               [[credentials
                 {:keys [route-table-id
                         request-metric-collector
                         dry-run-request
                         destination-cidr-block]}]]),
    :doc "Call deleteRoute"}
   [credentials7166 & args7167]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client7168
     (com.palletops.awaze.common/aws-client :ec2 credentials7166)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client7168
      deleteRoute
      (delete-route-request (clojure.core/nth args7167 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :assign-private-ip-addresses
   [m7169]
   (clojure.core/let
    [credentials7170 (:credentials m7169) args7171 (:args m7169)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client7172
      (com.palletops.awaze.common/aws-client :ec2 credentials7170)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client7172
       assignPrivateIpAddresses
       (assign-private-ip-addresses-request
        (clojure.core/nth args7171 0)))))))
  (clojure.core/defn
   assign-private-ip-addresses-map
   {:arglists (quote
               [[credentials
                 {:keys [secondary-private-ip-address-count
                         request-metric-collector
                         private-ip-addresses
                         network-interface-id
                         allow-reassignment]}]]),
    :doc "Generate map for assignPrivateIpAddresses"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :assign-private-ip-addresses,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   assign-private-ip-addresses
   {:arglists (quote
               [[credentials
                 {:keys [secondary-private-ip-address-count
                         request-metric-collector
                         private-ip-addresses
                         network-interface-id
                         allow-reassignment]}]]),
    :doc "Call assignPrivateIpAddresses"}
   [credentials7174 & args7175]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client7176
     (com.palletops.awaze.common/aws-client :ec2 credentials7174)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client7176
      assignPrivateIpAddresses
      (assign-private-ip-addresses-request
       (clojure.core/nth args7175 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-dhcp-options
   [m7177]
   (clojure.core/let
    [credentials7178 (:credentials m7177) args7179 (:args m7177)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client7180
      (com.palletops.awaze.common/aws-client :ec2 credentials7178)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client7180
       deleteDhcpOptions
       (delete-dhcp-options-request (clojure.core/nth args7179 0)))))))
  (clojure.core/defn
   delete-dhcp-options-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         dry-run-request
                         dhcp-options-id]}]]),
    :doc "Generate map for deleteDhcpOptions"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :delete-dhcp-options,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   delete-dhcp-options
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         dry-run-request
                         dhcp-options-id]}]]),
    :doc "Call deleteDhcpOptions"}
   [credentials7182 & args7183]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client7184
     (com.palletops.awaze.common/aws-client :ec2 credentials7182)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client7184
      deleteDhcpOptions
      (delete-dhcp-options-request (clojure.core/nth args7183 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :cancel-spot-instance-requests
   [m7185]
   (clojure.core/let
    [credentials7186 (:credentials m7185) args7187 (:args m7185)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client7188
      (com.palletops.awaze.common/aws-client :ec2 credentials7186)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client7188
       cancelSpotInstanceRequests
       (cancel-spot-instance-requests-request
        (clojure.core/nth args7187 0)))))))
  (clojure.core/defn
   cancel-spot-instance-requests-map
   {:arglists (quote
               [[credentials
                 {:keys [spot-instance-request-ids
                         request-metric-collector
                         dry-run-request]}]]),
    :doc "Generate map for cancelSpotInstanceRequests"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :cancel-spot-instance-requests,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   cancel-spot-instance-requests
   {:arglists (quote
               [[credentials
                 {:keys [spot-instance-request-ids
                         request-metric-collector
                         dry-run-request]}]]),
    :doc "Call cancelSpotInstanceRequests"}
   [credentials7190 & args7191]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client7192
     (com.palletops.awaze.common/aws-client :ec2 credentials7190)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client7192
      cancelSpotInstanceRequests
      (cancel-spot-instance-requests-request
       (clojure.core/nth args7191 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-dhcp-options
   [m7193]
   (clojure.core/let
    [credentials7194 (:credentials m7193) args7195 (:args m7193)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client7196
      (com.palletops.awaze.common/aws-client :ec2 credentials7194)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client7196
       createDhcpOptions
       (create-dhcp-options-request (clojure.core/nth args7195 0)))))))
  (clojure.core/defn
   create-dhcp-options-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         dry-run-request
                         dhcp-configurations]}]]),
    :doc "Generate map for createDhcpOptions"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :create-dhcp-options,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   create-dhcp-options
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         dry-run-request
                         dhcp-configurations]}]]),
    :doc "Call createDhcpOptions"}
   [credentials7198 & args7199]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client7200
     (com.palletops.awaze.common/aws-client :ec2 credentials7198)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client7200
      createDhcpOptions
      (create-dhcp-options-request (clojure.core/nth args7199 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :stop-instances
   [m7201]
   (clojure.core/let
    [credentials7202 (:credentials m7201) args7203 (:args m7201)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client7204
      (com.palletops.awaze.common/aws-client :ec2 credentials7202)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client7204
       stopInstances
       (stop-instances-request (clojure.core/nth args7203 0)))))))
  (clojure.core/defn
   stop-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         instance-ids
                         force
                         dry-run-request]}]]),
    :doc "Generate map for stopInstances"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :stop-instances,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   stop-instances
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         instance-ids
                         force
                         dry-run-request]}]]),
    :doc "Call stopInstances"}
   [credentials7206 & args7207]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client7208
     (com.palletops.awaze.common/aws-client :ec2 credentials7206)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.ec2.AmazonEC2Client client7208
      stopInstances
      (stop-instances-request (clojure.core/nth args7207 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :authorize-security-group-ingress
   [m7209]
   (clojure.core/let
    [credentials7210 (:credentials m7209) args7211 (:args m7209)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client7212
      (com.palletops.awaze.common/aws-client :ec2 credentials7210)]
     (clojure.core/case
      (clojure.core/count args7211)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client7212
        authorizeSecurityGroupIngress))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client7212
        authorizeSecurityGroupIngress
        (authorize-security-group-ingress-request
         (clojure.core/nth args7211 0))))))))
  (clojure.core/defn
   authorize-security-group-ingress-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [dry-run-request
                         source-security-group-name
                         request-metric-collector
                         group-id
                         from-port
                         ip-permissions
                         to-port
                         cidr-ip
                         ip-protocol
                         source-security-group-owner-id
                         group-name]}]]),
    :doc "Generate map for authorizeSecurityGroupIngress, authorizeSecurityGroupIngress"}
   ([credentials__1609__auto__]
    {:args [],
     :client :ec2,
     :fn :authorize-security-group-ingress,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :authorize-security-group-ingress,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   authorize-security-group-ingress
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [dry-run-request
                         source-security-group-name
                         request-metric-collector
                         group-id
                         from-port
                         ip-permissions
                         to-port
                         cidr-ip
                         ip-protocol
                         source-security-group-owner-id
                         group-name]}]]),
    :doc "Call authorizeSecurityGroupIngress, authorizeSecurityGroupIngress"}
   [credentials7214 & args7215]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client7216
     (com.palletops.awaze.common/aws-client :ec2 credentials7214)]
    (clojure.core/case
     (clojure.core/count args7215)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client7216
       authorizeSecurityGroupIngress))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client7216
       authorizeSecurityGroupIngress
       (authorize-security-group-ingress-request
        (clojure.core/nth args7215 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-placement-groups
   [m7217]
   (clojure.core/let
    [credentials7218 (:credentials m7217) args7219 (:args m7217)]
    (clojure.core/let
     [^com.amazonaws.services.ec2.AmazonEC2Client client7220
      (com.palletops.awaze.common/aws-client :ec2 credentials7218)]
     (clojure.core/case
      (clojure.core/count args7219)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client7220
        describePlacementGroups
        (describe-placement-groups-request
         (clojure.core/nth args7219 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.ec2.AmazonEC2Client client7220
        describePlacementGroups))))))
  (clojure.core/defn
   describe-placement-groups-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         group-names
                         filters
                         dry-run-request]}]
                [credentials]]),
    :doc "Generate map for describePlacementGroups, describePlacementGroups"}
   ([credentials__1609__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-placement-groups,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-placement-groups,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-placement-groups
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         group-names
                         filters
                         dry-run-request]}]
                [credentials]]),
    :doc "Call describePlacementGroups, describePlacementGroups"}
   [credentials7222 & args7223]
   (clojure.core/let
    [^com.amazonaws.services.ec2.AmazonEC2Client client7224
     (com.palletops.awaze.common/aws-client :ec2 credentials7222)]
    (clojure.core/case
     (clojure.core/count args7223)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client7224
       describePlacementGroups
       (describe-placement-groups-request
        (clojure.core/nth args7223 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.ec2.AmazonEC2Client client7224
       describePlacementGroups)))))))
