(ns
 com.palletops.awaze.elasticache
 (:require [com.palletops.awaze.common]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :elasticache
  [___1561__auto__
   ^com.amazonaws.auth.BasicAWSCredentials credentials__1562__auto__]
  (new
   com.amazonaws.services.elasticache.AmazonElastiCacheClient
   credentials__1562__auto__))
 (clojure.core/defn
  ^com.amazonaws.services.elasticache.model.ParameterNameValue parameter-name-value
  [m10038]
  (clojure.core/let
   [bean10037
    (new com.amazonaws.services.elasticache.model.ParameterNameValue)]
   (clojure.core/when-let
    [v10039 (:parameter-name m10038)]
    (. bean10037 setParameterName (clojure.core/str v10039)))
   (clojure.core/when-let
    [v10039 (:parameter-value m10038)]
    (. bean10037 setParameterValue (clojure.core/str v10039)))
   bean10037))
 (clojure.core/defn
  ^com.amazonaws.services.elasticache.model.SourceType source-type
  [m10041]
  (java.lang.Enum/valueOf
   com.amazonaws.services.elasticache.model.SourceType
   (clojure.core/name m10041)))
 (clojure.core/defn
  ^com.amazonaws.services.elasticache.model.DescribeCacheParameterGroupsRequest describe-cache-parameter-groups-request
  [m10044]
  (clojure.core/let
   [bean10043
    (new
     com.amazonaws.services.elasticache.model.DescribeCacheParameterGroupsRequest)]
   (clojure.core/when-let
    [v10045 (:cache-parameter-group-name m10044)]
    (. bean10043 setCacheParameterGroupName (clojure.core/str v10045)))
   (clojure.core/when-let
    [v10045 (:marker m10044)]
    (. bean10043 setMarker (clojure.core/str v10045)))
   (clojure.core/when-let
    [v10045 (:max-records m10044)]
    (. bean10043 setMaxRecords (clojure.core/int v10045)))
   bean10043))
 (clojure.core/defn
  ^com.amazonaws.services.elasticache.model.CreateCacheParameterGroupRequest create-cache-parameter-group-request
  [m10047]
  (clojure.core/let
   [bean10046
    (new
     com.amazonaws.services.elasticache.model.CreateCacheParameterGroupRequest)]
   (clojure.core/when-let
    [v10048 (:cache-parameter-group-name m10047)]
    (. bean10046 setCacheParameterGroupName (clojure.core/str v10048)))
   (clojure.core/when-let
    [v10048 (:description m10047)]
    (. bean10046 setDescription (clojure.core/str v10048)))
   (clojure.core/when-let
    [v10048 (:cache-parameter-group-family m10047)]
    (.
     bean10046
     setCacheParameterGroupFamily
     (clojure.core/str v10048)))
   bean10046))
 (clojure.core/defn
  ^com.amazonaws.services.elasticache.model.RevokeCacheSecurityGroupIngressRequest revoke-cache-security-group-ingress-request
  [m10050]
  (clojure.core/let
   [bean10049
    (new
     com.amazonaws.services.elasticache.model.RevokeCacheSecurityGroupIngressRequest)]
   (clojure.core/when-let
    [v10051 (:cache-security-group-name m10050)]
    (. bean10049 setCacheSecurityGroupName (clojure.core/str v10051)))
   (clojure.core/when-let
    [v10051 (:ec2security-group-name m10050)]
    (. bean10049 setEC2SecurityGroupName (clojure.core/str v10051)))
   (clojure.core/when-let
    [v10051 (:ec2security-group-owner-id m10050)]
    (. bean10049 setEC2SecurityGroupOwnerId (clojure.core/str v10051)))
   bean10049))
 (clojure.core/defn
  ^com.amazonaws.services.elasticache.model.CreateReplicationGroupRequest create-replication-group-request
  [m10053]
  (clojure.core/let
   [bean10052
    (new
     com.amazonaws.services.elasticache.model.CreateReplicationGroupRequest)]
   (clojure.core/when-let
    [v10054 (:replication-group-id m10053)]
    (. bean10052 setReplicationGroupId (clojure.core/str v10054)))
   (clojure.core/when-let
    [v10054 (:primary-cluster-id m10053)]
    (. bean10052 setPrimaryClusterId (clojure.core/str v10054)))
   (clojure.core/when-let
    [v10054 (:replication-group-description m10053)]
    (.
     bean10052
     setReplicationGroupDescription
     (clojure.core/str v10054)))
   bean10052))
 (clojure.core/defn
  ^com.amazonaws.services.elasticache.model.AuthorizeCacheSecurityGroupIngressRequest authorize-cache-security-group-ingress-request
  [m10056]
  (clojure.core/let
   [bean10055
    (new
     com.amazonaws.services.elasticache.model.AuthorizeCacheSecurityGroupIngressRequest)]
   (clojure.core/when-let
    [v10057 (:cache-security-group-name m10056)]
    (. bean10055 setCacheSecurityGroupName (clojure.core/str v10057)))
   (clojure.core/when-let
    [v10057 (:ec2security-group-name m10056)]
    (. bean10055 setEC2SecurityGroupName (clojure.core/str v10057)))
   (clojure.core/when-let
    [v10057 (:ec2security-group-owner-id m10056)]
    (. bean10055 setEC2SecurityGroupOwnerId (clojure.core/str v10057)))
   bean10055))
 (clojure.core/defn
  ^com.amazonaws.services.elasticache.model.DescribeReservedCacheNodesRequest describe-reserved-cache-nodes-request
  [m10059]
  (clojure.core/let
   [bean10058
    (new
     com.amazonaws.services.elasticache.model.DescribeReservedCacheNodesRequest)]
   (clojure.core/when-let
    [v10060 (:reserved-cache-nodes-offering-id m10059)]
    (.
     bean10058
     setReservedCacheNodesOfferingId
     (clojure.core/str v10060)))
   (clojure.core/when-let
    [v10060 (:cache-node-type m10059)]
    (. bean10058 setCacheNodeType (clojure.core/str v10060)))
   (clojure.core/when-let
    [v10060 (:marker m10059)]
    (. bean10058 setMarker (clojure.core/str v10060)))
   (clojure.core/when-let
    [v10060 (:product-description m10059)]
    (. bean10058 setProductDescription (clojure.core/str v10060)))
   (clojure.core/when-let
    [v10060 (:duration m10059)]
    (. bean10058 setDuration (clojure.core/str v10060)))
   (clojure.core/when-let
    [v10060 (:offering-type m10059)]
    (. bean10058 setOfferingType (clojure.core/str v10060)))
   (clojure.core/when-let
    [v10060 (:max-records m10059)]
    (. bean10058 setMaxRecords (clojure.core/int v10060)))
   (clojure.core/when-let
    [v10060 (:reserved-cache-node-id m10059)]
    (. bean10058 setReservedCacheNodeId (clojure.core/str v10060)))
   bean10058))
 (clojure.core/defn
  ^com.amazonaws.services.elasticache.model.ModifyCacheClusterRequest modify-cache-cluster-request
  [m10062]
  (clojure.core/let
   [bean10061
    (new
     com.amazonaws.services.elasticache.model.ModifyCacheClusterRequest)]
   (clojure.core/when-let
    [v10063 (:cache-cluster-id m10062)]
    (. bean10061 setCacheClusterId (clojure.core/str v10063)))
   (clojure.core/when-let
    [v10063 (:num-cache-nodes m10062)]
    (. bean10061 setNumCacheNodes (clojure.core/int v10063)))
   (clojure.core/when-let
    [v10063 (:cache-node-ids-to-remove m10062)]
    (.
     bean10061
     setCacheNodeIdsToRemove
     (clojure.core/map
      (clojure.core/fn [arg10067] (clojure.core/str arg10067))
      v10063)))
   (clojure.core/when-let
    [v10063 (:cache-security-group-names m10062)]
    (.
     bean10061
     setCacheSecurityGroupNames
     (clojure.core/map
      (clojure.core/fn [arg10068] (clojure.core/str arg10068))
      v10063)))
   (clojure.core/when-let
    [v10063 (:notification-topic-arn m10062)]
    (. bean10061 setNotificationTopicArn (clojure.core/str v10063)))
   (clojure.core/when-let
    [v10063 (:cache-parameter-group-name m10062)]
    (. bean10061 setCacheParameterGroupName (clojure.core/str v10063)))
   (clojure.core/when-let
    [v10063 (:notification-topic-status m10062)]
    (. bean10061 setNotificationTopicStatus (clojure.core/str v10063)))
   (clojure.core/when-let
    [v10063 (:engine-version m10062)]
    (. bean10061 setEngineVersion (clojure.core/str v10063)))
   (clojure.core/when-let
    [v10063 (:auto-minor-version-upgrade m10062)]
    (.
     bean10061
     setAutoMinorVersionUpgrade
     (clojure.core/boolean v10063)))
   (clojure.core/when-let
    [v10063 (:apply-immediately m10062)]
    (. bean10061 setApplyImmediately (clojure.core/boolean v10063)))
   (clojure.core/when-let
    [v10063 (:security-group-ids m10062)]
    (.
     bean10061
     setSecurityGroupIds
     (clojure.core/map
      (clojure.core/fn [arg10069] (clojure.core/str arg10069))
      v10063)))
   (clojure.core/when-let
    [v10063 (:preferred-maintenance-window m10062)]
    (.
     bean10061
     setPreferredMaintenanceWindow
     (clojure.core/str v10063)))
   bean10061))
 (clojure.core/defn
  ^com.amazonaws.services.elasticache.model.DeleteCacheSubnetGroupRequest delete-cache-subnet-group-request
  [m10065]
  (clojure.core/let
   [bean10064
    (new
     com.amazonaws.services.elasticache.model.DeleteCacheSubnetGroupRequest)]
   (clojure.core/when-let
    [v10066 (:cache-subnet-group-name m10065)]
    (. bean10064 setCacheSubnetGroupName (clojure.core/str v10066)))
   bean10064))
 (clojure.core/defn
  ^com.amazonaws.services.elasticache.model.DescribeCacheEngineVersionsRequest describe-cache-engine-versions-request
  [m10071]
  (clojure.core/let
   [bean10070
    (new
     com.amazonaws.services.elasticache.model.DescribeCacheEngineVersionsRequest)]
   (clojure.core/when-let
    [v10072 (:marker m10071)]
    (. bean10070 setMarker (clojure.core/str v10072)))
   (clojure.core/when-let
    [v10072 (:engine m10071)]
    (. bean10070 setEngine (clojure.core/str v10072)))
   (clojure.core/when-let
    [v10072 (:engine-version m10071)]
    (. bean10070 setEngineVersion (clojure.core/str v10072)))
   (clojure.core/when-let
    [v10072 (:default-only m10071)]
    (. bean10070 setDefaultOnly (clojure.core/boolean v10072)))
   (clojure.core/when-let
    [v10072 (:max-records m10071)]
    (. bean10070 setMaxRecords (clojure.core/int v10072)))
   (clojure.core/when-let
    [v10072 (:cache-parameter-group-family m10071)]
    (.
     bean10070
     setCacheParameterGroupFamily
     (clojure.core/str v10072)))
   bean10070))
 (clojure.core/defn
  ^com.amazonaws.services.elasticache.model.ResetCacheParameterGroupRequest reset-cache-parameter-group-request
  [m10074]
  (clojure.core/let
   [bean10073
    (new
     com.amazonaws.services.elasticache.model.ResetCacheParameterGroupRequest)]
   (clojure.core/when-let
    [v10075 (:cache-parameter-group-name m10074)]
    (. bean10073 setCacheParameterGroupName (clojure.core/str v10075)))
   (clojure.core/when-let
    [v10075 (:reset-all-parameters m10074)]
    (. bean10073 setResetAllParameters (clojure.core/boolean v10075)))
   (clojure.core/when-let
    [v10075 (:parameter-name-values m10074)]
    (.
     bean10073
     setParameterNameValues
     (clojure.core/map
      (clojure.core/fn [arg10079] (parameter-name-value arg10079))
      v10075)))
   bean10073))
 (clojure.core/defn
  ^com.amazonaws.services.elasticache.model.DescribeEngineDefaultParametersRequest describe-engine-default-parameters-request
  [m10077]
  (clojure.core/let
   [bean10076
    (new
     com.amazonaws.services.elasticache.model.DescribeEngineDefaultParametersRequest)]
   (clojure.core/when-let
    [v10078 (:marker m10077)]
    (. bean10076 setMarker (clojure.core/str v10078)))
   (clojure.core/when-let
    [v10078 (:max-records m10077)]
    (. bean10076 setMaxRecords (clojure.core/int v10078)))
   (clojure.core/when-let
    [v10078 (:cache-parameter-group-family m10077)]
    (.
     bean10076
     setCacheParameterGroupFamily
     (clojure.core/str v10078)))
   bean10076))
 (clojure.core/defn
  ^com.amazonaws.services.elasticache.model.DeleteCacheClusterRequest delete-cache-cluster-request
  [m10081]
  (clojure.core/let
   [bean10080
    (new
     com.amazonaws.services.elasticache.model.DeleteCacheClusterRequest)]
   (clojure.core/when-let
    [v10082 (:cache-cluster-id m10081)]
    (. bean10080 setCacheClusterId (clojure.core/str v10082)))
   bean10080))
 (clojure.core/defn
  ^com.amazonaws.services.elasticache.model.DescribeCacheSubnetGroupsRequest describe-cache-subnet-groups-request
  [m10084]
  (clojure.core/let
   [bean10083
    (new
     com.amazonaws.services.elasticache.model.DescribeCacheSubnetGroupsRequest)]
   (clojure.core/when-let
    [v10085 (:marker m10084)]
    (. bean10083 setMarker (clojure.core/str v10085)))
   (clojure.core/when-let
    [v10085 (:max-records m10084)]
    (. bean10083 setMaxRecords (clojure.core/int v10085)))
   (clojure.core/when-let
    [v10085 (:cache-subnet-group-name m10084)]
    (. bean10083 setCacheSubnetGroupName (clojure.core/str v10085)))
   bean10083))
 (clojure.core/defn
  ^com.amazonaws.services.elasticache.model.DescribeReplicationGroupsRequest describe-replication-groups-request
  [m10087]
  (clojure.core/let
   [bean10086
    (new
     com.amazonaws.services.elasticache.model.DescribeReplicationGroupsRequest)]
   (clojure.core/when-let
    [v10088 (:replication-group-id m10087)]
    (. bean10086 setReplicationGroupId (clojure.core/str v10088)))
   (clojure.core/when-let
    [v10088 (:marker m10087)]
    (. bean10086 setMarker (clojure.core/str v10088)))
   (clojure.core/when-let
    [v10088 (:max-records m10087)]
    (. bean10086 setMaxRecords (clojure.core/int v10088)))
   bean10086))
 (clojure.core/defn
  ^com.amazonaws.services.elasticache.model.DescribeCacheSecurityGroupsRequest describe-cache-security-groups-request
  [m10090]
  (clojure.core/let
   [bean10089
    (new
     com.amazonaws.services.elasticache.model.DescribeCacheSecurityGroupsRequest)]
   (clojure.core/when-let
    [v10091 (:marker m10090)]
    (. bean10089 setMarker (clojure.core/str v10091)))
   (clojure.core/when-let
    [v10091 (:max-records m10090)]
    (. bean10089 setMaxRecords (clojure.core/int v10091)))
   (clojure.core/when-let
    [v10091 (:cache-security-group-name m10090)]
    (. bean10089 setCacheSecurityGroupName (clojure.core/str v10091)))
   bean10089))
 (clojure.core/defn
  ^com.amazonaws.services.elasticache.model.CreateCacheSecurityGroupRequest create-cache-security-group-request
  [m10093]
  (clojure.core/let
   [bean10092
    (new
     com.amazonaws.services.elasticache.model.CreateCacheSecurityGroupRequest)]
   (clojure.core/when-let
    [v10094 (:description m10093)]
    (. bean10092 setDescription (clojure.core/str v10094)))
   (clojure.core/when-let
    [v10094 (:cache-security-group-name m10093)]
    (. bean10092 setCacheSecurityGroupName (clojure.core/str v10094)))
   bean10092))
 (clojure.core/defn
  ^com.amazonaws.services.elasticache.model.DescribeCacheClustersRequest describe-cache-clusters-request
  [m10096]
  (clojure.core/let
   [bean10095
    (new
     com.amazonaws.services.elasticache.model.DescribeCacheClustersRequest)]
   (clojure.core/when-let
    [v10097 (:cache-cluster-id m10096)]
    (. bean10095 setCacheClusterId (clojure.core/str v10097)))
   (clojure.core/when-let
    [v10097 (:marker m10096)]
    (. bean10095 setMarker (clojure.core/str v10097)))
   (clojure.core/when-let
    [v10097 (:max-records m10096)]
    (. bean10095 setMaxRecords (clojure.core/int v10097)))
   (clojure.core/when-let
    [v10097 (:show-cache-node-info m10096)]
    (. bean10095 setShowCacheNodeInfo (clojure.core/boolean v10097)))
   bean10095))
 (clojure.core/defn
  ^com.amazonaws.services.elasticache.model.DescribeEventsRequest describe-events-request
  [m10099]
  (clojure.core/let
   [bean10098
    (new
     com.amazonaws.services.elasticache.model.DescribeEventsRequest)]
   (clojure.core/when-let
    [v10100 (:marker m10099)]
    (. bean10098 setMarker (clojure.core/str v10100)))
   (clojure.core/when-let
    [v10100 (:start-time m10099)]
    (.
     bean10098
     setStartTime
     (com.palletops.awaze.common/to-date v10100)))
   (clojure.core/when-let
    [v10100 (:duration m10099)]
    (. bean10098 setDuration (clojure.core/int v10100)))
   (clojure.core/when-let
    [v10100 (:max-records m10099)]
    (. bean10098 setMaxRecords (clojure.core/int v10100)))
   (clojure.core/when-let
    [v10100 (:source-identifier m10099)]
    (. bean10098 setSourceIdentifier (clojure.core/str v10100)))
   (clojure.core/when-let
    [v10100 (:source-type m10099)]
    (. bean10098 setSourceType (clojure.core/str v10100)))
   (clojure.core/when-let
    [v10100 (:source-type m10099)]
    (. bean10098 setSourceType (source-type v10100)))
   (clojure.core/when-let
    [v10100 (:end-time m10099)]
    (.
     bean10098
     setEndTime
     (com.palletops.awaze.common/to-date v10100)))
   bean10098))
 (clojure.core/defn
  ^com.amazonaws.services.elasticache.model.ModifyCacheParameterGroupRequest modify-cache-parameter-group-request
  [m10102]
  (clojure.core/let
   [bean10101
    (new
     com.amazonaws.services.elasticache.model.ModifyCacheParameterGroupRequest)]
   (clojure.core/when-let
    [v10103 (:cache-parameter-group-name m10102)]
    (. bean10101 setCacheParameterGroupName (clojure.core/str v10103)))
   (clojure.core/when-let
    [v10103 (:parameter-name-values m10102)]
    (.
     bean10101
     setParameterNameValues
     (clojure.core/map
      (clojure.core/fn [arg10107] (parameter-name-value arg10107))
      v10103)))
   bean10101))
 (clojure.core/defn
  ^com.amazonaws.services.elasticache.model.DeleteCacheSecurityGroupRequest delete-cache-security-group-request
  [m10105]
  (clojure.core/let
   [bean10104
    (new
     com.amazonaws.services.elasticache.model.DeleteCacheSecurityGroupRequest)]
   (clojure.core/when-let
    [v10106 (:cache-security-group-name m10105)]
    (. bean10104 setCacheSecurityGroupName (clojure.core/str v10106)))
   bean10104))
 (clojure.core/defn
  ^com.amazonaws.services.elasticache.model.CreateCacheSubnetGroupRequest create-cache-subnet-group-request
  [m10109]
  (clojure.core/let
   [bean10108
    (new
     com.amazonaws.services.elasticache.model.CreateCacheSubnetGroupRequest)]
   (clojure.core/when-let
    [v10110 (:subnet-ids m10109)]
    (.
     bean10108
     setSubnetIds
     (clojure.core/map
      (clojure.core/fn [arg10114] (clojure.core/str arg10114))
      v10110)))
   (clojure.core/when-let
    [v10110 (:cache-subnet-group-name m10109)]
    (. bean10108 setCacheSubnetGroupName (clojure.core/str v10110)))
   (clojure.core/when-let
    [v10110 (:cache-subnet-group-description m10109)]
    (.
     bean10108
     setCacheSubnetGroupDescription
     (clojure.core/str v10110)))
   bean10108))
 (clojure.core/defn
  ^com.amazonaws.services.elasticache.model.ModifyReplicationGroupRequest modify-replication-group-request
  [m10112]
  (clojure.core/let
   [bean10111
    (new
     com.amazonaws.services.elasticache.model.ModifyReplicationGroupRequest)]
   (clojure.core/when-let
    [v10113 (:replication-group-id m10112)]
    (. bean10111 setReplicationGroupId (clojure.core/str v10113)))
   (clojure.core/when-let
    [v10113 (:cache-security-group-names m10112)]
    (.
     bean10111
     setCacheSecurityGroupNames
     (clojure.core/map
      (clojure.core/fn [arg10118] (clojure.core/str arg10118))
      v10113)))
   (clojure.core/when-let
    [v10113 (:notification-topic-arn m10112)]
    (. bean10111 setNotificationTopicArn (clojure.core/str v10113)))
   (clojure.core/when-let
    [v10113 (:cache-parameter-group-name m10112)]
    (. bean10111 setCacheParameterGroupName (clojure.core/str v10113)))
   (clojure.core/when-let
    [v10113 (:notification-topic-status m10112)]
    (. bean10111 setNotificationTopicStatus (clojure.core/str v10113)))
   (clojure.core/when-let
    [v10113 (:engine-version m10112)]
    (. bean10111 setEngineVersion (clojure.core/str v10113)))
   (clojure.core/when-let
    [v10113 (:auto-minor-version-upgrade m10112)]
    (.
     bean10111
     setAutoMinorVersionUpgrade
     (clojure.core/boolean v10113)))
   (clojure.core/when-let
    [v10113 (:apply-immediately m10112)]
    (. bean10111 setApplyImmediately (clojure.core/boolean v10113)))
   (clojure.core/when-let
    [v10113 (:security-group-ids m10112)]
    (.
     bean10111
     setSecurityGroupIds
     (clojure.core/map
      (clojure.core/fn [arg10119] (clojure.core/str arg10119))
      v10113)))
   (clojure.core/when-let
    [v10113 (:preferred-maintenance-window m10112)]
    (.
     bean10111
     setPreferredMaintenanceWindow
     (clojure.core/str v10113)))
   (clojure.core/when-let
    [v10113 (:primary-cluster-id m10112)]
    (. bean10111 setPrimaryClusterId (clojure.core/str v10113)))
   (clojure.core/when-let
    [v10113 (:replication-group-description m10112)]
    (.
     bean10111
     setReplicationGroupDescription
     (clojure.core/str v10113)))
   bean10111))
 (clojure.core/defn
  ^com.amazonaws.services.elasticache.model.ModifyCacheSubnetGroupRequest modify-cache-subnet-group-request
  [m10116]
  (clojure.core/let
   [bean10115
    (new
     com.amazonaws.services.elasticache.model.ModifyCacheSubnetGroupRequest)]
   (clojure.core/when-let
    [v10117 (:subnet-ids m10116)]
    (.
     bean10115
     setSubnetIds
     (clojure.core/map
      (clojure.core/fn [arg10123] (clojure.core/str arg10123))
      v10117)))
   (clojure.core/when-let
    [v10117 (:cache-subnet-group-name m10116)]
    (. bean10115 setCacheSubnetGroupName (clojure.core/str v10117)))
   (clojure.core/when-let
    [v10117 (:cache-subnet-group-description m10116)]
    (.
     bean10115
     setCacheSubnetGroupDescription
     (clojure.core/str v10117)))
   bean10115))
 (clojure.core/defn
  ^com.amazonaws.services.elasticache.model.DescribeCacheParametersRequest describe-cache-parameters-request
  [m10121]
  (clojure.core/let
   [bean10120
    (new
     com.amazonaws.services.elasticache.model.DescribeCacheParametersRequest)]
   (clojure.core/when-let
    [v10122 (:cache-parameter-group-name m10121)]
    (. bean10120 setCacheParameterGroupName (clojure.core/str v10122)))
   (clojure.core/when-let
    [v10122 (:source m10121)]
    (. bean10120 setSource (clojure.core/str v10122)))
   (clojure.core/when-let
    [v10122 (:marker m10121)]
    (. bean10120 setMarker (clojure.core/str v10122)))
   (clojure.core/when-let
    [v10122 (:max-records m10121)]
    (. bean10120 setMaxRecords (clojure.core/int v10122)))
   bean10120))
 (clojure.core/defn
  ^com.amazonaws.services.elasticache.model.DeleteCacheParameterGroupRequest delete-cache-parameter-group-request
  [m10125]
  (clojure.core/let
   [bean10124
    (new
     com.amazonaws.services.elasticache.model.DeleteCacheParameterGroupRequest)]
   (clojure.core/when-let
    [v10126 (:cache-parameter-group-name m10125)]
    (. bean10124 setCacheParameterGroupName (clojure.core/str v10126)))
   bean10124))
 (clojure.core/defn
  ^com.amazonaws.services.elasticache.model.DeleteReplicationGroupRequest delete-replication-group-request
  [m10128]
  (clojure.core/let
   [bean10127
    (new
     com.amazonaws.services.elasticache.model.DeleteReplicationGroupRequest)]
   (clojure.core/when-let
    [v10129 (:replication-group-id m10128)]
    (. bean10127 setReplicationGroupId (clojure.core/str v10129)))
   bean10127))
 (clojure.core/defn
  ^com.amazonaws.services.elasticache.model.PurchaseReservedCacheNodesOfferingRequest purchase-reserved-cache-nodes-offering-request
  [m10131]
  (clojure.core/let
   [bean10130
    (new
     com.amazonaws.services.elasticache.model.PurchaseReservedCacheNodesOfferingRequest)]
   (clojure.core/when-let
    [v10132 (:reserved-cache-nodes-offering-id m10131)]
    (.
     bean10130
     setReservedCacheNodesOfferingId
     (clojure.core/str v10132)))
   (clojure.core/when-let
    [v10132 (:cache-node-count m10131)]
    (. bean10130 setCacheNodeCount (clojure.core/int v10132)))
   (clojure.core/when-let
    [v10132 (:reserved-cache-node-id m10131)]
    (. bean10130 setReservedCacheNodeId (clojure.core/str v10132)))
   bean10130))
 (clojure.core/defn
  ^com.amazonaws.services.elasticache.model.RebootCacheClusterRequest reboot-cache-cluster-request
  [m10134]
  (clojure.core/let
   [bean10133
    (new
     com.amazonaws.services.elasticache.model.RebootCacheClusterRequest)]
   (clojure.core/when-let
    [v10135 (:cache-cluster-id m10134)]
    (. bean10133 setCacheClusterId (clojure.core/str v10135)))
   (clojure.core/when-let
    [v10135 (:cache-node-ids-to-reboot m10134)]
    (.
     bean10133
     setCacheNodeIdsToReboot
     (clojure.core/map
      (clojure.core/fn [arg10139] (clojure.core/str arg10139))
      v10135)))
   bean10133))
 (clojure.core/defn
  ^com.amazonaws.services.elasticache.model.CreateCacheClusterRequest create-cache-cluster-request
  [m10137]
  (clojure.core/let
   [bean10136
    (new
     com.amazonaws.services.elasticache.model.CreateCacheClusterRequest)]
   (clojure.core/when-let
    [v10138 (:replication-group-id m10137)]
    (. bean10136 setReplicationGroupId (clojure.core/str v10138)))
   (clojure.core/when-let
    [v10138 (:cache-node-type m10137)]
    (. bean10136 setCacheNodeType (clojure.core/str v10138)))
   (clojure.core/when-let
    [v10138 (:cache-cluster-id m10137)]
    (. bean10136 setCacheClusterId (clojure.core/str v10138)))
   (clojure.core/when-let
    [v10138 (:num-cache-nodes m10137)]
    (. bean10136 setNumCacheNodes (clojure.core/int v10138)))
   (clojure.core/when-let
    [v10138 (:cache-security-group-names m10137)]
    (.
     bean10136
     setCacheSecurityGroupNames
     (clojure.core/map
      (clojure.core/fn [arg10143] (clojure.core/str arg10143))
      v10138)))
   (clojure.core/when-let
    [v10138 (:notification-topic-arn m10137)]
    (. bean10136 setNotificationTopicArn (clojure.core/str v10138)))
   (clojure.core/when-let
    [v10138 (:cache-parameter-group-name m10137)]
    (. bean10136 setCacheParameterGroupName (clojure.core/str v10138)))
   (clojure.core/when-let
    [v10138 (:engine m10137)]
    (. bean10136 setEngine (clojure.core/str v10138)))
   (clojure.core/when-let
    [v10138 (:engine-version m10137)]
    (. bean10136 setEngineVersion (clojure.core/str v10138)))
   (clojure.core/when-let
    [v10138 (:auto-minor-version-upgrade m10137)]
    (.
     bean10136
     setAutoMinorVersionUpgrade
     (clojure.core/boolean v10138)))
   (clojure.core/when-let
    [v10138 (:security-group-ids m10137)]
    (.
     bean10136
     setSecurityGroupIds
     (clojure.core/map
      (clojure.core/fn [arg10144] (clojure.core/str arg10144))
      v10138)))
   (clojure.core/when-let
    [v10138 (:preferred-maintenance-window m10137)]
    (.
     bean10136
     setPreferredMaintenanceWindow
     (clojure.core/str v10138)))
   (clojure.core/when-let
    [v10138 (:preferred-availability-zone m10137)]
    (.
     bean10136
     setPreferredAvailabilityZone
     (clojure.core/str v10138)))
   (clojure.core/when-let
    [v10138 (:cache-subnet-group-name m10137)]
    (. bean10136 setCacheSubnetGroupName (clojure.core/str v10138)))
   (clojure.core/when-let
    [v10138 (:snapshot-arns m10137)]
    (.
     bean10136
     setSnapshotArns
     (clojure.core/map
      (clojure.core/fn [arg10145] (clojure.core/str arg10145))
      v10138)))
   (clojure.core/when-let
    [v10138 (:port m10137)]
    (. bean10136 setPort (clojure.core/int v10138)))
   bean10136))
 (clojure.core/defn
  ^com.amazonaws.services.elasticache.model.DescribeReservedCacheNodesOfferingsRequest describe-reserved-cache-nodes-offerings-request
  [m10141]
  (clojure.core/let
   [bean10140
    (new
     com.amazonaws.services.elasticache.model.DescribeReservedCacheNodesOfferingsRequest)]
   (clojure.core/when-let
    [v10142 (:reserved-cache-nodes-offering-id m10141)]
    (.
     bean10140
     setReservedCacheNodesOfferingId
     (clojure.core/str v10142)))
   (clojure.core/when-let
    [v10142 (:cache-node-type m10141)]
    (. bean10140 setCacheNodeType (clojure.core/str v10142)))
   (clojure.core/when-let
    [v10142 (:marker m10141)]
    (. bean10140 setMarker (clojure.core/str v10142)))
   (clojure.core/when-let
    [v10142 (:product-description m10141)]
    (. bean10140 setProductDescription (clojure.core/str v10142)))
   (clojure.core/when-let
    [v10142 (:duration m10141)]
    (. bean10140 setDuration (clojure.core/str v10142)))
   (clojure.core/when-let
    [v10142 (:offering-type m10141)]
    (. bean10140 setOfferingType (clojure.core/str v10142)))
   (clojure.core/when-let
    [v10142 (:max-records m10141)]
    (. bean10140 setMaxRecords (clojure.core/int v10142)))
   bean10140))
 (clojure.core/defmulti
  elasticache
  (clojure.core/fn
   elasticache
   [m__1641__auto__]
   (:fn m__1641__auto__)))
 (do
  (clojure.core/defmethod
   elasticache
   :describe-cache-parameter-groups
   [m10146]
   (clojure.core/let
    [credentials10147 (:credentials m10146) args10148 (:args m10146)]
    (clojure.core/let
     [^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10149
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials10147)]
     (clojure.core/case
      (clojure.core/count args10148)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10149
        describeCacheParameterGroups
        (describe-cache-parameter-groups-request
         (clojure.core/nth args10148 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10149
        describeCacheParameterGroups))))))
  (clojure.core/defn
   describe-cache-parameter-groups-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         max-records
                         marker
                         cache-parameter-group-name]}]
                [credentials]]),
    :doc "Generate map for describeCacheParameterGroups, describeCacheParameterGroups"}
   ([credentials__1609__auto__]
    {:args [],
     :client :elasticache,
     :fn :describe-cache-parameter-groups,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :describe-cache-parameter-groups,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-cache-parameter-groups
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         max-records
                         marker
                         cache-parameter-group-name]}]
                [credentials]]),
    :doc "Call describeCacheParameterGroups, describeCacheParameterGroups"}
   [credentials10151 & args10152]
   (clojure.core/let
    [^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10153
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials10151)]
    (clojure.core/case
     (clojure.core/count args10152)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10153
       describeCacheParameterGroups
       (describe-cache-parameter-groups-request
        (clojure.core/nth args10152 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10153
       describeCacheParameterGroups))))))
 (do
  (clojure.core/defmethod
   elasticache
   :create-cache-parameter-group
   [m10154]
   (clojure.core/let
    [credentials10155 (:credentials m10154) args10156 (:args m10154)]
    (clojure.core/let
     [^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10157
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials10155)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10157
       createCacheParameterGroup
       (create-cache-parameter-group-request
        (clojure.core/nth args10156 0)))))))
  (clojure.core/defn
   create-cache-parameter-group-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         description
                         cache-parameter-group-name
                         cache-parameter-group-family]}]]),
    :doc "Generate map for createCacheParameterGroup"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :create-cache-parameter-group,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   create-cache-parameter-group
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         description
                         cache-parameter-group-name
                         cache-parameter-group-family]}]]),
    :doc "Call createCacheParameterGroup"}
   [credentials10159 & args10160]
   (clojure.core/let
    [^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10161
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials10159)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10161
      createCacheParameterGroup
      (create-cache-parameter-group-request
       (clojure.core/nth args10160 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :revoke-cache-security-group-ingress
   [m10162]
   (clojure.core/let
    [credentials10163 (:credentials m10162) args10164 (:args m10162)]
    (clojure.core/let
     [^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10165
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials10163)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10165
       revokeCacheSecurityGroupIngress
       (revoke-cache-security-group-ingress-request
        (clojure.core/nth args10164 0)))))))
  (clojure.core/defn
   revoke-cache-security-group-ingress-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         cache-security-group-name
                         ec2security-group-owner-id
                         ec2security-group-name]}]]),
    :doc "Generate map for revokeCacheSecurityGroupIngress"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :revoke-cache-security-group-ingress,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   revoke-cache-security-group-ingress
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         cache-security-group-name
                         ec2security-group-owner-id
                         ec2security-group-name]}]]),
    :doc "Call revokeCacheSecurityGroupIngress"}
   [credentials10167 & args10168]
   (clojure.core/let
    [^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10169
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials10167)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10169
      revokeCacheSecurityGroupIngress
      (revoke-cache-security-group-ingress-request
       (clojure.core/nth args10168 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :create-replication-group
   [m10170]
   (clojure.core/let
    [credentials10171 (:credentials m10170) args10172 (:args m10170)]
    (clojure.core/let
     [^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10173
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials10171)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10173
       createReplicationGroup
       (create-replication-group-request
        (clojure.core/nth args10172 0)))))))
  (clojure.core/defn
   create-replication-group-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         replication-group-id
                         replication-group-description
                         primary-cluster-id]}]]),
    :doc "Generate map for createReplicationGroup"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :create-replication-group,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   create-replication-group
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         replication-group-id
                         replication-group-description
                         primary-cluster-id]}]]),
    :doc "Call createReplicationGroup"}
   [credentials10175 & args10176]
   (clojure.core/let
    [^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10177
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials10175)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10177
      createReplicationGroup
      (create-replication-group-request
       (clojure.core/nth args10176 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :authorize-cache-security-group-ingress
   [m10178]
   (clojure.core/let
    [credentials10179 (:credentials m10178) args10180 (:args m10178)]
    (clojure.core/let
     [^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10181
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials10179)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10181
       authorizeCacheSecurityGroupIngress
       (authorize-cache-security-group-ingress-request
        (clojure.core/nth args10180 0)))))))
  (clojure.core/defn
   authorize-cache-security-group-ingress-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         cache-security-group-name
                         ec2security-group-owner-id
                         ec2security-group-name]}]]),
    :doc "Generate map for authorizeCacheSecurityGroupIngress"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :authorize-cache-security-group-ingress,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   authorize-cache-security-group-ingress
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         cache-security-group-name
                         ec2security-group-owner-id
                         ec2security-group-name]}]]),
    :doc "Call authorizeCacheSecurityGroupIngress"}
   [credentials10183 & args10184]
   (clojure.core/let
    [^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10185
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials10183)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10185
      authorizeCacheSecurityGroupIngress
      (authorize-cache-security-group-ingress-request
       (clojure.core/nth args10184 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :describe-reserved-cache-nodes
   [m10186]
   (clojure.core/let
    [credentials10187 (:credentials m10186) args10188 (:args m10186)]
    (clojure.core/let
     [^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10189
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials10187)]
     (clojure.core/case
      (clojure.core/count args10188)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10189
        describeReservedCacheNodes))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10189
        describeReservedCacheNodes
        (describe-reserved-cache-nodes-request
         (clojure.core/nth args10188 0))))))))
  (clojure.core/defn
   describe-reserved-cache-nodes-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [reserved-cache-node-id
                         duration
                         request-metric-collector
                         max-records
                         marker
                         product-description
                         offering-type
                         reserved-cache-nodes-offering-id
                         cache-node-type]}]]),
    :doc "Generate map for describeReservedCacheNodes, describeReservedCacheNodes"}
   ([credentials__1609__auto__]
    {:args [],
     :client :elasticache,
     :fn :describe-reserved-cache-nodes,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :describe-reserved-cache-nodes,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-reserved-cache-nodes
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [reserved-cache-node-id
                         duration
                         request-metric-collector
                         max-records
                         marker
                         product-description
                         offering-type
                         reserved-cache-nodes-offering-id
                         cache-node-type]}]]),
    :doc "Call describeReservedCacheNodes, describeReservedCacheNodes"}
   [credentials10191 & args10192]
   (clojure.core/let
    [^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10193
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials10191)]
    (clojure.core/case
     (clojure.core/count args10192)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10193
       describeReservedCacheNodes))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10193
       describeReservedCacheNodes
       (describe-reserved-cache-nodes-request
        (clojure.core/nth args10192 0))))))))
 (do
  (clojure.core/defmethod
   elasticache
   :modify-cache-cluster
   [m10194]
   (clojure.core/let
    [credentials10195 (:credentials m10194) args10196 (:args m10194)]
    (clojure.core/let
     [^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10197
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials10195)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10197
       modifyCacheCluster
       (modify-cache-cluster-request (clojure.core/nth args10196 0)))))))
  (clojure.core/defn
   modify-cache-cluster-map
   {:arglists (quote
               [[credentials
                 {:keys [notification-topic-status
                         request-metric-collector
                         cache-parameter-group-name
                         notification-topic-arn
                         cache-cluster-id
                         num-cache-nodes
                         preferred-maintenance-window
                         cache-node-ids-to-remove
                         cache-security-group-names
                         security-group-ids
                         apply-immediately
                         engine-version
                         auto-minor-version-upgrade]}]]),
    :doc "Generate map for modifyCacheCluster"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :modify-cache-cluster,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   modify-cache-cluster
   {:arglists (quote
               [[credentials
                 {:keys [notification-topic-status
                         request-metric-collector
                         cache-parameter-group-name
                         notification-topic-arn
                         cache-cluster-id
                         num-cache-nodes
                         preferred-maintenance-window
                         cache-node-ids-to-remove
                         cache-security-group-names
                         security-group-ids
                         apply-immediately
                         engine-version
                         auto-minor-version-upgrade]}]]),
    :doc "Call modifyCacheCluster"}
   [credentials10199 & args10200]
   (clojure.core/let
    [^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10201
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials10199)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10201
      modifyCacheCluster
      (modify-cache-cluster-request (clojure.core/nth args10200 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :delete-cache-subnet-group
   [m10202]
   (clojure.core/let
    [credentials10203 (:credentials m10202) args10204 (:args m10202)]
    (clojure.core/let
     [^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10205
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials10203)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10205
       deleteCacheSubnetGroup
       (delete-cache-subnet-group-request
        (clojure.core/nth args10204 0)))))))
  (clojure.core/defn
   delete-cache-subnet-group-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         cache-subnet-group-name]}]]),
    :doc "Generate map for deleteCacheSubnetGroup"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :delete-cache-subnet-group,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   delete-cache-subnet-group
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         cache-subnet-group-name]}]]),
    :doc "Call deleteCacheSubnetGroup"}
   [credentials10207 & args10208]
   (clojure.core/let
    [^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10209
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials10207)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10209
      deleteCacheSubnetGroup
      (delete-cache-subnet-group-request
       (clojure.core/nth args10208 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :describe-cache-engine-versions
   [m10210]
   (clojure.core/let
    [credentials10211 (:credentials m10210) args10212 (:args m10210)]
    (clojure.core/let
     [^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10213
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials10211)]
     (clojure.core/case
      (clojure.core/count args10212)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10213
        describeCacheEngineVersions))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10213
        describeCacheEngineVersions
        (describe-cache-engine-versions-request
         (clojure.core/nth args10212 0))))))))
  (clojure.core/defn
   describe-cache-engine-versions-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [cache-parameter-group-family
                         marker
                         max-records
                         default-only
                         engine-version
                         engine
                         request-metric-collector]}]]),
    :doc "Generate map for describeCacheEngineVersions, describeCacheEngineVersions"}
   ([credentials__1609__auto__]
    {:args [],
     :client :elasticache,
     :fn :describe-cache-engine-versions,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :describe-cache-engine-versions,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-cache-engine-versions
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [cache-parameter-group-family
                         marker
                         max-records
                         default-only
                         engine-version
                         engine
                         request-metric-collector]}]]),
    :doc "Call describeCacheEngineVersions, describeCacheEngineVersions"}
   [credentials10215 & args10216]
   (clojure.core/let
    [^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10217
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials10215)]
    (clojure.core/case
     (clojure.core/count args10216)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10217
       describeCacheEngineVersions))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10217
       describeCacheEngineVersions
       (describe-cache-engine-versions-request
        (clojure.core/nth args10216 0))))))))
 (do
  (clojure.core/defmethod
   elasticache
   :reset-cache-parameter-group
   [m10218]
   (clojure.core/let
    [credentials10219 (:credentials m10218) args10220 (:args m10218)]
    (clojure.core/let
     [^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10221
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials10219)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10221
       resetCacheParameterGroup
       (reset-cache-parameter-group-request
        (clojure.core/nth args10220 0)))))))
  (clojure.core/defn
   reset-cache-parameter-group-map
   {:arglists (quote
               [[credentials
                 {:keys [reset-all-parameters
                         request-metric-collector
                         parameter-name-values
                         cache-parameter-group-name]}]]),
    :doc "Generate map for resetCacheParameterGroup"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :reset-cache-parameter-group,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   reset-cache-parameter-group
   {:arglists (quote
               [[credentials
                 {:keys [reset-all-parameters
                         request-metric-collector
                         parameter-name-values
                         cache-parameter-group-name]}]]),
    :doc "Call resetCacheParameterGroup"}
   [credentials10223 & args10224]
   (clojure.core/let
    [^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10225
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials10223)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10225
      resetCacheParameterGroup
      (reset-cache-parameter-group-request
       (clojure.core/nth args10224 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :describe-engine-default-parameters
   [m10226]
   (clojure.core/let
    [credentials10227 (:credentials m10226) args10228 (:args m10226)]
    (clojure.core/let
     [^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10229
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials10227)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10229
       describeEngineDefaultParameters
       (describe-engine-default-parameters-request
        (clojure.core/nth args10228 0)))))))
  (clojure.core/defn
   describe-engine-default-parameters-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         max-records
                         marker
                         cache-parameter-group-family]}]]),
    :doc "Generate map for describeEngineDefaultParameters"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :describe-engine-default-parameters,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-engine-default-parameters
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         max-records
                         marker
                         cache-parameter-group-family]}]]),
    :doc "Call describeEngineDefaultParameters"}
   [credentials10231 & args10232]
   (clojure.core/let
    [^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10233
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials10231)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10233
      describeEngineDefaultParameters
      (describe-engine-default-parameters-request
       (clojure.core/nth args10232 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :delete-cache-cluster
   [m10234]
   (clojure.core/let
    [credentials10235 (:credentials m10234) args10236 (:args m10234)]
    (clojure.core/let
     [^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10237
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials10235)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10237
       deleteCacheCluster
       (delete-cache-cluster-request (clojure.core/nth args10236 0)))))))
  (clojure.core/defn
   delete-cache-cluster-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector cache-cluster-id]}]]),
    :doc "Generate map for deleteCacheCluster"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :delete-cache-cluster,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   delete-cache-cluster
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector cache-cluster-id]}]]),
    :doc "Call deleteCacheCluster"}
   [credentials10239 & args10240]
   (clojure.core/let
    [^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10241
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials10239)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10241
      deleteCacheCluster
      (delete-cache-cluster-request (clojure.core/nth args10240 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :describe-cache-subnet-groups
   [m10242]
   (clojure.core/let
    [credentials10243 (:credentials m10242) args10244 (:args m10242)]
    (clojure.core/let
     [^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10245
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials10243)]
     (clojure.core/case
      (clojure.core/count args10244)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10245
        describeCacheSubnetGroups
        (describe-cache-subnet-groups-request
         (clojure.core/nth args10244 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10245
        describeCacheSubnetGroups))))))
  (clojure.core/defn
   describe-cache-subnet-groups-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         max-records
                         marker
                         cache-subnet-group-name]}]
                [credentials]]),
    :doc "Generate map for describeCacheSubnetGroups, describeCacheSubnetGroups"}
   ([credentials__1609__auto__]
    {:args [],
     :client :elasticache,
     :fn :describe-cache-subnet-groups,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :describe-cache-subnet-groups,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-cache-subnet-groups
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         max-records
                         marker
                         cache-subnet-group-name]}]
                [credentials]]),
    :doc "Call describeCacheSubnetGroups, describeCacheSubnetGroups"}
   [credentials10247 & args10248]
   (clojure.core/let
    [^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10249
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials10247)]
    (clojure.core/case
     (clojure.core/count args10248)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10249
       describeCacheSubnetGroups
       (describe-cache-subnet-groups-request
        (clojure.core/nth args10248 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10249
       describeCacheSubnetGroups))))))
 (do
  (clojure.core/defmethod
   elasticache
   :describe-replication-groups
   [m10250]
   (clojure.core/let
    [credentials10251 (:credentials m10250) args10252 (:args m10250)]
    (clojure.core/let
     [^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10253
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials10251)]
     (clojure.core/case
      (clojure.core/count args10252)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10253
        describeReplicationGroups
        (describe-replication-groups-request
         (clojure.core/nth args10252 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10253
        describeReplicationGroups))))))
  (clojure.core/defn
   describe-replication-groups-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         replication-group-id
                         max-records
                         marker]}]
                [credentials]]),
    :doc "Generate map for describeReplicationGroups, describeReplicationGroups"}
   ([credentials__1609__auto__]
    {:args [],
     :client :elasticache,
     :fn :describe-replication-groups,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :describe-replication-groups,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-replication-groups
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         replication-group-id
                         max-records
                         marker]}]
                [credentials]]),
    :doc "Call describeReplicationGroups, describeReplicationGroups"}
   [credentials10255 & args10256]
   (clojure.core/let
    [^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10257
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials10255)]
    (clojure.core/case
     (clojure.core/count args10256)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10257
       describeReplicationGroups
       (describe-replication-groups-request
        (clojure.core/nth args10256 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10257
       describeReplicationGroups))))))
 (do
  (clojure.core/defmethod
   elasticache
   :describe-cache-security-groups
   [m10258]
   (clojure.core/let
    [credentials10259 (:credentials m10258) args10260 (:args m10258)]
    (clojure.core/let
     [^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10261
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials10259)]
     (clojure.core/case
      (clojure.core/count args10260)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10261
        describeCacheSecurityGroups
        (describe-cache-security-groups-request
         (clojure.core/nth args10260 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10261
        describeCacheSecurityGroups))))))
  (clojure.core/defn
   describe-cache-security-groups-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         max-records
                         marker
                         cache-security-group-name]}]
                [credentials]]),
    :doc "Generate map for describeCacheSecurityGroups, describeCacheSecurityGroups"}
   ([credentials__1609__auto__]
    {:args [],
     :client :elasticache,
     :fn :describe-cache-security-groups,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :describe-cache-security-groups,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-cache-security-groups
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         max-records
                         marker
                         cache-security-group-name]}]
                [credentials]]),
    :doc "Call describeCacheSecurityGroups, describeCacheSecurityGroups"}
   [credentials10263 & args10264]
   (clojure.core/let
    [^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10265
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials10263)]
    (clojure.core/case
     (clojure.core/count args10264)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10265
       describeCacheSecurityGroups
       (describe-cache-security-groups-request
        (clojure.core/nth args10264 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10265
       describeCacheSecurityGroups))))))
 (do
  (clojure.core/defmethod
   elasticache
   :create-cache-security-group
   [m10266]
   (clojure.core/let
    [credentials10267 (:credentials m10266) args10268 (:args m10266)]
    (clojure.core/let
     [^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10269
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials10267)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10269
       createCacheSecurityGroup
       (create-cache-security-group-request
        (clojure.core/nth args10268 0)))))))
  (clojure.core/defn
   create-cache-security-group-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         description
                         cache-security-group-name]}]]),
    :doc "Generate map for createCacheSecurityGroup"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :create-cache-security-group,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   create-cache-security-group
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         description
                         cache-security-group-name]}]]),
    :doc "Call createCacheSecurityGroup"}
   [credentials10271 & args10272]
   (clojure.core/let
    [^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10273
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials10271)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10273
      createCacheSecurityGroup
      (create-cache-security-group-request
       (clojure.core/nth args10272 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :describe-cache-clusters
   [m10274]
   (clojure.core/let
    [credentials10275 (:credentials m10274) args10276 (:args m10274)]
    (clojure.core/let
     [^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10277
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials10275)]
     (clojure.core/case
      (clojure.core/count args10276)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10277
        describeCacheClusters))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10277
        describeCacheClusters
        (describe-cache-clusters-request
         (clojure.core/nth args10276 0))))))))
  (clojure.core/defn
   describe-cache-clusters-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [show-cache-node-info
                         request-metric-collector
                         max-records
                         marker
                         cache-cluster-id]}]]),
    :doc "Generate map for describeCacheClusters, describeCacheClusters"}
   ([credentials__1609__auto__]
    {:args [],
     :client :elasticache,
     :fn :describe-cache-clusters,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :describe-cache-clusters,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-cache-clusters
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [show-cache-node-info
                         request-metric-collector
                         max-records
                         marker
                         cache-cluster-id]}]]),
    :doc "Call describeCacheClusters, describeCacheClusters"}
   [credentials10279 & args10280]
   (clojure.core/let
    [^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10281
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials10279)]
    (clojure.core/case
     (clojure.core/count args10280)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10281
       describeCacheClusters))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10281
       describeCacheClusters
       (describe-cache-clusters-request
        (clojure.core/nth args10280 0))))))))
 (do
  (clojure.core/defmethod
   elasticache
   :describe-events
   [m10282]
   (clojure.core/let
    [credentials10283 (:credentials m10282) args10284 (:args m10282)]
    (clojure.core/let
     [^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10285
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials10283)]
     (clojure.core/case
      (clojure.core/count args10284)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10285
        describeEvents))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10285
        describeEvents
        (describe-events-request (clojure.core/nth args10284 0))))))))
  (clojure.core/defn
   describe-events-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [end-time
                         source-type
                         duration
                         request-metric-collector
                         max-records
                         start-time
                         marker
                         source-identifier]}]]),
    :doc "Generate map for describeEvents, describeEvents"}
   ([credentials__1609__auto__]
    {:args [],
     :client :elasticache,
     :fn :describe-events,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :describe-events,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-events
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [end-time
                         source-type
                         duration
                         request-metric-collector
                         max-records
                         start-time
                         marker
                         source-identifier]}]]),
    :doc "Call describeEvents, describeEvents"}
   [credentials10287 & args10288]
   (clojure.core/let
    [^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10289
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials10287)]
    (clojure.core/case
     (clojure.core/count args10288)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10289
       describeEvents))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10289
       describeEvents
       (describe-events-request (clojure.core/nth args10288 0))))))))
 (do
  (clojure.core/defmethod
   elasticache
   :modify-cache-parameter-group
   [m10290]
   (clojure.core/let
    [credentials10291 (:credentials m10290) args10292 (:args m10290)]
    (clojure.core/let
     [^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10293
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials10291)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10293
       modifyCacheParameterGroup
       (modify-cache-parameter-group-request
        (clojure.core/nth args10292 0)))))))
  (clojure.core/defn
   modify-cache-parameter-group-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         parameter-name-values
                         cache-parameter-group-name]}]]),
    :doc "Generate map for modifyCacheParameterGroup"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :modify-cache-parameter-group,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   modify-cache-parameter-group
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         parameter-name-values
                         cache-parameter-group-name]}]]),
    :doc "Call modifyCacheParameterGroup"}
   [credentials10295 & args10296]
   (clojure.core/let
    [^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10297
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials10295)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10297
      modifyCacheParameterGroup
      (modify-cache-parameter-group-request
       (clojure.core/nth args10296 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :delete-cache-security-group
   [m10298]
   (clojure.core/let
    [credentials10299 (:credentials m10298) args10300 (:args m10298)]
    (clojure.core/let
     [^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10301
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials10299)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10301
       deleteCacheSecurityGroup
       (delete-cache-security-group-request
        (clojure.core/nth args10300 0)))))))
  (clojure.core/defn
   delete-cache-security-group-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         cache-security-group-name]}]]),
    :doc "Generate map for deleteCacheSecurityGroup"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :delete-cache-security-group,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   delete-cache-security-group
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         cache-security-group-name]}]]),
    :doc "Call deleteCacheSecurityGroup"}
   [credentials10303 & args10304]
   (clojure.core/let
    [^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10305
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials10303)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10305
      deleteCacheSecurityGroup
      (delete-cache-security-group-request
       (clojure.core/nth args10304 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :create-cache-subnet-group
   [m10306]
   (clojure.core/let
    [credentials10307 (:credentials m10306) args10308 (:args m10306)]
    (clojure.core/let
     [^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10309
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials10307)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10309
       createCacheSubnetGroup
       (create-cache-subnet-group-request
        (clojure.core/nth args10308 0)))))))
  (clojure.core/defn
   create-cache-subnet-group-map
   {:arglists (quote
               [[credentials
                 {:keys [subnet-ids
                         request-metric-collector
                         cache-subnet-group-name
                         cache-subnet-group-description]}]]),
    :doc "Generate map for createCacheSubnetGroup"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :create-cache-subnet-group,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   create-cache-subnet-group
   {:arglists (quote
               [[credentials
                 {:keys [subnet-ids
                         request-metric-collector
                         cache-subnet-group-name
                         cache-subnet-group-description]}]]),
    :doc "Call createCacheSubnetGroup"}
   [credentials10311 & args10312]
   (clojure.core/let
    [^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10313
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials10311)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10313
      createCacheSubnetGroup
      (create-cache-subnet-group-request
       (clojure.core/nth args10312 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :modify-replication-group
   [m10314]
   (clojure.core/let
    [credentials10315 (:credentials m10314) args10316 (:args m10314)]
    (clojure.core/let
     [^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10317
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials10315)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10317
       modifyReplicationGroup
       (modify-replication-group-request
        (clojure.core/nth args10316 0)))))))
  (clojure.core/defn
   modify-replication-group-map
   {:arglists (quote
               [[credentials
                 {:keys [notification-topic-status
                         request-metric-collector
                         cache-parameter-group-name
                         notification-topic-arn
                         primary-cluster-id
                         preferred-maintenance-window
                         replication-group-id
                         cache-security-group-names
                         replication-group-description
                         security-group-ids
                         apply-immediately
                         engine-version
                         auto-minor-version-upgrade]}]]),
    :doc "Generate map for modifyReplicationGroup"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :modify-replication-group,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   modify-replication-group
   {:arglists (quote
               [[credentials
                 {:keys [notification-topic-status
                         request-metric-collector
                         cache-parameter-group-name
                         notification-topic-arn
                         primary-cluster-id
                         preferred-maintenance-window
                         replication-group-id
                         cache-security-group-names
                         replication-group-description
                         security-group-ids
                         apply-immediately
                         engine-version
                         auto-minor-version-upgrade]}]]),
    :doc "Call modifyReplicationGroup"}
   [credentials10319 & args10320]
   (clojure.core/let
    [^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10321
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials10319)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10321
      modifyReplicationGroup
      (modify-replication-group-request
       (clojure.core/nth args10320 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :modify-cache-subnet-group
   [m10322]
   (clojure.core/let
    [credentials10323 (:credentials m10322) args10324 (:args m10322)]
    (clojure.core/let
     [^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10325
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials10323)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10325
       modifyCacheSubnetGroup
       (modify-cache-subnet-group-request
        (clojure.core/nth args10324 0)))))))
  (clojure.core/defn
   modify-cache-subnet-group-map
   {:arglists (quote
               [[credentials
                 {:keys [subnet-ids
                         request-metric-collector
                         cache-subnet-group-name
                         cache-subnet-group-description]}]]),
    :doc "Generate map for modifyCacheSubnetGroup"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :modify-cache-subnet-group,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   modify-cache-subnet-group
   {:arglists (quote
               [[credentials
                 {:keys [subnet-ids
                         request-metric-collector
                         cache-subnet-group-name
                         cache-subnet-group-description]}]]),
    :doc "Call modifyCacheSubnetGroup"}
   [credentials10327 & args10328]
   (clojure.core/let
    [^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10329
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials10327)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10329
      modifyCacheSubnetGroup
      (modify-cache-subnet-group-request
       (clojure.core/nth args10328 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :describe-cache-parameters
   [m10330]
   (clojure.core/let
    [credentials10331 (:credentials m10330) args10332 (:args m10330)]
    (clojure.core/let
     [^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10333
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials10331)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10333
       describeCacheParameters
       (describe-cache-parameters-request
        (clojure.core/nth args10332 0)))))))
  (clojure.core/defn
   describe-cache-parameters-map
   {:arglists (quote
               [[credentials
                 {:keys [source
                         request-metric-collector
                         max-records
                         marker
                         cache-parameter-group-name]}]]),
    :doc "Generate map for describeCacheParameters"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :describe-cache-parameters,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-cache-parameters
   {:arglists (quote
               [[credentials
                 {:keys [source
                         request-metric-collector
                         max-records
                         marker
                         cache-parameter-group-name]}]]),
    :doc "Call describeCacheParameters"}
   [credentials10335 & args10336]
   (clojure.core/let
    [^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10337
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials10335)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10337
      describeCacheParameters
      (describe-cache-parameters-request
       (clojure.core/nth args10336 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :delete-cache-parameter-group
   [m10338]
   (clojure.core/let
    [credentials10339 (:credentials m10338) args10340 (:args m10338)]
    (clojure.core/let
     [^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10341
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials10339)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10341
       deleteCacheParameterGroup
       (delete-cache-parameter-group-request
        (clojure.core/nth args10340 0)))))))
  (clojure.core/defn
   delete-cache-parameter-group-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         cache-parameter-group-name]}]]),
    :doc "Generate map for deleteCacheParameterGroup"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :delete-cache-parameter-group,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   delete-cache-parameter-group
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         cache-parameter-group-name]}]]),
    :doc "Call deleteCacheParameterGroup"}
   [credentials10343 & args10344]
   (clojure.core/let
    [^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10345
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials10343)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10345
      deleteCacheParameterGroup
      (delete-cache-parameter-group-request
       (clojure.core/nth args10344 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :delete-replication-group
   [m10346]
   (clojure.core/let
    [credentials10347 (:credentials m10346) args10348 (:args m10346)]
    (clojure.core/let
     [^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10349
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials10347)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10349
       deleteReplicationGroup
       (delete-replication-group-request
        (clojure.core/nth args10348 0)))))))
  (clojure.core/defn
   delete-replication-group-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         replication-group-id]}]]),
    :doc "Generate map for deleteReplicationGroup"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :delete-replication-group,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   delete-replication-group
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         replication-group-id]}]]),
    :doc "Call deleteReplicationGroup"}
   [credentials10351 & args10352]
   (clojure.core/let
    [^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10353
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials10351)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10353
      deleteReplicationGroup
      (delete-replication-group-request
       (clojure.core/nth args10352 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :purchase-reserved-cache-nodes-offering
   [m10354]
   (clojure.core/let
    [credentials10355 (:credentials m10354) args10356 (:args m10354)]
    (clojure.core/let
     [^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10357
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials10355)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10357
       purchaseReservedCacheNodesOffering
       (purchase-reserved-cache-nodes-offering-request
        (clojure.core/nth args10356 0)))))))
  (clojure.core/defn
   purchase-reserved-cache-nodes-offering-map
   {:arglists (quote
               [[credentials
                 {:keys [reserved-cache-nodes-offering-id
                         reserved-cache-node-id
                         request-metric-collector
                         cache-node-count]}]]),
    :doc "Generate map for purchaseReservedCacheNodesOffering"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :purchase-reserved-cache-nodes-offering,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   purchase-reserved-cache-nodes-offering
   {:arglists (quote
               [[credentials
                 {:keys [reserved-cache-nodes-offering-id
                         reserved-cache-node-id
                         request-metric-collector
                         cache-node-count]}]]),
    :doc "Call purchaseReservedCacheNodesOffering"}
   [credentials10359 & args10360]
   (clojure.core/let
    [^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10361
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials10359)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10361
      purchaseReservedCacheNodesOffering
      (purchase-reserved-cache-nodes-offering-request
       (clojure.core/nth args10360 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :reboot-cache-cluster
   [m10362]
   (clojure.core/let
    [credentials10363 (:credentials m10362) args10364 (:args m10362)]
    (clojure.core/let
     [^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10365
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials10363)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10365
       rebootCacheCluster
       (reboot-cache-cluster-request (clojure.core/nth args10364 0)))))))
  (clojure.core/defn
   reboot-cache-cluster-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         cache-node-ids-to-reboot
                         cache-cluster-id]}]]),
    :doc "Generate map for rebootCacheCluster"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :reboot-cache-cluster,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   reboot-cache-cluster
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         cache-node-ids-to-reboot
                         cache-cluster-id]}]]),
    :doc "Call rebootCacheCluster"}
   [credentials10367 & args10368]
   (clojure.core/let
    [^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10369
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials10367)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10369
      rebootCacheCluster
      (reboot-cache-cluster-request (clojure.core/nth args10368 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :create-cache-cluster
   [m10370]
   (clojure.core/let
    [credentials10371 (:credentials m10370) args10372 (:args m10370)]
    (clojure.core/let
     [^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10373
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials10371)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10373
       createCacheCluster
       (create-cache-cluster-request (clojure.core/nth args10372 0)))))))
  (clojure.core/defn
   create-cache-cluster-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         engine
                         cache-parameter-group-name
                         notification-topic-arn
                         cache-cluster-id
                         preferred-availability-zone
                         num-cache-nodes
                         preferred-maintenance-window
                         replication-group-id
                         cache-security-group-names
                         port
                         security-group-ids
                         snapshot-arns
                         engine-version
                         auto-minor-version-upgrade
                         cache-node-type
                         cache-subnet-group-name]}]]),
    :doc "Generate map for createCacheCluster"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :create-cache-cluster,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   create-cache-cluster
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         engine
                         cache-parameter-group-name
                         notification-topic-arn
                         cache-cluster-id
                         preferred-availability-zone
                         num-cache-nodes
                         preferred-maintenance-window
                         replication-group-id
                         cache-security-group-names
                         port
                         security-group-ids
                         snapshot-arns
                         engine-version
                         auto-minor-version-upgrade
                         cache-node-type
                         cache-subnet-group-name]}]]),
    :doc "Call createCacheCluster"}
   [credentials10375 & args10376]
   (clojure.core/let
    [^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10377
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials10375)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10377
      createCacheCluster
      (create-cache-cluster-request (clojure.core/nth args10376 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :describe-reserved-cache-nodes-offerings
   [m10378]
   (clojure.core/let
    [credentials10379 (:credentials m10378) args10380 (:args m10378)]
    (clojure.core/let
     [^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10381
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials10379)]
     (clojure.core/case
      (clojure.core/count args10380)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10381
        describeReservedCacheNodesOfferings))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10381
        describeReservedCacheNodesOfferings
        (describe-reserved-cache-nodes-offerings-request
         (clojure.core/nth args10380 0))))))))
  (clojure.core/defn
   describe-reserved-cache-nodes-offerings-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [duration
                         request-metric-collector
                         max-records
                         marker
                         product-description
                         offering-type
                         reserved-cache-nodes-offering-id
                         cache-node-type]}]]),
    :doc "Generate map for describeReservedCacheNodesOfferings, describeReservedCacheNodesOfferings"}
   ([credentials__1609__auto__]
    {:args [],
     :client :elasticache,
     :fn :describe-reserved-cache-nodes-offerings,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :describe-reserved-cache-nodes-offerings,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-reserved-cache-nodes-offerings
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [duration
                         request-metric-collector
                         max-records
                         marker
                         product-description
                         offering-type
                         reserved-cache-nodes-offering-id
                         cache-node-type]}]]),
    :doc "Call describeReservedCacheNodesOfferings, describeReservedCacheNodesOfferings"}
   [credentials10383 & args10384]
   (clojure.core/let
    [^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10385
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials10383)]
    (clojure.core/case
     (clojure.core/count args10384)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10385
       describeReservedCacheNodesOfferings))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticache.AmazonElastiCacheClient client10385
       describeReservedCacheNodesOfferings
       (describe-reserved-cache-nodes-offerings-request
        (clojure.core/nth args10384 0)))))))))
