(ns
 com.palletops.awaze.elasticbeanstalk
 (:require [com.palletops.awaze.common]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :elasticbeanstalk
  [___1561__auto__
   ^com.amazonaws.auth.BasicAWSCredentials credentials__1562__auto__]
  (new
   com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient
   credentials__1562__auto__))
 (clojure.core/defn
  ^com.amazonaws.services.elasticbeanstalk.model.OptionSpecification option-specification
  [m8571]
  (clojure.core/let
   [bean8570
    (new
     com.amazonaws.services.elasticbeanstalk.model.OptionSpecification)]
   (clojure.core/when-let
    [v8572 (:option-name m8571)]
    (. bean8570 setOptionName (clojure.core/str v8572)))
   (clojure.core/when-let
    [v8572 (:namespace m8571)]
    (. bean8570 setNamespace (clojure.core/str v8572)))
   bean8570))
 (clojure.core/defn
  ^com.amazonaws.services.elasticbeanstalk.model.ConfigurationOptionSetting configuration-option-setting
  [m8574]
  (clojure.core/let
   [bean8573
    (new
     com.amazonaws.services.elasticbeanstalk.model.ConfigurationOptionSetting)]
   (clojure.core/when-let
    [v8575 (:value m8574)]
    (. bean8573 setValue (clojure.core/str v8575)))
   (clojure.core/when-let
    [v8575 (:option-name m8574)]
    (. bean8573 setOptionName (clojure.core/str v8575)))
   (clojure.core/when-let
    [v8575 (:namespace m8574)]
    (. bean8573 setNamespace (clojure.core/str v8575)))
   bean8573))
 (clojure.core/defn
  ^com.amazonaws.services.elasticbeanstalk.model.S3Location s3location
  [m8577]
  (clojure.core/let
   [bean8576
    (new com.amazonaws.services.elasticbeanstalk.model.S3Location)]
   (clojure.core/when-let
    [v8578 (:s3key m8577)]
    (. bean8576 setS3Key (clojure.core/str v8578)))
   (clojure.core/when-let
    [v8578 (:s3bucket m8577)]
    (. bean8576 setS3Bucket (clojure.core/str v8578)))
   bean8576))
 (clojure.core/defn
  ^com.amazonaws.services.elasticbeanstalk.model.SourceConfiguration source-configuration
  [m8580]
  (clojure.core/let
   [bean8579
    (new
     com.amazonaws.services.elasticbeanstalk.model.SourceConfiguration)]
   (clojure.core/when-let
    [v8581 (:application-name m8580)]
    (. bean8579 setApplicationName (clojure.core/str v8581)))
   (clojure.core/when-let
    [v8581 (:template-name m8580)]
    (. bean8579 setTemplateName (clojure.core/str v8581)))
   bean8579))
 (clojure.core/defn
  ^com.amazonaws.services.elasticbeanstalk.model.EventSeverity event-severity
  [m8583]
  (java.lang.Enum/valueOf
   com.amazonaws.services.elasticbeanstalk.model.EventSeverity
   (clojure.core/name m8583)))
 (clojure.core/defn
  ^com.amazonaws.services.elasticbeanstalk.model.EnvironmentInfoType environment-info-type
  [m8586]
  (java.lang.Enum/valueOf
   com.amazonaws.services.elasticbeanstalk.model.EnvironmentInfoType
   (clojure.core/name m8586)))
 (clojure.core/defn
  ^com.amazonaws.services.elasticbeanstalk.model.CreateApplicationRequest create-application-request
  [m8589]
  (clojure.core/let
   [bean8588
    (new
     com.amazonaws.services.elasticbeanstalk.model.CreateApplicationRequest)]
   (clojure.core/when-let
    [v8590 (:description m8589)]
    (. bean8588 setDescription (clojure.core/str v8590)))
   (clojure.core/when-let
    [v8590 (:application-name m8589)]
    (. bean8588 setApplicationName (clojure.core/str v8590)))
   bean8588))
 (clojure.core/defn
  ^com.amazonaws.services.elasticbeanstalk.model.DeleteApplicationRequest delete-application-request
  [m8592]
  (clojure.core/let
   [bean8591
    (new
     com.amazonaws.services.elasticbeanstalk.model.DeleteApplicationRequest)]
   (clojure.core/when-let
    [v8593 (:application-name m8592)]
    (. bean8591 setApplicationName (clojure.core/str v8593)))
   bean8591))
 (clojure.core/defn
  ^com.amazonaws.services.elasticbeanstalk.model.CreateEnvironmentRequest create-environment-request
  [m8595]
  (clojure.core/let
   [bean8594
    (new
     com.amazonaws.services.elasticbeanstalk.model.CreateEnvironmentRequest)]
   (clojure.core/when-let
    [v8596 (:options-to-remove m8595)]
    (.
     bean8594
     setOptionsToRemove
     (clojure.core/map
      (clojure.core/fn [arg8600] (option-specification arg8600))
      v8596)))
   (clojure.core/when-let
    [v8596 (:option-settings m8595)]
    (.
     bean8594
     setOptionSettings
     (clojure.core/map
      (clojure.core/fn
       [arg8601]
       (configuration-option-setting arg8601))
      v8596)))
   (clojure.core/when-let
    [v8596 (:description m8595)]
    (. bean8594 setDescription (clojure.core/str v8596)))
   (clojure.core/when-let
    [v8596 (:application-name m8595)]
    (. bean8594 setApplicationName (clojure.core/str v8596)))
   (clojure.core/when-let
    [v8596 (:version-label m8595)]
    (. bean8594 setVersionLabel (clojure.core/str v8596)))
   (clojure.core/when-let
    [v8596 (:template-name m8595)]
    (. bean8594 setTemplateName (clojure.core/str v8596)))
   (clojure.core/when-let
    [v8596 (:environment-name m8595)]
    (. bean8594 setEnvironmentName (clojure.core/str v8596)))
   (clojure.core/when-let
    [v8596 (:cnameprefix m8595)]
    (. bean8594 setCNAMEPrefix (clojure.core/str v8596)))
   (clojure.core/when-let
    [v8596 (:solution-stack-name m8595)]
    (. bean8594 setSolutionStackName (clojure.core/str v8596)))
   bean8594))
 (clojure.core/defn
  ^com.amazonaws.services.elasticbeanstalk.model.DescribeConfigurationSettingsRequest describe-configuration-settings-request
  [m8598]
  (clojure.core/let
   [bean8597
    (new
     com.amazonaws.services.elasticbeanstalk.model.DescribeConfigurationSettingsRequest)]
   (clojure.core/when-let
    [v8599 (:application-name m8598)]
    (. bean8597 setApplicationName (clojure.core/str v8599)))
   (clojure.core/when-let
    [v8599 (:template-name m8598)]
    (. bean8597 setTemplateName (clojure.core/str v8599)))
   (clojure.core/when-let
    [v8599 (:environment-name m8598)]
    (. bean8597 setEnvironmentName (clojure.core/str v8599)))
   bean8597))
 (clojure.core/defn
  ^com.amazonaws.services.elasticbeanstalk.model.CreateStorageLocationRequest create-storage-location-request
  [m8603]
  (clojure.core/let
   [bean8602
    (new
     com.amazonaws.services.elasticbeanstalk.model.CreateStorageLocationRequest)]
   bean8602))
 (clojure.core/defn
  ^com.amazonaws.services.elasticbeanstalk.model.DescribeConfigurationOptionsRequest describe-configuration-options-request
  [m8606]
  (clojure.core/let
   [bean8605
    (new
     com.amazonaws.services.elasticbeanstalk.model.DescribeConfigurationOptionsRequest)]
   (clojure.core/when-let
    [v8607 (:options m8606)]
    (.
     bean8605
     setOptions
     (clojure.core/map
      (clojure.core/fn [arg8611] (option-specification arg8611))
      v8607)))
   (clojure.core/when-let
    [v8607 (:application-name m8606)]
    (. bean8605 setApplicationName (clojure.core/str v8607)))
   (clojure.core/when-let
    [v8607 (:template-name m8606)]
    (. bean8605 setTemplateName (clojure.core/str v8607)))
   (clojure.core/when-let
    [v8607 (:environment-name m8606)]
    (. bean8605 setEnvironmentName (clojure.core/str v8607)))
   (clojure.core/when-let
    [v8607 (:solution-stack-name m8606)]
    (. bean8605 setSolutionStackName (clojure.core/str v8607)))
   bean8605))
 (clojure.core/defn
  ^com.amazonaws.services.elasticbeanstalk.model.RebuildEnvironmentRequest rebuild-environment-request
  [m8609]
  (clojure.core/let
   [bean8608
    (new
     com.amazonaws.services.elasticbeanstalk.model.RebuildEnvironmentRequest)]
   (clojure.core/when-let
    [v8610 (:environment-id m8609)]
    (. bean8608 setEnvironmentId (clojure.core/str v8610)))
   (clojure.core/when-let
    [v8610 (:environment-name m8609)]
    (. bean8608 setEnvironmentName (clojure.core/str v8610)))
   bean8608))
 (clojure.core/defn
  ^com.amazonaws.services.elasticbeanstalk.model.CreateApplicationVersionRequest create-application-version-request
  [m8613]
  (clojure.core/let
   [bean8612
    (new
     com.amazonaws.services.elasticbeanstalk.model.CreateApplicationVersionRequest)]
   (clojure.core/when-let
    [v8614 (:description m8613)]
    (. bean8612 setDescription (clojure.core/str v8614)))
   (clojure.core/when-let
    [v8614 (:application-name m8613)]
    (. bean8612 setApplicationName (clojure.core/str v8614)))
   (clojure.core/when-let
    [v8614 (:version-label m8613)]
    (. bean8612 setVersionLabel (clojure.core/str v8614)))
   (clojure.core/when-let
    [v8614 (:source-bundle m8613)]
    (. bean8612 setSourceBundle (s3location v8614)))
   (clojure.core/when-let
    [v8614 (:auto-create-application m8613)]
    (. bean8612 setAutoCreateApplication (clojure.core/boolean v8614)))
   bean8612))
 (clojure.core/defn
  ^com.amazonaws.services.elasticbeanstalk.model.UpdateEnvironmentRequest update-environment-request
  [m8616]
  (clojure.core/let
   [bean8615
    (new
     com.amazonaws.services.elasticbeanstalk.model.UpdateEnvironmentRequest)]
   (clojure.core/when-let
    [v8617 (:options-to-remove m8616)]
    (.
     bean8615
     setOptionsToRemove
     (clojure.core/map
      (clojure.core/fn [arg8621] (option-specification arg8621))
      v8617)))
   (clojure.core/when-let
    [v8617 (:option-settings m8616)]
    (.
     bean8615
     setOptionSettings
     (clojure.core/map
      (clojure.core/fn
       [arg8622]
       (configuration-option-setting arg8622))
      v8617)))
   (clojure.core/when-let
    [v8617 (:description m8616)]
    (. bean8615 setDescription (clojure.core/str v8617)))
   (clojure.core/when-let
    [v8617 (:version-label m8616)]
    (. bean8615 setVersionLabel (clojure.core/str v8617)))
   (clojure.core/when-let
    [v8617 (:template-name m8616)]
    (. bean8615 setTemplateName (clojure.core/str v8617)))
   (clojure.core/when-let
    [v8617 (:environment-id m8616)]
    (. bean8615 setEnvironmentId (clojure.core/str v8617)))
   (clojure.core/when-let
    [v8617 (:environment-name m8616)]
    (. bean8615 setEnvironmentName (clojure.core/str v8617)))
   bean8615))
 (clojure.core/defn
  ^com.amazonaws.services.elasticbeanstalk.model.CreateConfigurationTemplateRequest create-configuration-template-request
  [m8619]
  (clojure.core/let
   [bean8618
    (new
     com.amazonaws.services.elasticbeanstalk.model.CreateConfigurationTemplateRequest)]
   (clojure.core/when-let
    [v8620 (:option-settings m8619)]
    (.
     bean8618
     setOptionSettings
     (clojure.core/map
      (clojure.core/fn
       [arg8626]
       (configuration-option-setting arg8626))
      v8620)))
   (clojure.core/when-let
    [v8620 (:description m8619)]
    (. bean8618 setDescription (clojure.core/str v8620)))
   (clojure.core/when-let
    [v8620 (:application-name m8619)]
    (. bean8618 setApplicationName (clojure.core/str v8620)))
   (clojure.core/when-let
    [v8620 (:template-name m8619)]
    (. bean8618 setTemplateName (clojure.core/str v8620)))
   (clojure.core/when-let
    [v8620 (:environment-id m8619)]
    (. bean8618 setEnvironmentId (clojure.core/str v8620)))
   (clojure.core/when-let
    [v8620 (:solution-stack-name m8619)]
    (. bean8618 setSolutionStackName (clojure.core/str v8620)))
   (clojure.core/when-let
    [v8620 (:source-configuration m8619)]
    (. bean8618 setSourceConfiguration (source-configuration v8620)))
   bean8618))
 (clojure.core/defn
  ^com.amazonaws.services.elasticbeanstalk.model.ValidateConfigurationSettingsRequest validate-configuration-settings-request
  [m8624]
  (clojure.core/let
   [bean8623
    (new
     com.amazonaws.services.elasticbeanstalk.model.ValidateConfigurationSettingsRequest)]
   (clojure.core/when-let
    [v8625 (:option-settings m8624)]
    (.
     bean8623
     setOptionSettings
     (clojure.core/map
      (clojure.core/fn
       [arg8630]
       (configuration-option-setting arg8630))
      v8625)))
   (clojure.core/when-let
    [v8625 (:application-name m8624)]
    (. bean8623 setApplicationName (clojure.core/str v8625)))
   (clojure.core/when-let
    [v8625 (:template-name m8624)]
    (. bean8623 setTemplateName (clojure.core/str v8625)))
   (clojure.core/when-let
    [v8625 (:environment-name m8624)]
    (. bean8623 setEnvironmentName (clojure.core/str v8625)))
   bean8623))
 (clojure.core/defn
  ^com.amazonaws.services.elasticbeanstalk.model.DescribeEventsRequest describe-events-request
  [m8628]
  (clojure.core/let
   [bean8627
    (new
     com.amazonaws.services.elasticbeanstalk.model.DescribeEventsRequest)]
   (clojure.core/when-let
    [v8629 (:request-id m8628)]
    (. bean8627 setRequestId (clojure.core/str v8629)))
   (clojure.core/when-let
    [v8629 (:next-token m8628)]
    (. bean8627 setNextToken (clojure.core/str v8629)))
   (clojure.core/when-let
    [v8629 (:start-time m8628)]
    (.
     bean8627
     setStartTime
     (com.palletops.awaze.common/to-date v8629)))
   (clojure.core/when-let
    [v8629 (:max-records m8628)]
    (. bean8627 setMaxRecords (clojure.core/int v8629)))
   (clojure.core/when-let
    [v8629 (:end-time m8628)]
    (. bean8627 setEndTime (com.palletops.awaze.common/to-date v8629)))
   (clojure.core/when-let
    [v8629 (:application-name m8628)]
    (. bean8627 setApplicationName (clojure.core/str v8629)))
   (clojure.core/when-let
    [v8629 (:version-label m8628)]
    (. bean8627 setVersionLabel (clojure.core/str v8629)))
   (clojure.core/when-let
    [v8629 (:template-name m8628)]
    (. bean8627 setTemplateName (clojure.core/str v8629)))
   (clojure.core/when-let
    [v8629 (:environment-id m8628)]
    (. bean8627 setEnvironmentId (clojure.core/str v8629)))
   (clojure.core/when-let
    [v8629 (:environment-name m8628)]
    (. bean8627 setEnvironmentName (clojure.core/str v8629)))
   (clojure.core/when-let
    [v8629 (:severity m8628)]
    (. bean8627 setSeverity (clojure.core/str v8629)))
   (clojure.core/when-let
    [v8629 (:severity m8628)]
    (. bean8627 setSeverity (event-severity v8629)))
   bean8627))
 (clojure.core/defn
  ^com.amazonaws.services.elasticbeanstalk.model.DescribeApplicationsRequest describe-applications-request
  [m8632]
  (clojure.core/let
   [bean8631
    (new
     com.amazonaws.services.elasticbeanstalk.model.DescribeApplicationsRequest)]
   (clojure.core/when-let
    [v8633 (:application-names m8632)]
    (.
     bean8631
     setApplicationNames
     (clojure.core/map
      (clojure.core/fn [arg8637] (clojure.core/str arg8637))
      v8633)))
   bean8631))
 (clojure.core/defn
  ^com.amazonaws.services.elasticbeanstalk.model.CheckDNSAvailabilityRequest check-dnsavailability-request
  [m8635]
  (clojure.core/let
   [bean8634
    (new
     com.amazonaws.services.elasticbeanstalk.model.CheckDNSAvailabilityRequest)]
   (clojure.core/when-let
    [v8636 (:cnameprefix m8635)]
    (. bean8634 setCNAMEPrefix (clojure.core/str v8636)))
   bean8634))
 (clojure.core/defn
  ^com.amazonaws.services.elasticbeanstalk.model.RestartAppServerRequest restart-app-server-request
  [m8639]
  (clojure.core/let
   [bean8638
    (new
     com.amazonaws.services.elasticbeanstalk.model.RestartAppServerRequest)]
   (clojure.core/when-let
    [v8640 (:environment-id m8639)]
    (. bean8638 setEnvironmentId (clojure.core/str v8640)))
   (clojure.core/when-let
    [v8640 (:environment-name m8639)]
    (. bean8638 setEnvironmentName (clojure.core/str v8640)))
   bean8638))
 (clojure.core/defn
  ^com.amazonaws.services.elasticbeanstalk.model.UpdateApplicationVersionRequest update-application-version-request
  [m8642]
  (clojure.core/let
   [bean8641
    (new
     com.amazonaws.services.elasticbeanstalk.model.UpdateApplicationVersionRequest)]
   (clojure.core/when-let
    [v8643 (:description m8642)]
    (. bean8641 setDescription (clojure.core/str v8643)))
   (clojure.core/when-let
    [v8643 (:application-name m8642)]
    (. bean8641 setApplicationName (clojure.core/str v8643)))
   (clojure.core/when-let
    [v8643 (:version-label m8642)]
    (. bean8641 setVersionLabel (clojure.core/str v8643)))
   bean8641))
 (clojure.core/defn
  ^com.amazonaws.services.elasticbeanstalk.model.DescribeEnvironmentResourcesRequest describe-environment-resources-request
  [m8645]
  (clojure.core/let
   [bean8644
    (new
     com.amazonaws.services.elasticbeanstalk.model.DescribeEnvironmentResourcesRequest)]
   (clojure.core/when-let
    [v8646 (:environment-id m8645)]
    (. bean8644 setEnvironmentId (clojure.core/str v8646)))
   (clojure.core/when-let
    [v8646 (:environment-name m8645)]
    (. bean8644 setEnvironmentName (clojure.core/str v8646)))
   bean8644))
 (clojure.core/defn
  ^com.amazonaws.services.elasticbeanstalk.model.DescribeEnvironmentsRequest describe-environments-request
  [m8648]
  (clojure.core/let
   [bean8647
    (new
     com.amazonaws.services.elasticbeanstalk.model.DescribeEnvironmentsRequest)]
   (clojure.core/when-let
    [v8649 (:application-name m8648)]
    (. bean8647 setApplicationName (clojure.core/str v8649)))
   (clojure.core/when-let
    [v8649 (:version-label m8648)]
    (. bean8647 setVersionLabel (clojure.core/str v8649)))
   (clojure.core/when-let
    [v8649 (:environment-ids m8648)]
    (.
     bean8647
     setEnvironmentIds
     (clojure.core/map
      (clojure.core/fn [arg8653] (clojure.core/str arg8653))
      v8649)))
   (clojure.core/when-let
    [v8649 (:environment-names m8648)]
    (.
     bean8647
     setEnvironmentNames
     (clojure.core/map
      (clojure.core/fn [arg8654] (clojure.core/str arg8654))
      v8649)))
   (clojure.core/when-let
    [v8649 (:include-deleted m8648)]
    (. bean8647 setIncludeDeleted (clojure.core/boolean v8649)))
   (clojure.core/when-let
    [v8649 (:included-deleted-back-to m8648)]
    (.
     bean8647
     setIncludedDeletedBackTo
     (com.palletops.awaze.common/to-date v8649)))
   bean8647))
 (clojure.core/defn
  ^com.amazonaws.services.elasticbeanstalk.model.DescribeApplicationVersionsRequest describe-application-versions-request
  [m8651]
  (clojure.core/let
   [bean8650
    (new
     com.amazonaws.services.elasticbeanstalk.model.DescribeApplicationVersionsRequest)]
   (clojure.core/when-let
    [v8652 (:application-name m8651)]
    (. bean8650 setApplicationName (clojure.core/str v8652)))
   (clojure.core/when-let
    [v8652 (:version-labels m8651)]
    (.
     bean8650
     setVersionLabels
     (clojure.core/map
      (clojure.core/fn [arg8658] (clojure.core/str arg8658))
      v8652)))
   bean8650))
 (clojure.core/defn
  ^com.amazonaws.services.elasticbeanstalk.model.DeleteApplicationVersionRequest delete-application-version-request
  [m8656]
  (clojure.core/let
   [bean8655
    (new
     com.amazonaws.services.elasticbeanstalk.model.DeleteApplicationVersionRequest)]
   (clojure.core/when-let
    [v8657 (:application-name m8656)]
    (. bean8655 setApplicationName (clojure.core/str v8657)))
   (clojure.core/when-let
    [v8657 (:version-label m8656)]
    (. bean8655 setVersionLabel (clojure.core/str v8657)))
   (clojure.core/when-let
    [v8657 (:delete-source-bundle m8656)]
    (. bean8655 setDeleteSourceBundle (clojure.core/boolean v8657)))
   bean8655))
 (clojure.core/defn
  ^com.amazonaws.services.elasticbeanstalk.model.SwapEnvironmentCNAMEsRequest swap-environment-cnames-request
  [m8660]
  (clojure.core/let
   [bean8659
    (new
     com.amazonaws.services.elasticbeanstalk.model.SwapEnvironmentCNAMEsRequest)]
   (clojure.core/when-let
    [v8661 (:source-environment-id m8660)]
    (. bean8659 setSourceEnvironmentId (clojure.core/str v8661)))
   (clojure.core/when-let
    [v8661 (:source-environment-name m8660)]
    (. bean8659 setSourceEnvironmentName (clojure.core/str v8661)))
   (clojure.core/when-let
    [v8661 (:destination-environment-id m8660)]
    (. bean8659 setDestinationEnvironmentId (clojure.core/str v8661)))
   (clojure.core/when-let
    [v8661 (:destination-environment-name m8660)]
    (.
     bean8659
     setDestinationEnvironmentName
     (clojure.core/str v8661)))
   bean8659))
 (clojure.core/defn
  ^com.amazonaws.services.elasticbeanstalk.model.DeleteConfigurationTemplateRequest delete-configuration-template-request
  [m8663]
  (clojure.core/let
   [bean8662
    (new
     com.amazonaws.services.elasticbeanstalk.model.DeleteConfigurationTemplateRequest)]
   (clojure.core/when-let
    [v8664 (:application-name m8663)]
    (. bean8662 setApplicationName (clojure.core/str v8664)))
   (clojure.core/when-let
    [v8664 (:template-name m8663)]
    (. bean8662 setTemplateName (clojure.core/str v8664)))
   bean8662))
 (clojure.core/defn
  ^com.amazonaws.services.elasticbeanstalk.model.UpdateApplicationRequest update-application-request
  [m8666]
  (clojure.core/let
   [bean8665
    (new
     com.amazonaws.services.elasticbeanstalk.model.UpdateApplicationRequest)]
   (clojure.core/when-let
    [v8667 (:description m8666)]
    (. bean8665 setDescription (clojure.core/str v8667)))
   (clojure.core/when-let
    [v8667 (:application-name m8666)]
    (. bean8665 setApplicationName (clojure.core/str v8667)))
   bean8665))
 (clojure.core/defn
  ^com.amazonaws.services.elasticbeanstalk.model.ListAvailableSolutionStacksRequest list-available-solution-stacks-request
  [m8669]
  (clojure.core/let
   [bean8668
    (new
     com.amazonaws.services.elasticbeanstalk.model.ListAvailableSolutionStacksRequest)]
   bean8668))
 (clojure.core/defn
  ^com.amazonaws.services.elasticbeanstalk.model.UpdateConfigurationTemplateRequest update-configuration-template-request
  [m8672]
  (clojure.core/let
   [bean8671
    (new
     com.amazonaws.services.elasticbeanstalk.model.UpdateConfigurationTemplateRequest)]
   (clojure.core/when-let
    [v8673 (:options-to-remove m8672)]
    (.
     bean8671
     setOptionsToRemove
     (clojure.core/map
      (clojure.core/fn [arg8677] (option-specification arg8677))
      v8673)))
   (clojure.core/when-let
    [v8673 (:option-settings m8672)]
    (.
     bean8671
     setOptionSettings
     (clojure.core/map
      (clojure.core/fn
       [arg8678]
       (configuration-option-setting arg8678))
      v8673)))
   (clojure.core/when-let
    [v8673 (:description m8672)]
    (. bean8671 setDescription (clojure.core/str v8673)))
   (clojure.core/when-let
    [v8673 (:application-name m8672)]
    (. bean8671 setApplicationName (clojure.core/str v8673)))
   (clojure.core/when-let
    [v8673 (:template-name m8672)]
    (. bean8671 setTemplateName (clojure.core/str v8673)))
   bean8671))
 (clojure.core/defn
  ^com.amazonaws.services.elasticbeanstalk.model.RequestEnvironmentInfoRequest request-environment-info-request
  [m8675]
  (clojure.core/let
   [bean8674
    (new
     com.amazonaws.services.elasticbeanstalk.model.RequestEnvironmentInfoRequest)]
   (clojure.core/when-let
    [v8676 (:environment-id m8675)]
    (. bean8674 setEnvironmentId (clojure.core/str v8676)))
   (clojure.core/when-let
    [v8676 (:environment-name m8675)]
    (. bean8674 setEnvironmentName (clojure.core/str v8676)))
   (clojure.core/when-let
    [v8676 (:info-type m8675)]
    (. bean8674 setInfoType (clojure.core/str v8676)))
   (clojure.core/when-let
    [v8676 (:info-type m8675)]
    (. bean8674 setInfoType (environment-info-type v8676)))
   bean8674))
 (clojure.core/defn
  ^com.amazonaws.services.elasticbeanstalk.model.DeleteEnvironmentConfigurationRequest delete-environment-configuration-request
  [m8680]
  (clojure.core/let
   [bean8679
    (new
     com.amazonaws.services.elasticbeanstalk.model.DeleteEnvironmentConfigurationRequest)]
   (clojure.core/when-let
    [v8681 (:application-name m8680)]
    (. bean8679 setApplicationName (clojure.core/str v8681)))
   (clojure.core/when-let
    [v8681 (:environment-name m8680)]
    (. bean8679 setEnvironmentName (clojure.core/str v8681)))
   bean8679))
 (clojure.core/defn
  ^com.amazonaws.services.elasticbeanstalk.model.TerminateEnvironmentRequest terminate-environment-request
  [m8683]
  (clojure.core/let
   [bean8682
    (new
     com.amazonaws.services.elasticbeanstalk.model.TerminateEnvironmentRequest)]
   (clojure.core/when-let
    [v8684 (:environment-id m8683)]
    (. bean8682 setEnvironmentId (clojure.core/str v8684)))
   (clojure.core/when-let
    [v8684 (:environment-name m8683)]
    (. bean8682 setEnvironmentName (clojure.core/str v8684)))
   (clojure.core/when-let
    [v8684 (:terminate-resources m8683)]
    (. bean8682 setTerminateResources (clojure.core/boolean v8684)))
   bean8682))
 (clojure.core/defn
  ^com.amazonaws.services.elasticbeanstalk.model.RetrieveEnvironmentInfoRequest retrieve-environment-info-request
  [m8686]
  (clojure.core/let
   [bean8685
    (new
     com.amazonaws.services.elasticbeanstalk.model.RetrieveEnvironmentInfoRequest)]
   (clojure.core/when-let
    [v8687 (:environment-id m8686)]
    (. bean8685 setEnvironmentId (clojure.core/str v8687)))
   (clojure.core/when-let
    [v8687 (:environment-name m8686)]
    (. bean8685 setEnvironmentName (clojure.core/str v8687)))
   (clojure.core/when-let
    [v8687 (:info-type m8686)]
    (. bean8685 setInfoType (clojure.core/str v8687)))
   (clojure.core/when-let
    [v8687 (:info-type m8686)]
    (. bean8685 setInfoType (environment-info-type v8687)))
   bean8685))
 (clojure.core/defmulti
  elasticbeanstalk
  (clojure.core/fn
   elasticbeanstalk
   [m__1641__auto__]
   (:fn m__1641__auto__)))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :create-application
   [m8688]
   (clojure.core/let
    [credentials8689 (:credentials m8688) args8690 (:args m8688)]
    (clojure.core/let
     [^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8691
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials8689)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8691
       createApplication
       (create-application-request (clojure.core/nth args8690 0)))))))
  (clojure.core/defn
   create-application-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         description
                         application-name]}]]),
    :doc "Generate map for createApplication"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :elasticbeanstalk,
     :fn :create-application,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   create-application
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         description
                         application-name]}]]),
    :doc "Call createApplication"}
   [credentials8693 & args8694]
   (clojure.core/let
    [^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8695
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials8693)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8695
      createApplication
      (create-application-request (clojure.core/nth args8694 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :delete-application
   [m8696]
   (clojure.core/let
    [credentials8697 (:credentials m8696) args8698 (:args m8696)]
    (clojure.core/let
     [^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8699
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials8697)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8699
       deleteApplication
       (delete-application-request (clojure.core/nth args8698 0)))))))
  (clojure.core/defn
   delete-application-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector application-name]}]]),
    :doc "Generate map for deleteApplication"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :elasticbeanstalk,
     :fn :delete-application,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   delete-application
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector application-name]}]]),
    :doc "Call deleteApplication"}
   [credentials8701 & args8702]
   (clojure.core/let
    [^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8703
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials8701)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8703
      deleteApplication
      (delete-application-request (clojure.core/nth args8702 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :create-environment
   [m8704]
   (clojure.core/let
    [credentials8705 (:credentials m8704) args8706 (:args m8704)]
    (clojure.core/let
     [^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8707
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials8705)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8707
       createEnvironment
       (create-environment-request (clojure.core/nth args8706 0)))))))
  (clojure.core/defn
   create-environment-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         option-settings
                         version-label
                         cnameprefix
                         application-name
                         solution-stack-name
                         environment-name
                         description
                         options-to-remove
                         template-name]}]]),
    :doc "Generate map for createEnvironment"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :elasticbeanstalk,
     :fn :create-environment,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   create-environment
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         option-settings
                         version-label
                         cnameprefix
                         application-name
                         solution-stack-name
                         environment-name
                         description
                         options-to-remove
                         template-name]}]]),
    :doc "Call createEnvironment"}
   [credentials8709 & args8710]
   (clojure.core/let
    [^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8711
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials8709)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8711
      createEnvironment
      (create-environment-request (clojure.core/nth args8710 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :describe-configuration-settings
   [m8712]
   (clojure.core/let
    [credentials8713 (:credentials m8712) args8714 (:args m8712)]
    (clojure.core/let
     [^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8715
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials8713)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8715
       describeConfigurationSettings
       (describe-configuration-settings-request
        (clojure.core/nth args8714 0)))))))
  (clojure.core/defn
   describe-configuration-settings-map
   {:arglists (quote
               [[credentials
                 {:keys [template-name
                         request-metric-collector
                         environment-name
                         application-name]}]]),
    :doc "Generate map for describeConfigurationSettings"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :elasticbeanstalk,
     :fn :describe-configuration-settings,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-configuration-settings
   {:arglists (quote
               [[credentials
                 {:keys [template-name
                         request-metric-collector
                         environment-name
                         application-name]}]]),
    :doc "Call describeConfigurationSettings"}
   [credentials8717 & args8718]
   (clojure.core/let
    [^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8719
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials8717)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8719
      describeConfigurationSettings
      (describe-configuration-settings-request
       (clojure.core/nth args8718 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :create-storage-location
   [m8720]
   (clojure.core/let
    [credentials8721 (:credentials m8720) args8722 (:args m8720)]
    (clojure.core/let
     [^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8723
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials8721)]
     (clojure.core/case
      (clojure.core/count args8722)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8723
        createStorageLocation
        (create-storage-location-request
         (clojure.core/nth args8722 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8723
        createStorageLocation))))))
  (clojure.core/defn
   create-storage-location-map
   {:arglists (quote
               [[credentials {:keys [request-metric-collector]}]
                [credentials]]),
    :doc "Generate map for createStorageLocation, createStorageLocation"}
   ([credentials__1609__auto__]
    {:args [],
     :client :elasticbeanstalk,
     :fn :create-storage-location,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :elasticbeanstalk,
     :fn :create-storage-location,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   create-storage-location
   {:arglists (quote
               [[credentials {:keys [request-metric-collector]}]
                [credentials]]),
    :doc "Call createStorageLocation, createStorageLocation"}
   [credentials8725 & args8726]
   (clojure.core/let
    [^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8727
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials8725)]
    (clojure.core/case
     (clojure.core/count args8726)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8727
       createStorageLocation
       (create-storage-location-request (clojure.core/nth args8726 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8727
       createStorageLocation))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :describe-configuration-options
   [m8728]
   (clojure.core/let
    [credentials8729 (:credentials m8728) args8730 (:args m8728)]
    (clojure.core/let
     [^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8731
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials8729)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8731
       describeConfigurationOptions
       (describe-configuration-options-request
        (clojure.core/nth args8730 0)))))))
  (clojure.core/defn
   describe-configuration-options-map
   {:arglists (quote
               [[credentials
                 {:keys [template-name
                         solution-stack-name
                         request-metric-collector
                         options
                         environment-name
                         application-name]}]]),
    :doc "Generate map for describeConfigurationOptions"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :elasticbeanstalk,
     :fn :describe-configuration-options,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-configuration-options
   {:arglists (quote
               [[credentials
                 {:keys [template-name
                         solution-stack-name
                         request-metric-collector
                         options
                         environment-name
                         application-name]}]]),
    :doc "Call describeConfigurationOptions"}
   [credentials8733 & args8734]
   (clojure.core/let
    [^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8735
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials8733)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8735
      describeConfigurationOptions
      (describe-configuration-options-request
       (clojure.core/nth args8734 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :rebuild-environment
   [m8736]
   (clojure.core/let
    [credentials8737 (:credentials m8736) args8738 (:args m8736)]
    (clojure.core/let
     [^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8739
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials8737)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8739
       rebuildEnvironment
       (rebuild-environment-request (clojure.core/nth args8738 0)))))))
  (clojure.core/defn
   rebuild-environment-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         environment-name
                         environment-id]}]]),
    :doc "Generate map for rebuildEnvironment"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :elasticbeanstalk,
     :fn :rebuild-environment,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   rebuild-environment
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         environment-name
                         environment-id]}]]),
    :doc "Call rebuildEnvironment"}
   [credentials8741 & args8742]
   (clojure.core/let
    [^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8743
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials8741)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8743
      rebuildEnvironment
      (rebuild-environment-request (clojure.core/nth args8742 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :create-application-version
   [m8744]
   (clojure.core/let
    [credentials8745 (:credentials m8744) args8746 (:args m8744)]
    (clojure.core/let
     [^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8747
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials8745)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8747
       createApplicationVersion
       (create-application-version-request
        (clojure.core/nth args8746 0)))))))
  (clojure.core/defn
   create-application-version-map
   {:arglists (quote
               [[credentials
                 {:keys [version-label
                         source-bundle
                         request-metric-collector
                         description
                         auto-create-application
                         application-name]}]]),
    :doc "Generate map for createApplicationVersion"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :elasticbeanstalk,
     :fn :create-application-version,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   create-application-version
   {:arglists (quote
               [[credentials
                 {:keys [version-label
                         source-bundle
                         request-metric-collector
                         description
                         auto-create-application
                         application-name]}]]),
    :doc "Call createApplicationVersion"}
   [credentials8749 & args8750]
   (clojure.core/let
    [^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8751
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials8749)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8751
      createApplicationVersion
      (create-application-version-request
       (clojure.core/nth args8750 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :update-environment
   [m8752]
   (clojure.core/let
    [credentials8753 (:credentials m8752) args8754 (:args m8752)]
    (clojure.core/let
     [^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8755
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials8753)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8755
       updateEnvironment
       (update-environment-request (clojure.core/nth args8754 0)))))))
  (clojure.core/defn
   update-environment-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         environment-id
                         option-settings
                         version-label
                         environment-name
                         description
                         options-to-remove
                         template-name]}]]),
    :doc "Generate map for updateEnvironment"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :elasticbeanstalk,
     :fn :update-environment,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   update-environment
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         environment-id
                         option-settings
                         version-label
                         environment-name
                         description
                         options-to-remove
                         template-name]}]]),
    :doc "Call updateEnvironment"}
   [credentials8757 & args8758]
   (clojure.core/let
    [^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8759
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials8757)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8759
      updateEnvironment
      (update-environment-request (clojure.core/nth args8758 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :create-configuration-template
   [m8760]
   (clojure.core/let
    [credentials8761 (:credentials m8760) args8762 (:args m8760)]
    (clojure.core/let
     [^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8763
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials8761)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8763
       createConfigurationTemplate
       (create-configuration-template-request
        (clojure.core/nth args8762 0)))))))
  (clojure.core/defn
   create-configuration-template-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         environment-id
                         option-settings
                         source-configuration
                         application-name
                         solution-stack-name
                         description
                         template-name]}]]),
    :doc "Generate map for createConfigurationTemplate"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :elasticbeanstalk,
     :fn :create-configuration-template,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   create-configuration-template
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         environment-id
                         option-settings
                         source-configuration
                         application-name
                         solution-stack-name
                         description
                         template-name]}]]),
    :doc "Call createConfigurationTemplate"}
   [credentials8765 & args8766]
   (clojure.core/let
    [^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8767
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials8765)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8767
      createConfigurationTemplate
      (create-configuration-template-request
       (clojure.core/nth args8766 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :validate-configuration-settings
   [m8768]
   (clojure.core/let
    [credentials8769 (:credentials m8768) args8770 (:args m8768)]
    (clojure.core/let
     [^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8771
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials8769)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8771
       validateConfigurationSettings
       (validate-configuration-settings-request
        (clojure.core/nth args8770 0)))))))
  (clojure.core/defn
   validate-configuration-settings-map
   {:arglists (quote
               [[credentials
                 {:keys [template-name
                         request-metric-collector
                         option-settings
                         environment-name
                         application-name]}]]),
    :doc "Generate map for validateConfigurationSettings"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :elasticbeanstalk,
     :fn :validate-configuration-settings,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   validate-configuration-settings
   {:arglists (quote
               [[credentials
                 {:keys [template-name
                         request-metric-collector
                         option-settings
                         environment-name
                         application-name]}]]),
    :doc "Call validateConfigurationSettings"}
   [credentials8773 & args8774]
   (clojure.core/let
    [^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8775
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials8773)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8775
      validateConfigurationSettings
      (validate-configuration-settings-request
       (clojure.core/nth args8774 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :describe-events
   [m8776]
   (clojure.core/let
    [credentials8777 (:credentials m8776) args8778 (:args m8776)]
    (clojure.core/let
     [^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8779
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials8777)]
     (clojure.core/case
      (clojure.core/count args8778)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8779
        describeEvents
        (describe-events-request (clojure.core/nth args8778 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8779
        describeEvents))))))
  (clojure.core/defn
   describe-events-map
   {:arglists (quote
               [[credentials
                 {:keys [end-time
                         request-metric-collector
                         environment-id
                         max-records
                         start-time
                         version-label
                         application-name
                         environment-name
                         next-token
                         severity
                         template-name
                         request-id]}]
                [credentials]]),
    :doc "Generate map for describeEvents, describeEvents"}
   ([credentials__1609__auto__]
    {:args [],
     :client :elasticbeanstalk,
     :fn :describe-events,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :elasticbeanstalk,
     :fn :describe-events,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-events
   {:arglists (quote
               [[credentials
                 {:keys [end-time
                         request-metric-collector
                         environment-id
                         max-records
                         start-time
                         version-label
                         application-name
                         environment-name
                         next-token
                         severity
                         template-name
                         request-id]}]
                [credentials]]),
    :doc "Call describeEvents, describeEvents"}
   [credentials8781 & args8782]
   (clojure.core/let
    [^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8783
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials8781)]
    (clojure.core/case
     (clojure.core/count args8782)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8783
       describeEvents
       (describe-events-request (clojure.core/nth args8782 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8783
       describeEvents))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :describe-applications
   [m8784]
   (clojure.core/let
    [credentials8785 (:credentials m8784) args8786 (:args m8784)]
    (clojure.core/let
     [^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8787
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials8785)]
     (clojure.core/case
      (clojure.core/count args8786)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8787
        describeApplications
        (describe-applications-request (clojure.core/nth args8786 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8787
        describeApplications))))))
  (clojure.core/defn
   describe-applications-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector application-names]}]
                [credentials]]),
    :doc "Generate map for describeApplications, describeApplications"}
   ([credentials__1609__auto__]
    {:args [],
     :client :elasticbeanstalk,
     :fn :describe-applications,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :elasticbeanstalk,
     :fn :describe-applications,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-applications
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector application-names]}]
                [credentials]]),
    :doc "Call describeApplications, describeApplications"}
   [credentials8789 & args8790]
   (clojure.core/let
    [^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8791
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials8789)]
    (clojure.core/case
     (clojure.core/count args8790)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8791
       describeApplications
       (describe-applications-request (clojure.core/nth args8790 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8791
       describeApplications))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :check-dnsavailability
   [m8792]
   (clojure.core/let
    [credentials8793 (:credentials m8792) args8794 (:args m8792)]
    (clojure.core/let
     [^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8795
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials8793)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8795
       checkDNSAvailability
       (check-dnsavailability-request (clojure.core/nth args8794 0)))))))
  (clojure.core/defn
   check-dnsavailability-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector cnameprefix]}]]),
    :doc "Generate map for checkDNSAvailability"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :elasticbeanstalk,
     :fn :check-dnsavailability,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   check-dnsavailability
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector cnameprefix]}]]),
    :doc "Call checkDNSAvailability"}
   [credentials8797 & args8798]
   (clojure.core/let
    [^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8799
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials8797)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8799
      checkDNSAvailability
      (check-dnsavailability-request (clojure.core/nth args8798 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :restart-app-server
   [m8800]
   (clojure.core/let
    [credentials8801 (:credentials m8800) args8802 (:args m8800)]
    (clojure.core/let
     [^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8803
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials8801)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8803
       restartAppServer
       (restart-app-server-request (clojure.core/nth args8802 0)))))))
  (clojure.core/defn
   restart-app-server-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         environment-name
                         environment-id]}]]),
    :doc "Generate map for restartAppServer"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :elasticbeanstalk,
     :fn :restart-app-server,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   restart-app-server
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         environment-name
                         environment-id]}]]),
    :doc "Call restartAppServer"}
   [credentials8805 & args8806]
   (clojure.core/let
    [^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8807
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials8805)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8807
      restartAppServer
      (restart-app-server-request (clojure.core/nth args8806 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :update-application-version
   [m8808]
   (clojure.core/let
    [credentials8809 (:credentials m8808) args8810 (:args m8808)]
    (clojure.core/let
     [^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8811
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials8809)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8811
       updateApplicationVersion
       (update-application-version-request
        (clojure.core/nth args8810 0)))))))
  (clojure.core/defn
   update-application-version-map
   {:arglists (quote
               [[credentials
                 {:keys [version-label
                         request-metric-collector
                         description
                         application-name]}]]),
    :doc "Generate map for updateApplicationVersion"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :elasticbeanstalk,
     :fn :update-application-version,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   update-application-version
   {:arglists (quote
               [[credentials
                 {:keys [version-label
                         request-metric-collector
                         description
                         application-name]}]]),
    :doc "Call updateApplicationVersion"}
   [credentials8813 & args8814]
   (clojure.core/let
    [^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8815
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials8813)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8815
      updateApplicationVersion
      (update-application-version-request
       (clojure.core/nth args8814 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :describe-environment-resources
   [m8816]
   (clojure.core/let
    [credentials8817 (:credentials m8816) args8818 (:args m8816)]
    (clojure.core/let
     [^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8819
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials8817)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8819
       describeEnvironmentResources
       (describe-environment-resources-request
        (clojure.core/nth args8818 0)))))))
  (clojure.core/defn
   describe-environment-resources-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         environment-name
                         environment-id]}]]),
    :doc "Generate map for describeEnvironmentResources"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :elasticbeanstalk,
     :fn :describe-environment-resources,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-environment-resources
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         environment-name
                         environment-id]}]]),
    :doc "Call describeEnvironmentResources"}
   [credentials8821 & args8822]
   (clojure.core/let
    [^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8823
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials8821)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8823
      describeEnvironmentResources
      (describe-environment-resources-request
       (clojure.core/nth args8822 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :describe-environments
   [m8824]
   (clojure.core/let
    [credentials8825 (:credentials m8824) args8826 (:args m8824)]
    (clojure.core/let
     [^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8827
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials8825)]
     (clojure.core/case
      (clojure.core/count args8826)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8827
        describeEnvironments))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8827
        describeEnvironments
        (describe-environments-request (clojure.core/nth args8826 0))))))))
  (clojure.core/defn
   describe-environments-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [version-label
                         environment-names
                         include-deleted
                         included-deleted-back-to
                         application-name
                         request-metric-collector
                         environment-ids]}]]),
    :doc "Generate map for describeEnvironments, describeEnvironments"}
   ([credentials__1609__auto__]
    {:args [],
     :client :elasticbeanstalk,
     :fn :describe-environments,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :elasticbeanstalk,
     :fn :describe-environments,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-environments
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [version-label
                         environment-names
                         include-deleted
                         included-deleted-back-to
                         application-name
                         request-metric-collector
                         environment-ids]}]]),
    :doc "Call describeEnvironments, describeEnvironments"}
   [credentials8829 & args8830]
   (clojure.core/let
    [^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8831
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials8829)]
    (clojure.core/case
     (clojure.core/count args8830)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8831
       describeEnvironments))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8831
       describeEnvironments
       (describe-environments-request (clojure.core/nth args8830 0))))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :describe-application-versions
   [m8832]
   (clojure.core/let
    [credentials8833 (:credentials m8832) args8834 (:args m8832)]
    (clojure.core/let
     [^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8835
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials8833)]
     (clojure.core/case
      (clojure.core/count args8834)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8835
        describeApplicationVersions))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8835
        describeApplicationVersions
        (describe-application-versions-request
         (clojure.core/nth args8834 0))))))))
  (clojure.core/defn
   describe-application-versions-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [version-labels
                         request-metric-collector
                         application-name]}]]),
    :doc "Generate map for describeApplicationVersions, describeApplicationVersions"}
   ([credentials__1609__auto__]
    {:args [],
     :client :elasticbeanstalk,
     :fn :describe-application-versions,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :elasticbeanstalk,
     :fn :describe-application-versions,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-application-versions
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [version-labels
                         request-metric-collector
                         application-name]}]]),
    :doc "Call describeApplicationVersions, describeApplicationVersions"}
   [credentials8837 & args8838]
   (clojure.core/let
    [^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8839
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials8837)]
    (clojure.core/case
     (clojure.core/count args8838)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8839
       describeApplicationVersions))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8839
       describeApplicationVersions
       (describe-application-versions-request
        (clojure.core/nth args8838 0))))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :delete-application-version
   [m8840]
   (clojure.core/let
    [credentials8841 (:credentials m8840) args8842 (:args m8840)]
    (clojure.core/let
     [^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8843
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials8841)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8843
       deleteApplicationVersion
       (delete-application-version-request
        (clojure.core/nth args8842 0)))))))
  (clojure.core/defn
   delete-application-version-map
   {:arglists (quote
               [[credentials
                 {:keys [version-label
                         request-metric-collector
                         delete-source-bundle
                         application-name]}]]),
    :doc "Generate map for deleteApplicationVersion"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :elasticbeanstalk,
     :fn :delete-application-version,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   delete-application-version
   {:arglists (quote
               [[credentials
                 {:keys [version-label
                         request-metric-collector
                         delete-source-bundle
                         application-name]}]]),
    :doc "Call deleteApplicationVersion"}
   [credentials8845 & args8846]
   (clojure.core/let
    [^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8847
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials8845)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8847
      deleteApplicationVersion
      (delete-application-version-request
       (clojure.core/nth args8846 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :swap-environment-cnames
   [m8848]
   (clojure.core/let
    [credentials8849 (:credentials m8848) args8850 (:args m8848)]
    (clojure.core/let
     [^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8851
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials8849)]
     (clojure.core/case
      (clojure.core/count args8850)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8851
        swapEnvironmentCNAMEs
        (swap-environment-cnames-request
         (clojure.core/nth args8850 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8851
        swapEnvironmentCNAMEs))))))
  (clojure.core/defn
   swap-environment-cnames-map
   {:arglists (quote
               [[credentials
                 {:keys [source-environment-name
                         source-environment-id
                         request-metric-collector
                         destination-environment-name
                         destination-environment-id]}]
                [credentials]]),
    :doc "Generate map for swapEnvironmentCNAMEs, swapEnvironmentCNAMEs"}
   ([credentials__1609__auto__]
    {:args [],
     :client :elasticbeanstalk,
     :fn :swap-environment-cnames,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :elasticbeanstalk,
     :fn :swap-environment-cnames,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   swap-environment-cnames
   {:arglists (quote
               [[credentials
                 {:keys [source-environment-name
                         source-environment-id
                         request-metric-collector
                         destination-environment-name
                         destination-environment-id]}]
                [credentials]]),
    :doc "Call swapEnvironmentCNAMEs, swapEnvironmentCNAMEs"}
   [credentials8853 & args8854]
   (clojure.core/let
    [^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8855
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials8853)]
    (clojure.core/case
     (clojure.core/count args8854)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8855
       swapEnvironmentCNAMEs
       (swap-environment-cnames-request (clojure.core/nth args8854 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8855
       swapEnvironmentCNAMEs))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :delete-configuration-template
   [m8856]
   (clojure.core/let
    [credentials8857 (:credentials m8856) args8858 (:args m8856)]
    (clojure.core/let
     [^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8859
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials8857)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8859
       deleteConfigurationTemplate
       (delete-configuration-template-request
        (clojure.core/nth args8858 0)))))))
  (clojure.core/defn
   delete-configuration-template-map
   {:arglists (quote
               [[credentials
                 {:keys [template-name
                         request-metric-collector
                         application-name]}]]),
    :doc "Generate map for deleteConfigurationTemplate"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :elasticbeanstalk,
     :fn :delete-configuration-template,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   delete-configuration-template
   {:arglists (quote
               [[credentials
                 {:keys [template-name
                         request-metric-collector
                         application-name]}]]),
    :doc "Call deleteConfigurationTemplate"}
   [credentials8861 & args8862]
   (clojure.core/let
    [^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8863
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials8861)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8863
      deleteConfigurationTemplate
      (delete-configuration-template-request
       (clojure.core/nth args8862 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :update-application
   [m8864]
   (clojure.core/let
    [credentials8865 (:credentials m8864) args8866 (:args m8864)]
    (clojure.core/let
     [^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8867
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials8865)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8867
       updateApplication
       (update-application-request (clojure.core/nth args8866 0)))))))
  (clojure.core/defn
   update-application-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         description
                         application-name]}]]),
    :doc "Generate map for updateApplication"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :elasticbeanstalk,
     :fn :update-application,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   update-application
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         description
                         application-name]}]]),
    :doc "Call updateApplication"}
   [credentials8869 & args8870]
   (clojure.core/let
    [^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8871
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials8869)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8871
      updateApplication
      (update-application-request (clojure.core/nth args8870 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :list-available-solution-stacks
   [m8872]
   (clojure.core/let
    [credentials8873 (:credentials m8872) args8874 (:args m8872)]
    (clojure.core/let
     [^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8875
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials8873)]
     (clojure.core/case
      (clojure.core/count args8874)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8875
        listAvailableSolutionStacks
        (list-available-solution-stacks-request
         (clojure.core/nth args8874 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8875
        listAvailableSolutionStacks))))))
  (clojure.core/defn
   list-available-solution-stacks-map
   {:arglists (quote
               [[credentials {:keys [request-metric-collector]}]
                [credentials]]),
    :doc "Generate map for listAvailableSolutionStacks, listAvailableSolutionStacks"}
   ([credentials__1609__auto__]
    {:args [],
     :client :elasticbeanstalk,
     :fn :list-available-solution-stacks,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :elasticbeanstalk,
     :fn :list-available-solution-stacks,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   list-available-solution-stacks
   {:arglists (quote
               [[credentials {:keys [request-metric-collector]}]
                [credentials]]),
    :doc "Call listAvailableSolutionStacks, listAvailableSolutionStacks"}
   [credentials8877 & args8878]
   (clojure.core/let
    [^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8879
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials8877)]
    (clojure.core/case
     (clojure.core/count args8878)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8879
       listAvailableSolutionStacks
       (list-available-solution-stacks-request
        (clojure.core/nth args8878 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8879
       listAvailableSolutionStacks))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :update-configuration-template
   [m8880]
   (clojure.core/let
    [credentials8881 (:credentials m8880) args8882 (:args m8880)]
    (clojure.core/let
     [^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8883
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials8881)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8883
       updateConfigurationTemplate
       (update-configuration-template-request
        (clojure.core/nth args8882 0)))))))
  (clojure.core/defn
   update-configuration-template-map
   {:arglists (quote
               [[credentials
                 {:keys [template-name
                         request-metric-collector
                         options-to-remove
                         option-settings
                         description
                         application-name]}]]),
    :doc "Generate map for updateConfigurationTemplate"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :elasticbeanstalk,
     :fn :update-configuration-template,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   update-configuration-template
   {:arglists (quote
               [[credentials
                 {:keys [template-name
                         request-metric-collector
                         options-to-remove
                         option-settings
                         description
                         application-name]}]]),
    :doc "Call updateConfigurationTemplate"}
   [credentials8885 & args8886]
   (clojure.core/let
    [^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8887
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials8885)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8887
      updateConfigurationTemplate
      (update-configuration-template-request
       (clojure.core/nth args8886 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :request-environment-info
   [m8888]
   (clojure.core/let
    [credentials8889 (:credentials m8888) args8890 (:args m8888)]
    (clojure.core/let
     [^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8891
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials8889)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8891
       requestEnvironmentInfo
       (request-environment-info-request
        (clojure.core/nth args8890 0)))))))
  (clojure.core/defn
   request-environment-info-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         info-type
                         environment-name
                         environment-id]}]]),
    :doc "Generate map for requestEnvironmentInfo"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :elasticbeanstalk,
     :fn :request-environment-info,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   request-environment-info
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         info-type
                         environment-name
                         environment-id]}]]),
    :doc "Call requestEnvironmentInfo"}
   [credentials8893 & args8894]
   (clojure.core/let
    [^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8895
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials8893)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8895
      requestEnvironmentInfo
      (request-environment-info-request (clojure.core/nth args8894 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :delete-environment-configuration
   [m8896]
   (clojure.core/let
    [credentials8897 (:credentials m8896) args8898 (:args m8896)]
    (clojure.core/let
     [^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8899
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials8897)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8899
       deleteEnvironmentConfiguration
       (delete-environment-configuration-request
        (clojure.core/nth args8898 0)))))))
  (clojure.core/defn
   delete-environment-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         environment-name
                         application-name]}]]),
    :doc "Generate map for deleteEnvironmentConfiguration"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :elasticbeanstalk,
     :fn :delete-environment-configuration,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   delete-environment-configuration
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         environment-name
                         application-name]}]]),
    :doc "Call deleteEnvironmentConfiguration"}
   [credentials8901 & args8902]
   (clojure.core/let
    [^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8903
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials8901)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8903
      deleteEnvironmentConfiguration
      (delete-environment-configuration-request
       (clojure.core/nth args8902 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :terminate-environment
   [m8904]
   (clojure.core/let
    [credentials8905 (:credentials m8904) args8906 (:args m8904)]
    (clojure.core/let
     [^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8907
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials8905)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8907
       terminateEnvironment
       (terminate-environment-request (clojure.core/nth args8906 0)))))))
  (clojure.core/defn
   terminate-environment-map
   {:arglists (quote
               [[credentials
                 {:keys [terminate-resources
                         request-metric-collector
                         environment-name
                         environment-id]}]]),
    :doc "Generate map for terminateEnvironment"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :elasticbeanstalk,
     :fn :terminate-environment,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   terminate-environment
   {:arglists (quote
               [[credentials
                 {:keys [terminate-resources
                         request-metric-collector
                         environment-name
                         environment-id]}]]),
    :doc "Call terminateEnvironment"}
   [credentials8909 & args8910]
   (clojure.core/let
    [^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8911
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials8909)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8911
      terminateEnvironment
      (terminate-environment-request (clojure.core/nth args8910 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :retrieve-environment-info
   [m8912]
   (clojure.core/let
    [credentials8913 (:credentials m8912) args8914 (:args m8912)]
    (clojure.core/let
     [^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8915
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials8913)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8915
       retrieveEnvironmentInfo
       (retrieve-environment-info-request
        (clojure.core/nth args8914 0)))))))
  (clojure.core/defn
   retrieve-environment-info-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         info-type
                         environment-name
                         environment-id]}]]),
    :doc "Generate map for retrieveEnvironmentInfo"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :elasticbeanstalk,
     :fn :retrieve-environment-info,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   retrieve-environment-info
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         info-type
                         environment-name
                         environment-id]}]]),
    :doc "Call retrieveEnvironmentInfo"}
   [credentials8917 & args8918]
   (clojure.core/let
    [^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8919
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials8917)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient client8919
      retrieveEnvironmentInfo
      (retrieve-environment-info-request
       (clojure.core/nth args8918 0))))))))
