(ns
 com.palletops.awaze.elasticloadbalancing
 (:require [com.palletops.awaze.common]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :elasticloadbalancing
  [___1561__auto__
   ^com.amazonaws.auth.BasicAWSCredentials credentials__1562__auto__]
  (new
   com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient
   credentials__1562__auto__))
 (clojure.core/defn
  ^com.amazonaws.services.elasticloadbalancing.model.Instance instance
  [m3911]
  (clojure.core/let
   [bean3910
    (new com.amazonaws.services.elasticloadbalancing.model.Instance)]
   (clojure.core/when-let
    [v3912 (:instance-id m3911)]
    (. bean3910 setInstanceId (clojure.core/str v3912)))
   bean3910))
 (clojure.core/defn
  ^com.amazonaws.services.elasticloadbalancing.model.PolicyAttribute policy-attribute
  [m3914]
  (clojure.core/let
   [bean3913
    (new
     com.amazonaws.services.elasticloadbalancing.model.PolicyAttribute)]
   (clojure.core/when-let
    [v3915 (:attribute-name m3914)]
    (. bean3913 setAttributeName (clojure.core/str v3915)))
   (clojure.core/when-let
    [v3915 (:attribute-value m3914)]
    (. bean3913 setAttributeValue (clojure.core/str v3915)))
   bean3913))
 (clojure.core/defn
  ^com.amazonaws.services.elasticloadbalancing.model.HealthCheck health-check
  [m3917]
  (clojure.core/let
   [bean3916
    (new
     com.amazonaws.services.elasticloadbalancing.model.HealthCheck)]
   (clojure.core/when-let
    [v3918 (:target m3917)]
    (. bean3916 setTarget (clojure.core/str v3918)))
   (clojure.core/when-let
    [v3918 (:interval m3917)]
    (. bean3916 setInterval (clojure.core/int v3918)))
   (clojure.core/when-let
    [v3918 (:timeout m3917)]
    (. bean3916 setTimeout (clojure.core/int v3918)))
   (clojure.core/when-let
    [v3918 (:unhealthy-threshold m3917)]
    (. bean3916 setUnhealthyThreshold (clojure.core/int v3918)))
   (clojure.core/when-let
    [v3918 (:healthy-threshold m3917)]
    (. bean3916 setHealthyThreshold (clojure.core/int v3918)))
   bean3916))
 (clojure.core/defn
  ^com.amazonaws.services.elasticloadbalancing.model.Listener listener
  [m3920]
  (clojure.core/let
   [bean3919
    (new com.amazonaws.services.elasticloadbalancing.model.Listener)]
   (clojure.core/when-let
    [v3921 (:protocol m3920)]
    (. bean3919 setProtocol (clojure.core/str v3921)))
   (clojure.core/when-let
    [v3921 (:load-balancer-port m3920)]
    (. bean3919 setLoadBalancerPort (clojure.core/int v3921)))
   (clojure.core/when-let
    [v3921 (:instance-port m3920)]
    (. bean3919 setInstancePort (clojure.core/int v3921)))
   (clojure.core/when-let
    [v3921 (:sslcertificate-id m3920)]
    (. bean3919 setSSLCertificateId (clojure.core/str v3921)))
   (clojure.core/when-let
    [v3921 (:instance-protocol m3920)]
    (. bean3919 setInstanceProtocol (clojure.core/str v3921)))
   bean3919))
 (clojure.core/defn
  ^com.amazonaws.services.elasticloadbalancing.model.DeregisterInstancesFromLoadBalancerRequest deregister-instances-from-load-balancer-request
  [m3923]
  (clojure.core/let
   [bean3922
    (new
     com.amazonaws.services.elasticloadbalancing.model.DeregisterInstancesFromLoadBalancerRequest)]
   (clojure.core/when-let
    [v3924 (:instances m3923)]
    (.
     bean3922
     setInstances
     (clojure.core/map
      (clojure.core/fn [arg3928] (instance arg3928))
      v3924)))
   (clojure.core/when-let
    [v3924 (:load-balancer-name m3923)]
    (. bean3922 setLoadBalancerName (clojure.core/str v3924)))
   bean3922))
 (clojure.core/defn
  ^com.amazonaws.services.elasticloadbalancing.model.EnableAvailabilityZonesForLoadBalancerRequest enable-availability-zones-for-load-balancer-request
  [m3926]
  (clojure.core/let
   [bean3925
    (new
     com.amazonaws.services.elasticloadbalancing.model.EnableAvailabilityZonesForLoadBalancerRequest)]
   (clojure.core/when-let
    [v3927 (:availability-zones m3926)]
    (.
     bean3925
     setAvailabilityZones
     (clojure.core/map
      (clojure.core/fn [arg3932] (clojure.core/str arg3932))
      v3927)))
   (clojure.core/when-let
    [v3927 (:load-balancer-name m3926)]
    (. bean3925 setLoadBalancerName (clojure.core/str v3927)))
   bean3925))
 (clojure.core/defn
  ^com.amazonaws.services.elasticloadbalancing.model.ApplySecurityGroupsToLoadBalancerRequest apply-security-groups-to-load-balancer-request
  [m3930]
  (clojure.core/let
   [bean3929
    (new
     com.amazonaws.services.elasticloadbalancing.model.ApplySecurityGroupsToLoadBalancerRequest)]
   (clojure.core/when-let
    [v3931 (:security-groups m3930)]
    (.
     bean3929
     setSecurityGroups
     (clojure.core/map
      (clojure.core/fn [arg3936] (clojure.core/str arg3936))
      v3931)))
   (clojure.core/when-let
    [v3931 (:load-balancer-name m3930)]
    (. bean3929 setLoadBalancerName (clojure.core/str v3931)))
   bean3929))
 (clojure.core/defn
  ^com.amazonaws.services.elasticloadbalancing.model.CreateLBCookieStickinessPolicyRequest create-lbcookie-stickiness-policy-request
  [m3934]
  (clojure.core/let
   [bean3933
    (new
     com.amazonaws.services.elasticloadbalancing.model.CreateLBCookieStickinessPolicyRequest)]
   (clojure.core/when-let
    [v3935 (:policy-name m3934)]
    (. bean3933 setPolicyName (clojure.core/str v3935)))
   (clojure.core/when-let
    [v3935 (:load-balancer-name m3934)]
    (. bean3933 setLoadBalancerName (clojure.core/str v3935)))
   (clojure.core/when-let
    [v3935 (:cookie-expiration-period m3934)]
    (. bean3933 setCookieExpirationPeriod (clojure.core/long v3935)))
   bean3933))
 (clojure.core/defn
  ^com.amazonaws.services.elasticloadbalancing.model.DescribeLoadBalancerPoliciesRequest describe-load-balancer-policies-request
  [m3938]
  (clojure.core/let
   [bean3937
    (new
     com.amazonaws.services.elasticloadbalancing.model.DescribeLoadBalancerPoliciesRequest)]
   (clojure.core/when-let
    [v3939 (:load-balancer-name m3938)]
    (. bean3937 setLoadBalancerName (clojure.core/str v3939)))
   (clojure.core/when-let
    [v3939 (:policy-names m3938)]
    (.
     bean3937
     setPolicyNames
     (clojure.core/map
      (clojure.core/fn [arg3943] (clojure.core/str arg3943))
      v3939)))
   bean3937))
 (clojure.core/defn
  ^com.amazonaws.services.elasticloadbalancing.model.DeleteLoadBalancerRequest delete-load-balancer-request
  [m3941]
  (clojure.core/let
   [bean3940
    (new
     com.amazonaws.services.elasticloadbalancing.model.DeleteLoadBalancerRequest)]
   (clojure.core/when-let
    [v3942 (:load-balancer-name m3941)]
    (. bean3940 setLoadBalancerName (clojure.core/str v3942)))
   bean3940))
 (clojure.core/defn
  ^com.amazonaws.services.elasticloadbalancing.model.DescribeLoadBalancerPolicyTypesRequest describe-load-balancer-policy-types-request
  [m3945]
  (clojure.core/let
   [bean3944
    (new
     com.amazonaws.services.elasticloadbalancing.model.DescribeLoadBalancerPolicyTypesRequest)]
   (clojure.core/when-let
    [v3946 (:policy-type-names m3945)]
    (.
     bean3944
     setPolicyTypeNames
     (clojure.core/map
      (clojure.core/fn [arg3950] (clojure.core/str arg3950))
      v3946)))
   bean3944))
 (clojure.core/defn
  ^com.amazonaws.services.elasticloadbalancing.model.DeleteLoadBalancerPolicyRequest delete-load-balancer-policy-request
  [m3948]
  (clojure.core/let
   [bean3947
    (new
     com.amazonaws.services.elasticloadbalancing.model.DeleteLoadBalancerPolicyRequest)]
   (clojure.core/when-let
    [v3949 (:policy-name m3948)]
    (. bean3947 setPolicyName (clojure.core/str v3949)))
   (clojure.core/when-let
    [v3949 (:load-balancer-name m3948)]
    (. bean3947 setLoadBalancerName (clojure.core/str v3949)))
   bean3947))
 (clojure.core/defn
  ^com.amazonaws.services.elasticloadbalancing.model.CreateLoadBalancerPolicyRequest create-load-balancer-policy-request
  [m3952]
  (clojure.core/let
   [bean3951
    (new
     com.amazonaws.services.elasticloadbalancing.model.CreateLoadBalancerPolicyRequest)]
   (clojure.core/when-let
    [v3953 (:policy-name m3952)]
    (. bean3951 setPolicyName (clojure.core/str v3953)))
   (clojure.core/when-let
    [v3953 (:load-balancer-name m3952)]
    (. bean3951 setLoadBalancerName (clojure.core/str v3953)))
   (clojure.core/when-let
    [v3953 (:policy-type-name m3952)]
    (. bean3951 setPolicyTypeName (clojure.core/str v3953)))
   (clojure.core/when-let
    [v3953 (:policy-attributes m3952)]
    (.
     bean3951
     setPolicyAttributes
     (clojure.core/map
      (clojure.core/fn [arg3957] (policy-attribute arg3957))
      v3953)))
   bean3951))
 (clojure.core/defn
  ^com.amazonaws.services.elasticloadbalancing.model.ConfigureHealthCheckRequest configure-health-check-request
  [m3955]
  (clojure.core/let
   [bean3954
    (new
     com.amazonaws.services.elasticloadbalancing.model.ConfigureHealthCheckRequest)]
   (clojure.core/when-let
    [v3956 (:load-balancer-name m3955)]
    (. bean3954 setLoadBalancerName (clojure.core/str v3956)))
   (clojure.core/when-let
    [v3956 (:health-check m3955)]
    (. bean3954 setHealthCheck (health-check v3956)))
   bean3954))
 (clojure.core/defn
  ^com.amazonaws.services.elasticloadbalancing.model.DescribeInstanceHealthRequest describe-instance-health-request
  [m3959]
  (clojure.core/let
   [bean3958
    (new
     com.amazonaws.services.elasticloadbalancing.model.DescribeInstanceHealthRequest)]
   (clojure.core/when-let
    [v3960 (:instances m3959)]
    (.
     bean3958
     setInstances
     (clojure.core/map
      (clojure.core/fn [arg3964] (instance arg3964))
      v3960)))
   (clojure.core/when-let
    [v3960 (:load-balancer-name m3959)]
    (. bean3958 setLoadBalancerName (clojure.core/str v3960)))
   bean3958))
 (clojure.core/defn
  ^com.amazonaws.services.elasticloadbalancing.model.CreateLoadBalancerRequest create-load-balancer-request
  [m3962]
  (clojure.core/let
   [bean3961
    (new
     com.amazonaws.services.elasticloadbalancing.model.CreateLoadBalancerRequest)]
   (clojure.core/when-let
    [v3963 (:security-groups m3962)]
    (.
     bean3961
     setSecurityGroups
     (clojure.core/map
      (clojure.core/fn [arg3968] (clojure.core/str arg3968))
      v3963)))
   (clojure.core/when-let
    [v3963 (:availability-zones m3962)]
    (.
     bean3961
     setAvailabilityZones
     (clojure.core/map
      (clojure.core/fn [arg3969] (clojure.core/str arg3969))
      v3963)))
   (clojure.core/when-let
    [v3963 (:subnets m3962)]
    (.
     bean3961
     setSubnets
     (clojure.core/map
      (clojure.core/fn [arg3970] (clojure.core/str arg3970))
      v3963)))
   (clojure.core/when-let
    [v3963 (:load-balancer-name m3962)]
    (. bean3961 setLoadBalancerName (clojure.core/str v3963)))
   (clojure.core/when-let
    [v3963 (:listeners m3962)]
    (.
     bean3961
     setListeners
     (clojure.core/map
      (clojure.core/fn [arg3971] (listener arg3971))
      v3963)))
   (clojure.core/when-let
    [v3963 (:scheme m3962)]
    (. bean3961 setScheme (clojure.core/str v3963)))
   bean3961))
 (clojure.core/defn
  ^com.amazonaws.services.elasticloadbalancing.model.SetLoadBalancerPoliciesForBackendServerRequest set-load-balancer-policies-for-backend-server-request
  [m3966]
  (clojure.core/let
   [bean3965
    (new
     com.amazonaws.services.elasticloadbalancing.model.SetLoadBalancerPoliciesForBackendServerRequest)]
   (clojure.core/when-let
    [v3967 (:load-balancer-name m3966)]
    (. bean3965 setLoadBalancerName (clojure.core/str v3967)))
   (clojure.core/when-let
    [v3967 (:instance-port m3966)]
    (. bean3965 setInstancePort (clojure.core/int v3967)))
   (clojure.core/when-let
    [v3967 (:policy-names m3966)]
    (.
     bean3965
     setPolicyNames
     (clojure.core/map
      (clojure.core/fn [arg3975] (clojure.core/str arg3975))
      v3967)))
   bean3965))
 (clojure.core/defn
  ^com.amazonaws.services.elasticloadbalancing.model.DisableAvailabilityZonesForLoadBalancerRequest disable-availability-zones-for-load-balancer-request
  [m3973]
  (clojure.core/let
   [bean3972
    (new
     com.amazonaws.services.elasticloadbalancing.model.DisableAvailabilityZonesForLoadBalancerRequest)]
   (clojure.core/when-let
    [v3974 (:availability-zones m3973)]
    (.
     bean3972
     setAvailabilityZones
     (clojure.core/map
      (clojure.core/fn [arg3979] (clojure.core/str arg3979))
      v3974)))
   (clojure.core/when-let
    [v3974 (:load-balancer-name m3973)]
    (. bean3972 setLoadBalancerName (clojure.core/str v3974)))
   bean3972))
 (clojure.core/defn
  ^com.amazonaws.services.elasticloadbalancing.model.DetachLoadBalancerFromSubnetsRequest detach-load-balancer-from-subnets-request
  [m3977]
  (clojure.core/let
   [bean3976
    (new
     com.amazonaws.services.elasticloadbalancing.model.DetachLoadBalancerFromSubnetsRequest)]
   (clojure.core/when-let
    [v3978 (:subnets m3977)]
    (.
     bean3976
     setSubnets
     (clojure.core/map
      (clojure.core/fn [arg3983] (clojure.core/str arg3983))
      v3978)))
   (clojure.core/when-let
    [v3978 (:load-balancer-name m3977)]
    (. bean3976 setLoadBalancerName (clojure.core/str v3978)))
   bean3976))
 (clojure.core/defn
  ^com.amazonaws.services.elasticloadbalancing.model.CreateLoadBalancerListenersRequest create-load-balancer-listeners-request
  [m3981]
  (clojure.core/let
   [bean3980
    (new
     com.amazonaws.services.elasticloadbalancing.model.CreateLoadBalancerListenersRequest)]
   (clojure.core/when-let
    [v3982 (:load-balancer-name m3981)]
    (. bean3980 setLoadBalancerName (clojure.core/str v3982)))
   (clojure.core/when-let
    [v3982 (:listeners m3981)]
    (.
     bean3980
     setListeners
     (clojure.core/map
      (clojure.core/fn [arg3987] (listener arg3987))
      v3982)))
   bean3980))
 (clojure.core/defn
  ^com.amazonaws.services.elasticloadbalancing.model.DeleteLoadBalancerListenersRequest delete-load-balancer-listeners-request
  [m3985]
  (clojure.core/let
   [bean3984
    (new
     com.amazonaws.services.elasticloadbalancing.model.DeleteLoadBalancerListenersRequest)]
   (clojure.core/when-let
    [v3986 (:load-balancer-name m3985)]
    (. bean3984 setLoadBalancerName (clojure.core/str v3986)))
   (clojure.core/when-let
    [v3986 (:load-balancer-ports m3985)]
    (.
     bean3984
     setLoadBalancerPorts
     (clojure.core/map
      (clojure.core/fn [arg3991] (clojure.core/int arg3991))
      v3986)))
   bean3984))
 (clojure.core/defn
  ^com.amazonaws.services.elasticloadbalancing.model.SetLoadBalancerListenerSSLCertificateRequest set-load-balancer-listener-sslcertificate-request
  [m3989]
  (clojure.core/let
   [bean3988
    (new
     com.amazonaws.services.elasticloadbalancing.model.SetLoadBalancerListenerSSLCertificateRequest)]
   (clojure.core/when-let
    [v3990 (:load-balancer-name m3989)]
    (. bean3988 setLoadBalancerName (clojure.core/str v3990)))
   (clojure.core/when-let
    [v3990 (:load-balancer-port m3989)]
    (. bean3988 setLoadBalancerPort (clojure.core/int v3990)))
   (clojure.core/when-let
    [v3990 (:sslcertificate-id m3989)]
    (. bean3988 setSSLCertificateId (clojure.core/str v3990)))
   bean3988))
 (clojure.core/defn
  ^com.amazonaws.services.elasticloadbalancing.model.RegisterInstancesWithLoadBalancerRequest register-instances-with-load-balancer-request
  [m3993]
  (clojure.core/let
   [bean3992
    (new
     com.amazonaws.services.elasticloadbalancing.model.RegisterInstancesWithLoadBalancerRequest)]
   (clojure.core/when-let
    [v3994 (:instances m3993)]
    (.
     bean3992
     setInstances
     (clojure.core/map
      (clojure.core/fn [arg3998] (instance arg3998))
      v3994)))
   (clojure.core/when-let
    [v3994 (:load-balancer-name m3993)]
    (. bean3992 setLoadBalancerName (clojure.core/str v3994)))
   bean3992))
 (clojure.core/defn
  ^com.amazonaws.services.elasticloadbalancing.model.SetLoadBalancerPoliciesOfListenerRequest set-load-balancer-policies-of-listener-request
  [m3996]
  (clojure.core/let
   [bean3995
    (new
     com.amazonaws.services.elasticloadbalancing.model.SetLoadBalancerPoliciesOfListenerRequest)]
   (clojure.core/when-let
    [v3997 (:load-balancer-name m3996)]
    (. bean3995 setLoadBalancerName (clojure.core/str v3997)))
   (clojure.core/when-let
    [v3997 (:load-balancer-port m3996)]
    (. bean3995 setLoadBalancerPort (clojure.core/int v3997)))
   (clojure.core/when-let
    [v3997 (:policy-names m3996)]
    (.
     bean3995
     setPolicyNames
     (clojure.core/map
      (clojure.core/fn [arg4002] (clojure.core/str arg4002))
      v3997)))
   bean3995))
 (clojure.core/defn
  ^com.amazonaws.services.elasticloadbalancing.model.AttachLoadBalancerToSubnetsRequest attach-load-balancer-to-subnets-request
  [m4000]
  (clojure.core/let
   [bean3999
    (new
     com.amazonaws.services.elasticloadbalancing.model.AttachLoadBalancerToSubnetsRequest)]
   (clojure.core/when-let
    [v4001 (:subnets m4000)]
    (.
     bean3999
     setSubnets
     (clojure.core/map
      (clojure.core/fn [arg4006] (clojure.core/str arg4006))
      v4001)))
   (clojure.core/when-let
    [v4001 (:load-balancer-name m4000)]
    (. bean3999 setLoadBalancerName (clojure.core/str v4001)))
   bean3999))
 (clojure.core/defn
  ^com.amazonaws.services.elasticloadbalancing.model.DescribeLoadBalancersRequest describe-load-balancers-request
  [m4004]
  (clojure.core/let
   [bean4003
    (new
     com.amazonaws.services.elasticloadbalancing.model.DescribeLoadBalancersRequest)]
   (clojure.core/when-let
    [v4005 (:marker m4004)]
    (. bean4003 setMarker (clojure.core/str v4005)))
   (clojure.core/when-let
    [v4005 (:load-balancer-names m4004)]
    (.
     bean4003
     setLoadBalancerNames
     (clojure.core/map
      (clojure.core/fn [arg4010] (clojure.core/str arg4010))
      v4005)))
   bean4003))
 (clojure.core/defn
  ^com.amazonaws.services.elasticloadbalancing.model.CreateAppCookieStickinessPolicyRequest create-app-cookie-stickiness-policy-request
  [m4008]
  (clojure.core/let
   [bean4007
    (new
     com.amazonaws.services.elasticloadbalancing.model.CreateAppCookieStickinessPolicyRequest)]
   (clojure.core/when-let
    [v4009 (:policy-name m4008)]
    (. bean4007 setPolicyName (clojure.core/str v4009)))
   (clojure.core/when-let
    [v4009 (:load-balancer-name m4008)]
    (. bean4007 setLoadBalancerName (clojure.core/str v4009)))
   (clojure.core/when-let
    [v4009 (:cookie-name m4008)]
    (. bean4007 setCookieName (clojure.core/str v4009)))
   bean4007))
 (clojure.core/defmulti
  elasticloadbalancing
  (clojure.core/fn
   elasticloadbalancing
   [m__1641__auto__]
   (:fn m__1641__auto__)))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :deregister-instances-from-load-balancer
   [m4011]
   (clojure.core/let
    [credentials4012 (:credentials m4011) args4013 (:args m4011)]
    (clojure.core/let
     [^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client4014
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4012)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client4014
       deregisterInstancesFromLoadBalancer
       (deregister-instances-from-load-balancer-request
        (clojure.core/nth args4013 0)))))))
  (clojure.core/defn
   deregister-instances-from-load-balancer-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         load-balancer-name
                         instances]}]]),
    :doc "Generate map for deregisterInstancesFromLoadBalancer"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :deregister-instances-from-load-balancer,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   deregister-instances-from-load-balancer
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         load-balancer-name
                         instances]}]]),
    :doc "Call deregisterInstancesFromLoadBalancer"}
   [credentials4016 & args4017]
   (clojure.core/let
    [^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client4018
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4016)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client4018
      deregisterInstancesFromLoadBalancer
      (deregister-instances-from-load-balancer-request
       (clojure.core/nth args4017 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :enable-availability-zones-for-load-balancer
   [m4019]
   (clojure.core/let
    [credentials4020 (:credentials m4019) args4021 (:args m4019)]
    (clojure.core/let
     [^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client4022
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4020)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client4022
       enableAvailabilityZonesForLoadBalancer
       (enable-availability-zones-for-load-balancer-request
        (clojure.core/nth args4021 0)))))))
  (clojure.core/defn
   enable-availability-zones-for-load-balancer-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         load-balancer-name
                         availability-zones]}]]),
    :doc "Generate map for enableAvailabilityZonesForLoadBalancer"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :enable-availability-zones-for-load-balancer,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   enable-availability-zones-for-load-balancer
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         load-balancer-name
                         availability-zones]}]]),
    :doc "Call enableAvailabilityZonesForLoadBalancer"}
   [credentials4024 & args4025]
   (clojure.core/let
    [^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client4026
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4024)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client4026
      enableAvailabilityZonesForLoadBalancer
      (enable-availability-zones-for-load-balancer-request
       (clojure.core/nth args4025 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :apply-security-groups-to-load-balancer
   [m4027]
   (clojure.core/let
    [credentials4028 (:credentials m4027) args4029 (:args m4027)]
    (clojure.core/let
     [^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client4030
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4028)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client4030
       applySecurityGroupsToLoadBalancer
       (apply-security-groups-to-load-balancer-request
        (clojure.core/nth args4029 0)))))))
  (clojure.core/defn
   apply-security-groups-to-load-balancer-map
   {:arglists (quote
               [[credentials
                 {:keys [security-groups
                         request-metric-collector
                         load-balancer-name]}]]),
    :doc "Generate map for applySecurityGroupsToLoadBalancer"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :apply-security-groups-to-load-balancer,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   apply-security-groups-to-load-balancer
   {:arglists (quote
               [[credentials
                 {:keys [security-groups
                         request-metric-collector
                         load-balancer-name]}]]),
    :doc "Call applySecurityGroupsToLoadBalancer"}
   [credentials4032 & args4033]
   (clojure.core/let
    [^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client4034
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4032)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client4034
      applySecurityGroupsToLoadBalancer
      (apply-security-groups-to-load-balancer-request
       (clojure.core/nth args4033 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :create-lbcookie-stickiness-policy
   [m4035]
   (clojure.core/let
    [credentials4036 (:credentials m4035) args4037 (:args m4035)]
    (clojure.core/let
     [^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client4038
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4036)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client4038
       createLBCookieStickinessPolicy
       (create-lbcookie-stickiness-policy-request
        (clojure.core/nth args4037 0)))))))
  (clojure.core/defn
   create-lbcookie-stickiness-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         policy-name
                         load-balancer-name
                         cookie-expiration-period]}]]),
    :doc "Generate map for createLBCookieStickinessPolicy"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :create-lbcookie-stickiness-policy,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   create-lbcookie-stickiness-policy
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         policy-name
                         load-balancer-name
                         cookie-expiration-period]}]]),
    :doc "Call createLBCookieStickinessPolicy"}
   [credentials4040 & args4041]
   (clojure.core/let
    [^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client4042
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4040)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client4042
      createLBCookieStickinessPolicy
      (create-lbcookie-stickiness-policy-request
       (clojure.core/nth args4041 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :describe-load-balancer-policies
   [m4043]
   (clojure.core/let
    [credentials4044 (:credentials m4043) args4045 (:args m4043)]
    (clojure.core/let
     [^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client4046
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4044)]
     (clojure.core/case
      (clojure.core/count args4045)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client4046
        describeLoadBalancerPolicies
        (describe-load-balancer-policies-request
         (clojure.core/nth args4045 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client4046
        describeLoadBalancerPolicies))))))
  (clojure.core/defn
   describe-load-balancer-policies-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         policy-names
                         load-balancer-name]}]
                [credentials]]),
    :doc "Generate map for describeLoadBalancerPolicies, describeLoadBalancerPolicies"}
   ([credentials__1609__auto__]
    {:args [],
     :client :elasticloadbalancing,
     :fn :describe-load-balancer-policies,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :describe-load-balancer-policies,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-load-balancer-policies
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         policy-names
                         load-balancer-name]}]
                [credentials]]),
    :doc "Call describeLoadBalancerPolicies, describeLoadBalancerPolicies"}
   [credentials4048 & args4049]
   (clojure.core/let
    [^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client4050
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4048)]
    (clojure.core/case
     (clojure.core/count args4049)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client4050
       describeLoadBalancerPolicies
       (describe-load-balancer-policies-request
        (clojure.core/nth args4049 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client4050
       describeLoadBalancerPolicies))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :delete-load-balancer
   [m4051]
   (clojure.core/let
    [credentials4052 (:credentials m4051) args4053 (:args m4051)]
    (clojure.core/let
     [^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client4054
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4052)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client4054
       deleteLoadBalancer
       (delete-load-balancer-request (clojure.core/nth args4053 0)))))))
  (clojure.core/defn
   delete-load-balancer-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector load-balancer-name]}]]),
    :doc "Generate map for deleteLoadBalancer"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :delete-load-balancer,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   delete-load-balancer
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector load-balancer-name]}]]),
    :doc "Call deleteLoadBalancer"}
   [credentials4056 & args4057]
   (clojure.core/let
    [^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client4058
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4056)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client4058
      deleteLoadBalancer
      (delete-load-balancer-request (clojure.core/nth args4057 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :describe-load-balancer-policy-types
   [m4059]
   (clojure.core/let
    [credentials4060 (:credentials m4059) args4061 (:args m4059)]
    (clojure.core/let
     [^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client4062
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4060)]
     (clojure.core/case
      (clojure.core/count args4061)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client4062
        describeLoadBalancerPolicyTypes))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client4062
        describeLoadBalancerPolicyTypes
        (describe-load-balancer-policy-types-request
         (clojure.core/nth args4061 0))))))))
  (clojure.core/defn
   describe-load-balancer-policy-types-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [request-metric-collector policy-type-names]}]]),
    :doc "Generate map for describeLoadBalancerPolicyTypes, describeLoadBalancerPolicyTypes"}
   ([credentials__1609__auto__]
    {:args [],
     :client :elasticloadbalancing,
     :fn :describe-load-balancer-policy-types,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :describe-load-balancer-policy-types,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-load-balancer-policy-types
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [request-metric-collector policy-type-names]}]]),
    :doc "Call describeLoadBalancerPolicyTypes, describeLoadBalancerPolicyTypes"}
   [credentials4064 & args4065]
   (clojure.core/let
    [^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client4066
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4064)]
    (clojure.core/case
     (clojure.core/count args4065)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client4066
       describeLoadBalancerPolicyTypes))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client4066
       describeLoadBalancerPolicyTypes
       (describe-load-balancer-policy-types-request
        (clojure.core/nth args4065 0))))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :delete-load-balancer-policy
   [m4067]
   (clojure.core/let
    [credentials4068 (:credentials m4067) args4069 (:args m4067)]
    (clojure.core/let
     [^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client4070
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4068)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client4070
       deleteLoadBalancerPolicy
       (delete-load-balancer-policy-request
        (clojure.core/nth args4069 0)))))))
  (clojure.core/defn
   delete-load-balancer-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         policy-name
                         load-balancer-name]}]]),
    :doc "Generate map for deleteLoadBalancerPolicy"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :delete-load-balancer-policy,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   delete-load-balancer-policy
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         policy-name
                         load-balancer-name]}]]),
    :doc "Call deleteLoadBalancerPolicy"}
   [credentials4072 & args4073]
   (clojure.core/let
    [^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client4074
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4072)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client4074
      deleteLoadBalancerPolicy
      (delete-load-balancer-policy-request
       (clojure.core/nth args4073 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :create-load-balancer-policy
   [m4075]
   (clojure.core/let
    [credentials4076 (:credentials m4075) args4077 (:args m4075)]
    (clojure.core/let
     [^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client4078
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4076)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client4078
       createLoadBalancerPolicy
       (create-load-balancer-policy-request
        (clojure.core/nth args4077 0)))))))
  (clojure.core/defn
   create-load-balancer-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         policy-type-name
                         policy-name
                         policy-attributes
                         load-balancer-name]}]]),
    :doc "Generate map for createLoadBalancerPolicy"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :create-load-balancer-policy,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   create-load-balancer-policy
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         policy-type-name
                         policy-name
                         policy-attributes
                         load-balancer-name]}]]),
    :doc "Call createLoadBalancerPolicy"}
   [credentials4080 & args4081]
   (clojure.core/let
    [^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client4082
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4080)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client4082
      createLoadBalancerPolicy
      (create-load-balancer-policy-request
       (clojure.core/nth args4081 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :configure-health-check
   [m4083]
   (clojure.core/let
    [credentials4084 (:credentials m4083) args4085 (:args m4083)]
    (clojure.core/let
     [^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client4086
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4084)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client4086
       configureHealthCheck
       (configure-health-check-request (clojure.core/nth args4085 0)))))))
  (clojure.core/defn
   configure-health-check-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         load-balancer-name
                         health-check]}]]),
    :doc "Generate map for configureHealthCheck"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :configure-health-check,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   configure-health-check
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         load-balancer-name
                         health-check]}]]),
    :doc "Call configureHealthCheck"}
   [credentials4088 & args4089]
   (clojure.core/let
    [^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client4090
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4088)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client4090
      configureHealthCheck
      (configure-health-check-request (clojure.core/nth args4089 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :describe-instance-health
   [m4091]
   (clojure.core/let
    [credentials4092 (:credentials m4091) args4093 (:args m4091)]
    (clojure.core/let
     [^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client4094
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4092)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client4094
       describeInstanceHealth
       (describe-instance-health-request
        (clojure.core/nth args4093 0)))))))
  (clojure.core/defn
   describe-instance-health-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         load-balancer-name
                         instances]}]]),
    :doc "Generate map for describeInstanceHealth"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :describe-instance-health,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-instance-health
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         load-balancer-name
                         instances]}]]),
    :doc "Call describeInstanceHealth"}
   [credentials4096 & args4097]
   (clojure.core/let
    [^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client4098
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4096)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client4098
      describeInstanceHealth
      (describe-instance-health-request (clojure.core/nth args4097 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :create-load-balancer
   [m4099]
   (clojure.core/let
    [credentials4100 (:credentials m4099) args4101 (:args m4099)]
    (clojure.core/let
     [^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client4102
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4100)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client4102
       createLoadBalancer
       (create-load-balancer-request (clojure.core/nth args4101 0)))))))
  (clojure.core/defn
   create-load-balancer-map
   {:arglists (quote
               [[credentials
                 {:keys [listeners
                         security-groups
                         subnets
                         load-balancer-name
                         request-metric-collector
                         availability-zones
                         scheme]}]]),
    :doc "Generate map for createLoadBalancer"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :create-load-balancer,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   create-load-balancer
   {:arglists (quote
               [[credentials
                 {:keys [listeners
                         security-groups
                         subnets
                         load-balancer-name
                         request-metric-collector
                         availability-zones
                         scheme]}]]),
    :doc "Call createLoadBalancer"}
   [credentials4104 & args4105]
   (clojure.core/let
    [^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client4106
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4104)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client4106
      createLoadBalancer
      (create-load-balancer-request (clojure.core/nth args4105 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :set-load-balancer-policies-for-backend-server
   [m4107]
   (clojure.core/let
    [credentials4108 (:credentials m4107) args4109 (:args m4107)]
    (clojure.core/let
     [^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client4110
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4108)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client4110
       setLoadBalancerPoliciesForBackendServer
       (set-load-balancer-policies-for-backend-server-request
        (clojure.core/nth args4109 0)))))))
  (clojure.core/defn
   set-load-balancer-policies-for-backend-server-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         policy-names
                         load-balancer-name
                         instance-port]}]]),
    :doc "Generate map for setLoadBalancerPoliciesForBackendServer"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :set-load-balancer-policies-for-backend-server,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   set-load-balancer-policies-for-backend-server
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         policy-names
                         load-balancer-name
                         instance-port]}]]),
    :doc "Call setLoadBalancerPoliciesForBackendServer"}
   [credentials4112 & args4113]
   (clojure.core/let
    [^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client4114
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4112)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client4114
      setLoadBalancerPoliciesForBackendServer
      (set-load-balancer-policies-for-backend-server-request
       (clojure.core/nth args4113 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :disable-availability-zones-for-load-balancer
   [m4115]
   (clojure.core/let
    [credentials4116 (:credentials m4115) args4117 (:args m4115)]
    (clojure.core/let
     [^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client4118
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4116)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client4118
       disableAvailabilityZonesForLoadBalancer
       (disable-availability-zones-for-load-balancer-request
        (clojure.core/nth args4117 0)))))))
  (clojure.core/defn
   disable-availability-zones-for-load-balancer-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         load-balancer-name
                         availability-zones]}]]),
    :doc "Generate map for disableAvailabilityZonesForLoadBalancer"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :disable-availability-zones-for-load-balancer,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   disable-availability-zones-for-load-balancer
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         load-balancer-name
                         availability-zones]}]]),
    :doc "Call disableAvailabilityZonesForLoadBalancer"}
   [credentials4120 & args4121]
   (clojure.core/let
    [^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client4122
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4120)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client4122
      disableAvailabilityZonesForLoadBalancer
      (disable-availability-zones-for-load-balancer-request
       (clojure.core/nth args4121 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :detach-load-balancer-from-subnets
   [m4123]
   (clojure.core/let
    [credentials4124 (:credentials m4123) args4125 (:args m4123)]
    (clojure.core/let
     [^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client4126
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4124)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client4126
       detachLoadBalancerFromSubnets
       (detach-load-balancer-from-subnets-request
        (clojure.core/nth args4125 0)))))))
  (clojure.core/defn
   detach-load-balancer-from-subnets-map
   {:arglists (quote
               [[credentials
                 {:keys [subnets
                         request-metric-collector
                         load-balancer-name]}]]),
    :doc "Generate map for detachLoadBalancerFromSubnets"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :detach-load-balancer-from-subnets,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   detach-load-balancer-from-subnets
   {:arglists (quote
               [[credentials
                 {:keys [subnets
                         request-metric-collector
                         load-balancer-name]}]]),
    :doc "Call detachLoadBalancerFromSubnets"}
   [credentials4128 & args4129]
   (clojure.core/let
    [^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client4130
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4128)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client4130
      detachLoadBalancerFromSubnets
      (detach-load-balancer-from-subnets-request
       (clojure.core/nth args4129 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :create-load-balancer-listeners
   [m4131]
   (clojure.core/let
    [credentials4132 (:credentials m4131) args4133 (:args m4131)]
    (clojure.core/let
     [^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client4134
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4132)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client4134
       createLoadBalancerListeners
       (create-load-balancer-listeners-request
        (clojure.core/nth args4133 0)))))))
  (clojure.core/defn
   create-load-balancer-listeners-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         load-balancer-name
                         listeners]}]]),
    :doc "Generate map for createLoadBalancerListeners"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :create-load-balancer-listeners,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   create-load-balancer-listeners
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         load-balancer-name
                         listeners]}]]),
    :doc "Call createLoadBalancerListeners"}
   [credentials4136 & args4137]
   (clojure.core/let
    [^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client4138
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4136)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client4138
      createLoadBalancerListeners
      (create-load-balancer-listeners-request
       (clojure.core/nth args4137 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :delete-load-balancer-listeners
   [m4139]
   (clojure.core/let
    [credentials4140 (:credentials m4139) args4141 (:args m4139)]
    (clojure.core/let
     [^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client4142
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4140)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client4142
       deleteLoadBalancerListeners
       (delete-load-balancer-listeners-request
        (clojure.core/nth args4141 0)))))))
  (clojure.core/defn
   delete-load-balancer-listeners-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         load-balancer-ports
                         load-balancer-name]}]]),
    :doc "Generate map for deleteLoadBalancerListeners"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :delete-load-balancer-listeners,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   delete-load-balancer-listeners
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         load-balancer-ports
                         load-balancer-name]}]]),
    :doc "Call deleteLoadBalancerListeners"}
   [credentials4144 & args4145]
   (clojure.core/let
    [^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client4146
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4144)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client4146
      deleteLoadBalancerListeners
      (delete-load-balancer-listeners-request
       (clojure.core/nth args4145 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :set-load-balancer-listener-sslcertificate
   [m4147]
   (clojure.core/let
    [credentials4148 (:credentials m4147) args4149 (:args m4147)]
    (clojure.core/let
     [^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client4150
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4148)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client4150
       setLoadBalancerListenerSSLCertificate
       (set-load-balancer-listener-sslcertificate-request
        (clojure.core/nth args4149 0)))))))
  (clojure.core/defn
   set-load-balancer-listener-sslcertificate-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         load-balancer-port
                         load-balancer-name
                         sslcertificate-id]}]]),
    :doc "Generate map for setLoadBalancerListenerSSLCertificate"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :set-load-balancer-listener-sslcertificate,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   set-load-balancer-listener-sslcertificate
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         load-balancer-port
                         load-balancer-name
                         sslcertificate-id]}]]),
    :doc "Call setLoadBalancerListenerSSLCertificate"}
   [credentials4152 & args4153]
   (clojure.core/let
    [^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client4154
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4152)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client4154
      setLoadBalancerListenerSSLCertificate
      (set-load-balancer-listener-sslcertificate-request
       (clojure.core/nth args4153 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :register-instances-with-load-balancer
   [m4155]
   (clojure.core/let
    [credentials4156 (:credentials m4155) args4157 (:args m4155)]
    (clojure.core/let
     [^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client4158
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4156)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client4158
       registerInstancesWithLoadBalancer
       (register-instances-with-load-balancer-request
        (clojure.core/nth args4157 0)))))))
  (clojure.core/defn
   register-instances-with-load-balancer-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         load-balancer-name
                         instances]}]]),
    :doc "Generate map for registerInstancesWithLoadBalancer"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :register-instances-with-load-balancer,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   register-instances-with-load-balancer
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         load-balancer-name
                         instances]}]]),
    :doc "Call registerInstancesWithLoadBalancer"}
   [credentials4160 & args4161]
   (clojure.core/let
    [^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client4162
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4160)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client4162
      registerInstancesWithLoadBalancer
      (register-instances-with-load-balancer-request
       (clojure.core/nth args4161 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :set-load-balancer-policies-of-listener
   [m4163]
   (clojure.core/let
    [credentials4164 (:credentials m4163) args4165 (:args m4163)]
    (clojure.core/let
     [^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client4166
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4164)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client4166
       setLoadBalancerPoliciesOfListener
       (set-load-balancer-policies-of-listener-request
        (clojure.core/nth args4165 0)))))))
  (clojure.core/defn
   set-load-balancer-policies-of-listener-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         policy-names
                         load-balancer-port
                         load-balancer-name]}]]),
    :doc "Generate map for setLoadBalancerPoliciesOfListener"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :set-load-balancer-policies-of-listener,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   set-load-balancer-policies-of-listener
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         policy-names
                         load-balancer-port
                         load-balancer-name]}]]),
    :doc "Call setLoadBalancerPoliciesOfListener"}
   [credentials4168 & args4169]
   (clojure.core/let
    [^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client4170
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4168)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client4170
      setLoadBalancerPoliciesOfListener
      (set-load-balancer-policies-of-listener-request
       (clojure.core/nth args4169 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :attach-load-balancer-to-subnets
   [m4171]
   (clojure.core/let
    [credentials4172 (:credentials m4171) args4173 (:args m4171)]
    (clojure.core/let
     [^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client4174
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4172)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client4174
       attachLoadBalancerToSubnets
       (attach-load-balancer-to-subnets-request
        (clojure.core/nth args4173 0)))))))
  (clojure.core/defn
   attach-load-balancer-to-subnets-map
   {:arglists (quote
               [[credentials
                 {:keys [subnets
                         request-metric-collector
                         load-balancer-name]}]]),
    :doc "Generate map for attachLoadBalancerToSubnets"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :attach-load-balancer-to-subnets,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   attach-load-balancer-to-subnets
   {:arglists (quote
               [[credentials
                 {:keys [subnets
                         request-metric-collector
                         load-balancer-name]}]]),
    :doc "Call attachLoadBalancerToSubnets"}
   [credentials4176 & args4177]
   (clojure.core/let
    [^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client4178
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4176)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client4178
      attachLoadBalancerToSubnets
      (attach-load-balancer-to-subnets-request
       (clojure.core/nth args4177 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :describe-load-balancers
   [m4179]
   (clojure.core/let
    [credentials4180 (:credentials m4179) args4181 (:args m4179)]
    (clojure.core/let
     [^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client4182
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4180)]
     (clojure.core/case
      (clojure.core/count args4181)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client4182
        describeLoadBalancers
        (describe-load-balancers-request
         (clojure.core/nth args4181 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client4182
        describeLoadBalancers))))))
  (clojure.core/defn
   describe-load-balancers-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         marker
                         load-balancer-names]}]
                [credentials]]),
    :doc "Generate map for describeLoadBalancers, describeLoadBalancers"}
   ([credentials__1609__auto__]
    {:args [],
     :client :elasticloadbalancing,
     :fn :describe-load-balancers,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :describe-load-balancers,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-load-balancers
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         marker
                         load-balancer-names]}]
                [credentials]]),
    :doc "Call describeLoadBalancers, describeLoadBalancers"}
   [credentials4184 & args4185]
   (clojure.core/let
    [^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client4186
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4184)]
    (clojure.core/case
     (clojure.core/count args4185)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client4186
       describeLoadBalancers
       (describe-load-balancers-request (clojure.core/nth args4185 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client4186
       describeLoadBalancers))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :create-app-cookie-stickiness-policy
   [m4187]
   (clojure.core/let
    [credentials4188 (:credentials m4187) args4189 (:args m4187)]
    (clojure.core/let
     [^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client4190
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4188)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client4190
       createAppCookieStickinessPolicy
       (create-app-cookie-stickiness-policy-request
        (clojure.core/nth args4189 0)))))))
  (clojure.core/defn
   create-app-cookie-stickiness-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         policy-name
                         load-balancer-name
                         cookie-name]}]]),
    :doc "Generate map for createAppCookieStickinessPolicy"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :create-app-cookie-stickiness-policy,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   create-app-cookie-stickiness-policy
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         policy-name
                         load-balancer-name
                         cookie-name]}]]),
    :doc "Call createAppCookieStickinessPolicy"}
   [credentials4192 & args4193]
   (clojure.core/let
    [^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client4194
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4192)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient client4194
      createAppCookieStickinessPolicy
      (create-app-cookie-stickiness-policy-request
       (clojure.core/nth args4193 0))))))))
