(ns
 com.palletops.awaze.elasticmapreduce
 (:require [com.palletops.awaze.common]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :elasticmapreduce
  [___1561__auto__
   ^com.amazonaws.auth.BasicAWSCredentials credentials__1562__auto__]
  (new
   com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient
   credentials__1562__auto__))
 (clojure.core/defn
  ^com.amazonaws.services.elasticmapreduce.model.MarketType market-type
  [m3554]
  (java.lang.Enum/valueOf
   com.amazonaws.services.elasticmapreduce.model.MarketType
   (clojure.core/name m3554)))
 (clojure.core/defn
  ^com.amazonaws.services.elasticmapreduce.model.InstanceRoleType instance-role-type
  [m3557]
  (java.lang.Enum/valueOf
   com.amazonaws.services.elasticmapreduce.model.InstanceRoleType
   (clojure.core/name m3557)))
 (clojure.core/defn
  ^com.amazonaws.services.elasticmapreduce.model.KeyValue key-value
  [m3560]
  (clojure.core/let
   [bean3559
    (new com.amazonaws.services.elasticmapreduce.model.KeyValue)]
   (clojure.core/when-let
    [v3561 (:value m3560)]
    (. bean3559 setValue (clojure.core/str v3561)))
   (clojure.core/when-let
    [v3561 (:key m3560)]
    (. bean3559 setKey (clojure.core/str v3561)))
   bean3559))
 (clojure.core/defn
  ^com.amazonaws.services.elasticmapreduce.model.InstanceGroupConfig instance-group-config
  [m3563]
  (clojure.core/let
   [bean3562
    (new
     com.amazonaws.services.elasticmapreduce.model.InstanceGroupConfig)]
   (clojure.core/when-let
    [v3564 (:name m3563)]
    (. bean3562 setName (clojure.core/str v3564)))
   (clojure.core/when-let
    [v3564 (:instance-type m3563)]
    (. bean3562 setInstanceType (clojure.core/str v3564)))
   (clojure.core/when-let
    [v3564 (:market m3563)]
    (. bean3562 setMarket (clojure.core/str v3564)))
   (clojure.core/when-let
    [v3564 (:market m3563)]
    (. bean3562 setMarket (market-type v3564)))
   (clojure.core/when-let
    [v3564 (:instance-role m3563)]
    (. bean3562 setInstanceRole (clojure.core/str v3564)))
   (clojure.core/when-let
    [v3564 (:instance-role m3563)]
    (. bean3562 setInstanceRole (instance-role-type v3564)))
   (clojure.core/when-let
    [v3564 (:bid-price m3563)]
    (. bean3562 setBidPrice (clojure.core/str v3564)))
   (clojure.core/when-let
    [v3564 (:instance-count m3563)]
    (. bean3562 setInstanceCount (clojure.core/int v3564)))
   bean3562))
 (clojure.core/defn
  ^com.amazonaws.services.elasticmapreduce.model.PlacementType placement-type
  [m3566]
  (clojure.core/let
   [bean3565
    (new com.amazonaws.services.elasticmapreduce.model.PlacementType)]
   (clojure.core/when-let
    [v3567 (:availability-zone m3566)]
    (. bean3565 setAvailabilityZone (clojure.core/str v3567)))
   bean3565))
 (clojure.core/defn
  ^com.amazonaws.services.elasticmapreduce.model.ActionOnFailure action-on-failure
  [m3569]
  (java.lang.Enum/valueOf
   com.amazonaws.services.elasticmapreduce.model.ActionOnFailure
   (clojure.core/name m3569)))
 (clojure.core/defn
  ^com.amazonaws.services.elasticmapreduce.model.HadoopJarStepConfig hadoop-jar-step-config
  [m3572]
  (clojure.core/let
   [bean3571
    (new
     com.amazonaws.services.elasticmapreduce.model.HadoopJarStepConfig)]
   (clojure.core/when-let
    [v3573 (:properties m3572)]
    (.
     bean3571
     setProperties
     (clojure.core/map
      (clojure.core/fn [arg3577] (key-value arg3577))
      v3573)))
   (clojure.core/when-let
    [v3573 (:jar m3572)]
    (. bean3571 setJar (clojure.core/str v3573)))
   (clojure.core/when-let
    [v3573 (:main-class m3572)]
    (. bean3571 setMainClass (clojure.core/str v3573)))
   (clojure.core/when-let
    [v3573 (:args m3572)]
    (.
     bean3571
     setArgs
     (clojure.core/map
      (clojure.core/fn [arg3578] (clojure.core/str arg3578))
      v3573)))
   bean3571))
 (clojure.core/defn
  ^com.amazonaws.services.elasticmapreduce.model.ScriptBootstrapActionConfig script-bootstrap-action-config
  [m3575]
  (clojure.core/let
   [bean3574
    (new
     com.amazonaws.services.elasticmapreduce.model.ScriptBootstrapActionConfig)]
   (clojure.core/when-let
    [v3576 (:path m3575)]
    (. bean3574 setPath (clojure.core/str v3576)))
   (clojure.core/when-let
    [v3576 (:args m3575)]
    (.
     bean3574
     setArgs
     (clojure.core/map
      (clojure.core/fn [arg3582] (clojure.core/str arg3582))
      v3576)))
   bean3574))
 (clojure.core/defn
  ^com.amazonaws.services.elasticmapreduce.model.JobFlowInstancesConfig job-flow-instances-config
  [m3580]
  (clojure.core/let
   [bean3579
    (new
     com.amazonaws.services.elasticmapreduce.model.JobFlowInstancesConfig)]
   (clojure.core/when-let
    [v3581 (:termination-protected m3580)]
    (. bean3579 setTerminationProtected (clojure.core/boolean v3581)))
   (clojure.core/when-let
    [v3581 (:instance-groups m3580)]
    (.
     bean3579
     setInstanceGroups
     (clojure.core/map
      (clojure.core/fn [arg3586] (instance-group-config arg3586))
      v3581)))
   (clojure.core/when-let
    [v3581 (:master-instance-type m3580)]
    (. bean3579 setMasterInstanceType (clojure.core/str v3581)))
   (clojure.core/when-let
    [v3581 (:slave-instance-type m3580)]
    (. bean3579 setSlaveInstanceType (clojure.core/str v3581)))
   (clojure.core/when-let
    [v3581 (:instance-count m3580)]
    (. bean3579 setInstanceCount (clojure.core/int v3581)))
   (clojure.core/when-let
    [v3581 (:ec2key-name m3580)]
    (. bean3579 setEc2KeyName (clojure.core/str v3581)))
   (clojure.core/when-let
    [v3581 (:placement m3580)]
    (. bean3579 setPlacement (placement-type v3581)))
   (clojure.core/when-let
    [v3581 (:keep-job-flow-alive-when-no-steps m3580)]
    (.
     bean3579
     setKeepJobFlowAliveWhenNoSteps
     (clojure.core/boolean v3581)))
   (clojure.core/when-let
    [v3581 (:hadoop-version m3580)]
    (. bean3579 setHadoopVersion (clojure.core/str v3581)))
   (clojure.core/when-let
    [v3581 (:ec2subnet-id m3580)]
    (. bean3579 setEc2SubnetId (clojure.core/str v3581)))
   bean3579))
 (clojure.core/defn
  ^com.amazonaws.services.elasticmapreduce.model.StepConfig step-config
  [m3584]
  (clojure.core/let
   [bean3583
    (new com.amazonaws.services.elasticmapreduce.model.StepConfig)]
   (clojure.core/when-let
    [v3585 (:name m3584)]
    (. bean3583 setName (clojure.core/str v3585)))
   (clojure.core/when-let
    [v3585 (:action-on-failure m3584)]
    (. bean3583 setActionOnFailure (action-on-failure v3585)))
   (clojure.core/when-let
    [v3585 (:action-on-failure m3584)]
    (. bean3583 setActionOnFailure (clojure.core/str v3585)))
   (clojure.core/when-let
    [v3585 (:hadoop-jar-step m3584)]
    (. bean3583 setHadoopJarStep (hadoop-jar-step-config v3585)))
   bean3583))
 (clojure.core/defn
  ^com.amazonaws.services.elasticmapreduce.model.BootstrapActionConfig bootstrap-action-config
  [m3588]
  (clojure.core/let
   [bean3587
    (new
     com.amazonaws.services.elasticmapreduce.model.BootstrapActionConfig)]
   (clojure.core/when-let
    [v3589 (:name m3588)]
    (. bean3587 setName (clojure.core/str v3589)))
   (clojure.core/when-let
    [v3589 (:script-bootstrap-action m3588)]
    (.
     bean3587
     setScriptBootstrapAction
     (script-bootstrap-action-config v3589)))
   bean3587))
 (clojure.core/defn
  ^com.amazonaws.services.elasticmapreduce.model.SupportedProductConfig supported-product-config
  [m3591]
  (clojure.core/let
   [bean3590
    (new
     com.amazonaws.services.elasticmapreduce.model.SupportedProductConfig)]
   (clojure.core/when-let
    [v3592 (:name m3591)]
    (. bean3590 setName (clojure.core/str v3592)))
   (clojure.core/when-let
    [v3592 (:args m3591)]
    (.
     bean3590
     setArgs
     (clojure.core/map
      (clojure.core/fn [arg3596] (clojure.core/str arg3596))
      v3592)))
   bean3590))
 (clojure.core/defn
  ^com.amazonaws.services.elasticmapreduce.model.InstanceGroupModifyConfig instance-group-modify-config
  [m3594]
  (clojure.core/let
   [bean3593
    (new
     com.amazonaws.services.elasticmapreduce.model.InstanceGroupModifyConfig)]
   (clojure.core/when-let
    [v3595 (:instance-group-id m3594)]
    (. bean3593 setInstanceGroupId (clojure.core/str v3595)))
   (clojure.core/when-let
    [v3595 (:instance-count m3594)]
    (. bean3593 setInstanceCount (clojure.core/int v3595)))
   (clojure.core/when-let
    [v3595 (:ec2instance-ids-to-terminate m3594)]
    (.
     bean3593
     setEC2InstanceIdsToTerminate
     (clojure.core/map
      (clojure.core/fn [arg3600] (clojure.core/str arg3600))
      v3595)))
   bean3593))
 (clojure.core/defn
  ^com.amazonaws.services.elasticmapreduce.model.RunJobFlowRequest run-job-flow-request
  [m3598]
  (clojure.core/let
   [bean3597
    (new
     com.amazonaws.services.elasticmapreduce.model.RunJobFlowRequest)]
   (clojure.core/when-let
    [v3599 (:name m3598)]
    (. bean3597 setName (clojure.core/str v3599)))
   (clojure.core/when-let
    [v3599 (:visible-to-all-users m3598)]
    (. bean3597 setVisibleToAllUsers (clojure.core/boolean v3599)))
   (clojure.core/when-let
    [v3599 (:log-uri m3598)]
    (. bean3597 setLogUri (clojure.core/str v3599)))
   (clojure.core/when-let
    [v3599 (:additional-info m3598)]
    (. bean3597 setAdditionalInfo (clojure.core/str v3599)))
   (clojure.core/when-let
    [v3599 (:ami-version m3598)]
    (. bean3597 setAmiVersion (clojure.core/str v3599)))
   (clojure.core/when-let
    [v3599 (:instances m3598)]
    (. bean3597 setInstances (job-flow-instances-config v3599)))
   (clojure.core/when-let
    [v3599 (:steps m3598)]
    (.
     bean3597
     setSteps
     (clojure.core/map
      (clojure.core/fn [arg3604] (step-config arg3604))
      v3599)))
   (clojure.core/when-let
    [v3599 (:bootstrap-actions m3598)]
    (.
     bean3597
     setBootstrapActions
     (clojure.core/map
      (clojure.core/fn [arg3605] (bootstrap-action-config arg3605))
      v3599)))
   (clojure.core/when-let
    [v3599 (:supported-products m3598)]
    (.
     bean3597
     setSupportedProducts
     (clojure.core/map
      (clojure.core/fn [arg3606] (clojure.core/str arg3606))
      v3599)))
   (clojure.core/when-let
    [v3599 (:new-supported-products m3598)]
    (.
     bean3597
     setNewSupportedProducts
     (clojure.core/map
      (clojure.core/fn [arg3607] (supported-product-config arg3607))
      v3599)))
   (clojure.core/when-let
    [v3599 (:job-flow-role m3598)]
    (. bean3597 setJobFlowRole (clojure.core/str v3599)))
   bean3597))
 (clojure.core/defn
  ^com.amazonaws.services.elasticmapreduce.model.ListBootstrapActionsRequest list-bootstrap-actions-request
  [m3602]
  (clojure.core/let
   [bean3601
    (new
     com.amazonaws.services.elasticmapreduce.model.ListBootstrapActionsRequest)]
   (clojure.core/when-let
    [v3603 (:marker m3602)]
    (. bean3601 setMarker (clojure.core/str v3603)))
   (clojure.core/when-let
    [v3603 (:cluster-id m3602)]
    (. bean3601 setClusterId (clojure.core/str v3603)))
   bean3601))
 (clojure.core/defn
  ^com.amazonaws.services.elasticmapreduce.model.ListInstanceGroupsRequest list-instance-groups-request
  [m3609]
  (clojure.core/let
   [bean3608
    (new
     com.amazonaws.services.elasticmapreduce.model.ListInstanceGroupsRequest)]
   (clojure.core/when-let
    [v3610 (:marker m3609)]
    (. bean3608 setMarker (clojure.core/str v3610)))
   (clojure.core/when-let
    [v3610 (:cluster-id m3609)]
    (. bean3608 setClusterId (clojure.core/str v3610)))
   bean3608))
 (clojure.core/defn
  ^com.amazonaws.services.elasticmapreduce.model.SetVisibleToAllUsersRequest set-visible-to-all-users-request
  [m3612]
  (clojure.core/let
   [bean3611
    (new
     com.amazonaws.services.elasticmapreduce.model.SetVisibleToAllUsersRequest)]
   (clojure.core/when-let
    [v3613 (:visible-to-all-users m3612)]
    (. bean3611 setVisibleToAllUsers (clojure.core/boolean v3613)))
   (clojure.core/when-let
    [v3613 (:job-flow-ids m3612)]
    (.
     bean3611
     setJobFlowIds
     (clojure.core/map
      (clojure.core/fn [arg3617] (clojure.core/str arg3617))
      v3613)))
   bean3611))
 (clojure.core/defn
  ^com.amazonaws.services.elasticmapreduce.model.ModifyInstanceGroupsRequest modify-instance-groups-request
  [m3615]
  (clojure.core/let
   [bean3614
    (new
     com.amazonaws.services.elasticmapreduce.model.ModifyInstanceGroupsRequest)]
   (clojure.core/when-let
    [v3616 (:instance-groups m3615)]
    (.
     bean3614
     setInstanceGroups
     (clojure.core/map
      (clojure.core/fn
       [arg3621]
       (instance-group-modify-config arg3621))
      v3616)))
   bean3614))
 (clojure.core/defn
  ^com.amazonaws.services.elasticmapreduce.model.DescribeClusterRequest describe-cluster-request
  [m3619]
  (clojure.core/let
   [bean3618
    (new
     com.amazonaws.services.elasticmapreduce.model.DescribeClusterRequest)]
   (clojure.core/when-let
    [v3620 (:cluster-id m3619)]
    (. bean3618 setClusterId (clojure.core/str v3620)))
   bean3618))
 (clojure.core/defn
  ^com.amazonaws.services.elasticmapreduce.model.SetTerminationProtectionRequest set-termination-protection-request
  [m3623]
  (clojure.core/let
   [bean3622
    (new
     com.amazonaws.services.elasticmapreduce.model.SetTerminationProtectionRequest)]
   (clojure.core/when-let
    [v3624 (:job-flow-ids m3623)]
    (.
     bean3622
     setJobFlowIds
     (clojure.core/map
      (clojure.core/fn [arg3628] (clojure.core/str arg3628))
      v3624)))
   (clojure.core/when-let
    [v3624 (:termination-protected m3623)]
    (. bean3622 setTerminationProtected (clojure.core/boolean v3624)))
   bean3622))
 (clojure.core/defn
  ^com.amazonaws.services.elasticmapreduce.model.AddInstanceGroupsRequest add-instance-groups-request
  [m3626]
  (clojure.core/let
   [bean3625
    (new
     com.amazonaws.services.elasticmapreduce.model.AddInstanceGroupsRequest)]
   (clojure.core/when-let
    [v3627 (:instance-groups m3626)]
    (.
     bean3625
     setInstanceGroups
     (clojure.core/map
      (clojure.core/fn [arg3632] (instance-group-config arg3632))
      v3627)))
   (clojure.core/when-let
    [v3627 (:job-flow-id m3626)]
    (. bean3625 setJobFlowId (clojure.core/str v3627)))
   bean3625))
 (clojure.core/defn
  ^com.amazonaws.services.elasticmapreduce.model.DescribeStepRequest describe-step-request
  [m3630]
  (clojure.core/let
   [bean3629
    (new
     com.amazonaws.services.elasticmapreduce.model.DescribeStepRequest)]
   (clojure.core/when-let
    [v3631 (:cluster-id m3630)]
    (. bean3629 setClusterId (clojure.core/str v3631)))
   (clojure.core/when-let
    [v3631 (:step-id m3630)]
    (. bean3629 setStepId (clojure.core/str v3631)))
   bean3629))
 (clojure.core/defn
  ^com.amazonaws.services.elasticmapreduce.model.TerminateJobFlowsRequest terminate-job-flows-request
  [m3634]
  (clojure.core/let
   [bean3633
    (new
     com.amazonaws.services.elasticmapreduce.model.TerminateJobFlowsRequest)]
   (clojure.core/when-let
    [v3635 (:job-flow-ids m3634)]
    (.
     bean3633
     setJobFlowIds
     (clojure.core/map
      (clojure.core/fn [arg3639] (clojure.core/str arg3639))
      v3635)))
   bean3633))
 (clojure.core/defn
  ^com.amazonaws.services.elasticmapreduce.model.ListInstancesRequest list-instances-request
  [m3637]
  (clojure.core/let
   [bean3636
    (new
     com.amazonaws.services.elasticmapreduce.model.ListInstancesRequest)]
   (clojure.core/when-let
    [v3638 (:marker m3637)]
    (. bean3636 setMarker (clojure.core/str v3638)))
   (clojure.core/when-let
    [v3638 (:cluster-id m3637)]
    (. bean3636 setClusterId (clojure.core/str v3638)))
   (clojure.core/when-let
    [v3638 (:instance-group-id m3637)]
    (. bean3636 setInstanceGroupId (clojure.core/str v3638)))
   (clojure.core/when-let
    [v3638 (:instance-group-types m3637)]
    (.
     bean3636
     setInstanceGroupTypes
     (clojure.core/map
      (clojure.core/fn [arg3643] (clojure.core/str arg3643))
      v3638)))
   bean3636))
 (clojure.core/defn
  ^com.amazonaws.services.elasticmapreduce.model.ListClustersRequest list-clusters-request
  [m3641]
  (clojure.core/let
   [bean3640
    (new
     com.amazonaws.services.elasticmapreduce.model.ListClustersRequest)]
   (clojure.core/when-let
    [v3642 (:marker m3641)]
    (. bean3640 setMarker (clojure.core/str v3642)))
   (clojure.core/when-let
    [v3642 (:created-after m3641)]
    (.
     bean3640
     setCreatedAfter
     (com.palletops.awaze.common/to-date v3642)))
   (clojure.core/when-let
    [v3642 (:created-before m3641)]
    (.
     bean3640
     setCreatedBefore
     (com.palletops.awaze.common/to-date v3642)))
   (clojure.core/when-let
    [v3642 (:cluster-states m3641)]
    (.
     bean3640
     setClusterStates
     (clojure.core/map
      (clojure.core/fn [arg3647] (clojure.core/str arg3647))
      v3642)))
   bean3640))
 (clojure.core/defn
  ^com.amazonaws.services.elasticmapreduce.model.AddJobFlowStepsRequest add-job-flow-steps-request
  [m3645]
  (clojure.core/let
   [bean3644
    (new
     com.amazonaws.services.elasticmapreduce.model.AddJobFlowStepsRequest)]
   (clojure.core/when-let
    [v3646 (:steps m3645)]
    (.
     bean3644
     setSteps
     (clojure.core/map
      (clojure.core/fn [arg3651] (step-config arg3651))
      v3646)))
   (clojure.core/when-let
    [v3646 (:job-flow-id m3645)]
    (. bean3644 setJobFlowId (clojure.core/str v3646)))
   bean3644))
 (clojure.core/defn
  ^com.amazonaws.services.elasticmapreduce.model.ListStepsRequest list-steps-request
  [m3649]
  (clojure.core/let
   [bean3648
    (new
     com.amazonaws.services.elasticmapreduce.model.ListStepsRequest)]
   (clojure.core/when-let
    [v3650 (:marker m3649)]
    (. bean3648 setMarker (clojure.core/str v3650)))
   (clojure.core/when-let
    [v3650 (:cluster-id m3649)]
    (. bean3648 setClusterId (clojure.core/str v3650)))
   (clojure.core/when-let
    [v3650 (:step-states m3649)]
    (.
     bean3648
     setStepStates
     (clojure.core/map
      (clojure.core/fn [arg3655] (clojure.core/str arg3655))
      v3650)))
   bean3648))
 (clojure.core/defn
  ^com.amazonaws.services.elasticmapreduce.model.DescribeJobFlowsRequest describe-job-flows-request
  [m3653]
  (clojure.core/let
   [bean3652
    (new
     com.amazonaws.services.elasticmapreduce.model.DescribeJobFlowsRequest)]
   (clojure.core/when-let
    [v3654 (:job-flow-ids m3653)]
    (.
     bean3652
     setJobFlowIds
     (clojure.core/map
      (clojure.core/fn [arg3656] (clojure.core/str arg3656))
      v3654)))
   (clojure.core/when-let
    [v3654 (:created-after m3653)]
    (.
     bean3652
     setCreatedAfter
     (com.palletops.awaze.common/to-date v3654)))
   (clojure.core/when-let
    [v3654 (:created-before m3653)]
    (.
     bean3652
     setCreatedBefore
     (com.palletops.awaze.common/to-date v3654)))
   (clojure.core/when-let
    [v3654 (:job-flow-states m3653)]
    (.
     bean3652
     setJobFlowStates
     (clojure.core/map
      (clojure.core/fn [arg3657] (clojure.core/str arg3657))
      v3654)))
   bean3652))
 (clojure.core/defmulti
  elasticmapreduce
  (clojure.core/fn
   elasticmapreduce
   [m__1641__auto__]
   (:fn m__1641__auto__)))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :run-job-flow
   [m3658]
   (clojure.core/let
    [credentials3659 (:credentials m3658) args3660 (:args m3658)]
    (clojure.core/let
     [^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client3661
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials3659)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client3661
       runJobFlow
       (run-job-flow-request (clojure.core/nth args3660 0)))))))
  (clojure.core/defn
   run-job-flow-map
   {:arglists (quote
               [[credentials
                 {:keys [job-flow-role
                         request-metric-collector
                         additional-info
                         name
                         log-uri
                         bootstrap-actions
                         visible-to-all-users
                         supported-products
                         ami-version
                         steps
                         new-supported-products
                         instances]}]]),
    :doc "Generate map for runJobFlow"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :elasticmapreduce,
     :fn :run-job-flow,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   run-job-flow
   {:arglists (quote
               [[credentials
                 {:keys [job-flow-role
                         request-metric-collector
                         additional-info
                         name
                         log-uri
                         bootstrap-actions
                         visible-to-all-users
                         supported-products
                         ami-version
                         steps
                         new-supported-products
                         instances]}]]),
    :doc "Call runJobFlow"}
   [credentials3663 & args3664]
   (clojure.core/let
    [^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client3665
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials3663)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client3665
      runJobFlow
      (run-job-flow-request (clojure.core/nth args3664 0)))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :list-bootstrap-actions
   [m3666]
   (clojure.core/let
    [credentials3667 (:credentials m3666) args3668 (:args m3666)]
    (clojure.core/let
     [^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client3669
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials3667)]
     (clojure.core/case
      (clojure.core/count args3668)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client3669
        listBootstrapActions
        (list-bootstrap-actions-request (clojure.core/nth args3668 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client3669
        listBootstrapActions))))))
  (clojure.core/defn
   list-bootstrap-actions-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector marker cluster-id]}]
                [credentials]]),
    :doc "Generate map for listBootstrapActions, listBootstrapActions"}
   ([credentials__1609__auto__]
    {:args [],
     :client :elasticmapreduce,
     :fn :list-bootstrap-actions,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :elasticmapreduce,
     :fn :list-bootstrap-actions,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   list-bootstrap-actions
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector marker cluster-id]}]
                [credentials]]),
    :doc "Call listBootstrapActions, listBootstrapActions"}
   [credentials3671 & args3672]
   (clojure.core/let
    [^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client3673
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials3671)]
    (clojure.core/case
     (clojure.core/count args3672)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client3673
       listBootstrapActions
       (list-bootstrap-actions-request (clojure.core/nth args3672 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client3673
       listBootstrapActions))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :list-instance-groups
   [m3674]
   (clojure.core/let
    [credentials3675 (:credentials m3674) args3676 (:args m3674)]
    (clojure.core/let
     [^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client3677
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials3675)]
     (clojure.core/case
      (clojure.core/count args3676)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client3677
        listInstanceGroups
        (list-instance-groups-request (clojure.core/nth args3676 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client3677
        listInstanceGroups))))))
  (clojure.core/defn
   list-instance-groups-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector marker cluster-id]}]
                [credentials]]),
    :doc "Generate map for listInstanceGroups, listInstanceGroups"}
   ([credentials__1609__auto__]
    {:args [],
     :client :elasticmapreduce,
     :fn :list-instance-groups,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :elasticmapreduce,
     :fn :list-instance-groups,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   list-instance-groups
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector marker cluster-id]}]
                [credentials]]),
    :doc "Call listInstanceGroups, listInstanceGroups"}
   [credentials3679 & args3680]
   (clojure.core/let
    [^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client3681
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials3679)]
    (clojure.core/case
     (clojure.core/count args3680)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client3681
       listInstanceGroups
       (list-instance-groups-request (clojure.core/nth args3680 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client3681
       listInstanceGroups))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :set-visible-to-all-users
   [m3682]
   (clojure.core/let
    [credentials3683 (:credentials m3682) args3684 (:args m3682)]
    (clojure.core/let
     [^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client3685
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials3683)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client3685
       setVisibleToAllUsers
       (set-visible-to-all-users-request
        (clojure.core/nth args3684 0)))))))
  (clojure.core/defn
   set-visible-to-all-users-map
   {:arglists (quote
               [[credentials
                 {:keys [visible-to-all-users
                         request-metric-collector
                         job-flow-ids]}]]),
    :doc "Generate map for setVisibleToAllUsers"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :elasticmapreduce,
     :fn :set-visible-to-all-users,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   set-visible-to-all-users
   {:arglists (quote
               [[credentials
                 {:keys [visible-to-all-users
                         request-metric-collector
                         job-flow-ids]}]]),
    :doc "Call setVisibleToAllUsers"}
   [credentials3687 & args3688]
   (clojure.core/let
    [^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client3689
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials3687)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client3689
      setVisibleToAllUsers
      (set-visible-to-all-users-request (clojure.core/nth args3688 0)))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :modify-instance-groups
   [m3690]
   (clojure.core/let
    [credentials3691 (:credentials m3690) args3692 (:args m3690)]
    (clojure.core/let
     [^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client3693
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials3691)]
     (clojure.core/case
      (clojure.core/count args3692)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client3693
        modifyInstanceGroups))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client3693
        modifyInstanceGroups
        (modify-instance-groups-request (clojure.core/nth args3692 0))))))))
  (clojure.core/defn
   modify-instance-groups-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [request-metric-collector instance-groups]}]]),
    :doc "Generate map for modifyInstanceGroups, modifyInstanceGroups"}
   ([credentials__1609__auto__]
    {:args [],
     :client :elasticmapreduce,
     :fn :modify-instance-groups,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :elasticmapreduce,
     :fn :modify-instance-groups,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   modify-instance-groups
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [request-metric-collector instance-groups]}]]),
    :doc "Call modifyInstanceGroups, modifyInstanceGroups"}
   [credentials3695 & args3696]
   (clojure.core/let
    [^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client3697
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials3695)]
    (clojure.core/case
     (clojure.core/count args3696)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client3697
       modifyInstanceGroups))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client3697
       modifyInstanceGroups
       (modify-instance-groups-request (clojure.core/nth args3696 0))))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :describe-cluster
   [m3698]
   (clojure.core/let
    [credentials3699 (:credentials m3698) args3700 (:args m3698)]
    (clojure.core/let
     [^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client3701
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials3699)]
     (clojure.core/case
      (clojure.core/count args3700)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client3701
        describeCluster
        (describe-cluster-request (clojure.core/nth args3700 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client3701
        describeCluster))))))
  (clojure.core/defn
   describe-cluster-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector cluster-id]}]
                [credentials]]),
    :doc "Generate map for describeCluster, describeCluster"}
   ([credentials__1609__auto__]
    {:args [],
     :client :elasticmapreduce,
     :fn :describe-cluster,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :elasticmapreduce,
     :fn :describe-cluster,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-cluster
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector cluster-id]}]
                [credentials]]),
    :doc "Call describeCluster, describeCluster"}
   [credentials3703 & args3704]
   (clojure.core/let
    [^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client3705
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials3703)]
    (clojure.core/case
     (clojure.core/count args3704)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client3705
       describeCluster
       (describe-cluster-request (clojure.core/nth args3704 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client3705
       describeCluster))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :set-termination-protection
   [m3706]
   (clojure.core/let
    [credentials3707 (:credentials m3706) args3708 (:args m3706)]
    (clojure.core/let
     [^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client3709
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials3707)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client3709
       setTerminationProtection
       (set-termination-protection-request
        (clojure.core/nth args3708 0)))))))
  (clojure.core/defn
   set-termination-protection-map
   {:arglists (quote
               [[credentials
                 {:keys [termination-protected
                         request-metric-collector
                         job-flow-ids]}]]),
    :doc "Generate map for setTerminationProtection"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :elasticmapreduce,
     :fn :set-termination-protection,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   set-termination-protection
   {:arglists (quote
               [[credentials
                 {:keys [termination-protected
                         request-metric-collector
                         job-flow-ids]}]]),
    :doc "Call setTerminationProtection"}
   [credentials3711 & args3712]
   (clojure.core/let
    [^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client3713
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials3711)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client3713
      setTerminationProtection
      (set-termination-protection-request
       (clojure.core/nth args3712 0)))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :add-instance-groups
   [m3714]
   (clojure.core/let
    [credentials3715 (:credentials m3714) args3716 (:args m3714)]
    (clojure.core/let
     [^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client3717
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials3715)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client3717
       addInstanceGroups
       (add-instance-groups-request (clojure.core/nth args3716 0)))))))
  (clojure.core/defn
   add-instance-groups-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         job-flow-id
                         instance-groups]}]]),
    :doc "Generate map for addInstanceGroups"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :elasticmapreduce,
     :fn :add-instance-groups,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   add-instance-groups
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         job-flow-id
                         instance-groups]}]]),
    :doc "Call addInstanceGroups"}
   [credentials3719 & args3720]
   (clojure.core/let
    [^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client3721
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials3719)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client3721
      addInstanceGroups
      (add-instance-groups-request (clojure.core/nth args3720 0)))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :describe-step
   [m3722]
   (clojure.core/let
    [credentials3723 (:credentials m3722) args3724 (:args m3722)]
    (clojure.core/let
     [^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client3725
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials3723)]
     (clojure.core/case
      (clojure.core/count args3724)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client3725
        describeStep))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client3725
        describeStep
        (describe-step-request (clojure.core/nth args3724 0))))))))
  (clojure.core/defn
   describe-step-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [step-id request-metric-collector cluster-id]}]]),
    :doc "Generate map for describeStep, describeStep"}
   ([credentials__1609__auto__]
    {:args [],
     :client :elasticmapreduce,
     :fn :describe-step,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :elasticmapreduce,
     :fn :describe-step,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-step
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [step-id request-metric-collector cluster-id]}]]),
    :doc "Call describeStep, describeStep"}
   [credentials3727 & args3728]
   (clojure.core/let
    [^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client3729
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials3727)]
    (clojure.core/case
     (clojure.core/count args3728)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client3729
       describeStep))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client3729
       describeStep
       (describe-step-request (clojure.core/nth args3728 0))))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :terminate-job-flows
   [m3730]
   (clojure.core/let
    [credentials3731 (:credentials m3730) args3732 (:args m3730)]
    (clojure.core/let
     [^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client3733
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials3731)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client3733
       terminateJobFlows
       (terminate-job-flows-request (clojure.core/nth args3732 0)))))))
  (clojure.core/defn
   terminate-job-flows-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector job-flow-ids]}]]),
    :doc "Generate map for terminateJobFlows"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :elasticmapreduce,
     :fn :terminate-job-flows,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   terminate-job-flows
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector job-flow-ids]}]]),
    :doc "Call terminateJobFlows"}
   [credentials3735 & args3736]
   (clojure.core/let
    [^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client3737
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials3735)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client3737
      terminateJobFlows
      (terminate-job-flows-request (clojure.core/nth args3736 0)))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :list-instances
   [m3738]
   (clojure.core/let
    [credentials3739 (:credentials m3738) args3740 (:args m3738)]
    (clojure.core/let
     [^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client3741
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials3739)]
     (clojure.core/case
      (clojure.core/count args3740)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client3741
        listInstances))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client3741
        listInstances
        (list-instances-request (clojure.core/nth args3740 0))))))))
  (clojure.core/defn
   list-instances-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [request-metric-collector
                         marker
                         instance-group-types
                         instance-group-id
                         cluster-id]}]]),
    :doc "Generate map for listInstances, listInstances"}
   ([credentials__1609__auto__]
    {:args [],
     :client :elasticmapreduce,
     :fn :list-instances,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :elasticmapreduce,
     :fn :list-instances,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   list-instances
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [request-metric-collector
                         marker
                         instance-group-types
                         instance-group-id
                         cluster-id]}]]),
    :doc "Call listInstances, listInstances"}
   [credentials3743 & args3744]
   (clojure.core/let
    [^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client3745
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials3743)]
    (clojure.core/case
     (clojure.core/count args3744)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client3745
       listInstances))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client3745
       listInstances
       (list-instances-request (clojure.core/nth args3744 0))))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :list-clusters
   [m3746]
   (clojure.core/let
    [credentials3747 (:credentials m3746) args3748 (:args m3746)]
    (clojure.core/let
     [^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client3749
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials3747)]
     (clojure.core/case
      (clojure.core/count args3748)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client3749
        listClusters
        (list-clusters-request (clojure.core/nth args3748 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client3749
        listClusters))))))
  (clojure.core/defn
   list-clusters-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         marker
                         created-before
                         created-after
                         cluster-states]}]
                [credentials]]),
    :doc "Generate map for listClusters, listClusters"}
   ([credentials__1609__auto__]
    {:args [],
     :client :elasticmapreduce,
     :fn :list-clusters,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :elasticmapreduce,
     :fn :list-clusters,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   list-clusters
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         marker
                         created-before
                         created-after
                         cluster-states]}]
                [credentials]]),
    :doc "Call listClusters, listClusters"}
   [credentials3751 & args3752]
   (clojure.core/let
    [^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client3753
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials3751)]
    (clojure.core/case
     (clojure.core/count args3752)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client3753
       listClusters
       (list-clusters-request (clojure.core/nth args3752 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client3753
       listClusters))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :add-job-flow-steps
   [m3754]
   (clojure.core/let
    [credentials3755 (:credentials m3754) args3756 (:args m3754)]
    (clojure.core/let
     [^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client3757
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials3755)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client3757
       addJobFlowSteps
       (add-job-flow-steps-request (clojure.core/nth args3756 0)))))))
  (clojure.core/defn
   add-job-flow-steps-map
   {:arglists (quote
               [[credentials
                 {:keys [steps request-metric-collector job-flow-id]}]]),
    :doc "Generate map for addJobFlowSteps"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :elasticmapreduce,
     :fn :add-job-flow-steps,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   add-job-flow-steps
   {:arglists (quote
               [[credentials
                 {:keys [steps request-metric-collector job-flow-id]}]]),
    :doc "Call addJobFlowSteps"}
   [credentials3759 & args3760]
   (clojure.core/let
    [^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client3761
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials3759)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client3761
      addJobFlowSteps
      (add-job-flow-steps-request (clojure.core/nth args3760 0)))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :list-steps
   [m3762]
   (clojure.core/let
    [credentials3763 (:credentials m3762) args3764 (:args m3762)]
    (clojure.core/let
     [^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client3765
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials3763)]
     (clojure.core/case
      (clojure.core/count args3764)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client3765
        listSteps))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client3765
        listSteps
        (list-steps-request (clojure.core/nth args3764 0))))))))
  (clojure.core/defn
   list-steps-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [step-states
                         request-metric-collector
                         marker
                         cluster-id]}]]),
    :doc "Generate map for listSteps, listSteps"}
   ([credentials__1609__auto__]
    {:args [],
     :client :elasticmapreduce,
     :fn :list-steps,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :elasticmapreduce,
     :fn :list-steps,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   list-steps
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [step-states
                         request-metric-collector
                         marker
                         cluster-id]}]]),
    :doc "Call listSteps, listSteps"}
   [credentials3767 & args3768]
   (clojure.core/let
    [^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client3769
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials3767)]
    (clojure.core/case
     (clojure.core/count args3768)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client3769
       listSteps))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client3769
       listSteps
       (list-steps-request (clojure.core/nth args3768 0))))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :describe-job-flows
   [m3770]
   (clojure.core/let
    [credentials3771 (:credentials m3770) args3772 (:args m3770)]
    (clojure.core/let
     [^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client3773
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials3771)]
     (clojure.core/case
      (clojure.core/count args3772)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client3773
        describeJobFlows
        (describe-job-flows-request (clojure.core/nth args3772 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client3773
        describeJobFlows))))))
  (clojure.core/defn
   describe-job-flows-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         job-flow-states
                         job-flow-ids
                         created-before
                         created-after]}]
                [credentials]]),
    :doc "Generate map for describeJobFlows, describeJobFlows"}
   ([credentials__1609__auto__]
    {:args [],
     :client :elasticmapreduce,
     :fn :describe-job-flows,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :elasticmapreduce,
     :fn :describe-job-flows,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-job-flows
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         job-flow-states
                         job-flow-ids
                         created-before
                         created-after]}]
                [credentials]]),
    :doc "Call describeJobFlows, describeJobFlows"}
   [credentials3775 & args3776]
   (clojure.core/let
    [^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client3777
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials3775)]
    (clojure.core/case
     (clojure.core/count args3776)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client3777
       describeJobFlows
       (describe-job-flows-request (clojure.core/nth args3776 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient client3777
       describeJobFlows)))))))
