(ns com.palletops.awaze.iam (:require [com.palletops.awaze.common]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :iam
  [___1561__auto__
   ^com.amazonaws.auth.BasicAWSCredentials credentials__1562__auto__]
  (new
   com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient
   credentials__1562__auto__))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.StatusType status-type
  [m7226]
  (java.lang.Enum/valueOf
   com.amazonaws.services.identitymanagement.model.StatusType
   (clojure.core/name m7226)))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.AssignmentStatusType assignment-status-type
  [m7229]
  (java.lang.Enum/valueOf
   com.amazonaws.services.identitymanagement.model.AssignmentStatusType
   (clojure.core/name m7229)))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.GetRolePolicyRequest get-role-policy-request
  [m7232]
  (clojure.core/let
   [bean7231
    (new
     com.amazonaws.services.identitymanagement.model.GetRolePolicyRequest)]
   (clojure.core/when-let
    [v7233 (:policy-name m7232)]
    (. bean7231 setPolicyName (clojure.core/str v7233)))
   (clojure.core/when-let
    [v7233 (:role-name m7232)]
    (. bean7231 setRoleName (clojure.core/str v7233)))
   bean7231))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.ChangePasswordRequest change-password-request
  [m7235]
  (clojure.core/let
   [bean7234
    (new
     com.amazonaws.services.identitymanagement.model.ChangePasswordRequest)]
   (clojure.core/when-let
    [v7236 (:old-password m7235)]
    (. bean7234 setOldPassword (clojure.core/str v7236)))
   (clojure.core/when-let
    [v7236 (:new-password m7235)]
    (. bean7234 setNewPassword (clojure.core/str v7236)))
   bean7234))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.DeactivateMFADeviceRequest deactivate-mfadevice-request
  [m7238]
  (clojure.core/let
   [bean7237
    (new
     com.amazonaws.services.identitymanagement.model.DeactivateMFADeviceRequest)]
   (clojure.core/when-let
    [v7239 (:serial-number m7238)]
    (. bean7237 setSerialNumber (clojure.core/str v7239)))
   (clojure.core/when-let
    [v7239 (:user-name m7238)]
    (. bean7237 setUserName (clojure.core/str v7239)))
   bean7237))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.ResyncMFADeviceRequest resync-mfadevice-request
  [m7241]
  (clojure.core/let
   [bean7240
    (new
     com.amazonaws.services.identitymanagement.model.ResyncMFADeviceRequest)]
   (clojure.core/when-let
    [v7242 (:serial-number m7241)]
    (. bean7240 setSerialNumber (clojure.core/str v7242)))
   (clojure.core/when-let
    [v7242 (:user-name m7241)]
    (. bean7240 setUserName (clojure.core/str v7242)))
   (clojure.core/when-let
    [v7242 (:authentication-code1 m7241)]
    (. bean7240 setAuthenticationCode1 (clojure.core/str v7242)))
   (clojure.core/when-let
    [v7242 (:authentication-code2 m7241)]
    (. bean7240 setAuthenticationCode2 (clojure.core/str v7242)))
   bean7240))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.UpdateLoginProfileRequest update-login-profile-request
  [m7244]
  (clojure.core/let
   [bean7243
    (new
     com.amazonaws.services.identitymanagement.model.UpdateLoginProfileRequest)]
   (clojure.core/when-let
    [v7245 (:password m7244)]
    (. bean7243 setPassword (clojure.core/str v7245)))
   (clojure.core/when-let
    [v7245 (:user-name m7244)]
    (. bean7243 setUserName (clojure.core/str v7245)))
   bean7243))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.PutRolePolicyRequest put-role-policy-request
  [m7247]
  (clojure.core/let
   [bean7246
    (new
     com.amazonaws.services.identitymanagement.model.PutRolePolicyRequest)]
   (clojure.core/when-let
    [v7248 (:policy-name m7247)]
    (. bean7246 setPolicyName (clojure.core/str v7248)))
   (clojure.core/when-let
    [v7248 (:policy-document m7247)]
    (. bean7246 setPolicyDocument (clojure.core/str v7248)))
   (clojure.core/when-let
    [v7248 (:role-name m7247)]
    (. bean7246 setRoleName (clojure.core/str v7248)))
   bean7246))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.DeleteSigningCertificateRequest delete-signing-certificate-request
  [m7250]
  (clojure.core/let
   [bean7249
    (new
     com.amazonaws.services.identitymanagement.model.DeleteSigningCertificateRequest)]
   (clojure.core/when-let
    [v7251 (:user-name m7250)]
    (. bean7249 setUserName (clojure.core/str v7251)))
   (clojure.core/when-let
    [v7251 (:certificate-id m7250)]
    (. bean7249 setCertificateId (clojure.core/str v7251)))
   bean7249))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.DeleteUserRequest delete-user-request
  [m7253]
  (clojure.core/let
   [bean7252
    (new
     com.amazonaws.services.identitymanagement.model.DeleteUserRequest)]
   (clojure.core/when-let
    [v7254 (:user-name m7253)]
    (. bean7252 setUserName (clojure.core/str v7254)))
   bean7252))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.AddUserToGroupRequest add-user-to-group-request
  [m7256]
  (clojure.core/let
   [bean7255
    (new
     com.amazonaws.services.identitymanagement.model.AddUserToGroupRequest)]
   (clojure.core/when-let
    [v7257 (:group-name m7256)]
    (. bean7255 setGroupName (clojure.core/str v7257)))
   (clojure.core/when-let
    [v7257 (:user-name m7256)]
    (. bean7255 setUserName (clojure.core/str v7257)))
   bean7255))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.ListAccountAliasesRequest list-account-aliases-request
  [m7259]
  (clojure.core/let
   [bean7258
    (new
     com.amazonaws.services.identitymanagement.model.ListAccountAliasesRequest)]
   (clojure.core/when-let
    [v7260 (:max-items m7259)]
    (. bean7258 setMaxItems (clojure.core/int v7260)))
   (clojure.core/when-let
    [v7260 (:marker m7259)]
    (. bean7258 setMarker (clojure.core/str v7260)))
   bean7258))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.RemoveUserFromGroupRequest remove-user-from-group-request
  [m7262]
  (clojure.core/let
   [bean7261
    (new
     com.amazonaws.services.identitymanagement.model.RemoveUserFromGroupRequest)]
   (clojure.core/when-let
    [v7263 (:group-name m7262)]
    (. bean7261 setGroupName (clojure.core/str v7263)))
   (clojure.core/when-let
    [v7263 (:user-name m7262)]
    (. bean7261 setUserName (clojure.core/str v7263)))
   bean7261))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.UpdateGroupRequest update-group-request
  [m7265]
  (clojure.core/let
   [bean7264
    (new
     com.amazonaws.services.identitymanagement.model.UpdateGroupRequest)]
   (clojure.core/when-let
    [v7266 (:group-name m7265)]
    (. bean7264 setGroupName (clojure.core/str v7266)))
   (clojure.core/when-let
    [v7266 (:new-path m7265)]
    (. bean7264 setNewPath (clojure.core/str v7266)))
   (clojure.core/when-let
    [v7266 (:new-group-name m7265)]
    (. bean7264 setNewGroupName (clojure.core/str v7266)))
   bean7264))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.UpdateServerCertificateRequest update-server-certificate-request
  [m7268]
  (clojure.core/let
   [bean7267
    (new
     com.amazonaws.services.identitymanagement.model.UpdateServerCertificateRequest)]
   (clojure.core/when-let
    [v7269 (:server-certificate-name m7268)]
    (. bean7267 setServerCertificateName (clojure.core/str v7269)))
   (clojure.core/when-let
    [v7269 (:new-path m7268)]
    (. bean7267 setNewPath (clojure.core/str v7269)))
   (clojure.core/when-let
    [v7269 (:new-server-certificate-name m7268)]
    (. bean7267 setNewServerCertificateName (clojure.core/str v7269)))
   bean7267))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.DeleteRolePolicyRequest delete-role-policy-request
  [m7271]
  (clojure.core/let
   [bean7270
    (new
     com.amazonaws.services.identitymanagement.model.DeleteRolePolicyRequest)]
   (clojure.core/when-let
    [v7272 (:policy-name m7271)]
    (. bean7270 setPolicyName (clojure.core/str v7272)))
   (clojure.core/when-let
    [v7272 (:role-name m7271)]
    (. bean7270 setRoleName (clojure.core/str v7272)))
   bean7270))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.UpdateAccessKeyRequest update-access-key-request
  [m7274]
  (clojure.core/let
   [bean7273
    (new
     com.amazonaws.services.identitymanagement.model.UpdateAccessKeyRequest)]
   (clojure.core/when-let
    [v7275 (:status m7274)]
    (. bean7273 setStatus (status-type v7275)))
   (clojure.core/when-let
    [v7275 (:status m7274)]
    (. bean7273 setStatus (clojure.core/str v7275)))
   (clojure.core/when-let
    [v7275 (:user-name m7274)]
    (. bean7273 setUserName (clojure.core/str v7275)))
   (clojure.core/when-let
    [v7275 (:access-key-id m7274)]
    (. bean7273 setAccessKeyId (clojure.core/str v7275)))
   bean7273))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.DeleteGroupRequest delete-group-request
  [m7277]
  (clojure.core/let
   [bean7276
    (new
     com.amazonaws.services.identitymanagement.model.DeleteGroupRequest)]
   (clojure.core/when-let
    [v7278 (:group-name m7277)]
    (. bean7276 setGroupName (clojure.core/str v7278)))
   bean7276))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.ListGroupsForUserRequest list-groups-for-user-request
  [m7280]
  (clojure.core/let
   [bean7279
    (new
     com.amazonaws.services.identitymanagement.model.ListGroupsForUserRequest)]
   (clojure.core/when-let
    [v7281 (:max-items m7280)]
    (. bean7279 setMaxItems (clojure.core/int v7281)))
   (clojure.core/when-let
    [v7281 (:marker m7280)]
    (. bean7279 setMarker (clojure.core/str v7281)))
   (clojure.core/when-let
    [v7281 (:user-name m7280)]
    (. bean7279 setUserName (clojure.core/str v7281)))
   bean7279))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.PutUserPolicyRequest put-user-policy-request
  [m7283]
  (clojure.core/let
   [bean7282
    (new
     com.amazonaws.services.identitymanagement.model.PutUserPolicyRequest)]
   (clojure.core/when-let
    [v7284 (:policy-name m7283)]
    (. bean7282 setPolicyName (clojure.core/str v7284)))
   (clojure.core/when-let
    [v7284 (:user-name m7283)]
    (. bean7282 setUserName (clojure.core/str v7284)))
   (clojure.core/when-let
    [v7284 (:policy-document m7283)]
    (. bean7282 setPolicyDocument (clojure.core/str v7284)))
   bean7282))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.GetRoleRequest get-role-request
  [m7286]
  (clojure.core/let
   [bean7285
    (new
     com.amazonaws.services.identitymanagement.model.GetRoleRequest)]
   (clojure.core/when-let
    [v7287 (:role-name m7286)]
    (. bean7285 setRoleName (clojure.core/str v7287)))
   bean7285))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.GetAccountPasswordPolicyRequest get-account-password-policy-request
  [m7289]
  (clojure.core/let
   [bean7288
    (new
     com.amazonaws.services.identitymanagement.model.GetAccountPasswordPolicyRequest)]
   bean7288))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.ListAccessKeysRequest list-access-keys-request
  [m7292]
  (clojure.core/let
   [bean7291
    (new
     com.amazonaws.services.identitymanagement.model.ListAccessKeysRequest)]
   (clojure.core/when-let
    [v7293 (:max-items m7292)]
    (. bean7291 setMaxItems (clojure.core/int v7293)))
   (clojure.core/when-let
    [v7293 (:marker m7292)]
    (. bean7291 setMarker (clojure.core/str v7293)))
   (clojure.core/when-let
    [v7293 (:user-name m7292)]
    (. bean7291 setUserName (clojure.core/str v7293)))
   bean7291))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.DeleteAccountAliasRequest delete-account-alias-request
  [m7295]
  (clojure.core/let
   [bean7294
    (new
     com.amazonaws.services.identitymanagement.model.DeleteAccountAliasRequest)]
   (clojure.core/when-let
    [v7296 (:account-alias m7295)]
    (. bean7294 setAccountAlias (clojure.core/str v7296)))
   bean7294))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.GetLoginProfileRequest get-login-profile-request
  [m7298]
  (clojure.core/let
   [bean7297
    (new
     com.amazonaws.services.identitymanagement.model.GetLoginProfileRequest)]
   (clojure.core/when-let
    [v7299 (:user-name m7298)]
    (. bean7297 setUserName (clojure.core/str v7299)))
   bean7297))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.CreateLoginProfileRequest create-login-profile-request
  [m7301]
  (clojure.core/let
   [bean7300
    (new
     com.amazonaws.services.identitymanagement.model.CreateLoginProfileRequest)]
   (clojure.core/when-let
    [v7302 (:password m7301)]
    (. bean7300 setPassword (clojure.core/str v7302)))
   (clojure.core/when-let
    [v7302 (:user-name m7301)]
    (. bean7300 setUserName (clojure.core/str v7302)))
   bean7300))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.ListGroupsRequest list-groups-request
  [m7304]
  (clojure.core/let
   [bean7303
    (new
     com.amazonaws.services.identitymanagement.model.ListGroupsRequest)]
   (clojure.core/when-let
    [v7305 (:max-items m7304)]
    (. bean7303 setMaxItems (clojure.core/int v7305)))
   (clojure.core/when-let
    [v7305 (:marker m7304)]
    (. bean7303 setMarker (clojure.core/str v7305)))
   (clojure.core/when-let
    [v7305 (:path-prefix m7304)]
    (. bean7303 setPathPrefix (clojure.core/str v7305)))
   bean7303))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.GetAccountSummaryRequest get-account-summary-request
  [m7307]
  (clojure.core/let
   [bean7306
    (new
     com.amazonaws.services.identitymanagement.model.GetAccountSummaryRequest)]
   bean7306))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.DeleteAccountPasswordPolicyRequest delete-account-password-policy-request
  [m7310]
  (clojure.core/let
   [bean7309
    (new
     com.amazonaws.services.identitymanagement.model.DeleteAccountPasswordPolicyRequest)]
   bean7309))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.GetInstanceProfileRequest get-instance-profile-request
  [m7313]
  (clojure.core/let
   [bean7312
    (new
     com.amazonaws.services.identitymanagement.model.GetInstanceProfileRequest)]
   (clojure.core/when-let
    [v7314 (:instance-profile-name m7313)]
    (. bean7312 setInstanceProfileName (clojure.core/str v7314)))
   bean7312))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.GetUserRequest get-user-request
  [m7316]
  (clojure.core/let
   [bean7315
    (new
     com.amazonaws.services.identitymanagement.model.GetUserRequest)]
   (clojure.core/when-let
    [v7317 (:user-name m7316)]
    (. bean7315 setUserName (clojure.core/str v7317)))
   bean7315))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.DeleteVirtualMFADeviceRequest delete-virtual-mfadevice-request
  [m7319]
  (clojure.core/let
   [bean7318
    (new
     com.amazonaws.services.identitymanagement.model.DeleteVirtualMFADeviceRequest)]
   (clojure.core/when-let
    [v7320 (:serial-number m7319)]
    (. bean7318 setSerialNumber (clojure.core/str v7320)))
   bean7318))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.CreateAccessKeyRequest create-access-key-request
  [m7322]
  (clojure.core/let
   [bean7321
    (new
     com.amazonaws.services.identitymanagement.model.CreateAccessKeyRequest)]
   (clojure.core/when-let
    [v7323 (:user-name m7322)]
    (. bean7321 setUserName (clojure.core/str v7323)))
   bean7321))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.ListInstanceProfilesRequest list-instance-profiles-request
  [m7325]
  (clojure.core/let
   [bean7324
    (new
     com.amazonaws.services.identitymanagement.model.ListInstanceProfilesRequest)]
   (clojure.core/when-let
    [v7326 (:max-items m7325)]
    (. bean7324 setMaxItems (clojure.core/int v7326)))
   (clojure.core/when-let
    [v7326 (:marker m7325)]
    (. bean7324 setMarker (clojure.core/str v7326)))
   (clojure.core/when-let
    [v7326 (:path-prefix m7325)]
    (. bean7324 setPathPrefix (clojure.core/str v7326)))
   bean7324))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.PutGroupPolicyRequest put-group-policy-request
  [m7328]
  (clojure.core/let
   [bean7327
    (new
     com.amazonaws.services.identitymanagement.model.PutGroupPolicyRequest)]
   (clojure.core/when-let
    [v7329 (:group-name m7328)]
    (. bean7327 setGroupName (clojure.core/str v7329)))
   (clojure.core/when-let
    [v7329 (:policy-name m7328)]
    (. bean7327 setPolicyName (clojure.core/str v7329)))
   (clojure.core/when-let
    [v7329 (:policy-document m7328)]
    (. bean7327 setPolicyDocument (clojure.core/str v7329)))
   bean7327))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.GetServerCertificateRequest get-server-certificate-request
  [m7331]
  (clojure.core/let
   [bean7330
    (new
     com.amazonaws.services.identitymanagement.model.GetServerCertificateRequest)]
   (clojure.core/when-let
    [v7332 (:server-certificate-name m7331)]
    (. bean7330 setServerCertificateName (clojure.core/str v7332)))
   bean7330))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.UploadServerCertificateRequest upload-server-certificate-request
  [m7334]
  (clojure.core/let
   [bean7333
    (new
     com.amazonaws.services.identitymanagement.model.UploadServerCertificateRequest)]
   (clojure.core/when-let
    [v7335 (:path m7334)]
    (. bean7333 setPath (clojure.core/str v7335)))
   (clojure.core/when-let
    [v7335 (:server-certificate-name m7334)]
    (. bean7333 setServerCertificateName (clojure.core/str v7335)))
   (clojure.core/when-let
    [v7335 (:certificate-body m7334)]
    (. bean7333 setCertificateBody (clojure.core/str v7335)))
   (clojure.core/when-let
    [v7335 (:private-key m7334)]
    (. bean7333 setPrivateKey (clojure.core/str v7335)))
   (clojure.core/when-let
    [v7335 (:certificate-chain m7334)]
    (. bean7333 setCertificateChain (clojure.core/str v7335)))
   bean7333))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.ListRolePoliciesRequest list-role-policies-request
  [m7337]
  (clojure.core/let
   [bean7336
    (new
     com.amazonaws.services.identitymanagement.model.ListRolePoliciesRequest)]
   (clojure.core/when-let
    [v7338 (:max-items m7337)]
    (. bean7336 setMaxItems (clojure.core/int v7338)))
   (clojure.core/when-let
    [v7338 (:marker m7337)]
    (. bean7336 setMarker (clojure.core/str v7338)))
   (clojure.core/when-let
    [v7338 (:role-name m7337)]
    (. bean7336 setRoleName (clojure.core/str v7338)))
   bean7336))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.AddRoleToInstanceProfileRequest add-role-to-instance-profile-request
  [m7340]
  (clojure.core/let
   [bean7339
    (new
     com.amazonaws.services.identitymanagement.model.AddRoleToInstanceProfileRequest)]
   (clojure.core/when-let
    [v7341 (:instance-profile-name m7340)]
    (. bean7339 setInstanceProfileName (clojure.core/str v7341)))
   (clojure.core/when-let
    [v7341 (:role-name m7340)]
    (. bean7339 setRoleName (clojure.core/str v7341)))
   bean7339))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.DeleteAccessKeyRequest delete-access-key-request
  [m7343]
  (clojure.core/let
   [bean7342
    (new
     com.amazonaws.services.identitymanagement.model.DeleteAccessKeyRequest)]
   (clojure.core/when-let
    [v7344 (:user-name m7343)]
    (. bean7342 setUserName (clojure.core/str v7344)))
   (clojure.core/when-let
    [v7344 (:access-key-id m7343)]
    (. bean7342 setAccessKeyId (clojure.core/str v7344)))
   bean7342))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.DeleteRoleRequest delete-role-request
  [m7346]
  (clojure.core/let
   [bean7345
    (new
     com.amazonaws.services.identitymanagement.model.DeleteRoleRequest)]
   (clojure.core/when-let
    [v7347 (:role-name m7346)]
    (. bean7345 setRoleName (clojure.core/str v7347)))
   bean7345))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.CreateVirtualMFADeviceRequest create-virtual-mfadevice-request
  [m7349]
  (clojure.core/let
   [bean7348
    (new
     com.amazonaws.services.identitymanagement.model.CreateVirtualMFADeviceRequest)]
   (clojure.core/when-let
    [v7350 (:path m7349)]
    (. bean7348 setPath (clojure.core/str v7350)))
   (clojure.core/when-let
    [v7350 (:virtual-mfadevice-name m7349)]
    (. bean7348 setVirtualMFADeviceName (clojure.core/str v7350)))
   bean7348))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.ListGroupPoliciesRequest list-group-policies-request
  [m7352]
  (clojure.core/let
   [bean7351
    (new
     com.amazonaws.services.identitymanagement.model.ListGroupPoliciesRequest)]
   (clojure.core/when-let
    [v7353 (:max-items m7352)]
    (. bean7351 setMaxItems (clojure.core/int v7353)))
   (clojure.core/when-let
    [v7353 (:marker m7352)]
    (. bean7351 setMarker (clojure.core/str v7353)))
   (clojure.core/when-let
    [v7353 (:group-name m7352)]
    (. bean7351 setGroupName (clojure.core/str v7353)))
   bean7351))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.GetGroupPolicyRequest get-group-policy-request
  [m7355]
  (clojure.core/let
   [bean7354
    (new
     com.amazonaws.services.identitymanagement.model.GetGroupPolicyRequest)]
   (clojure.core/when-let
    [v7356 (:group-name m7355)]
    (. bean7354 setGroupName (clojure.core/str v7356)))
   (clojure.core/when-let
    [v7356 (:policy-name m7355)]
    (. bean7354 setPolicyName (clojure.core/str v7356)))
   bean7354))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.ListServerCertificatesRequest list-server-certificates-request
  [m7358]
  (clojure.core/let
   [bean7357
    (new
     com.amazonaws.services.identitymanagement.model.ListServerCertificatesRequest)]
   (clojure.core/when-let
    [v7359 (:max-items m7358)]
    (. bean7357 setMaxItems (clojure.core/int v7359)))
   (clojure.core/when-let
    [v7359 (:marker m7358)]
    (. bean7357 setMarker (clojure.core/str v7359)))
   (clojure.core/when-let
    [v7359 (:path-prefix m7358)]
    (. bean7357 setPathPrefix (clojure.core/str v7359)))
   bean7357))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.UpdateAccountPasswordPolicyRequest update-account-password-policy-request
  [m7361]
  (clojure.core/let
   [bean7360
    (new
     com.amazonaws.services.identitymanagement.model.UpdateAccountPasswordPolicyRequest)]
   (clojure.core/when-let
    [v7362 (:minimum-password-length m7361)]
    (. bean7360 setMinimumPasswordLength (clojure.core/int v7362)))
   (clojure.core/when-let
    [v7362 (:require-symbols m7361)]
    (. bean7360 setRequireSymbols (clojure.core/boolean v7362)))
   (clojure.core/when-let
    [v7362 (:require-numbers m7361)]
    (. bean7360 setRequireNumbers (clojure.core/boolean v7362)))
   (clojure.core/when-let
    [v7362 (:require-uppercase-characters m7361)]
    (.
     bean7360
     setRequireUppercaseCharacters
     (clojure.core/boolean v7362)))
   (clojure.core/when-let
    [v7362 (:require-lowercase-characters m7361)]
    (.
     bean7360
     setRequireLowercaseCharacters
     (clojure.core/boolean v7362)))
   (clojure.core/when-let
    [v7362 (:allow-users-to-change-password m7361)]
    (.
     bean7360
     setAllowUsersToChangePassword
     (clojure.core/boolean v7362)))
   bean7360))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.CreateGroupRequest create-group-request
  [m7364]
  (clojure.core/let
   [bean7363
    (new
     com.amazonaws.services.identitymanagement.model.CreateGroupRequest)]
   (clojure.core/when-let
    [v7365 (:group-name m7364)]
    (. bean7363 setGroupName (clojure.core/str v7365)))
   (clojure.core/when-let
    [v7365 (:path m7364)]
    (. bean7363 setPath (clojure.core/str v7365)))
   bean7363))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.ListInstanceProfilesForRoleRequest list-instance-profiles-for-role-request
  [m7367]
  (clojure.core/let
   [bean7366
    (new
     com.amazonaws.services.identitymanagement.model.ListInstanceProfilesForRoleRequest)]
   (clojure.core/when-let
    [v7368 (:max-items m7367)]
    (. bean7366 setMaxItems (clojure.core/int v7368)))
   (clojure.core/when-let
    [v7368 (:marker m7367)]
    (. bean7366 setMarker (clojure.core/str v7368)))
   (clojure.core/when-let
    [v7368 (:role-name m7367)]
    (. bean7366 setRoleName (clojure.core/str v7368)))
   bean7366))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.UploadSigningCertificateRequest upload-signing-certificate-request
  [m7370]
  (clojure.core/let
   [bean7369
    (new
     com.amazonaws.services.identitymanagement.model.UploadSigningCertificateRequest)]
   (clojure.core/when-let
    [v7371 (:user-name m7370)]
    (. bean7369 setUserName (clojure.core/str v7371)))
   (clojure.core/when-let
    [v7371 (:certificate-body m7370)]
    (. bean7369 setCertificateBody (clojure.core/str v7371)))
   bean7369))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.DeleteServerCertificateRequest delete-server-certificate-request
  [m7373]
  (clojure.core/let
   [bean7372
    (new
     com.amazonaws.services.identitymanagement.model.DeleteServerCertificateRequest)]
   (clojure.core/when-let
    [v7374 (:server-certificate-name m7373)]
    (. bean7372 setServerCertificateName (clojure.core/str v7374)))
   bean7372))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.ListVirtualMFADevicesRequest list-virtual-mfadevices-request
  [m7376]
  (clojure.core/let
   [bean7375
    (new
     com.amazonaws.services.identitymanagement.model.ListVirtualMFADevicesRequest)]
   (clojure.core/when-let
    [v7377 (:max-items m7376)]
    (. bean7375 setMaxItems (clojure.core/int v7377)))
   (clojure.core/when-let
    [v7377 (:marker m7376)]
    (. bean7375 setMarker (clojure.core/str v7377)))
   (clojure.core/when-let
    [v7377 (:assignment-status m7376)]
    (. bean7375 setAssignmentStatus (assignment-status-type v7377)))
   (clojure.core/when-let
    [v7377 (:assignment-status m7376)]
    (. bean7375 setAssignmentStatus (clojure.core/str v7377)))
   bean7375))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.RemoveRoleFromInstanceProfileRequest remove-role-from-instance-profile-request
  [m7379]
  (clojure.core/let
   [bean7378
    (new
     com.amazonaws.services.identitymanagement.model.RemoveRoleFromInstanceProfileRequest)]
   (clojure.core/when-let
    [v7380 (:instance-profile-name m7379)]
    (. bean7378 setInstanceProfileName (clojure.core/str v7380)))
   (clojure.core/when-let
    [v7380 (:role-name m7379)]
    (. bean7378 setRoleName (clojure.core/str v7380)))
   bean7378))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.ListSigningCertificatesRequest list-signing-certificates-request
  [m7382]
  (clojure.core/let
   [bean7381
    (new
     com.amazonaws.services.identitymanagement.model.ListSigningCertificatesRequest)]
   (clojure.core/when-let
    [v7383 (:max-items m7382)]
    (. bean7381 setMaxItems (clojure.core/int v7383)))
   (clojure.core/when-let
    [v7383 (:marker m7382)]
    (. bean7381 setMarker (clojure.core/str v7383)))
   (clojure.core/when-let
    [v7383 (:user-name m7382)]
    (. bean7381 setUserName (clojure.core/str v7383)))
   bean7381))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.DeleteInstanceProfileRequest delete-instance-profile-request
  [m7385]
  (clojure.core/let
   [bean7384
    (new
     com.amazonaws.services.identitymanagement.model.DeleteInstanceProfileRequest)]
   (clojure.core/when-let
    [v7386 (:instance-profile-name m7385)]
    (. bean7384 setInstanceProfileName (clojure.core/str v7386)))
   bean7384))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.ListMFADevicesRequest list-mfadevices-request
  [m7388]
  (clojure.core/let
   [bean7387
    (new
     com.amazonaws.services.identitymanagement.model.ListMFADevicesRequest)]
   (clojure.core/when-let
    [v7389 (:max-items m7388)]
    (. bean7387 setMaxItems (clojure.core/int v7389)))
   (clojure.core/when-let
    [v7389 (:marker m7388)]
    (. bean7387 setMarker (clojure.core/str v7389)))
   (clojure.core/when-let
    [v7389 (:user-name m7388)]
    (. bean7387 setUserName (clojure.core/str v7389)))
   bean7387))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.DeleteUserPolicyRequest delete-user-policy-request
  [m7391]
  (clojure.core/let
   [bean7390
    (new
     com.amazonaws.services.identitymanagement.model.DeleteUserPolicyRequest)]
   (clojure.core/when-let
    [v7392 (:policy-name m7391)]
    (. bean7390 setPolicyName (clojure.core/str v7392)))
   (clojure.core/when-let
    [v7392 (:user-name m7391)]
    (. bean7390 setUserName (clojure.core/str v7392)))
   bean7390))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.CreateAccountAliasRequest create-account-alias-request
  [m7394]
  (clojure.core/let
   [bean7393
    (new
     com.amazonaws.services.identitymanagement.model.CreateAccountAliasRequest)]
   (clojure.core/when-let
    [v7395 (:account-alias m7394)]
    (. bean7393 setAccountAlias (clojure.core/str v7395)))
   bean7393))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.UpdateSigningCertificateRequest update-signing-certificate-request
  [m7397]
  (clojure.core/let
   [bean7396
    (new
     com.amazonaws.services.identitymanagement.model.UpdateSigningCertificateRequest)]
   (clojure.core/when-let
    [v7398 (:status m7397)]
    (. bean7396 setStatus (status-type v7398)))
   (clojure.core/when-let
    [v7398 (:status m7397)]
    (. bean7396 setStatus (clojure.core/str v7398)))
   (clojure.core/when-let
    [v7398 (:user-name m7397)]
    (. bean7396 setUserName (clojure.core/str v7398)))
   (clojure.core/when-let
    [v7398 (:certificate-id m7397)]
    (. bean7396 setCertificateId (clojure.core/str v7398)))
   bean7396))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.UpdateAssumeRolePolicyRequest update-assume-role-policy-request
  [m7400]
  (clojure.core/let
   [bean7399
    (new
     com.amazonaws.services.identitymanagement.model.UpdateAssumeRolePolicyRequest)]
   (clojure.core/when-let
    [v7401 (:policy-document m7400)]
    (. bean7399 setPolicyDocument (clojure.core/str v7401)))
   (clojure.core/when-let
    [v7401 (:role-name m7400)]
    (. bean7399 setRoleName (clojure.core/str v7401)))
   bean7399))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.ListRolesRequest list-roles-request
  [m7403]
  (clojure.core/let
   [bean7402
    (new
     com.amazonaws.services.identitymanagement.model.ListRolesRequest)]
   (clojure.core/when-let
    [v7404 (:max-items m7403)]
    (. bean7402 setMaxItems (clojure.core/int v7404)))
   (clojure.core/when-let
    [v7404 (:marker m7403)]
    (. bean7402 setMarker (clojure.core/str v7404)))
   (clojure.core/when-let
    [v7404 (:path-prefix m7403)]
    (. bean7402 setPathPrefix (clojure.core/str v7404)))
   bean7402))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.ListUserPoliciesRequest list-user-policies-request
  [m7406]
  (clojure.core/let
   [bean7405
    (new
     com.amazonaws.services.identitymanagement.model.ListUserPoliciesRequest)]
   (clojure.core/when-let
    [v7407 (:max-items m7406)]
    (. bean7405 setMaxItems (clojure.core/int v7407)))
   (clojure.core/when-let
    [v7407 (:marker m7406)]
    (. bean7405 setMarker (clojure.core/str v7407)))
   (clojure.core/when-let
    [v7407 (:user-name m7406)]
    (. bean7405 setUserName (clojure.core/str v7407)))
   bean7405))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.DeleteLoginProfileRequest delete-login-profile-request
  [m7409]
  (clojure.core/let
   [bean7408
    (new
     com.amazonaws.services.identitymanagement.model.DeleteLoginProfileRequest)]
   (clojure.core/when-let
    [v7410 (:user-name m7409)]
    (. bean7408 setUserName (clojure.core/str v7410)))
   bean7408))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.EnableMFADeviceRequest enable-mfadevice-request
  [m7412]
  (clojure.core/let
   [bean7411
    (new
     com.amazonaws.services.identitymanagement.model.EnableMFADeviceRequest)]
   (clojure.core/when-let
    [v7413 (:serial-number m7412)]
    (. bean7411 setSerialNumber (clojure.core/str v7413)))
   (clojure.core/when-let
    [v7413 (:user-name m7412)]
    (. bean7411 setUserName (clojure.core/str v7413)))
   (clojure.core/when-let
    [v7413 (:authentication-code1 m7412)]
    (. bean7411 setAuthenticationCode1 (clojure.core/str v7413)))
   (clojure.core/when-let
    [v7413 (:authentication-code2 m7412)]
    (. bean7411 setAuthenticationCode2 (clojure.core/str v7413)))
   bean7411))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.GetGroupRequest get-group-request
  [m7415]
  (clojure.core/let
   [bean7414
    (new
     com.amazonaws.services.identitymanagement.model.GetGroupRequest)]
   (clojure.core/when-let
    [v7416 (:max-items m7415)]
    (. bean7414 setMaxItems (clojure.core/int v7416)))
   (clojure.core/when-let
    [v7416 (:marker m7415)]
    (. bean7414 setMarker (clojure.core/str v7416)))
   (clojure.core/when-let
    [v7416 (:group-name m7415)]
    (. bean7414 setGroupName (clojure.core/str v7416)))
   bean7414))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.DeleteGroupPolicyRequest delete-group-policy-request
  [m7418]
  (clojure.core/let
   [bean7417
    (new
     com.amazonaws.services.identitymanagement.model.DeleteGroupPolicyRequest)]
   (clojure.core/when-let
    [v7419 (:group-name m7418)]
    (. bean7417 setGroupName (clojure.core/str v7419)))
   (clojure.core/when-let
    [v7419 (:policy-name m7418)]
    (. bean7417 setPolicyName (clojure.core/str v7419)))
   bean7417))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.CreateInstanceProfileRequest create-instance-profile-request
  [m7421]
  (clojure.core/let
   [bean7420
    (new
     com.amazonaws.services.identitymanagement.model.CreateInstanceProfileRequest)]
   (clojure.core/when-let
    [v7422 (:path m7421)]
    (. bean7420 setPath (clojure.core/str v7422)))
   (clojure.core/when-let
    [v7422 (:instance-profile-name m7421)]
    (. bean7420 setInstanceProfileName (clojure.core/str v7422)))
   bean7420))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.UpdateUserRequest update-user-request
  [m7424]
  (clojure.core/let
   [bean7423
    (new
     com.amazonaws.services.identitymanagement.model.UpdateUserRequest)]
   (clojure.core/when-let
    [v7425 (:user-name m7424)]
    (. bean7423 setUserName (clojure.core/str v7425)))
   (clojure.core/when-let
    [v7425 (:new-user-name m7424)]
    (. bean7423 setNewUserName (clojure.core/str v7425)))
   (clojure.core/when-let
    [v7425 (:new-path m7424)]
    (. bean7423 setNewPath (clojure.core/str v7425)))
   bean7423))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.CreateUserRequest create-user-request
  [m7427]
  (clojure.core/let
   [bean7426
    (new
     com.amazonaws.services.identitymanagement.model.CreateUserRequest)]
   (clojure.core/when-let
    [v7428 (:path m7427)]
    (. bean7426 setPath (clojure.core/str v7428)))
   (clojure.core/when-let
    [v7428 (:user-name m7427)]
    (. bean7426 setUserName (clojure.core/str v7428)))
   bean7426))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.CreateRoleRequest create-role-request
  [m7430]
  (clojure.core/let
   [bean7429
    (new
     com.amazonaws.services.identitymanagement.model.CreateRoleRequest)]
   (clojure.core/when-let
    [v7431 (:path m7430)]
    (. bean7429 setPath (clojure.core/str v7431)))
   (clojure.core/when-let
    [v7431 (:assume-role-policy-document m7430)]
    (. bean7429 setAssumeRolePolicyDocument (clojure.core/str v7431)))
   (clojure.core/when-let
    [v7431 (:role-name m7430)]
    (. bean7429 setRoleName (clojure.core/str v7431)))
   bean7429))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.GetUserPolicyRequest get-user-policy-request
  [m7433]
  (clojure.core/let
   [bean7432
    (new
     com.amazonaws.services.identitymanagement.model.GetUserPolicyRequest)]
   (clojure.core/when-let
    [v7434 (:policy-name m7433)]
    (. bean7432 setPolicyName (clojure.core/str v7434)))
   (clojure.core/when-let
    [v7434 (:user-name m7433)]
    (. bean7432 setUserName (clojure.core/str v7434)))
   bean7432))
 (clojure.core/defn
  ^com.amazonaws.services.identitymanagement.model.ListUsersRequest list-users-request
  [m7436]
  (clojure.core/let
   [bean7435
    (new
     com.amazonaws.services.identitymanagement.model.ListUsersRequest)]
   (clojure.core/when-let
    [v7437 (:max-items m7436)]
    (. bean7435 setMaxItems (clojure.core/int v7437)))
   (clojure.core/when-let
    [v7437 (:marker m7436)]
    (. bean7435 setMarker (clojure.core/str v7437)))
   (clojure.core/when-let
    [v7437 (:path-prefix m7436)]
    (. bean7435 setPathPrefix (clojure.core/str v7437)))
   bean7435))
 (clojure.core/defmulti
  iam
  (clojure.core/fn iam [m__1641__auto__] (:fn m__1641__auto__)))
 (do
  (clojure.core/defmethod
   iam
   :get-role-policy
   [m7438]
   (clojure.core/let
    [credentials7439 (:credentials m7438) args7440 (:args m7438)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7441
      (com.palletops.awaze.common/aws-client :iam credentials7439)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7441
       getRolePolicy
       (get-role-policy-request (clojure.core/nth args7440 0)))))))
  (clojure.core/defn
   get-role-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [role-name
                         request-metric-collector
                         policy-name]}]]),
    :doc "Generate map for getRolePolicy"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :iam,
     :fn :get-role-policy,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   get-role-policy
   {:arglists (quote
               [[credentials
                 {:keys [role-name
                         request-metric-collector
                         policy-name]}]]),
    :doc "Call getRolePolicy"}
   [credentials7443 & args7444]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7445
     (com.palletops.awaze.common/aws-client :iam credentials7443)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7445
      getRolePolicy
      (get-role-policy-request (clojure.core/nth args7444 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :change-password
   [m7446]
   (clojure.core/let
    [credentials7447 (:credentials m7446) args7448 (:args m7446)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7449
      (com.palletops.awaze.common/aws-client :iam credentials7447)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7449
       changePassword
       (change-password-request (clojure.core/nth args7448 0)))))))
  (clojure.core/defn
   change-password-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         old-password
                         new-password]}]]),
    :doc "Generate map for changePassword"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :iam,
     :fn :change-password,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   change-password
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         old-password
                         new-password]}]]),
    :doc "Call changePassword"}
   [credentials7451 & args7452]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7453
     (com.palletops.awaze.common/aws-client :iam credentials7451)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7453
      changePassword
      (change-password-request (clojure.core/nth args7452 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :deactivate-mfadevice
   [m7454]
   (clojure.core/let
    [credentials7455 (:credentials m7454) args7456 (:args m7454)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7457
      (com.palletops.awaze.common/aws-client :iam credentials7455)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7457
       deactivateMFADevice
       (deactivate-mfadevice-request (clojure.core/nth args7456 0)))))))
  (clojure.core/defn
   deactivate-mfadevice-map
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         serial-number
                         request-metric-collector]}]]),
    :doc "Generate map for deactivateMFADevice"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :iam,
     :fn :deactivate-mfadevice,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   deactivate-mfadevice
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         serial-number
                         request-metric-collector]}]]),
    :doc "Call deactivateMFADevice"}
   [credentials7459 & args7460]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7461
     (com.palletops.awaze.common/aws-client :iam credentials7459)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7461
      deactivateMFADevice
      (deactivate-mfadevice-request (clojure.core/nth args7460 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :resync-mfadevice
   [m7462]
   (clojure.core/let
    [credentials7463 (:credentials m7462) args7464 (:args m7462)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7465
      (com.palletops.awaze.common/aws-client :iam credentials7463)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7465
       resyncMFADevice
       (resync-mfadevice-request (clojure.core/nth args7464 0)))))))
  (clojure.core/defn
   resync-mfadevice-map
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         serial-number
                         request-metric-collector
                         authentication-code2
                         authentication-code1]}]]),
    :doc "Generate map for resyncMFADevice"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :iam,
     :fn :resync-mfadevice,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   resync-mfadevice
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         serial-number
                         request-metric-collector
                         authentication-code2
                         authentication-code1]}]]),
    :doc "Call resyncMFADevice"}
   [credentials7467 & args7468]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7469
     (com.palletops.awaze.common/aws-client :iam credentials7467)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7469
      resyncMFADevice
      (resync-mfadevice-request (clojure.core/nth args7468 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :update-login-profile
   [m7470]
   (clojure.core/let
    [credentials7471 (:credentials m7470) args7472 (:args m7470)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7473
      (com.palletops.awaze.common/aws-client :iam credentials7471)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7473
       updateLoginProfile
       (update-login-profile-request (clojure.core/nth args7472 0)))))))
  (clojure.core/defn
   update-login-profile-map
   {:arglists (quote
               [[credentials
                 {:keys [user-name request-metric-collector password]}]]),
    :doc "Generate map for updateLoginProfile"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :iam,
     :fn :update-login-profile,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   update-login-profile
   {:arglists (quote
               [[credentials
                 {:keys [user-name request-metric-collector password]}]]),
    :doc "Call updateLoginProfile"}
   [credentials7475 & args7476]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7477
     (com.palletops.awaze.common/aws-client :iam credentials7475)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7477
      updateLoginProfile
      (update-login-profile-request (clojure.core/nth args7476 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :put-role-policy
   [m7478]
   (clojure.core/let
    [credentials7479 (:credentials m7478) args7480 (:args m7478)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7481
      (com.palletops.awaze.common/aws-client :iam credentials7479)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7481
       putRolePolicy
       (put-role-policy-request (clojure.core/nth args7480 0)))))))
  (clojure.core/defn
   put-role-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [role-name
                         request-metric-collector
                         policy-name
                         policy-document]}]]),
    :doc "Generate map for putRolePolicy"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :iam,
     :fn :put-role-policy,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   put-role-policy
   {:arglists (quote
               [[credentials
                 {:keys [role-name
                         request-metric-collector
                         policy-name
                         policy-document]}]]),
    :doc "Call putRolePolicy"}
   [credentials7483 & args7484]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7485
     (com.palletops.awaze.common/aws-client :iam credentials7483)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7485
      putRolePolicy
      (put-role-policy-request (clojure.core/nth args7484 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-signing-certificate
   [m7486]
   (clojure.core/let
    [credentials7487 (:credentials m7486) args7488 (:args m7486)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7489
      (com.palletops.awaze.common/aws-client :iam credentials7487)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7489
       deleteSigningCertificate
       (delete-signing-certificate-request
        (clojure.core/nth args7488 0)))))))
  (clojure.core/defn
   delete-signing-certificate-map
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         request-metric-collector
                         certificate-id]}]]),
    :doc "Generate map for deleteSigningCertificate"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :iam,
     :fn :delete-signing-certificate,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   delete-signing-certificate
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         request-metric-collector
                         certificate-id]}]]),
    :doc "Call deleteSigningCertificate"}
   [credentials7491 & args7492]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7493
     (com.palletops.awaze.common/aws-client :iam credentials7491)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7493
      deleteSigningCertificate
      (delete-signing-certificate-request
       (clojure.core/nth args7492 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-user
   [m7494]
   (clojure.core/let
    [credentials7495 (:credentials m7494) args7496 (:args m7494)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7497
      (com.palletops.awaze.common/aws-client :iam credentials7495)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7497
       deleteUser
       (delete-user-request (clojure.core/nth args7496 0)))))))
  (clojure.core/defn
   delete-user-map
   {:arglists (quote
               [[credentials
                 {:keys [user-name request-metric-collector]}]]),
    :doc "Generate map for deleteUser"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :iam,
     :fn :delete-user,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   delete-user
   {:arglists (quote
               [[credentials
                 {:keys [user-name request-metric-collector]}]]),
    :doc "Call deleteUser"}
   [credentials7499 & args7500]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7501
     (com.palletops.awaze.common/aws-client :iam credentials7499)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7501
      deleteUser
      (delete-user-request (clojure.core/nth args7500 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :add-user-to-group
   [m7502]
   (clojure.core/let
    [credentials7503 (:credentials m7502) args7504 (:args m7502)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7505
      (com.palletops.awaze.common/aws-client :iam credentials7503)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7505
       addUserToGroup
       (add-user-to-group-request (clojure.core/nth args7504 0)))))))
  (clojure.core/defn
   add-user-to-group-map
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         request-metric-collector
                         group-name]}]]),
    :doc "Generate map for addUserToGroup"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :iam,
     :fn :add-user-to-group,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   add-user-to-group
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         request-metric-collector
                         group-name]}]]),
    :doc "Call addUserToGroup"}
   [credentials7507 & args7508]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7509
     (com.palletops.awaze.common/aws-client :iam credentials7507)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7509
      addUserToGroup
      (add-user-to-group-request (clojure.core/nth args7508 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-account-aliases
   [m7510]
   (clojure.core/let
    [credentials7511 (:credentials m7510) args7512 (:args m7510)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7513
      (com.palletops.awaze.common/aws-client :iam credentials7511)]
     (clojure.core/case
      (clojure.core/count args7512)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7513
        listAccountAliases
        (list-account-aliases-request (clojure.core/nth args7512 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7513
        listAccountAliases))))))
  (clojure.core/defn
   list-account-aliases-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector max-items marker]}]
                [credentials]]),
    :doc "Generate map for listAccountAliases, listAccountAliases"}
   ([credentials__1609__auto__]
    {:args [],
     :client :iam,
     :fn :list-account-aliases,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :iam,
     :fn :list-account-aliases,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   list-account-aliases
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector max-items marker]}]
                [credentials]]),
    :doc "Call listAccountAliases, listAccountAliases"}
   [credentials7515 & args7516]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7517
     (com.palletops.awaze.common/aws-client :iam credentials7515)]
    (clojure.core/case
     (clojure.core/count args7516)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7517
       listAccountAliases
       (list-account-aliases-request (clojure.core/nth args7516 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7517
       listAccountAliases))))))
 (do
  (clojure.core/defmethod
   iam
   :remove-user-from-group
   [m7518]
   (clojure.core/let
    [credentials7519 (:credentials m7518) args7520 (:args m7518)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7521
      (com.palletops.awaze.common/aws-client :iam credentials7519)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7521
       removeUserFromGroup
       (remove-user-from-group-request (clojure.core/nth args7520 0)))))))
  (clojure.core/defn
   remove-user-from-group-map
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         request-metric-collector
                         group-name]}]]),
    :doc "Generate map for removeUserFromGroup"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :iam,
     :fn :remove-user-from-group,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   remove-user-from-group
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         request-metric-collector
                         group-name]}]]),
    :doc "Call removeUserFromGroup"}
   [credentials7523 & args7524]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7525
     (com.palletops.awaze.common/aws-client :iam credentials7523)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7525
      removeUserFromGroup
      (remove-user-from-group-request (clojure.core/nth args7524 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :update-group
   [m7526]
   (clojure.core/let
    [credentials7527 (:credentials m7526) args7528 (:args m7526)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7529
      (com.palletops.awaze.common/aws-client :iam credentials7527)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7529
       updateGroup
       (update-group-request (clojure.core/nth args7528 0)))))))
  (clojure.core/defn
   update-group-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         new-path
                         new-group-name
                         group-name]}]]),
    :doc "Generate map for updateGroup"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :iam,
     :fn :update-group,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   update-group
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         new-path
                         new-group-name
                         group-name]}]]),
    :doc "Call updateGroup"}
   [credentials7531 & args7532]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7533
     (com.palletops.awaze.common/aws-client :iam credentials7531)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7533
      updateGroup
      (update-group-request (clojure.core/nth args7532 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :update-server-certificate
   [m7534]
   (clojure.core/let
    [credentials7535 (:credentials m7534) args7536 (:args m7534)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7537
      (com.palletops.awaze.common/aws-client :iam credentials7535)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7537
       updateServerCertificate
       (update-server-certificate-request
        (clojure.core/nth args7536 0)))))))
  (clojure.core/defn
   update-server-certificate-map
   {:arglists (quote
               [[credentials
                 {:keys [server-certificate-name
                         request-metric-collector
                         new-server-certificate-name
                         new-path]}]]),
    :doc "Generate map for updateServerCertificate"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :iam,
     :fn :update-server-certificate,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   update-server-certificate
   {:arglists (quote
               [[credentials
                 {:keys [server-certificate-name
                         request-metric-collector
                         new-server-certificate-name
                         new-path]}]]),
    :doc "Call updateServerCertificate"}
   [credentials7539 & args7540]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7541
     (com.palletops.awaze.common/aws-client :iam credentials7539)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7541
      updateServerCertificate
      (update-server-certificate-request
       (clojure.core/nth args7540 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-role-policy
   [m7542]
   (clojure.core/let
    [credentials7543 (:credentials m7542) args7544 (:args m7542)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7545
      (com.palletops.awaze.common/aws-client :iam credentials7543)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7545
       deleteRolePolicy
       (delete-role-policy-request (clojure.core/nth args7544 0)))))))
  (clojure.core/defn
   delete-role-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [role-name
                         request-metric-collector
                         policy-name]}]]),
    :doc "Generate map for deleteRolePolicy"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :iam,
     :fn :delete-role-policy,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   delete-role-policy
   {:arglists (quote
               [[credentials
                 {:keys [role-name
                         request-metric-collector
                         policy-name]}]]),
    :doc "Call deleteRolePolicy"}
   [credentials7547 & args7548]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7549
     (com.palletops.awaze.common/aws-client :iam credentials7547)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7549
      deleteRolePolicy
      (delete-role-policy-request (clojure.core/nth args7548 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :update-access-key
   [m7550]
   (clojure.core/let
    [credentials7551 (:credentials m7550) args7552 (:args m7550)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7553
      (com.palletops.awaze.common/aws-client :iam credentials7551)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7553
       updateAccessKey
       (update-access-key-request (clojure.core/nth args7552 0)))))))
  (clojure.core/defn
   update-access-key-map
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         status
                         request-metric-collector
                         access-key-id]}]]),
    :doc "Generate map for updateAccessKey"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :iam,
     :fn :update-access-key,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   update-access-key
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         status
                         request-metric-collector
                         access-key-id]}]]),
    :doc "Call updateAccessKey"}
   [credentials7555 & args7556]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7557
     (com.palletops.awaze.common/aws-client :iam credentials7555)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7557
      updateAccessKey
      (update-access-key-request (clojure.core/nth args7556 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-group
   [m7558]
   (clojure.core/let
    [credentials7559 (:credentials m7558) args7560 (:args m7558)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7561
      (com.palletops.awaze.common/aws-client :iam credentials7559)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7561
       deleteGroup
       (delete-group-request (clojure.core/nth args7560 0)))))))
  (clojure.core/defn
   delete-group-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector group-name]}]]),
    :doc "Generate map for deleteGroup"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :iam,
     :fn :delete-group,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   delete-group
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector group-name]}]]),
    :doc "Call deleteGroup"}
   [credentials7563 & args7564]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7565
     (com.palletops.awaze.common/aws-client :iam credentials7563)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7565
      deleteGroup
      (delete-group-request (clojure.core/nth args7564 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-groups-for-user
   [m7566]
   (clojure.core/let
    [credentials7567 (:credentials m7566) args7568 (:args m7566)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7569
      (com.palletops.awaze.common/aws-client :iam credentials7567)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7569
       listGroupsForUser
       (list-groups-for-user-request (clojure.core/nth args7568 0)))))))
  (clojure.core/defn
   list-groups-for-user-map
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         request-metric-collector
                         max-items
                         marker]}]]),
    :doc "Generate map for listGroupsForUser"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :iam,
     :fn :list-groups-for-user,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   list-groups-for-user
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         request-metric-collector
                         max-items
                         marker]}]]),
    :doc "Call listGroupsForUser"}
   [credentials7571 & args7572]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7573
     (com.palletops.awaze.common/aws-client :iam credentials7571)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7573
      listGroupsForUser
      (list-groups-for-user-request (clojure.core/nth args7572 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :put-user-policy
   [m7574]
   (clojure.core/let
    [credentials7575 (:credentials m7574) args7576 (:args m7574)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7577
      (com.palletops.awaze.common/aws-client :iam credentials7575)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7577
       putUserPolicy
       (put-user-policy-request (clojure.core/nth args7576 0)))))))
  (clojure.core/defn
   put-user-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         request-metric-collector
                         policy-name
                         policy-document]}]]),
    :doc "Generate map for putUserPolicy"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :iam,
     :fn :put-user-policy,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   put-user-policy
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         request-metric-collector
                         policy-name
                         policy-document]}]]),
    :doc "Call putUserPolicy"}
   [credentials7579 & args7580]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7581
     (com.palletops.awaze.common/aws-client :iam credentials7579)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7581
      putUserPolicy
      (put-user-policy-request (clojure.core/nth args7580 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-role
   [m7582]
   (clojure.core/let
    [credentials7583 (:credentials m7582) args7584 (:args m7582)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7585
      (com.palletops.awaze.common/aws-client :iam credentials7583)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7585
       getRole
       (get-role-request (clojure.core/nth args7584 0)))))))
  (clojure.core/defn
   get-role-map
   {:arglists (quote
               [[credentials
                 {:keys [role-name request-metric-collector]}]]),
    :doc "Generate map for getRole"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :iam,
     :fn :get-role,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   get-role
   {:arglists (quote
               [[credentials
                 {:keys [role-name request-metric-collector]}]]),
    :doc "Call getRole"}
   [credentials7587 & args7588]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7589
     (com.palletops.awaze.common/aws-client :iam credentials7587)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7589
      getRole
      (get-role-request (clojure.core/nth args7588 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-account-password-policy
   [m7590]
   (clojure.core/let
    [credentials7591 (:credentials m7590) args7592 (:args m7590)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7593
      (com.palletops.awaze.common/aws-client :iam credentials7591)]
     (clojure.core/case
      (clojure.core/count args7592)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7593
        getAccountPasswordPolicy
        (get-account-password-policy-request
         (clojure.core/nth args7592 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7593
        getAccountPasswordPolicy))))))
  (clojure.core/defn
   get-account-password-policy-map
   {:arglists (quote
               [[credentials {:keys [request-metric-collector]}]
                [credentials]]),
    :doc "Generate map for getAccountPasswordPolicy, getAccountPasswordPolicy"}
   ([credentials__1609__auto__]
    {:args [],
     :client :iam,
     :fn :get-account-password-policy,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :iam,
     :fn :get-account-password-policy,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   get-account-password-policy
   {:arglists (quote
               [[credentials {:keys [request-metric-collector]}]
                [credentials]]),
    :doc "Call getAccountPasswordPolicy, getAccountPasswordPolicy"}
   [credentials7595 & args7596]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7597
     (com.palletops.awaze.common/aws-client :iam credentials7595)]
    (clojure.core/case
     (clojure.core/count args7596)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7597
       getAccountPasswordPolicy
       (get-account-password-policy-request
        (clojure.core/nth args7596 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7597
       getAccountPasswordPolicy))))))
 (do
  (clojure.core/defmethod
   iam
   :list-access-keys
   [m7598]
   (clojure.core/let
    [credentials7599 (:credentials m7598) args7600 (:args m7598)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7601
      (com.palletops.awaze.common/aws-client :iam credentials7599)]
     (clojure.core/case
      (clojure.core/count args7600)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7601
        listAccessKeys
        (list-access-keys-request (clojure.core/nth args7600 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7601
        listAccessKeys))))))
  (clojure.core/defn
   list-access-keys-map
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         request-metric-collector
                         max-items
                         marker]}]
                [credentials]]),
    :doc "Generate map for listAccessKeys, listAccessKeys"}
   ([credentials__1609__auto__]
    {:args [],
     :client :iam,
     :fn :list-access-keys,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :iam,
     :fn :list-access-keys,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   list-access-keys
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         request-metric-collector
                         max-items
                         marker]}]
                [credentials]]),
    :doc "Call listAccessKeys, listAccessKeys"}
   [credentials7603 & args7604]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7605
     (com.palletops.awaze.common/aws-client :iam credentials7603)]
    (clojure.core/case
     (clojure.core/count args7604)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7605
       listAccessKeys
       (list-access-keys-request (clojure.core/nth args7604 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7605
       listAccessKeys))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-account-alias
   [m7606]
   (clojure.core/let
    [credentials7607 (:credentials m7606) args7608 (:args m7606)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7609
      (com.palletops.awaze.common/aws-client :iam credentials7607)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7609
       deleteAccountAlias
       (delete-account-alias-request (clojure.core/nth args7608 0)))))))
  (clojure.core/defn
   delete-account-alias-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector account-alias]}]]),
    :doc "Generate map for deleteAccountAlias"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :iam,
     :fn :delete-account-alias,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   delete-account-alias
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector account-alias]}]]),
    :doc "Call deleteAccountAlias"}
   [credentials7611 & args7612]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7613
     (com.palletops.awaze.common/aws-client :iam credentials7611)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7613
      deleteAccountAlias
      (delete-account-alias-request (clojure.core/nth args7612 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-login-profile
   [m7614]
   (clojure.core/let
    [credentials7615 (:credentials m7614) args7616 (:args m7614)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7617
      (com.palletops.awaze.common/aws-client :iam credentials7615)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7617
       getLoginProfile
       (get-login-profile-request (clojure.core/nth args7616 0)))))))
  (clojure.core/defn
   get-login-profile-map
   {:arglists (quote
               [[credentials
                 {:keys [user-name request-metric-collector]}]]),
    :doc "Generate map for getLoginProfile"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :iam,
     :fn :get-login-profile,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   get-login-profile
   {:arglists (quote
               [[credentials
                 {:keys [user-name request-metric-collector]}]]),
    :doc "Call getLoginProfile"}
   [credentials7619 & args7620]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7621
     (com.palletops.awaze.common/aws-client :iam credentials7619)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7621
      getLoginProfile
      (get-login-profile-request (clojure.core/nth args7620 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :create-login-profile
   [m7622]
   (clojure.core/let
    [credentials7623 (:credentials m7622) args7624 (:args m7622)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7625
      (com.palletops.awaze.common/aws-client :iam credentials7623)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7625
       createLoginProfile
       (create-login-profile-request (clojure.core/nth args7624 0)))))))
  (clojure.core/defn
   create-login-profile-map
   {:arglists (quote
               [[credentials
                 {:keys [user-name request-metric-collector password]}]]),
    :doc "Generate map for createLoginProfile"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :iam,
     :fn :create-login-profile,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   create-login-profile
   {:arglists (quote
               [[credentials
                 {:keys [user-name request-metric-collector password]}]]),
    :doc "Call createLoginProfile"}
   [credentials7627 & args7628]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7629
     (com.palletops.awaze.common/aws-client :iam credentials7627)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7629
      createLoginProfile
      (create-login-profile-request (clojure.core/nth args7628 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-groups
   [m7630]
   (clojure.core/let
    [credentials7631 (:credentials m7630) args7632 (:args m7630)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7633
      (com.palletops.awaze.common/aws-client :iam credentials7631)]
     (clojure.core/case
      (clojure.core/count args7632)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7633
        listGroups))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7633
        listGroups
        (list-groups-request (clojure.core/nth args7632 0))))))))
  (clojure.core/defn
   list-groups-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [request-metric-collector
                         path-prefix
                         max-items
                         marker]}]]),
    :doc "Generate map for listGroups, listGroups"}
   ([credentials__1609__auto__]
    {:args [],
     :client :iam,
     :fn :list-groups,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :iam,
     :fn :list-groups,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   list-groups
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [request-metric-collector
                         path-prefix
                         max-items
                         marker]}]]),
    :doc "Call listGroups, listGroups"}
   [credentials7635 & args7636]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7637
     (com.palletops.awaze.common/aws-client :iam credentials7635)]
    (clojure.core/case
     (clojure.core/count args7636)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7637
       listGroups))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7637
       listGroups
       (list-groups-request (clojure.core/nth args7636 0))))))))
 (do
  (clojure.core/defmethod
   iam
   :get-account-summary
   [m7638]
   (clojure.core/let
    [credentials7639 (:credentials m7638) args7640 (:args m7638)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7641
      (com.palletops.awaze.common/aws-client :iam credentials7639)]
     (clojure.core/case
      (clojure.core/count args7640)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7641
        getAccountSummary))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7641
        getAccountSummary
        (get-account-summary-request (clojure.core/nth args7640 0))))))))
  (clojure.core/defn
   get-account-summary-map
   {:arglists (quote
               [[credentials]
                [credentials {:keys [request-metric-collector]}]]),
    :doc "Generate map for getAccountSummary, getAccountSummary"}
   ([credentials__1609__auto__]
    {:args [],
     :client :iam,
     :fn :get-account-summary,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :iam,
     :fn :get-account-summary,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   get-account-summary
   {:arglists (quote
               [[credentials]
                [credentials {:keys [request-metric-collector]}]]),
    :doc "Call getAccountSummary, getAccountSummary"}
   [credentials7643 & args7644]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7645
     (com.palletops.awaze.common/aws-client :iam credentials7643)]
    (clojure.core/case
     (clojure.core/count args7644)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7645
       getAccountSummary))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7645
       getAccountSummary
       (get-account-summary-request (clojure.core/nth args7644 0))))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-account-password-policy
   [m7646]
   (clojure.core/let
    [credentials7647 (:credentials m7646) args7648 (:args m7646)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7649
      (com.palletops.awaze.common/aws-client :iam credentials7647)]
     (clojure.core/case
      (clojure.core/count args7648)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7649
        deleteAccountPasswordPolicy
        (delete-account-password-policy-request
         (clojure.core/nth args7648 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7649
        deleteAccountPasswordPolicy))))))
  (clojure.core/defn
   delete-account-password-policy-map
   {:arglists (quote
               [[credentials {:keys [request-metric-collector]}]
                [credentials]]),
    :doc "Generate map for deleteAccountPasswordPolicy, deleteAccountPasswordPolicy"}
   ([credentials__1609__auto__]
    {:args [],
     :client :iam,
     :fn :delete-account-password-policy,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :iam,
     :fn :delete-account-password-policy,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   delete-account-password-policy
   {:arglists (quote
               [[credentials {:keys [request-metric-collector]}]
                [credentials]]),
    :doc "Call deleteAccountPasswordPolicy, deleteAccountPasswordPolicy"}
   [credentials7651 & args7652]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7653
     (com.palletops.awaze.common/aws-client :iam credentials7651)]
    (clojure.core/case
     (clojure.core/count args7652)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7653
       deleteAccountPasswordPolicy
       (delete-account-password-policy-request
        (clojure.core/nth args7652 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7653
       deleteAccountPasswordPolicy))))))
 (do
  (clojure.core/defmethod
   iam
   :get-instance-profile
   [m7654]
   (clojure.core/let
    [credentials7655 (:credentials m7654) args7656 (:args m7654)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7657
      (com.palletops.awaze.common/aws-client :iam credentials7655)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7657
       getInstanceProfile
       (get-instance-profile-request (clojure.core/nth args7656 0)))))))
  (clojure.core/defn
   get-instance-profile-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         instance-profile-name]}]]),
    :doc "Generate map for getInstanceProfile"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :iam,
     :fn :get-instance-profile,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   get-instance-profile
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         instance-profile-name]}]]),
    :doc "Call getInstanceProfile"}
   [credentials7659 & args7660]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7661
     (com.palletops.awaze.common/aws-client :iam credentials7659)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7661
      getInstanceProfile
      (get-instance-profile-request (clojure.core/nth args7660 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-user
   [m7662]
   (clojure.core/let
    [credentials7663 (:credentials m7662) args7664 (:args m7662)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7665
      (com.palletops.awaze.common/aws-client :iam credentials7663)]
     (clojure.core/case
      (clojure.core/count args7664)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7665
        getUser))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7665
        getUser
        (get-user-request (clojure.core/nth args7664 0))))))))
  (clojure.core/defn
   get-user-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [user-name request-metric-collector]}]]),
    :doc "Generate map for getUser, getUser"}
   ([credentials__1609__auto__]
    {:args [],
     :client :iam,
     :fn :get-user,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :iam,
     :fn :get-user,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   get-user
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [user-name request-metric-collector]}]]),
    :doc "Call getUser, getUser"}
   [credentials7667 & args7668]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7669
     (com.palletops.awaze.common/aws-client :iam credentials7667)]
    (clojure.core/case
     (clojure.core/count args7668)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7669
       getUser))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7669
       getUser
       (get-user-request (clojure.core/nth args7668 0))))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-virtual-mfadevice
   [m7670]
   (clojure.core/let
    [credentials7671 (:credentials m7670) args7672 (:args m7670)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7673
      (com.palletops.awaze.common/aws-client :iam credentials7671)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7673
       deleteVirtualMFADevice
       (delete-virtual-mfadevice-request
        (clojure.core/nth args7672 0)))))))
  (clojure.core/defn
   delete-virtual-mfadevice-map
   {:arglists (quote
               [[credentials
                 {:keys [serial-number request-metric-collector]}]]),
    :doc "Generate map for deleteVirtualMFADevice"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :iam,
     :fn :delete-virtual-mfadevice,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   delete-virtual-mfadevice
   {:arglists (quote
               [[credentials
                 {:keys [serial-number request-metric-collector]}]]),
    :doc "Call deleteVirtualMFADevice"}
   [credentials7675 & args7676]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7677
     (com.palletops.awaze.common/aws-client :iam credentials7675)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7677
      deleteVirtualMFADevice
      (delete-virtual-mfadevice-request (clojure.core/nth args7676 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :create-access-key
   [m7678]
   (clojure.core/let
    [credentials7679 (:credentials m7678) args7680 (:args m7678)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7681
      (com.palletops.awaze.common/aws-client :iam credentials7679)]
     (clojure.core/case
      (clojure.core/count args7680)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7681
        createAccessKey
        (create-access-key-request (clojure.core/nth args7680 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7681
        createAccessKey))))))
  (clojure.core/defn
   create-access-key-map
   {:arglists (quote
               [[credentials
                 {:keys [user-name request-metric-collector]}]
                [credentials]]),
    :doc "Generate map for createAccessKey, createAccessKey"}
   ([credentials__1609__auto__]
    {:args [],
     :client :iam,
     :fn :create-access-key,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :iam,
     :fn :create-access-key,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   create-access-key
   {:arglists (quote
               [[credentials
                 {:keys [user-name request-metric-collector]}]
                [credentials]]),
    :doc "Call createAccessKey, createAccessKey"}
   [credentials7683 & args7684]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7685
     (com.palletops.awaze.common/aws-client :iam credentials7683)]
    (clojure.core/case
     (clojure.core/count args7684)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7685
       createAccessKey
       (create-access-key-request (clojure.core/nth args7684 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7685
       createAccessKey))))))
 (do
  (clojure.core/defmethod
   iam
   :list-instance-profiles
   [m7686]
   (clojure.core/let
    [credentials7687 (:credentials m7686) args7688 (:args m7686)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7689
      (com.palletops.awaze.common/aws-client :iam credentials7687)]
     (clojure.core/case
      (clojure.core/count args7688)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7689
        listInstanceProfiles))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7689
        listInstanceProfiles
        (list-instance-profiles-request (clojure.core/nth args7688 0))))))))
  (clojure.core/defn
   list-instance-profiles-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [request-metric-collector
                         path-prefix
                         max-items
                         marker]}]]),
    :doc "Generate map for listInstanceProfiles, listInstanceProfiles"}
   ([credentials__1609__auto__]
    {:args [],
     :client :iam,
     :fn :list-instance-profiles,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :iam,
     :fn :list-instance-profiles,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   list-instance-profiles
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [request-metric-collector
                         path-prefix
                         max-items
                         marker]}]]),
    :doc "Call listInstanceProfiles, listInstanceProfiles"}
   [credentials7691 & args7692]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7693
     (com.palletops.awaze.common/aws-client :iam credentials7691)]
    (clojure.core/case
     (clojure.core/count args7692)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7693
       listInstanceProfiles))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7693
       listInstanceProfiles
       (list-instance-profiles-request (clojure.core/nth args7692 0))))))))
 (do
  (clojure.core/defmethod
   iam
   :put-group-policy
   [m7694]
   (clojure.core/let
    [credentials7695 (:credentials m7694) args7696 (:args m7694)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7697
      (com.palletops.awaze.common/aws-client :iam credentials7695)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7697
       putGroupPolicy
       (put-group-policy-request (clojure.core/nth args7696 0)))))))
  (clojure.core/defn
   put-group-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         policy-name
                         policy-document
                         group-name]}]]),
    :doc "Generate map for putGroupPolicy"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :iam,
     :fn :put-group-policy,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   put-group-policy
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         policy-name
                         policy-document
                         group-name]}]]),
    :doc "Call putGroupPolicy"}
   [credentials7699 & args7700]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7701
     (com.palletops.awaze.common/aws-client :iam credentials7699)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7701
      putGroupPolicy
      (put-group-policy-request (clojure.core/nth args7700 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-server-certificate
   [m7702]
   (clojure.core/let
    [credentials7703 (:credentials m7702) args7704 (:args m7702)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7705
      (com.palletops.awaze.common/aws-client :iam credentials7703)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7705
       getServerCertificate
       (get-server-certificate-request (clojure.core/nth args7704 0)))))))
  (clojure.core/defn
   get-server-certificate-map
   {:arglists (quote
               [[credentials
                 {:keys [server-certificate-name
                         request-metric-collector]}]]),
    :doc "Generate map for getServerCertificate"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :iam,
     :fn :get-server-certificate,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   get-server-certificate
   {:arglists (quote
               [[credentials
                 {:keys [server-certificate-name
                         request-metric-collector]}]]),
    :doc "Call getServerCertificate"}
   [credentials7707 & args7708]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7709
     (com.palletops.awaze.common/aws-client :iam credentials7707)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7709
      getServerCertificate
      (get-server-certificate-request (clojure.core/nth args7708 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :upload-server-certificate
   [m7710]
   (clojure.core/let
    [credentials7711 (:credentials m7710) args7712 (:args m7710)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7713
      (com.palletops.awaze.common/aws-client :iam credentials7711)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7713
       uploadServerCertificate
       (upload-server-certificate-request
        (clojure.core/nth args7712 0)))))))
  (clojure.core/defn
   upload-server-certificate-map
   {:arglists (quote
               [[credentials
                 {:keys [server-certificate-name
                         request-metric-collector
                         private-key
                         path
                         certificate-chain
                         certificate-body]}]]),
    :doc "Generate map for uploadServerCertificate"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :iam,
     :fn :upload-server-certificate,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   upload-server-certificate
   {:arglists (quote
               [[credentials
                 {:keys [server-certificate-name
                         request-metric-collector
                         private-key
                         path
                         certificate-chain
                         certificate-body]}]]),
    :doc "Call uploadServerCertificate"}
   [credentials7715 & args7716]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7717
     (com.palletops.awaze.common/aws-client :iam credentials7715)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7717
      uploadServerCertificate
      (upload-server-certificate-request
       (clojure.core/nth args7716 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-role-policies
   [m7718]
   (clojure.core/let
    [credentials7719 (:credentials m7718) args7720 (:args m7718)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7721
      (com.palletops.awaze.common/aws-client :iam credentials7719)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7721
       listRolePolicies
       (list-role-policies-request (clojure.core/nth args7720 0)))))))
  (clojure.core/defn
   list-role-policies-map
   {:arglists (quote
               [[credentials
                 {:keys [role-name
                         request-metric-collector
                         max-items
                         marker]}]]),
    :doc "Generate map for listRolePolicies"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :iam,
     :fn :list-role-policies,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   list-role-policies
   {:arglists (quote
               [[credentials
                 {:keys [role-name
                         request-metric-collector
                         max-items
                         marker]}]]),
    :doc "Call listRolePolicies"}
   [credentials7723 & args7724]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7725
     (com.palletops.awaze.common/aws-client :iam credentials7723)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7725
      listRolePolicies
      (list-role-policies-request (clojure.core/nth args7724 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :add-role-to-instance-profile
   [m7726]
   (clojure.core/let
    [credentials7727 (:credentials m7726) args7728 (:args m7726)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7729
      (com.palletops.awaze.common/aws-client :iam credentials7727)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7729
       addRoleToInstanceProfile
       (add-role-to-instance-profile-request
        (clojure.core/nth args7728 0)))))))
  (clojure.core/defn
   add-role-to-instance-profile-map
   {:arglists (quote
               [[credentials
                 {:keys [role-name
                         request-metric-collector
                         instance-profile-name]}]]),
    :doc "Generate map for addRoleToInstanceProfile"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :iam,
     :fn :add-role-to-instance-profile,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   add-role-to-instance-profile
   {:arglists (quote
               [[credentials
                 {:keys [role-name
                         request-metric-collector
                         instance-profile-name]}]]),
    :doc "Call addRoleToInstanceProfile"}
   [credentials7731 & args7732]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7733
     (com.palletops.awaze.common/aws-client :iam credentials7731)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7733
      addRoleToInstanceProfile
      (add-role-to-instance-profile-request
       (clojure.core/nth args7732 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-access-key
   [m7734]
   (clojure.core/let
    [credentials7735 (:credentials m7734) args7736 (:args m7734)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7737
      (com.palletops.awaze.common/aws-client :iam credentials7735)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7737
       deleteAccessKey
       (delete-access-key-request (clojure.core/nth args7736 0)))))))
  (clojure.core/defn
   delete-access-key-map
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         request-metric-collector
                         access-key-id]}]]),
    :doc "Generate map for deleteAccessKey"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :iam,
     :fn :delete-access-key,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   delete-access-key
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         request-metric-collector
                         access-key-id]}]]),
    :doc "Call deleteAccessKey"}
   [credentials7739 & args7740]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7741
     (com.palletops.awaze.common/aws-client :iam credentials7739)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7741
      deleteAccessKey
      (delete-access-key-request (clojure.core/nth args7740 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-role
   [m7742]
   (clojure.core/let
    [credentials7743 (:credentials m7742) args7744 (:args m7742)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7745
      (com.palletops.awaze.common/aws-client :iam credentials7743)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7745
       deleteRole
       (delete-role-request (clojure.core/nth args7744 0)))))))
  (clojure.core/defn
   delete-role-map
   {:arglists (quote
               [[credentials
                 {:keys [role-name request-metric-collector]}]]),
    :doc "Generate map for deleteRole"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :iam,
     :fn :delete-role,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   delete-role
   {:arglists (quote
               [[credentials
                 {:keys [role-name request-metric-collector]}]]),
    :doc "Call deleteRole"}
   [credentials7747 & args7748]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7749
     (com.palletops.awaze.common/aws-client :iam credentials7747)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7749
      deleteRole
      (delete-role-request (clojure.core/nth args7748 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :create-virtual-mfadevice
   [m7750]
   (clojure.core/let
    [credentials7751 (:credentials m7750) args7752 (:args m7750)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7753
      (com.palletops.awaze.common/aws-client :iam credentials7751)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7753
       createVirtualMFADevice
       (create-virtual-mfadevice-request
        (clojure.core/nth args7752 0)))))))
  (clojure.core/defn
   create-virtual-mfadevice-map
   {:arglists (quote
               [[credentials
                 {:keys [virtual-mfadevice-name
                         request-metric-collector
                         path]}]]),
    :doc "Generate map for createVirtualMFADevice"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :iam,
     :fn :create-virtual-mfadevice,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   create-virtual-mfadevice
   {:arglists (quote
               [[credentials
                 {:keys [virtual-mfadevice-name
                         request-metric-collector
                         path]}]]),
    :doc "Call createVirtualMFADevice"}
   [credentials7755 & args7756]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7757
     (com.palletops.awaze.common/aws-client :iam credentials7755)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7757
      createVirtualMFADevice
      (create-virtual-mfadevice-request (clojure.core/nth args7756 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-group-policies
   [m7758]
   (clojure.core/let
    [credentials7759 (:credentials m7758) args7760 (:args m7758)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7761
      (com.palletops.awaze.common/aws-client :iam credentials7759)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7761
       listGroupPolicies
       (list-group-policies-request (clojure.core/nth args7760 0)))))))
  (clojure.core/defn
   list-group-policies-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         max-items
                         marker
                         group-name]}]]),
    :doc "Generate map for listGroupPolicies"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :iam,
     :fn :list-group-policies,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   list-group-policies
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         max-items
                         marker
                         group-name]}]]),
    :doc "Call listGroupPolicies"}
   [credentials7763 & args7764]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7765
     (com.palletops.awaze.common/aws-client :iam credentials7763)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7765
      listGroupPolicies
      (list-group-policies-request (clojure.core/nth args7764 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-group-policy
   [m7766]
   (clojure.core/let
    [credentials7767 (:credentials m7766) args7768 (:args m7766)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7769
      (com.palletops.awaze.common/aws-client :iam credentials7767)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7769
       getGroupPolicy
       (get-group-policy-request (clojure.core/nth args7768 0)))))))
  (clojure.core/defn
   get-group-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         policy-name
                         group-name]}]]),
    :doc "Generate map for getGroupPolicy"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :iam,
     :fn :get-group-policy,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   get-group-policy
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         policy-name
                         group-name]}]]),
    :doc "Call getGroupPolicy"}
   [credentials7771 & args7772]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7773
     (com.palletops.awaze.common/aws-client :iam credentials7771)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7773
      getGroupPolicy
      (get-group-policy-request (clojure.core/nth args7772 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-server-certificates
   [m7774]
   (clojure.core/let
    [credentials7775 (:credentials m7774) args7776 (:args m7774)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7777
      (com.palletops.awaze.common/aws-client :iam credentials7775)]
     (clojure.core/case
      (clojure.core/count args7776)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7777
        listServerCertificates))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7777
        listServerCertificates
        (list-server-certificates-request
         (clojure.core/nth args7776 0))))))))
  (clojure.core/defn
   list-server-certificates-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [request-metric-collector
                         path-prefix
                         max-items
                         marker]}]]),
    :doc "Generate map for listServerCertificates, listServerCertificates"}
   ([credentials__1609__auto__]
    {:args [],
     :client :iam,
     :fn :list-server-certificates,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :iam,
     :fn :list-server-certificates,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   list-server-certificates
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [request-metric-collector
                         path-prefix
                         max-items
                         marker]}]]),
    :doc "Call listServerCertificates, listServerCertificates"}
   [credentials7779 & args7780]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7781
     (com.palletops.awaze.common/aws-client :iam credentials7779)]
    (clojure.core/case
     (clojure.core/count args7780)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7781
       listServerCertificates))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7781
       listServerCertificates
       (list-server-certificates-request
        (clojure.core/nth args7780 0))))))))
 (do
  (clojure.core/defmethod
   iam
   :update-account-password-policy
   [m7782]
   (clojure.core/let
    [credentials7783 (:credentials m7782) args7784 (:args m7782)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7785
      (com.palletops.awaze.common/aws-client :iam credentials7783)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7785
       updateAccountPasswordPolicy
       (update-account-password-policy-request
        (clojure.core/nth args7784 0)))))))
  (clojure.core/defn
   update-account-password-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [require-lowercase-characters
                         minimum-password-length
                         require-uppercase-characters
                         require-symbols
                         request-metric-collector
                         require-numbers
                         allow-users-to-change-password]}]]),
    :doc "Generate map for updateAccountPasswordPolicy"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :iam,
     :fn :update-account-password-policy,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   update-account-password-policy
   {:arglists (quote
               [[credentials
                 {:keys [require-lowercase-characters
                         minimum-password-length
                         require-uppercase-characters
                         require-symbols
                         request-metric-collector
                         require-numbers
                         allow-users-to-change-password]}]]),
    :doc "Call updateAccountPasswordPolicy"}
   [credentials7787 & args7788]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7789
     (com.palletops.awaze.common/aws-client :iam credentials7787)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7789
      updateAccountPasswordPolicy
      (update-account-password-policy-request
       (clojure.core/nth args7788 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :create-group
   [m7790]
   (clojure.core/let
    [credentials7791 (:credentials m7790) args7792 (:args m7790)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7793
      (com.palletops.awaze.common/aws-client :iam credentials7791)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7793
       createGroup
       (create-group-request (clojure.core/nth args7792 0)))))))
  (clojure.core/defn
   create-group-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector path group-name]}]]),
    :doc "Generate map for createGroup"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :iam,
     :fn :create-group,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   create-group
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector path group-name]}]]),
    :doc "Call createGroup"}
   [credentials7795 & args7796]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7797
     (com.palletops.awaze.common/aws-client :iam credentials7795)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7797
      createGroup
      (create-group-request (clojure.core/nth args7796 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-instance-profiles-for-role
   [m7798]
   (clojure.core/let
    [credentials7799 (:credentials m7798) args7800 (:args m7798)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7801
      (com.palletops.awaze.common/aws-client :iam credentials7799)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7801
       listInstanceProfilesForRole
       (list-instance-profiles-for-role-request
        (clojure.core/nth args7800 0)))))))
  (clojure.core/defn
   list-instance-profiles-for-role-map
   {:arglists (quote
               [[credentials
                 {:keys [role-name
                         request-metric-collector
                         max-items
                         marker]}]]),
    :doc "Generate map for listInstanceProfilesForRole"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :iam,
     :fn :list-instance-profiles-for-role,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   list-instance-profiles-for-role
   {:arglists (quote
               [[credentials
                 {:keys [role-name
                         request-metric-collector
                         max-items
                         marker]}]]),
    :doc "Call listInstanceProfilesForRole"}
   [credentials7803 & args7804]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7805
     (com.palletops.awaze.common/aws-client :iam credentials7803)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7805
      listInstanceProfilesForRole
      (list-instance-profiles-for-role-request
       (clojure.core/nth args7804 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :upload-signing-certificate
   [m7806]
   (clojure.core/let
    [credentials7807 (:credentials m7806) args7808 (:args m7806)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7809
      (com.palletops.awaze.common/aws-client :iam credentials7807)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7809
       uploadSigningCertificate
       (upload-signing-certificate-request
        (clojure.core/nth args7808 0)))))))
  (clojure.core/defn
   upload-signing-certificate-map
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         request-metric-collector
                         certificate-body]}]]),
    :doc "Generate map for uploadSigningCertificate"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :iam,
     :fn :upload-signing-certificate,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   upload-signing-certificate
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         request-metric-collector
                         certificate-body]}]]),
    :doc "Call uploadSigningCertificate"}
   [credentials7811 & args7812]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7813
     (com.palletops.awaze.common/aws-client :iam credentials7811)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7813
      uploadSigningCertificate
      (upload-signing-certificate-request
       (clojure.core/nth args7812 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-server-certificate
   [m7814]
   (clojure.core/let
    [credentials7815 (:credentials m7814) args7816 (:args m7814)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7817
      (com.palletops.awaze.common/aws-client :iam credentials7815)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7817
       deleteServerCertificate
       (delete-server-certificate-request
        (clojure.core/nth args7816 0)))))))
  (clojure.core/defn
   delete-server-certificate-map
   {:arglists (quote
               [[credentials
                 {:keys [server-certificate-name
                         request-metric-collector]}]]),
    :doc "Generate map for deleteServerCertificate"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :iam,
     :fn :delete-server-certificate,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   delete-server-certificate
   {:arglists (quote
               [[credentials
                 {:keys [server-certificate-name
                         request-metric-collector]}]]),
    :doc "Call deleteServerCertificate"}
   [credentials7819 & args7820]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7821
     (com.palletops.awaze.common/aws-client :iam credentials7819)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7821
      deleteServerCertificate
      (delete-server-certificate-request
       (clojure.core/nth args7820 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-virtual-mfadevices
   [m7822]
   (clojure.core/let
    [credentials7823 (:credentials m7822) args7824 (:args m7822)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7825
      (com.palletops.awaze.common/aws-client :iam credentials7823)]
     (clojure.core/case
      (clojure.core/count args7824)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7825
        listVirtualMFADevices
        (list-virtual-mfadevices-request
         (clojure.core/nth args7824 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7825
        listVirtualMFADevices))))))
  (clojure.core/defn
   list-virtual-mfadevices-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         max-items
                         marker
                         assignment-status]}]
                [credentials]]),
    :doc "Generate map for listVirtualMFADevices, listVirtualMFADevices"}
   ([credentials__1609__auto__]
    {:args [],
     :client :iam,
     :fn :list-virtual-mfadevices,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :iam,
     :fn :list-virtual-mfadevices,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   list-virtual-mfadevices
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         max-items
                         marker
                         assignment-status]}]
                [credentials]]),
    :doc "Call listVirtualMFADevices, listVirtualMFADevices"}
   [credentials7827 & args7828]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7829
     (com.palletops.awaze.common/aws-client :iam credentials7827)]
    (clojure.core/case
     (clojure.core/count args7828)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7829
       listVirtualMFADevices
       (list-virtual-mfadevices-request (clojure.core/nth args7828 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7829
       listVirtualMFADevices))))))
 (do
  (clojure.core/defmethod
   iam
   :remove-role-from-instance-profile
   [m7830]
   (clojure.core/let
    [credentials7831 (:credentials m7830) args7832 (:args m7830)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7833
      (com.palletops.awaze.common/aws-client :iam credentials7831)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7833
       removeRoleFromInstanceProfile
       (remove-role-from-instance-profile-request
        (clojure.core/nth args7832 0)))))))
  (clojure.core/defn
   remove-role-from-instance-profile-map
   {:arglists (quote
               [[credentials
                 {:keys [role-name
                         request-metric-collector
                         instance-profile-name]}]]),
    :doc "Generate map for removeRoleFromInstanceProfile"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :iam,
     :fn :remove-role-from-instance-profile,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   remove-role-from-instance-profile
   {:arglists (quote
               [[credentials
                 {:keys [role-name
                         request-metric-collector
                         instance-profile-name]}]]),
    :doc "Call removeRoleFromInstanceProfile"}
   [credentials7835 & args7836]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7837
     (com.palletops.awaze.common/aws-client :iam credentials7835)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7837
      removeRoleFromInstanceProfile
      (remove-role-from-instance-profile-request
       (clojure.core/nth args7836 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-signing-certificates
   [m7838]
   (clojure.core/let
    [credentials7839 (:credentials m7838) args7840 (:args m7838)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7841
      (com.palletops.awaze.common/aws-client :iam credentials7839)]
     (clojure.core/case
      (clojure.core/count args7840)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7841
        listSigningCertificates))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7841
        listSigningCertificates
        (list-signing-certificates-request
         (clojure.core/nth args7840 0))))))))
  (clojure.core/defn
   list-signing-certificates-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [user-name
                         request-metric-collector
                         max-items
                         marker]}]]),
    :doc "Generate map for listSigningCertificates, listSigningCertificates"}
   ([credentials__1609__auto__]
    {:args [],
     :client :iam,
     :fn :list-signing-certificates,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :iam,
     :fn :list-signing-certificates,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   list-signing-certificates
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [user-name
                         request-metric-collector
                         max-items
                         marker]}]]),
    :doc "Call listSigningCertificates, listSigningCertificates"}
   [credentials7843 & args7844]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7845
     (com.palletops.awaze.common/aws-client :iam credentials7843)]
    (clojure.core/case
     (clojure.core/count args7844)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7845
       listSigningCertificates))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7845
       listSigningCertificates
       (list-signing-certificates-request
        (clojure.core/nth args7844 0))))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-instance-profile
   [m7846]
   (clojure.core/let
    [credentials7847 (:credentials m7846) args7848 (:args m7846)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7849
      (com.palletops.awaze.common/aws-client :iam credentials7847)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7849
       deleteInstanceProfile
       (delete-instance-profile-request (clojure.core/nth args7848 0)))))))
  (clojure.core/defn
   delete-instance-profile-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         instance-profile-name]}]]),
    :doc "Generate map for deleteInstanceProfile"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :iam,
     :fn :delete-instance-profile,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   delete-instance-profile
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         instance-profile-name]}]]),
    :doc "Call deleteInstanceProfile"}
   [credentials7851 & args7852]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7853
     (com.palletops.awaze.common/aws-client :iam credentials7851)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7853
      deleteInstanceProfile
      (delete-instance-profile-request (clojure.core/nth args7852 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-mfadevices
   [m7854]
   (clojure.core/let
    [credentials7855 (:credentials m7854) args7856 (:args m7854)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7857
      (com.palletops.awaze.common/aws-client :iam credentials7855)]
     (clojure.core/case
      (clojure.core/count args7856)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7857
        listMFADevices))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7857
        listMFADevices
        (list-mfadevices-request (clojure.core/nth args7856 0))))))))
  (clojure.core/defn
   list-mfadevices-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [user-name
                         request-metric-collector
                         max-items
                         marker]}]]),
    :doc "Generate map for listMFADevices, listMFADevices"}
   ([credentials__1609__auto__]
    {:args [],
     :client :iam,
     :fn :list-mfadevices,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :iam,
     :fn :list-mfadevices,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   list-mfadevices
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [user-name
                         request-metric-collector
                         max-items
                         marker]}]]),
    :doc "Call listMFADevices, listMFADevices"}
   [credentials7859 & args7860]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7861
     (com.palletops.awaze.common/aws-client :iam credentials7859)]
    (clojure.core/case
     (clojure.core/count args7860)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7861
       listMFADevices))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7861
       listMFADevices
       (list-mfadevices-request (clojure.core/nth args7860 0))))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-user-policy
   [m7862]
   (clojure.core/let
    [credentials7863 (:credentials m7862) args7864 (:args m7862)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7865
      (com.palletops.awaze.common/aws-client :iam credentials7863)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7865
       deleteUserPolicy
       (delete-user-policy-request (clojure.core/nth args7864 0)))))))
  (clojure.core/defn
   delete-user-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         request-metric-collector
                         policy-name]}]]),
    :doc "Generate map for deleteUserPolicy"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :iam,
     :fn :delete-user-policy,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   delete-user-policy
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         request-metric-collector
                         policy-name]}]]),
    :doc "Call deleteUserPolicy"}
   [credentials7867 & args7868]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7869
     (com.palletops.awaze.common/aws-client :iam credentials7867)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7869
      deleteUserPolicy
      (delete-user-policy-request (clojure.core/nth args7868 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :create-account-alias
   [m7870]
   (clojure.core/let
    [credentials7871 (:credentials m7870) args7872 (:args m7870)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7873
      (com.palletops.awaze.common/aws-client :iam credentials7871)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7873
       createAccountAlias
       (create-account-alias-request (clojure.core/nth args7872 0)))))))
  (clojure.core/defn
   create-account-alias-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector account-alias]}]]),
    :doc "Generate map for createAccountAlias"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :iam,
     :fn :create-account-alias,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   create-account-alias
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector account-alias]}]]),
    :doc "Call createAccountAlias"}
   [credentials7875 & args7876]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7877
     (com.palletops.awaze.common/aws-client :iam credentials7875)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7877
      createAccountAlias
      (create-account-alias-request (clojure.core/nth args7876 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :update-signing-certificate
   [m7878]
   (clojure.core/let
    [credentials7879 (:credentials m7878) args7880 (:args m7878)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7881
      (com.palletops.awaze.common/aws-client :iam credentials7879)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7881
       updateSigningCertificate
       (update-signing-certificate-request
        (clojure.core/nth args7880 0)))))))
  (clojure.core/defn
   update-signing-certificate-map
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         status
                         request-metric-collector
                         certificate-id]}]]),
    :doc "Generate map for updateSigningCertificate"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :iam,
     :fn :update-signing-certificate,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   update-signing-certificate
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         status
                         request-metric-collector
                         certificate-id]}]]),
    :doc "Call updateSigningCertificate"}
   [credentials7883 & args7884]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7885
     (com.palletops.awaze.common/aws-client :iam credentials7883)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7885
      updateSigningCertificate
      (update-signing-certificate-request
       (clojure.core/nth args7884 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :update-assume-role-policy
   [m7886]
   (clojure.core/let
    [credentials7887 (:credentials m7886) args7888 (:args m7886)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7889
      (com.palletops.awaze.common/aws-client :iam credentials7887)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7889
       updateAssumeRolePolicy
       (update-assume-role-policy-request
        (clojure.core/nth args7888 0)))))))
  (clojure.core/defn
   update-assume-role-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [role-name
                         request-metric-collector
                         policy-document]}]]),
    :doc "Generate map for updateAssumeRolePolicy"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :iam,
     :fn :update-assume-role-policy,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   update-assume-role-policy
   {:arglists (quote
               [[credentials
                 {:keys [role-name
                         request-metric-collector
                         policy-document]}]]),
    :doc "Call updateAssumeRolePolicy"}
   [credentials7891 & args7892]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7893
     (com.palletops.awaze.common/aws-client :iam credentials7891)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7893
      updateAssumeRolePolicy
      (update-assume-role-policy-request
       (clojure.core/nth args7892 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-roles
   [m7894]
   (clojure.core/let
    [credentials7895 (:credentials m7894) args7896 (:args m7894)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7897
      (com.palletops.awaze.common/aws-client :iam credentials7895)]
     (clojure.core/case
      (clojure.core/count args7896)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7897
        listRoles
        (list-roles-request (clojure.core/nth args7896 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7897
        listRoles))))))
  (clojure.core/defn
   list-roles-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         path-prefix
                         max-items
                         marker]}]
                [credentials]]),
    :doc "Generate map for listRoles, listRoles"}
   ([credentials__1609__auto__]
    {:args [],
     :client :iam,
     :fn :list-roles,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :iam,
     :fn :list-roles,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   list-roles
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         path-prefix
                         max-items
                         marker]}]
                [credentials]]),
    :doc "Call listRoles, listRoles"}
   [credentials7899 & args7900]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7901
     (com.palletops.awaze.common/aws-client :iam credentials7899)]
    (clojure.core/case
     (clojure.core/count args7900)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7901
       listRoles
       (list-roles-request (clojure.core/nth args7900 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7901
       listRoles))))))
 (do
  (clojure.core/defmethod
   iam
   :list-user-policies
   [m7902]
   (clojure.core/let
    [credentials7903 (:credentials m7902) args7904 (:args m7902)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7905
      (com.palletops.awaze.common/aws-client :iam credentials7903)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7905
       listUserPolicies
       (list-user-policies-request (clojure.core/nth args7904 0)))))))
  (clojure.core/defn
   list-user-policies-map
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         request-metric-collector
                         max-items
                         marker]}]]),
    :doc "Generate map for listUserPolicies"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :iam,
     :fn :list-user-policies,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   list-user-policies
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         request-metric-collector
                         max-items
                         marker]}]]),
    :doc "Call listUserPolicies"}
   [credentials7907 & args7908]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7909
     (com.palletops.awaze.common/aws-client :iam credentials7907)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7909
      listUserPolicies
      (list-user-policies-request (clojure.core/nth args7908 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-login-profile
   [m7910]
   (clojure.core/let
    [credentials7911 (:credentials m7910) args7912 (:args m7910)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7913
      (com.palletops.awaze.common/aws-client :iam credentials7911)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7913
       deleteLoginProfile
       (delete-login-profile-request (clojure.core/nth args7912 0)))))))
  (clojure.core/defn
   delete-login-profile-map
   {:arglists (quote
               [[credentials
                 {:keys [user-name request-metric-collector]}]]),
    :doc "Generate map for deleteLoginProfile"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :iam,
     :fn :delete-login-profile,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   delete-login-profile
   {:arglists (quote
               [[credentials
                 {:keys [user-name request-metric-collector]}]]),
    :doc "Call deleteLoginProfile"}
   [credentials7915 & args7916]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7917
     (com.palletops.awaze.common/aws-client :iam credentials7915)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7917
      deleteLoginProfile
      (delete-login-profile-request (clojure.core/nth args7916 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :enable-mfadevice
   [m7918]
   (clojure.core/let
    [credentials7919 (:credentials m7918) args7920 (:args m7918)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7921
      (com.palletops.awaze.common/aws-client :iam credentials7919)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7921
       enableMFADevice
       (enable-mfadevice-request (clojure.core/nth args7920 0)))))))
  (clojure.core/defn
   enable-mfadevice-map
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         serial-number
                         request-metric-collector
                         authentication-code2
                         authentication-code1]}]]),
    :doc "Generate map for enableMFADevice"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :iam,
     :fn :enable-mfadevice,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   enable-mfadevice
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         serial-number
                         request-metric-collector
                         authentication-code2
                         authentication-code1]}]]),
    :doc "Call enableMFADevice"}
   [credentials7923 & args7924]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7925
     (com.palletops.awaze.common/aws-client :iam credentials7923)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7925
      enableMFADevice
      (enable-mfadevice-request (clojure.core/nth args7924 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-group
   [m7926]
   (clojure.core/let
    [credentials7927 (:credentials m7926) args7928 (:args m7926)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7929
      (com.palletops.awaze.common/aws-client :iam credentials7927)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7929
       getGroup
       (get-group-request (clojure.core/nth args7928 0)))))))
  (clojure.core/defn
   get-group-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         max-items
                         marker
                         group-name]}]]),
    :doc "Generate map for getGroup"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :iam,
     :fn :get-group,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   get-group
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         max-items
                         marker
                         group-name]}]]),
    :doc "Call getGroup"}
   [credentials7931 & args7932]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7933
     (com.palletops.awaze.common/aws-client :iam credentials7931)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7933
      getGroup
      (get-group-request (clojure.core/nth args7932 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :delete-group-policy
   [m7934]
   (clojure.core/let
    [credentials7935 (:credentials m7934) args7936 (:args m7934)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7937
      (com.palletops.awaze.common/aws-client :iam credentials7935)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7937
       deleteGroupPolicy
       (delete-group-policy-request (clojure.core/nth args7936 0)))))))
  (clojure.core/defn
   delete-group-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         policy-name
                         group-name]}]]),
    :doc "Generate map for deleteGroupPolicy"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :iam,
     :fn :delete-group-policy,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   delete-group-policy
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         policy-name
                         group-name]}]]),
    :doc "Call deleteGroupPolicy"}
   [credentials7939 & args7940]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7941
     (com.palletops.awaze.common/aws-client :iam credentials7939)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7941
      deleteGroupPolicy
      (delete-group-policy-request (clojure.core/nth args7940 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :create-instance-profile
   [m7942]
   (clojure.core/let
    [credentials7943 (:credentials m7942) args7944 (:args m7942)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7945
      (com.palletops.awaze.common/aws-client :iam credentials7943)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7945
       createInstanceProfile
       (create-instance-profile-request (clojure.core/nth args7944 0)))))))
  (clojure.core/defn
   create-instance-profile-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         path
                         instance-profile-name]}]]),
    :doc "Generate map for createInstanceProfile"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :iam,
     :fn :create-instance-profile,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   create-instance-profile
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         path
                         instance-profile-name]}]]),
    :doc "Call createInstanceProfile"}
   [credentials7947 & args7948]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7949
     (com.palletops.awaze.common/aws-client :iam credentials7947)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7949
      createInstanceProfile
      (create-instance-profile-request (clojure.core/nth args7948 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :update-user
   [m7950]
   (clojure.core/let
    [credentials7951 (:credentials m7950) args7952 (:args m7950)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7953
      (com.palletops.awaze.common/aws-client :iam credentials7951)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7953
       updateUser
       (update-user-request (clojure.core/nth args7952 0)))))))
  (clojure.core/defn
   update-user-map
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         request-metric-collector
                         new-user-name
                         new-path]}]]),
    :doc "Generate map for updateUser"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :iam,
     :fn :update-user,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   update-user
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         request-metric-collector
                         new-user-name
                         new-path]}]]),
    :doc "Call updateUser"}
   [credentials7955 & args7956]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7957
     (com.palletops.awaze.common/aws-client :iam credentials7955)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7957
      updateUser
      (update-user-request (clojure.core/nth args7956 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :create-user
   [m7958]
   (clojure.core/let
    [credentials7959 (:credentials m7958) args7960 (:args m7958)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7961
      (com.palletops.awaze.common/aws-client :iam credentials7959)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7961
       createUser
       (create-user-request (clojure.core/nth args7960 0)))))))
  (clojure.core/defn
   create-user-map
   {:arglists (quote
               [[credentials
                 {:keys [user-name request-metric-collector path]}]]),
    :doc "Generate map for createUser"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :iam,
     :fn :create-user,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   create-user
   {:arglists (quote
               [[credentials
                 {:keys [user-name request-metric-collector path]}]]),
    :doc "Call createUser"}
   [credentials7963 & args7964]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7965
     (com.palletops.awaze.common/aws-client :iam credentials7963)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7965
      createUser
      (create-user-request (clojure.core/nth args7964 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :create-role
   [m7966]
   (clojure.core/let
    [credentials7967 (:credentials m7966) args7968 (:args m7966)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7969
      (com.palletops.awaze.common/aws-client :iam credentials7967)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7969
       createRole
       (create-role-request (clojure.core/nth args7968 0)))))))
  (clojure.core/defn
   create-role-map
   {:arglists (quote
               [[credentials
                 {:keys [role-name
                         request-metric-collector
                         path
                         assume-role-policy-document]}]]),
    :doc "Generate map for createRole"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :iam,
     :fn :create-role,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   create-role
   {:arglists (quote
               [[credentials
                 {:keys [role-name
                         request-metric-collector
                         path
                         assume-role-policy-document]}]]),
    :doc "Call createRole"}
   [credentials7971 & args7972]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7973
     (com.palletops.awaze.common/aws-client :iam credentials7971)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7973
      createRole
      (create-role-request (clojure.core/nth args7972 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :get-user-policy
   [m7974]
   (clojure.core/let
    [credentials7975 (:credentials m7974) args7976 (:args m7974)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7977
      (com.palletops.awaze.common/aws-client :iam credentials7975)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7977
       getUserPolicy
       (get-user-policy-request (clojure.core/nth args7976 0)))))))
  (clojure.core/defn
   get-user-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         request-metric-collector
                         policy-name]}]]),
    :doc "Generate map for getUserPolicy"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :iam,
     :fn :get-user-policy,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   get-user-policy
   {:arglists (quote
               [[credentials
                 {:keys [user-name
                         request-metric-collector
                         policy-name]}]]),
    :doc "Call getUserPolicy"}
   [credentials7979 & args7980]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7981
     (com.palletops.awaze.common/aws-client :iam credentials7979)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7981
      getUserPolicy
      (get-user-policy-request (clojure.core/nth args7980 0)))))))
 (do
  (clojure.core/defmethod
   iam
   :list-users
   [m7982]
   (clojure.core/let
    [credentials7983 (:credentials m7982) args7984 (:args m7982)]
    (clojure.core/let
     [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7985
      (com.palletops.awaze.common/aws-client :iam credentials7983)]
     (clojure.core/case
      (clojure.core/count args7984)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7985
        listUsers
        (list-users-request (clojure.core/nth args7984 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7985
        listUsers))))))
  (clojure.core/defn
   list-users-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         path-prefix
                         max-items
                         marker]}]
                [credentials]]),
    :doc "Generate map for listUsers, listUsers"}
   ([credentials__1609__auto__]
    {:args [],
     :client :iam,
     :fn :list-users,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :iam,
     :fn :list-users,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   list-users
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         path-prefix
                         max-items
                         marker]}]
                [credentials]]),
    :doc "Call listUsers, listUsers"}
   [credentials7987 & args7988]
   (clojure.core/let
    [^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7989
     (com.palletops.awaze.common/aws-client :iam credentials7987)]
    (clojure.core/case
     (clojure.core/count args7988)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7989
       listUsers
       (list-users-request (clojure.core/nth args7988 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.identitymanagement.AmazonIdentityManagementClient client7989
       listUsers)))))))
