(ns
 com.palletops.awaze.redshift
 (:require [com.palletops.awaze.common]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :redshift
  [___1561__auto__
   ^com.amazonaws.auth.BasicAWSCredentials credentials__1562__auto__]
  (new
   com.amazonaws.services.redshift.AmazonRedshiftClient
   credentials__1562__auto__))
 (clojure.core/defn
  ^com.amazonaws.services.redshift.model.Parameter parameter
  [m2235]
  (clojure.core/let
   [bean2234 (new com.amazonaws.services.redshift.model.Parameter)]
   (clojure.core/when-let
    [v2236 (:source m2235)]
    (. bean2234 setSource (clojure.core/str v2236)))
   (clojure.core/when-let
    [v2236 (:description m2235)]
    (. bean2234 setDescription (clojure.core/str v2236)))
   (clojure.core/when-let
    [v2236 (:parameter-name m2235)]
    (. bean2234 setParameterName (clojure.core/str v2236)))
   (clojure.core/when-let
    [v2236 (:parameter-value m2235)]
    (. bean2234 setParameterValue (clojure.core/str v2236)))
   (clojure.core/when-let
    [v2236 (:data-type m2235)]
    (. bean2234 setDataType (clojure.core/str v2236)))
   (clojure.core/when-let
    [v2236 (:allowed-values m2235)]
    (. bean2234 setAllowedValues (clojure.core/str v2236)))
   (clojure.core/when-let
    [v2236 (:is-modifiable m2235)]
    (. bean2234 setIsModifiable (clojure.core/boolean v2236)))
   (clojure.core/when-let
    [v2236 (:minimum-engine-version m2235)]
    (. bean2234 setMinimumEngineVersion (clojure.core/str v2236)))
   bean2234))
 (clojure.core/defn
  ^com.amazonaws.services.redshift.model.SourceType source-type
  [m2238]
  (java.lang.Enum/valueOf
   com.amazonaws.services.redshift.model.SourceType
   (clojure.core/name m2238)))
 (clojure.core/defn
  ^com.amazonaws.services.redshift.model.DescribeClusterSecurityGroupsRequest describe-cluster-security-groups-request
  [m2241]
  (clojure.core/let
   [bean2240
    (new
     com.amazonaws.services.redshift.model.DescribeClusterSecurityGroupsRequest)]
   (clojure.core/when-let
    [v2242 (:marker m2241)]
    (. bean2240 setMarker (clojure.core/str v2242)))
   (clojure.core/when-let
    [v2242 (:cluster-security-group-name m2241)]
    (. bean2240 setClusterSecurityGroupName (clojure.core/str v2242)))
   (clojure.core/when-let
    [v2242 (:max-records m2241)]
    (. bean2240 setMaxRecords (clojure.core/int v2242)))
   bean2240))
 (clojure.core/defn
  ^com.amazonaws.services.redshift.model.DescribeClusterParameterGroupsRequest describe-cluster-parameter-groups-request
  [m2244]
  (clojure.core/let
   [bean2243
    (new
     com.amazonaws.services.redshift.model.DescribeClusterParameterGroupsRequest)]
   (clojure.core/when-let
    [v2245 (:marker m2244)]
    (. bean2243 setMarker (clojure.core/str v2245)))
   (clojure.core/when-let
    [v2245 (:parameter-group-name m2244)]
    (. bean2243 setParameterGroupName (clojure.core/str v2245)))
   (clojure.core/when-let
    [v2245 (:max-records m2244)]
    (. bean2243 setMaxRecords (clojure.core/int v2245)))
   bean2243))
 (clojure.core/defn
  ^com.amazonaws.services.redshift.model.CreateClusterRequest create-cluster-request
  [m2247]
  (clojure.core/let
   [bean2246
    (new com.amazonaws.services.redshift.model.CreateClusterRequest)]
   (clojure.core/when-let
    [v2248 (:cluster-identifier m2247)]
    (. bean2246 setClusterIdentifier (clojure.core/str v2248)))
   (clojure.core/when-let
    [v2248 (:availability-zone m2247)]
    (. bean2246 setAvailabilityZone (clojure.core/str v2248)))
   (clojure.core/when-let
    [v2248 (:master-username m2247)]
    (. bean2246 setMasterUsername (clojure.core/str v2248)))
   (clojure.core/when-let
    [v2248 (:cluster-version m2247)]
    (. bean2246 setClusterVersion (clojure.core/str v2248)))
   (clojure.core/when-let
    [v2248 (:node-type m2247)]
    (. bean2246 setNodeType (clojure.core/str v2248)))
   (clojure.core/when-let
    [v2248 (:number-of-nodes m2247)]
    (. bean2246 setNumberOfNodes (clojure.core/int v2248)))
   (clojure.core/when-let
    [v2248 (:dbname m2247)]
    (. bean2246 setDBName (clojure.core/str v2248)))
   (clojure.core/when-let
    [v2248 (:encrypted m2247)]
    (. bean2246 setEncrypted (clojure.core/boolean v2248)))
   (clojure.core/when-let
    [v2248 (:cluster-subnet-group-name m2247)]
    (. bean2246 setClusterSubnetGroupName (clojure.core/str v2248)))
   (clojure.core/when-let
    [v2248 (:cluster-type m2247)]
    (. bean2246 setClusterType (clojure.core/str v2248)))
   (clojure.core/when-let
    [v2248 (:cluster-security-groups m2247)]
    (.
     bean2246
     setClusterSecurityGroups
     (clojure.core/map
      (clojure.core/fn [arg2252] (clojure.core/str arg2252))
      v2248)))
   (clojure.core/when-let
    [v2248 (:vpc-security-group-ids m2247)]
    (.
     bean2246
     setVpcSecurityGroupIds
     (clojure.core/map
      (clojure.core/fn [arg2253] (clojure.core/str arg2253))
      v2248)))
   (clojure.core/when-let
    [v2248 (:master-user-password m2247)]
    (. bean2246 setMasterUserPassword (clojure.core/str v2248)))
   (clojure.core/when-let
    [v2248 (:cluster-parameter-group-name m2247)]
    (. bean2246 setClusterParameterGroupName (clojure.core/str v2248)))
   (clojure.core/when-let
    [v2248 (:automated-snapshot-retention-period m2247)]
    (.
     bean2246
     setAutomatedSnapshotRetentionPeriod
     (clojure.core/int v2248)))
   (clojure.core/when-let
    [v2248 (:preferred-maintenance-window m2247)]
    (.
     bean2246
     setPreferredMaintenanceWindow
     (clojure.core/str v2248)))
   (clojure.core/when-let
    [v2248 (:allow-version-upgrade m2247)]
    (. bean2246 setAllowVersionUpgrade (clojure.core/boolean v2248)))
   (clojure.core/when-let
    [v2248 (:publicly-accessible m2247)]
    (. bean2246 setPubliclyAccessible (clojure.core/boolean v2248)))
   (clojure.core/when-let
    [v2248 (:port m2247)]
    (. bean2246 setPort (clojure.core/int v2248)))
   bean2246))
 (clojure.core/defn
  ^com.amazonaws.services.redshift.model.AuthorizeSnapshotAccessRequest authorize-snapshot-access-request
  [m2250]
  (clojure.core/let
   [bean2249
    (new
     com.amazonaws.services.redshift.model.AuthorizeSnapshotAccessRequest)]
   (clojure.core/when-let
    [v2251 (:snapshot-identifier m2250)]
    (. bean2249 setSnapshotIdentifier (clojure.core/str v2251)))
   (clojure.core/when-let
    [v2251 (:snapshot-cluster-identifier m2250)]
    (. bean2249 setSnapshotClusterIdentifier (clojure.core/str v2251)))
   (clojure.core/when-let
    [v2251 (:account-with-restore-access m2250)]
    (. bean2249 setAccountWithRestoreAccess (clojure.core/str v2251)))
   bean2249))
 (clojure.core/defn
  ^com.amazonaws.services.redshift.model.DescribeClusterSubnetGroupsRequest describe-cluster-subnet-groups-request
  [m2255]
  (clojure.core/let
   [bean2254
    (new
     com.amazonaws.services.redshift.model.DescribeClusterSubnetGroupsRequest)]
   (clojure.core/when-let
    [v2256 (:marker m2255)]
    (. bean2254 setMarker (clojure.core/str v2256)))
   (clojure.core/when-let
    [v2256 (:cluster-subnet-group-name m2255)]
    (. bean2254 setClusterSubnetGroupName (clojure.core/str v2256)))
   (clojure.core/when-let
    [v2256 (:max-records m2255)]
    (. bean2254 setMaxRecords (clojure.core/int v2256)))
   bean2254))
 (clojure.core/defn
  ^com.amazonaws.services.redshift.model.DescribeClustersRequest describe-clusters-request
  [m2258]
  (clojure.core/let
   [bean2257
    (new
     com.amazonaws.services.redshift.model.DescribeClustersRequest)]
   (clojure.core/when-let
    [v2259 (:marker m2258)]
    (. bean2257 setMarker (clojure.core/str v2259)))
   (clojure.core/when-let
    [v2259 (:cluster-identifier m2258)]
    (. bean2257 setClusterIdentifier (clojure.core/str v2259)))
   (clojure.core/when-let
    [v2259 (:max-records m2258)]
    (. bean2257 setMaxRecords (clojure.core/int v2259)))
   bean2257))
 (clojure.core/defn
  ^com.amazonaws.services.redshift.model.RestoreFromClusterSnapshotRequest restore-from-cluster-snapshot-request
  [m2261]
  (clojure.core/let
   [bean2260
    (new
     com.amazonaws.services.redshift.model.RestoreFromClusterSnapshotRequest)]
   (clojure.core/when-let
    [v2262 (:snapshot-identifier m2261)]
    (. bean2260 setSnapshotIdentifier (clojure.core/str v2262)))
   (clojure.core/when-let
    [v2262 (:snapshot-cluster-identifier m2261)]
    (. bean2260 setSnapshotClusterIdentifier (clojure.core/str v2262)))
   (clojure.core/when-let
    [v2262 (:cluster-identifier m2261)]
    (. bean2260 setClusterIdentifier (clojure.core/str v2262)))
   (clojure.core/when-let
    [v2262 (:availability-zone m2261)]
    (. bean2260 setAvailabilityZone (clojure.core/str v2262)))
   (clojure.core/when-let
    [v2262 (:owner-account m2261)]
    (. bean2260 setOwnerAccount (clojure.core/str v2262)))
   (clojure.core/when-let
    [v2262 (:cluster-subnet-group-name m2261)]
    (. bean2260 setClusterSubnetGroupName (clojure.core/str v2262)))
   (clojure.core/when-let
    [v2262 (:allow-version-upgrade m2261)]
    (. bean2260 setAllowVersionUpgrade (clojure.core/boolean v2262)))
   (clojure.core/when-let
    [v2262 (:publicly-accessible m2261)]
    (. bean2260 setPubliclyAccessible (clojure.core/boolean v2262)))
   (clojure.core/when-let
    [v2262 (:port m2261)]
    (. bean2260 setPort (clojure.core/int v2262)))
   bean2260))
 (clojure.core/defn
  ^com.amazonaws.services.redshift.model.RevokeSnapshotAccessRequest revoke-snapshot-access-request
  [m2264]
  (clojure.core/let
   [bean2263
    (new
     com.amazonaws.services.redshift.model.RevokeSnapshotAccessRequest)]
   (clojure.core/when-let
    [v2265 (:snapshot-identifier m2264)]
    (. bean2263 setSnapshotIdentifier (clojure.core/str v2265)))
   (clojure.core/when-let
    [v2265 (:snapshot-cluster-identifier m2264)]
    (. bean2263 setSnapshotClusterIdentifier (clojure.core/str v2265)))
   (clojure.core/when-let
    [v2265 (:account-with-restore-access m2264)]
    (. bean2263 setAccountWithRestoreAccess (clojure.core/str v2265)))
   bean2263))
 (clojure.core/defn
  ^com.amazonaws.services.redshift.model.DeleteClusterSecurityGroupRequest delete-cluster-security-group-request
  [m2267]
  (clojure.core/let
   [bean2266
    (new
     com.amazonaws.services.redshift.model.DeleteClusterSecurityGroupRequest)]
   (clojure.core/when-let
    [v2268 (:cluster-security-group-name m2267)]
    (. bean2266 setClusterSecurityGroupName (clojure.core/str v2268)))
   bean2266))
 (clojure.core/defn
  ^com.amazonaws.services.redshift.model.DescribeClusterParametersRequest describe-cluster-parameters-request
  [m2270]
  (clojure.core/let
   [bean2269
    (new
     com.amazonaws.services.redshift.model.DescribeClusterParametersRequest)]
   (clojure.core/when-let
    [v2271 (:source m2270)]
    (. bean2269 setSource (clojure.core/str v2271)))
   (clojure.core/when-let
    [v2271 (:marker m2270)]
    (. bean2269 setMarker (clojure.core/str v2271)))
   (clojure.core/when-let
    [v2271 (:parameter-group-name m2270)]
    (. bean2269 setParameterGroupName (clojure.core/str v2271)))
   (clojure.core/when-let
    [v2271 (:max-records m2270)]
    (. bean2269 setMaxRecords (clojure.core/int v2271)))
   bean2269))
 (clojure.core/defn
  ^com.amazonaws.services.redshift.model.ResetClusterParameterGroupRequest reset-cluster-parameter-group-request
  [m2273]
  (clojure.core/let
   [bean2272
    (new
     com.amazonaws.services.redshift.model.ResetClusterParameterGroupRequest)]
   (clojure.core/when-let
    [v2274 (:parameters m2273)]
    (.
     bean2272
     setParameters
     (clojure.core/map
      (clojure.core/fn [arg2278] (parameter arg2278))
      v2274)))
   (clojure.core/when-let
    [v2274 (:parameter-group-name m2273)]
    (. bean2272 setParameterGroupName (clojure.core/str v2274)))
   (clojure.core/when-let
    [v2274 (:reset-all-parameters m2273)]
    (. bean2272 setResetAllParameters (clojure.core/boolean v2274)))
   bean2272))
 (clojure.core/defn
  ^com.amazonaws.services.redshift.model.CreateClusterParameterGroupRequest create-cluster-parameter-group-request
  [m2276]
  (clojure.core/let
   [bean2275
    (new
     com.amazonaws.services.redshift.model.CreateClusterParameterGroupRequest)]
   (clojure.core/when-let
    [v2277 (:description m2276)]
    (. bean2275 setDescription (clojure.core/str v2277)))
   (clojure.core/when-let
    [v2277 (:parameter-group-name m2276)]
    (. bean2275 setParameterGroupName (clojure.core/str v2277)))
   (clojure.core/when-let
    [v2277 (:parameter-group-family m2276)]
    (. bean2275 setParameterGroupFamily (clojure.core/str v2277)))
   bean2275))
 (clojure.core/defn
  ^com.amazonaws.services.redshift.model.DescribeReservedNodesRequest describe-reserved-nodes-request
  [m2280]
  (clojure.core/let
   [bean2279
    (new
     com.amazonaws.services.redshift.model.DescribeReservedNodesRequest)]
   (clojure.core/when-let
    [v2281 (:marker m2280)]
    (. bean2279 setMarker (clojure.core/str v2281)))
   (clojure.core/when-let
    [v2281 (:reserved-node-id m2280)]
    (. bean2279 setReservedNodeId (clojure.core/str v2281)))
   (clojure.core/when-let
    [v2281 (:max-records m2280)]
    (. bean2279 setMaxRecords (clojure.core/int v2281)))
   bean2279))
 (clojure.core/defn
  ^com.amazonaws.services.redshift.model.CopyClusterSnapshotRequest copy-cluster-snapshot-request
  [m2283]
  (clojure.core/let
   [bean2282
    (new
     com.amazonaws.services.redshift.model.CopyClusterSnapshotRequest)]
   (clojure.core/when-let
    [v2284 (:source-snapshot-identifier m2283)]
    (. bean2282 setSourceSnapshotIdentifier (clojure.core/str v2284)))
   (clojure.core/when-let
    [v2284 (:source-snapshot-cluster-identifier m2283)]
    (.
     bean2282
     setSourceSnapshotClusterIdentifier
     (clojure.core/str v2284)))
   (clojure.core/when-let
    [v2284 (:target-snapshot-identifier m2283)]
    (. bean2282 setTargetSnapshotIdentifier (clojure.core/str v2284)))
   bean2282))
 (clojure.core/defn
  ^com.amazonaws.services.redshift.model.ModifyClusterSubnetGroupRequest modify-cluster-subnet-group-request
  [m2286]
  (clojure.core/let
   [bean2285
    (new
     com.amazonaws.services.redshift.model.ModifyClusterSubnetGroupRequest)]
   (clojure.core/when-let
    [v2287 (:cluster-subnet-group-name m2286)]
    (. bean2285 setClusterSubnetGroupName (clojure.core/str v2287)))
   (clojure.core/when-let
    [v2287 (:description m2286)]
    (. bean2285 setDescription (clojure.core/str v2287)))
   (clojure.core/when-let
    [v2287 (:subnet-ids m2286)]
    (.
     bean2285
     setSubnetIds
     (clojure.core/map
      (clojure.core/fn [arg2291] (clojure.core/str arg2291))
      v2287)))
   bean2285))
 (clojure.core/defn
  ^com.amazonaws.services.redshift.model.DescribeEventsRequest describe-events-request
  [m2289]
  (clojure.core/let
   [bean2288
    (new com.amazonaws.services.redshift.model.DescribeEventsRequest)]
   (clojure.core/when-let
    [v2290 (:marker m2289)]
    (. bean2288 setMarker (clojure.core/str v2290)))
   (clojure.core/when-let
    [v2290 (:start-time m2289)]
    (.
     bean2288
     setStartTime
     (com.palletops.awaze.common/to-date v2290)))
   (clojure.core/when-let
    [v2290 (:duration m2289)]
    (. bean2288 setDuration (clojure.core/int v2290)))
   (clojure.core/when-let
    [v2290 (:max-records m2289)]
    (. bean2288 setMaxRecords (clojure.core/int v2290)))
   (clojure.core/when-let
    [v2290 (:source-identifier m2289)]
    (. bean2288 setSourceIdentifier (clojure.core/str v2290)))
   (clojure.core/when-let
    [v2290 (:source-type m2289)]
    (. bean2288 setSourceType (clojure.core/str v2290)))
   (clojure.core/when-let
    [v2290 (:source-type m2289)]
    (. bean2288 setSourceType (source-type v2290)))
   (clojure.core/when-let
    [v2290 (:end-time m2289)]
    (. bean2288 setEndTime (com.palletops.awaze.common/to-date v2290)))
   bean2288))
 (clojure.core/defn
  ^com.amazonaws.services.redshift.model.DeleteClusterParameterGroupRequest delete-cluster-parameter-group-request
  [m2293]
  (clojure.core/let
   [bean2292
    (new
     com.amazonaws.services.redshift.model.DeleteClusterParameterGroupRequest)]
   (clojure.core/when-let
    [v2294 (:parameter-group-name m2293)]
    (. bean2292 setParameterGroupName (clojure.core/str v2294)))
   bean2292))
 (clojure.core/defn
  ^com.amazonaws.services.redshift.model.AuthorizeClusterSecurityGroupIngressRequest authorize-cluster-security-group-ingress-request
  [m2296]
  (clojure.core/let
   [bean2295
    (new
     com.amazonaws.services.redshift.model.AuthorizeClusterSecurityGroupIngressRequest)]
   (clojure.core/when-let
    [v2297 (:cluster-security-group-name m2296)]
    (. bean2295 setClusterSecurityGroupName (clojure.core/str v2297)))
   (clojure.core/when-let
    [v2297 (:cidrip m2296)]
    (. bean2295 setCIDRIP (clojure.core/str v2297)))
   (clojure.core/when-let
    [v2297 (:ec2security-group-name m2296)]
    (. bean2295 setEC2SecurityGroupName (clojure.core/str v2297)))
   (clojure.core/when-let
    [v2297 (:ec2security-group-owner-id m2296)]
    (. bean2295 setEC2SecurityGroupOwnerId (clojure.core/str v2297)))
   bean2295))
 (clojure.core/defn
  ^com.amazonaws.services.redshift.model.ModifyClusterRequest modify-cluster-request
  [m2299]
  (clojure.core/let
   [bean2298
    (new com.amazonaws.services.redshift.model.ModifyClusterRequest)]
   (clojure.core/when-let
    [v2300 (:cluster-identifier m2299)]
    (. bean2298 setClusterIdentifier (clojure.core/str v2300)))
   (clojure.core/when-let
    [v2300 (:cluster-version m2299)]
    (. bean2298 setClusterVersion (clojure.core/str v2300)))
   (clojure.core/when-let
    [v2300 (:node-type m2299)]
    (. bean2298 setNodeType (clojure.core/str v2300)))
   (clojure.core/when-let
    [v2300 (:number-of-nodes m2299)]
    (. bean2298 setNumberOfNodes (clojure.core/int v2300)))
   (clojure.core/when-let
    [v2300 (:cluster-type m2299)]
    (. bean2298 setClusterType (clojure.core/str v2300)))
   (clojure.core/when-let
    [v2300 (:cluster-security-groups m2299)]
    (.
     bean2298
     setClusterSecurityGroups
     (clojure.core/map
      (clojure.core/fn [arg2304] (clojure.core/str arg2304))
      v2300)))
   (clojure.core/when-let
    [v2300 (:vpc-security-group-ids m2299)]
    (.
     bean2298
     setVpcSecurityGroupIds
     (clojure.core/map
      (clojure.core/fn [arg2305] (clojure.core/str arg2305))
      v2300)))
   (clojure.core/when-let
    [v2300 (:master-user-password m2299)]
    (. bean2298 setMasterUserPassword (clojure.core/str v2300)))
   (clojure.core/when-let
    [v2300 (:cluster-parameter-group-name m2299)]
    (. bean2298 setClusterParameterGroupName (clojure.core/str v2300)))
   (clojure.core/when-let
    [v2300 (:automated-snapshot-retention-period m2299)]
    (.
     bean2298
     setAutomatedSnapshotRetentionPeriod
     (clojure.core/int v2300)))
   (clojure.core/when-let
    [v2300 (:preferred-maintenance-window m2299)]
    (.
     bean2298
     setPreferredMaintenanceWindow
     (clojure.core/str v2300)))
   (clojure.core/when-let
    [v2300 (:allow-version-upgrade m2299)]
    (. bean2298 setAllowVersionUpgrade (clojure.core/boolean v2300)))
   bean2298))
 (clojure.core/defn
  ^com.amazonaws.services.redshift.model.DeleteClusterSubnetGroupRequest delete-cluster-subnet-group-request
  [m2302]
  (clojure.core/let
   [bean2301
    (new
     com.amazonaws.services.redshift.model.DeleteClusterSubnetGroupRequest)]
   (clojure.core/when-let
    [v2303 (:cluster-subnet-group-name m2302)]
    (. bean2301 setClusterSubnetGroupName (clojure.core/str v2303)))
   bean2301))
 (clojure.core/defn
  ^com.amazonaws.services.redshift.model.CreateClusterSubnetGroupRequest create-cluster-subnet-group-request
  [m2307]
  (clojure.core/let
   [bean2306
    (new
     com.amazonaws.services.redshift.model.CreateClusterSubnetGroupRequest)]
   (clojure.core/when-let
    [v2308 (:cluster-subnet-group-name m2307)]
    (. bean2306 setClusterSubnetGroupName (clojure.core/str v2308)))
   (clojure.core/when-let
    [v2308 (:description m2307)]
    (. bean2306 setDescription (clojure.core/str v2308)))
   (clojure.core/when-let
    [v2308 (:subnet-ids m2307)]
    (.
     bean2306
     setSubnetIds
     (clojure.core/map
      (clojure.core/fn [arg2312] (clojure.core/str arg2312))
      v2308)))
   bean2306))
 (clojure.core/defn
  ^com.amazonaws.services.redshift.model.PurchaseReservedNodeOfferingRequest purchase-reserved-node-offering-request
  [m2310]
  (clojure.core/let
   [bean2309
    (new
     com.amazonaws.services.redshift.model.PurchaseReservedNodeOfferingRequest)]
   (clojure.core/when-let
    [v2311 (:reserved-node-offering-id m2310)]
    (. bean2309 setReservedNodeOfferingId (clojure.core/str v2311)))
   (clojure.core/when-let
    [v2311 (:node-count m2310)]
    (. bean2309 setNodeCount (clojure.core/int v2311)))
   bean2309))
 (clojure.core/defn
  ^com.amazonaws.services.redshift.model.DescribeReservedNodeOfferingsRequest describe-reserved-node-offerings-request
  [m2314]
  (clojure.core/let
   [bean2313
    (new
     com.amazonaws.services.redshift.model.DescribeReservedNodeOfferingsRequest)]
   (clojure.core/when-let
    [v2315 (:marker m2314)]
    (. bean2313 setMarker (clojure.core/str v2315)))
   (clojure.core/when-let
    [v2315 (:reserved-node-offering-id m2314)]
    (. bean2313 setReservedNodeOfferingId (clojure.core/str v2315)))
   (clojure.core/when-let
    [v2315 (:max-records m2314)]
    (. bean2313 setMaxRecords (clojure.core/int v2315)))
   bean2313))
 (clojure.core/defn
  ^com.amazonaws.services.redshift.model.DeleteClusterRequest delete-cluster-request
  [m2317]
  (clojure.core/let
   [bean2316
    (new com.amazonaws.services.redshift.model.DeleteClusterRequest)]
   (clojure.core/when-let
    [v2318 (:cluster-identifier m2317)]
    (. bean2316 setClusterIdentifier (clojure.core/str v2318)))
   (clojure.core/when-let
    [v2318 (:skip-final-cluster-snapshot m2317)]
    (.
     bean2316
     setSkipFinalClusterSnapshot
     (clojure.core/boolean v2318)))
   (clojure.core/when-let
    [v2318 (:final-cluster-snapshot-identifier m2317)]
    (.
     bean2316
     setFinalClusterSnapshotIdentifier
     (clojure.core/str v2318)))
   bean2316))
 (clojure.core/defn
  ^com.amazonaws.services.redshift.model.CreateClusterSecurityGroupRequest create-cluster-security-group-request
  [m2320]
  (clojure.core/let
   [bean2319
    (new
     com.amazonaws.services.redshift.model.CreateClusterSecurityGroupRequest)]
   (clojure.core/when-let
    [v2321 (:description m2320)]
    (. bean2319 setDescription (clojure.core/str v2321)))
   (clojure.core/when-let
    [v2321 (:cluster-security-group-name m2320)]
    (. bean2319 setClusterSecurityGroupName (clojure.core/str v2321)))
   bean2319))
 (clojure.core/defn
  ^com.amazonaws.services.redshift.model.DescribeDefaultClusterParametersRequest describe-default-cluster-parameters-request
  [m2323]
  (clojure.core/let
   [bean2322
    (new
     com.amazonaws.services.redshift.model.DescribeDefaultClusterParametersRequest)]
   (clojure.core/when-let
    [v2324 (:marker m2323)]
    (. bean2322 setMarker (clojure.core/str v2324)))
   (clojure.core/when-let
    [v2324 (:max-records m2323)]
    (. bean2322 setMaxRecords (clojure.core/int v2324)))
   (clojure.core/when-let
    [v2324 (:parameter-group-family m2323)]
    (. bean2322 setParameterGroupFamily (clojure.core/str v2324)))
   bean2322))
 (clojure.core/defn
  ^com.amazonaws.services.redshift.model.CreateClusterSnapshotRequest create-cluster-snapshot-request
  [m2326]
  (clojure.core/let
   [bean2325
    (new
     com.amazonaws.services.redshift.model.CreateClusterSnapshotRequest)]
   (clojure.core/when-let
    [v2327 (:snapshot-identifier m2326)]
    (. bean2325 setSnapshotIdentifier (clojure.core/str v2327)))
   (clojure.core/when-let
    [v2327 (:cluster-identifier m2326)]
    (. bean2325 setClusterIdentifier (clojure.core/str v2327)))
   bean2325))
 (clojure.core/defn
  ^com.amazonaws.services.redshift.model.DescribeClusterVersionsRequest describe-cluster-versions-request
  [m2329]
  (clojure.core/let
   [bean2328
    (new
     com.amazonaws.services.redshift.model.DescribeClusterVersionsRequest)]
   (clojure.core/when-let
    [v2330 (:marker m2329)]
    (. bean2328 setMarker (clojure.core/str v2330)))
   (clojure.core/when-let
    [v2330 (:cluster-version m2329)]
    (. bean2328 setClusterVersion (clojure.core/str v2330)))
   (clojure.core/when-let
    [v2330 (:max-records m2329)]
    (. bean2328 setMaxRecords (clojure.core/int v2330)))
   (clojure.core/when-let
    [v2330 (:cluster-parameter-group-family m2329)]
    (.
     bean2328
     setClusterParameterGroupFamily
     (clojure.core/str v2330)))
   bean2328))
 (clojure.core/defn
  ^com.amazonaws.services.redshift.model.RebootClusterRequest reboot-cluster-request
  [m2332]
  (clojure.core/let
   [bean2331
    (new com.amazonaws.services.redshift.model.RebootClusterRequest)]
   (clojure.core/when-let
    [v2333 (:cluster-identifier m2332)]
    (. bean2331 setClusterIdentifier (clojure.core/str v2333)))
   bean2331))
 (clojure.core/defn
  ^com.amazonaws.services.redshift.model.DescribeResizeRequest describe-resize-request
  [m2335]
  (clojure.core/let
   [bean2334
    (new com.amazonaws.services.redshift.model.DescribeResizeRequest)]
   (clojure.core/when-let
    [v2336 (:cluster-identifier m2335)]
    (. bean2334 setClusterIdentifier (clojure.core/str v2336)))
   bean2334))
 (clojure.core/defn
  ^com.amazonaws.services.redshift.model.RevokeClusterSecurityGroupIngressRequest revoke-cluster-security-group-ingress-request
  [m2338]
  (clojure.core/let
   [bean2337
    (new
     com.amazonaws.services.redshift.model.RevokeClusterSecurityGroupIngressRequest)]
   (clojure.core/when-let
    [v2339 (:cluster-security-group-name m2338)]
    (. bean2337 setClusterSecurityGroupName (clojure.core/str v2339)))
   (clojure.core/when-let
    [v2339 (:cidrip m2338)]
    (. bean2337 setCIDRIP (clojure.core/str v2339)))
   (clojure.core/when-let
    [v2339 (:ec2security-group-name m2338)]
    (. bean2337 setEC2SecurityGroupName (clojure.core/str v2339)))
   (clojure.core/when-let
    [v2339 (:ec2security-group-owner-id m2338)]
    (. bean2337 setEC2SecurityGroupOwnerId (clojure.core/str v2339)))
   bean2337))
 (clojure.core/defn
  ^com.amazonaws.services.redshift.model.ModifyClusterParameterGroupRequest modify-cluster-parameter-group-request
  [m2341]
  (clojure.core/let
   [bean2340
    (new
     com.amazonaws.services.redshift.model.ModifyClusterParameterGroupRequest)]
   (clojure.core/when-let
    [v2342 (:parameters m2341)]
    (.
     bean2340
     setParameters
     (clojure.core/map
      (clojure.core/fn [arg2346] (parameter arg2346))
      v2342)))
   (clojure.core/when-let
    [v2342 (:parameter-group-name m2341)]
    (. bean2340 setParameterGroupName (clojure.core/str v2342)))
   bean2340))
 (clojure.core/defn
  ^com.amazonaws.services.redshift.model.DescribeClusterSnapshotsRequest describe-cluster-snapshots-request
  [m2344]
  (clojure.core/let
   [bean2343
    (new
     com.amazonaws.services.redshift.model.DescribeClusterSnapshotsRequest)]
   (clojure.core/when-let
    [v2345 (:marker m2344)]
    (. bean2343 setMarker (clojure.core/str v2345)))
   (clojure.core/when-let
    [v2345 (:snapshot-identifier m2344)]
    (. bean2343 setSnapshotIdentifier (clojure.core/str v2345)))
   (clojure.core/when-let
    [v2345 (:cluster-identifier m2344)]
    (. bean2343 setClusterIdentifier (clojure.core/str v2345)))
   (clojure.core/when-let
    [v2345 (:snapshot-type m2344)]
    (. bean2343 setSnapshotType (clojure.core/str v2345)))
   (clojure.core/when-let
    [v2345 (:owner-account m2344)]
    (. bean2343 setOwnerAccount (clojure.core/str v2345)))
   (clojure.core/when-let
    [v2345 (:start-time m2344)]
    (.
     bean2343
     setStartTime
     (com.palletops.awaze.common/to-date v2345)))
   (clojure.core/when-let
    [v2345 (:max-records m2344)]
    (. bean2343 setMaxRecords (clojure.core/int v2345)))
   (clojure.core/when-let
    [v2345 (:end-time m2344)]
    (. bean2343 setEndTime (com.palletops.awaze.common/to-date v2345)))
   bean2343))
 (clojure.core/defn
  ^com.amazonaws.services.redshift.model.DeleteClusterSnapshotRequest delete-cluster-snapshot-request
  [m2348]
  (clojure.core/let
   [bean2347
    (new
     com.amazonaws.services.redshift.model.DeleteClusterSnapshotRequest)]
   (clojure.core/when-let
    [v2349 (:snapshot-identifier m2348)]
    (. bean2347 setSnapshotIdentifier (clojure.core/str v2349)))
   (clojure.core/when-let
    [v2349 (:snapshot-cluster-identifier m2348)]
    (. bean2347 setSnapshotClusterIdentifier (clojure.core/str v2349)))
   bean2347))
 (clojure.core/defn
  ^com.amazonaws.services.redshift.model.DescribeOrderableClusterOptionsRequest describe-orderable-cluster-options-request
  [m2351]
  (clojure.core/let
   [bean2350
    (new
     com.amazonaws.services.redshift.model.DescribeOrderableClusterOptionsRequest)]
   (clojure.core/when-let
    [v2352 (:marker m2351)]
    (. bean2350 setMarker (clojure.core/str v2352)))
   (clojure.core/when-let
    [v2352 (:cluster-version m2351)]
    (. bean2350 setClusterVersion (clojure.core/str v2352)))
   (clojure.core/when-let
    [v2352 (:node-type m2351)]
    (. bean2350 setNodeType (clojure.core/str v2352)))
   (clojure.core/when-let
    [v2352 (:max-records m2351)]
    (. bean2350 setMaxRecords (clojure.core/int v2352)))
   bean2350))
 (clojure.core/defmulti
  redshift
  (clojure.core/fn redshift [m__1641__auto__] (:fn m__1641__auto__)))
 (do
  (clojure.core/defmethod
   redshift
   :describe-cluster-security-groups
   [m2353]
   (clojure.core/let
    [credentials2354 (:credentials m2353) args2355 (:args m2353)]
    (clojure.core/let
     [^com.amazonaws.services.redshift.AmazonRedshiftClient client2356
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2354)]
     (clojure.core/case
      (clojure.core/count args2355)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.redshift.AmazonRedshiftClient client2356
        describeClusterSecurityGroups))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.redshift.AmazonRedshiftClient client2356
        describeClusterSecurityGroups
        (describe-cluster-security-groups-request
         (clojure.core/nth args2355 0))))))))
  (clojure.core/defn
   describe-cluster-security-groups-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [request-metric-collector
                         max-records
                         marker
                         cluster-security-group-name]}]]),
    :doc "Generate map for describeClusterSecurityGroups, describeClusterSecurityGroups"}
   ([credentials__1609__auto__]
    {:args [],
     :client :redshift,
     :fn :describe-cluster-security-groups,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :describe-cluster-security-groups,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-cluster-security-groups
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [request-metric-collector
                         max-records
                         marker
                         cluster-security-group-name]}]]),
    :doc "Call describeClusterSecurityGroups, describeClusterSecurityGroups"}
   [credentials2358 & args2359]
   (clojure.core/let
    [^com.amazonaws.services.redshift.AmazonRedshiftClient client2360
     (com.palletops.awaze.common/aws-client :redshift credentials2358)]
    (clojure.core/case
     (clojure.core/count args2359)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.redshift.AmazonRedshiftClient client2360
       describeClusterSecurityGroups))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.redshift.AmazonRedshiftClient client2360
       describeClusterSecurityGroups
       (describe-cluster-security-groups-request
        (clojure.core/nth args2359 0))))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-cluster-parameter-groups
   [m2361]
   (clojure.core/let
    [credentials2362 (:credentials m2361) args2363 (:args m2361)]
    (clojure.core/let
     [^com.amazonaws.services.redshift.AmazonRedshiftClient client2364
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2362)]
     (clojure.core/case
      (clojure.core/count args2363)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.redshift.AmazonRedshiftClient client2364
        describeClusterParameterGroups
        (describe-cluster-parameter-groups-request
         (clojure.core/nth args2363 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.redshift.AmazonRedshiftClient client2364
        describeClusterParameterGroups))))))
  (clojure.core/defn
   describe-cluster-parameter-groups-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         parameter-group-name
                         max-records
                         marker]}]
                [credentials]]),
    :doc "Generate map for describeClusterParameterGroups, describeClusterParameterGroups"}
   ([credentials__1609__auto__]
    {:args [],
     :client :redshift,
     :fn :describe-cluster-parameter-groups,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :describe-cluster-parameter-groups,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-cluster-parameter-groups
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         parameter-group-name
                         max-records
                         marker]}]
                [credentials]]),
    :doc "Call describeClusterParameterGroups, describeClusterParameterGroups"}
   [credentials2366 & args2367]
   (clojure.core/let
    [^com.amazonaws.services.redshift.AmazonRedshiftClient client2368
     (com.palletops.awaze.common/aws-client :redshift credentials2366)]
    (clojure.core/case
     (clojure.core/count args2367)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.redshift.AmazonRedshiftClient client2368
       describeClusterParameterGroups
       (describe-cluster-parameter-groups-request
        (clojure.core/nth args2367 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.redshift.AmazonRedshiftClient client2368
       describeClusterParameterGroups))))))
 (do
  (clojure.core/defmethod
   redshift
   :create-cluster
   [m2369]
   (clojure.core/let
    [credentials2370 (:credentials m2369) args2371 (:args m2369)]
    (clojure.core/let
     [^com.amazonaws.services.redshift.AmazonRedshiftClient client2372
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2370)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.redshift.AmazonRedshiftClient client2372
       createCluster
       (create-cluster-request (clojure.core/nth args2371 0)))))))
  (clojure.core/defn
   create-cluster-map
   {:arglists (quote
               [[credentials
                 {:keys [node-type
                         cluster-type
                         publicly-accessible
                         request-metric-collector
                         cluster-security-groups
                         automated-snapshot-retention-period
                         cluster-identifier
                         encrypted
                         availability-zone
                         preferred-maintenance-window
                         master-username
                         dbname
                         cluster-parameter-group-name
                         master-user-password
                         number-of-nodes
                         vpc-security-group-ids
                         port
                         cluster-version
                         cluster-subnet-group-name
                         allow-version-upgrade]}]]),
    :doc "Generate map for createCluster"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :create-cluster,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   create-cluster
   {:arglists (quote
               [[credentials
                 {:keys [node-type
                         cluster-type
                         publicly-accessible
                         request-metric-collector
                         cluster-security-groups
                         automated-snapshot-retention-period
                         cluster-identifier
                         encrypted
                         availability-zone
                         preferred-maintenance-window
                         master-username
                         dbname
                         cluster-parameter-group-name
                         master-user-password
                         number-of-nodes
                         vpc-security-group-ids
                         port
                         cluster-version
                         cluster-subnet-group-name
                         allow-version-upgrade]}]]),
    :doc "Call createCluster"}
   [credentials2374 & args2375]
   (clojure.core/let
    [^com.amazonaws.services.redshift.AmazonRedshiftClient client2376
     (com.palletops.awaze.common/aws-client :redshift credentials2374)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.redshift.AmazonRedshiftClient client2376
      createCluster
      (create-cluster-request (clojure.core/nth args2375 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :authorize-snapshot-access
   [m2377]
   (clojure.core/let
    [credentials2378 (:credentials m2377) args2379 (:args m2377)]
    (clojure.core/let
     [^com.amazonaws.services.redshift.AmazonRedshiftClient client2380
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2378)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.redshift.AmazonRedshiftClient client2380
       authorizeSnapshotAccess
       (authorize-snapshot-access-request
        (clojure.core/nth args2379 0)))))))
  (clojure.core/defn
   authorize-snapshot-access-map
   {:arglists (quote
               [[credentials
                 {:keys [snapshot-identifier
                         snapshot-cluster-identifier
                         request-metric-collector
                         account-with-restore-access]}]]),
    :doc "Generate map for authorizeSnapshotAccess"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :authorize-snapshot-access,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   authorize-snapshot-access
   {:arglists (quote
               [[credentials
                 {:keys [snapshot-identifier
                         snapshot-cluster-identifier
                         request-metric-collector
                         account-with-restore-access]}]]),
    :doc "Call authorizeSnapshotAccess"}
   [credentials2382 & args2383]
   (clojure.core/let
    [^com.amazonaws.services.redshift.AmazonRedshiftClient client2384
     (com.palletops.awaze.common/aws-client :redshift credentials2382)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.redshift.AmazonRedshiftClient client2384
      authorizeSnapshotAccess
      (authorize-snapshot-access-request
       (clojure.core/nth args2383 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-cluster-subnet-groups
   [m2385]
   (clojure.core/let
    [credentials2386 (:credentials m2385) args2387 (:args m2385)]
    (clojure.core/let
     [^com.amazonaws.services.redshift.AmazonRedshiftClient client2388
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2386)]
     (clojure.core/case
      (clojure.core/count args2387)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.redshift.AmazonRedshiftClient client2388
        describeClusterSubnetGroups
        (describe-cluster-subnet-groups-request
         (clojure.core/nth args2387 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.redshift.AmazonRedshiftClient client2388
        describeClusterSubnetGroups))))))
  (clojure.core/defn
   describe-cluster-subnet-groups-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         max-records
                         marker
                         cluster-subnet-group-name]}]
                [credentials]]),
    :doc "Generate map for describeClusterSubnetGroups, describeClusterSubnetGroups"}
   ([credentials__1609__auto__]
    {:args [],
     :client :redshift,
     :fn :describe-cluster-subnet-groups,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :describe-cluster-subnet-groups,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-cluster-subnet-groups
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         max-records
                         marker
                         cluster-subnet-group-name]}]
                [credentials]]),
    :doc "Call describeClusterSubnetGroups, describeClusterSubnetGroups"}
   [credentials2390 & args2391]
   (clojure.core/let
    [^com.amazonaws.services.redshift.AmazonRedshiftClient client2392
     (com.palletops.awaze.common/aws-client :redshift credentials2390)]
    (clojure.core/case
     (clojure.core/count args2391)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.redshift.AmazonRedshiftClient client2392
       describeClusterSubnetGroups
       (describe-cluster-subnet-groups-request
        (clojure.core/nth args2391 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.redshift.AmazonRedshiftClient client2392
       describeClusterSubnetGroups))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-clusters
   [m2393]
   (clojure.core/let
    [credentials2394 (:credentials m2393) args2395 (:args m2393)]
    (clojure.core/let
     [^com.amazonaws.services.redshift.AmazonRedshiftClient client2396
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2394)]
     (clojure.core/case
      (clojure.core/count args2395)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.redshift.AmazonRedshiftClient client2396
        describeClusters
        (describe-clusters-request (clojure.core/nth args2395 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.redshift.AmazonRedshiftClient client2396
        describeClusters))))))
  (clojure.core/defn
   describe-clusters-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         max-records
                         marker
                         cluster-identifier]}]
                [credentials]]),
    :doc "Generate map for describeClusters, describeClusters"}
   ([credentials__1609__auto__]
    {:args [],
     :client :redshift,
     :fn :describe-clusters,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :describe-clusters,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-clusters
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         max-records
                         marker
                         cluster-identifier]}]
                [credentials]]),
    :doc "Call describeClusters, describeClusters"}
   [credentials2398 & args2399]
   (clojure.core/let
    [^com.amazonaws.services.redshift.AmazonRedshiftClient client2400
     (com.palletops.awaze.common/aws-client :redshift credentials2398)]
    (clojure.core/case
     (clojure.core/count args2399)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.redshift.AmazonRedshiftClient client2400
       describeClusters
       (describe-clusters-request (clojure.core/nth args2399 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.redshift.AmazonRedshiftClient client2400
       describeClusters))))))
 (do
  (clojure.core/defmethod
   redshift
   :restore-from-cluster-snapshot
   [m2401]
   (clojure.core/let
    [credentials2402 (:credentials m2401) args2403 (:args m2401)]
    (clojure.core/let
     [^com.amazonaws.services.redshift.AmazonRedshiftClient client2404
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2402)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.redshift.AmazonRedshiftClient client2404
       restoreFromClusterSnapshot
       (restore-from-cluster-snapshot-request
        (clojure.core/nth args2403 0)))))))
  (clojure.core/defn
   restore-from-cluster-snapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [publicly-accessible
                         request-metric-collector
                         cluster-identifier
                         owner-account
                         availability-zone
                         port
                         snapshot-identifier
                         snapshot-cluster-identifier
                         cluster-subnet-group-name
                         allow-version-upgrade]}]]),
    :doc "Generate map for restoreFromClusterSnapshot"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :restore-from-cluster-snapshot,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   restore-from-cluster-snapshot
   {:arglists (quote
               [[credentials
                 {:keys [publicly-accessible
                         request-metric-collector
                         cluster-identifier
                         owner-account
                         availability-zone
                         port
                         snapshot-identifier
                         snapshot-cluster-identifier
                         cluster-subnet-group-name
                         allow-version-upgrade]}]]),
    :doc "Call restoreFromClusterSnapshot"}
   [credentials2406 & args2407]
   (clojure.core/let
    [^com.amazonaws.services.redshift.AmazonRedshiftClient client2408
     (com.palletops.awaze.common/aws-client :redshift credentials2406)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.redshift.AmazonRedshiftClient client2408
      restoreFromClusterSnapshot
      (restore-from-cluster-snapshot-request
       (clojure.core/nth args2407 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :revoke-snapshot-access
   [m2409]
   (clojure.core/let
    [credentials2410 (:credentials m2409) args2411 (:args m2409)]
    (clojure.core/let
     [^com.amazonaws.services.redshift.AmazonRedshiftClient client2412
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2410)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.redshift.AmazonRedshiftClient client2412
       revokeSnapshotAccess
       (revoke-snapshot-access-request (clojure.core/nth args2411 0)))))))
  (clojure.core/defn
   revoke-snapshot-access-map
   {:arglists (quote
               [[credentials
                 {:keys [snapshot-identifier
                         snapshot-cluster-identifier
                         request-metric-collector
                         account-with-restore-access]}]]),
    :doc "Generate map for revokeSnapshotAccess"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :revoke-snapshot-access,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   revoke-snapshot-access
   {:arglists (quote
               [[credentials
                 {:keys [snapshot-identifier
                         snapshot-cluster-identifier
                         request-metric-collector
                         account-with-restore-access]}]]),
    :doc "Call revokeSnapshotAccess"}
   [credentials2414 & args2415]
   (clojure.core/let
    [^com.amazonaws.services.redshift.AmazonRedshiftClient client2416
     (com.palletops.awaze.common/aws-client :redshift credentials2414)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.redshift.AmazonRedshiftClient client2416
      revokeSnapshotAccess
      (revoke-snapshot-access-request (clojure.core/nth args2415 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :delete-cluster-security-group
   [m2417]
   (clojure.core/let
    [credentials2418 (:credentials m2417) args2419 (:args m2417)]
    (clojure.core/let
     [^com.amazonaws.services.redshift.AmazonRedshiftClient client2420
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2418)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.redshift.AmazonRedshiftClient client2420
       deleteClusterSecurityGroup
       (delete-cluster-security-group-request
        (clojure.core/nth args2419 0)))))))
  (clojure.core/defn
   delete-cluster-security-group-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         cluster-security-group-name]}]]),
    :doc "Generate map for deleteClusterSecurityGroup"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :delete-cluster-security-group,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   delete-cluster-security-group
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         cluster-security-group-name]}]]),
    :doc "Call deleteClusterSecurityGroup"}
   [credentials2422 & args2423]
   (clojure.core/let
    [^com.amazonaws.services.redshift.AmazonRedshiftClient client2424
     (com.palletops.awaze.common/aws-client :redshift credentials2422)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.redshift.AmazonRedshiftClient client2424
      deleteClusterSecurityGroup
      (delete-cluster-security-group-request
       (clojure.core/nth args2423 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-cluster-parameters
   [m2425]
   (clojure.core/let
    [credentials2426 (:credentials m2425) args2427 (:args m2425)]
    (clojure.core/let
     [^com.amazonaws.services.redshift.AmazonRedshiftClient client2428
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2426)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.redshift.AmazonRedshiftClient client2428
       describeClusterParameters
       (describe-cluster-parameters-request
        (clojure.core/nth args2427 0)))))))
  (clojure.core/defn
   describe-cluster-parameters-map
   {:arglists (quote
               [[credentials
                 {:keys [source
                         request-metric-collector
                         parameter-group-name
                         max-records
                         marker]}]]),
    :doc "Generate map for describeClusterParameters"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :describe-cluster-parameters,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-cluster-parameters
   {:arglists (quote
               [[credentials
                 {:keys [source
                         request-metric-collector
                         parameter-group-name
                         max-records
                         marker]}]]),
    :doc "Call describeClusterParameters"}
   [credentials2430 & args2431]
   (clojure.core/let
    [^com.amazonaws.services.redshift.AmazonRedshiftClient client2432
     (com.palletops.awaze.common/aws-client :redshift credentials2430)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.redshift.AmazonRedshiftClient client2432
      describeClusterParameters
      (describe-cluster-parameters-request
       (clojure.core/nth args2431 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :reset-cluster-parameter-group
   [m2433]
   (clojure.core/let
    [credentials2434 (:credentials m2433) args2435 (:args m2433)]
    (clojure.core/let
     [^com.amazonaws.services.redshift.AmazonRedshiftClient client2436
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2434)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.redshift.AmazonRedshiftClient client2436
       resetClusterParameterGroup
       (reset-cluster-parameter-group-request
        (clojure.core/nth args2435 0)))))))
  (clojure.core/defn
   reset-cluster-parameter-group-map
   {:arglists (quote
               [[credentials
                 {:keys [reset-all-parameters
                         request-metric-collector
                         parameters
                         parameter-group-name]}]]),
    :doc "Generate map for resetClusterParameterGroup"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :reset-cluster-parameter-group,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   reset-cluster-parameter-group
   {:arglists (quote
               [[credentials
                 {:keys [reset-all-parameters
                         request-metric-collector
                         parameters
                         parameter-group-name]}]]),
    :doc "Call resetClusterParameterGroup"}
   [credentials2438 & args2439]
   (clojure.core/let
    [^com.amazonaws.services.redshift.AmazonRedshiftClient client2440
     (com.palletops.awaze.common/aws-client :redshift credentials2438)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.redshift.AmazonRedshiftClient client2440
      resetClusterParameterGroup
      (reset-cluster-parameter-group-request
       (clojure.core/nth args2439 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :create-cluster-parameter-group
   [m2441]
   (clojure.core/let
    [credentials2442 (:credentials m2441) args2443 (:args m2441)]
    (clojure.core/let
     [^com.amazonaws.services.redshift.AmazonRedshiftClient client2444
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2442)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.redshift.AmazonRedshiftClient client2444
       createClusterParameterGroup
       (create-cluster-parameter-group-request
        (clojure.core/nth args2443 0)))))))
  (clojure.core/defn
   create-cluster-parameter-group-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         parameter-group-name
                         parameter-group-family
                         description]}]]),
    :doc "Generate map for createClusterParameterGroup"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :create-cluster-parameter-group,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   create-cluster-parameter-group
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         parameter-group-name
                         parameter-group-family
                         description]}]]),
    :doc "Call createClusterParameterGroup"}
   [credentials2446 & args2447]
   (clojure.core/let
    [^com.amazonaws.services.redshift.AmazonRedshiftClient client2448
     (com.palletops.awaze.common/aws-client :redshift credentials2446)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.redshift.AmazonRedshiftClient client2448
      createClusterParameterGroup
      (create-cluster-parameter-group-request
       (clojure.core/nth args2447 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-reserved-nodes
   [m2449]
   (clojure.core/let
    [credentials2450 (:credentials m2449) args2451 (:args m2449)]
    (clojure.core/let
     [^com.amazonaws.services.redshift.AmazonRedshiftClient client2452
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2450)]
     (clojure.core/case
      (clojure.core/count args2451)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.redshift.AmazonRedshiftClient client2452
        describeReservedNodes
        (describe-reserved-nodes-request
         (clojure.core/nth args2451 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.redshift.AmazonRedshiftClient client2452
        describeReservedNodes))))))
  (clojure.core/defn
   describe-reserved-nodes-map
   {:arglists (quote
               [[credentials
                 {:keys [reserved-node-id
                         request-metric-collector
                         max-records
                         marker]}]
                [credentials]]),
    :doc "Generate map for describeReservedNodes, describeReservedNodes"}
   ([credentials__1609__auto__]
    {:args [],
     :client :redshift,
     :fn :describe-reserved-nodes,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :describe-reserved-nodes,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-reserved-nodes
   {:arglists (quote
               [[credentials
                 {:keys [reserved-node-id
                         request-metric-collector
                         max-records
                         marker]}]
                [credentials]]),
    :doc "Call describeReservedNodes, describeReservedNodes"}
   [credentials2454 & args2455]
   (clojure.core/let
    [^com.amazonaws.services.redshift.AmazonRedshiftClient client2456
     (com.palletops.awaze.common/aws-client :redshift credentials2454)]
    (clojure.core/case
     (clojure.core/count args2455)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.redshift.AmazonRedshiftClient client2456
       describeReservedNodes
       (describe-reserved-nodes-request (clojure.core/nth args2455 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.redshift.AmazonRedshiftClient client2456
       describeReservedNodes))))))
 (do
  (clojure.core/defmethod
   redshift
   :copy-cluster-snapshot
   [m2457]
   (clojure.core/let
    [credentials2458 (:credentials m2457) args2459 (:args m2457)]
    (clojure.core/let
     [^com.amazonaws.services.redshift.AmazonRedshiftClient client2460
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2458)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.redshift.AmazonRedshiftClient client2460
       copyClusterSnapshot
       (copy-cluster-snapshot-request (clojure.core/nth args2459 0)))))))
  (clojure.core/defn
   copy-cluster-snapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [target-snapshot-identifier
                         source-snapshot-identifier
                         source-snapshot-cluster-identifier
                         request-metric-collector]}]]),
    :doc "Generate map for copyClusterSnapshot"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :copy-cluster-snapshot,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   copy-cluster-snapshot
   {:arglists (quote
               [[credentials
                 {:keys [target-snapshot-identifier
                         source-snapshot-identifier
                         source-snapshot-cluster-identifier
                         request-metric-collector]}]]),
    :doc "Call copyClusterSnapshot"}
   [credentials2462 & args2463]
   (clojure.core/let
    [^com.amazonaws.services.redshift.AmazonRedshiftClient client2464
     (com.palletops.awaze.common/aws-client :redshift credentials2462)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.redshift.AmazonRedshiftClient client2464
      copyClusterSnapshot
      (copy-cluster-snapshot-request (clojure.core/nth args2463 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :modify-cluster-subnet-group
   [m2465]
   (clojure.core/let
    [credentials2466 (:credentials m2465) args2467 (:args m2465)]
    (clojure.core/let
     [^com.amazonaws.services.redshift.AmazonRedshiftClient client2468
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2466)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.redshift.AmazonRedshiftClient client2468
       modifyClusterSubnetGroup
       (modify-cluster-subnet-group-request
        (clojure.core/nth args2467 0)))))))
  (clojure.core/defn
   modify-cluster-subnet-group-map
   {:arglists (quote
               [[credentials
                 {:keys [subnet-ids
                         request-metric-collector
                         description
                         cluster-subnet-group-name]}]]),
    :doc "Generate map for modifyClusterSubnetGroup"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :modify-cluster-subnet-group,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   modify-cluster-subnet-group
   {:arglists (quote
               [[credentials
                 {:keys [subnet-ids
                         request-metric-collector
                         description
                         cluster-subnet-group-name]}]]),
    :doc "Call modifyClusterSubnetGroup"}
   [credentials2470 & args2471]
   (clojure.core/let
    [^com.amazonaws.services.redshift.AmazonRedshiftClient client2472
     (com.palletops.awaze.common/aws-client :redshift credentials2470)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.redshift.AmazonRedshiftClient client2472
      modifyClusterSubnetGroup
      (modify-cluster-subnet-group-request
       (clojure.core/nth args2471 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-events
   [m2473]
   (clojure.core/let
    [credentials2474 (:credentials m2473) args2475 (:args m2473)]
    (clojure.core/let
     [^com.amazonaws.services.redshift.AmazonRedshiftClient client2476
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2474)]
     (clojure.core/case
      (clojure.core/count args2475)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.redshift.AmazonRedshiftClient client2476
        describeEvents
        (describe-events-request (clojure.core/nth args2475 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.redshift.AmazonRedshiftClient client2476
        describeEvents))))))
  (clojure.core/defn
   describe-events-map
   {:arglists (quote
               [[credentials
                 {:keys [end-time
                         source-type
                         duration
                         request-metric-collector
                         max-records
                         start-time
                         marker
                         source-identifier]}]
                [credentials]]),
    :doc "Generate map for describeEvents, describeEvents"}
   ([credentials__1609__auto__]
    {:args [],
     :client :redshift,
     :fn :describe-events,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :describe-events,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-events
   {:arglists (quote
               [[credentials
                 {:keys [end-time
                         source-type
                         duration
                         request-metric-collector
                         max-records
                         start-time
                         marker
                         source-identifier]}]
                [credentials]]),
    :doc "Call describeEvents, describeEvents"}
   [credentials2478 & args2479]
   (clojure.core/let
    [^com.amazonaws.services.redshift.AmazonRedshiftClient client2480
     (com.palletops.awaze.common/aws-client :redshift credentials2478)]
    (clojure.core/case
     (clojure.core/count args2479)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.redshift.AmazonRedshiftClient client2480
       describeEvents
       (describe-events-request (clojure.core/nth args2479 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.redshift.AmazonRedshiftClient client2480
       describeEvents))))))
 (do
  (clojure.core/defmethod
   redshift
   :delete-cluster-parameter-group
   [m2481]
   (clojure.core/let
    [credentials2482 (:credentials m2481) args2483 (:args m2481)]
    (clojure.core/let
     [^com.amazonaws.services.redshift.AmazonRedshiftClient client2484
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2482)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.redshift.AmazonRedshiftClient client2484
       deleteClusterParameterGroup
       (delete-cluster-parameter-group-request
        (clojure.core/nth args2483 0)))))))
  (clojure.core/defn
   delete-cluster-parameter-group-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         parameter-group-name]}]]),
    :doc "Generate map for deleteClusterParameterGroup"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :delete-cluster-parameter-group,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   delete-cluster-parameter-group
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         parameter-group-name]}]]),
    :doc "Call deleteClusterParameterGroup"}
   [credentials2486 & args2487]
   (clojure.core/let
    [^com.amazonaws.services.redshift.AmazonRedshiftClient client2488
     (com.palletops.awaze.common/aws-client :redshift credentials2486)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.redshift.AmazonRedshiftClient client2488
      deleteClusterParameterGroup
      (delete-cluster-parameter-group-request
       (clojure.core/nth args2487 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :authorize-cluster-security-group-ingress
   [m2489]
   (clojure.core/let
    [credentials2490 (:credentials m2489) args2491 (:args m2489)]
    (clojure.core/let
     [^com.amazonaws.services.redshift.AmazonRedshiftClient client2492
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2490)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.redshift.AmazonRedshiftClient client2492
       authorizeClusterSecurityGroupIngress
       (authorize-cluster-security-group-ingress-request
        (clojure.core/nth args2491 0)))))))
  (clojure.core/defn
   authorize-cluster-security-group-ingress-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         cluster-security-group-name
                         ec2security-group-owner-id
                         ec2security-group-name
                         cidrip]}]]),
    :doc "Generate map for authorizeClusterSecurityGroupIngress"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :authorize-cluster-security-group-ingress,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   authorize-cluster-security-group-ingress
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         cluster-security-group-name
                         ec2security-group-owner-id
                         ec2security-group-name
                         cidrip]}]]),
    :doc "Call authorizeClusterSecurityGroupIngress"}
   [credentials2494 & args2495]
   (clojure.core/let
    [^com.amazonaws.services.redshift.AmazonRedshiftClient client2496
     (com.palletops.awaze.common/aws-client :redshift credentials2494)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.redshift.AmazonRedshiftClient client2496
      authorizeClusterSecurityGroupIngress
      (authorize-cluster-security-group-ingress-request
       (clojure.core/nth args2495 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :modify-cluster
   [m2497]
   (clojure.core/let
    [credentials2498 (:credentials m2497) args2499 (:args m2497)]
    (clojure.core/let
     [^com.amazonaws.services.redshift.AmazonRedshiftClient client2500
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2498)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.redshift.AmazonRedshiftClient client2500
       modifyCluster
       (modify-cluster-request (clojure.core/nth args2499 0)))))))
  (clojure.core/defn
   modify-cluster-map
   {:arglists (quote
               [[credentials
                 {:keys [node-type
                         cluster-type
                         request-metric-collector
                         cluster-security-groups
                         automated-snapshot-retention-period
                         cluster-identifier
                         preferred-maintenance-window
                         cluster-parameter-group-name
                         master-user-password
                         number-of-nodes
                         vpc-security-group-ids
                         cluster-version
                         allow-version-upgrade]}]]),
    :doc "Generate map for modifyCluster"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :modify-cluster,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   modify-cluster
   {:arglists (quote
               [[credentials
                 {:keys [node-type
                         cluster-type
                         request-metric-collector
                         cluster-security-groups
                         automated-snapshot-retention-period
                         cluster-identifier
                         preferred-maintenance-window
                         cluster-parameter-group-name
                         master-user-password
                         number-of-nodes
                         vpc-security-group-ids
                         cluster-version
                         allow-version-upgrade]}]]),
    :doc "Call modifyCluster"}
   [credentials2502 & args2503]
   (clojure.core/let
    [^com.amazonaws.services.redshift.AmazonRedshiftClient client2504
     (com.palletops.awaze.common/aws-client :redshift credentials2502)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.redshift.AmazonRedshiftClient client2504
      modifyCluster
      (modify-cluster-request (clojure.core/nth args2503 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :delete-cluster-subnet-group
   [m2505]
   (clojure.core/let
    [credentials2506 (:credentials m2505) args2507 (:args m2505)]
    (clojure.core/let
     [^com.amazonaws.services.redshift.AmazonRedshiftClient client2508
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2506)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.redshift.AmazonRedshiftClient client2508
       deleteClusterSubnetGroup
       (delete-cluster-subnet-group-request
        (clojure.core/nth args2507 0)))))))
  (clojure.core/defn
   delete-cluster-subnet-group-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         cluster-subnet-group-name]}]]),
    :doc "Generate map for deleteClusterSubnetGroup"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :delete-cluster-subnet-group,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   delete-cluster-subnet-group
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         cluster-subnet-group-name]}]]),
    :doc "Call deleteClusterSubnetGroup"}
   [credentials2510 & args2511]
   (clojure.core/let
    [^com.amazonaws.services.redshift.AmazonRedshiftClient client2512
     (com.palletops.awaze.common/aws-client :redshift credentials2510)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.redshift.AmazonRedshiftClient client2512
      deleteClusterSubnetGroup
      (delete-cluster-subnet-group-request
       (clojure.core/nth args2511 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :create-cluster-subnet-group
   [m2513]
   (clojure.core/let
    [credentials2514 (:credentials m2513) args2515 (:args m2513)]
    (clojure.core/let
     [^com.amazonaws.services.redshift.AmazonRedshiftClient client2516
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2514)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.redshift.AmazonRedshiftClient client2516
       createClusterSubnetGroup
       (create-cluster-subnet-group-request
        (clojure.core/nth args2515 0)))))))
  (clojure.core/defn
   create-cluster-subnet-group-map
   {:arglists (quote
               [[credentials
                 {:keys [subnet-ids
                         request-metric-collector
                         description
                         cluster-subnet-group-name]}]]),
    :doc "Generate map for createClusterSubnetGroup"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :create-cluster-subnet-group,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   create-cluster-subnet-group
   {:arglists (quote
               [[credentials
                 {:keys [subnet-ids
                         request-metric-collector
                         description
                         cluster-subnet-group-name]}]]),
    :doc "Call createClusterSubnetGroup"}
   [credentials2518 & args2519]
   (clojure.core/let
    [^com.amazonaws.services.redshift.AmazonRedshiftClient client2520
     (com.palletops.awaze.common/aws-client :redshift credentials2518)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.redshift.AmazonRedshiftClient client2520
      createClusterSubnetGroup
      (create-cluster-subnet-group-request
       (clojure.core/nth args2519 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :purchase-reserved-node-offering
   [m2521]
   (clojure.core/let
    [credentials2522 (:credentials m2521) args2523 (:args m2521)]
    (clojure.core/let
     [^com.amazonaws.services.redshift.AmazonRedshiftClient client2524
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2522)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.redshift.AmazonRedshiftClient client2524
       purchaseReservedNodeOffering
       (purchase-reserved-node-offering-request
        (clojure.core/nth args2523 0)))))))
  (clojure.core/defn
   purchase-reserved-node-offering-map
   {:arglists (quote
               [[credentials
                 {:keys [reserved-node-offering-id
                         request-metric-collector
                         node-count]}]]),
    :doc "Generate map for purchaseReservedNodeOffering"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :purchase-reserved-node-offering,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   purchase-reserved-node-offering
   {:arglists (quote
               [[credentials
                 {:keys [reserved-node-offering-id
                         request-metric-collector
                         node-count]}]]),
    :doc "Call purchaseReservedNodeOffering"}
   [credentials2526 & args2527]
   (clojure.core/let
    [^com.amazonaws.services.redshift.AmazonRedshiftClient client2528
     (com.palletops.awaze.common/aws-client :redshift credentials2526)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.redshift.AmazonRedshiftClient client2528
      purchaseReservedNodeOffering
      (purchase-reserved-node-offering-request
       (clojure.core/nth args2527 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-reserved-node-offerings
   [m2529]
   (clojure.core/let
    [credentials2530 (:credentials m2529) args2531 (:args m2529)]
    (clojure.core/let
     [^com.amazonaws.services.redshift.AmazonRedshiftClient client2532
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2530)]
     (clojure.core/case
      (clojure.core/count args2531)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.redshift.AmazonRedshiftClient client2532
        describeReservedNodeOfferings))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.redshift.AmazonRedshiftClient client2532
        describeReservedNodeOfferings
        (describe-reserved-node-offerings-request
         (clojure.core/nth args2531 0))))))))
  (clojure.core/defn
   describe-reserved-node-offerings-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [reserved-node-offering-id
                         request-metric-collector
                         max-records
                         marker]}]]),
    :doc "Generate map for describeReservedNodeOfferings, describeReservedNodeOfferings"}
   ([credentials__1609__auto__]
    {:args [],
     :client :redshift,
     :fn :describe-reserved-node-offerings,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :describe-reserved-node-offerings,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-reserved-node-offerings
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [reserved-node-offering-id
                         request-metric-collector
                         max-records
                         marker]}]]),
    :doc "Call describeReservedNodeOfferings, describeReservedNodeOfferings"}
   [credentials2534 & args2535]
   (clojure.core/let
    [^com.amazonaws.services.redshift.AmazonRedshiftClient client2536
     (com.palletops.awaze.common/aws-client :redshift credentials2534)]
    (clojure.core/case
     (clojure.core/count args2535)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.redshift.AmazonRedshiftClient client2536
       describeReservedNodeOfferings))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.redshift.AmazonRedshiftClient client2536
       describeReservedNodeOfferings
       (describe-reserved-node-offerings-request
        (clojure.core/nth args2535 0))))))))
 (do
  (clojure.core/defmethod
   redshift
   :delete-cluster
   [m2537]
   (clojure.core/let
    [credentials2538 (:credentials m2537) args2539 (:args m2537)]
    (clojure.core/let
     [^com.amazonaws.services.redshift.AmazonRedshiftClient client2540
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2538)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.redshift.AmazonRedshiftClient client2540
       deleteCluster
       (delete-cluster-request (clojure.core/nth args2539 0)))))))
  (clojure.core/defn
   delete-cluster-map
   {:arglists (quote
               [[credentials
                 {:keys [skip-final-cluster-snapshot
                         request-metric-collector
                         final-cluster-snapshot-identifier
                         cluster-identifier]}]]),
    :doc "Generate map for deleteCluster"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :delete-cluster,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   delete-cluster
   {:arglists (quote
               [[credentials
                 {:keys [skip-final-cluster-snapshot
                         request-metric-collector
                         final-cluster-snapshot-identifier
                         cluster-identifier]}]]),
    :doc "Call deleteCluster"}
   [credentials2542 & args2543]
   (clojure.core/let
    [^com.amazonaws.services.redshift.AmazonRedshiftClient client2544
     (com.palletops.awaze.common/aws-client :redshift credentials2542)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.redshift.AmazonRedshiftClient client2544
      deleteCluster
      (delete-cluster-request (clojure.core/nth args2543 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :create-cluster-security-group
   [m2545]
   (clojure.core/let
    [credentials2546 (:credentials m2545) args2547 (:args m2545)]
    (clojure.core/let
     [^com.amazonaws.services.redshift.AmazonRedshiftClient client2548
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2546)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.redshift.AmazonRedshiftClient client2548
       createClusterSecurityGroup
       (create-cluster-security-group-request
        (clojure.core/nth args2547 0)))))))
  (clojure.core/defn
   create-cluster-security-group-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         description
                         cluster-security-group-name]}]]),
    :doc "Generate map for createClusterSecurityGroup"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :create-cluster-security-group,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   create-cluster-security-group
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         description
                         cluster-security-group-name]}]]),
    :doc "Call createClusterSecurityGroup"}
   [credentials2550 & args2551]
   (clojure.core/let
    [^com.amazonaws.services.redshift.AmazonRedshiftClient client2552
     (com.palletops.awaze.common/aws-client :redshift credentials2550)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.redshift.AmazonRedshiftClient client2552
      createClusterSecurityGroup
      (create-cluster-security-group-request
       (clojure.core/nth args2551 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-default-cluster-parameters
   [m2553]
   (clojure.core/let
    [credentials2554 (:credentials m2553) args2555 (:args m2553)]
    (clojure.core/let
     [^com.amazonaws.services.redshift.AmazonRedshiftClient client2556
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2554)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.redshift.AmazonRedshiftClient client2556
       describeDefaultClusterParameters
       (describe-default-cluster-parameters-request
        (clojure.core/nth args2555 0)))))))
  (clojure.core/defn
   describe-default-cluster-parameters-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         parameter-group-family
                         max-records
                         marker]}]]),
    :doc "Generate map for describeDefaultClusterParameters"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :describe-default-cluster-parameters,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-default-cluster-parameters
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         parameter-group-family
                         max-records
                         marker]}]]),
    :doc "Call describeDefaultClusterParameters"}
   [credentials2558 & args2559]
   (clojure.core/let
    [^com.amazonaws.services.redshift.AmazonRedshiftClient client2560
     (com.palletops.awaze.common/aws-client :redshift credentials2558)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.redshift.AmazonRedshiftClient client2560
      describeDefaultClusterParameters
      (describe-default-cluster-parameters-request
       (clojure.core/nth args2559 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :create-cluster-snapshot
   [m2561]
   (clojure.core/let
    [credentials2562 (:credentials m2561) args2563 (:args m2561)]
    (clojure.core/let
     [^com.amazonaws.services.redshift.AmazonRedshiftClient client2564
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2562)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.redshift.AmazonRedshiftClient client2564
       createClusterSnapshot
       (create-cluster-snapshot-request (clojure.core/nth args2563 0)))))))
  (clojure.core/defn
   create-cluster-snapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [snapshot-identifier
                         request-metric-collector
                         cluster-identifier]}]]),
    :doc "Generate map for createClusterSnapshot"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :create-cluster-snapshot,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   create-cluster-snapshot
   {:arglists (quote
               [[credentials
                 {:keys [snapshot-identifier
                         request-metric-collector
                         cluster-identifier]}]]),
    :doc "Call createClusterSnapshot"}
   [credentials2566 & args2567]
   (clojure.core/let
    [^com.amazonaws.services.redshift.AmazonRedshiftClient client2568
     (com.palletops.awaze.common/aws-client :redshift credentials2566)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.redshift.AmazonRedshiftClient client2568
      createClusterSnapshot
      (create-cluster-snapshot-request (clojure.core/nth args2567 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-cluster-versions
   [m2569]
   (clojure.core/let
    [credentials2570 (:credentials m2569) args2571 (:args m2569)]
    (clojure.core/let
     [^com.amazonaws.services.redshift.AmazonRedshiftClient client2572
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2570)]
     (clojure.core/case
      (clojure.core/count args2571)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.redshift.AmazonRedshiftClient client2572
        describeClusterVersions))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.redshift.AmazonRedshiftClient client2572
        describeClusterVersions
        (describe-cluster-versions-request
         (clojure.core/nth args2571 0))))))))
  (clojure.core/defn
   describe-cluster-versions-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [request-metric-collector
                         max-records
                         marker
                         cluster-version
                         cluster-parameter-group-family]}]]),
    :doc "Generate map for describeClusterVersions, describeClusterVersions"}
   ([credentials__1609__auto__]
    {:args [],
     :client :redshift,
     :fn :describe-cluster-versions,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :describe-cluster-versions,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-cluster-versions
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [request-metric-collector
                         max-records
                         marker
                         cluster-version
                         cluster-parameter-group-family]}]]),
    :doc "Call describeClusterVersions, describeClusterVersions"}
   [credentials2574 & args2575]
   (clojure.core/let
    [^com.amazonaws.services.redshift.AmazonRedshiftClient client2576
     (com.palletops.awaze.common/aws-client :redshift credentials2574)]
    (clojure.core/case
     (clojure.core/count args2575)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.redshift.AmazonRedshiftClient client2576
       describeClusterVersions))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.redshift.AmazonRedshiftClient client2576
       describeClusterVersions
       (describe-cluster-versions-request
        (clojure.core/nth args2575 0))))))))
 (do
  (clojure.core/defmethod
   redshift
   :reboot-cluster
   [m2577]
   (clojure.core/let
    [credentials2578 (:credentials m2577) args2579 (:args m2577)]
    (clojure.core/let
     [^com.amazonaws.services.redshift.AmazonRedshiftClient client2580
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2578)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.redshift.AmazonRedshiftClient client2580
       rebootCluster
       (reboot-cluster-request (clojure.core/nth args2579 0)))))))
  (clojure.core/defn
   reboot-cluster-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector cluster-identifier]}]]),
    :doc "Generate map for rebootCluster"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :reboot-cluster,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   reboot-cluster
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector cluster-identifier]}]]),
    :doc "Call rebootCluster"}
   [credentials2582 & args2583]
   (clojure.core/let
    [^com.amazonaws.services.redshift.AmazonRedshiftClient client2584
     (com.palletops.awaze.common/aws-client :redshift credentials2582)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.redshift.AmazonRedshiftClient client2584
      rebootCluster
      (reboot-cluster-request (clojure.core/nth args2583 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-resize
   [m2585]
   (clojure.core/let
    [credentials2586 (:credentials m2585) args2587 (:args m2585)]
    (clojure.core/let
     [^com.amazonaws.services.redshift.AmazonRedshiftClient client2588
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2586)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.redshift.AmazonRedshiftClient client2588
       describeResize
       (describe-resize-request (clojure.core/nth args2587 0)))))))
  (clojure.core/defn
   describe-resize-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector cluster-identifier]}]]),
    :doc "Generate map for describeResize"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :describe-resize,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-resize
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector cluster-identifier]}]]),
    :doc "Call describeResize"}
   [credentials2590 & args2591]
   (clojure.core/let
    [^com.amazonaws.services.redshift.AmazonRedshiftClient client2592
     (com.palletops.awaze.common/aws-client :redshift credentials2590)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.redshift.AmazonRedshiftClient client2592
      describeResize
      (describe-resize-request (clojure.core/nth args2591 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :revoke-cluster-security-group-ingress
   [m2593]
   (clojure.core/let
    [credentials2594 (:credentials m2593) args2595 (:args m2593)]
    (clojure.core/let
     [^com.amazonaws.services.redshift.AmazonRedshiftClient client2596
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2594)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.redshift.AmazonRedshiftClient client2596
       revokeClusterSecurityGroupIngress
       (revoke-cluster-security-group-ingress-request
        (clojure.core/nth args2595 0)))))))
  (clojure.core/defn
   revoke-cluster-security-group-ingress-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         cluster-security-group-name
                         ec2security-group-owner-id
                         ec2security-group-name
                         cidrip]}]]),
    :doc "Generate map for revokeClusterSecurityGroupIngress"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :revoke-cluster-security-group-ingress,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   revoke-cluster-security-group-ingress
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         cluster-security-group-name
                         ec2security-group-owner-id
                         ec2security-group-name
                         cidrip]}]]),
    :doc "Call revokeClusterSecurityGroupIngress"}
   [credentials2598 & args2599]
   (clojure.core/let
    [^com.amazonaws.services.redshift.AmazonRedshiftClient client2600
     (com.palletops.awaze.common/aws-client :redshift credentials2598)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.redshift.AmazonRedshiftClient client2600
      revokeClusterSecurityGroupIngress
      (revoke-cluster-security-group-ingress-request
       (clojure.core/nth args2599 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :modify-cluster-parameter-group
   [m2601]
   (clojure.core/let
    [credentials2602 (:credentials m2601) args2603 (:args m2601)]
    (clojure.core/let
     [^com.amazonaws.services.redshift.AmazonRedshiftClient client2604
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2602)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.redshift.AmazonRedshiftClient client2604
       modifyClusterParameterGroup
       (modify-cluster-parameter-group-request
        (clojure.core/nth args2603 0)))))))
  (clojure.core/defn
   modify-cluster-parameter-group-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         parameters
                         parameter-group-name]}]]),
    :doc "Generate map for modifyClusterParameterGroup"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :modify-cluster-parameter-group,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   modify-cluster-parameter-group
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         parameters
                         parameter-group-name]}]]),
    :doc "Call modifyClusterParameterGroup"}
   [credentials2606 & args2607]
   (clojure.core/let
    [^com.amazonaws.services.redshift.AmazonRedshiftClient client2608
     (com.palletops.awaze.common/aws-client :redshift credentials2606)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.redshift.AmazonRedshiftClient client2608
      modifyClusterParameterGroup
      (modify-cluster-parameter-group-request
       (clojure.core/nth args2607 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-cluster-snapshots
   [m2609]
   (clojure.core/let
    [credentials2610 (:credentials m2609) args2611 (:args m2609)]
    (clojure.core/let
     [^com.amazonaws.services.redshift.AmazonRedshiftClient client2612
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2610)]
     (clojure.core/case
      (clojure.core/count args2611)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.redshift.AmazonRedshiftClient client2612
        describeClusterSnapshots))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.redshift.AmazonRedshiftClient client2612
        describeClusterSnapshots
        (describe-cluster-snapshots-request
         (clojure.core/nth args2611 0))))))))
  (clojure.core/defn
   describe-cluster-snapshots-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [end-time
                         request-metric-collector
                         cluster-identifier
                         owner-account
                         max-records
                         start-time
                         marker
                         snapshot-identifier
                         snapshot-type]}]]),
    :doc "Generate map for describeClusterSnapshots, describeClusterSnapshots"}
   ([credentials__1609__auto__]
    {:args [],
     :client :redshift,
     :fn :describe-cluster-snapshots,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :describe-cluster-snapshots,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-cluster-snapshots
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [end-time
                         request-metric-collector
                         cluster-identifier
                         owner-account
                         max-records
                         start-time
                         marker
                         snapshot-identifier
                         snapshot-type]}]]),
    :doc "Call describeClusterSnapshots, describeClusterSnapshots"}
   [credentials2614 & args2615]
   (clojure.core/let
    [^com.amazonaws.services.redshift.AmazonRedshiftClient client2616
     (com.palletops.awaze.common/aws-client :redshift credentials2614)]
    (clojure.core/case
     (clojure.core/count args2615)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.redshift.AmazonRedshiftClient client2616
       describeClusterSnapshots))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.redshift.AmazonRedshiftClient client2616
       describeClusterSnapshots
       (describe-cluster-snapshots-request
        (clojure.core/nth args2615 0))))))))
 (do
  (clojure.core/defmethod
   redshift
   :delete-cluster-snapshot
   [m2617]
   (clojure.core/let
    [credentials2618 (:credentials m2617) args2619 (:args m2617)]
    (clojure.core/let
     [^com.amazonaws.services.redshift.AmazonRedshiftClient client2620
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2618)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.redshift.AmazonRedshiftClient client2620
       deleteClusterSnapshot
       (delete-cluster-snapshot-request (clojure.core/nth args2619 0)))))))
  (clojure.core/defn
   delete-cluster-snapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [snapshot-identifier
                         snapshot-cluster-identifier
                         request-metric-collector]}]]),
    :doc "Generate map for deleteClusterSnapshot"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :delete-cluster-snapshot,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   delete-cluster-snapshot
   {:arglists (quote
               [[credentials
                 {:keys [snapshot-identifier
                         snapshot-cluster-identifier
                         request-metric-collector]}]]),
    :doc "Call deleteClusterSnapshot"}
   [credentials2622 & args2623]
   (clojure.core/let
    [^com.amazonaws.services.redshift.AmazonRedshiftClient client2624
     (com.palletops.awaze.common/aws-client :redshift credentials2622)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.redshift.AmazonRedshiftClient client2624
      deleteClusterSnapshot
      (delete-cluster-snapshot-request (clojure.core/nth args2623 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-orderable-cluster-options
   [m2625]
   (clojure.core/let
    [credentials2626 (:credentials m2625) args2627 (:args m2625)]
    (clojure.core/let
     [^com.amazonaws.services.redshift.AmazonRedshiftClient client2628
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2626)]
     (clojure.core/case
      (clojure.core/count args2627)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.redshift.AmazonRedshiftClient client2628
        describeOrderableClusterOptions))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.redshift.AmazonRedshiftClient client2628
        describeOrderableClusterOptions
        (describe-orderable-cluster-options-request
         (clojure.core/nth args2627 0))))))))
  (clojure.core/defn
   describe-orderable-cluster-options-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [request-metric-collector
                         node-type
                         max-records
                         marker
                         cluster-version]}]]),
    :doc "Generate map for describeOrderableClusterOptions, describeOrderableClusterOptions"}
   ([credentials__1609__auto__]
    {:args [],
     :client :redshift,
     :fn :describe-orderable-cluster-options,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :describe-orderable-cluster-options,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-orderable-cluster-options
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [request-metric-collector
                         node-type
                         max-records
                         marker
                         cluster-version]}]]),
    :doc "Call describeOrderableClusterOptions, describeOrderableClusterOptions"}
   [credentials2630 & args2631]
   (clojure.core/let
    [^com.amazonaws.services.redshift.AmazonRedshiftClient client2632
     (com.palletops.awaze.common/aws-client :redshift credentials2630)]
    (clojure.core/case
     (clojure.core/count args2631)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.redshift.AmazonRedshiftClient client2632
       describeOrderableClusterOptions))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.redshift.AmazonRedshiftClient client2632
       describeOrderableClusterOptions
       (describe-orderable-cluster-options-request
        (clojure.core/nth args2631 0)))))))))
