(ns
 com.palletops.awaze.route53
 (:require [com.palletops.awaze.common]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :route53
  [___1561__auto__
   ^com.amazonaws.auth.BasicAWSCredentials credentials__1562__auto__]
  (new
   com.amazonaws.services.route53.AmazonRoute53Client
   credentials__1562__auto__))
 (clojure.core/defn
  ^com.amazonaws.services.route53.model.ResourceRecordSetRegion resource-record-set-region
  [m10387]
  (java.lang.Enum/valueOf
   com.amazonaws.services.route53.model.ResourceRecordSetRegion
   (clojure.core/name m10387)))
 (clojure.core/defn
  ^com.amazonaws.services.route53.model.RRType rrtype
  [m10390]
  (java.lang.Enum/valueOf
   com.amazonaws.services.route53.model.RRType
   (clojure.core/name m10390)))
 (clojure.core/defn
  ^com.amazonaws.services.route53.model.ResourceRecordSetFailover resource-record-set-failover
  [m10393]
  (java.lang.Enum/valueOf
   com.amazonaws.services.route53.model.ResourceRecordSetFailover
   (clojure.core/name m10393)))
 (clojure.core/defn
  ^com.amazonaws.services.route53.model.ResourceRecord resource-record
  [m10396]
  (clojure.core/let
   [bean10395
    (new com.amazonaws.services.route53.model.ResourceRecord)]
   (clojure.core/when-let
    [v10397 (:value m10396)]
    (. bean10395 setValue (clojure.core/str v10397)))
   bean10395))
 (clojure.core/defn
  ^com.amazonaws.services.route53.model.AliasTarget alias-target
  [m10399]
  (clojure.core/let
   [bean10398 (new com.amazonaws.services.route53.model.AliasTarget)]
   (clojure.core/when-let
    [v10400 (:dnsname m10399)]
    (. bean10398 setDNSName (clojure.core/str v10400)))
   (clojure.core/when-let
    [v10400 (:hosted-zone-id m10399)]
    (. bean10398 setHostedZoneId (clojure.core/str v10400)))
   (clojure.core/when-let
    [v10400 (:evaluate-target-health m10399)]
    (.
     bean10398
     setEvaluateTargetHealth
     (clojure.core/boolean v10400)))
   bean10398))
 (clojure.core/defn
  ^com.amazonaws.services.route53.model.ChangeAction change-action
  [m10402]
  (java.lang.Enum/valueOf
   com.amazonaws.services.route53.model.ChangeAction
   (clojure.core/name m10402)))
 (clojure.core/defn
  ^com.amazonaws.services.route53.model.ResourceRecordSet resource-record-set
  [m10405]
  (clojure.core/let
   [bean10404
    (new com.amazonaws.services.route53.model.ResourceRecordSet)]
   (clojure.core/when-let
    [v10406 (:name m10405)]
    (. bean10404 setName (clojure.core/str v10406)))
   (clojure.core/when-let
    [v10406 (:region m10405)]
    (. bean10404 setRegion (clojure.core/str v10406)))
   (clojure.core/when-let
    [v10406 (:region m10405)]
    (. bean10404 setRegion (resource-record-set-region v10406)))
   (clojure.core/when-let
    [v10406 (:type m10405)]
    (. bean10404 setType (rrtype v10406)))
   (clojure.core/when-let
    [v10406 (:type m10405)]
    (. bean10404 setType (clojure.core/str v10406)))
   (clojure.core/when-let
    [v10406 (:health-check-id m10405)]
    (. bean10404 setHealthCheckId (clojure.core/str v10406)))
   (clojure.core/when-let
    [v10406 (:set-identifier m10405)]
    (. bean10404 setSetIdentifier (clojure.core/str v10406)))
   (clojure.core/when-let
    [v10406 (:weight m10405)]
    (. bean10404 setWeight (clojure.core/long v10406)))
   (clojure.core/when-let
    [v10406 (:failover m10405)]
    (. bean10404 setFailover (clojure.core/str v10406)))
   (clojure.core/when-let
    [v10406 (:failover m10405)]
    (. bean10404 setFailover (resource-record-set-failover v10406)))
   (clojure.core/when-let
    [v10406 (:ttl m10405)]
    (. bean10404 setTTL (clojure.core/long v10406)))
   (clojure.core/when-let
    [v10406 (:resource-records m10405)]
    (.
     bean10404
     setResourceRecords
     (clojure.core/map
      (clojure.core/fn [arg10410] (resource-record arg10410))
      v10406)))
   (clojure.core/when-let
    [v10406 (:alias-target m10405)]
    (. bean10404 setAliasTarget (alias-target v10406)))
   bean10404))
 (clojure.core/defn
  ^com.amazonaws.services.route53.model.Change change
  [m10408]
  (clojure.core/let
   [bean10407 (new com.amazonaws.services.route53.model.Change)]
   (clojure.core/when-let
    [v10409 (:action m10408)]
    (. bean10407 setAction (clojure.core/str v10409)))
   (clojure.core/when-let
    [v10409 (:action m10408)]
    (. bean10407 setAction (change-action v10409)))
   (clojure.core/when-let
    [v10409 (:resource-record-set m10408)]
    (. bean10407 setResourceRecordSet (resource-record-set v10409)))
   bean10407))
 (clojure.core/defn
  ^com.amazonaws.services.route53.model.HealthCheckType health-check-type
  [m10412]
  (java.lang.Enum/valueOf
   com.amazonaws.services.route53.model.HealthCheckType
   (clojure.core/name m10412)))
 (clojure.core/defn
  ^com.amazonaws.services.route53.model.ChangeBatch change-batch
  [m10415]
  (clojure.core/let
   [bean10414 (new com.amazonaws.services.route53.model.ChangeBatch)]
   (clojure.core/when-let
    [v10416 (:comment m10415)]
    (. bean10414 setComment (clojure.core/str v10416)))
   (clojure.core/when-let
    [v10416 (:changes m10415)]
    (.
     bean10414
     setChanges
     (clojure.core/map
      (clojure.core/fn [arg10420] (change arg10420))
      v10416)))
   bean10414))
 (clojure.core/defn
  ^com.amazonaws.services.route53.model.HealthCheckConfig health-check-config
  [m10418]
  (clojure.core/let
   [bean10417
    (new com.amazonaws.services.route53.model.HealthCheckConfig)]
   (clojure.core/when-let
    [v10419 (:resource-path m10418)]
    (. bean10417 setResourcePath (clojure.core/str v10419)))
   (clojure.core/when-let
    [v10419 (:type m10418)]
    (. bean10417 setType (health-check-type v10419)))
   (clojure.core/when-let
    [v10419 (:type m10418)]
    (. bean10417 setType (clojure.core/str v10419)))
   (clojure.core/when-let
    [v10419 (:port m10418)]
    (. bean10417 setPort (clojure.core/int v10419)))
   (clojure.core/when-let
    [v10419 (:ipaddress m10418)]
    (. bean10417 setIPAddress (clojure.core/str v10419)))
   (clojure.core/when-let
    [v10419 (:fully-qualified-domain-name m10418)]
    (.
     bean10417
     setFullyQualifiedDomainName
     (clojure.core/str v10419)))
   bean10417))
 (clojure.core/defn
  ^com.amazonaws.services.route53.model.HostedZoneConfig hosted-zone-config
  [m10422]
  (clojure.core/let
   [bean10421
    (new com.amazonaws.services.route53.model.HostedZoneConfig)]
   (clojure.core/when-let
    [v10423 (:comment m10422)]
    (. bean10421 setComment (clojure.core/str v10423)))
   bean10421))
 (clojure.core/defn
  ^com.amazonaws.services.route53.model.GetHostedZoneRequest get-hosted-zone-request
  [m10425]
  (clojure.core/let
   [bean10424
    (new com.amazonaws.services.route53.model.GetHostedZoneRequest)]
   (clojure.core/when-let
    [v10426 (:id m10425)]
    (. bean10424 setId (clojure.core/str v10426)))
   bean10424))
 (clojure.core/defn
  ^com.amazonaws.services.route53.model.ListHostedZonesRequest list-hosted-zones-request
  [m10428]
  (clojure.core/let
   [bean10427
    (new com.amazonaws.services.route53.model.ListHostedZonesRequest)]
   (clojure.core/when-let
    [v10429 (:max-items m10428)]
    (. bean10427 setMaxItems (clojure.core/str v10429)))
   (clojure.core/when-let
    [v10429 (:marker m10428)]
    (. bean10427 setMarker (clojure.core/str v10429)))
   bean10427))
 (clojure.core/defn
  ^com.amazonaws.services.route53.model.ListResourceRecordSetsRequest list-resource-record-sets-request
  [m10431]
  (clojure.core/let
   [bean10430
    (new
     com.amazonaws.services.route53.model.ListResourceRecordSetsRequest)]
   (clojure.core/when-let
    [v10432 (:max-items m10431)]
    (. bean10430 setMaxItems (clojure.core/str v10432)))
   (clojure.core/when-let
    [v10432 (:hosted-zone-id m10431)]
    (. bean10430 setHostedZoneId (clojure.core/str v10432)))
   (clojure.core/when-let
    [v10432 (:start-record-name m10431)]
    (. bean10430 setStartRecordName (clojure.core/str v10432)))
   (clojure.core/when-let
    [v10432 (:start-record-type m10431)]
    (. bean10430 setStartRecordType (rrtype v10432)))
   (clojure.core/when-let
    [v10432 (:start-record-type m10431)]
    (. bean10430 setStartRecordType (clojure.core/str v10432)))
   (clojure.core/when-let
    [v10432 (:start-record-identifier m10431)]
    (. bean10430 setStartRecordIdentifier (clojure.core/str v10432)))
   bean10430))
 (clojure.core/defn
  ^com.amazonaws.services.route53.model.ChangeResourceRecordSetsRequest change-resource-record-sets-request
  [m10434]
  (clojure.core/let
   [bean10433
    (new
     com.amazonaws.services.route53.model.ChangeResourceRecordSetsRequest)]
   (clojure.core/when-let
    [v10435 (:hosted-zone-id m10434)]
    (. bean10433 setHostedZoneId (clojure.core/str v10435)))
   (clojure.core/when-let
    [v10435 (:change-batch m10434)]
    (. bean10433 setChangeBatch (change-batch v10435)))
   bean10433))
 (clojure.core/defn
  ^com.amazonaws.services.route53.model.ListHealthChecksRequest list-health-checks-request
  [m10437]
  (clojure.core/let
   [bean10436
    (new com.amazonaws.services.route53.model.ListHealthChecksRequest)]
   (clojure.core/when-let
    [v10438 (:max-items m10437)]
    (. bean10436 setMaxItems (clojure.core/str v10438)))
   (clojure.core/when-let
    [v10438 (:marker m10437)]
    (. bean10436 setMarker (clojure.core/str v10438)))
   bean10436))
 (clojure.core/defn
  ^com.amazonaws.services.route53.model.CreateHealthCheckRequest create-health-check-request
  [m10440]
  (clojure.core/let
   [bean10439
    (new
     com.amazonaws.services.route53.model.CreateHealthCheckRequest)]
   (clojure.core/when-let
    [v10441 (:caller-reference m10440)]
    (. bean10439 setCallerReference (clojure.core/str v10441)))
   (clojure.core/when-let
    [v10441 (:health-check-config m10440)]
    (. bean10439 setHealthCheckConfig (health-check-config v10441)))
   bean10439))
 (clojure.core/defn
  ^com.amazonaws.services.route53.model.GetHealthCheckRequest get-health-check-request
  [m10443]
  (clojure.core/let
   [bean10442
    (new com.amazonaws.services.route53.model.GetHealthCheckRequest)]
   (clojure.core/when-let
    [v10444 (:health-check-id m10443)]
    (. bean10442 setHealthCheckId (clojure.core/str v10444)))
   bean10442))
 (clojure.core/defn
  ^com.amazonaws.services.route53.model.DeleteHostedZoneRequest delete-hosted-zone-request
  [m10446]
  (clojure.core/let
   [bean10445
    (new com.amazonaws.services.route53.model.DeleteHostedZoneRequest)]
   (clojure.core/when-let
    [v10447 (:id m10446)]
    (. bean10445 setId (clojure.core/str v10447)))
   bean10445))
 (clojure.core/defn
  ^com.amazonaws.services.route53.model.GetChangeRequest get-change-request
  [m10449]
  (clojure.core/let
   [bean10448
    (new com.amazonaws.services.route53.model.GetChangeRequest)]
   (clojure.core/when-let
    [v10450 (:id m10449)]
    (. bean10448 setId (clojure.core/str v10450)))
   bean10448))
 (clojure.core/defn
  ^com.amazonaws.services.route53.model.DeleteHealthCheckRequest delete-health-check-request
  [m10452]
  (clojure.core/let
   [bean10451
    (new
     com.amazonaws.services.route53.model.DeleteHealthCheckRequest)]
   (clojure.core/when-let
    [v10453 (:health-check-id m10452)]
    (. bean10451 setHealthCheckId (clojure.core/str v10453)))
   bean10451))
 (clojure.core/defn
  ^com.amazonaws.services.route53.model.CreateHostedZoneRequest create-hosted-zone-request
  [m10455]
  (clojure.core/let
   [bean10454
    (new com.amazonaws.services.route53.model.CreateHostedZoneRequest)]
   (clojure.core/when-let
    [v10456 (:name m10455)]
    (. bean10454 setName (clojure.core/str v10456)))
   (clojure.core/when-let
    [v10456 (:caller-reference m10455)]
    (. bean10454 setCallerReference (clojure.core/str v10456)))
   (clojure.core/when-let
    [v10456 (:hosted-zone-config m10455)]
    (. bean10454 setHostedZoneConfig (hosted-zone-config v10456)))
   bean10454))
 (clojure.core/defmulti
  route53
  (clojure.core/fn route53 [m__1641__auto__] (:fn m__1641__auto__)))
 (do
  (clojure.core/defmethod
   route53
   :get-hosted-zone
   [m10457]
   (clojure.core/let
    [credentials10458 (:credentials m10457) args10459 (:args m10457)]
    (clojure.core/let
     [^com.amazonaws.services.route53.AmazonRoute53Client client10460
      (com.palletops.awaze.common/aws-client
       :route53
       credentials10458)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.route53.AmazonRoute53Client client10460
       getHostedZone
       (get-hosted-zone-request (clojure.core/nth args10459 0)))))))
  (clojure.core/defn
   get-hosted-zone-map
   {:arglists (quote
               [[credentials {:keys [request-metric-collector id]}]]),
    :doc "Generate map for getHostedZone"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :route53,
     :fn :get-hosted-zone,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   get-hosted-zone
   {:arglists (quote
               [[credentials {:keys [request-metric-collector id]}]]),
    :doc "Call getHostedZone"}
   [credentials10462 & args10463]
   (clojure.core/let
    [^com.amazonaws.services.route53.AmazonRoute53Client client10464
     (com.palletops.awaze.common/aws-client :route53 credentials10462)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.route53.AmazonRoute53Client client10464
      getHostedZone
      (get-hosted-zone-request (clojure.core/nth args10463 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :list-hosted-zones
   [m10465]
   (clojure.core/let
    [credentials10466 (:credentials m10465) args10467 (:args m10465)]
    (clojure.core/let
     [^com.amazonaws.services.route53.AmazonRoute53Client client10468
      (com.palletops.awaze.common/aws-client
       :route53
       credentials10466)]
     (clojure.core/case
      (clojure.core/count args10467)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.route53.AmazonRoute53Client client10468
        listHostedZones))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.route53.AmazonRoute53Client client10468
        listHostedZones
        (list-hosted-zones-request (clojure.core/nth args10467 0))))))))
  (clojure.core/defn
   list-hosted-zones-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [request-metric-collector max-items marker]}]]),
    :doc "Generate map for listHostedZones, listHostedZones"}
   ([credentials__1609__auto__]
    {:args [],
     :client :route53,
     :fn :list-hosted-zones,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :route53,
     :fn :list-hosted-zones,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   list-hosted-zones
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [request-metric-collector max-items marker]}]]),
    :doc "Call listHostedZones, listHostedZones"}
   [credentials10470 & args10471]
   (clojure.core/let
    [^com.amazonaws.services.route53.AmazonRoute53Client client10472
     (com.palletops.awaze.common/aws-client :route53 credentials10470)]
    (clojure.core/case
     (clojure.core/count args10471)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.route53.AmazonRoute53Client client10472
       listHostedZones))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.route53.AmazonRoute53Client client10472
       listHostedZones
       (list-hosted-zones-request (clojure.core/nth args10471 0))))))))
 (do
  (clojure.core/defmethod
   route53
   :list-resource-record-sets
   [m10473]
   (clojure.core/let
    [credentials10474 (:credentials m10473) args10475 (:args m10473)]
    (clojure.core/let
     [^com.amazonaws.services.route53.AmazonRoute53Client client10476
      (com.palletops.awaze.common/aws-client
       :route53
       credentials10474)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.route53.AmazonRoute53Client client10476
       listResourceRecordSets
       (list-resource-record-sets-request
        (clojure.core/nth args10475 0)))))))
  (clojure.core/defn
   list-resource-record-sets-map
   {:arglists (quote
               [[credentials
                 {:keys [start-record-type
                         start-record-name
                         start-record-identifier
                         request-metric-collector
                         max-items
                         hosted-zone-id]}]]),
    :doc "Generate map for listResourceRecordSets"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :route53,
     :fn :list-resource-record-sets,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   list-resource-record-sets
   {:arglists (quote
               [[credentials
                 {:keys [start-record-type
                         start-record-name
                         start-record-identifier
                         request-metric-collector
                         max-items
                         hosted-zone-id]}]]),
    :doc "Call listResourceRecordSets"}
   [credentials10478 & args10479]
   (clojure.core/let
    [^com.amazonaws.services.route53.AmazonRoute53Client client10480
     (com.palletops.awaze.common/aws-client :route53 credentials10478)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.route53.AmazonRoute53Client client10480
      listResourceRecordSets
      (list-resource-record-sets-request
       (clojure.core/nth args10479 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :change-resource-record-sets
   [m10481]
   (clojure.core/let
    [credentials10482 (:credentials m10481) args10483 (:args m10481)]
    (clojure.core/let
     [^com.amazonaws.services.route53.AmazonRoute53Client client10484
      (com.palletops.awaze.common/aws-client
       :route53
       credentials10482)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.route53.AmazonRoute53Client client10484
       changeResourceRecordSets
       (change-resource-record-sets-request
        (clojure.core/nth args10483 0)))))))
  (clojure.core/defn
   change-resource-record-sets-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         hosted-zone-id
                         change-batch]}]]),
    :doc "Generate map for changeResourceRecordSets"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :route53,
     :fn :change-resource-record-sets,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   change-resource-record-sets
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         hosted-zone-id
                         change-batch]}]]),
    :doc "Call changeResourceRecordSets"}
   [credentials10486 & args10487]
   (clojure.core/let
    [^com.amazonaws.services.route53.AmazonRoute53Client client10488
     (com.palletops.awaze.common/aws-client :route53 credentials10486)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.route53.AmazonRoute53Client client10488
      changeResourceRecordSets
      (change-resource-record-sets-request
       (clojure.core/nth args10487 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :list-health-checks
   [m10489]
   (clojure.core/let
    [credentials10490 (:credentials m10489) args10491 (:args m10489)]
    (clojure.core/let
     [^com.amazonaws.services.route53.AmazonRoute53Client client10492
      (com.palletops.awaze.common/aws-client
       :route53
       credentials10490)]
     (clojure.core/case
      (clojure.core/count args10491)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.route53.AmazonRoute53Client client10492
        listHealthChecks))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.route53.AmazonRoute53Client client10492
        listHealthChecks
        (list-health-checks-request (clojure.core/nth args10491 0))))))))
  (clojure.core/defn
   list-health-checks-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [request-metric-collector max-items marker]}]]),
    :doc "Generate map for listHealthChecks, listHealthChecks"}
   ([credentials__1609__auto__]
    {:args [],
     :client :route53,
     :fn :list-health-checks,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :route53,
     :fn :list-health-checks,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   list-health-checks
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [request-metric-collector max-items marker]}]]),
    :doc "Call listHealthChecks, listHealthChecks"}
   [credentials10494 & args10495]
   (clojure.core/let
    [^com.amazonaws.services.route53.AmazonRoute53Client client10496
     (com.palletops.awaze.common/aws-client :route53 credentials10494)]
    (clojure.core/case
     (clojure.core/count args10495)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.route53.AmazonRoute53Client client10496
       listHealthChecks))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.route53.AmazonRoute53Client client10496
       listHealthChecks
       (list-health-checks-request (clojure.core/nth args10495 0))))))))
 (do
  (clojure.core/defmethod
   route53
   :create-health-check
   [m10497]
   (clojure.core/let
    [credentials10498 (:credentials m10497) args10499 (:args m10497)]
    (clojure.core/let
     [^com.amazonaws.services.route53.AmazonRoute53Client client10500
      (com.palletops.awaze.common/aws-client
       :route53
       credentials10498)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.route53.AmazonRoute53Client client10500
       createHealthCheck
       (create-health-check-request (clojure.core/nth args10499 0)))))))
  (clojure.core/defn
   create-health-check-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         health-check-config
                         caller-reference]}]]),
    :doc "Generate map for createHealthCheck"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :route53,
     :fn :create-health-check,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   create-health-check
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         health-check-config
                         caller-reference]}]]),
    :doc "Call createHealthCheck"}
   [credentials10502 & args10503]
   (clojure.core/let
    [^com.amazonaws.services.route53.AmazonRoute53Client client10504
     (com.palletops.awaze.common/aws-client :route53 credentials10502)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.route53.AmazonRoute53Client client10504
      createHealthCheck
      (create-health-check-request (clojure.core/nth args10503 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :get-health-check
   [m10505]
   (clojure.core/let
    [credentials10506 (:credentials m10505) args10507 (:args m10505)]
    (clojure.core/let
     [^com.amazonaws.services.route53.AmazonRoute53Client client10508
      (com.palletops.awaze.common/aws-client
       :route53
       credentials10506)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.route53.AmazonRoute53Client client10508
       getHealthCheck
       (get-health-check-request (clojure.core/nth args10507 0)))))))
  (clojure.core/defn
   get-health-check-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector health-check-id]}]]),
    :doc "Generate map for getHealthCheck"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :route53,
     :fn :get-health-check,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   get-health-check
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector health-check-id]}]]),
    :doc "Call getHealthCheck"}
   [credentials10510 & args10511]
   (clojure.core/let
    [^com.amazonaws.services.route53.AmazonRoute53Client client10512
     (com.palletops.awaze.common/aws-client :route53 credentials10510)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.route53.AmazonRoute53Client client10512
      getHealthCheck
      (get-health-check-request (clojure.core/nth args10511 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :delete-hosted-zone
   [m10513]
   (clojure.core/let
    [credentials10514 (:credentials m10513) args10515 (:args m10513)]
    (clojure.core/let
     [^com.amazonaws.services.route53.AmazonRoute53Client client10516
      (com.palletops.awaze.common/aws-client
       :route53
       credentials10514)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.route53.AmazonRoute53Client client10516
       deleteHostedZone
       (delete-hosted-zone-request (clojure.core/nth args10515 0)))))))
  (clojure.core/defn
   delete-hosted-zone-map
   {:arglists (quote
               [[credentials {:keys [request-metric-collector id]}]]),
    :doc "Generate map for deleteHostedZone"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :route53,
     :fn :delete-hosted-zone,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   delete-hosted-zone
   {:arglists (quote
               [[credentials {:keys [request-metric-collector id]}]]),
    :doc "Call deleteHostedZone"}
   [credentials10518 & args10519]
   (clojure.core/let
    [^com.amazonaws.services.route53.AmazonRoute53Client client10520
     (com.palletops.awaze.common/aws-client :route53 credentials10518)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.route53.AmazonRoute53Client client10520
      deleteHostedZone
      (delete-hosted-zone-request (clojure.core/nth args10519 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :get-change
   [m10521]
   (clojure.core/let
    [credentials10522 (:credentials m10521) args10523 (:args m10521)]
    (clojure.core/let
     [^com.amazonaws.services.route53.AmazonRoute53Client client10524
      (com.palletops.awaze.common/aws-client
       :route53
       credentials10522)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.route53.AmazonRoute53Client client10524
       getChange
       (get-change-request (clojure.core/nth args10523 0)))))))
  (clojure.core/defn
   get-change-map
   {:arglists (quote
               [[credentials {:keys [request-metric-collector id]}]]),
    :doc "Generate map for getChange"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :route53,
     :fn :get-change,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   get-change
   {:arglists (quote
               [[credentials {:keys [request-metric-collector id]}]]),
    :doc "Call getChange"}
   [credentials10526 & args10527]
   (clojure.core/let
    [^com.amazonaws.services.route53.AmazonRoute53Client client10528
     (com.palletops.awaze.common/aws-client :route53 credentials10526)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.route53.AmazonRoute53Client client10528
      getChange
      (get-change-request (clojure.core/nth args10527 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :delete-health-check
   [m10529]
   (clojure.core/let
    [credentials10530 (:credentials m10529) args10531 (:args m10529)]
    (clojure.core/let
     [^com.amazonaws.services.route53.AmazonRoute53Client client10532
      (com.palletops.awaze.common/aws-client
       :route53
       credentials10530)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.route53.AmazonRoute53Client client10532
       deleteHealthCheck
       (delete-health-check-request (clojure.core/nth args10531 0)))))))
  (clojure.core/defn
   delete-health-check-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector health-check-id]}]]),
    :doc "Generate map for deleteHealthCheck"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :route53,
     :fn :delete-health-check,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   delete-health-check
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector health-check-id]}]]),
    :doc "Call deleteHealthCheck"}
   [credentials10534 & args10535]
   (clojure.core/let
    [^com.amazonaws.services.route53.AmazonRoute53Client client10536
     (com.palletops.awaze.common/aws-client :route53 credentials10534)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.route53.AmazonRoute53Client client10536
      deleteHealthCheck
      (delete-health-check-request (clojure.core/nth args10535 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :create-hosted-zone
   [m10537]
   (clojure.core/let
    [credentials10538 (:credentials m10537) args10539 (:args m10537)]
    (clojure.core/let
     [^com.amazonaws.services.route53.AmazonRoute53Client client10540
      (com.palletops.awaze.common/aws-client
       :route53
       credentials10538)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.route53.AmazonRoute53Client client10540
       createHostedZone
       (create-hosted-zone-request (clojure.core/nth args10539 0)))))))
  (clojure.core/defn
   create-hosted-zone-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         name
                         hosted-zone-config
                         caller-reference]}]]),
    :doc "Generate map for createHostedZone"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :route53,
     :fn :create-hosted-zone,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   create-hosted-zone
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         name
                         hosted-zone-config
                         caller-reference]}]]),
    :doc "Call createHostedZone"}
   [credentials10542 & args10543]
   (clojure.core/let
    [^com.amazonaws.services.route53.AmazonRoute53Client client10544
     (com.palletops.awaze.common/aws-client :route53 credentials10542)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.route53.AmazonRoute53Client client10544
      createHostedZone
      (create-hosted-zone-request (clojure.core/nth args10543 0))))))))
