(ns com.palletops.awaze.s3 (:require [com.palletops.awaze.common]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :s3
  [___1561__auto__
   ^com.amazonaws.auth.BasicAWSCredentials credentials__1562__auto__]
  (new
   com.amazonaws.services.s3.AmazonS3Client
   credentials__1562__auto__))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.RedirectRule redirect-rule
  [m9184]
  (clojure.core/let
   [bean9183 (new com.amazonaws.services.s3.model.RedirectRule)]
   (clojure.core/when-let
    [v9185 (:protocol m9184)]
    (. bean9183 setProtocol (clojure.core/str v9185)))
   (clojure.core/when-let
    [v9185 (:replace-key-prefix-with m9184)]
    (. bean9183 setReplaceKeyPrefixWith (clojure.core/str v9185)))
   (clojure.core/when-let
    [v9185 (:replace-key-with m9184)]
    (. bean9183 setReplaceKeyWith (clojure.core/str v9185)))
   (clojure.core/when-let
    [v9185 (:host-name m9184)]
    (. bean9183 setHostName (clojure.core/str v9185)))
   (clojure.core/when-let
    [v9185 (:http-redirect-code m9184)]
    (. bean9183 setHttpRedirectCode (clojure.core/str v9185)))
   bean9183))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.RoutingRuleCondition routing-rule-condition
  [m9187]
  (clojure.core/let
   [bean9186
    (new com.amazonaws.services.s3.model.RoutingRuleCondition)]
   (clojure.core/when-let
    [v9188 (:key-prefix-equals m9187)]
    (. bean9186 setKeyPrefixEquals (clojure.core/str v9188)))
   (clojure.core/when-let
    [v9188 (:http-error-code-returned-equals m9187)]
    (.
     bean9186
     setHttpErrorCodeReturnedEquals
     (clojure.core/str v9188)))
   bean9186))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.StorageClass storage-class
  [m9190]
  (java.lang.Enum/valueOf
   com.amazonaws.services.s3.model.StorageClass
   (clojure.core/name m9190)))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.RoutingRule routing-rule
  [m9193]
  (clojure.core/let
   [bean9192 (new com.amazonaws.services.s3.model.RoutingRule)]
   (clojure.core/when-let
    [v9194 (:redirect m9193)]
    (. bean9192 setRedirect (redirect-rule v9194)))
   (clojure.core/when-let
    [v9194 (:condition m9193)]
    (. bean9192 setCondition (routing-rule-condition v9194)))
   bean9192))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.Owner owner
  [m9196]
  (clojure.core/let
   [bean9195 (new com.amazonaws.services.s3.model.Owner)]
   (clojure.core/when-let
    [v9197 (:id m9196)]
    (. bean9195 setId (clojure.core/str v9197)))
   (clojure.core/when-let
    [v9197 (:display-name m9196)]
    (. bean9195 setDisplayName (clojure.core/str v9197)))
   bean9195))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.CORSRule$AllowedMethods corsrule-allowed-methods
  [m9199]
  (java.lang.Enum/valueOf
   com.amazonaws.services.s3.model.CORSRule$AllowedMethods
   (clojure.core/name m9199)))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.BucketLifecycleConfiguration$Transition bucket-lifecycle-configuration-transition
  [m9202]
  (clojure.core/let
   [bean9201
    (new
     com.amazonaws.services.s3.model.BucketLifecycleConfiguration$Transition)]
   (clojure.core/when-let
    [v9203 (:days m9202)]
    (. bean9201 setDays (clojure.core/int v9203)))
   (clojure.core/when-let
    [v9203 (:date m9202)]
    (. bean9201 setDate (com.palletops.awaze.common/to-date v9203)))
   (clojure.core/when-let
    [v9203 (:storage-class m9202)]
    (. bean9201 setStorageClass (storage-class v9203)))
   bean9201))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.MultiFactorAuthentication multi-factor-authentication
  [m9205]
  (clojure.core/let
   [arg9207
    nil
    arg9208
    nil
    bean9204
    (new
     com.amazonaws.services.s3.model.MultiFactorAuthentication
     arg9207
     arg9208)]
   (clojure.core/when-let
    [v9206 (:token m9205)]
    (. bean9204 setToken (clojure.core/str v9206)))
   (clojure.core/when-let
    [v9206 (:device-serial-number m9205)]
    (. bean9204 setDeviceSerialNumber (clojure.core/str v9206)))
   bean9204))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.DeleteObjectsRequest$KeyVersion delete-objects-request-key-version
  [m9210]
  (clojure.core/let
   [arg9212
    nil
    bean9209
    (new
     com.amazonaws.services.s3.model.DeleteObjectsRequest$KeyVersion
     arg9212)]
   bean9209))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.BucketNotificationConfiguration$TopicConfiguration bucket-notification-configuration-topic-configuration
  [m9214]
  (clojure.core/let
   [arg9216
    nil
    arg9217
    nil
    bean9213
    (new
     com.amazonaws.services.s3.model.BucketNotificationConfiguration$TopicConfiguration
     arg9216
     arg9217)]
   bean9213))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.ProgressListener progress-listener
  [m9219]
  (throw
   (clojure.core/ex-info
    "Trying to construct an interface"
    {:type "com.amazonaws.services.s3.model.ProgressListener",
     :value m9219})))
 (clojure.core/defn
  ^com.amazonaws.event.ProgressListener progress-listener
  [m9222]
  (throw
   (clojure.core/ex-info
    "Trying to construct an interface"
    {:type "com.amazonaws.event.ProgressListener", :value m9222})))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.ResponseHeaderOverrides response-header-overrides
  [m9225]
  (clojure.core/let
   [bean9224
    (new com.amazonaws.services.s3.model.ResponseHeaderOverrides)]
   (clojure.core/when-let
    [v9226 (:content-type m9225)]
    (. bean9224 setContentType (clojure.core/str v9226)))
   (clojure.core/when-let
    [v9226 (:content-encoding m9225)]
    (. bean9224 setContentEncoding (clojure.core/str v9226)))
   (clojure.core/when-let
    [v9226 (:cache-control m9225)]
    (. bean9224 setCacheControl (clojure.core/str v9226)))
   (clojure.core/when-let
    [v9226 (:content-disposition m9225)]
    (. bean9224 setContentDisposition (clojure.core/str v9226)))
   (clojure.core/when-let
    [v9226 (:content-language m9225)]
    (. bean9224 setContentLanguage (clojure.core/str v9226)))
   (clojure.core/when-let
    [v9226 (:expires m9225)]
    (. bean9224 setExpires (clojure.core/str v9226)))
   bean9224))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.BucketWebsiteConfiguration bucket-website-configuration
  [m9228]
  (clojure.core/let
   [bean9227
    (new com.amazonaws.services.s3.model.BucketWebsiteConfiguration)]
   (clojure.core/when-let
    [v9229 (:index-document-suffix m9228)]
    (. bean9227 setIndexDocumentSuffix (clojure.core/str v9229)))
   (clojure.core/when-let
    [v9229 (:error-document m9228)]
    (. bean9227 setErrorDocument (clojure.core/str v9229)))
   (clojure.core/when-let
    [v9229 (:redirect-all-requests-to m9228)]
    (. bean9227 setRedirectAllRequestsTo (redirect-rule v9229)))
   (clojure.core/when-let
    [v9229 (:routing-rules m9228)]
    (.
     bean9227
     setRoutingRules
     (clojure.core/map
      (clojure.core/fn [arg9233] (routing-rule arg9233))
      v9229)))
   bean9227))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.AccessControlList access-control-list
  [m9231]
  (clojure.core/let
   [bean9230 (new com.amazonaws.services.s3.model.AccessControlList)]
   (clojure.core/when-let
    [v9232 (:owner m9231)]
    (. bean9230 setOwner (owner v9232)))
   bean9230))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.CannedAccessControlList canned-access-control-list
  [m9235]
  (java.lang.Enum/valueOf
   com.amazonaws.services.s3.model.CannedAccessControlList
   (clojure.core/name m9235)))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.ObjectMetadata object-metadata
  [m9238]
  (clojure.core/let
   [bean9237 (new com.amazonaws.services.s3.model.ObjectMetadata)]
   (clojure.core/when-let
    [v9239 (:last-modified m9238)]
    (.
     bean9237
     setLastModified
     (com.palletops.awaze.common/to-date v9239)))
   (clojure.core/when-let
    [v9239 (:content-type m9238)]
    (. bean9237 setContentType (clojure.core/str v9239)))
   (clojure.core/when-let
    [v9239 (:content-length m9238)]
    (. bean9237 setContentLength (clojure.core/long v9239)))
   (clojure.core/when-let
    [v9239 (:content-md5 m9238)]
    (. bean9237 setContentMD5 (clojure.core/str v9239)))
   (clojure.core/when-let
    [v9239 (:server-side-encryption m9238)]
    (. bean9237 setServerSideEncryption (clojure.core/str v9239)))
   (clojure.core/when-let
    [v9239 (:expiration-time-rule-id m9238)]
    (. bean9237 setExpirationTimeRuleId (clojure.core/str v9239)))
   (clojure.core/when-let
    [v9239 (:user-metadata m9238)]
    (.
     bean9237
     setUserMetadata
     (clojure.core/zipmap
      (clojure.core/map
       (clojure.core/fn [arg9243] (clojure.core/str arg9243))
       (clojure.core/keys v9239))
      (clojure.core/map
       (clojure.core/fn [arg9243] (clojure.core/str arg9243))
       (clojure.core/vals v9239)))))
   (clojure.core/when-let
    [v9239 (:content-encoding m9238)]
    (. bean9237 setContentEncoding (clojure.core/str v9239)))
   (clojure.core/when-let
    [v9239 (:cache-control m9238)]
    (. bean9237 setCacheControl (clojure.core/str v9239)))
   (clojure.core/when-let
    [v9239 (:content-disposition m9238)]
    (. bean9237 setContentDisposition (clojure.core/str v9239)))
   (clojure.core/when-let
    [v9239 (:restore-expiration-time m9238)]
    (.
     bean9237
     setRestoreExpirationTime
     (com.palletops.awaze.common/to-date v9239)))
   (clojure.core/when-let
    [v9239 (:ongoing-restore m9238)]
    (. bean9237 setOngoingRestore (clojure.core/boolean v9239)))
   (clojure.core/when-let
    [v9239 (:http-expires-date m9238)]
    (.
     bean9237
     setHttpExpiresDate
     (com.palletops.awaze.common/to-date v9239)))
   (clojure.core/when-let
    [v9239 (:expiration-time m9238)]
    (.
     bean9237
     setExpirationTime
     (com.palletops.awaze.common/to-date v9239)))
   bean9237))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.CORSRule corsrule
  [m9241]
  (clojure.core/let
   [bean9240 (new com.amazonaws.services.s3.model.CORSRule)]
   (clojure.core/when-let
    [v9242 (:allowed-origins m9241)]
    (.
     bean9240
     setAllowedOrigins
     (clojure.core/into-array
      java.lang.String
      (clojure.core/map
       (clojure.core/fn [arg9247] (clojure.core/str arg9247))
       v9242))))
   (clojure.core/when-let
    [v9242 (:allowed-origins m9241)]
    (.
     bean9240
     setAllowedOrigins
     (clojure.core/map
      (clojure.core/fn [arg9248] (clojure.core/str arg9248))
      v9242)))
   (clojure.core/when-let
    [v9242 (:max-age-seconds m9241)]
    (. bean9240 setMaxAgeSeconds (clojure.core/int v9242)))
   (clojure.core/when-let
    [v9242 (:exposed-headers m9241)]
    (.
     bean9240
     setExposedHeaders
     (clojure.core/into-array
      java.lang.String
      (clojure.core/map
       (clojure.core/fn [arg9249] (clojure.core/str arg9249))
       v9242))))
   (clojure.core/when-let
    [v9242 (:exposed-headers m9241)]
    (.
     bean9240
     setExposedHeaders
     (clojure.core/map
      (clojure.core/fn [arg9250] (clojure.core/str arg9250))
      v9242)))
   (clojure.core/when-let
    [v9242 (:allowed-headers m9241)]
    (.
     bean9240
     setAllowedHeaders
     (clojure.core/into-array
      java.lang.String
      (clojure.core/map
       (clojure.core/fn [arg9251] (clojure.core/str arg9251))
       v9242))))
   (clojure.core/when-let
    [v9242 (:allowed-headers m9241)]
    (.
     bean9240
     setAllowedHeaders
     (clojure.core/map
      (clojure.core/fn [arg9252] (clojure.core/str arg9252))
      v9242)))
   (clojure.core/when-let
    [v9242 (:id m9241)]
    (. bean9240 setId (clojure.core/str v9242)))
   (clojure.core/when-let
    [v9242 (:allowed-methods m9241)]
    (.
     bean9240
     setAllowedMethods
     (clojure.core/into-array
      com.amazonaws.services.s3.model.CORSRule$AllowedMethods
      (clojure.core/map
       (clojure.core/fn [arg9253] (corsrule-allowed-methods arg9253))
       v9242))))
   (clojure.core/when-let
    [v9242 (:allowed-methods m9241)]
    (.
     bean9240
     setAllowedMethods
     (clojure.core/map
      (clojure.core/fn [arg9254] (corsrule-allowed-methods arg9254))
      v9242)))
   bean9240))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.TagSet tag-set
  [m9245]
  (clojure.core/let
   [bean9244 (new com.amazonaws.services.s3.model.TagSet)]
   bean9244))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.BucketVersioningConfiguration bucket-versioning-configuration
  [m9256]
  (clojure.core/let
   [bean9255
    (new
     com.amazonaws.services.s3.model.BucketVersioningConfiguration)]
   (clojure.core/when-let
    [v9257 (:status m9256)]
    (. bean9255 setStatus (clojure.core/str v9257)))
   (clojure.core/when-let
    [v9257 (:mfa-delete-enabled m9256)]
    (. bean9255 setMfaDeleteEnabled (clojure.core/boolean v9257)))
   bean9255))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.PartETag part-etag
  [m9259]
  (clojure.core/let
   [arg9261
    0
    arg9262
    nil
    bean9258
    (new com.amazonaws.services.s3.model.PartETag arg9261 arg9262)]
   (clojure.core/when-let
    [v9260 (:etag m9259)]
    (. bean9258 setETag (clojure.core/str v9260)))
   (clojure.core/when-let
    [v9260 (:part-number m9259)]
    (. bean9258 setPartNumber (clojure.core/int v9260)))
   bean9258))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.BucketLifecycleConfiguration$Rule bucket-lifecycle-configuration-rule
  [m9264]
  (clojure.core/let
   [bean9263
    (new
     com.amazonaws.services.s3.model.BucketLifecycleConfiguration$Rule)]
   (clojure.core/when-let
    [v9265 (:expiration-date m9264)]
    (.
     bean9263
     setExpirationDate
     (com.palletops.awaze.common/to-date v9265)))
   (clojure.core/when-let
    [v9265 (:transition m9264)]
    (.
     bean9263
     setTransition
     (bucket-lifecycle-configuration-transition v9265)))
   (clojure.core/when-let
    [v9265 (:id m9264)]
    (. bean9263 setId (clojure.core/str v9265)))
   (clojure.core/when-let
    [v9265 (:status m9264)]
    (. bean9263 setStatus (clojure.core/str v9265)))
   (clojure.core/when-let
    [v9265 (:prefix m9264)]
    (. bean9263 setPrefix (clojure.core/str v9265)))
   (clojure.core/when-let
    [v9265 (:expiration-in-days m9264)]
    (. bean9263 setExpirationInDays (clojure.core/int v9265)))
   bean9263))
 (clojure.core/defn
  ^com.amazonaws.HttpMethod http-method
  [m9267]
  (java.lang.Enum/valueOf
   com.amazonaws.HttpMethod
   (clojure.core/name m9267)))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.BucketLoggingConfiguration bucket-logging-configuration
  [m9270]
  (clojure.core/let
   [bean9269
    (new com.amazonaws.services.s3.model.BucketLoggingConfiguration)]
   (clojure.core/when-let
    [v9271 (:destination-bucket-name m9270)]
    (. bean9269 setDestinationBucketName (clojure.core/str v9271)))
   (clojure.core/when-let
    [v9271 (:log-file-prefix m9270)]
    (. bean9269 setLogFilePrefix (clojure.core/str v9271)))
   bean9269))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.S3VersionSummary s3version-summary
  [m9273]
  (clojure.core/let
   [bean9272 (new com.amazonaws.services.s3.model.S3VersionSummary)]
   (clojure.core/when-let
    [v9274 (:size m9273)]
    (. bean9272 setSize (clojure.core/long v9274)))
   (clojure.core/when-let
    [v9274 (:last-modified m9273)]
    (.
     bean9272
     setLastModified
     (com.palletops.awaze.common/to-date v9274)))
   (clojure.core/when-let
    [v9274 (:is-latest m9273)]
    (. bean9272 setIsLatest (clojure.core/boolean v9274)))
   (clojure.core/when-let
    [v9274 (:is-delete-marker m9273)]
    (. bean9272 setIsDeleteMarker (clojure.core/boolean v9274)))
   (clojure.core/when-let
    [v9274 (:etag m9273)]
    (. bean9272 setETag (clojure.core/str v9274)))
   (clojure.core/when-let
    [v9274 (:owner m9273)]
    (. bean9272 setOwner (owner v9274)))
   (clojure.core/when-let
    [v9274 (:key m9273)]
    (. bean9272 setKey (clojure.core/str v9274)))
   (clojure.core/when-let
    [v9274 (:bucket-name m9273)]
    (. bean9272 setBucketName (clojure.core/str v9274)))
   (clojure.core/when-let
    [v9274 (:version-id m9273)]
    (. bean9272 setVersionId (clojure.core/str v9274)))
   (clojure.core/when-let
    [v9274 (:storage-class m9273)]
    (. bean9272 setStorageClass (clojure.core/str v9274)))
   bean9272))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.DeleteObjectsRequest delete-objects-request
  [m9276]
  (clojure.core/let
   [arg9278
    nil
    bean9275
    (new com.amazonaws.services.s3.model.DeleteObjectsRequest arg9278)]
   (clojure.core/when-let
    [v9277 (:bucket-name m9276)]
    (. bean9275 setBucketName (clojure.core/str v9277)))
   (clojure.core/when-let
    [v9277 (:quiet m9276)]
    (. bean9275 setQuiet (clojure.core/boolean v9277)))
   (clojure.core/when-let
    [v9277 (:mfa m9276)]
    (. bean9275 setMfa (multi-factor-authentication v9277)))
   (clojure.core/when-let
    [v9277 (:keys m9276)]
    (.
     bean9275
     setKeys
     (clojure.core/map
      (clojure.core/fn
       [arg9284]
       (delete-objects-request-key-version arg9284))
      v9277)))
   bean9275))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.SetBucketAclRequest set-bucket-acl-request
  [m9280]
  (clojure.core/let
   [^java.lang.String arg9282
    nil
    ^com.amazonaws.services.s3.model.AccessControlList arg9283
    (access-control-list {})
    bean9279
    (new
     com.amazonaws.services.s3.model.SetBucketAclRequest
     ^java.lang.String arg9282
     ^com.amazonaws.services.s3.model.AccessControlList arg9283)]
   bean9279))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.GetBucketLocationRequest get-bucket-location-request
  [m9286]
  (clojure.core/let
   [arg9288
    nil
    bean9285
    (new
     com.amazonaws.services.s3.model.GetBucketLocationRequest
     arg9288)]
   (clojure.core/when-let
    [v9287 (:bucket-name m9286)]
    (. bean9285 setBucketName (clojure.core/str v9287)))
   bean9285))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.BucketNotificationConfiguration bucket-notification-configuration
  [m9290]
  (clojure.core/let
   [bean9289
    (new
     com.amazonaws.services.s3.model.BucketNotificationConfiguration)]
   (clojure.core/when-let
    [v9291 (:topic-configurations m9290)]
    (.
     bean9289
     setTopicConfigurations
     (clojure.core/map
      (clojure.core/fn
       [arg9297]
       (bucket-notification-configuration-topic-configuration arg9297))
      v9291)))
   bean9289))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.GetObjectRequest get-object-request
  [m9293]
  (clojure.core/let
   [arg9295
    nil
    arg9296
    nil
    bean9292
    (new
     com.amazonaws.services.s3.model.GetObjectRequest
     arg9295
     arg9296)]
   (clojure.core/when-let
    [v9294 (:key m9293)]
    (. bean9292 setKey (clojure.core/str v9294)))
   (clojure.core/when-let
    [v9294 (:bucket-name m9293)]
    (. bean9292 setBucketName (clojure.core/str v9294)))
   (clojure.core/when-let
    [v9294 (:version-id m9293)]
    (. bean9292 setVersionId (clojure.core/str v9294)))
   (clojure.core/when-let
    [v9294 (:progress-listener m9293)]
    (. bean9292 setProgressListener (progress-listener v9294)))
   (clojure.core/when-let
    [v9294 (:general-progress-listener m9293)]
    (. bean9292 setGeneralProgressListener (progress-listener v9294)))
   (clojure.core/when-let
    [v9294 (:response-headers m9293)]
    (. bean9292 setResponseHeaders (response-header-overrides v9294)))
   (clojure.core/when-let
    [v9294 (:matching-etag-constraints m9293)]
    (.
     bean9292
     setMatchingETagConstraints
     (clojure.core/map
      (clojure.core/fn [arg9303] (clojure.core/str arg9303))
      v9294)))
   (clojure.core/when-let
    [v9294 (:nonmatching-etag-constraints m9293)]
    (.
     bean9292
     setNonmatchingETagConstraints
     (clojure.core/map
      (clojure.core/fn [arg9304] (clojure.core/str arg9304))
      v9294)))
   (clojure.core/when-let
    [v9294 (:unmodified-since-constraint m9293)]
    (.
     bean9292
     setUnmodifiedSinceConstraint
     (com.palletops.awaze.common/to-date v9294)))
   (clojure.core/when-let
    [v9294 (:modified-since-constraint m9293)]
    (.
     bean9292
     setModifiedSinceConstraint
     (com.palletops.awaze.common/to-date v9294)))
   bean9292))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.SetBucketWebsiteConfigurationRequest set-bucket-website-configuration-request
  [m9299]
  (clojure.core/let
   [arg9301
    nil
    arg9302
    nil
    bean9298
    (new
     com.amazonaws.services.s3.model.SetBucketWebsiteConfigurationRequest
     arg9301
     arg9302)]
   (clojure.core/when-let
    [v9300 (:configuration m9299)]
    (. bean9298 setConfiguration (bucket-website-configuration v9300)))
   (clojure.core/when-let
    [v9300 (:bucket-name m9299)]
    (. bean9298 setBucketName (clojure.core/str v9300)))
   bean9298))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.CopyObjectRequest copy-object-request
  [m9306]
  (clojure.core/let
   [arg9308
    nil
    arg9309
    nil
    arg9310
    nil
    arg9311
    nil
    bean9305
    (new
     com.amazonaws.services.s3.model.CopyObjectRequest
     arg9308
     arg9309
     arg9310
     arg9311)]
   (clojure.core/when-let
    [v9307 (:access-control-list m9306)]
    (. bean9305 setAccessControlList (access-control-list v9307)))
   (clojure.core/when-let
    [v9307 (:storage-class m9306)]
    (. bean9305 setStorageClass (storage-class v9307)))
   (clojure.core/when-let
    [v9307 (:storage-class m9306)]
    (. bean9305 setStorageClass (clojure.core/str v9307)))
   (clojure.core/when-let
    [v9307 (:redirect-location m9306)]
    (. bean9305 setRedirectLocation (clojure.core/str v9307)))
   (clojure.core/when-let
    [v9307 (:canned-access-control-list m9306)]
    (.
     bean9305
     setCannedAccessControlList
     (canned-access-control-list v9307)))
   (clojure.core/when-let
    [v9307 (:source-bucket-name m9306)]
    (. bean9305 setSourceBucketName (clojure.core/str v9307)))
   (clojure.core/when-let
    [v9307 (:source-key m9306)]
    (. bean9305 setSourceKey (clojure.core/str v9307)))
   (clojure.core/when-let
    [v9307 (:source-version-id m9306)]
    (. bean9305 setSourceVersionId (clojure.core/str v9307)))
   (clojure.core/when-let
    [v9307 (:destination-bucket-name m9306)]
    (. bean9305 setDestinationBucketName (clojure.core/str v9307)))
   (clojure.core/when-let
    [v9307 (:destination-key m9306)]
    (. bean9305 setDestinationKey (clojure.core/str v9307)))
   (clojure.core/when-let
    [v9307 (:matching-etag-constraints m9306)]
    (.
     bean9305
     setMatchingETagConstraints
     (clojure.core/map
      (clojure.core/fn [arg9315] (clojure.core/str arg9315))
      v9307)))
   (clojure.core/when-let
    [v9307 (:nonmatching-etag-constraints m9306)]
    (.
     bean9305
     setNonmatchingETagConstraints
     (clojure.core/map
      (clojure.core/fn [arg9316] (clojure.core/str arg9316))
      v9307)))
   (clojure.core/when-let
    [v9307 (:unmodified-since-constraint m9306)]
    (.
     bean9305
     setUnmodifiedSinceConstraint
     (com.palletops.awaze.common/to-date v9307)))
   (clojure.core/when-let
    [v9307 (:modified-since-constraint m9306)]
    (.
     bean9305
     setModifiedSinceConstraint
     (com.palletops.awaze.common/to-date v9307)))
   (clojure.core/when-let
    [v9307 (:new-object-metadata m9306)]
    (. bean9305 setNewObjectMetadata (object-metadata v9307)))
   bean9305))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.BucketCrossOriginConfiguration bucket-cross-origin-configuration
  [m9313]
  (clojure.core/let
   [bean9312
    (new
     com.amazonaws.services.s3.model.BucketCrossOriginConfiguration)]
   (clojure.core/when-let
    [v9314 (:rules m9313)]
    (.
     bean9312
     setRules
     (clojure.core/map
      (clojure.core/fn [arg9320] (corsrule arg9320))
      v9314)))
   bean9312))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.BucketTaggingConfiguration bucket-tagging-configuration
  [m9318]
  (clojure.core/let
   [bean9317
    (new com.amazonaws.services.s3.model.BucketTaggingConfiguration)]
   (clojure.core/when-let
    [v9319 (:tag-sets m9318)]
    (.
     bean9317
     setTagSets
     (clojure.core/map
      (clojure.core/fn [arg9324] (tag-set arg9324))
      v9319)))
   bean9317))
 (clojure.core/defn
  ^com.amazonaws.services.s3.S3ClientOptions s3client-options
  [m9322]
  (clojure.core/let
   [bean9321 (new com.amazonaws.services.s3.S3ClientOptions)]
   (clojure.core/when-let
    [v9323 (:path-style-access m9322)]
    (. bean9321 setPathStyleAccess (clojure.core/boolean v9323)))
   bean9321))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.RestoreObjectRequest restore-object-request
  [m9326]
  (clojure.core/let
   [arg9328
    nil
    arg9329
    nil
    bean9325
    (new
     com.amazonaws.services.s3.model.RestoreObjectRequest
     arg9328
     arg9329)]
   (clojure.core/when-let
    [v9327 (:key m9326)]
    (. bean9325 setKey (clojure.core/str v9327)))
   (clojure.core/when-let
    [v9327 (:bucket-name m9326)]
    (. bean9325 setBucketName (clojure.core/str v9327)))
   (clojure.core/when-let
    [v9327 (:expiration-in-days m9326)]
    (. bean9325 setExpirationInDays (clojure.core/int v9327)))
   bean9325))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.DeleteVersionRequest delete-version-request
  [m9331]
  (clojure.core/let
   [arg9333
    nil
    arg9334
    nil
    arg9335
    nil
    bean9330
    (new
     com.amazonaws.services.s3.model.DeleteVersionRequest
     arg9333
     arg9334
     arg9335)]
   (clojure.core/when-let
    [v9332 (:key m9331)]
    (. bean9330 setKey (clojure.core/str v9332)))
   (clojure.core/when-let
    [v9332 (:bucket-name m9331)]
    (. bean9330 setBucketName (clojure.core/str v9332)))
   (clojure.core/when-let
    [v9332 (:version-id m9331)]
    (. bean9330 setVersionId (clojure.core/str v9332)))
   (clojure.core/when-let
    [v9332 (:mfa m9331)]
    (. bean9330 setMfa (multi-factor-authentication v9332)))
   bean9330))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.SetBucketVersioningConfigurationRequest set-bucket-versioning-configuration-request
  [m9337]
  (clojure.core/let
   [arg9339
    nil
    arg9340
    nil
    bean9336
    (new
     com.amazonaws.services.s3.model.SetBucketVersioningConfigurationRequest
     arg9339
     arg9340)]
   (clojure.core/when-let
    [v9338 (:bucket-name m9337)]
    (. bean9336 setBucketName (clojure.core/str v9338)))
   (clojure.core/when-let
    [v9338 (:mfa m9337)]
    (. bean9336 setMfa (multi-factor-authentication v9338)))
   (clojure.core/when-let
    [v9338 (:versioning-configuration m9337)]
    (.
     bean9336
     setVersioningConfiguration
     (bucket-versioning-configuration v9338)))
   bean9336))
 (clojure.core/defn
  ^com.amazonaws.handlers.RequestHandler request-handler
  [m9342]
  (throw
   (clojure.core/ex-info
    "Trying to construct an interface"
    {:type "com.amazonaws.handlers.RequestHandler", :value m9342})))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.CreateBucketRequest create-bucket-request
  [m9345]
  (clojure.core/let
   [arg9347
    nil
    bean9344
    (new com.amazonaws.services.s3.model.CreateBucketRequest arg9347)]
   (clojure.core/when-let
    [v9346 (:region m9345)]
    (. bean9344 setRegion (clojure.core/str v9346)))
   (clojure.core/when-let
    [v9346 (:bucket-name m9345)]
    (. bean9344 setBucketName (clojure.core/str v9346)))
   (clojure.core/when-let
    [v9346 (:access-control-list m9345)]
    (. bean9344 setAccessControlList (access-control-list v9346)))
   (clojure.core/when-let
    [v9346 (:canned-acl m9345)]
    (. bean9344 setCannedAcl (canned-access-control-list v9346)))
   bean9344))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.Region region
  [m9349]
  (java.lang.Enum/valueOf
   com.amazonaws.services.s3.model.Region
   (clojure.core/name m9349)))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.ObjectListing object-listing
  [m9352]
  (clojure.core/let
   [bean9351 (new com.amazonaws.services.s3.model.ObjectListing)]
   (clojure.core/when-let
    [v9353 (:marker m9352)]
    (. bean9351 setMarker (clojure.core/str v9353)))
   (clojure.core/when-let
    [v9353 (:prefix m9352)]
    (. bean9351 setPrefix (clojure.core/str v9353)))
   (clojure.core/when-let
    [v9353 (:next-marker m9352)]
    (. bean9351 setNextMarker (clojure.core/str v9353)))
   (clojure.core/when-let
    [v9353 (:bucket-name m9352)]
    (. bean9351 setBucketName (clojure.core/str v9353)))
   (clojure.core/when-let
    [v9353 (:delimiter m9352)]
    (. bean9351 setDelimiter (clojure.core/str v9353)))
   (clojure.core/when-let
    [v9353 (:max-keys m9352)]
    (. bean9351 setMaxKeys (clojure.core/int v9353)))
   (clojure.core/when-let
    [v9353 (:truncated m9352)]
    (. bean9351 setTruncated (clojure.core/boolean v9353)))
   (clojure.core/when-let
    [v9353 (:common-prefixes m9352)]
    (.
     bean9351
     setCommonPrefixes
     (clojure.core/map
      (clojure.core/fn [arg9360] (clojure.core/str arg9360))
      v9353)))
   bean9351))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.PutObjectRequest put-object-request
  [m9355]
  (clojure.core/let
   [^java.lang.String arg9357
    nil
    ^java.lang.String arg9358
    nil
    ^java.lang.String arg9359
    nil
    bean9354
    (new
     com.amazonaws.services.s3.model.PutObjectRequest
     ^java.lang.String arg9357
     ^java.lang.String arg9358
     ^java.lang.String arg9359)]
   (clojure.core/when-let
    [v9356 (:file m9355)]
    (. bean9354 setFile (clojure.java.io/file v9356)))
   (clojure.core/when-let
    [v9356 (:key m9355)]
    (. bean9354 setKey (clojure.core/str v9356)))
   (clojure.core/when-let
    [v9356 (:bucket-name m9355)]
    (. bean9354 setBucketName (clojure.core/str v9356)))
   (clojure.core/when-let
    [v9356 (:input-stream m9355)]
    (. bean9354 setInputStream (clojure.java.io/input-stream v9356)))
   (clojure.core/when-let
    [v9356 (:progress-listener m9355)]
    (. bean9354 setProgressListener (progress-listener v9356)))
   (clojure.core/when-let
    [v9356 (:general-progress-listener m9355)]
    (. bean9354 setGeneralProgressListener (progress-listener v9356)))
   (clojure.core/when-let
    [v9356 (:access-control-list m9355)]
    (. bean9354 setAccessControlList (access-control-list v9356)))
   (clojure.core/when-let
    [v9356 (:storage-class m9355)]
    (. bean9354 setStorageClass (storage-class v9356)))
   (clojure.core/when-let
    [v9356 (:storage-class m9355)]
    (. bean9354 setStorageClass (clojure.core/str v9356)))
   (clojure.core/when-let
    [v9356 (:redirect-location m9355)]
    (. bean9354 setRedirectLocation (clojure.core/str v9356)))
   (clojure.core/when-let
    [v9356 (:canned-acl m9355)]
    (. bean9354 setCannedAcl (canned-access-control-list v9356)))
   (clojure.core/when-let
    [v9356 (:metadata m9355)]
    (. bean9354 setMetadata (object-metadata v9356)))
   bean9354))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.GetBucketPolicyRequest get-bucket-policy-request
  [m9362]
  (clojure.core/let
   [arg9364
    nil
    bean9361
    (new
     com.amazonaws.services.s3.model.GetBucketPolicyRequest
     arg9364)]
   (clojure.core/when-let
    [v9363 (:bucket-name m9362)]
    (. bean9361 setBucketName (clojure.core/str v9363)))
   bean9361))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.ListObjectsRequest list-objects-request
  [m9366]
  (clojure.core/let
   [bean9365 (new com.amazonaws.services.s3.model.ListObjectsRequest)]
   (clojure.core/when-let
    [v9367 (:marker m9366)]
    (. bean9365 setMarker (clojure.core/str v9367)))
   (clojure.core/when-let
    [v9367 (:prefix m9366)]
    (. bean9365 setPrefix (clojure.core/str v9367)))
   (clojure.core/when-let
    [v9367 (:bucket-name m9366)]
    (. bean9365 setBucketName (clojure.core/str v9367)))
   (clojure.core/when-let
    [v9367 (:delimiter m9366)]
    (. bean9365 setDelimiter (clojure.core/str v9367)))
   (clojure.core/when-let
    [v9367 (:max-keys m9366)]
    (. bean9365 setMaxKeys (clojure.core/int v9367)))
   bean9365))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.AbortMultipartUploadRequest abort-multipart-upload-request
  [m9369]
  (clojure.core/let
   [arg9371
    nil
    arg9372
    nil
    arg9373
    nil
    bean9368
    (new
     com.amazonaws.services.s3.model.AbortMultipartUploadRequest
     arg9371
     arg9372
     arg9373)]
   (clojure.core/when-let
    [v9370 (:key m9369)]
    (. bean9368 setKey (clojure.core/str v9370)))
   (clojure.core/when-let
    [v9370 (:bucket-name m9369)]
    (. bean9368 setBucketName (clojure.core/str v9370)))
   (clojure.core/when-let
    [v9370 (:upload-id m9369)]
    (. bean9368 setUploadId (clojure.core/str v9370)))
   bean9368))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.UploadPartRequest upload-part-request
  [m9375]
  (clojure.core/let
   [bean9374 (new com.amazonaws.services.s3.model.UploadPartRequest)]
   (clojure.core/when-let
    [v9376 (:file m9375)]
    (. bean9374 setFile (clojure.java.io/file v9376)))
   (clojure.core/when-let
    [v9376 (:key m9375)]
    (. bean9374 setKey (clojure.core/str v9376)))
   (clojure.core/when-let
    [v9376 (:bucket-name m9375)]
    (. bean9374 setBucketName (clojure.core/str v9376)))
   (clojure.core/when-let
    [v9376 (:part-number m9375)]
    (. bean9374 setPartNumber (clojure.core/int v9376)))
   (clojure.core/when-let
    [v9376 (:input-stream m9375)]
    (. bean9374 setInputStream (clojure.java.io/input-stream v9376)))
   (clojure.core/when-let
    [v9376 (:upload-id m9375)]
    (. bean9374 setUploadId (clojure.core/str v9376)))
   (clojure.core/when-let
    [v9376 (:part-size m9375)]
    (. bean9374 setPartSize (clojure.core/long v9376)))
   (clojure.core/when-let
    [v9376 (:md5digest m9375)]
    (. bean9374 setMd5Digest (clojure.core/str v9376)))
   (clojure.core/when-let
    [v9376 (:file-offset m9375)]
    (. bean9374 setFileOffset (clojure.core/long v9376)))
   (clojure.core/when-let
    [v9376 (:progress-listener m9375)]
    (. bean9374 setProgressListener (progress-listener v9376)))
   (clojure.core/when-let
    [v9376 (:last-part m9375)]
    (. bean9374 setLastPart (clojure.core/boolean v9376)))
   (clojure.core/when-let
    [v9376 (:general-progress-listener m9375)]
    (. bean9374 setGeneralProgressListener (progress-listener v9376)))
   bean9374))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.CompleteMultipartUploadRequest complete-multipart-upload-request
  [m9378]
  (clojure.core/let
   [arg9380
    nil
    arg9381
    nil
    arg9382
    nil
    arg9383
    nil
    bean9377
    (new
     com.amazonaws.services.s3.model.CompleteMultipartUploadRequest
     arg9380
     arg9381
     arg9382
     arg9383)]
   (clojure.core/when-let
    [v9379 (:key m9378)]
    (. bean9377 setKey (clojure.core/str v9379)))
   (clojure.core/when-let
    [v9379 (:bucket-name m9378)]
    (. bean9377 setBucketName (clojure.core/str v9379)))
   (clojure.core/when-let
    [v9379 (:upload-id m9378)]
    (. bean9377 setUploadId (clojure.core/str v9379)))
   (clojure.core/when-let
    [v9379 (:part-etags m9378)]
    (.
     bean9377
     setPartETags
     (clojure.core/map
      (clojure.core/fn [arg9387] (part-etag arg9387))
      v9379)))
   bean9377))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.ListVersionsRequest list-versions-request
  [m9385]
  (clojure.core/let
   [bean9384
    (new com.amazonaws.services.s3.model.ListVersionsRequest)]
   (clojure.core/when-let
    [v9386 (:max-results m9385)]
    (. bean9384 setMaxResults (clojure.core/int v9386)))
   (clojure.core/when-let
    [v9386 (:prefix m9385)]
    (. bean9384 setPrefix (clojure.core/str v9386)))
   (clojure.core/when-let
    [v9386 (:bucket-name m9385)]
    (. bean9384 setBucketName (clojure.core/str v9386)))
   (clojure.core/when-let
    [v9386 (:delimiter m9385)]
    (. bean9384 setDelimiter (clojure.core/str v9386)))
   (clojure.core/when-let
    [v9386 (:key-marker m9385)]
    (. bean9384 setKeyMarker (clojure.core/str v9386)))
   (clojure.core/when-let
    [v9386 (:version-id-marker m9385)]
    (. bean9384 setVersionIdMarker (clojure.core/str v9386)))
   bean9384))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.DeleteBucketWebsiteConfigurationRequest delete-bucket-website-configuration-request
  [m9389]
  (clojure.core/let
   [arg9391
    nil
    bean9388
    (new
     com.amazonaws.services.s3.model.DeleteBucketWebsiteConfigurationRequest
     arg9391)]
   (clojure.core/when-let
    [v9390 (:bucket-name m9389)]
    (. bean9388 setBucketName (clojure.core/str v9390)))
   bean9388))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.ListMultipartUploadsRequest list-multipart-uploads-request
  [m9393]
  (clojure.core/let
   [arg9395
    nil
    bean9392
    (new
     com.amazonaws.services.s3.model.ListMultipartUploadsRequest
     arg9395)]
   (clojure.core/when-let
    [v9394 (:prefix m9393)]
    (. bean9392 setPrefix (clojure.core/str v9394)))
   (clojure.core/when-let
    [v9394 (:bucket-name m9393)]
    (. bean9392 setBucketName (clojure.core/str v9394)))
   (clojure.core/when-let
    [v9394 (:delimiter m9393)]
    (. bean9392 setDelimiter (clojure.core/str v9394)))
   (clojure.core/when-let
    [v9394 (:key-marker m9393)]
    (. bean9392 setKeyMarker (clojure.core/str v9394)))
   (clojure.core/when-let
    [v9394 (:max-uploads m9393)]
    (. bean9392 setMaxUploads (clojure.core/int v9394)))
   (clojure.core/when-let
    [v9394 (:upload-id-marker m9393)]
    (. bean9392 setUploadIdMarker (clojure.core/str v9394)))
   bean9392))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.BucketLifecycleConfiguration bucket-lifecycle-configuration
  [m9397]
  (clojure.core/let
   [bean9396
    (new com.amazonaws.services.s3.model.BucketLifecycleConfiguration)]
   (clojure.core/when-let
    [v9398 (:rules m9397)]
    (.
     bean9396
     setRules
     (clojure.core/map
      (clojure.core/fn
       [arg9404]
       (bucket-lifecycle-configuration-rule arg9404))
      v9398)))
   bean9396))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.GetObjectMetadataRequest get-object-metadata-request
  [m9400]
  (clojure.core/let
   [arg9402
    nil
    arg9403
    nil
    bean9399
    (new
     com.amazonaws.services.s3.model.GetObjectMetadataRequest
     arg9402
     arg9403)]
   (clojure.core/when-let
    [v9401 (:key m9400)]
    (. bean9399 setKey (clojure.core/str v9401)))
   (clojure.core/when-let
    [v9401 (:bucket-name m9400)]
    (. bean9399 setBucketName (clojure.core/str v9401)))
   (clojure.core/when-let
    [v9401 (:version-id m9400)]
    (. bean9399 setVersionId (clojure.core/str v9401)))
   bean9399))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.DeleteBucketPolicyRequest delete-bucket-policy-request
  [m9406]
  (clojure.core/let
   [arg9408
    nil
    bean9405
    (new
     com.amazonaws.services.s3.model.DeleteBucketPolicyRequest
     arg9408)]
   (clojure.core/when-let
    [v9407 (:bucket-name m9406)]
    (. bean9405 setBucketName (clojure.core/str v9407)))
   bean9405))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.GetBucketWebsiteConfigurationRequest get-bucket-website-configuration-request
  [m9410]
  (clojure.core/let
   [arg9412
    nil
    bean9409
    (new
     com.amazonaws.services.s3.model.GetBucketWebsiteConfigurationRequest
     arg9412)]
   (clojure.core/when-let
    [v9411 (:bucket-name m9410)]
    (. bean9409 setBucketName (clojure.core/str v9411)))
   bean9409))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.DeleteBucketRequest delete-bucket-request
  [m9414]
  (clojure.core/let
   [arg9416
    nil
    bean9413
    (new com.amazonaws.services.s3.model.DeleteBucketRequest arg9416)]
   (clojure.core/when-let
    [v9415 (:bucket-name m9414)]
    (. bean9413 setBucketName (clojure.core/str v9415)))
   bean9413))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.DeleteObjectRequest delete-object-request
  [m9418]
  (clojure.core/let
   [arg9420
    nil
    arg9421
    nil
    bean9417
    (new
     com.amazonaws.services.s3.model.DeleteObjectRequest
     arg9420
     arg9421)]
   (clojure.core/when-let
    [v9419 (:key m9418)]
    (. bean9417 setKey (clojure.core/str v9419)))
   (clojure.core/when-let
    [v9419 (:bucket-name m9418)]
    (. bean9417 setBucketName (clojure.core/str v9419)))
   bean9417))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.CopyPartRequest copy-part-request
  [m9423]
  (clojure.core/let
   [bean9422 (new com.amazonaws.services.s3.model.CopyPartRequest)]
   (clojure.core/when-let
    [v9424 (:part-number m9423)]
    (. bean9422 setPartNumber (clojure.core/int v9424)))
   (clojure.core/when-let
    [v9424 (:upload-id m9423)]
    (. bean9422 setUploadId (clojure.core/str v9424)))
   (clojure.core/when-let
    [v9424 (:source-bucket-name m9423)]
    (. bean9422 setSourceBucketName (clojure.core/str v9424)))
   (clojure.core/when-let
    [v9424 (:source-key m9423)]
    (. bean9422 setSourceKey (clojure.core/str v9424)))
   (clojure.core/when-let
    [v9424 (:source-version-id m9423)]
    (. bean9422 setSourceVersionId (clojure.core/str v9424)))
   (clojure.core/when-let
    [v9424 (:destination-bucket-name m9423)]
    (. bean9422 setDestinationBucketName (clojure.core/str v9424)))
   (clojure.core/when-let
    [v9424 (:destination-key m9423)]
    (. bean9422 setDestinationKey (clojure.core/str v9424)))
   (clojure.core/when-let
    [v9424 (:first-byte m9423)]
    (. bean9422 setFirstByte (clojure.core/long v9424)))
   (clojure.core/when-let
    [v9424 (:last-byte m9423)]
    (. bean9422 setLastByte (clojure.core/long v9424)))
   (clojure.core/when-let
    [v9424 (:matching-etag-constraints m9423)]
    (.
     bean9422
     setMatchingETagConstraints
     (clojure.core/map
      (clojure.core/fn [arg9430] (clojure.core/str arg9430))
      v9424)))
   (clojure.core/when-let
    [v9424 (:nonmatching-etag-constraints m9423)]
    (.
     bean9422
     setNonmatchingETagConstraints
     (clojure.core/map
      (clojure.core/fn [arg9431] (clojure.core/str arg9431))
      v9424)))
   (clojure.core/when-let
    [v9424 (:unmodified-since-constraint m9423)]
    (.
     bean9422
     setUnmodifiedSinceConstraint
     (com.palletops.awaze.common/to-date v9424)))
   (clojure.core/when-let
    [v9424 (:modified-since-constraint m9423)]
    (.
     bean9422
     setModifiedSinceConstraint
     (com.palletops.awaze.common/to-date v9424)))
   bean9422))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.InitiateMultipartUploadRequest initiate-multipart-upload-request
  [m9426]
  (clojure.core/let
   [arg9428
    nil
    arg9429
    nil
    bean9425
    (new
     com.amazonaws.services.s3.model.InitiateMultipartUploadRequest
     arg9428
     arg9429)]
   (clojure.core/when-let
    [v9427 (:key m9426)]
    (. bean9425 setKey (clojure.core/str v9427)))
   (clojure.core/when-let
    [v9427 (:bucket-name m9426)]
    (. bean9425 setBucketName (clojure.core/str v9427)))
   (clojure.core/when-let
    [v9427 (:canned-acl m9426)]
    (. bean9425 setCannedACL (canned-access-control-list v9427)))
   (clojure.core/when-let
    [v9427 (:access-control-list m9426)]
    (. bean9425 setAccessControlList (access-control-list v9427)))
   (clojure.core/when-let
    [v9427 (:storage-class m9426)]
    (. bean9425 setStorageClass (storage-class v9427)))
   (clojure.core/when-let
    [v9427 (:object-metadata m9426)]
    (. bean9425 setObjectMetadata (object-metadata v9427)))
   (clojure.core/when-let
    [v9427 (:redirect-location m9426)]
    (. bean9425 setRedirectLocation (clojure.core/str v9427)))
   bean9425))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.SetBucketPolicyRequest set-bucket-policy-request
  [m9433]
  (clojure.core/let
   [arg9435
    nil
    arg9436
    nil
    bean9432
    (new
     com.amazonaws.services.s3.model.SetBucketPolicyRequest
     arg9435
     arg9436)]
   (clojure.core/when-let
    [v9434 (:bucket-name m9433)]
    (. bean9432 setBucketName (clojure.core/str v9434)))
   (clojure.core/when-let
    [v9434 (:policy-text m9433)]
    (. bean9432 setPolicyText (clojure.core/str v9434)))
   bean9432))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.GeneratePresignedUrlRequest generate-presigned-url-request
  [m9438]
  (clojure.core/let
   [arg9440
    nil
    arg9441
    nil
    bean9437
    (new
     com.amazonaws.services.s3.model.GeneratePresignedUrlRequest
     arg9440
     arg9441)]
   (clojure.core/when-let
    [v9439 (:method m9438)]
    (. bean9437 setMethod (http-method v9439)))
   (clojure.core/when-let
    [v9439 (:content-type m9438)]
    (. bean9437 setContentType (clojure.core/str v9439)))
   (clojure.core/when-let
    [v9439 (:key m9438)]
    (. bean9437 setKey (clojure.core/str v9439)))
   (clojure.core/when-let
    [v9439 (:bucket-name m9438)]
    (. bean9437 setBucketName (clojure.core/str v9439)))
   (clojure.core/when-let
    [v9439 (:expiration m9438)]
    (.
     bean9437
     setExpiration
     (com.palletops.awaze.common/to-date v9439)))
   (clojure.core/when-let
    [v9439 (:response-headers m9438)]
    (. bean9437 setResponseHeaders (response-header-overrides v9439)))
   bean9437))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.ListPartsRequest list-parts-request
  [m9443]
  (clojure.core/let
   [arg9445
    nil
    arg9446
    nil
    arg9447
    nil
    bean9442
    (new
     com.amazonaws.services.s3.model.ListPartsRequest
     arg9445
     arg9446
     arg9447)]
   (clojure.core/when-let
    [v9444 (:key m9443)]
    (. bean9442 setKey (clojure.core/str v9444)))
   (clojure.core/when-let
    [v9444 (:bucket-name m9443)]
    (. bean9442 setBucketName (clojure.core/str v9444)))
   (clojure.core/when-let
    [v9444 (:upload-id m9443)]
    (. bean9442 setUploadId (clojure.core/str v9444)))
   (clojure.core/when-let
    [v9444 (:max-parts m9443)]
    (. bean9442 setMaxParts (clojure.core/int v9444)))
   (clojure.core/when-let
    [v9444 (:part-number-marker m9443)]
    (. bean9442 setPartNumberMarker (clojure.core/int v9444)))
   bean9442))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.ListBucketsRequest list-buckets-request
  [m9449]
  (clojure.core/let
   [bean9448 (new com.amazonaws.services.s3.model.ListBucketsRequest)]
   bean9448))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.SetBucketLoggingConfigurationRequest set-bucket-logging-configuration-request
  [m9452]
  (clojure.core/let
   [arg9454
    nil
    arg9455
    nil
    bean9451
    (new
     com.amazonaws.services.s3.model.SetBucketLoggingConfigurationRequest
     arg9454
     arg9455)]
   (clojure.core/when-let
    [v9453 (:bucket-name m9452)]
    (. bean9451 setBucketName (clojure.core/str v9453)))
   (clojure.core/when-let
    [v9453 (:logging-configuration m9452)]
    (.
     bean9451
     setLoggingConfiguration
     (bucket-logging-configuration v9453)))
   bean9451))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.GetBucketAclRequest get-bucket-acl-request
  [m9457]
  (clojure.core/let
   [arg9459
    nil
    bean9456
    (new com.amazonaws.services.s3.model.GetBucketAclRequest arg9459)]
   bean9456))
 (clojure.core/defn
  ^com.amazonaws.services.s3.model.VersionListing version-listing
  [m9461]
  (clojure.core/let
   [bean9460 (new com.amazonaws.services.s3.model.VersionListing)]
   (clojure.core/when-let
    [v9462 (:prefix m9461)]
    (. bean9460 setPrefix (clojure.core/str v9462)))
   (clojure.core/when-let
    [v9462 (:bucket-name m9461)]
    (. bean9460 setBucketName (clojure.core/str v9462)))
   (clojure.core/when-let
    [v9462 (:delimiter m9461)]
    (. bean9460 setDelimiter (clojure.core/str v9462)))
   (clojure.core/when-let
    [v9462 (:key-marker m9461)]
    (. bean9460 setKeyMarker (clojure.core/str v9462)))
   (clojure.core/when-let
    [v9462 (:version-id-marker m9461)]
    (. bean9460 setVersionIdMarker (clojure.core/str v9462)))
   (clojure.core/when-let
    [v9462 (:max-keys m9461)]
    (. bean9460 setMaxKeys (clojure.core/int v9462)))
   (clojure.core/when-let
    [v9462 (:truncated m9461)]
    (. bean9460 setTruncated (clojure.core/boolean v9462)))
   (clojure.core/when-let
    [v9462 (:version-summaries m9461)]
    (.
     bean9460
     setVersionSummaries
     (clojure.core/map
      (clojure.core/fn [arg9463] (s3version-summary arg9463))
      v9462)))
   (clojure.core/when-let
    [v9462 (:common-prefixes m9461)]
    (.
     bean9460
     setCommonPrefixes
     (clojure.core/map
      (clojure.core/fn [arg9464] (clojure.core/str arg9464))
      v9462)))
   (clojure.core/when-let
    [v9462 (:next-key-marker m9461)]
    (. bean9460 setNextKeyMarker (clojure.core/str v9462)))
   (clojure.core/when-let
    [v9462 (:next-version-id-marker m9461)]
    (. bean9460 setNextVersionIdMarker (clojure.core/str v9462)))
   bean9460))
 (clojure.core/defmulti
  s3
  (clojure.core/fn s3 [m__1641__auto__] (:fn m__1641__auto__)))
 (do
  (clojure.core/defmethod
   s3
   :get-bucket-versioning-configuration
   [m9465]
   (clojure.core/let
    [credentials9466 (:credentials m9465) args9467 (:args m9465)]
    (clojure.core/let
     [^com.amazonaws.services.s3.AmazonS3Client client9468
      (com.palletops.awaze.common/aws-client :s3 credentials9466)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client9468
       getBucketVersioningConfiguration
       (clojure.core/str (clojure.core/nth args9467 0)))))))
  (clojure.core/defn
   get-bucket-versioning-configuration-map
   {:arglists (quote [[credentials string-0]]),
    :doc "Generate map for getBucketVersioningConfiguration"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :s3,
     :fn :get-bucket-versioning-configuration,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   get-bucket-versioning-configuration
   {:arglists (quote [[credentials string-0]]),
    :doc "Call getBucketVersioningConfiguration"}
   [credentials9470 & args9471]
   (clojure.core/let
    [^com.amazonaws.services.s3.AmazonS3Client client9472
     (com.palletops.awaze.common/aws-client :s3 credentials9470)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.s3.AmazonS3Client client9472
      getBucketVersioningConfiguration
      (clojure.core/str (clojure.core/nth args9471 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :delete-objects
   [m9473]
   (clojure.core/let
    [credentials9474 (:credentials m9473) args9475 (:args m9473)]
    (clojure.core/let
     [^com.amazonaws.services.s3.AmazonS3Client client9476
      (com.palletops.awaze.common/aws-client :s3 credentials9474)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client9476
       deleteObjects
       (delete-objects-request (clojure.core/nth args9475 0)))))))
  (clojure.core/defn
   delete-objects-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         quiet
                         mfa
                         keys
                         bucket-name]}]]),
    :doc "Generate map for deleteObjects"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :s3,
     :fn :delete-objects,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   delete-objects
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         quiet
                         mfa
                         keys
                         bucket-name]}]]),
    :doc "Call deleteObjects"}
   [credentials9479 & args9480]
   (clojure.core/let
    [^com.amazonaws.services.s3.AmazonS3Client client9482
     (com.palletops.awaze.common/aws-client :s3 credentials9479)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.s3.AmazonS3Client client9482
      deleteObjects
      (delete-objects-request (clojure.core/nth args9480 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :set-bucket-acl
   [m9483]
   (clojure.core/let
    [credentials9484 (:credentials m9483) args9485 (:args m9483)]
    (clojure.core/let
     [^com.amazonaws.services.s3.AmazonS3Client client9486
      (com.palletops.awaze.common/aws-client :s3 credentials9484)]
     (clojure.core/case
      (clojure.core/count args9485)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.s3.AmazonS3Client client9486
        setBucketAcl
        (set-bucket-acl-request (clojure.core/nth args9485 0))))
      2
      (clojure.core/let
       [a__1584__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^java.lang.String a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args9485 0))
          ^com.amazonaws.services.s3.model.CannedAccessControlList b
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.CannedAccessControlList
           (clojure.core/nth args9485 1))]
         (clojure.core/reset! a__1584__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
           ^com.amazonaws.services.s3.AmazonS3Client client9486
           setBucketAcl
           a
           b)))
        (catch
         java.lang.Exception
         e__1585__auto__
         (if
          (clojure.core/deref a__1584__auto__)
          (throw e__1585__auto__)
          (clojure.core/let
           [a__1584__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^java.lang.String a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args9485 0))
              ^com.amazonaws.services.s3.model.AccessControlList b
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.s3.model.AccessControlList
               (clojure.core/nth args9485 1))]
             (clojure.core/reset! a__1584__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
               ^com.amazonaws.services.s3.AmazonS3Client client9486
               setBucketAcl
               a
               b)))
            (catch
             java.lang.Exception
             e__1585__auto__
             (if
              (clojure.core/deref a__1584__auto__)
              (throw e__1585__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "setBucketAcl")
                {:args args9485}))))))))))))))
  (clojure.core/defn
   set-bucket-acl-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         canned-acl
                         bucket-name
                         acl]}]
                [credentials string-0 canned-access-control-list-1]
                [credentials string-0 {:keys [owner grants]}]]),
    :doc "Generate map for setBucketAcl, setBucketAcl, setBucketAcl"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :s3,
     :fn :set-bucket-acl,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a b]
    {:args [a b],
     :client :s3,
     :fn :set-bucket-acl,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   set-bucket-acl
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         canned-acl
                         bucket-name
                         acl]}]
                [credentials string-0 canned-access-control-list-1]
                [credentials string-0 {:keys [owner grants]}]]),
    :doc "Call setBucketAcl, setBucketAcl, setBucketAcl"}
   [credentials9490 & args9491]
   (clojure.core/let
    [^com.amazonaws.services.s3.AmazonS3Client client9494
     (com.palletops.awaze.common/aws-client :s3 credentials9490)]
    (clojure.core/case
     (clojure.core/count args9491)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client9494
       setBucketAcl
       (set-bucket-acl-request (clojure.core/nth args9491 0))))
     2
     (clojure.core/let
      [a__1584__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^java.lang.String a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args9491 0))
         ^com.amazonaws.services.s3.model.CannedAccessControlList b
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.CannedAccessControlList
          (clojure.core/nth args9491 1))]
        (clojure.core/reset! a__1584__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
          ^com.amazonaws.services.s3.AmazonS3Client client9494
          setBucketAcl
          a
          b)))
       (catch
        java.lang.Exception
        e__1585__auto__
        (if
         (clojure.core/deref a__1584__auto__)
         (throw e__1585__auto__)
         (clojure.core/let
          [a__1584__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^java.lang.String a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args9491 0))
             ^com.amazonaws.services.s3.model.AccessControlList b
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.s3.model.AccessControlList
              (clojure.core/nth args9491 1))]
            (clojure.core/reset! a__1584__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
              ^com.amazonaws.services.s3.AmazonS3Client client9494
              setBucketAcl
              a
              b)))
           (catch
            java.lang.Exception
            e__1585__auto__
            (if
             (clojure.core/deref a__1584__auto__)
             (throw e__1585__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "setBucketAcl")
               {:args args9491}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :get-bucket-location
   [m9495]
   (clojure.core/let
    [credentials9496 (:credentials m9495) args9497 (:args m9495)]
    (clojure.core/let
     [^com.amazonaws.services.s3.AmazonS3Client client9498
      (com.palletops.awaze.common/aws-client :s3 credentials9496)]
     (clojure.core/case
      (clojure.core/count args9497)
      1
      (clojure.core/let
       [a__1584__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^com.amazonaws.services.s3.model.GetBucketLocationRequest a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.GetBucketLocationRequest
           (clojure.core/nth args9497 0))]
         (clojure.core/reset! a__1584__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
           ^com.amazonaws.services.s3.AmazonS3Client client9498
           getBucketLocation
           a)))
        (catch
         java.lang.Exception
         e__1585__auto__
         (if
          (clojure.core/deref a__1584__auto__)
          (throw e__1585__auto__)
          (clojure.core/let
           [a__1584__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^java.lang.String a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args9497 0))]
             (clojure.core/reset! a__1584__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
               ^com.amazonaws.services.s3.AmazonS3Client client9498
               getBucketLocation
               a)))
            (catch
             java.lang.Exception
             e__1585__auto__
             (if
              (clojure.core/deref a__1584__auto__)
              (throw e__1585__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "getBucketLocation")
                {:args args9497}))))))))))))))
  (clojure.core/defn
   get-bucket-location-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector bucket-name]}]
                [credentials string-0]]),
    :doc "Generate map for getBucketLocation, getBucketLocation"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :s3,
     :fn :get-bucket-location,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   get-bucket-location
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector bucket-name]}]
                [credentials string-0]]),
    :doc "Call getBucketLocation, getBucketLocation"}
   [credentials9501 & args9502]
   (clojure.core/let
    [^com.amazonaws.services.s3.AmazonS3Client client9504
     (com.palletops.awaze.common/aws-client :s3 credentials9501)]
    (clojure.core/case
     (clojure.core/count args9502)
     1
     (clojure.core/let
      [a__1584__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^com.amazonaws.services.s3.model.GetBucketLocationRequest a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.GetBucketLocationRequest
          (clojure.core/nth args9502 0))]
        (clojure.core/reset! a__1584__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
          ^com.amazonaws.services.s3.AmazonS3Client client9504
          getBucketLocation
          a)))
       (catch
        java.lang.Exception
        e__1585__auto__
        (if
         (clojure.core/deref a__1584__auto__)
         (throw e__1585__auto__)
         (clojure.core/let
          [a__1584__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^java.lang.String a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args9502 0))]
            (clojure.core/reset! a__1584__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
              ^com.amazonaws.services.s3.AmazonS3Client client9504
              getBucketLocation
              a)))
           (catch
            java.lang.Exception
            e__1585__auto__
            (if
             (clojure.core/deref a__1584__auto__)
             (throw e__1585__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "getBucketLocation")
               {:args args9502}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :set-bucket-notification-configuration
   [m9505]
   (clojure.core/let
    [credentials9506 (:credentials m9505) args9507 (:args m9505)]
    (clojure.core/let
     [^com.amazonaws.services.s3.AmazonS3Client client9508
      (com.palletops.awaze.common/aws-client :s3 credentials9506)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client9508
       setBucketNotificationConfiguration
       (clojure.core/str (clojure.core/nth args9507 0))
       (bucket-notification-configuration
        (clojure.core/nth args9507 1)))))))
  (clojure.core/defn
   set-bucket-notification-configuration-map
   {:arglists (quote
               [[credentials string-0 {:keys [topic-configurations]}]]),
    :doc "Generate map for setBucketNotificationConfiguration"}
   ([credentials__1609__auto__ a b]
    {:args [a b],
     :client :s3,
     :fn :set-bucket-notification-configuration,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   set-bucket-notification-configuration
   {:arglists (quote
               [[credentials string-0 {:keys [topic-configurations]}]]),
    :doc "Call setBucketNotificationConfiguration"}
   [credentials9510 & args9511]
   (clojure.core/let
    [^com.amazonaws.services.s3.AmazonS3Client client9512
     (com.palletops.awaze.common/aws-client :s3 credentials9510)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.s3.AmazonS3Client client9512
      setBucketNotificationConfiguration
      (clojure.core/str (clojure.core/nth args9511 0))
      (bucket-notification-configuration
       (clojure.core/nth args9511 1)))))))
 (do
  (clojure.core/defmethod
   s3
   :get-object
   [m9513]
   (clojure.core/let
    [credentials9514 (:credentials m9513) args9515 (:args m9513)]
    (clojure.core/let
     [^com.amazonaws.services.s3.AmazonS3Client client9516
      (com.palletops.awaze.common/aws-client :s3 credentials9514)]
     (clojure.core/case
      (clojure.core/count args9515)
      2
      (clojure.core/let
       [a__1584__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^java.lang.String a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args9515 0))
          ^java.lang.String b
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args9515 1))]
         (clojure.core/reset! a__1584__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
           ^com.amazonaws.services.s3.AmazonS3Client client9516
           getObject
           a
           b)))
        (catch
         java.lang.Exception
         e__1585__auto__
         (if
          (clojure.core/deref a__1584__auto__)
          (throw e__1585__auto__)
          (clojure.core/let
           [a__1584__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^com.amazonaws.services.s3.model.GetObjectRequest a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.s3.model.GetObjectRequest
               (clojure.core/nth args9515 0))
              ^java.io.File b
              (com.palletops.awaze.common/coerce-value-form
               java.io.File
               (clojure.core/nth args9515 1))]
             (clojure.core/reset! a__1584__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
               ^com.amazonaws.services.s3.AmazonS3Client client9516
               getObject
               a
               b)))
            (catch
             java.lang.Exception
             e__1585__auto__
             (if
              (clojure.core/deref a__1584__auto__)
              (throw e__1585__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "getObject")
                {:args args9515}))))))))))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.s3.AmazonS3Client client9516
        getObject
        (get-object-request (clojure.core/nth args9515 0))))))))
  (clojure.core/defn
   get-object-map
   {:arglists (quote
               [[credentials string-0 string-1]
                [credentials
                 {:keys [request-metric-collector
                         general-progress-listener
                         response-headers
                         key
                         bucket-name
                         unmodified-since-constraint
                         version-id
                         range
                         modified-since-constraint
                         progress-listener
                         nonmatching-etag-constraints
                         matching-etag-constraints]}
                 file-1]
                [credentials
                 {:keys [request-metric-collector
                         general-progress-listener
                         response-headers
                         key
                         bucket-name
                         unmodified-since-constraint
                         version-id
                         range
                         modified-since-constraint
                         progress-listener
                         nonmatching-etag-constraints
                         matching-etag-constraints]}]]),
    :doc "Generate map for getObject, getObject, getObject"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :s3,
     :fn :get-object,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a b]
    {:args [a b],
     :client :s3,
     :fn :get-object,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   get-object
   {:arglists (quote
               [[credentials string-0 string-1]
                [credentials
                 {:keys [request-metric-collector
                         general-progress-listener
                         response-headers
                         key
                         bucket-name
                         unmodified-since-constraint
                         version-id
                         range
                         modified-since-constraint
                         progress-listener
                         nonmatching-etag-constraints
                         matching-etag-constraints]}
                 file-1]
                [credentials
                 {:keys [request-metric-collector
                         general-progress-listener
                         response-headers
                         key
                         bucket-name
                         unmodified-since-constraint
                         version-id
                         range
                         modified-since-constraint
                         progress-listener
                         nonmatching-etag-constraints
                         matching-etag-constraints]}]]),
    :doc "Call getObject, getObject, getObject"}
   [credentials9522 & args9523]
   (clojure.core/let
    [^com.amazonaws.services.s3.AmazonS3Client client9528
     (com.palletops.awaze.common/aws-client :s3 credentials9522)]
    (clojure.core/case
     (clojure.core/count args9523)
     2
     (clojure.core/let
      [a__1584__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^java.lang.String a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args9523 0))
         ^java.lang.String b
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args9523 1))]
        (clojure.core/reset! a__1584__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
          ^com.amazonaws.services.s3.AmazonS3Client client9528
          getObject
          a
          b)))
       (catch
        java.lang.Exception
        e__1585__auto__
        (if
         (clojure.core/deref a__1584__auto__)
         (throw e__1585__auto__)
         (clojure.core/let
          [a__1584__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^com.amazonaws.services.s3.model.GetObjectRequest a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.s3.model.GetObjectRequest
              (clojure.core/nth args9523 0))
             ^java.io.File b
             (com.palletops.awaze.common/coerce-value-form
              java.io.File
              (clojure.core/nth args9523 1))]
            (clojure.core/reset! a__1584__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
              ^com.amazonaws.services.s3.AmazonS3Client client9528
              getObject
              a
              b)))
           (catch
            java.lang.Exception
            e__1585__auto__
            (if
             (clojure.core/deref a__1584__auto__)
             (throw e__1585__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "getObject")
               {:args args9523}))))))))))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client9528
       getObject
       (get-object-request (clojure.core/nth args9523 0))))))))
 (do
  (clojure.core/defmethod
   s3
   :set-bucket-website-configuration
   [m9529]
   (clojure.core/let
    [credentials9530 (:credentials m9529) args9531 (:args m9529)]
    (clojure.core/let
     [^com.amazonaws.services.s3.AmazonS3Client client9532
      (com.palletops.awaze.common/aws-client :s3 credentials9530)]
     (clojure.core/case
      (clojure.core/count args9531)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.s3.AmazonS3Client client9532
        setBucketWebsiteConfiguration
        (set-bucket-website-configuration-request
         (clojure.core/nth args9531 0))))
      2
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.s3.AmazonS3Client client9532
        setBucketWebsiteConfiguration
        (clojure.core/str (clojure.core/nth args9531 0))
        (bucket-website-configuration (clojure.core/nth args9531 1))))))))
  (clojure.core/defn
   set-bucket-website-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         configuration
                         bucket-name]}]
                [credentials
                 string-0
                 {:keys [routing-rules
                         redirect-all-requests-to
                         index-document-suffix
                         error-document]}]]),
    :doc "Generate map for setBucketWebsiteConfiguration, setBucketWebsiteConfiguration"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :s3,
     :fn :set-bucket-website-configuration,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a b]
    {:args [a b],
     :client :s3,
     :fn :set-bucket-website-configuration,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   set-bucket-website-configuration
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         configuration
                         bucket-name]}]
                [credentials
                 string-0
                 {:keys [routing-rules
                         redirect-all-requests-to
                         index-document-suffix
                         error-document]}]]),
    :doc "Call setBucketWebsiteConfiguration, setBucketWebsiteConfiguration"}
   [credentials9536 & args9537]
   (clojure.core/let
    [^com.amazonaws.services.s3.AmazonS3Client client9540
     (com.palletops.awaze.common/aws-client :s3 credentials9536)]
    (clojure.core/case
     (clojure.core/count args9537)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client9540
       setBucketWebsiteConfiguration
       (set-bucket-website-configuration-request
        (clojure.core/nth args9537 0))))
     2
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client9540
       setBucketWebsiteConfiguration
       (clojure.core/str (clojure.core/nth args9537 0))
       (bucket-website-configuration (clojure.core/nth args9537 1))))))))
 (do
  (clojure.core/defmethod
   s3
   :copy-object
   [m9541]
   (clojure.core/let
    [credentials9542 (:credentials m9541) args9543 (:args m9541)]
    (clojure.core/let
     [^com.amazonaws.services.s3.AmazonS3Client client9544
      (com.palletops.awaze.common/aws-client :s3 credentials9542)]
     (clojure.core/case
      (clojure.core/count args9543)
      4
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.s3.AmazonS3Client client9544
        copyObject
        (clojure.core/str (clojure.core/nth args9543 0))
        (clojure.core/str (clojure.core/nth args9543 1))
        (clojure.core/str (clojure.core/nth args9543 2))
        (clojure.core/str (clojure.core/nth args9543 3))))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.s3.AmazonS3Client client9544
        copyObject
        (copy-object-request (clojure.core/nth args9543 0))))))))
  (clojure.core/defn
   copy-object-map
   {:arglists (quote
               [[credentials string-0 string-1 string-2 string-3]
                [credentials
                 {:keys [source-key
                         request-metric-collector
                         source-bucket-name
                         canned-access-control-list
                         unmodified-since-constraint
                         access-control-list
                         modified-since-constraint
                         redirect-location
                         new-object-metadata
                         nonmatching-etag-constraints
                         destination-key
                         matching-etag-constraints
                         destination-bucket-name
                         source-version-id
                         storage-class]}]]),
    :doc "Generate map for copyObject, copyObject"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :s3,
     :fn :copy-object,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a b c d]
    {:args [a b c d],
     :client :s3,
     :fn :copy-object,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   copy-object
   {:arglists (quote
               [[credentials string-0 string-1 string-2 string-3]
                [credentials
                 {:keys [source-key
                         request-metric-collector
                         source-bucket-name
                         canned-access-control-list
                         unmodified-since-constraint
                         access-control-list
                         modified-since-constraint
                         redirect-location
                         new-object-metadata
                         nonmatching-etag-constraints
                         destination-key
                         matching-etag-constraints
                         destination-bucket-name
                         source-version-id
                         storage-class]}]]),
    :doc "Call copyObject, copyObject"}
   [credentials9550 & args9551]
   (clojure.core/let
    [^com.amazonaws.services.s3.AmazonS3Client client9556
     (com.palletops.awaze.common/aws-client :s3 credentials9550)]
    (clojure.core/case
     (clojure.core/count args9551)
     4
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client9556
       copyObject
       (clojure.core/str (clojure.core/nth args9551 0))
       (clojure.core/str (clojure.core/nth args9551 1))
       (clojure.core/str (clojure.core/nth args9551 2))
       (clojure.core/str (clojure.core/nth args9551 3))))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client9556
       copyObject
       (copy-object-request (clojure.core/nth args9551 0))))))))
 (do
  (clojure.core/defmethod
   s3
   :set-bucket-cross-origin-configuration
   [m9557]
   (clojure.core/let
    [credentials9558 (:credentials m9557) args9559 (:args m9557)]
    (clojure.core/let
     [^com.amazonaws.services.s3.AmazonS3Client client9560
      (com.palletops.awaze.common/aws-client :s3 credentials9558)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client9560
       setBucketCrossOriginConfiguration
       (clojure.core/str (clojure.core/nth args9559 0))
       (bucket-cross-origin-configuration
        (clojure.core/nth args9559 1)))))))
  (clojure.core/defn
   set-bucket-cross-origin-configuration-map
   {:arglists (quote [[credentials string-0 {:keys [rules]}]]),
    :doc "Generate map for setBucketCrossOriginConfiguration"}
   ([credentials__1609__auto__ a b]
    {:args [a b],
     :client :s3,
     :fn :set-bucket-cross-origin-configuration,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   set-bucket-cross-origin-configuration
   {:arglists (quote [[credentials string-0 {:keys [rules]}]]),
    :doc "Call setBucketCrossOriginConfiguration"}
   [credentials9562 & args9563]
   (clojure.core/let
    [^com.amazonaws.services.s3.AmazonS3Client client9564
     (com.palletops.awaze.common/aws-client :s3 credentials9562)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.s3.AmazonS3Client client9564
      setBucketCrossOriginConfiguration
      (clojure.core/str (clojure.core/nth args9563 0))
      (bucket-cross-origin-configuration
       (clojure.core/nth args9563 1)))))))
 (do
  (clojure.core/defmethod
   s3
   :does-bucket-exist
   [m9565]
   (clojure.core/let
    [credentials9566 (:credentials m9565) args9567 (:args m9565)]
    (clojure.core/let
     [^com.amazonaws.services.s3.AmazonS3Client client9568
      (com.palletops.awaze.common/aws-client :s3 credentials9566)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client9568
       doesBucketExist
       (clojure.core/str (clojure.core/nth args9567 0)))))))
  (clojure.core/defn
   does-bucket-exist-map
   {:arglists (quote [[credentials string-0]]),
    :doc "Generate map for doesBucketExist"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :s3,
     :fn :does-bucket-exist,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   does-bucket-exist
   {:arglists (quote [[credentials string-0]]),
    :doc "Call doesBucketExist"}
   [credentials9570 & args9571]
   (clojure.core/let
    [^com.amazonaws.services.s3.AmazonS3Client client9572
     (com.palletops.awaze.common/aws-client :s3 credentials9570)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.s3.AmazonS3Client client9572
      doesBucketExist
      (clojure.core/str (clojure.core/nth args9571 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :change-object-storage-class
   [m9573]
   (clojure.core/let
    [credentials9574 (:credentials m9573) args9575 (:args m9573)]
    (clojure.core/let
     [^com.amazonaws.services.s3.AmazonS3Client client9576
      (com.palletops.awaze.common/aws-client :s3 credentials9574)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client9576
       changeObjectStorageClass
       (clojure.core/str (clojure.core/nth args9575 0))
       (clojure.core/str (clojure.core/nth args9575 1))
       (storage-class (clojure.core/nth args9575 2)))))))
  (clojure.core/defn
   change-object-storage-class-map
   {:arglists (quote
               [[credentials string-0 string-1 storage-class-2]]),
    :doc "Generate map for changeObjectStorageClass"}
   ([credentials__1609__auto__ a b c]
    {:args [a b c],
     :client :s3,
     :fn :change-object-storage-class,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   change-object-storage-class
   {:arglists (quote
               [[credentials string-0 string-1 storage-class-2]]),
    :doc "Call changeObjectStorageClass"}
   [credentials9578 & args9579]
   (clojure.core/let
    [^com.amazonaws.services.s3.AmazonS3Client client9580
     (com.palletops.awaze.common/aws-client :s3 credentials9578)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.s3.AmazonS3Client client9580
      changeObjectStorageClass
      (clojure.core/str (clojure.core/nth args9579 0))
      (clojure.core/str (clojure.core/nth args9579 1))
      (storage-class (clojure.core/nth args9579 2)))))))
 (do
  (clojure.core/defmethod
   s3
   :set-bucket-tagging-configuration
   [m9581]
   (clojure.core/let
    [credentials9582 (:credentials m9581) args9583 (:args m9581)]
    (clojure.core/let
     [^com.amazonaws.services.s3.AmazonS3Client client9584
      (com.palletops.awaze.common/aws-client :s3 credentials9582)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client9584
       setBucketTaggingConfiguration
       (clojure.core/str (clojure.core/nth args9583 0))
       (bucket-tagging-configuration (clojure.core/nth args9583 1)))))))
  (clojure.core/defn
   set-bucket-tagging-configuration-map
   {:arglists (quote [[credentials string-0 {:keys []}]]),
    :doc "Generate map for setBucketTaggingConfiguration"}
   ([credentials__1609__auto__ a b]
    {:args [a b],
     :client :s3,
     :fn :set-bucket-tagging-configuration,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   set-bucket-tagging-configuration
   {:arglists (quote [[credentials string-0 {:keys []}]]),
    :doc "Call setBucketTaggingConfiguration"}
   [credentials9586 & args9587]
   (clojure.core/let
    [^com.amazonaws.services.s3.AmazonS3Client client9588
     (com.palletops.awaze.common/aws-client :s3 credentials9586)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.s3.AmazonS3Client client9588
      setBucketTaggingConfiguration
      (clojure.core/str (clojure.core/nth args9587 0))
      (bucket-tagging-configuration (clojure.core/nth args9587 1)))))))
 (do
  (clojure.core/defmethod
   s3
   :set-s3client-options
   [m9589]
   (clojure.core/let
    [credentials9590 (:credentials m9589) args9591 (:args m9589)]
    (clojure.core/let
     [^com.amazonaws.services.s3.AmazonS3Client client9592
      (com.palletops.awaze.common/aws-client :s3 credentials9590)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client9592
       setS3ClientOptions
       (s3client-options (clojure.core/nth args9591 0)))))))
  (clojure.core/defn
   set-s3client-options-map
   {:arglists (quote [[credentials {:keys [path-style-access]}]]),
    :doc "Generate map for setS3ClientOptions"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :s3,
     :fn :set-s3client-options,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   set-s3client-options
   {:arglists (quote [[credentials {:keys [path-style-access]}]]),
    :doc "Call setS3ClientOptions"}
   [credentials9594 & args9595]
   (clojure.core/let
    [^com.amazonaws.services.s3.AmazonS3Client client9596
     (com.palletops.awaze.common/aws-client :s3 credentials9594)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.s3.AmazonS3Client client9596
      setS3ClientOptions
      (s3client-options (clojure.core/nth args9595 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :get-bucket-lifecycle-configuration
   [m9597]
   (clojure.core/let
    [credentials9598 (:credentials m9597) args9599 (:args m9597)]
    (clojure.core/let
     [^com.amazonaws.services.s3.AmazonS3Client client9600
      (com.palletops.awaze.common/aws-client :s3 credentials9598)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client9600
       getBucketLifecycleConfiguration
       (clojure.core/str (clojure.core/nth args9599 0)))))))
  (clojure.core/defn
   get-bucket-lifecycle-configuration-map
   {:arglists (quote [[credentials string-0]]),
    :doc "Generate map for getBucketLifecycleConfiguration"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :s3,
     :fn :get-bucket-lifecycle-configuration,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   get-bucket-lifecycle-configuration
   {:arglists (quote [[credentials string-0]]),
    :doc "Call getBucketLifecycleConfiguration"}
   [credentials9602 & args9603]
   (clojure.core/let
    [^com.amazonaws.services.s3.AmazonS3Client client9604
     (com.palletops.awaze.common/aws-client :s3 credentials9602)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.s3.AmazonS3Client client9604
      getBucketLifecycleConfiguration
      (clojure.core/str (clojure.core/nth args9603 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :get-resource-url
   [m9605]
   (clojure.core/let
    [credentials9606 (:credentials m9605) args9607 (:args m9605)]
    (clojure.core/let
     [^com.amazonaws.services.s3.AmazonS3Client client9608
      (com.palletops.awaze.common/aws-client :s3 credentials9606)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client9608
       getResourceUrl
       (clojure.core/str (clojure.core/nth args9607 0))
       (clojure.core/str (clojure.core/nth args9607 1)))))))
  (clojure.core/defn
   get-resource-url-map
   {:arglists (quote [[credentials string-0 string-1]]),
    :doc "Generate map for getResourceUrl"}
   ([credentials__1609__auto__ a b]
    {:args [a b],
     :client :s3,
     :fn :get-resource-url,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   get-resource-url
   {:arglists (quote [[credentials string-0 string-1]]),
    :doc "Call getResourceUrl"}
   [credentials9610 & args9611]
   (clojure.core/let
    [^com.amazonaws.services.s3.AmazonS3Client client9612
     (com.palletops.awaze.common/aws-client :s3 credentials9610)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.s3.AmazonS3Client client9612
      getResourceUrl
      (clojure.core/str (clojure.core/nth args9611 0))
      (clojure.core/str (clojure.core/nth args9611 1)))))))
 (do
  (clojure.core/defmethod
   s3
   :set-object-acl
   [m9613]
   (clojure.core/let
    [credentials9614 (:credentials m9613) args9615 (:args m9613)]
    (clojure.core/let
     [^com.amazonaws.services.s3.AmazonS3Client client9616
      (com.palletops.awaze.common/aws-client :s3 credentials9614)]
     (clojure.core/case
      (clojure.core/count args9615)
      4
      (clojure.core/let
       [a__1584__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^java.lang.String a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args9615 0))
          ^java.lang.String b
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args9615 1))
          ^java.lang.String c
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args9615 2))
          ^com.amazonaws.services.s3.model.CannedAccessControlList d
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.CannedAccessControlList
           (clojure.core/nth args9615 3))]
         (clojure.core/reset! a__1584__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
           ^com.amazonaws.services.s3.AmazonS3Client client9616
           setObjectAcl
           a
           b
           c
           d)))
        (catch
         java.lang.Exception
         e__1585__auto__
         (if
          (clojure.core/deref a__1584__auto__)
          (throw e__1585__auto__)
          (clojure.core/let
           [a__1584__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^java.lang.String a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args9615 0))
              ^java.lang.String b
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args9615 1))
              ^java.lang.String c
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args9615 2))
              ^com.amazonaws.services.s3.model.AccessControlList d
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.s3.model.AccessControlList
               (clojure.core/nth args9615 3))]
             (clojure.core/reset! a__1584__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
               ^com.amazonaws.services.s3.AmazonS3Client client9616
               setObjectAcl
               a
               b
               c
               d)))
            (catch
             java.lang.Exception
             e__1585__auto__
             (if
              (clojure.core/deref a__1584__auto__)
              (throw e__1585__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "setObjectAcl")
                {:args args9615}))))))))))
      3
      (clojure.core/let
       [a__1584__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^java.lang.String a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args9615 0))
          ^java.lang.String b
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args9615 1))
          ^com.amazonaws.services.s3.model.CannedAccessControlList c
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.CannedAccessControlList
           (clojure.core/nth args9615 2))]
         (clojure.core/reset! a__1584__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
           ^com.amazonaws.services.s3.AmazonS3Client client9616
           setObjectAcl
           a
           b
           c)))
        (catch
         java.lang.Exception
         e__1585__auto__
         (if
          (clojure.core/deref a__1584__auto__)
          (throw e__1585__auto__)
          (clojure.core/let
           [a__1584__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^java.lang.String a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args9615 0))
              ^java.lang.String b
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args9615 1))
              ^com.amazonaws.services.s3.model.AccessControlList c
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.s3.model.AccessControlList
               (clojure.core/nth args9615 2))]
             (clojure.core/reset! a__1584__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
               ^com.amazonaws.services.s3.AmazonS3Client client9616
               setObjectAcl
               a
               b
               c)))
            (catch
             java.lang.Exception
             e__1585__auto__
             (if
              (clojure.core/deref a__1584__auto__)
              (throw e__1585__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "setObjectAcl")
                {:args args9615}))))))))))))))
  (clojure.core/defn
   set-object-acl-map
   {:arglists (quote
               [[credentials
                 string-0
                 string-1
                 string-2
                 canned-access-control-list-3]
                [credentials
                 string-0
                 string-1
                 string-2
                 {:keys [owner grants]}]
                [credentials
                 string-0
                 string-1
                 canned-access-control-list-2]
                [credentials string-0 string-1 {:keys [owner grants]}]]),
    :doc "Generate map for setObjectAcl, setObjectAcl, setObjectAcl, setObjectAcl"}
   ([credentials__1609__auto__ a b c]
    {:args [a b c],
     :client :s3,
     :fn :set-object-acl,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a b c d]
    {:args [a b c d],
     :client :s3,
     :fn :set-object-acl,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   set-object-acl
   {:arglists (quote
               [[credentials
                 string-0
                 string-1
                 string-2
                 canned-access-control-list-3]
                [credentials
                 string-0
                 string-1
                 string-2
                 {:keys [owner grants]}]
                [credentials
                 string-0
                 string-1
                 canned-access-control-list-2]
                [credentials string-0 string-1 {:keys [owner grants]}]]),
    :doc "Call setObjectAcl, setObjectAcl, setObjectAcl, setObjectAcl"}
   [credentials9618 & args9619]
   (clojure.core/let
    [^com.amazonaws.services.s3.AmazonS3Client client9620
     (com.palletops.awaze.common/aws-client :s3 credentials9618)]
    (clojure.core/case
     (clojure.core/count args9619)
     4
     (clojure.core/let
      [a__1584__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^java.lang.String a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args9619 0))
         ^java.lang.String b
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args9619 1))
         ^java.lang.String c
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args9619 2))
         ^com.amazonaws.services.s3.model.CannedAccessControlList d
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.CannedAccessControlList
          (clojure.core/nth args9619 3))]
        (clojure.core/reset! a__1584__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
          ^com.amazonaws.services.s3.AmazonS3Client client9620
          setObjectAcl
          a
          b
          c
          d)))
       (catch
        java.lang.Exception
        e__1585__auto__
        (if
         (clojure.core/deref a__1584__auto__)
         (throw e__1585__auto__)
         (clojure.core/let
          [a__1584__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^java.lang.String a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args9619 0))
             ^java.lang.String b
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args9619 1))
             ^java.lang.String c
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args9619 2))
             ^com.amazonaws.services.s3.model.AccessControlList d
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.s3.model.AccessControlList
              (clojure.core/nth args9619 3))]
            (clojure.core/reset! a__1584__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
              ^com.amazonaws.services.s3.AmazonS3Client client9620
              setObjectAcl
              a
              b
              c
              d)))
           (catch
            java.lang.Exception
            e__1585__auto__
            (if
             (clojure.core/deref a__1584__auto__)
             (throw e__1585__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "setObjectAcl")
               {:args args9619}))))))))))
     3
     (clojure.core/let
      [a__1584__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^java.lang.String a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args9619 0))
         ^java.lang.String b
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args9619 1))
         ^com.amazonaws.services.s3.model.CannedAccessControlList c
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.CannedAccessControlList
          (clojure.core/nth args9619 2))]
        (clojure.core/reset! a__1584__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
          ^com.amazonaws.services.s3.AmazonS3Client client9620
          setObjectAcl
          a
          b
          c)))
       (catch
        java.lang.Exception
        e__1585__auto__
        (if
         (clojure.core/deref a__1584__auto__)
         (throw e__1585__auto__)
         (clojure.core/let
          [a__1584__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^java.lang.String a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args9619 0))
             ^java.lang.String b
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args9619 1))
             ^com.amazonaws.services.s3.model.AccessControlList c
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.s3.model.AccessControlList
              (clojure.core/nth args9619 2))]
            (clojure.core/reset! a__1584__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
              ^com.amazonaws.services.s3.AmazonS3Client client9620
              setObjectAcl
              a
              b
              c)))
           (catch
            java.lang.Exception
            e__1585__auto__
            (if
             (clojure.core/deref a__1584__auto__)
             (throw e__1585__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "setObjectAcl")
               {:args args9619}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :restore-object
   [m9621]
   (clojure.core/let
    [credentials9622 (:credentials m9621) args9623 (:args m9621)]
    (clojure.core/let
     [^com.amazonaws.services.s3.AmazonS3Client client9624
      (com.palletops.awaze.common/aws-client :s3 credentials9622)]
     (clojure.core/case
      (clojure.core/count args9623)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.s3.AmazonS3Client client9624
        restoreObject
        (restore-object-request (clojure.core/nth args9623 0))))
      3
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.s3.AmazonS3Client client9624
        restoreObject
        (clojure.core/str (clojure.core/nth args9623 0))
        (clojure.core/str (clojure.core/nth args9623 1))
        (clojure.core/int (clojure.core/nth args9623 2))))))))
  (clojure.core/defn
   restore-object-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         key
                         expiration-in-days
                         bucket-name]}]
                [credentials string-0 string-1 int-2]]),
    :doc "Generate map for restoreObject, restoreObject"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :s3,
     :fn :restore-object,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a b c]
    {:args [a b c],
     :client :s3,
     :fn :restore-object,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   restore-object
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         key
                         expiration-in-days
                         bucket-name]}]
                [credentials string-0 string-1 int-2]]),
    :doc "Call restoreObject, restoreObject"}
   [credentials9628 & args9629]
   (clojure.core/let
    [^com.amazonaws.services.s3.AmazonS3Client client9632
     (com.palletops.awaze.common/aws-client :s3 credentials9628)]
    (clojure.core/case
     (clojure.core/count args9629)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client9632
       restoreObject
       (restore-object-request (clojure.core/nth args9629 0))))
     3
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client9632
       restoreObject
       (clojure.core/str (clojure.core/nth args9629 0))
       (clojure.core/str (clojure.core/nth args9629 1))
       (clojure.core/int (clojure.core/nth args9629 2))))))))
 (do
  (clojure.core/defmethod
   s3
   :get-url
   [m9633]
   (clojure.core/let
    [credentials9634 (:credentials m9633) args9635 (:args m9633)]
    (clojure.core/let
     [^com.amazonaws.services.s3.AmazonS3Client client9636
      (com.palletops.awaze.common/aws-client :s3 credentials9634)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client9636
       getUrl
       (clojure.core/str (clojure.core/nth args9635 0))
       (clojure.core/str (clojure.core/nth args9635 1)))))))
  (clojure.core/defn
   get-url-map
   {:arglists (quote [[credentials string-0 string-1]]),
    :doc "Generate map for getUrl"}
   ([credentials__1609__auto__ a b]
    {:args [a b],
     :client :s3,
     :fn :get-url,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   get-url
   {:arglists (quote [[credentials string-0 string-1]]),
    :doc "Call getUrl"}
   [credentials9638 & args9639]
   (clojure.core/let
    [^com.amazonaws.services.s3.AmazonS3Client client9640
     (com.palletops.awaze.common/aws-client :s3 credentials9638)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.s3.AmazonS3Client client9640
      getUrl
      (clojure.core/str (clojure.core/nth args9639 0))
      (clojure.core/str (clojure.core/nth args9639 1)))))))
 (do
  (clojure.core/defmethod
   s3
   :delete-version
   [m9641]
   (clojure.core/let
    [credentials9642 (:credentials m9641) args9643 (:args m9641)]
    (clojure.core/let
     [^com.amazonaws.services.s3.AmazonS3Client client9644
      (com.palletops.awaze.common/aws-client :s3 credentials9642)]
     (clojure.core/case
      (clojure.core/count args9643)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.s3.AmazonS3Client client9644
        deleteVersion
        (delete-version-request (clojure.core/nth args9643 0))))
      3
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.s3.AmazonS3Client client9644
        deleteVersion
        (clojure.core/str (clojure.core/nth args9643 0))
        (clojure.core/str (clojure.core/nth args9643 1))
        (clojure.core/str (clojure.core/nth args9643 2))))))))
  (clojure.core/defn
   delete-version-map
   {:arglists (quote
               [[credentials
                 {:keys [version-id
                         request-metric-collector
                         mfa
                         key
                         bucket-name]}]
                [credentials string-0 string-1 string-2]]),
    :doc "Generate map for deleteVersion, deleteVersion"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :s3,
     :fn :delete-version,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a b c]
    {:args [a b c],
     :client :s3,
     :fn :delete-version,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   delete-version
   {:arglists (quote
               [[credentials
                 {:keys [version-id
                         request-metric-collector
                         mfa
                         key
                         bucket-name]}]
                [credentials string-0 string-1 string-2]]),
    :doc "Call deleteVersion, deleteVersion"}
   [credentials9649 & args9650]
   (clojure.core/let
    [^com.amazonaws.services.s3.AmazonS3Client client9654
     (com.palletops.awaze.common/aws-client :s3 credentials9649)]
    (clojure.core/case
     (clojure.core/count args9650)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client9654
       deleteVersion
       (delete-version-request (clojure.core/nth args9650 0))))
     3
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client9654
       deleteVersion
       (clojure.core/str (clojure.core/nth args9650 0))
       (clojure.core/str (clojure.core/nth args9650 1))
       (clojure.core/str (clojure.core/nth args9650 2))))))))
 (do
  (clojure.core/defmethod
   s3
   :set-bucket-versioning-configuration
   [m9655]
   (clojure.core/let
    [credentials9656 (:credentials m9655) args9657 (:args m9655)]
    (clojure.core/let
     [^com.amazonaws.services.s3.AmazonS3Client client9658
      (com.palletops.awaze.common/aws-client :s3 credentials9656)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client9658
       setBucketVersioningConfiguration
       (set-bucket-versioning-configuration-request
        (clojure.core/nth args9657 0)))))))
  (clojure.core/defn
   set-bucket-versioning-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [versioning-configuration
                         request-metric-collector
                         mfa
                         bucket-name]}]]),
    :doc "Generate map for setBucketVersioningConfiguration"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :s3,
     :fn :set-bucket-versioning-configuration,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   set-bucket-versioning-configuration
   {:arglists (quote
               [[credentials
                 {:keys [versioning-configuration
                         request-metric-collector
                         mfa
                         bucket-name]}]]),
    :doc "Call setBucketVersioningConfiguration"}
   [credentials9662 & args9663]
   (clojure.core/let
    [^com.amazonaws.services.s3.AmazonS3Client client9666
     (com.palletops.awaze.common/aws-client :s3 credentials9662)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.s3.AmazonS3Client client9666
      setBucketVersioningConfiguration
      (set-bucket-versioning-configuration-request
       (clojure.core/nth args9663 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :add-request-handler
   [m9667]
   (clojure.core/let
    [credentials9668 (:credentials m9667) args9669 (:args m9667)]
    (clojure.core/let
     [^com.amazonaws.services.s3.AmazonS3Client client9670
      (com.palletops.awaze.common/aws-client :s3 credentials9668)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client9670
       addRequestHandler
       (request-handler (clojure.core/nth args9669 0)))))))
  (clojure.core/defn
   add-request-handler-map
   {:arglists (quote [[credentials request-handler-0]]),
    :doc "Generate map for addRequestHandler"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :s3,
     :fn :add-request-handler,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   add-request-handler
   {:arglists (quote [[credentials request-handler-0]]),
    :doc "Call addRequestHandler"}
   [credentials9672 & args9673]
   (clojure.core/let
    [^com.amazonaws.services.s3.AmazonS3Client client9674
     (com.palletops.awaze.common/aws-client :s3 credentials9672)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.s3.AmazonS3Client client9674
      addRequestHandler
      (request-handler (clojure.core/nth args9673 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :get-bucket-cross-origin-configuration
   [m9675]
   (clojure.core/let
    [credentials9676 (:credentials m9675) args9677 (:args m9675)]
    (clojure.core/let
     [^com.amazonaws.services.s3.AmazonS3Client client9678
      (com.palletops.awaze.common/aws-client :s3 credentials9676)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client9678
       getBucketCrossOriginConfiguration
       (clojure.core/str (clojure.core/nth args9677 0)))))))
  (clojure.core/defn
   get-bucket-cross-origin-configuration-map
   {:arglists (quote [[credentials string-0]]),
    :doc "Generate map for getBucketCrossOriginConfiguration"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :s3,
     :fn :get-bucket-cross-origin-configuration,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   get-bucket-cross-origin-configuration
   {:arglists (quote [[credentials string-0]]),
    :doc "Call getBucketCrossOriginConfiguration"}
   [credentials9680 & args9681]
   (clojure.core/let
    [^com.amazonaws.services.s3.AmazonS3Client client9682
     (com.palletops.awaze.common/aws-client :s3 credentials9680)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.s3.AmazonS3Client client9682
      getBucketCrossOriginConfiguration
      (clojure.core/str (clojure.core/nth args9681 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :create-bucket
   [m9683]
   (clojure.core/let
    [credentials9684 (:credentials m9683) args9685 (:args m9683)]
    (clojure.core/let
     [^com.amazonaws.services.s3.AmazonS3Client client9686
      (com.palletops.awaze.common/aws-client :s3 credentials9684)]
     (clojure.core/case
      (clojure.core/count args9685)
      1
      (clojure.core/let
       [a__1584__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^com.amazonaws.services.s3.model.CreateBucketRequest a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.CreateBucketRequest
           (clojure.core/nth args9685 0))]
         (clojure.core/reset! a__1584__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
           ^com.amazonaws.services.s3.AmazonS3Client client9686
           createBucket
           a)))
        (catch
         java.lang.Exception
         e__1585__auto__
         (if
          (clojure.core/deref a__1584__auto__)
          (throw e__1585__auto__)
          (clojure.core/let
           [a__1584__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^java.lang.String a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args9685 0))]
             (clojure.core/reset! a__1584__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
               ^com.amazonaws.services.s3.AmazonS3Client client9686
               createBucket
               a)))
            (catch
             java.lang.Exception
             e__1585__auto__
             (if
              (clojure.core/deref a__1584__auto__)
              (throw e__1585__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "createBucket")
                {:args args9685}))))))))))
      2
      (clojure.core/let
       [a__1584__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^java.lang.String a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args9685 0))
          ^com.amazonaws.services.s3.model.Region b
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.Region
           (clojure.core/nth args9685 1))]
         (clojure.core/reset! a__1584__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
           ^com.amazonaws.services.s3.AmazonS3Client client9686
           createBucket
           a
           b)))
        (catch
         java.lang.Exception
         e__1585__auto__
         (if
          (clojure.core/deref a__1584__auto__)
          (throw e__1585__auto__)
          (clojure.core/let
           [a__1584__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^java.lang.String a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args9685 0))
              ^java.lang.String b
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args9685 1))]
             (clojure.core/reset! a__1584__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
               ^com.amazonaws.services.s3.AmazonS3Client client9686
               createBucket
               a
               b)))
            (catch
             java.lang.Exception
             e__1585__auto__
             (if
              (clojure.core/deref a__1584__auto__)
              (throw e__1585__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "createBucket")
                {:args args9685}))))))))))))))
  (clojure.core/defn
   create-bucket-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         region
                         canned-acl
                         bucket-name
                         access-control-list]}]
                [credentials string-0]
                [credentials string-0 region-1]
                [credentials string-0 string-1]]),
    :doc "Generate map for createBucket, createBucket, createBucket, createBucket"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :s3,
     :fn :create-bucket,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a b]
    {:args [a b],
     :client :s3,
     :fn :create-bucket,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   create-bucket
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         region
                         canned-acl
                         bucket-name
                         access-control-list]}]
                [credentials string-0]
                [credentials string-0 region-1]
                [credentials string-0 string-1]]),
    :doc "Call createBucket, createBucket, createBucket, createBucket"}
   [credentials9689 & args9690]
   (clojure.core/let
    [^com.amazonaws.services.s3.AmazonS3Client client9692
     (com.palletops.awaze.common/aws-client :s3 credentials9689)]
    (clojure.core/case
     (clojure.core/count args9690)
     1
     (clojure.core/let
      [a__1584__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^com.amazonaws.services.s3.model.CreateBucketRequest a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.CreateBucketRequest
          (clojure.core/nth args9690 0))]
        (clojure.core/reset! a__1584__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
          ^com.amazonaws.services.s3.AmazonS3Client client9692
          createBucket
          a)))
       (catch
        java.lang.Exception
        e__1585__auto__
        (if
         (clojure.core/deref a__1584__auto__)
         (throw e__1585__auto__)
         (clojure.core/let
          [a__1584__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^java.lang.String a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args9690 0))]
            (clojure.core/reset! a__1584__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
              ^com.amazonaws.services.s3.AmazonS3Client client9692
              createBucket
              a)))
           (catch
            java.lang.Exception
            e__1585__auto__
            (if
             (clojure.core/deref a__1584__auto__)
             (throw e__1585__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "createBucket")
               {:args args9690}))))))))))
     2
     (clojure.core/let
      [a__1584__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^java.lang.String a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args9690 0))
         ^com.amazonaws.services.s3.model.Region b
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.Region
          (clojure.core/nth args9690 1))]
        (clojure.core/reset! a__1584__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
          ^com.amazonaws.services.s3.AmazonS3Client client9692
          createBucket
          a
          b)))
       (catch
        java.lang.Exception
        e__1585__auto__
        (if
         (clojure.core/deref a__1584__auto__)
         (throw e__1585__auto__)
         (clojure.core/let
          [a__1584__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^java.lang.String a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args9690 0))
             ^java.lang.String b
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args9690 1))]
            (clojure.core/reset! a__1584__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
              ^com.amazonaws.services.s3.AmazonS3Client client9692
              createBucket
              a
              b)))
           (catch
            java.lang.Exception
            e__1585__auto__
            (if
             (clojure.core/deref a__1584__auto__)
             (throw e__1585__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "createBucket")
               {:args args9690}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :list-next-batch-of-objects
   [m9693]
   (clojure.core/let
    [credentials9694 (:credentials m9693) args9695 (:args m9693)]
    (clojure.core/let
     [^com.amazonaws.services.s3.AmazonS3Client client9696
      (com.palletops.awaze.common/aws-client :s3 credentials9694)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client9696
       listNextBatchOfObjects
       (object-listing (clojure.core/nth args9695 0)))))))
  (clojure.core/defn
   list-next-batch-of-objects-map
   {:arglists (quote
               [[credentials
                 {:keys [common-prefixes
                         marker
                         delimiter
                         truncated
                         next-marker
                         max-keys
                         prefix
                         object-summaries
                         bucket-name]}]]),
    :doc "Generate map for listNextBatchOfObjects"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :s3,
     :fn :list-next-batch-of-objects,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   list-next-batch-of-objects
   {:arglists (quote
               [[credentials
                 {:keys [common-prefixes
                         marker
                         delimiter
                         truncated
                         next-marker
                         max-keys
                         prefix
                         object-summaries
                         bucket-name]}]]),
    :doc "Call listNextBatchOfObjects"}
   [credentials9698 & args9699]
   (clojure.core/let
    [^com.amazonaws.services.s3.AmazonS3Client client9700
     (com.palletops.awaze.common/aws-client :s3 credentials9698)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.s3.AmazonS3Client client9700
      listNextBatchOfObjects
      (object-listing (clojure.core/nth args9699 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :put-object
   [m9701]
   (clojure.core/let
    [credentials9702 (:credentials m9701) args9703 (:args m9701)]
    (clojure.core/let
     [^com.amazonaws.services.s3.AmazonS3Client client9704
      (com.palletops.awaze.common/aws-client :s3 credentials9702)]
     (clojure.core/case
      (clojure.core/count args9703)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.s3.AmazonS3Client client9704
        putObject
        (put-object-request (clojure.core/nth args9703 0))))
      3
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.s3.AmazonS3Client client9704
        putObject
        (clojure.core/str (clojure.core/nth args9703 0))
        (clojure.core/str (clojure.core/nth args9703 1))
        (clojure.java.io/file (clojure.core/nth args9703 2))))
      4
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.s3.AmazonS3Client client9704
        putObject
        (clojure.core/str (clojure.core/nth args9703 0))
        (clojure.core/str (clojure.core/nth args9703 1))
        (clojure.java.io/input-stream (clojure.core/nth args9703 2))
        (object-metadata (clojure.core/nth args9703 3))))))))
  (clojure.core/defn
   put-object-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         metadata
                         general-progress-listener
                         canned-acl
                         key
                         bucket-name
                         input-stream
                         access-control-list
                         progress-listener
                         redirect-location
                         storage-class
                         file]}]
                [credentials string-0 string-1 file-2]
                [credentials
                 string-0
                 string-1
                 input-stream-2
                 {:keys [expiration-time
                         content-md5
                         server-side-encryption
                         etag
                         cache-control
                         raw-metadata
                         content-disposition
                         content-type
                         ongoing-restore
                         version-id
                         restore-expiration-time
                         expiration-time-rule-id
                         content-length
                         http-expires-date
                         last-modified
                         user-metadata
                         content-encoding]}]]),
    :doc "Generate map for putObject, putObject, putObject"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :s3,
     :fn :put-object,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a b c]
    {:args [a b c],
     :client :s3,
     :fn :put-object,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a b c d]
    {:args [a b c d],
     :client :s3,
     :fn :put-object,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   put-object
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         metadata
                         general-progress-listener
                         canned-acl
                         key
                         bucket-name
                         input-stream
                         access-control-list
                         progress-listener
                         redirect-location
                         storage-class
                         file]}]
                [credentials string-0 string-1 file-2]
                [credentials
                 string-0
                 string-1
                 input-stream-2
                 {:keys [expiration-time
                         content-md5
                         server-side-encryption
                         etag
                         cache-control
                         raw-metadata
                         content-disposition
                         content-type
                         ongoing-restore
                         version-id
                         restore-expiration-time
                         expiration-time-rule-id
                         content-length
                         http-expires-date
                         last-modified
                         user-metadata
                         content-encoding]}]]),
    :doc "Call putObject, putObject, putObject"}
   [credentials9709 & args9710]
   (clojure.core/let
    [^com.amazonaws.services.s3.AmazonS3Client client9714
     (com.palletops.awaze.common/aws-client :s3 credentials9709)]
    (clojure.core/case
     (clojure.core/count args9710)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client9714
       putObject
       (put-object-request (clojure.core/nth args9710 0))))
     3
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client9714
       putObject
       (clojure.core/str (clojure.core/nth args9710 0))
       (clojure.core/str (clojure.core/nth args9710 1))
       (clojure.java.io/file (clojure.core/nth args9710 2))))
     4
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client9714
       putObject
       (clojure.core/str (clojure.core/nth args9710 0))
       (clojure.core/str (clojure.core/nth args9710 1))
       (clojure.java.io/input-stream (clojure.core/nth args9710 2))
       (object-metadata (clojure.core/nth args9710 3))))))))
 (do
  (clojure.core/defmethod
   s3
   :get-bucket-policy
   [m9715]
   (clojure.core/let
    [credentials9716 (:credentials m9715) args9717 (:args m9715)]
    (clojure.core/let
     [^com.amazonaws.services.s3.AmazonS3Client client9718
      (com.palletops.awaze.common/aws-client :s3 credentials9716)]
     (clojure.core/case
      (clojure.core/count args9717)
      1
      (clojure.core/let
       [a__1584__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^java.lang.String a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args9717 0))]
         (clojure.core/reset! a__1584__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
           ^com.amazonaws.services.s3.AmazonS3Client client9718
           getBucketPolicy
           a)))
        (catch
         java.lang.Exception
         e__1585__auto__
         (if
          (clojure.core/deref a__1584__auto__)
          (throw e__1585__auto__)
          (clojure.core/let
           [a__1584__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^com.amazonaws.services.s3.model.GetBucketPolicyRequest a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.s3.model.GetBucketPolicyRequest
               (clojure.core/nth args9717 0))]
             (clojure.core/reset! a__1584__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
               ^com.amazonaws.services.s3.AmazonS3Client client9718
               getBucketPolicy
               a)))
            (catch
             java.lang.Exception
             e__1585__auto__
             (if
              (clojure.core/deref a__1584__auto__)
              (throw e__1585__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "getBucketPolicy")
                {:args args9717}))))))))))))))
  (clojure.core/defn
   get-bucket-policy-map
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [request-metric-collector bucket-name]}]]),
    :doc "Generate map for getBucketPolicy, getBucketPolicy"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :s3,
     :fn :get-bucket-policy,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   get-bucket-policy
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [request-metric-collector bucket-name]}]]),
    :doc "Call getBucketPolicy, getBucketPolicy"}
   [credentials9721 & args9722]
   (clojure.core/let
    [^com.amazonaws.services.s3.AmazonS3Client client9724
     (com.palletops.awaze.common/aws-client :s3 credentials9721)]
    (clojure.core/case
     (clojure.core/count args9722)
     1
     (clojure.core/let
      [a__1584__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^java.lang.String a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args9722 0))]
        (clojure.core/reset! a__1584__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
          ^com.amazonaws.services.s3.AmazonS3Client client9724
          getBucketPolicy
          a)))
       (catch
        java.lang.Exception
        e__1585__auto__
        (if
         (clojure.core/deref a__1584__auto__)
         (throw e__1585__auto__)
         (clojure.core/let
          [a__1584__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^com.amazonaws.services.s3.model.GetBucketPolicyRequest a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.s3.model.GetBucketPolicyRequest
              (clojure.core/nth args9722 0))]
            (clojure.core/reset! a__1584__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
              ^com.amazonaws.services.s3.AmazonS3Client client9724
              getBucketPolicy
              a)))
           (catch
            java.lang.Exception
            e__1585__auto__
            (if
             (clojure.core/deref a__1584__auto__)
             (throw e__1585__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "getBucketPolicy")
               {:args args9722}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :list-objects
   [m9725]
   (clojure.core/let
    [credentials9726 (:credentials m9725) args9727 (:args m9725)]
    (clojure.core/let
     [^com.amazonaws.services.s3.AmazonS3Client client9728
      (com.palletops.awaze.common/aws-client :s3 credentials9726)]
     (clojure.core/case
      (clojure.core/count args9727)
      1
      (clojure.core/let
       [a__1584__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^com.amazonaws.services.s3.model.ListObjectsRequest a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.ListObjectsRequest
           (clojure.core/nth args9727 0))]
         (clojure.core/reset! a__1584__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
           ^com.amazonaws.services.s3.AmazonS3Client client9728
           listObjects
           a)))
        (catch
         java.lang.Exception
         e__1585__auto__
         (if
          (clojure.core/deref a__1584__auto__)
          (throw e__1585__auto__)
          (clojure.core/let
           [a__1584__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^java.lang.String a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args9727 0))]
             (clojure.core/reset! a__1584__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
               ^com.amazonaws.services.s3.AmazonS3Client client9728
               listObjects
               a)))
            (catch
             java.lang.Exception
             e__1585__auto__
             (if
              (clojure.core/deref a__1584__auto__)
              (throw e__1585__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "listObjects")
                {:args args9727}))))))))))
      2
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.s3.AmazonS3Client client9728
        listObjects
        (clojure.core/str (clojure.core/nth args9727 0))
        (clojure.core/str (clojure.core/nth args9727 1))))))))
  (clojure.core/defn
   list-objects-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         prefix
                         max-keys
                         marker
                         delimiter
                         bucket-name]}]
                [credentials string-0 string-1]
                [credentials string-0]]),
    :doc "Generate map for listObjects, listObjects, listObjects"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :s3,
     :fn :list-objects,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a b]
    {:args [a b],
     :client :s3,
     :fn :list-objects,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   list-objects
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         prefix
                         max-keys
                         marker
                         delimiter
                         bucket-name]}]
                [credentials string-0 string-1]
                [credentials string-0]]),
    :doc "Call listObjects, listObjects, listObjects"}
   [credentials9730 & args9731]
   (clojure.core/let
    [^com.amazonaws.services.s3.AmazonS3Client client9732
     (com.palletops.awaze.common/aws-client :s3 credentials9730)]
    (clojure.core/case
     (clojure.core/count args9731)
     1
     (clojure.core/let
      [a__1584__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^com.amazonaws.services.s3.model.ListObjectsRequest a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.ListObjectsRequest
          (clojure.core/nth args9731 0))]
        (clojure.core/reset! a__1584__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
          ^com.amazonaws.services.s3.AmazonS3Client client9732
          listObjects
          a)))
       (catch
        java.lang.Exception
        e__1585__auto__
        (if
         (clojure.core/deref a__1584__auto__)
         (throw e__1585__auto__)
         (clojure.core/let
          [a__1584__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^java.lang.String a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args9731 0))]
            (clojure.core/reset! a__1584__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
              ^com.amazonaws.services.s3.AmazonS3Client client9732
              listObjects
              a)))
           (catch
            java.lang.Exception
            e__1585__auto__
            (if
             (clojure.core/deref a__1584__auto__)
             (throw e__1585__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "listObjects")
               {:args args9731}))))))))))
     2
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client9732
       listObjects
       (clojure.core/str (clojure.core/nth args9731 0))
       (clojure.core/str (clojure.core/nth args9731 1))))))))
 (do
  (clojure.core/defmethod
   s3
   :abort-multipart-upload
   [m9733]
   (clojure.core/let
    [credentials9734 (:credentials m9733) args9735 (:args m9733)]
    (clojure.core/let
     [^com.amazonaws.services.s3.AmazonS3Client client9736
      (com.palletops.awaze.common/aws-client :s3 credentials9734)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client9736
       abortMultipartUpload
       (abort-multipart-upload-request (clojure.core/nth args9735 0)))))))
  (clojure.core/defn
   abort-multipart-upload-map
   {:arglists (quote
               [[credentials
                 {:keys [upload-id
                         request-metric-collector
                         key
                         bucket-name]}]]),
    :doc "Generate map for abortMultipartUpload"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :s3,
     :fn :abort-multipart-upload,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   abort-multipart-upload
   {:arglists (quote
               [[credentials
                 {:keys [upload-id
                         request-metric-collector
                         key
                         bucket-name]}]]),
    :doc "Call abortMultipartUpload"}
   [credentials9741 & args9742]
   (clojure.core/let
    [^com.amazonaws.services.s3.AmazonS3Client client9746
     (com.palletops.awaze.common/aws-client :s3 credentials9741)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.s3.AmazonS3Client client9746
      abortMultipartUpload
      (abort-multipart-upload-request (clojure.core/nth args9742 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :upload-part
   [m9747]
   (clojure.core/let
    [credentials9748 (:credentials m9747) args9749 (:args m9747)]
    (clojure.core/let
     [^com.amazonaws.services.s3.AmazonS3Client client9750
      (com.palletops.awaze.common/aws-client :s3 credentials9748)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client9750
       uploadPart
       (upload-part-request (clojure.core/nth args9749 0)))))))
  (clojure.core/defn
   upload-part-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         general-progress-listener
                         md5digest
                         key
                         bucket-name
                         part-number
                         input-stream
                         upload-id
                         progress-listener
                         file-offset
                         last-part
                         file
                         part-size]}]]),
    :doc "Generate map for uploadPart"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :s3,
     :fn :upload-part,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   upload-part
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         general-progress-listener
                         md5digest
                         key
                         bucket-name
                         part-number
                         input-stream
                         upload-id
                         progress-listener
                         file-offset
                         last-part
                         file
                         part-size]}]]),
    :doc "Call uploadPart"}
   [credentials9752 & args9753]
   (clojure.core/let
    [^com.amazonaws.services.s3.AmazonS3Client client9754
     (com.palletops.awaze.common/aws-client :s3 credentials9752)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.s3.AmazonS3Client client9754
      uploadPart
      (upload-part-request (clojure.core/nth args9753 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :complete-multipart-upload
   [m9755]
   (clojure.core/let
    [credentials9756 (:credentials m9755) args9757 (:args m9755)]
    (clojure.core/let
     [^com.amazonaws.services.s3.AmazonS3Client client9758
      (com.palletops.awaze.common/aws-client :s3 credentials9756)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client9758
       completeMultipartUpload
       (complete-multipart-upload-request
        (clojure.core/nth args9757 0)))))))
  (clojure.core/defn
   complete-multipart-upload-map
   {:arglists (quote
               [[credentials
                 {:keys [upload-id
                         request-metric-collector
                         part-etags
                         key
                         bucket-name]}]]),
    :doc "Generate map for completeMultipartUpload"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :s3,
     :fn :complete-multipart-upload,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   complete-multipart-upload
   {:arglists (quote
               [[credentials
                 {:keys [upload-id
                         request-metric-collector
                         part-etags
                         key
                         bucket-name]}]]),
    :doc "Call completeMultipartUpload"}
   [credentials9764 & args9765]
   (clojure.core/let
    [^com.amazonaws.services.s3.AmazonS3Client client9770
     (com.palletops.awaze.common/aws-client :s3 credentials9764)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.s3.AmazonS3Client client9770
      completeMultipartUpload
      (complete-multipart-upload-request
       (clojure.core/nth args9765 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :list-versions
   [m9771]
   (clojure.core/let
    [credentials9772 (:credentials m9771) args9773 (:args m9771)]
    (clojure.core/let
     [^com.amazonaws.services.s3.AmazonS3Client client9774
      (com.palletops.awaze.common/aws-client :s3 credentials9772)]
     (clojure.core/case
      (clojure.core/count args9773)
      6
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.s3.AmazonS3Client client9774
        listVersions
        (clojure.core/str (clojure.core/nth args9773 0))
        (clojure.core/str (clojure.core/nth args9773 1))
        (clojure.core/str (clojure.core/nth args9773 2))
        (clojure.core/str (clojure.core/nth args9773 3))
        (clojure.core/str (clojure.core/nth args9773 4))
        (clojure.core/int (clojure.core/nth args9773 5))))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.s3.AmazonS3Client client9774
        listVersions
        (list-versions-request (clojure.core/nth args9773 0))))
      2
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.s3.AmazonS3Client client9774
        listVersions
        (clojure.core/str (clojure.core/nth args9773 0))
        (clojure.core/str (clojure.core/nth args9773 1))))))))
  (clojure.core/defn
   list-versions-map
   {:arglists (quote
               [[credentials
                 string-0
                 string-1
                 string-2
                 string-3
                 string-4
                 integer-5]
                [credentials
                 {:keys [delimiter
                         prefix
                         key-marker
                         bucket-name
                         request-metric-collector
                         version-id-marker
                         max-results]}]
                [credentials string-0 string-1]]),
    :doc "Generate map for listVersions, listVersions, listVersions"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :s3,
     :fn :list-versions,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a b]
    {:args [a b],
     :client :s3,
     :fn :list-versions,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a b c d e f]
    {:args [a b c d e f],
     :client :s3,
     :fn :list-versions,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   list-versions
   {:arglists (quote
               [[credentials
                 string-0
                 string-1
                 string-2
                 string-3
                 string-4
                 integer-5]
                [credentials
                 {:keys [delimiter
                         prefix
                         key-marker
                         bucket-name
                         request-metric-collector
                         version-id-marker
                         max-results]}]
                [credentials string-0 string-1]]),
    :doc "Call listVersions, listVersions, listVersions"}
   [credentials9776 & args9777]
   (clojure.core/let
    [^com.amazonaws.services.s3.AmazonS3Client client9778
     (com.palletops.awaze.common/aws-client :s3 credentials9776)]
    (clojure.core/case
     (clojure.core/count args9777)
     6
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client9778
       listVersions
       (clojure.core/str (clojure.core/nth args9777 0))
       (clojure.core/str (clojure.core/nth args9777 1))
       (clojure.core/str (clojure.core/nth args9777 2))
       (clojure.core/str (clojure.core/nth args9777 3))
       (clojure.core/str (clojure.core/nth args9777 4))
       (clojure.core/int (clojure.core/nth args9777 5))))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client9778
       listVersions
       (list-versions-request (clojure.core/nth args9777 0))))
     2
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client9778
       listVersions
       (clojure.core/str (clojure.core/nth args9777 0))
       (clojure.core/str (clojure.core/nth args9777 1))))))))
 (do
  (clojure.core/defmethod
   s3
   :set-object-redirect-location
   [m9779]
   (clojure.core/let
    [credentials9780 (:credentials m9779) args9781 (:args m9779)]
    (clojure.core/let
     [^com.amazonaws.services.s3.AmazonS3Client client9782
      (com.palletops.awaze.common/aws-client :s3 credentials9780)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client9782
       setObjectRedirectLocation
       (clojure.core/str (clojure.core/nth args9781 0))
       (clojure.core/str (clojure.core/nth args9781 1))
       (clojure.core/str (clojure.core/nth args9781 2)))))))
  (clojure.core/defn
   set-object-redirect-location-map
   {:arglists (quote [[credentials string-0 string-1 string-2]]),
    :doc "Generate map for setObjectRedirectLocation"}
   ([credentials__1609__auto__ a b c]
    {:args [a b c],
     :client :s3,
     :fn :set-object-redirect-location,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   set-object-redirect-location
   {:arglists (quote [[credentials string-0 string-1 string-2]]),
    :doc "Call setObjectRedirectLocation"}
   [credentials9784 & args9785]
   (clojure.core/let
    [^com.amazonaws.services.s3.AmazonS3Client client9786
     (com.palletops.awaze.common/aws-client :s3 credentials9784)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.s3.AmazonS3Client client9786
      setObjectRedirectLocation
      (clojure.core/str (clojure.core/nth args9785 0))
      (clojure.core/str (clojure.core/nth args9785 1))
      (clojure.core/str (clojure.core/nth args9785 2)))))))
 (do
  (clojure.core/defmethod
   s3
   :delete-bucket-website-configuration
   [m9787]
   (clojure.core/let
    [credentials9788 (:credentials m9787) args9789 (:args m9787)]
    (clojure.core/let
     [^com.amazonaws.services.s3.AmazonS3Client client9790
      (com.palletops.awaze.common/aws-client :s3 credentials9788)]
     (clojure.core/case
      (clojure.core/count args9789)
      1
      (clojure.core/let
       [a__1584__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^com.amazonaws.services.s3.model.DeleteBucketWebsiteConfigurationRequest a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.DeleteBucketWebsiteConfigurationRequest
           (clojure.core/nth args9789 0))]
         (clojure.core/reset! a__1584__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
           ^com.amazonaws.services.s3.AmazonS3Client client9790
           deleteBucketWebsiteConfiguration
           a)))
        (catch
         java.lang.Exception
         e__1585__auto__
         (if
          (clojure.core/deref a__1584__auto__)
          (throw e__1585__auto__)
          (clojure.core/let
           [a__1584__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^java.lang.String a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args9789 0))]
             (clojure.core/reset! a__1584__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
               ^com.amazonaws.services.s3.AmazonS3Client client9790
               deleteBucketWebsiteConfiguration
               a)))
            (catch
             java.lang.Exception
             e__1585__auto__
             (if
              (clojure.core/deref a__1584__auto__)
              (throw e__1585__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "deleteBucketWebsiteConfiguration")
                {:args args9789}))))))))))))))
  (clojure.core/defn
   delete-bucket-website-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector bucket-name]}]
                [credentials string-0]]),
    :doc "Generate map for deleteBucketWebsiteConfiguration, deleteBucketWebsiteConfiguration"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :s3,
     :fn :delete-bucket-website-configuration,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   delete-bucket-website-configuration
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector bucket-name]}]
                [credentials string-0]]),
    :doc "Call deleteBucketWebsiteConfiguration, deleteBucketWebsiteConfiguration"}
   [credentials9793 & args9794]
   (clojure.core/let
    [^com.amazonaws.services.s3.AmazonS3Client client9796
     (com.palletops.awaze.common/aws-client :s3 credentials9793)]
    (clojure.core/case
     (clojure.core/count args9794)
     1
     (clojure.core/let
      [a__1584__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^com.amazonaws.services.s3.model.DeleteBucketWebsiteConfigurationRequest a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.DeleteBucketWebsiteConfigurationRequest
          (clojure.core/nth args9794 0))]
        (clojure.core/reset! a__1584__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
          ^com.amazonaws.services.s3.AmazonS3Client client9796
          deleteBucketWebsiteConfiguration
          a)))
       (catch
        java.lang.Exception
        e__1585__auto__
        (if
         (clojure.core/deref a__1584__auto__)
         (throw e__1585__auto__)
         (clojure.core/let
          [a__1584__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^java.lang.String a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args9794 0))]
            (clojure.core/reset! a__1584__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
              ^com.amazonaws.services.s3.AmazonS3Client client9796
              deleteBucketWebsiteConfiguration
              a)))
           (catch
            java.lang.Exception
            e__1585__auto__
            (if
             (clojure.core/deref a__1584__auto__)
             (throw e__1585__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "deleteBucketWebsiteConfiguration")
               {:args args9794}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :list-multipart-uploads
   [m9797]
   (clojure.core/let
    [credentials9798 (:credentials m9797) args9799 (:args m9797)]
    (clojure.core/let
     [^com.amazonaws.services.s3.AmazonS3Client client9800
      (com.palletops.awaze.common/aws-client :s3 credentials9798)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client9800
       listMultipartUploads
       (list-multipart-uploads-request (clojure.core/nth args9799 0)))))))
  (clojure.core/defn
   list-multipart-uploads-map
   {:arglists (quote
               [[credentials
                 {:keys [delimiter
                         upload-id-marker
                         max-uploads
                         prefix
                         key-marker
                         bucket-name
                         request-metric-collector]}]]),
    :doc "Generate map for listMultipartUploads"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :s3,
     :fn :list-multipart-uploads,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   list-multipart-uploads
   {:arglists (quote
               [[credentials
                 {:keys [delimiter
                         upload-id-marker
                         max-uploads
                         prefix
                         key-marker
                         bucket-name
                         request-metric-collector]}]]),
    :doc "Call listMultipartUploads"}
   [credentials9803 & args9804]
   (clojure.core/let
    [^com.amazonaws.services.s3.AmazonS3Client client9806
     (com.palletops.awaze.common/aws-client :s3 credentials9803)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.s3.AmazonS3Client client9806
      listMultipartUploads
      (list-multipart-uploads-request (clojure.core/nth args9804 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :set-bucket-lifecycle-configuration
   [m9807]
   (clojure.core/let
    [credentials9808 (:credentials m9807) args9809 (:args m9807)]
    (clojure.core/let
     [^com.amazonaws.services.s3.AmazonS3Client client9810
      (com.palletops.awaze.common/aws-client :s3 credentials9808)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client9810
       setBucketLifecycleConfiguration
       (clojure.core/str (clojure.core/nth args9809 0))
       (bucket-lifecycle-configuration (clojure.core/nth args9809 1)))))))
  (clojure.core/defn
   set-bucket-lifecycle-configuration-map
   {:arglists (quote [[credentials string-0 {:keys [rules]}]]),
    :doc "Generate map for setBucketLifecycleConfiguration"}
   ([credentials__1609__auto__ a b]
    {:args [a b],
     :client :s3,
     :fn :set-bucket-lifecycle-configuration,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   set-bucket-lifecycle-configuration
   {:arglists (quote [[credentials string-0 {:keys [rules]}]]),
    :doc "Call setBucketLifecycleConfiguration"}
   [credentials9812 & args9813]
   (clojure.core/let
    [^com.amazonaws.services.s3.AmazonS3Client client9814
     (com.palletops.awaze.common/aws-client :s3 credentials9812)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.s3.AmazonS3Client client9814
      setBucketLifecycleConfiguration
      (clojure.core/str (clojure.core/nth args9813 0))
      (bucket-lifecycle-configuration (clojure.core/nth args9813 1)))))))
 (do
  (clojure.core/defmethod
   s3
   :get-object-metadata
   [m9815]
   (clojure.core/let
    [credentials9816 (:credentials m9815) args9817 (:args m9815)]
    (clojure.core/let
     [^com.amazonaws.services.s3.AmazonS3Client client9818
      (com.palletops.awaze.common/aws-client :s3 credentials9816)]
     (clojure.core/case
      (clojure.core/count args9817)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.s3.AmazonS3Client client9818
        getObjectMetadata
        (get-object-metadata-request (clojure.core/nth args9817 0))))
      2
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.s3.AmazonS3Client client9818
        getObjectMetadata
        (clojure.core/str (clojure.core/nth args9817 0))
        (clojure.core/str (clojure.core/nth args9817 1))))))))
  (clojure.core/defn
   get-object-metadata-map
   {:arglists (quote
               [[credentials
                 {:keys [version-id
                         request-metric-collector
                         key
                         bucket-name]}]
                [credentials string-0 string-1]]),
    :doc "Generate map for getObjectMetadata, getObjectMetadata"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :s3,
     :fn :get-object-metadata,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a b]
    {:args [a b],
     :client :s3,
     :fn :get-object-metadata,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   get-object-metadata
   {:arglists (quote
               [[credentials
                 {:keys [version-id
                         request-metric-collector
                         key
                         bucket-name]}]
                [credentials string-0 string-1]]),
    :doc "Call getObjectMetadata, getObjectMetadata"}
   [credentials9822 & args9823]
   (clojure.core/let
    [^com.amazonaws.services.s3.AmazonS3Client client9826
     (com.palletops.awaze.common/aws-client :s3 credentials9822)]
    (clojure.core/case
     (clojure.core/count args9823)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client9826
       getObjectMetadata
       (get-object-metadata-request (clojure.core/nth args9823 0))))
     2
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client9826
       getObjectMetadata
       (clojure.core/str (clojure.core/nth args9823 0))
       (clojure.core/str (clojure.core/nth args9823 1))))))))
 (do
  (clojure.core/defmethod
   s3
   :delete-bucket-cross-origin-configuration
   [m9827]
   (clojure.core/let
    [credentials9828 (:credentials m9827) args9829 (:args m9827)]
    (clojure.core/let
     [^com.amazonaws.services.s3.AmazonS3Client client9830
      (com.palletops.awaze.common/aws-client :s3 credentials9828)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client9830
       deleteBucketCrossOriginConfiguration
       (clojure.core/str (clojure.core/nth args9829 0)))))))
  (clojure.core/defn
   delete-bucket-cross-origin-configuration-map
   {:arglists (quote [[credentials string-0]]),
    :doc "Generate map for deleteBucketCrossOriginConfiguration"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :s3,
     :fn :delete-bucket-cross-origin-configuration,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   delete-bucket-cross-origin-configuration
   {:arglists (quote [[credentials string-0]]),
    :doc "Call deleteBucketCrossOriginConfiguration"}
   [credentials9832 & args9833]
   (clojure.core/let
    [^com.amazonaws.services.s3.AmazonS3Client client9834
     (com.palletops.awaze.common/aws-client :s3 credentials9832)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.s3.AmazonS3Client client9834
      deleteBucketCrossOriginConfiguration
      (clojure.core/str (clojure.core/nth args9833 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :delete-bucket-tagging-configuration
   [m9835]
   (clojure.core/let
    [credentials9836 (:credentials m9835) args9837 (:args m9835)]
    (clojure.core/let
     [^com.amazonaws.services.s3.AmazonS3Client client9838
      (com.palletops.awaze.common/aws-client :s3 credentials9836)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client9838
       deleteBucketTaggingConfiguration
       (clojure.core/str (clojure.core/nth args9837 0)))))))
  (clojure.core/defn
   delete-bucket-tagging-configuration-map
   {:arglists (quote [[credentials string-0]]),
    :doc "Generate map for deleteBucketTaggingConfiguration"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :s3,
     :fn :delete-bucket-tagging-configuration,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   delete-bucket-tagging-configuration
   {:arglists (quote [[credentials string-0]]),
    :doc "Call deleteBucketTaggingConfiguration"}
   [credentials9840 & args9841]
   (clojure.core/let
    [^com.amazonaws.services.s3.AmazonS3Client client9842
     (com.palletops.awaze.common/aws-client :s3 credentials9840)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.s3.AmazonS3Client client9842
      deleteBucketTaggingConfiguration
      (clojure.core/str (clojure.core/nth args9841 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :get-object-acl
   [m9843]
   (clojure.core/let
    [credentials9844 (:credentials m9843) args9845 (:args m9843)]
    (clojure.core/let
     [^com.amazonaws.services.s3.AmazonS3Client client9846
      (com.palletops.awaze.common/aws-client :s3 credentials9844)]
     (clojure.core/case
      (clojure.core/count args9845)
      3
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.s3.AmazonS3Client client9846
        getObjectAcl
        (clojure.core/str (clojure.core/nth args9845 0))
        (clojure.core/str (clojure.core/nth args9845 1))
        (clojure.core/str (clojure.core/nth args9845 2))))
      2
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.s3.AmazonS3Client client9846
        getObjectAcl
        (clojure.core/str (clojure.core/nth args9845 0))
        (clojure.core/str (clojure.core/nth args9845 1))))))))
  (clojure.core/defn
   get-object-acl-map
   {:arglists (quote
               [[credentials string-0 string-1 string-2]
                [credentials string-0 string-1]]),
    :doc "Generate map for getObjectAcl, getObjectAcl"}
   ([credentials__1609__auto__ a b]
    {:args [a b],
     :client :s3,
     :fn :get-object-acl,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a b c]
    {:args [a b c],
     :client :s3,
     :fn :get-object-acl,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   get-object-acl
   {:arglists (quote
               [[credentials string-0 string-1 string-2]
                [credentials string-0 string-1]]),
    :doc "Call getObjectAcl, getObjectAcl"}
   [credentials9848 & args9849]
   (clojure.core/let
    [^com.amazonaws.services.s3.AmazonS3Client client9850
     (com.palletops.awaze.common/aws-client :s3 credentials9848)]
    (clojure.core/case
     (clojure.core/count args9849)
     3
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client9850
       getObjectAcl
       (clojure.core/str (clojure.core/nth args9849 0))
       (clojure.core/str (clojure.core/nth args9849 1))
       (clojure.core/str (clojure.core/nth args9849 2))))
     2
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client9850
       getObjectAcl
       (clojure.core/str (clojure.core/nth args9849 0))
       (clojure.core/str (clojure.core/nth args9849 1))))))))
 (do
  (clojure.core/defmethod
   s3
   :delete-bucket-policy
   [m9851]
   (clojure.core/let
    [credentials9852 (:credentials m9851) args9853 (:args m9851)]
    (clojure.core/let
     [^com.amazonaws.services.s3.AmazonS3Client client9854
      (com.palletops.awaze.common/aws-client :s3 credentials9852)]
     (clojure.core/case
      (clojure.core/count args9853)
      1
      (clojure.core/let
       [a__1584__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^java.lang.String a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args9853 0))]
         (clojure.core/reset! a__1584__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
           ^com.amazonaws.services.s3.AmazonS3Client client9854
           deleteBucketPolicy
           a)))
        (catch
         java.lang.Exception
         e__1585__auto__
         (if
          (clojure.core/deref a__1584__auto__)
          (throw e__1585__auto__)
          (clojure.core/let
           [a__1584__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^com.amazonaws.services.s3.model.DeleteBucketPolicyRequest a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.s3.model.DeleteBucketPolicyRequest
               (clojure.core/nth args9853 0))]
             (clojure.core/reset! a__1584__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
               ^com.amazonaws.services.s3.AmazonS3Client client9854
               deleteBucketPolicy
               a)))
            (catch
             java.lang.Exception
             e__1585__auto__
             (if
              (clojure.core/deref a__1584__auto__)
              (throw e__1585__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "deleteBucketPolicy")
                {:args args9853}))))))))))))))
  (clojure.core/defn
   delete-bucket-policy-map
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [request-metric-collector bucket-name]}]]),
    :doc "Generate map for deleteBucketPolicy, deleteBucketPolicy"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :s3,
     :fn :delete-bucket-policy,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   delete-bucket-policy
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [request-metric-collector bucket-name]}]]),
    :doc "Call deleteBucketPolicy, deleteBucketPolicy"}
   [credentials9857 & args9858]
   (clojure.core/let
    [^com.amazonaws.services.s3.AmazonS3Client client9860
     (com.palletops.awaze.common/aws-client :s3 credentials9857)]
    (clojure.core/case
     (clojure.core/count args9858)
     1
     (clojure.core/let
      [a__1584__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^java.lang.String a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args9858 0))]
        (clojure.core/reset! a__1584__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
          ^com.amazonaws.services.s3.AmazonS3Client client9860
          deleteBucketPolicy
          a)))
       (catch
        java.lang.Exception
        e__1585__auto__
        (if
         (clojure.core/deref a__1584__auto__)
         (throw e__1585__auto__)
         (clojure.core/let
          [a__1584__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^com.amazonaws.services.s3.model.DeleteBucketPolicyRequest a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.s3.model.DeleteBucketPolicyRequest
              (clojure.core/nth args9858 0))]
            (clojure.core/reset! a__1584__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
              ^com.amazonaws.services.s3.AmazonS3Client client9860
              deleteBucketPolicy
              a)))
           (catch
            java.lang.Exception
            e__1585__auto__
            (if
             (clojure.core/deref a__1584__auto__)
             (throw e__1585__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "deleteBucketPolicy")
               {:args args9858}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :get-bucket-tagging-configuration
   [m9861]
   (clojure.core/let
    [credentials9862 (:credentials m9861) args9863 (:args m9861)]
    (clojure.core/let
     [^com.amazonaws.services.s3.AmazonS3Client client9864
      (com.palletops.awaze.common/aws-client :s3 credentials9862)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client9864
       getBucketTaggingConfiguration
       (clojure.core/str (clojure.core/nth args9863 0)))))))
  (clojure.core/defn
   get-bucket-tagging-configuration-map
   {:arglists (quote [[credentials string-0]]),
    :doc "Generate map for getBucketTaggingConfiguration"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :s3,
     :fn :get-bucket-tagging-configuration,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   get-bucket-tagging-configuration
   {:arglists (quote [[credentials string-0]]),
    :doc "Call getBucketTaggingConfiguration"}
   [credentials9866 & args9867]
   (clojure.core/let
    [^com.amazonaws.services.s3.AmazonS3Client client9868
     (com.palletops.awaze.common/aws-client :s3 credentials9866)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.s3.AmazonS3Client client9868
      getBucketTaggingConfiguration
      (clojure.core/str (clojure.core/nth args9867 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :get-bucket-website-configuration
   [m9869]
   (clojure.core/let
    [credentials9870 (:credentials m9869) args9871 (:args m9869)]
    (clojure.core/let
     [^com.amazonaws.services.s3.AmazonS3Client client9872
      (com.palletops.awaze.common/aws-client :s3 credentials9870)]
     (clojure.core/case
      (clojure.core/count args9871)
      1
      (clojure.core/let
       [a__1584__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^java.lang.String a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args9871 0))]
         (clojure.core/reset! a__1584__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
           ^com.amazonaws.services.s3.AmazonS3Client client9872
           getBucketWebsiteConfiguration
           a)))
        (catch
         java.lang.Exception
         e__1585__auto__
         (if
          (clojure.core/deref a__1584__auto__)
          (throw e__1585__auto__)
          (clojure.core/let
           [a__1584__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^com.amazonaws.services.s3.model.GetBucketWebsiteConfigurationRequest a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.s3.model.GetBucketWebsiteConfigurationRequest
               (clojure.core/nth args9871 0))]
             (clojure.core/reset! a__1584__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
               ^com.amazonaws.services.s3.AmazonS3Client client9872
               getBucketWebsiteConfiguration
               a)))
            (catch
             java.lang.Exception
             e__1585__auto__
             (if
              (clojure.core/deref a__1584__auto__)
              (throw e__1585__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "getBucketWebsiteConfiguration")
                {:args args9871}))))))))))))))
  (clojure.core/defn
   get-bucket-website-configuration-map
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [request-metric-collector bucket-name]}]]),
    :doc "Generate map for getBucketWebsiteConfiguration, getBucketWebsiteConfiguration"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :s3,
     :fn :get-bucket-website-configuration,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   get-bucket-website-configuration
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [request-metric-collector bucket-name]}]]),
    :doc "Call getBucketWebsiteConfiguration, getBucketWebsiteConfiguration"}
   [credentials9875 & args9876]
   (clojure.core/let
    [^com.amazonaws.services.s3.AmazonS3Client client9878
     (com.palletops.awaze.common/aws-client :s3 credentials9875)]
    (clojure.core/case
     (clojure.core/count args9876)
     1
     (clojure.core/let
      [a__1584__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^java.lang.String a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args9876 0))]
        (clojure.core/reset! a__1584__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
          ^com.amazonaws.services.s3.AmazonS3Client client9878
          getBucketWebsiteConfiguration
          a)))
       (catch
        java.lang.Exception
        e__1585__auto__
        (if
         (clojure.core/deref a__1584__auto__)
         (throw e__1585__auto__)
         (clojure.core/let
          [a__1584__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^com.amazonaws.services.s3.model.GetBucketWebsiteConfigurationRequest a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.s3.model.GetBucketWebsiteConfigurationRequest
              (clojure.core/nth args9876 0))]
            (clojure.core/reset! a__1584__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
              ^com.amazonaws.services.s3.AmazonS3Client client9878
              getBucketWebsiteConfiguration
              a)))
           (catch
            java.lang.Exception
            e__1585__auto__
            (if
             (clojure.core/deref a__1584__auto__)
             (throw e__1585__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "getBucketWebsiteConfiguration")
               {:args args9876}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :delete-bucket-lifecycle-configuration
   [m9879]
   (clojure.core/let
    [credentials9880 (:credentials m9879) args9881 (:args m9879)]
    (clojure.core/let
     [^com.amazonaws.services.s3.AmazonS3Client client9882
      (com.palletops.awaze.common/aws-client :s3 credentials9880)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client9882
       deleteBucketLifecycleConfiguration
       (clojure.core/str (clojure.core/nth args9881 0)))))))
  (clojure.core/defn
   delete-bucket-lifecycle-configuration-map
   {:arglists (quote [[credentials string-0]]),
    :doc "Generate map for deleteBucketLifecycleConfiguration"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :s3,
     :fn :delete-bucket-lifecycle-configuration,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   delete-bucket-lifecycle-configuration
   {:arglists (quote [[credentials string-0]]),
    :doc "Call deleteBucketLifecycleConfiguration"}
   [credentials9884 & args9885]
   (clojure.core/let
    [^com.amazonaws.services.s3.AmazonS3Client client9886
     (com.palletops.awaze.common/aws-client :s3 credentials9884)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.s3.AmazonS3Client client9886
      deleteBucketLifecycleConfiguration
      (clojure.core/str (clojure.core/nth args9885 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :delete-bucket
   [m9887]
   (clojure.core/let
    [credentials9888 (:credentials m9887) args9889 (:args m9887)]
    (clojure.core/let
     [^com.amazonaws.services.s3.AmazonS3Client client9890
      (com.palletops.awaze.common/aws-client :s3 credentials9888)]
     (clojure.core/case
      (clojure.core/count args9889)
      1
      (clojure.core/let
       [a__1584__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^com.amazonaws.services.s3.model.DeleteBucketRequest a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.DeleteBucketRequest
           (clojure.core/nth args9889 0))]
         (clojure.core/reset! a__1584__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
           ^com.amazonaws.services.s3.AmazonS3Client client9890
           deleteBucket
           a)))
        (catch
         java.lang.Exception
         e__1585__auto__
         (if
          (clojure.core/deref a__1584__auto__)
          (throw e__1585__auto__)
          (clojure.core/let
           [a__1584__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^java.lang.String a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args9889 0))]
             (clojure.core/reset! a__1584__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
               ^com.amazonaws.services.s3.AmazonS3Client client9890
               deleteBucket
               a)))
            (catch
             java.lang.Exception
             e__1585__auto__
             (if
              (clojure.core/deref a__1584__auto__)
              (throw e__1585__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "deleteBucket")
                {:args args9889}))))))))))))))
  (clojure.core/defn
   delete-bucket-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector bucket-name]}]
                [credentials string-0]]),
    :doc "Generate map for deleteBucket, deleteBucket"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :s3,
     :fn :delete-bucket,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   delete-bucket
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector bucket-name]}]
                [credentials string-0]]),
    :doc "Call deleteBucket, deleteBucket"}
   [credentials9893 & args9894]
   (clojure.core/let
    [^com.amazonaws.services.s3.AmazonS3Client client9896
     (com.palletops.awaze.common/aws-client :s3 credentials9893)]
    (clojure.core/case
     (clojure.core/count args9894)
     1
     (clojure.core/let
      [a__1584__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^com.amazonaws.services.s3.model.DeleteBucketRequest a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.DeleteBucketRequest
          (clojure.core/nth args9894 0))]
        (clojure.core/reset! a__1584__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
          ^com.amazonaws.services.s3.AmazonS3Client client9896
          deleteBucket
          a)))
       (catch
        java.lang.Exception
        e__1585__auto__
        (if
         (clojure.core/deref a__1584__auto__)
         (throw e__1585__auto__)
         (clojure.core/let
          [a__1584__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^java.lang.String a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args9894 0))]
            (clojure.core/reset! a__1584__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
              ^com.amazonaws.services.s3.AmazonS3Client client9896
              deleteBucket
              a)))
           (catch
            java.lang.Exception
            e__1585__auto__
            (if
             (clojure.core/deref a__1584__auto__)
             (throw e__1585__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "deleteBucket")
               {:args args9894}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :delete-object
   [m9897]
   (clojure.core/let
    [credentials9898 (:credentials m9897) args9899 (:args m9897)]
    (clojure.core/let
     [^com.amazonaws.services.s3.AmazonS3Client client9900
      (com.palletops.awaze.common/aws-client :s3 credentials9898)]
     (clojure.core/case
      (clojure.core/count args9899)
      2
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.s3.AmazonS3Client client9900
        deleteObject
        (clojure.core/str (clojure.core/nth args9899 0))
        (clojure.core/str (clojure.core/nth args9899 1))))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.s3.AmazonS3Client client9900
        deleteObject
        (delete-object-request (clojure.core/nth args9899 0))))))))
  (clojure.core/defn
   delete-object-map
   {:arglists (quote
               [[credentials string-0 string-1]
                [credentials
                 {:keys [request-metric-collector key bucket-name]}]]),
    :doc "Generate map for deleteObject, deleteObject"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :s3,
     :fn :delete-object,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a b]
    {:args [a b],
     :client :s3,
     :fn :delete-object,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   delete-object
   {:arglists (quote
               [[credentials string-0 string-1]
                [credentials
                 {:keys [request-metric-collector key bucket-name]}]]),
    :doc "Call deleteObject, deleteObject"}
   [credentials9904 & args9905]
   (clojure.core/let
    [^com.amazonaws.services.s3.AmazonS3Client client9908
     (com.palletops.awaze.common/aws-client :s3 credentials9904)]
    (clojure.core/case
     (clojure.core/count args9905)
     2
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client9908
       deleteObject
       (clojure.core/str (clojure.core/nth args9905 0))
       (clojure.core/str (clojure.core/nth args9905 1))))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client9908
       deleteObject
       (delete-object-request (clojure.core/nth args9905 0))))))))
 (do
  (clojure.core/defmethod
   s3
   :get-region
   [m9909]
   (clojure.core/let
    [credentials9910 (:credentials m9909) args9911 (:args m9909)]
    (clojure.core/let
     [^com.amazonaws.services.s3.AmazonS3Client client9912
      (com.palletops.awaze.common/aws-client :s3 credentials9910)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client9912
       getRegion)))))
  (clojure.core/defn
   get-region-map
   {:arglists (quote [[credentials]]),
    :doc "Generate map for getRegion"}
   ([credentials__1609__auto__]
    {:args [],
     :client :s3,
     :fn :get-region,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   get-region
   {:arglists (quote [[credentials]]), :doc "Call getRegion"}
   [credentials9914 & args9915]
   (clojure.core/let
    [^com.amazonaws.services.s3.AmazonS3Client client9916
     (com.palletops.awaze.common/aws-client :s3 credentials9914)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.s3.AmazonS3Client client9916
      getRegion)))))
 (do
  (clojure.core/defmethod
   s3
   :copy-part
   [m9917]
   (clojure.core/let
    [credentials9918 (:credentials m9917) args9919 (:args m9917)]
    (clojure.core/let
     [^com.amazonaws.services.s3.AmazonS3Client client9920
      (com.palletops.awaze.common/aws-client :s3 credentials9918)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client9920
       copyPart
       (copy-part-request (clojure.core/nth args9919 0)))))))
  (clojure.core/defn
   copy-part-map
   {:arglists (quote
               [[credentials
                 {:keys [source-key
                         request-metric-collector
                         source-bucket-name
                         last-byte
                         part-number
                         unmodified-since-constraint
                         upload-id
                         modified-since-constraint
                         first-byte
                         nonmatching-etag-constraints
                         destination-key
                         matching-etag-constraints
                         destination-bucket-name
                         source-version-id]}]]),
    :doc "Generate map for copyPart"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :s3,
     :fn :copy-part,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   copy-part
   {:arglists (quote
               [[credentials
                 {:keys [source-key
                         request-metric-collector
                         source-bucket-name
                         last-byte
                         part-number
                         unmodified-since-constraint
                         upload-id
                         modified-since-constraint
                         first-byte
                         nonmatching-etag-constraints
                         destination-key
                         matching-etag-constraints
                         destination-bucket-name
                         source-version-id]}]]),
    :doc "Call copyPart"}
   [credentials9922 & args9923]
   (clojure.core/let
    [^com.amazonaws.services.s3.AmazonS3Client client9924
     (com.palletops.awaze.common/aws-client :s3 credentials9922)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.s3.AmazonS3Client client9924
      copyPart
      (copy-part-request (clojure.core/nth args9923 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :initiate-multipart-upload
   [m9925]
   (clojure.core/let
    [credentials9926 (:credentials m9925) args9927 (:args m9925)]
    (clojure.core/let
     [^com.amazonaws.services.s3.AmazonS3Client client9928
      (com.palletops.awaze.common/aws-client :s3 credentials9926)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client9928
       initiateMultipartUpload
       (initiate-multipart-upload-request
        (clojure.core/nth args9927 0)))))))
  (clojure.core/defn
   initiate-multipart-upload-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         canned-acl
                         key
                         bucket-name
                         access-control-list
                         redirect-location
                         storage-class
                         object-metadata]}]]),
    :doc "Generate map for initiateMultipartUpload"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :s3,
     :fn :initiate-multipart-upload,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   initiate-multipart-upload
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         canned-acl
                         key
                         bucket-name
                         access-control-list
                         redirect-location
                         storage-class
                         object-metadata]}]]),
    :doc "Call initiateMultipartUpload"}
   [credentials9932 & args9933]
   (clojure.core/let
    [^com.amazonaws.services.s3.AmazonS3Client client9936
     (com.palletops.awaze.common/aws-client :s3 credentials9932)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.s3.AmazonS3Client client9936
      initiateMultipartUpload
      (initiate-multipart-upload-request
       (clojure.core/nth args9933 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :set-bucket-policy
   [m9937]
   (clojure.core/let
    [credentials9938 (:credentials m9937) args9939 (:args m9937)]
    (clojure.core/let
     [^com.amazonaws.services.s3.AmazonS3Client client9940
      (com.palletops.awaze.common/aws-client :s3 credentials9938)]
     (clojure.core/case
      (clojure.core/count args9939)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.s3.AmazonS3Client client9940
        setBucketPolicy
        (set-bucket-policy-request (clojure.core/nth args9939 0))))
      2
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.s3.AmazonS3Client client9940
        setBucketPolicy
        (clojure.core/str (clojure.core/nth args9939 0))
        (clojure.core/str (clojure.core/nth args9939 1))))))))
  (clojure.core/defn
   set-bucket-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         policy-text
                         bucket-name]}]
                [credentials string-0 string-1]]),
    :doc "Generate map for setBucketPolicy, setBucketPolicy"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :s3,
     :fn :set-bucket-policy,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a b]
    {:args [a b],
     :client :s3,
     :fn :set-bucket-policy,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   set-bucket-policy
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         policy-text
                         bucket-name]}]
                [credentials string-0 string-1]]),
    :doc "Call setBucketPolicy, setBucketPolicy"}
   [credentials9944 & args9945]
   (clojure.core/let
    [^com.amazonaws.services.s3.AmazonS3Client client9948
     (com.palletops.awaze.common/aws-client :s3 credentials9944)]
    (clojure.core/case
     (clojure.core/count args9945)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client9948
       setBucketPolicy
       (set-bucket-policy-request (clojure.core/nth args9945 0))))
     2
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client9948
       setBucketPolicy
       (clojure.core/str (clojure.core/nth args9945 0))
       (clojure.core/str (clojure.core/nth args9945 1))))))))
 (do
  (clojure.core/defmethod
   s3
   :get-bucket-notification-configuration
   [m9949]
   (clojure.core/let
    [credentials9950 (:credentials m9949) args9951 (:args m9949)]
    (clojure.core/let
     [^com.amazonaws.services.s3.AmazonS3Client client9952
      (com.palletops.awaze.common/aws-client :s3 credentials9950)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client9952
       getBucketNotificationConfiguration
       (clojure.core/str (clojure.core/nth args9951 0)))))))
  (clojure.core/defn
   get-bucket-notification-configuration-map
   {:arglists (quote [[credentials string-0]]),
    :doc "Generate map for getBucketNotificationConfiguration"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :s3,
     :fn :get-bucket-notification-configuration,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   get-bucket-notification-configuration
   {:arglists (quote [[credentials string-0]]),
    :doc "Call getBucketNotificationConfiguration"}
   [credentials9954 & args9955]
   (clojure.core/let
    [^com.amazonaws.services.s3.AmazonS3Client client9956
     (com.palletops.awaze.common/aws-client :s3 credentials9954)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.s3.AmazonS3Client client9956
      getBucketNotificationConfiguration
      (clojure.core/str (clojure.core/nth args9955 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :generate-presigned-url
   [m9957]
   (clojure.core/let
    [credentials9958 (:credentials m9957) args9959 (:args m9957)]
    (clojure.core/let
     [^com.amazonaws.services.s3.AmazonS3Client client9960
      (com.palletops.awaze.common/aws-client :s3 credentials9958)]
     (clojure.core/case
      (clojure.core/count args9959)
      4
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.s3.AmazonS3Client client9960
        generatePresignedUrl
        (clojure.core/str (clojure.core/nth args9959 0))
        (clojure.core/str (clojure.core/nth args9959 1))
        (com.palletops.awaze.common/to-date
         (clojure.core/nth args9959 2))
        (http-method (clojure.core/nth args9959 3))))
      3
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.s3.AmazonS3Client client9960
        generatePresignedUrl
        (clojure.core/str (clojure.core/nth args9959 0))
        (clojure.core/str (clojure.core/nth args9959 1))
        (com.palletops.awaze.common/to-date
         (clojure.core/nth args9959 2))))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.s3.AmazonS3Client client9960
        generatePresignedUrl
        (generate-presigned-url-request (clojure.core/nth args9959 0))))))))
  (clojure.core/defn
   generate-presigned-url-map
   {:arglists (quote
               [[credentials string-0 string-1 date-2 http-method-3]
                [credentials string-0 string-1 date-2]
                [credentials
                 {:keys [request-metric-collector
                         expiration
                         response-headers
                         key
                         method
                         bucket-name
                         content-type
                         request-parameters]}]]),
    :doc "Generate map for generatePresignedUrl, generatePresignedUrl, generatePresignedUrl"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :s3,
     :fn :generate-presigned-url,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a b c]
    {:args [a b c],
     :client :s3,
     :fn :generate-presigned-url,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a b c d]
    {:args [a b c d],
     :client :s3,
     :fn :generate-presigned-url,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   generate-presigned-url
   {:arglists (quote
               [[credentials string-0 string-1 date-2 http-method-3]
                [credentials string-0 string-1 date-2]
                [credentials
                 {:keys [request-metric-collector
                         expiration
                         response-headers
                         key
                         method
                         bucket-name
                         content-type
                         request-parameters]}]]),
    :doc "Call generatePresignedUrl, generatePresignedUrl, generatePresignedUrl"}
   [credentials9964 & args9965]
   (clojure.core/let
    [^com.amazonaws.services.s3.AmazonS3Client client9968
     (com.palletops.awaze.common/aws-client :s3 credentials9964)]
    (clojure.core/case
     (clojure.core/count args9965)
     4
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client9968
       generatePresignedUrl
       (clojure.core/str (clojure.core/nth args9965 0))
       (clojure.core/str (clojure.core/nth args9965 1))
       (com.palletops.awaze.common/to-date
        (clojure.core/nth args9965 2))
       (http-method (clojure.core/nth args9965 3))))
     3
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client9968
       generatePresignedUrl
       (clojure.core/str (clojure.core/nth args9965 0))
       (clojure.core/str (clojure.core/nth args9965 1))
       (com.palletops.awaze.common/to-date
        (clojure.core/nth args9965 2))))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client9968
       generatePresignedUrl
       (generate-presigned-url-request (clojure.core/nth args9965 0))))))))
 (do
  (clojure.core/defmethod
   s3
   :list-parts
   [m9969]
   (clojure.core/let
    [credentials9970 (:credentials m9969) args9971 (:args m9969)]
    (clojure.core/let
     [^com.amazonaws.services.s3.AmazonS3Client client9972
      (com.palletops.awaze.common/aws-client :s3 credentials9970)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client9972
       listParts
       (list-parts-request (clojure.core/nth args9971 0)))))))
  (clojure.core/defn
   list-parts-map
   {:arglists (quote
               [[credentials
                 {:keys [upload-id
                         request-metric-collector
                         part-number-marker
                         max-parts
                         key
                         bucket-name]}]]),
    :doc "Generate map for listParts"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :s3,
     :fn :list-parts,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   list-parts
   {:arglists (quote
               [[credentials
                 {:keys [upload-id
                         request-metric-collector
                         part-number-marker
                         max-parts
                         key
                         bucket-name]}]]),
    :doc "Call listParts"}
   [credentials9977 & args9978]
   (clojure.core/let
    [^com.amazonaws.services.s3.AmazonS3Client client9982
     (com.palletops.awaze.common/aws-client :s3 credentials9977)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.s3.AmazonS3Client client9982
      listParts
      (list-parts-request (clojure.core/nth args9978 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :get-s3account-owner
   [m9983]
   (clojure.core/let
    [credentials9984 (:credentials m9983) args9985 (:args m9983)]
    (clojure.core/let
     [^com.amazonaws.services.s3.AmazonS3Client client9986
      (com.palletops.awaze.common/aws-client :s3 credentials9984)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client9986
       getS3AccountOwner)))))
  (clojure.core/defn
   get-s3account-owner-map
   {:arglists (quote [[credentials]]),
    :doc "Generate map for getS3AccountOwner"}
   ([credentials__1609__auto__]
    {:args [],
     :client :s3,
     :fn :get-s3account-owner,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   get-s3account-owner
   {:arglists (quote [[credentials]]), :doc "Call getS3AccountOwner"}
   [credentials9988 & args9989]
   (clojure.core/let
    [^com.amazonaws.services.s3.AmazonS3Client client9990
     (com.palletops.awaze.common/aws-client :s3 credentials9988)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.s3.AmazonS3Client client9990
      getS3AccountOwner)))))
 (do
  (clojure.core/defmethod
   s3
   :get-bucket-logging-configuration
   [m9991]
   (clojure.core/let
    [credentials9992 (:credentials m9991) args9993 (:args m9991)]
    (clojure.core/let
     [^com.amazonaws.services.s3.AmazonS3Client client9994
      (com.palletops.awaze.common/aws-client :s3 credentials9992)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client9994
       getBucketLoggingConfiguration
       (clojure.core/str (clojure.core/nth args9993 0)))))))
  (clojure.core/defn
   get-bucket-logging-configuration-map
   {:arglists (quote [[credentials string-0]]),
    :doc "Generate map for getBucketLoggingConfiguration"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :s3,
     :fn :get-bucket-logging-configuration,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   get-bucket-logging-configuration
   {:arglists (quote [[credentials string-0]]),
    :doc "Call getBucketLoggingConfiguration"}
   [credentials9996 & args9997]
   (clojure.core/let
    [^com.amazonaws.services.s3.AmazonS3Client client9998
     (com.palletops.awaze.common/aws-client :s3 credentials9996)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.s3.AmazonS3Client client9998
      getBucketLoggingConfiguration
      (clojure.core/str (clojure.core/nth args9997 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :list-buckets
   [m9999]
   (clojure.core/let
    [credentials10000 (:credentials m9999) args10001 (:args m9999)]
    (clojure.core/let
     [^com.amazonaws.services.s3.AmazonS3Client client10002
      (com.palletops.awaze.common/aws-client :s3 credentials10000)]
     (clojure.core/case
      (clojure.core/count args10001)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.s3.AmazonS3Client client10002
        listBuckets
        (list-buckets-request (clojure.core/nth args10001 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.s3.AmazonS3Client client10002
        listBuckets))))))
  (clojure.core/defn
   list-buckets-map
   {:arglists (quote
               [[credentials {:keys [request-metric-collector]}]
                [credentials]]),
    :doc "Generate map for listBuckets, listBuckets"}
   ([credentials__1609__auto__]
    {:args [],
     :client :s3,
     :fn :list-buckets,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :s3,
     :fn :list-buckets,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   list-buckets
   {:arglists (quote
               [[credentials {:keys [request-metric-collector]}]
                [credentials]]),
    :doc "Call listBuckets, listBuckets"}
   [credentials10004 & args10005]
   (clojure.core/let
    [^com.amazonaws.services.s3.AmazonS3Client client10006
     (com.palletops.awaze.common/aws-client :s3 credentials10004)]
    (clojure.core/case
     (clojure.core/count args10005)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client10006
       listBuckets
       (list-buckets-request (clojure.core/nth args10005 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client10006
       listBuckets))))))
 (do
  (clojure.core/defmethod
   s3
   :set-bucket-logging-configuration
   [m10007]
   (clojure.core/let
    [credentials10008 (:credentials m10007) args10009 (:args m10007)]
    (clojure.core/let
     [^com.amazonaws.services.s3.AmazonS3Client client10010
      (com.palletops.awaze.common/aws-client :s3 credentials10008)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client10010
       setBucketLoggingConfiguration
       (set-bucket-logging-configuration-request
        (clojure.core/nth args10009 0)))))))
  (clojure.core/defn
   set-bucket-logging-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         logging-configuration
                         bucket-name]}]]),
    :doc "Generate map for setBucketLoggingConfiguration"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :s3,
     :fn :set-bucket-logging-configuration,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   set-bucket-logging-configuration
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         logging-configuration
                         bucket-name]}]]),
    :doc "Call setBucketLoggingConfiguration"}
   [credentials10014 & args10015]
   (clojure.core/let
    [^com.amazonaws.services.s3.AmazonS3Client client10018
     (com.palletops.awaze.common/aws-client :s3 credentials10014)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.s3.AmazonS3Client client10018
      setBucketLoggingConfiguration
      (set-bucket-logging-configuration-request
       (clojure.core/nth args10015 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :get-bucket-acl
   [m10019]
   (clojure.core/let
    [credentials10020 (:credentials m10019) args10021 (:args m10019)]
    (clojure.core/let
     [^com.amazonaws.services.s3.AmazonS3Client client10022
      (com.palletops.awaze.common/aws-client :s3 credentials10020)]
     (clojure.core/case
      (clojure.core/count args10021)
      1
      (clojure.core/let
       [a__1584__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^com.amazonaws.services.s3.model.GetBucketAclRequest a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.GetBucketAclRequest
           (clojure.core/nth args10021 0))]
         (clojure.core/reset! a__1584__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
           ^com.amazonaws.services.s3.AmazonS3Client client10022
           getBucketAcl
           a)))
        (catch
         java.lang.Exception
         e__1585__auto__
         (if
          (clojure.core/deref a__1584__auto__)
          (throw e__1585__auto__)
          (clojure.core/let
           [a__1584__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^java.lang.String a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args10021 0))]
             (clojure.core/reset! a__1584__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
               ^com.amazonaws.services.s3.AmazonS3Client client10022
               getBucketAcl
               a)))
            (catch
             java.lang.Exception
             e__1585__auto__
             (if
              (clojure.core/deref a__1584__auto__)
              (throw e__1585__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "getBucketAcl")
                {:args args10021}))))))))))))))
  (clojure.core/defn
   get-bucket-acl-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector bucket-name]}]
                [credentials string-0]]),
    :doc "Generate map for getBucketAcl, getBucketAcl"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :s3,
     :fn :get-bucket-acl,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   get-bucket-acl
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector bucket-name]}]
                [credentials string-0]]),
    :doc "Call getBucketAcl, getBucketAcl"}
   [credentials10025 & args10026]
   (clojure.core/let
    [^com.amazonaws.services.s3.AmazonS3Client client10028
     (com.palletops.awaze.common/aws-client :s3 credentials10025)]
    (clojure.core/case
     (clojure.core/count args10026)
     1
     (clojure.core/let
      [a__1584__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^com.amazonaws.services.s3.model.GetBucketAclRequest a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.GetBucketAclRequest
          (clojure.core/nth args10026 0))]
        (clojure.core/reset! a__1584__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
          ^com.amazonaws.services.s3.AmazonS3Client client10028
          getBucketAcl
          a)))
       (catch
        java.lang.Exception
        e__1585__auto__
        (if
         (clojure.core/deref a__1584__auto__)
         (throw e__1585__auto__)
         (clojure.core/let
          [a__1584__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^java.lang.String a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args10026 0))]
            (clojure.core/reset! a__1584__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
              ^com.amazonaws.services.s3.AmazonS3Client client10028
              getBucketAcl
              a)))
           (catch
            java.lang.Exception
            e__1585__auto__
            (if
             (clojure.core/deref a__1584__auto__)
             (throw e__1585__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "getBucketAcl")
               {:args args10026}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :list-next-batch-of-versions
   [m10029]
   (clojure.core/let
    [credentials10030 (:credentials m10029) args10031 (:args m10029)]
    (clojure.core/let
     [^com.amazonaws.services.s3.AmazonS3Client client10032
      (com.palletops.awaze.common/aws-client :s3 credentials10030)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.s3.AmazonS3Client client10032
       listNextBatchOfVersions
       (version-listing (clojure.core/nth args10031 0)))))))
  (clojure.core/defn
   list-next-batch-of-versions-map
   {:arglists (quote
               [[credentials
                 {:keys [prefix
                         bucket-name
                         common-prefixes
                         version-summaries
                         max-keys
                         truncated
                         key-marker
                         next-key-marker
                         delimiter
                         next-version-id-marker
                         version-id-marker]}]]),
    :doc "Generate map for listNextBatchOfVersions"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :s3,
     :fn :list-next-batch-of-versions,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   list-next-batch-of-versions
   {:arglists (quote
               [[credentials
                 {:keys [prefix
                         bucket-name
                         common-prefixes
                         version-summaries
                         max-keys
                         truncated
                         key-marker
                         next-key-marker
                         delimiter
                         next-version-id-marker
                         version-id-marker]}]]),
    :doc "Call listNextBatchOfVersions"}
   [credentials10034 & args10035]
   (clojure.core/let
    [^com.amazonaws.services.s3.AmazonS3Client client10036
     (com.palletops.awaze.common/aws-client :s3 credentials10034)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.s3.AmazonS3Client client10036
      listNextBatchOfVersions
      (version-listing (clojure.core/nth args10035 0))))))))
