(ns
 com.palletops.awaze.securitytoken
 (:require [com.palletops.awaze.common]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :securitytoken
  [___1561__auto__
   ^com.amazonaws.auth.BasicAWSCredentials credentials__1562__auto__]
  (new
   com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient
   credentials__1562__auto__))
 (clojure.core/defn
  ^com.amazonaws.services.securitytoken.model.AssumeRoleRequest assume-role-request
  [m8921]
  (clojure.core/let
   [bean8920
    (new com.amazonaws.services.securitytoken.model.AssumeRoleRequest)]
   (clojure.core/when-let
    [v8922 (:duration-seconds m8921)]
    (. bean8920 setDurationSeconds (clojure.core/int v8922)))
   (clojure.core/when-let
    [v8922 (:role-arn m8921)]
    (. bean8920 setRoleArn (clojure.core/str v8922)))
   (clojure.core/when-let
    [v8922 (:role-session-name m8921)]
    (. bean8920 setRoleSessionName (clojure.core/str v8922)))
   (clojure.core/when-let
    [v8922 (:external-id m8921)]
    (. bean8920 setExternalId (clojure.core/str v8922)))
   (clojure.core/when-let
    [v8922 (:policy m8921)]
    (. bean8920 setPolicy (clojure.core/str v8922)))
   bean8920))
 (clojure.core/defn
  ^com.amazonaws.services.securitytoken.model.GetFederationTokenRequest get-federation-token-request
  [m8924]
  (clojure.core/let
   [bean8923
    (new
     com.amazonaws.services.securitytoken.model.GetFederationTokenRequest)]
   (clojure.core/when-let
    [v8925 (:name m8924)]
    (. bean8923 setName (clojure.core/str v8925)))
   (clojure.core/when-let
    [v8925 (:duration-seconds m8924)]
    (. bean8923 setDurationSeconds (clojure.core/int v8925)))
   (clojure.core/when-let
    [v8925 (:policy m8924)]
    (. bean8923 setPolicy (clojure.core/str v8925)))
   bean8923))
 (clojure.core/defn
  ^com.amazonaws.services.securitytoken.model.AssumeRoleWithWebIdentityRequest assume-role-with-web-identity-request
  [m8927]
  (clojure.core/let
   [bean8926
    (new
     com.amazonaws.services.securitytoken.model.AssumeRoleWithWebIdentityRequest)]
   (clojure.core/when-let
    [v8928 (:duration-seconds m8927)]
    (. bean8926 setDurationSeconds (clojure.core/int v8928)))
   (clojure.core/when-let
    [v8928 (:role-arn m8927)]
    (. bean8926 setRoleArn (clojure.core/str v8928)))
   (clojure.core/when-let
    [v8928 (:role-session-name m8927)]
    (. bean8926 setRoleSessionName (clojure.core/str v8928)))
   (clojure.core/when-let
    [v8928 (:web-identity-token m8927)]
    (. bean8926 setWebIdentityToken (clojure.core/str v8928)))
   (clojure.core/when-let
    [v8928 (:provider-id m8927)]
    (. bean8926 setProviderId (clojure.core/str v8928)))
   (clojure.core/when-let
    [v8928 (:policy m8927)]
    (. bean8926 setPolicy (clojure.core/str v8928)))
   bean8926))
 (clojure.core/defn
  ^com.amazonaws.services.securitytoken.model.DecodeAuthorizationMessageRequest decode-authorization-message-request
  [m8930]
  (clojure.core/let
   [bean8929
    (new
     com.amazonaws.services.securitytoken.model.DecodeAuthorizationMessageRequest)]
   (clojure.core/when-let
    [v8931 (:encoded-message m8930)]
    (. bean8929 setEncodedMessage (clojure.core/str v8931)))
   bean8929))
 (clojure.core/defn
  ^com.amazonaws.services.securitytoken.model.GetSessionTokenRequest get-session-token-request
  [m8933]
  (clojure.core/let
   [bean8932
    (new
     com.amazonaws.services.securitytoken.model.GetSessionTokenRequest)]
   (clojure.core/when-let
    [v8934 (:duration-seconds m8933)]
    (. bean8932 setDurationSeconds (clojure.core/int v8934)))
   (clojure.core/when-let
    [v8934 (:serial-number m8933)]
    (. bean8932 setSerialNumber (clojure.core/str v8934)))
   (clojure.core/when-let
    [v8934 (:token-code m8933)]
    (. bean8932 setTokenCode (clojure.core/str v8934)))
   bean8932))
 (clojure.core/defmulti
  securitytoken
  (clojure.core/fn
   securitytoken
   [m__1641__auto__]
   (:fn m__1641__auto__)))
 (do
  (clojure.core/defmethod
   securitytoken
   :assume-role
   [m8935]
   (clojure.core/let
    [credentials8936 (:credentials m8935) args8937 (:args m8935)]
    (clojure.core/let
     [^com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient client8938
      (com.palletops.awaze.common/aws-client
       :securitytoken
       credentials8936)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient client8938
       assumeRole
       (assume-role-request (clojure.core/nth args8937 0)))))))
  (clojure.core/defn
   assume-role-map
   {:arglists (quote
               [[credentials
                 {:keys [role-session-name
                         role-arn
                         request-metric-collector
                         policy
                         external-id
                         duration-seconds]}]]),
    :doc "Generate map for assumeRole"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :securitytoken,
     :fn :assume-role,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   assume-role
   {:arglists (quote
               [[credentials
                 {:keys [role-session-name
                         role-arn
                         request-metric-collector
                         policy
                         external-id
                         duration-seconds]}]]),
    :doc "Call assumeRole"}
   [credentials8940 & args8941]
   (clojure.core/let
    [^com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient client8942
     (com.palletops.awaze.common/aws-client
      :securitytoken
      credentials8940)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient client8942
      assumeRole
      (assume-role-request (clojure.core/nth args8941 0)))))))
 (do
  (clojure.core/defmethod
   securitytoken
   :get-federation-token
   [m8943]
   (clojure.core/let
    [credentials8944 (:credentials m8943) args8945 (:args m8943)]
    (clojure.core/let
     [^com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient client8946
      (com.palletops.awaze.common/aws-client
       :securitytoken
       credentials8944)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient client8946
       getFederationToken
       (get-federation-token-request (clojure.core/nth args8945 0)))))))
  (clojure.core/defn
   get-federation-token-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         policy
                         name
                         duration-seconds]}]]),
    :doc "Generate map for getFederationToken"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :securitytoken,
     :fn :get-federation-token,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   get-federation-token
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         policy
                         name
                         duration-seconds]}]]),
    :doc "Call getFederationToken"}
   [credentials8948 & args8949]
   (clojure.core/let
    [^com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient client8950
     (com.palletops.awaze.common/aws-client
      :securitytoken
      credentials8948)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient client8950
      getFederationToken
      (get-federation-token-request (clojure.core/nth args8949 0)))))))
 (do
  (clojure.core/defmethod
   securitytoken
   :assume-role-with-web-identity
   [m8951]
   (clojure.core/let
    [credentials8952 (:credentials m8951) args8953 (:args m8951)]
    (clojure.core/let
     [^com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient client8954
      (com.palletops.awaze.common/aws-client
       :securitytoken
       credentials8952)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient client8954
       assumeRoleWithWebIdentity
       (assume-role-with-web-identity-request
        (clojure.core/nth args8953 0)))))))
  (clojure.core/defn
   assume-role-with-web-identity-map
   {:arglists (quote
               [[credentials
                 {:keys [duration-seconds
                         role-arn
                         role-session-name
                         provider-id
                         policy
                         web-identity-token
                         request-metric-collector]}]]),
    :doc "Generate map for assumeRoleWithWebIdentity"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :securitytoken,
     :fn :assume-role-with-web-identity,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   assume-role-with-web-identity
   {:arglists (quote
               [[credentials
                 {:keys [duration-seconds
                         role-arn
                         role-session-name
                         provider-id
                         policy
                         web-identity-token
                         request-metric-collector]}]]),
    :doc "Call assumeRoleWithWebIdentity"}
   [credentials8956 & args8957]
   (clojure.core/let
    [^com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient client8958
     (com.palletops.awaze.common/aws-client
      :securitytoken
      credentials8956)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient client8958
      assumeRoleWithWebIdentity
      (assume-role-with-web-identity-request
       (clojure.core/nth args8957 0)))))))
 (do
  (clojure.core/defmethod
   securitytoken
   :decode-authorization-message
   [m8959]
   (clojure.core/let
    [credentials8960 (:credentials m8959) args8961 (:args m8959)]
    (clojure.core/let
     [^com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient client8962
      (com.palletops.awaze.common/aws-client
       :securitytoken
       credentials8960)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient client8962
       decodeAuthorizationMessage
       (decode-authorization-message-request
        (clojure.core/nth args8961 0)))))))
  (clojure.core/defn
   decode-authorization-message-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector encoded-message]}]]),
    :doc "Generate map for decodeAuthorizationMessage"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :securitytoken,
     :fn :decode-authorization-message,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   decode-authorization-message
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector encoded-message]}]]),
    :doc "Call decodeAuthorizationMessage"}
   [credentials8964 & args8965]
   (clojure.core/let
    [^com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient client8966
     (com.palletops.awaze.common/aws-client
      :securitytoken
      credentials8964)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient client8966
      decodeAuthorizationMessage
      (decode-authorization-message-request
       (clojure.core/nth args8965 0)))))))
 (do
  (clojure.core/defmethod
   securitytoken
   :get-session-token
   [m8967]
   (clojure.core/let
    [credentials8968 (:credentials m8967) args8969 (:args m8967)]
    (clojure.core/let
     [^com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient client8970
      (com.palletops.awaze.common/aws-client
       :securitytoken
       credentials8968)]
     (clojure.core/case
      (clojure.core/count args8969)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient client8970
        getSessionToken
        (get-session-token-request (clojure.core/nth args8969 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient client8970
        getSessionToken))))))
  (clojure.core/defn
   get-session-token-map
   {:arglists (quote
               [[credentials
                 {:keys [token-code
                         serial-number
                         request-metric-collector
                         duration-seconds]}]
                [credentials]]),
    :doc "Generate map for getSessionToken, getSessionToken"}
   ([credentials__1609__auto__]
    {:args [],
     :client :securitytoken,
     :fn :get-session-token,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :securitytoken,
     :fn :get-session-token,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   get-session-token
   {:arglists (quote
               [[credentials
                 {:keys [token-code
                         serial-number
                         request-metric-collector
                         duration-seconds]}]
                [credentials]]),
    :doc "Call getSessionToken, getSessionToken"}
   [credentials8972 & args8973]
   (clojure.core/let
    [^com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient client8974
     (com.palletops.awaze.common/aws-client
      :securitytoken
      credentials8972)]
    (clojure.core/case
     (clojure.core/count args8973)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient client8974
       getSessionToken
       (get-session-token-request (clojure.core/nth args8973 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient client8974
       getSessionToken)))))))
