(ns
 com.palletops.awaze.simpledb
 (:require [com.palletops.awaze.common]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :simpledb
  [___1561__auto__
   ^com.amazonaws.auth.BasicAWSCredentials credentials__1562__auto__]
  (new
   com.amazonaws.services.simpledb.AmazonSimpleDBClient
   credentials__1562__auto__))
 (clojure.core/defn
  ^com.amazonaws.services.simpledb.model.Attribute attribute
  [m3779]
  (clojure.core/let
   [bean3778 (new com.amazonaws.services.simpledb.model.Attribute)]
   (clojure.core/when-let
    [v3780 (:name m3779)]
    (. bean3778 setName (clojure.core/str v3780)))
   (clojure.core/when-let
    [v3780 (:value m3779)]
    (. bean3778 setValue (clojure.core/str v3780)))
   (clojure.core/when-let
    [v3780 (:alternate-name-encoding m3779)]
    (. bean3778 setAlternateNameEncoding (clojure.core/str v3780)))
   (clojure.core/when-let
    [v3780 (:alternate-value-encoding m3779)]
    (. bean3778 setAlternateValueEncoding (clojure.core/str v3780)))
   bean3778))
 (clojure.core/defn
  ^com.amazonaws.services.simpledb.model.ReplaceableAttribute replaceable-attribute
  [m3782]
  (clojure.core/let
   [bean3781
    (new com.amazonaws.services.simpledb.model.ReplaceableAttribute)]
   (clojure.core/when-let
    [v3783 (:name m3782)]
    (. bean3781 setName (clojure.core/str v3783)))
   (clojure.core/when-let
    [v3783 (:value m3782)]
    (. bean3781 setValue (clojure.core/str v3783)))
   (clojure.core/when-let
    [v3783 (:replace m3782)]
    (. bean3781 setReplace (clojure.core/boolean v3783)))
   bean3781))
 (clojure.core/defn
  ^com.amazonaws.services.simpledb.model.DeletableItem deletable-item
  [m3785]
  (clojure.core/let
   [bean3784
    (new com.amazonaws.services.simpledb.model.DeletableItem)]
   (clojure.core/when-let
    [v3786 (:name m3785)]
    (. bean3784 setName (clojure.core/str v3786)))
   (clojure.core/when-let
    [v3786 (:attributes m3785)]
    (.
     bean3784
     setAttributes
     (clojure.core/map
      (clojure.core/fn [arg3790] (attribute arg3790))
      v3786)))
   bean3784))
 (clojure.core/defn
  ^com.amazonaws.services.simpledb.model.UpdateCondition update-condition
  [m3788]
  (clojure.core/let
   [bean3787
    (new com.amazonaws.services.simpledb.model.UpdateCondition)]
   (clojure.core/when-let
    [v3789 (:name m3788)]
    (. bean3787 setName (clojure.core/str v3789)))
   (clojure.core/when-let
    [v3789 (:value m3788)]
    (. bean3787 setValue (clojure.core/str v3789)))
   (clojure.core/when-let
    [v3789 (:exists m3788)]
    (. bean3787 setExists (clojure.core/boolean v3789)))
   bean3787))
 (clojure.core/defn
  ^com.amazonaws.services.simpledb.model.ReplaceableItem replaceable-item
  [m3792]
  (clojure.core/let
   [bean3791
    (new com.amazonaws.services.simpledb.model.ReplaceableItem)]
   (clojure.core/when-let
    [v3793 (:name m3792)]
    (. bean3791 setName (clojure.core/str v3793)))
   (clojure.core/when-let
    [v3793 (:attributes m3792)]
    (.
     bean3791
     setAttributes
     (clojure.core/map
      (clojure.core/fn [arg3797] (replaceable-attribute arg3797))
      v3793)))
   bean3791))
 (clojure.core/defn
  ^com.amazonaws.services.simpledb.model.DomainMetadataRequest domain-metadata-request
  [m3795]
  (clojure.core/let
   [bean3794
    (new com.amazonaws.services.simpledb.model.DomainMetadataRequest)]
   (clojure.core/when-let
    [v3796 (:domain-name m3795)]
    (. bean3794 setDomainName (clojure.core/str v3796)))
   bean3794))
 (clojure.core/defn
  ^com.amazonaws.services.simpledb.model.GetAttributesRequest get-attributes-request
  [m3799]
  (clojure.core/let
   [bean3798
    (new com.amazonaws.services.simpledb.model.GetAttributesRequest)]
   (clojure.core/when-let
    [v3800 (:domain-name m3799)]
    (. bean3798 setDomainName (clojure.core/str v3800)))
   (clojure.core/when-let
    [v3800 (:item-name m3799)]
    (. bean3798 setItemName (clojure.core/str v3800)))
   (clojure.core/when-let
    [v3800 (:attribute-names m3799)]
    (.
     bean3798
     setAttributeNames
     (clojure.core/map
      (clojure.core/fn [arg3804] (clojure.core/str arg3804))
      v3800)))
   (clojure.core/when-let
    [v3800 (:consistent-read m3799)]
    (. bean3798 setConsistentRead (clojure.core/boolean v3800)))
   bean3798))
 (clojure.core/defn
  ^com.amazonaws.services.simpledb.model.CreateDomainRequest create-domain-request
  [m3802]
  (clojure.core/let
   [bean3801
    (new com.amazonaws.services.simpledb.model.CreateDomainRequest)]
   (clojure.core/when-let
    [v3803 (:domain-name m3802)]
    (. bean3801 setDomainName (clojure.core/str v3803)))
   bean3801))
 (clojure.core/defn
  ^com.amazonaws.services.simpledb.model.BatchDeleteAttributesRequest batch-delete-attributes-request
  [m3806]
  (clojure.core/let
   [bean3805
    (new
     com.amazonaws.services.simpledb.model.BatchDeleteAttributesRequest)]
   (clojure.core/when-let
    [v3807 (:items m3806)]
    (.
     bean3805
     setItems
     (clojure.core/map
      (clojure.core/fn [arg3811] (deletable-item arg3811))
      v3807)))
   (clojure.core/when-let
    [v3807 (:domain-name m3806)]
    (. bean3805 setDomainName (clojure.core/str v3807)))
   bean3805))
 (clojure.core/defn
  ^com.amazonaws.services.simpledb.model.ListDomainsRequest list-domains-request
  [m3809]
  (clojure.core/let
   [bean3808
    (new com.amazonaws.services.simpledb.model.ListDomainsRequest)]
   (clojure.core/when-let
    [v3810 (:next-token m3809)]
    (. bean3808 setNextToken (clojure.core/str v3810)))
   (clojure.core/when-let
    [v3810 (:max-number-of-domains m3809)]
    (. bean3808 setMaxNumberOfDomains (clojure.core/int v3810)))
   bean3808))
 (clojure.core/defn
  ^com.amazonaws.services.simpledb.model.PutAttributesRequest put-attributes-request
  [m3813]
  (clojure.core/let
   [bean3812
    (new com.amazonaws.services.simpledb.model.PutAttributesRequest)]
   (clojure.core/when-let
    [v3814 (:attributes m3813)]
    (.
     bean3812
     setAttributes
     (clojure.core/map
      (clojure.core/fn [arg3818] (replaceable-attribute arg3818))
      v3814)))
   (clojure.core/when-let
    [v3814 (:domain-name m3813)]
    (. bean3812 setDomainName (clojure.core/str v3814)))
   (clojure.core/when-let
    [v3814 (:item-name m3813)]
    (. bean3812 setItemName (clojure.core/str v3814)))
   (clojure.core/when-let
    [v3814 (:expected m3813)]
    (. bean3812 setExpected (update-condition v3814)))
   bean3812))
 (clojure.core/defn
  ^com.amazonaws.services.simpledb.model.DeleteAttributesRequest delete-attributes-request
  [m3816]
  (clojure.core/let
   [bean3815
    (new
     com.amazonaws.services.simpledb.model.DeleteAttributesRequest)]
   (clojure.core/when-let
    [v3817 (:attributes m3816)]
    (.
     bean3815
     setAttributes
     (clojure.core/map
      (clojure.core/fn [arg3822] (attribute arg3822))
      v3817)))
   (clojure.core/when-let
    [v3817 (:domain-name m3816)]
    (. bean3815 setDomainName (clojure.core/str v3817)))
   (clojure.core/when-let
    [v3817 (:item-name m3816)]
    (. bean3815 setItemName (clojure.core/str v3817)))
   (clojure.core/when-let
    [v3817 (:expected m3816)]
    (. bean3815 setExpected (update-condition v3817)))
   bean3815))
 (clojure.core/defn
  ^com.amazonaws.services.simpledb.model.BatchPutAttributesRequest batch-put-attributes-request
  [m3820]
  (clojure.core/let
   [bean3819
    (new
     com.amazonaws.services.simpledb.model.BatchPutAttributesRequest)]
   (clojure.core/when-let
    [v3821 (:items m3820)]
    (.
     bean3819
     setItems
     (clojure.core/map
      (clojure.core/fn [arg3826] (replaceable-item arg3826))
      v3821)))
   (clojure.core/when-let
    [v3821 (:domain-name m3820)]
    (. bean3819 setDomainName (clojure.core/str v3821)))
   bean3819))
 (clojure.core/defn
  ^com.amazonaws.services.simpledb.model.DeleteDomainRequest delete-domain-request
  [m3824]
  (clojure.core/let
   [bean3823
    (new com.amazonaws.services.simpledb.model.DeleteDomainRequest)]
   (clojure.core/when-let
    [v3825 (:domain-name m3824)]
    (. bean3823 setDomainName (clojure.core/str v3825)))
   bean3823))
 (clojure.core/defn
  ^com.amazonaws.services.simpledb.model.SelectRequest select-request
  [m3828]
  (clojure.core/let
   [bean3827
    (new com.amazonaws.services.simpledb.model.SelectRequest)]
   (clojure.core/when-let
    [v3829 (:next-token m3828)]
    (. bean3827 setNextToken (clojure.core/str v3829)))
   (clojure.core/when-let
    [v3829 (:consistent-read m3828)]
    (. bean3827 setConsistentRead (clojure.core/boolean v3829)))
   (clojure.core/when-let
    [v3829 (:select-expression m3828)]
    (. bean3827 setSelectExpression (clojure.core/str v3829)))
   bean3827))
 (clojure.core/defmulti
  simpledb
  (clojure.core/fn simpledb [m__1641__auto__] (:fn m__1641__auto__)))
 (do
  (clojure.core/defmethod
   simpledb
   :domain-metadata
   [m3830]
   (clojure.core/let
    [credentials3831 (:credentials m3830) args3832 (:args m3830)]
    (clojure.core/let
     [^com.amazonaws.services.simpledb.AmazonSimpleDBClient client3833
      (com.palletops.awaze.common/aws-client
       :simpledb
       credentials3831)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.simpledb.AmazonSimpleDBClient client3833
       domainMetadata
       (domain-metadata-request (clojure.core/nth args3832 0)))))))
  (clojure.core/defn
   domain-metadata-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector domain-name]}]]),
    :doc "Generate map for domainMetadata"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :simpledb,
     :fn :domain-metadata,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   domain-metadata
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector domain-name]}]]),
    :doc "Call domainMetadata"}
   [credentials3835 & args3836]
   (clojure.core/let
    [^com.amazonaws.services.simpledb.AmazonSimpleDBClient client3837
     (com.palletops.awaze.common/aws-client :simpledb credentials3835)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.simpledb.AmazonSimpleDBClient client3837
      domainMetadata
      (domain-metadata-request (clojure.core/nth args3836 0)))))))
 (do
  (clojure.core/defmethod
   simpledb
   :get-attributes
   [m3838]
   (clojure.core/let
    [credentials3839 (:credentials m3838) args3840 (:args m3838)]
    (clojure.core/let
     [^com.amazonaws.services.simpledb.AmazonSimpleDBClient client3841
      (com.palletops.awaze.common/aws-client
       :simpledb
       credentials3839)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.simpledb.AmazonSimpleDBClient client3841
       getAttributes
       (get-attributes-request (clojure.core/nth args3840 0)))))))
  (clojure.core/defn
   get-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         item-name
                         domain-name
                         consistent-read
                         attribute-names]}]]),
    :doc "Generate map for getAttributes"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :simpledb,
     :fn :get-attributes,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   get-attributes
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         item-name
                         domain-name
                         consistent-read
                         attribute-names]}]]),
    :doc "Call getAttributes"}
   [credentials3843 & args3844]
   (clojure.core/let
    [^com.amazonaws.services.simpledb.AmazonSimpleDBClient client3845
     (com.palletops.awaze.common/aws-client :simpledb credentials3843)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.simpledb.AmazonSimpleDBClient client3845
      getAttributes
      (get-attributes-request (clojure.core/nth args3844 0)))))))
 (do
  (clojure.core/defmethod
   simpledb
   :create-domain
   [m3846]
   (clojure.core/let
    [credentials3847 (:credentials m3846) args3848 (:args m3846)]
    (clojure.core/let
     [^com.amazonaws.services.simpledb.AmazonSimpleDBClient client3849
      (com.palletops.awaze.common/aws-client
       :simpledb
       credentials3847)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.simpledb.AmazonSimpleDBClient client3849
       createDomain
       (create-domain-request (clojure.core/nth args3848 0)))))))
  (clojure.core/defn
   create-domain-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector domain-name]}]]),
    :doc "Generate map for createDomain"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :simpledb,
     :fn :create-domain,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   create-domain
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector domain-name]}]]),
    :doc "Call createDomain"}
   [credentials3851 & args3852]
   (clojure.core/let
    [^com.amazonaws.services.simpledb.AmazonSimpleDBClient client3853
     (com.palletops.awaze.common/aws-client :simpledb credentials3851)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.simpledb.AmazonSimpleDBClient client3853
      createDomain
      (create-domain-request (clojure.core/nth args3852 0)))))))
 (do
  (clojure.core/defmethod
   simpledb
   :batch-delete-attributes
   [m3854]
   (clojure.core/let
    [credentials3855 (:credentials m3854) args3856 (:args m3854)]
    (clojure.core/let
     [^com.amazonaws.services.simpledb.AmazonSimpleDBClient client3857
      (com.palletops.awaze.common/aws-client
       :simpledb
       credentials3855)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.simpledb.AmazonSimpleDBClient client3857
       batchDeleteAttributes
       (batch-delete-attributes-request (clojure.core/nth args3856 0)))))))
  (clojure.core/defn
   batch-delete-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector items domain-name]}]]),
    :doc "Generate map for batchDeleteAttributes"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :simpledb,
     :fn :batch-delete-attributes,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   batch-delete-attributes
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector items domain-name]}]]),
    :doc "Call batchDeleteAttributes"}
   [credentials3859 & args3860]
   (clojure.core/let
    [^com.amazonaws.services.simpledb.AmazonSimpleDBClient client3861
     (com.palletops.awaze.common/aws-client :simpledb credentials3859)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.simpledb.AmazonSimpleDBClient client3861
      batchDeleteAttributes
      (batch-delete-attributes-request (clojure.core/nth args3860 0)))))))
 (do
  (clojure.core/defmethod
   simpledb
   :list-domains
   [m3862]
   (clojure.core/let
    [credentials3863 (:credentials m3862) args3864 (:args m3862)]
    (clojure.core/let
     [^com.amazonaws.services.simpledb.AmazonSimpleDBClient client3865
      (com.palletops.awaze.common/aws-client
       :simpledb
       credentials3863)]
     (clojure.core/case
      (clojure.core/count args3864)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.simpledb.AmazonSimpleDBClient client3865
        listDomains
        (list-domains-request (clojure.core/nth args3864 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.simpledb.AmazonSimpleDBClient client3865
        listDomains))))))
  (clojure.core/defn
   list-domains-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         next-token
                         max-number-of-domains]}]
                [credentials]]),
    :doc "Generate map for listDomains, listDomains"}
   ([credentials__1609__auto__]
    {:args [],
     :client :simpledb,
     :fn :list-domains,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :simpledb,
     :fn :list-domains,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   list-domains
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         next-token
                         max-number-of-domains]}]
                [credentials]]),
    :doc "Call listDomains, listDomains"}
   [credentials3867 & args3868]
   (clojure.core/let
    [^com.amazonaws.services.simpledb.AmazonSimpleDBClient client3869
     (com.palletops.awaze.common/aws-client :simpledb credentials3867)]
    (clojure.core/case
     (clojure.core/count args3868)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.simpledb.AmazonSimpleDBClient client3869
       listDomains
       (list-domains-request (clojure.core/nth args3868 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.simpledb.AmazonSimpleDBClient client3869
       listDomains))))))
 (do
  (clojure.core/defmethod
   simpledb
   :put-attributes
   [m3870]
   (clojure.core/let
    [credentials3871 (:credentials m3870) args3872 (:args m3870)]
    (clojure.core/let
     [^com.amazonaws.services.simpledb.AmazonSimpleDBClient client3873
      (com.palletops.awaze.common/aws-client
       :simpledb
       credentials3871)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.simpledb.AmazonSimpleDBClient client3873
       putAttributes
       (put-attributes-request (clojure.core/nth args3872 0)))))))
  (clojure.core/defn
   put-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         item-name
                         expected
                         domain-name
                         attributes]}]]),
    :doc "Generate map for putAttributes"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :simpledb,
     :fn :put-attributes,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   put-attributes
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         item-name
                         expected
                         domain-name
                         attributes]}]]),
    :doc "Call putAttributes"}
   [credentials3875 & args3876]
   (clojure.core/let
    [^com.amazonaws.services.simpledb.AmazonSimpleDBClient client3877
     (com.palletops.awaze.common/aws-client :simpledb credentials3875)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.simpledb.AmazonSimpleDBClient client3877
      putAttributes
      (put-attributes-request (clojure.core/nth args3876 0)))))))
 (do
  (clojure.core/defmethod
   simpledb
   :delete-attributes
   [m3878]
   (clojure.core/let
    [credentials3879 (:credentials m3878) args3880 (:args m3878)]
    (clojure.core/let
     [^com.amazonaws.services.simpledb.AmazonSimpleDBClient client3881
      (com.palletops.awaze.common/aws-client
       :simpledb
       credentials3879)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.simpledb.AmazonSimpleDBClient client3881
       deleteAttributes
       (delete-attributes-request (clojure.core/nth args3880 0)))))))
  (clojure.core/defn
   delete-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         item-name
                         expected
                         domain-name
                         attributes]}]]),
    :doc "Generate map for deleteAttributes"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :simpledb,
     :fn :delete-attributes,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   delete-attributes
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         item-name
                         expected
                         domain-name
                         attributes]}]]),
    :doc "Call deleteAttributes"}
   [credentials3883 & args3884]
   (clojure.core/let
    [^com.amazonaws.services.simpledb.AmazonSimpleDBClient client3885
     (com.palletops.awaze.common/aws-client :simpledb credentials3883)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.simpledb.AmazonSimpleDBClient client3885
      deleteAttributes
      (delete-attributes-request (clojure.core/nth args3884 0)))))))
 (do
  (clojure.core/defmethod
   simpledb
   :batch-put-attributes
   [m3886]
   (clojure.core/let
    [credentials3887 (:credentials m3886) args3888 (:args m3886)]
    (clojure.core/let
     [^com.amazonaws.services.simpledb.AmazonSimpleDBClient client3889
      (com.palletops.awaze.common/aws-client
       :simpledb
       credentials3887)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.simpledb.AmazonSimpleDBClient client3889
       batchPutAttributes
       (batch-put-attributes-request (clojure.core/nth args3888 0)))))))
  (clojure.core/defn
   batch-put-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector items domain-name]}]]),
    :doc "Generate map for batchPutAttributes"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :simpledb,
     :fn :batch-put-attributes,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   batch-put-attributes
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector items domain-name]}]]),
    :doc "Call batchPutAttributes"}
   [credentials3891 & args3892]
   (clojure.core/let
    [^com.amazonaws.services.simpledb.AmazonSimpleDBClient client3893
     (com.palletops.awaze.common/aws-client :simpledb credentials3891)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.simpledb.AmazonSimpleDBClient client3893
      batchPutAttributes
      (batch-put-attributes-request (clojure.core/nth args3892 0)))))))
 (do
  (clojure.core/defmethod
   simpledb
   :delete-domain
   [m3894]
   (clojure.core/let
    [credentials3895 (:credentials m3894) args3896 (:args m3894)]
    (clojure.core/let
     [^com.amazonaws.services.simpledb.AmazonSimpleDBClient client3897
      (com.palletops.awaze.common/aws-client
       :simpledb
       credentials3895)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.simpledb.AmazonSimpleDBClient client3897
       deleteDomain
       (delete-domain-request (clojure.core/nth args3896 0)))))))
  (clojure.core/defn
   delete-domain-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector domain-name]}]]),
    :doc "Generate map for deleteDomain"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :simpledb,
     :fn :delete-domain,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   delete-domain
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector domain-name]}]]),
    :doc "Call deleteDomain"}
   [credentials3899 & args3900]
   (clojure.core/let
    [^com.amazonaws.services.simpledb.AmazonSimpleDBClient client3901
     (com.palletops.awaze.common/aws-client :simpledb credentials3899)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.simpledb.AmazonSimpleDBClient client3901
      deleteDomain
      (delete-domain-request (clojure.core/nth args3900 0)))))))
 (do
  (clojure.core/defmethod
   simpledb
   :select
   [m3902]
   (clojure.core/let
    [credentials3903 (:credentials m3902) args3904 (:args m3902)]
    (clojure.core/let
     [^com.amazonaws.services.simpledb.AmazonSimpleDBClient client3905
      (com.palletops.awaze.common/aws-client
       :simpledb
       credentials3903)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.simpledb.AmazonSimpleDBClient client3905
       select
       (select-request (clojure.core/nth args3904 0)))))))
  (clojure.core/defn
   select-map
   {:arglists (quote
               [[credentials
                 {:keys [select-expression
                         request-metric-collector
                         next-token
                         consistent-read]}]]),
    :doc "Generate map for select"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :simpledb,
     :fn :select,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   select
   {:arglists (quote
               [[credentials
                 {:keys [select-expression
                         request-metric-collector
                         next-token
                         consistent-read]}]]),
    :doc "Call select"}
   [credentials3907 & args3908]
   (clojure.core/let
    [^com.amazonaws.services.simpledb.AmazonSimpleDBClient client3909
     (com.palletops.awaze.common/aws-client :simpledb credentials3907)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.simpledb.AmazonSimpleDBClient client3909
      select
      (select-request (clojure.core/nth args3908 0))))))))
