(ns
 com.palletops.awaze.simpleemail
 (:require [com.palletops.awaze.common]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :simpleemail
  [___1561__auto__
   ^com.amazonaws.auth.BasicAWSCredentials credentials__1562__auto__]
  (new
   com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient
   credentials__1562__auto__))
 (clojure.core/defn
  ^com.amazonaws.services.simpleemail.model.Content content
  [m1685]
  (clojure.core/let
   [bean1684 (new com.amazonaws.services.simpleemail.model.Content)]
   (clojure.core/when-let
    [v1686 (:charset m1685)]
    (. bean1684 setCharset (clojure.core/str v1686)))
   (clojure.core/when-let
    [v1686 (:data m1685)]
    (. bean1684 setData (clojure.core/str v1686)))
   bean1684))
 (clojure.core/defn
  ^com.amazonaws.services.simpleemail.model.Body body
  [m1688]
  (clojure.core/let
   [bean1687 (new com.amazonaws.services.simpleemail.model.Body)]
   (clojure.core/when-let
    [v1689 (:text m1688)]
    (. bean1687 setText (content v1689)))
   (clojure.core/when-let
    [v1689 (:html m1688)]
    (. bean1687 setHtml (content v1689)))
   bean1687))
 (clojure.core/defn
  ^com.amazonaws.services.simpleemail.model.Destination destination
  [m1691]
  (clojure.core/let
   [bean1690
    (new com.amazonaws.services.simpleemail.model.Destination)]
   (clojure.core/when-let
    [v1692 (:to-addresses m1691)]
    (.
     bean1690
     setToAddresses
     (clojure.core/map
      (clojure.core/fn [arg1696] (clojure.core/str arg1696))
      v1692)))
   (clojure.core/when-let
    [v1692 (:cc-addresses m1691)]
    (.
     bean1690
     setCcAddresses
     (clojure.core/map
      (clojure.core/fn [arg1697] (clojure.core/str arg1697))
      v1692)))
   (clojure.core/when-let
    [v1692 (:bcc-addresses m1691)]
    (.
     bean1690
     setBccAddresses
     (clojure.core/map
      (clojure.core/fn [arg1698] (clojure.core/str arg1698))
      v1692)))
   bean1690))
 (clojure.core/defn
  ^com.amazonaws.services.simpleemail.model.Message message
  [m1694]
  (clojure.core/let
   [bean1693 (new com.amazonaws.services.simpleemail.model.Message)]
   (clojure.core/when-let
    [v1695 (:subject m1694)]
    (. bean1693 setSubject (content v1695)))
   (clojure.core/when-let
    [v1695 (:body m1694)]
    (. bean1693 setBody (body v1695)))
   bean1693))
 (clojure.core/defn
  ^com.amazonaws.services.simpleemail.model.RawMessage raw-message
  [m1700]Couldn't find coercion function for java.nio.ByteBuffer of type java.lang.Class java.nio.ByteBuffer

  (clojure.core/let
   [bean1699
    (new com.amazonaws.services.simpleemail.model.RawMessage)]
   (clojure.core/when-let
    [v1701 (:data m1700)]
    (. bean1699 setData v1701))
   bean1699))
 (clojure.core/defn
  ^com.amazonaws.services.simpleemail.model.IdentityType identity-type
  [m1703]
  (java.lang.Enum/valueOf
   com.amazonaws.services.simpleemail.model.IdentityType
   (clojure.core/name m1703)))
 (clojure.core/defn
  ^com.amazonaws.services.simpleemail.model.NotificationType notification-type
  [m1706]
  (java.lang.Enum/valueOf
   com.amazonaws.services.simpleemail.model.NotificationType
   (clojure.core/name m1706)))
 (clojure.core/defn
  ^com.amazonaws.services.simpleemail.model.SendEmailRequest send-email-request
  [m1709]
  (clojure.core/let
   [bean1708
    (new com.amazonaws.services.simpleemail.model.SendEmailRequest)]
   (clojure.core/when-let
    [v1710 (:source m1709)]
    (. bean1708 setSource (clojure.core/str v1710)))
   (clojure.core/when-let
    [v1710 (:destination m1709)]
    (. bean1708 setDestination (destination v1710)))
   (clojure.core/when-let
    [v1710 (:message m1709)]
    (. bean1708 setMessage (message v1710)))
   (clojure.core/when-let
    [v1710 (:reply-to-addresses m1709)]
    (.
     bean1708
     setReplyToAddresses
     (clojure.core/map
      (clojure.core/fn [arg1714] (clojure.core/str arg1714))
      v1710)))
   (clojure.core/when-let
    [v1710 (:return-path m1709)]
    (. bean1708 setReturnPath (clojure.core/str v1710)))
   bean1708))
 (clojure.core/defn
  ^com.amazonaws.services.simpleemail.model.ListVerifiedEmailAddressesRequest list-verified-email-addresses-request
  [m1712]
  (clojure.core/let
   [bean1711
    (new
     com.amazonaws.services.simpleemail.model.ListVerifiedEmailAddressesRequest)]
   bean1711))
 (clojure.core/defn
  ^com.amazonaws.services.simpleemail.model.GetSendStatisticsRequest get-send-statistics-request
  [m1716]
  (clojure.core/let
   [bean1715
    (new
     com.amazonaws.services.simpleemail.model.GetSendStatisticsRequest)]
   bean1715))
 (clojure.core/defn
  ^com.amazonaws.services.simpleemail.model.DeleteVerifiedEmailAddressRequest delete-verified-email-address-request
  [m1719]
  (clojure.core/let
   [bean1718
    (new
     com.amazonaws.services.simpleemail.model.DeleteVerifiedEmailAddressRequest)]
   (clojure.core/when-let
    [v1720 (:email-address m1719)]
    (. bean1718 setEmailAddress (clojure.core/str v1720)))
   bean1718))
 (clojure.core/defn
  ^com.amazonaws.services.simpleemail.model.SetIdentityDkimEnabledRequest set-identity-dkim-enabled-request
  [m1722]
  (clojure.core/let
   [bean1721
    (new
     com.amazonaws.services.simpleemail.model.SetIdentityDkimEnabledRequest)]
   (clojure.core/when-let
    [v1723 (:identity m1722)]
    (. bean1721 setIdentity (clojure.core/str v1723)))
   (clojure.core/when-let
    [v1723 (:dkim-enabled m1722)]
    (. bean1721 setDkimEnabled (clojure.core/boolean v1723)))
   bean1721))
 (clojure.core/defn
  ^com.amazonaws.services.simpleemail.model.SetIdentityFeedbackForwardingEnabledRequest set-identity-feedback-forwarding-enabled-request
  [m1725]
  (clojure.core/let
   [bean1724
    (new
     com.amazonaws.services.simpleemail.model.SetIdentityFeedbackForwardingEnabledRequest)]
   (clojure.core/when-let
    [v1726 (:identity m1725)]
    (. bean1724 setIdentity (clojure.core/str v1726)))
   (clojure.core/when-let
    [v1726 (:forwarding-enabled m1725)]
    (. bean1724 setForwardingEnabled (clojure.core/boolean v1726)))
   bean1724))
 (clojure.core/defn
  ^com.amazonaws.services.simpleemail.model.SendRawEmailRequest send-raw-email-request
  [m1728]
  (clojure.core/let
   [bean1727
    (new com.amazonaws.services.simpleemail.model.SendRawEmailRequest)]
   (clojure.core/when-let
    [v1729 (:source m1728)]
    (. bean1727 setSource (clojure.core/str v1729)))
   (clojure.core/when-let
    [v1729 (:destinations m1728)]
    (.
     bean1727
     setDestinations
     (clojure.core/map
      (clojure.core/fn [arg1733] (clojure.core/str arg1733))
      v1729)))
   (clojure.core/when-let
    [v1729 (:raw-message m1728)]
    (. bean1727 setRawMessage (raw-message v1729)))
   bean1727))
 (clojure.core/defn
  ^com.amazonaws.services.simpleemail.model.GetIdentityNotificationAttributesRequest get-identity-notification-attributes-request
  [m1731]
  (clojure.core/let
   [bean1730
    (new
     com.amazonaws.services.simpleemail.model.GetIdentityNotificationAttributesRequest)]
   (clojure.core/when-let
    [v1732 (:identities m1731)]
    (.
     bean1730
     setIdentities
     (clojure.core/map
      (clojure.core/fn [arg1737] (clojure.core/str arg1737))
      v1732)))
   bean1730))
 (clojure.core/defn
  ^com.amazonaws.services.simpleemail.model.ListIdentitiesRequest list-identities-request
  [m1735]
  (clojure.core/let
   [bean1734
    (new
     com.amazonaws.services.simpleemail.model.ListIdentitiesRequest)]
   (clojure.core/when-let
    [v1736 (:next-token m1735)]
    (. bean1734 setNextToken (clojure.core/str v1736)))
   (clojure.core/when-let
    [v1736 (:identity-type m1735)]
    (. bean1734 setIdentityType (identity-type v1736)))
   (clojure.core/when-let
    [v1736 (:identity-type m1735)]
    (. bean1734 setIdentityType (clojure.core/str v1736)))
   (clojure.core/when-let
    [v1736 (:max-items m1735)]
    (. bean1734 setMaxItems (clojure.core/int v1736)))
   bean1734))
 (clojure.core/defn
  ^com.amazonaws.services.simpleemail.model.GetIdentityDkimAttributesRequest get-identity-dkim-attributes-request
  [m1739]
  (clojure.core/let
   [bean1738
    (new
     com.amazonaws.services.simpleemail.model.GetIdentityDkimAttributesRequest)]
   (clojure.core/when-let
    [v1740 (:identities m1739)]
    (.
     bean1738
     setIdentities
     (clojure.core/map
      (clojure.core/fn [arg1744] (clojure.core/str arg1744))
      v1740)))
   bean1738))
 (clojure.core/defn
  ^com.amazonaws.services.simpleemail.model.VerifyDomainDkimRequest verify-domain-dkim-request
  [m1742]
  (clojure.core/let
   [bean1741
    (new
     com.amazonaws.services.simpleemail.model.VerifyDomainDkimRequest)]
   (clojure.core/when-let
    [v1743 (:domain m1742)]
    (. bean1741 setDomain (clojure.core/str v1743)))
   bean1741))
 (clojure.core/defn
  ^com.amazonaws.services.simpleemail.model.VerifyEmailAddressRequest verify-email-address-request
  [m1746]
  (clojure.core/let
   [bean1745
    (new
     com.amazonaws.services.simpleemail.model.VerifyEmailAddressRequest)]
   (clojure.core/when-let
    [v1747 (:email-address m1746)]
    (. bean1745 setEmailAddress (clojure.core/str v1747)))
   bean1745))
 (clojure.core/defn
  ^com.amazonaws.services.simpleemail.model.SetIdentityNotificationTopicRequest set-identity-notification-topic-request
  [m1749]
  (clojure.core/let
   [bean1748
    (new
     com.amazonaws.services.simpleemail.model.SetIdentityNotificationTopicRequest)]
   (clojure.core/when-let
    [v1750 (:identity m1749)]
    (. bean1748 setIdentity (clojure.core/str v1750)))
   (clojure.core/when-let
    [v1750 (:notification-type m1749)]
    (. bean1748 setNotificationType (notification-type v1750)))
   (clojure.core/when-let
    [v1750 (:notification-type m1749)]
    (. bean1748 setNotificationType (clojure.core/str v1750)))
   (clojure.core/when-let
    [v1750 (:sns-topic m1749)]
    (. bean1748 setSnsTopic (clojure.core/str v1750)))
   bean1748))
 (clojure.core/defn
  ^com.amazonaws.services.simpleemail.model.GetIdentityVerificationAttributesRequest get-identity-verification-attributes-request
  [m1752]
  (clojure.core/let
   [bean1751
    (new
     com.amazonaws.services.simpleemail.model.GetIdentityVerificationAttributesRequest)]
   (clojure.core/when-let
    [v1753 (:identities m1752)]
    (.
     bean1751
     setIdentities
     (clojure.core/map
      (clojure.core/fn [arg1757] (clojure.core/str arg1757))
      v1753)))
   bean1751))
 (clojure.core/defn
  ^com.amazonaws.services.simpleemail.model.VerifyDomainIdentityRequest verify-domain-identity-request
  [m1755]
  (clojure.core/let
   [bean1754
    (new
     com.amazonaws.services.simpleemail.model.VerifyDomainIdentityRequest)]
   (clojure.core/when-let
    [v1756 (:domain m1755)]
    (. bean1754 setDomain (clojure.core/str v1756)))
   bean1754))
 (clojure.core/defn
  ^com.amazonaws.services.simpleemail.model.GetSendQuotaRequest get-send-quota-request
  [m1759]
  (clojure.core/let
   [bean1758
    (new com.amazonaws.services.simpleemail.model.GetSendQuotaRequest)]
   bean1758))
 (clojure.core/defn
  ^com.amazonaws.services.simpleemail.model.DeleteIdentityRequest delete-identity-request
  [m1762]
  (clojure.core/let
   [bean1761
    (new
     com.amazonaws.services.simpleemail.model.DeleteIdentityRequest)]
   (clojure.core/when-let
    [v1763 (:identity m1762)]
    (. bean1761 setIdentity (clojure.core/str v1763)))
   bean1761))
 (clojure.core/defn
  ^com.amazonaws.services.simpleemail.model.VerifyEmailIdentityRequest verify-email-identity-request
  [m1765]
  (clojure.core/let
   [bean1764
    (new
     com.amazonaws.services.simpleemail.model.VerifyEmailIdentityRequest)]
   (clojure.core/when-let
    [v1766 (:email-address m1765)]
    (. bean1764 setEmailAddress (clojure.core/str v1766)))
   bean1764))
 (clojure.core/defmulti
  simpleemail
  (clojure.core/fn
   simpleemail
   [m__1641__auto__]
   (:fn m__1641__auto__)))
 (do
  (clojure.core/defmethod
   simpleemail
   :send-email
   [m1767]
   (clojure.core/let
    [credentials1768 (:credentials m1767) args1769 (:args m1767)]
    (clojure.core/let
     [^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client1770
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials1768)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client1770
       sendEmail
       (send-email-request (clojure.core/nth args1769 0)))))))
  (clojure.core/defn
   send-email-map
   {:arglists (quote
               [[credentials
                 {:keys [source
                         return-path
                         request-metric-collector
                         reply-to-addresses
                         message
                         destination]}]]),
    :doc "Generate map for sendEmail"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :simpleemail,
     :fn :send-email,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   send-email
   {:arglists (quote
               [[credentials
                 {:keys [source
                         return-path
                         request-metric-collector
                         reply-to-addresses
                         message
                         destination]}]]),
    :doc "Call sendEmail"}
   [credentials1772 & args1773]
   (clojure.core/let
    [^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client1774
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials1772)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client1774
      sendEmail
      (send-email-request (clojure.core/nth args1773 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :list-verified-email-addresses
   [m1775]
   (clojure.core/let
    [credentials1776 (:credentials m1775) args1777 (:args m1775)]
    (clojure.core/let
     [^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client1778
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials1776)]
     (clojure.core/case
      (clojure.core/count args1777)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client1778
        listVerifiedEmailAddresses))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client1778
        listVerifiedEmailAddresses
        (list-verified-email-addresses-request
         (clojure.core/nth args1777 0))))))))
  (clojure.core/defn
   list-verified-email-addresses-map
   {:arglists (quote
               [[credentials]
                [credentials {:keys [request-metric-collector]}]]),
    :doc "Generate map for listVerifiedEmailAddresses, listVerifiedEmailAddresses"}
   ([credentials__1609__auto__]
    {:args [],
     :client :simpleemail,
     :fn :list-verified-email-addresses,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :simpleemail,
     :fn :list-verified-email-addresses,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   list-verified-email-addresses
   {:arglists (quote
               [[credentials]
                [credentials {:keys [request-metric-collector]}]]),
    :doc "Call listVerifiedEmailAddresses, listVerifiedEmailAddresses"}
   [credentials1780 & args1781]
   (clojure.core/let
    [^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client1782
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials1780)]
    (clojure.core/case
     (clojure.core/count args1781)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client1782
       listVerifiedEmailAddresses))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client1782
       listVerifiedEmailAddresses
       (list-verified-email-addresses-request
        (clojure.core/nth args1781 0))))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :get-send-statistics
   [m1783]
   (clojure.core/let
    [credentials1784 (:credentials m1783) args1785 (:args m1783)]
    (clojure.core/let
     [^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client1786
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials1784)]
     (clojure.core/case
      (clojure.core/count args1785)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client1786
        getSendStatistics))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client1786
        getSendStatistics
        (get-send-statistics-request (clojure.core/nth args1785 0))))))))
  (clojure.core/defn
   get-send-statistics-map
   {:arglists (quote
               [[credentials]
                [credentials {:keys [request-metric-collector]}]]),
    :doc "Generate map for getSendStatistics, getSendStatistics"}
   ([credentials__1609__auto__]
    {:args [],
     :client :simpleemail,
     :fn :get-send-statistics,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :simpleemail,
     :fn :get-send-statistics,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   get-send-statistics
   {:arglists (quote
               [[credentials]
                [credentials {:keys [request-metric-collector]}]]),
    :doc "Call getSendStatistics, getSendStatistics"}
   [credentials1788 & args1789]
   (clojure.core/let
    [^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client1790
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials1788)]
    (clojure.core/case
     (clojure.core/count args1789)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client1790
       getSendStatistics))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client1790
       getSendStatistics
       (get-send-statistics-request (clojure.core/nth args1789 0))))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :delete-verified-email-address
   [m1791]
   (clojure.core/let
    [credentials1792 (:credentials m1791) args1793 (:args m1791)]
    (clojure.core/let
     [^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client1794
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials1792)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client1794
       deleteVerifiedEmailAddress
       (delete-verified-email-address-request
        (clojure.core/nth args1793 0)))))))
  (clojure.core/defn
   delete-verified-email-address-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector email-address]}]]),
    :doc "Generate map for deleteVerifiedEmailAddress"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :simpleemail,
     :fn :delete-verified-email-address,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   delete-verified-email-address
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector email-address]}]]),
    :doc "Call deleteVerifiedEmailAddress"}
   [credentials1796 & args1797]
   (clojure.core/let
    [^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client1798
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials1796)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client1798
      deleteVerifiedEmailAddress
      (delete-verified-email-address-request
       (clojure.core/nth args1797 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :set-identity-dkim-enabled
   [m1799]
   (clojure.core/let
    [credentials1800 (:credentials m1799) args1801 (:args m1799)]
    (clojure.core/let
     [^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client1802
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials1800)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client1802
       setIdentityDkimEnabled
       (set-identity-dkim-enabled-request
        (clojure.core/nth args1801 0)))))))
  (clojure.core/defn
   set-identity-dkim-enabled-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         identity
                         dkim-enabled]}]]),
    :doc "Generate map for setIdentityDkimEnabled"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :simpleemail,
     :fn :set-identity-dkim-enabled,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   set-identity-dkim-enabled
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         identity
                         dkim-enabled]}]]),
    :doc "Call setIdentityDkimEnabled"}
   [credentials1804 & args1805]
   (clojure.core/let
    [^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client1806
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials1804)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client1806
      setIdentityDkimEnabled
      (set-identity-dkim-enabled-request
       (clojure.core/nth args1805 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :set-identity-feedback-forwarding-enabled
   [m1807]
   (clojure.core/let
    [credentials1808 (:credentials m1807) args1809 (:args m1807)]
    (clojure.core/let
     [^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client1810
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials1808)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client1810
       setIdentityFeedbackForwardingEnabled
       (set-identity-feedback-forwarding-enabled-request
        (clojure.core/nth args1809 0)))))))
  (clojure.core/defn
   set-identity-feedback-forwarding-enabled-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         identity
                         forwarding-enabled]}]]),
    :doc "Generate map for setIdentityFeedbackForwardingEnabled"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :simpleemail,
     :fn :set-identity-feedback-forwarding-enabled,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   set-identity-feedback-forwarding-enabled
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         identity
                         forwarding-enabled]}]]),
    :doc "Call setIdentityFeedbackForwardingEnabled"}
   [credentials1812 & args1813]
   (clojure.core/let
    [^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client1814
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials1812)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client1814
      setIdentityFeedbackForwardingEnabled
      (set-identity-feedback-forwarding-enabled-request
       (clojure.core/nth args1813 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :send-raw-email
   [m1815]
   (clojure.core/let
    [credentials1816 (:credentials m1815) args1817 (:args m1815)]
    (clojure.core/let
     [^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client1818
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials1816)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client1818
       sendRawEmail
       (send-raw-email-request (clojure.core/nth args1817 0)))))))
  (clojure.core/defn
   send-raw-email-map
   {:arglists (quote
               [[credentials
                 {:keys [source
                         request-metric-collector
                         raw-message
                         destinations]}]]),
    :doc "Generate map for sendRawEmail"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :simpleemail,
     :fn :send-raw-email,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   send-raw-email
   {:arglists (quote
               [[credentials
                 {:keys [source
                         request-metric-collector
                         raw-message
                         destinations]}]]),
    :doc "Call sendRawEmail"}
   [credentials1820 & args1821]
   (clojure.core/let
    [^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client1822
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials1820)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client1822
      sendRawEmail
      (send-raw-email-request (clojure.core/nth args1821 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :get-identity-notification-attributes
   [m1823]
   (clojure.core/let
    [credentials1824 (:credentials m1823) args1825 (:args m1823)]
    (clojure.core/let
     [^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client1826
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials1824)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client1826
       getIdentityNotificationAttributes
       (get-identity-notification-attributes-request
        (clojure.core/nth args1825 0)))))))
  (clojure.core/defn
   get-identity-notification-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector identities]}]]),
    :doc "Generate map for getIdentityNotificationAttributes"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :simpleemail,
     :fn :get-identity-notification-attributes,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   get-identity-notification-attributes
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector identities]}]]),
    :doc "Call getIdentityNotificationAttributes"}
   [credentials1828 & args1829]
   (clojure.core/let
    [^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client1830
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials1828)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client1830
      getIdentityNotificationAttributes
      (get-identity-notification-attributes-request
       (clojure.core/nth args1829 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :list-identities
   [m1831]
   (clojure.core/let
    [credentials1832 (:credentials m1831) args1833 (:args m1831)]
    (clojure.core/let
     [^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client1834
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials1832)]
     (clojure.core/case
      (clojure.core/count args1833)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client1834
        listIdentities))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client1834
        listIdentities
        (list-identities-request (clojure.core/nth args1833 0))))))))
  (clojure.core/defn
   list-identities-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [request-metric-collector
                         next-token
                         max-items
                         identity-type]}]]),
    :doc "Generate map for listIdentities, listIdentities"}
   ([credentials__1609__auto__]
    {:args [],
     :client :simpleemail,
     :fn :list-identities,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :simpleemail,
     :fn :list-identities,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   list-identities
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [request-metric-collector
                         next-token
                         max-items
                         identity-type]}]]),
    :doc "Call listIdentities, listIdentities"}
   [credentials1836 & args1837]
   (clojure.core/let
    [^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client1838
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials1836)]
    (clojure.core/case
     (clojure.core/count args1837)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client1838
       listIdentities))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client1838
       listIdentities
       (list-identities-request (clojure.core/nth args1837 0))))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :get-identity-dkim-attributes
   [m1839]
   (clojure.core/let
    [credentials1840 (:credentials m1839) args1841 (:args m1839)]
    (clojure.core/let
     [^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client1842
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials1840)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client1842
       getIdentityDkimAttributes
       (get-identity-dkim-attributes-request
        (clojure.core/nth args1841 0)))))))
  (clojure.core/defn
   get-identity-dkim-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector identities]}]]),
    :doc "Generate map for getIdentityDkimAttributes"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :simpleemail,
     :fn :get-identity-dkim-attributes,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   get-identity-dkim-attributes
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector identities]}]]),
    :doc "Call getIdentityDkimAttributes"}
   [credentials1844 & args1845]
   (clojure.core/let
    [^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client1846
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials1844)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client1846
      getIdentityDkimAttributes
      (get-identity-dkim-attributes-request
       (clojure.core/nth args1845 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :verify-domain-dkim
   [m1847]
   (clojure.core/let
    [credentials1848 (:credentials m1847) args1849 (:args m1847)]
    (clojure.core/let
     [^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client1850
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials1848)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client1850
       verifyDomainDkim
       (verify-domain-dkim-request (clojure.core/nth args1849 0)))))))
  (clojure.core/defn
   verify-domain-dkim-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector domain]}]]),
    :doc "Generate map for verifyDomainDkim"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :simpleemail,
     :fn :verify-domain-dkim,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   verify-domain-dkim
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector domain]}]]),
    :doc "Call verifyDomainDkim"}
   [credentials1852 & args1853]
   (clojure.core/let
    [^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client1854
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials1852)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client1854
      verifyDomainDkim
      (verify-domain-dkim-request (clojure.core/nth args1853 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :verify-email-address
   [m1855]
   (clojure.core/let
    [credentials1856 (:credentials m1855) args1857 (:args m1855)]
    (clojure.core/let
     [^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client1858
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials1856)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client1858
       verifyEmailAddress
       (verify-email-address-request (clojure.core/nth args1857 0)))))))
  (clojure.core/defn
   verify-email-address-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector email-address]}]]),
    :doc "Generate map for verifyEmailAddress"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :simpleemail,
     :fn :verify-email-address,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   verify-email-address
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector email-address]}]]),
    :doc "Call verifyEmailAddress"}
   [credentials1860 & args1861]
   (clojure.core/let
    [^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client1862
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials1860)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client1862
      verifyEmailAddress
      (verify-email-address-request (clojure.core/nth args1861 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :set-identity-notification-topic
   [m1863]
   (clojure.core/let
    [credentials1864 (:credentials m1863) args1865 (:args m1863)]
    (clojure.core/let
     [^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client1866
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials1864)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client1866
       setIdentityNotificationTopic
       (set-identity-notification-topic-request
        (clojure.core/nth args1865 0)))))))
  (clojure.core/defn
   set-identity-notification-topic-map
   {:arglists (quote
               [[credentials
                 {:keys [sns-topic
                         request-metric-collector
                         notification-type
                         identity]}]]),
    :doc "Generate map for setIdentityNotificationTopic"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :simpleemail,
     :fn :set-identity-notification-topic,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   set-identity-notification-topic
   {:arglists (quote
               [[credentials
                 {:keys [sns-topic
                         request-metric-collector
                         notification-type
                         identity]}]]),
    :doc "Call setIdentityNotificationTopic"}
   [credentials1868 & args1869]
   (clojure.core/let
    [^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client1870
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials1868)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client1870
      setIdentityNotificationTopic
      (set-identity-notification-topic-request
       (clojure.core/nth args1869 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :get-identity-verification-attributes
   [m1871]
   (clojure.core/let
    [credentials1872 (:credentials m1871) args1873 (:args m1871)]
    (clojure.core/let
     [^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client1874
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials1872)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client1874
       getIdentityVerificationAttributes
       (get-identity-verification-attributes-request
        (clojure.core/nth args1873 0)))))))
  (clojure.core/defn
   get-identity-verification-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector identities]}]]),
    :doc "Generate map for getIdentityVerificationAttributes"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :simpleemail,
     :fn :get-identity-verification-attributes,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   get-identity-verification-attributes
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector identities]}]]),
    :doc "Call getIdentityVerificationAttributes"}
   [credentials1876 & args1877]
   (clojure.core/let
    [^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client1878
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials1876)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client1878
      getIdentityVerificationAttributes
      (get-identity-verification-attributes-request
       (clojure.core/nth args1877 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :verify-domain-identity
   [m1879]
   (clojure.core/let
    [credentials1880 (:credentials m1879) args1881 (:args m1879)]
    (clojure.core/let
     [^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client1882
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials1880)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client1882
       verifyDomainIdentity
       (verify-domain-identity-request (clojure.core/nth args1881 0)))))))
  (clojure.core/defn
   verify-domain-identity-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector domain]}]]),
    :doc "Generate map for verifyDomainIdentity"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :simpleemail,
     :fn :verify-domain-identity,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   verify-domain-identity
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector domain]}]]),
    :doc "Call verifyDomainIdentity"}
   [credentials1884 & args1885]
   (clojure.core/let
    [^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client1886
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials1884)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client1886
      verifyDomainIdentity
      (verify-domain-identity-request (clojure.core/nth args1885 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :get-send-quota
   [m1887]
   (clojure.core/let
    [credentials1888 (:credentials m1887) args1889 (:args m1887)]
    (clojure.core/let
     [^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client1890
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials1888)]
     (clojure.core/case
      (clojure.core/count args1889)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client1890
        getSendQuota
        (get-send-quota-request (clojure.core/nth args1889 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client1890
        getSendQuota))))))
  (clojure.core/defn
   get-send-quota-map
   {:arglists (quote
               [[credentials {:keys [request-metric-collector]}]
                [credentials]]),
    :doc "Generate map for getSendQuota, getSendQuota"}
   ([credentials__1609__auto__]
    {:args [],
     :client :simpleemail,
     :fn :get-send-quota,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :simpleemail,
     :fn :get-send-quota,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   get-send-quota
   {:arglists (quote
               [[credentials {:keys [request-metric-collector]}]
                [credentials]]),
    :doc "Call getSendQuota, getSendQuota"}
   [credentials1892 & args1893]
   (clojure.core/let
    [^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client1894
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials1892)]
    (clojure.core/case
     (clojure.core/count args1893)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client1894
       getSendQuota
       (get-send-quota-request (clojure.core/nth args1893 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client1894
       getSendQuota))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :delete-identity
   [m1895]
   (clojure.core/let
    [credentials1896 (:credentials m1895) args1897 (:args m1895)]
    (clojure.core/let
     [^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client1898
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials1896)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client1898
       deleteIdentity
       (delete-identity-request (clojure.core/nth args1897 0)))))))
  (clojure.core/defn
   delete-identity-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector identity]}]]),
    :doc "Generate map for deleteIdentity"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :simpleemail,
     :fn :delete-identity,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   delete-identity
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector identity]}]]),
    :doc "Call deleteIdentity"}
   [credentials1900 & args1901]
   (clojure.core/let
    [^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client1902
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials1900)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client1902
      deleteIdentity
      (delete-identity-request (clojure.core/nth args1901 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :verify-email-identity
   [m1903]
   (clojure.core/let
    [credentials1904 (:credentials m1903) args1905 (:args m1903)]
    (clojure.core/let
     [^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client1906
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials1904)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client1906
       verifyEmailIdentity
       (verify-email-identity-request (clojure.core/nth args1905 0)))))))
  (clojure.core/defn
   verify-email-identity-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector email-address]}]]),
    :doc "Generate map for verifyEmailIdentity"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :simpleemail,
     :fn :verify-email-identity,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   verify-email-identity
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector email-address]}]]),
    :doc "Call verifyEmailIdentity"}
   [credentials1908 & args1909]
   (clojure.core/let
    [^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client1910
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials1908)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient client1910
      verifyEmailIdentity
      (verify-email-identity-request (clojure.core/nth args1909 0))))))))
