(ns com.palletops.awaze.sns (:require [com.palletops.awaze.common]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :sns
  [___1561__auto__
   ^com.amazonaws.auth.BasicAWSCredentials credentials__1562__auto__]
  (new
   com.amazonaws.services.sns.AmazonSNSClient
   credentials__1562__auto__))
 (clojure.core/defn
  ^com.amazonaws.services.sns.model.GetEndpointAttributesRequest get-endpoint-attributes-request
  [m2634]
  (clojure.core/let
   [bean2633
    (new
     com.amazonaws.services.sns.model.GetEndpointAttributesRequest)]
   (clojure.core/when-let
    [v2635 (:endpoint-arn m2634)]
    (. bean2633 setEndpointArn (clojure.core/str v2635)))
   bean2633))
 (clojure.core/defn
  ^com.amazonaws.services.sns.model.GetPlatformApplicationAttributesRequest get-platform-application-attributes-request
  [m2637]
  (clojure.core/let
   [bean2636
    (new
     com.amazonaws.services.sns.model.GetPlatformApplicationAttributesRequest)]
   (clojure.core/when-let
    [v2638 (:platform-application-arn m2637)]
    (. bean2636 setPlatformApplicationArn (clojure.core/str v2638)))
   bean2636))
 (clojure.core/defn
  ^com.amazonaws.services.sns.model.SetTopicAttributesRequest set-topic-attributes-request
  [m2640]
  (clojure.core/let
   [bean2639
    (new com.amazonaws.services.sns.model.SetTopicAttributesRequest)]
   (clojure.core/when-let
    [v2641 (:topic-arn m2640)]
    (. bean2639 setTopicArn (clojure.core/str v2641)))
   (clojure.core/when-let
    [v2641 (:attribute-name m2640)]
    (. bean2639 setAttributeName (clojure.core/str v2641)))
   (clojure.core/when-let
    [v2641 (:attribute-value m2640)]
    (. bean2639 setAttributeValue (clojure.core/str v2641)))
   bean2639))
 (clojure.core/defn
  ^com.amazonaws.services.sns.model.AddPermissionRequest add-permission-request
  [m2643]
  (clojure.core/let
   [bean2642
    (new com.amazonaws.services.sns.model.AddPermissionRequest)]
   (clojure.core/when-let
    [v2644 (:topic-arn m2643)]
    (. bean2642 setTopicArn (clojure.core/str v2644)))
   (clojure.core/when-let
    [v2644 (:label m2643)]
    (. bean2642 setLabel (clojure.core/str v2644)))
   (clojure.core/when-let
    [v2644 (:awsaccount-ids m2643)]
    (.
     bean2642
     setAWSAccountIds
     (clojure.core/map
      (clojure.core/fn [arg2648] (clojure.core/str arg2648))
      v2644)))
   (clojure.core/when-let
    [v2644 (:action-names m2643)]
    (.
     bean2642
     setActionNames
     (clojure.core/map
      (clojure.core/fn [arg2649] (clojure.core/str arg2649))
      v2644)))
   bean2642))
 (clojure.core/defn
  ^com.amazonaws.services.sns.model.GetSubscriptionAttributesRequest get-subscription-attributes-request
  [m2646]
  (clojure.core/let
   [bean2645
    (new
     com.amazonaws.services.sns.model.GetSubscriptionAttributesRequest)]
   (clojure.core/when-let
    [v2647 (:subscription-arn m2646)]
    (. bean2645 setSubscriptionArn (clojure.core/str v2647)))
   bean2645))
 (clojure.core/defn
  ^com.amazonaws.services.sns.model.ConfirmSubscriptionRequest confirm-subscription-request
  [m2651]
  (clojure.core/let
   [bean2650
    (new com.amazonaws.services.sns.model.ConfirmSubscriptionRequest)]
   (clojure.core/when-let
    [v2652 (:topic-arn m2651)]
    (. bean2650 setTopicArn (clojure.core/str v2652)))
   (clojure.core/when-let
    [v2652 (:token m2651)]
    (. bean2650 setToken (clojure.core/str v2652)))
   (clojure.core/when-let
    [v2652 (:authenticate-on-unsubscribe m2651)]
    (. bean2650 setAuthenticateOnUnsubscribe (clojure.core/str v2652)))
   bean2650))
 (clojure.core/defn
  ^com.amazonaws.services.sns.model.DeleteTopicRequest delete-topic-request
  [m2654]
  (clojure.core/let
   [bean2653
    (new com.amazonaws.services.sns.model.DeleteTopicRequest)]
   (clojure.core/when-let
    [v2655 (:topic-arn m2654)]
    (. bean2653 setTopicArn (clojure.core/str v2655)))
   bean2653))
 (clojure.core/defn
  ^com.amazonaws.services.sns.model.PublishRequest publish-request
  [m2657]
  (clojure.core/let
   [bean2656 (new com.amazonaws.services.sns.model.PublishRequest)]
   (clojure.core/when-let
    [v2658 (:topic-arn m2657)]
    (. bean2656 setTopicArn (clojure.core/str v2658)))
   (clojure.core/when-let
    [v2658 (:target-arn m2657)]
    (. bean2656 setTargetArn (clojure.core/str v2658)))
   (clojure.core/when-let
    [v2658 (:message-structure m2657)]
    (. bean2656 setMessageStructure (clojure.core/str v2658)))
   (clojure.core/when-let
    [v2658 (:subject m2657)]
    (. bean2656 setSubject (clojure.core/str v2658)))
   (clojure.core/when-let
    [v2658 (:message m2657)]
    (. bean2656 setMessage (clojure.core/str v2658)))
   bean2656))
 (clojure.core/defn
  ^com.amazonaws.services.sns.model.ListTopicsRequest list-topics-request
  [m2660]
  (clojure.core/let
   [bean2659 (new com.amazonaws.services.sns.model.ListTopicsRequest)]
   (clojure.core/when-let
    [v2661 (:next-token m2660)]
    (. bean2659 setNextToken (clojure.core/str v2661)))
   bean2659))
 (clojure.core/defn
  ^com.amazonaws.services.sns.model.ListSubscriptionsByTopicRequest list-subscriptions-by-topic-request
  [m2663]
  (clojure.core/let
   [bean2662
    (new
     com.amazonaws.services.sns.model.ListSubscriptionsByTopicRequest)]
   (clojure.core/when-let
    [v2664 (:topic-arn m2663)]
    (. bean2662 setTopicArn (clojure.core/str v2664)))
   (clojure.core/when-let
    [v2664 (:next-token m2663)]
    (. bean2662 setNextToken (clojure.core/str v2664)))
   bean2662))
 (clojure.core/defn
  ^com.amazonaws.services.sns.model.DeletePlatformApplicationRequest delete-platform-application-request
  [m2666]
  (clojure.core/let
   [bean2665
    (new
     com.amazonaws.services.sns.model.DeletePlatformApplicationRequest)]
   (clojure.core/when-let
    [v2667 (:platform-application-arn m2666)]
    (. bean2665 setPlatformApplicationArn (clojure.core/str v2667)))
   bean2665))
 (clojure.core/defn
  ^com.amazonaws.services.sns.model.ListEndpointsByPlatformApplicationRequest list-endpoints-by-platform-application-request
  [m2669]
  (clojure.core/let
   [bean2668
    (new
     com.amazonaws.services.sns.model.ListEndpointsByPlatformApplicationRequest)]
   (clojure.core/when-let
    [v2670 (:platform-application-arn m2669)]
    (. bean2668 setPlatformApplicationArn (clojure.core/str v2670)))
   (clojure.core/when-let
    [v2670 (:next-token m2669)]
    (. bean2668 setNextToken (clojure.core/str v2670)))
   bean2668))
 (clojure.core/defn
  ^com.amazonaws.services.sns.model.UnsubscribeRequest unsubscribe-request
  [m2672]
  (clojure.core/let
   [bean2671
    (new com.amazonaws.services.sns.model.UnsubscribeRequest)]
   (clojure.core/when-let
    [v2673 (:subscription-arn m2672)]
    (. bean2671 setSubscriptionArn (clojure.core/str v2673)))
   bean2671))
 (clojure.core/defn
  ^com.amazonaws.services.sns.model.SetSubscriptionAttributesRequest set-subscription-attributes-request
  [m2675]
  (clojure.core/let
   [bean2674
    (new
     com.amazonaws.services.sns.model.SetSubscriptionAttributesRequest)]
   (clojure.core/when-let
    [v2676 (:subscription-arn m2675)]
    (. bean2674 setSubscriptionArn (clojure.core/str v2676)))
   (clojure.core/when-let
    [v2676 (:attribute-name m2675)]
    (. bean2674 setAttributeName (clojure.core/str v2676)))
   (clojure.core/when-let
    [v2676 (:attribute-value m2675)]
    (. bean2674 setAttributeValue (clojure.core/str v2676)))
   bean2674))
 (clojure.core/defn
  ^com.amazonaws.services.sns.model.ListSubscriptionsRequest list-subscriptions-request
  [m2678]
  (clojure.core/let
   [bean2677
    (new com.amazonaws.services.sns.model.ListSubscriptionsRequest)]
   (clojure.core/when-let
    [v2679 (:next-token m2678)]
    (. bean2677 setNextToken (clojure.core/str v2679)))
   bean2677))
 (clojure.core/defn
  ^com.amazonaws.services.sns.model.CreateTopicRequest create-topic-request
  [m2681]
  (clojure.core/let
   [bean2680
    (new com.amazonaws.services.sns.model.CreateTopicRequest)]
   (clojure.core/when-let
    [v2682 (:name m2681)]
    (. bean2680 setName (clojure.core/str v2682)))
   bean2680))
 (clojure.core/defn
  ^com.amazonaws.services.sns.model.CreatePlatformEndpointRequest create-platform-endpoint-request
  [m2684]
  (clojure.core/let
   [bean2683
    (new
     com.amazonaws.services.sns.model.CreatePlatformEndpointRequest)]
   (clojure.core/when-let
    [v2685 (:token m2684)]
    (. bean2683 setToken (clojure.core/str v2685)))
   (clojure.core/when-let
    [v2685 (:platform-application-arn m2684)]
    (. bean2683 setPlatformApplicationArn (clojure.core/str v2685)))
   (clojure.core/when-let
    [v2685 (:custom-user-data m2684)]
    (. bean2683 setCustomUserData (clojure.core/str v2685)))
   (clojure.core/when-let
    [v2685 (:attributes m2684)]
    (.
     bean2683
     setAttributes
     (clojure.core/zipmap
      (clojure.core/map
       (clojure.core/fn [arg2689] (clojure.core/str arg2689))
       (clojure.core/keys v2685))
      (clojure.core/map
       (clojure.core/fn [arg2689] (clojure.core/str arg2689))
       (clojure.core/vals v2685)))))
   bean2683))
 (clojure.core/defn
  ^com.amazonaws.services.sns.model.RemovePermissionRequest remove-permission-request
  [m2687]
  (clojure.core/let
   [bean2686
    (new com.amazonaws.services.sns.model.RemovePermissionRequest)]
   (clojure.core/when-let
    [v2688 (:topic-arn m2687)]
    (. bean2686 setTopicArn (clojure.core/str v2688)))
   (clojure.core/when-let
    [v2688 (:label m2687)]
    (. bean2686 setLabel (clojure.core/str v2688)))
   bean2686))
 (clojure.core/defn
  ^com.amazonaws.services.sns.model.GetTopicAttributesRequest get-topic-attributes-request
  [m2691]
  (clojure.core/let
   [bean2690
    (new com.amazonaws.services.sns.model.GetTopicAttributesRequest)]
   (clojure.core/when-let
    [v2692 (:topic-arn m2691)]
    (. bean2690 setTopicArn (clojure.core/str v2692)))
   bean2690))
 (clojure.core/defn
  ^com.amazonaws.services.sns.model.SubscribeRequest subscribe-request
  [m2694]
  (clojure.core/let
   [bean2693 (new com.amazonaws.services.sns.model.SubscribeRequest)]
   (clojure.core/when-let
    [v2695 (:endpoint m2694)]
    (. bean2693 setEndpoint (clojure.core/str v2695)))
   (clojure.core/when-let
    [v2695 (:topic-arn m2694)]
    (. bean2693 setTopicArn (clojure.core/str v2695)))
   (clojure.core/when-let
    [v2695 (:protocol m2694)]
    (. bean2693 setProtocol (clojure.core/str v2695)))
   bean2693))
 (clojure.core/defn
  ^com.amazonaws.services.sns.model.DeleteEndpointRequest delete-endpoint-request
  [m2697]
  (clojure.core/let
   [bean2696
    (new com.amazonaws.services.sns.model.DeleteEndpointRequest)]
   (clojure.core/when-let
    [v2698 (:endpoint-arn m2697)]
    (. bean2696 setEndpointArn (clojure.core/str v2698)))
   bean2696))
 (clojure.core/defn
  ^com.amazonaws.services.sns.model.ListPlatformApplicationsRequest list-platform-applications-request
  [m2700]
  (clojure.core/let
   [bean2699
    (new
     com.amazonaws.services.sns.model.ListPlatformApplicationsRequest)]
   (clojure.core/when-let
    [v2701 (:next-token m2700)]
    (. bean2699 setNextToken (clojure.core/str v2701)))
   bean2699))
 (clojure.core/defn
  ^com.amazonaws.services.sns.model.SetPlatformApplicationAttributesRequest set-platform-application-attributes-request
  [m2703]
  (clojure.core/let
   [bean2702
    (new
     com.amazonaws.services.sns.model.SetPlatformApplicationAttributesRequest)]
   (clojure.core/when-let
    [v2704 (:platform-application-arn m2703)]
    (. bean2702 setPlatformApplicationArn (clojure.core/str v2704)))
   (clojure.core/when-let
    [v2704 (:attributes m2703)]
    (.
     bean2702
     setAttributes
     (clojure.core/zipmap
      (clojure.core/map
       (clojure.core/fn [arg2708] (clojure.core/str arg2708))
       (clojure.core/keys v2704))
      (clojure.core/map
       (clojure.core/fn [arg2708] (clojure.core/str arg2708))
       (clojure.core/vals v2704)))))
   bean2702))
 (clojure.core/defn
  ^com.amazonaws.services.sns.model.CreatePlatformApplicationRequest create-platform-application-request
  [m2706]
  (clojure.core/let
   [bean2705
    (new
     com.amazonaws.services.sns.model.CreatePlatformApplicationRequest)]
   (clojure.core/when-let
    [v2707 (:name m2706)]
    (. bean2705 setName (clojure.core/str v2707)))
   (clojure.core/when-let
    [v2707 (:platform m2706)]
    (. bean2705 setPlatform (clojure.core/str v2707)))
   (clojure.core/when-let
    [v2707 (:attributes m2706)]
    (.
     bean2705
     setAttributes
     (clojure.core/zipmap
      (clojure.core/map
       (clojure.core/fn [arg2712] (clojure.core/str arg2712))
       (clojure.core/keys v2707))
      (clojure.core/map
       (clojure.core/fn [arg2712] (clojure.core/str arg2712))
       (clojure.core/vals v2707)))))
   bean2705))
 (clojure.core/defn
  ^com.amazonaws.services.sns.model.SetEndpointAttributesRequest set-endpoint-attributes-request
  [m2710]
  (clojure.core/let
   [bean2709
    (new
     com.amazonaws.services.sns.model.SetEndpointAttributesRequest)]
   (clojure.core/when-let
    [v2711 (:endpoint-arn m2710)]
    (. bean2709 setEndpointArn (clojure.core/str v2711)))
   (clojure.core/when-let
    [v2711 (:attributes m2710)]
    (.
     bean2709
     setAttributes
     (clojure.core/zipmap
      (clojure.core/map
       (clojure.core/fn [arg2713] (clojure.core/str arg2713))
       (clojure.core/keys v2711))
      (clojure.core/map
       (clojure.core/fn [arg2713] (clojure.core/str arg2713))
       (clojure.core/vals v2711)))))
   bean2709))
 (clojure.core/defmulti
  sns
  (clojure.core/fn sns [m__1641__auto__] (:fn m__1641__auto__)))
 (do
  (clojure.core/defmethod
   sns
   :get-endpoint-attributes
   [m2714]
   (clojure.core/let
    [credentials2715 (:credentials m2714) args2716 (:args m2714)]
    (clojure.core/let
     [^com.amazonaws.services.sns.AmazonSNSClient client2717
      (com.palletops.awaze.common/aws-client :sns credentials2715)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.sns.AmazonSNSClient client2717
       getEndpointAttributes
       (get-endpoint-attributes-request (clojure.core/nth args2716 0)))))))
  (clojure.core/defn
   get-endpoint-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector endpoint-arn]}]]),
    :doc "Generate map for getEndpointAttributes"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :sns,
     :fn :get-endpoint-attributes,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   get-endpoint-attributes
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector endpoint-arn]}]]),
    :doc "Call getEndpointAttributes"}
   [credentials2719 & args2720]
   (clojure.core/let
    [^com.amazonaws.services.sns.AmazonSNSClient client2721
     (com.palletops.awaze.common/aws-client :sns credentials2719)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.sns.AmazonSNSClient client2721
      getEndpointAttributes
      (get-endpoint-attributes-request (clojure.core/nth args2720 0)))))))
 (do
  (clojure.core/defmethod
   sns
   :get-platform-application-attributes
   [m2722]
   (clojure.core/let
    [credentials2723 (:credentials m2722) args2724 (:args m2722)]
    (clojure.core/let
     [^com.amazonaws.services.sns.AmazonSNSClient client2725
      (com.palletops.awaze.common/aws-client :sns credentials2723)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.sns.AmazonSNSClient client2725
       getPlatformApplicationAttributes
       (get-platform-application-attributes-request
        (clojure.core/nth args2724 0)))))))
  (clojure.core/defn
   get-platform-application-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         platform-application-arn]}]]),
    :doc "Generate map for getPlatformApplicationAttributes"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :sns,
     :fn :get-platform-application-attributes,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   get-platform-application-attributes
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         platform-application-arn]}]]),
    :doc "Call getPlatformApplicationAttributes"}
   [credentials2727 & args2728]
   (clojure.core/let
    [^com.amazonaws.services.sns.AmazonSNSClient client2729
     (com.palletops.awaze.common/aws-client :sns credentials2727)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.sns.AmazonSNSClient client2729
      getPlatformApplicationAttributes
      (get-platform-application-attributes-request
       (clojure.core/nth args2728 0)))))))
 (do
  (clojure.core/defmethod
   sns
   :set-topic-attributes
   [m2730]
   (clojure.core/let
    [credentials2731 (:credentials m2730) args2732 (:args m2730)]
    (clojure.core/let
     [^com.amazonaws.services.sns.AmazonSNSClient client2733
      (com.palletops.awaze.common/aws-client :sns credentials2731)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.sns.AmazonSNSClient client2733
       setTopicAttributes
       (set-topic-attributes-request (clojure.core/nth args2732 0)))))))
  (clojure.core/defn
   set-topic-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [topic-arn
                         request-metric-collector
                         attribute-value
                         attribute-name]}]]),
    :doc "Generate map for setTopicAttributes"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :sns,
     :fn :set-topic-attributes,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   set-topic-attributes
   {:arglists (quote
               [[credentials
                 {:keys [topic-arn
                         request-metric-collector
                         attribute-value
                         attribute-name]}]]),
    :doc "Call setTopicAttributes"}
   [credentials2735 & args2736]
   (clojure.core/let
    [^com.amazonaws.services.sns.AmazonSNSClient client2737
     (com.palletops.awaze.common/aws-client :sns credentials2735)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.sns.AmazonSNSClient client2737
      setTopicAttributes
      (set-topic-attributes-request (clojure.core/nth args2736 0)))))))
 (do
  (clojure.core/defmethod
   sns
   :add-permission
   [m2738]
   (clojure.core/let
    [credentials2739 (:credentials m2738) args2740 (:args m2738)]
    (clojure.core/let
     [^com.amazonaws.services.sns.AmazonSNSClient client2741
      (com.palletops.awaze.common/aws-client :sns credentials2739)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.sns.AmazonSNSClient client2741
       addPermission
       (add-permission-request (clojure.core/nth args2740 0)))))))
  (clojure.core/defn
   add-permission-map
   {:arglists (quote
               [[credentials
                 {:keys [topic-arn
                         request-metric-collector
                         label
                         action-names
                         awsaccount-ids]}]]),
    :doc "Generate map for addPermission"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :sns,
     :fn :add-permission,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   add-permission
   {:arglists (quote
               [[credentials
                 {:keys [topic-arn
                         request-metric-collector
                         label
                         action-names
                         awsaccount-ids]}]]),
    :doc "Call addPermission"}
   [credentials2743 & args2744]
   (clojure.core/let
    [^com.amazonaws.services.sns.AmazonSNSClient client2745
     (com.palletops.awaze.common/aws-client :sns credentials2743)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.sns.AmazonSNSClient client2745
      addPermission
      (add-permission-request (clojure.core/nth args2744 0)))))))
 (do
  (clojure.core/defmethod
   sns
   :get-subscription-attributes
   [m2746]
   (clojure.core/let
    [credentials2747 (:credentials m2746) args2748 (:args m2746)]
    (clojure.core/let
     [^com.amazonaws.services.sns.AmazonSNSClient client2749
      (com.palletops.awaze.common/aws-client :sns credentials2747)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.sns.AmazonSNSClient client2749
       getSubscriptionAttributes
       (get-subscription-attributes-request
        (clojure.core/nth args2748 0)))))))
  (clojure.core/defn
   get-subscription-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [subscription-arn request-metric-collector]}]]),
    :doc "Generate map for getSubscriptionAttributes"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :sns,
     :fn :get-subscription-attributes,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   get-subscription-attributes
   {:arglists (quote
               [[credentials
                 {:keys [subscription-arn request-metric-collector]}]]),
    :doc "Call getSubscriptionAttributes"}
   [credentials2751 & args2752]
   (clojure.core/let
    [^com.amazonaws.services.sns.AmazonSNSClient client2753
     (com.palletops.awaze.common/aws-client :sns credentials2751)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.sns.AmazonSNSClient client2753
      getSubscriptionAttributes
      (get-subscription-attributes-request
       (clojure.core/nth args2752 0)))))))
 (do
  (clojure.core/defmethod
   sns
   :confirm-subscription
   [m2754]
   (clojure.core/let
    [credentials2755 (:credentials m2754) args2756 (:args m2754)]
    (clojure.core/let
     [^com.amazonaws.services.sns.AmazonSNSClient client2757
      (com.palletops.awaze.common/aws-client :sns credentials2755)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.sns.AmazonSNSClient client2757
       confirmSubscription
       (confirm-subscription-request (clojure.core/nth args2756 0)))))))
  (clojure.core/defn
   confirm-subscription-map
   {:arglists (quote
               [[credentials
                 {:keys [topic-arn
                         token
                         request-metric-collector
                         authenticate-on-unsubscribe]}]]),
    :doc "Generate map for confirmSubscription"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :sns,
     :fn :confirm-subscription,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   confirm-subscription
   {:arglists (quote
               [[credentials
                 {:keys [topic-arn
                         token
                         request-metric-collector
                         authenticate-on-unsubscribe]}]]),
    :doc "Call confirmSubscription"}
   [credentials2759 & args2760]
   (clojure.core/let
    [^com.amazonaws.services.sns.AmazonSNSClient client2761
     (com.palletops.awaze.common/aws-client :sns credentials2759)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.sns.AmazonSNSClient client2761
      confirmSubscription
      (confirm-subscription-request (clojure.core/nth args2760 0)))))))
 (do
  (clojure.core/defmethod
   sns
   :delete-topic
   [m2762]
   (clojure.core/let
    [credentials2763 (:credentials m2762) args2764 (:args m2762)]
    (clojure.core/let
     [^com.amazonaws.services.sns.AmazonSNSClient client2765
      (com.palletops.awaze.common/aws-client :sns credentials2763)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.sns.AmazonSNSClient client2765
       deleteTopic
       (delete-topic-request (clojure.core/nth args2764 0)))))))
  (clojure.core/defn
   delete-topic-map
   {:arglists (quote
               [[credentials
                 {:keys [topic-arn request-metric-collector]}]]),
    :doc "Generate map for deleteTopic"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :sns,
     :fn :delete-topic,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   delete-topic
   {:arglists (quote
               [[credentials
                 {:keys [topic-arn request-metric-collector]}]]),
    :doc "Call deleteTopic"}
   [credentials2767 & args2768]
   (clojure.core/let
    [^com.amazonaws.services.sns.AmazonSNSClient client2769
     (com.palletops.awaze.common/aws-client :sns credentials2767)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.sns.AmazonSNSClient client2769
      deleteTopic
      (delete-topic-request (clojure.core/nth args2768 0)))))))
 (do
  (clojure.core/defmethod
   sns
   :publish
   [m2770]
   (clojure.core/let
    [credentials2771 (:credentials m2770) args2772 (:args m2770)]
    (clojure.core/let
     [^com.amazonaws.services.sns.AmazonSNSClient client2773
      (com.palletops.awaze.common/aws-client :sns credentials2771)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.sns.AmazonSNSClient client2773
       publish
       (publish-request (clojure.core/nth args2772 0)))))))
  (clojure.core/defn
   publish-map
   {:arglists (quote
               [[credentials
                 {:keys [topic-arn
                         target-arn
                         subject
                         request-metric-collector
                         message-structure
                         message]}]]),
    :doc "Generate map for publish"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :sns,
     :fn :publish,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   publish
   {:arglists (quote
               [[credentials
                 {:keys [topic-arn
                         target-arn
                         subject
                         request-metric-collector
                         message-structure
                         message]}]]),
    :doc "Call publish"}
   [credentials2775 & args2776]
   (clojure.core/let
    [^com.amazonaws.services.sns.AmazonSNSClient client2777
     (com.palletops.awaze.common/aws-client :sns credentials2775)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.sns.AmazonSNSClient client2777
      publish
      (publish-request (clojure.core/nth args2776 0)))))))
 (do
  (clojure.core/defmethod
   sns
   :list-topics
   [m2778]
   (clojure.core/let
    [credentials2779 (:credentials m2778) args2780 (:args m2778)]
    (clojure.core/let
     [^com.amazonaws.services.sns.AmazonSNSClient client2781
      (com.palletops.awaze.common/aws-client :sns credentials2779)]
     (clojure.core/case
      (clojure.core/count args2780)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.sns.AmazonSNSClient client2781
        listTopics))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.sns.AmazonSNSClient client2781
        listTopics
        (list-topics-request (clojure.core/nth args2780 0))))))))
  (clojure.core/defn
   list-topics-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [request-metric-collector next-token]}]]),
    :doc "Generate map for listTopics, listTopics"}
   ([credentials__1609__auto__]
    {:args [],
     :client :sns,
     :fn :list-topics,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :sns,
     :fn :list-topics,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   list-topics
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [request-metric-collector next-token]}]]),
    :doc "Call listTopics, listTopics"}
   [credentials2783 & args2784]
   (clojure.core/let
    [^com.amazonaws.services.sns.AmazonSNSClient client2785
     (com.palletops.awaze.common/aws-client :sns credentials2783)]
    (clojure.core/case
     (clojure.core/count args2784)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.sns.AmazonSNSClient client2785
       listTopics))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.sns.AmazonSNSClient client2785
       listTopics
       (list-topics-request (clojure.core/nth args2784 0))))))))
 (do
  (clojure.core/defmethod
   sns
   :list-subscriptions-by-topic
   [m2786]
   (clojure.core/let
    [credentials2787 (:credentials m2786) args2788 (:args m2786)]
    (clojure.core/let
     [^com.amazonaws.services.sns.AmazonSNSClient client2789
      (com.palletops.awaze.common/aws-client :sns credentials2787)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.sns.AmazonSNSClient client2789
       listSubscriptionsByTopic
       (list-subscriptions-by-topic-request
        (clojure.core/nth args2788 0)))))))
  (clojure.core/defn
   list-subscriptions-by-topic-map
   {:arglists (quote
               [[credentials
                 {:keys [topic-arn
                         request-metric-collector
                         next-token]}]]),
    :doc "Generate map for listSubscriptionsByTopic"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :sns,
     :fn :list-subscriptions-by-topic,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   list-subscriptions-by-topic
   {:arglists (quote
               [[credentials
                 {:keys [topic-arn
                         request-metric-collector
                         next-token]}]]),
    :doc "Call listSubscriptionsByTopic"}
   [credentials2791 & args2792]
   (clojure.core/let
    [^com.amazonaws.services.sns.AmazonSNSClient client2793
     (com.palletops.awaze.common/aws-client :sns credentials2791)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.sns.AmazonSNSClient client2793
      listSubscriptionsByTopic
      (list-subscriptions-by-topic-request
       (clojure.core/nth args2792 0)))))))
 (do
  (clojure.core/defmethod
   sns
   :delete-platform-application
   [m2794]
   (clojure.core/let
    [credentials2795 (:credentials m2794) args2796 (:args m2794)]
    (clojure.core/let
     [^com.amazonaws.services.sns.AmazonSNSClient client2797
      (com.palletops.awaze.common/aws-client :sns credentials2795)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.sns.AmazonSNSClient client2797
       deletePlatformApplication
       (delete-platform-application-request
        (clojure.core/nth args2796 0)))))))
  (clojure.core/defn
   delete-platform-application-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         platform-application-arn]}]]),
    :doc "Generate map for deletePlatformApplication"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :sns,
     :fn :delete-platform-application,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   delete-platform-application
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         platform-application-arn]}]]),
    :doc "Call deletePlatformApplication"}
   [credentials2799 & args2800]
   (clojure.core/let
    [^com.amazonaws.services.sns.AmazonSNSClient client2801
     (com.palletops.awaze.common/aws-client :sns credentials2799)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.sns.AmazonSNSClient client2801
      deletePlatformApplication
      (delete-platform-application-request
       (clojure.core/nth args2800 0)))))))
 (do
  (clojure.core/defmethod
   sns
   :list-endpoints-by-platform-application
   [m2802]
   (clojure.core/let
    [credentials2803 (:credentials m2802) args2804 (:args m2802)]
    (clojure.core/let
     [^com.amazonaws.services.sns.AmazonSNSClient client2805
      (com.palletops.awaze.common/aws-client :sns credentials2803)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.sns.AmazonSNSClient client2805
       listEndpointsByPlatformApplication
       (list-endpoints-by-platform-application-request
        (clojure.core/nth args2804 0)))))))
  (clojure.core/defn
   list-endpoints-by-platform-application-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         platform-application-arn
                         next-token]}]]),
    :doc "Generate map for listEndpointsByPlatformApplication"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :sns,
     :fn :list-endpoints-by-platform-application,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   list-endpoints-by-platform-application
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         platform-application-arn
                         next-token]}]]),
    :doc "Call listEndpointsByPlatformApplication"}
   [credentials2807 & args2808]
   (clojure.core/let
    [^com.amazonaws.services.sns.AmazonSNSClient client2809
     (com.palletops.awaze.common/aws-client :sns credentials2807)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.sns.AmazonSNSClient client2809
      listEndpointsByPlatformApplication
      (list-endpoints-by-platform-application-request
       (clojure.core/nth args2808 0)))))))
 (do
  (clojure.core/defmethod
   sns
   :unsubscribe
   [m2810]
   (clojure.core/let
    [credentials2811 (:credentials m2810) args2812 (:args m2810)]
    (clojure.core/let
     [^com.amazonaws.services.sns.AmazonSNSClient client2813
      (com.palletops.awaze.common/aws-client :sns credentials2811)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.sns.AmazonSNSClient client2813
       unsubscribe
       (unsubscribe-request (clojure.core/nth args2812 0)))))))
  (clojure.core/defn
   unsubscribe-map
   {:arglists (quote
               [[credentials
                 {:keys [subscription-arn request-metric-collector]}]]),
    :doc "Generate map for unsubscribe"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :sns,
     :fn :unsubscribe,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   unsubscribe
   {:arglists (quote
               [[credentials
                 {:keys [subscription-arn request-metric-collector]}]]),
    :doc "Call unsubscribe"}
   [credentials2815 & args2816]
   (clojure.core/let
    [^com.amazonaws.services.sns.AmazonSNSClient client2817
     (com.palletops.awaze.common/aws-client :sns credentials2815)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.sns.AmazonSNSClient client2817
      unsubscribe
      (unsubscribe-request (clojure.core/nth args2816 0)))))))
 (do
  (clojure.core/defmethod
   sns
   :set-subscription-attributes
   [m2818]
   (clojure.core/let
    [credentials2819 (:credentials m2818) args2820 (:args m2818)]
    (clojure.core/let
     [^com.amazonaws.services.sns.AmazonSNSClient client2821
      (com.palletops.awaze.common/aws-client :sns credentials2819)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.sns.AmazonSNSClient client2821
       setSubscriptionAttributes
       (set-subscription-attributes-request
        (clojure.core/nth args2820 0)))))))
  (clojure.core/defn
   set-subscription-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [subscription-arn
                         request-metric-collector
                         attribute-value
                         attribute-name]}]]),
    :doc "Generate map for setSubscriptionAttributes"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :sns,
     :fn :set-subscription-attributes,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   set-subscription-attributes
   {:arglists (quote
               [[credentials
                 {:keys [subscription-arn
                         request-metric-collector
                         attribute-value
                         attribute-name]}]]),
    :doc "Call setSubscriptionAttributes"}
   [credentials2823 & args2824]
   (clojure.core/let
    [^com.amazonaws.services.sns.AmazonSNSClient client2825
     (com.palletops.awaze.common/aws-client :sns credentials2823)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.sns.AmazonSNSClient client2825
      setSubscriptionAttributes
      (set-subscription-attributes-request
       (clojure.core/nth args2824 0)))))))
 (do
  (clojure.core/defmethod
   sns
   :list-subscriptions
   [m2826]
   (clojure.core/let
    [credentials2827 (:credentials m2826) args2828 (:args m2826)]
    (clojure.core/let
     [^com.amazonaws.services.sns.AmazonSNSClient client2829
      (com.palletops.awaze.common/aws-client :sns credentials2827)]
     (clojure.core/case
      (clojure.core/count args2828)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.sns.AmazonSNSClient client2829
        listSubscriptions))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.sns.AmazonSNSClient client2829
        listSubscriptions
        (list-subscriptions-request (clojure.core/nth args2828 0))))))))
  (clojure.core/defn
   list-subscriptions-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [request-metric-collector next-token]}]]),
    :doc "Generate map for listSubscriptions, listSubscriptions"}
   ([credentials__1609__auto__]
    {:args [],
     :client :sns,
     :fn :list-subscriptions,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :sns,
     :fn :list-subscriptions,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   list-subscriptions
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [request-metric-collector next-token]}]]),
    :doc "Call listSubscriptions, listSubscriptions"}
   [credentials2831 & args2832]
   (clojure.core/let
    [^com.amazonaws.services.sns.AmazonSNSClient client2833
     (com.palletops.awaze.common/aws-client :sns credentials2831)]
    (clojure.core/case
     (clojure.core/count args2832)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.sns.AmazonSNSClient client2833
       listSubscriptions))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.sns.AmazonSNSClient client2833
       listSubscriptions
       (list-subscriptions-request (clojure.core/nth args2832 0))))))))
 (do
  (clojure.core/defmethod
   sns
   :create-topic
   [m2834]
   (clojure.core/let
    [credentials2835 (:credentials m2834) args2836 (:args m2834)]
    (clojure.core/let
     [^com.amazonaws.services.sns.AmazonSNSClient client2837
      (com.palletops.awaze.common/aws-client :sns credentials2835)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.sns.AmazonSNSClient client2837
       createTopic
       (create-topic-request (clojure.core/nth args2836 0)))))))
  (clojure.core/defn
   create-topic-map
   {:arglists (quote
               [[credentials {:keys [request-metric-collector name]}]]),
    :doc "Generate map for createTopic"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :sns,
     :fn :create-topic,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   create-topic
   {:arglists (quote
               [[credentials {:keys [request-metric-collector name]}]]),
    :doc "Call createTopic"}
   [credentials2839 & args2840]
   (clojure.core/let
    [^com.amazonaws.services.sns.AmazonSNSClient client2841
     (com.palletops.awaze.common/aws-client :sns credentials2839)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.sns.AmazonSNSClient client2841
      createTopic
      (create-topic-request (clojure.core/nth args2840 0)))))))
 (do
  (clojure.core/defmethod
   sns
   :create-platform-endpoint
   [m2842]
   (clojure.core/let
    [credentials2843 (:credentials m2842) args2844 (:args m2842)]
    (clojure.core/let
     [^com.amazonaws.services.sns.AmazonSNSClient client2845
      (com.palletops.awaze.common/aws-client :sns credentials2843)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.sns.AmazonSNSClient client2845
       createPlatformEndpoint
       (create-platform-endpoint-request
        (clojure.core/nth args2844 0)))))))
  (clojure.core/defn
   create-platform-endpoint-map
   {:arglists (quote
               [[credentials
                 {:keys [token
                         request-metric-collector
                         platform-application-arn
                         custom-user-data
                         attributes]}]]),
    :doc "Generate map for createPlatformEndpoint"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :sns,
     :fn :create-platform-endpoint,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   create-platform-endpoint
   {:arglists (quote
               [[credentials
                 {:keys [token
                         request-metric-collector
                         platform-application-arn
                         custom-user-data
                         attributes]}]]),
    :doc "Call createPlatformEndpoint"}
   [credentials2847 & args2848]
   (clojure.core/let
    [^com.amazonaws.services.sns.AmazonSNSClient client2849
     (com.palletops.awaze.common/aws-client :sns credentials2847)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.sns.AmazonSNSClient client2849
      createPlatformEndpoint
      (create-platform-endpoint-request (clojure.core/nth args2848 0)))))))
 (do
  (clojure.core/defmethod
   sns
   :remove-permission
   [m2850]
   (clojure.core/let
    [credentials2851 (:credentials m2850) args2852 (:args m2850)]
    (clojure.core/let
     [^com.amazonaws.services.sns.AmazonSNSClient client2853
      (com.palletops.awaze.common/aws-client :sns credentials2851)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.sns.AmazonSNSClient client2853
       removePermission
       (remove-permission-request (clojure.core/nth args2852 0)))))))
  (clojure.core/defn
   remove-permission-map
   {:arglists (quote
               [[credentials
                 {:keys [topic-arn request-metric-collector label]}]]),
    :doc "Generate map for removePermission"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :sns,
     :fn :remove-permission,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   remove-permission
   {:arglists (quote
               [[credentials
                 {:keys [topic-arn request-metric-collector label]}]]),
    :doc "Call removePermission"}
   [credentials2855 & args2856]
   (clojure.core/let
    [^com.amazonaws.services.sns.AmazonSNSClient client2857
     (com.palletops.awaze.common/aws-client :sns credentials2855)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.sns.AmazonSNSClient client2857
      removePermission
      (remove-permission-request (clojure.core/nth args2856 0)))))))
 (do
  (clojure.core/defmethod
   sns
   :get-topic-attributes
   [m2858]
   (clojure.core/let
    [credentials2859 (:credentials m2858) args2860 (:args m2858)]
    (clojure.core/let
     [^com.amazonaws.services.sns.AmazonSNSClient client2861
      (com.palletops.awaze.common/aws-client :sns credentials2859)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.sns.AmazonSNSClient client2861
       getTopicAttributes
       (get-topic-attributes-request (clojure.core/nth args2860 0)))))))
  (clojure.core/defn
   get-topic-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [topic-arn request-metric-collector]}]]),
    :doc "Generate map for getTopicAttributes"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :sns,
     :fn :get-topic-attributes,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   get-topic-attributes
   {:arglists (quote
               [[credentials
                 {:keys [topic-arn request-metric-collector]}]]),
    :doc "Call getTopicAttributes"}
   [credentials2863 & args2864]
   (clojure.core/let
    [^com.amazonaws.services.sns.AmazonSNSClient client2865
     (com.palletops.awaze.common/aws-client :sns credentials2863)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.sns.AmazonSNSClient client2865
      getTopicAttributes
      (get-topic-attributes-request (clojure.core/nth args2864 0)))))))
 (do
  (clojure.core/defmethod
   sns
   :subscribe
   [m2866]
   (clojure.core/let
    [credentials2867 (:credentials m2866) args2868 (:args m2866)]
    (clojure.core/let
     [^com.amazonaws.services.sns.AmazonSNSClient client2869
      (com.palletops.awaze.common/aws-client :sns credentials2867)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.sns.AmazonSNSClient client2869
       subscribe
       (subscribe-request (clojure.core/nth args2868 0)))))))
  (clojure.core/defn
   subscribe-map
   {:arglists (quote
               [[credentials
                 {:keys [topic-arn
                         request-metric-collector
                         protocol
                         endpoint]}]]),
    :doc "Generate map for subscribe"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :sns,
     :fn :subscribe,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   subscribe
   {:arglists (quote
               [[credentials
                 {:keys [topic-arn
                         request-metric-collector
                         protocol
                         endpoint]}]]),
    :doc "Call subscribe"}
   [credentials2871 & args2872]
   (clojure.core/let
    [^com.amazonaws.services.sns.AmazonSNSClient client2873
     (com.palletops.awaze.common/aws-client :sns credentials2871)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.sns.AmazonSNSClient client2873
      subscribe
      (subscribe-request (clojure.core/nth args2872 0)))))))
 (do
  (clojure.core/defmethod
   sns
   :delete-endpoint
   [m2874]
   (clojure.core/let
    [credentials2875 (:credentials m2874) args2876 (:args m2874)]
    (clojure.core/let
     [^com.amazonaws.services.sns.AmazonSNSClient client2877
      (com.palletops.awaze.common/aws-client :sns credentials2875)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.sns.AmazonSNSClient client2877
       deleteEndpoint
       (delete-endpoint-request (clojure.core/nth args2876 0)))))))
  (clojure.core/defn
   delete-endpoint-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector endpoint-arn]}]]),
    :doc "Generate map for deleteEndpoint"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :sns,
     :fn :delete-endpoint,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   delete-endpoint
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector endpoint-arn]}]]),
    :doc "Call deleteEndpoint"}
   [credentials2879 & args2880]
   (clojure.core/let
    [^com.amazonaws.services.sns.AmazonSNSClient client2881
     (com.palletops.awaze.common/aws-client :sns credentials2879)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.sns.AmazonSNSClient client2881
      deleteEndpoint
      (delete-endpoint-request (clojure.core/nth args2880 0)))))))
 (do
  (clojure.core/defmethod
   sns
   :list-platform-applications
   [m2882]
   (clojure.core/let
    [credentials2883 (:credentials m2882) args2884 (:args m2882)]
    (clojure.core/let
     [^com.amazonaws.services.sns.AmazonSNSClient client2885
      (com.palletops.awaze.common/aws-client :sns credentials2883)]
     (clojure.core/case
      (clojure.core/count args2884)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.sns.AmazonSNSClient client2885
        listPlatformApplications
        (list-platform-applications-request
         (clojure.core/nth args2884 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.sns.AmazonSNSClient client2885
        listPlatformApplications))))))
  (clojure.core/defn
   list-platform-applications-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector next-token]}]
                [credentials]]),
    :doc "Generate map for listPlatformApplications, listPlatformApplications"}
   ([credentials__1609__auto__]
    {:args [],
     :client :sns,
     :fn :list-platform-applications,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :sns,
     :fn :list-platform-applications,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   list-platform-applications
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector next-token]}]
                [credentials]]),
    :doc "Call listPlatformApplications, listPlatformApplications"}
   [credentials2887 & args2888]
   (clojure.core/let
    [^com.amazonaws.services.sns.AmazonSNSClient client2889
     (com.palletops.awaze.common/aws-client :sns credentials2887)]
    (clojure.core/case
     (clojure.core/count args2888)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.sns.AmazonSNSClient client2889
       listPlatformApplications
       (list-platform-applications-request
        (clojure.core/nth args2888 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.sns.AmazonSNSClient client2889
       listPlatformApplications))))))
 (do
  (clojure.core/defmethod
   sns
   :set-platform-application-attributes
   [m2890]
   (clojure.core/let
    [credentials2891 (:credentials m2890) args2892 (:args m2890)]
    (clojure.core/let
     [^com.amazonaws.services.sns.AmazonSNSClient client2893
      (com.palletops.awaze.common/aws-client :sns credentials2891)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.sns.AmazonSNSClient client2893
       setPlatformApplicationAttributes
       (set-platform-application-attributes-request
        (clojure.core/nth args2892 0)))))))
  (clojure.core/defn
   set-platform-application-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         platform-application-arn
                         attributes]}]]),
    :doc "Generate map for setPlatformApplicationAttributes"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :sns,
     :fn :set-platform-application-attributes,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   set-platform-application-attributes
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         platform-application-arn
                         attributes]}]]),
    :doc "Call setPlatformApplicationAttributes"}
   [credentials2895 & args2896]
   (clojure.core/let
    [^com.amazonaws.services.sns.AmazonSNSClient client2897
     (com.palletops.awaze.common/aws-client :sns credentials2895)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.sns.AmazonSNSClient client2897
      setPlatformApplicationAttributes
      (set-platform-application-attributes-request
       (clojure.core/nth args2896 0)))))))
 (do
  (clojure.core/defmethod
   sns
   :create-platform-application
   [m2898]
   (clojure.core/let
    [credentials2899 (:credentials m2898) args2900 (:args m2898)]
    (clojure.core/let
     [^com.amazonaws.services.sns.AmazonSNSClient client2901
      (com.palletops.awaze.common/aws-client :sns credentials2899)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.sns.AmazonSNSClient client2901
       createPlatformApplication
       (create-platform-application-request
        (clojure.core/nth args2900 0)))))))
  (clojure.core/defn
   create-platform-application-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         platform
                         name
                         attributes]}]]),
    :doc "Generate map for createPlatformApplication"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :sns,
     :fn :create-platform-application,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   create-platform-application
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         platform
                         name
                         attributes]}]]),
    :doc "Call createPlatformApplication"}
   [credentials2903 & args2904]
   (clojure.core/let
    [^com.amazonaws.services.sns.AmazonSNSClient client2905
     (com.palletops.awaze.common/aws-client :sns credentials2903)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.sns.AmazonSNSClient client2905
      createPlatformApplication
      (create-platform-application-request
       (clojure.core/nth args2904 0)))))))
 (do
  (clojure.core/defmethod
   sns
   :set-endpoint-attributes
   [m2906]
   (clojure.core/let
    [credentials2907 (:credentials m2906) args2908 (:args m2906)]
    (clojure.core/let
     [^com.amazonaws.services.sns.AmazonSNSClient client2909
      (com.palletops.awaze.common/aws-client :sns credentials2907)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.sns.AmazonSNSClient client2909
       setEndpointAttributes
       (set-endpoint-attributes-request (clojure.core/nth args2908 0)))))))
  (clojure.core/defn
   set-endpoint-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         endpoint-arn
                         attributes]}]]),
    :doc "Generate map for setEndpointAttributes"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :sns,
     :fn :set-endpoint-attributes,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   set-endpoint-attributes
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         endpoint-arn
                         attributes]}]]),
    :doc "Call setEndpointAttributes"}
   [credentials2911 & args2912]
   (clojure.core/let
    [^com.amazonaws.services.sns.AmazonSNSClient client2913
     (com.palletops.awaze.common/aws-client :sns credentials2911)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.sns.AmazonSNSClient client2913
      setEndpointAttributes
      (set-endpoint-attributes-request (clojure.core/nth args2912 0))))))))
