(ns
 com.palletops.awaze.storagegateway
 (:require [com.palletops.awaze.common]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :storagegateway
  [___1561__auto__
   ^com.amazonaws.auth.BasicAWSCredentials credentials__1562__auto__]
  (new
   com.amazonaws.services.storagegateway.AWSStorageGatewayClient
   credentials__1562__auto__))
 (clojure.core/defn
  ^com.amazonaws.services.storagegateway.model.BandwidthType bandwidth-type
  [m4860]
  (java.lang.Enum/valueOf
   com.amazonaws.services.storagegateway.model.BandwidthType
   (clojure.core/name m4860)))
 (clojure.core/defn
  ^com.amazonaws.services.storagegateway.model.GatewayTimezone gateway-timezone
  [m4863]
  (java.lang.Enum/valueOf
   com.amazonaws.services.storagegateway.model.GatewayTimezone
   (clojure.core/name m4863)))
 (clojure.core/defn
  ^com.amazonaws.services.storagegateway.model.GatewayType gateway-type
  [m4866]
  (java.lang.Enum/valueOf
   com.amazonaws.services.storagegateway.model.GatewayType
   (clojure.core/name m4866)))
 (clojure.core/defn
  ^com.amazonaws.services.storagegateway.model.DescribeMaintenanceStartTimeRequest describe-maintenance-start-time-request
  [m4869]
  (clojure.core/let
   [bean4868
    (new
     com.amazonaws.services.storagegateway.model.DescribeMaintenanceStartTimeRequest)]
   (clojure.core/when-let
    [v4870 (:gateway-arn m4869)]
    (. bean4868 setGatewayARN (clojure.core/str v4870)))
   bean4868))
 (clojure.core/defn
  ^com.amazonaws.services.storagegateway.model.UpdateBandwidthRateLimitRequest update-bandwidth-rate-limit-request
  [m4872]
  (clojure.core/let
   [bean4871
    (new
     com.amazonaws.services.storagegateway.model.UpdateBandwidthRateLimitRequest)]
   (clojure.core/when-let
    [v4873 (:gateway-arn m4872)]
    (. bean4871 setGatewayARN (clojure.core/str v4873)))
   (clojure.core/when-let
    [v4873 (:average-upload-rate-limit-in-bits-per-sec m4872)]
    (.
     bean4871
     setAverageUploadRateLimitInBitsPerSec
     (clojure.core/long v4873)))
   (clojure.core/when-let
    [v4873 (:average-download-rate-limit-in-bits-per-sec m4872)]
    (.
     bean4871
     setAverageDownloadRateLimitInBitsPerSec
     (clojure.core/long v4873)))
   bean4871))
 (clojure.core/defn
  ^com.amazonaws.services.storagegateway.model.DescribeWorkingStorageRequest describe-working-storage-request
  [m4875]
  (clojure.core/let
   [bean4874
    (new
     com.amazonaws.services.storagegateway.model.DescribeWorkingStorageRequest)]
   (clojure.core/when-let
    [v4876 (:gateway-arn m4875)]
    (. bean4874 setGatewayARN (clojure.core/str v4876)))
   bean4874))
 (clojure.core/defn
  ^com.amazonaws.services.storagegateway.model.DeleteSnapshotScheduleRequest delete-snapshot-schedule-request
  [m4878]
  (clojure.core/let
   [bean4877
    (new
     com.amazonaws.services.storagegateway.model.DeleteSnapshotScheduleRequest)]
   (clojure.core/when-let
    [v4879 (:volume-arn m4878)]
    (. bean4877 setVolumeARN (clojure.core/str v4879)))
   bean4877))
 (clojure.core/defn
  ^com.amazonaws.services.storagegateway.model.DescribeChapCredentialsRequest describe-chap-credentials-request
  [m4881]
  (clojure.core/let
   [bean4880
    (new
     com.amazonaws.services.storagegateway.model.DescribeChapCredentialsRequest)]
   (clojure.core/when-let
    [v4882 (:target-arn m4881)]
    (. bean4880 setTargetARN (clojure.core/str v4882)))
   bean4880))
 (clojure.core/defn
  ^com.amazonaws.services.storagegateway.model.DeleteBandwidthRateLimitRequest delete-bandwidth-rate-limit-request
  [m4884]
  (clojure.core/let
   [bean4883
    (new
     com.amazonaws.services.storagegateway.model.DeleteBandwidthRateLimitRequest)]
   (clojure.core/when-let
    [v4885 (:gateway-arn m4884)]
    (. bean4883 setGatewayARN (clojure.core/str v4885)))
   (clojure.core/when-let
    [v4885 (:bandwidth-type m4884)]
    (. bean4883 setBandwidthType (clojure.core/str v4885)))
   (clojure.core/when-let
    [v4885 (:bandwidth-type m4884)]
    (. bean4883 setBandwidthType (bandwidth-type v4885)))
   bean4883))
 (clojure.core/defn
  ^com.amazonaws.services.storagegateway.model.CreateCachediSCSIVolumeRequest create-cachedi-scsivolume-request
  [m4887]
  (clojure.core/let
   [bean4886
    (new
     com.amazonaws.services.storagegateway.model.CreateCachediSCSIVolumeRequest)]
   (clojure.core/when-let
    [v4888 (:gateway-arn m4887)]
    (. bean4886 setGatewayARN (clojure.core/str v4888)))
   (clojure.core/when-let
    [v4888 (:volume-size-in-bytes m4887)]
    (. bean4886 setVolumeSizeInBytes (clojure.core/long v4888)))
   (clojure.core/when-let
    [v4888 (:target-name m4887)]
    (. bean4886 setTargetName (clojure.core/str v4888)))
   (clojure.core/when-let
    [v4888 (:network-interface-id m4887)]
    (. bean4886 setNetworkInterfaceId (clojure.core/str v4888)))
   (clojure.core/when-let
    [v4888 (:client-token m4887)]
    (. bean4886 setClientToken (clojure.core/str v4888)))
   (clojure.core/when-let
    [v4888 (:snapshot-id m4887)]
    (. bean4886 setSnapshotId (clojure.core/str v4888)))
   bean4886))
 (clojure.core/defn
  ^com.amazonaws.services.storagegateway.model.CreateSnapshotFromVolumeRecoveryPointRequest create-snapshot-from-volume-recovery-point-request
  [m4890]
  (clojure.core/let
   [bean4889
    (new
     com.amazonaws.services.storagegateway.model.CreateSnapshotFromVolumeRecoveryPointRequest)]
   (clojure.core/when-let
    [v4891 (:volume-arn m4890)]
    (. bean4889 setVolumeARN (clojure.core/str v4891)))
   (clojure.core/when-let
    [v4891 (:snapshot-description m4890)]
    (. bean4889 setSnapshotDescription (clojure.core/str v4891)))
   bean4889))
 (clojure.core/defn
  ^com.amazonaws.services.storagegateway.model.DescribeStorediSCSIVolumesRequest describe-storedi-scsivolumes-request
  [m4893]
  (clojure.core/let
   [bean4892
    (new
     com.amazonaws.services.storagegateway.model.DescribeStorediSCSIVolumesRequest)]
   (clojure.core/when-let
    [v4894 (:volume-arns m4893)]
    (.
     bean4892
     setVolumeARNs
     (clojure.core/map
      (clojure.core/fn [arg4898] (clojure.core/str arg4898))
      v4894)))
   bean4892))
 (clojure.core/defn
  ^com.amazonaws.services.storagegateway.model.DescribeUploadBufferRequest describe-upload-buffer-request
  [m4896]
  (clojure.core/let
   [bean4895
    (new
     com.amazonaws.services.storagegateway.model.DescribeUploadBufferRequest)]
   (clojure.core/when-let
    [v4897 (:gateway-arn m4896)]
    (. bean4895 setGatewayARN (clojure.core/str v4897)))
   bean4895))
 (clojure.core/defn
  ^com.amazonaws.services.storagegateway.model.AddUploadBufferRequest add-upload-buffer-request
  [m4900]
  (clojure.core/let
   [bean4899
    (new
     com.amazonaws.services.storagegateway.model.AddUploadBufferRequest)]
   (clojure.core/when-let
    [v4901 (:gateway-arn m4900)]
    (. bean4899 setGatewayARN (clojure.core/str v4901)))
   (clojure.core/when-let
    [v4901 (:disk-ids m4900)]
    (.
     bean4899
     setDiskIds
     (clojure.core/map
      (clojure.core/fn [arg4905] (clojure.core/str arg4905))
      v4901)))
   bean4899))
 (clojure.core/defn
  ^com.amazonaws.services.storagegateway.model.AddWorkingStorageRequest add-working-storage-request
  [m4903]
  (clojure.core/let
   [bean4902
    (new
     com.amazonaws.services.storagegateway.model.AddWorkingStorageRequest)]
   (clojure.core/when-let
    [v4904 (:gateway-arn m4903)]
    (. bean4902 setGatewayARN (clojure.core/str v4904)))
   (clojure.core/when-let
    [v4904 (:disk-ids m4903)]
    (.
     bean4902
     setDiskIds
     (clojure.core/map
      (clojure.core/fn [arg4909] (clojure.core/str arg4909))
      v4904)))
   bean4902))
 (clojure.core/defn
  ^com.amazonaws.services.storagegateway.model.StartGatewayRequest start-gateway-request
  [m4907]
  (clojure.core/let
   [bean4906
    (new
     com.amazonaws.services.storagegateway.model.StartGatewayRequest)]
   (clojure.core/when-let
    [v4908 (:gateway-arn m4907)]
    (. bean4906 setGatewayARN (clojure.core/str v4908)))
   bean4906))
 (clojure.core/defn
  ^com.amazonaws.services.storagegateway.model.ListLocalDisksRequest list-local-disks-request
  [m4911]
  (clojure.core/let
   [bean4910
    (new
     com.amazonaws.services.storagegateway.model.ListLocalDisksRequest)]
   (clojure.core/when-let
    [v4912 (:gateway-arn m4911)]
    (. bean4910 setGatewayARN (clojure.core/str v4912)))
   bean4910))
 (clojure.core/defn
  ^com.amazonaws.services.storagegateway.model.DeleteChapCredentialsRequest delete-chap-credentials-request
  [m4914]
  (clojure.core/let
   [bean4913
    (new
     com.amazonaws.services.storagegateway.model.DeleteChapCredentialsRequest)]
   (clojure.core/when-let
    [v4915 (:target-arn m4914)]
    (. bean4913 setTargetARN (clojure.core/str v4915)))
   (clojure.core/when-let
    [v4915 (:initiator-name m4914)]
    (. bean4913 setInitiatorName (clojure.core/str v4915)))
   bean4913))
 (clojure.core/defn
  ^com.amazonaws.services.storagegateway.model.UpdateMaintenanceStartTimeRequest update-maintenance-start-time-request
  [m4917]
  (clojure.core/let
   [bean4916
    (new
     com.amazonaws.services.storagegateway.model.UpdateMaintenanceStartTimeRequest)]
   (clojure.core/when-let
    [v4918 (:gateway-arn m4917)]
    (. bean4916 setGatewayARN (clojure.core/str v4918)))
   (clojure.core/when-let
    [v4918 (:day-of-week m4917)]
    (. bean4916 setDayOfWeek (clojure.core/int v4918)))
   (clojure.core/when-let
    [v4918 (:hour-of-day m4917)]
    (. bean4916 setHourOfDay (clojure.core/int v4918)))
   (clojure.core/when-let
    [v4918 (:minute-of-hour m4917)]
    (. bean4916 setMinuteOfHour (clojure.core/int v4918)))
   bean4916))
 (clojure.core/defn
  ^com.amazonaws.services.storagegateway.model.AddCacheRequest add-cache-request
  [m4920]
  (clojure.core/let
   [bean4919
    (new com.amazonaws.services.storagegateway.model.AddCacheRequest)]
   (clojure.core/when-let
    [v4921 (:gateway-arn m4920)]
    (. bean4919 setGatewayARN (clojure.core/str v4921)))
   (clojure.core/when-let
    [v4921 (:disk-ids m4920)]
    (.
     bean4919
     setDiskIds
     (clojure.core/map
      (clojure.core/fn [arg4925] (clojure.core/str arg4925))
      v4921)))
   bean4919))
 (clojure.core/defn
  ^com.amazonaws.services.storagegateway.model.DescribeCachediSCSIVolumesRequest describe-cachedi-scsivolumes-request
  [m4923]
  (clojure.core/let
   [bean4922
    (new
     com.amazonaws.services.storagegateway.model.DescribeCachediSCSIVolumesRequest)]
   (clojure.core/when-let
    [v4924 (:volume-arns m4923)]
    (.
     bean4922
     setVolumeARNs
     (clojure.core/map
      (clojure.core/fn [arg4929] (clojure.core/str arg4929))
      v4924)))
   bean4922))
 (clojure.core/defn
  ^com.amazonaws.services.storagegateway.model.DescribeBandwidthRateLimitRequest describe-bandwidth-rate-limit-request
  [m4927]
  (clojure.core/let
   [bean4926
    (new
     com.amazonaws.services.storagegateway.model.DescribeBandwidthRateLimitRequest)]
   (clojure.core/when-let
    [v4928 (:gateway-arn m4927)]
    (. bean4926 setGatewayARN (clojure.core/str v4928)))
   bean4926))
 (clojure.core/defn
  ^com.amazonaws.services.storagegateway.model.ListVolumesRequest list-volumes-request
  [m4931]
  (clojure.core/let
   [bean4930
    (new
     com.amazonaws.services.storagegateway.model.ListVolumesRequest)]
   (clojure.core/when-let
    [v4932 (:gateway-arn m4931)]
    (. bean4930 setGatewayARN (clojure.core/str v4932)))
   (clojure.core/when-let
    [v4932 (:marker m4931)]
    (. bean4930 setMarker (clojure.core/str v4932)))
   (clojure.core/when-let
    [v4932 (:limit m4931)]
    (. bean4930 setLimit (clojure.core/int v4932)))
   bean4930))
 (clojure.core/defn
  ^com.amazonaws.services.storagegateway.model.ActivateGatewayRequest activate-gateway-request
  [m4934]
  (clojure.core/let
   [bean4933
    (new
     com.amazonaws.services.storagegateway.model.ActivateGatewayRequest)]
   (clojure.core/when-let
    [v4935 (:activation-key m4934)]
    (. bean4933 setActivationKey (clojure.core/str v4935)))
   (clojure.core/when-let
    [v4935 (:gateway-name m4934)]
    (. bean4933 setGatewayName (clojure.core/str v4935)))
   (clojure.core/when-let
    [v4935 (:gateway-timezone m4934)]
    (. bean4933 setGatewayTimezone (clojure.core/str v4935)))
   (clojure.core/when-let
    [v4935 (:gateway-timezone m4934)]
    (. bean4933 setGatewayTimezone (gateway-timezone v4935)))
   (clojure.core/when-let
    [v4935 (:gateway-region m4934)]
    (. bean4933 setGatewayRegion (clojure.core/str v4935)))
   (clojure.core/when-let
    [v4935 (:gateway-type m4934)]
    (. bean4933 setGatewayType (gateway-type v4935)))
   (clojure.core/when-let
    [v4935 (:gateway-type m4934)]
    (. bean4933 setGatewayType (clojure.core/str v4935)))
   bean4933))
 (clojure.core/defn
  ^com.amazonaws.services.storagegateway.model.DescribeCacheRequest describe-cache-request
  [m4937]
  (clojure.core/let
   [bean4936
    (new
     com.amazonaws.services.storagegateway.model.DescribeCacheRequest)]
   (clojure.core/when-let
    [v4938 (:gateway-arn m4937)]
    (. bean4936 setGatewayARN (clojure.core/str v4938)))
   bean4936))
 (clojure.core/defn
  ^com.amazonaws.services.storagegateway.model.UpdateGatewaySoftwareNowRequest update-gateway-software-now-request
  [m4940]
  (clojure.core/let
   [bean4939
    (new
     com.amazonaws.services.storagegateway.model.UpdateGatewaySoftwareNowRequest)]
   (clojure.core/when-let
    [v4941 (:gateway-arn m4940)]
    (. bean4939 setGatewayARN (clojure.core/str v4941)))
   bean4939))
 (clojure.core/defn
  ^com.amazonaws.services.storagegateway.model.UpdateChapCredentialsRequest update-chap-credentials-request
  [m4943]
  (clojure.core/let
   [bean4942
    (new
     com.amazonaws.services.storagegateway.model.UpdateChapCredentialsRequest)]
   (clojure.core/when-let
    [v4944 (:target-arn m4943)]
    (. bean4942 setTargetARN (clojure.core/str v4944)))
   (clojure.core/when-let
    [v4944 (:secret-to-authenticate-initiator m4943)]
    (.
     bean4942
     setSecretToAuthenticateInitiator
     (clojure.core/str v4944)))
   (clojure.core/when-let
    [v4944 (:initiator-name m4943)]
    (. bean4942 setInitiatorName (clojure.core/str v4944)))
   (clojure.core/when-let
    [v4944 (:secret-to-authenticate-target m4943)]
    (.
     bean4942
     setSecretToAuthenticateTarget
     (clojure.core/str v4944)))
   bean4942))
 (clojure.core/defn
  ^com.amazonaws.services.storagegateway.model.CreateStorediSCSIVolumeRequest create-storedi-scsivolume-request
  [m4946]
  (clojure.core/let
   [bean4945
    (new
     com.amazonaws.services.storagegateway.model.CreateStorediSCSIVolumeRequest)]
   (clojure.core/when-let
    [v4947 (:gateway-arn m4946)]
    (. bean4945 setGatewayARN (clojure.core/str v4947)))
   (clojure.core/when-let
    [v4947 (:target-name m4946)]
    (. bean4945 setTargetName (clojure.core/str v4947)))
   (clojure.core/when-let
    [v4947 (:network-interface-id m4946)]
    (. bean4945 setNetworkInterfaceId (clojure.core/str v4947)))
   (clojure.core/when-let
    [v4947 (:disk-id m4946)]
    (. bean4945 setDiskId (clojure.core/str v4947)))
   (clojure.core/when-let
    [v4947 (:preserve-existing-data m4946)]
    (. bean4945 setPreserveExistingData (clojure.core/boolean v4947)))
   (clojure.core/when-let
    [v4947 (:snapshot-id m4946)]
    (. bean4945 setSnapshotId (clojure.core/str v4947)))
   bean4945))
 (clojure.core/defn
  ^com.amazonaws.services.storagegateway.model.UpdateGatewayInformationRequest update-gateway-information-request
  [m4949]
  (clojure.core/let
   [bean4948
    (new
     com.amazonaws.services.storagegateway.model.UpdateGatewayInformationRequest)]
   (clojure.core/when-let
    [v4950 (:gateway-arn m4949)]
    (. bean4948 setGatewayARN (clojure.core/str v4950)))
   (clojure.core/when-let
    [v4950 (:gateway-name m4949)]
    (. bean4948 setGatewayName (clojure.core/str v4950)))
   (clojure.core/when-let
    [v4950 (:gateway-timezone m4949)]
    (. bean4948 setGatewayTimezone (clojure.core/str v4950)))
   (clojure.core/when-let
    [v4950 (:gateway-timezone m4949)]
    (. bean4948 setGatewayTimezone (gateway-timezone v4950)))
   bean4948))
 (clojure.core/defn
  ^com.amazonaws.services.storagegateway.model.DescribeGatewayInformationRequest describe-gateway-information-request
  [m4952]
  (clojure.core/let
   [bean4951
    (new
     com.amazonaws.services.storagegateway.model.DescribeGatewayInformationRequest)]
   (clojure.core/when-let
    [v4953 (:gateway-arn m4952)]
    (. bean4951 setGatewayARN (clojure.core/str v4953)))
   bean4951))
 (clojure.core/defn
  ^com.amazonaws.services.storagegateway.model.ShutdownGatewayRequest shutdown-gateway-request
  [m4955]
  (clojure.core/let
   [bean4954
    (new
     com.amazonaws.services.storagegateway.model.ShutdownGatewayRequest)]
   (clojure.core/when-let
    [v4956 (:gateway-arn m4955)]
    (. bean4954 setGatewayARN (clojure.core/str v4956)))
   bean4954))
 (clojure.core/defn
  ^com.amazonaws.services.storagegateway.model.ListVolumeRecoveryPointsRequest list-volume-recovery-points-request
  [m4958]
  (clojure.core/let
   [bean4957
    (new
     com.amazonaws.services.storagegateway.model.ListVolumeRecoveryPointsRequest)]
   (clojure.core/when-let
    [v4959 (:gateway-arn m4958)]
    (. bean4957 setGatewayARN (clojure.core/str v4959)))
   bean4957))
 (clojure.core/defn
  ^com.amazonaws.services.storagegateway.model.DeleteGatewayRequest delete-gateway-request
  [m4961]
  (clojure.core/let
   [bean4960
    (new
     com.amazonaws.services.storagegateway.model.DeleteGatewayRequest)]
   (clojure.core/when-let
    [v4962 (:gateway-arn m4961)]
    (. bean4960 setGatewayARN (clojure.core/str v4962)))
   bean4960))
 (clojure.core/defn
  ^com.amazonaws.services.storagegateway.model.CreateSnapshotRequest create-snapshot-request
  [m4964]
  (clojure.core/let
   [bean4963
    (new
     com.amazonaws.services.storagegateway.model.CreateSnapshotRequest)]
   (clojure.core/when-let
    [v4965 (:volume-arn m4964)]
    (. bean4963 setVolumeARN (clojure.core/str v4965)))
   (clojure.core/when-let
    [v4965 (:snapshot-description m4964)]
    (. bean4963 setSnapshotDescription (clojure.core/str v4965)))
   bean4963))
 (clojure.core/defn
  ^com.amazonaws.services.storagegateway.model.DeleteVolumeRequest delete-volume-request
  [m4967]
  (clojure.core/let
   [bean4966
    (new
     com.amazonaws.services.storagegateway.model.DeleteVolumeRequest)]
   (clojure.core/when-let
    [v4968 (:volume-arn m4967)]
    (. bean4966 setVolumeARN (clojure.core/str v4968)))
   bean4966))
 (clojure.core/defn
  ^com.amazonaws.services.storagegateway.model.UpdateSnapshotScheduleRequest update-snapshot-schedule-request
  [m4970]
  (clojure.core/let
   [bean4969
    (new
     com.amazonaws.services.storagegateway.model.UpdateSnapshotScheduleRequest)]
   (clojure.core/when-let
    [v4971 (:volume-arn m4970)]
    (. bean4969 setVolumeARN (clojure.core/str v4971)))
   (clojure.core/when-let
    [v4971 (:start-at m4970)]
    (. bean4969 setStartAt (clojure.core/int v4971)))
   (clojure.core/when-let
    [v4971 (:recurrence-in-hours m4970)]
    (. bean4969 setRecurrenceInHours (clojure.core/int v4971)))
   (clojure.core/when-let
    [v4971 (:description m4970)]
    (. bean4969 setDescription (clojure.core/str v4971)))
   bean4969))
 (clojure.core/defn
  ^com.amazonaws.services.storagegateway.model.DescribeSnapshotScheduleRequest describe-snapshot-schedule-request
  [m4973]
  (clojure.core/let
   [bean4972
    (new
     com.amazonaws.services.storagegateway.model.DescribeSnapshotScheduleRequest)]
   (clojure.core/when-let
    [v4974 (:volume-arn m4973)]
    (. bean4972 setVolumeARN (clojure.core/str v4974)))
   bean4972))
 (clojure.core/defn
  ^com.amazonaws.services.storagegateway.model.ListGatewaysRequest list-gateways-request
  [m4976]
  (clojure.core/let
   [bean4975
    (new
     com.amazonaws.services.storagegateway.model.ListGatewaysRequest)]
   (clojure.core/when-let
    [v4977 (:marker m4976)]
    (. bean4975 setMarker (clojure.core/str v4977)))
   (clojure.core/when-let
    [v4977 (:limit m4976)]
    (. bean4975 setLimit (clojure.core/int v4977)))
   bean4975))
 (clojure.core/defmulti
  storagegateway
  (clojure.core/fn
   storagegateway
   [m__1641__auto__]
   (:fn m__1641__auto__)))
 (do
  (clojure.core/defmethod
   storagegateway
   :describe-maintenance-start-time
   [m4978]
   (clojure.core/let
    [credentials4979 (:credentials m4978) args4980 (:args m4978)]
    (clojure.core/let
     [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4981
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials4979)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4981
       describeMaintenanceStartTime
       (describe-maintenance-start-time-request
        (clojure.core/nth args4980 0)))))))
  (clojure.core/defn
   describe-maintenance-start-time-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector gateway-arn]}]]),
    :doc "Generate map for describeMaintenanceStartTime"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :describe-maintenance-start-time,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-maintenance-start-time
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector gateway-arn]}]]),
    :doc "Call describeMaintenanceStartTime"}
   [credentials4983 & args4984]
   (clojure.core/let
    [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4985
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials4983)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4985
      describeMaintenanceStartTime
      (describe-maintenance-start-time-request
       (clojure.core/nth args4984 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :update-bandwidth-rate-limit
   [m4986]
   (clojure.core/let
    [credentials4987 (:credentials m4986) args4988 (:args m4986)]
    (clojure.core/let
     [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4989
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials4987)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4989
       updateBandwidthRateLimit
       (update-bandwidth-rate-limit-request
        (clojure.core/nth args4988 0)))))))
  (clojure.core/defn
   update-bandwidth-rate-limit-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         gateway-arn
                         average-upload-rate-limit-in-bits-per-sec
                         average-download-rate-limit-in-bits-per-sec]}]]),
    :doc "Generate map for updateBandwidthRateLimit"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :update-bandwidth-rate-limit,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   update-bandwidth-rate-limit
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         gateway-arn
                         average-upload-rate-limit-in-bits-per-sec
                         average-download-rate-limit-in-bits-per-sec]}]]),
    :doc "Call updateBandwidthRateLimit"}
   [credentials4991 & args4992]
   (clojure.core/let
    [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4993
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials4991)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4993
      updateBandwidthRateLimit
      (update-bandwidth-rate-limit-request
       (clojure.core/nth args4992 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :describe-working-storage
   [m4994]
   (clojure.core/let
    [credentials4995 (:credentials m4994) args4996 (:args m4994)]
    (clojure.core/let
     [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4997
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials4995)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client4997
       describeWorkingStorage
       (describe-working-storage-request
        (clojure.core/nth args4996 0)))))))
  (clojure.core/defn
   describe-working-storage-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector gateway-arn]}]]),
    :doc "Generate map for describeWorkingStorage"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :describe-working-storage,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-working-storage
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector gateway-arn]}]]),
    :doc "Call describeWorkingStorage"}
   [credentials4999 & args5000]
   (clojure.core/let
    [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5001
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials4999)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5001
      describeWorkingStorage
      (describe-working-storage-request (clojure.core/nth args5000 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :delete-snapshot-schedule
   [m5002]
   (clojure.core/let
    [credentials5003 (:credentials m5002) args5004 (:args m5002)]
    (clojure.core/let
     [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5005
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5003)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5005
       deleteSnapshotSchedule
       (delete-snapshot-schedule-request
        (clojure.core/nth args5004 0)))))))
  (clojure.core/defn
   delete-snapshot-schedule-map
   {:arglists (quote
               [[credentials
                 {:keys [volume-arn request-metric-collector]}]]),
    :doc "Generate map for deleteSnapshotSchedule"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :delete-snapshot-schedule,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   delete-snapshot-schedule
   {:arglists (quote
               [[credentials
                 {:keys [volume-arn request-metric-collector]}]]),
    :doc "Call deleteSnapshotSchedule"}
   [credentials5007 & args5008]
   (clojure.core/let
    [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5009
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5007)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5009
      deleteSnapshotSchedule
      (delete-snapshot-schedule-request (clojure.core/nth args5008 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :describe-chap-credentials
   [m5010]
   (clojure.core/let
    [credentials5011 (:credentials m5010) args5012 (:args m5010)]
    (clojure.core/let
     [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5013
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5011)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5013
       describeChapCredentials
       (describe-chap-credentials-request
        (clojure.core/nth args5012 0)))))))
  (clojure.core/defn
   describe-chap-credentials-map
   {:arglists (quote
               [[credentials
                 {:keys [target-arn request-metric-collector]}]]),
    :doc "Generate map for describeChapCredentials"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :describe-chap-credentials,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-chap-credentials
   {:arglists (quote
               [[credentials
                 {:keys [target-arn request-metric-collector]}]]),
    :doc "Call describeChapCredentials"}
   [credentials5015 & args5016]
   (clojure.core/let
    [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5017
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5015)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5017
      describeChapCredentials
      (describe-chap-credentials-request
       (clojure.core/nth args5016 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :delete-bandwidth-rate-limit
   [m5018]
   (clojure.core/let
    [credentials5019 (:credentials m5018) args5020 (:args m5018)]
    (clojure.core/let
     [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5021
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5019)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5021
       deleteBandwidthRateLimit
       (delete-bandwidth-rate-limit-request
        (clojure.core/nth args5020 0)))))))
  (clojure.core/defn
   delete-bandwidth-rate-limit-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         gateway-arn
                         bandwidth-type]}]]),
    :doc "Generate map for deleteBandwidthRateLimit"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :delete-bandwidth-rate-limit,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   delete-bandwidth-rate-limit
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         gateway-arn
                         bandwidth-type]}]]),
    :doc "Call deleteBandwidthRateLimit"}
   [credentials5023 & args5024]
   (clojure.core/let
    [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5025
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5023)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5025
      deleteBandwidthRateLimit
      (delete-bandwidth-rate-limit-request
       (clojure.core/nth args5024 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :create-cachedi-scsivolume
   [m5026]
   (clojure.core/let
    [credentials5027 (:credentials m5026) args5028 (:args m5026)]
    (clojure.core/let
     [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5029
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5027)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5029
       createCachediSCSIVolume
       (create-cachedi-scsivolume-request
        (clojure.core/nth args5028 0)))))))
  (clojure.core/defn
   create-cachedi-scsivolume-map
   {:arglists (quote
               [[credentials
                 {:keys [network-interface-id
                         client-token
                         target-name
                         volume-size-in-bytes
                         gateway-arn
                         request-metric-collector
                         snapshot-id]}]]),
    :doc "Generate map for createCachediSCSIVolume"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :create-cachedi-scsivolume,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   create-cachedi-scsivolume
   {:arglists (quote
               [[credentials
                 {:keys [network-interface-id
                         client-token
                         target-name
                         volume-size-in-bytes
                         gateway-arn
                         request-metric-collector
                         snapshot-id]}]]),
    :doc "Call createCachediSCSIVolume"}
   [credentials5031 & args5032]
   (clojure.core/let
    [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5033
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5031)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5033
      createCachediSCSIVolume
      (create-cachedi-scsivolume-request
       (clojure.core/nth args5032 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :create-snapshot-from-volume-recovery-point
   [m5034]
   (clojure.core/let
    [credentials5035 (:credentials m5034) args5036 (:args m5034)]
    (clojure.core/let
     [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5037
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5035)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5037
       createSnapshotFromVolumeRecoveryPoint
       (create-snapshot-from-volume-recovery-point-request
        (clojure.core/nth args5036 0)))))))
  (clojure.core/defn
   create-snapshot-from-volume-recovery-point-map
   {:arglists (quote
               [[credentials
                 {:keys [volume-arn
                         snapshot-description
                         request-metric-collector]}]]),
    :doc "Generate map for createSnapshotFromVolumeRecoveryPoint"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :create-snapshot-from-volume-recovery-point,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   create-snapshot-from-volume-recovery-point
   {:arglists (quote
               [[credentials
                 {:keys [volume-arn
                         snapshot-description
                         request-metric-collector]}]]),
    :doc "Call createSnapshotFromVolumeRecoveryPoint"}
   [credentials5039 & args5040]
   (clojure.core/let
    [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5041
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5039)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5041
      createSnapshotFromVolumeRecoveryPoint
      (create-snapshot-from-volume-recovery-point-request
       (clojure.core/nth args5040 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :describe-storedi-scsivolumes
   [m5042]
   (clojure.core/let
    [credentials5043 (:credentials m5042) args5044 (:args m5042)]
    (clojure.core/let
     [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5045
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5043)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5045
       describeStorediSCSIVolumes
       (describe-storedi-scsivolumes-request
        (clojure.core/nth args5044 0)))))))
  (clojure.core/defn
   describe-storedi-scsivolumes-map
   {:arglists (quote
               [[credentials
                 {:keys [volume-arns request-metric-collector]}]]),
    :doc "Generate map for describeStorediSCSIVolumes"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :describe-storedi-scsivolumes,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-storedi-scsivolumes
   {:arglists (quote
               [[credentials
                 {:keys [volume-arns request-metric-collector]}]]),
    :doc "Call describeStorediSCSIVolumes"}
   [credentials5047 & args5048]
   (clojure.core/let
    [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5049
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5047)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5049
      describeStorediSCSIVolumes
      (describe-storedi-scsivolumes-request
       (clojure.core/nth args5048 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :describe-upload-buffer
   [m5050]
   (clojure.core/let
    [credentials5051 (:credentials m5050) args5052 (:args m5050)]
    (clojure.core/let
     [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5053
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5051)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5053
       describeUploadBuffer
       (describe-upload-buffer-request (clojure.core/nth args5052 0)))))))
  (clojure.core/defn
   describe-upload-buffer-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector gateway-arn]}]]),
    :doc "Generate map for describeUploadBuffer"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :describe-upload-buffer,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-upload-buffer
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector gateway-arn]}]]),
    :doc "Call describeUploadBuffer"}
   [credentials5055 & args5056]
   (clojure.core/let
    [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5057
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5055)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5057
      describeUploadBuffer
      (describe-upload-buffer-request (clojure.core/nth args5056 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :add-upload-buffer
   [m5058]
   (clojure.core/let
    [credentials5059 (:credentials m5058) args5060 (:args m5058)]
    (clojure.core/let
     [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5061
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5059)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5061
       addUploadBuffer
       (add-upload-buffer-request (clojure.core/nth args5060 0)))))))
  (clojure.core/defn
   add-upload-buffer-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         gateway-arn
                         disk-ids]}]]),
    :doc "Generate map for addUploadBuffer"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :add-upload-buffer,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   add-upload-buffer
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         gateway-arn
                         disk-ids]}]]),
    :doc "Call addUploadBuffer"}
   [credentials5063 & args5064]
   (clojure.core/let
    [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5065
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5063)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5065
      addUploadBuffer
      (add-upload-buffer-request (clojure.core/nth args5064 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :add-working-storage
   [m5066]
   (clojure.core/let
    [credentials5067 (:credentials m5066) args5068 (:args m5066)]
    (clojure.core/let
     [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5069
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5067)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5069
       addWorkingStorage
       (add-working-storage-request (clojure.core/nth args5068 0)))))))
  (clojure.core/defn
   add-working-storage-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         gateway-arn
                         disk-ids]}]]),
    :doc "Generate map for addWorkingStorage"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :add-working-storage,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   add-working-storage
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         gateway-arn
                         disk-ids]}]]),
    :doc "Call addWorkingStorage"}
   [credentials5071 & args5072]
   (clojure.core/let
    [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5073
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5071)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5073
      addWorkingStorage
      (add-working-storage-request (clojure.core/nth args5072 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :start-gateway
   [m5074]
   (clojure.core/let
    [credentials5075 (:credentials m5074) args5076 (:args m5074)]
    (clojure.core/let
     [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5077
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5075)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5077
       startGateway
       (start-gateway-request (clojure.core/nth args5076 0)))))))
  (clojure.core/defn
   start-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector gateway-arn]}]]),
    :doc "Generate map for startGateway"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :start-gateway,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   start-gateway
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector gateway-arn]}]]),
    :doc "Call startGateway"}
   [credentials5079 & args5080]
   (clojure.core/let
    [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5081
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5079)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5081
      startGateway
      (start-gateway-request (clojure.core/nth args5080 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :list-local-disks
   [m5082]
   (clojure.core/let
    [credentials5083 (:credentials m5082) args5084 (:args m5082)]
    (clojure.core/let
     [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5085
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5083)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5085
       listLocalDisks
       (list-local-disks-request (clojure.core/nth args5084 0)))))))
  (clojure.core/defn
   list-local-disks-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector gateway-arn]}]]),
    :doc "Generate map for listLocalDisks"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :list-local-disks,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   list-local-disks
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector gateway-arn]}]]),
    :doc "Call listLocalDisks"}
   [credentials5087 & args5088]
   (clojure.core/let
    [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5089
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5087)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5089
      listLocalDisks
      (list-local-disks-request (clojure.core/nth args5088 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :delete-chap-credentials
   [m5090]
   (clojure.core/let
    [credentials5091 (:credentials m5090) args5092 (:args m5090)]
    (clojure.core/let
     [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5093
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5091)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5093
       deleteChapCredentials
       (delete-chap-credentials-request (clojure.core/nth args5092 0)))))))
  (clojure.core/defn
   delete-chap-credentials-map
   {:arglists (quote
               [[credentials
                 {:keys [target-arn
                         request-metric-collector
                         initiator-name]}]]),
    :doc "Generate map for deleteChapCredentials"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :delete-chap-credentials,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   delete-chap-credentials
   {:arglists (quote
               [[credentials
                 {:keys [target-arn
                         request-metric-collector
                         initiator-name]}]]),
    :doc "Call deleteChapCredentials"}
   [credentials5095 & args5096]
   (clojure.core/let
    [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5097
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5095)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5097
      deleteChapCredentials
      (delete-chap-credentials-request (clojure.core/nth args5096 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :update-maintenance-start-time
   [m5098]
   (clojure.core/let
    [credentials5099 (:credentials m5098) args5100 (:args m5098)]
    (clojure.core/let
     [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5101
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5099)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5101
       updateMaintenanceStartTime
       (update-maintenance-start-time-request
        (clojure.core/nth args5100 0)))))))
  (clojure.core/defn
   update-maintenance-start-time-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         minute-of-hour
                         hour-of-day
                         gateway-arn
                         day-of-week]}]]),
    :doc "Generate map for updateMaintenanceStartTime"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :update-maintenance-start-time,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   update-maintenance-start-time
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         minute-of-hour
                         hour-of-day
                         gateway-arn
                         day-of-week]}]]),
    :doc "Call updateMaintenanceStartTime"}
   [credentials5103 & args5104]
   (clojure.core/let
    [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5105
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5103)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5105
      updateMaintenanceStartTime
      (update-maintenance-start-time-request
       (clojure.core/nth args5104 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :add-cache
   [m5106]
   (clojure.core/let
    [credentials5107 (:credentials m5106) args5108 (:args m5106)]
    (clojure.core/let
     [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5109
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5107)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5109
       addCache
       (add-cache-request (clojure.core/nth args5108 0)))))))
  (clojure.core/defn
   add-cache-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         gateway-arn
                         disk-ids]}]]),
    :doc "Generate map for addCache"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :add-cache,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   add-cache
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         gateway-arn
                         disk-ids]}]]),
    :doc "Call addCache"}
   [credentials5111 & args5112]
   (clojure.core/let
    [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5113
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5111)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5113
      addCache
      (add-cache-request (clojure.core/nth args5112 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :describe-cachedi-scsivolumes
   [m5114]
   (clojure.core/let
    [credentials5115 (:credentials m5114) args5116 (:args m5114)]
    (clojure.core/let
     [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5117
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5115)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5117
       describeCachediSCSIVolumes
       (describe-cachedi-scsivolumes-request
        (clojure.core/nth args5116 0)))))))
  (clojure.core/defn
   describe-cachedi-scsivolumes-map
   {:arglists (quote
               [[credentials
                 {:keys [volume-arns request-metric-collector]}]]),
    :doc "Generate map for describeCachediSCSIVolumes"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :describe-cachedi-scsivolumes,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-cachedi-scsivolumes
   {:arglists (quote
               [[credentials
                 {:keys [volume-arns request-metric-collector]}]]),
    :doc "Call describeCachediSCSIVolumes"}
   [credentials5119 & args5120]
   (clojure.core/let
    [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5121
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5119)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5121
      describeCachediSCSIVolumes
      (describe-cachedi-scsivolumes-request
       (clojure.core/nth args5120 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :describe-bandwidth-rate-limit
   [m5122]
   (clojure.core/let
    [credentials5123 (:credentials m5122) args5124 (:args m5122)]
    (clojure.core/let
     [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5125
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5123)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5125
       describeBandwidthRateLimit
       (describe-bandwidth-rate-limit-request
        (clojure.core/nth args5124 0)))))))
  (clojure.core/defn
   describe-bandwidth-rate-limit-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector gateway-arn]}]]),
    :doc "Generate map for describeBandwidthRateLimit"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :describe-bandwidth-rate-limit,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-bandwidth-rate-limit
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector gateway-arn]}]]),
    :doc "Call describeBandwidthRateLimit"}
   [credentials5127 & args5128]
   (clojure.core/let
    [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5129
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5127)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5129
      describeBandwidthRateLimit
      (describe-bandwidth-rate-limit-request
       (clojure.core/nth args5128 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :list-volumes
   [m5130]
   (clojure.core/let
    [credentials5131 (:credentials m5130) args5132 (:args m5130)]
    (clojure.core/let
     [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5133
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5131)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5133
       listVolumes
       (list-volumes-request (clojure.core/nth args5132 0)))))))
  (clojure.core/defn
   list-volumes-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         marker
                         limit
                         gateway-arn]}]]),
    :doc "Generate map for listVolumes"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :list-volumes,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   list-volumes
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         marker
                         limit
                         gateway-arn]}]]),
    :doc "Call listVolumes"}
   [credentials5135 & args5136]
   (clojure.core/let
    [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5137
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5135)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5137
      listVolumes
      (list-volumes-request (clojure.core/nth args5136 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :activate-gateway
   [m5138]
   (clojure.core/let
    [credentials5139 (:credentials m5138) args5140 (:args m5138)]
    (clojure.core/let
     [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5141
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5139)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5141
       activateGateway
       (activate-gateway-request (clojure.core/nth args5140 0)))))))
  (clojure.core/defn
   activate-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         gateway-type
                         gateway-timezone
                         gateway-region
                         gateway-name
                         activation-key]}]]),
    :doc "Generate map for activateGateway"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :activate-gateway,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   activate-gateway
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         gateway-type
                         gateway-timezone
                         gateway-region
                         gateway-name
                         activation-key]}]]),
    :doc "Call activateGateway"}
   [credentials5143 & args5144]
   (clojure.core/let
    [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5145
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5143)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5145
      activateGateway
      (activate-gateway-request (clojure.core/nth args5144 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :describe-cache
   [m5146]
   (clojure.core/let
    [credentials5147 (:credentials m5146) args5148 (:args m5146)]
    (clojure.core/let
     [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5149
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5147)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5149
       describeCache
       (describe-cache-request (clojure.core/nth args5148 0)))))))
  (clojure.core/defn
   describe-cache-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector gateway-arn]}]]),
    :doc "Generate map for describeCache"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :describe-cache,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-cache
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector gateway-arn]}]]),
    :doc "Call describeCache"}
   [credentials5151 & args5152]
   (clojure.core/let
    [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5153
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5151)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5153
      describeCache
      (describe-cache-request (clojure.core/nth args5152 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :update-gateway-software-now
   [m5154]
   (clojure.core/let
    [credentials5155 (:credentials m5154) args5156 (:args m5154)]
    (clojure.core/let
     [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5157
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5155)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5157
       updateGatewaySoftwareNow
       (update-gateway-software-now-request
        (clojure.core/nth args5156 0)))))))
  (clojure.core/defn
   update-gateway-software-now-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector gateway-arn]}]]),
    :doc "Generate map for updateGatewaySoftwareNow"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :update-gateway-software-now,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   update-gateway-software-now
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector gateway-arn]}]]),
    :doc "Call updateGatewaySoftwareNow"}
   [credentials5159 & args5160]
   (clojure.core/let
    [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5161
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5159)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5161
      updateGatewaySoftwareNow
      (update-gateway-software-now-request
       (clojure.core/nth args5160 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :update-chap-credentials
   [m5162]
   (clojure.core/let
    [credentials5163 (:credentials m5162) args5164 (:args m5162)]
    (clojure.core/let
     [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5165
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5163)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5165
       updateChapCredentials
       (update-chap-credentials-request (clojure.core/nth args5164 0)))))))
  (clojure.core/defn
   update-chap-credentials-map
   {:arglists (quote
               [[credentials
                 {:keys [target-arn
                         secret-to-authenticate-target
                         secret-to-authenticate-initiator
                         request-metric-collector
                         initiator-name]}]]),
    :doc "Generate map for updateChapCredentials"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :update-chap-credentials,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   update-chap-credentials
   {:arglists (quote
               [[credentials
                 {:keys [target-arn
                         secret-to-authenticate-target
                         secret-to-authenticate-initiator
                         request-metric-collector
                         initiator-name]}]]),
    :doc "Call updateChapCredentials"}
   [credentials5167 & args5168]
   (clojure.core/let
    [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5169
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5167)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5169
      updateChapCredentials
      (update-chap-credentials-request (clojure.core/nth args5168 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :create-storedi-scsivolume
   [m5170]
   (clojure.core/let
    [credentials5171 (:credentials m5170) args5172 (:args m5170)]
    (clojure.core/let
     [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5173
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5171)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5173
       createStorediSCSIVolume
       (create-storedi-scsivolume-request
        (clojure.core/nth args5172 0)))))))
  (clojure.core/defn
   create-storedi-scsivolume-map
   {:arglists (quote
               [[credentials
                 {:keys [network-interface-id
                         target-name
                         gateway-arn
                         request-metric-collector
                         preserve-existing-data
                         snapshot-id
                         disk-id]}]]),
    :doc "Generate map for createStorediSCSIVolume"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :create-storedi-scsivolume,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   create-storedi-scsivolume
   {:arglists (quote
               [[credentials
                 {:keys [network-interface-id
                         target-name
                         gateway-arn
                         request-metric-collector
                         preserve-existing-data
                         snapshot-id
                         disk-id]}]]),
    :doc "Call createStorediSCSIVolume"}
   [credentials5175 & args5176]
   (clojure.core/let
    [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5177
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5175)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5177
      createStorediSCSIVolume
      (create-storedi-scsivolume-request
       (clojure.core/nth args5176 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :update-gateway-information
   [m5178]
   (clojure.core/let
    [credentials5179 (:credentials m5178) args5180 (:args m5178)]
    (clojure.core/let
     [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5181
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5179)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5181
       updateGatewayInformation
       (update-gateway-information-request
        (clojure.core/nth args5180 0)))))))
  (clojure.core/defn
   update-gateway-information-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         gateway-timezone
                         gateway-name
                         gateway-arn]}]]),
    :doc "Generate map for updateGatewayInformation"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :update-gateway-information,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   update-gateway-information
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         gateway-timezone
                         gateway-name
                         gateway-arn]}]]),
    :doc "Call updateGatewayInformation"}
   [credentials5183 & args5184]
   (clojure.core/let
    [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5185
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5183)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5185
      updateGatewayInformation
      (update-gateway-information-request
       (clojure.core/nth args5184 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :describe-gateway-information
   [m5186]
   (clojure.core/let
    [credentials5187 (:credentials m5186) args5188 (:args m5186)]
    (clojure.core/let
     [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5189
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5187)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5189
       describeGatewayInformation
       (describe-gateway-information-request
        (clojure.core/nth args5188 0)))))))
  (clojure.core/defn
   describe-gateway-information-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector gateway-arn]}]]),
    :doc "Generate map for describeGatewayInformation"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :describe-gateway-information,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-gateway-information
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector gateway-arn]}]]),
    :doc "Call describeGatewayInformation"}
   [credentials5191 & args5192]
   (clojure.core/let
    [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5193
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5191)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5193
      describeGatewayInformation
      (describe-gateway-information-request
       (clojure.core/nth args5192 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :shutdown-gateway
   [m5194]
   (clojure.core/let
    [credentials5195 (:credentials m5194) args5196 (:args m5194)]
    (clojure.core/let
     [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5197
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5195)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5197
       shutdownGateway
       (shutdown-gateway-request (clojure.core/nth args5196 0)))))))
  (clojure.core/defn
   shutdown-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector gateway-arn]}]]),
    :doc "Generate map for shutdownGateway"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :shutdown-gateway,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   shutdown-gateway
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector gateway-arn]}]]),
    :doc "Call shutdownGateway"}
   [credentials5199 & args5200]
   (clojure.core/let
    [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5201
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5199)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5201
      shutdownGateway
      (shutdown-gateway-request (clojure.core/nth args5200 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :list-volume-recovery-points
   [m5202]
   (clojure.core/let
    [credentials5203 (:credentials m5202) args5204 (:args m5202)]
    (clojure.core/let
     [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5205
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5203)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5205
       listVolumeRecoveryPoints
       (list-volume-recovery-points-request
        (clojure.core/nth args5204 0)))))))
  (clojure.core/defn
   list-volume-recovery-points-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector gateway-arn]}]]),
    :doc "Generate map for listVolumeRecoveryPoints"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :list-volume-recovery-points,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   list-volume-recovery-points
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector gateway-arn]}]]),
    :doc "Call listVolumeRecoveryPoints"}
   [credentials5207 & args5208]
   (clojure.core/let
    [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5209
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5207)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5209
      listVolumeRecoveryPoints
      (list-volume-recovery-points-request
       (clojure.core/nth args5208 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :delete-gateway
   [m5210]
   (clojure.core/let
    [credentials5211 (:credentials m5210) args5212 (:args m5210)]
    (clojure.core/let
     [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5213
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5211)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5213
       deleteGateway
       (delete-gateway-request (clojure.core/nth args5212 0)))))))
  (clojure.core/defn
   delete-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector gateway-arn]}]]),
    :doc "Generate map for deleteGateway"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :delete-gateway,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   delete-gateway
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector gateway-arn]}]]),
    :doc "Call deleteGateway"}
   [credentials5215 & args5216]
   (clojure.core/let
    [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5217
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5215)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5217
      deleteGateway
      (delete-gateway-request (clojure.core/nth args5216 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :create-snapshot
   [m5218]
   (clojure.core/let
    [credentials5219 (:credentials m5218) args5220 (:args m5218)]
    (clojure.core/let
     [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5221
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5219)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5221
       createSnapshot
       (create-snapshot-request (clojure.core/nth args5220 0)))))))
  (clojure.core/defn
   create-snapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [volume-arn
                         snapshot-description
                         request-metric-collector]}]]),
    :doc "Generate map for createSnapshot"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :create-snapshot,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   create-snapshot
   {:arglists (quote
               [[credentials
                 {:keys [volume-arn
                         snapshot-description
                         request-metric-collector]}]]),
    :doc "Call createSnapshot"}
   [credentials5223 & args5224]
   (clojure.core/let
    [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5225
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5223)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5225
      createSnapshot
      (create-snapshot-request (clojure.core/nth args5224 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :delete-volume
   [m5226]
   (clojure.core/let
    [credentials5227 (:credentials m5226) args5228 (:args m5226)]
    (clojure.core/let
     [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5229
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5227)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5229
       deleteVolume
       (delete-volume-request (clojure.core/nth args5228 0)))))))
  (clojure.core/defn
   delete-volume-map
   {:arglists (quote
               [[credentials
                 {:keys [volume-arn request-metric-collector]}]]),
    :doc "Generate map for deleteVolume"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :delete-volume,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   delete-volume
   {:arglists (quote
               [[credentials
                 {:keys [volume-arn request-metric-collector]}]]),
    :doc "Call deleteVolume"}
   [credentials5231 & args5232]
   (clojure.core/let
    [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5233
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5231)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5233
      deleteVolume
      (delete-volume-request (clojure.core/nth args5232 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :update-snapshot-schedule
   [m5234]
   (clojure.core/let
    [credentials5235 (:credentials m5234) args5236 (:args m5234)]
    (clojure.core/let
     [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5237
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5235)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5237
       updateSnapshotSchedule
       (update-snapshot-schedule-request
        (clojure.core/nth args5236 0)))))))
  (clojure.core/defn
   update-snapshot-schedule-map
   {:arglists (quote
               [[credentials
                 {:keys [volume-arn
                         start-at
                         request-metric-collector
                         recurrence-in-hours
                         description]}]]),
    :doc "Generate map for updateSnapshotSchedule"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :update-snapshot-schedule,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   update-snapshot-schedule
   {:arglists (quote
               [[credentials
                 {:keys [volume-arn
                         start-at
                         request-metric-collector
                         recurrence-in-hours
                         description]}]]),
    :doc "Call updateSnapshotSchedule"}
   [credentials5239 & args5240]
   (clojure.core/let
    [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5241
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5239)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5241
      updateSnapshotSchedule
      (update-snapshot-schedule-request (clojure.core/nth args5240 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :describe-snapshot-schedule
   [m5242]
   (clojure.core/let
    [credentials5243 (:credentials m5242) args5244 (:args m5242)]
    (clojure.core/let
     [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5245
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5243)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5245
       describeSnapshotSchedule
       (describe-snapshot-schedule-request
        (clojure.core/nth args5244 0)))))))
  (clojure.core/defn
   describe-snapshot-schedule-map
   {:arglists (quote
               [[credentials
                 {:keys [volume-arn request-metric-collector]}]]),
    :doc "Generate map for describeSnapshotSchedule"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :describe-snapshot-schedule,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   describe-snapshot-schedule
   {:arglists (quote
               [[credentials
                 {:keys [volume-arn request-metric-collector]}]]),
    :doc "Call describeSnapshotSchedule"}
   [credentials5247 & args5248]
   (clojure.core/let
    [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5249
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5247)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5249
      describeSnapshotSchedule
      (describe-snapshot-schedule-request
       (clojure.core/nth args5248 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :list-gateways
   [m5250]
   (clojure.core/let
    [credentials5251 (:credentials m5250) args5252 (:args m5250)]
    (clojure.core/let
     [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5253
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5251)]
     (clojure.core/case
      (clojure.core/count args5252)
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5253
        listGateways))
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5253
        listGateways
        (list-gateways-request (clojure.core/nth args5252 0))))))))
  (clojure.core/defn
   list-gateways-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [request-metric-collector marker limit]}]]),
    :doc "Generate map for listGateways, listGateways"}
   ([credentials__1609__auto__]
    {:args [],
     :client :storagegateway,
     :fn :list-gateways,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :list-gateways,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   list-gateways
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [request-metric-collector marker limit]}]]),
    :doc "Call listGateways, listGateways"}
   [credentials5255 & args5256]
   (clojure.core/let
    [^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5257
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5255)]
    (clojure.core/case
     (clojure.core/count args5256)
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5257
       listGateways))
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.storagegateway.AWSStorageGatewayClient client5257
       listGateways
       (list-gateways-request (clojure.core/nth args5256 0)))))))))
