(ns com.palletops.awaze.sts (:require [com.palletops.awaze.common]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :sts
  [___1561__auto__
   ^com.amazonaws.auth.BasicAWSCredentials credentials__1562__auto__]
  (new
   com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient
   credentials__1562__auto__))
 (clojure.core/defn
  ^com.amazonaws.services.securitytoken.model.AssumeRoleRequest assume-role-request
  [m4196]
  (clojure.core/let
   [bean4195
    (new com.amazonaws.services.securitytoken.model.AssumeRoleRequest)]
   (clojure.core/when-let
    [v4197 (:duration-seconds m4196)]
    (. bean4195 setDurationSeconds (clojure.core/int v4197)))
   (clojure.core/when-let
    [v4197 (:role-arn m4196)]
    (. bean4195 setRoleArn (clojure.core/str v4197)))
   (clojure.core/when-let
    [v4197 (:role-session-name m4196)]
    (. bean4195 setRoleSessionName (clojure.core/str v4197)))
   (clojure.core/when-let
    [v4197 (:external-id m4196)]
    (. bean4195 setExternalId (clojure.core/str v4197)))
   (clojure.core/when-let
    [v4197 (:policy m4196)]
    (. bean4195 setPolicy (clojure.core/str v4197)))
   bean4195))
 (clojure.core/defn
  ^com.amazonaws.services.securitytoken.model.GetFederationTokenRequest get-federation-token-request
  [m4199]
  (clojure.core/let
   [bean4198
    (new
     com.amazonaws.services.securitytoken.model.GetFederationTokenRequest)]
   (clojure.core/when-let
    [v4200 (:name m4199)]
    (. bean4198 setName (clojure.core/str v4200)))
   (clojure.core/when-let
    [v4200 (:duration-seconds m4199)]
    (. bean4198 setDurationSeconds (clojure.core/int v4200)))
   (clojure.core/when-let
    [v4200 (:policy m4199)]
    (. bean4198 setPolicy (clojure.core/str v4200)))
   bean4198))
 (clojure.core/defn
  ^com.amazonaws.services.securitytoken.model.AssumeRoleWithWebIdentityRequest assume-role-with-web-identity-request
  [m4202]
  (clojure.core/let
   [bean4201
    (new
     com.amazonaws.services.securitytoken.model.AssumeRoleWithWebIdentityRequest)]
   (clojure.core/when-let
    [v4203 (:duration-seconds m4202)]
    (. bean4201 setDurationSeconds (clojure.core/int v4203)))
   (clojure.core/when-let
    [v4203 (:role-arn m4202)]
    (. bean4201 setRoleArn (clojure.core/str v4203)))
   (clojure.core/when-let
    [v4203 (:role-session-name m4202)]
    (. bean4201 setRoleSessionName (clojure.core/str v4203)))
   (clojure.core/when-let
    [v4203 (:web-identity-token m4202)]
    (. bean4201 setWebIdentityToken (clojure.core/str v4203)))
   (clojure.core/when-let
    [v4203 (:provider-id m4202)]
    (. bean4201 setProviderId (clojure.core/str v4203)))
   (clojure.core/when-let
    [v4203 (:policy m4202)]
    (. bean4201 setPolicy (clojure.core/str v4203)))
   bean4201))
 (clojure.core/defn
  ^com.amazonaws.services.securitytoken.model.DecodeAuthorizationMessageRequest decode-authorization-message-request
  [m4205]
  (clojure.core/let
   [bean4204
    (new
     com.amazonaws.services.securitytoken.model.DecodeAuthorizationMessageRequest)]
   (clojure.core/when-let
    [v4206 (:encoded-message m4205)]
    (. bean4204 setEncodedMessage (clojure.core/str v4206)))
   bean4204))
 (clojure.core/defn
  ^com.amazonaws.services.securitytoken.model.GetSessionTokenRequest get-session-token-request
  [m4208]
  (clojure.core/let
   [bean4207
    (new
     com.amazonaws.services.securitytoken.model.GetSessionTokenRequest)]
   (clojure.core/when-let
    [v4209 (:duration-seconds m4208)]
    (. bean4207 setDurationSeconds (clojure.core/int v4209)))
   (clojure.core/when-let
    [v4209 (:serial-number m4208)]
    (. bean4207 setSerialNumber (clojure.core/str v4209)))
   (clojure.core/when-let
    [v4209 (:token-code m4208)]
    (. bean4207 setTokenCode (clojure.core/str v4209)))
   bean4207))
 (clojure.core/defmulti
  sts
  (clojure.core/fn sts [m__1641__auto__] (:fn m__1641__auto__)))
 (do
  (clojure.core/defmethod
   sts
   :assume-role
   [m4210]
   (clojure.core/let
    [credentials4211 (:credentials m4210) args4212 (:args m4210)]
    (clojure.core/let
     [^com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient client4213
      (com.palletops.awaze.common/aws-client :sts credentials4211)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient client4213
       assumeRole
       (assume-role-request (clojure.core/nth args4212 0)))))))
  (clojure.core/defn
   assume-role-map
   {:arglists (quote
               [[credentials
                 {:keys [role-session-name
                         role-arn
                         request-metric-collector
                         policy
                         external-id
                         duration-seconds]}]]),
    :doc "Generate map for assumeRole"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :sts,
     :fn :assume-role,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   assume-role
   {:arglists (quote
               [[credentials
                 {:keys [role-session-name
                         role-arn
                         request-metric-collector
                         policy
                         external-id
                         duration-seconds]}]]),
    :doc "Call assumeRole"}
   [credentials4215 & args4216]
   (clojure.core/let
    [^com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient client4217
     (com.palletops.awaze.common/aws-client :sts credentials4215)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient client4217
      assumeRole
      (assume-role-request (clojure.core/nth args4216 0)))))))
 (do
  (clojure.core/defmethod
   sts
   :get-federation-token
   [m4218]
   (clojure.core/let
    [credentials4219 (:credentials m4218) args4220 (:args m4218)]
    (clojure.core/let
     [^com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient client4221
      (com.palletops.awaze.common/aws-client :sts credentials4219)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient client4221
       getFederationToken
       (get-federation-token-request (clojure.core/nth args4220 0)))))))
  (clojure.core/defn
   get-federation-token-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         policy
                         name
                         duration-seconds]}]]),
    :doc "Generate map for getFederationToken"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :sts,
     :fn :get-federation-token,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   get-federation-token
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector
                         policy
                         name
                         duration-seconds]}]]),
    :doc "Call getFederationToken"}
   [credentials4223 & args4224]
   (clojure.core/let
    [^com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient client4225
     (com.palletops.awaze.common/aws-client :sts credentials4223)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient client4225
      getFederationToken
      (get-federation-token-request (clojure.core/nth args4224 0)))))))
 (do
  (clojure.core/defmethod
   sts
   :assume-role-with-web-identity
   [m4226]
   (clojure.core/let
    [credentials4227 (:credentials m4226) args4228 (:args m4226)]
    (clojure.core/let
     [^com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient client4229
      (com.palletops.awaze.common/aws-client :sts credentials4227)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient client4229
       assumeRoleWithWebIdentity
       (assume-role-with-web-identity-request
        (clojure.core/nth args4228 0)))))))
  (clojure.core/defn
   assume-role-with-web-identity-map
   {:arglists (quote
               [[credentials
                 {:keys [duration-seconds
                         role-arn
                         role-session-name
                         provider-id
                         policy
                         web-identity-token
                         request-metric-collector]}]]),
    :doc "Generate map for assumeRoleWithWebIdentity"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :sts,
     :fn :assume-role-with-web-identity,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   assume-role-with-web-identity
   {:arglists (quote
               [[credentials
                 {:keys [duration-seconds
                         role-arn
                         role-session-name
                         provider-id
                         policy
                         web-identity-token
                         request-metric-collector]}]]),
    :doc "Call assumeRoleWithWebIdentity"}
   [credentials4231 & args4232]
   (clojure.core/let
    [^com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient client4233
     (com.palletops.awaze.common/aws-client :sts credentials4231)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient client4233
      assumeRoleWithWebIdentity
      (assume-role-with-web-identity-request
       (clojure.core/nth args4232 0)))))))
 (do
  (clojure.core/defmethod
   sts
   :decode-authorization-message
   [m4234]
   (clojure.core/let
    [credentials4235 (:credentials m4234) args4236 (:args m4234)]
    (clojure.core/let
     [^com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient client4237
      (com.palletops.awaze.common/aws-client :sts credentials4235)]
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient client4237
       decodeAuthorizationMessage
       (decode-authorization-message-request
        (clojure.core/nth args4236 0)))))))
  (clojure.core/defn
   decode-authorization-message-map
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector encoded-message]}]]),
    :doc "Generate map for decodeAuthorizationMessage"}
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :sts,
     :fn :decode-authorization-message,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   decode-authorization-message
   {:arglists (quote
               [[credentials
                 {:keys [request-metric-collector encoded-message]}]]),
    :doc "Call decodeAuthorizationMessage"}
   [credentials4239 & args4240]
   (clojure.core/let
    [^com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient client4241
     (com.palletops.awaze.common/aws-client :sts credentials4239)]
    (com.palletops.awaze.common/to-data
     (.
      ^com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient client4241
      decodeAuthorizationMessage
      (decode-authorization-message-request
       (clojure.core/nth args4240 0)))))))
 (do
  (clojure.core/defmethod
   sts
   :get-session-token
   [m4242]
   (clojure.core/let
    [credentials4243 (:credentials m4242) args4244 (:args m4242)]
    (clojure.core/let
     [^com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient client4245
      (com.palletops.awaze.common/aws-client :sts credentials4243)]
     (clojure.core/case
      (clojure.core/count args4244)
      1
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient client4245
        getSessionToken
        (get-session-token-request (clojure.core/nth args4244 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
        ^com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient client4245
        getSessionToken))))))
  (clojure.core/defn
   get-session-token-map
   {:arglists (quote
               [[credentials
                 {:keys [token-code
                         serial-number
                         request-metric-collector
                         duration-seconds]}]
                [credentials]]),
    :doc "Generate map for getSessionToken, getSessionToken"}
   ([credentials__1609__auto__]
    {:args [],
     :client :sts,
     :fn :get-session-token,
     :credentials credentials__1609__auto__})
   ([credentials__1609__auto__ a]
    {:args [a],
     :client :sts,
     :fn :get-session-token,
     :credentials credentials__1609__auto__}))
  (clojure.core/defn
   get-session-token
   {:arglists (quote
               [[credentials
                 {:keys [token-code
                         serial-number
                         request-metric-collector
                         duration-seconds]}]
                [credentials]]),
    :doc "Call getSessionToken, getSessionToken"}
   [credentials4247 & args4248]
   (clojure.core/let
    [^com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient client4249
     (com.palletops.awaze.common/aws-client :sts credentials4247)]
    (clojure.core/case
     (clojure.core/count args4248)
     1
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient client4249
       getSessionToken
       (get-session-token-request (clojure.core/nth args4248 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
       ^com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient client4249
       getSessionToken)))))))
