(ns
 com.palletops.awaze.cloudformation
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.cloudformation :as cloudformation]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :cloudformation
  [___1600__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1601__auto__]
  (new
   com.amazonaws.services.cloudformation.AmazonCloudFormationClient
   credentials__1601__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.Parameter}
parameter
  [m8740]
  (clojure.core/let
   [bean8739
    (new com.amazonaws.services.cloudformation.model.Parameter)]
   (clojure.core/when-let
    [v8741 (:parameter-value m8740)]
    (. bean8739 setParameterValue (clojure.core/str v8741)))
   (clojure.core/when-let
    [v8741 (:parameter-key m8740)]
    (. bean8739 setParameterKey (clojure.core/str v8741)))
   (clojure.core/when-let
    [v8741 (:use-previous-value m8740)]
    (. bean8739 setUsePreviousValue (clojure.core/boolean v8741)))
   bean8739))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.Tag}
tag
  [m8743]
  (clojure.core/let
   [bean8742 (new com.amazonaws.services.cloudformation.model.Tag)]
   (clojure.core/when-let
    [v8744 (:value m8743)]
    (. bean8742 setValue (clojure.core/str v8744)))
   (clojure.core/when-let
    [v8744 (:key m8743)]
    (. bean8742 setKey (clojure.core/str v8744)))
   bean8742))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.DescribeStackEventsRequest}
describe-stack-events-request
  [m8746]
  (clojure.core/let
   [bean8745
    (new
     com.amazonaws.services.cloudformation.model.DescribeStackEventsRequest)]
   (clojure.core/when-let
    [v8747 (:next-token m8746)]
    (. bean8745 setNextToken (clojure.core/str v8747)))
   (clojure.core/when-let
    [v8747 (:stack-name m8746)]
    (. bean8745 setStackName (clojure.core/str v8747)))
   bean8745))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.DescribeStacksRequest}
describe-stacks-request
  [m8749]
  (clojure.core/let
   [bean8748
    (new
     com.amazonaws.services.cloudformation.model.DescribeStacksRequest)]
   (clojure.core/when-let
    [v8750 (:next-token m8749)]
    (. bean8748 setNextToken (clojure.core/str v8750)))
   (clojure.core/when-let
    [v8750 (:stack-name m8749)]
    (. bean8748 setStackName (clojure.core/str v8750)))
   bean8748))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.GetStackPolicyRequest}
get-stack-policy-request
  [m8752]
  (clojure.core/let
   [bean8751
    (new
     com.amazonaws.services.cloudformation.model.GetStackPolicyRequest)]
   (clojure.core/when-let
    [v8753 (:stack-name m8752)]
    (. bean8751 setStackName (clojure.core/str v8753)))
   bean8751))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.GetTemplateRequest}
get-template-request
  [m8755]
  (clojure.core/let
   [bean8754
    (new
     com.amazonaws.services.cloudformation.model.GetTemplateRequest)]
   (clojure.core/when-let
    [v8756 (:stack-name m8755)]
    (. bean8754 setStackName (clojure.core/str v8756)))
   bean8754))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.ListStacksRequest}
list-stacks-request
  [m8758]
  (clojure.core/let
   [bean8757
    (new
     com.amazonaws.services.cloudformation.model.ListStacksRequest)]
   (clojure.core/when-let
    [v8759 (:next-token m8758)]
    (. bean8757 setNextToken (clojure.core/str v8759)))
   (clojure.core/when-let
    [v8759 (:stack-status-filters m8758)]
    (.
     bean8757
     setStackStatusFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8790] (clojure.core/str arg8790))
 v8759)))
   bean8757))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.DeleteStackRequest}
delete-stack-request
  [m8761]
  (clojure.core/let
   [bean8760
    (new
     com.amazonaws.services.cloudformation.model.DeleteStackRequest)]
   (clojure.core/when-let
    [v8762 (:stack-name m8761)]
    (. bean8760 setStackName (clojure.core/str v8762)))
   bean8760))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.EstimateTemplateCostRequest}
estimate-template-cost-request
  [m8764]
  (clojure.core/let
   [bean8763
    (new
     com.amazonaws.services.cloudformation.model.EstimateTemplateCostRequest)]
   (clojure.core/when-let
    [v8765 (:parameters m8764)]
    (.
     bean8763
     setParameters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8791] (cloudformation/parameter arg8791))
 v8765)))
   (clojure.core/when-let
    [v8765 (:template-body m8764)]
    (. bean8763 setTemplateBody (clojure.core/str v8765)))
   (clojure.core/when-let
    [v8765 (:template-url m8764)]
    (. bean8763 setTemplateURL (clojure.core/str v8765)))
   bean8763))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.ValidateTemplateRequest}
validate-template-request
  [m8767]
  (clojure.core/let
   [bean8766
    (new
     com.amazonaws.services.cloudformation.model.ValidateTemplateRequest)]
   (clojure.core/when-let
    [v8768 (:template-body m8767)]
    (. bean8766 setTemplateBody (clojure.core/str v8768)))
   (clojure.core/when-let
    [v8768 (:template-url m8767)]
    (. bean8766 setTemplateURL (clojure.core/str v8768)))
   bean8766))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.UpdateStackRequest}
update-stack-request
  [m8770]
  (clojure.core/let
   [bean8769
    (new
     com.amazonaws.services.cloudformation.model.UpdateStackRequest)]
   (clojure.core/when-let
    [v8771 (:notification-arns m8770)]
    (.
     bean8769
     setNotificationARNs
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8792] (clojure.core/str arg8792))
 v8771)))
   (clojure.core/when-let
    [v8771 (:stack-policy-during-update-body m8770)]
    (.
     bean8769
     setStackPolicyDuringUpdateBody
     (clojure.core/str v8771)))
   (clojure.core/when-let
    [v8771 (:parameters m8770)]
    (.
     bean8769
     setParameters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8793] (cloudformation/parameter arg8793))
 v8771)))
   (clojure.core/when-let
    [v8771 (:stack-policy-during-update-url m8770)]
    (.
     bean8769
     setStackPolicyDuringUpdateURL
     (clojure.core/str v8771)))
   (clojure.core/when-let
    [v8771 (:stack-name m8770)]
    (. bean8769 setStackName (clojure.core/str v8771)))
   (clojure.core/when-let
    [v8771 (:template-url m8770)]
    (. bean8769 setTemplateURL (clojure.core/str v8771)))
   (clojure.core/when-let
    [v8771 (:use-previous-template m8770)]
    (. bean8769 setUsePreviousTemplate (clojure.core/boolean v8771)))
   (clojure.core/when-let
    [v8771 (:stack-policy-url m8770)]
    (. bean8769 setStackPolicyURL (clojure.core/str v8771)))
   (clojure.core/when-let
    [v8771 (:capabilities m8770)]
    (.
     bean8769
     setCapabilities
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8794] (clojure.core/str arg8794))
 v8771)))
   (clojure.core/when-let
    [v8771 (:stack-policy-body m8770)]
    (. bean8769 setStackPolicyBody (clojure.core/str v8771)))
   (clojure.core/when-let
    [v8771 (:template-body m8770)]
    (. bean8769 setTemplateBody (clojure.core/str v8771)))
   bean8769))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.DescribeStackResourcesRequest}
describe-stack-resources-request
  [m8773]
  (clojure.core/let
   [bean8772
    (new
     com.amazonaws.services.cloudformation.model.DescribeStackResourcesRequest)]
   (clojure.core/when-let
    [v8774 (:stack-name m8773)]
    (. bean8772 setStackName (clojure.core/str v8774)))
   (clojure.core/when-let
    [v8774 (:logical-resource-id m8773)]
    (. bean8772 setLogicalResourceId (clojure.core/str v8774)))
   (clojure.core/when-let
    [v8774 (:physical-resource-id m8773)]
    (. bean8772 setPhysicalResourceId (clojure.core/str v8774)))
   bean8772))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.CancelUpdateStackRequest}
cancel-update-stack-request
  [m8776]
  (clojure.core/let
   [bean8775
    (new
     com.amazonaws.services.cloudformation.model.CancelUpdateStackRequest)]
   (clojure.core/when-let
    [v8777 (:stack-name m8776)]
    (. bean8775 setStackName (clojure.core/str v8777)))
   bean8775))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.CreateStackRequest}
create-stack-request
  [m8779]
  (clojure.core/let
   [bean8778
    (new
     com.amazonaws.services.cloudformation.model.CreateStackRequest)]
   (clojure.core/when-let
    [v8780 (:notification-arns m8779)]
    (.
     bean8778
     setNotificationARNs
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8795] (clojure.core/str arg8795))
 v8780)))
   (clojure.core/when-let
    [v8780 (:on-failure m8779)]
    (. bean8778 setOnFailure (clojure.core/str v8780)))
   (clojure.core/when-let
    [v8780 (:disable-rollback m8779)]
    (. bean8778 setDisableRollback (clojure.core/boolean v8780)))
   (clojure.core/when-let
    [v8780 (:parameters m8779)]
    (.
     bean8778
     setParameters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8796] (cloudformation/parameter arg8796))
 v8780)))
   (clojure.core/when-let
    [v8780 (:stack-name m8779)]
    (. bean8778 setStackName (clojure.core/str v8780)))
   (clojure.core/when-let
    [v8780 (:template-url m8779)]
    (. bean8778 setTemplateURL (clojure.core/str v8780)))
   (clojure.core/when-let
    [v8780 (:stack-policy-url m8779)]
    (. bean8778 setStackPolicyURL (clojure.core/str v8780)))
   (clojure.core/when-let
    [v8780 (:capabilities m8779)]
    (.
     bean8778
     setCapabilities
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8797] (clojure.core/str arg8797))
 v8780)))
   (clojure.core/when-let
    [v8780 (:stack-policy-body m8779)]
    (. bean8778 setStackPolicyBody (clojure.core/str v8780)))
   (clojure.core/when-let
    [v8780 (:timeout-in-minutes m8779)]
    (. bean8778 setTimeoutInMinutes (clojure.core/int v8780)))
   (clojure.core/when-let
    [v8780 (:tags m8779)]
    (.
     bean8778
     setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8798] (cloudformation/tag arg8798))
 v8780)))
   (clojure.core/when-let
    [v8780 (:template-body m8779)]
    (. bean8778 setTemplateBody (clojure.core/str v8780)))
   bean8778))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.SetStackPolicyRequest}
set-stack-policy-request
  [m8782]
  (clojure.core/let
   [bean8781
    (new
     com.amazonaws.services.cloudformation.model.SetStackPolicyRequest)]
   (clojure.core/when-let
    [v8783 (:stack-name m8782)]
    (. bean8781 setStackName (clojure.core/str v8783)))
   (clojure.core/when-let
    [v8783 (:stack-policy-body m8782)]
    (. bean8781 setStackPolicyBody (clojure.core/str v8783)))
   (clojure.core/when-let
    [v8783 (:stack-policy-url m8782)]
    (. bean8781 setStackPolicyURL (clojure.core/str v8783)))
   bean8781))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.DescribeStackResourceRequest}
describe-stack-resource-request
  [m8785]
  (clojure.core/let
   [bean8784
    (new
     com.amazonaws.services.cloudformation.model.DescribeStackResourceRequest)]
   (clojure.core/when-let
    [v8786 (:stack-name m8785)]
    (. bean8784 setStackName (clojure.core/str v8786)))
   (clojure.core/when-let
    [v8786 (:logical-resource-id m8785)]
    (. bean8784 setLogicalResourceId (clojure.core/str v8786)))
   bean8784))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.ListStackResourcesRequest}
list-stack-resources-request
  [m8788]
  (clojure.core/let
   [bean8787
    (new
     com.amazonaws.services.cloudformation.model.ListStackResourcesRequest)]
   (clojure.core/when-let
    [v8789 (:next-token m8788)]
    (. bean8787 setNextToken (clojure.core/str v8789)))
   (clojure.core/when-let
    [v8789 (:stack-name m8788)]
    (. bean8787 setStackName (clojure.core/str v8789)))
   bean8787))
 (clojure.core/defmulti
  cloudformation
  (clojure.core/fn
   cloudformation
   [m__1683__auto__]
   (:fn m__1683__auto__)))
 (do
  (clojure.core/defmethod
   cloudformation
   :describe-stack-events
   [m8799]
   (clojure.core/let
    [credentials8800 (:credentials m8799) args8801 (:args m8799)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client8802
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials8800)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client8802
       describeStackEvents
       (cloudformation/describe-stack-events-request
        (clojure.core/nth args8801 0)))))))
  (clojure.core/defn
   describe-stack-events-map
   {:arglists (quote
               [[credentials
                 {:keys [stack-name
                         next-token
                         general-progress-listener]}]]),
    :doc "Generate map for describeStackEvents"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :cloudformation,
     :fn :describe-stack-events,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-stack-events
   {:arglists (quote
               [[credentials
                 {:keys [stack-name
                         next-token
                         general-progress-listener]}]]),
    :doc "Call describeStackEvents"}
   [credentials8804 & args8805]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client8806
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials8804)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client8806
      describeStackEvents
      (cloudformation/describe-stack-events-request
       (clojure.core/nth args8805 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :describe-stacks
   [m8807]
   (clojure.core/let
    [credentials8808 (:credentials m8807) args8809 (:args m8807)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client8810
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials8808)]
     (clojure.core/case
      (clojure.core/count args8809)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client8810
        describeStacks))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client8810
        describeStacks
        (cloudformation/describe-stacks-request
         (clojure.core/nth args8809 0))))))))
  (clojure.core/defn
   describe-stacks-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [stack-name
                         next-token
                         general-progress-listener]}]]),
    :doc "Generate map for describeStacks, describeStacks"}
   ([credentials__1651__auto__]
    {:args [],
     :client :cloudformation,
     :fn :describe-stacks,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :cloudformation,
     :fn :describe-stacks,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-stacks
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [stack-name
                         next-token
                         general-progress-listener]}]]),
    :doc "Call describeStacks, describeStacks"}
   [credentials8812 & args8813]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client8814
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials8812)]
    (clojure.core/case
     (clojure.core/count args8813)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client8814
       describeStacks))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client8814
       describeStacks
       (cloudformation/describe-stacks-request
        (clojure.core/nth args8813 0))))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :get-stack-policy
   [m8815]
   (clojure.core/let
    [credentials8816 (:credentials m8815) args8817 (:args m8815)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client8818
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials8816)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client8818
       getStackPolicy
       (cloudformation/get-stack-policy-request
        (clojure.core/nth args8817 0)))))))
  (clojure.core/defn
   get-stack-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [stack-name general-progress-listener]}]]),
    :doc "Generate map for getStackPolicy"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :cloudformation,
     :fn :get-stack-policy,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   get-stack-policy
   {:arglists (quote
               [[credentials
                 {:keys [stack-name general-progress-listener]}]]),
    :doc "Call getStackPolicy"}
   [credentials8820 & args8821]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client8822
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials8820)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client8822
      getStackPolicy
      (cloudformation/get-stack-policy-request
       (clojure.core/nth args8821 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :get-template
   [m8823]
   (clojure.core/let
    [credentials8824 (:credentials m8823) args8825 (:args m8823)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client8826
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials8824)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client8826
       getTemplate
       (cloudformation/get-template-request
        (clojure.core/nth args8825 0)))))))
  (clojure.core/defn
   get-template-map
   {:arglists (quote
               [[credentials
                 {:keys [stack-name general-progress-listener]}]]),
    :doc "Generate map for getTemplate"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :cloudformation,
     :fn :get-template,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   get-template
   {:arglists (quote
               [[credentials
                 {:keys [stack-name general-progress-listener]}]]),
    :doc "Call getTemplate"}
   [credentials8828 & args8829]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client8830
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials8828)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client8830
      getTemplate
      (cloudformation/get-template-request
       (clojure.core/nth args8829 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :list-stacks
   [m8831]
   (clojure.core/let
    [credentials8832 (:credentials m8831) args8833 (:args m8831)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client8834
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials8832)]
     (clojure.core/case
      (clojure.core/count args8833)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client8834
        listStacks))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client8834
        listStacks
        (cloudformation/list-stacks-request
         (clojure.core/nth args8833 0))))))))
  (clojure.core/defn
   list-stacks-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [stack-status-filters
                         next-token
                         general-progress-listener]}]]),
    :doc "Generate map for listStacks, listStacks"}
   ([credentials__1651__auto__]
    {:args [],
     :client :cloudformation,
     :fn :list-stacks,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :cloudformation,
     :fn :list-stacks,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   list-stacks
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [stack-status-filters
                         next-token
                         general-progress-listener]}]]),
    :doc "Call listStacks, listStacks"}
   [credentials8836 & args8837]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client8838
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials8836)]
    (clojure.core/case
     (clojure.core/count args8837)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client8838
       listStacks))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client8838
       listStacks
       (cloudformation/list-stacks-request
        (clojure.core/nth args8837 0))))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :delete-stack
   [m8839]
   (clojure.core/let
    [credentials8840 (:credentials m8839) args8841 (:args m8839)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client8842
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials8840)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client8842
       deleteStack
       (cloudformation/delete-stack-request
        (clojure.core/nth args8841 0)))))))
  (clojure.core/defn
   delete-stack-map
   {:arglists (quote
               [[credentials
                 {:keys [stack-name general-progress-listener]}]]),
    :doc "Generate map for deleteStack"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :cloudformation,
     :fn :delete-stack,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-stack
   {:arglists (quote
               [[credentials
                 {:keys [stack-name general-progress-listener]}]]),
    :doc "Call deleteStack"}
   [credentials8844 & args8845]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client8846
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials8844)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client8846
      deleteStack
      (cloudformation/delete-stack-request
       (clojure.core/nth args8845 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :estimate-template-cost
   [m8847]
   (clojure.core/let
    [credentials8848 (:credentials m8847) args8849 (:args m8847)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client8850
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials8848)]
     (clojure.core/case
      (clojure.core/count args8849)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client8850
        estimateTemplateCost
        (cloudformation/estimate-template-cost-request
         (clojure.core/nth args8849 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client8850
        estimateTemplateCost))))))
  (clojure.core/defn
   estimate-template-cost-map
   {:arglists (quote
               [[credentials
                 {:keys [template-url
                         template-body
                         parameters
                         general-progress-listener]}]
                [credentials]]),
    :doc "Generate map for estimateTemplateCost, estimateTemplateCost"}
   ([credentials__1651__auto__]
    {:args [],
     :client :cloudformation,
     :fn :estimate-template-cost,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :cloudformation,
     :fn :estimate-template-cost,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   estimate-template-cost
   {:arglists (quote
               [[credentials
                 {:keys [template-url
                         template-body
                         parameters
                         general-progress-listener]}]
                [credentials]]),
    :doc "Call estimateTemplateCost, estimateTemplateCost"}
   [credentials8852 & args8853]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client8854
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials8852)]
    (clojure.core/case
     (clojure.core/count args8853)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client8854
       estimateTemplateCost
       (cloudformation/estimate-template-cost-request
        (clojure.core/nth args8853 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client8854
       estimateTemplateCost))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :validate-template
   [m8855]
   (clojure.core/let
    [credentials8856 (:credentials m8855) args8857 (:args m8855)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client8858
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials8856)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client8858
       validateTemplate
       (cloudformation/validate-template-request
        (clojure.core/nth args8857 0)))))))
  (clojure.core/defn
   validate-template-map
   {:arglists (quote
               [[credentials
                 {:keys [template-url
                         template-body
                         general-progress-listener]}]]),
    :doc "Generate map for validateTemplate"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :cloudformation,
     :fn :validate-template,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   validate-template
   {:arglists (quote
               [[credentials
                 {:keys [template-url
                         template-body
                         general-progress-listener]}]]),
    :doc "Call validateTemplate"}
   [credentials8860 & args8861]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client8862
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials8860)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client8862
      validateTemplate
      (cloudformation/validate-template-request
       (clojure.core/nth args8861 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :update-stack
   [m8863]
   (clojure.core/let
    [credentials8864 (:credentials m8863) args8865 (:args m8863)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client8866
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials8864)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client8866
       updateStack
       (cloudformation/update-stack-request
        (clojure.core/nth args8865 0)))))))
  (clojure.core/defn
   update-stack-map
   {:arglists (quote
               [[credentials
                 {:keys [stack-policy-body
                         stack-policy-during-update-url
                         template-body
                         general-progress-listener
                         stack-policy-during-update-body
                         capabilities
                         stack-name
                         notification-arns
                         parameters
                         template-url
                         stack-policy-url
                         use-previous-template]}]]),
    :doc "Generate map for updateStack"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :cloudformation,
     :fn :update-stack,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   update-stack
   {:arglists (quote
               [[credentials
                 {:keys [stack-policy-body
                         stack-policy-during-update-url
                         template-body
                         general-progress-listener
                         stack-policy-during-update-body
                         capabilities
                         stack-name
                         notification-arns
                         parameters
                         template-url
                         stack-policy-url
                         use-previous-template]}]]),
    :doc "Call updateStack"}
   [credentials8868 & args8869]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client8870
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials8868)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client8870
      updateStack
      (cloudformation/update-stack-request
       (clojure.core/nth args8869 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :describe-stack-resources
   [m8871]
   (clojure.core/let
    [credentials8872 (:credentials m8871) args8873 (:args m8871)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client8874
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials8872)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client8874
       describeStackResources
       (cloudformation/describe-stack-resources-request
        (clojure.core/nth args8873 0)))))))
  (clojure.core/defn
   describe-stack-resources-map
   {:arglists (quote
               [[credentials
                 {:keys [stack-name
                         physical-resource-id
                         logical-resource-id
                         general-progress-listener]}]]),
    :doc "Generate map for describeStackResources"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :cloudformation,
     :fn :describe-stack-resources,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-stack-resources
   {:arglists (quote
               [[credentials
                 {:keys [stack-name
                         physical-resource-id
                         logical-resource-id
                         general-progress-listener]}]]),
    :doc "Call describeStackResources"}
   [credentials8876 & args8877]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client8878
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials8876)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client8878
      describeStackResources
      (cloudformation/describe-stack-resources-request
       (clojure.core/nth args8877 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :cancel-update-stack
   [m8879]
   (clojure.core/let
    [credentials8880 (:credentials m8879) args8881 (:args m8879)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client8882
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials8880)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client8882
       cancelUpdateStack
       (cloudformation/cancel-update-stack-request
        (clojure.core/nth args8881 0)))))))
  (clojure.core/defn
   cancel-update-stack-map
   {:arglists (quote
               [[credentials
                 {:keys [stack-name general-progress-listener]}]]),
    :doc "Generate map for cancelUpdateStack"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :cloudformation,
     :fn :cancel-update-stack,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   cancel-update-stack
   {:arglists (quote
               [[credentials
                 {:keys [stack-name general-progress-listener]}]]),
    :doc "Call cancelUpdateStack"}
   [credentials8884 & args8885]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client8886
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials8884)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client8886
      cancelUpdateStack
      (cloudformation/cancel-update-stack-request
       (clojure.core/nth args8885 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :create-stack
   [m8887]
   (clojure.core/let
    [credentials8888 (:credentials m8887) args8889 (:args m8887)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client8890
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials8888)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client8890
       createStack
       (cloudformation/create-stack-request
        (clojure.core/nth args8889 0)))))))
  (clojure.core/defn
   create-stack-map
   {:arglists (quote
               [[credentials
                 {:keys [stack-policy-body
                         disable-rollback
                         template-body
                         general-progress-listener
                         capabilities
                         stack-name
                         notification-arns
                         parameters
                         template-url
                         on-failure
                         stack-policy-url
                         timeout-in-minutes
                         tags]}]]),
    :doc "Generate map for createStack"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :cloudformation,
     :fn :create-stack,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-stack
   {:arglists (quote
               [[credentials
                 {:keys [stack-policy-body
                         disable-rollback
                         template-body
                         general-progress-listener
                         capabilities
                         stack-name
                         notification-arns
                         parameters
                         template-url
                         on-failure
                         stack-policy-url
                         timeout-in-minutes
                         tags]}]]),
    :doc "Call createStack"}
   [credentials8892 & args8893]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client8894
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials8892)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client8894
      createStack
      (cloudformation/create-stack-request
       (clojure.core/nth args8893 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :set-stack-policy
   [m8895]
   (clojure.core/let
    [credentials8896 (:credentials m8895) args8897 (:args m8895)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client8898
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials8896)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client8898
       setStackPolicy
       (cloudformation/set-stack-policy-request
        (clojure.core/nth args8897 0)))))))
  (clojure.core/defn
   set-stack-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [stack-policy-url
                         stack-policy-body
                         stack-name
                         general-progress-listener]}]]),
    :doc "Generate map for setStackPolicy"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :cloudformation,
     :fn :set-stack-policy,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   set-stack-policy
   {:arglists (quote
               [[credentials
                 {:keys [stack-policy-url
                         stack-policy-body
                         stack-name
                         general-progress-listener]}]]),
    :doc "Call setStackPolicy"}
   [credentials8900 & args8901]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client8902
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials8900)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client8902
      setStackPolicy
      (cloudformation/set-stack-policy-request
       (clojure.core/nth args8901 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :describe-stack-resource
   [m8903]
   (clojure.core/let
    [credentials8904 (:credentials m8903) args8905 (:args m8903)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client8906
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials8904)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client8906
       describeStackResource
       (cloudformation/describe-stack-resource-request
        (clojure.core/nth args8905 0)))))))
  (clojure.core/defn
   describe-stack-resource-map
   {:arglists (quote
               [[credentials
                 {:keys [stack-name
                         logical-resource-id
                         general-progress-listener]}]]),
    :doc "Generate map for describeStackResource"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :cloudformation,
     :fn :describe-stack-resource,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-stack-resource
   {:arglists (quote
               [[credentials
                 {:keys [stack-name
                         logical-resource-id
                         general-progress-listener]}]]),
    :doc "Call describeStackResource"}
   [credentials8908 & args8909]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client8910
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials8908)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client8910
      describeStackResource
      (cloudformation/describe-stack-resource-request
       (clojure.core/nth args8909 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :list-stack-resources
   [m8911]
   (clojure.core/let
    [credentials8912 (:credentials m8911) args8913 (:args m8911)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client8914
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials8912)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client8914
       listStackResources
       (cloudformation/list-stack-resources-request
        (clojure.core/nth args8913 0)))))))
  (clojure.core/defn
   list-stack-resources-map
   {:arglists (quote
               [[credentials
                 {:keys [stack-name
                         next-token
                         general-progress-listener]}]]),
    :doc "Generate map for listStackResources"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :cloudformation,
     :fn :list-stack-resources,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   list-stack-resources
   {:arglists (quote
               [[credentials
                 {:keys [stack-name
                         next-token
                         general-progress-listener]}]]),
    :doc "Call listStackResources"}
   [credentials8916 & args8917]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client8918
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials8916)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client8918
      listStackResources
      (cloudformation/list-stack-resources-request
       (clojure.core/nth args8917 0))))))))
