(ns
 com.palletops.awaze.cloudsearch
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.cloudsearch :as cloudsearch]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :cloudsearch
  [___1600__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1601__auto__]
  (new
   com.amazonaws.services.cloudsearch.AmazonCloudSearchClient
   credentials__1601__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.SourceData}
source-data
  [m8920]
  (clojure.core/let
   [bean8919
    (new com.amazonaws.services.cloudsearch.model.SourceData)]
   (clojure.core/when-let
    [v8921 (:default-value m8920)]
    (. bean8919 setDefaultValue (clojure.core/str v8921)))
   (clojure.core/when-let
    [v8921 (:source-name m8920)]
    (. bean8919 setSourceName (clojure.core/str v8921)))
   bean8919))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.SourceDataTrimTitle}
source-data-trim-title
  [m8923]
  (clojure.core/let
   [bean8922
    (new com.amazonaws.services.cloudsearch.model.SourceDataTrimTitle)]
   (clojure.core/when-let
    [v8924 (:default-value m8923)]
    (. bean8922 setDefaultValue (clojure.core/str v8924)))
   (clojure.core/when-let
    [v8924 (:source-name m8923)]
    (. bean8922 setSourceName (clojure.core/str v8924)))
   (clojure.core/when-let
    [v8924 (:separator m8923)]
    (. bean8922 setSeparator (clojure.core/str v8924)))
   (clojure.core/when-let
    [v8924 (:language m8923)]
    (. bean8922 setLanguage (clojure.core/str v8924)))
   bean8922))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.SourceDataMap}
source-data-map
  [m8926]
  (clojure.core/let
   [bean8925
    (new com.amazonaws.services.cloudsearch.model.SourceDataMap)]
   (clojure.core/when-let
    [v8927 (:default-value m8926)]
    (. bean8925 setDefaultValue (clojure.core/str v8927)))
   (clojure.core/when-let
    [v8927 (:source-name m8926)]
    (. bean8925 setSourceName (clojure.core/str v8927)))
   (clojure.core/when-let
    [v8927 (:cases m8926)]
    (.
     bean8925
     setCases
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg9012] (clojure.core/str arg9012))
  (clojure.core/keys v8927))
 (clojure.core/map
  (clojure.core/fn [arg9012] (clojure.core/str arg9012))
  (clojure.core/vals v8927)))))
   bean8925))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.UIntOptions}
uint-options
  [m8929]
  (clojure.core/let
   [bean8928
    (new com.amazonaws.services.cloudsearch.model.UIntOptions)]
   (clojure.core/when-let
    [v8930 (:default-value m8929)]
    (. bean8928 setDefaultValue (clojure.core/int v8930)))
   bean8928))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.LiteralOptions}
literal-options
  [m8932]
  (clojure.core/let
   [bean8931
    (new com.amazonaws.services.cloudsearch.model.LiteralOptions)]
   (clojure.core/when-let
    [v8933 (:default-value m8932)]
    (. bean8931 setDefaultValue (clojure.core/str v8933)))
   (clojure.core/when-let
    [v8933 (:search-enabled m8932)]
    (. bean8931 setSearchEnabled (clojure.core/boolean v8933)))
   (clojure.core/when-let
    [v8933 (:facet-enabled m8932)]
    (. bean8931 setFacetEnabled (clojure.core/boolean v8933)))
   (clojure.core/when-let
    [v8933 (:result-enabled m8932)]
    (. bean8931 setResultEnabled (clojure.core/boolean v8933)))
   bean8931))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.TextOptions}
text-options
  [m8935]
  (clojure.core/let
   [bean8934
    (new com.amazonaws.services.cloudsearch.model.TextOptions)]
   (clojure.core/when-let
    [v8936 (:default-value m8935)]
    (. bean8934 setDefaultValue (clojure.core/str v8936)))
   (clojure.core/when-let
    [v8936 (:facet-enabled m8935)]
    (. bean8934 setFacetEnabled (clojure.core/boolean v8936)))
   (clojure.core/when-let
    [v8936 (:result-enabled m8935)]
    (. bean8934 setResultEnabled (clojure.core/boolean v8936)))
   (clojure.core/when-let
    [v8936 (:text-processor m8935)]
    (. bean8934 setTextProcessor (clojure.core/str v8936)))
   bean8934))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.SourceAttribute}
source-attribute
  [m8938]
  (clojure.core/let
   [bean8937
    (new com.amazonaws.services.cloudsearch.model.SourceAttribute)]
   (clojure.core/when-let
    [v8939 (:source-data-function m8938)]
    (. bean8937 setSourceDataFunction (clojure.core/str v8939)))
   (clojure.core/when-let
    [v8939 (:source-data-copy m8938)]
    (. bean8937 setSourceDataCopy (cloudsearch/source-data v8939)))
   (clojure.core/when-let
    [v8939 (:source-data-trim-title m8938)]
    (.
     bean8937
     setSourceDataTrimTitle
     (cloudsearch/source-data-trim-title v8939)))
   (clojure.core/when-let
    [v8939 (:source-data-map m8938)]
    (. bean8937 setSourceDataMap (cloudsearch/source-data-map v8939)))
   bean8937))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.IndexField}
index-field
  [m8941]
  (clojure.core/let
   [bean8940
    (new com.amazonaws.services.cloudsearch.model.IndexField)]
   (clojure.core/when-let
    [v8942 (:index-field-name m8941)]
    (. bean8940 setIndexFieldName (clojure.core/str v8942)))
   (clojure.core/when-let
    [v8942 (:index-field-type m8941)]
    (. bean8940 setIndexFieldType (clojure.core/str v8942)))
   (clojure.core/when-let
    [v8942 (:uint-options m8941)]
    (. bean8940 setUIntOptions (cloudsearch/uint-options v8942)))
   (clojure.core/when-let
    [v8942 (:literal-options m8941)]
    (. bean8940 setLiteralOptions (cloudsearch/literal-options v8942)))
   (clojure.core/when-let
    [v8942 (:text-options m8941)]
    (. bean8940 setTextOptions (cloudsearch/text-options v8942)))
   (clojure.core/when-let
    [v8942 (:source-attributes m8941)]
    (.
     bean8940
     setSourceAttributes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9013] (cloudsearch/source-attribute arg9013))
 v8942)))
   bean8940))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.NamedRankExpression}
named-rank-expression
  [m8944]
  (clojure.core/let
   [bean8943
    (new com.amazonaws.services.cloudsearch.model.NamedRankExpression)]
   (clojure.core/when-let
    [v8945 (:rank-name m8944)]
    (. bean8943 setRankName (clojure.core/str v8945)))
   (clojure.core/when-let
    [v8945 (:rank-expression m8944)]
    (. bean8943 setRankExpression (clojure.core/str v8945)))
   bean8943))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.UpdateDefaultSearchFieldRequest}
update-default-search-field-request
  [m8947]
  (clojure.core/let
   [bean8946
    (new
     com.amazonaws.services.cloudsearch.model.UpdateDefaultSearchFieldRequest)]
   (clojure.core/when-let
    [v8948 (:domain-name m8947)]
    (. bean8946 setDomainName (clojure.core/str v8948)))
   (clojure.core/when-let
    [v8948 (:default-search-field m8947)]
    (. bean8946 setDefaultSearchField (clojure.core/str v8948)))
   bean8946))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.DescribeServiceAccessPoliciesRequest}
describe-service-access-policies-request
  [m8950]
  (clojure.core/let
   [bean8949
    (new
     com.amazonaws.services.cloudsearch.model.DescribeServiceAccessPoliciesRequest)]
   (clojure.core/when-let
    [v8951 (:domain-name m8950)]
    (. bean8949 setDomainName (clojure.core/str v8951)))
   bean8949))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.DescribeDomainsRequest}
describe-domains-request
  [m8953]
  (clojure.core/let
   [bean8952
    (new
     com.amazonaws.services.cloudsearch.model.DescribeDomainsRequest)]
   (clojure.core/when-let
    [v8954 (:domain-names m8953)]
    (.
     bean8952
     setDomainNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9014] (clojure.core/str arg9014))
 v8954)))
   bean8952))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.DefineIndexFieldRequest}
define-index-field-request
  [m8956]
  (clojure.core/let
   [bean8955
    (new
     com.amazonaws.services.cloudsearch.model.DefineIndexFieldRequest)]
   (clojure.core/when-let
    [v8957 (:domain-name m8956)]
    (. bean8955 setDomainName (clojure.core/str v8957)))
   (clojure.core/when-let
    [v8957 (:index-field m8956)]
    (. bean8955 setIndexField (cloudsearch/index-field v8957)))
   bean8955))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.DefineRankExpressionRequest}
define-rank-expression-request
  [m8959]
  (clojure.core/let
   [bean8958
    (new
     com.amazonaws.services.cloudsearch.model.DefineRankExpressionRequest)]
   (clojure.core/when-let
    [v8960 (:domain-name m8959)]
    (. bean8958 setDomainName (clojure.core/str v8960)))
   (clojure.core/when-let
    [v8960 (:rank-expression m8959)]
    (.
     bean8958
     setRankExpression
     (cloudsearch/named-rank-expression v8960)))
   bean8958))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.UpdateStopwordOptionsRequest}
update-stopword-options-request
  [m8962]
  (clojure.core/let
   [bean8961
    (new
     com.amazonaws.services.cloudsearch.model.UpdateStopwordOptionsRequest)]
   (clojure.core/when-let
    [v8963 (:domain-name m8962)]
    (. bean8961 setDomainName (clojure.core/str v8963)))
   (clojure.core/when-let
    [v8963 (:stopwords m8962)]
    (. bean8961 setStopwords (clojure.core/str v8963)))
   bean8961))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.DeleteRankExpressionRequest}
delete-rank-expression-request
  [m8965]
  (clojure.core/let
   [bean8964
    (new
     com.amazonaws.services.cloudsearch.model.DeleteRankExpressionRequest)]
   (clojure.core/when-let
    [v8966 (:domain-name m8965)]
    (. bean8964 setDomainName (clojure.core/str v8966)))
   (clojure.core/when-let
    [v8966 (:rank-name m8965)]
    (. bean8964 setRankName (clojure.core/str v8966)))
   bean8964))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.DescribeDefaultSearchFieldRequest}
describe-default-search-field-request
  [m8968]
  (clojure.core/let
   [bean8967
    (new
     com.amazonaws.services.cloudsearch.model.DescribeDefaultSearchFieldRequest)]
   (clojure.core/when-let
    [v8969 (:domain-name m8968)]
    (. bean8967 setDomainName (clojure.core/str v8969)))
   bean8967))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.CreateDomainRequest}
create-domain-request
  [m8971]
  (clojure.core/let
   [bean8970
    (new com.amazonaws.services.cloudsearch.model.CreateDomainRequest)]
   (clojure.core/when-let
    [v8972 (:domain-name m8971)]
    (. bean8970 setDomainName (clojure.core/str v8972)))
   bean8970))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.DescribeStemmingOptionsRequest}
describe-stemming-options-request
  [m8974]
  (clojure.core/let
   [bean8973
    (new
     com.amazonaws.services.cloudsearch.model.DescribeStemmingOptionsRequest)]
   (clojure.core/when-let
    [v8975 (:domain-name m8974)]
    (. bean8973 setDomainName (clojure.core/str v8975)))
   bean8973))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.UpdateAvailabilityOptionsRequest}
update-availability-options-request
  [m8977]
  (clojure.core/let
   [bean8976
    (new
     com.amazonaws.services.cloudsearch.model.UpdateAvailabilityOptionsRequest)]
   (clojure.core/when-let
    [v8978 (:domain-name m8977)]
    (. bean8976 setDomainName (clojure.core/str v8978)))
   (clojure.core/when-let
    [v8978 (:multi-az m8977)]
    (. bean8976 setMultiAZ (clojure.core/boolean v8978)))
   bean8976))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.DescribeIndexFieldsRequest}
describe-index-fields-request
  [m8980]
  (clojure.core/let
   [bean8979
    (new
     com.amazonaws.services.cloudsearch.model.DescribeIndexFieldsRequest)]
   (clojure.core/when-let
    [v8981 (:domain-name m8980)]
    (. bean8979 setDomainName (clojure.core/str v8981)))
   (clojure.core/when-let
    [v8981 (:field-names m8980)]
    (.
     bean8979
     setFieldNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9015] (clojure.core/str arg9015))
 v8981)))
   bean8979))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.DescribeAvailabilityOptionsRequest}
describe-availability-options-request
  [m8983]
  (clojure.core/let
   [bean8982
    (new
     com.amazonaws.services.cloudsearch.model.DescribeAvailabilityOptionsRequest)]
   (clojure.core/when-let
    [v8984 (:domain-name m8983)]
    (. bean8982 setDomainName (clojure.core/str v8984)))
   bean8982))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.DeleteIndexFieldRequest}
delete-index-field-request
  [m8986]
  (clojure.core/let
   [bean8985
    (new
     com.amazonaws.services.cloudsearch.model.DeleteIndexFieldRequest)]
   (clojure.core/when-let
    [v8987 (:domain-name m8986)]
    (. bean8985 setDomainName (clojure.core/str v8987)))
   (clojure.core/when-let
    [v8987 (:index-field-name m8986)]
    (. bean8985 setIndexFieldName (clojure.core/str v8987)))
   bean8985))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.DescribeStopwordOptionsRequest}
describe-stopword-options-request
  [m8989]
  (clojure.core/let
   [bean8988
    (new
     com.amazonaws.services.cloudsearch.model.DescribeStopwordOptionsRequest)]
   (clojure.core/when-let
    [v8990 (:domain-name m8989)]
    (. bean8988 setDomainName (clojure.core/str v8990)))
   bean8988))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.DescribeSynonymOptionsRequest}
describe-synonym-options-request
  [m8992]
  (clojure.core/let
   [bean8991
    (new
     com.amazonaws.services.cloudsearch.model.DescribeSynonymOptionsRequest)]
   (clojure.core/when-let
    [v8993 (:domain-name m8992)]
    (. bean8991 setDomainName (clojure.core/str v8993)))
   bean8991))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.UpdateSynonymOptionsRequest}
update-synonym-options-request
  [m8995]
  (clojure.core/let
   [bean8994
    (new
     com.amazonaws.services.cloudsearch.model.UpdateSynonymOptionsRequest)]
   (clojure.core/when-let
    [v8996 (:domain-name m8995)]
    (. bean8994 setDomainName (clojure.core/str v8996)))
   (clojure.core/when-let
    [v8996 (:synonyms m8995)]
    (. bean8994 setSynonyms (clojure.core/str v8996)))
   bean8994))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.DeleteDomainRequest}
delete-domain-request
  [m8998]
  (clojure.core/let
   [bean8997
    (new com.amazonaws.services.cloudsearch.model.DeleteDomainRequest)]
   (clojure.core/when-let
    [v8999 (:domain-name m8998)]
    (. bean8997 setDomainName (clojure.core/str v8999)))
   bean8997))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.DescribeRankExpressionsRequest}
describe-rank-expressions-request
  [m9001]
  (clojure.core/let
   [bean9000
    (new
     com.amazonaws.services.cloudsearch.model.DescribeRankExpressionsRequest)]
   (clojure.core/when-let
    [v9002 (:domain-name m9001)]
    (. bean9000 setDomainName (clojure.core/str v9002)))
   (clojure.core/when-let
    [v9002 (:rank-names m9001)]
    (.
     bean9000
     setRankNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9016] (clojure.core/str arg9016))
 v9002)))
   bean9000))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.IndexDocumentsRequest}
index-documents-request
  [m9004]
  (clojure.core/let
   [bean9003
    (new
     com.amazonaws.services.cloudsearch.model.IndexDocumentsRequest)]
   (clojure.core/when-let
    [v9005 (:domain-name m9004)]
    (. bean9003 setDomainName (clojure.core/str v9005)))
   bean9003))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.UpdateServiceAccessPoliciesRequest}
update-service-access-policies-request
  [m9007]
  (clojure.core/let
   [bean9006
    (new
     com.amazonaws.services.cloudsearch.model.UpdateServiceAccessPoliciesRequest)]
   (clojure.core/when-let
    [v9008 (:domain-name m9007)]
    (. bean9006 setDomainName (clojure.core/str v9008)))
   (clojure.core/when-let
    [v9008 (:access-policies m9007)]
    (. bean9006 setAccessPolicies (clojure.core/str v9008)))
   bean9006))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.UpdateStemmingOptionsRequest}
update-stemming-options-request
  [m9010]
  (clojure.core/let
   [bean9009
    (new
     com.amazonaws.services.cloudsearch.model.UpdateStemmingOptionsRequest)]
   (clojure.core/when-let
    [v9011 (:domain-name m9010)]
    (. bean9009 setDomainName (clojure.core/str v9011)))
   (clojure.core/when-let
    [v9011 (:stems m9010)]
    (. bean9009 setStems (clojure.core/str v9011)))
   bean9009))
 (clojure.core/defmulti
  cloudsearch
  (clojure.core/fn
   cloudsearch
   [m__1683__auto__]
   (:fn m__1683__auto__)))
 (do
  (clojure.core/defmethod
   cloudsearch
   :update-default-search-field
   [m9017]
   (clojure.core/let
    [credentials9018 (:credentials m9017) args9019 (:args m9017)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client9020
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials9018)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9020
       updateDefaultSearchField
       (cloudsearch/update-default-search-field-request
        (clojure.core/nth args9019 0)))))))
  (clojure.core/defn
   update-default-search-field-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         domain-name
                         default-search-field]}]]),
    :doc "Generate map for updateDefaultSearchField"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :cloudsearch,
     :fn :update-default-search-field,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   update-default-search-field
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         domain-name
                         default-search-field]}]]),
    :doc "Call updateDefaultSearchField"}
   [credentials9022 & args9023]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client9024
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials9022)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9024
      updateDefaultSearchField
      (cloudsearch/update-default-search-field-request
       (clojure.core/nth args9023 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :describe-service-access-policies
   [m9025]
   (clojure.core/let
    [credentials9026 (:credentials m9025) args9027 (:args m9025)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client9028
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials9026)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9028
       describeServiceAccessPolicies
       (cloudsearch/describe-service-access-policies-request
        (clojure.core/nth args9027 0)))))))
  (clojure.core/defn
   describe-service-access-policies-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener domain-name]}]]),
    :doc "Generate map for describeServiceAccessPolicies"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :cloudsearch,
     :fn :describe-service-access-policies,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-service-access-policies
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener domain-name]}]]),
    :doc "Call describeServiceAccessPolicies"}
   [credentials9030 & args9031]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client9032
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials9030)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9032
      describeServiceAccessPolicies
      (cloudsearch/describe-service-access-policies-request
       (clojure.core/nth args9031 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :describe-domains
   [m9033]
   (clojure.core/let
    [credentials9034 (:credentials m9033) args9035 (:args m9033)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client9036
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials9034)]
     (clojure.core/case
      (clojure.core/count args9035)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9036
        describeDomains
        (cloudsearch/describe-domains-request
         (clojure.core/nth args9035 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9036
        describeDomains))))))
  (clojure.core/defn
   describe-domains-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener domain-names]}]
                [credentials]]),
    :doc "Generate map for describeDomains, describeDomains"}
   ([credentials__1651__auto__]
    {:args [],
     :client :cloudsearch,
     :fn :describe-domains,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :cloudsearch,
     :fn :describe-domains,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-domains
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener domain-names]}]
                [credentials]]),
    :doc "Call describeDomains, describeDomains"}
   [credentials9038 & args9039]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client9040
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials9038)]
    (clojure.core/case
     (clojure.core/count args9039)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9040
       describeDomains
       (cloudsearch/describe-domains-request
        (clojure.core/nth args9039 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9040
       describeDomains))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :define-index-field
   [m9041]
   (clojure.core/let
    [credentials9042 (:credentials m9041) args9043 (:args m9041)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client9044
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials9042)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9044
       defineIndexField
       (cloudsearch/define-index-field-request
        (clojure.core/nth args9043 0)))))))
  (clojure.core/defn
   define-index-field-map
   {:arglists (quote
               [[credentials
                 {:keys [index-field
                         general-progress-listener
                         domain-name]}]]),
    :doc "Generate map for defineIndexField"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :cloudsearch,
     :fn :define-index-field,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   define-index-field
   {:arglists (quote
               [[credentials
                 {:keys [index-field
                         general-progress-listener
                         domain-name]}]]),
    :doc "Call defineIndexField"}
   [credentials9046 & args9047]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client9048
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials9046)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9048
      defineIndexField
      (cloudsearch/define-index-field-request
       (clojure.core/nth args9047 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :define-rank-expression
   [m9049]
   (clojure.core/let
    [credentials9050 (:credentials m9049) args9051 (:args m9049)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client9052
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials9050)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9052
       defineRankExpression
       (cloudsearch/define-rank-expression-request
        (clojure.core/nth args9051 0)))))))
  (clojure.core/defn
   define-rank-expression-map
   {:arglists (quote
               [[credentials
                 {:keys [rank-expression
                         general-progress-listener
                         domain-name]}]]),
    :doc "Generate map for defineRankExpression"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :cloudsearch,
     :fn :define-rank-expression,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   define-rank-expression
   {:arglists (quote
               [[credentials
                 {:keys [rank-expression
                         general-progress-listener
                         domain-name]}]]),
    :doc "Call defineRankExpression"}
   [credentials9054 & args9055]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client9056
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials9054)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9056
      defineRankExpression
      (cloudsearch/define-rank-expression-request
       (clojure.core/nth args9055 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :update-stopword-options
   [m9057]
   (clojure.core/let
    [credentials9058 (:credentials m9057) args9059 (:args m9057)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client9060
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials9058)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9060
       updateStopwordOptions
       (cloudsearch/update-stopword-options-request
        (clojure.core/nth args9059 0)))))))
  (clojure.core/defn
   update-stopword-options-map
   {:arglists (quote
               [[credentials
                 {:keys [stopwords
                         general-progress-listener
                         domain-name]}]]),
    :doc "Generate map for updateStopwordOptions"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :cloudsearch,
     :fn :update-stopword-options,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   update-stopword-options
   {:arglists (quote
               [[credentials
                 {:keys [stopwords
                         general-progress-listener
                         domain-name]}]]),
    :doc "Call updateStopwordOptions"}
   [credentials9062 & args9063]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client9064
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials9062)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9064
      updateStopwordOptions
      (cloudsearch/update-stopword-options-request
       (clojure.core/nth args9063 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :delete-rank-expression
   [m9065]
   (clojure.core/let
    [credentials9066 (:credentials m9065) args9067 (:args m9065)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client9068
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials9066)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9068
       deleteRankExpression
       (cloudsearch/delete-rank-expression-request
        (clojure.core/nth args9067 0)))))))
  (clojure.core/defn
   delete-rank-expression-map
   {:arglists (quote
               [[credentials
                 {:keys [rank-name
                         general-progress-listener
                         domain-name]}]]),
    :doc "Generate map for deleteRankExpression"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :cloudsearch,
     :fn :delete-rank-expression,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-rank-expression
   {:arglists (quote
               [[credentials
                 {:keys [rank-name
                         general-progress-listener
                         domain-name]}]]),
    :doc "Call deleteRankExpression"}
   [credentials9070 & args9071]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client9072
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials9070)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9072
      deleteRankExpression
      (cloudsearch/delete-rank-expression-request
       (clojure.core/nth args9071 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :describe-default-search-field
   [m9073]
   (clojure.core/let
    [credentials9074 (:credentials m9073) args9075 (:args m9073)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client9076
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials9074)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9076
       describeDefaultSearchField
       (cloudsearch/describe-default-search-field-request
        (clojure.core/nth args9075 0)))))))
  (clojure.core/defn
   describe-default-search-field-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener domain-name]}]]),
    :doc "Generate map for describeDefaultSearchField"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :cloudsearch,
     :fn :describe-default-search-field,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-default-search-field
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener domain-name]}]]),
    :doc "Call describeDefaultSearchField"}
   [credentials9078 & args9079]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client9080
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials9078)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9080
      describeDefaultSearchField
      (cloudsearch/describe-default-search-field-request
       (clojure.core/nth args9079 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :create-domain
   [m9081]
   (clojure.core/let
    [credentials9082 (:credentials m9081) args9083 (:args m9081)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client9084
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials9082)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9084
       createDomain
       (cloudsearch/create-domain-request
        (clojure.core/nth args9083 0)))))))
  (clojure.core/defn
   create-domain-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener domain-name]}]]),
    :doc "Generate map for createDomain"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :cloudsearch,
     :fn :create-domain,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-domain
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener domain-name]}]]),
    :doc "Call createDomain"}
   [credentials9086 & args9087]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client9088
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials9086)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9088
      createDomain
      (cloudsearch/create-domain-request
       (clojure.core/nth args9087 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :describe-stemming-options
   [m9089]
   (clojure.core/let
    [credentials9090 (:credentials m9089) args9091 (:args m9089)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client9092
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials9090)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9092
       describeStemmingOptions
       (cloudsearch/describe-stemming-options-request
        (clojure.core/nth args9091 0)))))))
  (clojure.core/defn
   describe-stemming-options-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener domain-name]}]]),
    :doc "Generate map for describeStemmingOptions"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :cloudsearch,
     :fn :describe-stemming-options,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-stemming-options
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener domain-name]}]]),
    :doc "Call describeStemmingOptions"}
   [credentials9094 & args9095]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client9096
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials9094)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9096
      describeStemmingOptions
      (cloudsearch/describe-stemming-options-request
       (clojure.core/nth args9095 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :update-availability-options
   [m9097]
   (clojure.core/let
    [credentials9098 (:credentials m9097) args9099 (:args m9097)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client9100
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials9098)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9100
       updateAvailabilityOptions
       (cloudsearch/update-availability-options-request
        (clojure.core/nth args9099 0)))))))
  (clojure.core/defn
   update-availability-options-map
   {:arglists (quote
               [[credentials
                 {:keys [multi-az
                         general-progress-listener
                         domain-name]}]]),
    :doc "Generate map for updateAvailabilityOptions"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :cloudsearch,
     :fn :update-availability-options,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   update-availability-options
   {:arglists (quote
               [[credentials
                 {:keys [multi-az
                         general-progress-listener
                         domain-name]}]]),
    :doc "Call updateAvailabilityOptions"}
   [credentials9102 & args9103]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client9104
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials9102)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9104
      updateAvailabilityOptions
      (cloudsearch/update-availability-options-request
       (clojure.core/nth args9103 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :describe-index-fields
   [m9105]
   (clojure.core/let
    [credentials9106 (:credentials m9105) args9107 (:args m9105)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client9108
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials9106)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9108
       describeIndexFields
       (cloudsearch/describe-index-fields-request
        (clojure.core/nth args9107 0)))))))
  (clojure.core/defn
   describe-index-fields-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         field-names
                         domain-name]}]]),
    :doc "Generate map for describeIndexFields"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :cloudsearch,
     :fn :describe-index-fields,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-index-fields
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         field-names
                         domain-name]}]]),
    :doc "Call describeIndexFields"}
   [credentials9110 & args9111]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client9112
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials9110)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9112
      describeIndexFields
      (cloudsearch/describe-index-fields-request
       (clojure.core/nth args9111 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :describe-availability-options
   [m9113]
   (clojure.core/let
    [credentials9114 (:credentials m9113) args9115 (:args m9113)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client9116
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials9114)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9116
       describeAvailabilityOptions
       (cloudsearch/describe-availability-options-request
        (clojure.core/nth args9115 0)))))))
  (clojure.core/defn
   describe-availability-options-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener domain-name]}]]),
    :doc "Generate map for describeAvailabilityOptions"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :cloudsearch,
     :fn :describe-availability-options,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-availability-options
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener domain-name]}]]),
    :doc "Call describeAvailabilityOptions"}
   [credentials9118 & args9119]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client9120
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials9118)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9120
      describeAvailabilityOptions
      (cloudsearch/describe-availability-options-request
       (clojure.core/nth args9119 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :delete-index-field
   [m9121]
   (clojure.core/let
    [credentials9122 (:credentials m9121) args9123 (:args m9121)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client9124
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials9122)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9124
       deleteIndexField
       (cloudsearch/delete-index-field-request
        (clojure.core/nth args9123 0)))))))
  (clojure.core/defn
   delete-index-field-map
   {:arglists (quote
               [[credentials
                 {:keys [index-field-name
                         general-progress-listener
                         domain-name]}]]),
    :doc "Generate map for deleteIndexField"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :cloudsearch,
     :fn :delete-index-field,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-index-field
   {:arglists (quote
               [[credentials
                 {:keys [index-field-name
                         general-progress-listener
                         domain-name]}]]),
    :doc "Call deleteIndexField"}
   [credentials9126 & args9127]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client9128
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials9126)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9128
      deleteIndexField
      (cloudsearch/delete-index-field-request
       (clojure.core/nth args9127 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :describe-stopword-options
   [m9129]
   (clojure.core/let
    [credentials9130 (:credentials m9129) args9131 (:args m9129)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client9132
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials9130)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9132
       describeStopwordOptions
       (cloudsearch/describe-stopword-options-request
        (clojure.core/nth args9131 0)))))))
  (clojure.core/defn
   describe-stopword-options-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener domain-name]}]]),
    :doc "Generate map for describeStopwordOptions"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :cloudsearch,
     :fn :describe-stopword-options,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-stopword-options
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener domain-name]}]]),
    :doc "Call describeStopwordOptions"}
   [credentials9134 & args9135]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client9136
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials9134)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9136
      describeStopwordOptions
      (cloudsearch/describe-stopword-options-request
       (clojure.core/nth args9135 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :describe-synonym-options
   [m9137]
   (clojure.core/let
    [credentials9138 (:credentials m9137) args9139 (:args m9137)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client9140
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials9138)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9140
       describeSynonymOptions
       (cloudsearch/describe-synonym-options-request
        (clojure.core/nth args9139 0)))))))
  (clojure.core/defn
   describe-synonym-options-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener domain-name]}]]),
    :doc "Generate map for describeSynonymOptions"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :cloudsearch,
     :fn :describe-synonym-options,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-synonym-options
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener domain-name]}]]),
    :doc "Call describeSynonymOptions"}
   [credentials9142 & args9143]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client9144
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials9142)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9144
      describeSynonymOptions
      (cloudsearch/describe-synonym-options-request
       (clojure.core/nth args9143 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :update-synonym-options
   [m9145]
   (clojure.core/let
    [credentials9146 (:credentials m9145) args9147 (:args m9145)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client9148
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials9146)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9148
       updateSynonymOptions
       (cloudsearch/update-synonym-options-request
        (clojure.core/nth args9147 0)))))))
  (clojure.core/defn
   update-synonym-options-map
   {:arglists (quote
               [[credentials
                 {:keys [synonyms
                         general-progress-listener
                         domain-name]}]]),
    :doc "Generate map for updateSynonymOptions"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :cloudsearch,
     :fn :update-synonym-options,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   update-synonym-options
   {:arglists (quote
               [[credentials
                 {:keys [synonyms
                         general-progress-listener
                         domain-name]}]]),
    :doc "Call updateSynonymOptions"}
   [credentials9150 & args9151]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client9152
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials9150)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9152
      updateSynonymOptions
      (cloudsearch/update-synonym-options-request
       (clojure.core/nth args9151 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :delete-domain
   [m9153]
   (clojure.core/let
    [credentials9154 (:credentials m9153) args9155 (:args m9153)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client9156
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials9154)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9156
       deleteDomain
       (cloudsearch/delete-domain-request
        (clojure.core/nth args9155 0)))))))
  (clojure.core/defn
   delete-domain-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener domain-name]}]]),
    :doc "Generate map for deleteDomain"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :cloudsearch,
     :fn :delete-domain,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-domain
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener domain-name]}]]),
    :doc "Call deleteDomain"}
   [credentials9158 & args9159]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client9160
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials9158)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9160
      deleteDomain
      (cloudsearch/delete-domain-request
       (clojure.core/nth args9159 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :describe-rank-expressions
   [m9161]
   (clojure.core/let
    [credentials9162 (:credentials m9161) args9163 (:args m9161)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client9164
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials9162)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9164
       describeRankExpressions
       (cloudsearch/describe-rank-expressions-request
        (clojure.core/nth args9163 0)))))))
  (clojure.core/defn
   describe-rank-expressions-map
   {:arglists (quote
               [[credentials
                 {:keys [rank-names
                         general-progress-listener
                         domain-name]}]]),
    :doc "Generate map for describeRankExpressions"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :cloudsearch,
     :fn :describe-rank-expressions,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-rank-expressions
   {:arglists (quote
               [[credentials
                 {:keys [rank-names
                         general-progress-listener
                         domain-name]}]]),
    :doc "Call describeRankExpressions"}
   [credentials9166 & args9167]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client9168
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials9166)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9168
      describeRankExpressions
      (cloudsearch/describe-rank-expressions-request
       (clojure.core/nth args9167 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :index-documents
   [m9169]
   (clojure.core/let
    [credentials9170 (:credentials m9169) args9171 (:args m9169)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client9172
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials9170)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9172
       indexDocuments
       (cloudsearch/index-documents-request
        (clojure.core/nth args9171 0)))))))
  (clojure.core/defn
   index-documents-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener domain-name]}]]),
    :doc "Generate map for indexDocuments"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :cloudsearch,
     :fn :index-documents,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   index-documents
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener domain-name]}]]),
    :doc "Call indexDocuments"}
   [credentials9174 & args9175]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client9176
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials9174)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9176
      indexDocuments
      (cloudsearch/index-documents-request
       (clojure.core/nth args9175 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :update-service-access-policies
   [m9177]
   (clojure.core/let
    [credentials9178 (:credentials m9177) args9179 (:args m9177)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client9180
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials9178)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9180
       updateServiceAccessPolicies
       (cloudsearch/update-service-access-policies-request
        (clojure.core/nth args9179 0)))))))
  (clojure.core/defn
   update-service-access-policies-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         domain-name
                         access-policies]}]]),
    :doc "Generate map for updateServiceAccessPolicies"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :cloudsearch,
     :fn :update-service-access-policies,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   update-service-access-policies
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         domain-name
                         access-policies]}]]),
    :doc "Call updateServiceAccessPolicies"}
   [credentials9182 & args9183]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client9184
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials9182)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9184
      updateServiceAccessPolicies
      (cloudsearch/update-service-access-policies-request
       (clojure.core/nth args9183 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :update-stemming-options
   [m9185]
   (clojure.core/let
    [credentials9186 (:credentials m9185) args9187 (:args m9185)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client9188
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials9186)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9188
       updateStemmingOptions
       (cloudsearch/update-stemming-options-request
        (clojure.core/nth args9187 0)))))))
  (clojure.core/defn
   update-stemming-options-map
   {:arglists (quote
               [[credentials
                 {:keys [stems general-progress-listener domain-name]}]]),
    :doc "Generate map for updateStemmingOptions"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :cloudsearch,
     :fn :update-stemming-options,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   update-stemming-options
   {:arglists (quote
               [[credentials
                 {:keys [stems general-progress-listener domain-name]}]]),
    :doc "Call updateStemmingOptions"}
   [credentials9190 & args9191]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client9192
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials9190)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9192
      updateStemmingOptions
      (cloudsearch/update-stemming-options-request
       (clojure.core/nth args9191 0))))))))
