(ns
 com.palletops.awaze.ec2
 (:refer-clojure :exclude [filter])
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.ec2 :as ec2]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :ec2
  [___1600__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1601__auto__]
  (new
   com.amazonaws.services.ec2.AmazonEC2Client
   credentials__1601__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.VolumeType}
volume-type
  [m5985]
  (.
   com.amazonaws.services.ec2.model.VolumeType
   fromValue
   (clojure.core/name m5985)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.PermissionGroup}
permission-group
  [m5988]
  (.
   com.amazonaws.services.ec2.model.PermissionGroup
   fromValue
   (clojure.core/name m5988)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.EbsBlockDevice}
ebs-block-device
  [m5991]
  (clojure.core/let
   [bean5990 (new com.amazonaws.services.ec2.model.EbsBlockDevice)]
   (clojure.core/when-let
    [v5992 (:encrypted m5991)]
    (. bean5990 setEncrypted (clojure.core/boolean v5992)))
   (clojure.core/when-let
    [v5992 (:snapshot-id m5991)]
    (. bean5990 setSnapshotId (clojure.core/str v5992)))
   (clojure.core/when-let
    [v5992 (:volume-size m5991)]
    (. bean5990 setVolumeSize (clojure.core/int v5992)))
   (clojure.core/when-let
    [v5992 (:volume-type m5991)]
    (. bean5990 setVolumeType (ec2/volume-type v5992)))
   (clojure.core/when-let
    [v5992 (:delete-on-termination m5991)]
    (. bean5990 setDeleteOnTermination (clojure.core/boolean v5992)))
   (clojure.core/when-let
    [v5992 (:iops m5991)]
    (. bean5990 setIops (clojure.core/int v5992)))
   bean5990))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.PrivateIpAddressSpecification}
private-ip-address-specification
  [m5994]
  (clojure.core/let
   [bean5993
    (new
     com.amazonaws.services.ec2.model.PrivateIpAddressSpecification)]
   (clojure.core/when-let
    [v5995 (:private-ip-address m5994)]
    (. bean5993 setPrivateIpAddress (clojure.core/str v5995)))
   (clojure.core/when-let
    [v5995 (:primary m5994)]
    (. bean5993 setPrimary (clojure.core/boolean v5995)))
   bean5993))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.UserIdGroupPair}
user-id-group-pair
  [m5997]
  (clojure.core/let
   [bean5996 (new com.amazonaws.services.ec2.model.UserIdGroupPair)]
   (clojure.core/when-let
    [v5998 (:group-name m5997)]
    (. bean5996 setGroupName (clojure.core/str v5998)))
   (clojure.core/when-let
    [v5998 (:group-id m5997)]
    (. bean5996 setGroupId (clojure.core/str v5998)))
   (clojure.core/when-let
    [v5998 (:user-id m5997)]
    (. bean5996 setUserId (clojure.core/str v5998)))
   bean5996))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CurrencyCodeValues}
currency-code-values
  [m6000]
  (.
   com.amazonaws.services.ec2.model.CurrencyCodeValues
   fromValue
   (clojure.core/name m6000)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.LaunchPermission}
launch-permission
  [m6003]
  (clojure.core/let
   [bean6002 (new com.amazonaws.services.ec2.model.LaunchPermission)]
   (clojure.core/when-let
    [v6004 (:user-id m6003)]
    (. bean6002 setUserId (clojure.core/str v6004)))
   (clojure.core/when-let
    [v6004 (:group m6003)]
    (. bean6002 setGroup (ec2/permission-group v6004)))
   bean6002))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateVolumePermission}
create-volume-permission
  [m6006]
  (clojure.core/let
   [bean6005
    (new com.amazonaws.services.ec2.model.CreateVolumePermission)]
   (clojure.core/when-let
    [v6007 (:user-id m6006)]
    (. bean6005 setUserId (clojure.core/str v6007)))
   (clojure.core/when-let
    [v6007 (:group m6006)]
    (. bean6005 setGroup (ec2/permission-group v6007)))
   bean6005))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.Placement}
placement
  [m6009]
  (clojure.core/let
   [bean6008 (new com.amazonaws.services.ec2.model.Placement)]
   (clojure.core/when-let
    [v6010 (:availability-zone m6009)]
    (. bean6008 setAvailabilityZone (clojure.core/str v6010)))
   (clojure.core/when-let
    [v6010 (:group-name m6009)]
    (. bean6008 setGroupName (clojure.core/str v6010)))
   (clojure.core/when-let
    [v6010 (:tenancy m6009)]
    (. bean6008 setTenancy (clojure.core/str v6010)))
   bean6008))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ArchitectureValues}
architecture-values
  [m6012]
  (.
   com.amazonaws.services.ec2.model.ArchitectureValues
   fromValue
   (clojure.core/name m6012)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ShutdownBehavior}
shutdown-behavior
  [m6015]
  (.
   com.amazonaws.services.ec2.model.ShutdownBehavior
   fromValue
   (clojure.core/name m6015)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DiskImageDetail}
disk-image-detail
  [m6018]
  (clojure.core/let
   [bean6017 (new com.amazonaws.services.ec2.model.DiskImageDetail)]
   (clojure.core/when-let
    [v6019 (:format m6018)]
    (. bean6017 setFormat (clojure.core/str v6019)))
   (clojure.core/when-let
    [v6019 (:bytes m6018)]
    (. bean6017 setBytes (clojure.core/long v6019)))
   (clojure.core/when-let
    [v6019 (:import-manifest-url m6018)]
    (. bean6017 setImportManifestUrl (clojure.core/str v6019)))
   bean6017))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.VolumeDetail}
volume-detail
  [m6021]
  (clojure.core/let
   [bean6020 (new com.amazonaws.services.ec2.model.VolumeDetail)]
   (clojure.core/when-let
    [v6022 (:size m6021)]
    (. bean6020 setSize (clojure.core/long v6022)))
   bean6020))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.EbsInstanceBlockDeviceSpecification}
ebs-instance-block-device-specification
  [m6024]
  (clojure.core/let
   [bean6023
    (new
     com.amazonaws.services.ec2.model.EbsInstanceBlockDeviceSpecification)]
   (clojure.core/when-let
    [v6025 (:volume-id m6024)]
    (. bean6023 setVolumeId (clojure.core/str v6025)))
   (clojure.core/when-let
    [v6025 (:delete-on-termination m6024)]
    (. bean6023 setDeleteOnTermination (clojure.core/boolean v6025)))
   bean6023))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.S3Storage}
s3storage
  [m6027]
  (clojure.core/let
   [bean6026 (new com.amazonaws.services.ec2.model.S3Storage)]
   (clojure.core/when-let
    [v6028 (:bucket m6027)]
    (. bean6026 setBucket (clojure.core/str v6028)))
   (clojure.core/when-let
    [v6028 (:prefix m6027)]
    (. bean6026 setPrefix (clojure.core/str v6028)))
   (clojure.core/when-let
    [v6028 (:awsaccess-key-id m6027)]
    (. bean6026 setAWSAccessKeyId (clojure.core/str v6028)))
   (clojure.core/when-let
    [v6028 (:upload-policy m6027)]
    (. bean6026 setUploadPolicy (clojure.core/str v6028)))
   (clojure.core/when-let
    [v6028 (:upload-policy-signature m6027)]
    (. bean6026 setUploadPolicySignature (clojure.core/str v6028)))
   bean6026))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.IamInstanceProfileSpecification}
iam-instance-profile-specification
  [m6030]
  (clojure.core/let
   [bean6029
    (new
     com.amazonaws.services.ec2.model.IamInstanceProfileSpecification)]
   (clojure.core/when-let
    [v6031 (:name m6030)]
    (. bean6029 setName (clojure.core/str v6031)))
   (clojure.core/when-let
    [v6031 (:arn m6030)]
    (. bean6029 setArn (clojure.core/str v6031)))
   bean6029))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.SpotPlacement}
spot-placement
  [m6033]
  (clojure.core/let
   [bean6032 (new com.amazonaws.services.ec2.model.SpotPlacement)]
   (clojure.core/when-let
    [v6034 (:availability-zone m6033)]
    (. bean6032 setAvailabilityZone (clojure.core/str v6034)))
   (clojure.core/when-let
    [v6034 (:group-name m6033)]
    (. bean6032 setGroupName (clojure.core/str v6034)))
   bean6032))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.BlockDeviceMapping}
block-device-mapping
  [m6036]
  (clojure.core/let
   [bean6035
    (new com.amazonaws.services.ec2.model.BlockDeviceMapping)]
   (clojure.core/when-let
    [v6037 (:virtual-name m6036)]
    (. bean6035 setVirtualName (clojure.core/str v6037)))
   (clojure.core/when-let
    [v6037 (:device-name m6036)]
    (. bean6035 setDeviceName (clojure.core/str v6037)))
   (clojure.core/when-let
    [v6037 (:ebs m6036)]
    (. bean6035 setEbs (ec2/ebs-block-device v6037)))
   (clojure.core/when-let
    [v6037 (:no-device m6036)]
    (. bean6035 setNoDevice (clojure.core/str v6037)))
   bean6035))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.InstanceNetworkInterfaceSpecification}
instance-network-interface-specification
  [m6039]
  (clojure.core/let
   [bean6038
    (new
     com.amazonaws.services.ec2.model.InstanceNetworkInterfaceSpecification)]
   (clojure.core/when-let
    [v6040 (:network-interface-id m6039)]
    (. bean6038 setNetworkInterfaceId (clojure.core/str v6040)))
   (clojure.core/when-let
    [v6040 (:associate-public-ip-address m6039)]
    (.
     bean6038
     setAssociatePublicIpAddress
     (clojure.core/boolean v6040)))
   (clojure.core/when-let
    [v6040 (:private-ip-address m6039)]
    (. bean6038 setPrivateIpAddress (clojure.core/str v6040)))
   (clojure.core/when-let
    [v6040 (:secondary-private-ip-address-count m6039)]
    (.
     bean6038
     setSecondaryPrivateIpAddressCount
     (clojure.core/int v6040)))
   (clojure.core/when-let
    [v6040 (:groups m6039)]
    (.
     bean6038
     setGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6581] (clojure.core/str arg6581))
 v6040)))
   (clojure.core/when-let
    [v6040 (:delete-on-termination m6039)]
    (. bean6038 setDeleteOnTermination (clojure.core/boolean v6040)))
   (clojure.core/when-let
    [v6040 (:private-ip-addresses m6039)]
    (.
     bean6038
     setPrivateIpAddresses
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg6582]
  (ec2/private-ip-address-specification arg6582))
 v6040)))
   (clojure.core/when-let
    [v6040 (:description m6039)]
    (. bean6038 setDescription (clojure.core/str v6040)))
   (clojure.core/when-let
    [v6040 (:device-index m6039)]
    (. bean6038 setDeviceIndex (clojure.core/int v6040)))
   (clojure.core/when-let
    [v6040 (:subnet-id m6039)]
    (. bean6038 setSubnetId (clojure.core/str v6040)))
   bean6038))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.InstanceType}
instance-type
  [m6042]
  (.
   com.amazonaws.services.ec2.model.InstanceType
   fromValue
   (clojure.core/name m6042)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.GroupIdentifier}
group-identifier
  [m6045]
  (clojure.core/let
   [bean6044 (new com.amazonaws.services.ec2.model.GroupIdentifier)]
   (clojure.core/when-let
    [v6046 (:group-name m6045)]
    (. bean6044 setGroupName (clojure.core/str v6046)))
   (clojure.core/when-let
    [v6046 (:group-id m6045)]
    (. bean6044 setGroupId (clojure.core/str v6046)))
   bean6044))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.Filter}
filter
  [m6048]
  (clojure.core/let
   [bean6047 (new com.amazonaws.services.ec2.model.Filter)]
   (clojure.core/when-let
    [v6049 (:name m6048)]
    (. bean6047 setName (clojure.core/str v6049)))
   (clojure.core/when-let
    [v6049 (:values m6048)]
    (.
     bean6047
     setValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6583] (clojure.core/str arg6583))
 v6049)))
   bean6047))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.RuleAction}
rule-action
  [m6051]
  (.
   com.amazonaws.services.ec2.model.RuleAction
   fromValue
   (clojure.core/name m6051)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.IcmpTypeCode}
icmp-type-code
  [m6054]
  (clojure.core/let
   [bean6053 (new com.amazonaws.services.ec2.model.IcmpTypeCode)]
   (clojure.core/when-let
    [v6055 (:type m6054)]
    (. bean6053 setType (clojure.core/int v6055)))
   (clojure.core/when-let
    [v6055 (:code m6054)]
    (. bean6053 setCode (clojure.core/int v6055)))
   bean6053))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.PortRange}
port-range
  [m6057]
  (clojure.core/let
   [bean6056 (new com.amazonaws.services.ec2.model.PortRange)]
   (clojure.core/when-let
    [v6058 (:to m6057)]
    (. bean6056 setTo (clojure.core/int v6058)))
   (clojure.core/when-let
    [v6058 (:from m6057)]
    (. bean6056 setFrom (clojure.core/int v6058)))
   bean6056))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.IpPermission}
ip-permission
  [m6060]
  (clojure.core/let
   [bean6059 (new com.amazonaws.services.ec2.model.IpPermission)]
   (clojure.core/when-let
    [v6061 (:ip-protocol m6060)]
    (. bean6059 setIpProtocol (clojure.core/str v6061)))
   (clojure.core/when-let
    [v6061 (:from-port m6060)]
    (. bean6059 setFromPort (clojure.core/int v6061)))
   (clojure.core/when-let
    [v6061 (:to-port m6060)]
    (. bean6059 setToPort (clojure.core/int v6061)))
   (clojure.core/when-let
    [v6061 (:user-id-group-pairs m6060)]
    (.
     bean6059
     setUserIdGroupPairs
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6584] (ec2/user-id-group-pair arg6584))
 v6061)))
   (clojure.core/when-let
    [v6061 (:ip-ranges m6060)]
    (.
     bean6059
     setIpRanges
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6585] (clojure.core/str arg6585))
 v6061)))
   bean6059))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.PriceScheduleSpecification}
price-schedule-specification
  [m6063]
  (clojure.core/let
   [bean6062
    (new com.amazonaws.services.ec2.model.PriceScheduleSpecification)]
   (clojure.core/when-let
    [v6064 (:currency-code m6063)]
    (. bean6062 setCurrencyCode (ec2/currency-code-values v6064)))
   (clojure.core/when-let
    [v6064 (:term m6063)]
    (. bean6062 setTerm (clojure.core/long v6064)))
   (clojure.core/when-let
    [v6064 (:price m6063)]
    (. bean6062 setPrice (clojure.core/double v6064)))
   bean6062))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.LaunchPermissionModifications}
launch-permission-modifications
  [m6066]
  (clojure.core/let
   [bean6065
    (new
     com.amazonaws.services.ec2.model.LaunchPermissionModifications)]
   (clojure.core/when-let
    [v6067 (:add m6066)]
    (.
     bean6065
     setAdd
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6586] (ec2/launch-permission arg6586))
 v6067)))
   (clojure.core/when-let
    [v6067 (:remove m6066)]
    (.
     bean6065
     setRemove
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6587] (ec2/launch-permission arg6587))
 v6067)))
   bean6065))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.Tag}
tag
  [m6069]
  (clojure.core/let
   [bean6068 (new com.amazonaws.services.ec2.model.Tag)]
   (clojure.core/when-let
    [v6070 (:value m6069)]
    (. bean6068 setValue (clojure.core/str v6070)))
   (clojure.core/when-let
    [v6070 (:key m6069)]
    (. bean6068 setKey (clojure.core/str v6070)))
   bean6068))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateVolumePermissionModifications}
create-volume-permission-modifications
  [m6072]
  (clojure.core/let
   [bean6071
    (new
     com.amazonaws.services.ec2.model.CreateVolumePermissionModifications)]
   (clojure.core/when-let
    [v6073 (:add m6072)]
    (.
     bean6071
     setAdd
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6588] (ec2/create-volume-permission arg6588))
 v6073)))
   (clojure.core/when-let
    [v6073 (:remove m6072)]
    (.
     bean6071
     setRemove
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6589] (ec2/create-volume-permission arg6589))
 v6073)))
   bean6071))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.SnapshotAttributeName}
snapshot-attribute-name
  [m6075]
  (.
   com.amazonaws.services.ec2.model.SnapshotAttributeName
   fromValue
   (clojure.core/name m6075)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ReservedInstancesConfiguration}
reserved-instances-configuration
  [m6078]
  (clojure.core/let
   [bean6077
    (new
     com.amazonaws.services.ec2.model.ReservedInstancesConfiguration)]
   (clojure.core/when-let
    [v6079 (:availability-zone m6078)]
    (. bean6077 setAvailabilityZone (clojure.core/str v6079)))
   (clojure.core/when-let
    [v6079 (:instance-type m6078)]
    (. bean6077 setInstanceType (clojure.core/str v6079)))
   (clojure.core/when-let
    [v6079 (:instance-count m6078)]
    (. bean6077 setInstanceCount (clojure.core/int v6079)))
   (clojure.core/when-let
    [v6079 (:platform m6078)]
    (. bean6077 setPlatform (clojure.core/str v6079)))
   bean6077))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.OfferingTypeValues}
offering-type-values
  [m6081]
  (.
   com.amazonaws.services.ec2.model.OfferingTypeValues
   fromValue
   (clojure.core/name m6081)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ImportInstanceLaunchSpecification}
import-instance-launch-specification
  [m6084]
  (clojure.core/let
   [bean6083
    (new
     com.amazonaws.services.ec2.model.ImportInstanceLaunchSpecification)]
   (clojure.core/when-let
    [v6085 (:placement m6084)]
    (. bean6083 setPlacement (ec2/placement v6085)))
   (clojure.core/when-let
    [v6085 (:monitoring m6084)]
    (. bean6083 setMonitoring (clojure.core/boolean v6085)))
   (clojure.core/when-let
    [v6085 (:group-names m6084)]
    (.
     bean6083
     setGroupNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6590] (clojure.core/str arg6590))
 v6085)))
   (clojure.core/when-let
    [v6085 (:private-ip-address m6084)]
    (. bean6083 setPrivateIpAddress (clojure.core/str v6085)))
   (clojure.core/when-let
    [v6085 (:instance-type m6084)]
    (. bean6083 setInstanceType (clojure.core/str v6085)))
   (clojure.core/when-let
    [v6085 (:architecture m6084)]
    (. bean6083 setArchitecture (ec2/architecture-values v6085)))
   (clojure.core/when-let
    [v6085 (:user-data m6084)]
    (. bean6083 setUserData (clojure.core/str v6085)))
   (clojure.core/when-let
    [v6085 (:additional-info m6084)]
    (. bean6083 setAdditionalInfo (clojure.core/str v6085)))
   (clojure.core/when-let
    [v6085 (:subnet-id m6084)]
    (. bean6083 setSubnetId (clojure.core/str v6085)))
   (clojure.core/when-let
    [v6085 (:instance-initiated-shutdown-behavior m6084)]
    (.
     bean6083
     setInstanceInitiatedShutdownBehavior
     (ec2/shutdown-behavior v6085)))
   bean6083))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DiskImage}
disk-image
  [m6087]
  (clojure.core/let
   [bean6086 (new com.amazonaws.services.ec2.model.DiskImage)]
   (clojure.core/when-let
    [v6088 (:image m6087)]
    (. bean6086 setImage (ec2/disk-image-detail v6088)))
   (clojure.core/when-let
    [v6088 (:volume m6087)]
    (. bean6086 setVolume (ec2/volume-detail v6088)))
   (clojure.core/when-let
    [v6088 (:description m6087)]
    (. bean6086 setDescription (clojure.core/str v6088)))
   bean6086))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.NetworkInterfaceAttachmentChanges}
network-interface-attachment-changes
  [m6090]
  (clojure.core/let
   [bean6089
    (new
     com.amazonaws.services.ec2.model.NetworkInterfaceAttachmentChanges)]
   (clojure.core/when-let
    [v6091 (:attachment-id m6090)]
    (. bean6089 setAttachmentId (clojure.core/str v6091)))
   (clojure.core/when-let
    [v6091 (:delete-on-termination m6090)]
    (. bean6089 setDeleteOnTermination (clojure.core/boolean v6091)))
   bean6089))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.InstanceBlockDeviceMappingSpecification}
instance-block-device-mapping-specification
  [m6093]
  (clojure.core/let
   [bean6092
    (new
     com.amazonaws.services.ec2.model.InstanceBlockDeviceMappingSpecification)]
   (clojure.core/when-let
    [v6094 (:virtual-name m6093)]
    (. bean6092 setVirtualName (clojure.core/str v6094)))
   (clojure.core/when-let
    [v6094 (:device-name m6093)]
    (. bean6092 setDeviceName (clojure.core/str v6094)))
   (clojure.core/when-let
    [v6094 (:ebs m6093)]
    (.
     bean6092
     setEbs
     (ec2/ebs-instance-block-device-specification v6094)))
   (clojure.core/when-let
    [v6094 (:no-device m6093)]
    (. bean6092 setNoDevice (clojure.core/str v6094)))
   bean6092))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.InstanceAttributeName}
instance-attribute-name
  [m6096]
  (.
   com.amazonaws.services.ec2.model.InstanceAttributeName
   fromValue
   (clojure.core/name m6096)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.Storage}
storage
  [m6099]
  (clojure.core/let
   [bean6098 (new com.amazonaws.services.ec2.model.Storage)]
   (clojure.core/when-let
    [v6100 (:s3 m6099)]
    (. bean6098 setS3 (ec2/s3storage v6100)))
   bean6098))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ReservedInstanceLimitPrice}
reserved-instance-limit-price
  [m6102]
  (clojure.core/let
   [bean6101
    (new com.amazonaws.services.ec2.model.ReservedInstanceLimitPrice)]
   (clojure.core/when-let
    [v6103 (:currency-code m6102)]
    (. bean6101 setCurrencyCode (clojure.core/str v6103)))
   (clojure.core/when-let
    [v6103 (:amount m6102)]
    (. bean6101 setAmount (clojure.core/double v6103)))
   bean6101))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.RIProductDescription}
riproduct-description
  [m6105]
  (.
   com.amazonaws.services.ec2.model.RIProductDescription
   fromValue
   (clojure.core/name m6105)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ExportToS3TaskSpecification}
export-to-s3task-specification
  [m6108]
  (clojure.core/let
   [bean6107
    (new com.amazonaws.services.ec2.model.ExportToS3TaskSpecification)]
   (clojure.core/when-let
    [v6109 (:disk-image-format m6108)]
    (. bean6107 setDiskImageFormat (clojure.core/str v6109)))
   (clojure.core/when-let
    [v6109 (:container-format m6108)]
    (. bean6107 setContainerFormat (clojure.core/str v6109)))
   (clojure.core/when-let
    [v6109 (:s3bucket m6108)]
    (. bean6107 setS3Bucket (clojure.core/str v6109)))
   (clojure.core/when-let
    [v6109 (:s3prefix m6108)]
    (. bean6107 setS3Prefix (clojure.core/str v6109)))
   bean6107))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.VpnConnectionOptionsSpecification}
vpn-connection-options-specification
  [m6111]
  (clojure.core/let
   [bean6110
    (new
     com.amazonaws.services.ec2.model.VpnConnectionOptionsSpecification)]
   (clojure.core/when-let
    [v6112 (:static-routes-only m6111)]
    (. bean6110 setStaticRoutesOnly (clojure.core/boolean v6112)))
   bean6110))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.LaunchSpecification}
launch-specification
  [m6114]
  (clojure.core/let
   [bean6113
    (new com.amazonaws.services.ec2.model.LaunchSpecification)]
   (clojure.core/when-let
    [v6115 (:iam-instance-profile m6114)]
    (.
     bean6113
     setIamInstanceProfile
     (ec2/iam-instance-profile-specification v6115)))
   (clojure.core/when-let
    [v6115 (:placement m6114)]
    (. bean6113 setPlacement (ec2/spot-placement v6115)))
   (clojure.core/when-let
    [v6115 (:block-device-mappings m6114)]
    (.
     bean6113
     setBlockDeviceMappings
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6591] (ec2/block-device-mapping arg6591))
 v6115)))
   (clojure.core/when-let
    [v6115 (:network-interfaces m6114)]
    (.
     bean6113
     setNetworkInterfaces
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg6592]
  (ec2/instance-network-interface-specification arg6592))
 v6115)))
   (clojure.core/when-let
    [v6115 (:key-name m6114)]
    (. bean6113 setKeyName (clojure.core/str v6115)))
   (clojure.core/when-let
    [v6115 (:addressing-type m6114)]
    (. bean6113 setAddressingType (clojure.core/str v6115)))
   (clojure.core/when-let
    [v6115 (:instance-type m6114)]
    (. bean6113 setInstanceType (ec2/instance-type v6115)))
   (clojure.core/when-let
    [v6115 (:all-security-groups m6114)]
    (.
     bean6113
     setAllSecurityGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6593] (ec2/group-identifier arg6593))
 v6115)))
   (clojure.core/when-let
    [v6115 (:ebs-optimized m6114)]
    (. bean6113 setEbsOptimized (clojure.core/boolean v6115)))
   (clojure.core/when-let
    [v6115 (:image-id m6114)]
    (. bean6113 setImageId (clojure.core/str v6115)))
   (clojure.core/when-let
    [v6115 (:ramdisk-id m6114)]
    (. bean6113 setRamdiskId (clojure.core/str v6115)))
   (clojure.core/when-let
    [v6115 (:security-groups m6114)]
    (.
     bean6113
     setSecurityGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6594] (clojure.core/str arg6594))
 v6115)))
   (clojure.core/when-let
    [v6115 (:user-data m6114)]
    (. bean6113 setUserData (clojure.core/str v6115)))
   (clojure.core/when-let
    [v6115 (:monitoring-enabled m6114)]
    (. bean6113 setMonitoringEnabled (clojure.core/boolean v6115)))
   (clojure.core/when-let
    [v6115 (:kernel-id m6114)]
    (. bean6113 setKernelId (clojure.core/str v6115)))
   (clojure.core/when-let
    [v6115 (:subnet-id m6114)]
    (. bean6113 setSubnetId (clojure.core/str v6115)))
   bean6113))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.GatewayType}
gateway-type
  [m6117]
  (.
   com.amazonaws.services.ec2.model.GatewayType
   fromValue
   (clojure.core/name m6117)))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DhcpConfiguration}
dhcp-configuration
  [m6120]
  (clojure.core/let
   [bean6119 (new com.amazonaws.services.ec2.model.DhcpConfiguration)]
   (clojure.core/when-let
    [v6121 (:key m6120)]
    (. bean6119 setKey (clojure.core/str v6121)))
   (clojure.core/when-let
    [v6121 (:values m6120)]
    (.
     bean6119
     setValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6595] (clojure.core/str arg6595))
 v6121)))
   bean6119))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeSecurityGroupsRequest}
describe-security-groups-request
  [m6123]
  (clojure.core/let
   [bean6122
    (new
     com.amazonaws.services.ec2.model.DescribeSecurityGroupsRequest)]
   (clojure.core/when-let
    [v6124 (:filters m6123)]
    (.
     bean6122
     setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6596] (ec2/filter arg6596))
 v6124)))
   (clojure.core/when-let
    [v6124 (:group-ids m6123)]
    (.
     bean6122
     setGroupIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6597] (clojure.core/str arg6597))
 v6124)))
   (clojure.core/when-let
    [v6124 (:group-names m6123)]
    (.
     bean6122
     setGroupNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6598] (clojure.core/str arg6598))
 v6124)))
   bean6122))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateVpcRequest}
create-vpc-request
  [m6126]
  (clojure.core/let
   [bean6125 (new com.amazonaws.services.ec2.model.CreateVpcRequest)]
   (clojure.core/when-let
    [v6127 (:cidr-block m6126)]
    (. bean6125 setCidrBlock (clojure.core/str v6127)))
   (clojure.core/when-let
    [v6127 (:instance-tenancy m6126)]
    (. bean6125 setInstanceTenancy (clojure.core/str v6127)))
   bean6125))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeregisterImageRequest}
deregister-image-request
  [m6129]
  (clojure.core/let
   [bean6128
    (new com.amazonaws.services.ec2.model.DeregisterImageRequest)]
   (clojure.core/when-let
    [v6130 (:image-id m6129)]
    (. bean6128 setImageId (clojure.core/str v6130)))
   bean6128))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateNetworkAclEntryRequest}
create-network-acl-entry-request
  [m6132]
  (clojure.core/let
   [bean6131
    (new
     com.amazonaws.services.ec2.model.CreateNetworkAclEntryRequest)]
   (clojure.core/when-let
    [v6133 (:network-acl-id m6132)]
    (. bean6131 setNetworkAclId (clojure.core/str v6133)))
   (clojure.core/when-let
    [v6133 (:rule-number m6132)]
    (. bean6131 setRuleNumber (clojure.core/int v6133)))
   (clojure.core/when-let
    [v6133 (:rule-action m6132)]
    (. bean6131 setRuleAction (ec2/rule-action v6133)))
   (clojure.core/when-let
    [v6133 (:egress m6132)]
    (. bean6131 setEgress (clojure.core/boolean v6133)))
   (clojure.core/when-let
    [v6133 (:cidr-block m6132)]
    (. bean6131 setCidrBlock (clojure.core/str v6133)))
   (clojure.core/when-let
    [v6133 (:icmp-type-code m6132)]
    (. bean6131 setIcmpTypeCode (ec2/icmp-type-code v6133)))
   (clojure.core/when-let
    [v6133 (:port-range m6132)]
    (. bean6131 setPortRange (ec2/port-range v6133)))
   (clojure.core/when-let
    [v6133 (:protocol m6132)]
    (. bean6131 setProtocol (clojure.core/str v6133)))
   bean6131))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CancelExportTaskRequest}
cancel-export-task-request
  [m6135]
  (clojure.core/let
   [bean6134
    (new com.amazonaws.services.ec2.model.CancelExportTaskRequest)]
   (clojure.core/when-let
    [v6136 (:export-task-id m6135)]
    (. bean6134 setExportTaskId (clojure.core/str v6136)))
   bean6134))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.RevokeSecurityGroupIngressRequest}
revoke-security-group-ingress-request
  [m6138]
  (clojure.core/let
   [bean6137
    (new
     com.amazonaws.services.ec2.model.RevokeSecurityGroupIngressRequest)]
   (clojure.core/when-let
    [v6139 (:ip-protocol m6138)]
    (. bean6137 setIpProtocol (clojure.core/str v6139)))
   (clojure.core/when-let
    [v6139 (:group-name m6138)]
    (. bean6137 setGroupName (clojure.core/str v6139)))
   (clojure.core/when-let
    [v6139 (:source-security-group-owner-id m6138)]
    (.
     bean6137
     setSourceSecurityGroupOwnerId
     (clojure.core/str v6139)))
   (clojure.core/when-let
    [v6139 (:source-security-group-name m6138)]
    (. bean6137 setSourceSecurityGroupName (clojure.core/str v6139)))
   (clojure.core/when-let
    [v6139 (:from-port m6138)]
    (. bean6137 setFromPort (clojure.core/int v6139)))
   (clojure.core/when-let
    [v6139 (:group-id m6138)]
    (. bean6137 setGroupId (clojure.core/str v6139)))
   (clojure.core/when-let
    [v6139 (:ip-permissions m6138)]
    (.
     bean6137
     setIpPermissions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6599] (ec2/ip-permission arg6599))
 v6139)))
   (clojure.core/when-let
    [v6139 (:cidr-ip m6138)]
    (. bean6137 setCidrIp (clojure.core/str v6139)))
   (clojure.core/when-let
    [v6139 (:to-port m6138)]
    (. bean6137 setToPort (clojure.core/int v6139)))
   bean6137))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeRouteTablesRequest}
describe-route-tables-request
  [m6141]
  (clojure.core/let
   [bean6140
    (new com.amazonaws.services.ec2.model.DescribeRouteTablesRequest)]
   (clojure.core/when-let
    [v6142 (:filters m6141)]
    (.
     bean6140
     setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6600] (ec2/filter arg6600))
 v6142)))
   (clojure.core/when-let
    [v6142 (:route-table-ids m6141)]
    (.
     bean6140
     setRouteTableIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6601] (clojure.core/str arg6601))
 v6142)))
   bean6140))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateReservedInstancesListingRequest}
create-reserved-instances-listing-request
  [m6144]
  (clojure.core/let
   [bean6143
    (new
     com.amazonaws.services.ec2.model.CreateReservedInstancesListingRequest)]
   (clojure.core/when-let
    [v6145 (:instance-count m6144)]
    (. bean6143 setInstanceCount (clojure.core/int v6145)))
   (clojure.core/when-let
    [v6145 (:reserved-instances-id m6144)]
    (. bean6143 setReservedInstancesId (clojure.core/str v6145)))
   (clojure.core/when-let
    [v6145 (:price-schedules m6144)]
    (.
     bean6143
     setPriceSchedules
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg6602]
  (ec2/price-schedule-specification arg6602))
 v6145)))
   (clojure.core/when-let
    [v6145 (:client-token m6144)]
    (. bean6143 setClientToken (clojure.core/str v6145)))
   bean6143))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ResetImageAttributeRequest}
reset-image-attribute-request
  [m6147]
  (clojure.core/let
   [bean6146
    (new com.amazonaws.services.ec2.model.ResetImageAttributeRequest)]
   (clojure.core/when-let
    [v6148 (:image-id m6147)]
    (. bean6146 setImageId (clojure.core/str v6148)))
   (clojure.core/when-let
    [v6148 (:attribute m6147)]
    (. bean6146 setAttribute (clojure.core/str v6148)))
   bean6146))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeAvailabilityZonesRequest}
describe-availability-zones-request
  [m6150]
  (clojure.core/let
   [bean6149
    (new
     com.amazonaws.services.ec2.model.DescribeAvailabilityZonesRequest)]
   (clojure.core/when-let
    [v6151 (:filters m6150)]
    (.
     bean6149
     setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6603] (ec2/filter arg6603))
 v6151)))
   (clojure.core/when-let
    [v6151 (:zone-names m6150)]
    (.
     bean6149
     setZoneNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6604] (clojure.core/str arg6604))
 v6151)))
   bean6149))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeNetworkAclsRequest}
describe-network-acls-request
  [m6153]
  (clojure.core/let
   [bean6152
    (new com.amazonaws.services.ec2.model.DescribeNetworkAclsRequest)]
   (clojure.core/when-let
    [v6154 (:filters m6153)]
    (.
     bean6152
     setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6605] (ec2/filter arg6605))
 v6154)))
   (clojure.core/when-let
    [v6154 (:network-acl-ids m6153)]
    (.
     bean6152
     setNetworkAclIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6606] (clojure.core/str arg6606))
 v6154)))
   bean6152))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeVpnGatewaysRequest}
describe-vpn-gateways-request
  [m6156]
  (clojure.core/let
   [bean6155
    (new com.amazonaws.services.ec2.model.DescribeVpnGatewaysRequest)]
   (clojure.core/when-let
    [v6157 (:filters m6156)]
    (.
     bean6155
     setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6607] (ec2/filter arg6607))
 v6157)))
   (clojure.core/when-let
    [v6157 (:vpn-gateway-ids m6156)]
    (.
     bean6155
     setVpnGatewayIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6608] (clojure.core/str arg6608))
 v6157)))
   bean6155))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeSnapshotsRequest}
describe-snapshots-request
  [m6159]
  (clojure.core/let
   [bean6158
    (new com.amazonaws.services.ec2.model.DescribeSnapshotsRequest)]
   (clojure.core/when-let
    [v6160 (:filters m6159)]
    (.
     bean6158
     setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6609] (ec2/filter arg6609))
 v6160)))
   (clojure.core/when-let
    [v6160 (:snapshot-ids m6159)]
    (.
     bean6158
     setSnapshotIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6610] (clojure.core/str arg6610))
 v6160)))
   (clojure.core/when-let
    [v6160 (:owner-ids m6159)]
    (.
     bean6158
     setOwnerIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6611] (clojure.core/str arg6611))
 v6160)))
   (clojure.core/when-let
    [v6160 (:restorable-by-user-ids m6159)]
    (.
     bean6158
     setRestorableByUserIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6612] (clojure.core/str arg6612))
 v6160)))
   bean6158))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ModifyImageAttributeRequest}
modify-image-attribute-request
  [m6162]
  (clojure.core/let
   [bean6161
    (new com.amazonaws.services.ec2.model.ModifyImageAttributeRequest)]
   (clojure.core/when-let
    [v6163 (:user-groups m6162)]
    (.
     bean6161
     setUserGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6613] (clojure.core/str arg6613))
 v6163)))
   (clojure.core/when-let
    [v6163 (:launch-permission m6162)]
    (.
     bean6161
     setLaunchPermission
     (ec2/launch-permission-modifications v6163)))
   (clojure.core/when-let
    [v6163 (:user-ids m6162)]
    (.
     bean6161
     setUserIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6614] (clojure.core/str arg6614))
 v6163)))
   (clojure.core/when-let
    [v6163 (:value m6162)]
    (. bean6161 setValue (clojure.core/str v6163)))
   (clojure.core/when-let
    [v6163 (:image-id m6162)]
    (. bean6161 setImageId (clojure.core/str v6163)))
   (clojure.core/when-let
    [v6163 (:product-codes m6162)]
    (.
     bean6161
     setProductCodes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6615] (clojure.core/str arg6615))
 v6163)))
   (clojure.core/when-let
    [v6163 (:attribute m6162)]
    (. bean6161 setAttribute (clojure.core/str v6163)))
   (clojure.core/when-let
    [v6163 (:description m6162)]
    (. bean6161 setDescription (clojure.core/str v6163)))
   (clojure.core/when-let
    [v6163 (:operation-type m6162)]
    (. bean6161 setOperationType (clojure.core/str v6163)))
   bean6161))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeVolumesRequest}
describe-volumes-request
  [m6165]
  (clojure.core/let
   [bean6164
    (new com.amazonaws.services.ec2.model.DescribeVolumesRequest)]
   (clojure.core/when-let
    [v6166 (:filters m6165)]
    (.
     bean6164
     setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6616] (ec2/filter arg6616))
 v6166)))
   (clojure.core/when-let
    [v6166 (:volume-ids m6165)]
    (.
     bean6164
     setVolumeIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6617] (clojure.core/str arg6617))
 v6166)))
   bean6164))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.AttachInternetGatewayRequest}
attach-internet-gateway-request
  [m6168]
  (clojure.core/let
   [bean6167
    (new
     com.amazonaws.services.ec2.model.AttachInternetGatewayRequest)]
   (clojure.core/when-let
    [v6169 (:vpc-id m6168)]
    (. bean6167 setVpcId (clojure.core/str v6169)))
   (clojure.core/when-let
    [v6169 (:internet-gateway-id m6168)]
    (. bean6167 setInternetGatewayId (clojure.core/str v6169)))
   bean6167))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteSecurityGroupRequest}
delete-security-group-request
  [m6171]
  (clojure.core/let
   [bean6170
    (new com.amazonaws.services.ec2.model.DeleteSecurityGroupRequest)]
   (clojure.core/when-let
    [v6172 (:group-name m6171)]
    (. bean6170 setGroupName (clojure.core/str v6172)))
   (clojure.core/when-let
    [v6172 (:group-id m6171)]
    (. bean6170 setGroupId (clojure.core/str v6172)))
   bean6170))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DetachVolumeRequest}
detach-volume-request
  [m6174]
  (clojure.core/let
   [bean6173
    (new com.amazonaws.services.ec2.model.DetachVolumeRequest)]
   (clojure.core/when-let
    [v6175 (:instance-id m6174)]
    (. bean6173 setInstanceId (clojure.core/str v6175)))
   (clojure.core/when-let
    [v6175 (:volume-id m6174)]
    (. bean6173 setVolumeId (clojure.core/str v6175)))
   (clojure.core/when-let
    [v6175 (:device m6174)]
    (. bean6173 setDevice (clojure.core/str v6175)))
   (clojure.core/when-let
    [v6175 (:force m6174)]
    (. bean6173 setForce (clojure.core/boolean v6175)))
   bean6173))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ReleaseAddressRequest}
release-address-request
  [m6177]
  (clojure.core/let
   [bean6176
    (new com.amazonaws.services.ec2.model.ReleaseAddressRequest)]
   (clojure.core/when-let
    [v6178 (:public-ip m6177)]
    (. bean6176 setPublicIp (clojure.core/str v6178)))
   (clojure.core/when-let
    [v6178 (:allocation-id m6177)]
    (. bean6176 setAllocationId (clojure.core/str v6178)))
   bean6176))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ImportVolumeRequest}
import-volume-request
  [m6180]
  (clojure.core/let
   [bean6179
    (new com.amazonaws.services.ec2.model.ImportVolumeRequest)]
   (clojure.core/when-let
    [v6181 (:availability-zone m6180)]
    (. bean6179 setAvailabilityZone (clojure.core/str v6181)))
   (clojure.core/when-let
    [v6181 (:image m6180)]
    (. bean6179 setImage (ec2/disk-image-detail v6181)))
   (clojure.core/when-let
    [v6181 (:volume m6180)]
    (. bean6179 setVolume (ec2/volume-detail v6181)))
   (clojure.core/when-let
    [v6181 (:description m6180)]
    (. bean6179 setDescription (clojure.core/str v6181)))
   bean6179))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteRouteTableRequest}
delete-route-table-request
  [m6183]
  (clojure.core/let
   [bean6182
    (new com.amazonaws.services.ec2.model.DeleteRouteTableRequest)]
   (clojure.core/when-let
    [v6184 (:route-table-id m6183)]
    (. bean6182 setRouteTableId (clojure.core/str v6184)))
   bean6182))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeSnapshotAttributeRequest}
describe-snapshot-attribute-request
  [m6186]
  (clojure.core/let
   [bean6185
    (new
     com.amazonaws.services.ec2.model.DescribeSnapshotAttributeRequest)]
   (clojure.core/when-let
    [v6187 (:snapshot-id m6186)]
    (. bean6185 setSnapshotId (clojure.core/str v6187)))
   (clojure.core/when-let
    [v6187 (:attribute m6186)]
    (. bean6185 setAttribute (clojure.core/str v6187)))
   bean6185))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeInstanceStatusRequest}
describe-instance-status-request
  [m6189]
  (clojure.core/let
   [bean6188
    (new
     com.amazonaws.services.ec2.model.DescribeInstanceStatusRequest)]
   (clojure.core/when-let
    [v6190 (:instance-ids m6189)]
    (.
     bean6188
     setInstanceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6618] (clojure.core/str arg6618))
 v6190)))
   (clojure.core/when-let
    [v6190 (:filters m6189)]
    (.
     bean6188
     setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6619] (ec2/filter arg6619))
 v6190)))
   (clojure.core/when-let
    [v6190 (:max-results m6189)]
    (. bean6188 setMaxResults (clojure.core/int v6190)))
   (clojure.core/when-let
    [v6190 (:include-all-instances m6189)]
    (. bean6188 setIncludeAllInstances (clojure.core/boolean v6190)))
   (clojure.core/when-let
    [v6190 (:next-token m6189)]
    (. bean6188 setNextToken (clojure.core/str v6190)))
   bean6188))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeImageAttributeRequest}
describe-image-attribute-request
  [m6192]
  (clojure.core/let
   [bean6191
    (new
     com.amazonaws.services.ec2.model.DescribeImageAttributeRequest)]
   (clojure.core/when-let
    [v6193 (:image-id m6192)]
    (. bean6191 setImageId (clojure.core/str v6193)))
   (clojure.core/when-let
    [v6193 (:attribute m6192)]
    (. bean6191 setAttribute (clojure.core/str v6193)))
   bean6191))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ReportInstanceStatusRequest}
report-instance-status-request
  [m6195]
  (clojure.core/let
   [bean6194
    (new com.amazonaws.services.ec2.model.ReportInstanceStatusRequest)]
   (clojure.core/when-let
    [v6196 (:start-time m6195)]
    (.
     bean6194
     setStartTime
     (com.palletops.awaze.common/to-date v6196)))
   (clojure.core/when-let
    [v6196 (:end-time m6195)]
    (. bean6194 setEndTime (com.palletops.awaze.common/to-date v6196)))
   (clojure.core/when-let
    [v6196 (:instances m6195)]
    (.
     bean6194
     setInstances
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6620] (clojure.core/str arg6620))
 v6196)))
   (clojure.core/when-let
    [v6196 (:reason-codes m6195)]
    (.
     bean6194
     setReasonCodes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6621] (clojure.core/str arg6621))
 v6196)))
   (clojure.core/when-let
    [v6196 (:status m6195)]
    (. bean6194 setStatus (clojure.core/str v6196)))
   (clojure.core/when-let
    [v6196 (:description m6195)]
    (. bean6194 setDescription (clojure.core/str v6196)))
   bean6194))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteTagsRequest}
delete-tags-request
  [m6198]
  (clojure.core/let
   [bean6197 (new com.amazonaws.services.ec2.model.DeleteTagsRequest)]
   (clojure.core/when-let
    [v6199 (:tags m6198)]
    (.
     bean6197
     setTags
^{:tag java.util.Collection}
(clojure.core/map (clojure.core/fn [arg6622] (ec2/tag arg6622)) v6199)))
   (clojure.core/when-let
    [v6199 (:resources m6198)]
    (.
     bean6197
     setResources
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6623] (clojure.core/str arg6623))
 v6199)))
   bean6197))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ResetSnapshotAttributeRequest}
reset-snapshot-attribute-request
  [m6201]
  (clojure.core/let
   [bean6200
    (new
     com.amazonaws.services.ec2.model.ResetSnapshotAttributeRequest)]
   (clojure.core/when-let
    [v6202 (:snapshot-id m6201)]
    (. bean6200 setSnapshotId (clojure.core/str v6202)))
   (clojure.core/when-let
    [v6202 (:attribute m6201)]
    (. bean6200 setAttribute (clojure.core/str v6202)))
   bean6200))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.AssociateDhcpOptionsRequest}
associate-dhcp-options-request
  [m6204]
  (clojure.core/let
   [bean6203
    (new com.amazonaws.services.ec2.model.AssociateDhcpOptionsRequest)]
   (clojure.core/when-let
    [v6205 (:vpc-id m6204)]
    (. bean6203 setVpcId (clojure.core/str v6205)))
   (clojure.core/when-let
    [v6205 (:dhcp-options-id m6204)]
    (. bean6203 setDhcpOptionsId (clojure.core/str v6205)))
   bean6203))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ModifySnapshotAttributeRequest}
modify-snapshot-attribute-request
  [m6207]
  (clojure.core/let
   [bean6206
    (new
     com.amazonaws.services.ec2.model.ModifySnapshotAttributeRequest)]
   (clojure.core/when-let
    [v6208 (:group-names m6207)]
    (.
     bean6206
     setGroupNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6624] (clojure.core/str arg6624))
 v6208)))
   (clojure.core/when-let
    [v6208 (:operation-type m6207)]
    (. bean6206 setOperationType (clojure.core/str v6208)))
   (clojure.core/when-let
    [v6208 (:user-ids m6207)]
    (.
     bean6206
     setUserIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6625] (clojure.core/str arg6625))
 v6208)))
   (clojure.core/when-let
    [v6208 (:create-volume-permission m6207)]
    (.
     bean6206
     setCreateVolumePermission
     (ec2/create-volume-permission-modifications v6208)))
   (clojure.core/when-let
    [v6208 (:snapshot-id m6207)]
    (. bean6206 setSnapshotId (clojure.core/str v6208)))
   (clojure.core/when-let
    [v6208 (:attribute m6207)]
    (. bean6206 setAttribute (ec2/snapshot-attribute-name v6208)))
   bean6206))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ModifyVolumeAttributeRequest}
modify-volume-attribute-request
  [m6210]
  (clojure.core/let
   [bean6209
    (new
     com.amazonaws.services.ec2.model.ModifyVolumeAttributeRequest)]
   (clojure.core/when-let
    [v6211 (:volume-id m6210)]
    (. bean6209 setVolumeId (clojure.core/str v6211)))
   (clojure.core/when-let
    [v6211 (:auto-enable-io m6210)]
    (. bean6209 setAutoEnableIO (clojure.core/boolean v6211)))
   bean6209))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreatePlacementGroupRequest}
create-placement-group-request
  [m6213]
  (clojure.core/let
   [bean6212
    (new com.amazonaws.services.ec2.model.CreatePlacementGroupRequest)]
   (clojure.core/when-let
    [v6214 (:group-name m6213)]
    (. bean6212 setGroupName (clojure.core/str v6214)))
   (clojure.core/when-let
    [v6214 (:strategy m6213)]
    (. bean6212 setStrategy (clojure.core/str v6214)))
   bean6212))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeVpnConnectionsRequest}
describe-vpn-connections-request
  [m6216]
  (clojure.core/let
   [bean6215
    (new
     com.amazonaws.services.ec2.model.DescribeVpnConnectionsRequest)]
   (clojure.core/when-let
    [v6217 (:filters m6216)]
    (.
     bean6215
     setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6626] (ec2/filter arg6626))
 v6217)))
   (clojure.core/when-let
    [v6217 (:vpn-connection-ids m6216)]
    (.
     bean6215
     setVpnConnectionIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6627] (clojure.core/str arg6627))
 v6217)))
   bean6215))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeSpotPriceHistoryRequest}
describe-spot-price-history-request
  [m6219]
  (clojure.core/let
   [bean6218
    (new
     com.amazonaws.services.ec2.model.DescribeSpotPriceHistoryRequest)]
   (clojure.core/when-let
    [v6220 (:availability-zone m6219)]
    (. bean6218 setAvailabilityZone (clojure.core/str v6220)))
   (clojure.core/when-let
    [v6220 (:start-time m6219)]
    (.
     bean6218
     setStartTime
     (com.palletops.awaze.common/to-date v6220)))
   (clojure.core/when-let
    [v6220 (:end-time m6219)]
    (. bean6218 setEndTime (com.palletops.awaze.common/to-date v6220)))
   (clojure.core/when-let
    [v6220 (:filters m6219)]
    (.
     bean6218
     setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6628] (ec2/filter arg6628))
 v6220)))
   (clojure.core/when-let
    [v6220 (:max-results m6219)]
    (. bean6218 setMaxResults (clojure.core/int v6220)))
   (clojure.core/when-let
    [v6220 (:instance-types m6219)]
    (.
     bean6218
     setInstanceTypes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6629] (clojure.core/str arg6629))
 v6220)))
   (clojure.core/when-let
    [v6220 (:product-descriptions m6219)]
    (.
     bean6218
     setProductDescriptions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6630] (clojure.core/str arg6630))
 v6220)))
   (clojure.core/when-let
    [v6220 (:next-token m6219)]
    (. bean6218 setNextToken (clojure.core/str v6220)))
   bean6218))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.RejectVpcPeeringConnectionRequest}
reject-vpc-peering-connection-request
  [m6222]
  (clojure.core/let
   [bean6221
    (new
     com.amazonaws.services.ec2.model.RejectVpcPeeringConnectionRequest)]
   (clojure.core/when-let
    [v6223 (:vpc-peering-connection-id m6222)]
    (. bean6221 setVpcPeeringConnectionId (clojure.core/str v6223)))
   bean6221))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteVpcRequest}
delete-vpc-request
  [m6225]
  (clojure.core/let
   [bean6224 (new com.amazonaws.services.ec2.model.DeleteVpcRequest)]
   (clojure.core/when-let
    [v6226 (:vpc-id m6225)]
    (. bean6224 setVpcId (clojure.core/str v6226)))
   bean6224))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateRouteTableRequest}
create-route-table-request
  [m6228]
  (clojure.core/let
   [bean6227
    (new com.amazonaws.services.ec2.model.CreateRouteTableRequest)]
   (clojure.core/when-let
    [v6229 (:vpc-id m6228)]
    (. bean6227 setVpcId (clojure.core/str v6229)))
   bean6227))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.TerminateInstancesRequest}
terminate-instances-request
  [m6231]
  (clojure.core/let
   [bean6230
    (new com.amazonaws.services.ec2.model.TerminateInstancesRequest)]
   (clojure.core/when-let
    [v6232 (:instance-ids m6231)]
    (.
     bean6230
     setInstanceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6631] (clojure.core/str arg6631))
 v6232)))
   bean6230))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeBundleTasksRequest}
describe-bundle-tasks-request
  [m6234]
  (clojure.core/let
   [bean6233
    (new com.amazonaws.services.ec2.model.DescribeBundleTasksRequest)]
   (clojure.core/when-let
    [v6235 (:filters m6234)]
    (.
     bean6233
     setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6632] (ec2/filter arg6632))
 v6235)))
   (clojure.core/when-let
    [v6235 (:bundle-ids m6234)]
    (.
     bean6233
     setBundleIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6633] (clojure.core/str arg6633))
 v6235)))
   bean6233))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.AssociateAddressRequest}
associate-address-request
  [m6237]
  (clojure.core/let
   [bean6236
    (new com.amazonaws.services.ec2.model.AssociateAddressRequest)]
   (clojure.core/when-let
    [v6238 (:instance-id m6237)]
    (. bean6236 setInstanceId (clojure.core/str v6238)))
   (clojure.core/when-let
    [v6238 (:private-ip-address m6237)]
    (. bean6236 setPrivateIpAddress (clojure.core/str v6238)))
   (clojure.core/when-let
    [v6238 (:public-ip m6237)]
    (. bean6236 setPublicIp (clojure.core/str v6238)))
   (clojure.core/when-let
    [v6238 (:allocation-id m6237)]
    (. bean6236 setAllocationId (clojure.core/str v6238)))
   (clojure.core/when-let
    [v6238 (:allow-reassociation m6237)]
    (. bean6236 setAllowReassociation (clojure.core/boolean v6238)))
   (clojure.core/when-let
    [v6238 (:network-interface-id m6237)]
    (. bean6236 setNetworkInterfaceId (clojure.core/str v6238)))
   bean6236))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateVolumeRequest}
create-volume-request
  [m6240]
  (clojure.core/let
   [bean6239
    (new com.amazonaws.services.ec2.model.CreateVolumeRequest)]
   (clojure.core/when-let
    [v6241 (:size m6240)]
    (. bean6239 setSize (clojure.core/int v6241)))
   (clojure.core/when-let
    [v6241 (:availability-zone m6240)]
    (. bean6239 setAvailabilityZone (clojure.core/str v6241)))
   (clojure.core/when-let
    [v6241 (:encrypted m6240)]
    (. bean6239 setEncrypted (clojure.core/boolean v6241)))
   (clojure.core/when-let
    [v6241 (:snapshot-id m6240)]
    (. bean6239 setSnapshotId (clojure.core/str v6241)))
   (clojure.core/when-let
    [v6241 (:volume-type m6240)]
    (. bean6239 setVolumeType (clojure.core/str v6241)))
   (clojure.core/when-let
    [v6241 (:iops m6240)]
    (. bean6239 setIops (clojure.core/int v6241)))
   bean6239))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ModifyReservedInstancesRequest}
modify-reserved-instances-request
  [m6243]
  (clojure.core/let
   [bean6242
    (new
     com.amazonaws.services.ec2.model.ModifyReservedInstancesRequest)]
   (clojure.core/when-let
    [v6244 (:reserved-instances-ids m6243)]
    (.
     bean6242
     setReservedInstancesIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6634] (clojure.core/str arg6634))
 v6244)))
   (clojure.core/when-let
    [v6244 (:target-configurations m6243)]
    (.
     bean6242
     setTargetConfigurations
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg6635]
  (ec2/reserved-instances-configuration arg6635))
 v6244)))
   (clojure.core/when-let
    [v6244 (:client-token m6243)]
    (. bean6242 setClientToken (clojure.core/str v6244)))
   bean6242))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeVpcAttributeRequest}
describe-vpc-attribute-request
  [m6246]
  (clojure.core/let
   [bean6245
    (new com.amazonaws.services.ec2.model.DescribeVpcAttributeRequest)]
   (clojure.core/when-let
    [v6247 (:vpc-id m6246)]
    (. bean6245 setVpcId (clojure.core/str v6247)))
   (clojure.core/when-let
    [v6247 (:attribute m6246)]
    (. bean6245 setAttribute (clojure.core/str v6247)))
   bean6245))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.AuthorizeSecurityGroupEgressRequest}
authorize-security-group-egress-request
  [m6249]
  (clojure.core/let
   [bean6248
    (new
     com.amazonaws.services.ec2.model.AuthorizeSecurityGroupEgressRequest)]
   (clojure.core/when-let
    [v6250 (:group-id m6249)]
    (. bean6248 setGroupId (clojure.core/str v6250)))
   (clojure.core/when-let
    [v6250 (:source-security-group-name m6249)]
    (. bean6248 setSourceSecurityGroupName (clojure.core/str v6250)))
   (clojure.core/when-let
    [v6250 (:source-security-group-owner-id m6249)]
    (.
     bean6248
     setSourceSecurityGroupOwnerId
     (clojure.core/str v6250)))
   (clojure.core/when-let
    [v6250 (:ip-protocol m6249)]
    (. bean6248 setIpProtocol (clojure.core/str v6250)))
   (clojure.core/when-let
    [v6250 (:from-port m6249)]
    (. bean6248 setFromPort (clojure.core/int v6250)))
   (clojure.core/when-let
    [v6250 (:to-port m6249)]
    (. bean6248 setToPort (clojure.core/int v6250)))
   (clojure.core/when-let
    [v6250 (:cidr-ip m6249)]
    (. bean6248 setCidrIp (clojure.core/str v6250)))
   (clojure.core/when-let
    [v6250 (:ip-permissions m6249)]
    (.
     bean6248
     setIpPermissions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6636] (ec2/ip-permission arg6636))
 v6250)))
   bean6248))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteCustomerGatewayRequest}
delete-customer-gateway-request
  [m6252]
  (clojure.core/let
   [bean6251
    (new
     com.amazonaws.services.ec2.model.DeleteCustomerGatewayRequest)]
   (clojure.core/when-let
    [v6253 (:customer-gateway-id m6252)]
    (. bean6251 setCustomerGatewayId (clojure.core/str v6253)))
   bean6251))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ReplaceNetworkAclEntryRequest}
replace-network-acl-entry-request
  [m6255]
  (clojure.core/let
   [bean6254
    (new
     com.amazonaws.services.ec2.model.ReplaceNetworkAclEntryRequest)]
   (clojure.core/when-let
    [v6256 (:network-acl-id m6255)]
    (. bean6254 setNetworkAclId (clojure.core/str v6256)))
   (clojure.core/when-let
    [v6256 (:rule-number m6255)]
    (. bean6254 setRuleNumber (clojure.core/int v6256)))
   (clojure.core/when-let
    [v6256 (:rule-action m6255)]
    (. bean6254 setRuleAction (ec2/rule-action v6256)))
   (clojure.core/when-let
    [v6256 (:egress m6255)]
    (. bean6254 setEgress (clojure.core/boolean v6256)))
   (clojure.core/when-let
    [v6256 (:cidr-block m6255)]
    (. bean6254 setCidrBlock (clojure.core/str v6256)))
   (clojure.core/when-let
    [v6256 (:icmp-type-code m6255)]
    (. bean6254 setIcmpTypeCode (ec2/icmp-type-code v6256)))
   (clojure.core/when-let
    [v6256 (:port-range m6255)]
    (. bean6254 setPortRange (ec2/port-range v6256)))
   (clojure.core/when-let
    [v6256 (:protocol m6255)]
    (. bean6254 setProtocol (clojure.core/str v6256)))
   bean6254))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateVpcPeeringConnectionRequest}
create-vpc-peering-connection-request
  [m6258]
  (clojure.core/let
   [bean6257
    (new
     com.amazonaws.services.ec2.model.CreateVpcPeeringConnectionRequest)]
   (clojure.core/when-let
    [v6259 (:vpc-id m6258)]
    (. bean6257 setVpcId (clojure.core/str v6259)))
   (clojure.core/when-let
    [v6259 (:peer-vpc-id m6258)]
    (. bean6257 setPeerVpcId (clojure.core/str v6259)))
   (clojure.core/when-let
    [v6259 (:peer-owner-id m6258)]
    (. bean6257 setPeerOwnerId (clojure.core/str v6259)))
   bean6257))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeSubnetsRequest}
describe-subnets-request
  [m6261]
  (clojure.core/let
   [bean6260
    (new com.amazonaws.services.ec2.model.DescribeSubnetsRequest)]
   (clojure.core/when-let
    [v6262 (:subnet-ids m6261)]
    (.
     bean6260
     setSubnetIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6637] (clojure.core/str arg6637))
 v6262)))
   (clojure.core/when-let
    [v6262 (:filters m6261)]
    (.
     bean6260
     setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6638] (ec2/filter arg6638))
 v6262)))
   bean6260))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.GetConsoleOutputRequest}
get-console-output-request
  [m6264]
  (clojure.core/let
   [bean6263
    (new com.amazonaws.services.ec2.model.GetConsoleOutputRequest)]
   (clojure.core/when-let
    [v6265 (:instance-id m6264)]
    (. bean6263 setInstanceId (clojure.core/str v6265)))
   bean6263))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CancelConversionTaskRequest}
cancel-conversion-task-request
  [m6267]
  (clojure.core/let
   [bean6266
    (new com.amazonaws.services.ec2.model.CancelConversionTaskRequest)]
   (clojure.core/when-let
    [v6268 (:conversion-task-id m6267)]
    (. bean6266 setConversionTaskId (clojure.core/str v6268)))
   (clojure.core/when-let
    [v6268 (:reason-message m6267)]
    (. bean6266 setReasonMessage (clojure.core/str v6268)))
   bean6266))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.AttachVpnGatewayRequest}
attach-vpn-gateway-request
  [m6270]
  (clojure.core/let
   [bean6269
    (new com.amazonaws.services.ec2.model.AttachVpnGatewayRequest)]
   (clojure.core/when-let
    [v6271 (:vpc-id m6270)]
    (. bean6269 setVpcId (clojure.core/str v6271)))
   (clojure.core/when-let
    [v6271 (:vpn-gateway-id m6270)]
    (. bean6269 setVpnGatewayId (clojure.core/str v6271)))
   bean6269))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeVpcPeeringConnectionsRequest}
describe-vpc-peering-connections-request
  [m6273]
  (clojure.core/let
   [bean6272
    (new
     com.amazonaws.services.ec2.model.DescribeVpcPeeringConnectionsRequest)]
   (clojure.core/when-let
    [v6274 (:filters m6273)]
    (.
     bean6272
     setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6639] (ec2/filter arg6639))
 v6274)))
   (clojure.core/when-let
    [v6274 (:vpc-peering-connection-ids m6273)]
    (.
     bean6272
     setVpcPeeringConnectionIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6640] (clojure.core/str arg6640))
 v6274)))
   bean6272))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteVpnConnectionRouteRequest}
delete-vpn-connection-route-request
  [m6276]
  (clojure.core/let
   [bean6275
    (new
     com.amazonaws.services.ec2.model.DeleteVpnConnectionRouteRequest)]
   (clojure.core/when-let
    [v6277 (:destination-cidr-block m6276)]
    (. bean6275 setDestinationCidrBlock (clojure.core/str v6277)))
   (clojure.core/when-let
    [v6277 (:vpn-connection-id m6276)]
    (. bean6275 setVpnConnectionId (clojure.core/str v6277)))
   bean6275))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.RunInstancesRequest}
run-instances-request
  [m6279]
  (clojure.core/let
   [bean6278
    (new com.amazonaws.services.ec2.model.RunInstancesRequest)]
   (clojure.core/when-let
    [v6280 (:iam-instance-profile m6279)]
    (.
     bean6278
     setIamInstanceProfile
     (ec2/iam-instance-profile-specification v6280)))
   (clojure.core/when-let
    [v6280 (:placement m6279)]
    (. bean6278 setPlacement (ec2/placement v6280)))
   (clojure.core/when-let
    [v6280 (:block-device-mappings m6279)]
    (.
     bean6278
     setBlockDeviceMappings
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6641] (ec2/block-device-mapping arg6641))
 v6280)))
   (clojure.core/when-let
    [v6280 (:network-interfaces m6279)]
    (.
     bean6278
     setNetworkInterfaces
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg6642]
  (ec2/instance-network-interface-specification arg6642))
 v6280)))
   (clojure.core/when-let
    [v6280 (:key-name m6279)]
    (. bean6278 setKeyName (clojure.core/str v6280)))
   (clojure.core/when-let
    [v6280 (:monitoring m6279)]
    (. bean6278 setMonitoring (clojure.core/boolean v6280)))
   (clojure.core/when-let
    [v6280 (:private-ip-address m6279)]
    (. bean6278 setPrivateIpAddress (clojure.core/str v6280)))
   (clojure.core/when-let
    [v6280 (:client-token m6279)]
    (. bean6278 setClientToken (clojure.core/str v6280)))
   (clojure.core/when-let
    [v6280 (:max-count m6279)]
    (. bean6278 setMaxCount (clojure.core/int v6280)))
   (clojure.core/when-let
    [v6280 (:disable-api-termination m6279)]
    (. bean6278 setDisableApiTermination (clojure.core/boolean v6280)))
   (clojure.core/when-let
    [v6280 (:instance-type m6279)]
    (. bean6278 setInstanceType (clojure.core/str v6280)))
   (clojure.core/when-let
    [v6280 (:ebs-optimized m6279)]
    (. bean6278 setEbsOptimized (clojure.core/boolean v6280)))
   (clojure.core/when-let
    [v6280 (:image-id m6279)]
    (. bean6278 setImageId (clojure.core/str v6280)))
   (clojure.core/when-let
    [v6280 (:ramdisk-id m6279)]
    (. bean6278 setRamdiskId (clojure.core/str v6280)))
   (clojure.core/when-let
    [v6280 (:security-groups m6279)]
    (.
     bean6278
     setSecurityGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6643] (clojure.core/str arg6643))
 v6280)))
   (clojure.core/when-let
    [v6280 (:user-data m6279)]
    (. bean6278 setUserData (clojure.core/str v6280)))
   (clojure.core/when-let
    [v6280 (:additional-info m6279)]
    (. bean6278 setAdditionalInfo (clojure.core/str v6280)))
   (clojure.core/when-let
    [v6280 (:kernel-id m6279)]
    (. bean6278 setKernelId (clojure.core/str v6280)))
   (clojure.core/when-let
    [v6280 (:subnet-id m6279)]
    (. bean6278 setSubnetId (clojure.core/str v6280)))
   (clojure.core/when-let
    [v6280 (:security-group-ids m6279)]
    (.
     bean6278
     setSecurityGroupIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6644] (clojure.core/str arg6644))
 v6280)))
   (clojure.core/when-let
    [v6280 (:instance-initiated-shutdown-behavior m6279)]
    (.
     bean6278
     setInstanceInitiatedShutdownBehavior
     (ec2/shutdown-behavior v6280)))
   (clojure.core/when-let
    [v6280 (:min-count m6279)]
    (. bean6278 setMinCount (clojure.core/int v6280)))
   bean6278))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.RegisterImageRequest}
register-image-request
  [m6282]
  (clojure.core/let
   [bean6281
    (new com.amazonaws.services.ec2.model.RegisterImageRequest)]
   (clojure.core/when-let
    [v6283 (:sriov-net-support m6282)]
    (. bean6281 setSriovNetSupport (clojure.core/str v6283)))
   (clojure.core/when-let
    [v6283 (:root-device-name m6282)]
    (. bean6281 setRootDeviceName (clojure.core/str v6283)))
   (clojure.core/when-let
    [v6283 (:block-device-mappings m6282)]
    (.
     bean6281
     setBlockDeviceMappings
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6645] (ec2/block-device-mapping arg6645))
 v6283)))
   (clojure.core/when-let
    [v6283 (:name m6282)]
    (. bean6281 setName (clojure.core/str v6283)))
   (clojure.core/when-let
    [v6283 (:image-location m6282)]
    (. bean6281 setImageLocation (clojure.core/str v6283)))
   (clojure.core/when-let
    [v6283 (:ramdisk-id m6282)]
    (. bean6281 setRamdiskId (clojure.core/str v6283)))
   (clojure.core/when-let
    [v6283 (:virtualization-type m6282)]
    (. bean6281 setVirtualizationType (clojure.core/str v6283)))
   (clojure.core/when-let
    [v6283 (:architecture m6282)]
    (. bean6281 setArchitecture (clojure.core/str v6283)))
   (clojure.core/when-let
    [v6283 (:kernel-id m6282)]
    (. bean6281 setKernelId (clojure.core/str v6283)))
   (clojure.core/when-let
    [v6283 (:description m6282)]
    (. bean6281 setDescription (clojure.core/str v6283)))
   bean6281))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeTagsRequest}
describe-tags-request
  [m6285]
  (clojure.core/let
   [bean6284
    (new com.amazonaws.services.ec2.model.DescribeTagsRequest)]
   (clojure.core/when-let
    [v6286 (:filters m6285)]
    (.
     bean6284
     setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6646] (ec2/filter arg6646))
 v6286)))
   (clojure.core/when-let
    [v6286 (:max-results m6285)]
    (. bean6284 setMaxResults (clojure.core/int v6286)))
   (clojure.core/when-let
    [v6286 (:next-token m6285)]
    (. bean6284 setNextToken (clojure.core/str v6286)))
   bean6284))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeReservedInstancesRequest}
describe-reserved-instances-request
  [m6288]
  (clojure.core/let
   [bean6287
    (new
     com.amazonaws.services.ec2.model.DescribeReservedInstancesRequest)]
   (clojure.core/when-let
    [v6289 (:offering-type m6288)]
    (. bean6287 setOfferingType (ec2/offering-type-values v6289)))
   (clojure.core/when-let
    [v6289 (:filters m6288)]
    (.
     bean6287
     setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6647] (ec2/filter arg6647))
 v6289)))
   (clojure.core/when-let
    [v6289 (:reserved-instances-ids m6288)]
    (.
     bean6287
     setReservedInstancesIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6648] (clojure.core/str arg6648))
 v6289)))
   bean6287))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DetachVpnGatewayRequest}
detach-vpn-gateway-request
  [m6291]
  (clojure.core/let
   [bean6290
    (new com.amazonaws.services.ec2.model.DetachVpnGatewayRequest)]
   (clojure.core/when-let
    [v6292 (:vpc-id m6291)]
    (. bean6290 setVpcId (clojure.core/str v6292)))
   (clojure.core/when-let
    [v6292 (:vpn-gateway-id m6291)]
    (. bean6290 setVpnGatewayId (clojure.core/str v6292)))
   bean6290))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeCustomerGatewaysRequest}
describe-customer-gateways-request
  [m6294]
  (clojure.core/let
   [bean6293
    (new
     com.amazonaws.services.ec2.model.DescribeCustomerGatewaysRequest)]
   (clojure.core/when-let
    [v6295 (:filters m6294)]
    (.
     bean6293
     setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6649] (ec2/filter arg6649))
 v6295)))
   (clojure.core/when-let
    [v6295 (:customer-gateway-ids m6294)]
    (.
     bean6293
     setCustomerGatewayIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6650] (clojure.core/str arg6650))
 v6295)))
   bean6293))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeNetworkInterfaceAttributeRequest}
describe-network-interface-attribute-request
  [m6297]
  (clojure.core/let
   [bean6296
    (new
     com.amazonaws.services.ec2.model.DescribeNetworkInterfaceAttributeRequest)]
   (clojure.core/when-let
    [v6298 (:groups m6297)]
    (. bean6296 setGroups (clojure.core/str v6298)))
   (clojure.core/when-let
    [v6298 (:source-dest-check m6297)]
    (. bean6296 setSourceDestCheck (clojure.core/str v6298)))
   (clojure.core/when-let
    [v6298 (:attachment m6297)]
    (. bean6296 setAttachment (clojure.core/str v6298)))
   (clojure.core/when-let
    [v6298 (:description m6297)]
    (. bean6296 setDescription (clojure.core/str v6298)))
   (clojure.core/when-let
    [v6298 (:network-interface-id m6297)]
    (. bean6296 setNetworkInterfaceId (clojure.core/str v6298)))
   bean6296))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ImportKeyPairRequest}
import-key-pair-request
  [m6300]
  (clojure.core/let
   [bean6299
    (new com.amazonaws.services.ec2.model.ImportKeyPairRequest)]
   (clojure.core/when-let
    [v6301 (:key-name m6300)]
    (. bean6299 setKeyName (clojure.core/str v6301)))
   (clojure.core/when-let
    [v6301 (:public-key-material m6300)]
    (. bean6299 setPublicKeyMaterial (clojure.core/str v6301)))
   bean6299))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ImportInstanceRequest}
import-instance-request
  [m6303]
  (clojure.core/let
   [bean6302
    (new com.amazonaws.services.ec2.model.ImportInstanceRequest)]
   (clojure.core/when-let
    [v6304 (:launch-specification m6303)]
    (.
     bean6302
     setLaunchSpecification
     (ec2/import-instance-launch-specification v6304)))
   (clojure.core/when-let
    [v6304 (:disk-images m6303)]
    (.
     bean6302
     setDiskImages
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6651] (ec2/disk-image arg6651))
 v6304)))
   (clojure.core/when-let
    [v6304 (:description m6303)]
    (. bean6302 setDescription (clojure.core/str v6304)))
   (clojure.core/when-let
    [v6304 (:platform m6303)]
    (. bean6302 setPlatform (clojure.core/str v6304)))
   bean6302))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.AllocateAddressRequest}
allocate-address-request
  [m6306]
  (clojure.core/let
   [bean6305
    (new com.amazonaws.services.ec2.model.AllocateAddressRequest)]
   (clojure.core/when-let
    [v6307 (:domain m6306)]
    (. bean6305 setDomain (clojure.core/str v6307)))
   bean6305))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeSpotInstanceRequestsRequest}
describe-spot-instance-requests-request
  [m6309]
  (clojure.core/let
   [bean6308
    (new
     com.amazonaws.services.ec2.model.DescribeSpotInstanceRequestsRequest)]
   (clojure.core/when-let
    [v6310 (:filters m6309)]
    (.
     bean6308
     setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6652] (ec2/filter arg6652))
 v6310)))
   (clojure.core/when-let
    [v6310 (:spot-instance-request-ids m6309)]
    (.
     bean6308
     setSpotInstanceRequestIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6653] (clojure.core/str arg6653))
 v6310)))
   bean6308))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteSpotDatafeedSubscriptionRequest}
delete-spot-datafeed-subscription-request
  [m6312]
  (clojure.core/let
   [bean6311
    (new
     com.amazonaws.services.ec2.model.DeleteSpotDatafeedSubscriptionRequest)]
   bean6311))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeConversionTasksRequest}
describe-conversion-tasks-request
  [m6315]
  (clojure.core/let
   [bean6314
    (new
     com.amazonaws.services.ec2.model.DescribeConversionTasksRequest)]
   (clojure.core/when-let
    [v6316 (:filters m6315)]
    (.
     bean6314
     setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6654] (ec2/filter arg6654))
 v6316)))
   (clojure.core/when-let
    [v6316 (:conversion-task-ids m6315)]
    (.
     bean6314
     setConversionTaskIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6655] (clojure.core/str arg6655))
 v6316)))
   bean6314))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ReplaceRouteTableAssociationRequest}
replace-route-table-association-request
  [m6318]
  (clojure.core/let
   [bean6317
    (new
     com.amazonaws.services.ec2.model.ReplaceRouteTableAssociationRequest)]
   (clojure.core/when-let
    [v6319 (:route-table-id m6318)]
    (. bean6317 setRouteTableId (clojure.core/str v6319)))
   (clojure.core/when-let
    [v6319 (:association-id m6318)]
    (. bean6317 setAssociationId (clojure.core/str v6319)))
   bean6317))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteSubnetRequest}
delete-subnet-request
  [m6321]
  (clojure.core/let
   [bean6320
    (new com.amazonaws.services.ec2.model.DeleteSubnetRequest)]
   (clojure.core/when-let
    [v6322 (:subnet-id m6321)]
    (. bean6320 setSubnetId (clojure.core/str v6322)))
   bean6320))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ModifyVpcAttributeRequest}
modify-vpc-attribute-request
  [m6324]
  (clojure.core/let
   [bean6323
    (new com.amazonaws.services.ec2.model.ModifyVpcAttributeRequest)]
   (clojure.core/when-let
    [v6325 (:vpc-id m6324)]
    (. bean6323 setVpcId (clojure.core/str v6325)))
   (clojure.core/when-let
    [v6325 (:enable-dns-support m6324)]
    (. bean6323 setEnableDnsSupport (clojure.core/boolean v6325)))
   (clojure.core/when-let
    [v6325 (:enable-dns-hostnames m6324)]
    (. bean6323 setEnableDnsHostnames (clojure.core/boolean v6325)))
   bean6323))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DetachInternetGatewayRequest}
detach-internet-gateway-request
  [m6327]
  (clojure.core/let
   [bean6326
    (new
     com.amazonaws.services.ec2.model.DetachInternetGatewayRequest)]
   (clojure.core/when-let
    [v6328 (:vpc-id m6327)]
    (. bean6326 setVpcId (clojure.core/str v6328)))
   (clojure.core/when-let
    [v6328 (:internet-gateway-id m6327)]
    (. bean6326 setInternetGatewayId (clojure.core/str v6328)))
   bean6326))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeReservedInstancesModificationsRequest}
describe-reserved-instances-modifications-request
  [m6330]
  (clojure.core/let
   [bean6329
    (new
     com.amazonaws.services.ec2.model.DescribeReservedInstancesModificationsRequest)]
   (clojure.core/when-let
    [v6331 (:filters m6330)]
    (.
     bean6329
     setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6656] (ec2/filter arg6656))
 v6331)))
   (clojure.core/when-let
    [v6331 (:reserved-instances-modification-ids m6330)]
    (.
     bean6329
     setReservedInstancesModificationIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6657] (clojure.core/str arg6657))
 v6331)))
   (clojure.core/when-let
    [v6331 (:next-token m6330)]
    (. bean6329 setNextToken (clojure.core/str v6331)))
   bean6329))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.GetPasswordDataRequest}
get-password-data-request
  [m6333]
  (clojure.core/let
   [bean6332
    (new com.amazonaws.services.ec2.model.GetPasswordDataRequest)]
   (clojure.core/when-let
    [v6334 (:instance-id m6333)]
    (. bean6332 setInstanceId (clojure.core/str v6334)))
   bean6332))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.UnassignPrivateIpAddressesRequest}
unassign-private-ip-addresses-request
  [m6336]
  (clojure.core/let
   [bean6335
    (new
     com.amazonaws.services.ec2.model.UnassignPrivateIpAddressesRequest)]
   (clojure.core/when-let
    [v6337 (:private-ip-addresses m6336)]
    (.
     bean6335
     setPrivateIpAddresses
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6658] (clojure.core/str arg6658))
 v6337)))
   (clojure.core/when-let
    [v6337 (:network-interface-id m6336)]
    (. bean6335 setNetworkInterfaceId (clojure.core/str v6337)))
   bean6335))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ModifyNetworkInterfaceAttributeRequest}
modify-network-interface-attribute-request
  [m6339]
  (clojure.core/let
   [bean6338
    (new
     com.amazonaws.services.ec2.model.ModifyNetworkInterfaceAttributeRequest)]
   (clojure.core/when-let
    [v6340 (:groups m6339)]
    (.
     bean6338
     setGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6659] (clojure.core/str arg6659))
 v6340)))
   (clojure.core/when-let
    [v6340 (:source-dest-check m6339)]
    (. bean6338 setSourceDestCheck (clojure.core/boolean v6340)))
   (clojure.core/when-let
    [v6340 (:attachment m6339)]
    (.
     bean6338
     setAttachment
     (ec2/network-interface-attachment-changes v6340)))
   (clojure.core/when-let
    [v6340 (:description m6339)]
    (. bean6338 setDescription (clojure.core/str v6340)))
   (clojure.core/when-let
    [v6340 (:network-interface-id m6339)]
    (. bean6338 setNetworkInterfaceId (clojure.core/str v6340)))
   bean6338))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ResetNetworkInterfaceAttributeRequest}
reset-network-interface-attribute-request
  [m6342]
  (clojure.core/let
   [bean6341
    (new
     com.amazonaws.services.ec2.model.ResetNetworkInterfaceAttributeRequest)]
   (clojure.core/when-let
    [v6343 (:source-dest-check m6342)]
    (. bean6341 setSourceDestCheck (clojure.core/str v6343)))
   (clojure.core/when-let
    [v6343 (:network-interface-id m6342)]
    (. bean6341 setNetworkInterfaceId (clojure.core/str v6343)))
   bean6341))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeVpcsRequest}
describe-vpcs-request
  [m6345]
  (clojure.core/let
   [bean6344
    (new com.amazonaws.services.ec2.model.DescribeVpcsRequest)]
   (clojure.core/when-let
    [v6346 (:filters m6345)]
    (.
     bean6344
     setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6660] (ec2/filter arg6660))
 v6346)))
   (clojure.core/when-let
    [v6346 (:vpc-ids m6345)]
    (.
     bean6344
     setVpcIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6661] (clojure.core/str arg6661))
 v6346)))
   bean6344))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.RebootInstancesRequest}
reboot-instances-request
  [m6348]
  (clojure.core/let
   [bean6347
    (new com.amazonaws.services.ec2.model.RebootInstancesRequest)]
   (clojure.core/when-let
    [v6349 (:instance-ids m6348)]
    (.
     bean6347
     setInstanceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6662] (clojure.core/str arg6662))
 v6349)))
   bean6347))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeVolumeAttributeRequest}
describe-volume-attribute-request
  [m6351]
  (clojure.core/let
   [bean6350
    (new
     com.amazonaws.services.ec2.model.DescribeVolumeAttributeRequest)]
   (clojure.core/when-let
    [v6352 (:volume-id m6351)]
    (. bean6350 setVolumeId (clojure.core/str v6352)))
   (clojure.core/when-let
    [v6352 (:attribute m6351)]
    (. bean6350 setAttribute (clojure.core/str v6352)))
   bean6350))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ModifyInstanceAttributeRequest}
modify-instance-attribute-request
  [m6354]
  (clojure.core/let
   [bean6353
    (new
     com.amazonaws.services.ec2.model.ModifyInstanceAttributeRequest)]
   (clojure.core/when-let
    [v6355 (:sriov-net-support m6354)]
    (. bean6353 setSriovNetSupport (clojure.core/str v6355)))
   (clojure.core/when-let
    [v6355 (:block-device-mappings m6354)]
    (.
     bean6353
     setBlockDeviceMappings
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg6663]
  (ec2/instance-block-device-mapping-specification arg6663))
 v6355)))
   (clojure.core/when-let
    [v6355 (:source-dest-check m6354)]
    (. bean6353 setSourceDestCheck (clojure.core/boolean v6355)))
   (clojure.core/when-let
    [v6355 (:value m6354)]
    (. bean6353 setValue (clojure.core/str v6355)))
   (clojure.core/when-let
    [v6355 (:disable-api-termination m6354)]
    (. bean6353 setDisableApiTermination (clojure.core/boolean v6355)))
   (clojure.core/when-let
    [v6355 (:instance-type m6354)]
    (. bean6353 setInstanceType (clojure.core/str v6355)))
   (clojure.core/when-let
    [v6355 (:instance-id m6354)]
    (. bean6353 setInstanceId (clojure.core/str v6355)))
   (clojure.core/when-let
    [v6355 (:ebs-optimized m6354)]
    (. bean6353 setEbsOptimized (clojure.core/boolean v6355)))
   (clojure.core/when-let
    [v6355 (:groups m6354)]
    (.
     bean6353
     setGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6664] (clojure.core/str arg6664))
 v6355)))
   (clojure.core/when-let
    [v6355 (:user-data m6354)]
    (. bean6353 setUserData (clojure.core/str v6355)))
   (clojure.core/when-let
    [v6355 (:ramdisk m6354)]
    (. bean6353 setRamdisk (clojure.core/str v6355)))
   (clojure.core/when-let
    [v6355 (:attribute m6354)]
    (. bean6353 setAttribute (ec2/instance-attribute-name v6355)))
   (clojure.core/when-let
    [v6355 (:instance-initiated-shutdown-behavior m6354)]
    (.
     bean6353
     setInstanceInitiatedShutdownBehavior
     (clojure.core/str v6355)))
   (clojure.core/when-let
    [v6355 (:kernel m6354)]
    (. bean6353 setKernel (clojure.core/str v6355)))
   bean6353))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteKeyPairRequest}
delete-key-pair-request
  [m6357]
  (clojure.core/let
   [bean6356
    (new com.amazonaws.services.ec2.model.DeleteKeyPairRequest)]
   (clojure.core/when-let
    [v6358 (:key-name m6357)]
    (. bean6356 setKeyName (clojure.core/str v6358)))
   bean6356))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.EnableVgwRoutePropagationRequest}
enable-vgw-route-propagation-request
  [m6360]
  (clojure.core/let
   [bean6359
    (new
     com.amazonaws.services.ec2.model.EnableVgwRoutePropagationRequest)]
   (clojure.core/when-let
    [v6361 (:route-table-id m6360)]
    (. bean6359 setRouteTableId (clojure.core/str v6361)))
   (clojure.core/when-let
    [v6361 (:gateway-id m6360)]
    (. bean6359 setGatewayId (clojure.core/str v6361)))
   bean6359))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.BundleInstanceRequest}
bundle-instance-request
  [m6363]
  (clojure.core/let
   [bean6362
    (new com.amazonaws.services.ec2.model.BundleInstanceRequest)]
   (clojure.core/when-let
    [v6364 (:instance-id m6363)]
    (. bean6362 setInstanceId (clojure.core/str v6364)))
   (clojure.core/when-let
    [v6364 (:storage m6363)]
    (. bean6362 setStorage (ec2/storage v6364)))
   bean6362))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateInternetGatewayRequest}
create-internet-gateway-request
  [m6366]
  (clojure.core/let
   [bean6365
    (new
     com.amazonaws.services.ec2.model.CreateInternetGatewayRequest)]
   bean6365))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeVolumeStatusRequest}
describe-volume-status-request
  [m6369]
  (clojure.core/let
   [bean6368
    (new com.amazonaws.services.ec2.model.DescribeVolumeStatusRequest)]
   (clojure.core/when-let
    [v6370 (:filters m6369)]
    (.
     bean6368
     setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6665] (ec2/filter arg6665))
 v6370)))
   (clojure.core/when-let
    [v6370 (:max-results m6369)]
    (. bean6368 setMaxResults (clojure.core/int v6370)))
   (clojure.core/when-let
    [v6370 (:volume-ids m6369)]
    (.
     bean6368
     setVolumeIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6666] (clojure.core/str arg6666))
 v6370)))
   (clojure.core/when-let
    [v6370 (:next-token m6369)]
    (. bean6368 setNextToken (clojure.core/str v6370)))
   bean6368))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CopyImageRequest}
copy-image-request
  [m6372]
  (clojure.core/let
   [bean6371 (new com.amazonaws.services.ec2.model.CopyImageRequest)]
   (clojure.core/when-let
    [v6373 (:name m6372)]
    (. bean6371 setName (clojure.core/str v6373)))
   (clojure.core/when-let
    [v6373 (:source-region m6372)]
    (. bean6371 setSourceRegion (clojure.core/str v6373)))
   (clojure.core/when-let
    [v6373 (:source-image-id m6372)]
    (. bean6371 setSourceImageId (clojure.core/str v6373)))
   (clojure.core/when-let
    [v6373 (:description m6372)]
    (. bean6371 setDescription (clojure.core/str v6373)))
   (clojure.core/when-let
    [v6373 (:client-token m6372)]
    (. bean6371 setClientToken (clojure.core/str v6373)))
   bean6371))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeKeyPairsRequest}
describe-key-pairs-request
  [m6375]
  (clojure.core/let
   [bean6374
    (new com.amazonaws.services.ec2.model.DescribeKeyPairsRequest)]
   (clojure.core/when-let
    [v6376 (:filters m6375)]
    (.
     bean6374
     setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6667] (ec2/filter arg6667))
 v6376)))
   (clojure.core/when-let
    [v6376 (:key-names m6375)]
    (.
     bean6374
     setKeyNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6668] (clojure.core/str arg6668))
 v6376)))
   bean6374))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.AcceptVpcPeeringConnectionRequest}
accept-vpc-peering-connection-request
  [m6378]
  (clojure.core/let
   [bean6377
    (new
     com.amazonaws.services.ec2.model.AcceptVpcPeeringConnectionRequest)]
   (clojure.core/when-let
    [v6379 (:vpc-peering-connection-id m6378)]
    (. bean6377 setVpcPeeringConnectionId (clojure.core/str v6379)))
   bean6377))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteNetworkAclEntryRequest}
delete-network-acl-entry-request
  [m6381]
  (clojure.core/let
   [bean6380
    (new
     com.amazonaws.services.ec2.model.DeleteNetworkAclEntryRequest)]
   (clojure.core/when-let
    [v6382 (:network-acl-id m6381)]
    (. bean6380 setNetworkAclId (clojure.core/str v6382)))
   (clojure.core/when-let
    [v6382 (:rule-number m6381)]
    (. bean6380 setRuleNumber (clojure.core/int v6382)))
   (clojure.core/when-let
    [v6382 (:egress m6381)]
    (. bean6380 setEgress (clojure.core/boolean v6382)))
   bean6380))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.PurchaseReservedInstancesOfferingRequest}
purchase-reserved-instances-offering-request
  [m6384]
  (clojure.core/let
   [bean6383
    (new
     com.amazonaws.services.ec2.model.PurchaseReservedInstancesOfferingRequest)]
   (clojure.core/when-let
    [v6385 (:instance-count m6384)]
    (. bean6383 setInstanceCount (clojure.core/int v6385)))
   (clojure.core/when-let
    [v6385 (:reserved-instances-offering-id m6384)]
    (.
     bean6383
     setReservedInstancesOfferingId
     (clojure.core/str v6385)))
   (clojure.core/when-let
    [v6385 (:limit-price m6384)]
    (.
     bean6383
     setLimitPrice
     (ec2/reserved-instance-limit-price v6385)))
   bean6383))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CancelReservedInstancesListingRequest}
cancel-reserved-instances-listing-request
  [m6387]
  (clojure.core/let
   [bean6386
    (new
     com.amazonaws.services.ec2.model.CancelReservedInstancesListingRequest)]
   (clojure.core/when-let
    [v6388 (:reserved-instances-listing-id m6387)]
    (.
     bean6386
     setReservedInstancesListingId
     (clojure.core/str v6388)))
   bean6386))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.RevokeSecurityGroupEgressRequest}
revoke-security-group-egress-request
  [m6390]
  (clojure.core/let
   [bean6389
    (new
     com.amazonaws.services.ec2.model.RevokeSecurityGroupEgressRequest)]
   (clojure.core/when-let
    [v6391 (:group-id m6390)]
    (. bean6389 setGroupId (clojure.core/str v6391)))
   (clojure.core/when-let
    [v6391 (:source-security-group-name m6390)]
    (. bean6389 setSourceSecurityGroupName (clojure.core/str v6391)))
   (clojure.core/when-let
    [v6391 (:source-security-group-owner-id m6390)]
    (.
     bean6389
     setSourceSecurityGroupOwnerId
     (clojure.core/str v6391)))
   (clojure.core/when-let
    [v6391 (:ip-protocol m6390)]
    (. bean6389 setIpProtocol (clojure.core/str v6391)))
   (clojure.core/when-let
    [v6391 (:from-port m6390)]
    (. bean6389 setFromPort (clojure.core/int v6391)))
   (clojure.core/when-let
    [v6391 (:to-port m6390)]
    (. bean6389 setToPort (clojure.core/int v6391)))
   (clojure.core/when-let
    [v6391 (:cidr-ip m6390)]
    (. bean6389 setCidrIp (clojure.core/str v6391)))
   (clojure.core/when-let
    [v6391 (:ip-permissions m6390)]
    (.
     bean6389
     setIpPermissions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6669] (ec2/ip-permission arg6669))
 v6391)))
   bean6389))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateSpotDatafeedSubscriptionRequest}
create-spot-datafeed-subscription-request
  [m6393]
  (clojure.core/let
   [bean6392
    (new
     com.amazonaws.services.ec2.model.CreateSpotDatafeedSubscriptionRequest)]
   (clojure.core/when-let
    [v6394 (:bucket m6393)]
    (. bean6392 setBucket (clojure.core/str v6394)))
   (clojure.core/when-let
    [v6394 (:prefix m6393)]
    (. bean6392 setPrefix (clojure.core/str v6394)))
   bean6392))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.EnableVolumeIORequest}
enable-volume-iorequest
  [m6396]
  (clojure.core/let
   [bean6395
    (new com.amazonaws.services.ec2.model.EnableVolumeIORequest)]
   (clojure.core/when-let
    [v6397 (:volume-id m6396)]
    (. bean6395 setVolumeId (clojure.core/str v6397)))
   bean6395))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ReplaceNetworkAclAssociationRequest}
replace-network-acl-association-request
  [m6399]
  (clojure.core/let
   [bean6398
    (new
     com.amazonaws.services.ec2.model.ReplaceNetworkAclAssociationRequest)]
   (clojure.core/when-let
    [v6400 (:network-acl-id m6399)]
    (. bean6398 setNetworkAclId (clojure.core/str v6400)))
   (clojure.core/when-let
    [v6400 (:association-id m6399)]
    (. bean6398 setAssociationId (clojure.core/str v6400)))
   bean6398))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteVpcPeeringConnectionRequest}
delete-vpc-peering-connection-request
  [m6402]
  (clojure.core/let
   [bean6401
    (new
     com.amazonaws.services.ec2.model.DeleteVpcPeeringConnectionRequest)]
   (clojure.core/when-let
    [v6403 (:vpc-peering-connection-id m6402)]
    (. bean6401 setVpcPeeringConnectionId (clojure.core/str v6403)))
   bean6401))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CopySnapshotRequest}
copy-snapshot-request
  [m6405]
  (clojure.core/let
   [bean6404
    (new com.amazonaws.services.ec2.model.CopySnapshotRequest)]
   (clojure.core/when-let
    [v6406 (:destination-region m6405)]
    (. bean6404 setDestinationRegion (clojure.core/str v6406)))
   (clojure.core/when-let
    [v6406 (:source-region m6405)]
    (. bean6404 setSourceRegion (clojure.core/str v6406)))
   (clojure.core/when-let
    [v6406 (:source-snapshot-id m6405)]
    (. bean6404 setSourceSnapshotId (clojure.core/str v6406)))
   (clojure.core/when-let
    [v6406 (:presigned-url m6405)]
    (. bean6404 setPresignedUrl (clojure.core/str v6406)))
   (clojure.core/when-let
    [v6406 (:description m6405)]
    (. bean6404 setDescription (clojure.core/str v6406)))
   bean6404))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateCustomerGatewayRequest}
create-customer-gateway-request
  [m6408]
  (clojure.core/let
   [bean6407
    (new
     com.amazonaws.services.ec2.model.CreateCustomerGatewayRequest)]
   (clojure.core/when-let
    [v6409 (:public-ip m6408)]
    (. bean6407 setPublicIp (clojure.core/str v6409)))
   (clojure.core/when-let
    [v6409 (:bgp-asn m6408)]
    (. bean6407 setBgpAsn (clojure.core/int v6409)))
   (clojure.core/when-let
    [v6409 (:type m6408)]
    (. bean6407 setType (clojure.core/str v6409)))
   bean6407))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeReservedInstancesOfferingsRequest}
describe-reserved-instances-offerings-request
  [m6411]
  (clojure.core/let
   [bean6410
    (new
     com.amazonaws.services.ec2.model.DescribeReservedInstancesOfferingsRequest)]
   (clojure.core/when-let
    [v6412 (:offering-type m6411)]
    (. bean6410 setOfferingType (ec2/offering-type-values v6412)))
   (clojure.core/when-let
    [v6412 (:min-duration m6411)]
    (. bean6410 setMinDuration (clojure.core/long v6412)))
   (clojure.core/when-let
    [v6412 (:next-token m6411)]
    (. bean6410 setNextToken (clojure.core/str v6412)))
   (clojure.core/when-let
    [v6412 (:include-marketplace m6411)]
    (. bean6410 setIncludeMarketplace (clojure.core/boolean v6412)))
   (clojure.core/when-let
    [v6412 (:availability-zone m6411)]
    (. bean6410 setAvailabilityZone (clojure.core/str v6412)))
   (clojure.core/when-let
    [v6412 (:instance-tenancy m6411)]
    (. bean6410 setInstanceTenancy (clojure.core/str v6412)))
   (clojure.core/when-let
    [v6412 (:product-description m6411)]
    (.
     bean6410
     setProductDescription
     (ec2/riproduct-description v6412)))
   (clojure.core/when-let
    [v6412 (:instance-type m6411)]
    (. bean6410 setInstanceType (clojure.core/str v6412)))
   (clojure.core/when-let
    [v6412 (:max-results m6411)]
    (. bean6410 setMaxResults (clojure.core/int v6412)))
   (clojure.core/when-let
    [v6412 (:max-duration m6411)]
    (. bean6410 setMaxDuration (clojure.core/long v6412)))
   (clojure.core/when-let
    [v6412 (:max-instance-count m6411)]
    (. bean6410 setMaxInstanceCount (clojure.core/int v6412)))
   (clojure.core/when-let
    [v6412 (:filters m6411)]
    (.
     bean6410
     setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6670] (ec2/filter arg6670))
 v6412)))
   (clojure.core/when-let
    [v6412 (:reserved-instances-offering-ids m6411)]
    (.
     bean6410
     setReservedInstancesOfferingIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6671] (clojure.core/str arg6671))
 v6412)))
   bean6410))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CancelBundleTaskRequest}
cancel-bundle-task-request
  [m6414]
  (clojure.core/let
   [bean6413
    (new com.amazonaws.services.ec2.model.CancelBundleTaskRequest)]
   (clojure.core/when-let
    [v6415 (:bundle-id m6414)]
    (. bean6413 setBundleId (clojure.core/str v6415)))
   bean6413))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeImagesRequest}
describe-images-request
  [m6417]
  (clojure.core/let
   [bean6416
    (new com.amazonaws.services.ec2.model.DescribeImagesRequest)]
   (clojure.core/when-let
    [v6418 (:filters m6417)]
    (.
     bean6416
     setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6672] (ec2/filter arg6672))
 v6418)))
   (clojure.core/when-let
    [v6418 (:image-ids m6417)]
    (.
     bean6416
     setImageIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6673] (clojure.core/str arg6673))
 v6418)))
   (clojure.core/when-let
    [v6418 (:owners m6417)]
    (.
     bean6416
     setOwners
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6674] (clojure.core/str arg6674))
 v6418)))
   (clojure.core/when-let
    [v6418 (:executable-users m6417)]
    (.
     bean6416
     setExecutableUsers
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6675] (clojure.core/str arg6675))
 v6418)))
   bean6416))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeDhcpOptionsRequest}
describe-dhcp-options-request
  [m6420]
  (clojure.core/let
   [bean6419
    (new com.amazonaws.services.ec2.model.DescribeDhcpOptionsRequest)]
   (clojure.core/when-let
    [v6421 (:filters m6420)]
    (.
     bean6419
     setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6676] (ec2/filter arg6676))
 v6421)))
   (clojure.core/when-let
    [v6421 (:dhcp-options-ids m6420)]
    (.
     bean6419
     setDhcpOptionsIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6677] (clojure.core/str arg6677))
 v6421)))
   bean6419))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteVpnConnectionRequest}
delete-vpn-connection-request
  [m6423]
  (clojure.core/let
   [bean6422
    (new com.amazonaws.services.ec2.model.DeleteVpnConnectionRequest)]
   (clojure.core/when-let
    [v6424 (:vpn-connection-id m6423)]
    (. bean6422 setVpnConnectionId (clojure.core/str v6424)))
   bean6422))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateVpnConnectionRouteRequest}
create-vpn-connection-route-request
  [m6426]
  (clojure.core/let
   [bean6425
    (new
     com.amazonaws.services.ec2.model.CreateVpnConnectionRouteRequest)]
   (clojure.core/when-let
    [v6427 (:destination-cidr-block m6426)]
    (. bean6425 setDestinationCidrBlock (clojure.core/str v6427)))
   (clojure.core/when-let
    [v6427 (:vpn-connection-id m6426)]
    (. bean6425 setVpnConnectionId (clojure.core/str v6427)))
   bean6425))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateKeyPairRequest}
create-key-pair-request
  [m6429]
  (clojure.core/let
   [bean6428
    (new com.amazonaws.services.ec2.model.CreateKeyPairRequest)]
   (clojure.core/when-let
    [v6430 (:key-name m6429)]
    (. bean6428 setKeyName (clojure.core/str v6430)))
   bean6428))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeAccountAttributesRequest}
describe-account-attributes-request
  [m6432]
  (clojure.core/let
   [bean6431
    (new
     com.amazonaws.services.ec2.model.DescribeAccountAttributesRequest)]
   (clojure.core/when-let
    [v6433 (:attribute-names m6432)]
    (.
     bean6431
     setAttributeNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6678] (clojure.core/str arg6678))
 v6433)))
   bean6431))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeSpotDatafeedSubscriptionRequest}
describe-spot-datafeed-subscription-request
  [m6435]
  (clojure.core/let
   [bean6434
    (new
     com.amazonaws.services.ec2.model.DescribeSpotDatafeedSubscriptionRequest)]
   bean6434))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeInternetGatewaysRequest}
describe-internet-gateways-request
  [m6438]
  (clojure.core/let
   [bean6437
    (new
     com.amazonaws.services.ec2.model.DescribeInternetGatewaysRequest)]
   (clojure.core/when-let
    [v6439 (:filters m6438)]
    (.
     bean6437
     setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6679] (ec2/filter arg6679))
 v6439)))
   (clojure.core/when-let
    [v6439 (:internet-gateway-ids m6438)]
    (.
     bean6437
     setInternetGatewayIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6680] (clojure.core/str arg6680))
 v6439)))
   bean6437))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.StartInstancesRequest}
start-instances-request
  [m6441]
  (clojure.core/let
   [bean6440
    (new com.amazonaws.services.ec2.model.StartInstancesRequest)]
   (clojure.core/when-let
    [v6442 (:instance-ids m6441)]
    (.
     bean6440
     setInstanceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6681] (clojure.core/str arg6681))
 v6442)))
   (clojure.core/when-let
    [v6442 (:additional-info m6441)]
    (. bean6440 setAdditionalInfo (clojure.core/str v6442)))
   bean6440))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.AttachNetworkInterfaceRequest}
attach-network-interface-request
  [m6444]
  (clojure.core/let
   [bean6443
    (new
     com.amazonaws.services.ec2.model.AttachNetworkInterfaceRequest)]
   (clojure.core/when-let
    [v6445 (:instance-id m6444)]
    (. bean6443 setInstanceId (clojure.core/str v6445)))
   (clojure.core/when-let
    [v6445 (:device-index m6444)]
    (. bean6443 setDeviceIndex (clojure.core/int v6445)))
   (clojure.core/when-let
    [v6445 (:network-interface-id m6444)]
    (. bean6443 setNetworkInterfaceId (clojure.core/str v6445)))
   bean6443))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateRouteRequest}
create-route-request
  [m6447]
  (clojure.core/let
   [bean6446
    (new com.amazonaws.services.ec2.model.CreateRouteRequest)]
   (clojure.core/when-let
    [v6448 (:instance-id m6447)]
    (. bean6446 setInstanceId (clojure.core/str v6448)))
   (clojure.core/when-let
    [v6448 (:route-table-id m6447)]
    (. bean6446 setRouteTableId (clojure.core/str v6448)))
   (clojure.core/when-let
    [v6448 (:destination-cidr-block m6447)]
    (. bean6446 setDestinationCidrBlock (clojure.core/str v6448)))
   (clojure.core/when-let
    [v6448 (:vpc-peering-connection-id m6447)]
    (. bean6446 setVpcPeeringConnectionId (clojure.core/str v6448)))
   (clojure.core/when-let
    [v6448 (:network-interface-id m6447)]
    (. bean6446 setNetworkInterfaceId (clojure.core/str v6448)))
   (clojure.core/when-let
    [v6448 (:gateway-id m6447)]
    (. bean6446 setGatewayId (clojure.core/str v6448)))
   bean6446))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.UnmonitorInstancesRequest}
unmonitor-instances-request
  [m6450]
  (clojure.core/let
   [bean6449
    (new com.amazonaws.services.ec2.model.UnmonitorInstancesRequest)]
   (clojure.core/when-let
    [v6451 (:instance-ids m6450)]
    (.
     bean6449
     setInstanceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6682] (clojure.core/str arg6682))
 v6451)))
   bean6449))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteNetworkInterfaceRequest}
delete-network-interface-request
  [m6453]
  (clojure.core/let
   [bean6452
    (new
     com.amazonaws.services.ec2.model.DeleteNetworkInterfaceRequest)]
   (clojure.core/when-let
    [v6454 (:network-interface-id m6453)]
    (. bean6452 setNetworkInterfaceId (clojure.core/str v6454)))
   bean6452))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.MonitorInstancesRequest}
monitor-instances-request
  [m6456]
  (clojure.core/let
   [bean6455
    (new com.amazonaws.services.ec2.model.MonitorInstancesRequest)]
   (clojure.core/when-let
    [v6457 (:instance-ids m6456)]
    (.
     bean6455
     setInstanceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6683] (clojure.core/str arg6683))
 v6457)))
   bean6455))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeReservedInstancesListingsRequest}
describe-reserved-instances-listings-request
  [m6459]
  (clojure.core/let
   [bean6458
    (new
     com.amazonaws.services.ec2.model.DescribeReservedInstancesListingsRequest)]
   (clojure.core/when-let
    [v6460 (:filters m6459)]
    (.
     bean6458
     setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6684] (ec2/filter arg6684))
 v6460)))
   (clojure.core/when-let
    [v6460 (:reserved-instances-id m6459)]
    (. bean6458 setReservedInstancesId (clojure.core/str v6460)))
   (clojure.core/when-let
    [v6460 (:reserved-instances-listing-id m6459)]
    (.
     bean6458
     setReservedInstancesListingId
     (clojure.core/str v6460)))
   bean6458))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateTagsRequest}
create-tags-request
  [m6462]
  (clojure.core/let
   [bean6461 (new com.amazonaws.services.ec2.model.CreateTagsRequest)]
   (clojure.core/when-let
    [v6463 (:tags m6462)]
    (.
     bean6461
     setTags
^{:tag java.util.Collection}
(clojure.core/map (clojure.core/fn [arg6685] (ec2/tag arg6685)) v6463)))
   (clojure.core/when-let
    [v6463 (:resources m6462)]
    (.
     bean6461
     setResources
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6686] (clojure.core/str arg6686))
 v6463)))
   bean6461))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ConfirmProductInstanceRequest}
confirm-product-instance-request
  [m6465]
  (clojure.core/let
   [bean6464
    (new
     com.amazonaws.services.ec2.model.ConfirmProductInstanceRequest)]
   (clojure.core/when-let
    [v6466 (:instance-id m6465)]
    (. bean6464 setInstanceId (clojure.core/str v6466)))
   (clojure.core/when-let
    [v6466 (:product-code m6465)]
    (. bean6464 setProductCode (clojure.core/str v6466)))
   bean6464))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DisassociateRouteTableRequest}
disassociate-route-table-request
  [m6468]
  (clojure.core/let
   [bean6467
    (new
     com.amazonaws.services.ec2.model.DisassociateRouteTableRequest)]
   (clojure.core/when-let
    [v6469 (:association-id m6468)]
    (. bean6467 setAssociationId (clojure.core/str v6469)))
   bean6467))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DisassociateAddressRequest}
disassociate-address-request
  [m6471]
  (clojure.core/let
   [bean6470
    (new com.amazonaws.services.ec2.model.DisassociateAddressRequest)]
   (clojure.core/when-let
    [v6472 (:public-ip m6471)]
    (. bean6470 setPublicIp (clojure.core/str v6472)))
   (clojure.core/when-let
    [v6472 (:association-id m6471)]
    (. bean6470 setAssociationId (clojure.core/str v6472)))
   bean6470))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DetachNetworkInterfaceRequest}
detach-network-interface-request
  [m6474]
  (clojure.core/let
   [bean6473
    (new
     com.amazonaws.services.ec2.model.DetachNetworkInterfaceRequest)]
   (clojure.core/when-let
    [v6475 (:force m6474)]
    (. bean6473 setForce (clojure.core/boolean v6475)))
   (clojure.core/when-let
    [v6475 (:attachment-id m6474)]
    (. bean6473 setAttachmentId (clojure.core/str v6475)))
   bean6473))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeExportTasksRequest}
describe-export-tasks-request
  [m6477]
  (clojure.core/let
   [bean6476
    (new com.amazonaws.services.ec2.model.DescribeExportTasksRequest)]
   (clojure.core/when-let
    [v6478 (:export-task-ids m6477)]
    (.
     bean6476
     setExportTaskIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6687] (clojure.core/str arg6687))
 v6478)))
   bean6476))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeAddressesRequest}
describe-addresses-request
  [m6480]
  (clojure.core/let
   [bean6479
    (new com.amazonaws.services.ec2.model.DescribeAddressesRequest)]
   (clojure.core/when-let
    [v6481 (:filters m6480)]
    (.
     bean6479
     setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6688] (ec2/filter arg6688))
 v6481)))
   (clojure.core/when-let
    [v6481 (:public-ips m6480)]
    (.
     bean6479
     setPublicIps
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6689] (clojure.core/str arg6689))
 v6481)))
   (clojure.core/when-let
    [v6481 (:allocation-ids m6480)]
    (.
     bean6479
     setAllocationIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6690] (clojure.core/str arg6690))
 v6481)))
   bean6479))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateInstanceExportTaskRequest}
create-instance-export-task-request
  [m6483]
  (clojure.core/let
   [bean6482
    (new
     com.amazonaws.services.ec2.model.CreateInstanceExportTaskRequest)]
   (clojure.core/when-let
    [v6484 (:instance-id m6483)]
    (. bean6482 setInstanceId (clojure.core/str v6484)))
   (clojure.core/when-let
    [v6484 (:target-environment m6483)]
    (. bean6482 setTargetEnvironment (clojure.core/str v6484)))
   (clojure.core/when-let
    [v6484 (:export-to-s3task m6483)]
    (.
     bean6482
     setExportToS3Task
     (ec2/export-to-s3task-specification v6484)))
   (clojure.core/when-let
    [v6484 (:description m6483)]
    (. bean6482 setDescription (clojure.core/str v6484)))
   bean6482))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateImageRequest}
create-image-request
  [m6486]
  (clojure.core/let
   [bean6485
    (new com.amazonaws.services.ec2.model.CreateImageRequest)]
   (clojure.core/when-let
    [v6487 (:name m6486)]
    (. bean6485 setName (clojure.core/str v6487)))
   (clojure.core/when-let
    [v6487 (:instance-id m6486)]
    (. bean6485 setInstanceId (clojure.core/str v6487)))
   (clojure.core/when-let
    [v6487 (:block-device-mappings m6486)]
    (.
     bean6485
     setBlockDeviceMappings
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6691] (ec2/block-device-mapping arg6691))
 v6487)))
   (clojure.core/when-let
    [v6487 (:description m6486)]
    (. bean6485 setDescription (clojure.core/str v6487)))
   (clojure.core/when-let
    [v6487 (:no-reboot m6486)]
    (. bean6485 setNoReboot (clojure.core/boolean v6487)))
   bean6485))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateSecurityGroupRequest}
create-security-group-request
  [m6489]
  (clojure.core/let
   [bean6488
    (new com.amazonaws.services.ec2.model.CreateSecurityGroupRequest)]
   (clojure.core/when-let
    [v6490 (:vpc-id m6489)]
    (. bean6488 setVpcId (clojure.core/str v6490)))
   (clojure.core/when-let
    [v6490 (:group-name m6489)]
    (. bean6488 setGroupName (clojure.core/str v6490)))
   (clojure.core/when-let
    [v6490 (:description m6489)]
    (. bean6488 setDescription (clojure.core/str v6490)))
   bean6488))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateSubnetRequest}
create-subnet-request
  [m6492]
  (clojure.core/let
   [bean6491
    (new com.amazonaws.services.ec2.model.CreateSubnetRequest)]
   (clojure.core/when-let
    [v6493 (:availability-zone m6492)]
    (. bean6491 setAvailabilityZone (clojure.core/str v6493)))
   (clojure.core/when-let
    [v6493 (:vpc-id m6492)]
    (. bean6491 setVpcId (clojure.core/str v6493)))
   (clojure.core/when-let
    [v6493 (:cidr-block m6492)]
    (. bean6491 setCidrBlock (clojure.core/str v6493)))
   bean6491))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteNetworkAclRequest}
delete-network-acl-request
  [m6495]
  (clojure.core/let
   [bean6494
    (new com.amazonaws.services.ec2.model.DeleteNetworkAclRequest)]
   (clojure.core/when-let
    [v6496 (:network-acl-id m6495)]
    (. bean6494 setNetworkAclId (clojure.core/str v6496)))
   bean6494))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateNetworkInterfaceRequest}
create-network-interface-request
  [m6498]
  (clojure.core/let
   [bean6497
    (new
     com.amazonaws.services.ec2.model.CreateNetworkInterfaceRequest)]
   (clojure.core/when-let
    [v6499 (:subnet-id m6498)]
    (. bean6497 setSubnetId (clojure.core/str v6499)))
   (clojure.core/when-let
    [v6499 (:private-ip-address m6498)]
    (. bean6497 setPrivateIpAddress (clojure.core/str v6499)))
   (clojure.core/when-let
    [v6499 (:groups m6498)]
    (.
     bean6497
     setGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6692] (clojure.core/str arg6692))
 v6499)))
   (clojure.core/when-let
    [v6499 (:private-ip-addresses m6498)]
    (.
     bean6497
     setPrivateIpAddresses
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg6693]
  (ec2/private-ip-address-specification arg6693))
 v6499)))
   (clojure.core/when-let
    [v6499 (:secondary-private-ip-address-count m6498)]
    (.
     bean6497
     setSecondaryPrivateIpAddressCount
     (clojure.core/int v6499)))
   (clojure.core/when-let
    [v6499 (:description m6498)]
    (. bean6497 setDescription (clojure.core/str v6499)))
   bean6497))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteVpnGatewayRequest}
delete-vpn-gateway-request
  [m6501]
  (clojure.core/let
   [bean6500
    (new com.amazonaws.services.ec2.model.DeleteVpnGatewayRequest)]
   (clojure.core/when-let
    [v6502 (:vpn-gateway-id m6501)]
    (. bean6500 setVpnGatewayId (clojure.core/str v6502)))
   bean6500))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.AttachVolumeRequest}
attach-volume-request
  [m6504]
  (clojure.core/let
   [bean6503
    (new com.amazonaws.services.ec2.model.AttachVolumeRequest)]
   (clojure.core/when-let
    [v6505 (:instance-id m6504)]
    (. bean6503 setInstanceId (clojure.core/str v6505)))
   (clojure.core/when-let
    [v6505 (:volume-id m6504)]
    (. bean6503 setVolumeId (clojure.core/str v6505)))
   (clojure.core/when-let
    [v6505 (:device m6504)]
    (. bean6503 setDevice (clojure.core/str v6505)))
   bean6503))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateVpnConnectionRequest}
create-vpn-connection-request
  [m6507]
  (clojure.core/let
   [bean6506
    (new com.amazonaws.services.ec2.model.CreateVpnConnectionRequest)]
   (clojure.core/when-let
    [v6508 (:vpn-gateway-id m6507)]
    (. bean6506 setVpnGatewayId (clojure.core/str v6508)))
   (clojure.core/when-let
    [v6508 (:customer-gateway-id m6507)]
    (. bean6506 setCustomerGatewayId (clojure.core/str v6508)))
   (clojure.core/when-let
    [v6508 (:options m6507)]
    (.
     bean6506
     setOptions
     (ec2/vpn-connection-options-specification v6508)))
   (clojure.core/when-let
    [v6508 (:type m6507)]
    (. bean6506 setType (clojure.core/str v6508)))
   bean6506))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeletePlacementGroupRequest}
delete-placement-group-request
  [m6510]
  (clojure.core/let
   [bean6509
    (new com.amazonaws.services.ec2.model.DeletePlacementGroupRequest)]
   (clojure.core/when-let
    [v6511 (:group-name m6510)]
    (. bean6509 setGroupName (clojure.core/str v6511)))
   bean6509))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ResetInstanceAttributeRequest}
reset-instance-attribute-request
  [m6513]
  (clojure.core/let
   [bean6512
    (new
     com.amazonaws.services.ec2.model.ResetInstanceAttributeRequest)]
   (clojure.core/when-let
    [v6514 (:instance-id m6513)]
    (. bean6512 setInstanceId (clojure.core/str v6514)))
   (clojure.core/when-let
    [v6514 (:attribute m6513)]
    (. bean6512 setAttribute (clojure.core/str v6514)))
   bean6512))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateSnapshotRequest}
create-snapshot-request
  [m6516]
  (clojure.core/let
   [bean6515
    (new com.amazonaws.services.ec2.model.CreateSnapshotRequest)]
   (clojure.core/when-let
    [v6517 (:volume-id m6516)]
    (. bean6515 setVolumeId (clojure.core/str v6517)))
   (clojure.core/when-let
    [v6517 (:description m6516)]
    (. bean6515 setDescription (clojure.core/str v6517)))
   bean6515))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.RequestSpotInstancesRequest}
request-spot-instances-request
  [m6519]
  (clojure.core/let
   [bean6518
    (new com.amazonaws.services.ec2.model.RequestSpotInstancesRequest)]
   (clojure.core/when-let
    [v6520 (:spot-price m6519)]
    (. bean6518 setSpotPrice (clojure.core/str v6520)))
   (clojure.core/when-let
    [v6520 (:instance-count m6519)]
    (. bean6518 setInstanceCount (clojure.core/int v6520)))
   (clojure.core/when-let
    [v6520 (:launch-specification m6519)]
    (.
     bean6518
     setLaunchSpecification
     (ec2/launch-specification v6520)))
   (clojure.core/when-let
    [v6520 (:valid-from m6519)]
    (.
     bean6518
     setValidFrom
     (com.palletops.awaze.common/to-date v6520)))
   (clojure.core/when-let
    [v6520 (:valid-until m6519)]
    (.
     bean6518
     setValidUntil
     (com.palletops.awaze.common/to-date v6520)))
   (clojure.core/when-let
    [v6520 (:launch-group m6519)]
    (. bean6518 setLaunchGroup (clojure.core/str v6520)))
   (clojure.core/when-let
    [v6520 (:availability-zone-group m6519)]
    (. bean6518 setAvailabilityZoneGroup (clojure.core/str v6520)))
   (clojure.core/when-let
    [v6520 (:type m6519)]
    (. bean6518 setType (clojure.core/str v6520)))
   bean6518))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeNetworkInterfacesRequest}
describe-network-interfaces-request
  [m6522]
  (clojure.core/let
   [bean6521
    (new
     com.amazonaws.services.ec2.model.DescribeNetworkInterfacesRequest)]
   (clojure.core/when-let
    [v6523 (:filters m6522)]
    (.
     bean6521
     setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6694] (ec2/filter arg6694))
 v6523)))
   (clojure.core/when-let
    [v6523 (:network-interface-ids m6522)]
    (.
     bean6521
     setNetworkInterfaceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6695] (clojure.core/str arg6695))
 v6523)))
   bean6521))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteVolumeRequest}
delete-volume-request
  [m6525]
  (clojure.core/let
   [bean6524
    (new com.amazonaws.services.ec2.model.DeleteVolumeRequest)]
   (clojure.core/when-let
    [v6526 (:volume-id m6525)]
    (. bean6524 setVolumeId (clojure.core/str v6526)))
   bean6524))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteSnapshotRequest}
delete-snapshot-request
  [m6528]
  (clojure.core/let
   [bean6527
    (new com.amazonaws.services.ec2.model.DeleteSnapshotRequest)]
   (clojure.core/when-let
    [v6529 (:snapshot-id m6528)]
    (. bean6527 setSnapshotId (clojure.core/str v6529)))
   bean6527))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeInstancesRequest}
describe-instances-request
  [m6531]
  (clojure.core/let
   [bean6530
    (new com.amazonaws.services.ec2.model.DescribeInstancesRequest)]
   (clojure.core/when-let
    [v6532 (:instance-ids m6531)]
    (.
     bean6530
     setInstanceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6696] (clojure.core/str arg6696))
 v6532)))
   (clojure.core/when-let
    [v6532 (:filters m6531)]
    (.
     bean6530
     setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6697] (ec2/filter arg6697))
 v6532)))
   (clojure.core/when-let
    [v6532 (:max-results m6531)]
    (. bean6530 setMaxResults (clojure.core/int v6532)))
   (clojure.core/when-let
    [v6532 (:next-token m6531)]
    (. bean6530 setNextToken (clojure.core/str v6532)))
   bean6530))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.AssociateRouteTableRequest}
associate-route-table-request
  [m6534]
  (clojure.core/let
   [bean6533
    (new com.amazonaws.services.ec2.model.AssociateRouteTableRequest)]
   (clojure.core/when-let
    [v6535 (:route-table-id m6534)]
    (. bean6533 setRouteTableId (clojure.core/str v6535)))
   (clojure.core/when-let
    [v6535 (:subnet-id m6534)]
    (. bean6533 setSubnetId (clojure.core/str v6535)))
   bean6533))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DisableVgwRoutePropagationRequest}
disable-vgw-route-propagation-request
  [m6537]
  (clojure.core/let
   [bean6536
    (new
     com.amazonaws.services.ec2.model.DisableVgwRoutePropagationRequest)]
   (clojure.core/when-let
    [v6538 (:route-table-id m6537)]
    (. bean6536 setRouteTableId (clojure.core/str v6538)))
   (clojure.core/when-let
    [v6538 (:gateway-id m6537)]
    (. bean6536 setGatewayId (clojure.core/str v6538)))
   bean6536))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeInstanceAttributeRequest}
describe-instance-attribute-request
  [m6540]
  (clojure.core/let
   [bean6539
    (new
     com.amazonaws.services.ec2.model.DescribeInstanceAttributeRequest)]
   (clojure.core/when-let
    [v6541 (:instance-id m6540)]
    (. bean6539 setInstanceId (clojure.core/str v6541)))
   (clojure.core/when-let
    [v6541 (:attribute m6540)]
    (. bean6539 setAttribute (clojure.core/str v6541)))
   bean6539))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateVpnGatewayRequest}
create-vpn-gateway-request
  [m6543]
  (clojure.core/let
   [bean6542
    (new com.amazonaws.services.ec2.model.CreateVpnGatewayRequest)]
   (clojure.core/when-let
    [v6544 (:availability-zone m6543)]
    (. bean6542 setAvailabilityZone (clojure.core/str v6544)))
   (clojure.core/when-let
    [v6544 (:type m6543)]
    (. bean6542 setType (ec2/gateway-type v6544)))
   bean6542))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateNetworkAclRequest}
create-network-acl-request
  [m6546]
  (clojure.core/let
   [bean6545
    (new com.amazonaws.services.ec2.model.CreateNetworkAclRequest)]
   (clojure.core/when-let
    [v6547 (:vpc-id m6546)]
    (. bean6545 setVpcId (clojure.core/str v6547)))
   bean6545))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.ReplaceRouteRequest}
replace-route-request
  [m6549]
  (clojure.core/let
   [bean6548
    (new com.amazonaws.services.ec2.model.ReplaceRouteRequest)]
   (clojure.core/when-let
    [v6550 (:instance-id m6549)]
    (. bean6548 setInstanceId (clojure.core/str v6550)))
   (clojure.core/when-let
    [v6550 (:route-table-id m6549)]
    (. bean6548 setRouteTableId (clojure.core/str v6550)))
   (clojure.core/when-let
    [v6550 (:destination-cidr-block m6549)]
    (. bean6548 setDestinationCidrBlock (clojure.core/str v6550)))
   (clojure.core/when-let
    [v6550 (:vpc-peering-connection-id m6549)]
    (. bean6548 setVpcPeeringConnectionId (clojure.core/str v6550)))
   (clojure.core/when-let
    [v6550 (:network-interface-id m6549)]
    (. bean6548 setNetworkInterfaceId (clojure.core/str v6550)))
   (clojure.core/when-let
    [v6550 (:gateway-id m6549)]
    (. bean6548 setGatewayId (clojure.core/str v6550)))
   bean6548))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribeRegionsRequest}
describe-regions-request
  [m6552]
  (clojure.core/let
   [bean6551
    (new com.amazonaws.services.ec2.model.DescribeRegionsRequest)]
   (clojure.core/when-let
    [v6553 (:filters m6552)]
    (.
     bean6551
     setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6698] (ec2/filter arg6698))
 v6553)))
   (clojure.core/when-let
    [v6553 (:region-names m6552)]
    (.
     bean6551
     setRegionNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6699] (clojure.core/str arg6699))
 v6553)))
   bean6551))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteInternetGatewayRequest}
delete-internet-gateway-request
  [m6555]
  (clojure.core/let
   [bean6554
    (new
     com.amazonaws.services.ec2.model.DeleteInternetGatewayRequest)]
   (clojure.core/when-let
    [v6556 (:internet-gateway-id m6555)]
    (. bean6554 setInternetGatewayId (clojure.core/str v6556)))
   bean6554))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteRouteRequest}
delete-route-request
  [m6558]
  (clojure.core/let
   [bean6557
    (new com.amazonaws.services.ec2.model.DeleteRouteRequest)]
   (clojure.core/when-let
    [v6559 (:route-table-id m6558)]
    (. bean6557 setRouteTableId (clojure.core/str v6559)))
   (clojure.core/when-let
    [v6559 (:destination-cidr-block m6558)]
    (. bean6557 setDestinationCidrBlock (clojure.core/str v6559)))
   bean6557))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.AssignPrivateIpAddressesRequest}
assign-private-ip-addresses-request
  [m6561]
  (clojure.core/let
   [bean6560
    (new
     com.amazonaws.services.ec2.model.AssignPrivateIpAddressesRequest)]
   (clojure.core/when-let
    [v6562 (:private-ip-addresses m6561)]
    (.
     bean6560
     setPrivateIpAddresses
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6700] (clojure.core/str arg6700))
 v6562)))
   (clojure.core/when-let
    [v6562 (:secondary-private-ip-address-count m6561)]
    (.
     bean6560
     setSecondaryPrivateIpAddressCount
     (clojure.core/int v6562)))
   (clojure.core/when-let
    [v6562 (:allow-reassignment m6561)]
    (. bean6560 setAllowReassignment (clojure.core/boolean v6562)))
   (clojure.core/when-let
    [v6562 (:network-interface-id m6561)]
    (. bean6560 setNetworkInterfaceId (clojure.core/str v6562)))
   bean6560))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DeleteDhcpOptionsRequest}
delete-dhcp-options-request
  [m6564]
  (clojure.core/let
   [bean6563
    (new com.amazonaws.services.ec2.model.DeleteDhcpOptionsRequest)]
   (clojure.core/when-let
    [v6565 (:dhcp-options-id m6564)]
    (. bean6563 setDhcpOptionsId (clojure.core/str v6565)))
   bean6563))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CancelSpotInstanceRequestsRequest}
cancel-spot-instance-requests-request
  [m6567]
  (clojure.core/let
   [bean6566
    (new
     com.amazonaws.services.ec2.model.CancelSpotInstanceRequestsRequest)]
   (clojure.core/when-let
    [v6568 (:spot-instance-request-ids m6567)]
    (.
     bean6566
     setSpotInstanceRequestIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6701] (clojure.core/str arg6701))
 v6568)))
   bean6566))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.CreateDhcpOptionsRequest}
create-dhcp-options-request
  [m6570]
  (clojure.core/let
   [bean6569
    (new com.amazonaws.services.ec2.model.CreateDhcpOptionsRequest)]
   (clojure.core/when-let
    [v6571 (:dhcp-configurations m6570)]
    (.
     bean6569
     setDhcpConfigurations
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6702] (ec2/dhcp-configuration arg6702))
 v6571)))
   bean6569))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.StopInstancesRequest}
stop-instances-request
  [m6573]
  (clojure.core/let
   [bean6572
    (new com.amazonaws.services.ec2.model.StopInstancesRequest)]
   (clojure.core/when-let
    [v6574 (:instance-ids m6573)]
    (.
     bean6572
     setInstanceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6703] (clojure.core/str arg6703))
 v6574)))
   (clojure.core/when-let
    [v6574 (:force m6573)]
    (. bean6572 setForce (clojure.core/boolean v6574)))
   bean6572))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.AuthorizeSecurityGroupIngressRequest}
authorize-security-group-ingress-request
  [m6576]
  (clojure.core/let
   [bean6575
    (new
     com.amazonaws.services.ec2.model.AuthorizeSecurityGroupIngressRequest)]
   (clojure.core/when-let
    [v6577 (:ip-protocol m6576)]
    (. bean6575 setIpProtocol (clojure.core/str v6577)))
   (clojure.core/when-let
    [v6577 (:group-name m6576)]
    (. bean6575 setGroupName (clojure.core/str v6577)))
   (clojure.core/when-let
    [v6577 (:source-security-group-owner-id m6576)]
    (.
     bean6575
     setSourceSecurityGroupOwnerId
     (clojure.core/str v6577)))
   (clojure.core/when-let
    [v6577 (:source-security-group-name m6576)]
    (. bean6575 setSourceSecurityGroupName (clojure.core/str v6577)))
   (clojure.core/when-let
    [v6577 (:from-port m6576)]
    (. bean6575 setFromPort (clojure.core/int v6577)))
   (clojure.core/when-let
    [v6577 (:group-id m6576)]
    (. bean6575 setGroupId (clojure.core/str v6577)))
   (clojure.core/when-let
    [v6577 (:ip-permissions m6576)]
    (.
     bean6575
     setIpPermissions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6704] (ec2/ip-permission arg6704))
 v6577)))
   (clojure.core/when-let
    [v6577 (:cidr-ip m6576)]
    (. bean6575 setCidrIp (clojure.core/str v6577)))
   (clojure.core/when-let
    [v6577 (:to-port m6576)]
    (. bean6575 setToPort (clojure.core/int v6577)))
   bean6575))
 (clojure.core/defn
^{:tag com.amazonaws.services.ec2.model.DescribePlacementGroupsRequest}
describe-placement-groups-request
  [m6579]
  (clojure.core/let
   [bean6578
    (new
     com.amazonaws.services.ec2.model.DescribePlacementGroupsRequest)]
   (clojure.core/when-let
    [v6580 (:filters m6579)]
    (.
     bean6578
     setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6705] (ec2/filter arg6705))
 v6580)))
   (clojure.core/when-let
    [v6580 (:group-names m6579)]
    (.
     bean6578
     setGroupNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6706] (clojure.core/str arg6706))
 v6580)))
   bean6578))
 (clojure.core/defmulti
  ec2
  (clojure.core/fn ec2 [m__1683__auto__] (:fn m__1683__auto__)))
 (do
  (clojure.core/defmethod
   ec2
   :describe-security-groups
   [m6707]
   (clojure.core/let
    [credentials6708 (:credentials m6707) args6709 (:args m6707)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client6710
      (com.palletops.awaze.common/aws-client :ec2 credentials6708)]
     (clojure.core/case
      (clojure.core/count args6709)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6710
        describeSecurityGroups))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6710
        describeSecurityGroups
        (ec2/describe-security-groups-request
         (clojure.core/nth args6709 0))))))))
  (clojure.core/defn
   describe-security-groups-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [group-names
                         group-ids
                         general-progress-listener
                         filters]}]]),
    :doc "Generate map for describeSecurityGroups, describeSecurityGroups"}
   ([credentials__1651__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-security-groups,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-security-groups,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-security-groups
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [group-names
                         group-ids
                         general-progress-listener
                         filters]}]]),
    :doc "Call describeSecurityGroups, describeSecurityGroups"}
   [credentials6712 & args6713]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client6714
     (com.palletops.awaze.common/aws-client :ec2 credentials6712)]
    (clojure.core/case
     (clojure.core/count args6713)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6714
       describeSecurityGroups))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6714
       describeSecurityGroups
       (ec2/describe-security-groups-request
        (clojure.core/nth args6713 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-vpc
   [m6715]
   (clojure.core/let
    [credentials6716 (:credentials m6715) args6717 (:args m6715)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client6718
      (com.palletops.awaze.common/aws-client :ec2 credentials6716)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6718
       createVpc
       (ec2/create-vpc-request (clojure.core/nth args6717 0)))))))
  (clojure.core/defn
   create-vpc-map
   {:arglists (quote
               [[credentials
                 {:keys [instance-tenancy
                         general-progress-listener
                         cidr-block]}]]),
    :doc "Generate map for createVpc"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :create-vpc,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-vpc
   {:arglists (quote
               [[credentials
                 {:keys [instance-tenancy
                         general-progress-listener
                         cidr-block]}]]),
    :doc "Call createVpc"}
   [credentials6720 & args6721]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client6722
     (com.palletops.awaze.common/aws-client :ec2 credentials6720)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6722
      createVpc
      (ec2/create-vpc-request (clojure.core/nth args6721 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :deregister-image
   [m6723]
   (clojure.core/let
    [credentials6724 (:credentials m6723) args6725 (:args m6723)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client6726
      (com.palletops.awaze.common/aws-client :ec2 credentials6724)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6726
       deregisterImage
       (ec2/deregister-image-request (clojure.core/nth args6725 0)))))))
  (clojure.core/defn
   deregister-image-map
   {:arglists (quote
               [[credentials
                 {:keys [image-id general-progress-listener]}]]),
    :doc "Generate map for deregisterImage"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :deregister-image,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   deregister-image
   {:arglists (quote
               [[credentials
                 {:keys [image-id general-progress-listener]}]]),
    :doc "Call deregisterImage"}
   [credentials6728 & args6729]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client6730
     (com.palletops.awaze.common/aws-client :ec2 credentials6728)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6730
      deregisterImage
      (ec2/deregister-image-request (clojure.core/nth args6729 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-network-acl-entry
   [m6731]
   (clojure.core/let
    [credentials6732 (:credentials m6731) args6733 (:args m6731)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client6734
      (com.palletops.awaze.common/aws-client :ec2 credentials6732)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6734
       createNetworkAclEntry
       (ec2/create-network-acl-entry-request
        (clojure.core/nth args6733 0)))))))
  (clojure.core/defn
   create-network-acl-entry-map
   {:arglists (quote
               [[credentials
                 {:keys [protocol
                         general-progress-listener
                         icmp-type-code
                         network-acl-id
                         rule-number
                         cidr-block
                         egress
                         port-range
                         rule-action]}]]),
    :doc "Generate map for createNetworkAclEntry"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :create-network-acl-entry,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-network-acl-entry
   {:arglists (quote
               [[credentials
                 {:keys [protocol
                         general-progress-listener
                         icmp-type-code
                         network-acl-id
                         rule-number
                         cidr-block
                         egress
                         port-range
                         rule-action]}]]),
    :doc "Call createNetworkAclEntry"}
   [credentials6736 & args6737]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client6738
     (com.palletops.awaze.common/aws-client :ec2 credentials6736)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6738
      createNetworkAclEntry
      (ec2/create-network-acl-entry-request
       (clojure.core/nth args6737 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :cancel-export-task
   [m6739]
   (clojure.core/let
    [credentials6740 (:credentials m6739) args6741 (:args m6739)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client6742
      (com.palletops.awaze.common/aws-client :ec2 credentials6740)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6742
       cancelExportTask
       (ec2/cancel-export-task-request (clojure.core/nth args6741 0)))))))
  (clojure.core/defn
   cancel-export-task-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener export-task-id]}]]),
    :doc "Generate map for cancelExportTask"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :cancel-export-task,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   cancel-export-task
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener export-task-id]}]]),
    :doc "Call cancelExportTask"}
   [credentials6744 & args6745]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client6746
     (com.palletops.awaze.common/aws-client :ec2 credentials6744)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6746
      cancelExportTask
      (ec2/cancel-export-task-request (clojure.core/nth args6745 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :revoke-security-group-ingress
   [m6747]
   (clojure.core/let
    [credentials6748 (:credentials m6747) args6749 (:args m6747)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client6750
      (com.palletops.awaze.common/aws-client :ec2 credentials6748)]
     (clojure.core/case
      (clojure.core/count args6749)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6750
        revokeSecurityGroupIngress))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6750
        revokeSecurityGroupIngress
        (ec2/revoke-security-group-ingress-request
         (clojure.core/nth args6749 0))))))))
  (clojure.core/defn
   revoke-security-group-ingress-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [source-security-group-name
                         group-id
                         general-progress-listener
                         from-port
                         ip-permissions
                         to-port
                         cidr-ip
                         ip-protocol
                         source-security-group-owner-id
                         group-name]}]]),
    :doc "Generate map for revokeSecurityGroupIngress, revokeSecurityGroupIngress"}
   ([credentials__1651__auto__]
    {:args [],
     :client :ec2,
     :fn :revoke-security-group-ingress,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :revoke-security-group-ingress,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   revoke-security-group-ingress
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [source-security-group-name
                         group-id
                         general-progress-listener
                         from-port
                         ip-permissions
                         to-port
                         cidr-ip
                         ip-protocol
                         source-security-group-owner-id
                         group-name]}]]),
    :doc "Call revokeSecurityGroupIngress, revokeSecurityGroupIngress"}
   [credentials6752 & args6753]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client6754
     (com.palletops.awaze.common/aws-client :ec2 credentials6752)]
    (clojure.core/case
     (clojure.core/count args6753)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6754
       revokeSecurityGroupIngress))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6754
       revokeSecurityGroupIngress
       (ec2/revoke-security-group-ingress-request
        (clojure.core/nth args6753 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-route-tables
   [m6755]
   (clojure.core/let
    [credentials6756 (:credentials m6755) args6757 (:args m6755)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client6758
      (com.palletops.awaze.common/aws-client :ec2 credentials6756)]
     (clojure.core/case
      (clojure.core/count args6757)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6758
        describeRouteTables
        (ec2/describe-route-tables-request
         (clojure.core/nth args6757 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6758
        describeRouteTables))))))
  (clojure.core/defn
   describe-route-tables-map
   {:arglists (quote
               [[credentials
                 {:keys [route-table-ids
                         general-progress-listener
                         filters]}]
                [credentials]]),
    :doc "Generate map for describeRouteTables, describeRouteTables"}
   ([credentials__1651__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-route-tables,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-route-tables,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-route-tables
   {:arglists (quote
               [[credentials
                 {:keys [route-table-ids
                         general-progress-listener
                         filters]}]
                [credentials]]),
    :doc "Call describeRouteTables, describeRouteTables"}
   [credentials6760 & args6761]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client6762
     (com.palletops.awaze.common/aws-client :ec2 credentials6760)]
    (clojure.core/case
     (clojure.core/count args6761)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6762
       describeRouteTables
       (ec2/describe-route-tables-request
        (clojure.core/nth args6761 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6762
       describeRouteTables))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-reserved-instances-listing
   [m6763]
   (clojure.core/let
    [credentials6764 (:credentials m6763) args6765 (:args m6763)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client6766
      (com.palletops.awaze.common/aws-client :ec2 credentials6764)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6766
       createReservedInstancesListing
       (ec2/create-reserved-instances-listing-request
        (clojure.core/nth args6765 0)))))))
  (clojure.core/defn
   create-reserved-instances-listing-map
   {:arglists (quote
               [[credentials
                 {:keys [reserved-instances-id
                         price-schedules
                         instance-count
                         general-progress-listener
                         client-token]}]]),
    :doc "Generate map for createReservedInstancesListing"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :create-reserved-instances-listing,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-reserved-instances-listing
   {:arglists (quote
               [[credentials
                 {:keys [reserved-instances-id
                         price-schedules
                         instance-count
                         general-progress-listener
                         client-token]}]]),
    :doc "Call createReservedInstancesListing"}
   [credentials6768 & args6769]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client6770
     (com.palletops.awaze.common/aws-client :ec2 credentials6768)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6770
      createReservedInstancesListing
      (ec2/create-reserved-instances-listing-request
       (clojure.core/nth args6769 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :reset-image-attribute
   [m6771]
   (clojure.core/let
    [credentials6772 (:credentials m6771) args6773 (:args m6771)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client6774
      (com.palletops.awaze.common/aws-client :ec2 credentials6772)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6774
       resetImageAttribute
       (ec2/reset-image-attribute-request
        (clojure.core/nth args6773 0)))))))
  (clojure.core/defn
   reset-image-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [image-id general-progress-listener attribute]}]]),
    :doc "Generate map for resetImageAttribute"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :reset-image-attribute,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   reset-image-attribute
   {:arglists (quote
               [[credentials
                 {:keys [image-id general-progress-listener attribute]}]]),
    :doc "Call resetImageAttribute"}
   [credentials6776 & args6777]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client6778
     (com.palletops.awaze.common/aws-client :ec2 credentials6776)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6778
      resetImageAttribute
      (ec2/reset-image-attribute-request
       (clojure.core/nth args6777 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-availability-zones
   [m6779]
   (clojure.core/let
    [credentials6780 (:credentials m6779) args6781 (:args m6779)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client6782
      (com.palletops.awaze.common/aws-client :ec2 credentials6780)]
     (clojure.core/case
      (clojure.core/count args6781)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6782
        describeAvailabilityZones
        (ec2/describe-availability-zones-request
         (clojure.core/nth args6781 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6782
        describeAvailabilityZones))))))
  (clojure.core/defn
   describe-availability-zones-map
   {:arglists (quote
               [[credentials
                 {:keys [zone-names general-progress-listener filters]}]
                [credentials]]),
    :doc "Generate map for describeAvailabilityZones, describeAvailabilityZones"}
   ([credentials__1651__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-availability-zones,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-availability-zones,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-availability-zones
   {:arglists (quote
               [[credentials
                 {:keys [zone-names general-progress-listener filters]}]
                [credentials]]),
    :doc "Call describeAvailabilityZones, describeAvailabilityZones"}
   [credentials6784 & args6785]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client6786
     (com.palletops.awaze.common/aws-client :ec2 credentials6784)]
    (clojure.core/case
     (clojure.core/count args6785)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6786
       describeAvailabilityZones
       (ec2/describe-availability-zones-request
        (clojure.core/nth args6785 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6786
       describeAvailabilityZones))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-network-acls
   [m6787]
   (clojure.core/let
    [credentials6788 (:credentials m6787) args6789 (:args m6787)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client6790
      (com.palletops.awaze.common/aws-client :ec2 credentials6788)]
     (clojure.core/case
      (clojure.core/count args6789)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6790
        describeNetworkAcls
        (ec2/describe-network-acls-request
         (clojure.core/nth args6789 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6790
        describeNetworkAcls))))))
  (clojure.core/defn
   describe-network-acls-map
   {:arglists (quote
               [[credentials
                 {:keys [network-acl-ids
                         general-progress-listener
                         filters]}]
                [credentials]]),
    :doc "Generate map for describeNetworkAcls, describeNetworkAcls"}
   ([credentials__1651__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-network-acls,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-network-acls,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-network-acls
   {:arglists (quote
               [[credentials
                 {:keys [network-acl-ids
                         general-progress-listener
                         filters]}]
                [credentials]]),
    :doc "Call describeNetworkAcls, describeNetworkAcls"}
   [credentials6792 & args6793]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client6794
     (com.palletops.awaze.common/aws-client :ec2 credentials6792)]
    (clojure.core/case
     (clojure.core/count args6793)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6794
       describeNetworkAcls
       (ec2/describe-network-acls-request
        (clojure.core/nth args6793 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6794
       describeNetworkAcls))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-vpn-gateways
   [m6795]
   (clojure.core/let
    [credentials6796 (:credentials m6795) args6797 (:args m6795)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client6798
      (com.palletops.awaze.common/aws-client :ec2 credentials6796)]
     (clojure.core/case
      (clojure.core/count args6797)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6798
        describeVpnGateways
        (ec2/describe-vpn-gateways-request
         (clojure.core/nth args6797 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6798
        describeVpnGateways))))))
  (clojure.core/defn
   describe-vpn-gateways-map
   {:arglists (quote
               [[credentials
                 {:keys [vpn-gateway-ids
                         general-progress-listener
                         filters]}]
                [credentials]]),
    :doc "Generate map for describeVpnGateways, describeVpnGateways"}
   ([credentials__1651__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-vpn-gateways,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-vpn-gateways,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-vpn-gateways
   {:arglists (quote
               [[credentials
                 {:keys [vpn-gateway-ids
                         general-progress-listener
                         filters]}]
                [credentials]]),
    :doc "Call describeVpnGateways, describeVpnGateways"}
   [credentials6800 & args6801]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client6802
     (com.palletops.awaze.common/aws-client :ec2 credentials6800)]
    (clojure.core/case
     (clojure.core/count args6801)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6802
       describeVpnGateways
       (ec2/describe-vpn-gateways-request
        (clojure.core/nth args6801 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6802
       describeVpnGateways))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-snapshots
   [m6803]
   (clojure.core/let
    [credentials6804 (:credentials m6803) args6805 (:args m6803)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client6806
      (com.palletops.awaze.common/aws-client :ec2 credentials6804)]
     (clojure.core/case
      (clojure.core/count args6805)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6806
        describeSnapshots))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6806
        describeSnapshots
        (ec2/describe-snapshots-request (clojure.core/nth args6805 0))))))))
  (clojure.core/defn
   describe-snapshots-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [restorable-by-user-ids
                         owner-ids
                         snapshot-ids
                         general-progress-listener
                         filters]}]]),
    :doc "Generate map for describeSnapshots, describeSnapshots"}
   ([credentials__1651__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-snapshots,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-snapshots,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-snapshots
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [restorable-by-user-ids
                         owner-ids
                         snapshot-ids
                         general-progress-listener
                         filters]}]]),
    :doc "Call describeSnapshots, describeSnapshots"}
   [credentials6808 & args6809]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client6810
     (com.palletops.awaze.common/aws-client :ec2 credentials6808)]
    (clojure.core/case
     (clojure.core/count args6809)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6810
       describeSnapshots))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6810
       describeSnapshots
       (ec2/describe-snapshots-request (clojure.core/nth args6809 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :modify-image-attribute
   [m6811]
   (clojure.core/let
    [credentials6812 (:credentials m6811) args6813 (:args m6811)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client6814
      (com.palletops.awaze.common/aws-client :ec2 credentials6812)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6814
       modifyImageAttribute
       (ec2/modify-image-attribute-request
        (clojure.core/nth args6813 0)))))))
  (clojure.core/defn
   modify-image-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [user-groups
                         launch-permission
                         general-progress-listener
                         user-ids
                         operation-type
                         attribute
                         image-id
                         product-codes
                         value
                         description]}]]),
    :doc "Generate map for modifyImageAttribute"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :modify-image-attribute,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   modify-image-attribute
   {:arglists (quote
               [[credentials
                 {:keys [user-groups
                         launch-permission
                         general-progress-listener
                         user-ids
                         operation-type
                         attribute
                         image-id
                         product-codes
                         value
                         description]}]]),
    :doc "Call modifyImageAttribute"}
   [credentials6816 & args6817]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client6818
     (com.palletops.awaze.common/aws-client :ec2 credentials6816)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6818
      modifyImageAttribute
      (ec2/modify-image-attribute-request
       (clojure.core/nth args6817 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-volumes
   [m6819]
   (clojure.core/let
    [credentials6820 (:credentials m6819) args6821 (:args m6819)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client6822
      (com.palletops.awaze.common/aws-client :ec2 credentials6820)]
     (clojure.core/case
      (clojure.core/count args6821)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6822
        describeVolumes))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6822
        describeVolumes
        (ec2/describe-volumes-request (clojure.core/nth args6821 0))))))))
  (clojure.core/defn
   describe-volumes-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [volume-ids general-progress-listener filters]}]]),
    :doc "Generate map for describeVolumes, describeVolumes"}
   ([credentials__1651__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-volumes,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-volumes,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-volumes
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [volume-ids general-progress-listener filters]}]]),
    :doc "Call describeVolumes, describeVolumes"}
   [credentials6824 & args6825]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client6826
     (com.palletops.awaze.common/aws-client :ec2 credentials6824)]
    (clojure.core/case
     (clojure.core/count args6825)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6826
       describeVolumes))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6826
       describeVolumes
       (ec2/describe-volumes-request (clojure.core/nth args6825 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :attach-internet-gateway
   [m6827]
   (clojure.core/let
    [credentials6828 (:credentials m6827) args6829 (:args m6827)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client6830
      (com.palletops.awaze.common/aws-client :ec2 credentials6828)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6830
       attachInternetGateway
       (ec2/attach-internet-gateway-request
        (clojure.core/nth args6829 0)))))))
  (clojure.core/defn
   attach-internet-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [vpc-id
                         internet-gateway-id
                         general-progress-listener]}]]),
    :doc "Generate map for attachInternetGateway"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :attach-internet-gateway,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   attach-internet-gateway
   {:arglists (quote
               [[credentials
                 {:keys [vpc-id
                         internet-gateway-id
                         general-progress-listener]}]]),
    :doc "Call attachInternetGateway"}
   [credentials6832 & args6833]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client6834
     (com.palletops.awaze.common/aws-client :ec2 credentials6832)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6834
      attachInternetGateway
      (ec2/attach-internet-gateway-request
       (clojure.core/nth args6833 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-security-group
   [m6835]
   (clojure.core/let
    [credentials6836 (:credentials m6835) args6837 (:args m6835)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client6838
      (com.palletops.awaze.common/aws-client :ec2 credentials6836)]
     (clojure.core/case
      (clojure.core/count args6837)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6838
        deleteSecurityGroup))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6838
        deleteSecurityGroup
        (ec2/delete-security-group-request
         (clojure.core/nth args6837 0))))))))
  (clojure.core/defn
   delete-security-group-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [group-name
                         group-id
                         general-progress-listener]}]]),
    :doc "Generate map for deleteSecurityGroup, deleteSecurityGroup"}
   ([credentials__1651__auto__]
    {:args [],
     :client :ec2,
     :fn :delete-security-group,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :delete-security-group,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-security-group
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [group-name
                         group-id
                         general-progress-listener]}]]),
    :doc "Call deleteSecurityGroup, deleteSecurityGroup"}
   [credentials6840 & args6841]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client6842
     (com.palletops.awaze.common/aws-client :ec2 credentials6840)]
    (clojure.core/case
     (clojure.core/count args6841)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6842
       deleteSecurityGroup))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6842
       deleteSecurityGroup
       (ec2/delete-security-group-request
        (clojure.core/nth args6841 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :detach-volume
   [m6843]
   (clojure.core/let
    [credentials6844 (:credentials m6843) args6845 (:args m6843)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client6846
      (com.palletops.awaze.common/aws-client :ec2 credentials6844)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6846
       detachVolume
       (ec2/detach-volume-request (clojure.core/nth args6845 0)))))))
  (clojure.core/defn
   detach-volume-map
   {:arglists (quote
               [[credentials
                 {:keys [volume-id
                         force
                         device
                         general-progress-listener
                         instance-id]}]]),
    :doc "Generate map for detachVolume"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :detach-volume,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   detach-volume
   {:arglists (quote
               [[credentials
                 {:keys [volume-id
                         force
                         device
                         general-progress-listener
                         instance-id]}]]),
    :doc "Call detachVolume"}
   [credentials6848 & args6849]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client6850
     (com.palletops.awaze.common/aws-client :ec2 credentials6848)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6850
      detachVolume
      (ec2/detach-volume-request (clojure.core/nth args6849 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :release-address
   [m6851]
   (clojure.core/let
    [credentials6852 (:credentials m6851) args6853 (:args m6851)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client6854
      (com.palletops.awaze.common/aws-client :ec2 credentials6852)]
     (clojure.core/case
      (clojure.core/count args6853)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6854
        releaseAddress))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6854
        releaseAddress
        (ec2/release-address-request (clojure.core/nth args6853 0))))))))
  (clojure.core/defn
   release-address-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [public-ip
                         general-progress-listener
                         allocation-id]}]]),
    :doc "Generate map for releaseAddress, releaseAddress"}
   ([credentials__1651__auto__]
    {:args [],
     :client :ec2,
     :fn :release-address,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :release-address,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   release-address
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [public-ip
                         general-progress-listener
                         allocation-id]}]]),
    :doc "Call releaseAddress, releaseAddress"}
   [credentials6856 & args6857]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client6858
     (com.palletops.awaze.common/aws-client :ec2 credentials6856)]
    (clojure.core/case
     (clojure.core/count args6857)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6858
       releaseAddress))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6858
       releaseAddress
       (ec2/release-address-request (clojure.core/nth args6857 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :import-volume
   [m6859]
   (clojure.core/let
    [credentials6860 (:credentials m6859) args6861 (:args m6859)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client6862
      (com.palletops.awaze.common/aws-client :ec2 credentials6860)]
     (clojure.core/case
      (clojure.core/count args6861)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6862
        importVolume))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6862
        importVolume
        (ec2/import-volume-request (clojure.core/nth args6861 0))))))))
  (clojure.core/defn
   import-volume-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [volume
                         availability-zone
                         description
                         image
                         general-progress-listener]}]]),
    :doc "Generate map for importVolume, importVolume"}
   ([credentials__1651__auto__]
    {:args [],
     :client :ec2,
     :fn :import-volume,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :import-volume,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   import-volume
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [volume
                         availability-zone
                         description
                         image
                         general-progress-listener]}]]),
    :doc "Call importVolume, importVolume"}
   [credentials6864 & args6865]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client6866
     (com.palletops.awaze.common/aws-client :ec2 credentials6864)]
    (clojure.core/case
     (clojure.core/count args6865)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6866
       importVolume))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6866
       importVolume
       (ec2/import-volume-request (clojure.core/nth args6865 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-route-table
   [m6867]
   (clojure.core/let
    [credentials6868 (:credentials m6867) args6869 (:args m6867)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client6870
      (com.palletops.awaze.common/aws-client :ec2 credentials6868)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6870
       deleteRouteTable
       (ec2/delete-route-table-request (clojure.core/nth args6869 0)))))))
  (clojure.core/defn
   delete-route-table-map
   {:arglists (quote
               [[credentials
                 {:keys [route-table-id general-progress-listener]}]]),
    :doc "Generate map for deleteRouteTable"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :delete-route-table,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-route-table
   {:arglists (quote
               [[credentials
                 {:keys [route-table-id general-progress-listener]}]]),
    :doc "Call deleteRouteTable"}
   [credentials6872 & args6873]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client6874
     (com.palletops.awaze.common/aws-client :ec2 credentials6872)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6874
      deleteRouteTable
      (ec2/delete-route-table-request (clojure.core/nth args6873 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-snapshot-attribute
   [m6875]
   (clojure.core/let
    [credentials6876 (:credentials m6875) args6877 (:args m6875)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client6878
      (com.palletops.awaze.common/aws-client :ec2 credentials6876)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6878
       describeSnapshotAttribute
       (ec2/describe-snapshot-attribute-request
        (clojure.core/nth args6877 0)))))))
  (clojure.core/defn
   describe-snapshot-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [snapshot-id
                         general-progress-listener
                         attribute]}]]),
    :doc "Generate map for describeSnapshotAttribute"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-snapshot-attribute,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-snapshot-attribute
   {:arglists (quote
               [[credentials
                 {:keys [snapshot-id
                         general-progress-listener
                         attribute]}]]),
    :doc "Call describeSnapshotAttribute"}
   [credentials6880 & args6881]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client6882
     (com.palletops.awaze.common/aws-client :ec2 credentials6880)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6882
      describeSnapshotAttribute
      (ec2/describe-snapshot-attribute-request
       (clojure.core/nth args6881 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-instance-status
   [m6883]
   (clojure.core/let
    [credentials6884 (:credentials m6883) args6885 (:args m6883)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client6886
      (com.palletops.awaze.common/aws-client :ec2 credentials6884)]
     (clojure.core/case
      (clojure.core/count args6885)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6886
        describeInstanceStatus))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6886
        describeInstanceStatus
        (ec2/describe-instance-status-request
         (clojure.core/nth args6885 0))))))))
  (clojure.core/defn
   describe-instance-status-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [general-progress-listener
                         filters
                         max-results
                         include-all-instances
                         instance-ids
                         next-token]}]]),
    :doc "Generate map for describeInstanceStatus, describeInstanceStatus"}
   ([credentials__1651__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-instance-status,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-instance-status,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-instance-status
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [general-progress-listener
                         filters
                         max-results
                         include-all-instances
                         instance-ids
                         next-token]}]]),
    :doc "Call describeInstanceStatus, describeInstanceStatus"}
   [credentials6888 & args6889]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client6890
     (com.palletops.awaze.common/aws-client :ec2 credentials6888)]
    (clojure.core/case
     (clojure.core/count args6889)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6890
       describeInstanceStatus))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6890
       describeInstanceStatus
       (ec2/describe-instance-status-request
        (clojure.core/nth args6889 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-image-attribute
   [m6891]
   (clojure.core/let
    [credentials6892 (:credentials m6891) args6893 (:args m6891)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client6894
      (com.palletops.awaze.common/aws-client :ec2 credentials6892)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6894
       describeImageAttribute
       (ec2/describe-image-attribute-request
        (clojure.core/nth args6893 0)))))))
  (clojure.core/defn
   describe-image-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [image-id general-progress-listener attribute]}]]),
    :doc "Generate map for describeImageAttribute"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-image-attribute,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-image-attribute
   {:arglists (quote
               [[credentials
                 {:keys [image-id general-progress-listener attribute]}]]),
    :doc "Call describeImageAttribute"}
   [credentials6896 & args6897]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client6898
     (com.palletops.awaze.common/aws-client :ec2 credentials6896)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6898
      describeImageAttribute
      (ec2/describe-image-attribute-request
       (clojure.core/nth args6897 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :report-instance-status
   [m6899]
   (clojure.core/let
    [credentials6900 (:credentials m6899) args6901 (:args m6899)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client6902
      (com.palletops.awaze.common/aws-client :ec2 credentials6900)]
     (clojure.core/case
      (clojure.core/count args6901)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6902
        reportInstanceStatus))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6902
        reportInstanceStatus
        (ec2/report-instance-status-request
         (clojure.core/nth args6901 0))))))))
  (clojure.core/defn
   report-instance-status-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [end-time
                         status
                         general-progress-listener
                         reason-codes
                         start-time
                         description
                         instances]}]]),
    :doc "Generate map for reportInstanceStatus, reportInstanceStatus"}
   ([credentials__1651__auto__]
    {:args [],
     :client :ec2,
     :fn :report-instance-status,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :report-instance-status,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   report-instance-status
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [end-time
                         status
                         general-progress-listener
                         reason-codes
                         start-time
                         description
                         instances]}]]),
    :doc "Call reportInstanceStatus, reportInstanceStatus"}
   [credentials6904 & args6905]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client6906
     (com.palletops.awaze.common/aws-client :ec2 credentials6904)]
    (clojure.core/case
     (clojure.core/count args6905)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6906
       reportInstanceStatus))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6906
       reportInstanceStatus
       (ec2/report-instance-status-request
        (clojure.core/nth args6905 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-tags
   [m6907]
   (clojure.core/let
    [credentials6908 (:credentials m6907) args6909 (:args m6907)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client6910
      (com.palletops.awaze.common/aws-client :ec2 credentials6908)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6910
       deleteTags
       (ec2/delete-tags-request (clojure.core/nth args6909 0)))))))
  (clojure.core/defn
   delete-tags-map
   {:arglists (quote
               [[credentials
                 {:keys [tags resources general-progress-listener]}]]),
    :doc "Generate map for deleteTags"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :delete-tags,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-tags
   {:arglists (quote
               [[credentials
                 {:keys [tags resources general-progress-listener]}]]),
    :doc "Call deleteTags"}
   [credentials6912 & args6913]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client6914
     (com.palletops.awaze.common/aws-client :ec2 credentials6912)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6914
      deleteTags
      (ec2/delete-tags-request (clojure.core/nth args6913 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :reset-snapshot-attribute
   [m6915]
   (clojure.core/let
    [credentials6916 (:credentials m6915) args6917 (:args m6915)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client6918
      (com.palletops.awaze.common/aws-client :ec2 credentials6916)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6918
       resetSnapshotAttribute
       (ec2/reset-snapshot-attribute-request
        (clojure.core/nth args6917 0)))))))
  (clojure.core/defn
   reset-snapshot-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [snapshot-id
                         general-progress-listener
                         attribute]}]]),
    :doc "Generate map for resetSnapshotAttribute"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :reset-snapshot-attribute,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   reset-snapshot-attribute
   {:arglists (quote
               [[credentials
                 {:keys [snapshot-id
                         general-progress-listener
                         attribute]}]]),
    :doc "Call resetSnapshotAttribute"}
   [credentials6920 & args6921]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client6922
     (com.palletops.awaze.common/aws-client :ec2 credentials6920)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6922
      resetSnapshotAttribute
      (ec2/reset-snapshot-attribute-request
       (clojure.core/nth args6921 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :associate-dhcp-options
   [m6923]
   (clojure.core/let
    [credentials6924 (:credentials m6923) args6925 (:args m6923)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client6926
      (com.palletops.awaze.common/aws-client :ec2 credentials6924)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6926
       associateDhcpOptions
       (ec2/associate-dhcp-options-request
        (clojure.core/nth args6925 0)))))))
  (clojure.core/defn
   associate-dhcp-options-map
   {:arglists (quote
               [[credentials
                 {:keys [vpc-id
                         general-progress-listener
                         dhcp-options-id]}]]),
    :doc "Generate map for associateDhcpOptions"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :associate-dhcp-options,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   associate-dhcp-options
   {:arglists (quote
               [[credentials
                 {:keys [vpc-id
                         general-progress-listener
                         dhcp-options-id]}]]),
    :doc "Call associateDhcpOptions"}
   [credentials6928 & args6929]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client6930
     (com.palletops.awaze.common/aws-client :ec2 credentials6928)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6930
      associateDhcpOptions
      (ec2/associate-dhcp-options-request
       (clojure.core/nth args6929 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :modify-snapshot-attribute
   [m6931]
   (clojure.core/let
    [credentials6932 (:credentials m6931) args6933 (:args m6931)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client6934
      (com.palletops.awaze.common/aws-client :ec2 credentials6932)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6934
       modifySnapshotAttribute
       (ec2/modify-snapshot-attribute-request
        (clojure.core/nth args6933 0)))))))
  (clojure.core/defn
   modify-snapshot-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         group-names
                         snapshot-id
                         user-ids
                         operation-type
                         attribute
                         create-volume-permission]}]]),
    :doc "Generate map for modifySnapshotAttribute"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :modify-snapshot-attribute,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   modify-snapshot-attribute
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         group-names
                         snapshot-id
                         user-ids
                         operation-type
                         attribute
                         create-volume-permission]}]]),
    :doc "Call modifySnapshotAttribute"}
   [credentials6936 & args6937]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client6938
     (com.palletops.awaze.common/aws-client :ec2 credentials6936)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6938
      modifySnapshotAttribute
      (ec2/modify-snapshot-attribute-request
       (clojure.core/nth args6937 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :modify-volume-attribute
   [m6939]
   (clojure.core/let
    [credentials6940 (:credentials m6939) args6941 (:args m6939)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client6942
      (com.palletops.awaze.common/aws-client :ec2 credentials6940)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6942
       modifyVolumeAttribute
       (ec2/modify-volume-attribute-request
        (clojure.core/nth args6941 0)))))))
  (clojure.core/defn
   modify-volume-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [volume-id
                         general-progress-listener
                         auto-enable-io]}]]),
    :doc "Generate map for modifyVolumeAttribute"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :modify-volume-attribute,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   modify-volume-attribute
   {:arglists (quote
               [[credentials
                 {:keys [volume-id
                         general-progress-listener
                         auto-enable-io]}]]),
    :doc "Call modifyVolumeAttribute"}
   [credentials6944 & args6945]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client6946
     (com.palletops.awaze.common/aws-client :ec2 credentials6944)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6946
      modifyVolumeAttribute
      (ec2/modify-volume-attribute-request
       (clojure.core/nth args6945 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-placement-group
   [m6947]
   (clojure.core/let
    [credentials6948 (:credentials m6947) args6949 (:args m6947)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client6950
      (com.palletops.awaze.common/aws-client :ec2 credentials6948)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6950
       createPlacementGroup
       (ec2/create-placement-group-request
        (clojure.core/nth args6949 0)))))))
  (clojure.core/defn
   create-placement-group-map
   {:arglists (quote
               [[credentials
                 {:keys [strategy
                         group-name
                         general-progress-listener]}]]),
    :doc "Generate map for createPlacementGroup"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :create-placement-group,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-placement-group
   {:arglists (quote
               [[credentials
                 {:keys [strategy
                         group-name
                         general-progress-listener]}]]),
    :doc "Call createPlacementGroup"}
   [credentials6952 & args6953]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client6954
     (com.palletops.awaze.common/aws-client :ec2 credentials6952)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6954
      createPlacementGroup
      (ec2/create-placement-group-request
       (clojure.core/nth args6953 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-vpn-connections
   [m6955]
   (clojure.core/let
    [credentials6956 (:credentials m6955) args6957 (:args m6955)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client6958
      (com.palletops.awaze.common/aws-client :ec2 credentials6956)]
     (clojure.core/case
      (clojure.core/count args6957)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6958
        describeVpnConnections
        (ec2/describe-vpn-connections-request
         (clojure.core/nth args6957 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6958
        describeVpnConnections))))))
  (clojure.core/defn
   describe-vpn-connections-map
   {:arglists (quote
               [[credentials
                 {:keys [vpn-connection-ids
                         general-progress-listener
                         filters]}]
                [credentials]]),
    :doc "Generate map for describeVpnConnections, describeVpnConnections"}
   ([credentials__1651__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-vpn-connections,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-vpn-connections,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-vpn-connections
   {:arglists (quote
               [[credentials
                 {:keys [vpn-connection-ids
                         general-progress-listener
                         filters]}]
                [credentials]]),
    :doc "Call describeVpnConnections, describeVpnConnections"}
   [credentials6960 & args6961]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client6962
     (com.palletops.awaze.common/aws-client :ec2 credentials6960)]
    (clojure.core/case
     (clojure.core/count args6961)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6962
       describeVpnConnections
       (ec2/describe-vpn-connections-request
        (clojure.core/nth args6961 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6962
       describeVpnConnections))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-spot-price-history
   [m6963]
   (clojure.core/let
    [credentials6964 (:credentials m6963) args6965 (:args m6963)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client6966
      (com.palletops.awaze.common/aws-client :ec2 credentials6964)]
     (clojure.core/case
      (clojure.core/count args6965)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6966
        describeSpotPriceHistory
        (ec2/describe-spot-price-history-request
         (clojure.core/nth args6965 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6966
        describeSpotPriceHistory))))))
  (clojure.core/defn
   describe-spot-price-history-map
   {:arglists (quote
               [[credentials
                 {:keys [end-time
                         instance-types
                         product-descriptions
                         general-progress-listener
                         filters
                         availability-zone
                         max-results
                         start-time
                         next-token]}]
                [credentials]]),
    :doc "Generate map for describeSpotPriceHistory, describeSpotPriceHistory"}
   ([credentials__1651__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-spot-price-history,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-spot-price-history,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-spot-price-history
   {:arglists (quote
               [[credentials
                 {:keys [end-time
                         instance-types
                         product-descriptions
                         general-progress-listener
                         filters
                         availability-zone
                         max-results
                         start-time
                         next-token]}]
                [credentials]]),
    :doc "Call describeSpotPriceHistory, describeSpotPriceHistory"}
   [credentials6968 & args6969]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client6970
     (com.palletops.awaze.common/aws-client :ec2 credentials6968)]
    (clojure.core/case
     (clojure.core/count args6969)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6970
       describeSpotPriceHistory
       (ec2/describe-spot-price-history-request
        (clojure.core/nth args6969 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6970
       describeSpotPriceHistory))))))
 (do
  (clojure.core/defmethod
   ec2
   :reject-vpc-peering-connection
   [m6971]
   (clojure.core/let
    [credentials6972 (:credentials m6971) args6973 (:args m6971)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client6974
      (com.palletops.awaze.common/aws-client :ec2 credentials6972)]
     (clojure.core/case
      (clojure.core/count args6973)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6974
        rejectVpcPeeringConnection
        (ec2/reject-vpc-peering-connection-request
         (clojure.core/nth args6973 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6974
        rejectVpcPeeringConnection))))))
  (clojure.core/defn
   reject-vpc-peering-connection-map
   {:arglists (quote
               [[credentials
                 {:keys [vpc-peering-connection-id
                         general-progress-listener]}]
                [credentials]]),
    :doc "Generate map for rejectVpcPeeringConnection, rejectVpcPeeringConnection"}
   ([credentials__1651__auto__]
    {:args [],
     :client :ec2,
     :fn :reject-vpc-peering-connection,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :reject-vpc-peering-connection,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   reject-vpc-peering-connection
   {:arglists (quote
               [[credentials
                 {:keys [vpc-peering-connection-id
                         general-progress-listener]}]
                [credentials]]),
    :doc "Call rejectVpcPeeringConnection, rejectVpcPeeringConnection"}
   [credentials6976 & args6977]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client6978
     (com.palletops.awaze.common/aws-client :ec2 credentials6976)]
    (clojure.core/case
     (clojure.core/count args6977)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6978
       rejectVpcPeeringConnection
       (ec2/reject-vpc-peering-connection-request
        (clojure.core/nth args6977 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6978
       rejectVpcPeeringConnection))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-vpc
   [m6979]
   (clojure.core/let
    [credentials6980 (:credentials m6979) args6981 (:args m6979)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client6982
      (com.palletops.awaze.common/aws-client :ec2 credentials6980)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6982
       deleteVpc
       (ec2/delete-vpc-request (clojure.core/nth args6981 0)))))))
  (clojure.core/defn
   delete-vpc-map
   {:arglists (quote
               [[credentials
                 {:keys [vpc-id general-progress-listener]}]]),
    :doc "Generate map for deleteVpc"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :delete-vpc,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-vpc
   {:arglists (quote
               [[credentials
                 {:keys [vpc-id general-progress-listener]}]]),
    :doc "Call deleteVpc"}
   [credentials6984 & args6985]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client6986
     (com.palletops.awaze.common/aws-client :ec2 credentials6984)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6986
      deleteVpc
      (ec2/delete-vpc-request (clojure.core/nth args6985 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-route-table
   [m6987]
   (clojure.core/let
    [credentials6988 (:credentials m6987) args6989 (:args m6987)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client6990
      (com.palletops.awaze.common/aws-client :ec2 credentials6988)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6990
       createRouteTable
       (ec2/create-route-table-request (clojure.core/nth args6989 0)))))))
  (clojure.core/defn
   create-route-table-map
   {:arglists (quote
               [[credentials
                 {:keys [vpc-id general-progress-listener]}]]),
    :doc "Generate map for createRouteTable"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :create-route-table,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-route-table
   {:arglists (quote
               [[credentials
                 {:keys [vpc-id general-progress-listener]}]]),
    :doc "Call createRouteTable"}
   [credentials6992 & args6993]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client6994
     (com.palletops.awaze.common/aws-client :ec2 credentials6992)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6994
      createRouteTable
      (ec2/create-route-table-request (clojure.core/nth args6993 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :terminate-instances
   [m6995]
   (clojure.core/let
    [credentials6996 (:credentials m6995) args6997 (:args m6995)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client6998
      (com.palletops.awaze.common/aws-client :ec2 credentials6996)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client6998
       terminateInstances
       (ec2/terminate-instances-request (clojure.core/nth args6997 0)))))))
  (clojure.core/defn
   terminate-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [instance-ids general-progress-listener]}]]),
    :doc "Generate map for terminateInstances"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :terminate-instances,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   terminate-instances
   {:arglists (quote
               [[credentials
                 {:keys [instance-ids general-progress-listener]}]]),
    :doc "Call terminateInstances"}
   [credentials7000 & args7001]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7002
     (com.palletops.awaze.common/aws-client :ec2 credentials7000)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7002
      terminateInstances
      (ec2/terminate-instances-request (clojure.core/nth args7001 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-bundle-tasks
   [m7003]
   (clojure.core/let
    [credentials7004 (:credentials m7003) args7005 (:args m7003)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7006
      (com.palletops.awaze.common/aws-client :ec2 credentials7004)]
     (clojure.core/case
      (clojure.core/count args7005)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7006
        describeBundleTasks
        (ec2/describe-bundle-tasks-request
         (clojure.core/nth args7005 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7006
        describeBundleTasks))))))
  (clojure.core/defn
   describe-bundle-tasks-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener filters bundle-ids]}]
                [credentials]]),
    :doc "Generate map for describeBundleTasks, describeBundleTasks"}
   ([credentials__1651__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-bundle-tasks,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-bundle-tasks,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-bundle-tasks
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener filters bundle-ids]}]
                [credentials]]),
    :doc "Call describeBundleTasks, describeBundleTasks"}
   [credentials7008 & args7009]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7010
     (com.palletops.awaze.common/aws-client :ec2 credentials7008)]
    (clojure.core/case
     (clojure.core/count args7009)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7010
       describeBundleTasks
       (ec2/describe-bundle-tasks-request
        (clojure.core/nth args7009 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7010
       describeBundleTasks))))))
 (do
  (clojure.core/defmethod
   ec2
   :associate-address
   [m7011]
   (clojure.core/let
    [credentials7012 (:credentials m7011) args7013 (:args m7011)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7014
      (com.palletops.awaze.common/aws-client :ec2 credentials7012)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7014
       associateAddress
       (ec2/associate-address-request (clojure.core/nth args7013 0)))))))
  (clojure.core/defn
   associate-address-map
   {:arglists (quote
               [[credentials
                 {:keys [allocation-id
                         general-progress-listener
                         public-ip
                         private-ip-address
                         allow-reassociation
                         network-interface-id
                         instance-id]}]]),
    :doc "Generate map for associateAddress"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :associate-address,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   associate-address
   {:arglists (quote
               [[credentials
                 {:keys [allocation-id
                         general-progress-listener
                         public-ip
                         private-ip-address
                         allow-reassociation
                         network-interface-id
                         instance-id]}]]),
    :doc "Call associateAddress"}
   [credentials7016 & args7017]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7018
     (com.palletops.awaze.common/aws-client :ec2 credentials7016)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7018
      associateAddress
      (ec2/associate-address-request (clojure.core/nth args7017 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-volume
   [m7019]
   (clojure.core/let
    [credentials7020 (:credentials m7019) args7021 (:args m7019)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7022
      (com.palletops.awaze.common/aws-client :ec2 credentials7020)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7022
       createVolume
       (ec2/create-volume-request (clojure.core/nth args7021 0)))))))
  (clojure.core/defn
   create-volume-map
   {:arglists (quote
               [[credentials
                 {:keys [iops
                         general-progress-listener
                         encrypted
                         snapshot-id
                         availability-zone
                         volume-type
                         size]}]]),
    :doc "Generate map for createVolume"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :create-volume,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-volume
   {:arglists (quote
               [[credentials
                 {:keys [iops
                         general-progress-listener
                         encrypted
                         snapshot-id
                         availability-zone
                         volume-type
                         size]}]]),
    :doc "Call createVolume"}
   [credentials7024 & args7025]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7026
     (com.palletops.awaze.common/aws-client :ec2 credentials7024)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7026
      createVolume
      (ec2/create-volume-request (clojure.core/nth args7025 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :modify-reserved-instances
   [m7027]
   (clojure.core/let
    [credentials7028 (:credentials m7027) args7029 (:args m7027)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7030
      (com.palletops.awaze.common/aws-client :ec2 credentials7028)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7030
       modifyReservedInstances
       (ec2/modify-reserved-instances-request
        (clojure.core/nth args7029 0)))))))
  (clojure.core/defn
   modify-reserved-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [target-configurations
                         reserved-instances-ids
                         general-progress-listener
                         client-token]}]]),
    :doc "Generate map for modifyReservedInstances"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :modify-reserved-instances,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   modify-reserved-instances
   {:arglists (quote
               [[credentials
                 {:keys [target-configurations
                         reserved-instances-ids
                         general-progress-listener
                         client-token]}]]),
    :doc "Call modifyReservedInstances"}
   [credentials7032 & args7033]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7034
     (com.palletops.awaze.common/aws-client :ec2 credentials7032)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7034
      modifyReservedInstances
      (ec2/modify-reserved-instances-request
       (clojure.core/nth args7033 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-vpc-attribute
   [m7035]
   (clojure.core/let
    [credentials7036 (:credentials m7035) args7037 (:args m7035)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7038
      (com.palletops.awaze.common/aws-client :ec2 credentials7036)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7038
       describeVpcAttribute
       (ec2/describe-vpc-attribute-request
        (clojure.core/nth args7037 0)))))))
  (clojure.core/defn
   describe-vpc-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [vpc-id general-progress-listener attribute]}]]),
    :doc "Generate map for describeVpcAttribute"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-vpc-attribute,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-vpc-attribute
   {:arglists (quote
               [[credentials
                 {:keys [vpc-id general-progress-listener attribute]}]]),
    :doc "Call describeVpcAttribute"}
   [credentials7040 & args7041]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7042
     (com.palletops.awaze.common/aws-client :ec2 credentials7040)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7042
      describeVpcAttribute
      (ec2/describe-vpc-attribute-request
       (clojure.core/nth args7041 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :authorize-security-group-egress
   [m7043]
   (clojure.core/let
    [credentials7044 (:credentials m7043) args7045 (:args m7043)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7046
      (com.palletops.awaze.common/aws-client :ec2 credentials7044)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7046
       authorizeSecurityGroupEgress
       (ec2/authorize-security-group-egress-request
        (clojure.core/nth args7045 0)))))))
  (clojure.core/defn
   authorize-security-group-egress-map
   {:arglists (quote
               [[credentials
                 {:keys [source-security-group-name
                         group-id
                         general-progress-listener
                         from-port
                         ip-permissions
                         to-port
                         cidr-ip
                         ip-protocol
                         source-security-group-owner-id]}]]),
    :doc "Generate map for authorizeSecurityGroupEgress"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :authorize-security-group-egress,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   authorize-security-group-egress
   {:arglists (quote
               [[credentials
                 {:keys [source-security-group-name
                         group-id
                         general-progress-listener
                         from-port
                         ip-permissions
                         to-port
                         cidr-ip
                         ip-protocol
                         source-security-group-owner-id]}]]),
    :doc "Call authorizeSecurityGroupEgress"}
   [credentials7048 & args7049]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7050
     (com.palletops.awaze.common/aws-client :ec2 credentials7048)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7050
      authorizeSecurityGroupEgress
      (ec2/authorize-security-group-egress-request
       (clojure.core/nth args7049 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-customer-gateway
   [m7051]
   (clojure.core/let
    [credentials7052 (:credentials m7051) args7053 (:args m7051)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7054
      (com.palletops.awaze.common/aws-client :ec2 credentials7052)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7054
       deleteCustomerGateway
       (ec2/delete-customer-gateway-request
        (clojure.core/nth args7053 0)))))))
  (clojure.core/defn
   delete-customer-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         customer-gateway-id]}]]),
    :doc "Generate map for deleteCustomerGateway"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :delete-customer-gateway,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-customer-gateway
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         customer-gateway-id]}]]),
    :doc "Call deleteCustomerGateway"}
   [credentials7056 & args7057]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7058
     (com.palletops.awaze.common/aws-client :ec2 credentials7056)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7058
      deleteCustomerGateway
      (ec2/delete-customer-gateway-request
       (clojure.core/nth args7057 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :replace-network-acl-entry
   [m7059]
   (clojure.core/let
    [credentials7060 (:credentials m7059) args7061 (:args m7059)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7062
      (com.palletops.awaze.common/aws-client :ec2 credentials7060)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7062
       replaceNetworkAclEntry
       (ec2/replace-network-acl-entry-request
        (clojure.core/nth args7061 0)))))))
  (clojure.core/defn
   replace-network-acl-entry-map
   {:arglists (quote
               [[credentials
                 {:keys [protocol
                         general-progress-listener
                         icmp-type-code
                         network-acl-id
                         rule-number
                         cidr-block
                         egress
                         port-range
                         rule-action]}]]),
    :doc "Generate map for replaceNetworkAclEntry"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :replace-network-acl-entry,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   replace-network-acl-entry
   {:arglists (quote
               [[credentials
                 {:keys [protocol
                         general-progress-listener
                         icmp-type-code
                         network-acl-id
                         rule-number
                         cidr-block
                         egress
                         port-range
                         rule-action]}]]),
    :doc "Call replaceNetworkAclEntry"}
   [credentials7064 & args7065]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7066
     (com.palletops.awaze.common/aws-client :ec2 credentials7064)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7066
      replaceNetworkAclEntry
      (ec2/replace-network-acl-entry-request
       (clojure.core/nth args7065 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-vpc-peering-connection
   [m7067]
   (clojure.core/let
    [credentials7068 (:credentials m7067) args7069 (:args m7067)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7070
      (com.palletops.awaze.common/aws-client :ec2 credentials7068)]
     (clojure.core/case
      (clojure.core/count args7069)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7070
        createVpcPeeringConnection))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7070
        createVpcPeeringConnection
        (ec2/create-vpc-peering-connection-request
         (clojure.core/nth args7069 0))))))))
  (clojure.core/defn
   create-vpc-peering-connection-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [vpc-id
                         peer-vpc-id
                         peer-owner-id
                         general-progress-listener]}]]),
    :doc "Generate map for createVpcPeeringConnection, createVpcPeeringConnection"}
   ([credentials__1651__auto__]
    {:args [],
     :client :ec2,
     :fn :create-vpc-peering-connection,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :create-vpc-peering-connection,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-vpc-peering-connection
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [vpc-id
                         peer-vpc-id
                         peer-owner-id
                         general-progress-listener]}]]),
    :doc "Call createVpcPeeringConnection, createVpcPeeringConnection"}
   [credentials7072 & args7073]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7074
     (com.palletops.awaze.common/aws-client :ec2 credentials7072)]
    (clojure.core/case
     (clojure.core/count args7073)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7074
       createVpcPeeringConnection))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7074
       createVpcPeeringConnection
       (ec2/create-vpc-peering-connection-request
        (clojure.core/nth args7073 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-subnets
   [m7075]
   (clojure.core/let
    [credentials7076 (:credentials m7075) args7077 (:args m7075)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7078
      (com.palletops.awaze.common/aws-client :ec2 credentials7076)]
     (clojure.core/case
      (clojure.core/count args7077)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7078
        describeSubnets
        (ec2/describe-subnets-request (clojure.core/nth args7077 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7078
        describeSubnets))))))
  (clojure.core/defn
   describe-subnets-map
   {:arglists (quote
               [[credentials
                 {:keys [subnet-ids general-progress-listener filters]}]
                [credentials]]),
    :doc "Generate map for describeSubnets, describeSubnets"}
   ([credentials__1651__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-subnets,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-subnets,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-subnets
   {:arglists (quote
               [[credentials
                 {:keys [subnet-ids general-progress-listener filters]}]
                [credentials]]),
    :doc "Call describeSubnets, describeSubnets"}
   [credentials7080 & args7081]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7082
     (com.palletops.awaze.common/aws-client :ec2 credentials7080)]
    (clojure.core/case
     (clojure.core/count args7081)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7082
       describeSubnets
       (ec2/describe-subnets-request (clojure.core/nth args7081 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7082
       describeSubnets))))))
 (do
  (clojure.core/defmethod
   ec2
   :get-console-output
   [m7083]
   (clojure.core/let
    [credentials7084 (:credentials m7083) args7085 (:args m7083)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7086
      (com.palletops.awaze.common/aws-client :ec2 credentials7084)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7086
       getConsoleOutput
       (ec2/get-console-output-request (clojure.core/nth args7085 0)))))))
  (clojure.core/defn
   get-console-output-map
   {:arglists (quote
               [[credentials
                 {:keys [instance-id general-progress-listener]}]]),
    :doc "Generate map for getConsoleOutput"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :get-console-output,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   get-console-output
   {:arglists (quote
               [[credentials
                 {:keys [instance-id general-progress-listener]}]]),
    :doc "Call getConsoleOutput"}
   [credentials7088 & args7089]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7090
     (com.palletops.awaze.common/aws-client :ec2 credentials7088)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7090
      getConsoleOutput
      (ec2/get-console-output-request (clojure.core/nth args7089 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :cancel-conversion-task
   [m7091]
   (clojure.core/let
    [credentials7092 (:credentials m7091) args7093 (:args m7091)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7094
      (com.palletops.awaze.common/aws-client :ec2 credentials7092)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7094
       cancelConversionTask
       (ec2/cancel-conversion-task-request
        (clojure.core/nth args7093 0)))))))
  (clojure.core/defn
   cancel-conversion-task-map
   {:arglists (quote
               [[credentials
                 {:keys [reason-message
                         general-progress-listener
                         conversion-task-id]}]]),
    :doc "Generate map for cancelConversionTask"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :cancel-conversion-task,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   cancel-conversion-task
   {:arglists (quote
               [[credentials
                 {:keys [reason-message
                         general-progress-listener
                         conversion-task-id]}]]),
    :doc "Call cancelConversionTask"}
   [credentials7096 & args7097]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7098
     (com.palletops.awaze.common/aws-client :ec2 credentials7096)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7098
      cancelConversionTask
      (ec2/cancel-conversion-task-request
       (clojure.core/nth args7097 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :attach-vpn-gateway
   [m7099]
   (clojure.core/let
    [credentials7100 (:credentials m7099) args7101 (:args m7099)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7102
      (com.palletops.awaze.common/aws-client :ec2 credentials7100)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7102
       attachVpnGateway
       (ec2/attach-vpn-gateway-request (clojure.core/nth args7101 0)))))))
  (clojure.core/defn
   attach-vpn-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [vpn-gateway-id
                         vpc-id
                         general-progress-listener]}]]),
    :doc "Generate map for attachVpnGateway"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :attach-vpn-gateway,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   attach-vpn-gateway
   {:arglists (quote
               [[credentials
                 {:keys [vpn-gateway-id
                         vpc-id
                         general-progress-listener]}]]),
    :doc "Call attachVpnGateway"}
   [credentials7104 & args7105]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7106
     (com.palletops.awaze.common/aws-client :ec2 credentials7104)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7106
      attachVpnGateway
      (ec2/attach-vpn-gateway-request (clojure.core/nth args7105 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-vpc-peering-connections
   [m7107]
   (clojure.core/let
    [credentials7108 (:credentials m7107) args7109 (:args m7107)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7110
      (com.palletops.awaze.common/aws-client :ec2 credentials7108)]
     (clojure.core/case
      (clojure.core/count args7109)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7110
        describeVpcPeeringConnections
        (ec2/describe-vpc-peering-connections-request
         (clojure.core/nth args7109 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7110
        describeVpcPeeringConnections))))))
  (clojure.core/defn
   describe-vpc-peering-connections-map
   {:arglists (quote
               [[credentials
                 {:keys [vpc-peering-connection-ids
                         general-progress-listener
                         filters]}]
                [credentials]]),
    :doc "Generate map for describeVpcPeeringConnections, describeVpcPeeringConnections"}
   ([credentials__1651__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-vpc-peering-connections,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-vpc-peering-connections,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-vpc-peering-connections
   {:arglists (quote
               [[credentials
                 {:keys [vpc-peering-connection-ids
                         general-progress-listener
                         filters]}]
                [credentials]]),
    :doc "Call describeVpcPeeringConnections, describeVpcPeeringConnections"}
   [credentials7112 & args7113]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7114
     (com.palletops.awaze.common/aws-client :ec2 credentials7112)]
    (clojure.core/case
     (clojure.core/count args7113)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7114
       describeVpcPeeringConnections
       (ec2/describe-vpc-peering-connections-request
        (clojure.core/nth args7113 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7114
       describeVpcPeeringConnections))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-vpn-connection-route
   [m7115]
   (clojure.core/let
    [credentials7116 (:credentials m7115) args7117 (:args m7115)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7118
      (com.palletops.awaze.common/aws-client :ec2 credentials7116)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7118
       deleteVpnConnectionRoute
       (ec2/delete-vpn-connection-route-request
        (clojure.core/nth args7117 0)))))))
  (clojure.core/defn
   delete-vpn-connection-route-map
   {:arglists (quote
               [[credentials
                 {:keys [vpn-connection-id
                         general-progress-listener
                         destination-cidr-block]}]]),
    :doc "Generate map for deleteVpnConnectionRoute"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :delete-vpn-connection-route,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-vpn-connection-route
   {:arglists (quote
               [[credentials
                 {:keys [vpn-connection-id
                         general-progress-listener
                         destination-cidr-block]}]]),
    :doc "Call deleteVpnConnectionRoute"}
   [credentials7120 & args7121]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7122
     (com.palletops.awaze.common/aws-client :ec2 credentials7120)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7122
      deleteVpnConnectionRoute
      (ec2/delete-vpn-connection-route-request
       (clojure.core/nth args7121 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :run-instances
   [m7123]
   (clojure.core/let
    [credentials7124 (:credentials m7123) args7125 (:args m7123)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7126
      (com.palletops.awaze.common/aws-client :ec2 credentials7124)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7126
       runInstances
       (ec2/run-instances-request (clojure.core/nth args7125 0)))))))
  (clojure.core/defn
   run-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [instance-type
                         kernel-id
                         additional-info
                         general-progress-listener
                         ebs-optimized
                         subnet-id
                         max-count
                         block-device-mappings
                         network-interfaces
                         placement
                         private-ip-address
                         disable-api-termination
                         user-data
                         security-groups
                         ramdisk-id
                         iam-instance-profile
                         min-count
                         security-group-ids
                         key-name
                         client-token
                         image-id
                         monitoring
                         instance-initiated-shutdown-behavior]}]]),
    :doc "Generate map for runInstances"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :run-instances,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   run-instances
   {:arglists (quote
               [[credentials
                 {:keys [instance-type
                         kernel-id
                         additional-info
                         general-progress-listener
                         ebs-optimized
                         subnet-id
                         max-count
                         block-device-mappings
                         network-interfaces
                         placement
                         private-ip-address
                         disable-api-termination
                         user-data
                         security-groups
                         ramdisk-id
                         iam-instance-profile
                         min-count
                         security-group-ids
                         key-name
                         client-token
                         image-id
                         monitoring
                         instance-initiated-shutdown-behavior]}]]),
    :doc "Call runInstances"}
   [credentials7128 & args7129]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7130
     (com.palletops.awaze.common/aws-client :ec2 credentials7128)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7130
      runInstances
      (ec2/run-instances-request (clojure.core/nth args7129 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :register-image
   [m7131]
   (clojure.core/let
    [credentials7132 (:credentials m7131) args7133 (:args m7131)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7134
      (com.palletops.awaze.common/aws-client :ec2 credentials7132)]
     (clojure.core/case
      (clojure.core/count args7133)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7134
        registerImage
        (ec2/register-image-request (clojure.core/nth args7133 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7134
        registerImage))))))
  (clojure.core/defn
   register-image-map
   {:arglists (quote
               [[credentials
                 {:keys [kernel-id
                         general-progress-listener
                         name
                         root-device-name
                         virtualization-type
                         block-device-mappings
                         image-location
                         ramdisk-id
                         architecture
                         sriov-net-support
                         description]}]
                [credentials]]),
    :doc "Generate map for registerImage, registerImage"}
   ([credentials__1651__auto__]
    {:args [],
     :client :ec2,
     :fn :register-image,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :register-image,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   register-image
   {:arglists (quote
               [[credentials
                 {:keys [kernel-id
                         general-progress-listener
                         name
                         root-device-name
                         virtualization-type
                         block-device-mappings
                         image-location
                         ramdisk-id
                         architecture
                         sriov-net-support
                         description]}]
                [credentials]]),
    :doc "Call registerImage, registerImage"}
   [credentials7136 & args7137]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7138
     (com.palletops.awaze.common/aws-client :ec2 credentials7136)]
    (clojure.core/case
     (clojure.core/count args7137)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7138
       registerImage
       (ec2/register-image-request (clojure.core/nth args7137 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7138
       registerImage))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-tags
   [m7139]
   (clojure.core/let
    [credentials7140 (:credentials m7139) args7141 (:args m7139)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7142
      (com.palletops.awaze.common/aws-client :ec2 credentials7140)]
     (clojure.core/case
      (clojure.core/count args7141)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7142
        describeTags))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7142
        describeTags
        (ec2/describe-tags-request (clojure.core/nth args7141 0))))))))
  (clojure.core/defn
   describe-tags-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [next-token
                         max-results
                         general-progress-listener
                         filters]}]]),
    :doc "Generate map for describeTags, describeTags"}
   ([credentials__1651__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-tags,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-tags,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-tags
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [next-token
                         max-results
                         general-progress-listener
                         filters]}]]),
    :doc "Call describeTags, describeTags"}
   [credentials7144 & args7145]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7146
     (com.palletops.awaze.common/aws-client :ec2 credentials7144)]
    (clojure.core/case
     (clojure.core/count args7145)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7146
       describeTags))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7146
       describeTags
       (ec2/describe-tags-request (clojure.core/nth args7145 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-reserved-instances
   [m7147]
   (clojure.core/let
    [credentials7148 (:credentials m7147) args7149 (:args m7147)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7150
      (com.palletops.awaze.common/aws-client :ec2 credentials7148)]
     (clojure.core/case
      (clojure.core/count args7149)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7150
        describeReservedInstances))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7150
        describeReservedInstances
        (ec2/describe-reserved-instances-request
         (clojure.core/nth args7149 0))))))))
  (clojure.core/defn
   describe-reserved-instances-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [reserved-instances-ids
                         offering-type
                         general-progress-listener
                         filters]}]]),
    :doc "Generate map for describeReservedInstances, describeReservedInstances"}
   ([credentials__1651__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-reserved-instances,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-reserved-instances,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-reserved-instances
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [reserved-instances-ids
                         offering-type
                         general-progress-listener
                         filters]}]]),
    :doc "Call describeReservedInstances, describeReservedInstances"}
   [credentials7152 & args7153]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7154
     (com.palletops.awaze.common/aws-client :ec2 credentials7152)]
    (clojure.core/case
     (clojure.core/count args7153)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7154
       describeReservedInstances))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7154
       describeReservedInstances
       (ec2/describe-reserved-instances-request
        (clojure.core/nth args7153 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :detach-vpn-gateway
   [m7155]
   (clojure.core/let
    [credentials7156 (:credentials m7155) args7157 (:args m7155)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7158
      (com.palletops.awaze.common/aws-client :ec2 credentials7156)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7158
       detachVpnGateway
       (ec2/detach-vpn-gateway-request (clojure.core/nth args7157 0)))))))
  (clojure.core/defn
   detach-vpn-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [vpn-gateway-id
                         vpc-id
                         general-progress-listener]}]]),
    :doc "Generate map for detachVpnGateway"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :detach-vpn-gateway,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   detach-vpn-gateway
   {:arglists (quote
               [[credentials
                 {:keys [vpn-gateway-id
                         vpc-id
                         general-progress-listener]}]]),
    :doc "Call detachVpnGateway"}
   [credentials7160 & args7161]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7162
     (com.palletops.awaze.common/aws-client :ec2 credentials7160)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7162
      detachVpnGateway
      (ec2/detach-vpn-gateway-request (clojure.core/nth args7161 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-customer-gateways
   [m7163]
   (clojure.core/let
    [credentials7164 (:credentials m7163) args7165 (:args m7163)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7166
      (com.palletops.awaze.common/aws-client :ec2 credentials7164)]
     (clojure.core/case
      (clojure.core/count args7165)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7166
        describeCustomerGateways))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7166
        describeCustomerGateways
        (ec2/describe-customer-gateways-request
         (clojure.core/nth args7165 0))))))))
  (clojure.core/defn
   describe-customer-gateways-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [general-progress-listener
                         filters
                         customer-gateway-ids]}]]),
    :doc "Generate map for describeCustomerGateways, describeCustomerGateways"}
   ([credentials__1651__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-customer-gateways,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-customer-gateways,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-customer-gateways
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [general-progress-listener
                         filters
                         customer-gateway-ids]}]]),
    :doc "Call describeCustomerGateways, describeCustomerGateways"}
   [credentials7168 & args7169]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7170
     (com.palletops.awaze.common/aws-client :ec2 credentials7168)]
    (clojure.core/case
     (clojure.core/count args7169)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7170
       describeCustomerGateways))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7170
       describeCustomerGateways
       (ec2/describe-customer-gateways-request
        (clojure.core/nth args7169 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-network-interface-attribute
   [m7171]
   (clojure.core/let
    [credentials7172 (:credentials m7171) args7173 (:args m7171)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7174
      (com.palletops.awaze.common/aws-client :ec2 credentials7172)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7174
       describeNetworkInterfaceAttribute
       (ec2/describe-network-interface-attribute-request
        (clojure.core/nth args7173 0)))))))
  (clojure.core/defn
   describe-network-interface-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         source-dest-check
                         network-interface-id
                         groups
                         attachment
                         description]}]]),
    :doc "Generate map for describeNetworkInterfaceAttribute"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-network-interface-attribute,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-network-interface-attribute
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         source-dest-check
                         network-interface-id
                         groups
                         attachment
                         description]}]]),
    :doc "Call describeNetworkInterfaceAttribute"}
   [credentials7176 & args7177]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7178
     (com.palletops.awaze.common/aws-client :ec2 credentials7176)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7178
      describeNetworkInterfaceAttribute
      (ec2/describe-network-interface-attribute-request
       (clojure.core/nth args7177 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :import-key-pair
   [m7179]
   (clojure.core/let
    [credentials7180 (:credentials m7179) args7181 (:args m7179)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7182
      (com.palletops.awaze.common/aws-client :ec2 credentials7180)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7182
       importKeyPair
       (ec2/import-key-pair-request (clojure.core/nth args7181 0)))))))
  (clojure.core/defn
   import-key-pair-map
   {:arglists (quote
               [[credentials
                 {:keys [public-key-material
                         key-name
                         general-progress-listener]}]]),
    :doc "Generate map for importKeyPair"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :import-key-pair,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   import-key-pair
   {:arglists (quote
               [[credentials
                 {:keys [public-key-material
                         key-name
                         general-progress-listener]}]]),
    :doc "Call importKeyPair"}
   [credentials7184 & args7185]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7186
     (com.palletops.awaze.common/aws-client :ec2 credentials7184)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7186
      importKeyPair
      (ec2/import-key-pair-request (clojure.core/nth args7185 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :import-instance
   [m7187]
   (clojure.core/let
    [credentials7188 (:credentials m7187) args7189 (:args m7187)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7190
      (com.palletops.awaze.common/aws-client :ec2 credentials7188)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7190
       importInstance
       (ec2/import-instance-request (clojure.core/nth args7189 0)))))))
  (clojure.core/defn
   import-instance-map
   {:arglists (quote
               [[credentials
                 {:keys [platform
                         description
                         disk-images
                         general-progress-listener
                         launch-specification]}]]),
    :doc "Generate map for importInstance"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :import-instance,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   import-instance
   {:arglists (quote
               [[credentials
                 {:keys [platform
                         description
                         disk-images
                         general-progress-listener
                         launch-specification]}]]),
    :doc "Call importInstance"}
   [credentials7192 & args7193]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7194
     (com.palletops.awaze.common/aws-client :ec2 credentials7192)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7194
      importInstance
      (ec2/import-instance-request (clojure.core/nth args7193 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :allocate-address
   [m7195]
   (clojure.core/let
    [credentials7196 (:credentials m7195) args7197 (:args m7195)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7198
      (com.palletops.awaze.common/aws-client :ec2 credentials7196)]
     (clojure.core/case
      (clojure.core/count args7197)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7198
        allocateAddress))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7198
        allocateAddress
        (ec2/allocate-address-request (clojure.core/nth args7197 0))))))))
  (clojure.core/defn
   allocate-address-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [general-progress-listener domain]}]]),
    :doc "Generate map for allocateAddress, allocateAddress"}
   ([credentials__1651__auto__]
    {:args [],
     :client :ec2,
     :fn :allocate-address,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :allocate-address,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   allocate-address
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [general-progress-listener domain]}]]),
    :doc "Call allocateAddress, allocateAddress"}
   [credentials7200 & args7201]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7202
     (com.palletops.awaze.common/aws-client :ec2 credentials7200)]
    (clojure.core/case
     (clojure.core/count args7201)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7202
       allocateAddress))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7202
       allocateAddress
       (ec2/allocate-address-request (clojure.core/nth args7201 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-spot-instance-requests
   [m7203]
   (clojure.core/let
    [credentials7204 (:credentials m7203) args7205 (:args m7203)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7206
      (com.palletops.awaze.common/aws-client :ec2 credentials7204)]
     (clojure.core/case
      (clojure.core/count args7205)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7206
        describeSpotInstanceRequests))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7206
        describeSpotInstanceRequests
        (ec2/describe-spot-instance-requests-request
         (clojure.core/nth args7205 0))))))))
  (clojure.core/defn
   describe-spot-instance-requests-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [spot-instance-request-ids
                         general-progress-listener
                         filters]}]]),
    :doc "Generate map for describeSpotInstanceRequests, describeSpotInstanceRequests"}
   ([credentials__1651__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-spot-instance-requests,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-spot-instance-requests,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-spot-instance-requests
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [spot-instance-request-ids
                         general-progress-listener
                         filters]}]]),
    :doc "Call describeSpotInstanceRequests, describeSpotInstanceRequests"}
   [credentials7208 & args7209]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7210
     (com.palletops.awaze.common/aws-client :ec2 credentials7208)]
    (clojure.core/case
     (clojure.core/count args7209)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7210
       describeSpotInstanceRequests))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7210
       describeSpotInstanceRequests
       (ec2/describe-spot-instance-requests-request
        (clojure.core/nth args7209 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-spot-datafeed-subscription
   [m7211]
   (clojure.core/let
    [credentials7212 (:credentials m7211) args7213 (:args m7211)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7214
      (com.palletops.awaze.common/aws-client :ec2 credentials7212)]
     (clojure.core/case
      (clojure.core/count args7213)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7214
        deleteSpotDatafeedSubscription))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7214
        deleteSpotDatafeedSubscription
        (ec2/delete-spot-datafeed-subscription-request
         (clojure.core/nth args7213 0))))))))
  (clojure.core/defn
   delete-spot-datafeed-subscription-map
   {:arglists (quote
               [[credentials]
                [credentials {:keys [general-progress-listener]}]]),
    :doc "Generate map for deleteSpotDatafeedSubscription, deleteSpotDatafeedSubscription"}
   ([credentials__1651__auto__]
    {:args [],
     :client :ec2,
     :fn :delete-spot-datafeed-subscription,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :delete-spot-datafeed-subscription,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-spot-datafeed-subscription
   {:arglists (quote
               [[credentials]
                [credentials {:keys [general-progress-listener]}]]),
    :doc "Call deleteSpotDatafeedSubscription, deleteSpotDatafeedSubscription"}
   [credentials7216 & args7217]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7218
     (com.palletops.awaze.common/aws-client :ec2 credentials7216)]
    (clojure.core/case
     (clojure.core/count args7217)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7218
       deleteSpotDatafeedSubscription))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7218
       deleteSpotDatafeedSubscription
       (ec2/delete-spot-datafeed-subscription-request
        (clojure.core/nth args7217 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-conversion-tasks
   [m7219]
   (clojure.core/let
    [credentials7220 (:credentials m7219) args7221 (:args m7219)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7222
      (com.palletops.awaze.common/aws-client :ec2 credentials7220)]
     (clojure.core/case
      (clojure.core/count args7221)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7222
        describeConversionTasks))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7222
        describeConversionTasks
        (ec2/describe-conversion-tasks-request
         (clojure.core/nth args7221 0))))))))
  (clojure.core/defn
   describe-conversion-tasks-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [general-progress-listener
                         filters
                         conversion-task-ids]}]]),
    :doc "Generate map for describeConversionTasks, describeConversionTasks"}
   ([credentials__1651__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-conversion-tasks,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-conversion-tasks,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-conversion-tasks
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [general-progress-listener
                         filters
                         conversion-task-ids]}]]),
    :doc "Call describeConversionTasks, describeConversionTasks"}
   [credentials7224 & args7225]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7226
     (com.palletops.awaze.common/aws-client :ec2 credentials7224)]
    (clojure.core/case
     (clojure.core/count args7225)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7226
       describeConversionTasks))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7226
       describeConversionTasks
       (ec2/describe-conversion-tasks-request
        (clojure.core/nth args7225 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :replace-route-table-association
   [m7227]
   (clojure.core/let
    [credentials7228 (:credentials m7227) args7229 (:args m7227)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7230
      (com.palletops.awaze.common/aws-client :ec2 credentials7228)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7230
       replaceRouteTableAssociation
       (ec2/replace-route-table-association-request
        (clojure.core/nth args7229 0)))))))
  (clojure.core/defn
   replace-route-table-association-map
   {:arglists (quote
               [[credentials
                 {:keys [route-table-id
                         general-progress-listener
                         association-id]}]]),
    :doc "Generate map for replaceRouteTableAssociation"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :replace-route-table-association,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   replace-route-table-association
   {:arglists (quote
               [[credentials
                 {:keys [route-table-id
                         general-progress-listener
                         association-id]}]]),
    :doc "Call replaceRouteTableAssociation"}
   [credentials7232 & args7233]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7234
     (com.palletops.awaze.common/aws-client :ec2 credentials7232)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7234
      replaceRouteTableAssociation
      (ec2/replace-route-table-association-request
       (clojure.core/nth args7233 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-subnet
   [m7235]
   (clojure.core/let
    [credentials7236 (:credentials m7235) args7237 (:args m7235)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7238
      (com.palletops.awaze.common/aws-client :ec2 credentials7236)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7238
       deleteSubnet
       (ec2/delete-subnet-request (clojure.core/nth args7237 0)))))))
  (clojure.core/defn
   delete-subnet-map
   {:arglists (quote
               [[credentials
                 {:keys [subnet-id general-progress-listener]}]]),
    :doc "Generate map for deleteSubnet"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :delete-subnet,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-subnet
   {:arglists (quote
               [[credentials
                 {:keys [subnet-id general-progress-listener]}]]),
    :doc "Call deleteSubnet"}
   [credentials7240 & args7241]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7242
     (com.palletops.awaze.common/aws-client :ec2 credentials7240)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7242
      deleteSubnet
      (ec2/delete-subnet-request (clojure.core/nth args7241 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :modify-vpc-attribute
   [m7243]
   (clojure.core/let
    [credentials7244 (:credentials m7243) args7245 (:args m7243)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7246
      (com.palletops.awaze.common/aws-client :ec2 credentials7244)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7246
       modifyVpcAttribute
       (ec2/modify-vpc-attribute-request
        (clojure.core/nth args7245 0)))))))
  (clojure.core/defn
   modify-vpc-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [vpc-id
                         general-progress-listener
                         enable-dns-support
                         enable-dns-hostnames]}]]),
    :doc "Generate map for modifyVpcAttribute"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :modify-vpc-attribute,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   modify-vpc-attribute
   {:arglists (quote
               [[credentials
                 {:keys [vpc-id
                         general-progress-listener
                         enable-dns-support
                         enable-dns-hostnames]}]]),
    :doc "Call modifyVpcAttribute"}
   [credentials7248 & args7249]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7250
     (com.palletops.awaze.common/aws-client :ec2 credentials7248)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7250
      modifyVpcAttribute
      (ec2/modify-vpc-attribute-request (clojure.core/nth args7249 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :detach-internet-gateway
   [m7251]
   (clojure.core/let
    [credentials7252 (:credentials m7251) args7253 (:args m7251)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7254
      (com.palletops.awaze.common/aws-client :ec2 credentials7252)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7254
       detachInternetGateway
       (ec2/detach-internet-gateway-request
        (clojure.core/nth args7253 0)))))))
  (clojure.core/defn
   detach-internet-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [vpc-id
                         internet-gateway-id
                         general-progress-listener]}]]),
    :doc "Generate map for detachInternetGateway"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :detach-internet-gateway,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   detach-internet-gateway
   {:arglists (quote
               [[credentials
                 {:keys [vpc-id
                         internet-gateway-id
                         general-progress-listener]}]]),
    :doc "Call detachInternetGateway"}
   [credentials7256 & args7257]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7258
     (com.palletops.awaze.common/aws-client :ec2 credentials7256)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7258
      detachInternetGateway
      (ec2/detach-internet-gateway-request
       (clojure.core/nth args7257 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-reserved-instances-modifications
   [m7259]
   (clojure.core/let
    [credentials7260 (:credentials m7259) args7261 (:args m7259)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7262
      (com.palletops.awaze.common/aws-client :ec2 credentials7260)]
     (clojure.core/case
      (clojure.core/count args7261)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7262
        describeReservedInstancesModifications
        (ec2/describe-reserved-instances-modifications-request
         (clojure.core/nth args7261 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7262
        describeReservedInstancesModifications))))))
  (clojure.core/defn
   describe-reserved-instances-modifications-map
   {:arglists (quote
               [[credentials
                 {:keys [reserved-instances-modification-ids
                         next-token
                         general-progress-listener
                         filters]}]
                [credentials]]),
    :doc "Generate map for describeReservedInstancesModifications, describeReservedInstancesModifications"}
   ([credentials__1651__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-reserved-instances-modifications,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-reserved-instances-modifications,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-reserved-instances-modifications
   {:arglists (quote
               [[credentials
                 {:keys [reserved-instances-modification-ids
                         next-token
                         general-progress-listener
                         filters]}]
                [credentials]]),
    :doc "Call describeReservedInstancesModifications, describeReservedInstancesModifications"}
   [credentials7264 & args7265]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7266
     (com.palletops.awaze.common/aws-client :ec2 credentials7264)]
    (clojure.core/case
     (clojure.core/count args7265)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7266
       describeReservedInstancesModifications
       (ec2/describe-reserved-instances-modifications-request
        (clojure.core/nth args7265 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7266
       describeReservedInstancesModifications))))))
 (do
  (clojure.core/defmethod
   ec2
   :get-password-data
   [m7267]
   (clojure.core/let
    [credentials7268 (:credentials m7267) args7269 (:args m7267)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7270
      (com.palletops.awaze.common/aws-client :ec2 credentials7268)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7270
       getPasswordData
       (ec2/get-password-data-request (clojure.core/nth args7269 0)))))))
  (clojure.core/defn
   get-password-data-map
   {:arglists (quote
               [[credentials
                 {:keys [instance-id general-progress-listener]}]]),
    :doc "Generate map for getPasswordData"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :get-password-data,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   get-password-data
   {:arglists (quote
               [[credentials
                 {:keys [instance-id general-progress-listener]}]]),
    :doc "Call getPasswordData"}
   [credentials7272 & args7273]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7274
     (com.palletops.awaze.common/aws-client :ec2 credentials7272)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7274
      getPasswordData
      (ec2/get-password-data-request (clojure.core/nth args7273 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :unassign-private-ip-addresses
   [m7275]
   (clojure.core/let
    [credentials7276 (:credentials m7275) args7277 (:args m7275)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7278
      (com.palletops.awaze.common/aws-client :ec2 credentials7276)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7278
       unassignPrivateIpAddresses
       (ec2/unassign-private-ip-addresses-request
        (clojure.core/nth args7277 0)))))))
  (clojure.core/defn
   unassign-private-ip-addresses-map
   {:arglists (quote
               [[credentials
                 {:keys [private-ip-addresses
                         network-interface-id
                         general-progress-listener]}]]),
    :doc "Generate map for unassignPrivateIpAddresses"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :unassign-private-ip-addresses,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   unassign-private-ip-addresses
   {:arglists (quote
               [[credentials
                 {:keys [private-ip-addresses
                         network-interface-id
                         general-progress-listener]}]]),
    :doc "Call unassignPrivateIpAddresses"}
   [credentials7280 & args7281]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7282
     (com.palletops.awaze.common/aws-client :ec2 credentials7280)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7282
      unassignPrivateIpAddresses
      (ec2/unassign-private-ip-addresses-request
       (clojure.core/nth args7281 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :modify-network-interface-attribute
   [m7283]
   (clojure.core/let
    [credentials7284 (:credentials m7283) args7285 (:args m7283)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7286
      (com.palletops.awaze.common/aws-client :ec2 credentials7284)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7286
       modifyNetworkInterfaceAttribute
       (ec2/modify-network-interface-attribute-request
        (clojure.core/nth args7285 0)))))))
  (clojure.core/defn
   modify-network-interface-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         source-dest-check
                         network-interface-id
                         groups
                         attachment
                         description]}]]),
    :doc "Generate map for modifyNetworkInterfaceAttribute"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :modify-network-interface-attribute,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   modify-network-interface-attribute
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         source-dest-check
                         network-interface-id
                         groups
                         attachment
                         description]}]]),
    :doc "Call modifyNetworkInterfaceAttribute"}
   [credentials7288 & args7289]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7290
     (com.palletops.awaze.common/aws-client :ec2 credentials7288)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7290
      modifyNetworkInterfaceAttribute
      (ec2/modify-network-interface-attribute-request
       (clojure.core/nth args7289 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :reset-network-interface-attribute
   [m7291]
   (clojure.core/let
    [credentials7292 (:credentials m7291) args7293 (:args m7291)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7294
      (com.palletops.awaze.common/aws-client :ec2 credentials7292)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7294
       resetNetworkInterfaceAttribute
       (ec2/reset-network-interface-attribute-request
        (clojure.core/nth args7293 0)))))))
  (clojure.core/defn
   reset-network-interface-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [source-dest-check
                         network-interface-id
                         general-progress-listener]}]]),
    :doc "Generate map for resetNetworkInterfaceAttribute"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :reset-network-interface-attribute,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   reset-network-interface-attribute
   {:arglists (quote
               [[credentials
                 {:keys [source-dest-check
                         network-interface-id
                         general-progress-listener]}]]),
    :doc "Call resetNetworkInterfaceAttribute"}
   [credentials7296 & args7297]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7298
     (com.palletops.awaze.common/aws-client :ec2 credentials7296)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7298
      resetNetworkInterfaceAttribute
      (ec2/reset-network-interface-attribute-request
       (clojure.core/nth args7297 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-vpcs
   [m7299]
   (clojure.core/let
    [credentials7300 (:credentials m7299) args7301 (:args m7299)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7302
      (com.palletops.awaze.common/aws-client :ec2 credentials7300)]
     (clojure.core/case
      (clojure.core/count args7301)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7302
        describeVpcs
        (ec2/describe-vpcs-request (clojure.core/nth args7301 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7302
        describeVpcs))))))
  (clojure.core/defn
   describe-vpcs-map
   {:arglists (quote
               [[credentials
                 {:keys [vpc-ids general-progress-listener filters]}]
                [credentials]]),
    :doc "Generate map for describeVpcs, describeVpcs"}
   ([credentials__1651__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-vpcs,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-vpcs,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-vpcs
   {:arglists (quote
               [[credentials
                 {:keys [vpc-ids general-progress-listener filters]}]
                [credentials]]),
    :doc "Call describeVpcs, describeVpcs"}
   [credentials7304 & args7305]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7306
     (com.palletops.awaze.common/aws-client :ec2 credentials7304)]
    (clojure.core/case
     (clojure.core/count args7305)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7306
       describeVpcs
       (ec2/describe-vpcs-request (clojure.core/nth args7305 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7306
       describeVpcs))))))
 (do
  (clojure.core/defmethod
   ec2
   :reboot-instances
   [m7307]
   (clojure.core/let
    [credentials7308 (:credentials m7307) args7309 (:args m7307)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7310
      (com.palletops.awaze.common/aws-client :ec2 credentials7308)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7310
       rebootInstances
       (ec2/reboot-instances-request (clojure.core/nth args7309 0)))))))
  (clojure.core/defn
   reboot-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [instance-ids general-progress-listener]}]]),
    :doc "Generate map for rebootInstances"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :reboot-instances,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   reboot-instances
   {:arglists (quote
               [[credentials
                 {:keys [instance-ids general-progress-listener]}]]),
    :doc "Call rebootInstances"}
   [credentials7312 & args7313]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7314
     (com.palletops.awaze.common/aws-client :ec2 credentials7312)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7314
      rebootInstances
      (ec2/reboot-instances-request (clojure.core/nth args7313 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-volume-attribute
   [m7315]
   (clojure.core/let
    [credentials7316 (:credentials m7315) args7317 (:args m7315)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7318
      (com.palletops.awaze.common/aws-client :ec2 credentials7316)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7318
       describeVolumeAttribute
       (ec2/describe-volume-attribute-request
        (clojure.core/nth args7317 0)))))))
  (clojure.core/defn
   describe-volume-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [volume-id
                         general-progress-listener
                         attribute]}]]),
    :doc "Generate map for describeVolumeAttribute"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-volume-attribute,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-volume-attribute
   {:arglists (quote
               [[credentials
                 {:keys [volume-id
                         general-progress-listener
                         attribute]}]]),
    :doc "Call describeVolumeAttribute"}
   [credentials7320 & args7321]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7322
     (com.palletops.awaze.common/aws-client :ec2 credentials7320)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7322
      describeVolumeAttribute
      (ec2/describe-volume-attribute-request
       (clojure.core/nth args7321 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :modify-instance-attribute
   [m7323]
   (clojure.core/let
    [credentials7324 (:credentials m7323) args7325 (:args m7323)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7326
      (com.palletops.awaze.common/aws-client :ec2 credentials7324)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7326
       modifyInstanceAttribute
       (ec2/modify-instance-attribute-request
        (clojure.core/nth args7325 0)))))))
  (clojure.core/defn
   modify-instance-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [instance-type
                         general-progress-listener
                         ebs-optimized
                         source-dest-check
                         block-device-mappings
                         kernel
                         disable-api-termination
                         user-data
                         groups
                         ramdisk
                         attribute
                         instance-id
                         sriov-net-support
                         instance-initiated-shutdown-behavior
                         value]}]]),
    :doc "Generate map for modifyInstanceAttribute"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :modify-instance-attribute,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   modify-instance-attribute
   {:arglists (quote
               [[credentials
                 {:keys [instance-type
                         general-progress-listener
                         ebs-optimized
                         source-dest-check
                         block-device-mappings
                         kernel
                         disable-api-termination
                         user-data
                         groups
                         ramdisk
                         attribute
                         instance-id
                         sriov-net-support
                         instance-initiated-shutdown-behavior
                         value]}]]),
    :doc "Call modifyInstanceAttribute"}
   [credentials7328 & args7329]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7330
     (com.palletops.awaze.common/aws-client :ec2 credentials7328)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7330
      modifyInstanceAttribute
      (ec2/modify-instance-attribute-request
       (clojure.core/nth args7329 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-key-pair
   [m7331]
   (clojure.core/let
    [credentials7332 (:credentials m7331) args7333 (:args m7331)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7334
      (com.palletops.awaze.common/aws-client :ec2 credentials7332)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7334
       deleteKeyPair
       (ec2/delete-key-pair-request (clojure.core/nth args7333 0)))))))
  (clojure.core/defn
   delete-key-pair-map
   {:arglists (quote
               [[credentials
                 {:keys [key-name general-progress-listener]}]]),
    :doc "Generate map for deleteKeyPair"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :delete-key-pair,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-key-pair
   {:arglists (quote
               [[credentials
                 {:keys [key-name general-progress-listener]}]]),
    :doc "Call deleteKeyPair"}
   [credentials7336 & args7337]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7338
     (com.palletops.awaze.common/aws-client :ec2 credentials7336)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7338
      deleteKeyPair
      (ec2/delete-key-pair-request (clojure.core/nth args7337 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :enable-vgw-route-propagation
   [m7339]
   (clojure.core/let
    [credentials7340 (:credentials m7339) args7341 (:args m7339)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7342
      (com.palletops.awaze.common/aws-client :ec2 credentials7340)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7342
       enableVgwRoutePropagation
       (ec2/enable-vgw-route-propagation-request
        (clojure.core/nth args7341 0)))))))
  (clojure.core/defn
   enable-vgw-route-propagation-map
   {:arglists (quote
               [[credentials
                 {:keys [route-table-id
                         general-progress-listener
                         gateway-id]}]]),
    :doc "Generate map for enableVgwRoutePropagation"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :enable-vgw-route-propagation,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   enable-vgw-route-propagation
   {:arglists (quote
               [[credentials
                 {:keys [route-table-id
                         general-progress-listener
                         gateway-id]}]]),
    :doc "Call enableVgwRoutePropagation"}
   [credentials7344 & args7345]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7346
     (com.palletops.awaze.common/aws-client :ec2 credentials7344)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7346
      enableVgwRoutePropagation
      (ec2/enable-vgw-route-propagation-request
       (clojure.core/nth args7345 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :bundle-instance
   [m7347]
   (clojure.core/let
    [credentials7348 (:credentials m7347) args7349 (:args m7347)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7350
      (com.palletops.awaze.common/aws-client :ec2 credentials7348)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7350
       bundleInstance
       (ec2/bundle-instance-request (clojure.core/nth args7349 0)))))))
  (clojure.core/defn
   bundle-instance-map
   {:arglists (quote
               [[credentials
                 {:keys [storage
                         instance-id
                         general-progress-listener]}]]),
    :doc "Generate map for bundleInstance"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :bundle-instance,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   bundle-instance
   {:arglists (quote
               [[credentials
                 {:keys [storage
                         instance-id
                         general-progress-listener]}]]),
    :doc "Call bundleInstance"}
   [credentials7352 & args7353]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7354
     (com.palletops.awaze.common/aws-client :ec2 credentials7352)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7354
      bundleInstance
      (ec2/bundle-instance-request (clojure.core/nth args7353 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-internet-gateway
   [m7355]
   (clojure.core/let
    [credentials7356 (:credentials m7355) args7357 (:args m7355)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7358
      (com.palletops.awaze.common/aws-client :ec2 credentials7356)]
     (clojure.core/case
      (clojure.core/count args7357)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7358
        createInternetGateway))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7358
        createInternetGateway
        (ec2/create-internet-gateway-request
         (clojure.core/nth args7357 0))))))))
  (clojure.core/defn
   create-internet-gateway-map
   {:arglists (quote
               [[credentials]
                [credentials {:keys [general-progress-listener]}]]),
    :doc "Generate map for createInternetGateway, createInternetGateway"}
   ([credentials__1651__auto__]
    {:args [],
     :client :ec2,
     :fn :create-internet-gateway,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :create-internet-gateway,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-internet-gateway
   {:arglists (quote
               [[credentials]
                [credentials {:keys [general-progress-listener]}]]),
    :doc "Call createInternetGateway, createInternetGateway"}
   [credentials7360 & args7361]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7362
     (com.palletops.awaze.common/aws-client :ec2 credentials7360)]
    (clojure.core/case
     (clojure.core/count args7361)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7362
       createInternetGateway))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7362
       createInternetGateway
       (ec2/create-internet-gateway-request
        (clojure.core/nth args7361 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-volume-status
   [m7363]
   (clojure.core/let
    [credentials7364 (:credentials m7363) args7365 (:args m7363)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7366
      (com.palletops.awaze.common/aws-client :ec2 credentials7364)]
     (clojure.core/case
      (clojure.core/count args7365)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7366
        describeVolumeStatus
        (ec2/describe-volume-status-request
         (clojure.core/nth args7365 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7366
        describeVolumeStatus))))))
  (clojure.core/defn
   describe-volume-status-map
   {:arglists (quote
               [[credentials
                 {:keys [volume-ids
                         general-progress-listener
                         next-token
                         filters
                         max-results]}]
                [credentials]]),
    :doc "Generate map for describeVolumeStatus, describeVolumeStatus"}
   ([credentials__1651__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-volume-status,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-volume-status,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-volume-status
   {:arglists (quote
               [[credentials
                 {:keys [volume-ids
                         general-progress-listener
                         next-token
                         filters
                         max-results]}]
                [credentials]]),
    :doc "Call describeVolumeStatus, describeVolumeStatus"}
   [credentials7368 & args7369]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7370
     (com.palletops.awaze.common/aws-client :ec2 credentials7368)]
    (clojure.core/case
     (clojure.core/count args7369)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7370
       describeVolumeStatus
       (ec2/describe-volume-status-request
        (clojure.core/nth args7369 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7370
       describeVolumeStatus))))))
 (do
  (clojure.core/defmethod
   ec2
   :copy-image
   [m7371]
   (clojure.core/let
    [credentials7372 (:credentials m7371) args7373 (:args m7371)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7374
      (com.palletops.awaze.common/aws-client :ec2 credentials7372)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7374
       copyImage
       (ec2/copy-image-request (clojure.core/nth args7373 0)))))))
  (clojure.core/defn
   copy-image-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         name
                         source-region
                         source-image-id
                         client-token
                         description]}]]),
    :doc "Generate map for copyImage"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :copy-image,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   copy-image
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         name
                         source-region
                         source-image-id
                         client-token
                         description]}]]),
    :doc "Call copyImage"}
   [credentials7376 & args7377]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7378
     (com.palletops.awaze.common/aws-client :ec2 credentials7376)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7378
      copyImage
      (ec2/copy-image-request (clojure.core/nth args7377 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-key-pairs
   [m7379]
   (clojure.core/let
    [credentials7380 (:credentials m7379) args7381 (:args m7379)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7382
      (com.palletops.awaze.common/aws-client :ec2 credentials7380)]
     (clojure.core/case
      (clojure.core/count args7381)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7382
        describeKeyPairs))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7382
        describeKeyPairs
        (ec2/describe-key-pairs-request (clojure.core/nth args7381 0))))))))
  (clojure.core/defn
   describe-key-pairs-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [key-names general-progress-listener filters]}]]),
    :doc "Generate map for describeKeyPairs, describeKeyPairs"}
   ([credentials__1651__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-key-pairs,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-key-pairs,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-key-pairs
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [key-names general-progress-listener filters]}]]),
    :doc "Call describeKeyPairs, describeKeyPairs"}
   [credentials7384 & args7385]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7386
     (com.palletops.awaze.common/aws-client :ec2 credentials7384)]
    (clojure.core/case
     (clojure.core/count args7385)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7386
       describeKeyPairs))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7386
       describeKeyPairs
       (ec2/describe-key-pairs-request (clojure.core/nth args7385 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :accept-vpc-peering-connection
   [m7387]
   (clojure.core/let
    [credentials7388 (:credentials m7387) args7389 (:args m7387)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7390
      (com.palletops.awaze.common/aws-client :ec2 credentials7388)]
     (clojure.core/case
      (clojure.core/count args7389)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7390
        acceptVpcPeeringConnection
        (ec2/accept-vpc-peering-connection-request
         (clojure.core/nth args7389 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7390
        acceptVpcPeeringConnection))))))
  (clojure.core/defn
   accept-vpc-peering-connection-map
   {:arglists (quote
               [[credentials
                 {:keys [vpc-peering-connection-id
                         general-progress-listener]}]
                [credentials]]),
    :doc "Generate map for acceptVpcPeeringConnection, acceptVpcPeeringConnection"}
   ([credentials__1651__auto__]
    {:args [],
     :client :ec2,
     :fn :accept-vpc-peering-connection,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :accept-vpc-peering-connection,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   accept-vpc-peering-connection
   {:arglists (quote
               [[credentials
                 {:keys [vpc-peering-connection-id
                         general-progress-listener]}]
                [credentials]]),
    :doc "Call acceptVpcPeeringConnection, acceptVpcPeeringConnection"}
   [credentials7392 & args7393]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7394
     (com.palletops.awaze.common/aws-client :ec2 credentials7392)]
    (clojure.core/case
     (clojure.core/count args7393)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7394
       acceptVpcPeeringConnection
       (ec2/accept-vpc-peering-connection-request
        (clojure.core/nth args7393 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7394
       acceptVpcPeeringConnection))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-network-acl-entry
   [m7395]
   (clojure.core/let
    [credentials7396 (:credentials m7395) args7397 (:args m7395)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7398
      (com.palletops.awaze.common/aws-client :ec2 credentials7396)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7398
       deleteNetworkAclEntry
       (ec2/delete-network-acl-entry-request
        (clojure.core/nth args7397 0)))))))
  (clojure.core/defn
   delete-network-acl-entry-map
   {:arglists (quote
               [[credentials
                 {:keys [rule-number
                         network-acl-id
                         general-progress-listener
                         egress]}]]),
    :doc "Generate map for deleteNetworkAclEntry"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :delete-network-acl-entry,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-network-acl-entry
   {:arglists (quote
               [[credentials
                 {:keys [rule-number
                         network-acl-id
                         general-progress-listener
                         egress]}]]),
    :doc "Call deleteNetworkAclEntry"}
   [credentials7400 & args7401]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7402
     (com.palletops.awaze.common/aws-client :ec2 credentials7400)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7402
      deleteNetworkAclEntry
      (ec2/delete-network-acl-entry-request
       (clojure.core/nth args7401 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :purchase-reserved-instances-offering
   [m7403]
   (clojure.core/let
    [credentials7404 (:credentials m7403) args7405 (:args m7403)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7406
      (com.palletops.awaze.common/aws-client :ec2 credentials7404)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7406
       purchaseReservedInstancesOffering
       (ec2/purchase-reserved-instances-offering-request
        (clojure.core/nth args7405 0)))))))
  (clojure.core/defn
   purchase-reserved-instances-offering-map
   {:arglists (quote
               [[credentials
                 {:keys [reserved-instances-offering-id
                         limit-price
                         instance-count
                         general-progress-listener]}]]),
    :doc "Generate map for purchaseReservedInstancesOffering"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :purchase-reserved-instances-offering,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   purchase-reserved-instances-offering
   {:arglists (quote
               [[credentials
                 {:keys [reserved-instances-offering-id
                         limit-price
                         instance-count
                         general-progress-listener]}]]),
    :doc "Call purchaseReservedInstancesOffering"}
   [credentials7408 & args7409]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7410
     (com.palletops.awaze.common/aws-client :ec2 credentials7408)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7410
      purchaseReservedInstancesOffering
      (ec2/purchase-reserved-instances-offering-request
       (clojure.core/nth args7409 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :cancel-reserved-instances-listing
   [m7411]
   (clojure.core/let
    [credentials7412 (:credentials m7411) args7413 (:args m7411)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7414
      (com.palletops.awaze.common/aws-client :ec2 credentials7412)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7414
       cancelReservedInstancesListing
       (ec2/cancel-reserved-instances-listing-request
        (clojure.core/nth args7413 0)))))))
  (clojure.core/defn
   cancel-reserved-instances-listing-map
   {:arglists (quote
               [[credentials
                 {:keys [reserved-instances-listing-id
                         general-progress-listener]}]]),
    :doc "Generate map for cancelReservedInstancesListing"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :cancel-reserved-instances-listing,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   cancel-reserved-instances-listing
   {:arglists (quote
               [[credentials
                 {:keys [reserved-instances-listing-id
                         general-progress-listener]}]]),
    :doc "Call cancelReservedInstancesListing"}
   [credentials7416 & args7417]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7418
     (com.palletops.awaze.common/aws-client :ec2 credentials7416)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7418
      cancelReservedInstancesListing
      (ec2/cancel-reserved-instances-listing-request
       (clojure.core/nth args7417 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :revoke-security-group-egress
   [m7419]
   (clojure.core/let
    [credentials7420 (:credentials m7419) args7421 (:args m7419)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7422
      (com.palletops.awaze.common/aws-client :ec2 credentials7420)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7422
       revokeSecurityGroupEgress
       (ec2/revoke-security-group-egress-request
        (clojure.core/nth args7421 0)))))))
  (clojure.core/defn
   revoke-security-group-egress-map
   {:arglists (quote
               [[credentials
                 {:keys [source-security-group-name
                         group-id
                         general-progress-listener
                         from-port
                         ip-permissions
                         to-port
                         cidr-ip
                         ip-protocol
                         source-security-group-owner-id]}]]),
    :doc "Generate map for revokeSecurityGroupEgress"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :revoke-security-group-egress,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   revoke-security-group-egress
   {:arglists (quote
               [[credentials
                 {:keys [source-security-group-name
                         group-id
                         general-progress-listener
                         from-port
                         ip-permissions
                         to-port
                         cidr-ip
                         ip-protocol
                         source-security-group-owner-id]}]]),
    :doc "Call revokeSecurityGroupEgress"}
   [credentials7424 & args7425]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7426
     (com.palletops.awaze.common/aws-client :ec2 credentials7424)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7426
      revokeSecurityGroupEgress
      (ec2/revoke-security-group-egress-request
       (clojure.core/nth args7425 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-spot-datafeed-subscription
   [m7427]
   (clojure.core/let
    [credentials7428 (:credentials m7427) args7429 (:args m7427)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7430
      (com.palletops.awaze.common/aws-client :ec2 credentials7428)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7430
       createSpotDatafeedSubscription
       (ec2/create-spot-datafeed-subscription-request
        (clojure.core/nth args7429 0)))))))
  (clojure.core/defn
   create-spot-datafeed-subscription-map
   {:arglists (quote
               [[credentials
                 {:keys [prefix general-progress-listener bucket]}]]),
    :doc "Generate map for createSpotDatafeedSubscription"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :create-spot-datafeed-subscription,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-spot-datafeed-subscription
   {:arglists (quote
               [[credentials
                 {:keys [prefix general-progress-listener bucket]}]]),
    :doc "Call createSpotDatafeedSubscription"}
   [credentials7432 & args7433]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7434
     (com.palletops.awaze.common/aws-client :ec2 credentials7432)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7434
      createSpotDatafeedSubscription
      (ec2/create-spot-datafeed-subscription-request
       (clojure.core/nth args7433 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :enable-volume-io
   [m7435]
   (clojure.core/let
    [credentials7436 (:credentials m7435) args7437 (:args m7435)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7438
      (com.palletops.awaze.common/aws-client :ec2 credentials7436)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7438
       enableVolumeIO
       (ec2/enable-volume-iorequest (clojure.core/nth args7437 0)))))))
  (clojure.core/defn
   enable-volume-io-map
   {:arglists (quote
               [[credentials
                 {:keys [volume-id general-progress-listener]}]]),
    :doc "Generate map for enableVolumeIO"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :enable-volume-io,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   enable-volume-io
   {:arglists (quote
               [[credentials
                 {:keys [volume-id general-progress-listener]}]]),
    :doc "Call enableVolumeIO"}
   [credentials7440 & args7441]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7442
     (com.palletops.awaze.common/aws-client :ec2 credentials7440)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7442
      enableVolumeIO
      (ec2/enable-volume-iorequest (clojure.core/nth args7441 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :replace-network-acl-association
   [m7443]
   (clojure.core/let
    [credentials7444 (:credentials m7443) args7445 (:args m7443)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7446
      (com.palletops.awaze.common/aws-client :ec2 credentials7444)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7446
       replaceNetworkAclAssociation
       (ec2/replace-network-acl-association-request
        (clojure.core/nth args7445 0)))))))
  (clojure.core/defn
   replace-network-acl-association-map
   {:arglists (quote
               [[credentials
                 {:keys [network-acl-id
                         general-progress-listener
                         association-id]}]]),
    :doc "Generate map for replaceNetworkAclAssociation"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :replace-network-acl-association,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   replace-network-acl-association
   {:arglists (quote
               [[credentials
                 {:keys [network-acl-id
                         general-progress-listener
                         association-id]}]]),
    :doc "Call replaceNetworkAclAssociation"}
   [credentials7448 & args7449]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7450
     (com.palletops.awaze.common/aws-client :ec2 credentials7448)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7450
      replaceNetworkAclAssociation
      (ec2/replace-network-acl-association-request
       (clojure.core/nth args7449 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-vpc-peering-connection
   [m7451]
   (clojure.core/let
    [credentials7452 (:credentials m7451) args7453 (:args m7451)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7454
      (com.palletops.awaze.common/aws-client :ec2 credentials7452)]
     (clojure.core/case
      (clojure.core/count args7453)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7454
        deleteVpcPeeringConnection))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7454
        deleteVpcPeeringConnection
        (ec2/delete-vpc-peering-connection-request
         (clojure.core/nth args7453 0))))))))
  (clojure.core/defn
   delete-vpc-peering-connection-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [vpc-peering-connection-id
                         general-progress-listener]}]]),
    :doc "Generate map for deleteVpcPeeringConnection, deleteVpcPeeringConnection"}
   ([credentials__1651__auto__]
    {:args [],
     :client :ec2,
     :fn :delete-vpc-peering-connection,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :delete-vpc-peering-connection,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-vpc-peering-connection
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [vpc-peering-connection-id
                         general-progress-listener]}]]),
    :doc "Call deleteVpcPeeringConnection, deleteVpcPeeringConnection"}
   [credentials7456 & args7457]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7458
     (com.palletops.awaze.common/aws-client :ec2 credentials7456)]
    (clojure.core/case
     (clojure.core/count args7457)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7458
       deleteVpcPeeringConnection))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7458
       deleteVpcPeeringConnection
       (ec2/delete-vpc-peering-connection-request
        (clojure.core/nth args7457 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :copy-snapshot
   [m7459]
   (clojure.core/let
    [credentials7460 (:credentials m7459) args7461 (:args m7459)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7462
      (com.palletops.awaze.common/aws-client :ec2 credentials7460)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7462
       copySnapshot
       (ec2/copy-snapshot-request (clojure.core/nth args7461 0)))))))
  (clojure.core/defn
   copy-snapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         destination-region
                         source-snapshot-id
                         source-region
                         presigned-url
                         description]}]]),
    :doc "Generate map for copySnapshot"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :copy-snapshot,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   copy-snapshot
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         destination-region
                         source-snapshot-id
                         source-region
                         presigned-url
                         description]}]]),
    :doc "Call copySnapshot"}
   [credentials7464 & args7465]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7466
     (com.palletops.awaze.common/aws-client :ec2 credentials7464)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7466
      copySnapshot
      (ec2/copy-snapshot-request (clojure.core/nth args7465 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-customer-gateway
   [m7467]
   (clojure.core/let
    [credentials7468 (:credentials m7467) args7469 (:args m7467)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7470
      (com.palletops.awaze.common/aws-client :ec2 credentials7468)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7470
       createCustomerGateway
       (ec2/create-customer-gateway-request
        (clojure.core/nth args7469 0)))))))
  (clojure.core/defn
   create-customer-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [type
                         public-ip
                         general-progress-listener
                         bgp-asn]}]]),
    :doc "Generate map for createCustomerGateway"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :create-customer-gateway,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-customer-gateway
   {:arglists (quote
               [[credentials
                 {:keys [type
                         public-ip
                         general-progress-listener
                         bgp-asn]}]]),
    :doc "Call createCustomerGateway"}
   [credentials7472 & args7473]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7474
     (com.palletops.awaze.common/aws-client :ec2 credentials7472)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7474
      createCustomerGateway
      (ec2/create-customer-gateway-request
       (clojure.core/nth args7473 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-reserved-instances-offerings
   [m7475]
   (clojure.core/let
    [credentials7476 (:credentials m7475) args7477 (:args m7475)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7478
      (com.palletops.awaze.common/aws-client :ec2 credentials7476)]
     (clojure.core/case
      (clojure.core/count args7477)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7478
        describeReservedInstancesOfferings
        (ec2/describe-reserved-instances-offerings-request
         (clojure.core/nth args7477 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7478
        describeReservedInstancesOfferings))))))
  (clojure.core/defn
   describe-reserved-instances-offerings-map
   {:arglists (quote
               [[credentials
                 {:keys [instance-type
                         reserved-instances-offering-ids
                         min-duration
                         general-progress-listener
                         filters
                         max-duration
                         availability-zone
                         max-instance-count
                         max-results
                         product-description
                         next-token
                         offering-type
                         instance-tenancy
                         include-marketplace]}]
                [credentials]]),
    :doc "Generate map for describeReservedInstancesOfferings, describeReservedInstancesOfferings"}
   ([credentials__1651__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-reserved-instances-offerings,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-reserved-instances-offerings,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-reserved-instances-offerings
   {:arglists (quote
               [[credentials
                 {:keys [instance-type
                         reserved-instances-offering-ids
                         min-duration
                         general-progress-listener
                         filters
                         max-duration
                         availability-zone
                         max-instance-count
                         max-results
                         product-description
                         next-token
                         offering-type
                         instance-tenancy
                         include-marketplace]}]
                [credentials]]),
    :doc "Call describeReservedInstancesOfferings, describeReservedInstancesOfferings"}
   [credentials7480 & args7481]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7482
     (com.palletops.awaze.common/aws-client :ec2 credentials7480)]
    (clojure.core/case
     (clojure.core/count args7481)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7482
       describeReservedInstancesOfferings
       (ec2/describe-reserved-instances-offerings-request
        (clojure.core/nth args7481 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7482
       describeReservedInstancesOfferings))))))
 (do
  (clojure.core/defmethod
   ec2
   :cancel-bundle-task
   [m7483]
   (clojure.core/let
    [credentials7484 (:credentials m7483) args7485 (:args m7483)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7486
      (com.palletops.awaze.common/aws-client :ec2 credentials7484)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7486
       cancelBundleTask
       (ec2/cancel-bundle-task-request (clojure.core/nth args7485 0)))))))
  (clojure.core/defn
   cancel-bundle-task-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener bundle-id]}]]),
    :doc "Generate map for cancelBundleTask"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :cancel-bundle-task,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   cancel-bundle-task
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener bundle-id]}]]),
    :doc "Call cancelBundleTask"}
   [credentials7488 & args7489]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7490
     (com.palletops.awaze.common/aws-client :ec2 credentials7488)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7490
      cancelBundleTask
      (ec2/cancel-bundle-task-request (clojure.core/nth args7489 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-images
   [m7491]
   (clojure.core/let
    [credentials7492 (:credentials m7491) args7493 (:args m7491)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7494
      (com.palletops.awaze.common/aws-client :ec2 credentials7492)]
     (clojure.core/case
      (clojure.core/count args7493)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7494
        describeImages))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7494
        describeImages
        (ec2/describe-images-request (clojure.core/nth args7493 0))))))))
  (clojure.core/defn
   describe-images-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [owners
                         general-progress-listener
                         executable-users
                         image-ids
                         filters]}]]),
    :doc "Generate map for describeImages, describeImages"}
   ([credentials__1651__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-images,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-images,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-images
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [owners
                         general-progress-listener
                         executable-users
                         image-ids
                         filters]}]]),
    :doc "Call describeImages, describeImages"}
   [credentials7496 & args7497]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7498
     (com.palletops.awaze.common/aws-client :ec2 credentials7496)]
    (clojure.core/case
     (clojure.core/count args7497)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7498
       describeImages))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7498
       describeImages
       (ec2/describe-images-request (clojure.core/nth args7497 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-dhcp-options
   [m7499]
   (clojure.core/let
    [credentials7500 (:credentials m7499) args7501 (:args m7499)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7502
      (com.palletops.awaze.common/aws-client :ec2 credentials7500)]
     (clojure.core/case
      (clojure.core/count args7501)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7502
        describeDhcpOptions))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7502
        describeDhcpOptions
        (ec2/describe-dhcp-options-request
         (clojure.core/nth args7501 0))))))))
  (clojure.core/defn
   describe-dhcp-options-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [general-progress-listener
                         filters
                         dhcp-options-ids]}]]),
    :doc "Generate map for describeDhcpOptions, describeDhcpOptions"}
   ([credentials__1651__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-dhcp-options,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-dhcp-options,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-dhcp-options
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [general-progress-listener
                         filters
                         dhcp-options-ids]}]]),
    :doc "Call describeDhcpOptions, describeDhcpOptions"}
   [credentials7504 & args7505]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7506
     (com.palletops.awaze.common/aws-client :ec2 credentials7504)]
    (clojure.core/case
     (clojure.core/count args7505)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7506
       describeDhcpOptions))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7506
       describeDhcpOptions
       (ec2/describe-dhcp-options-request
        (clojure.core/nth args7505 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-vpn-connection
   [m7507]
   (clojure.core/let
    [credentials7508 (:credentials m7507) args7509 (:args m7507)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7510
      (com.palletops.awaze.common/aws-client :ec2 credentials7508)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7510
       deleteVpnConnection
       (ec2/delete-vpn-connection-request
        (clojure.core/nth args7509 0)))))))
  (clojure.core/defn
   delete-vpn-connection-map
   {:arglists (quote
               [[credentials
                 {:keys [vpn-connection-id general-progress-listener]}]]),
    :doc "Generate map for deleteVpnConnection"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :delete-vpn-connection,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-vpn-connection
   {:arglists (quote
               [[credentials
                 {:keys [vpn-connection-id general-progress-listener]}]]),
    :doc "Call deleteVpnConnection"}
   [credentials7512 & args7513]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7514
     (com.palletops.awaze.common/aws-client :ec2 credentials7512)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7514
      deleteVpnConnection
      (ec2/delete-vpn-connection-request
       (clojure.core/nth args7513 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-vpn-connection-route
   [m7515]
   (clojure.core/let
    [credentials7516 (:credentials m7515) args7517 (:args m7515)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7518
      (com.palletops.awaze.common/aws-client :ec2 credentials7516)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7518
       createVpnConnectionRoute
       (ec2/create-vpn-connection-route-request
        (clojure.core/nth args7517 0)))))))
  (clojure.core/defn
   create-vpn-connection-route-map
   {:arglists (quote
               [[credentials
                 {:keys [vpn-connection-id
                         general-progress-listener
                         destination-cidr-block]}]]),
    :doc "Generate map for createVpnConnectionRoute"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :create-vpn-connection-route,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-vpn-connection-route
   {:arglists (quote
               [[credentials
                 {:keys [vpn-connection-id
                         general-progress-listener
                         destination-cidr-block]}]]),
    :doc "Call createVpnConnectionRoute"}
   [credentials7520 & args7521]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7522
     (com.palletops.awaze.common/aws-client :ec2 credentials7520)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7522
      createVpnConnectionRoute
      (ec2/create-vpn-connection-route-request
       (clojure.core/nth args7521 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-key-pair
   [m7523]
   (clojure.core/let
    [credentials7524 (:credentials m7523) args7525 (:args m7523)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7526
      (com.palletops.awaze.common/aws-client :ec2 credentials7524)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7526
       createKeyPair
       (ec2/create-key-pair-request (clojure.core/nth args7525 0)))))))
  (clojure.core/defn
   create-key-pair-map
   {:arglists (quote
               [[credentials
                 {:keys [key-name general-progress-listener]}]]),
    :doc "Generate map for createKeyPair"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :create-key-pair,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-key-pair
   {:arglists (quote
               [[credentials
                 {:keys [key-name general-progress-listener]}]]),
    :doc "Call createKeyPair"}
   [credentials7528 & args7529]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7530
     (com.palletops.awaze.common/aws-client :ec2 credentials7528)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7530
      createKeyPair
      (ec2/create-key-pair-request (clojure.core/nth args7529 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-account-attributes
   [m7531]
   (clojure.core/let
    [credentials7532 (:credentials m7531) args7533 (:args m7531)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7534
      (com.palletops.awaze.common/aws-client :ec2 credentials7532)]
     (clojure.core/case
      (clojure.core/count args7533)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7534
        describeAccountAttributes))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7534
        describeAccountAttributes
        (ec2/describe-account-attributes-request
         (clojure.core/nth args7533 0))))))))
  (clojure.core/defn
   describe-account-attributes-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [general-progress-listener attribute-names]}]]),
    :doc "Generate map for describeAccountAttributes, describeAccountAttributes"}
   ([credentials__1651__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-account-attributes,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-account-attributes,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-account-attributes
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [general-progress-listener attribute-names]}]]),
    :doc "Call describeAccountAttributes, describeAccountAttributes"}
   [credentials7536 & args7537]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7538
     (com.palletops.awaze.common/aws-client :ec2 credentials7536)]
    (clojure.core/case
     (clojure.core/count args7537)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7538
       describeAccountAttributes))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7538
       describeAccountAttributes
       (ec2/describe-account-attributes-request
        (clojure.core/nth args7537 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-spot-datafeed-subscription
   [m7539]
   (clojure.core/let
    [credentials7540 (:credentials m7539) args7541 (:args m7539)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7542
      (com.palletops.awaze.common/aws-client :ec2 credentials7540)]
     (clojure.core/case
      (clojure.core/count args7541)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7542
        describeSpotDatafeedSubscription))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7542
        describeSpotDatafeedSubscription
        (ec2/describe-spot-datafeed-subscription-request
         (clojure.core/nth args7541 0))))))))
  (clojure.core/defn
   describe-spot-datafeed-subscription-map
   {:arglists (quote
               [[credentials]
                [credentials {:keys [general-progress-listener]}]]),
    :doc "Generate map for describeSpotDatafeedSubscription, describeSpotDatafeedSubscription"}
   ([credentials__1651__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-spot-datafeed-subscription,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-spot-datafeed-subscription,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-spot-datafeed-subscription
   {:arglists (quote
               [[credentials]
                [credentials {:keys [general-progress-listener]}]]),
    :doc "Call describeSpotDatafeedSubscription, describeSpotDatafeedSubscription"}
   [credentials7544 & args7545]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7546
     (com.palletops.awaze.common/aws-client :ec2 credentials7544)]
    (clojure.core/case
     (clojure.core/count args7545)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7546
       describeSpotDatafeedSubscription))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7546
       describeSpotDatafeedSubscription
       (ec2/describe-spot-datafeed-subscription-request
        (clojure.core/nth args7545 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-internet-gateways
   [m7547]
   (clojure.core/let
    [credentials7548 (:credentials m7547) args7549 (:args m7547)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7550
      (com.palletops.awaze.common/aws-client :ec2 credentials7548)]
     (clojure.core/case
      (clojure.core/count args7549)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7550
        describeInternetGateways))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7550
        describeInternetGateways
        (ec2/describe-internet-gateways-request
         (clojure.core/nth args7549 0))))))))
  (clojure.core/defn
   describe-internet-gateways-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [internet-gateway-ids
                         general-progress-listener
                         filters]}]]),
    :doc "Generate map for describeInternetGateways, describeInternetGateways"}
   ([credentials__1651__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-internet-gateways,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-internet-gateways,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-internet-gateways
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [internet-gateway-ids
                         general-progress-listener
                         filters]}]]),
    :doc "Call describeInternetGateways, describeInternetGateways"}
   [credentials7552 & args7553]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7554
     (com.palletops.awaze.common/aws-client :ec2 credentials7552)]
    (clojure.core/case
     (clojure.core/count args7553)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7554
       describeInternetGateways))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7554
       describeInternetGateways
       (ec2/describe-internet-gateways-request
        (clojure.core/nth args7553 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :start-instances
   [m7555]
   (clojure.core/let
    [credentials7556 (:credentials m7555) args7557 (:args m7555)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7558
      (com.palletops.awaze.common/aws-client :ec2 credentials7556)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7558
       startInstances
       (ec2/start-instances-request (clojure.core/nth args7557 0)))))))
  (clojure.core/defn
   start-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [instance-ids
                         general-progress-listener
                         additional-info]}]]),
    :doc "Generate map for startInstances"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :start-instances,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   start-instances
   {:arglists (quote
               [[credentials
                 {:keys [instance-ids
                         general-progress-listener
                         additional-info]}]]),
    :doc "Call startInstances"}
   [credentials7560 & args7561]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7562
     (com.palletops.awaze.common/aws-client :ec2 credentials7560)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7562
      startInstances
      (ec2/start-instances-request (clojure.core/nth args7561 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :attach-network-interface
   [m7563]
   (clojure.core/let
    [credentials7564 (:credentials m7563) args7565 (:args m7563)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7566
      (com.palletops.awaze.common/aws-client :ec2 credentials7564)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7566
       attachNetworkInterface
       (ec2/attach-network-interface-request
        (clojure.core/nth args7565 0)))))))
  (clojure.core/defn
   attach-network-interface-map
   {:arglists (quote
               [[credentials
                 {:keys [network-interface-id
                         instance-id
                         general-progress-listener
                         device-index]}]]),
    :doc "Generate map for attachNetworkInterface"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :attach-network-interface,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   attach-network-interface
   {:arglists (quote
               [[credentials
                 {:keys [network-interface-id
                         instance-id
                         general-progress-listener
                         device-index]}]]),
    :doc "Call attachNetworkInterface"}
   [credentials7568 & args7569]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7570
     (com.palletops.awaze.common/aws-client :ec2 credentials7568)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7570
      attachNetworkInterface
      (ec2/attach-network-interface-request
       (clojure.core/nth args7569 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-route
   [m7571]
   (clojure.core/let
    [credentials7572 (:credentials m7571) args7573 (:args m7571)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7574
      (com.palletops.awaze.common/aws-client :ec2 credentials7572)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7574
       createRoute
       (ec2/create-route-request (clojure.core/nth args7573 0)))))))
  (clojure.core/defn
   create-route-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         gateway-id
                         destination-cidr-block
                         network-interface-id
                         vpc-peering-connection-id
                         instance-id
                         route-table-id]}]]),
    :doc "Generate map for createRoute"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :create-route,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-route
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         gateway-id
                         destination-cidr-block
                         network-interface-id
                         vpc-peering-connection-id
                         instance-id
                         route-table-id]}]]),
    :doc "Call createRoute"}
   [credentials7576 & args7577]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7578
     (com.palletops.awaze.common/aws-client :ec2 credentials7576)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7578
      createRoute
      (ec2/create-route-request (clojure.core/nth args7577 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :unmonitor-instances
   [m7579]
   (clojure.core/let
    [credentials7580 (:credentials m7579) args7581 (:args m7579)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7582
      (com.palletops.awaze.common/aws-client :ec2 credentials7580)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7582
       unmonitorInstances
       (ec2/unmonitor-instances-request (clojure.core/nth args7581 0)))))))
  (clojure.core/defn
   unmonitor-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [instance-ids general-progress-listener]}]]),
    :doc "Generate map for unmonitorInstances"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :unmonitor-instances,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   unmonitor-instances
   {:arglists (quote
               [[credentials
                 {:keys [instance-ids general-progress-listener]}]]),
    :doc "Call unmonitorInstances"}
   [credentials7584 & args7585]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7586
     (com.palletops.awaze.common/aws-client :ec2 credentials7584)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7586
      unmonitorInstances
      (ec2/unmonitor-instances-request (clojure.core/nth args7585 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-network-interface
   [m7587]
   (clojure.core/let
    [credentials7588 (:credentials m7587) args7589 (:args m7587)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7590
      (com.palletops.awaze.common/aws-client :ec2 credentials7588)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7590
       deleteNetworkInterface
       (ec2/delete-network-interface-request
        (clojure.core/nth args7589 0)))))))
  (clojure.core/defn
   delete-network-interface-map
   {:arglists (quote
               [[credentials
                 {:keys [network-interface-id
                         general-progress-listener]}]]),
    :doc "Generate map for deleteNetworkInterface"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :delete-network-interface,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-network-interface
   {:arglists (quote
               [[credentials
                 {:keys [network-interface-id
                         general-progress-listener]}]]),
    :doc "Call deleteNetworkInterface"}
   [credentials7592 & args7593]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7594
     (com.palletops.awaze.common/aws-client :ec2 credentials7592)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7594
      deleteNetworkInterface
      (ec2/delete-network-interface-request
       (clojure.core/nth args7593 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :monitor-instances
   [m7595]
   (clojure.core/let
    [credentials7596 (:credentials m7595) args7597 (:args m7595)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7598
      (com.palletops.awaze.common/aws-client :ec2 credentials7596)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7598
       monitorInstances
       (ec2/monitor-instances-request (clojure.core/nth args7597 0)))))))
  (clojure.core/defn
   monitor-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [instance-ids general-progress-listener]}]]),
    :doc "Generate map for monitorInstances"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :monitor-instances,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   monitor-instances
   {:arglists (quote
               [[credentials
                 {:keys [instance-ids general-progress-listener]}]]),
    :doc "Call monitorInstances"}
   [credentials7600 & args7601]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7602
     (com.palletops.awaze.common/aws-client :ec2 credentials7600)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7602
      monitorInstances
      (ec2/monitor-instances-request (clojure.core/nth args7601 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-reserved-instances-listings
   [m7603]
   (clojure.core/let
    [credentials7604 (:credentials m7603) args7605 (:args m7603)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7606
      (com.palletops.awaze.common/aws-client :ec2 credentials7604)]
     (clojure.core/case
      (clojure.core/count args7605)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7606
        describeReservedInstancesListings))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7606
        describeReservedInstancesListings
        (ec2/describe-reserved-instances-listings-request
         (clojure.core/nth args7605 0))))))))
  (clojure.core/defn
   describe-reserved-instances-listings-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [reserved-instances-listing-id
                         reserved-instances-id
                         general-progress-listener
                         filters]}]]),
    :doc "Generate map for describeReservedInstancesListings, describeReservedInstancesListings"}
   ([credentials__1651__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-reserved-instances-listings,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-reserved-instances-listings,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-reserved-instances-listings
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [reserved-instances-listing-id
                         reserved-instances-id
                         general-progress-listener
                         filters]}]]),
    :doc "Call describeReservedInstancesListings, describeReservedInstancesListings"}
   [credentials7608 & args7609]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7610
     (com.palletops.awaze.common/aws-client :ec2 credentials7608)]
    (clojure.core/case
     (clojure.core/count args7609)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7610
       describeReservedInstancesListings))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7610
       describeReservedInstancesListings
       (ec2/describe-reserved-instances-listings-request
        (clojure.core/nth args7609 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-tags
   [m7611]
   (clojure.core/let
    [credentials7612 (:credentials m7611) args7613 (:args m7611)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7614
      (com.palletops.awaze.common/aws-client :ec2 credentials7612)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7614
       createTags
       (ec2/create-tags-request (clojure.core/nth args7613 0)))))))
  (clojure.core/defn
   create-tags-map
   {:arglists (quote
               [[credentials
                 {:keys [tags resources general-progress-listener]}]]),
    :doc "Generate map for createTags"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :create-tags,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-tags
   {:arglists (quote
               [[credentials
                 {:keys [tags resources general-progress-listener]}]]),
    :doc "Call createTags"}
   [credentials7616 & args7617]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7618
     (com.palletops.awaze.common/aws-client :ec2 credentials7616)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7618
      createTags
      (ec2/create-tags-request (clojure.core/nth args7617 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :confirm-product-instance
   [m7619]
   (clojure.core/let
    [credentials7620 (:credentials m7619) args7621 (:args m7619)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7622
      (com.palletops.awaze.common/aws-client :ec2 credentials7620)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7622
       confirmProductInstance
       (ec2/confirm-product-instance-request
        (clojure.core/nth args7621 0)))))))
  (clojure.core/defn
   confirm-product-instance-map
   {:arglists (quote
               [[credentials
                 {:keys [product-code
                         instance-id
                         general-progress-listener]}]]),
    :doc "Generate map for confirmProductInstance"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :confirm-product-instance,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   confirm-product-instance
   {:arglists (quote
               [[credentials
                 {:keys [product-code
                         instance-id
                         general-progress-listener]}]]),
    :doc "Call confirmProductInstance"}
   [credentials7624 & args7625]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7626
     (com.palletops.awaze.common/aws-client :ec2 credentials7624)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7626
      confirmProductInstance
      (ec2/confirm-product-instance-request
       (clojure.core/nth args7625 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :disassociate-route-table
   [m7627]
   (clojure.core/let
    [credentials7628 (:credentials m7627) args7629 (:args m7627)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7630
      (com.palletops.awaze.common/aws-client :ec2 credentials7628)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7630
       disassociateRouteTable
       (ec2/disassociate-route-table-request
        (clojure.core/nth args7629 0)))))))
  (clojure.core/defn
   disassociate-route-table-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener association-id]}]]),
    :doc "Generate map for disassociateRouteTable"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :disassociate-route-table,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   disassociate-route-table
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener association-id]}]]),
    :doc "Call disassociateRouteTable"}
   [credentials7632 & args7633]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7634
     (com.palletops.awaze.common/aws-client :ec2 credentials7632)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7634
      disassociateRouteTable
      (ec2/disassociate-route-table-request
       (clojure.core/nth args7633 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :disassociate-address
   [m7635]
   (clojure.core/let
    [credentials7636 (:credentials m7635) args7637 (:args m7635)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7638
      (com.palletops.awaze.common/aws-client :ec2 credentials7636)]
     (clojure.core/case
      (clojure.core/count args7637)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7638
        disassociateAddress))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7638
        disassociateAddress
        (ec2/disassociate-address-request
         (clojure.core/nth args7637 0))))))))
  (clojure.core/defn
   disassociate-address-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [public-ip
                         general-progress-listener
                         association-id]}]]),
    :doc "Generate map for disassociateAddress, disassociateAddress"}
   ([credentials__1651__auto__]
    {:args [],
     :client :ec2,
     :fn :disassociate-address,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :disassociate-address,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   disassociate-address
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [public-ip
                         general-progress-listener
                         association-id]}]]),
    :doc "Call disassociateAddress, disassociateAddress"}
   [credentials7640 & args7641]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7642
     (com.palletops.awaze.common/aws-client :ec2 credentials7640)]
    (clojure.core/case
     (clojure.core/count args7641)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7642
       disassociateAddress))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7642
       disassociateAddress
       (ec2/disassociate-address-request
        (clojure.core/nth args7641 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :detach-network-interface
   [m7643]
   (clojure.core/let
    [credentials7644 (:credentials m7643) args7645 (:args m7643)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7646
      (com.palletops.awaze.common/aws-client :ec2 credentials7644)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7646
       detachNetworkInterface
       (ec2/detach-network-interface-request
        (clojure.core/nth args7645 0)))))))
  (clojure.core/defn
   detach-network-interface-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         force
                         attachment-id]}]]),
    :doc "Generate map for detachNetworkInterface"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :detach-network-interface,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   detach-network-interface
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         force
                         attachment-id]}]]),
    :doc "Call detachNetworkInterface"}
   [credentials7648 & args7649]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7650
     (com.palletops.awaze.common/aws-client :ec2 credentials7648)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7650
      detachNetworkInterface
      (ec2/detach-network-interface-request
       (clojure.core/nth args7649 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-export-tasks
   [m7651]
   (clojure.core/let
    [credentials7652 (:credentials m7651) args7653 (:args m7651)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7654
      (com.palletops.awaze.common/aws-client :ec2 credentials7652)]
     (clojure.core/case
      (clojure.core/count args7653)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7654
        describeExportTasks))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7654
        describeExportTasks
        (ec2/describe-export-tasks-request
         (clojure.core/nth args7653 0))))))))
  (clojure.core/defn
   describe-export-tasks-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [general-progress-listener export-task-ids]}]]),
    :doc "Generate map for describeExportTasks, describeExportTasks"}
   ([credentials__1651__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-export-tasks,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-export-tasks,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-export-tasks
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [general-progress-listener export-task-ids]}]]),
    :doc "Call describeExportTasks, describeExportTasks"}
   [credentials7656 & args7657]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7658
     (com.palletops.awaze.common/aws-client :ec2 credentials7656)]
    (clojure.core/case
     (clojure.core/count args7657)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7658
       describeExportTasks))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7658
       describeExportTasks
       (ec2/describe-export-tasks-request
        (clojure.core/nth args7657 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-addresses
   [m7659]
   (clojure.core/let
    [credentials7660 (:credentials m7659) args7661 (:args m7659)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7662
      (com.palletops.awaze.common/aws-client :ec2 credentials7660)]
     (clojure.core/case
      (clojure.core/count args7661)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7662
        describeAddresses
        (ec2/describe-addresses-request (clojure.core/nth args7661 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7662
        describeAddresses))))))
  (clojure.core/defn
   describe-addresses-map
   {:arglists (quote
               [[credentials
                 {:keys [public-ips
                         general-progress-listener
                         filters
                         allocation-ids]}]
                [credentials]]),
    :doc "Generate map for describeAddresses, describeAddresses"}
   ([credentials__1651__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-addresses,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-addresses,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-addresses
   {:arglists (quote
               [[credentials
                 {:keys [public-ips
                         general-progress-listener
                         filters
                         allocation-ids]}]
                [credentials]]),
    :doc "Call describeAddresses, describeAddresses"}
   [credentials7664 & args7665]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7666
     (com.palletops.awaze.common/aws-client :ec2 credentials7664)]
    (clojure.core/case
     (clojure.core/count args7665)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7666
       describeAddresses
       (ec2/describe-addresses-request (clojure.core/nth args7665 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7666
       describeAddresses))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-instance-export-task
   [m7667]
   (clojure.core/let
    [credentials7668 (:credentials m7667) args7669 (:args m7667)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7670
      (com.palletops.awaze.common/aws-client :ec2 credentials7668)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7670
       createInstanceExportTask
       (ec2/create-instance-export-task-request
        (clojure.core/nth args7669 0)))))))
  (clojure.core/defn
   create-instance-export-task-map
   {:arglists (quote
               [[credentials
                 {:keys [target-environment
                         instance-id
                         general-progress-listener
                         export-to-s3task
                         description]}]]),
    :doc "Generate map for createInstanceExportTask"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :create-instance-export-task,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-instance-export-task
   {:arglists (quote
               [[credentials
                 {:keys [target-environment
                         instance-id
                         general-progress-listener
                         export-to-s3task
                         description]}]]),
    :doc "Call createInstanceExportTask"}
   [credentials7672 & args7673]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7674
     (com.palletops.awaze.common/aws-client :ec2 credentials7672)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7674
      createInstanceExportTask
      (ec2/create-instance-export-task-request
       (clojure.core/nth args7673 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-image
   [m7675]
   (clojure.core/let
    [credentials7676 (:credentials m7675) args7677 (:args m7675)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7678
      (com.palletops.awaze.common/aws-client :ec2 credentials7676)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7678
       createImage
       (ec2/create-image-request (clojure.core/nth args7677 0)))))))
  (clojure.core/defn
   create-image-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         name
                         block-device-mappings
                         no-reboot
                         instance-id
                         description]}]]),
    :doc "Generate map for createImage"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :create-image,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-image
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         name
                         block-device-mappings
                         no-reboot
                         instance-id
                         description]}]]),
    :doc "Call createImage"}
   [credentials7680 & args7681]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7682
     (com.palletops.awaze.common/aws-client :ec2 credentials7680)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7682
      createImage
      (ec2/create-image-request (clojure.core/nth args7681 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-security-group
   [m7683]
   (clojure.core/let
    [credentials7684 (:credentials m7683) args7685 (:args m7683)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7686
      (com.palletops.awaze.common/aws-client :ec2 credentials7684)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7686
       createSecurityGroup
       (ec2/create-security-group-request
        (clojure.core/nth args7685 0)))))))
  (clojure.core/defn
   create-security-group-map
   {:arglists (quote
               [[credentials
                 {:keys [vpc-id
                         group-name
                         general-progress-listener
                         description]}]]),
    :doc "Generate map for createSecurityGroup"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :create-security-group,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-security-group
   {:arglists (quote
               [[credentials
                 {:keys [vpc-id
                         group-name
                         general-progress-listener
                         description]}]]),
    :doc "Call createSecurityGroup"}
   [credentials7688 & args7689]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7690
     (com.palletops.awaze.common/aws-client :ec2 credentials7688)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7690
      createSecurityGroup
      (ec2/create-security-group-request
       (clojure.core/nth args7689 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-subnet
   [m7691]
   (clojure.core/let
    [credentials7692 (:credentials m7691) args7693 (:args m7691)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7694
      (com.palletops.awaze.common/aws-client :ec2 credentials7692)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7694
       createSubnet
       (ec2/create-subnet-request (clojure.core/nth args7693 0)))))))
  (clojure.core/defn
   create-subnet-map
   {:arglists (quote
               [[credentials
                 {:keys [vpc-id
                         general-progress-listener
                         cidr-block
                         availability-zone]}]]),
    :doc "Generate map for createSubnet"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :create-subnet,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-subnet
   {:arglists (quote
               [[credentials
                 {:keys [vpc-id
                         general-progress-listener
                         cidr-block
                         availability-zone]}]]),
    :doc "Call createSubnet"}
   [credentials7696 & args7697]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7698
     (com.palletops.awaze.common/aws-client :ec2 credentials7696)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7698
      createSubnet
      (ec2/create-subnet-request (clojure.core/nth args7697 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-network-acl
   [m7699]
   (clojure.core/let
    [credentials7700 (:credentials m7699) args7701 (:args m7699)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7702
      (com.palletops.awaze.common/aws-client :ec2 credentials7700)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7702
       deleteNetworkAcl
       (ec2/delete-network-acl-request (clojure.core/nth args7701 0)))))))
  (clojure.core/defn
   delete-network-acl-map
   {:arglists (quote
               [[credentials
                 {:keys [network-acl-id general-progress-listener]}]]),
    :doc "Generate map for deleteNetworkAcl"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :delete-network-acl,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-network-acl
   {:arglists (quote
               [[credentials
                 {:keys [network-acl-id general-progress-listener]}]]),
    :doc "Call deleteNetworkAcl"}
   [credentials7704 & args7705]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7706
     (com.palletops.awaze.common/aws-client :ec2 credentials7704)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7706
      deleteNetworkAcl
      (ec2/delete-network-acl-request (clojure.core/nth args7705 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-network-interface
   [m7707]
   (clojure.core/let
    [credentials7708 (:credentials m7707) args7709 (:args m7707)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7710
      (com.palletops.awaze.common/aws-client :ec2 credentials7708)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7710
       createNetworkInterface
       (ec2/create-network-interface-request
        (clojure.core/nth args7709 0)))))))
  (clojure.core/defn
   create-network-interface-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         secondary-private-ip-address-count
                         subnet-id
                         private-ip-address
                         groups
                         private-ip-addresses
                         description]}]]),
    :doc "Generate map for createNetworkInterface"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :create-network-interface,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-network-interface
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         secondary-private-ip-address-count
                         subnet-id
                         private-ip-address
                         groups
                         private-ip-addresses
                         description]}]]),
    :doc "Call createNetworkInterface"}
   [credentials7712 & args7713]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7714
     (com.palletops.awaze.common/aws-client :ec2 credentials7712)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7714
      createNetworkInterface
      (ec2/create-network-interface-request
       (clojure.core/nth args7713 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-vpn-gateway
   [m7715]
   (clojure.core/let
    [credentials7716 (:credentials m7715) args7717 (:args m7715)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7718
      (com.palletops.awaze.common/aws-client :ec2 credentials7716)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7718
       deleteVpnGateway
       (ec2/delete-vpn-gateway-request (clojure.core/nth args7717 0)))))))
  (clojure.core/defn
   delete-vpn-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [vpn-gateway-id general-progress-listener]}]]),
    :doc "Generate map for deleteVpnGateway"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :delete-vpn-gateway,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-vpn-gateway
   {:arglists (quote
               [[credentials
                 {:keys [vpn-gateway-id general-progress-listener]}]]),
    :doc "Call deleteVpnGateway"}
   [credentials7720 & args7721]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7722
     (com.palletops.awaze.common/aws-client :ec2 credentials7720)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7722
      deleteVpnGateway
      (ec2/delete-vpn-gateway-request (clojure.core/nth args7721 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :attach-volume
   [m7723]
   (clojure.core/let
    [credentials7724 (:credentials m7723) args7725 (:args m7723)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7726
      (com.palletops.awaze.common/aws-client :ec2 credentials7724)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7726
       attachVolume
       (ec2/attach-volume-request (clojure.core/nth args7725 0)))))))
  (clojure.core/defn
   attach-volume-map
   {:arglists (quote
               [[credentials
                 {:keys [volume-id
                         instance-id
                         general-progress-listener
                         device]}]]),
    :doc "Generate map for attachVolume"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :attach-volume,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   attach-volume
   {:arglists (quote
               [[credentials
                 {:keys [volume-id
                         instance-id
                         general-progress-listener
                         device]}]]),
    :doc "Call attachVolume"}
   [credentials7728 & args7729]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7730
     (com.palletops.awaze.common/aws-client :ec2 credentials7728)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7730
      attachVolume
      (ec2/attach-volume-request (clojure.core/nth args7729 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-vpn-connection
   [m7731]
   (clojure.core/let
    [credentials7732 (:credentials m7731) args7733 (:args m7731)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7734
      (com.palletops.awaze.common/aws-client :ec2 credentials7732)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7734
       createVpnConnection
       (ec2/create-vpn-connection-request
        (clojure.core/nth args7733 0)))))))
  (clojure.core/defn
   create-vpn-connection-map
   {:arglists (quote
               [[credentials
                 {:keys [options
                         type
                         vpn-gateway-id
                         general-progress-listener
                         customer-gateway-id]}]]),
    :doc "Generate map for createVpnConnection"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :create-vpn-connection,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-vpn-connection
   {:arglists (quote
               [[credentials
                 {:keys [options
                         type
                         vpn-gateway-id
                         general-progress-listener
                         customer-gateway-id]}]]),
    :doc "Call createVpnConnection"}
   [credentials7736 & args7737]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7738
     (com.palletops.awaze.common/aws-client :ec2 credentials7736)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7738
      createVpnConnection
      (ec2/create-vpn-connection-request
       (clojure.core/nth args7737 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-placement-group
   [m7739]
   (clojure.core/let
    [credentials7740 (:credentials m7739) args7741 (:args m7739)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7742
      (com.palletops.awaze.common/aws-client :ec2 credentials7740)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7742
       deletePlacementGroup
       (ec2/delete-placement-group-request
        (clojure.core/nth args7741 0)))))))
  (clojure.core/defn
   delete-placement-group-map
   {:arglists (quote
               [[credentials
                 {:keys [group-name general-progress-listener]}]]),
    :doc "Generate map for deletePlacementGroup"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :delete-placement-group,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-placement-group
   {:arglists (quote
               [[credentials
                 {:keys [group-name general-progress-listener]}]]),
    :doc "Call deletePlacementGroup"}
   [credentials7744 & args7745]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7746
     (com.palletops.awaze.common/aws-client :ec2 credentials7744)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7746
      deletePlacementGroup
      (ec2/delete-placement-group-request
       (clojure.core/nth args7745 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :reset-instance-attribute
   [m7747]
   (clojure.core/let
    [credentials7748 (:credentials m7747) args7749 (:args m7747)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7750
      (com.palletops.awaze.common/aws-client :ec2 credentials7748)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7750
       resetInstanceAttribute
       (ec2/reset-instance-attribute-request
        (clojure.core/nth args7749 0)))))))
  (clojure.core/defn
   reset-instance-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [instance-id
                         general-progress-listener
                         attribute]}]]),
    :doc "Generate map for resetInstanceAttribute"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :reset-instance-attribute,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   reset-instance-attribute
   {:arglists (quote
               [[credentials
                 {:keys [instance-id
                         general-progress-listener
                         attribute]}]]),
    :doc "Call resetInstanceAttribute"}
   [credentials7752 & args7753]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7754
     (com.palletops.awaze.common/aws-client :ec2 credentials7752)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7754
      resetInstanceAttribute
      (ec2/reset-instance-attribute-request
       (clojure.core/nth args7753 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-snapshot
   [m7755]
   (clojure.core/let
    [credentials7756 (:credentials m7755) args7757 (:args m7755)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7758
      (com.palletops.awaze.common/aws-client :ec2 credentials7756)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7758
       createSnapshot
       (ec2/create-snapshot-request (clojure.core/nth args7757 0)))))))
  (clojure.core/defn
   create-snapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [volume-id
                         general-progress-listener
                         description]}]]),
    :doc "Generate map for createSnapshot"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :create-snapshot,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-snapshot
   {:arglists (quote
               [[credentials
                 {:keys [volume-id
                         general-progress-listener
                         description]}]]),
    :doc "Call createSnapshot"}
   [credentials7760 & args7761]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7762
     (com.palletops.awaze.common/aws-client :ec2 credentials7760)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7762
      createSnapshot
      (ec2/create-snapshot-request (clojure.core/nth args7761 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :request-spot-instances
   [m7763]
   (clojure.core/let
    [credentials7764 (:credentials m7763) args7765 (:args m7763)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7766
      (com.palletops.awaze.common/aws-client :ec2 credentials7764)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7766
       requestSpotInstances
       (ec2/request-spot-instances-request
        (clojure.core/nth args7765 0)))))))
  (clojure.core/defn
   request-spot-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         valid-from
                         spot-price
                         launch-group
                         instance-count
                         launch-specification
                         type
                         availability-zone-group
                         valid-until]}]]),
    :doc "Generate map for requestSpotInstances"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :request-spot-instances,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   request-spot-instances
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         valid-from
                         spot-price
                         launch-group
                         instance-count
                         launch-specification
                         type
                         availability-zone-group
                         valid-until]}]]),
    :doc "Call requestSpotInstances"}
   [credentials7768 & args7769]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7770
     (com.palletops.awaze.common/aws-client :ec2 credentials7768)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7770
      requestSpotInstances
      (ec2/request-spot-instances-request
       (clojure.core/nth args7769 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-network-interfaces
   [m7771]
   (clojure.core/let
    [credentials7772 (:credentials m7771) args7773 (:args m7771)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7774
      (com.palletops.awaze.common/aws-client :ec2 credentials7772)]
     (clojure.core/case
      (clojure.core/count args7773)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7774
        describeNetworkInterfaces
        (ec2/describe-network-interfaces-request
         (clojure.core/nth args7773 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7774
        describeNetworkInterfaces))))))
  (clojure.core/defn
   describe-network-interfaces-map
   {:arglists (quote
               [[credentials
                 {:keys [network-interface-ids
                         general-progress-listener
                         filters]}]
                [credentials]]),
    :doc "Generate map for describeNetworkInterfaces, describeNetworkInterfaces"}
   ([credentials__1651__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-network-interfaces,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-network-interfaces,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-network-interfaces
   {:arglists (quote
               [[credentials
                 {:keys [network-interface-ids
                         general-progress-listener
                         filters]}]
                [credentials]]),
    :doc "Call describeNetworkInterfaces, describeNetworkInterfaces"}
   [credentials7776 & args7777]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7778
     (com.palletops.awaze.common/aws-client :ec2 credentials7776)]
    (clojure.core/case
     (clojure.core/count args7777)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7778
       describeNetworkInterfaces
       (ec2/describe-network-interfaces-request
        (clojure.core/nth args7777 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7778
       describeNetworkInterfaces))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-volume
   [m7779]
   (clojure.core/let
    [credentials7780 (:credentials m7779) args7781 (:args m7779)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7782
      (com.palletops.awaze.common/aws-client :ec2 credentials7780)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7782
       deleteVolume
       (ec2/delete-volume-request (clojure.core/nth args7781 0)))))))
  (clojure.core/defn
   delete-volume-map
   {:arglists (quote
               [[credentials
                 {:keys [volume-id general-progress-listener]}]]),
    :doc "Generate map for deleteVolume"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :delete-volume,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-volume
   {:arglists (quote
               [[credentials
                 {:keys [volume-id general-progress-listener]}]]),
    :doc "Call deleteVolume"}
   [credentials7784 & args7785]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7786
     (com.palletops.awaze.common/aws-client :ec2 credentials7784)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7786
      deleteVolume
      (ec2/delete-volume-request (clojure.core/nth args7785 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-snapshot
   [m7787]
   (clojure.core/let
    [credentials7788 (:credentials m7787) args7789 (:args m7787)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7790
      (com.palletops.awaze.common/aws-client :ec2 credentials7788)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7790
       deleteSnapshot
       (ec2/delete-snapshot-request (clojure.core/nth args7789 0)))))))
  (clojure.core/defn
   delete-snapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [snapshot-id general-progress-listener]}]]),
    :doc "Generate map for deleteSnapshot"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :delete-snapshot,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-snapshot
   {:arglists (quote
               [[credentials
                 {:keys [snapshot-id general-progress-listener]}]]),
    :doc "Call deleteSnapshot"}
   [credentials7792 & args7793]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7794
     (com.palletops.awaze.common/aws-client :ec2 credentials7792)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7794
      deleteSnapshot
      (ec2/delete-snapshot-request (clojure.core/nth args7793 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-instances
   [m7795]
   (clojure.core/let
    [credentials7796 (:credentials m7795) args7797 (:args m7795)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7798
      (com.palletops.awaze.common/aws-client :ec2 credentials7796)]
     (clojure.core/case
      (clojure.core/count args7797)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7798
        describeInstances))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7798
        describeInstances
        (ec2/describe-instances-request (clojure.core/nth args7797 0))))))))
  (clojure.core/defn
   describe-instances-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [instance-ids
                         general-progress-listener
                         next-token
                         filters
                         max-results]}]]),
    :doc "Generate map for describeInstances, describeInstances"}
   ([credentials__1651__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-instances,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-instances,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-instances
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [instance-ids
                         general-progress-listener
                         next-token
                         filters
                         max-results]}]]),
    :doc "Call describeInstances, describeInstances"}
   [credentials7800 & args7801]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7802
     (com.palletops.awaze.common/aws-client :ec2 credentials7800)]
    (clojure.core/case
     (clojure.core/count args7801)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7802
       describeInstances))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7802
       describeInstances
       (ec2/describe-instances-request (clojure.core/nth args7801 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :associate-route-table
   [m7803]
   (clojure.core/let
    [credentials7804 (:credentials m7803) args7805 (:args m7803)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7806
      (com.palletops.awaze.common/aws-client :ec2 credentials7804)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7806
       associateRouteTable
       (ec2/associate-route-table-request
        (clojure.core/nth args7805 0)))))))
  (clojure.core/defn
   associate-route-table-map
   {:arglists (quote
               [[credentials
                 {:keys [subnet-id
                         route-table-id
                         general-progress-listener]}]]),
    :doc "Generate map for associateRouteTable"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :associate-route-table,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   associate-route-table
   {:arglists (quote
               [[credentials
                 {:keys [subnet-id
                         route-table-id
                         general-progress-listener]}]]),
    :doc "Call associateRouteTable"}
   [credentials7808 & args7809]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7810
     (com.palletops.awaze.common/aws-client :ec2 credentials7808)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7810
      associateRouteTable
      (ec2/associate-route-table-request
       (clojure.core/nth args7809 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :disable-vgw-route-propagation
   [m7811]
   (clojure.core/let
    [credentials7812 (:credentials m7811) args7813 (:args m7811)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7814
      (com.palletops.awaze.common/aws-client :ec2 credentials7812)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7814
       disableVgwRoutePropagation
       (ec2/disable-vgw-route-propagation-request
        (clojure.core/nth args7813 0)))))))
  (clojure.core/defn
   disable-vgw-route-propagation-map
   {:arglists (quote
               [[credentials
                 {:keys [route-table-id
                         general-progress-listener
                         gateway-id]}]]),
    :doc "Generate map for disableVgwRoutePropagation"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :disable-vgw-route-propagation,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   disable-vgw-route-propagation
   {:arglists (quote
               [[credentials
                 {:keys [route-table-id
                         general-progress-listener
                         gateway-id]}]]),
    :doc "Call disableVgwRoutePropagation"}
   [credentials7816 & args7817]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7818
     (com.palletops.awaze.common/aws-client :ec2 credentials7816)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7818
      disableVgwRoutePropagation
      (ec2/disable-vgw-route-propagation-request
       (clojure.core/nth args7817 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-instance-attribute
   [m7819]
   (clojure.core/let
    [credentials7820 (:credentials m7819) args7821 (:args m7819)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7822
      (com.palletops.awaze.common/aws-client :ec2 credentials7820)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7822
       describeInstanceAttribute
       (ec2/describe-instance-attribute-request
        (clojure.core/nth args7821 0)))))))
  (clojure.core/defn
   describe-instance-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [instance-id
                         general-progress-listener
                         attribute]}]]),
    :doc "Generate map for describeInstanceAttribute"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-instance-attribute,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-instance-attribute
   {:arglists (quote
               [[credentials
                 {:keys [instance-id
                         general-progress-listener
                         attribute]}]]),
    :doc "Call describeInstanceAttribute"}
   [credentials7824 & args7825]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7826
     (com.palletops.awaze.common/aws-client :ec2 credentials7824)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7826
      describeInstanceAttribute
      (ec2/describe-instance-attribute-request
       (clojure.core/nth args7825 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-vpn-gateway
   [m7827]
   (clojure.core/let
    [credentials7828 (:credentials m7827) args7829 (:args m7827)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7830
      (com.palletops.awaze.common/aws-client :ec2 credentials7828)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7830
       createVpnGateway
       (ec2/create-vpn-gateway-request (clojure.core/nth args7829 0)))))))
  (clojure.core/defn
   create-vpn-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [type
                         general-progress-listener
                         availability-zone]}]]),
    :doc "Generate map for createVpnGateway"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :create-vpn-gateway,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-vpn-gateway
   {:arglists (quote
               [[credentials
                 {:keys [type
                         general-progress-listener
                         availability-zone]}]]),
    :doc "Call createVpnGateway"}
   [credentials7832 & args7833]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7834
     (com.palletops.awaze.common/aws-client :ec2 credentials7832)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7834
      createVpnGateway
      (ec2/create-vpn-gateway-request (clojure.core/nth args7833 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-network-acl
   [m7835]
   (clojure.core/let
    [credentials7836 (:credentials m7835) args7837 (:args m7835)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7838
      (com.palletops.awaze.common/aws-client :ec2 credentials7836)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7838
       createNetworkAcl
       (ec2/create-network-acl-request (clojure.core/nth args7837 0)))))))
  (clojure.core/defn
   create-network-acl-map
   {:arglists (quote
               [[credentials
                 {:keys [vpc-id general-progress-listener]}]]),
    :doc "Generate map for createNetworkAcl"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :create-network-acl,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-network-acl
   {:arglists (quote
               [[credentials
                 {:keys [vpc-id general-progress-listener]}]]),
    :doc "Call createNetworkAcl"}
   [credentials7840 & args7841]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7842
     (com.palletops.awaze.common/aws-client :ec2 credentials7840)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7842
      createNetworkAcl
      (ec2/create-network-acl-request (clojure.core/nth args7841 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :replace-route
   [m7843]
   (clojure.core/let
    [credentials7844 (:credentials m7843) args7845 (:args m7843)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7846
      (com.palletops.awaze.common/aws-client :ec2 credentials7844)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7846
       replaceRoute
       (ec2/replace-route-request (clojure.core/nth args7845 0)))))))
  (clojure.core/defn
   replace-route-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         gateway-id
                         destination-cidr-block
                         network-interface-id
                         vpc-peering-connection-id
                         instance-id
                         route-table-id]}]]),
    :doc "Generate map for replaceRoute"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :replace-route,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   replace-route
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         gateway-id
                         destination-cidr-block
                         network-interface-id
                         vpc-peering-connection-id
                         instance-id
                         route-table-id]}]]),
    :doc "Call replaceRoute"}
   [credentials7848 & args7849]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7850
     (com.palletops.awaze.common/aws-client :ec2 credentials7848)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7850
      replaceRoute
      (ec2/replace-route-request (clojure.core/nth args7849 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-regions
   [m7851]
   (clojure.core/let
    [credentials7852 (:credentials m7851) args7853 (:args m7851)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7854
      (com.palletops.awaze.common/aws-client :ec2 credentials7852)]
     (clojure.core/case
      (clojure.core/count args7853)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7854
        describeRegions))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7854
        describeRegions
        (ec2/describe-regions-request (clojure.core/nth args7853 0))))))))
  (clojure.core/defn
   describe-regions-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [region-names
                         general-progress-listener
                         filters]}]]),
    :doc "Generate map for describeRegions, describeRegions"}
   ([credentials__1651__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-regions,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-regions,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-regions
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [region-names
                         general-progress-listener
                         filters]}]]),
    :doc "Call describeRegions, describeRegions"}
   [credentials7856 & args7857]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7858
     (com.palletops.awaze.common/aws-client :ec2 credentials7856)]
    (clojure.core/case
     (clojure.core/count args7857)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7858
       describeRegions))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7858
       describeRegions
       (ec2/describe-regions-request (clojure.core/nth args7857 0))))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-internet-gateway
   [m7859]
   (clojure.core/let
    [credentials7860 (:credentials m7859) args7861 (:args m7859)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7862
      (com.palletops.awaze.common/aws-client :ec2 credentials7860)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7862
       deleteInternetGateway
       (ec2/delete-internet-gateway-request
        (clojure.core/nth args7861 0)))))))
  (clojure.core/defn
   delete-internet-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [internet-gateway-id
                         general-progress-listener]}]]),
    :doc "Generate map for deleteInternetGateway"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :delete-internet-gateway,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-internet-gateway
   {:arglists (quote
               [[credentials
                 {:keys [internet-gateway-id
                         general-progress-listener]}]]),
    :doc "Call deleteInternetGateway"}
   [credentials7864 & args7865]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7866
     (com.palletops.awaze.common/aws-client :ec2 credentials7864)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7866
      deleteInternetGateway
      (ec2/delete-internet-gateway-request
       (clojure.core/nth args7865 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-route
   [m7867]
   (clojure.core/let
    [credentials7868 (:credentials m7867) args7869 (:args m7867)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7870
      (com.palletops.awaze.common/aws-client :ec2 credentials7868)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7870
       deleteRoute
       (ec2/delete-route-request (clojure.core/nth args7869 0)))))))
  (clojure.core/defn
   delete-route-map
   {:arglists (quote
               [[credentials
                 {:keys [route-table-id
                         general-progress-listener
                         destination-cidr-block]}]]),
    :doc "Generate map for deleteRoute"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :delete-route,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-route
   {:arglists (quote
               [[credentials
                 {:keys [route-table-id
                         general-progress-listener
                         destination-cidr-block]}]]),
    :doc "Call deleteRoute"}
   [credentials7872 & args7873]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7874
     (com.palletops.awaze.common/aws-client :ec2 credentials7872)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7874
      deleteRoute
      (ec2/delete-route-request (clojure.core/nth args7873 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :assign-private-ip-addresses
   [m7875]
   (clojure.core/let
    [credentials7876 (:credentials m7875) args7877 (:args m7875)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7878
      (com.palletops.awaze.common/aws-client :ec2 credentials7876)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7878
       assignPrivateIpAddresses
       (ec2/assign-private-ip-addresses-request
        (clojure.core/nth args7877 0)))))))
  (clojure.core/defn
   assign-private-ip-addresses-map
   {:arglists (quote
               [[credentials
                 {:keys [secondary-private-ip-address-count
                         private-ip-addresses
                         network-interface-id
                         general-progress-listener
                         allow-reassignment]}]]),
    :doc "Generate map for assignPrivateIpAddresses"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :assign-private-ip-addresses,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   assign-private-ip-addresses
   {:arglists (quote
               [[credentials
                 {:keys [secondary-private-ip-address-count
                         private-ip-addresses
                         network-interface-id
                         general-progress-listener
                         allow-reassignment]}]]),
    :doc "Call assignPrivateIpAddresses"}
   [credentials7880 & args7881]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7882
     (com.palletops.awaze.common/aws-client :ec2 credentials7880)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7882
      assignPrivateIpAddresses
      (ec2/assign-private-ip-addresses-request
       (clojure.core/nth args7881 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :delete-dhcp-options
   [m7883]
   (clojure.core/let
    [credentials7884 (:credentials m7883) args7885 (:args m7883)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7886
      (com.palletops.awaze.common/aws-client :ec2 credentials7884)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7886
       deleteDhcpOptions
       (ec2/delete-dhcp-options-request (clojure.core/nth args7885 0)))))))
  (clojure.core/defn
   delete-dhcp-options-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener dhcp-options-id]}]]),
    :doc "Generate map for deleteDhcpOptions"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :delete-dhcp-options,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-dhcp-options
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener dhcp-options-id]}]]),
    :doc "Call deleteDhcpOptions"}
   [credentials7888 & args7889]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7890
     (com.palletops.awaze.common/aws-client :ec2 credentials7888)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7890
      deleteDhcpOptions
      (ec2/delete-dhcp-options-request (clojure.core/nth args7889 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :cancel-spot-instance-requests
   [m7891]
   (clojure.core/let
    [credentials7892 (:credentials m7891) args7893 (:args m7891)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7894
      (com.palletops.awaze.common/aws-client :ec2 credentials7892)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7894
       cancelSpotInstanceRequests
       (ec2/cancel-spot-instance-requests-request
        (clojure.core/nth args7893 0)))))))
  (clojure.core/defn
   cancel-spot-instance-requests-map
   {:arglists (quote
               [[credentials
                 {:keys [spot-instance-request-ids
                         general-progress-listener]}]]),
    :doc "Generate map for cancelSpotInstanceRequests"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :cancel-spot-instance-requests,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   cancel-spot-instance-requests
   {:arglists (quote
               [[credentials
                 {:keys [spot-instance-request-ids
                         general-progress-listener]}]]),
    :doc "Call cancelSpotInstanceRequests"}
   [credentials7896 & args7897]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7898
     (com.palletops.awaze.common/aws-client :ec2 credentials7896)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7898
      cancelSpotInstanceRequests
      (ec2/cancel-spot-instance-requests-request
       (clojure.core/nth args7897 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :create-dhcp-options
   [m7899]
   (clojure.core/let
    [credentials7900 (:credentials m7899) args7901 (:args m7899)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7902
      (com.palletops.awaze.common/aws-client :ec2 credentials7900)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7902
       createDhcpOptions
       (ec2/create-dhcp-options-request (clojure.core/nth args7901 0)))))))
  (clojure.core/defn
   create-dhcp-options-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         dhcp-configurations]}]]),
    :doc "Generate map for createDhcpOptions"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :create-dhcp-options,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-dhcp-options
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         dhcp-configurations]}]]),
    :doc "Call createDhcpOptions"}
   [credentials7904 & args7905]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7906
     (com.palletops.awaze.common/aws-client :ec2 credentials7904)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7906
      createDhcpOptions
      (ec2/create-dhcp-options-request (clojure.core/nth args7905 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :stop-instances
   [m7907]
   (clojure.core/let
    [credentials7908 (:credentials m7907) args7909 (:args m7907)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7910
      (com.palletops.awaze.common/aws-client :ec2 credentials7908)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7910
       stopInstances
       (ec2/stop-instances-request (clojure.core/nth args7909 0)))))))
  (clojure.core/defn
   stop-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [instance-ids general-progress-listener force]}]]),
    :doc "Generate map for stopInstances"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :stop-instances,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   stop-instances
   {:arglists (quote
               [[credentials
                 {:keys [instance-ids general-progress-listener force]}]]),
    :doc "Call stopInstances"}
   [credentials7912 & args7913]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7914
     (com.palletops.awaze.common/aws-client :ec2 credentials7912)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7914
      stopInstances
      (ec2/stop-instances-request (clojure.core/nth args7913 0)))))))
 (do
  (clojure.core/defmethod
   ec2
   :authorize-security-group-ingress
   [m7915]
   (clojure.core/let
    [credentials7916 (:credentials m7915) args7917 (:args m7915)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7918
      (com.palletops.awaze.common/aws-client :ec2 credentials7916)]
     (clojure.core/case
      (clojure.core/count args7917)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7918
        authorizeSecurityGroupIngress
        (ec2/authorize-security-group-ingress-request
         (clojure.core/nth args7917 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7918
        authorizeSecurityGroupIngress))))))
  (clojure.core/defn
   authorize-security-group-ingress-map
   {:arglists (quote
               [[credentials
                 {:keys [source-security-group-name
                         group-id
                         general-progress-listener
                         from-port
                         ip-permissions
                         to-port
                         cidr-ip
                         ip-protocol
                         source-security-group-owner-id
                         group-name]}]
                [credentials]]),
    :doc "Generate map for authorizeSecurityGroupIngress, authorizeSecurityGroupIngress"}
   ([credentials__1651__auto__]
    {:args [],
     :client :ec2,
     :fn :authorize-security-group-ingress,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :authorize-security-group-ingress,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   authorize-security-group-ingress
   {:arglists (quote
               [[credentials
                 {:keys [source-security-group-name
                         group-id
                         general-progress-listener
                         from-port
                         ip-permissions
                         to-port
                         cidr-ip
                         ip-protocol
                         source-security-group-owner-id
                         group-name]}]
                [credentials]]),
    :doc "Call authorizeSecurityGroupIngress, authorizeSecurityGroupIngress"}
   [credentials7920 & args7921]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7922
     (com.palletops.awaze.common/aws-client :ec2 credentials7920)]
    (clojure.core/case
     (clojure.core/count args7921)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7922
       authorizeSecurityGroupIngress
       (ec2/authorize-security-group-ingress-request
        (clojure.core/nth args7921 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7922
       authorizeSecurityGroupIngress))))))
 (do
  (clojure.core/defmethod
   ec2
   :describe-placement-groups
   [m7923]
   (clojure.core/let
    [credentials7924 (:credentials m7923) args7925 (:args m7923)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
      client7926
      (com.palletops.awaze.common/aws-client :ec2 credentials7924)]
     (clojure.core/case
      (clojure.core/count args7925)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7926
        describePlacementGroups))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7926
        describePlacementGroups
        (ec2/describe-placement-groups-request
         (clojure.core/nth args7925 0))))))))
  (clojure.core/defn
   describe-placement-groups-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [group-names
                         general-progress-listener
                         filters]}]]),
    :doc "Generate map for describePlacementGroups, describePlacementGroups"}
   ([credentials__1651__auto__]
    {:args [],
     :client :ec2,
     :fn :describe-placement-groups,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :ec2,
     :fn :describe-placement-groups,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-placement-groups
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [group-names
                         general-progress-listener
                         filters]}]]),
    :doc "Call describePlacementGroups, describePlacementGroups"}
   [credentials7928 & args7929]
   (clojure.core/let
    [^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
     client7930
     (com.palletops.awaze.common/aws-client :ec2 credentials7928)]
    (clojure.core/case
     (clojure.core/count args7929)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7930
       describePlacementGroups))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.ec2.AmazonEC2Client}
client7930
       describePlacementGroups
       (ec2/describe-placement-groups-request
        (clojure.core/nth args7929 0)))))))))
