(ns
 com.palletops.awaze.elasticloadbalancing
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.elasticloadbalancing :as elasticloadbalancing]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :elasticloadbalancing
  [___1600__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1601__auto__]
  (new
   com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient
   credentials__1601__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.CrossZoneLoadBalancing}
cross-zone-load-balancing
  [m4463]
  (clojure.core/let
   [bean4462
    (new
     com.amazonaws.services.elasticloadbalancing.model.CrossZoneLoadBalancing)]
   (clojure.core/when-let
    [v4464 (:enabled m4463)]
    (. bean4462 setEnabled (clojure.core/boolean v4464)))
   bean4462))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.AccessLog}
access-log
  [m4466]
  (clojure.core/let
   [bean4465
    (new com.amazonaws.services.elasticloadbalancing.model.AccessLog)]
   (clojure.core/when-let
    [v4467 (:s3bucket-name m4466)]
    (. bean4465 setS3BucketName (clojure.core/str v4467)))
   (clojure.core/when-let
    [v4467 (:emit-interval m4466)]
    (. bean4465 setEmitInterval (clojure.core/int v4467)))
   (clojure.core/when-let
    [v4467 (:s3bucket-prefix m4466)]
    (. bean4465 setS3BucketPrefix (clojure.core/str v4467)))
   (clojure.core/when-let
    [v4467 (:enabled m4466)]
    (. bean4465 setEnabled (clojure.core/boolean v4467)))
   bean4465))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.ConnectionDraining}
connection-draining
  [m4469]
  (clojure.core/let
   [bean4468
    (new
     com.amazonaws.services.elasticloadbalancing.model.ConnectionDraining)]
   (clojure.core/when-let
    [v4470 (:timeout m4469)]
    (. bean4468 setTimeout (clojure.core/int v4470)))
   (clojure.core/when-let
    [v4470 (:enabled m4469)]
    (. bean4468 setEnabled (clojure.core/boolean v4470)))
   bean4468))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.Instance}
instance
  [m4472]
  (clojure.core/let
   [bean4471
    (new com.amazonaws.services.elasticloadbalancing.model.Instance)]
   (clojure.core/when-let
    [v4473 (:instance-id m4472)]
    (. bean4471 setInstanceId (clojure.core/str v4473)))
   bean4471))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.PolicyAttribute}
policy-attribute
  [m4475]
  (clojure.core/let
   [bean4474
    (new
     com.amazonaws.services.elasticloadbalancing.model.PolicyAttribute)]
   (clojure.core/when-let
    [v4476 (:attribute-name m4475)]
    (. bean4474 setAttributeName (clojure.core/str v4476)))
   (clojure.core/when-let
    [v4476 (:attribute-value m4475)]
    (. bean4474 setAttributeValue (clojure.core/str v4476)))
   bean4474))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.HealthCheck}
health-check
  [m4478]
  (clojure.core/let
   [bean4477
    (new
     com.amazonaws.services.elasticloadbalancing.model.HealthCheck)]
   (clojure.core/when-let
    [v4479 (:target m4478)]
    (. bean4477 setTarget (clojure.core/str v4479)))
   (clojure.core/when-let
    [v4479 (:interval m4478)]
    (. bean4477 setInterval (clojure.core/int v4479)))
   (clojure.core/when-let
    [v4479 (:timeout m4478)]
    (. bean4477 setTimeout (clojure.core/int v4479)))
   (clojure.core/when-let
    [v4479 (:unhealthy-threshold m4478)]
    (. bean4477 setUnhealthyThreshold (clojure.core/int v4479)))
   (clojure.core/when-let
    [v4479 (:healthy-threshold m4478)]
    (. bean4477 setHealthyThreshold (clojure.core/int v4479)))
   bean4477))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.Listener}
listener
  [m4481]
  (clojure.core/let
   [bean4480
    (new com.amazonaws.services.elasticloadbalancing.model.Listener)]
   (clojure.core/when-let
    [v4482 (:instance-protocol m4481)]
    (. bean4480 setInstanceProtocol (clojure.core/str v4482)))
   (clojure.core/when-let
    [v4482 (:protocol m4481)]
    (. bean4480 setProtocol (clojure.core/str v4482)))
   (clojure.core/when-let
    [v4482 (:load-balancer-port m4481)]
    (. bean4480 setLoadBalancerPort (clojure.core/int v4482)))
   (clojure.core/when-let
    [v4482 (:instance-port m4481)]
    (. bean4480 setInstancePort (clojure.core/int v4482)))
   (clojure.core/when-let
    [v4482 (:sslcertificate-id m4481)]
    (. bean4480 setSSLCertificateId (clojure.core/str v4482)))
   bean4480))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.LoadBalancerAttributes}
load-balancer-attributes
  [m4484]
  (clojure.core/let
   [bean4483
    (new
     com.amazonaws.services.elasticloadbalancing.model.LoadBalancerAttributes)]
   (clojure.core/when-let
    [v4485 (:cross-zone-load-balancing m4484)]
    (.
     bean4483
     setCrossZoneLoadBalancing
     (elasticloadbalancing/cross-zone-load-balancing v4485)))
   (clojure.core/when-let
    [v4485 (:access-log m4484)]
    (. bean4483 setAccessLog (elasticloadbalancing/access-log v4485)))
   (clojure.core/when-let
    [v4485 (:connection-draining m4484)]
    (.
     bean4483
     setConnectionDraining
     (elasticloadbalancing/connection-draining v4485)))
   bean4483))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.DeregisterInstancesFromLoadBalancerRequest}
deregister-instances-from-load-balancer-request
  [m4487]
  (clojure.core/let
   [bean4486
    (new
     com.amazonaws.services.elasticloadbalancing.model.DeregisterInstancesFromLoadBalancerRequest)]
   (clojure.core/when-let
    [v4488 (:instances m4487)]
    (.
     bean4486
     setInstances
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4561] (elasticloadbalancing/instance arg4561))
 v4488)))
   (clojure.core/when-let
    [v4488 (:load-balancer-name m4487)]
    (. bean4486 setLoadBalancerName (clojure.core/str v4488)))
   bean4486))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.EnableAvailabilityZonesForLoadBalancerRequest}
enable-availability-zones-for-load-balancer-request
  [m4490]
  (clojure.core/let
   [bean4489
    (new
     com.amazonaws.services.elasticloadbalancing.model.EnableAvailabilityZonesForLoadBalancerRequest)]
   (clojure.core/when-let
    [v4491 (:availability-zones m4490)]
    (.
     bean4489
     setAvailabilityZones
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4562] (clojure.core/str arg4562))
 v4491)))
   (clojure.core/when-let
    [v4491 (:load-balancer-name m4490)]
    (. bean4489 setLoadBalancerName (clojure.core/str v4491)))
   bean4489))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.ApplySecurityGroupsToLoadBalancerRequest}
apply-security-groups-to-load-balancer-request
  [m4493]
  (clojure.core/let
   [bean4492
    (new
     com.amazonaws.services.elasticloadbalancing.model.ApplySecurityGroupsToLoadBalancerRequest)]
   (clojure.core/when-let
    [v4494 (:security-groups m4493)]
    (.
     bean4492
     setSecurityGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4563] (clojure.core/str arg4563))
 v4494)))
   (clojure.core/when-let
    [v4494 (:load-balancer-name m4493)]
    (. bean4492 setLoadBalancerName (clojure.core/str v4494)))
   bean4492))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.CreateLBCookieStickinessPolicyRequest}
create-lbcookie-stickiness-policy-request
  [m4496]
  (clojure.core/let
   [bean4495
    (new
     com.amazonaws.services.elasticloadbalancing.model.CreateLBCookieStickinessPolicyRequest)]
   (clojure.core/when-let
    [v4497 (:policy-name m4496)]
    (. bean4495 setPolicyName (clojure.core/str v4497)))
   (clojure.core/when-let
    [v4497 (:load-balancer-name m4496)]
    (. bean4495 setLoadBalancerName (clojure.core/str v4497)))
   (clojure.core/when-let
    [v4497 (:cookie-expiration-period m4496)]
    (. bean4495 setCookieExpirationPeriod (clojure.core/long v4497)))
   bean4495))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.DescribeLoadBalancerPoliciesRequest}
describe-load-balancer-policies-request
  [m4499]
  (clojure.core/let
   [bean4498
    (new
     com.amazonaws.services.elasticloadbalancing.model.DescribeLoadBalancerPoliciesRequest)]
   (clojure.core/when-let
    [v4500 (:policy-names m4499)]
    (.
     bean4498
     setPolicyNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4564] (clojure.core/str arg4564))
 v4500)))
   (clojure.core/when-let
    [v4500 (:load-balancer-name m4499)]
    (. bean4498 setLoadBalancerName (clojure.core/str v4500)))
   bean4498))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.DeleteLoadBalancerRequest}
delete-load-balancer-request
  [m4502]
  (clojure.core/let
   [bean4501
    (new
     com.amazonaws.services.elasticloadbalancing.model.DeleteLoadBalancerRequest)]
   (clojure.core/when-let
    [v4503 (:load-balancer-name m4502)]
    (. bean4501 setLoadBalancerName (clojure.core/str v4503)))
   bean4501))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.DescribeLoadBalancerPolicyTypesRequest}
describe-load-balancer-policy-types-request
  [m4505]
  (clojure.core/let
   [bean4504
    (new
     com.amazonaws.services.elasticloadbalancing.model.DescribeLoadBalancerPolicyTypesRequest)]
   (clojure.core/when-let
    [v4506 (:policy-type-names m4505)]
    (.
     bean4504
     setPolicyTypeNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4565] (clojure.core/str arg4565))
 v4506)))
   bean4504))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.DeleteLoadBalancerPolicyRequest}
delete-load-balancer-policy-request
  [m4508]
  (clojure.core/let
   [bean4507
    (new
     com.amazonaws.services.elasticloadbalancing.model.DeleteLoadBalancerPolicyRequest)]
   (clojure.core/when-let
    [v4509 (:policy-name m4508)]
    (. bean4507 setPolicyName (clojure.core/str v4509)))
   (clojure.core/when-let
    [v4509 (:load-balancer-name m4508)]
    (. bean4507 setLoadBalancerName (clojure.core/str v4509)))
   bean4507))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.CreateLoadBalancerPolicyRequest}
create-load-balancer-policy-request
  [m4511]
  (clojure.core/let
   [bean4510
    (new
     com.amazonaws.services.elasticloadbalancing.model.CreateLoadBalancerPolicyRequest)]
   (clojure.core/when-let
    [v4512 (:policy-name m4511)]
    (. bean4510 setPolicyName (clojure.core/str v4512)))
   (clojure.core/when-let
    [v4512 (:load-balancer-name m4511)]
    (. bean4510 setLoadBalancerName (clojure.core/str v4512)))
   (clojure.core/when-let
    [v4512 (:policy-type-name m4511)]
    (. bean4510 setPolicyTypeName (clojure.core/str v4512)))
   (clojure.core/when-let
    [v4512 (:policy-attributes m4511)]
    (.
     bean4510
     setPolicyAttributes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg4566]
  (elasticloadbalancing/policy-attribute arg4566))
 v4512)))
   bean4510))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.ConfigureHealthCheckRequest}
configure-health-check-request
  [m4514]
  (clojure.core/let
   [bean4513
    (new
     com.amazonaws.services.elasticloadbalancing.model.ConfigureHealthCheckRequest)]
   (clojure.core/when-let
    [v4515 (:load-balancer-name m4514)]
    (. bean4513 setLoadBalancerName (clojure.core/str v4515)))
   (clojure.core/when-let
    [v4515 (:health-check m4514)]
    (.
     bean4513
     setHealthCheck
     (elasticloadbalancing/health-check v4515)))
   bean4513))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.DescribeInstanceHealthRequest}
describe-instance-health-request
  [m4517]
  (clojure.core/let
   [bean4516
    (new
     com.amazonaws.services.elasticloadbalancing.model.DescribeInstanceHealthRequest)]
   (clojure.core/when-let
    [v4518 (:instances m4517)]
    (.
     bean4516
     setInstances
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4567] (elasticloadbalancing/instance arg4567))
 v4518)))
   (clojure.core/when-let
    [v4518 (:load-balancer-name m4517)]
    (. bean4516 setLoadBalancerName (clojure.core/str v4518)))
   bean4516))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.CreateLoadBalancerRequest}
create-load-balancer-request
  [m4520]
  (clojure.core/let
   [bean4519
    (new
     com.amazonaws.services.elasticloadbalancing.model.CreateLoadBalancerRequest)]
   (clojure.core/when-let
    [v4521 (:subnets m4520)]
    (.
     bean4519
     setSubnets
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4568] (clojure.core/str arg4568))
 v4521)))
   (clojure.core/when-let
    [v4521 (:availability-zones m4520)]
    (.
     bean4519
     setAvailabilityZones
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4569] (clojure.core/str arg4569))
 v4521)))
   (clojure.core/when-let
    [v4521 (:security-groups m4520)]
    (.
     bean4519
     setSecurityGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4570] (clojure.core/str arg4570))
 v4521)))
   (clojure.core/when-let
    [v4521 (:load-balancer-name m4520)]
    (. bean4519 setLoadBalancerName (clojure.core/str v4521)))
   (clojure.core/when-let
    [v4521 (:listeners m4520)]
    (.
     bean4519
     setListeners
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4571] (elasticloadbalancing/listener arg4571))
 v4521)))
   (clojure.core/when-let
    [v4521 (:scheme m4520)]
    (. bean4519 setScheme (clojure.core/str v4521)))
   bean4519))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.SetLoadBalancerPoliciesForBackendServerRequest}
set-load-balancer-policies-for-backend-server-request
  [m4523]
  (clojure.core/let
   [bean4522
    (new
     com.amazonaws.services.elasticloadbalancing.model.SetLoadBalancerPoliciesForBackendServerRequest)]
   (clojure.core/when-let
    [v4524 (:policy-names m4523)]
    (.
     bean4522
     setPolicyNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4572] (clojure.core/str arg4572))
 v4524)))
   (clojure.core/when-let
    [v4524 (:load-balancer-name m4523)]
    (. bean4522 setLoadBalancerName (clojure.core/str v4524)))
   (clojure.core/when-let
    [v4524 (:instance-port m4523)]
    (. bean4522 setInstancePort (clojure.core/int v4524)))
   bean4522))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.DisableAvailabilityZonesForLoadBalancerRequest}
disable-availability-zones-for-load-balancer-request
  [m4526]
  (clojure.core/let
   [bean4525
    (new
     com.amazonaws.services.elasticloadbalancing.model.DisableAvailabilityZonesForLoadBalancerRequest)]
   (clojure.core/when-let
    [v4527 (:availability-zones m4526)]
    (.
     bean4525
     setAvailabilityZones
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4573] (clojure.core/str arg4573))
 v4527)))
   (clojure.core/when-let
    [v4527 (:load-balancer-name m4526)]
    (. bean4525 setLoadBalancerName (clojure.core/str v4527)))
   bean4525))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.DetachLoadBalancerFromSubnetsRequest}
detach-load-balancer-from-subnets-request
  [m4529]
  (clojure.core/let
   [bean4528
    (new
     com.amazonaws.services.elasticloadbalancing.model.DetachLoadBalancerFromSubnetsRequest)]
   (clojure.core/when-let
    [v4530 (:subnets m4529)]
    (.
     bean4528
     setSubnets
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4574] (clojure.core/str arg4574))
 v4530)))
   (clojure.core/when-let
    [v4530 (:load-balancer-name m4529)]
    (. bean4528 setLoadBalancerName (clojure.core/str v4530)))
   bean4528))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.CreateLoadBalancerListenersRequest}
create-load-balancer-listeners-request
  [m4532]
  (clojure.core/let
   [bean4531
    (new
     com.amazonaws.services.elasticloadbalancing.model.CreateLoadBalancerListenersRequest)]
   (clojure.core/when-let
    [v4533 (:load-balancer-name m4532)]
    (. bean4531 setLoadBalancerName (clojure.core/str v4533)))
   (clojure.core/when-let
    [v4533 (:listeners m4532)]
    (.
     bean4531
     setListeners
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4575] (elasticloadbalancing/listener arg4575))
 v4533)))
   bean4531))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.DeleteLoadBalancerListenersRequest}
delete-load-balancer-listeners-request
  [m4535]
  (clojure.core/let
   [bean4534
    (new
     com.amazonaws.services.elasticloadbalancing.model.DeleteLoadBalancerListenersRequest)]
   (clojure.core/when-let
    [v4536 (:load-balancer-name m4535)]
    (. bean4534 setLoadBalancerName (clojure.core/str v4536)))
   (clojure.core/when-let
    [v4536 (:load-balancer-ports m4535)]
    (.
     bean4534
     setLoadBalancerPorts
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4576] (clojure.core/int arg4576))
 v4536)))
   bean4534))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.SetLoadBalancerListenerSSLCertificateRequest}
set-load-balancer-listener-sslcertificate-request
  [m4538]
  (clojure.core/let
   [bean4537
    (new
     com.amazonaws.services.elasticloadbalancing.model.SetLoadBalancerListenerSSLCertificateRequest)]
   (clojure.core/when-let
    [v4539 (:load-balancer-name m4538)]
    (. bean4537 setLoadBalancerName (clojure.core/str v4539)))
   (clojure.core/when-let
    [v4539 (:load-balancer-port m4538)]
    (. bean4537 setLoadBalancerPort (clojure.core/int v4539)))
   (clojure.core/when-let
    [v4539 (:sslcertificate-id m4538)]
    (. bean4537 setSSLCertificateId (clojure.core/str v4539)))
   bean4537))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.RegisterInstancesWithLoadBalancerRequest}
register-instances-with-load-balancer-request
  [m4541]
  (clojure.core/let
   [bean4540
    (new
     com.amazonaws.services.elasticloadbalancing.model.RegisterInstancesWithLoadBalancerRequest)]
   (clojure.core/when-let
    [v4542 (:instances m4541)]
    (.
     bean4540
     setInstances
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4577] (elasticloadbalancing/instance arg4577))
 v4542)))
   (clojure.core/when-let
    [v4542 (:load-balancer-name m4541)]
    (. bean4540 setLoadBalancerName (clojure.core/str v4542)))
   bean4540))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.SetLoadBalancerPoliciesOfListenerRequest}
set-load-balancer-policies-of-listener-request
  [m4544]
  (clojure.core/let
   [bean4543
    (new
     com.amazonaws.services.elasticloadbalancing.model.SetLoadBalancerPoliciesOfListenerRequest)]
   (clojure.core/when-let
    [v4545 (:policy-names m4544)]
    (.
     bean4543
     setPolicyNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4578] (clojure.core/str arg4578))
 v4545)))
   (clojure.core/when-let
    [v4545 (:load-balancer-name m4544)]
    (. bean4543 setLoadBalancerName (clojure.core/str v4545)))
   (clojure.core/when-let
    [v4545 (:load-balancer-port m4544)]
    (. bean4543 setLoadBalancerPort (clojure.core/int v4545)))
   bean4543))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.AttachLoadBalancerToSubnetsRequest}
attach-load-balancer-to-subnets-request
  [m4547]
  (clojure.core/let
   [bean4546
    (new
     com.amazonaws.services.elasticloadbalancing.model.AttachLoadBalancerToSubnetsRequest)]
   (clojure.core/when-let
    [v4548 (:subnets m4547)]
    (.
     bean4546
     setSubnets
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4579] (clojure.core/str arg4579))
 v4548)))
   (clojure.core/when-let
    [v4548 (:load-balancer-name m4547)]
    (. bean4546 setLoadBalancerName (clojure.core/str v4548)))
   bean4546))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.ModifyLoadBalancerAttributesRequest}
modify-load-balancer-attributes-request
  [m4550]
  (clojure.core/let
   [bean4549
    (new
     com.amazonaws.services.elasticloadbalancing.model.ModifyLoadBalancerAttributesRequest)]
   (clojure.core/when-let
    [v4551 (:load-balancer-name m4550)]
    (. bean4549 setLoadBalancerName (clojure.core/str v4551)))
   (clojure.core/when-let
    [v4551 (:load-balancer-attributes m4550)]
    (.
     bean4549
     setLoadBalancerAttributes
     (elasticloadbalancing/load-balancer-attributes v4551)))
   bean4549))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.DescribeLoadBalancersRequest}
describe-load-balancers-request
  [m4553]
  (clojure.core/let
   [bean4552
    (new
     com.amazonaws.services.elasticloadbalancing.model.DescribeLoadBalancersRequest)]
   (clojure.core/when-let
    [v4554 (:marker m4553)]
    (. bean4552 setMarker (clojure.core/str v4554)))
   (clojure.core/when-let
    [v4554 (:load-balancer-names m4553)]
    (.
     bean4552
     setLoadBalancerNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4580] (clojure.core/str arg4580))
 v4554)))
   bean4552))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.DescribeLoadBalancerAttributesRequest}
describe-load-balancer-attributes-request
  [m4556]
  (clojure.core/let
   [bean4555
    (new
     com.amazonaws.services.elasticloadbalancing.model.DescribeLoadBalancerAttributesRequest)]
   (clojure.core/when-let
    [v4557 (:load-balancer-name m4556)]
    (. bean4555 setLoadBalancerName (clojure.core/str v4557)))
   bean4555))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.CreateAppCookieStickinessPolicyRequest}
create-app-cookie-stickiness-policy-request
  [m4559]
  (clojure.core/let
   [bean4558
    (new
     com.amazonaws.services.elasticloadbalancing.model.CreateAppCookieStickinessPolicyRequest)]
   (clojure.core/when-let
    [v4560 (:policy-name m4559)]
    (. bean4558 setPolicyName (clojure.core/str v4560)))
   (clojure.core/when-let
    [v4560 (:load-balancer-name m4559)]
    (. bean4558 setLoadBalancerName (clojure.core/str v4560)))
   (clojure.core/when-let
    [v4560 (:cookie-name m4559)]
    (. bean4558 setCookieName (clojure.core/str v4560)))
   bean4558))
 (clojure.core/defmulti
  elasticloadbalancing
  (clojure.core/fn
   elasticloadbalancing
   [m__1683__auto__]
   (:fn m__1683__auto__)))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :deregister-instances-from-load-balancer
   [m4581]
   (clojure.core/let
    [credentials4582 (:credentials m4581) args4583 (:args m4581)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4584
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4582)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4584
       deregisterInstancesFromLoadBalancer
       (elasticloadbalancing/deregister-instances-from-load-balancer-request
        (clojure.core/nth args4583 0)))))))
  (clojure.core/defn
   deregister-instances-from-load-balancer-map
   {:arglists (quote
               [[credentials
                 {:keys [load-balancer-name
                         instances
                         general-progress-listener]}]]),
    :doc "Generate map for deregisterInstancesFromLoadBalancer"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :deregister-instances-from-load-balancer,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   deregister-instances-from-load-balancer
   {:arglists (quote
               [[credentials
                 {:keys [load-balancer-name
                         instances
                         general-progress-listener]}]]),
    :doc "Call deregisterInstancesFromLoadBalancer"}
   [credentials4586 & args4587]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4588
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4586)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4588
      deregisterInstancesFromLoadBalancer
      (elasticloadbalancing/deregister-instances-from-load-balancer-request
       (clojure.core/nth args4587 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :enable-availability-zones-for-load-balancer
   [m4589]
   (clojure.core/let
    [credentials4590 (:credentials m4589) args4591 (:args m4589)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4592
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4590)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4592
       enableAvailabilityZonesForLoadBalancer
       (elasticloadbalancing/enable-availability-zones-for-load-balancer-request
        (clojure.core/nth args4591 0)))))))
  (clojure.core/defn
   enable-availability-zones-for-load-balancer-map
   {:arglists (quote
               [[credentials
                 {:keys [load-balancer-name
                         general-progress-listener
                         availability-zones]}]]),
    :doc "Generate map for enableAvailabilityZonesForLoadBalancer"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :enable-availability-zones-for-load-balancer,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   enable-availability-zones-for-load-balancer
   {:arglists (quote
               [[credentials
                 {:keys [load-balancer-name
                         general-progress-listener
                         availability-zones]}]]),
    :doc "Call enableAvailabilityZonesForLoadBalancer"}
   [credentials4594 & args4595]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4596
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4594)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4596
      enableAvailabilityZonesForLoadBalancer
      (elasticloadbalancing/enable-availability-zones-for-load-balancer-request
       (clojure.core/nth args4595 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :apply-security-groups-to-load-balancer
   [m4597]
   (clojure.core/let
    [credentials4598 (:credentials m4597) args4599 (:args m4597)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4600
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4598)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4600
       applySecurityGroupsToLoadBalancer
       (elasticloadbalancing/apply-security-groups-to-load-balancer-request
        (clojure.core/nth args4599 0)))))))
  (clojure.core/defn
   apply-security-groups-to-load-balancer-map
   {:arglists (quote
               [[credentials
                 {:keys [security-groups
                         load-balancer-name
                         general-progress-listener]}]]),
    :doc "Generate map for applySecurityGroupsToLoadBalancer"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :apply-security-groups-to-load-balancer,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   apply-security-groups-to-load-balancer
   {:arglists (quote
               [[credentials
                 {:keys [security-groups
                         load-balancer-name
                         general-progress-listener]}]]),
    :doc "Call applySecurityGroupsToLoadBalancer"}
   [credentials4602 & args4603]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4604
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4602)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4604
      applySecurityGroupsToLoadBalancer
      (elasticloadbalancing/apply-security-groups-to-load-balancer-request
       (clojure.core/nth args4603 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :create-lbcookie-stickiness-policy
   [m4605]
   (clojure.core/let
    [credentials4606 (:credentials m4605) args4607 (:args m4605)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4608
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4606)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4608
       createLBCookieStickinessPolicy
       (elasticloadbalancing/create-lbcookie-stickiness-policy-request
        (clojure.core/nth args4607 0)))))))
  (clojure.core/defn
   create-lbcookie-stickiness-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [policy-name
                         load-balancer-name
                         general-progress-listener
                         cookie-expiration-period]}]]),
    :doc "Generate map for createLBCookieStickinessPolicy"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :create-lbcookie-stickiness-policy,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-lbcookie-stickiness-policy
   {:arglists (quote
               [[credentials
                 {:keys [policy-name
                         load-balancer-name
                         general-progress-listener
                         cookie-expiration-period]}]]),
    :doc "Call createLBCookieStickinessPolicy"}
   [credentials4610 & args4611]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4612
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4610)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4612
      createLBCookieStickinessPolicy
      (elasticloadbalancing/create-lbcookie-stickiness-policy-request
       (clojure.core/nth args4611 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :describe-load-balancer-policies
   [m4613]
   (clojure.core/let
    [credentials4614 (:credentials m4613) args4615 (:args m4613)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4616
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4614)]
     (clojure.core/case
      (clojure.core/count args4615)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4616
        describeLoadBalancerPolicies
        (elasticloadbalancing/describe-load-balancer-policies-request
         (clojure.core/nth args4615 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4616
        describeLoadBalancerPolicies))))))
  (clojure.core/defn
   describe-load-balancer-policies-map
   {:arglists (quote
               [[credentials
                 {:keys [policy-names
                         load-balancer-name
                         general-progress-listener]}]
                [credentials]]),
    :doc "Generate map for describeLoadBalancerPolicies, describeLoadBalancerPolicies"}
   ([credentials__1651__auto__]
    {:args [],
     :client :elasticloadbalancing,
     :fn :describe-load-balancer-policies,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :describe-load-balancer-policies,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-load-balancer-policies
   {:arglists (quote
               [[credentials
                 {:keys [policy-names
                         load-balancer-name
                         general-progress-listener]}]
                [credentials]]),
    :doc "Call describeLoadBalancerPolicies, describeLoadBalancerPolicies"}
   [credentials4618 & args4619]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4620
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4618)]
    (clojure.core/case
     (clojure.core/count args4619)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4620
       describeLoadBalancerPolicies
       (elasticloadbalancing/describe-load-balancer-policies-request
        (clojure.core/nth args4619 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4620
       describeLoadBalancerPolicies))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :delete-load-balancer
   [m4621]
   (clojure.core/let
    [credentials4622 (:credentials m4621) args4623 (:args m4621)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4624
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4622)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4624
       deleteLoadBalancer
       (elasticloadbalancing/delete-load-balancer-request
        (clojure.core/nth args4623 0)))))))
  (clojure.core/defn
   delete-load-balancer-map
   {:arglists (quote
               [[credentials
                 {:keys [load-balancer-name general-progress-listener]}]]),
    :doc "Generate map for deleteLoadBalancer"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :delete-load-balancer,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-load-balancer
   {:arglists (quote
               [[credentials
                 {:keys [load-balancer-name general-progress-listener]}]]),
    :doc "Call deleteLoadBalancer"}
   [credentials4626 & args4627]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4628
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4626)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4628
      deleteLoadBalancer
      (elasticloadbalancing/delete-load-balancer-request
       (clojure.core/nth args4627 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :describe-load-balancer-policy-types
   [m4629]
   (clojure.core/let
    [credentials4630 (:credentials m4629) args4631 (:args m4629)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4632
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4630)]
     (clojure.core/case
      (clojure.core/count args4631)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4632
        describeLoadBalancerPolicyTypes))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4632
        describeLoadBalancerPolicyTypes
        (elasticloadbalancing/describe-load-balancer-policy-types-request
         (clojure.core/nth args4631 0))))))))
  (clojure.core/defn
   describe-load-balancer-policy-types-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [policy-type-names general-progress-listener]}]]),
    :doc "Generate map for describeLoadBalancerPolicyTypes, describeLoadBalancerPolicyTypes"}
   ([credentials__1651__auto__]
    {:args [],
     :client :elasticloadbalancing,
     :fn :describe-load-balancer-policy-types,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :describe-load-balancer-policy-types,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-load-balancer-policy-types
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [policy-type-names general-progress-listener]}]]),
    :doc "Call describeLoadBalancerPolicyTypes, describeLoadBalancerPolicyTypes"}
   [credentials4634 & args4635]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4636
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4634)]
    (clojure.core/case
     (clojure.core/count args4635)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4636
       describeLoadBalancerPolicyTypes))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4636
       describeLoadBalancerPolicyTypes
       (elasticloadbalancing/describe-load-balancer-policy-types-request
        (clojure.core/nth args4635 0))))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :delete-load-balancer-policy
   [m4637]
   (clojure.core/let
    [credentials4638 (:credentials m4637) args4639 (:args m4637)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4640
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4638)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4640
       deleteLoadBalancerPolicy
       (elasticloadbalancing/delete-load-balancer-policy-request
        (clojure.core/nth args4639 0)))))))
  (clojure.core/defn
   delete-load-balancer-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [policy-name
                         load-balancer-name
                         general-progress-listener]}]]),
    :doc "Generate map for deleteLoadBalancerPolicy"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :delete-load-balancer-policy,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-load-balancer-policy
   {:arglists (quote
               [[credentials
                 {:keys [policy-name
                         load-balancer-name
                         general-progress-listener]}]]),
    :doc "Call deleteLoadBalancerPolicy"}
   [credentials4642 & args4643]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4644
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4642)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4644
      deleteLoadBalancerPolicy
      (elasticloadbalancing/delete-load-balancer-policy-request
       (clojure.core/nth args4643 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :create-load-balancer-policy
   [m4645]
   (clojure.core/let
    [credentials4646 (:credentials m4645) args4647 (:args m4645)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4648
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4646)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4648
       createLoadBalancerPolicy
       (elasticloadbalancing/create-load-balancer-policy-request
        (clojure.core/nth args4647 0)))))))
  (clojure.core/defn
   create-load-balancer-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [policy-type-name
                         policy-name
                         policy-attributes
                         load-balancer-name
                         general-progress-listener]}]]),
    :doc "Generate map for createLoadBalancerPolicy"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :create-load-balancer-policy,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-load-balancer-policy
   {:arglists (quote
               [[credentials
                 {:keys [policy-type-name
                         policy-name
                         policy-attributes
                         load-balancer-name
                         general-progress-listener]}]]),
    :doc "Call createLoadBalancerPolicy"}
   [credentials4650 & args4651]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4652
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4650)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4652
      createLoadBalancerPolicy
      (elasticloadbalancing/create-load-balancer-policy-request
       (clojure.core/nth args4651 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :configure-health-check
   [m4653]
   (clojure.core/let
    [credentials4654 (:credentials m4653) args4655 (:args m4653)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4656
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4654)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4656
       configureHealthCheck
       (elasticloadbalancing/configure-health-check-request
        (clojure.core/nth args4655 0)))))))
  (clojure.core/defn
   configure-health-check-map
   {:arglists (quote
               [[credentials
                 {:keys [load-balancer-name
                         health-check
                         general-progress-listener]}]]),
    :doc "Generate map for configureHealthCheck"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :configure-health-check,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   configure-health-check
   {:arglists (quote
               [[credentials
                 {:keys [load-balancer-name
                         health-check
                         general-progress-listener]}]]),
    :doc "Call configureHealthCheck"}
   [credentials4658 & args4659]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4660
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4658)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4660
      configureHealthCheck
      (elasticloadbalancing/configure-health-check-request
       (clojure.core/nth args4659 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :describe-instance-health
   [m4661]
   (clojure.core/let
    [credentials4662 (:credentials m4661) args4663 (:args m4661)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4664
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4662)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4664
       describeInstanceHealth
       (elasticloadbalancing/describe-instance-health-request
        (clojure.core/nth args4663 0)))))))
  (clojure.core/defn
   describe-instance-health-map
   {:arglists (quote
               [[credentials
                 {:keys [load-balancer-name
                         instances
                         general-progress-listener]}]]),
    :doc "Generate map for describeInstanceHealth"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :describe-instance-health,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-instance-health
   {:arglists (quote
               [[credentials
                 {:keys [load-balancer-name
                         instances
                         general-progress-listener]}]]),
    :doc "Call describeInstanceHealth"}
   [credentials4666 & args4667]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4668
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4666)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4668
      describeInstanceHealth
      (elasticloadbalancing/describe-instance-health-request
       (clojure.core/nth args4667 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :create-load-balancer
   [m4669]
   (clojure.core/let
    [credentials4670 (:credentials m4669) args4671 (:args m4669)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4672
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4670)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4672
       createLoadBalancer
       (elasticloadbalancing/create-load-balancer-request
        (clojure.core/nth args4671 0)))))))
  (clojure.core/defn
   create-load-balancer-map
   {:arglists (quote
               [[credentials
                 {:keys [scheme
                         general-progress-listener
                         subnets
                         listeners
                         security-groups
                         availability-zones
                         load-balancer-name]}]]),
    :doc "Generate map for createLoadBalancer"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :create-load-balancer,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-load-balancer
   {:arglists (quote
               [[credentials
                 {:keys [scheme
                         general-progress-listener
                         subnets
                         listeners
                         security-groups
                         availability-zones
                         load-balancer-name]}]]),
    :doc "Call createLoadBalancer"}
   [credentials4674 & args4675]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4676
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4674)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4676
      createLoadBalancer
      (elasticloadbalancing/create-load-balancer-request
       (clojure.core/nth args4675 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :set-load-balancer-policies-for-backend-server
   [m4677]
   (clojure.core/let
    [credentials4678 (:credentials m4677) args4679 (:args m4677)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4680
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4678)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4680
       setLoadBalancerPoliciesForBackendServer
       (elasticloadbalancing/set-load-balancer-policies-for-backend-server-request
        (clojure.core/nth args4679 0)))))))
  (clojure.core/defn
   set-load-balancer-policies-for-backend-server-map
   {:arglists (quote
               [[credentials
                 {:keys [policy-names
                         load-balancer-name
                         instance-port
                         general-progress-listener]}]]),
    :doc "Generate map for setLoadBalancerPoliciesForBackendServer"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :set-load-balancer-policies-for-backend-server,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   set-load-balancer-policies-for-backend-server
   {:arglists (quote
               [[credentials
                 {:keys [policy-names
                         load-balancer-name
                         instance-port
                         general-progress-listener]}]]),
    :doc "Call setLoadBalancerPoliciesForBackendServer"}
   [credentials4682 & args4683]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4684
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4682)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4684
      setLoadBalancerPoliciesForBackendServer
      (elasticloadbalancing/set-load-balancer-policies-for-backend-server-request
       (clojure.core/nth args4683 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :disable-availability-zones-for-load-balancer
   [m4685]
   (clojure.core/let
    [credentials4686 (:credentials m4685) args4687 (:args m4685)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4688
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4686)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4688
       disableAvailabilityZonesForLoadBalancer
       (elasticloadbalancing/disable-availability-zones-for-load-balancer-request
        (clojure.core/nth args4687 0)))))))
  (clojure.core/defn
   disable-availability-zones-for-load-balancer-map
   {:arglists (quote
               [[credentials
                 {:keys [load-balancer-name
                         general-progress-listener
                         availability-zones]}]]),
    :doc "Generate map for disableAvailabilityZonesForLoadBalancer"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :disable-availability-zones-for-load-balancer,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   disable-availability-zones-for-load-balancer
   {:arglists (quote
               [[credentials
                 {:keys [load-balancer-name
                         general-progress-listener
                         availability-zones]}]]),
    :doc "Call disableAvailabilityZonesForLoadBalancer"}
   [credentials4690 & args4691]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4692
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4690)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4692
      disableAvailabilityZonesForLoadBalancer
      (elasticloadbalancing/disable-availability-zones-for-load-balancer-request
       (clojure.core/nth args4691 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :detach-load-balancer-from-subnets
   [m4693]
   (clojure.core/let
    [credentials4694 (:credentials m4693) args4695 (:args m4693)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4696
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4694)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4696
       detachLoadBalancerFromSubnets
       (elasticloadbalancing/detach-load-balancer-from-subnets-request
        (clojure.core/nth args4695 0)))))))
  (clojure.core/defn
   detach-load-balancer-from-subnets-map
   {:arglists (quote
               [[credentials
                 {:keys [subnets
                         load-balancer-name
                         general-progress-listener]}]]),
    :doc "Generate map for detachLoadBalancerFromSubnets"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :detach-load-balancer-from-subnets,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   detach-load-balancer-from-subnets
   {:arglists (quote
               [[credentials
                 {:keys [subnets
                         load-balancer-name
                         general-progress-listener]}]]),
    :doc "Call detachLoadBalancerFromSubnets"}
   [credentials4698 & args4699]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4700
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4698)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4700
      detachLoadBalancerFromSubnets
      (elasticloadbalancing/detach-load-balancer-from-subnets-request
       (clojure.core/nth args4699 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :create-load-balancer-listeners
   [m4701]
   (clojure.core/let
    [credentials4702 (:credentials m4701) args4703 (:args m4701)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4704
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4702)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4704
       createLoadBalancerListeners
       (elasticloadbalancing/create-load-balancer-listeners-request
        (clojure.core/nth args4703 0)))))))
  (clojure.core/defn
   create-load-balancer-listeners-map
   {:arglists (quote
               [[credentials
                 {:keys [load-balancer-name
                         listeners
                         general-progress-listener]}]]),
    :doc "Generate map for createLoadBalancerListeners"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :create-load-balancer-listeners,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-load-balancer-listeners
   {:arglists (quote
               [[credentials
                 {:keys [load-balancer-name
                         listeners
                         general-progress-listener]}]]),
    :doc "Call createLoadBalancerListeners"}
   [credentials4706 & args4707]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4708
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4706)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4708
      createLoadBalancerListeners
      (elasticloadbalancing/create-load-balancer-listeners-request
       (clojure.core/nth args4707 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :delete-load-balancer-listeners
   [m4709]
   (clojure.core/let
    [credentials4710 (:credentials m4709) args4711 (:args m4709)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4712
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4710)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4712
       deleteLoadBalancerListeners
       (elasticloadbalancing/delete-load-balancer-listeners-request
        (clojure.core/nth args4711 0)))))))
  (clojure.core/defn
   delete-load-balancer-listeners-map
   {:arglists (quote
               [[credentials
                 {:keys [load-balancer-ports
                         load-balancer-name
                         general-progress-listener]}]]),
    :doc "Generate map for deleteLoadBalancerListeners"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :delete-load-balancer-listeners,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-load-balancer-listeners
   {:arglists (quote
               [[credentials
                 {:keys [load-balancer-ports
                         load-balancer-name
                         general-progress-listener]}]]),
    :doc "Call deleteLoadBalancerListeners"}
   [credentials4714 & args4715]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4716
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4714)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4716
      deleteLoadBalancerListeners
      (elasticloadbalancing/delete-load-balancer-listeners-request
       (clojure.core/nth args4715 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :set-load-balancer-listener-sslcertificate
   [m4717]
   (clojure.core/let
    [credentials4718 (:credentials m4717) args4719 (:args m4717)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4720
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4718)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4720
       setLoadBalancerListenerSSLCertificate
       (elasticloadbalancing/set-load-balancer-listener-sslcertificate-request
        (clojure.core/nth args4719 0)))))))
  (clojure.core/defn
   set-load-balancer-listener-sslcertificate-map
   {:arglists (quote
               [[credentials
                 {:keys [load-balancer-port
                         load-balancer-name
                         general-progress-listener
                         sslcertificate-id]}]]),
    :doc "Generate map for setLoadBalancerListenerSSLCertificate"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :set-load-balancer-listener-sslcertificate,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   set-load-balancer-listener-sslcertificate
   {:arglists (quote
               [[credentials
                 {:keys [load-balancer-port
                         load-balancer-name
                         general-progress-listener
                         sslcertificate-id]}]]),
    :doc "Call setLoadBalancerListenerSSLCertificate"}
   [credentials4722 & args4723]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4724
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4722)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4724
      setLoadBalancerListenerSSLCertificate
      (elasticloadbalancing/set-load-balancer-listener-sslcertificate-request
       (clojure.core/nth args4723 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :register-instances-with-load-balancer
   [m4725]
   (clojure.core/let
    [credentials4726 (:credentials m4725) args4727 (:args m4725)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4728
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4726)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4728
       registerInstancesWithLoadBalancer
       (elasticloadbalancing/register-instances-with-load-balancer-request
        (clojure.core/nth args4727 0)))))))
  (clojure.core/defn
   register-instances-with-load-balancer-map
   {:arglists (quote
               [[credentials
                 {:keys [load-balancer-name
                         instances
                         general-progress-listener]}]]),
    :doc "Generate map for registerInstancesWithLoadBalancer"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :register-instances-with-load-balancer,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   register-instances-with-load-balancer
   {:arglists (quote
               [[credentials
                 {:keys [load-balancer-name
                         instances
                         general-progress-listener]}]]),
    :doc "Call registerInstancesWithLoadBalancer"}
   [credentials4730 & args4731]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4732
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4730)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4732
      registerInstancesWithLoadBalancer
      (elasticloadbalancing/register-instances-with-load-balancer-request
       (clojure.core/nth args4731 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :set-load-balancer-policies-of-listener
   [m4733]
   (clojure.core/let
    [credentials4734 (:credentials m4733) args4735 (:args m4733)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4736
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4734)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4736
       setLoadBalancerPoliciesOfListener
       (elasticloadbalancing/set-load-balancer-policies-of-listener-request
        (clojure.core/nth args4735 0)))))))
  (clojure.core/defn
   set-load-balancer-policies-of-listener-map
   {:arglists (quote
               [[credentials
                 {:keys [policy-names
                         load-balancer-port
                         load-balancer-name
                         general-progress-listener]}]]),
    :doc "Generate map for setLoadBalancerPoliciesOfListener"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :set-load-balancer-policies-of-listener,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   set-load-balancer-policies-of-listener
   {:arglists (quote
               [[credentials
                 {:keys [policy-names
                         load-balancer-port
                         load-balancer-name
                         general-progress-listener]}]]),
    :doc "Call setLoadBalancerPoliciesOfListener"}
   [credentials4738 & args4739]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4740
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4738)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4740
      setLoadBalancerPoliciesOfListener
      (elasticloadbalancing/set-load-balancer-policies-of-listener-request
       (clojure.core/nth args4739 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :attach-load-balancer-to-subnets
   [m4741]
   (clojure.core/let
    [credentials4742 (:credentials m4741) args4743 (:args m4741)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4744
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4742)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4744
       attachLoadBalancerToSubnets
       (elasticloadbalancing/attach-load-balancer-to-subnets-request
        (clojure.core/nth args4743 0)))))))
  (clojure.core/defn
   attach-load-balancer-to-subnets-map
   {:arglists (quote
               [[credentials
                 {:keys [subnets
                         load-balancer-name
                         general-progress-listener]}]]),
    :doc "Generate map for attachLoadBalancerToSubnets"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :attach-load-balancer-to-subnets,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   attach-load-balancer-to-subnets
   {:arglists (quote
               [[credentials
                 {:keys [subnets
                         load-balancer-name
                         general-progress-listener]}]]),
    :doc "Call attachLoadBalancerToSubnets"}
   [credentials4746 & args4747]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4748
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4746)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4748
      attachLoadBalancerToSubnets
      (elasticloadbalancing/attach-load-balancer-to-subnets-request
       (clojure.core/nth args4747 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :modify-load-balancer-attributes
   [m4749]
   (clojure.core/let
    [credentials4750 (:credentials m4749) args4751 (:args m4749)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4752
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4750)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4752
       modifyLoadBalancerAttributes
       (elasticloadbalancing/modify-load-balancer-attributes-request
        (clojure.core/nth args4751 0)))))))
  (clojure.core/defn
   modify-load-balancer-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [load-balancer-name
                         load-balancer-attributes
                         general-progress-listener]}]]),
    :doc "Generate map for modifyLoadBalancerAttributes"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :modify-load-balancer-attributes,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   modify-load-balancer-attributes
   {:arglists (quote
               [[credentials
                 {:keys [load-balancer-name
                         load-balancer-attributes
                         general-progress-listener]}]]),
    :doc "Call modifyLoadBalancerAttributes"}
   [credentials4754 & args4755]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4756
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4754)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4756
      modifyLoadBalancerAttributes
      (elasticloadbalancing/modify-load-balancer-attributes-request
       (clojure.core/nth args4755 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :describe-load-balancers
   [m4757]
   (clojure.core/let
    [credentials4758 (:credentials m4757) args4759 (:args m4757)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4760
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4758)]
     (clojure.core/case
      (clojure.core/count args4759)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4760
        describeLoadBalancers
        (elasticloadbalancing/describe-load-balancers-request
         (clojure.core/nth args4759 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4760
        describeLoadBalancers))))))
  (clojure.core/defn
   describe-load-balancers-map
   {:arglists (quote
               [[credentials
                 {:keys [marker
                         load-balancer-names
                         general-progress-listener]}]
                [credentials]]),
    :doc "Generate map for describeLoadBalancers, describeLoadBalancers"}
   ([credentials__1651__auto__]
    {:args [],
     :client :elasticloadbalancing,
     :fn :describe-load-balancers,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :describe-load-balancers,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-load-balancers
   {:arglists (quote
               [[credentials
                 {:keys [marker
                         load-balancer-names
                         general-progress-listener]}]
                [credentials]]),
    :doc "Call describeLoadBalancers, describeLoadBalancers"}
   [credentials4762 & args4763]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4764
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4762)]
    (clojure.core/case
     (clojure.core/count args4763)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4764
       describeLoadBalancers
       (elasticloadbalancing/describe-load-balancers-request
        (clojure.core/nth args4763 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4764
       describeLoadBalancers))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :describe-load-balancer-attributes
   [m4765]
   (clojure.core/let
    [credentials4766 (:credentials m4765) args4767 (:args m4765)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4768
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4766)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4768
       describeLoadBalancerAttributes
       (elasticloadbalancing/describe-load-balancer-attributes-request
        (clojure.core/nth args4767 0)))))))
  (clojure.core/defn
   describe-load-balancer-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [load-balancer-name general-progress-listener]}]]),
    :doc "Generate map for describeLoadBalancerAttributes"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :describe-load-balancer-attributes,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-load-balancer-attributes
   {:arglists (quote
               [[credentials
                 {:keys [load-balancer-name general-progress-listener]}]]),
    :doc "Call describeLoadBalancerAttributes"}
   [credentials4770 & args4771]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4772
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4770)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4772
      describeLoadBalancerAttributes
      (elasticloadbalancing/describe-load-balancer-attributes-request
       (clojure.core/nth args4771 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :create-app-cookie-stickiness-policy
   [m4773]
   (clojure.core/let
    [credentials4774 (:credentials m4773) args4775 (:args m4773)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4776
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4774)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4776
       createAppCookieStickinessPolicy
       (elasticloadbalancing/create-app-cookie-stickiness-policy-request
        (clojure.core/nth args4775 0)))))))
  (clojure.core/defn
   create-app-cookie-stickiness-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [policy-name
                         load-balancer-name
                         general-progress-listener
                         cookie-name]}]]),
    :doc "Generate map for createAppCookieStickinessPolicy"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticloadbalancing,
     :fn :create-app-cookie-stickiness-policy,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-app-cookie-stickiness-policy
   {:arglists (quote
               [[credentials
                 {:keys [policy-name
                         load-balancer-name
                         general-progress-listener
                         cookie-name]}]]),
    :doc "Call createAppCookieStickinessPolicy"}
   [credentials4778 & args4779]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4780
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4778)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4780
      createAppCookieStickinessPolicy
      (elasticloadbalancing/create-app-cookie-stickiness-policy-request
       (clojure.core/nth args4779 0))))))))
