(ns
 com.palletops.awaze.glacier
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.glacier :as glacier]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :glacier
  [___1600__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1601__auto__]
  (new
   com.amazonaws.services.glacier.AmazonGlacierClient
   credentials__1601__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.InventoryRetrievalJobInput}
inventory-retrieval-job-input
  [m2308]
  (clojure.core/let
   [bean2307
    (new
     com.amazonaws.services.glacier.model.InventoryRetrievalJobInput)]
   (clojure.core/when-let
    [v2309 (:marker m2308)]
    (. bean2307 setMarker (clojure.core/str v2309)))
   (clojure.core/when-let
    [v2309 (:start-date m2308)]
    (. bean2307 setStartDate (clojure.core/str v2309)))
   (clojure.core/when-let
    [v2309 (:end-date m2308)]
    (. bean2307 setEndDate (clojure.core/str v2309)))
   (clojure.core/when-let
    [v2309 (:limit m2308)]
    (. bean2307 setLimit (clojure.core/str v2309)))
   bean2307))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.JobParameters}
job-parameters
  [m2311]
  (clojure.core/let
   [bean2310 (new com.amazonaws.services.glacier.model.JobParameters)]
   (clojure.core/when-let
    [v2312 (:archive-id m2311)]
    (. bean2310 setArchiveId (clojure.core/str v2312)))
   (clojure.core/when-let
    [v2312 (:snstopic m2311)]
    (. bean2310 setSNSTopic (clojure.core/str v2312)))
   (clojure.core/when-let
    [v2312 (:retrieval-byte-range m2311)]
    (. bean2310 setRetrievalByteRange (clojure.core/str v2312)))
   (clojure.core/when-let
    [v2312 (:inventory-retrieval-parameters m2311)]
    (.
     bean2310
     setInventoryRetrievalParameters
     (glacier/inventory-retrieval-job-input v2312)))
   (clojure.core/when-let
    [v2312 (:description m2311)]
    (. bean2310 setDescription (clojure.core/str v2312)))
   (clojure.core/when-let
    [v2312 (:type m2311)]
    (. bean2310 setType (clojure.core/str v2312)))
   (clojure.core/when-let
    [v2312 (:format m2311)]
    (. bean2310 setFormat (clojure.core/str v2312)))
   bean2310))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.VaultNotificationConfig}
vault-notification-config
  [m2314]
  (clojure.core/let
   [bean2313
    (new com.amazonaws.services.glacier.model.VaultNotificationConfig)]
   (clojure.core/when-let
    [v2315 (:snstopic m2314)]
    (. bean2313 setSNSTopic (clojure.core/str v2315)))
   (clojure.core/when-let
    [v2315 (:events m2314)]
    (.
     bean2313
     setEvents
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2373] (clojure.core/str arg2373))
 v2315)))
   bean2313))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.ListJobsRequest}
list-jobs-request
  [m2317]
  (clojure.core/let
   [bean2316
    (new com.amazonaws.services.glacier.model.ListJobsRequest)]
   (clojure.core/when-let
    [v2318 (:marker m2317)]
    (. bean2316 setMarker (clojure.core/str v2318)))
   (clojure.core/when-let
    [v2318 (:account-id m2317)]
    (. bean2316 setAccountId (clojure.core/str v2318)))
   (clojure.core/when-let
    [v2318 (:vault-name m2317)]
    (. bean2316 setVaultName (clojure.core/str v2318)))
   (clojure.core/when-let
    [v2318 (:statuscode m2317)]
    (. bean2316 setStatuscode (clojure.core/str v2318)))
   (clojure.core/when-let
    [v2318 (:completed m2317)]
    (. bean2316 setCompleted (clojure.core/str v2318)))
   (clojure.core/when-let
    [v2318 (:limit m2317)]
    (. bean2316 setLimit (clojure.core/str v2318)))
   bean2316))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.GetVaultNotificationsRequest}
get-vault-notifications-request
  [m2320]
  (clojure.core/let
   [bean2319
    (new
     com.amazonaws.services.glacier.model.GetVaultNotificationsRequest)]
   (clojure.core/when-let
    [v2321 (:account-id m2320)]
    (. bean2319 setAccountId (clojure.core/str v2321)))
   (clojure.core/when-let
    [v2321 (:vault-name m2320)]
    (. bean2319 setVaultName (clojure.core/str v2321)))
   bean2319))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.UploadMultipartPartRequest}
upload-multipart-part-request
  [m2323]
  (clojure.core/let
   [bean2322
    (new
     com.amazonaws.services.glacier.model.UploadMultipartPartRequest)]
   (clojure.core/when-let
    [v2324 (:range m2323)]
    (. bean2322 setRange (clojure.core/str v2324)))
   (clojure.core/when-let
    [v2324 (:account-id m2323)]
    (. bean2322 setAccountId (clojure.core/str v2324)))
   (clojure.core/when-let
    [v2324 (:vault-name m2323)]
    (. bean2322 setVaultName (clojure.core/str v2324)))
   (clojure.core/when-let
    [v2324 (:upload-id m2323)]
    (. bean2322 setUploadId (clojure.core/str v2324)))
   (clojure.core/when-let
    [v2324 (:checksum m2323)]
    (. bean2322 setChecksum (clojure.core/str v2324)))
   (clojure.core/when-let
    [v2324 (:body m2323)]
    (. bean2322 setBody (clojure.java.io/input-stream v2324)))
   bean2322))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.ListVaultsRequest}
list-vaults-request
  [m2326]
  (clojure.core/let
   [bean2325
    (new com.amazonaws.services.glacier.model.ListVaultsRequest)]
   (clojure.core/when-let
    [v2327 (:marker m2326)]
    (. bean2325 setMarker (clojure.core/str v2327)))
   (clojure.core/when-let
    [v2327 (:account-id m2326)]
    (. bean2325 setAccountId (clojure.core/str v2327)))
   (clojure.core/when-let
    [v2327 (:limit m2326)]
    (. bean2325 setLimit (clojure.core/str v2327)))
   bean2325))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.DeleteVaultRequest}
delete-vault-request
  [m2329]
  (clojure.core/let
   [bean2328
    (new com.amazonaws.services.glacier.model.DeleteVaultRequest)]
   (clojure.core/when-let
    [v2330 (:account-id m2329)]
    (. bean2328 setAccountId (clojure.core/str v2330)))
   (clojure.core/when-let
    [v2330 (:vault-name m2329)]
    (. bean2328 setVaultName (clojure.core/str v2330)))
   bean2328))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.InitiateJobRequest}
initiate-job-request
  [m2332]
  (clojure.core/let
   [bean2331
    (new com.amazonaws.services.glacier.model.InitiateJobRequest)]
   (clojure.core/when-let
    [v2333 (:job-parameters m2332)]
    (. bean2331 setJobParameters (glacier/job-parameters v2333)))
   (clojure.core/when-let
    [v2333 (:account-id m2332)]
    (. bean2331 setAccountId (clojure.core/str v2333)))
   (clojure.core/when-let
    [v2333 (:vault-name m2332)]
    (. bean2331 setVaultName (clojure.core/str v2333)))
   bean2331))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.DescribeVaultRequest}
describe-vault-request
  [m2335]
  (clojure.core/let
   [bean2334
    (new com.amazonaws.services.glacier.model.DescribeVaultRequest)]
   (clojure.core/when-let
    [v2336 (:account-id m2335)]
    (. bean2334 setAccountId (clojure.core/str v2336)))
   (clojure.core/when-let
    [v2336 (:vault-name m2335)]
    (. bean2334 setVaultName (clojure.core/str v2336)))
   bean2334))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.AbortMultipartUploadRequest}
abort-multipart-upload-request
  [m2338]
  (clojure.core/let
   [bean2337
    (new
     com.amazonaws.services.glacier.model.AbortMultipartUploadRequest)]
   (clojure.core/when-let
    [v2339 (:account-id m2338)]
    (. bean2337 setAccountId (clojure.core/str v2339)))
   (clojure.core/when-let
    [v2339 (:vault-name m2338)]
    (. bean2337 setVaultName (clojure.core/str v2339)))
   (clojure.core/when-let
    [v2339 (:upload-id m2338)]
    (. bean2337 setUploadId (clojure.core/str v2339)))
   bean2337))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.DeleteVaultNotificationsRequest}
delete-vault-notifications-request
  [m2341]
  (clojure.core/let
   [bean2340
    (new
     com.amazonaws.services.glacier.model.DeleteVaultNotificationsRequest)]
   (clojure.core/when-let
    [v2342 (:account-id m2341)]
    (. bean2340 setAccountId (clojure.core/str v2342)))
   (clojure.core/when-let
    [v2342 (:vault-name m2341)]
    (. bean2340 setVaultName (clojure.core/str v2342)))
   bean2340))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.CompleteMultipartUploadRequest}
complete-multipart-upload-request
  [m2344]
  (clojure.core/let
   [bean2343
    (new
     com.amazonaws.services.glacier.model.CompleteMultipartUploadRequest)]
   (clojure.core/when-let
    [v2345 (:account-id m2344)]
    (. bean2343 setAccountId (clojure.core/str v2345)))
   (clojure.core/when-let
    [v2345 (:vault-name m2344)]
    (. bean2343 setVaultName (clojure.core/str v2345)))
   (clojure.core/when-let
    [v2345 (:upload-id m2344)]
    (. bean2343 setUploadId (clojure.core/str v2345)))
   (clojure.core/when-let
    [v2345 (:checksum m2344)]
    (. bean2343 setChecksum (clojure.core/str v2345)))
   (clojure.core/when-let
    [v2345 (:archive-size m2344)]
    (. bean2343 setArchiveSize (clojure.core/str v2345)))
   bean2343))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.GetJobOutputRequest}
get-job-output-request
  [m2347]
  (clojure.core/let
   [bean2346
    (new com.amazonaws.services.glacier.model.GetJobOutputRequest)]
   (clojure.core/when-let
    [v2348 (:range m2347)]
    (. bean2346 setRange (clojure.core/str v2348)))
   (clojure.core/when-let
    [v2348 (:account-id m2347)]
    (. bean2346 setAccountId (clojure.core/str v2348)))
   (clojure.core/when-let
    [v2348 (:vault-name m2347)]
    (. bean2346 setVaultName (clojure.core/str v2348)))
   (clojure.core/when-let
    [v2348 (:job-id m2347)]
    (. bean2346 setJobId (clojure.core/str v2348)))
   bean2346))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.ListMultipartUploadsRequest}
list-multipart-uploads-request
  [m2350]
  (clojure.core/let
   [bean2349
    (new
     com.amazonaws.services.glacier.model.ListMultipartUploadsRequest)]
   (clojure.core/when-let
    [v2351 (:account-id m2350)]
    (. bean2349 setAccountId (clojure.core/str v2351)))
   (clojure.core/when-let
    [v2351 (:vault-name m2350)]
    (. bean2349 setVaultName (clojure.core/str v2351)))
   (clojure.core/when-let
    [v2351 (:upload-id-marker m2350)]
    (. bean2349 setUploadIdMarker (clojure.core/str v2351)))
   (clojure.core/when-let
    [v2351 (:limit m2350)]
    (. bean2349 setLimit (clojure.core/str v2351)))
   bean2349))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.DescribeJobRequest}
describe-job-request
  [m2353]
  (clojure.core/let
   [bean2352
    (new com.amazonaws.services.glacier.model.DescribeJobRequest)]
   (clojure.core/when-let
    [v2354 (:account-id m2353)]
    (. bean2352 setAccountId (clojure.core/str v2354)))
   (clojure.core/when-let
    [v2354 (:vault-name m2353)]
    (. bean2352 setVaultName (clojure.core/str v2354)))
   (clojure.core/when-let
    [v2354 (:job-id m2353)]
    (. bean2352 setJobId (clojure.core/str v2354)))
   bean2352))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.CreateVaultRequest}
create-vault-request
  [m2356]
  (clojure.core/let
   [bean2355
    (new com.amazonaws.services.glacier.model.CreateVaultRequest)]
   (clojure.core/when-let
    [v2357 (:account-id m2356)]
    (. bean2355 setAccountId (clojure.core/str v2357)))
   (clojure.core/when-let
    [v2357 (:vault-name m2356)]
    (. bean2355 setVaultName (clojure.core/str v2357)))
   bean2355))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.UploadArchiveRequest}
upload-archive-request
  [m2359]
  (clojure.core/let
   [bean2358
    (new com.amazonaws.services.glacier.model.UploadArchiveRequest)]
   (clojure.core/when-let
    [v2360 (:account-id m2359)]
    (. bean2358 setAccountId (clojure.core/str v2360)))
   (clojure.core/when-let
    [v2360 (:vault-name m2359)]
    (. bean2358 setVaultName (clojure.core/str v2360)))
   (clojure.core/when-let
    [v2360 (:archive-description m2359)]
    (. bean2358 setArchiveDescription (clojure.core/str v2360)))
   (clojure.core/when-let
    [v2360 (:checksum m2359)]
    (. bean2358 setChecksum (clojure.core/str v2360)))
   (clojure.core/when-let
    [v2360 (:body m2359)]
    (. bean2358 setBody (clojure.java.io/input-stream v2360)))
   (clojure.core/when-let
    [v2360 (:content-length m2359)]
    (. bean2358 setContentLength (clojure.core/long v2360)))
   bean2358))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.InitiateMultipartUploadRequest}
initiate-multipart-upload-request
  [m2362]
  (clojure.core/let
   [bean2361
    (new
     com.amazonaws.services.glacier.model.InitiateMultipartUploadRequest)]
   (clojure.core/when-let
    [v2363 (:account-id m2362)]
    (. bean2361 setAccountId (clojure.core/str v2363)))
   (clojure.core/when-let
    [v2363 (:vault-name m2362)]
    (. bean2361 setVaultName (clojure.core/str v2363)))
   (clojure.core/when-let
    [v2363 (:archive-description m2362)]
    (. bean2361 setArchiveDescription (clojure.core/str v2363)))
   (clojure.core/when-let
    [v2363 (:part-size m2362)]
    (. bean2361 setPartSize (clojure.core/str v2363)))
   bean2361))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.DeleteArchiveRequest}
delete-archive-request
  [m2365]
  (clojure.core/let
   [bean2364
    (new com.amazonaws.services.glacier.model.DeleteArchiveRequest)]
   (clojure.core/when-let
    [v2366 (:account-id m2365)]
    (. bean2364 setAccountId (clojure.core/str v2366)))
   (clojure.core/when-let
    [v2366 (:vault-name m2365)]
    (. bean2364 setVaultName (clojure.core/str v2366)))
   (clojure.core/when-let
    [v2366 (:archive-id m2365)]
    (. bean2364 setArchiveId (clojure.core/str v2366)))
   bean2364))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.SetVaultNotificationsRequest}
set-vault-notifications-request
  [m2368]
  (clojure.core/let
   [bean2367
    (new
     com.amazonaws.services.glacier.model.SetVaultNotificationsRequest)]
   (clojure.core/when-let
    [v2369 (:account-id m2368)]
    (. bean2367 setAccountId (clojure.core/str v2369)))
   (clojure.core/when-let
    [v2369 (:vault-name m2368)]
    (. bean2367 setVaultName (clojure.core/str v2369)))
   (clojure.core/when-let
    [v2369 (:vault-notification-config m2368)]
    (.
     bean2367
     setVaultNotificationConfig
     (glacier/vault-notification-config v2369)))
   bean2367))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.ListPartsRequest}
list-parts-request
  [m2371]
  (clojure.core/let
   [bean2370
    (new com.amazonaws.services.glacier.model.ListPartsRequest)]
   (clojure.core/when-let
    [v2372 (:marker m2371)]
    (. bean2370 setMarker (clojure.core/str v2372)))
   (clojure.core/when-let
    [v2372 (:account-id m2371)]
    (. bean2370 setAccountId (clojure.core/str v2372)))
   (clojure.core/when-let
    [v2372 (:vault-name m2371)]
    (. bean2370 setVaultName (clojure.core/str v2372)))
   (clojure.core/when-let
    [v2372 (:upload-id m2371)]
    (. bean2370 setUploadId (clojure.core/str v2372)))
   (clojure.core/when-let
    [v2372 (:limit m2371)]
    (. bean2370 setLimit (clojure.core/str v2372)))
   bean2370))
 (clojure.core/defmulti
  glacier
  (clojure.core/fn glacier [m__1683__auto__] (:fn m__1683__auto__)))
 (do
  (clojure.core/defmethod
   glacier
   :list-jobs
   [m2374]
   (clojure.core/let
    [credentials2375 (:credentials m2374) args2376 (:args m2374)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client2377
      (com.palletops.awaze.common/aws-client :glacier credentials2375)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client2377
       listJobs
       (glacier/list-jobs-request (clojure.core/nth args2376 0)))))))
  (clojure.core/defn
   list-jobs-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         vault-name
                         statuscode
                         account-id
                         limit
                         marker
                         completed]}]]),
    :doc "Generate map for listJobs"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :glacier,
     :fn :list-jobs,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   list-jobs
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         vault-name
                         statuscode
                         account-id
                         limit
                         marker
                         completed]}]]),
    :doc "Call listJobs"}
   [credentials2379 & args2380]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client2381
     (com.palletops.awaze.common/aws-client :glacier credentials2379)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client2381
      listJobs
      (glacier/list-jobs-request (clojure.core/nth args2380 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :get-vault-notifications
   [m2382]
   (clojure.core/let
    [credentials2383 (:credentials m2382) args2384 (:args m2382)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client2385
      (com.palletops.awaze.common/aws-client :glacier credentials2383)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client2385
       getVaultNotifications
       (glacier/get-vault-notifications-request
        (clojure.core/nth args2384 0)))))))
  (clojure.core/defn
   get-vault-notifications-map
   {:arglists (quote
               [[credentials
                 {:keys [vault-name
                         general-progress-listener
                         account-id]}]]),
    :doc "Generate map for getVaultNotifications"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :glacier,
     :fn :get-vault-notifications,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   get-vault-notifications
   {:arglists (quote
               [[credentials
                 {:keys [vault-name
                         general-progress-listener
                         account-id]}]]),
    :doc "Call getVaultNotifications"}
   [credentials2387 & args2388]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client2389
     (com.palletops.awaze.common/aws-client :glacier credentials2387)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client2389
      getVaultNotifications
      (glacier/get-vault-notifications-request
       (clojure.core/nth args2388 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :upload-multipart-part
   [m2390]
   (clojure.core/let
    [credentials2391 (:credentials m2390) args2392 (:args m2390)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client2393
      (com.palletops.awaze.common/aws-client :glacier credentials2391)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client2393
       uploadMultipartPart
       (glacier/upload-multipart-part-request
        (clojure.core/nth args2392 0)))))))
  (clojure.core/defn
   upload-multipart-part-map
   {:arglists (quote
               [[credentials
                 {:keys [checksum
                         general-progress-listener
                         vault-name
                         range
                         upload-id
                         account-id
                         body]}]]),
    :doc "Generate map for uploadMultipartPart"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :glacier,
     :fn :upload-multipart-part,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   upload-multipart-part
   {:arglists (quote
               [[credentials
                 {:keys [checksum
                         general-progress-listener
                         vault-name
                         range
                         upload-id
                         account-id
                         body]}]]),
    :doc "Call uploadMultipartPart"}
   [credentials2395 & args2396]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client2397
     (com.palletops.awaze.common/aws-client :glacier credentials2395)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client2397
      uploadMultipartPart
      (glacier/upload-multipart-part-request
       (clojure.core/nth args2396 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :list-vaults
   [m2398]
   (clojure.core/let
    [credentials2399 (:credentials m2398) args2400 (:args m2398)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client2401
      (com.palletops.awaze.common/aws-client :glacier credentials2399)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client2401
       listVaults
       (glacier/list-vaults-request (clojure.core/nth args2400 0)))))))
  (clojure.core/defn
   list-vaults-map
   {:arglists (quote
               [[credentials
                 {:keys [marker
                         limit
                         general-progress-listener
                         account-id]}]]),
    :doc "Generate map for listVaults"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :glacier,
     :fn :list-vaults,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   list-vaults
   {:arglists (quote
               [[credentials
                 {:keys [marker
                         limit
                         general-progress-listener
                         account-id]}]]),
    :doc "Call listVaults"}
   [credentials2403 & args2404]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client2405
     (com.palletops.awaze.common/aws-client :glacier credentials2403)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client2405
      listVaults
      (glacier/list-vaults-request (clojure.core/nth args2404 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :delete-vault
   [m2406]
   (clojure.core/let
    [credentials2407 (:credentials m2406) args2408 (:args m2406)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client2409
      (com.palletops.awaze.common/aws-client :glacier credentials2407)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client2409
       deleteVault
       (glacier/delete-vault-request (clojure.core/nth args2408 0)))))))
  (clojure.core/defn
   delete-vault-map
   {:arglists (quote
               [[credentials
                 {:keys [vault-name
                         general-progress-listener
                         account-id]}]]),
    :doc "Generate map for deleteVault"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :glacier,
     :fn :delete-vault,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-vault
   {:arglists (quote
               [[credentials
                 {:keys [vault-name
                         general-progress-listener
                         account-id]}]]),
    :doc "Call deleteVault"}
   [credentials2411 & args2412]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client2413
     (com.palletops.awaze.common/aws-client :glacier credentials2411)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client2413
      deleteVault
      (glacier/delete-vault-request (clojure.core/nth args2412 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :initiate-job
   [m2414]
   (clojure.core/let
    [credentials2415 (:credentials m2414) args2416 (:args m2414)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client2417
      (com.palletops.awaze.common/aws-client :glacier credentials2415)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client2417
       initiateJob
       (glacier/initiate-job-request (clojure.core/nth args2416 0)))))))
  (clojure.core/defn
   initiate-job-map
   {:arglists (quote
               [[credentials
                 {:keys [vault-name
                         job-parameters
                         general-progress-listener
                         account-id]}]]),
    :doc "Generate map for initiateJob"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :glacier,
     :fn :initiate-job,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   initiate-job
   {:arglists (quote
               [[credentials
                 {:keys [vault-name
                         job-parameters
                         general-progress-listener
                         account-id]}]]),
    :doc "Call initiateJob"}
   [credentials2419 & args2420]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client2421
     (com.palletops.awaze.common/aws-client :glacier credentials2419)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client2421
      initiateJob
      (glacier/initiate-job-request (clojure.core/nth args2420 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :describe-vault
   [m2422]
   (clojure.core/let
    [credentials2423 (:credentials m2422) args2424 (:args m2422)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client2425
      (com.palletops.awaze.common/aws-client :glacier credentials2423)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client2425
       describeVault
       (glacier/describe-vault-request (clojure.core/nth args2424 0)))))))
  (clojure.core/defn
   describe-vault-map
   {:arglists (quote
               [[credentials
                 {:keys [vault-name
                         general-progress-listener
                         account-id]}]]),
    :doc "Generate map for describeVault"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :glacier,
     :fn :describe-vault,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-vault
   {:arglists (quote
               [[credentials
                 {:keys [vault-name
                         general-progress-listener
                         account-id]}]]),
    :doc "Call describeVault"}
   [credentials2427 & args2428]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client2429
     (com.palletops.awaze.common/aws-client :glacier credentials2427)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client2429
      describeVault
      (glacier/describe-vault-request (clojure.core/nth args2428 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :abort-multipart-upload
   [m2430]
   (clojure.core/let
    [credentials2431 (:credentials m2430) args2432 (:args m2430)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client2433
      (com.palletops.awaze.common/aws-client :glacier credentials2431)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client2433
       abortMultipartUpload
       (glacier/abort-multipart-upload-request
        (clojure.core/nth args2432 0)))))))
  (clojure.core/defn
   abort-multipart-upload-map
   {:arglists (quote
               [[credentials
                 {:keys [vault-name
                         upload-id
                         general-progress-listener
                         account-id]}]]),
    :doc "Generate map for abortMultipartUpload"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :glacier,
     :fn :abort-multipart-upload,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   abort-multipart-upload
   {:arglists (quote
               [[credentials
                 {:keys [vault-name
                         upload-id
                         general-progress-listener
                         account-id]}]]),
    :doc "Call abortMultipartUpload"}
   [credentials2435 & args2436]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client2437
     (com.palletops.awaze.common/aws-client :glacier credentials2435)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client2437
      abortMultipartUpload
      (glacier/abort-multipart-upload-request
       (clojure.core/nth args2436 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :delete-vault-notifications
   [m2438]
   (clojure.core/let
    [credentials2439 (:credentials m2438) args2440 (:args m2438)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client2441
      (com.palletops.awaze.common/aws-client :glacier credentials2439)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client2441
       deleteVaultNotifications
       (glacier/delete-vault-notifications-request
        (clojure.core/nth args2440 0)))))))
  (clojure.core/defn
   delete-vault-notifications-map
   {:arglists (quote
               [[credentials
                 {:keys [vault-name
                         general-progress-listener
                         account-id]}]]),
    :doc "Generate map for deleteVaultNotifications"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :glacier,
     :fn :delete-vault-notifications,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-vault-notifications
   {:arglists (quote
               [[credentials
                 {:keys [vault-name
                         general-progress-listener
                         account-id]}]]),
    :doc "Call deleteVaultNotifications"}
   [credentials2443 & args2444]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client2445
     (com.palletops.awaze.common/aws-client :glacier credentials2443)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client2445
      deleteVaultNotifications
      (glacier/delete-vault-notifications-request
       (clojure.core/nth args2444 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :complete-multipart-upload
   [m2446]
   (clojure.core/let
    [credentials2447 (:credentials m2446) args2448 (:args m2446)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client2449
      (com.palletops.awaze.common/aws-client :glacier credentials2447)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client2449
       completeMultipartUpload
       (glacier/complete-multipart-upload-request
        (clojure.core/nth args2448 0)))))))
  (clojure.core/defn
   complete-multipart-upload-map
   {:arglists (quote
               [[credentials
                 {:keys [upload-id
                         general-progress-listener
                         archive-size
                         vault-name
                         account-id
                         checksum]}]]),
    :doc "Generate map for completeMultipartUpload"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :glacier,
     :fn :complete-multipart-upload,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   complete-multipart-upload
   {:arglists (quote
               [[credentials
                 {:keys [upload-id
                         general-progress-listener
                         archive-size
                         vault-name
                         account-id
                         checksum]}]]),
    :doc "Call completeMultipartUpload"}
   [credentials2451 & args2452]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client2453
     (com.palletops.awaze.common/aws-client :glacier credentials2451)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client2453
      completeMultipartUpload
      (glacier/complete-multipart-upload-request
       (clojure.core/nth args2452 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :get-job-output
   [m2454]
   (clojure.core/let
    [credentials2455 (:credentials m2454) args2456 (:args m2454)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client2457
      (com.palletops.awaze.common/aws-client :glacier credentials2455)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client2457
       getJobOutput
       (glacier/get-job-output-request (clojure.core/nth args2456 0)))))))
  (clojure.core/defn
   get-job-output-map
   {:arglists (quote
               [[credentials
                 {:keys [vault-name
                         range
                         job-id
                         general-progress-listener
                         account-id]}]]),
    :doc "Generate map for getJobOutput"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :glacier,
     :fn :get-job-output,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   get-job-output
   {:arglists (quote
               [[credentials
                 {:keys [vault-name
                         range
                         job-id
                         general-progress-listener
                         account-id]}]]),
    :doc "Call getJobOutput"}
   [credentials2459 & args2460]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client2461
     (com.palletops.awaze.common/aws-client :glacier credentials2459)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client2461
      getJobOutput
      (glacier/get-job-output-request (clojure.core/nth args2460 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :list-multipart-uploads
   [m2462]
   (clojure.core/let
    [credentials2463 (:credentials m2462) args2464 (:args m2462)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client2465
      (com.palletops.awaze.common/aws-client :glacier credentials2463)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client2465
       listMultipartUploads
       (glacier/list-multipart-uploads-request
        (clojure.core/nth args2464 0)))))))
  (clojure.core/defn
   list-multipart-uploads-map
   {:arglists (quote
               [[credentials
                 {:keys [vault-name
                         upload-id-marker
                         limit
                         general-progress-listener
                         account-id]}]]),
    :doc "Generate map for listMultipartUploads"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :glacier,
     :fn :list-multipart-uploads,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   list-multipart-uploads
   {:arglists (quote
               [[credentials
                 {:keys [vault-name
                         upload-id-marker
                         limit
                         general-progress-listener
                         account-id]}]]),
    :doc "Call listMultipartUploads"}
   [credentials2467 & args2468]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client2469
     (com.palletops.awaze.common/aws-client :glacier credentials2467)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client2469
      listMultipartUploads
      (glacier/list-multipart-uploads-request
       (clojure.core/nth args2468 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :describe-job
   [m2470]
   (clojure.core/let
    [credentials2471 (:credentials m2470) args2472 (:args m2470)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client2473
      (com.palletops.awaze.common/aws-client :glacier credentials2471)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client2473
       describeJob
       (glacier/describe-job-request (clojure.core/nth args2472 0)))))))
  (clojure.core/defn
   describe-job-map
   {:arglists (quote
               [[credentials
                 {:keys [vault-name
                         job-id
                         general-progress-listener
                         account-id]}]]),
    :doc "Generate map for describeJob"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :glacier,
     :fn :describe-job,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-job
   {:arglists (quote
               [[credentials
                 {:keys [vault-name
                         job-id
                         general-progress-listener
                         account-id]}]]),
    :doc "Call describeJob"}
   [credentials2475 & args2476]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client2477
     (com.palletops.awaze.common/aws-client :glacier credentials2475)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client2477
      describeJob
      (glacier/describe-job-request (clojure.core/nth args2476 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :create-vault
   [m2478]
   (clojure.core/let
    [credentials2479 (:credentials m2478) args2480 (:args m2478)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client2481
      (com.palletops.awaze.common/aws-client :glacier credentials2479)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client2481
       createVault
       (glacier/create-vault-request (clojure.core/nth args2480 0)))))))
  (clojure.core/defn
   create-vault-map
   {:arglists (quote
               [[credentials
                 {:keys [vault-name
                         general-progress-listener
                         account-id]}]]),
    :doc "Generate map for createVault"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :glacier,
     :fn :create-vault,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-vault
   {:arglists (quote
               [[credentials
                 {:keys [vault-name
                         general-progress-listener
                         account-id]}]]),
    :doc "Call createVault"}
   [credentials2483 & args2484]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client2485
     (com.palletops.awaze.common/aws-client :glacier credentials2483)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client2485
      createVault
      (glacier/create-vault-request (clojure.core/nth args2484 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :upload-archive
   [m2486]
   (clojure.core/let
    [credentials2487 (:credentials m2486) args2488 (:args m2486)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client2489
      (com.palletops.awaze.common/aws-client :glacier credentials2487)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client2489
       uploadArchive
       (glacier/upload-archive-request (clojure.core/nth args2488 0)))))))
  (clojure.core/defn
   upload-archive-map
   {:arglists (quote
               [[credentials
                 {:keys [checksum
                         general-progress-listener
                         vault-name
                         account-id
                         content-length
                         body
                         archive-description]}]]),
    :doc "Generate map for uploadArchive"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :glacier,
     :fn :upload-archive,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   upload-archive
   {:arglists (quote
               [[credentials
                 {:keys [checksum
                         general-progress-listener
                         vault-name
                         account-id
                         content-length
                         body
                         archive-description]}]]),
    :doc "Call uploadArchive"}
   [credentials2491 & args2492]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client2493
     (com.palletops.awaze.common/aws-client :glacier credentials2491)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client2493
      uploadArchive
      (glacier/upload-archive-request (clojure.core/nth args2492 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :initiate-multipart-upload
   [m2494]
   (clojure.core/let
    [credentials2495 (:credentials m2494) args2496 (:args m2494)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client2497
      (com.palletops.awaze.common/aws-client :glacier credentials2495)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client2497
       initiateMultipartUpload
       (glacier/initiate-multipart-upload-request
        (clojure.core/nth args2496 0)))))))
  (clojure.core/defn
   initiate-multipart-upload-map
   {:arglists (quote
               [[credentials
                 {:keys [vault-name
                         part-size
                         general-progress-listener
                         archive-description
                         account-id]}]]),
    :doc "Generate map for initiateMultipartUpload"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :glacier,
     :fn :initiate-multipart-upload,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   initiate-multipart-upload
   {:arglists (quote
               [[credentials
                 {:keys [vault-name
                         part-size
                         general-progress-listener
                         archive-description
                         account-id]}]]),
    :doc "Call initiateMultipartUpload"}
   [credentials2499 & args2500]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client2501
     (com.palletops.awaze.common/aws-client :glacier credentials2499)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client2501
      initiateMultipartUpload
      (glacier/initiate-multipart-upload-request
       (clojure.core/nth args2500 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :delete-archive
   [m2502]
   (clojure.core/let
    [credentials2503 (:credentials m2502) args2504 (:args m2502)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client2505
      (com.palletops.awaze.common/aws-client :glacier credentials2503)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client2505
       deleteArchive
       (glacier/delete-archive-request (clojure.core/nth args2504 0)))))))
  (clojure.core/defn
   delete-archive-map
   {:arglists (quote
               [[credentials
                 {:keys [vault-name
                         general-progress-listener
                         archive-id
                         account-id]}]]),
    :doc "Generate map for deleteArchive"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :glacier,
     :fn :delete-archive,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-archive
   {:arglists (quote
               [[credentials
                 {:keys [vault-name
                         general-progress-listener
                         archive-id
                         account-id]}]]),
    :doc "Call deleteArchive"}
   [credentials2507 & args2508]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client2509
     (com.palletops.awaze.common/aws-client :glacier credentials2507)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client2509
      deleteArchive
      (glacier/delete-archive-request (clojure.core/nth args2508 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :set-vault-notifications
   [m2510]
   (clojure.core/let
    [credentials2511 (:credentials m2510) args2512 (:args m2510)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client2513
      (com.palletops.awaze.common/aws-client :glacier credentials2511)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client2513
       setVaultNotifications
       (glacier/set-vault-notifications-request
        (clojure.core/nth args2512 0)))))))
  (clojure.core/defn
   set-vault-notifications-map
   {:arglists (quote
               [[credentials
                 {:keys [vault-notification-config
                         vault-name
                         general-progress-listener
                         account-id]}]]),
    :doc "Generate map for setVaultNotifications"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :glacier,
     :fn :set-vault-notifications,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   set-vault-notifications
   {:arglists (quote
               [[credentials
                 {:keys [vault-notification-config
                         vault-name
                         general-progress-listener
                         account-id]}]]),
    :doc "Call setVaultNotifications"}
   [credentials2515 & args2516]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client2517
     (com.palletops.awaze.common/aws-client :glacier credentials2515)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client2517
      setVaultNotifications
      (glacier/set-vault-notifications-request
       (clojure.core/nth args2516 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :list-parts
   [m2518]
   (clojure.core/let
    [credentials2519 (:credentials m2518) args2520 (:args m2518)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client2521
      (com.palletops.awaze.common/aws-client :glacier credentials2519)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client2521
       listParts
       (glacier/list-parts-request (clojure.core/nth args2520 0)))))))
  (clojure.core/defn
   list-parts-map
   {:arglists (quote
               [[credentials
                 {:keys [upload-id
                         marker
                         limit
                         general-progress-listener
                         vault-name
                         account-id]}]]),
    :doc "Generate map for listParts"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :glacier,
     :fn :list-parts,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   list-parts
   {:arglists (quote
               [[credentials
                 {:keys [upload-id
                         marker
                         limit
                         general-progress-listener
                         vault-name
                         account-id]}]]),
    :doc "Call listParts"}
   [credentials2523 & args2524]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client2525
     (com.palletops.awaze.common/aws-client :glacier credentials2523)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client2525
      listParts
      (glacier/list-parts-request (clojure.core/nth args2524 0))))))))
