(ns
 com.palletops.awaze.redshift
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.redshift :as redshift]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :redshift
  [___1600__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1601__auto__]
  (new
   com.amazonaws.services.redshift.AmazonRedshiftClient
   credentials__1601__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.Parameter}
parameter
  [m2527]
  (clojure.core/let
   [bean2526 (new com.amazonaws.services.redshift.model.Parameter)]
   (clojure.core/when-let
    [v2528 (:parameter-name m2527)]
    (. bean2526 setParameterName (clojure.core/str v2528)))
   (clojure.core/when-let
    [v2528 (:parameter-value m2527)]
    (. bean2526 setParameterValue (clojure.core/str v2528)))
   (clojure.core/when-let
    [v2528 (:data-type m2527)]
    (. bean2526 setDataType (clojure.core/str v2528)))
   (clojure.core/when-let
    [v2528 (:allowed-values m2527)]
    (. bean2526 setAllowedValues (clojure.core/str v2528)))
   (clojure.core/when-let
    [v2528 (:is-modifiable m2527)]
    (. bean2526 setIsModifiable (clojure.core/boolean v2528)))
   (clojure.core/when-let
    [v2528 (:minimum-engine-version m2527)]
    (. bean2526 setMinimumEngineVersion (clojure.core/str v2528)))
   (clojure.core/when-let
    [v2528 (:source m2527)]
    (. bean2526 setSource (clojure.core/str v2528)))
   (clojure.core/when-let
    [v2528 (:description m2527)]
    (. bean2526 setDescription (clojure.core/str v2528)))
   bean2526))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.SourceType}
source-type
  [m2530]
  (.
   com.amazonaws.services.redshift.model.SourceType
   fromValue
   (clojure.core/name m2530)))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeClusterSecurityGroupsRequest}
describe-cluster-security-groups-request
  [m2533]
  (clojure.core/let
   [bean2532
    (new
     com.amazonaws.services.redshift.model.DescribeClusterSecurityGroupsRequest)]
   (clojure.core/when-let
    [v2534 (:marker m2533)]
    (. bean2532 setMarker (clojure.core/str v2534)))
   (clojure.core/when-let
    [v2534 (:max-records m2533)]
    (. bean2532 setMaxRecords (clojure.core/int v2534)))
   (clojure.core/when-let
    [v2534 (:cluster-security-group-name m2533)]
    (. bean2532 setClusterSecurityGroupName (clojure.core/str v2534)))
   bean2532))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeClusterParameterGroupsRequest}
describe-cluster-parameter-groups-request
  [m2536]
  (clojure.core/let
   [bean2535
    (new
     com.amazonaws.services.redshift.model.DescribeClusterParameterGroupsRequest)]
   (clojure.core/when-let
    [v2537 (:marker m2536)]
    (. bean2535 setMarker (clojure.core/str v2537)))
   (clojure.core/when-let
    [v2537 (:max-records m2536)]
    (. bean2535 setMaxRecords (clojure.core/int v2537)))
   (clojure.core/when-let
    [v2537 (:parameter-group-name m2536)]
    (. bean2535 setParameterGroupName (clojure.core/str v2537)))
   bean2535))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.EnableSnapshotCopyRequest}
enable-snapshot-copy-request
  [m2539]
  (clojure.core/let
   [bean2538
    (new
     com.amazonaws.services.redshift.model.EnableSnapshotCopyRequest)]
   (clojure.core/when-let
    [v2540 (:cluster-identifier m2539)]
    (. bean2538 setClusterIdentifier (clojure.core/str v2540)))
   (clojure.core/when-let
    [v2540 (:retention-period m2539)]
    (. bean2538 setRetentionPeriod (clojure.core/int v2540)))
   (clojure.core/when-let
    [v2540 (:destination-region m2539)]
    (. bean2538 setDestinationRegion (clojure.core/str v2540)))
   bean2538))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.CreateClusterRequest}
create-cluster-request
  [m2542]
  (clojure.core/let
   [bean2541
    (new com.amazonaws.services.redshift.model.CreateClusterRequest)]
   (clojure.core/when-let
    [v2543 (:vpc-security-group-ids m2542)]
    (.
     bean2541
     setVpcSecurityGroupIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2691] (clojure.core/str arg2691))
 v2543)))
   (clojure.core/when-let
    [v2543 (:cluster-version m2542)]
    (. bean2541 setClusterVersion (clojure.core/str v2543)))
   (clojure.core/when-let
    [v2543 (:cluster-identifier m2542)]
    (. bean2541 setClusterIdentifier (clojure.core/str v2543)))
   (clojure.core/when-let
    [v2543 (:encrypted m2542)]
    (. bean2541 setEncrypted (clojure.core/boolean v2543)))
   (clojure.core/when-let
    [v2543 (:port m2542)]
    (. bean2541 setPort (clojure.core/int v2543)))
   (clojure.core/when-let
    [v2543 (:preferred-maintenance-window m2542)]
    (.
     bean2541
     setPreferredMaintenanceWindow
     (clojure.core/str v2543)))
   (clojure.core/when-let
    [v2543 (:availability-zone m2542)]
    (. bean2541 setAvailabilityZone (clojure.core/str v2543)))
   (clojure.core/when-let
    [v2543 (:master-user-password m2542)]
    (. bean2541 setMasterUserPassword (clojure.core/str v2543)))
   (clojure.core/when-let
    [v2543 (:allow-version-upgrade m2542)]
    (. bean2541 setAllowVersionUpgrade (clojure.core/boolean v2543)))
   (clojure.core/when-let
    [v2543 (:dbname m2542)]
    (. bean2541 setDBName (clojure.core/str v2543)))
   (clojure.core/when-let
    [v2543 (:cluster-security-groups m2542)]
    (.
     bean2541
     setClusterSecurityGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2692] (clojure.core/str arg2692))
 v2543)))
   (clojure.core/when-let
    [v2543 (:automated-snapshot-retention-period m2542)]
    (.
     bean2541
     setAutomatedSnapshotRetentionPeriod
     (clojure.core/int v2543)))
   (clojure.core/when-let
    [v2543 (:publicly-accessible m2542)]
    (. bean2541 setPubliclyAccessible (clojure.core/boolean v2543)))
   (clojure.core/when-let
    [v2543 (:number-of-nodes m2542)]
    (. bean2541 setNumberOfNodes (clojure.core/int v2543)))
   (clojure.core/when-let
    [v2543 (:cluster-type m2542)]
    (. bean2541 setClusterType (clojure.core/str v2543)))
   (clojure.core/when-let
    [v2543 (:cluster-subnet-group-name m2542)]
    (. bean2541 setClusterSubnetGroupName (clojure.core/str v2543)))
   (clojure.core/when-let
    [v2543 (:hsm-client-certificate-identifier m2542)]
    (.
     bean2541
     setHsmClientCertificateIdentifier
     (clojure.core/str v2543)))
   (clojure.core/when-let
    [v2543 (:cluster-parameter-group-name m2542)]
    (. bean2541 setClusterParameterGroupName (clojure.core/str v2543)))
   (clojure.core/when-let
    [v2543 (:elastic-ip m2542)]
    (. bean2541 setElasticIp (clojure.core/str v2543)))
   (clojure.core/when-let
    [v2543 (:master-username m2542)]
    (. bean2541 setMasterUsername (clojure.core/str v2543)))
   (clojure.core/when-let
    [v2543 (:node-type m2542)]
    (. bean2541 setNodeType (clojure.core/str v2543)))
   (clojure.core/when-let
    [v2543 (:hsm-configuration-identifier m2542)]
    (.
     bean2541
     setHsmConfigurationIdentifier
     (clojure.core/str v2543)))
   bean2541))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.AuthorizeSnapshotAccessRequest}
authorize-snapshot-access-request
  [m2545]
  (clojure.core/let
   [bean2544
    (new
     com.amazonaws.services.redshift.model.AuthorizeSnapshotAccessRequest)]
   (clojure.core/when-let
    [v2546 (:snapshot-identifier m2545)]
    (. bean2544 setSnapshotIdentifier (clojure.core/str v2546)))
   (clojure.core/when-let
    [v2546 (:snapshot-cluster-identifier m2545)]
    (. bean2544 setSnapshotClusterIdentifier (clojure.core/str v2546)))
   (clojure.core/when-let
    [v2546 (:account-with-restore-access m2545)]
    (. bean2544 setAccountWithRestoreAccess (clojure.core/str v2546)))
   bean2544))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeClusterSubnetGroupsRequest}
describe-cluster-subnet-groups-request
  [m2548]
  (clojure.core/let
   [bean2547
    (new
     com.amazonaws.services.redshift.model.DescribeClusterSubnetGroupsRequest)]
   (clojure.core/when-let
    [v2549 (:marker m2548)]
    (. bean2547 setMarker (clojure.core/str v2549)))
   (clojure.core/when-let
    [v2549 (:cluster-subnet-group-name m2548)]
    (. bean2547 setClusterSubnetGroupName (clojure.core/str v2549)))
   (clojure.core/when-let
    [v2549 (:max-records m2548)]
    (. bean2547 setMaxRecords (clojure.core/int v2549)))
   bean2547))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.EnableLoggingRequest}
enable-logging-request
  [m2551]
  (clojure.core/let
   [bean2550
    (new com.amazonaws.services.redshift.model.EnableLoggingRequest)]
   (clojure.core/when-let
    [v2552 (:cluster-identifier m2551)]
    (. bean2550 setClusterIdentifier (clojure.core/str v2552)))
   (clojure.core/when-let
    [v2552 (:bucket-name m2551)]
    (. bean2550 setBucketName (clojure.core/str v2552)))
   (clojure.core/when-let
    [v2552 (:s3key-prefix m2551)]
    (. bean2550 setS3KeyPrefix (clojure.core/str v2552)))
   bean2550))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeClustersRequest}
describe-clusters-request
  [m2554]
  (clojure.core/let
   [bean2553
    (new
     com.amazonaws.services.redshift.model.DescribeClustersRequest)]
   (clojure.core/when-let
    [v2555 (:marker m2554)]
    (. bean2553 setMarker (clojure.core/str v2555)))
   (clojure.core/when-let
    [v2555 (:cluster-identifier m2554)]
    (. bean2553 setClusterIdentifier (clojure.core/str v2555)))
   (clojure.core/when-let
    [v2555 (:max-records m2554)]
    (. bean2553 setMaxRecords (clojure.core/int v2555)))
   bean2553))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.RestoreFromClusterSnapshotRequest}
restore-from-cluster-snapshot-request
  [m2557]
  (clojure.core/let
   [bean2556
    (new
     com.amazonaws.services.redshift.model.RestoreFromClusterSnapshotRequest)]
   (clojure.core/when-let
    [v2558 (:vpc-security-group-ids m2557)]
    (.
     bean2556
     setVpcSecurityGroupIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2693] (clojure.core/str arg2693))
 v2558)))
   (clojure.core/when-let
    [v2558 (:cluster-identifier m2557)]
    (. bean2556 setClusterIdentifier (clojure.core/str v2558)))
   (clojure.core/when-let
    [v2558 (:port m2557)]
    (. bean2556 setPort (clojure.core/int v2558)))
   (clojure.core/when-let
    [v2558 (:preferred-maintenance-window m2557)]
    (.
     bean2556
     setPreferredMaintenanceWindow
     (clojure.core/str v2558)))
   (clojure.core/when-let
    [v2558 (:availability-zone m2557)]
    (. bean2556 setAvailabilityZone (clojure.core/str v2558)))
   (clojure.core/when-let
    [v2558 (:allow-version-upgrade m2557)]
    (. bean2556 setAllowVersionUpgrade (clojure.core/boolean v2558)))
   (clojure.core/when-let
    [v2558 (:cluster-security-groups m2557)]
    (.
     bean2556
     setClusterSecurityGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2694] (clojure.core/str arg2694))
 v2558)))
   (clojure.core/when-let
    [v2558 (:automated-snapshot-retention-period m2557)]
    (.
     bean2556
     setAutomatedSnapshotRetentionPeriod
     (clojure.core/int v2558)))
   (clojure.core/when-let
    [v2558 (:publicly-accessible m2557)]
    (. bean2556 setPubliclyAccessible (clojure.core/boolean v2558)))
   (clojure.core/when-let
    [v2558 (:snapshot-identifier m2557)]
    (. bean2556 setSnapshotIdentifier (clojure.core/str v2558)))
   (clojure.core/when-let
    [v2558 (:cluster-subnet-group-name m2557)]
    (. bean2556 setClusterSubnetGroupName (clojure.core/str v2558)))
   (clojure.core/when-let
    [v2558 (:hsm-client-certificate-identifier m2557)]
    (.
     bean2556
     setHsmClientCertificateIdentifier
     (clojure.core/str v2558)))
   (clojure.core/when-let
    [v2558 (:cluster-parameter-group-name m2557)]
    (. bean2556 setClusterParameterGroupName (clojure.core/str v2558)))
   (clojure.core/when-let
    [v2558 (:elastic-ip m2557)]
    (. bean2556 setElasticIp (clojure.core/str v2558)))
   (clojure.core/when-let
    [v2558 (:owner-account m2557)]
    (. bean2556 setOwnerAccount (clojure.core/str v2558)))
   (clojure.core/when-let
    [v2558 (:snapshot-cluster-identifier m2557)]
    (. bean2556 setSnapshotClusterIdentifier (clojure.core/str v2558)))
   (clojure.core/when-let
    [v2558 (:hsm-configuration-identifier m2557)]
    (.
     bean2556
     setHsmConfigurationIdentifier
     (clojure.core/str v2558)))
   bean2556))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.RevokeSnapshotAccessRequest}
revoke-snapshot-access-request
  [m2560]
  (clojure.core/let
   [bean2559
    (new
     com.amazonaws.services.redshift.model.RevokeSnapshotAccessRequest)]
   (clojure.core/when-let
    [v2561 (:snapshot-identifier m2560)]
    (. bean2559 setSnapshotIdentifier (clojure.core/str v2561)))
   (clojure.core/when-let
    [v2561 (:snapshot-cluster-identifier m2560)]
    (. bean2559 setSnapshotClusterIdentifier (clojure.core/str v2561)))
   (clojure.core/when-let
    [v2561 (:account-with-restore-access m2560)]
    (. bean2559 setAccountWithRestoreAccess (clojure.core/str v2561)))
   bean2559))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.RotateEncryptionKeyRequest}
rotate-encryption-key-request
  [m2563]
  (clojure.core/let
   [bean2562
    (new
     com.amazonaws.services.redshift.model.RotateEncryptionKeyRequest)]
   (clojure.core/when-let
    [v2564 (:cluster-identifier m2563)]
    (. bean2562 setClusterIdentifier (clojure.core/str v2564)))
   bean2562))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DisableLoggingRequest}
disable-logging-request
  [m2566]
  (clojure.core/let
   [bean2565
    (new com.amazonaws.services.redshift.model.DisableLoggingRequest)]
   (clojure.core/when-let
    [v2567 (:cluster-identifier m2566)]
    (. bean2565 setClusterIdentifier (clojure.core/str v2567)))
   bean2565))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DeleteClusterSecurityGroupRequest}
delete-cluster-security-group-request
  [m2569]
  (clojure.core/let
   [bean2568
    (new
     com.amazonaws.services.redshift.model.DeleteClusterSecurityGroupRequest)]
   (clojure.core/when-let
    [v2570 (:cluster-security-group-name m2569)]
    (. bean2568 setClusterSecurityGroupName (clojure.core/str v2570)))
   bean2568))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeClusterParametersRequest}
describe-cluster-parameters-request
  [m2572]
  (clojure.core/let
   [bean2571
    (new
     com.amazonaws.services.redshift.model.DescribeClusterParametersRequest)]
   (clojure.core/when-let
    [v2573 (:marker m2572)]
    (. bean2571 setMarker (clojure.core/str v2573)))
   (clojure.core/when-let
    [v2573 (:max-records m2572)]
    (. bean2571 setMaxRecords (clojure.core/int v2573)))
   (clojure.core/when-let
    [v2573 (:parameter-group-name m2572)]
    (. bean2571 setParameterGroupName (clojure.core/str v2573)))
   (clojure.core/when-let
    [v2573 (:source m2572)]
    (. bean2571 setSource (clojure.core/str v2573)))
   bean2571))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.CreateEventSubscriptionRequest}
create-event-subscription-request
  [m2575]
  (clojure.core/let
   [bean2574
    (new
     com.amazonaws.services.redshift.model.CreateEventSubscriptionRequest)]
   (clojure.core/when-let
    [v2576 (:source-type m2575)]
    (. bean2574 setSourceType (clojure.core/str v2576)))
   (clojure.core/when-let
    [v2576 (:subscription-name m2575)]
    (. bean2574 setSubscriptionName (clojure.core/str v2576)))
   (clojure.core/when-let
    [v2576 (:sns-topic-arn m2575)]
    (. bean2574 setSnsTopicArn (clojure.core/str v2576)))
   (clojure.core/when-let
    [v2576 (:source-ids m2575)]
    (.
     bean2574
     setSourceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2695] (clojure.core/str arg2695))
 v2576)))
   (clojure.core/when-let
    [v2576 (:event-categories m2575)]
    (.
     bean2574
     setEventCategories
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2696] (clojure.core/str arg2696))
 v2576)))
   (clojure.core/when-let
    [v2576 (:severity m2575)]
    (. bean2574 setSeverity (clojure.core/str v2576)))
   (clojure.core/when-let
    [v2576 (:enabled m2575)]
    (. bean2574 setEnabled (clojure.core/boolean v2576)))
   bean2574))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.ResetClusterParameterGroupRequest}
reset-cluster-parameter-group-request
  [m2578]
  (clojure.core/let
   [bean2577
    (new
     com.amazonaws.services.redshift.model.ResetClusterParameterGroupRequest)]
   (clojure.core/when-let
    [v2579 (:parameter-group-name m2578)]
    (. bean2577 setParameterGroupName (clojure.core/str v2579)))
   (clojure.core/when-let
    [v2579 (:reset-all-parameters m2578)]
    (. bean2577 setResetAllParameters (clojure.core/boolean v2579)))
   (clojure.core/when-let
    [v2579 (:parameters m2578)]
    (.
     bean2577
     setParameters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2697] (redshift/parameter arg2697))
 v2579)))
   bean2577))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.CreateClusterParameterGroupRequest}
create-cluster-parameter-group-request
  [m2581]
  (clojure.core/let
   [bean2580
    (new
     com.amazonaws.services.redshift.model.CreateClusterParameterGroupRequest)]
   (clojure.core/when-let
    [v2582 (:parameter-group-family m2581)]
    (. bean2580 setParameterGroupFamily (clojure.core/str v2582)))
   (clojure.core/when-let
    [v2582 (:parameter-group-name m2581)]
    (. bean2580 setParameterGroupName (clojure.core/str v2582)))
   (clojure.core/when-let
    [v2582 (:description m2581)]
    (. bean2580 setDescription (clojure.core/str v2582)))
   bean2580))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DeleteHsmConfigurationRequest}
delete-hsm-configuration-request
  [m2584]
  (clojure.core/let
   [bean2583
    (new
     com.amazonaws.services.redshift.model.DeleteHsmConfigurationRequest)]
   (clojure.core/when-let
    [v2585 (:hsm-configuration-identifier m2584)]
    (.
     bean2583
     setHsmConfigurationIdentifier
     (clojure.core/str v2585)))
   bean2583))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.ModifyEventSubscriptionRequest}
modify-event-subscription-request
  [m2587]
  (clojure.core/let
   [bean2586
    (new
     com.amazonaws.services.redshift.model.ModifyEventSubscriptionRequest)]
   (clojure.core/when-let
    [v2588 (:source-type m2587)]
    (. bean2586 setSourceType (clojure.core/str v2588)))
   (clojure.core/when-let
    [v2588 (:subscription-name m2587)]
    (. bean2586 setSubscriptionName (clojure.core/str v2588)))
   (clojure.core/when-let
    [v2588 (:sns-topic-arn m2587)]
    (. bean2586 setSnsTopicArn (clojure.core/str v2588)))
   (clojure.core/when-let
    [v2588 (:source-ids m2587)]
    (.
     bean2586
     setSourceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2698] (clojure.core/str arg2698))
 v2588)))
   (clojure.core/when-let
    [v2588 (:event-categories m2587)]
    (.
     bean2586
     setEventCategories
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2699] (clojure.core/str arg2699))
 v2588)))
   (clojure.core/when-let
    [v2588 (:severity m2587)]
    (. bean2586 setSeverity (clojure.core/str v2588)))
   (clojure.core/when-let
    [v2588 (:enabled m2587)]
    (. bean2586 setEnabled (clojure.core/boolean v2588)))
   bean2586))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeReservedNodesRequest}
describe-reserved-nodes-request
  [m2590]
  (clojure.core/let
   [bean2589
    (new
     com.amazonaws.services.redshift.model.DescribeReservedNodesRequest)]
   (clojure.core/when-let
    [v2591 (:marker m2590)]
    (. bean2589 setMarker (clojure.core/str v2591)))
   (clojure.core/when-let
    [v2591 (:max-records m2590)]
    (. bean2589 setMaxRecords (clojure.core/int v2591)))
   (clojure.core/when-let
    [v2591 (:reserved-node-id m2590)]
    (. bean2589 setReservedNodeId (clojure.core/str v2591)))
   bean2589))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.CopyClusterSnapshotRequest}
copy-cluster-snapshot-request
  [m2593]
  (clojure.core/let
   [bean2592
    (new
     com.amazonaws.services.redshift.model.CopyClusterSnapshotRequest)]
   (clojure.core/when-let
    [v2594 (:source-snapshot-identifier m2593)]
    (. bean2592 setSourceSnapshotIdentifier (clojure.core/str v2594)))
   (clojure.core/when-let
    [v2594 (:source-snapshot-cluster-identifier m2593)]
    (.
     bean2592
     setSourceSnapshotClusterIdentifier
     (clojure.core/str v2594)))
   (clojure.core/when-let
    [v2594 (:target-snapshot-identifier m2593)]
    (. bean2592 setTargetSnapshotIdentifier (clojure.core/str v2594)))
   bean2592))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DeleteHsmClientCertificateRequest}
delete-hsm-client-certificate-request
  [m2596]
  (clojure.core/let
   [bean2595
    (new
     com.amazonaws.services.redshift.model.DeleteHsmClientCertificateRequest)]
   (clojure.core/when-let
    [v2597 (:hsm-client-certificate-identifier m2596)]
    (.
     bean2595
     setHsmClientCertificateIdentifier
     (clojure.core/str v2597)))
   bean2595))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.ModifyClusterSubnetGroupRequest}
modify-cluster-subnet-group-request
  [m2599]
  (clojure.core/let
   [bean2598
    (new
     com.amazonaws.services.redshift.model.ModifyClusterSubnetGroupRequest)]
   (clojure.core/when-let
    [v2600 (:cluster-subnet-group-name m2599)]
    (. bean2598 setClusterSubnetGroupName (clojure.core/str v2600)))
   (clojure.core/when-let
    [v2600 (:subnet-ids m2599)]
    (.
     bean2598
     setSubnetIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2700] (clojure.core/str arg2700))
 v2600)))
   (clojure.core/when-let
    [v2600 (:description m2599)]
    (. bean2598 setDescription (clojure.core/str v2600)))
   bean2598))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeLoggingStatusRequest}
describe-logging-status-request
  [m2602]
  (clojure.core/let
   [bean2601
    (new
     com.amazonaws.services.redshift.model.DescribeLoggingStatusRequest)]
   (clojure.core/when-let
    [v2603 (:cluster-identifier m2602)]
    (. bean2601 setClusterIdentifier (clojure.core/str v2603)))
   bean2601))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeEventsRequest}
describe-events-request
  [m2605]
  (clojure.core/let
   [bean2604
    (new com.amazonaws.services.redshift.model.DescribeEventsRequest)]
   (clojure.core/when-let
    [v2606 (:marker m2605)]
    (. bean2604 setMarker (clojure.core/str v2606)))
   (clojure.core/when-let
    [v2606 (:max-records m2605)]
    (. bean2604 setMaxRecords (clojure.core/int v2606)))
   (clojure.core/when-let
    [v2606 (:source-identifier m2605)]
    (. bean2604 setSourceIdentifier (clojure.core/str v2606)))
   (clojure.core/when-let
    [v2606 (:source-type m2605)]
    (. bean2604 setSourceType (redshift/source-type v2606)))
   (clojure.core/when-let
    [v2606 (:start-time m2605)]
    (.
     bean2604
     setStartTime
     (com.palletops.awaze.common/to-date v2606)))
   (clojure.core/when-let
    [v2606 (:end-time m2605)]
    (. bean2604 setEndTime (com.palletops.awaze.common/to-date v2606)))
   (clojure.core/when-let
    [v2606 (:duration m2605)]
    (. bean2604 setDuration (clojure.core/int v2606)))
   bean2604))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DeleteClusterParameterGroupRequest}
delete-cluster-parameter-group-request
  [m2608]
  (clojure.core/let
   [bean2607
    (new
     com.amazonaws.services.redshift.model.DeleteClusterParameterGroupRequest)]
   (clojure.core/when-let
    [v2609 (:parameter-group-name m2608)]
    (. bean2607 setParameterGroupName (clojure.core/str v2609)))
   bean2607))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.AuthorizeClusterSecurityGroupIngressRequest}
authorize-cluster-security-group-ingress-request
  [m2611]
  (clojure.core/let
   [bean2610
    (new
     com.amazonaws.services.redshift.model.AuthorizeClusterSecurityGroupIngressRequest)]
   (clojure.core/when-let
    [v2612 (:cluster-security-group-name m2611)]
    (. bean2610 setClusterSecurityGroupName (clojure.core/str v2612)))
   (clojure.core/when-let
    [v2612 (:cidrip m2611)]
    (. bean2610 setCIDRIP (clojure.core/str v2612)))
   (clojure.core/when-let
    [v2612 (:ec2security-group-name m2611)]
    (. bean2610 setEC2SecurityGroupName (clojure.core/str v2612)))
   (clojure.core/when-let
    [v2612 (:ec2security-group-owner-id m2611)]
    (. bean2610 setEC2SecurityGroupOwnerId (clojure.core/str v2612)))
   bean2610))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.ModifyClusterRequest}
modify-cluster-request
  [m2614]
  (clojure.core/let
   [bean2613
    (new com.amazonaws.services.redshift.model.ModifyClusterRequest)]
   (clojure.core/when-let
    [v2615 (:vpc-security-group-ids m2614)]
    (.
     bean2613
     setVpcSecurityGroupIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2701] (clojure.core/str arg2701))
 v2615)))
   (clojure.core/when-let
    [v2615 (:cluster-version m2614)]
    (. bean2613 setClusterVersion (clojure.core/str v2615)))
   (clojure.core/when-let
    [v2615 (:cluster-identifier m2614)]
    (. bean2613 setClusterIdentifier (clojure.core/str v2615)))
   (clojure.core/when-let
    [v2615 (:preferred-maintenance-window m2614)]
    (.
     bean2613
     setPreferredMaintenanceWindow
     (clojure.core/str v2615)))
   (clojure.core/when-let
    [v2615 (:new-cluster-identifier m2614)]
    (. bean2613 setNewClusterIdentifier (clojure.core/str v2615)))
   (clojure.core/when-let
    [v2615 (:master-user-password m2614)]
    (. bean2613 setMasterUserPassword (clojure.core/str v2615)))
   (clojure.core/when-let
    [v2615 (:allow-version-upgrade m2614)]
    (. bean2613 setAllowVersionUpgrade (clojure.core/boolean v2615)))
   (clojure.core/when-let
    [v2615 (:cluster-security-groups m2614)]
    (.
     bean2613
     setClusterSecurityGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2702] (clojure.core/str arg2702))
 v2615)))
   (clojure.core/when-let
    [v2615 (:automated-snapshot-retention-period m2614)]
    (.
     bean2613
     setAutomatedSnapshotRetentionPeriod
     (clojure.core/int v2615)))
   (clojure.core/when-let
    [v2615 (:number-of-nodes m2614)]
    (. bean2613 setNumberOfNodes (clojure.core/int v2615)))
   (clojure.core/when-let
    [v2615 (:cluster-type m2614)]
    (. bean2613 setClusterType (clojure.core/str v2615)))
   (clojure.core/when-let
    [v2615 (:hsm-client-certificate-identifier m2614)]
    (.
     bean2613
     setHsmClientCertificateIdentifier
     (clojure.core/str v2615)))
   (clojure.core/when-let
    [v2615 (:cluster-parameter-group-name m2614)]
    (. bean2613 setClusterParameterGroupName (clojure.core/str v2615)))
   (clojure.core/when-let
    [v2615 (:node-type m2614)]
    (. bean2613 setNodeType (clojure.core/str v2615)))
   (clojure.core/when-let
    [v2615 (:hsm-configuration-identifier m2614)]
    (.
     bean2613
     setHsmConfigurationIdentifier
     (clojure.core/str v2615)))
   bean2613))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DeleteClusterSubnetGroupRequest}
delete-cluster-subnet-group-request
  [m2617]
  (clojure.core/let
   [bean2616
    (new
     com.amazonaws.services.redshift.model.DeleteClusterSubnetGroupRequest)]
   (clojure.core/when-let
    [v2618 (:cluster-subnet-group-name m2617)]
    (. bean2616 setClusterSubnetGroupName (clojure.core/str v2618)))
   bean2616))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.CreateClusterSubnetGroupRequest}
create-cluster-subnet-group-request
  [m2620]
  (clojure.core/let
   [bean2619
    (new
     com.amazonaws.services.redshift.model.CreateClusterSubnetGroupRequest)]
   (clojure.core/when-let
    [v2621 (:cluster-subnet-group-name m2620)]
    (. bean2619 setClusterSubnetGroupName (clojure.core/str v2621)))
   (clojure.core/when-let
    [v2621 (:subnet-ids m2620)]
    (.
     bean2619
     setSubnetIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2703] (clojure.core/str arg2703))
 v2621)))
   (clojure.core/when-let
    [v2621 (:description m2620)]
    (. bean2619 setDescription (clojure.core/str v2621)))
   bean2619))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.PurchaseReservedNodeOfferingRequest}
purchase-reserved-node-offering-request
  [m2623]
  (clojure.core/let
   [bean2622
    (new
     com.amazonaws.services.redshift.model.PurchaseReservedNodeOfferingRequest)]
   (clojure.core/when-let
    [v2624 (:reserved-node-offering-id m2623)]
    (. bean2622 setReservedNodeOfferingId (clojure.core/str v2624)))
   (clojure.core/when-let
    [v2624 (:node-count m2623)]
    (. bean2622 setNodeCount (clojure.core/int v2624)))
   bean2622))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeReservedNodeOfferingsRequest}
describe-reserved-node-offerings-request
  [m2626]
  (clojure.core/let
   [bean2625
    (new
     com.amazonaws.services.redshift.model.DescribeReservedNodeOfferingsRequest)]
   (clojure.core/when-let
    [v2627 (:marker m2626)]
    (. bean2625 setMarker (clojure.core/str v2627)))
   (clojure.core/when-let
    [v2627 (:reserved-node-offering-id m2626)]
    (. bean2625 setReservedNodeOfferingId (clojure.core/str v2627)))
   (clojure.core/when-let
    [v2627 (:max-records m2626)]
    (. bean2625 setMaxRecords (clojure.core/int v2627)))
   bean2625))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DeleteClusterRequest}
delete-cluster-request
  [m2629]
  (clojure.core/let
   [bean2628
    (new com.amazonaws.services.redshift.model.DeleteClusterRequest)]
   (clojure.core/when-let
    [v2630 (:cluster-identifier m2629)]
    (. bean2628 setClusterIdentifier (clojure.core/str v2630)))
   (clojure.core/when-let
    [v2630 (:skip-final-cluster-snapshot m2629)]
    (.
     bean2628
     setSkipFinalClusterSnapshot
     (clojure.core/boolean v2630)))
   (clojure.core/when-let
    [v2630 (:final-cluster-snapshot-identifier m2629)]
    (.
     bean2628
     setFinalClusterSnapshotIdentifier
     (clojure.core/str v2630)))
   bean2628))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.CreateClusterSecurityGroupRequest}
create-cluster-security-group-request
  [m2632]
  (clojure.core/let
   [bean2631
    (new
     com.amazonaws.services.redshift.model.CreateClusterSecurityGroupRequest)]
   (clojure.core/when-let
    [v2633 (:cluster-security-group-name m2632)]
    (. bean2631 setClusterSecurityGroupName (clojure.core/str v2633)))
   (clojure.core/when-let
    [v2633 (:description m2632)]
    (. bean2631 setDescription (clojure.core/str v2633)))
   bean2631))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeEventSubscriptionsRequest}
describe-event-subscriptions-request
  [m2635]
  (clojure.core/let
   [bean2634
    (new
     com.amazonaws.services.redshift.model.DescribeEventSubscriptionsRequest)]
   (clojure.core/when-let
    [v2636 (:marker m2635)]
    (. bean2634 setMarker (clojure.core/str v2636)))
   (clojure.core/when-let
    [v2636 (:max-records m2635)]
    (. bean2634 setMaxRecords (clojure.core/int v2636)))
   (clojure.core/when-let
    [v2636 (:subscription-name m2635)]
    (. bean2634 setSubscriptionName (clojure.core/str v2636)))
   bean2634))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeDefaultClusterParametersRequest}
describe-default-cluster-parameters-request
  [m2638]
  (clojure.core/let
   [bean2637
    (new
     com.amazonaws.services.redshift.model.DescribeDefaultClusterParametersRequest)]
   (clojure.core/when-let
    [v2639 (:marker m2638)]
    (. bean2637 setMarker (clojure.core/str v2639)))
   (clojure.core/when-let
    [v2639 (:max-records m2638)]
    (. bean2637 setMaxRecords (clojure.core/int v2639)))
   (clojure.core/when-let
    [v2639 (:parameter-group-family m2638)]
    (. bean2637 setParameterGroupFamily (clojure.core/str v2639)))
   bean2637))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeHsmConfigurationsRequest}
describe-hsm-configurations-request
  [m2641]
  (clojure.core/let
   [bean2640
    (new
     com.amazonaws.services.redshift.model.DescribeHsmConfigurationsRequest)]
   (clojure.core/when-let
    [v2642 (:marker m2641)]
    (. bean2640 setMarker (clojure.core/str v2642)))
   (clojure.core/when-let
    [v2642 (:hsm-configuration-identifier m2641)]
    (.
     bean2640
     setHsmConfigurationIdentifier
     (clojure.core/str v2642)))
   (clojure.core/when-let
    [v2642 (:max-records m2641)]
    (. bean2640 setMaxRecords (clojure.core/int v2642)))
   bean2640))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.CreateClusterSnapshotRequest}
create-cluster-snapshot-request
  [m2644]
  (clojure.core/let
   [bean2643
    (new
     com.amazonaws.services.redshift.model.CreateClusterSnapshotRequest)]
   (clojure.core/when-let
    [v2645 (:snapshot-identifier m2644)]
    (. bean2643 setSnapshotIdentifier (clojure.core/str v2645)))
   (clojure.core/when-let
    [v2645 (:cluster-identifier m2644)]
    (. bean2643 setClusterIdentifier (clojure.core/str v2645)))
   bean2643))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeClusterVersionsRequest}
describe-cluster-versions-request
  [m2647]
  (clojure.core/let
   [bean2646
    (new
     com.amazonaws.services.redshift.model.DescribeClusterVersionsRequest)]
   (clojure.core/when-let
    [v2648 (:marker m2647)]
    (. bean2646 setMarker (clojure.core/str v2648)))
   (clojure.core/when-let
    [v2648 (:cluster-version m2647)]
    (. bean2646 setClusterVersion (clojure.core/str v2648)))
   (clojure.core/when-let
    [v2648 (:max-records m2647)]
    (. bean2646 setMaxRecords (clojure.core/int v2648)))
   (clojure.core/when-let
    [v2648 (:cluster-parameter-group-family m2647)]
    (.
     bean2646
     setClusterParameterGroupFamily
     (clojure.core/str v2648)))
   bean2646))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DisableSnapshotCopyRequest}
disable-snapshot-copy-request
  [m2650]
  (clojure.core/let
   [bean2649
    (new
     com.amazonaws.services.redshift.model.DisableSnapshotCopyRequest)]
   (clojure.core/when-let
    [v2651 (:cluster-identifier m2650)]
    (. bean2649 setClusterIdentifier (clojure.core/str v2651)))
   bean2649))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DeleteEventSubscriptionRequest}
delete-event-subscription-request
  [m2653]
  (clojure.core/let
   [bean2652
    (new
     com.amazonaws.services.redshift.model.DeleteEventSubscriptionRequest)]
   (clojure.core/when-let
    [v2654 (:subscription-name m2653)]
    (. bean2652 setSubscriptionName (clojure.core/str v2654)))
   bean2652))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.ModifySnapshotCopyRetentionPeriodRequest}
modify-snapshot-copy-retention-period-request
  [m2656]
  (clojure.core/let
   [bean2655
    (new
     com.amazonaws.services.redshift.model.ModifySnapshotCopyRetentionPeriodRequest)]
   (clojure.core/when-let
    [v2657 (:cluster-identifier m2656)]
    (. bean2655 setClusterIdentifier (clojure.core/str v2657)))
   (clojure.core/when-let
    [v2657 (:retention-period m2656)]
    (. bean2655 setRetentionPeriod (clojure.core/int v2657)))
   bean2655))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.RebootClusterRequest}
reboot-cluster-request
  [m2659]
  (clojure.core/let
   [bean2658
    (new com.amazonaws.services.redshift.model.RebootClusterRequest)]
   (clojure.core/when-let
    [v2660 (:cluster-identifier m2659)]
    (. bean2658 setClusterIdentifier (clojure.core/str v2660)))
   bean2658))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeResizeRequest}
describe-resize-request
  [m2662]
  (clojure.core/let
   [bean2661
    (new com.amazonaws.services.redshift.model.DescribeResizeRequest)]
   (clojure.core/when-let
    [v2663 (:cluster-identifier m2662)]
    (. bean2661 setClusterIdentifier (clojure.core/str v2663)))
   bean2661))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.RevokeClusterSecurityGroupIngressRequest}
revoke-cluster-security-group-ingress-request
  [m2665]
  (clojure.core/let
   [bean2664
    (new
     com.amazonaws.services.redshift.model.RevokeClusterSecurityGroupIngressRequest)]
   (clojure.core/when-let
    [v2666 (:cluster-security-group-name m2665)]
    (. bean2664 setClusterSecurityGroupName (clojure.core/str v2666)))
   (clojure.core/when-let
    [v2666 (:cidrip m2665)]
    (. bean2664 setCIDRIP (clojure.core/str v2666)))
   (clojure.core/when-let
    [v2666 (:ec2security-group-name m2665)]
    (. bean2664 setEC2SecurityGroupName (clojure.core/str v2666)))
   (clojure.core/when-let
    [v2666 (:ec2security-group-owner-id m2665)]
    (. bean2664 setEC2SecurityGroupOwnerId (clojure.core/str v2666)))
   bean2664))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.ModifyClusterParameterGroupRequest}
modify-cluster-parameter-group-request
  [m2668]
  (clojure.core/let
   [bean2667
    (new
     com.amazonaws.services.redshift.model.ModifyClusterParameterGroupRequest)]
   (clojure.core/when-let
    [v2669 (:parameter-group-name m2668)]
    (. bean2667 setParameterGroupName (clojure.core/str v2669)))
   (clojure.core/when-let
    [v2669 (:parameters m2668)]
    (.
     bean2667
     setParameters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2704] (redshift/parameter arg2704))
 v2669)))
   bean2667))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeHsmClientCertificatesRequest}
describe-hsm-client-certificates-request
  [m2671]
  (clojure.core/let
   [bean2670
    (new
     com.amazonaws.services.redshift.model.DescribeHsmClientCertificatesRequest)]
   (clojure.core/when-let
    [v2672 (:marker m2671)]
    (. bean2670 setMarker (clojure.core/str v2672)))
   (clojure.core/when-let
    [v2672 (:hsm-client-certificate-identifier m2671)]
    (.
     bean2670
     setHsmClientCertificateIdentifier
     (clojure.core/str v2672)))
   (clojure.core/when-let
    [v2672 (:max-records m2671)]
    (. bean2670 setMaxRecords (clojure.core/int v2672)))
   bean2670))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.CreateHsmClientCertificateRequest}
create-hsm-client-certificate-request
  [m2674]
  (clojure.core/let
   [bean2673
    (new
     com.amazonaws.services.redshift.model.CreateHsmClientCertificateRequest)]
   (clojure.core/when-let
    [v2675 (:hsm-client-certificate-identifier m2674)]
    (.
     bean2673
     setHsmClientCertificateIdentifier
     (clojure.core/str v2675)))
   bean2673))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeEventCategoriesRequest}
describe-event-categories-request
  [m2677]
  (clojure.core/let
   [bean2676
    (new
     com.amazonaws.services.redshift.model.DescribeEventCategoriesRequest)]
   (clojure.core/when-let
    [v2678 (:source-type m2677)]
    (. bean2676 setSourceType (clojure.core/str v2678)))
   bean2676))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.CreateHsmConfigurationRequest}
create-hsm-configuration-request
  [m2680]
  (clojure.core/let
   [bean2679
    (new
     com.amazonaws.services.redshift.model.CreateHsmConfigurationRequest)]
   (clojure.core/when-let
    [v2681 (:hsm-configuration-identifier m2680)]
    (.
     bean2679
     setHsmConfigurationIdentifier
     (clojure.core/str v2681)))
   (clojure.core/when-let
    [v2681 (:hsm-ip-address m2680)]
    (. bean2679 setHsmIpAddress (clojure.core/str v2681)))
   (clojure.core/when-let
    [v2681 (:hsm-partition-name m2680)]
    (. bean2679 setHsmPartitionName (clojure.core/str v2681)))
   (clojure.core/when-let
    [v2681 (:hsm-partition-password m2680)]
    (. bean2679 setHsmPartitionPassword (clojure.core/str v2681)))
   (clojure.core/when-let
    [v2681 (:hsm-server-public-certificate m2680)]
    (.
     bean2679
     setHsmServerPublicCertificate
     (clojure.core/str v2681)))
   (clojure.core/when-let
    [v2681 (:description m2680)]
    (. bean2679 setDescription (clojure.core/str v2681)))
   bean2679))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeClusterSnapshotsRequest}
describe-cluster-snapshots-request
  [m2683]
  (clojure.core/let
   [bean2682
    (new
     com.amazonaws.services.redshift.model.DescribeClusterSnapshotsRequest)]
   (clojure.core/when-let
    [v2684 (:marker m2683)]
    (. bean2682 setMarker (clojure.core/str v2684)))
   (clojure.core/when-let
    [v2684 (:snapshot-identifier m2683)]
    (. bean2682 setSnapshotIdentifier (clojure.core/str v2684)))
   (clojure.core/when-let
    [v2684 (:cluster-identifier m2683)]
    (. bean2682 setClusterIdentifier (clojure.core/str v2684)))
   (clojure.core/when-let
    [v2684 (:max-records m2683)]
    (. bean2682 setMaxRecords (clojure.core/int v2684)))
   (clojure.core/when-let
    [v2684 (:start-time m2683)]
    (.
     bean2682
     setStartTime
     (com.palletops.awaze.common/to-date v2684)))
   (clojure.core/when-let
    [v2684 (:end-time m2683)]
    (. bean2682 setEndTime (com.palletops.awaze.common/to-date v2684)))
   (clojure.core/when-let
    [v2684 (:owner-account m2683)]
    (. bean2682 setOwnerAccount (clojure.core/str v2684)))
   (clojure.core/when-let
    [v2684 (:snapshot-type m2683)]
    (. bean2682 setSnapshotType (clojure.core/str v2684)))
   bean2682))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DeleteClusterSnapshotRequest}
delete-cluster-snapshot-request
  [m2686]
  (clojure.core/let
   [bean2685
    (new
     com.amazonaws.services.redshift.model.DeleteClusterSnapshotRequest)]
   (clojure.core/when-let
    [v2687 (:snapshot-identifier m2686)]
    (. bean2685 setSnapshotIdentifier (clojure.core/str v2687)))
   (clojure.core/when-let
    [v2687 (:snapshot-cluster-identifier m2686)]
    (. bean2685 setSnapshotClusterIdentifier (clojure.core/str v2687)))
   bean2685))
 (clojure.core/defn
^{:tag com.amazonaws.services.redshift.model.DescribeOrderableClusterOptionsRequest}
describe-orderable-cluster-options-request
  [m2689]
  (clojure.core/let
   [bean2688
    (new
     com.amazonaws.services.redshift.model.DescribeOrderableClusterOptionsRequest)]
   (clojure.core/when-let
    [v2690 (:marker m2689)]
    (. bean2688 setMarker (clojure.core/str v2690)))
   (clojure.core/when-let
    [v2690 (:node-type m2689)]
    (. bean2688 setNodeType (clojure.core/str v2690)))
   (clojure.core/when-let
    [v2690 (:cluster-version m2689)]
    (. bean2688 setClusterVersion (clojure.core/str v2690)))
   (clojure.core/when-let
    [v2690 (:max-records m2689)]
    (. bean2688 setMaxRecords (clojure.core/int v2690)))
   bean2688))
 (clojure.core/defmulti
  redshift
  (clojure.core/fn redshift [m__1683__auto__] (:fn m__1683__auto__)))
 (do
  (clojure.core/defmethod
   redshift
   :describe-cluster-security-groups
   [m2705]
   (clojure.core/let
    [credentials2706 (:credentials m2705) args2707 (:args m2705)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client2708
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2706)]
     (clojure.core/case
      (clojure.core/count args2707)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2708
        describeClusterSecurityGroups))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2708
        describeClusterSecurityGroups
        (redshift/describe-cluster-security-groups-request
         (clojure.core/nth args2707 0))))))))
  (clojure.core/defn
   describe-cluster-security-groups-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [max-records
                         marker
                         general-progress-listener
                         cluster-security-group-name]}]]),
    :doc "Generate map for describeClusterSecurityGroups, describeClusterSecurityGroups"}
   ([credentials__1651__auto__]
    {:args [],
     :client :redshift,
     :fn :describe-cluster-security-groups,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :describe-cluster-security-groups,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-cluster-security-groups
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [max-records
                         marker
                         general-progress-listener
                         cluster-security-group-name]}]]),
    :doc "Call describeClusterSecurityGroups, describeClusterSecurityGroups"}
   [credentials2710 & args2711]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client2712
     (com.palletops.awaze.common/aws-client :redshift credentials2710)]
    (clojure.core/case
     (clojure.core/count args2711)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2712
       describeClusterSecurityGroups))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2712
       describeClusterSecurityGroups
       (redshift/describe-cluster-security-groups-request
        (clojure.core/nth args2711 0))))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-cluster-parameter-groups
   [m2713]
   (clojure.core/let
    [credentials2714 (:credentials m2713) args2715 (:args m2713)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client2716
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2714)]
     (clojure.core/case
      (clojure.core/count args2715)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2716
        describeClusterParameterGroups))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2716
        describeClusterParameterGroups
        (redshift/describe-cluster-parameter-groups-request
         (clojure.core/nth args2715 0))))))))
  (clojure.core/defn
   describe-cluster-parameter-groups-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [parameter-group-name
                         max-records
                         marker
                         general-progress-listener]}]]),
    :doc "Generate map for describeClusterParameterGroups, describeClusterParameterGroups"}
   ([credentials__1651__auto__]
    {:args [],
     :client :redshift,
     :fn :describe-cluster-parameter-groups,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :describe-cluster-parameter-groups,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-cluster-parameter-groups
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [parameter-group-name
                         max-records
                         marker
                         general-progress-listener]}]]),
    :doc "Call describeClusterParameterGroups, describeClusterParameterGroups"}
   [credentials2718 & args2719]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client2720
     (com.palletops.awaze.common/aws-client :redshift credentials2718)]
    (clojure.core/case
     (clojure.core/count args2719)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2720
       describeClusterParameterGroups))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2720
       describeClusterParameterGroups
       (redshift/describe-cluster-parameter-groups-request
        (clojure.core/nth args2719 0))))))))
 (do
  (clojure.core/defmethod
   redshift
   :enable-snapshot-copy
   [m2721]
   (clojure.core/let
    [credentials2722 (:credentials m2721) args2723 (:args m2721)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client2724
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2722)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2724
       enableSnapshotCopy
       (redshift/enable-snapshot-copy-request
        (clojure.core/nth args2723 0)))))))
  (clojure.core/defn
   enable-snapshot-copy-map
   {:arglists (quote
               [[credentials
                 {:keys [retention-period
                         general-progress-listener
                         destination-region
                         cluster-identifier]}]]),
    :doc "Generate map for enableSnapshotCopy"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :enable-snapshot-copy,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   enable-snapshot-copy
   {:arglists (quote
               [[credentials
                 {:keys [retention-period
                         general-progress-listener
                         destination-region
                         cluster-identifier]}]]),
    :doc "Call enableSnapshotCopy"}
   [credentials2726 & args2727]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client2728
     (com.palletops.awaze.common/aws-client :redshift credentials2726)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2728
      enableSnapshotCopy
      (redshift/enable-snapshot-copy-request
       (clojure.core/nth args2727 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :create-cluster
   [m2729]
   (clojure.core/let
    [credentials2730 (:credentials m2729) args2731 (:args m2729)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client2732
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2730)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2732
       createCluster
       (redshift/create-cluster-request (clojure.core/nth args2731 0)))))))
  (clojure.core/defn
   create-cluster-map
   {:arglists (quote
               [[credentials
                 {:keys [node-type
                         hsm-client-certificate-identifier
                         cluster-type
                         publicly-accessible
                         cluster-security-groups
                         general-progress-listener
                         automated-snapshot-retention-period
                         cluster-identifier
                         encrypted
                         availability-zone
                         preferred-maintenance-window
                         hsm-configuration-identifier
                         master-username
                         dbname
                         cluster-parameter-group-name
                         master-user-password
                         number-of-nodes
                         vpc-security-group-ids
                         port
                         elastic-ip
                         cluster-version
                         cluster-subnet-group-name
                         allow-version-upgrade]}]]),
    :doc "Generate map for createCluster"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :create-cluster,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-cluster
   {:arglists (quote
               [[credentials
                 {:keys [node-type
                         hsm-client-certificate-identifier
                         cluster-type
                         publicly-accessible
                         cluster-security-groups
                         general-progress-listener
                         automated-snapshot-retention-period
                         cluster-identifier
                         encrypted
                         availability-zone
                         preferred-maintenance-window
                         hsm-configuration-identifier
                         master-username
                         dbname
                         cluster-parameter-group-name
                         master-user-password
                         number-of-nodes
                         vpc-security-group-ids
                         port
                         elastic-ip
                         cluster-version
                         cluster-subnet-group-name
                         allow-version-upgrade]}]]),
    :doc "Call createCluster"}
   [credentials2734 & args2735]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client2736
     (com.palletops.awaze.common/aws-client :redshift credentials2734)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2736
      createCluster
      (redshift/create-cluster-request (clojure.core/nth args2735 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :authorize-snapshot-access
   [m2737]
   (clojure.core/let
    [credentials2738 (:credentials m2737) args2739 (:args m2737)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client2740
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2738)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2740
       authorizeSnapshotAccess
       (redshift/authorize-snapshot-access-request
        (clojure.core/nth args2739 0)))))))
  (clojure.core/defn
   authorize-snapshot-access-map
   {:arglists (quote
               [[credentials
                 {:keys [snapshot-identifier
                         snapshot-cluster-identifier
                         general-progress-listener
                         account-with-restore-access]}]]),
    :doc "Generate map for authorizeSnapshotAccess"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :authorize-snapshot-access,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   authorize-snapshot-access
   {:arglists (quote
               [[credentials
                 {:keys [snapshot-identifier
                         snapshot-cluster-identifier
                         general-progress-listener
                         account-with-restore-access]}]]),
    :doc "Call authorizeSnapshotAccess"}
   [credentials2742 & args2743]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client2744
     (com.palletops.awaze.common/aws-client :redshift credentials2742)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2744
      authorizeSnapshotAccess
      (redshift/authorize-snapshot-access-request
       (clojure.core/nth args2743 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-cluster-subnet-groups
   [m2745]
   (clojure.core/let
    [credentials2746 (:credentials m2745) args2747 (:args m2745)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client2748
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2746)]
     (clojure.core/case
      (clojure.core/count args2747)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2748
        describeClusterSubnetGroups
        (redshift/describe-cluster-subnet-groups-request
         (clojure.core/nth args2747 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2748
        describeClusterSubnetGroups))))))
  (clojure.core/defn
   describe-cluster-subnet-groups-map
   {:arglists (quote
               [[credentials
                 {:keys [max-records
                         marker
                         general-progress-listener
                         cluster-subnet-group-name]}]
                [credentials]]),
    :doc "Generate map for describeClusterSubnetGroups, describeClusterSubnetGroups"}
   ([credentials__1651__auto__]
    {:args [],
     :client :redshift,
     :fn :describe-cluster-subnet-groups,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :describe-cluster-subnet-groups,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-cluster-subnet-groups
   {:arglists (quote
               [[credentials
                 {:keys [max-records
                         marker
                         general-progress-listener
                         cluster-subnet-group-name]}]
                [credentials]]),
    :doc "Call describeClusterSubnetGroups, describeClusterSubnetGroups"}
   [credentials2750 & args2751]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client2752
     (com.palletops.awaze.common/aws-client :redshift credentials2750)]
    (clojure.core/case
     (clojure.core/count args2751)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2752
       describeClusterSubnetGroups
       (redshift/describe-cluster-subnet-groups-request
        (clojure.core/nth args2751 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2752
       describeClusterSubnetGroups))))))
 (do
  (clojure.core/defmethod
   redshift
   :enable-logging
   [m2753]
   (clojure.core/let
    [credentials2754 (:credentials m2753) args2755 (:args m2753)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client2756
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2754)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2756
       enableLogging
       (redshift/enable-logging-request (clojure.core/nth args2755 0)))))))
  (clojure.core/defn
   enable-logging-map
   {:arglists (quote
               [[credentials
                 {:keys [s3key-prefix
                         general-progress-listener
                         cluster-identifier
                         bucket-name]}]]),
    :doc "Generate map for enableLogging"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :enable-logging,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   enable-logging
   {:arglists (quote
               [[credentials
                 {:keys [s3key-prefix
                         general-progress-listener
                         cluster-identifier
                         bucket-name]}]]),
    :doc "Call enableLogging"}
   [credentials2758 & args2759]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client2760
     (com.palletops.awaze.common/aws-client :redshift credentials2758)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2760
      enableLogging
      (redshift/enable-logging-request (clojure.core/nth args2759 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-clusters
   [m2761]
   (clojure.core/let
    [credentials2762 (:credentials m2761) args2763 (:args m2761)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client2764
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2762)]
     (clojure.core/case
      (clojure.core/count args2763)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2764
        describeClusters))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2764
        describeClusters
        (redshift/describe-clusters-request
         (clojure.core/nth args2763 0))))))))
  (clojure.core/defn
   describe-clusters-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [max-records
                         marker
                         general-progress-listener
                         cluster-identifier]}]]),
    :doc "Generate map for describeClusters, describeClusters"}
   ([credentials__1651__auto__]
    {:args [],
     :client :redshift,
     :fn :describe-clusters,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :describe-clusters,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-clusters
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [max-records
                         marker
                         general-progress-listener
                         cluster-identifier]}]]),
    :doc "Call describeClusters, describeClusters"}
   [credentials2766 & args2767]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client2768
     (com.palletops.awaze.common/aws-client :redshift credentials2766)]
    (clojure.core/case
     (clojure.core/count args2767)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2768
       describeClusters))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2768
       describeClusters
       (redshift/describe-clusters-request
        (clojure.core/nth args2767 0))))))))
 (do
  (clojure.core/defmethod
   redshift
   :restore-from-cluster-snapshot
   [m2769]
   (clojure.core/let
    [credentials2770 (:credentials m2769) args2771 (:args m2769)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client2772
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2770)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2772
       restoreFromClusterSnapshot
       (redshift/restore-from-cluster-snapshot-request
        (clojure.core/nth args2771 0)))))))
  (clojure.core/defn
   restore-from-cluster-snapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [hsm-client-certificate-identifier
                         publicly-accessible
                         cluster-security-groups
                         general-progress-listener
                         automated-snapshot-retention-period
                         cluster-identifier
                         owner-account
                         availability-zone
                         preferred-maintenance-window
                         hsm-configuration-identifier
                         cluster-parameter-group-name
                         vpc-security-group-ids
                         port
                         elastic-ip
                         snapshot-identifier
                         snapshot-cluster-identifier
                         cluster-subnet-group-name
                         allow-version-upgrade]}]]),
    :doc "Generate map for restoreFromClusterSnapshot"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :restore-from-cluster-snapshot,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   restore-from-cluster-snapshot
   {:arglists (quote
               [[credentials
                 {:keys [hsm-client-certificate-identifier
                         publicly-accessible
                         cluster-security-groups
                         general-progress-listener
                         automated-snapshot-retention-period
                         cluster-identifier
                         owner-account
                         availability-zone
                         preferred-maintenance-window
                         hsm-configuration-identifier
                         cluster-parameter-group-name
                         vpc-security-group-ids
                         port
                         elastic-ip
                         snapshot-identifier
                         snapshot-cluster-identifier
                         cluster-subnet-group-name
                         allow-version-upgrade]}]]),
    :doc "Call restoreFromClusterSnapshot"}
   [credentials2774 & args2775]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client2776
     (com.palletops.awaze.common/aws-client :redshift credentials2774)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2776
      restoreFromClusterSnapshot
      (redshift/restore-from-cluster-snapshot-request
       (clojure.core/nth args2775 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :revoke-snapshot-access
   [m2777]
   (clojure.core/let
    [credentials2778 (:credentials m2777) args2779 (:args m2777)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client2780
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2778)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2780
       revokeSnapshotAccess
       (redshift/revoke-snapshot-access-request
        (clojure.core/nth args2779 0)))))))
  (clojure.core/defn
   revoke-snapshot-access-map
   {:arglists (quote
               [[credentials
                 {:keys [snapshot-identifier
                         snapshot-cluster-identifier
                         general-progress-listener
                         account-with-restore-access]}]]),
    :doc "Generate map for revokeSnapshotAccess"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :revoke-snapshot-access,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   revoke-snapshot-access
   {:arglists (quote
               [[credentials
                 {:keys [snapshot-identifier
                         snapshot-cluster-identifier
                         general-progress-listener
                         account-with-restore-access]}]]),
    :doc "Call revokeSnapshotAccess"}
   [credentials2782 & args2783]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client2784
     (com.palletops.awaze.common/aws-client :redshift credentials2782)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2784
      revokeSnapshotAccess
      (redshift/revoke-snapshot-access-request
       (clojure.core/nth args2783 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :rotate-encryption-key
   [m2785]
   (clojure.core/let
    [credentials2786 (:credentials m2785) args2787 (:args m2785)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client2788
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2786)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2788
       rotateEncryptionKey
       (redshift/rotate-encryption-key-request
        (clojure.core/nth args2787 0)))))))
  (clojure.core/defn
   rotate-encryption-key-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener cluster-identifier]}]]),
    :doc "Generate map for rotateEncryptionKey"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :rotate-encryption-key,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   rotate-encryption-key
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener cluster-identifier]}]]),
    :doc "Call rotateEncryptionKey"}
   [credentials2790 & args2791]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client2792
     (com.palletops.awaze.common/aws-client :redshift credentials2790)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2792
      rotateEncryptionKey
      (redshift/rotate-encryption-key-request
       (clojure.core/nth args2791 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :disable-logging
   [m2793]
   (clojure.core/let
    [credentials2794 (:credentials m2793) args2795 (:args m2793)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client2796
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2794)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2796
       disableLogging
       (redshift/disable-logging-request
        (clojure.core/nth args2795 0)))))))
  (clojure.core/defn
   disable-logging-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener cluster-identifier]}]]),
    :doc "Generate map for disableLogging"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :disable-logging,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   disable-logging
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener cluster-identifier]}]]),
    :doc "Call disableLogging"}
   [credentials2798 & args2799]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client2800
     (com.palletops.awaze.common/aws-client :redshift credentials2798)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2800
      disableLogging
      (redshift/disable-logging-request (clojure.core/nth args2799 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :delete-cluster-security-group
   [m2801]
   (clojure.core/let
    [credentials2802 (:credentials m2801) args2803 (:args m2801)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client2804
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2802)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2804
       deleteClusterSecurityGroup
       (redshift/delete-cluster-security-group-request
        (clojure.core/nth args2803 0)))))))
  (clojure.core/defn
   delete-cluster-security-group-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         cluster-security-group-name]}]]),
    :doc "Generate map for deleteClusterSecurityGroup"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :delete-cluster-security-group,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-cluster-security-group
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         cluster-security-group-name]}]]),
    :doc "Call deleteClusterSecurityGroup"}
   [credentials2806 & args2807]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client2808
     (com.palletops.awaze.common/aws-client :redshift credentials2806)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2808
      deleteClusterSecurityGroup
      (redshift/delete-cluster-security-group-request
       (clojure.core/nth args2807 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-cluster-parameters
   [m2809]
   (clojure.core/let
    [credentials2810 (:credentials m2809) args2811 (:args m2809)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client2812
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2810)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2812
       describeClusterParameters
       (redshift/describe-cluster-parameters-request
        (clojure.core/nth args2811 0)))))))
  (clojure.core/defn
   describe-cluster-parameters-map
   {:arglists (quote
               [[credentials
                 {:keys [source
                         parameter-group-name
                         max-records
                         marker
                         general-progress-listener]}]]),
    :doc "Generate map for describeClusterParameters"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :describe-cluster-parameters,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-cluster-parameters
   {:arglists (quote
               [[credentials
                 {:keys [source
                         parameter-group-name
                         max-records
                         marker
                         general-progress-listener]}]]),
    :doc "Call describeClusterParameters"}
   [credentials2814 & args2815]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client2816
     (com.palletops.awaze.common/aws-client :redshift credentials2814)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2816
      describeClusterParameters
      (redshift/describe-cluster-parameters-request
       (clojure.core/nth args2815 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :create-event-subscription
   [m2817]
   (clojure.core/let
    [credentials2818 (:credentials m2817) args2819 (:args m2817)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client2820
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2818)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2820
       createEventSubscription
       (redshift/create-event-subscription-request
        (clojure.core/nth args2819 0)))))))
  (clojure.core/defn
   create-event-subscription-map
   {:arglists (quote
               [[credentials
                 {:keys [enabled
                         source-type
                         sns-topic-arn
                         event-categories
                         general-progress-listener
                         subscription-name
                         source-ids
                         severity]}]]),
    :doc "Generate map for createEventSubscription"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :create-event-subscription,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-event-subscription
   {:arglists (quote
               [[credentials
                 {:keys [enabled
                         source-type
                         sns-topic-arn
                         event-categories
                         general-progress-listener
                         subscription-name
                         source-ids
                         severity]}]]),
    :doc "Call createEventSubscription"}
   [credentials2822 & args2823]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client2824
     (com.palletops.awaze.common/aws-client :redshift credentials2822)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2824
      createEventSubscription
      (redshift/create-event-subscription-request
       (clojure.core/nth args2823 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :reset-cluster-parameter-group
   [m2825]
   (clojure.core/let
    [credentials2826 (:credentials m2825) args2827 (:args m2825)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client2828
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2826)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2828
       resetClusterParameterGroup
       (redshift/reset-cluster-parameter-group-request
        (clojure.core/nth args2827 0)))))))
  (clojure.core/defn
   reset-cluster-parameter-group-map
   {:arglists (quote
               [[credentials
                 {:keys [reset-all-parameters
                         parameters
                         parameter-group-name
                         general-progress-listener]}]]),
    :doc "Generate map for resetClusterParameterGroup"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :reset-cluster-parameter-group,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   reset-cluster-parameter-group
   {:arglists (quote
               [[credentials
                 {:keys [reset-all-parameters
                         parameters
                         parameter-group-name
                         general-progress-listener]}]]),
    :doc "Call resetClusterParameterGroup"}
   [credentials2830 & args2831]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client2832
     (com.palletops.awaze.common/aws-client :redshift credentials2830)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2832
      resetClusterParameterGroup
      (redshift/reset-cluster-parameter-group-request
       (clojure.core/nth args2831 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :create-cluster-parameter-group
   [m2833]
   (clojure.core/let
    [credentials2834 (:credentials m2833) args2835 (:args m2833)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client2836
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2834)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2836
       createClusterParameterGroup
       (redshift/create-cluster-parameter-group-request
        (clojure.core/nth args2835 0)))))))
  (clojure.core/defn
   create-cluster-parameter-group-map
   {:arglists (quote
               [[credentials
                 {:keys [parameter-group-name
                         parameter-group-family
                         general-progress-listener
                         description]}]]),
    :doc "Generate map for createClusterParameterGroup"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :create-cluster-parameter-group,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-cluster-parameter-group
   {:arglists (quote
               [[credentials
                 {:keys [parameter-group-name
                         parameter-group-family
                         general-progress-listener
                         description]}]]),
    :doc "Call createClusterParameterGroup"}
   [credentials2838 & args2839]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client2840
     (com.palletops.awaze.common/aws-client :redshift credentials2838)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2840
      createClusterParameterGroup
      (redshift/create-cluster-parameter-group-request
       (clojure.core/nth args2839 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :delete-hsm-configuration
   [m2841]
   (clojure.core/let
    [credentials2842 (:credentials m2841) args2843 (:args m2841)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client2844
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2842)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2844
       deleteHsmConfiguration
       (redshift/delete-hsm-configuration-request
        (clojure.core/nth args2843 0)))))))
  (clojure.core/defn
   delete-hsm-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [hsm-configuration-identifier
                         general-progress-listener]}]]),
    :doc "Generate map for deleteHsmConfiguration"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :delete-hsm-configuration,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-hsm-configuration
   {:arglists (quote
               [[credentials
                 {:keys [hsm-configuration-identifier
                         general-progress-listener]}]]),
    :doc "Call deleteHsmConfiguration"}
   [credentials2846 & args2847]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client2848
     (com.palletops.awaze.common/aws-client :redshift credentials2846)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2848
      deleteHsmConfiguration
      (redshift/delete-hsm-configuration-request
       (clojure.core/nth args2847 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :modify-event-subscription
   [m2849]
   (clojure.core/let
    [credentials2850 (:credentials m2849) args2851 (:args m2849)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client2852
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2850)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2852
       modifyEventSubscription
       (redshift/modify-event-subscription-request
        (clojure.core/nth args2851 0)))))))
  (clojure.core/defn
   modify-event-subscription-map
   {:arglists (quote
               [[credentials
                 {:keys [enabled
                         source-type
                         sns-topic-arn
                         event-categories
                         general-progress-listener
                         subscription-name
                         source-ids
                         severity]}]]),
    :doc "Generate map for modifyEventSubscription"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :modify-event-subscription,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   modify-event-subscription
   {:arglists (quote
               [[credentials
                 {:keys [enabled
                         source-type
                         sns-topic-arn
                         event-categories
                         general-progress-listener
                         subscription-name
                         source-ids
                         severity]}]]),
    :doc "Call modifyEventSubscription"}
   [credentials2854 & args2855]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client2856
     (com.palletops.awaze.common/aws-client :redshift credentials2854)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2856
      modifyEventSubscription
      (redshift/modify-event-subscription-request
       (clojure.core/nth args2855 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-reserved-nodes
   [m2857]
   (clojure.core/let
    [credentials2858 (:credentials m2857) args2859 (:args m2857)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client2860
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2858)]
     (clojure.core/case
      (clojure.core/count args2859)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2860
        describeReservedNodes))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2860
        describeReservedNodes
        (redshift/describe-reserved-nodes-request
         (clojure.core/nth args2859 0))))))))
  (clojure.core/defn
   describe-reserved-nodes-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [reserved-node-id
                         max-records
                         marker
                         general-progress-listener]}]]),
    :doc "Generate map for describeReservedNodes, describeReservedNodes"}
   ([credentials__1651__auto__]
    {:args [],
     :client :redshift,
     :fn :describe-reserved-nodes,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :describe-reserved-nodes,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-reserved-nodes
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [reserved-node-id
                         max-records
                         marker
                         general-progress-listener]}]]),
    :doc "Call describeReservedNodes, describeReservedNodes"}
   [credentials2862 & args2863]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client2864
     (com.palletops.awaze.common/aws-client :redshift credentials2862)]
    (clojure.core/case
     (clojure.core/count args2863)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2864
       describeReservedNodes))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2864
       describeReservedNodes
       (redshift/describe-reserved-nodes-request
        (clojure.core/nth args2863 0))))))))
 (do
  (clojure.core/defmethod
   redshift
   :copy-cluster-snapshot
   [m2865]
   (clojure.core/let
    [credentials2866 (:credentials m2865) args2867 (:args m2865)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client2868
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2866)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2868
       copyClusterSnapshot
       (redshift/copy-cluster-snapshot-request
        (clojure.core/nth args2867 0)))))))
  (clojure.core/defn
   copy-cluster-snapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [target-snapshot-identifier
                         source-snapshot-identifier
                         source-snapshot-cluster-identifier
                         general-progress-listener]}]]),
    :doc "Generate map for copyClusterSnapshot"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :copy-cluster-snapshot,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   copy-cluster-snapshot
   {:arglists (quote
               [[credentials
                 {:keys [target-snapshot-identifier
                         source-snapshot-identifier
                         source-snapshot-cluster-identifier
                         general-progress-listener]}]]),
    :doc "Call copyClusterSnapshot"}
   [credentials2870 & args2871]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client2872
     (com.palletops.awaze.common/aws-client :redshift credentials2870)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2872
      copyClusterSnapshot
      (redshift/copy-cluster-snapshot-request
       (clojure.core/nth args2871 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :delete-hsm-client-certificate
   [m2873]
   (clojure.core/let
    [credentials2874 (:credentials m2873) args2875 (:args m2873)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client2876
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2874)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2876
       deleteHsmClientCertificate
       (redshift/delete-hsm-client-certificate-request
        (clojure.core/nth args2875 0)))))))
  (clojure.core/defn
   delete-hsm-client-certificate-map
   {:arglists (quote
               [[credentials
                 {:keys [hsm-client-certificate-identifier
                         general-progress-listener]}]]),
    :doc "Generate map for deleteHsmClientCertificate"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :delete-hsm-client-certificate,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-hsm-client-certificate
   {:arglists (quote
               [[credentials
                 {:keys [hsm-client-certificate-identifier
                         general-progress-listener]}]]),
    :doc "Call deleteHsmClientCertificate"}
   [credentials2878 & args2879]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client2880
     (com.palletops.awaze.common/aws-client :redshift credentials2878)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2880
      deleteHsmClientCertificate
      (redshift/delete-hsm-client-certificate-request
       (clojure.core/nth args2879 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :modify-cluster-subnet-group
   [m2881]
   (clojure.core/let
    [credentials2882 (:credentials m2881) args2883 (:args m2881)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client2884
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2882)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2884
       modifyClusterSubnetGroup
       (redshift/modify-cluster-subnet-group-request
        (clojure.core/nth args2883 0)))))))
  (clojure.core/defn
   modify-cluster-subnet-group-map
   {:arglists (quote
               [[credentials
                 {:keys [subnet-ids
                         general-progress-listener
                         description
                         cluster-subnet-group-name]}]]),
    :doc "Generate map for modifyClusterSubnetGroup"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :modify-cluster-subnet-group,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   modify-cluster-subnet-group
   {:arglists (quote
               [[credentials
                 {:keys [subnet-ids
                         general-progress-listener
                         description
                         cluster-subnet-group-name]}]]),
    :doc "Call modifyClusterSubnetGroup"}
   [credentials2886 & args2887]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client2888
     (com.palletops.awaze.common/aws-client :redshift credentials2886)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2888
      modifyClusterSubnetGroup
      (redshift/modify-cluster-subnet-group-request
       (clojure.core/nth args2887 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-logging-status
   [m2889]
   (clojure.core/let
    [credentials2890 (:credentials m2889) args2891 (:args m2889)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client2892
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2890)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2892
       describeLoggingStatus
       (redshift/describe-logging-status-request
        (clojure.core/nth args2891 0)))))))
  (clojure.core/defn
   describe-logging-status-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener cluster-identifier]}]]),
    :doc "Generate map for describeLoggingStatus"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :describe-logging-status,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-logging-status
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener cluster-identifier]}]]),
    :doc "Call describeLoggingStatus"}
   [credentials2894 & args2895]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client2896
     (com.palletops.awaze.common/aws-client :redshift credentials2894)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2896
      describeLoggingStatus
      (redshift/describe-logging-status-request
       (clojure.core/nth args2895 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-events
   [m2897]
   (clojure.core/let
    [credentials2898 (:credentials m2897) args2899 (:args m2897)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client2900
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2898)]
     (clojure.core/case
      (clojure.core/count args2899)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2900
        describeEvents))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2900
        describeEvents
        (redshift/describe-events-request
         (clojure.core/nth args2899 0))))))))
  (clojure.core/defn
   describe-events-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [end-time
                         source-type
                         duration
                         general-progress-listener
                         max-records
                         start-time
                         marker
                         source-identifier]}]]),
    :doc "Generate map for describeEvents, describeEvents"}
   ([credentials__1651__auto__]
    {:args [],
     :client :redshift,
     :fn :describe-events,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :describe-events,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-events
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [end-time
                         source-type
                         duration
                         general-progress-listener
                         max-records
                         start-time
                         marker
                         source-identifier]}]]),
    :doc "Call describeEvents, describeEvents"}
   [credentials2902 & args2903]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client2904
     (com.palletops.awaze.common/aws-client :redshift credentials2902)]
    (clojure.core/case
     (clojure.core/count args2903)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2904
       describeEvents))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2904
       describeEvents
       (redshift/describe-events-request
        (clojure.core/nth args2903 0))))))))
 (do
  (clojure.core/defmethod
   redshift
   :delete-cluster-parameter-group
   [m2905]
   (clojure.core/let
    [credentials2906 (:credentials m2905) args2907 (:args m2905)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client2908
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2906)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2908
       deleteClusterParameterGroup
       (redshift/delete-cluster-parameter-group-request
        (clojure.core/nth args2907 0)))))))
  (clojure.core/defn
   delete-cluster-parameter-group-map
   {:arglists (quote
               [[credentials
                 {:keys [parameter-group-name
                         general-progress-listener]}]]),
    :doc "Generate map for deleteClusterParameterGroup"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :delete-cluster-parameter-group,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-cluster-parameter-group
   {:arglists (quote
               [[credentials
                 {:keys [parameter-group-name
                         general-progress-listener]}]]),
    :doc "Call deleteClusterParameterGroup"}
   [credentials2910 & args2911]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client2912
     (com.palletops.awaze.common/aws-client :redshift credentials2910)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2912
      deleteClusterParameterGroup
      (redshift/delete-cluster-parameter-group-request
       (clojure.core/nth args2911 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :authorize-cluster-security-group-ingress
   [m2913]
   (clojure.core/let
    [credentials2914 (:credentials m2913) args2915 (:args m2913)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client2916
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2914)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2916
       authorizeClusterSecurityGroupIngress
       (redshift/authorize-cluster-security-group-ingress-request
        (clojure.core/nth args2915 0)))))))
  (clojure.core/defn
   authorize-cluster-security-group-ingress-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         cluster-security-group-name
                         ec2security-group-owner-id
                         ec2security-group-name
                         cidrip]}]]),
    :doc "Generate map for authorizeClusterSecurityGroupIngress"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :authorize-cluster-security-group-ingress,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   authorize-cluster-security-group-ingress
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         cluster-security-group-name
                         ec2security-group-owner-id
                         ec2security-group-name
                         cidrip]}]]),
    :doc "Call authorizeClusterSecurityGroupIngress"}
   [credentials2918 & args2919]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client2920
     (com.palletops.awaze.common/aws-client :redshift credentials2918)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2920
      authorizeClusterSecurityGroupIngress
      (redshift/authorize-cluster-security-group-ingress-request
       (clojure.core/nth args2919 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :modify-cluster
   [m2921]
   (clojure.core/let
    [credentials2922 (:credentials m2921) args2923 (:args m2921)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client2924
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2922)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2924
       modifyCluster
       (redshift/modify-cluster-request (clojure.core/nth args2923 0)))))))
  (clojure.core/defn
   modify-cluster-map
   {:arglists (quote
               [[credentials
                 {:keys [node-type
                         hsm-client-certificate-identifier
                         cluster-type
                         new-cluster-identifier
                         cluster-security-groups
                         general-progress-listener
                         automated-snapshot-retention-period
                         cluster-identifier
                         preferred-maintenance-window
                         hsm-configuration-identifier
                         cluster-parameter-group-name
                         master-user-password
                         number-of-nodes
                         vpc-security-group-ids
                         cluster-version
                         allow-version-upgrade]}]]),
    :doc "Generate map for modifyCluster"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :modify-cluster,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   modify-cluster
   {:arglists (quote
               [[credentials
                 {:keys [node-type
                         hsm-client-certificate-identifier
                         cluster-type
                         new-cluster-identifier
                         cluster-security-groups
                         general-progress-listener
                         automated-snapshot-retention-period
                         cluster-identifier
                         preferred-maintenance-window
                         hsm-configuration-identifier
                         cluster-parameter-group-name
                         master-user-password
                         number-of-nodes
                         vpc-security-group-ids
                         cluster-version
                         allow-version-upgrade]}]]),
    :doc "Call modifyCluster"}
   [credentials2926 & args2927]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client2928
     (com.palletops.awaze.common/aws-client :redshift credentials2926)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2928
      modifyCluster
      (redshift/modify-cluster-request (clojure.core/nth args2927 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :delete-cluster-subnet-group
   [m2929]
   (clojure.core/let
    [credentials2930 (:credentials m2929) args2931 (:args m2929)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client2932
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2930)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2932
       deleteClusterSubnetGroup
       (redshift/delete-cluster-subnet-group-request
        (clojure.core/nth args2931 0)))))))
  (clojure.core/defn
   delete-cluster-subnet-group-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         cluster-subnet-group-name]}]]),
    :doc "Generate map for deleteClusterSubnetGroup"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :delete-cluster-subnet-group,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-cluster-subnet-group
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         cluster-subnet-group-name]}]]),
    :doc "Call deleteClusterSubnetGroup"}
   [credentials2934 & args2935]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client2936
     (com.palletops.awaze.common/aws-client :redshift credentials2934)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2936
      deleteClusterSubnetGroup
      (redshift/delete-cluster-subnet-group-request
       (clojure.core/nth args2935 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :create-cluster-subnet-group
   [m2937]
   (clojure.core/let
    [credentials2938 (:credentials m2937) args2939 (:args m2937)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client2940
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2938)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2940
       createClusterSubnetGroup
       (redshift/create-cluster-subnet-group-request
        (clojure.core/nth args2939 0)))))))
  (clojure.core/defn
   create-cluster-subnet-group-map
   {:arglists (quote
               [[credentials
                 {:keys [subnet-ids
                         general-progress-listener
                         description
                         cluster-subnet-group-name]}]]),
    :doc "Generate map for createClusterSubnetGroup"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :create-cluster-subnet-group,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-cluster-subnet-group
   {:arglists (quote
               [[credentials
                 {:keys [subnet-ids
                         general-progress-listener
                         description
                         cluster-subnet-group-name]}]]),
    :doc "Call createClusterSubnetGroup"}
   [credentials2942 & args2943]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client2944
     (com.palletops.awaze.common/aws-client :redshift credentials2942)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2944
      createClusterSubnetGroup
      (redshift/create-cluster-subnet-group-request
       (clojure.core/nth args2943 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :purchase-reserved-node-offering
   [m2945]
   (clojure.core/let
    [credentials2946 (:credentials m2945) args2947 (:args m2945)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client2948
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2946)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2948
       purchaseReservedNodeOffering
       (redshift/purchase-reserved-node-offering-request
        (clojure.core/nth args2947 0)))))))
  (clojure.core/defn
   purchase-reserved-node-offering-map
   {:arglists (quote
               [[credentials
                 {:keys [reserved-node-offering-id
                         node-count
                         general-progress-listener]}]]),
    :doc "Generate map for purchaseReservedNodeOffering"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :purchase-reserved-node-offering,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   purchase-reserved-node-offering
   {:arglists (quote
               [[credentials
                 {:keys [reserved-node-offering-id
                         node-count
                         general-progress-listener]}]]),
    :doc "Call purchaseReservedNodeOffering"}
   [credentials2950 & args2951]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client2952
     (com.palletops.awaze.common/aws-client :redshift credentials2950)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2952
      purchaseReservedNodeOffering
      (redshift/purchase-reserved-node-offering-request
       (clojure.core/nth args2951 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-reserved-node-offerings
   [m2953]
   (clojure.core/let
    [credentials2954 (:credentials m2953) args2955 (:args m2953)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client2956
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2954)]
     (clojure.core/case
      (clojure.core/count args2955)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2956
        describeReservedNodeOfferings
        (redshift/describe-reserved-node-offerings-request
         (clojure.core/nth args2955 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2956
        describeReservedNodeOfferings))))))
  (clojure.core/defn
   describe-reserved-node-offerings-map
   {:arglists (quote
               [[credentials
                 {:keys [reserved-node-offering-id
                         max-records
                         marker
                         general-progress-listener]}]
                [credentials]]),
    :doc "Generate map for describeReservedNodeOfferings, describeReservedNodeOfferings"}
   ([credentials__1651__auto__]
    {:args [],
     :client :redshift,
     :fn :describe-reserved-node-offerings,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :describe-reserved-node-offerings,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-reserved-node-offerings
   {:arglists (quote
               [[credentials
                 {:keys [reserved-node-offering-id
                         max-records
                         marker
                         general-progress-listener]}]
                [credentials]]),
    :doc "Call describeReservedNodeOfferings, describeReservedNodeOfferings"}
   [credentials2958 & args2959]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client2960
     (com.palletops.awaze.common/aws-client :redshift credentials2958)]
    (clojure.core/case
     (clojure.core/count args2959)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2960
       describeReservedNodeOfferings
       (redshift/describe-reserved-node-offerings-request
        (clojure.core/nth args2959 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2960
       describeReservedNodeOfferings))))))
 (do
  (clojure.core/defmethod
   redshift
   :delete-cluster
   [m2961]
   (clojure.core/let
    [credentials2962 (:credentials m2961) args2963 (:args m2961)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client2964
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2962)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2964
       deleteCluster
       (redshift/delete-cluster-request (clojure.core/nth args2963 0)))))))
  (clojure.core/defn
   delete-cluster-map
   {:arglists (quote
               [[credentials
                 {:keys [skip-final-cluster-snapshot
                         general-progress-listener
                         final-cluster-snapshot-identifier
                         cluster-identifier]}]]),
    :doc "Generate map for deleteCluster"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :delete-cluster,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-cluster
   {:arglists (quote
               [[credentials
                 {:keys [skip-final-cluster-snapshot
                         general-progress-listener
                         final-cluster-snapshot-identifier
                         cluster-identifier]}]]),
    :doc "Call deleteCluster"}
   [credentials2966 & args2967]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client2968
     (com.palletops.awaze.common/aws-client :redshift credentials2966)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2968
      deleteCluster
      (redshift/delete-cluster-request (clojure.core/nth args2967 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :create-cluster-security-group
   [m2969]
   (clojure.core/let
    [credentials2970 (:credentials m2969) args2971 (:args m2969)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client2972
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2970)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2972
       createClusterSecurityGroup
       (redshift/create-cluster-security-group-request
        (clojure.core/nth args2971 0)))))))
  (clojure.core/defn
   create-cluster-security-group-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         description
                         cluster-security-group-name]}]]),
    :doc "Generate map for createClusterSecurityGroup"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :create-cluster-security-group,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-cluster-security-group
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         description
                         cluster-security-group-name]}]]),
    :doc "Call createClusterSecurityGroup"}
   [credentials2974 & args2975]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client2976
     (com.palletops.awaze.common/aws-client :redshift credentials2974)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2976
      createClusterSecurityGroup
      (redshift/create-cluster-security-group-request
       (clojure.core/nth args2975 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-event-subscriptions
   [m2977]
   (clojure.core/let
    [credentials2978 (:credentials m2977) args2979 (:args m2977)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client2980
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2978)]
     (clojure.core/case
      (clojure.core/count args2979)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2980
        describeEventSubscriptions))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2980
        describeEventSubscriptions
        (redshift/describe-event-subscriptions-request
         (clojure.core/nth args2979 0))))))))
  (clojure.core/defn
   describe-event-subscriptions-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [subscription-name
                         max-records
                         marker
                         general-progress-listener]}]]),
    :doc "Generate map for describeEventSubscriptions, describeEventSubscriptions"}
   ([credentials__1651__auto__]
    {:args [],
     :client :redshift,
     :fn :describe-event-subscriptions,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :describe-event-subscriptions,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-event-subscriptions
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [subscription-name
                         max-records
                         marker
                         general-progress-listener]}]]),
    :doc "Call describeEventSubscriptions, describeEventSubscriptions"}
   [credentials2982 & args2983]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client2984
     (com.palletops.awaze.common/aws-client :redshift credentials2982)]
    (clojure.core/case
     (clojure.core/count args2983)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2984
       describeEventSubscriptions))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2984
       describeEventSubscriptions
       (redshift/describe-event-subscriptions-request
        (clojure.core/nth args2983 0))))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-default-cluster-parameters
   [m2985]
   (clojure.core/let
    [credentials2986 (:credentials m2985) args2987 (:args m2985)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client2988
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2986)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2988
       describeDefaultClusterParameters
       (redshift/describe-default-cluster-parameters-request
        (clojure.core/nth args2987 0)))))))
  (clojure.core/defn
   describe-default-cluster-parameters-map
   {:arglists (quote
               [[credentials
                 {:keys [parameter-group-family
                         max-records
                         marker
                         general-progress-listener]}]]),
    :doc "Generate map for describeDefaultClusterParameters"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :describe-default-cluster-parameters,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-default-cluster-parameters
   {:arglists (quote
               [[credentials
                 {:keys [parameter-group-family
                         max-records
                         marker
                         general-progress-listener]}]]),
    :doc "Call describeDefaultClusterParameters"}
   [credentials2990 & args2991]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client2992
     (com.palletops.awaze.common/aws-client :redshift credentials2990)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2992
      describeDefaultClusterParameters
      (redshift/describe-default-cluster-parameters-request
       (clojure.core/nth args2991 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-hsm-configurations
   [m2993]
   (clojure.core/let
    [credentials2994 (:credentials m2993) args2995 (:args m2993)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client2996
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials2994)]
     (clojure.core/case
      (clojure.core/count args2995)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2996
        describeHsmConfigurations))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client2996
        describeHsmConfigurations
        (redshift/describe-hsm-configurations-request
         (clojure.core/nth args2995 0))))))))
  (clojure.core/defn
   describe-hsm-configurations-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [max-records
                         marker
                         hsm-configuration-identifier
                         general-progress-listener]}]]),
    :doc "Generate map for describeHsmConfigurations, describeHsmConfigurations"}
   ([credentials__1651__auto__]
    {:args [],
     :client :redshift,
     :fn :describe-hsm-configurations,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :describe-hsm-configurations,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-hsm-configurations
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [max-records
                         marker
                         hsm-configuration-identifier
                         general-progress-listener]}]]),
    :doc "Call describeHsmConfigurations, describeHsmConfigurations"}
   [credentials2998 & args2999]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client3000
     (com.palletops.awaze.common/aws-client :redshift credentials2998)]
    (clojure.core/case
     (clojure.core/count args2999)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3000
       describeHsmConfigurations))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3000
       describeHsmConfigurations
       (redshift/describe-hsm-configurations-request
        (clojure.core/nth args2999 0))))))))
 (do
  (clojure.core/defmethod
   redshift
   :create-cluster-snapshot
   [m3001]
   (clojure.core/let
    [credentials3002 (:credentials m3001) args3003 (:args m3001)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client3004
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials3002)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3004
       createClusterSnapshot
       (redshift/create-cluster-snapshot-request
        (clojure.core/nth args3003 0)))))))
  (clojure.core/defn
   create-cluster-snapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [snapshot-identifier
                         general-progress-listener
                         cluster-identifier]}]]),
    :doc "Generate map for createClusterSnapshot"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :create-cluster-snapshot,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-cluster-snapshot
   {:arglists (quote
               [[credentials
                 {:keys [snapshot-identifier
                         general-progress-listener
                         cluster-identifier]}]]),
    :doc "Call createClusterSnapshot"}
   [credentials3006 & args3007]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client3008
     (com.palletops.awaze.common/aws-client :redshift credentials3006)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3008
      createClusterSnapshot
      (redshift/create-cluster-snapshot-request
       (clojure.core/nth args3007 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-cluster-versions
   [m3009]
   (clojure.core/let
    [credentials3010 (:credentials m3009) args3011 (:args m3009)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client3012
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials3010)]
     (clojure.core/case
      (clojure.core/count args3011)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3012
        describeClusterVersions))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3012
        describeClusterVersions
        (redshift/describe-cluster-versions-request
         (clojure.core/nth args3011 0))))))))
  (clojure.core/defn
   describe-cluster-versions-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [max-records
                         marker
                         general-progress-listener
                         cluster-version
                         cluster-parameter-group-family]}]]),
    :doc "Generate map for describeClusterVersions, describeClusterVersions"}
   ([credentials__1651__auto__]
    {:args [],
     :client :redshift,
     :fn :describe-cluster-versions,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :describe-cluster-versions,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-cluster-versions
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [max-records
                         marker
                         general-progress-listener
                         cluster-version
                         cluster-parameter-group-family]}]]),
    :doc "Call describeClusterVersions, describeClusterVersions"}
   [credentials3014 & args3015]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client3016
     (com.palletops.awaze.common/aws-client :redshift credentials3014)]
    (clojure.core/case
     (clojure.core/count args3015)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3016
       describeClusterVersions))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3016
       describeClusterVersions
       (redshift/describe-cluster-versions-request
        (clojure.core/nth args3015 0))))))))
 (do
  (clojure.core/defmethod
   redshift
   :disable-snapshot-copy
   [m3017]
   (clojure.core/let
    [credentials3018 (:credentials m3017) args3019 (:args m3017)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client3020
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials3018)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3020
       disableSnapshotCopy
       (redshift/disable-snapshot-copy-request
        (clojure.core/nth args3019 0)))))))
  (clojure.core/defn
   disable-snapshot-copy-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener cluster-identifier]}]]),
    :doc "Generate map for disableSnapshotCopy"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :disable-snapshot-copy,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   disable-snapshot-copy
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener cluster-identifier]}]]),
    :doc "Call disableSnapshotCopy"}
   [credentials3022 & args3023]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client3024
     (com.palletops.awaze.common/aws-client :redshift credentials3022)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3024
      disableSnapshotCopy
      (redshift/disable-snapshot-copy-request
       (clojure.core/nth args3023 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :delete-event-subscription
   [m3025]
   (clojure.core/let
    [credentials3026 (:credentials m3025) args3027 (:args m3025)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client3028
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials3026)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3028
       deleteEventSubscription
       (redshift/delete-event-subscription-request
        (clojure.core/nth args3027 0)))))))
  (clojure.core/defn
   delete-event-subscription-map
   {:arglists (quote
               [[credentials
                 {:keys [subscription-name general-progress-listener]}]]),
    :doc "Generate map for deleteEventSubscription"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :delete-event-subscription,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-event-subscription
   {:arglists (quote
               [[credentials
                 {:keys [subscription-name general-progress-listener]}]]),
    :doc "Call deleteEventSubscription"}
   [credentials3030 & args3031]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client3032
     (com.palletops.awaze.common/aws-client :redshift credentials3030)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3032
      deleteEventSubscription
      (redshift/delete-event-subscription-request
       (clojure.core/nth args3031 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :modify-snapshot-copy-retention-period
   [m3033]
   (clojure.core/let
    [credentials3034 (:credentials m3033) args3035 (:args m3033)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client3036
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials3034)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3036
       modifySnapshotCopyRetentionPeriod
       (redshift/modify-snapshot-copy-retention-period-request
        (clojure.core/nth args3035 0)))))))
  (clojure.core/defn
   modify-snapshot-copy-retention-period-map
   {:arglists (quote
               [[credentials
                 {:keys [retention-period
                         general-progress-listener
                         cluster-identifier]}]]),
    :doc "Generate map for modifySnapshotCopyRetentionPeriod"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :modify-snapshot-copy-retention-period,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   modify-snapshot-copy-retention-period
   {:arglists (quote
               [[credentials
                 {:keys [retention-period
                         general-progress-listener
                         cluster-identifier]}]]),
    :doc "Call modifySnapshotCopyRetentionPeriod"}
   [credentials3038 & args3039]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client3040
     (com.palletops.awaze.common/aws-client :redshift credentials3038)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3040
      modifySnapshotCopyRetentionPeriod
      (redshift/modify-snapshot-copy-retention-period-request
       (clojure.core/nth args3039 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :reboot-cluster
   [m3041]
   (clojure.core/let
    [credentials3042 (:credentials m3041) args3043 (:args m3041)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client3044
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials3042)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3044
       rebootCluster
       (redshift/reboot-cluster-request (clojure.core/nth args3043 0)))))))
  (clojure.core/defn
   reboot-cluster-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener cluster-identifier]}]]),
    :doc "Generate map for rebootCluster"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :reboot-cluster,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   reboot-cluster
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener cluster-identifier]}]]),
    :doc "Call rebootCluster"}
   [credentials3046 & args3047]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client3048
     (com.palletops.awaze.common/aws-client :redshift credentials3046)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3048
      rebootCluster
      (redshift/reboot-cluster-request (clojure.core/nth args3047 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-resize
   [m3049]
   (clojure.core/let
    [credentials3050 (:credentials m3049) args3051 (:args m3049)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client3052
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials3050)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3052
       describeResize
       (redshift/describe-resize-request
        (clojure.core/nth args3051 0)))))))
  (clojure.core/defn
   describe-resize-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener cluster-identifier]}]]),
    :doc "Generate map for describeResize"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :describe-resize,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-resize
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener cluster-identifier]}]]),
    :doc "Call describeResize"}
   [credentials3054 & args3055]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client3056
     (com.palletops.awaze.common/aws-client :redshift credentials3054)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3056
      describeResize
      (redshift/describe-resize-request (clojure.core/nth args3055 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :revoke-cluster-security-group-ingress
   [m3057]
   (clojure.core/let
    [credentials3058 (:credentials m3057) args3059 (:args m3057)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client3060
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials3058)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3060
       revokeClusterSecurityGroupIngress
       (redshift/revoke-cluster-security-group-ingress-request
        (clojure.core/nth args3059 0)))))))
  (clojure.core/defn
   revoke-cluster-security-group-ingress-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         cluster-security-group-name
                         ec2security-group-owner-id
                         ec2security-group-name
                         cidrip]}]]),
    :doc "Generate map for revokeClusterSecurityGroupIngress"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :revoke-cluster-security-group-ingress,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   revoke-cluster-security-group-ingress
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         cluster-security-group-name
                         ec2security-group-owner-id
                         ec2security-group-name
                         cidrip]}]]),
    :doc "Call revokeClusterSecurityGroupIngress"}
   [credentials3062 & args3063]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client3064
     (com.palletops.awaze.common/aws-client :redshift credentials3062)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3064
      revokeClusterSecurityGroupIngress
      (redshift/revoke-cluster-security-group-ingress-request
       (clojure.core/nth args3063 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :modify-cluster-parameter-group
   [m3065]
   (clojure.core/let
    [credentials3066 (:credentials m3065) args3067 (:args m3065)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client3068
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials3066)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3068
       modifyClusterParameterGroup
       (redshift/modify-cluster-parameter-group-request
        (clojure.core/nth args3067 0)))))))
  (clojure.core/defn
   modify-cluster-parameter-group-map
   {:arglists (quote
               [[credentials
                 {:keys [parameters
                         parameter-group-name
                         general-progress-listener]}]]),
    :doc "Generate map for modifyClusterParameterGroup"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :modify-cluster-parameter-group,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   modify-cluster-parameter-group
   {:arglists (quote
               [[credentials
                 {:keys [parameters
                         parameter-group-name
                         general-progress-listener]}]]),
    :doc "Call modifyClusterParameterGroup"}
   [credentials3070 & args3071]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client3072
     (com.palletops.awaze.common/aws-client :redshift credentials3070)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3072
      modifyClusterParameterGroup
      (redshift/modify-cluster-parameter-group-request
       (clojure.core/nth args3071 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-hsm-client-certificates
   [m3073]
   (clojure.core/let
    [credentials3074 (:credentials m3073) args3075 (:args m3073)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client3076
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials3074)]
     (clojure.core/case
      (clojure.core/count args3075)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3076
        describeHsmClientCertificates))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3076
        describeHsmClientCertificates
        (redshift/describe-hsm-client-certificates-request
         (clojure.core/nth args3075 0))))))))
  (clojure.core/defn
   describe-hsm-client-certificates-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [max-records
                         marker
                         hsm-client-certificate-identifier
                         general-progress-listener]}]]),
    :doc "Generate map for describeHsmClientCertificates, describeHsmClientCertificates"}
   ([credentials__1651__auto__]
    {:args [],
     :client :redshift,
     :fn :describe-hsm-client-certificates,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :describe-hsm-client-certificates,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-hsm-client-certificates
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [max-records
                         marker
                         hsm-client-certificate-identifier
                         general-progress-listener]}]]),
    :doc "Call describeHsmClientCertificates, describeHsmClientCertificates"}
   [credentials3078 & args3079]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client3080
     (com.palletops.awaze.common/aws-client :redshift credentials3078)]
    (clojure.core/case
     (clojure.core/count args3079)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3080
       describeHsmClientCertificates))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3080
       describeHsmClientCertificates
       (redshift/describe-hsm-client-certificates-request
        (clojure.core/nth args3079 0))))))))
 (do
  (clojure.core/defmethod
   redshift
   :create-hsm-client-certificate
   [m3081]
   (clojure.core/let
    [credentials3082 (:credentials m3081) args3083 (:args m3081)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client3084
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials3082)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3084
       createHsmClientCertificate
       (redshift/create-hsm-client-certificate-request
        (clojure.core/nth args3083 0)))))))
  (clojure.core/defn
   create-hsm-client-certificate-map
   {:arglists (quote
               [[credentials
                 {:keys [hsm-client-certificate-identifier
                         general-progress-listener]}]]),
    :doc "Generate map for createHsmClientCertificate"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :create-hsm-client-certificate,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-hsm-client-certificate
   {:arglists (quote
               [[credentials
                 {:keys [hsm-client-certificate-identifier
                         general-progress-listener]}]]),
    :doc "Call createHsmClientCertificate"}
   [credentials3086 & args3087]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client3088
     (com.palletops.awaze.common/aws-client :redshift credentials3086)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3088
      createHsmClientCertificate
      (redshift/create-hsm-client-certificate-request
       (clojure.core/nth args3087 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-event-categories
   [m3089]
   (clojure.core/let
    [credentials3090 (:credentials m3089) args3091 (:args m3089)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client3092
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials3090)]
     (clojure.core/case
      (clojure.core/count args3091)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3092
        describeEventCategories
        (redshift/describe-event-categories-request
         (clojure.core/nth args3091 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3092
        describeEventCategories))))))
  (clojure.core/defn
   describe-event-categories-map
   {:arglists (quote
               [[credentials
                 {:keys [source-type general-progress-listener]}]
                [credentials]]),
    :doc "Generate map for describeEventCategories, describeEventCategories"}
   ([credentials__1651__auto__]
    {:args [],
     :client :redshift,
     :fn :describe-event-categories,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :describe-event-categories,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-event-categories
   {:arglists (quote
               [[credentials
                 {:keys [source-type general-progress-listener]}]
                [credentials]]),
    :doc "Call describeEventCategories, describeEventCategories"}
   [credentials3094 & args3095]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client3096
     (com.palletops.awaze.common/aws-client :redshift credentials3094)]
    (clojure.core/case
     (clojure.core/count args3095)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3096
       describeEventCategories
       (redshift/describe-event-categories-request
        (clojure.core/nth args3095 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3096
       describeEventCategories))))))
 (do
  (clojure.core/defmethod
   redshift
   :create-hsm-configuration
   [m3097]
   (clojure.core/let
    [credentials3098 (:credentials m3097) args3099 (:args m3097)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client3100
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials3098)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3100
       createHsmConfiguration
       (redshift/create-hsm-configuration-request
        (clojure.core/nth args3099 0)))))))
  (clojure.core/defn
   create-hsm-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         hsm-partition-name
                         hsm-configuration-identifier
                         hsm-partition-password
                         hsm-server-public-certificate
                         hsm-ip-address
                         description]}]]),
    :doc "Generate map for createHsmConfiguration"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :create-hsm-configuration,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-hsm-configuration
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         hsm-partition-name
                         hsm-configuration-identifier
                         hsm-partition-password
                         hsm-server-public-certificate
                         hsm-ip-address
                         description]}]]),
    :doc "Call createHsmConfiguration"}
   [credentials3102 & args3103]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client3104
     (com.palletops.awaze.common/aws-client :redshift credentials3102)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3104
      createHsmConfiguration
      (redshift/create-hsm-configuration-request
       (clojure.core/nth args3103 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-cluster-snapshots
   [m3105]
   (clojure.core/let
    [credentials3106 (:credentials m3105) args3107 (:args m3105)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client3108
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials3106)]
     (clojure.core/case
      (clojure.core/count args3107)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3108
        describeClusterSnapshots
        (redshift/describe-cluster-snapshots-request
         (clojure.core/nth args3107 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3108
        describeClusterSnapshots))))))
  (clojure.core/defn
   describe-cluster-snapshots-map
   {:arglists (quote
               [[credentials
                 {:keys [end-time
                         general-progress-listener
                         cluster-identifier
                         owner-account
                         max-records
                         start-time
                         marker
                         snapshot-identifier
                         snapshot-type]}]
                [credentials]]),
    :doc "Generate map for describeClusterSnapshots, describeClusterSnapshots"}
   ([credentials__1651__auto__]
    {:args [],
     :client :redshift,
     :fn :describe-cluster-snapshots,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :describe-cluster-snapshots,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-cluster-snapshots
   {:arglists (quote
               [[credentials
                 {:keys [end-time
                         general-progress-listener
                         cluster-identifier
                         owner-account
                         max-records
                         start-time
                         marker
                         snapshot-identifier
                         snapshot-type]}]
                [credentials]]),
    :doc "Call describeClusterSnapshots, describeClusterSnapshots"}
   [credentials3110 & args3111]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client3112
     (com.palletops.awaze.common/aws-client :redshift credentials3110)]
    (clojure.core/case
     (clojure.core/count args3111)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3112
       describeClusterSnapshots
       (redshift/describe-cluster-snapshots-request
        (clojure.core/nth args3111 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3112
       describeClusterSnapshots))))))
 (do
  (clojure.core/defmethod
   redshift
   :delete-cluster-snapshot
   [m3113]
   (clojure.core/let
    [credentials3114 (:credentials m3113) args3115 (:args m3113)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client3116
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials3114)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3116
       deleteClusterSnapshot
       (redshift/delete-cluster-snapshot-request
        (clojure.core/nth args3115 0)))))))
  (clojure.core/defn
   delete-cluster-snapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [snapshot-identifier
                         snapshot-cluster-identifier
                         general-progress-listener]}]]),
    :doc "Generate map for deleteClusterSnapshot"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :delete-cluster-snapshot,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-cluster-snapshot
   {:arglists (quote
               [[credentials
                 {:keys [snapshot-identifier
                         snapshot-cluster-identifier
                         general-progress-listener]}]]),
    :doc "Call deleteClusterSnapshot"}
   [credentials3118 & args3119]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client3120
     (com.palletops.awaze.common/aws-client :redshift credentials3118)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3120
      deleteClusterSnapshot
      (redshift/delete-cluster-snapshot-request
       (clojure.core/nth args3119 0)))))))
 (do
  (clojure.core/defmethod
   redshift
   :describe-orderable-cluster-options
   [m3121]
   (clojure.core/let
    [credentials3122 (:credentials m3121) args3123 (:args m3121)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
      client3124
      (com.palletops.awaze.common/aws-client
       :redshift
       credentials3122)]
     (clojure.core/case
      (clojure.core/count args3123)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3124
        describeOrderableClusterOptions))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3124
        describeOrderableClusterOptions
        (redshift/describe-orderable-cluster-options-request
         (clojure.core/nth args3123 0))))))))
  (clojure.core/defn
   describe-orderable-cluster-options-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [node-type
                         max-records
                         marker
                         general-progress-listener
                         cluster-version]}]]),
    :doc "Generate map for describeOrderableClusterOptions, describeOrderableClusterOptions"}
   ([credentials__1651__auto__]
    {:args [],
     :client :redshift,
     :fn :describe-orderable-cluster-options,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :redshift,
     :fn :describe-orderable-cluster-options,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-orderable-cluster-options
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [node-type
                         max-records
                         marker
                         general-progress-listener
                         cluster-version]}]]),
    :doc "Call describeOrderableClusterOptions, describeOrderableClusterOptions"}
   [credentials3126 & args3127]
   (clojure.core/let
    [^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
     client3128
     (com.palletops.awaze.common/aws-client :redshift credentials3126)]
    (clojure.core/case
     (clojure.core/count args3127)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3128
       describeOrderableClusterOptions))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.redshift.AmazonRedshiftClient}
client3128
       describeOrderableClusterOptions
       (redshift/describe-orderable-cluster-options-request
        (clojure.core/nth args3127 0)))))))))
