(ns
 com.palletops.awaze.route53
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.route53 :as route53]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :route53
  [___1600__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1601__auto__]
  (new
   com.amazonaws.services.route53.AmazonRoute53Client
   credentials__1601__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ResourceRecord}
resource-record
  [m11291]
  (clojure.core/let
   [bean11290
    (new com.amazonaws.services.route53.model.ResourceRecord)]
   (clojure.core/when-let
    [v11292 (:value m11291)]
    (. bean11290 setValue (clojure.core/str v11292)))
   bean11290))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.RRType}
rrtype
  [m11294]
  (.
   com.amazonaws.services.route53.model.RRType
   fromValue
   (clojure.core/name m11294)))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.AliasTarget}
alias-target
  [m11297]
  (clojure.core/let
   [bean11296 (new com.amazonaws.services.route53.model.AliasTarget)]
   (clojure.core/when-let
    [v11298 (:hosted-zone-id m11297)]
    (. bean11296 setHostedZoneId (clojure.core/str v11298)))
   (clojure.core/when-let
    [v11298 (:evaluate-target-health m11297)]
    (.
     bean11296
     setEvaluateTargetHealth
     (clojure.core/boolean v11298)))
   (clojure.core/when-let
    [v11298 (:dnsname m11297)]
    (. bean11296 setDNSName (clojure.core/str v11298)))
   bean11296))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ResourceRecordSet}
resource-record-set
  [m11300]
  (clojure.core/let
   [bean11299
    (new com.amazonaws.services.route53.model.ResourceRecordSet)]
   (clojure.core/when-let
    [v11301 (:health-check-id m11300)]
    (. bean11299 setHealthCheckId (clojure.core/str v11301)))
   (clojure.core/when-let
    [v11301 (:set-identifier m11300)]
    (. bean11299 setSetIdentifier (clojure.core/str v11301)))
   (clojure.core/when-let
    [v11301 (:ttl m11300)]
    (. bean11299 setTTL (clojure.core/long v11301)))
   (clojure.core/when-let
    [v11301 (:name m11300)]
    (. bean11299 setName (clojure.core/str v11301)))
   (clojure.core/when-let
    [v11301 (:resource-records m11300)]
    (.
     bean11299
     setResourceRecords
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg11347] (route53/resource-record arg11347))
 v11301)))
   (clojure.core/when-let
    [v11301 (:failover m11300)]
    (. bean11299 setFailover (clojure.core/str v11301)))
   (clojure.core/when-let
    [v11301 (:region m11300)]
    (. bean11299 setRegion (clojure.core/str v11301)))
   (clojure.core/when-let
    [v11301 (:weight m11300)]
    (. bean11299 setWeight (clojure.core/long v11301)))
   (clojure.core/when-let
    [v11301 (:type m11300)]
    (. bean11299 setType (route53/rrtype v11301)))
   (clojure.core/when-let
    [v11301 (:alias-target m11300)]
    (. bean11299 setAliasTarget (route53/alias-target v11301)))
   bean11299))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.Change}
change
  [m11303]
  (clojure.core/let
   [bean11302 (new com.amazonaws.services.route53.model.Change)]
   (clojure.core/when-let
    [v11304 (:action m11303)]
    (. bean11302 setAction (clojure.core/str v11304)))
   (clojure.core/when-let
    [v11304 (:resource-record-set m11303)]
    (.
     bean11302
     setResourceRecordSet
     (route53/resource-record-set v11304)))
   bean11302))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ChangeBatch}
change-batch
  [m11306]
  (clojure.core/let
   [bean11305 (new com.amazonaws.services.route53.model.ChangeBatch)]
   (clojure.core/when-let
    [v11307 (:comment m11306)]
    (. bean11305 setComment (clojure.core/str v11307)))
   (clojure.core/when-let
    [v11307 (:changes m11306)]
    (.
     bean11305
     setChanges
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg11348] (route53/change arg11348))
 v11307)))
   bean11305))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.HealthCheckConfig}
health-check-config
  [m11309]
  (clojure.core/let
   [bean11308
    (new com.amazonaws.services.route53.model.HealthCheckConfig)]
   (clojure.core/when-let
    [v11310 (:resource-path m11309)]
    (. bean11308 setResourcePath (clojure.core/str v11310)))
   (clojure.core/when-let
    [v11310 (:port m11309)]
    (. bean11308 setPort (clojure.core/int v11310)))
   (clojure.core/when-let
    [v11310 (:ipaddress m11309)]
    (. bean11308 setIPAddress (clojure.core/str v11310)))
   (clojure.core/when-let
    [v11310 (:fully-qualified-domain-name m11309)]
    (.
     bean11308
     setFullyQualifiedDomainName
     (clojure.core/str v11310)))
   (clojure.core/when-let
    [v11310 (:search-string m11309)]
    (. bean11308 setSearchString (clojure.core/str v11310)))
   (clojure.core/when-let
    [v11310 (:request-interval m11309)]
    (. bean11308 setRequestInterval (clojure.core/int v11310)))
   (clojure.core/when-let
    [v11310 (:failure-threshold m11309)]
    (. bean11308 setFailureThreshold (clojure.core/int v11310)))
   (clojure.core/when-let
    [v11310 (:type m11309)]
    (. bean11308 setType (clojure.core/str v11310)))
   bean11308))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.HostedZoneConfig}
hosted-zone-config
  [m11312]
  (clojure.core/let
   [bean11311
    (new com.amazonaws.services.route53.model.HostedZoneConfig)]
   (clojure.core/when-let
    [v11313 (:comment m11312)]
    (. bean11311 setComment (clojure.core/str v11313)))
   bean11311))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.GetHostedZoneRequest}
get-hosted-zone-request
  [m11315]
  (clojure.core/let
   [bean11314
    (new com.amazonaws.services.route53.model.GetHostedZoneRequest)]
   (clojure.core/when-let
    [v11316 (:id m11315)]
    (. bean11314 setId (clojure.core/str v11316)))
   bean11314))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ListHostedZonesRequest}
list-hosted-zones-request
  [m11318]
  (clojure.core/let
   [bean11317
    (new com.amazonaws.services.route53.model.ListHostedZonesRequest)]
   (clojure.core/when-let
    [v11319 (:marker m11318)]
    (. bean11317 setMarker (clojure.core/str v11319)))
   (clojure.core/when-let
    [v11319 (:max-items m11318)]
    (. bean11317 setMaxItems (clojure.core/str v11319)))
   bean11317))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ListResourceRecordSetsRequest}
list-resource-record-sets-request
  [m11321]
  (clojure.core/let
   [bean11320
    (new
     com.amazonaws.services.route53.model.ListResourceRecordSetsRequest)]
   (clojure.core/when-let
    [v11322 (:max-items m11321)]
    (. bean11320 setMaxItems (clojure.core/str v11322)))
   (clojure.core/when-let
    [v11322 (:hosted-zone-id m11321)]
    (. bean11320 setHostedZoneId (clojure.core/str v11322)))
   (clojure.core/when-let
    [v11322 (:start-record-name m11321)]
    (. bean11320 setStartRecordName (clojure.core/str v11322)))
   (clojure.core/when-let
    [v11322 (:start-record-type m11321)]
    (. bean11320 setStartRecordType (route53/rrtype v11322)))
   (clojure.core/when-let
    [v11322 (:start-record-identifier m11321)]
    (. bean11320 setStartRecordIdentifier (clojure.core/str v11322)))
   bean11320))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ChangeResourceRecordSetsRequest}
change-resource-record-sets-request
  [m11324]
  (clojure.core/let
   [bean11323
    (new
     com.amazonaws.services.route53.model.ChangeResourceRecordSetsRequest)]
   (clojure.core/when-let
    [v11325 (:hosted-zone-id m11324)]
    (. bean11323 setHostedZoneId (clojure.core/str v11325)))
   (clojure.core/when-let
    [v11325 (:change-batch m11324)]
    (. bean11323 setChangeBatch (route53/change-batch v11325)))
   bean11323))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.ListHealthChecksRequest}
list-health-checks-request
  [m11327]
  (clojure.core/let
   [bean11326
    (new com.amazonaws.services.route53.model.ListHealthChecksRequest)]
   (clojure.core/when-let
    [v11328 (:marker m11327)]
    (. bean11326 setMarker (clojure.core/str v11328)))
   (clojure.core/when-let
    [v11328 (:max-items m11327)]
    (. bean11326 setMaxItems (clojure.core/str v11328)))
   bean11326))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.CreateHealthCheckRequest}
create-health-check-request
  [m11330]
  (clojure.core/let
   [bean11329
    (new
     com.amazonaws.services.route53.model.CreateHealthCheckRequest)]
   (clojure.core/when-let
    [v11331 (:caller-reference m11330)]
    (. bean11329 setCallerReference (clojure.core/str v11331)))
   (clojure.core/when-let
    [v11331 (:health-check-config m11330)]
    (.
     bean11329
     setHealthCheckConfig
     (route53/health-check-config v11331)))
   bean11329))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.GetHealthCheckRequest}
get-health-check-request
  [m11333]
  (clojure.core/let
   [bean11332
    (new com.amazonaws.services.route53.model.GetHealthCheckRequest)]
   (clojure.core/when-let
    [v11334 (:health-check-id m11333)]
    (. bean11332 setHealthCheckId (clojure.core/str v11334)))
   bean11332))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.DeleteHostedZoneRequest}
delete-hosted-zone-request
  [m11336]
  (clojure.core/let
   [bean11335
    (new com.amazonaws.services.route53.model.DeleteHostedZoneRequest)]
   (clojure.core/when-let
    [v11337 (:id m11336)]
    (. bean11335 setId (clojure.core/str v11337)))
   bean11335))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.GetChangeRequest}
get-change-request
  [m11339]
  (clojure.core/let
   [bean11338
    (new com.amazonaws.services.route53.model.GetChangeRequest)]
   (clojure.core/when-let
    [v11340 (:id m11339)]
    (. bean11338 setId (clojure.core/str v11340)))
   bean11338))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.DeleteHealthCheckRequest}
delete-health-check-request
  [m11342]
  (clojure.core/let
   [bean11341
    (new
     com.amazonaws.services.route53.model.DeleteHealthCheckRequest)]
   (clojure.core/when-let
    [v11343 (:health-check-id m11342)]
    (. bean11341 setHealthCheckId (clojure.core/str v11343)))
   bean11341))
 (clojure.core/defn
^{:tag com.amazonaws.services.route53.model.CreateHostedZoneRequest}
create-hosted-zone-request
  [m11345]
  (clojure.core/let
   [bean11344
    (new com.amazonaws.services.route53.model.CreateHostedZoneRequest)]
   (clojure.core/when-let
    [v11346 (:name m11345)]
    (. bean11344 setName (clojure.core/str v11346)))
   (clojure.core/when-let
    [v11346 (:caller-reference m11345)]
    (. bean11344 setCallerReference (clojure.core/str v11346)))
   (clojure.core/when-let
    [v11346 (:hosted-zone-config m11345)]
    (.
     bean11344
     setHostedZoneConfig
     (route53/hosted-zone-config v11346)))
   bean11344))
 (clojure.core/defmulti
  route53
  (clojure.core/fn route53 [m__1683__auto__] (:fn m__1683__auto__)))
 (do
  (clojure.core/defmethod
   route53
   :get-hosted-zone
   [m11349]
   (clojure.core/let
    [credentials11350 (:credentials m11349) args11351 (:args m11349)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11352
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11350)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11352
       getHostedZone
       (route53/get-hosted-zone-request
        (clojure.core/nth args11351 0)))))))
  (clojure.core/defn
   get-hosted-zone-map
   {:arglists (quote
               [[credentials {:keys [id general-progress-listener]}]]),
    :doc "Generate map for getHostedZone"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :route53,
     :fn :get-hosted-zone,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   get-hosted-zone
   {:arglists (quote
               [[credentials {:keys [id general-progress-listener]}]]),
    :doc "Call getHostedZone"}
   [credentials11354 & args11355]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11356
     (com.palletops.awaze.common/aws-client :route53 credentials11354)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11356
      getHostedZone
      (route53/get-hosted-zone-request (clojure.core/nth args11355 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :list-hosted-zones
   [m11357]
   (clojure.core/let
    [credentials11358 (:credentials m11357) args11359 (:args m11357)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11360
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11358)]
     (clojure.core/case
      (clojure.core/count args11359)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11360
        listHostedZones))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11360
        listHostedZones
        (route53/list-hosted-zones-request
         (clojure.core/nth args11359 0))))))))
  (clojure.core/defn
   list-hosted-zones-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [max-items marker general-progress-listener]}]]),
    :doc "Generate map for listHostedZones, listHostedZones"}
   ([credentials__1651__auto__]
    {:args [],
     :client :route53,
     :fn :list-hosted-zones,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :route53,
     :fn :list-hosted-zones,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   list-hosted-zones
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [max-items marker general-progress-listener]}]]),
    :doc "Call listHostedZones, listHostedZones"}
   [credentials11362 & args11363]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11364
     (com.palletops.awaze.common/aws-client :route53 credentials11362)]
    (clojure.core/case
     (clojure.core/count args11363)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11364
       listHostedZones))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11364
       listHostedZones
       (route53/list-hosted-zones-request
        (clojure.core/nth args11363 0))))))))
 (do
  (clojure.core/defmethod
   route53
   :list-resource-record-sets
   [m11365]
   (clojure.core/let
    [credentials11366 (:credentials m11365) args11367 (:args m11365)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11368
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11366)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11368
       listResourceRecordSets
       (route53/list-resource-record-sets-request
        (clojure.core/nth args11367 0)))))))
  (clojure.core/defn
   list-resource-record-sets-map
   {:arglists (quote
               [[credentials
                 {:keys [start-record-name
                         max-items
                         general-progress-listener
                         hosted-zone-id
                         start-record-identifier
                         start-record-type]}]]),
    :doc "Generate map for listResourceRecordSets"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :route53,
     :fn :list-resource-record-sets,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   list-resource-record-sets
   {:arglists (quote
               [[credentials
                 {:keys [start-record-name
                         max-items
                         general-progress-listener
                         hosted-zone-id
                         start-record-identifier
                         start-record-type]}]]),
    :doc "Call listResourceRecordSets"}
   [credentials11370 & args11371]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11372
     (com.palletops.awaze.common/aws-client :route53 credentials11370)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11372
      listResourceRecordSets
      (route53/list-resource-record-sets-request
       (clojure.core/nth args11371 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :change-resource-record-sets
   [m11373]
   (clojure.core/let
    [credentials11374 (:credentials m11373) args11375 (:args m11373)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11376
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11374)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11376
       changeResourceRecordSets
       (route53/change-resource-record-sets-request
        (clojure.core/nth args11375 0)))))))
  (clojure.core/defn
   change-resource-record-sets-map
   {:arglists (quote
               [[credentials
                 {:keys [hosted-zone-id
                         general-progress-listener
                         change-batch]}]]),
    :doc "Generate map for changeResourceRecordSets"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :route53,
     :fn :change-resource-record-sets,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   change-resource-record-sets
   {:arglists (quote
               [[credentials
                 {:keys [hosted-zone-id
                         general-progress-listener
                         change-batch]}]]),
    :doc "Call changeResourceRecordSets"}
   [credentials11378 & args11379]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11380
     (com.palletops.awaze.common/aws-client :route53 credentials11378)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11380
      changeResourceRecordSets
      (route53/change-resource-record-sets-request
       (clojure.core/nth args11379 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :list-health-checks
   [m11381]
   (clojure.core/let
    [credentials11382 (:credentials m11381) args11383 (:args m11381)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11384
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11382)]
     (clojure.core/case
      (clojure.core/count args11383)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11384
        listHealthChecks
        (route53/list-health-checks-request
         (clojure.core/nth args11383 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11384
        listHealthChecks))))))
  (clojure.core/defn
   list-health-checks-map
   {:arglists (quote
               [[credentials
                 {:keys [max-items marker general-progress-listener]}]
                [credentials]]),
    :doc "Generate map for listHealthChecks, listHealthChecks"}
   ([credentials__1651__auto__]
    {:args [],
     :client :route53,
     :fn :list-health-checks,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :route53,
     :fn :list-health-checks,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   list-health-checks
   {:arglists (quote
               [[credentials
                 {:keys [max-items marker general-progress-listener]}]
                [credentials]]),
    :doc "Call listHealthChecks, listHealthChecks"}
   [credentials11386 & args11387]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11388
     (com.palletops.awaze.common/aws-client :route53 credentials11386)]
    (clojure.core/case
     (clojure.core/count args11387)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11388
       listHealthChecks
       (route53/list-health-checks-request
        (clojure.core/nth args11387 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11388
       listHealthChecks))))))
 (do
  (clojure.core/defmethod
   route53
   :create-health-check
   [m11389]
   (clojure.core/let
    [credentials11390 (:credentials m11389) args11391 (:args m11389)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11392
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11390)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11392
       createHealthCheck
       (route53/create-health-check-request
        (clojure.core/nth args11391 0)))))))
  (clojure.core/defn
   create-health-check-map
   {:arglists (quote
               [[credentials
                 {:keys [health-check-config
                         general-progress-listener
                         caller-reference]}]]),
    :doc "Generate map for createHealthCheck"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :route53,
     :fn :create-health-check,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-health-check
   {:arglists (quote
               [[credentials
                 {:keys [health-check-config
                         general-progress-listener
                         caller-reference]}]]),
    :doc "Call createHealthCheck"}
   [credentials11394 & args11395]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11396
     (com.palletops.awaze.common/aws-client :route53 credentials11394)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11396
      createHealthCheck
      (route53/create-health-check-request
       (clojure.core/nth args11395 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :get-health-check
   [m11397]
   (clojure.core/let
    [credentials11398 (:credentials m11397) args11399 (:args m11397)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11400
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11398)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11400
       getHealthCheck
       (route53/get-health-check-request
        (clojure.core/nth args11399 0)))))))
  (clojure.core/defn
   get-health-check-map
   {:arglists (quote
               [[credentials
                 {:keys [health-check-id general-progress-listener]}]]),
    :doc "Generate map for getHealthCheck"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :route53,
     :fn :get-health-check,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   get-health-check
   {:arglists (quote
               [[credentials
                 {:keys [health-check-id general-progress-listener]}]]),
    :doc "Call getHealthCheck"}
   [credentials11402 & args11403]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11404
     (com.palletops.awaze.common/aws-client :route53 credentials11402)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11404
      getHealthCheck
      (route53/get-health-check-request
       (clojure.core/nth args11403 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :delete-hosted-zone
   [m11405]
   (clojure.core/let
    [credentials11406 (:credentials m11405) args11407 (:args m11405)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11408
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11406)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11408
       deleteHostedZone
       (route53/delete-hosted-zone-request
        (clojure.core/nth args11407 0)))))))
  (clojure.core/defn
   delete-hosted-zone-map
   {:arglists (quote
               [[credentials {:keys [id general-progress-listener]}]]),
    :doc "Generate map for deleteHostedZone"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :route53,
     :fn :delete-hosted-zone,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-hosted-zone
   {:arglists (quote
               [[credentials {:keys [id general-progress-listener]}]]),
    :doc "Call deleteHostedZone"}
   [credentials11410 & args11411]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11412
     (com.palletops.awaze.common/aws-client :route53 credentials11410)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11412
      deleteHostedZone
      (route53/delete-hosted-zone-request
       (clojure.core/nth args11411 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :get-change
   [m11413]
   (clojure.core/let
    [credentials11414 (:credentials m11413) args11415 (:args m11413)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11416
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11414)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11416
       getChange
       (route53/get-change-request (clojure.core/nth args11415 0)))))))
  (clojure.core/defn
   get-change-map
   {:arglists (quote
               [[credentials {:keys [id general-progress-listener]}]]),
    :doc "Generate map for getChange"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :route53,
     :fn :get-change,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   get-change
   {:arglists (quote
               [[credentials {:keys [id general-progress-listener]}]]),
    :doc "Call getChange"}
   [credentials11418 & args11419]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11420
     (com.palletops.awaze.common/aws-client :route53 credentials11418)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11420
      getChange
      (route53/get-change-request (clojure.core/nth args11419 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :delete-health-check
   [m11421]
   (clojure.core/let
    [credentials11422 (:credentials m11421) args11423 (:args m11421)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11424
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11422)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11424
       deleteHealthCheck
       (route53/delete-health-check-request
        (clojure.core/nth args11423 0)))))))
  (clojure.core/defn
   delete-health-check-map
   {:arglists (quote
               [[credentials
                 {:keys [health-check-id general-progress-listener]}]]),
    :doc "Generate map for deleteHealthCheck"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :route53,
     :fn :delete-health-check,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-health-check
   {:arglists (quote
               [[credentials
                 {:keys [health-check-id general-progress-listener]}]]),
    :doc "Call deleteHealthCheck"}
   [credentials11426 & args11427]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11428
     (com.palletops.awaze.common/aws-client :route53 credentials11426)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11428
      deleteHealthCheck
      (route53/delete-health-check-request
       (clojure.core/nth args11427 0)))))))
 (do
  (clojure.core/defmethod
   route53
   :create-hosted-zone
   [m11429]
   (clojure.core/let
    [credentials11430 (:credentials m11429) args11431 (:args m11429)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
      client11432
      (com.palletops.awaze.common/aws-client
       :route53
       credentials11430)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11432
       createHostedZone
       (route53/create-hosted-zone-request
        (clojure.core/nth args11431 0)))))))
  (clojure.core/defn
   create-hosted-zone-map
   {:arglists (quote
               [[credentials
                 {:keys [name
                         hosted-zone-config
                         general-progress-listener
                         caller-reference]}]]),
    :doc "Generate map for createHostedZone"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :route53,
     :fn :create-hosted-zone,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-hosted-zone
   {:arglists (quote
               [[credentials
                 {:keys [name
                         hosted-zone-config
                         general-progress-listener
                         caller-reference]}]]),
    :doc "Call createHostedZone"}
   [credentials11434 & args11435]
   (clojure.core/let
    [^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
     client11436
     (com.palletops.awaze.common/aws-client :route53 credentials11434)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.route53.AmazonRoute53Client}
client11436
      createHostedZone
      (route53/create-hosted-zone-request
       (clojure.core/nth args11435 0))))))))
