(ns
 com.palletops.awaze.simpledb
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.simpledb :as simpledb]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :simpledb
  [___1600__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1601__auto__]
  (new
   com.amazonaws.services.simpledb.AmazonSimpleDBClient
   credentials__1601__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpledb.model.Attribute}
attribute
  [m4331]
  (clojure.core/let
   [bean4330 (new com.amazonaws.services.simpledb.model.Attribute)]
   (clojure.core/when-let
    [v4332 (:name m4331)]
    (. bean4330 setName (clojure.core/str v4332)))
   (clojure.core/when-let
    [v4332 (:value m4331)]
    (. bean4330 setValue (clojure.core/str v4332)))
   (clojure.core/when-let
    [v4332 (:alternate-name-encoding m4331)]
    (. bean4330 setAlternateNameEncoding (clojure.core/str v4332)))
   (clojure.core/when-let
    [v4332 (:alternate-value-encoding m4331)]
    (. bean4330 setAlternateValueEncoding (clojure.core/str v4332)))
   bean4330))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpledb.model.ReplaceableAttribute}
replaceable-attribute
  [m4334]
  (clojure.core/let
   [bean4333
    (new com.amazonaws.services.simpledb.model.ReplaceableAttribute)]
   (clojure.core/when-let
    [v4335 (:name m4334)]
    (. bean4333 setName (clojure.core/str v4335)))
   (clojure.core/when-let
    [v4335 (:value m4334)]
    (. bean4333 setValue (clojure.core/str v4335)))
   (clojure.core/when-let
    [v4335 (:replace m4334)]
    (. bean4333 setReplace (clojure.core/boolean v4335)))
   bean4333))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpledb.model.DeletableItem}
deletable-item
  [m4337]
  (clojure.core/let
   [bean4336
    (new com.amazonaws.services.simpledb.model.DeletableItem)]
   (clojure.core/when-let
    [v4338 (:name m4337)]
    (. bean4336 setName (clojure.core/str v4338)))
   (clojure.core/when-let
    [v4338 (:attributes m4337)]
    (.
     bean4336
     setAttributes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4375] (simpledb/attribute arg4375))
 v4338)))
   bean4336))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpledb.model.UpdateCondition}
update-condition
  [m4340]
  (clojure.core/let
   [bean4339
    (new com.amazonaws.services.simpledb.model.UpdateCondition)]
   (clojure.core/when-let
    [v4341 (:name m4340)]
    (. bean4339 setName (clojure.core/str v4341)))
   (clojure.core/when-let
    [v4341 (:value m4340)]
    (. bean4339 setValue (clojure.core/str v4341)))
   (clojure.core/when-let
    [v4341 (:exists m4340)]
    (. bean4339 setExists (clojure.core/boolean v4341)))
   bean4339))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpledb.model.ReplaceableItem}
replaceable-item
  [m4343]
  (clojure.core/let
   [bean4342
    (new com.amazonaws.services.simpledb.model.ReplaceableItem)]
   (clojure.core/when-let
    [v4344 (:name m4343)]
    (. bean4342 setName (clojure.core/str v4344)))
   (clojure.core/when-let
    [v4344 (:attributes m4343)]
    (.
     bean4342
     setAttributes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4376] (simpledb/replaceable-attribute arg4376))
 v4344)))
   bean4342))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpledb.model.DomainMetadataRequest}
domain-metadata-request
  [m4346]
  (clojure.core/let
   [bean4345
    (new com.amazonaws.services.simpledb.model.DomainMetadataRequest)]
   (clojure.core/when-let
    [v4347 (:domain-name m4346)]
    (. bean4345 setDomainName (clojure.core/str v4347)))
   bean4345))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpledb.model.GetAttributesRequest}
get-attributes-request
  [m4349]
  (clojure.core/let
   [bean4348
    (new com.amazonaws.services.simpledb.model.GetAttributesRequest)]
   (clojure.core/when-let
    [v4350 (:domain-name m4349)]
    (. bean4348 setDomainName (clojure.core/str v4350)))
   (clojure.core/when-let
    [v4350 (:item-name m4349)]
    (. bean4348 setItemName (clojure.core/str v4350)))
   (clojure.core/when-let
    [v4350 (:attribute-names m4349)]
    (.
     bean4348
     setAttributeNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4377] (clojure.core/str arg4377))
 v4350)))
   (clojure.core/when-let
    [v4350 (:consistent-read m4349)]
    (. bean4348 setConsistentRead (clojure.core/boolean v4350)))
   bean4348))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpledb.model.CreateDomainRequest}
create-domain-request
  [m4352]
  (clojure.core/let
   [bean4351
    (new com.amazonaws.services.simpledb.model.CreateDomainRequest)]
   (clojure.core/when-let
    [v4353 (:domain-name m4352)]
    (. bean4351 setDomainName (clojure.core/str v4353)))
   bean4351))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpledb.model.BatchDeleteAttributesRequest}
batch-delete-attributes-request
  [m4355]
  (clojure.core/let
   [bean4354
    (new
     com.amazonaws.services.simpledb.model.BatchDeleteAttributesRequest)]
   (clojure.core/when-let
    [v4356 (:items m4355)]
    (.
     bean4354
     setItems
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4378] (simpledb/deletable-item arg4378))
 v4356)))
   (clojure.core/when-let
    [v4356 (:domain-name m4355)]
    (. bean4354 setDomainName (clojure.core/str v4356)))
   bean4354))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpledb.model.ListDomainsRequest}
list-domains-request
  [m4358]
  (clojure.core/let
   [bean4357
    (new com.amazonaws.services.simpledb.model.ListDomainsRequest)]
   (clojure.core/when-let
    [v4359 (:next-token m4358)]
    (. bean4357 setNextToken (clojure.core/str v4359)))
   (clojure.core/when-let
    [v4359 (:max-number-of-domains m4358)]
    (. bean4357 setMaxNumberOfDomains (clojure.core/int v4359)))
   bean4357))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpledb.model.PutAttributesRequest}
put-attributes-request
  [m4361]
  (clojure.core/let
   [bean4360
    (new com.amazonaws.services.simpledb.model.PutAttributesRequest)]
   (clojure.core/when-let
    [v4362 (:domain-name m4361)]
    (. bean4360 setDomainName (clojure.core/str v4362)))
   (clojure.core/when-let
    [v4362 (:item-name m4361)]
    (. bean4360 setItemName (clojure.core/str v4362)))
   (clojure.core/when-let
    [v4362 (:expected m4361)]
    (. bean4360 setExpected (simpledb/update-condition v4362)))
   (clojure.core/when-let
    [v4362 (:attributes m4361)]
    (.
     bean4360
     setAttributes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4379] (simpledb/replaceable-attribute arg4379))
 v4362)))
   bean4360))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpledb.model.DeleteAttributesRequest}
delete-attributes-request
  [m4364]
  (clojure.core/let
   [bean4363
    (new
     com.amazonaws.services.simpledb.model.DeleteAttributesRequest)]
   (clojure.core/when-let
    [v4365 (:domain-name m4364)]
    (. bean4363 setDomainName (clojure.core/str v4365)))
   (clojure.core/when-let
    [v4365 (:item-name m4364)]
    (. bean4363 setItemName (clojure.core/str v4365)))
   (clojure.core/when-let
    [v4365 (:expected m4364)]
    (. bean4363 setExpected (simpledb/update-condition v4365)))
   (clojure.core/when-let
    [v4365 (:attributes m4364)]
    (.
     bean4363
     setAttributes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4380] (simpledb/attribute arg4380))
 v4365)))
   bean4363))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpledb.model.BatchPutAttributesRequest}
batch-put-attributes-request
  [m4367]
  (clojure.core/let
   [bean4366
    (new
     com.amazonaws.services.simpledb.model.BatchPutAttributesRequest)]
   (clojure.core/when-let
    [v4368 (:items m4367)]
    (.
     bean4366
     setItems
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4381] (simpledb/replaceable-item arg4381))
 v4368)))
   (clojure.core/when-let
    [v4368 (:domain-name m4367)]
    (. bean4366 setDomainName (clojure.core/str v4368)))
   bean4366))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpledb.model.DeleteDomainRequest}
delete-domain-request
  [m4370]
  (clojure.core/let
   [bean4369
    (new com.amazonaws.services.simpledb.model.DeleteDomainRequest)]
   (clojure.core/when-let
    [v4371 (:domain-name m4370)]
    (. bean4369 setDomainName (clojure.core/str v4371)))
   bean4369))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpledb.model.SelectRequest}
select-request
  [m4373]
  (clojure.core/let
   [bean4372
    (new com.amazonaws.services.simpledb.model.SelectRequest)]
   (clojure.core/when-let
    [v4374 (:next-token m4373)]
    (. bean4372 setNextToken (clojure.core/str v4374)))
   (clojure.core/when-let
    [v4374 (:select-expression m4373)]
    (. bean4372 setSelectExpression (clojure.core/str v4374)))
   (clojure.core/when-let
    [v4374 (:consistent-read m4373)]
    (. bean4372 setConsistentRead (clojure.core/boolean v4374)))
   bean4372))
 (clojure.core/defmulti
  simpledb
  (clojure.core/fn simpledb [m__1683__auto__] (:fn m__1683__auto__)))
 (do
  (clojure.core/defmethod
   simpledb
   :domain-metadata
   [m4382]
   (clojure.core/let
    [credentials4383 (:credentials m4382) args4384 (:args m4382)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
      client4385
      (com.palletops.awaze.common/aws-client
       :simpledb
       credentials4383)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client4385
       domainMetadata
       (simpledb/domain-metadata-request
        (clojure.core/nth args4384 0)))))))
  (clojure.core/defn
   domain-metadata-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener domain-name]}]]),
    :doc "Generate map for domainMetadata"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :simpledb,
     :fn :domain-metadata,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   domain-metadata
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener domain-name]}]]),
    :doc "Call domainMetadata"}
   [credentials4387 & args4388]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
     client4389
     (com.palletops.awaze.common/aws-client :simpledb credentials4387)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client4389
      domainMetadata
      (simpledb/domain-metadata-request (clojure.core/nth args4388 0)))))))
 (do
  (clojure.core/defmethod
   simpledb
   :get-attributes
   [m4390]
   (clojure.core/let
    [credentials4391 (:credentials m4390) args4392 (:args m4390)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
      client4393
      (com.palletops.awaze.common/aws-client
       :simpledb
       credentials4391)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client4393
       getAttributes
       (simpledb/get-attributes-request (clojure.core/nth args4392 0)))))))
  (clojure.core/defn
   get-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [item-name
                         general-progress-listener
                         domain-name
                         consistent-read
                         attribute-names]}]]),
    :doc "Generate map for getAttributes"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :simpledb,
     :fn :get-attributes,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   get-attributes
   {:arglists (quote
               [[credentials
                 {:keys [item-name
                         general-progress-listener
                         domain-name
                         consistent-read
                         attribute-names]}]]),
    :doc "Call getAttributes"}
   [credentials4395 & args4396]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
     client4397
     (com.palletops.awaze.common/aws-client :simpledb credentials4395)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client4397
      getAttributes
      (simpledb/get-attributes-request (clojure.core/nth args4396 0)))))))
 (do
  (clojure.core/defmethod
   simpledb
   :create-domain
   [m4398]
   (clojure.core/let
    [credentials4399 (:credentials m4398) args4400 (:args m4398)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
      client4401
      (com.palletops.awaze.common/aws-client
       :simpledb
       credentials4399)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client4401
       createDomain
       (simpledb/create-domain-request (clojure.core/nth args4400 0)))))))
  (clojure.core/defn
   create-domain-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener domain-name]}]]),
    :doc "Generate map for createDomain"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :simpledb,
     :fn :create-domain,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-domain
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener domain-name]}]]),
    :doc "Call createDomain"}
   [credentials4403 & args4404]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
     client4405
     (com.palletops.awaze.common/aws-client :simpledb credentials4403)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client4405
      createDomain
      (simpledb/create-domain-request (clojure.core/nth args4404 0)))))))
 (do
  (clojure.core/defmethod
   simpledb
   :batch-delete-attributes
   [m4406]
   (clojure.core/let
    [credentials4407 (:credentials m4406) args4408 (:args m4406)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
      client4409
      (com.palletops.awaze.common/aws-client
       :simpledb
       credentials4407)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client4409
       batchDeleteAttributes
       (simpledb/batch-delete-attributes-request
        (clojure.core/nth args4408 0)))))))
  (clojure.core/defn
   batch-delete-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [items general-progress-listener domain-name]}]]),
    :doc "Generate map for batchDeleteAttributes"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :simpledb,
     :fn :batch-delete-attributes,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   batch-delete-attributes
   {:arglists (quote
               [[credentials
                 {:keys [items general-progress-listener domain-name]}]]),
    :doc "Call batchDeleteAttributes"}
   [credentials4411 & args4412]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
     client4413
     (com.palletops.awaze.common/aws-client :simpledb credentials4411)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client4413
      batchDeleteAttributes
      (simpledb/batch-delete-attributes-request
       (clojure.core/nth args4412 0)))))))
 (do
  (clojure.core/defmethod
   simpledb
   :list-domains
   [m4414]
   (clojure.core/let
    [credentials4415 (:credentials m4414) args4416 (:args m4414)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
      client4417
      (com.palletops.awaze.common/aws-client
       :simpledb
       credentials4415)]
     (clojure.core/case
      (clojure.core/count args4416)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client4417
        listDomains))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client4417
        listDomains
        (simpledb/list-domains-request (clojure.core/nth args4416 0))))))))
  (clojure.core/defn
   list-domains-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [next-token
                         max-number-of-domains
                         general-progress-listener]}]]),
    :doc "Generate map for listDomains, listDomains"}
   ([credentials__1651__auto__]
    {:args [],
     :client :simpledb,
     :fn :list-domains,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :simpledb,
     :fn :list-domains,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   list-domains
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [next-token
                         max-number-of-domains
                         general-progress-listener]}]]),
    :doc "Call listDomains, listDomains"}
   [credentials4419 & args4420]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
     client4421
     (com.palletops.awaze.common/aws-client :simpledb credentials4419)]
    (clojure.core/case
     (clojure.core/count args4420)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client4421
       listDomains))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client4421
       listDomains
       (simpledb/list-domains-request (clojure.core/nth args4420 0))))))))
 (do
  (clojure.core/defmethod
   simpledb
   :put-attributes
   [m4422]
   (clojure.core/let
    [credentials4423 (:credentials m4422) args4424 (:args m4422)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
      client4425
      (com.palletops.awaze.common/aws-client
       :simpledb
       credentials4423)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client4425
       putAttributes
       (simpledb/put-attributes-request (clojure.core/nth args4424 0)))))))
  (clojure.core/defn
   put-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [item-name
                         general-progress-listener
                         expected
                         domain-name
                         attributes]}]]),
    :doc "Generate map for putAttributes"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :simpledb,
     :fn :put-attributes,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   put-attributes
   {:arglists (quote
               [[credentials
                 {:keys [item-name
                         general-progress-listener
                         expected
                         domain-name
                         attributes]}]]),
    :doc "Call putAttributes"}
   [credentials4427 & args4428]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
     client4429
     (com.palletops.awaze.common/aws-client :simpledb credentials4427)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client4429
      putAttributes
      (simpledb/put-attributes-request (clojure.core/nth args4428 0)))))))
 (do
  (clojure.core/defmethod
   simpledb
   :delete-attributes
   [m4430]
   (clojure.core/let
    [credentials4431 (:credentials m4430) args4432 (:args m4430)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
      client4433
      (com.palletops.awaze.common/aws-client
       :simpledb
       credentials4431)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client4433
       deleteAttributes
       (simpledb/delete-attributes-request
        (clojure.core/nth args4432 0)))))))
  (clojure.core/defn
   delete-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [item-name
                         general-progress-listener
                         expected
                         domain-name
                         attributes]}]]),
    :doc "Generate map for deleteAttributes"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :simpledb,
     :fn :delete-attributes,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-attributes
   {:arglists (quote
               [[credentials
                 {:keys [item-name
                         general-progress-listener
                         expected
                         domain-name
                         attributes]}]]),
    :doc "Call deleteAttributes"}
   [credentials4435 & args4436]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
     client4437
     (com.palletops.awaze.common/aws-client :simpledb credentials4435)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client4437
      deleteAttributes
      (simpledb/delete-attributes-request
       (clojure.core/nth args4436 0)))))))
 (do
  (clojure.core/defmethod
   simpledb
   :batch-put-attributes
   [m4438]
   (clojure.core/let
    [credentials4439 (:credentials m4438) args4440 (:args m4438)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
      client4441
      (com.palletops.awaze.common/aws-client
       :simpledb
       credentials4439)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client4441
       batchPutAttributes
       (simpledb/batch-put-attributes-request
        (clojure.core/nth args4440 0)))))))
  (clojure.core/defn
   batch-put-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [items general-progress-listener domain-name]}]]),
    :doc "Generate map for batchPutAttributes"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :simpledb,
     :fn :batch-put-attributes,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   batch-put-attributes
   {:arglists (quote
               [[credentials
                 {:keys [items general-progress-listener domain-name]}]]),
    :doc "Call batchPutAttributes"}
   [credentials4443 & args4444]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
     client4445
     (com.palletops.awaze.common/aws-client :simpledb credentials4443)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client4445
      batchPutAttributes
      (simpledb/batch-put-attributes-request
       (clojure.core/nth args4444 0)))))))
 (do
  (clojure.core/defmethod
   simpledb
   :delete-domain
   [m4446]
   (clojure.core/let
    [credentials4447 (:credentials m4446) args4448 (:args m4446)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
      client4449
      (com.palletops.awaze.common/aws-client
       :simpledb
       credentials4447)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client4449
       deleteDomain
       (simpledb/delete-domain-request (clojure.core/nth args4448 0)))))))
  (clojure.core/defn
   delete-domain-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener domain-name]}]]),
    :doc "Generate map for deleteDomain"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :simpledb,
     :fn :delete-domain,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-domain
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener domain-name]}]]),
    :doc "Call deleteDomain"}
   [credentials4451 & args4452]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
     client4453
     (com.palletops.awaze.common/aws-client :simpledb credentials4451)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client4453
      deleteDomain
      (simpledb/delete-domain-request (clojure.core/nth args4452 0)))))))
 (do
  (clojure.core/defmethod
   simpledb
   :select
   [m4454]
   (clojure.core/let
    [credentials4455 (:credentials m4454) args4456 (:args m4454)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
      client4457
      (com.palletops.awaze.common/aws-client
       :simpledb
       credentials4455)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client4457
       select
       (simpledb/select-request (clojure.core/nth args4456 0)))))))
  (clojure.core/defn
   select-map
   {:arglists (quote
               [[credentials
                 {:keys [select-expression
                         next-token
                         general-progress-listener
                         consistent-read]}]]),
    :doc "Generate map for select"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :simpledb,
     :fn :select,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   select
   {:arglists (quote
               [[credentials
                 {:keys [select-expression
                         next-token
                         general-progress-listener
                         consistent-read]}]]),
    :doc "Call select"}
   [credentials4459 & args4460]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
     client4461
     (com.palletops.awaze.common/aws-client :simpledb credentials4459)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client4461
      select
      (simpledb/select-request (clojure.core/nth args4460 0))))))))
