(ns
 com.palletops.awaze.simpleemail
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.simpleemail :as simpleemail]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :simpleemail
  [___1600__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1601__auto__]
  (new
   com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient
   credentials__1601__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.Content}
content
  [m1756]
  (clojure.core/let
   [bean1755 (new com.amazonaws.services.simpleemail.model.Content)]
   (clojure.core/when-let
    [v1757 (:charset m1756)]
    (. bean1755 setCharset (clojure.core/str v1757)))
   (clojure.core/when-let
    [v1757 (:data m1756)]
    (. bean1755 setData (clojure.core/str v1757)))
   bean1755))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.Body}
body
  [m1759]
  (clojure.core/let
   [bean1758 (new com.amazonaws.services.simpleemail.model.Body)]
   (clojure.core/when-let
    [v1760 (:text m1759)]
    (. bean1758 setText (simpleemail/content v1760)))
   (clojure.core/when-let
    [v1760 (:html m1759)]
    (. bean1758 setHtml (simpleemail/content v1760)))
   bean1758))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.Destination}
destination
  [m1762]
  (clojure.core/let
   [bean1761
    (new com.amazonaws.services.simpleemail.model.Destination)]
   (clojure.core/when-let
    [v1763 (:to-addresses m1762)]
    (.
     bean1761
     setToAddresses
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg1827] (clojure.core/str arg1827))
 v1763)))
   (clojure.core/when-let
    [v1763 (:cc-addresses m1762)]
    (.
     bean1761
     setCcAddresses
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg1828] (clojure.core/str arg1828))
 v1763)))
   (clojure.core/when-let
    [v1763 (:bcc-addresses m1762)]
    (.
     bean1761
     setBccAddresses
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg1829] (clojure.core/str arg1829))
 v1763)))
   bean1761))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.Message}
message
  [m1765]
  (clojure.core/let
   [bean1764 (new com.amazonaws.services.simpleemail.model.Message)]
   (clojure.core/when-let
    [v1766 (:subject m1765)]
    (. bean1764 setSubject (simpleemail/content v1766)))
   (clojure.core/when-let
    [v1766 (:body m1765)]
    (. bean1764 setBody (simpleemail/body v1766)))
   bean1764))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.RawMessage}
raw-message
  [m1768]
  (clojure.core/let
   [bean1767
    (new com.amazonaws.services.simpleemail.model.RawMessage)]
   (clojure.core/when-let
    [v1769 (:data m1768)]
    (. bean1767 setData (clojure.core/identity v1769)))
   bean1767))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.NotificationType}
notification-type
  [m1771]
  (.
   com.amazonaws.services.simpleemail.model.NotificationType
   fromValue
   (clojure.core/name m1771)))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.SendEmailRequest}
send-email-request
  [m1774]
  (clojure.core/let
   [bean1773
    (new com.amazonaws.services.simpleemail.model.SendEmailRequest)]
   (clojure.core/when-let
    [v1775 (:source m1774)]
    (. bean1773 setSource (clojure.core/str v1775)))
   (clojure.core/when-let
    [v1775 (:destination m1774)]
    (. bean1773 setDestination (simpleemail/destination v1775)))
   (clojure.core/when-let
    [v1775 (:message m1774)]
    (. bean1773 setMessage (simpleemail/message v1775)))
   (clojure.core/when-let
    [v1775 (:reply-to-addresses m1774)]
    (.
     bean1773
     setReplyToAddresses
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg1830] (clojure.core/str arg1830))
 v1775)))
   (clojure.core/when-let
    [v1775 (:return-path m1774)]
    (. bean1773 setReturnPath (clojure.core/str v1775)))
   bean1773))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.ListVerifiedEmailAddressesRequest}
list-verified-email-addresses-request
  [m1777]
  (clojure.core/let
   [bean1776
    (new
     com.amazonaws.services.simpleemail.model.ListVerifiedEmailAddressesRequest)]
   bean1776))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.GetSendStatisticsRequest}
get-send-statistics-request
  [m1780]
  (clojure.core/let
   [bean1779
    (new
     com.amazonaws.services.simpleemail.model.GetSendStatisticsRequest)]
   bean1779))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.DeleteVerifiedEmailAddressRequest}
delete-verified-email-address-request
  [m1783]
  (clojure.core/let
   [bean1782
    (new
     com.amazonaws.services.simpleemail.model.DeleteVerifiedEmailAddressRequest)]
   (clojure.core/when-let
    [v1784 (:email-address m1783)]
    (. bean1782 setEmailAddress (clojure.core/str v1784)))
   bean1782))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.SetIdentityDkimEnabledRequest}
set-identity-dkim-enabled-request
  [m1786]
  (clojure.core/let
   [bean1785
    (new
     com.amazonaws.services.simpleemail.model.SetIdentityDkimEnabledRequest)]
   (clojure.core/when-let
    [v1787 (:identity m1786)]
    (. bean1785 setIdentity (clojure.core/str v1787)))
   (clojure.core/when-let
    [v1787 (:dkim-enabled m1786)]
    (. bean1785 setDkimEnabled (clojure.core/boolean v1787)))
   bean1785))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.SetIdentityFeedbackForwardingEnabledRequest}
set-identity-feedback-forwarding-enabled-request
  [m1789]
  (clojure.core/let
   [bean1788
    (new
     com.amazonaws.services.simpleemail.model.SetIdentityFeedbackForwardingEnabledRequest)]
   (clojure.core/when-let
    [v1790 (:identity m1789)]
    (. bean1788 setIdentity (clojure.core/str v1790)))
   (clojure.core/when-let
    [v1790 (:forwarding-enabled m1789)]
    (. bean1788 setForwardingEnabled (clojure.core/boolean v1790)))
   bean1788))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.SendRawEmailRequest}
send-raw-email-request
  [m1792]
  (clojure.core/let
   [bean1791
    (new com.amazonaws.services.simpleemail.model.SendRawEmailRequest)]
   (clojure.core/when-let
    [v1793 (:source m1792)]
    (. bean1791 setSource (clojure.core/str v1793)))
   (clojure.core/when-let
    [v1793 (:destinations m1792)]
    (.
     bean1791
     setDestinations
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg1831] (clojure.core/str arg1831))
 v1793)))
   (clojure.core/when-let
    [v1793 (:raw-message m1792)]
    (. bean1791 setRawMessage (simpleemail/raw-message v1793)))
   bean1791))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.GetIdentityNotificationAttributesRequest}
get-identity-notification-attributes-request
  [m1795]
  (clojure.core/let
   [bean1794
    (new
     com.amazonaws.services.simpleemail.model.GetIdentityNotificationAttributesRequest)]
   (clojure.core/when-let
    [v1796 (:identities m1795)]
    (.
     bean1794
     setIdentities
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg1832] (clojure.core/str arg1832))
 v1796)))
   bean1794))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.ListIdentitiesRequest}
list-identities-request
  [m1798]
  (clojure.core/let
   [bean1797
    (new
     com.amazonaws.services.simpleemail.model.ListIdentitiesRequest)]
   (clojure.core/when-let
    [v1799 (:identity-type m1798)]
    (. bean1797 setIdentityType (clojure.core/str v1799)))
   (clojure.core/when-let
    [v1799 (:next-token m1798)]
    (. bean1797 setNextToken (clojure.core/str v1799)))
   (clojure.core/when-let
    [v1799 (:max-items m1798)]
    (. bean1797 setMaxItems (clojure.core/int v1799)))
   bean1797))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.GetIdentityDkimAttributesRequest}
get-identity-dkim-attributes-request
  [m1801]
  (clojure.core/let
   [bean1800
    (new
     com.amazonaws.services.simpleemail.model.GetIdentityDkimAttributesRequest)]
   (clojure.core/when-let
    [v1802 (:identities m1801)]
    (.
     bean1800
     setIdentities
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg1833] (clojure.core/str arg1833))
 v1802)))
   bean1800))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.VerifyDomainDkimRequest}
verify-domain-dkim-request
  [m1804]
  (clojure.core/let
   [bean1803
    (new
     com.amazonaws.services.simpleemail.model.VerifyDomainDkimRequest)]
   (clojure.core/when-let
    [v1805 (:domain m1804)]
    (. bean1803 setDomain (clojure.core/str v1805)))
   bean1803))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.VerifyEmailAddressRequest}
verify-email-address-request
  [m1807]
  (clojure.core/let
   [bean1806
    (new
     com.amazonaws.services.simpleemail.model.VerifyEmailAddressRequest)]
   (clojure.core/when-let
    [v1808 (:email-address m1807)]
    (. bean1806 setEmailAddress (clojure.core/str v1808)))
   bean1806))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.SetIdentityNotificationTopicRequest}
set-identity-notification-topic-request
  [m1810]
  (clojure.core/let
   [bean1809
    (new
     com.amazonaws.services.simpleemail.model.SetIdentityNotificationTopicRequest)]
   (clojure.core/when-let
    [v1811 (:identity m1810)]
    (. bean1809 setIdentity (clojure.core/str v1811)))
   (clojure.core/when-let
    [v1811 (:notification-type m1810)]
    (.
     bean1809
     setNotificationType
     (simpleemail/notification-type v1811)))
   (clojure.core/when-let
    [v1811 (:sns-topic m1810)]
    (. bean1809 setSnsTopic (clojure.core/str v1811)))
   bean1809))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.GetIdentityVerificationAttributesRequest}
get-identity-verification-attributes-request
  [m1813]
  (clojure.core/let
   [bean1812
    (new
     com.amazonaws.services.simpleemail.model.GetIdentityVerificationAttributesRequest)]
   (clojure.core/when-let
    [v1814 (:identities m1813)]
    (.
     bean1812
     setIdentities
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg1834] (clojure.core/str arg1834))
 v1814)))
   bean1812))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.VerifyDomainIdentityRequest}
verify-domain-identity-request
  [m1816]
  (clojure.core/let
   [bean1815
    (new
     com.amazonaws.services.simpleemail.model.VerifyDomainIdentityRequest)]
   (clojure.core/when-let
    [v1817 (:domain m1816)]
    (. bean1815 setDomain (clojure.core/str v1817)))
   bean1815))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.GetSendQuotaRequest}
get-send-quota-request
  [m1819]
  (clojure.core/let
   [bean1818
    (new com.amazonaws.services.simpleemail.model.GetSendQuotaRequest)]
   bean1818))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.DeleteIdentityRequest}
delete-identity-request
  [m1822]
  (clojure.core/let
   [bean1821
    (new
     com.amazonaws.services.simpleemail.model.DeleteIdentityRequest)]
   (clojure.core/when-let
    [v1823 (:identity m1822)]
    (. bean1821 setIdentity (clojure.core/str v1823)))
   bean1821))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.VerifyEmailIdentityRequest}
verify-email-identity-request
  [m1825]
  (clojure.core/let
   [bean1824
    (new
     com.amazonaws.services.simpleemail.model.VerifyEmailIdentityRequest)]
   (clojure.core/when-let
    [v1826 (:email-address m1825)]
    (. bean1824 setEmailAddress (clojure.core/str v1826)))
   bean1824))
 (clojure.core/defmulti
  simpleemail
  (clojure.core/fn
   simpleemail
   [m__1683__auto__]
   (:fn m__1683__auto__)))
 (do
  (clojure.core/defmethod
   simpleemail
   :send-email
   [m1835]
   (clojure.core/let
    [credentials1836 (:credentials m1835) args1837 (:args m1835)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client1838
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials1836)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client1838
       sendEmail
       (simpleemail/send-email-request (clojure.core/nth args1837 0)))))))
  (clojure.core/defn
   send-email-map
   {:arglists (quote
               [[credentials
                 {:keys [source
                         return-path
                         reply-to-addresses
                         message
                         destination
                         general-progress-listener]}]]),
    :doc "Generate map for sendEmail"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :simpleemail,
     :fn :send-email,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   send-email
   {:arglists (quote
               [[credentials
                 {:keys [source
                         return-path
                         reply-to-addresses
                         message
                         destination
                         general-progress-listener]}]]),
    :doc "Call sendEmail"}
   [credentials1840 & args1841]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client1842
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials1840)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client1842
      sendEmail
      (simpleemail/send-email-request (clojure.core/nth args1841 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :list-verified-email-addresses
   [m1843]
   (clojure.core/let
    [credentials1844 (:credentials m1843) args1845 (:args m1843)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client1846
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials1844)]
     (clojure.core/case
      (clojure.core/count args1845)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client1846
        listVerifiedEmailAddresses))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client1846
        listVerifiedEmailAddresses
        (simpleemail/list-verified-email-addresses-request
         (clojure.core/nth args1845 0))))))))
  (clojure.core/defn
   list-verified-email-addresses-map
   {:arglists (quote
               [[credentials]
                [credentials {:keys [general-progress-listener]}]]),
    :doc "Generate map for listVerifiedEmailAddresses, listVerifiedEmailAddresses"}
   ([credentials__1651__auto__]
    {:args [],
     :client :simpleemail,
     :fn :list-verified-email-addresses,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :simpleemail,
     :fn :list-verified-email-addresses,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   list-verified-email-addresses
   {:arglists (quote
               [[credentials]
                [credentials {:keys [general-progress-listener]}]]),
    :doc "Call listVerifiedEmailAddresses, listVerifiedEmailAddresses"}
   [credentials1848 & args1849]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client1850
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials1848)]
    (clojure.core/case
     (clojure.core/count args1849)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client1850
       listVerifiedEmailAddresses))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client1850
       listVerifiedEmailAddresses
       (simpleemail/list-verified-email-addresses-request
        (clojure.core/nth args1849 0))))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :get-send-statistics
   [m1851]
   (clojure.core/let
    [credentials1852 (:credentials m1851) args1853 (:args m1851)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client1854
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials1852)]
     (clojure.core/case
      (clojure.core/count args1853)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client1854
        getSendStatistics
        (simpleemail/get-send-statistics-request
         (clojure.core/nth args1853 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client1854
        getSendStatistics))))))
  (clojure.core/defn
   get-send-statistics-map
   {:arglists (quote
               [[credentials {:keys [general-progress-listener]}]
                [credentials]]),
    :doc "Generate map for getSendStatistics, getSendStatistics"}
   ([credentials__1651__auto__]
    {:args [],
     :client :simpleemail,
     :fn :get-send-statistics,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :simpleemail,
     :fn :get-send-statistics,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   get-send-statistics
   {:arglists (quote
               [[credentials {:keys [general-progress-listener]}]
                [credentials]]),
    :doc "Call getSendStatistics, getSendStatistics"}
   [credentials1856 & args1857]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client1858
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials1856)]
    (clojure.core/case
     (clojure.core/count args1857)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client1858
       getSendStatistics
       (simpleemail/get-send-statistics-request
        (clojure.core/nth args1857 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client1858
       getSendStatistics))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :delete-verified-email-address
   [m1859]
   (clojure.core/let
    [credentials1860 (:credentials m1859) args1861 (:args m1859)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client1862
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials1860)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client1862
       deleteVerifiedEmailAddress
       (simpleemail/delete-verified-email-address-request
        (clojure.core/nth args1861 0)))))))
  (clojure.core/defn
   delete-verified-email-address-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener email-address]}]]),
    :doc "Generate map for deleteVerifiedEmailAddress"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :simpleemail,
     :fn :delete-verified-email-address,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-verified-email-address
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener email-address]}]]),
    :doc "Call deleteVerifiedEmailAddress"}
   [credentials1864 & args1865]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client1866
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials1864)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client1866
      deleteVerifiedEmailAddress
      (simpleemail/delete-verified-email-address-request
       (clojure.core/nth args1865 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :set-identity-dkim-enabled
   [m1867]
   (clojure.core/let
    [credentials1868 (:credentials m1867) args1869 (:args m1867)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client1870
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials1868)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client1870
       setIdentityDkimEnabled
       (simpleemail/set-identity-dkim-enabled-request
        (clojure.core/nth args1869 0)))))))
  (clojure.core/defn
   set-identity-dkim-enabled-map
   {:arglists (quote
               [[credentials
                 {:keys [identity
                         general-progress-listener
                         dkim-enabled]}]]),
    :doc "Generate map for setIdentityDkimEnabled"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :simpleemail,
     :fn :set-identity-dkim-enabled,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   set-identity-dkim-enabled
   {:arglists (quote
               [[credentials
                 {:keys [identity
                         general-progress-listener
                         dkim-enabled]}]]),
    :doc "Call setIdentityDkimEnabled"}
   [credentials1872 & args1873]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client1874
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials1872)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client1874
      setIdentityDkimEnabled
      (simpleemail/set-identity-dkim-enabled-request
       (clojure.core/nth args1873 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :set-identity-feedback-forwarding-enabled
   [m1875]
   (clojure.core/let
    [credentials1876 (:credentials m1875) args1877 (:args m1875)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client1878
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials1876)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client1878
       setIdentityFeedbackForwardingEnabled
       (simpleemail/set-identity-feedback-forwarding-enabled-request
        (clojure.core/nth args1877 0)))))))
  (clojure.core/defn
   set-identity-feedback-forwarding-enabled-map
   {:arglists (quote
               [[credentials
                 {:keys [identity
                         general-progress-listener
                         forwarding-enabled]}]]),
    :doc "Generate map for setIdentityFeedbackForwardingEnabled"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :simpleemail,
     :fn :set-identity-feedback-forwarding-enabled,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   set-identity-feedback-forwarding-enabled
   {:arglists (quote
               [[credentials
                 {:keys [identity
                         general-progress-listener
                         forwarding-enabled]}]]),
    :doc "Call setIdentityFeedbackForwardingEnabled"}
   [credentials1880 & args1881]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client1882
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials1880)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client1882
      setIdentityFeedbackForwardingEnabled
      (simpleemail/set-identity-feedback-forwarding-enabled-request
       (clojure.core/nth args1881 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :send-raw-email
   [m1883]
   (clojure.core/let
    [credentials1884 (:credentials m1883) args1885 (:args m1883)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client1886
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials1884)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client1886
       sendRawEmail
       (simpleemail/send-raw-email-request
        (clojure.core/nth args1885 0)))))))
  (clojure.core/defn
   send-raw-email-map
   {:arglists (quote
               [[credentials
                 {:keys [source
                         raw-message
                         general-progress-listener
                         destinations]}]]),
    :doc "Generate map for sendRawEmail"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :simpleemail,
     :fn :send-raw-email,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   send-raw-email
   {:arglists (quote
               [[credentials
                 {:keys [source
                         raw-message
                         general-progress-listener
                         destinations]}]]),
    :doc "Call sendRawEmail"}
   [credentials1888 & args1889]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client1890
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials1888)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client1890
      sendRawEmail
      (simpleemail/send-raw-email-request
       (clojure.core/nth args1889 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :get-identity-notification-attributes
   [m1891]
   (clojure.core/let
    [credentials1892 (:credentials m1891) args1893 (:args m1891)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client1894
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials1892)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client1894
       getIdentityNotificationAttributes
       (simpleemail/get-identity-notification-attributes-request
        (clojure.core/nth args1893 0)))))))
  (clojure.core/defn
   get-identity-notification-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [identities general-progress-listener]}]]),
    :doc "Generate map for getIdentityNotificationAttributes"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :simpleemail,
     :fn :get-identity-notification-attributes,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   get-identity-notification-attributes
   {:arglists (quote
               [[credentials
                 {:keys [identities general-progress-listener]}]]),
    :doc "Call getIdentityNotificationAttributes"}
   [credentials1896 & args1897]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client1898
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials1896)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client1898
      getIdentityNotificationAttributes
      (simpleemail/get-identity-notification-attributes-request
       (clojure.core/nth args1897 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :list-identities
   [m1899]
   (clojure.core/let
    [credentials1900 (:credentials m1899) args1901 (:args m1899)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client1902
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials1900)]
     (clojure.core/case
      (clojure.core/count args1901)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client1902
        listIdentities))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client1902
        listIdentities
        (simpleemail/list-identities-request
         (clojure.core/nth args1901 0))))))))
  (clojure.core/defn
   list-identities-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [next-token
                         max-items
                         identity-type
                         general-progress-listener]}]]),
    :doc "Generate map for listIdentities, listIdentities"}
   ([credentials__1651__auto__]
    {:args [],
     :client :simpleemail,
     :fn :list-identities,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :simpleemail,
     :fn :list-identities,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   list-identities
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [next-token
                         max-items
                         identity-type
                         general-progress-listener]}]]),
    :doc "Call listIdentities, listIdentities"}
   [credentials1904 & args1905]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client1906
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials1904)]
    (clojure.core/case
     (clojure.core/count args1905)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client1906
       listIdentities))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client1906
       listIdentities
       (simpleemail/list-identities-request
        (clojure.core/nth args1905 0))))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :get-identity-dkim-attributes
   [m1907]
   (clojure.core/let
    [credentials1908 (:credentials m1907) args1909 (:args m1907)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client1910
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials1908)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client1910
       getIdentityDkimAttributes
       (simpleemail/get-identity-dkim-attributes-request
        (clojure.core/nth args1909 0)))))))
  (clojure.core/defn
   get-identity-dkim-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [identities general-progress-listener]}]]),
    :doc "Generate map for getIdentityDkimAttributes"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :simpleemail,
     :fn :get-identity-dkim-attributes,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   get-identity-dkim-attributes
   {:arglists (quote
               [[credentials
                 {:keys [identities general-progress-listener]}]]),
    :doc "Call getIdentityDkimAttributes"}
   [credentials1912 & args1913]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client1914
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials1912)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client1914
      getIdentityDkimAttributes
      (simpleemail/get-identity-dkim-attributes-request
       (clojure.core/nth args1913 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :verify-domain-dkim
   [m1915]
   (clojure.core/let
    [credentials1916 (:credentials m1915) args1917 (:args m1915)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client1918
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials1916)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client1918
       verifyDomainDkim
       (simpleemail/verify-domain-dkim-request
        (clojure.core/nth args1917 0)))))))
  (clojure.core/defn
   verify-domain-dkim-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener domain]}]]),
    :doc "Generate map for verifyDomainDkim"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :simpleemail,
     :fn :verify-domain-dkim,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   verify-domain-dkim
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener domain]}]]),
    :doc "Call verifyDomainDkim"}
   [credentials1920 & args1921]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client1922
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials1920)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client1922
      verifyDomainDkim
      (simpleemail/verify-domain-dkim-request
       (clojure.core/nth args1921 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :verify-email-address
   [m1923]
   (clojure.core/let
    [credentials1924 (:credentials m1923) args1925 (:args m1923)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client1926
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials1924)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client1926
       verifyEmailAddress
       (simpleemail/verify-email-address-request
        (clojure.core/nth args1925 0)))))))
  (clojure.core/defn
   verify-email-address-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener email-address]}]]),
    :doc "Generate map for verifyEmailAddress"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :simpleemail,
     :fn :verify-email-address,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   verify-email-address
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener email-address]}]]),
    :doc "Call verifyEmailAddress"}
   [credentials1928 & args1929]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client1930
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials1928)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client1930
      verifyEmailAddress
      (simpleemail/verify-email-address-request
       (clojure.core/nth args1929 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :set-identity-notification-topic
   [m1931]
   (clojure.core/let
    [credentials1932 (:credentials m1931) args1933 (:args m1931)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client1934
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials1932)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client1934
       setIdentityNotificationTopic
       (simpleemail/set-identity-notification-topic-request
        (clojure.core/nth args1933 0)))))))
  (clojure.core/defn
   set-identity-notification-topic-map
   {:arglists (quote
               [[credentials
                 {:keys [sns-topic
                         notification-type
                         identity
                         general-progress-listener]}]]),
    :doc "Generate map for setIdentityNotificationTopic"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :simpleemail,
     :fn :set-identity-notification-topic,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   set-identity-notification-topic
   {:arglists (quote
               [[credentials
                 {:keys [sns-topic
                         notification-type
                         identity
                         general-progress-listener]}]]),
    :doc "Call setIdentityNotificationTopic"}
   [credentials1936 & args1937]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client1938
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials1936)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client1938
      setIdentityNotificationTopic
      (simpleemail/set-identity-notification-topic-request
       (clojure.core/nth args1937 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :get-identity-verification-attributes
   [m1939]
   (clojure.core/let
    [credentials1940 (:credentials m1939) args1941 (:args m1939)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client1942
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials1940)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client1942
       getIdentityVerificationAttributes
       (simpleemail/get-identity-verification-attributes-request
        (clojure.core/nth args1941 0)))))))
  (clojure.core/defn
   get-identity-verification-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [identities general-progress-listener]}]]),
    :doc "Generate map for getIdentityVerificationAttributes"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :simpleemail,
     :fn :get-identity-verification-attributes,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   get-identity-verification-attributes
   {:arglists (quote
               [[credentials
                 {:keys [identities general-progress-listener]}]]),
    :doc "Call getIdentityVerificationAttributes"}
   [credentials1944 & args1945]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client1946
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials1944)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client1946
      getIdentityVerificationAttributes
      (simpleemail/get-identity-verification-attributes-request
       (clojure.core/nth args1945 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :verify-domain-identity
   [m1947]
   (clojure.core/let
    [credentials1948 (:credentials m1947) args1949 (:args m1947)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client1950
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials1948)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client1950
       verifyDomainIdentity
       (simpleemail/verify-domain-identity-request
        (clojure.core/nth args1949 0)))))))
  (clojure.core/defn
   verify-domain-identity-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener domain]}]]),
    :doc "Generate map for verifyDomainIdentity"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :simpleemail,
     :fn :verify-domain-identity,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   verify-domain-identity
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener domain]}]]),
    :doc "Call verifyDomainIdentity"}
   [credentials1952 & args1953]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client1954
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials1952)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client1954
      verifyDomainIdentity
      (simpleemail/verify-domain-identity-request
       (clojure.core/nth args1953 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :get-send-quota
   [m1955]
   (clojure.core/let
    [credentials1956 (:credentials m1955) args1957 (:args m1955)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client1958
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials1956)]
     (clojure.core/case
      (clojure.core/count args1957)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client1958
        getSendQuota))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client1958
        getSendQuota
        (simpleemail/get-send-quota-request
         (clojure.core/nth args1957 0))))))))
  (clojure.core/defn
   get-send-quota-map
   {:arglists (quote
               [[credentials]
                [credentials {:keys [general-progress-listener]}]]),
    :doc "Generate map for getSendQuota, getSendQuota"}
   ([credentials__1651__auto__]
    {:args [],
     :client :simpleemail,
     :fn :get-send-quota,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :simpleemail,
     :fn :get-send-quota,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   get-send-quota
   {:arglists (quote
               [[credentials]
                [credentials {:keys [general-progress-listener]}]]),
    :doc "Call getSendQuota, getSendQuota"}
   [credentials1960 & args1961]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client1962
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials1960)]
    (clojure.core/case
     (clojure.core/count args1961)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client1962
       getSendQuota))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client1962
       getSendQuota
       (simpleemail/get-send-quota-request
        (clojure.core/nth args1961 0))))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :delete-identity
   [m1963]
   (clojure.core/let
    [credentials1964 (:credentials m1963) args1965 (:args m1963)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client1966
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials1964)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client1966
       deleteIdentity
       (simpleemail/delete-identity-request
        (clojure.core/nth args1965 0)))))))
  (clojure.core/defn
   delete-identity-map
   {:arglists (quote
               [[credentials
                 {:keys [identity general-progress-listener]}]]),
    :doc "Generate map for deleteIdentity"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :simpleemail,
     :fn :delete-identity,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-identity
   {:arglists (quote
               [[credentials
                 {:keys [identity general-progress-listener]}]]),
    :doc "Call deleteIdentity"}
   [credentials1968 & args1969]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client1970
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials1968)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client1970
      deleteIdentity
      (simpleemail/delete-identity-request
       (clojure.core/nth args1969 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :verify-email-identity
   [m1971]
   (clojure.core/let
    [credentials1972 (:credentials m1971) args1973 (:args m1971)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client1974
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials1972)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client1974
       verifyEmailIdentity
       (simpleemail/verify-email-identity-request
        (clojure.core/nth args1973 0)))))))
  (clojure.core/defn
   verify-email-identity-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener email-address]}]]),
    :doc "Generate map for verifyEmailIdentity"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :simpleemail,
     :fn :verify-email-identity,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   verify-email-identity
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener email-address]}]]),
    :doc "Call verifyEmailIdentity"}
   [credentials1976 & args1977]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client1978
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials1976)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client1978
      verifyEmailIdentity
      (simpleemail/verify-email-identity-request
       (clojure.core/nth args1977 0))))))))
