(ns
 com.palletops.awaze.sqs
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.sqs :as sqs]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :sqs
  [___1600__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1601__auto__]
  (new
   com.amazonaws.services.sqs.AmazonSQSClient
   credentials__1601__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.MessageAttributeValue}
message-attribute-value
  [m8524]
  (clojure.core/let
   [bean8523
    (new com.amazonaws.services.sqs.model.MessageAttributeValue)]
   (clojure.core/when-let
    [v8525 (:data-type m8524)]
    (. bean8523 setDataType (clojure.core/str v8525)))
   (clojure.core/when-let
    [v8525 (:string-list-values m8524)]
    (.
     bean8523
     setStringListValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8583] (clojure.core/str arg8583))
 v8525)))
   (clojure.core/when-let
    [v8525 (:binary-list-values m8524)]
    (.
     bean8523
     setBinaryListValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8584] (clojure.core/identity arg8584))
 v8525)))
   (clojure.core/when-let
    [v8525 (:binary-value m8524)]
    (. bean8523 setBinaryValue (clojure.core/identity v8525)))
   (clojure.core/when-let
    [v8525 (:string-value m8524)]
    (. bean8523 setStringValue (clojure.core/str v8525)))
   bean8523))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.ChangeMessageVisibilityBatchRequestEntry}
change-message-visibility-batch-request-entry
  [m8527]
  (clojure.core/let
   [bean8526
    (new
     com.amazonaws.services.sqs.model.ChangeMessageVisibilityBatchRequestEntry)]
   (clojure.core/when-let
    [v8528 (:id m8527)]
    (. bean8526 setId (clojure.core/str v8528)))
   (clojure.core/when-let
    [v8528 (:receipt-handle m8527)]
    (. bean8526 setReceiptHandle (clojure.core/str v8528)))
   (clojure.core/when-let
    [v8528 (:visibility-timeout m8527)]
    (. bean8526 setVisibilityTimeout (clojure.core/int v8528)))
   bean8526))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.SendMessageBatchRequestEntry}
send-message-batch-request-entry
  [m8530]
  (clojure.core/let
   [bean8529
    (new
     com.amazonaws.services.sqs.model.SendMessageBatchRequestEntry)]
   (clojure.core/when-let
    [v8531 (:id m8530)]
    (. bean8529 setId (clojure.core/str v8531)))
   (clojure.core/when-let
    [v8531 (:message-attributes m8530)]
    (.
     bean8529
     setMessageAttributes
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg8585] (clojure.core/str arg8585))
  (clojure.core/keys v8531))
 (clojure.core/map
  (clojure.core/fn [arg8585] (sqs/message-attribute-value arg8585))
  (clojure.core/vals v8531)))))
   (clojure.core/when-let
    [v8531 (:message-body m8530)]
    (. bean8529 setMessageBody (clojure.core/str v8531)))
   (clojure.core/when-let
    [v8531 (:delay-seconds m8530)]
    (. bean8529 setDelaySeconds (clojure.core/int v8531)))
   bean8529))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.DeleteMessageBatchRequestEntry}
delete-message-batch-request-entry
  [m8533]
  (clojure.core/let
   [bean8532
    (new
     com.amazonaws.services.sqs.model.DeleteMessageBatchRequestEntry)]
   (clojure.core/when-let
    [v8534 (:id m8533)]
    (. bean8532 setId (clojure.core/str v8534)))
   (clojure.core/when-let
    [v8534 (:receipt-handle m8533)]
    (. bean8532 setReceiptHandle (clojure.core/str v8534)))
   bean8532))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.GetQueueAttributesRequest}
get-queue-attributes-request
  [m8536]
  (clojure.core/let
   [bean8535
    (new com.amazonaws.services.sqs.model.GetQueueAttributesRequest)]
   (clojure.core/when-let
    [v8537 (:attribute-names m8536)]
    (.
     bean8535
     setAttributeNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8586] (clojure.core/str arg8586))
 v8537)))
   (clojure.core/when-let
    [v8537 (:queue-url m8536)]
    (. bean8535 setQueueUrl (clojure.core/str v8537)))
   bean8535))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.ChangeMessageVisibilityBatchRequest}
change-message-visibility-batch-request
  [m8539]
  (clojure.core/let
   [bean8538
    (new
     com.amazonaws.services.sqs.model.ChangeMessageVisibilityBatchRequest)]
   (clojure.core/when-let
    [v8540 (:queue-url m8539)]
    (. bean8538 setQueueUrl (clojure.core/str v8540)))
   (clojure.core/when-let
    [v8540 (:entries m8539)]
    (.
     bean8538
     setEntries
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg8587]
  (sqs/change-message-visibility-batch-request-entry arg8587))
 v8540)))
   bean8538))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.SendMessageRequest}
send-message-request
  [m8542]
  (clojure.core/let
   [bean8541
    (new com.amazonaws.services.sqs.model.SendMessageRequest)]
   (clojure.core/when-let
    [v8543 (:message-attributes m8542)]
    (.
     bean8541
     setMessageAttributes
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg8588] (clojure.core/str arg8588))
  (clojure.core/keys v8543))
 (clojure.core/map
  (clojure.core/fn [arg8588] (sqs/message-attribute-value arg8588))
  (clojure.core/vals v8543)))))
   (clojure.core/when-let
    [v8543 (:queue-url m8542)]
    (. bean8541 setQueueUrl (clojure.core/str v8543)))
   (clojure.core/when-let
    [v8543 (:message-body m8542)]
    (. bean8541 setMessageBody (clojure.core/str v8543)))
   (clojure.core/when-let
    [v8543 (:delay-seconds m8542)]
    (. bean8541 setDelaySeconds (clojure.core/int v8543)))
   bean8541))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.ListQueuesRequest}
list-queues-request
  [m8545]
  (clojure.core/let
   [bean8544 (new com.amazonaws.services.sqs.model.ListQueuesRequest)]
   (clojure.core/when-let
    [v8546 (:queue-name-prefix m8545)]
    (. bean8544 setQueueNamePrefix (clojure.core/str v8546)))
   bean8544))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.AddPermissionRequest}
add-permission-request
  [m8548]
  (clojure.core/let
   [bean8547
    (new com.amazonaws.services.sqs.model.AddPermissionRequest)]
   (clojure.core/when-let
    [v8549 (:label m8548)]
    (. bean8547 setLabel (clojure.core/str v8549)))
   (clojure.core/when-let
    [v8549 (:awsaccount-ids m8548)]
    (.
     bean8547
     setAWSAccountIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8589] (clojure.core/str arg8589))
 v8549)))
   (clojure.core/when-let
    [v8549 (:queue-url m8548)]
    (. bean8547 setQueueUrl (clojure.core/str v8549)))
   (clojure.core/when-let
    [v8549 (:actions m8548)]
    (.
     bean8547
     setActions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8590] (clojure.core/str arg8590))
 v8549)))
   bean8547))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.ListDeadLetterSourceQueuesRequest}
list-dead-letter-source-queues-request
  [m8551]
  (clojure.core/let
   [bean8550
    (new
     com.amazonaws.services.sqs.model.ListDeadLetterSourceQueuesRequest)]
   (clojure.core/when-let
    [v8552 (:queue-url m8551)]
    (. bean8550 setQueueUrl (clojure.core/str v8552)))
   bean8550))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.DeleteMessageRequest}
delete-message-request
  [m8554]
  (clojure.core/let
   [bean8553
    (new com.amazonaws.services.sqs.model.DeleteMessageRequest)]
   (clojure.core/when-let
    [v8555 (:queue-url m8554)]
    (. bean8553 setQueueUrl (clojure.core/str v8555)))
   (clojure.core/when-let
    [v8555 (:receipt-handle m8554)]
    (. bean8553 setReceiptHandle (clojure.core/str v8555)))
   bean8553))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.CreateQueueRequest}
create-queue-request
  [m8557]
  (clojure.core/let
   [bean8556
    (new com.amazonaws.services.sqs.model.CreateQueueRequest)]
   (clojure.core/when-let
    [v8558 (:queue-name m8557)]
    (. bean8556 setQueueName (clojure.core/str v8558)))
   (clojure.core/when-let
    [v8558 (:attributes m8557)]
    (.
     bean8556
     setAttributes
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg8591] (clojure.core/str arg8591))
  (clojure.core/keys v8558))
 (clojure.core/map
  (clojure.core/fn [arg8591] (clojure.core/str arg8591))
  (clojure.core/vals v8558)))))
   bean8556))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.ChangeMessageVisibilityRequest}
change-message-visibility-request
  [m8560]
  (clojure.core/let
   [bean8559
    (new
     com.amazonaws.services.sqs.model.ChangeMessageVisibilityRequest)]
   (clojure.core/when-let
    [v8561 (:queue-url m8560)]
    (. bean8559 setQueueUrl (clojure.core/str v8561)))
   (clojure.core/when-let
    [v8561 (:receipt-handle m8560)]
    (. bean8559 setReceiptHandle (clojure.core/str v8561)))
   (clojure.core/when-let
    [v8561 (:visibility-timeout m8560)]
    (. bean8559 setVisibilityTimeout (clojure.core/int v8561)))
   bean8559))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.SendMessageBatchRequest}
send-message-batch-request
  [m8563]
  (clojure.core/let
   [bean8562
    (new com.amazonaws.services.sqs.model.SendMessageBatchRequest)]
   (clojure.core/when-let
    [v8564 (:queue-url m8563)]
    (. bean8562 setQueueUrl (clojure.core/str v8564)))
   (clojure.core/when-let
    [v8564 (:entries m8563)]
    (.
     bean8562
     setEntries
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg8592]
  (sqs/send-message-batch-request-entry arg8592))
 v8564)))
   bean8562))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.DeleteQueueRequest}
delete-queue-request
  [m8566]
  (clojure.core/let
   [bean8565
    (new com.amazonaws.services.sqs.model.DeleteQueueRequest)]
   (clojure.core/when-let
    [v8567 (:queue-url m8566)]
    (. bean8565 setQueueUrl (clojure.core/str v8567)))
   bean8565))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.ReceiveMessageRequest}
receive-message-request
  [m8569]
  (clojure.core/let
   [bean8568
    (new com.amazonaws.services.sqs.model.ReceiveMessageRequest)]
   (clojure.core/when-let
    [v8570 (:attribute-names m8569)]
    (.
     bean8568
     setAttributeNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8593] (clojure.core/str arg8593))
 v8570)))
   (clojure.core/when-let
    [v8570 (:queue-url m8569)]
    (. bean8568 setQueueUrl (clojure.core/str v8570)))
   (clojure.core/when-let
    [v8570 (:visibility-timeout m8569)]
    (. bean8568 setVisibilityTimeout (clojure.core/int v8570)))
   (clojure.core/when-let
    [v8570 (:message-attribute-names m8569)]
    (.
     bean8568
     setMessageAttributeNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8594] (clojure.core/str arg8594))
 v8570)))
   (clojure.core/when-let
    [v8570 (:max-number-of-messages m8569)]
    (. bean8568 setMaxNumberOfMessages (clojure.core/int v8570)))
   (clojure.core/when-let
    [v8570 (:wait-time-seconds m8569)]
    (. bean8568 setWaitTimeSeconds (clojure.core/int v8570)))
   bean8568))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.SetQueueAttributesRequest}
set-queue-attributes-request
  [m8572]
  (clojure.core/let
   [bean8571
    (new com.amazonaws.services.sqs.model.SetQueueAttributesRequest)]
   (clojure.core/when-let
    [v8573 (:queue-url m8572)]
    (. bean8571 setQueueUrl (clojure.core/str v8573)))
   (clojure.core/when-let
    [v8573 (:attributes m8572)]
    (.
     bean8571
     setAttributes
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg8595] (clojure.core/str arg8595))
  (clojure.core/keys v8573))
 (clojure.core/map
  (clojure.core/fn [arg8595] (clojure.core/str arg8595))
  (clojure.core/vals v8573)))))
   bean8571))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.RemovePermissionRequest}
remove-permission-request
  [m8575]
  (clojure.core/let
   [bean8574
    (new com.amazonaws.services.sqs.model.RemovePermissionRequest)]
   (clojure.core/when-let
    [v8576 (:label m8575)]
    (. bean8574 setLabel (clojure.core/str v8576)))
   (clojure.core/when-let
    [v8576 (:queue-url m8575)]
    (. bean8574 setQueueUrl (clojure.core/str v8576)))
   bean8574))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.DeleteMessageBatchRequest}
delete-message-batch-request
  [m8578]
  (clojure.core/let
   [bean8577
    (new com.amazonaws.services.sqs.model.DeleteMessageBatchRequest)]
   (clojure.core/when-let
    [v8579 (:queue-url m8578)]
    (. bean8577 setQueueUrl (clojure.core/str v8579)))
   (clojure.core/when-let
    [v8579 (:entries m8578)]
    (.
     bean8577
     setEntries
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg8596]
  (sqs/delete-message-batch-request-entry arg8596))
 v8579)))
   bean8577))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.GetQueueUrlRequest}
get-queue-url-request
  [m8581]
  (clojure.core/let
   [bean8580
    (new com.amazonaws.services.sqs.model.GetQueueUrlRequest)]
   (clojure.core/when-let
    [v8582 (:queue-name m8581)]
    (. bean8580 setQueueName (clojure.core/str v8582)))
   (clojure.core/when-let
    [v8582 (:queue-owner-awsaccount-id m8581)]
    (. bean8580 setQueueOwnerAWSAccountId (clojure.core/str v8582)))
   bean8580))
 (clojure.core/defmulti
  sqs
  (clojure.core/fn sqs [m__1683__auto__] (:fn m__1683__auto__)))
 (do
  (clojure.core/defmethod
   sqs
   :get-queue-attributes
   [m8597]
   (clojure.core/let
    [credentials8598 (:credentials m8597) args8599 (:args m8597)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8600
      (com.palletops.awaze.common/aws-client :sqs credentials8598)]
     (clojure.core/case
      (clojure.core/count args8599)
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8600
        getQueueAttributes
        (clojure.core/str (clojure.core/nth args8599 0))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg8613] (clojure.core/str arg8613))
 (clojure.core/nth args8599 1))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8600
        getQueueAttributes
        (sqs/get-queue-attributes-request
         (clojure.core/nth args8599 0))))))))
  (clojure.core/defn
   get-queue-attributes-map
   {:arglists (quote
               [[credentials string-0 list-1]
                [credentials
                 {:keys [queue-url
                         general-progress-listener
                         attribute-names]}]]),
    :doc "Generate map for getQueueAttributes, getQueueAttributes"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :sqs,
     :fn :get-queue-attributes,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a b]
    {:args [a b],
     :client :sqs,
     :fn :get-queue-attributes,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   get-queue-attributes
   {:arglists (quote
               [[credentials string-0 list-1]
                [credentials
                 {:keys [queue-url
                         general-progress-listener
                         attribute-names]}]]),
    :doc "Call getQueueAttributes, getQueueAttributes"}
   [credentials8602 & args8603]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8604
     (com.palletops.awaze.common/aws-client :sqs credentials8602)]
    (clojure.core/case
     (clojure.core/count args8603)
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8604
       getQueueAttributes
       (clojure.core/str (clojure.core/nth args8603 0))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg8614] (clojure.core/str arg8614))
 (clojure.core/nth args8603 1))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8604
       getQueueAttributes
       (sqs/get-queue-attributes-request
        (clojure.core/nth args8603 0))))))))
 (do
  (clojure.core/defmethod
   sqs
   :change-message-visibility-batch
   [m8605]
   (clojure.core/let
    [credentials8606 (:credentials m8605) args8607 (:args m8605)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8608
      (com.palletops.awaze.common/aws-client :sqs credentials8606)]
     (clojure.core/case
      (clojure.core/count args8607)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8608
        changeMessageVisibilityBatch
        (sqs/change-message-visibility-batch-request
         (clojure.core/nth args8607 0))))
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8608
        changeMessageVisibilityBatch
        (clojure.core/str (clojure.core/nth args8607 0))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn
  [arg8623]
  (sqs/change-message-visibility-batch-request-entry arg8623))
 (clojure.core/nth args8607 1))))))))
  (clojure.core/defn
   change-message-visibility-batch-map
   {:arglists (quote
               [[credentials
                 {:keys [queue-url general-progress-listener entries]}]
                [credentials string-0 list-1]]),
    :doc "Generate map for changeMessageVisibilityBatch, changeMessageVisibilityBatch"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :sqs,
     :fn :change-message-visibility-batch,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a b]
    {:args [a b],
     :client :sqs,
     :fn :change-message-visibility-batch,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   change-message-visibility-batch
   {:arglists (quote
               [[credentials
                 {:keys [queue-url general-progress-listener entries]}]
                [credentials string-0 list-1]]),
    :doc "Call changeMessageVisibilityBatch, changeMessageVisibilityBatch"}
   [credentials8610 & args8611]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8612
     (com.palletops.awaze.common/aws-client :sqs credentials8610)]
    (clojure.core/case
     (clojure.core/count args8611)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8612
       changeMessageVisibilityBatch
       (sqs/change-message-visibility-batch-request
        (clojure.core/nth args8611 0))))
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8612
       changeMessageVisibilityBatch
       (clojure.core/str (clojure.core/nth args8611 0))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn
  [arg8624]
  (sqs/change-message-visibility-batch-request-entry arg8624))
 (clojure.core/nth args8611 1))))))))
 (do
  (clojure.core/defmethod
   sqs
   :send-message
   [m8615]
   (clojure.core/let
    [credentials8616 (:credentials m8615) args8617 (:args m8615)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8618
      (com.palletops.awaze.common/aws-client :sqs credentials8616)]
     (clojure.core/case
      (clojure.core/count args8617)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8618
        sendMessage
        (sqs/send-message-request (clojure.core/nth args8617 0))))
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8618
        sendMessage
        (clojure.core/str (clojure.core/nth args8617 0))
        (clojure.core/str (clojure.core/nth args8617 1))))))))
  (clojure.core/defn
   send-message-map
   {:arglists (quote
               [[credentials
                 {:keys [queue-url
                         message-body
                         message-attributes
                         general-progress-listener
                         delay-seconds]}]
                [credentials string-0 string-1]]),
    :doc "Generate map for sendMessage, sendMessage"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :sqs,
     :fn :send-message,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a b]
    {:args [a b],
     :client :sqs,
     :fn :send-message,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   send-message
   {:arglists (quote
               [[credentials
                 {:keys [queue-url
                         message-body
                         message-attributes
                         general-progress-listener
                         delay-seconds]}]
                [credentials string-0 string-1]]),
    :doc "Call sendMessage, sendMessage"}
   [credentials8620 & args8621]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8622
     (com.palletops.awaze.common/aws-client :sqs credentials8620)]
    (clojure.core/case
     (clojure.core/count args8621)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8622
       sendMessage
       (sqs/send-message-request (clojure.core/nth args8621 0))))
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8622
       sendMessage
       (clojure.core/str (clojure.core/nth args8621 0))
       (clojure.core/str (clojure.core/nth args8621 1))))))))
 (do
  (clojure.core/defmethod
   sqs
   :list-queues
   [m8625]
   (clojure.core/let
    [credentials8626 (:credentials m8625) args8627 (:args m8625)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8628
      (com.palletops.awaze.common/aws-client :sqs credentials8626)]
     (clojure.core/case
      (clojure.core/count args8627)
      1
      (clojure.core/let
       [a__1626__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args8627 0))]
         (clojure.core/reset! a__1626__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8628
           listQueues
           a)))
        (catch
         java.lang.Exception
         e__1627__auto__
         (if
          (clojure.core/deref a__1626__auto__)
          (throw e__1627__auto__)
          (clojure.core/let
           [a__1626__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag com.amazonaws.services.sqs.model.ListQueuesRequest}
              a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.sqs.model.ListQueuesRequest
               (clojure.core/nth args8627 0))]
             (clojure.core/reset! a__1626__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8628
               listQueues
               a)))
            (catch
             java.lang.Exception
             e__1627__auto__
             (if
              (clojure.core/deref a__1626__auto__)
              (throw e__1627__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "listQueues")
                {:args args8627}))))))))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8628
        listQueues))))))
  (clojure.core/defn
   list-queues-map
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [queue-name-prefix general-progress-listener]}]
                [credentials]]),
    :doc "Generate map for listQueues, listQueues, listQueues"}
   ([credentials__1651__auto__]
    {:args [],
     :client :sqs,
     :fn :list-queues,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :sqs,
     :fn :list-queues,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   list-queues
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [queue-name-prefix general-progress-listener]}]
                [credentials]]),
    :doc "Call listQueues, listQueues, listQueues"}
   [credentials8630 & args8631]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8632
     (com.palletops.awaze.common/aws-client :sqs credentials8630)]
    (clojure.core/case
     (clojure.core/count args8631)
     1
     (clojure.core/let
      [a__1626__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args8631 0))]
        (clojure.core/reset! a__1626__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8632
          listQueues
          a)))
       (catch
        java.lang.Exception
        e__1627__auto__
        (if
         (clojure.core/deref a__1626__auto__)
         (throw e__1627__auto__)
         (clojure.core/let
          [a__1626__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag com.amazonaws.services.sqs.model.ListQueuesRequest}
             a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.sqs.model.ListQueuesRequest
              (clojure.core/nth args8631 0))]
            (clojure.core/reset! a__1626__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8632
              listQueues
              a)))
           (catch
            java.lang.Exception
            e__1627__auto__
            (if
             (clojure.core/deref a__1626__auto__)
             (throw e__1627__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "listQueues")
               {:args args8631}))))))))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8632
       listQueues))))))
 (do
  (clojure.core/defmethod
   sqs
   :add-permission
   [m8633]
   (clojure.core/let
    [credentials8634 (:credentials m8633) args8635 (:args m8633)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8636
      (com.palletops.awaze.common/aws-client :sqs credentials8634)]
     (clojure.core/case
      (clojure.core/count args8635)
      4
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8636
        addPermission
        (clojure.core/str (clojure.core/nth args8635 0))
        (clojure.core/str (clojure.core/nth args8635 1))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg8649] (clojure.core/str arg8649))
 (clojure.core/nth args8635 2))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg8650] (clojure.core/str arg8650))
 (clojure.core/nth args8635 3))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8636
        addPermission
        (sqs/add-permission-request (clojure.core/nth args8635 0))))))))
  (clojure.core/defn
   add-permission-map
   {:arglists (quote
               [[credentials string-0 string-1 list-2 list-3]
                [credentials
                 {:keys [queue-url
                         label
                         general-progress-listener
                         actions
                         awsaccount-ids]}]]),
    :doc "Generate map for addPermission, addPermission"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :sqs,
     :fn :add-permission,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a b c d]
    {:args [a b c d],
     :client :sqs,
     :fn :add-permission,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   add-permission
   {:arglists (quote
               [[credentials string-0 string-1 list-2 list-3]
                [credentials
                 {:keys [queue-url
                         label
                         general-progress-listener
                         actions
                         awsaccount-ids]}]]),
    :doc "Call addPermission, addPermission"}
   [credentials8638 & args8639]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8640
     (com.palletops.awaze.common/aws-client :sqs credentials8638)]
    (clojure.core/case
     (clojure.core/count args8639)
     4
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8640
       addPermission
       (clojure.core/str (clojure.core/nth args8639 0))
       (clojure.core/str (clojure.core/nth args8639 1))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg8651] (clojure.core/str arg8651))
 (clojure.core/nth args8639 2))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg8652] (clojure.core/str arg8652))
 (clojure.core/nth args8639 3))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8640
       addPermission
       (sqs/add-permission-request (clojure.core/nth args8639 0))))))))
 (do
  (clojure.core/defmethod
   sqs
   :list-dead-letter-source-queues
   [m8641]
   (clojure.core/let
    [credentials8642 (:credentials m8641) args8643 (:args m8641)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8644
      (com.palletops.awaze.common/aws-client :sqs credentials8642)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8644
       listDeadLetterSourceQueues
       (sqs/list-dead-letter-source-queues-request
        (clojure.core/nth args8643 0)))))))
  (clojure.core/defn
   list-dead-letter-source-queues-map
   {:arglists (quote
               [[credentials
                 {:keys [queue-url general-progress-listener]}]]),
    :doc "Generate map for listDeadLetterSourceQueues"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :sqs,
     :fn :list-dead-letter-source-queues,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   list-dead-letter-source-queues
   {:arglists (quote
               [[credentials
                 {:keys [queue-url general-progress-listener]}]]),
    :doc "Call listDeadLetterSourceQueues"}
   [credentials8646 & args8647]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8648
     (com.palletops.awaze.common/aws-client :sqs credentials8646)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8648
      listDeadLetterSourceQueues
      (sqs/list-dead-letter-source-queues-request
       (clojure.core/nth args8647 0)))))))
 (do
  (clojure.core/defmethod
   sqs
   :delete-message
   [m8653]
   (clojure.core/let
    [credentials8654 (:credentials m8653) args8655 (:args m8653)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8656
      (com.palletops.awaze.common/aws-client :sqs credentials8654)]
     (clojure.core/case
      (clojure.core/count args8655)
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8656
        deleteMessage
        (clojure.core/str (clojure.core/nth args8655 0))
        (clojure.core/str (clojure.core/nth args8655 1))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8656
        deleteMessage
        (sqs/delete-message-request (clojure.core/nth args8655 0))))))))
  (clojure.core/defn
   delete-message-map
   {:arglists (quote
               [[credentials string-0 string-1]
                [credentials
                 {:keys [receipt-handle
                         queue-url
                         general-progress-listener]}]]),
    :doc "Generate map for deleteMessage, deleteMessage"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :sqs,
     :fn :delete-message,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a b]
    {:args [a b],
     :client :sqs,
     :fn :delete-message,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-message
   {:arglists (quote
               [[credentials string-0 string-1]
                [credentials
                 {:keys [receipt-handle
                         queue-url
                         general-progress-listener]}]]),
    :doc "Call deleteMessage, deleteMessage"}
   [credentials8658 & args8659]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8660
     (com.palletops.awaze.common/aws-client :sqs credentials8658)]
    (clojure.core/case
     (clojure.core/count args8659)
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8660
       deleteMessage
       (clojure.core/str (clojure.core/nth args8659 0))
       (clojure.core/str (clojure.core/nth args8659 1))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8660
       deleteMessage
       (sqs/delete-message-request (clojure.core/nth args8659 0))))))))
 (do
  (clojure.core/defmethod
   sqs
   :create-queue
   [m8661]
   (clojure.core/let
    [credentials8662 (:credentials m8661) args8663 (:args m8661)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8664
      (com.palletops.awaze.common/aws-client :sqs credentials8662)]
     (clojure.core/case
      (clojure.core/count args8663)
      1
      (clojure.core/let
       [a__1626__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.sqs.model.CreateQueueRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.sqs.model.CreateQueueRequest
           (clojure.core/nth args8663 0))]
         (clojure.core/reset! a__1626__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8664
           createQueue
           a)))
        (catch
         java.lang.Exception
         e__1627__auto__
         (if
          (clojure.core/deref a__1626__auto__)
          (throw e__1627__auto__)
          (clojure.core/let
           [a__1626__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args8663 0))]
             (clojure.core/reset! a__1626__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8664
               createQueue
               a)))
            (catch
             java.lang.Exception
             e__1627__auto__
             (if
              (clojure.core/deref a__1626__auto__)
              (throw e__1627__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "createQueue")
                {:args args8663}))))))))))))))
  (clojure.core/defn
   create-queue-map
   {:arglists (quote
               [[credentials
                 {:keys [queue-name
                         general-progress-listener
                         attributes]}]
                [credentials string-0]]),
    :doc "Generate map for createQueue, createQueue"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :sqs,
     :fn :create-queue,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-queue
   {:arglists (quote
               [[credentials
                 {:keys [queue-name
                         general-progress-listener
                         attributes]}]
                [credentials string-0]]),
    :doc "Call createQueue, createQueue"}
   [credentials8666 & args8667]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8668
     (com.palletops.awaze.common/aws-client :sqs credentials8666)]
    (clojure.core/case
     (clojure.core/count args8667)
     1
     (clojure.core/let
      [a__1626__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.sqs.model.CreateQueueRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.sqs.model.CreateQueueRequest
          (clojure.core/nth args8667 0))]
        (clojure.core/reset! a__1626__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8668
          createQueue
          a)))
       (catch
        java.lang.Exception
        e__1627__auto__
        (if
         (clojure.core/deref a__1626__auto__)
         (throw e__1627__auto__)
         (clojure.core/let
          [a__1626__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args8667 0))]
            (clojure.core/reset! a__1626__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8668
              createQueue
              a)))
           (catch
            java.lang.Exception
            e__1627__auto__
            (if
             (clojure.core/deref a__1626__auto__)
             (throw e__1627__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "createQueue")
               {:args args8667}))))))))))))))
 (do
  (clojure.core/defmethod
   sqs
   :change-message-visibility
   [m8669]
   (clojure.core/let
    [credentials8670 (:credentials m8669) args8671 (:args m8669)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8672
      (com.palletops.awaze.common/aws-client :sqs credentials8670)]
     (clojure.core/case
      (clojure.core/count args8671)
      3
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8672
        changeMessageVisibility
        (clojure.core/str (clojure.core/nth args8671 0))
        (clojure.core/str (clojure.core/nth args8671 1))
        (clojure.core/int (clojure.core/nth args8671 2))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8672
        changeMessageVisibility
        (sqs/change-message-visibility-request
         (clojure.core/nth args8671 0))))))))
  (clojure.core/defn
   change-message-visibility-map
   {:arglists (quote
               [[credentials string-0 string-1 integer-2]
                [credentials
                 {:keys [visibility-timeout
                         receipt-handle
                         queue-url
                         general-progress-listener]}]]),
    :doc "Generate map for changeMessageVisibility, changeMessageVisibility"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :sqs,
     :fn :change-message-visibility,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a b c]
    {:args [a b c],
     :client :sqs,
     :fn :change-message-visibility,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   change-message-visibility
   {:arglists (quote
               [[credentials string-0 string-1 integer-2]
                [credentials
                 {:keys [visibility-timeout
                         receipt-handle
                         queue-url
                         general-progress-listener]}]]),
    :doc "Call changeMessageVisibility, changeMessageVisibility"}
   [credentials8674 & args8675]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8676
     (com.palletops.awaze.common/aws-client :sqs credentials8674)]
    (clojure.core/case
     (clojure.core/count args8675)
     3
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8676
       changeMessageVisibility
       (clojure.core/str (clojure.core/nth args8675 0))
       (clojure.core/str (clojure.core/nth args8675 1))
       (clojure.core/int (clojure.core/nth args8675 2))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8676
       changeMessageVisibility
       (sqs/change-message-visibility-request
        (clojure.core/nth args8675 0))))))))
 (do
  (clojure.core/defmethod
   sqs
   :send-message-batch
   [m8677]
   (clojure.core/let
    [credentials8678 (:credentials m8677) args8679 (:args m8677)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8680
      (com.palletops.awaze.common/aws-client :sqs credentials8678)]
     (clojure.core/case
      (clojure.core/count args8679)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8680
        sendMessageBatch
        (sqs/send-message-batch-request (clojure.core/nth args8679 0))))
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8680
        sendMessageBatch
        (clojure.core/str (clojure.core/nth args8679 0))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn
  [arg8693]
  (sqs/send-message-batch-request-entry arg8693))
 (clojure.core/nth args8679 1))))))))
  (clojure.core/defn
   send-message-batch-map
   {:arglists (quote
               [[credentials
                 {:keys [queue-url general-progress-listener entries]}]
                [credentials string-0 list-1]]),
    :doc "Generate map for sendMessageBatch, sendMessageBatch"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :sqs,
     :fn :send-message-batch,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a b]
    {:args [a b],
     :client :sqs,
     :fn :send-message-batch,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   send-message-batch
   {:arglists (quote
               [[credentials
                 {:keys [queue-url general-progress-listener entries]}]
                [credentials string-0 list-1]]),
    :doc "Call sendMessageBatch, sendMessageBatch"}
   [credentials8682 & args8683]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8684
     (com.palletops.awaze.common/aws-client :sqs credentials8682)]
    (clojure.core/case
     (clojure.core/count args8683)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8684
       sendMessageBatch
       (sqs/send-message-batch-request (clojure.core/nth args8683 0))))
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8684
       sendMessageBatch
       (clojure.core/str (clojure.core/nth args8683 0))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn
  [arg8694]
  (sqs/send-message-batch-request-entry arg8694))
 (clojure.core/nth args8683 1))))))))
 (do
  (clojure.core/defmethod
   sqs
   :delete-queue
   [m8685]
   (clojure.core/let
    [credentials8686 (:credentials m8685) args8687 (:args m8685)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8688
      (com.palletops.awaze.common/aws-client :sqs credentials8686)]
     (clojure.core/case
      (clojure.core/count args8687)
      1
      (clojure.core/let
       [a__1626__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args8687 0))]
         (clojure.core/reset! a__1626__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8688
           deleteQueue
           a)))
        (catch
         java.lang.Exception
         e__1627__auto__
         (if
          (clojure.core/deref a__1626__auto__)
          (throw e__1627__auto__)
          (clojure.core/let
           [a__1626__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag com.amazonaws.services.sqs.model.DeleteQueueRequest}
              a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.sqs.model.DeleteQueueRequest
               (clojure.core/nth args8687 0))]
             (clojure.core/reset! a__1626__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8688
               deleteQueue
               a)))
            (catch
             java.lang.Exception
             e__1627__auto__
             (if
              (clojure.core/deref a__1626__auto__)
              (throw e__1627__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "deleteQueue")
                {:args args8687}))))))))))))))
  (clojure.core/defn
   delete-queue-map
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [queue-url general-progress-listener]}]]),
    :doc "Generate map for deleteQueue, deleteQueue"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :sqs,
     :fn :delete-queue,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-queue
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [queue-url general-progress-listener]}]]),
    :doc "Call deleteQueue, deleteQueue"}
   [credentials8690 & args8691]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8692
     (com.palletops.awaze.common/aws-client :sqs credentials8690)]
    (clojure.core/case
     (clojure.core/count args8691)
     1
     (clojure.core/let
      [a__1626__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args8691 0))]
        (clojure.core/reset! a__1626__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8692
          deleteQueue
          a)))
       (catch
        java.lang.Exception
        e__1627__auto__
        (if
         (clojure.core/deref a__1626__auto__)
         (throw e__1627__auto__)
         (clojure.core/let
          [a__1626__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag com.amazonaws.services.sqs.model.DeleteQueueRequest}
             a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.sqs.model.DeleteQueueRequest
              (clojure.core/nth args8691 0))]
            (clojure.core/reset! a__1626__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8692
              deleteQueue
              a)))
           (catch
            java.lang.Exception
            e__1627__auto__
            (if
             (clojure.core/deref a__1626__auto__)
             (throw e__1627__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "deleteQueue")
               {:args args8691}))))))))))))))
 (do
  (clojure.core/defmethod
   sqs
   :receive-message
   [m8695]
   (clojure.core/let
    [credentials8696 (:credentials m8695) args8697 (:args m8695)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8698
      (com.palletops.awaze.common/aws-client :sqs credentials8696)]
     (clojure.core/case
      (clojure.core/count args8697)
      1
      (clojure.core/let
       [a__1626__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.sqs.model.ReceiveMessageRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.sqs.model.ReceiveMessageRequest
           (clojure.core/nth args8697 0))]
         (clojure.core/reset! a__1626__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8698
           receiveMessage
           a)))
        (catch
         java.lang.Exception
         e__1627__auto__
         (if
          (clojure.core/deref a__1626__auto__)
          (throw e__1627__auto__)
          (clojure.core/let
           [a__1626__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args8697 0))]
             (clojure.core/reset! a__1626__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8698
               receiveMessage
               a)))
            (catch
             java.lang.Exception
             e__1627__auto__
             (if
              (clojure.core/deref a__1626__auto__)
              (throw e__1627__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "receiveMessage")
                {:args args8697}))))))))))))))
  (clojure.core/defn
   receive-message-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         message-attribute-names
                         queue-url
                         wait-time-seconds
                         attribute-names
                         max-number-of-messages
                         visibility-timeout]}]
                [credentials string-0]]),
    :doc "Generate map for receiveMessage, receiveMessage"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :sqs,
     :fn :receive-message,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   receive-message
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         message-attribute-names
                         queue-url
                         wait-time-seconds
                         attribute-names
                         max-number-of-messages
                         visibility-timeout]}]
                [credentials string-0]]),
    :doc "Call receiveMessage, receiveMessage"}
   [credentials8700 & args8701]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8702
     (com.palletops.awaze.common/aws-client :sqs credentials8700)]
    (clojure.core/case
     (clojure.core/count args8701)
     1
     (clojure.core/let
      [a__1626__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.sqs.model.ReceiveMessageRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.sqs.model.ReceiveMessageRequest
          (clojure.core/nth args8701 0))]
        (clojure.core/reset! a__1626__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8702
          receiveMessage
          a)))
       (catch
        java.lang.Exception
        e__1627__auto__
        (if
         (clojure.core/deref a__1626__auto__)
         (throw e__1627__auto__)
         (clojure.core/let
          [a__1626__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args8701 0))]
            (clojure.core/reset! a__1626__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8702
              receiveMessage
              a)))
           (catch
            java.lang.Exception
            e__1627__auto__
            (if
             (clojure.core/deref a__1626__auto__)
             (throw e__1627__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "receiveMessage")
               {:args args8701}))))))))))))))
 (do
  (clojure.core/defmethod
   sqs
   :set-queue-attributes
   [m8703]
   (clojure.core/let
    [credentials8704 (:credentials m8703) args8705 (:args m8703)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8706
      (com.palletops.awaze.common/aws-client :sqs credentials8704)]
     (clojure.core/case
      (clojure.core/count args8705)
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8706
        setQueueAttributes
        (clojure.core/str (clojure.core/nth args8705 0))
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg8719] (clojure.core/str arg8719))
  (clojure.core/keys (clojure.core/nth args8705 1)))
 (clojure.core/map
  (clojure.core/fn [arg8719] (clojure.core/str arg8719))
  (clojure.core/vals (clojure.core/nth args8705 1))))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8706
        setQueueAttributes
        (sqs/set-queue-attributes-request
         (clojure.core/nth args8705 0))))))))
  (clojure.core/defn
   set-queue-attributes-map
   {:arglists (quote
               [[credentials string-0 map-1]
                [credentials
                 {:keys [queue-url
                         general-progress-listener
                         attributes]}]]),
    :doc "Generate map for setQueueAttributes, setQueueAttributes"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :sqs,
     :fn :set-queue-attributes,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a b]
    {:args [a b],
     :client :sqs,
     :fn :set-queue-attributes,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   set-queue-attributes
   {:arglists (quote
               [[credentials string-0 map-1]
                [credentials
                 {:keys [queue-url
                         general-progress-listener
                         attributes]}]]),
    :doc "Call setQueueAttributes, setQueueAttributes"}
   [credentials8708 & args8709]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8710
     (com.palletops.awaze.common/aws-client :sqs credentials8708)]
    (clojure.core/case
     (clojure.core/count args8709)
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8710
       setQueueAttributes
       (clojure.core/str (clojure.core/nth args8709 0))
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg8720] (clojure.core/str arg8720))
  (clojure.core/keys (clojure.core/nth args8709 1)))
 (clojure.core/map
  (clojure.core/fn [arg8720] (clojure.core/str arg8720))
  (clojure.core/vals (clojure.core/nth args8709 1))))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8710
       setQueueAttributes
       (sqs/set-queue-attributes-request
        (clojure.core/nth args8709 0))))))))
 (do
  (clojure.core/defmethod
   sqs
   :remove-permission
   [m8711]
   (clojure.core/let
    [credentials8712 (:credentials m8711) args8713 (:args m8711)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8714
      (com.palletops.awaze.common/aws-client :sqs credentials8712)]
     (clojure.core/case
      (clojure.core/count args8713)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8714
        removePermission
        (sqs/remove-permission-request (clojure.core/nth args8713 0))))
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8714
        removePermission
        (clojure.core/str (clojure.core/nth args8713 0))
        (clojure.core/str (clojure.core/nth args8713 1))))))))
  (clojure.core/defn
   remove-permission-map
   {:arglists (quote
               [[credentials
                 {:keys [queue-url label general-progress-listener]}]
                [credentials string-0 string-1]]),
    :doc "Generate map for removePermission, removePermission"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :sqs,
     :fn :remove-permission,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a b]
    {:args [a b],
     :client :sqs,
     :fn :remove-permission,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   remove-permission
   {:arglists (quote
               [[credentials
                 {:keys [queue-url label general-progress-listener]}]
                [credentials string-0 string-1]]),
    :doc "Call removePermission, removePermission"}
   [credentials8716 & args8717]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8718
     (com.palletops.awaze.common/aws-client :sqs credentials8716)]
    (clojure.core/case
     (clojure.core/count args8717)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8718
       removePermission
       (sqs/remove-permission-request (clojure.core/nth args8717 0))))
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8718
       removePermission
       (clojure.core/str (clojure.core/nth args8717 0))
       (clojure.core/str (clojure.core/nth args8717 1))))))))
 (do
  (clojure.core/defmethod
   sqs
   :delete-message-batch
   [m8721]
   (clojure.core/let
    [credentials8722 (:credentials m8721) args8723 (:args m8721)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8724
      (com.palletops.awaze.common/aws-client :sqs credentials8722)]
     (clojure.core/case
      (clojure.core/count args8723)
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8724
        deleteMessageBatch
        (clojure.core/str (clojure.core/nth args8723 0))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn
  [arg8737]
  (sqs/delete-message-batch-request-entry arg8737))
 (clojure.core/nth args8723 1))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8724
        deleteMessageBatch
        (sqs/delete-message-batch-request
         (clojure.core/nth args8723 0))))))))
  (clojure.core/defn
   delete-message-batch-map
   {:arglists (quote
               [[credentials string-0 list-1]
                [credentials
                 {:keys [queue-url general-progress-listener entries]}]]),
    :doc "Generate map for deleteMessageBatch, deleteMessageBatch"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :sqs,
     :fn :delete-message-batch,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a b]
    {:args [a b],
     :client :sqs,
     :fn :delete-message-batch,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-message-batch
   {:arglists (quote
               [[credentials string-0 list-1]
                [credentials
                 {:keys [queue-url general-progress-listener entries]}]]),
    :doc "Call deleteMessageBatch, deleteMessageBatch"}
   [credentials8726 & args8727]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8728
     (com.palletops.awaze.common/aws-client :sqs credentials8726)]
    (clojure.core/case
     (clojure.core/count args8727)
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8728
       deleteMessageBatch
       (clojure.core/str (clojure.core/nth args8727 0))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn
  [arg8738]
  (sqs/delete-message-batch-request-entry arg8738))
 (clojure.core/nth args8727 1))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8728
       deleteMessageBatch
       (sqs/delete-message-batch-request
        (clojure.core/nth args8727 0))))))))
 (do
  (clojure.core/defmethod
   sqs
   :get-queue-url
   [m8729]
   (clojure.core/let
    [credentials8730 (:credentials m8729) args8731 (:args m8729)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8732
      (com.palletops.awaze.common/aws-client :sqs credentials8730)]
     (clojure.core/case
      (clojure.core/count args8731)
      1
      (clojure.core/let
       [a__1626__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args8731 0))]
         (clojure.core/reset! a__1626__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8732
           getQueueUrl
           a)))
        (catch
         java.lang.Exception
         e__1627__auto__
         (if
          (clojure.core/deref a__1626__auto__)
          (throw e__1627__auto__)
          (clojure.core/let
           [a__1626__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag com.amazonaws.services.sqs.model.GetQueueUrlRequest}
              a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.sqs.model.GetQueueUrlRequest
               (clojure.core/nth args8731 0))]
             (clojure.core/reset! a__1626__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8732
               getQueueUrl
               a)))
            (catch
             java.lang.Exception
             e__1627__auto__
             (if
              (clojure.core/deref a__1626__auto__)
              (throw e__1627__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "getQueueUrl")
                {:args args8731}))))))))))))))
  (clojure.core/defn
   get-queue-url-map
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [queue-owner-awsaccount-id
                         queue-name
                         general-progress-listener]}]]),
    :doc "Generate map for getQueueUrl, getQueueUrl"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :sqs,
     :fn :get-queue-url,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   get-queue-url
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [queue-owner-awsaccount-id
                         queue-name
                         general-progress-listener]}]]),
    :doc "Call getQueueUrl, getQueueUrl"}
   [credentials8734 & args8735]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8736
     (com.palletops.awaze.common/aws-client :sqs credentials8734)]
    (clojure.core/case
     (clojure.core/count args8735)
     1
     (clojure.core/let
      [a__1626__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args8735 0))]
        (clojure.core/reset! a__1626__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8736
          getQueueUrl
          a)))
       (catch
        java.lang.Exception
        e__1627__auto__
        (if
         (clojure.core/deref a__1626__auto__)
         (throw e__1627__auto__)
         (clojure.core/let
          [a__1626__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag com.amazonaws.services.sqs.model.GetQueueUrlRequest}
             a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.sqs.model.GetQueueUrlRequest
              (clojure.core/nth args8735 0))]
            (clojure.core/reset! a__1626__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8736
              getQueueUrl
              a)))
           (catch
            java.lang.Exception
            e__1627__auto__
            (if
             (clojure.core/deref a__1626__auto__)
             (throw e__1627__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "getQueueUrl")
               {:args args8735})))))))))))))))
