(ns
 com.palletops.awaze.sts
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.sts :as sts]
  [com.palletops.awaze.beans.securitytoken :as securitytoken]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :sts
  [___1600__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1601__auto__]
  (new
   com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient
   credentials__1601__auto__))
 (clojure.core/defmulti
  sts
  (clojure.core/fn sts [m__1683__auto__] (:fn m__1683__auto__)))
 (do
  (clojure.core/defmethod
   sts
   :assume-role-with-web-identity
   [m4781]
   (clojure.core/let
    [credentials4782 (:credentials m4781) args4783 (:args m4781)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
      client4784
      (com.palletops.awaze.common/aws-client :sts credentials4782)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client4784
       assumeRoleWithWebIdentity
       (securitytoken/assume-role-with-web-identity-request
        (clojure.core/nth args4783 0)))))))
  (clojure.core/defn
   assume-role-with-web-identity-map
   {:arglists (quote
               [[credentials
                 {:keys [web-identity-token
                         general-progress-listener
                         duration-seconds
                         role-session-name
                         policy
                         role-arn
                         provider-id]}]]),
    :doc "Generate map for assumeRoleWithWebIdentity"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :sts,
     :fn :assume-role-with-web-identity,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   assume-role-with-web-identity
   {:arglists (quote
               [[credentials
                 {:keys [web-identity-token
                         general-progress-listener
                         duration-seconds
                         role-session-name
                         policy
                         role-arn
                         provider-id]}]]),
    :doc "Call assumeRoleWithWebIdentity"}
   [credentials4786 & args4787]
   (clojure.core/let
    [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
     client4788
     (com.palletops.awaze.common/aws-client :sts credentials4786)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client4788
      assumeRoleWithWebIdentity
      (securitytoken/assume-role-with-web-identity-request
       (clojure.core/nth args4787 0)))))))
 (do
  (clojure.core/defmethod
   sts
   :decode-authorization-message
   [m4789]
   (clojure.core/let
    [credentials4790 (:credentials m4789) args4791 (:args m4789)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
      client4792
      (com.palletops.awaze.common/aws-client :sts credentials4790)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client4792
       decodeAuthorizationMessage
       (securitytoken/decode-authorization-message-request
        (clojure.core/nth args4791 0)))))))
  (clojure.core/defn
   decode-authorization-message-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener encoded-message]}]]),
    :doc "Generate map for decodeAuthorizationMessage"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :sts,
     :fn :decode-authorization-message,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   decode-authorization-message
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener encoded-message]}]]),
    :doc "Call decodeAuthorizationMessage"}
   [credentials4794 & args4795]
   (clojure.core/let
    [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
     client4796
     (com.palletops.awaze.common/aws-client :sts credentials4794)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client4796
      decodeAuthorizationMessage
      (securitytoken/decode-authorization-message-request
       (clojure.core/nth args4795 0)))))))
 (do
  (clojure.core/defmethod
   sts
   :assume-role-with-saml
   [m4797]
   (clojure.core/let
    [credentials4798 (:credentials m4797) args4799 (:args m4797)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
      client4800
      (com.palletops.awaze.common/aws-client :sts credentials4798)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client4800
       assumeRoleWithSAML
       (securitytoken/assume-role-with-samlrequest
        (clojure.core/nth args4799 0)))))))
  (clojure.core/defn
   assume-role-with-saml-map
   {:arglists (quote
               [[credentials
                 {:keys [principal-arn
                         duration-seconds
                         role-arn
                         policy
                         general-progress-listener
                         samlassertion]}]]),
    :doc "Generate map for assumeRoleWithSAML"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :sts,
     :fn :assume-role-with-saml,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   assume-role-with-saml
   {:arglists (quote
               [[credentials
                 {:keys [principal-arn
                         duration-seconds
                         role-arn
                         policy
                         general-progress-listener
                         samlassertion]}]]),
    :doc "Call assumeRoleWithSAML"}
   [credentials4802 & args4803]
   (clojure.core/let
    [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
     client4804
     (com.palletops.awaze.common/aws-client :sts credentials4802)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client4804
      assumeRoleWithSAML
      (securitytoken/assume-role-with-samlrequest
       (clojure.core/nth args4803 0)))))))
 (do
  (clojure.core/defmethod
   sts
   :get-federation-token
   [m4805]
   (clojure.core/let
    [credentials4806 (:credentials m4805) args4807 (:args m4805)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
      client4808
      (com.palletops.awaze.common/aws-client :sts credentials4806)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client4808
       getFederationToken
       (securitytoken/get-federation-token-request
        (clojure.core/nth args4807 0)))))))
  (clojure.core/defn
   get-federation-token-map
   {:arglists (quote
               [[credentials
                 {:keys [policy
                         name
                         general-progress-listener
                         duration-seconds]}]]),
    :doc "Generate map for getFederationToken"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :sts,
     :fn :get-federation-token,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   get-federation-token
   {:arglists (quote
               [[credentials
                 {:keys [policy
                         name
                         general-progress-listener
                         duration-seconds]}]]),
    :doc "Call getFederationToken"}
   [credentials4810 & args4811]
   (clojure.core/let
    [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
     client4812
     (com.palletops.awaze.common/aws-client :sts credentials4810)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client4812
      getFederationToken
      (securitytoken/get-federation-token-request
       (clojure.core/nth args4811 0)))))))
 (do
  (clojure.core/defmethod
   sts
   :assume-role
   [m4813]
   (clojure.core/let
    [credentials4814 (:credentials m4813) args4815 (:args m4813)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
      client4816
      (com.palletops.awaze.common/aws-client :sts credentials4814)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client4816
       assumeRole
       (securitytoken/assume-role-request
        (clojure.core/nth args4815 0)))))))
  (clojure.core/defn
   assume-role-map
   {:arglists (quote
               [[credentials
                 {:keys [token-code
                         serial-number
                         general-progress-listener
                         duration-seconds
                         external-id
                         role-session-name
                         policy
                         role-arn]}]]),
    :doc "Generate map for assumeRole"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :sts,
     :fn :assume-role,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   assume-role
   {:arglists (quote
               [[credentials
                 {:keys [token-code
                         serial-number
                         general-progress-listener
                         duration-seconds
                         external-id
                         role-session-name
                         policy
                         role-arn]}]]),
    :doc "Call assumeRole"}
   [credentials4818 & args4819]
   (clojure.core/let
    [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
     client4820
     (com.palletops.awaze.common/aws-client :sts credentials4818)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client4820
      assumeRole
      (securitytoken/assume-role-request
       (clojure.core/nth args4819 0)))))))
 (do
  (clojure.core/defmethod
   sts
   :get-session-token
   [m4821]
   (clojure.core/let
    [credentials4822 (:credentials m4821) args4823 (:args m4821)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
      client4824
      (com.palletops.awaze.common/aws-client :sts credentials4822)]
     (clojure.core/case
      (clojure.core/count args4823)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client4824
        getSessionToken))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client4824
        getSessionToken
        (securitytoken/get-session-token-request
         (clojure.core/nth args4823 0))))))))
  (clojure.core/defn
   get-session-token-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [token-code
                         serial-number
                         general-progress-listener
                         duration-seconds]}]]),
    :doc "Generate map for getSessionToken, getSessionToken"}
   ([credentials__1651__auto__]
    {:args [],
     :client :sts,
     :fn :get-session-token,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :sts,
     :fn :get-session-token,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   get-session-token
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [token-code
                         serial-number
                         general-progress-listener
                         duration-seconds]}]]),
    :doc "Call getSessionToken, getSessionToken"}
   [credentials4826 & args4827]
   (clojure.core/let
    [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
     client4828
     (com.palletops.awaze.common/aws-client :sts credentials4826)]
    (clojure.core/case
     (clojure.core/count args4827)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client4828
       getSessionToken))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client4828
       getSessionToken
       (securitytoken/get-session-token-request
        (clojure.core/nth args4827 0)))))))))
