(ns
 com.palletops.awaze.autoscaling
 (:refer-clojure :exclude [filter])
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.autoscaling :as autoscaling]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :autoscaling
  [___1600__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1601__auto__]
  (new
   com.amazonaws.services.autoscaling.AmazonAutoScalingClient
   credentials__1601__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.Ebs}
ebs
  [m3416]
  (clojure.core/let
   [bean3415 (new com.amazonaws.services.autoscaling.model.Ebs)]
   (clojure.core/let
    [v3417
     (:snapshot-id m3416 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3417 :com.palletops.awaze.client-builder/undef)
     (. bean3415 setSnapshotId (clojure.core/str v3417))))
   (clojure.core/let
    [v3417
     (:volume-size m3416 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3417 :com.palletops.awaze.client-builder/undef)
     (. bean3415 setVolumeSize (clojure.core/int v3417))))
   (clojure.core/let
    [v3417
     (:volume-type m3416 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3417 :com.palletops.awaze.client-builder/undef)
     (. bean3415 setVolumeType (clojure.core/str v3417))))
   (clojure.core/let
    [v3417
     (:delete-on-termination
      m3416
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3417 :com.palletops.awaze.client-builder/undef)
     (. bean3415 setDeleteOnTermination (clojure.core/boolean v3417))))
   (clojure.core/let
    [v3417 (:iops m3416 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3417 :com.palletops.awaze.client-builder/undef)
     (. bean3415 setIops (clojure.core/int v3417))))
   bean3415))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.Tag}
tag
  [m3419]
  (clojure.core/let
   [bean3418 (new com.amazonaws.services.autoscaling.model.Tag)]
   (clojure.core/let
    [v3420 (:value m3419 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3420 :com.palletops.awaze.client-builder/undef)
     (. bean3418 setValue (clojure.core/str v3420))))
   (clojure.core/let
    [v3420 (:key m3419 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3420 :com.palletops.awaze.client-builder/undef)
     (. bean3418 setKey (clojure.core/str v3420))))
   (clojure.core/let
    [v3420
     (:resource-id m3419 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3420 :com.palletops.awaze.client-builder/undef)
     (. bean3418 setResourceId (clojure.core/str v3420))))
   (clojure.core/let
    [v3420
     (:resource-type m3419 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3420 :com.palletops.awaze.client-builder/undef)
     (. bean3418 setResourceType (clojure.core/str v3420))))
   (clojure.core/let
    [v3420
     (:propagate-at-launch
      m3419
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3420 :com.palletops.awaze.client-builder/undef)
     (. bean3418 setPropagateAtLaunch (clojure.core/boolean v3420))))
   bean3418))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.BlockDeviceMapping}
block-device-mapping
  [m3422]
  (clojure.core/let
   [bean3421
    (new com.amazonaws.services.autoscaling.model.BlockDeviceMapping)]
   (clojure.core/let
    [v3423 (:ebs m3422 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3423 :com.palletops.awaze.client-builder/undef)
     (. bean3421 setEbs (autoscaling/ebs v3423))))
   (clojure.core/let
    [v3423
     (:virtual-name m3422 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3423 :com.palletops.awaze.client-builder/undef)
     (. bean3421 setVirtualName (clojure.core/str v3423))))
   (clojure.core/let
    [v3423
     (:device-name m3422 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3423 :com.palletops.awaze.client-builder/undef)
     (. bean3421 setDeviceName (clojure.core/str v3423))))
   (clojure.core/let
    [v3423
     (:no-device m3422 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3423 :com.palletops.awaze.client-builder/undef)
     (. bean3421 setNoDevice (clojure.core/boolean v3423))))
   bean3421))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.InstanceMonitoring}
instance-monitoring
  [m3425]
  (clojure.core/let
   [bean3424
    (new com.amazonaws.services.autoscaling.model.InstanceMonitoring)]
   (clojure.core/let
    [v3426 (:enabled m3425 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3426 :com.palletops.awaze.client-builder/undef)
     (. bean3424 setEnabled (clojure.core/boolean v3426))))
   bean3424))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.Filter}
filter
  [m3428]
  (clojure.core/let
   [bean3427 (new com.amazonaws.services.autoscaling.model.Filter)]
   (clojure.core/let
    [v3429 (:name m3428 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3429 :com.palletops.awaze.client-builder/undef)
     (. bean3427 setName (clojure.core/str v3429))))
   (clojure.core/let
    [v3429 (:values m3428 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3429 :com.palletops.awaze.client-builder/undef)
     (.
      bean3427
      setValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg3538] (clojure.core/str arg3538))
 v3429))))
   bean3427))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.SetDesiredCapacityRequest}
set-desired-capacity-request
  [m3431]
  (clojure.core/let
   [bean3430
    (new
     com.amazonaws.services.autoscaling.model.SetDesiredCapacityRequest)]
   (clojure.core/let
    [v3432
     (:desired-capacity
      m3431
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3432 :com.palletops.awaze.client-builder/undef)
     (. bean3430 setDesiredCapacity (clojure.core/int v3432))))
   (clojure.core/let
    [v3432
     (:auto-scaling-group-name
      m3431
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3432 :com.palletops.awaze.client-builder/undef)
     (. bean3430 setAutoScalingGroupName (clojure.core/str v3432))))
   (clojure.core/let
    [v3432
     (:honor-cooldown m3431 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3432 :com.palletops.awaze.client-builder/undef)
     (. bean3430 setHonorCooldown (clojure.core/boolean v3432))))
   bean3430))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.EnableMetricsCollectionRequest}
enable-metrics-collection-request
  [m3434]
  (clojure.core/let
   [bean3433
    (new
     com.amazonaws.services.autoscaling.model.EnableMetricsCollectionRequest)]
   (clojure.core/let
    [v3435
     (:auto-scaling-group-name
      m3434
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3435 :com.palletops.awaze.client-builder/undef)
     (. bean3433 setAutoScalingGroupName (clojure.core/str v3435))))
   (clojure.core/let
    [v3435 (:metrics m3434 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3435 :com.palletops.awaze.client-builder/undef)
     (.
      bean3433
      setMetrics
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg3539] (clojure.core/str arg3539))
 v3435))))
   (clojure.core/let
    [v3435
     (:granularity m3434 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3435 :com.palletops.awaze.client-builder/undef)
     (. bean3433 setGranularity (clojure.core/str v3435))))
   bean3433))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DeletePolicyRequest}
delete-policy-request
  [m3437]
  (clojure.core/let
   [bean3436
    (new com.amazonaws.services.autoscaling.model.DeletePolicyRequest)]
   (clojure.core/let
    [v3438
     (:auto-scaling-group-name
      m3437
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3438 :com.palletops.awaze.client-builder/undef)
     (. bean3436 setAutoScalingGroupName (clojure.core/str v3438))))
   (clojure.core/let
    [v3438
     (:policy-name m3437 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3438 :com.palletops.awaze.client-builder/undef)
     (. bean3436 setPolicyName (clojure.core/str v3438))))
   bean3436))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.SetInstanceHealthRequest}
set-instance-health-request
  [m3440]
  (clojure.core/let
   [bean3439
    (new
     com.amazonaws.services.autoscaling.model.SetInstanceHealthRequest)]
   (clojure.core/let
    [v3441
     (:instance-id m3440 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3441 :com.palletops.awaze.client-builder/undef)
     (. bean3439 setInstanceId (clojure.core/str v3441))))
   (clojure.core/let
    [v3441
     (:health-status m3440 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3441 :com.palletops.awaze.client-builder/undef)
     (. bean3439 setHealthStatus (clojure.core/str v3441))))
   (clojure.core/let
    [v3441
     (:should-respect-grace-period
      m3440
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3441 :com.palletops.awaze.client-builder/undef)
     (.
      bean3439
      setShouldRespectGracePeriod
      (clojure.core/boolean v3441))))
   bean3439))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DescribeLaunchConfigurationsRequest}
describe-launch-configurations-request
  [m3443]
  (clojure.core/let
   [bean3442
    (new
     com.amazonaws.services.autoscaling.model.DescribeLaunchConfigurationsRequest)]
   (clojure.core/let
    [v3444
     (:next-token m3443 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3444 :com.palletops.awaze.client-builder/undef)
     (. bean3442 setNextToken (clojure.core/str v3444))))
   (clojure.core/let
    [v3444
     (:launch-configuration-names
      m3443
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3444 :com.palletops.awaze.client-builder/undef)
     (.
      bean3442
      setLaunchConfigurationNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg3540] (clojure.core/str arg3540))
 v3444))))
   (clojure.core/let
    [v3444
     (:max-records m3443 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3444 :com.palletops.awaze.client-builder/undef)
     (. bean3442 setMaxRecords (clojure.core/int v3444))))
   bean3442))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DeleteTagsRequest}
delete-tags-request
  [m3446]
  (clojure.core/let
   [bean3445
    (new com.amazonaws.services.autoscaling.model.DeleteTagsRequest)]
   (clojure.core/let
    [v3447 (:tags m3446 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3447 :com.palletops.awaze.client-builder/undef)
     (.
      bean3445
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg3541] (autoscaling/tag arg3541))
 v3447))))
   bean3445))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DescribeAutoScalingInstancesRequest}
describe-auto-scaling-instances-request
  [m3449]
  (clojure.core/let
   [bean3448
    (new
     com.amazonaws.services.autoscaling.model.DescribeAutoScalingInstancesRequest)]
   (clojure.core/let
    [v3450
     (:instance-ids m3449 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3450 :com.palletops.awaze.client-builder/undef)
     (.
      bean3448
      setInstanceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg3542] (clojure.core/str arg3542))
 v3450))))
   (clojure.core/let
    [v3450
     (:next-token m3449 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3450 :com.palletops.awaze.client-builder/undef)
     (. bean3448 setNextToken (clojure.core/str v3450))))
   (clojure.core/let
    [v3450
     (:max-records m3449 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3450 :com.palletops.awaze.client-builder/undef)
     (. bean3448 setMaxRecords (clojure.core/int v3450))))
   bean3448))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DescribeAccountLimitsRequest}
describe-account-limits-request
  [m3452]
  (clojure.core/let
   [bean3451
    (new
     com.amazonaws.services.autoscaling.model.DescribeAccountLimitsRequest)]
   bean3451))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DescribeNotificationConfigurationsRequest}
describe-notification-configurations-request
  [m3455]
  (clojure.core/let
   [bean3454
    (new
     com.amazonaws.services.autoscaling.model.DescribeNotificationConfigurationsRequest)]
   (clojure.core/let
    [v3456
     (:auto-scaling-group-names
      m3455
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3456 :com.palletops.awaze.client-builder/undef)
     (.
      bean3454
      setAutoScalingGroupNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg3543] (clojure.core/str arg3543))
 v3456))))
   (clojure.core/let
    [v3456
     (:next-token m3455 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3456 :com.palletops.awaze.client-builder/undef)
     (. bean3454 setNextToken (clojure.core/str v3456))))
   (clojure.core/let
    [v3456
     (:max-records m3455 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3456 :com.palletops.awaze.client-builder/undef)
     (. bean3454 setMaxRecords (clojure.core/int v3456))))
   bean3454))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DescribeAutoScalingNotificationTypesRequest}
describe-auto-scaling-notification-types-request
  [m3458]
  (clojure.core/let
   [bean3457
    (new
     com.amazonaws.services.autoscaling.model.DescribeAutoScalingNotificationTypesRequest)]
   bean3457))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.PutNotificationConfigurationRequest}
put-notification-configuration-request
  [m3461]
  (clojure.core/let
   [bean3460
    (new
     com.amazonaws.services.autoscaling.model.PutNotificationConfigurationRequest)]
   (clojure.core/let
    [v3462
     (:auto-scaling-group-name
      m3461
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3462 :com.palletops.awaze.client-builder/undef)
     (. bean3460 setAutoScalingGroupName (clojure.core/str v3462))))
   (clojure.core/let
    [v3462
     (:topic-arn m3461 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3462 :com.palletops.awaze.client-builder/undef)
     (. bean3460 setTopicARN (clojure.core/str v3462))))
   (clojure.core/let
    [v3462
     (:notification-types
      m3461
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3462 :com.palletops.awaze.client-builder/undef)
     (.
      bean3460
      setNotificationTypes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg3544] (clojure.core/str arg3544))
 v3462))))
   bean3460))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DescribePoliciesRequest}
describe-policies-request
  [m3464]
  (clojure.core/let
   [bean3463
    (new
     com.amazonaws.services.autoscaling.model.DescribePoliciesRequest)]
   (clojure.core/let
    [v3465
     (:auto-scaling-group-name
      m3464
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3465 :com.palletops.awaze.client-builder/undef)
     (. bean3463 setAutoScalingGroupName (clojure.core/str v3465))))
   (clojure.core/let
    [v3465
     (:policy-names m3464 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3465 :com.palletops.awaze.client-builder/undef)
     (.
      bean3463
      setPolicyNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg3545] (clojure.core/str arg3545))
 v3465))))
   (clojure.core/let
    [v3465
     (:next-token m3464 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3465 :com.palletops.awaze.client-builder/undef)
     (. bean3463 setNextToken (clojure.core/str v3465))))
   (clojure.core/let
    [v3465
     (:max-records m3464 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3465 :com.palletops.awaze.client-builder/undef)
     (. bean3463 setMaxRecords (clojure.core/int v3465))))
   bean3463))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.SuspendProcessesRequest}
suspend-processes-request
  [m3467]
  (clojure.core/let
   [bean3466
    (new
     com.amazonaws.services.autoscaling.model.SuspendProcessesRequest)]
   (clojure.core/let
    [v3468
     (:auto-scaling-group-name
      m3467
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3468 :com.palletops.awaze.client-builder/undef)
     (. bean3466 setAutoScalingGroupName (clojure.core/str v3468))))
   (clojure.core/let
    [v3468
     (:scaling-processes
      m3467
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3468 :com.palletops.awaze.client-builder/undef)
     (.
      bean3466
      setScalingProcesses
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg3546] (clojure.core/str arg3546))
 v3468))))
   bean3466))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.CreateAutoScalingGroupRequest}
create-auto-scaling-group-request
  [m3470]
  (clojure.core/let
   [bean3469
    (new
     com.amazonaws.services.autoscaling.model.CreateAutoScalingGroupRequest)]
   (clojure.core/let
    [v3471
     (:max-size m3470 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3471 :com.palletops.awaze.client-builder/undef)
     (. bean3469 setMaxSize (clojure.core/int v3471))))
   (clojure.core/let
    [v3471
     (:health-check-type
      m3470
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3471 :com.palletops.awaze.client-builder/undef)
     (. bean3469 setHealthCheckType (clojure.core/str v3471))))
   (clojure.core/let
    [v3471
     (:default-cooldown
      m3470
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3471 :com.palletops.awaze.client-builder/undef)
     (. bean3469 setDefaultCooldown (clojure.core/int v3471))))
   (clojure.core/let
    [v3471
     (:load-balancer-names
      m3470
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3471 :com.palletops.awaze.client-builder/undef)
     (.
      bean3469
      setLoadBalancerNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg3547] (clojure.core/str arg3547))
 v3471))))
   (clojure.core/let
    [v3471
     (:availability-zones
      m3470
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3471 :com.palletops.awaze.client-builder/undef)
     (.
      bean3469
      setAvailabilityZones
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg3548] (clojure.core/str arg3548))
 v3471))))
   (clojure.core/let
    [v3471
     (:launch-configuration-name
      m3470
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3471 :com.palletops.awaze.client-builder/undef)
     (. bean3469 setLaunchConfigurationName (clojure.core/str v3471))))
   (clojure.core/let
    [v3471
     (:health-check-grace-period
      m3470
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3471 :com.palletops.awaze.client-builder/undef)
     (. bean3469 setHealthCheckGracePeriod (clojure.core/int v3471))))
   (clojure.core/let
    [v3471
     (:min-size m3470 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3471 :com.palletops.awaze.client-builder/undef)
     (. bean3469 setMinSize (clojure.core/int v3471))))
   (clojure.core/let
    [v3471
     (:desired-capacity
      m3470
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3471 :com.palletops.awaze.client-builder/undef)
     (. bean3469 setDesiredCapacity (clojure.core/int v3471))))
   (clojure.core/let
    [v3471
     (:termination-policies
      m3470
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3471 :com.palletops.awaze.client-builder/undef)
     (.
      bean3469
      setTerminationPolicies
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg3549] (clojure.core/str arg3549))
 v3471))))
   (clojure.core/let
    [v3471
     (:instance-id m3470 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3471 :com.palletops.awaze.client-builder/undef)
     (. bean3469 setInstanceId (clojure.core/str v3471))))
   (clojure.core/let
    [v3471
     (:auto-scaling-group-name
      m3470
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3471 :com.palletops.awaze.client-builder/undef)
     (. bean3469 setAutoScalingGroupName (clojure.core/str v3471))))
   (clojure.core/let
    [v3471 (:tags m3470 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3471 :com.palletops.awaze.client-builder/undef)
     (.
      bean3469
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg3550] (autoscaling/tag arg3550))
 v3471))))
   (clojure.core/let
    [v3471
     (:vpczone-identifier
      m3470
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3471 :com.palletops.awaze.client-builder/undef)
     (. bean3469 setVPCZoneIdentifier (clojure.core/str v3471))))
   (clojure.core/let
    [v3471
     (:placement-group
      m3470
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3471 :com.palletops.awaze.client-builder/undef)
     (. bean3469 setPlacementGroup (clojure.core/str v3471))))
   bean3469))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DescribeAutoScalingGroupsRequest}
describe-auto-scaling-groups-request
  [m3473]
  (clojure.core/let
   [bean3472
    (new
     com.amazonaws.services.autoscaling.model.DescribeAutoScalingGroupsRequest)]
   (clojure.core/let
    [v3474
     (:auto-scaling-group-names
      m3473
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3474 :com.palletops.awaze.client-builder/undef)
     (.
      bean3472
      setAutoScalingGroupNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg3551] (clojure.core/str arg3551))
 v3474))))
   (clojure.core/let
    [v3474
     (:next-token m3473 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3474 :com.palletops.awaze.client-builder/undef)
     (. bean3472 setNextToken (clojure.core/str v3474))))
   (clojure.core/let
    [v3474
     (:max-records m3473 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3474 :com.palletops.awaze.client-builder/undef)
     (. bean3472 setMaxRecords (clojure.core/int v3474))))
   bean3472))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.PutScalingPolicyRequest}
put-scaling-policy-request
  [m3476]
  (clojure.core/let
   [bean3475
    (new
     com.amazonaws.services.autoscaling.model.PutScalingPolicyRequest)]
   (clojure.core/let
    [v3477
     (:auto-scaling-group-name
      m3476
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3477 :com.palletops.awaze.client-builder/undef)
     (. bean3475 setAutoScalingGroupName (clojure.core/str v3477))))
   (clojure.core/let
    [v3477
     (:policy-name m3476 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3477 :com.palletops.awaze.client-builder/undef)
     (. bean3475 setPolicyName (clojure.core/str v3477))))
   (clojure.core/let
    [v3477
     (:scaling-adjustment
      m3476
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3477 :com.palletops.awaze.client-builder/undef)
     (. bean3475 setScalingAdjustment (clojure.core/int v3477))))
   (clojure.core/let
    [v3477
     (:adjustment-type
      m3476
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3477 :com.palletops.awaze.client-builder/undef)
     (. bean3475 setAdjustmentType (clojure.core/str v3477))))
   (clojure.core/let
    [v3477
     (:cooldown m3476 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3477 :com.palletops.awaze.client-builder/undef)
     (. bean3475 setCooldown (clojure.core/int v3477))))
   (clojure.core/let
    [v3477
     (:min-adjustment-step
      m3476
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3477 :com.palletops.awaze.client-builder/undef)
     (. bean3475 setMinAdjustmentStep (clojure.core/int v3477))))
   bean3475))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.ExecutePolicyRequest}
execute-policy-request
  [m3479]
  (clojure.core/let
   [bean3478
    (new
     com.amazonaws.services.autoscaling.model.ExecutePolicyRequest)]
   (clojure.core/let
    [v3480
     (:auto-scaling-group-name
      m3479
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3480 :com.palletops.awaze.client-builder/undef)
     (. bean3478 setAutoScalingGroupName (clojure.core/str v3480))))
   (clojure.core/let
    [v3480
     (:policy-name m3479 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3480 :com.palletops.awaze.client-builder/undef)
     (. bean3478 setPolicyName (clojure.core/str v3480))))
   (clojure.core/let
    [v3480
     (:honor-cooldown m3479 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3480 :com.palletops.awaze.client-builder/undef)
     (. bean3478 setHonorCooldown (clojure.core/boolean v3480))))
   bean3478))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.CreateLaunchConfigurationRequest}
create-launch-configuration-request
  [m3482]
  (clojure.core/let
   [bean3481
    (new
     com.amazonaws.services.autoscaling.model.CreateLaunchConfigurationRequest)]
   (clojure.core/let
    [v3483
     (:iam-instance-profile
      m3482
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3483 :com.palletops.awaze.client-builder/undef)
     (. bean3481 setIamInstanceProfile (clojure.core/str v3483))))
   (clojure.core/let
    [v3483
     (:spot-price m3482 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3483 :com.palletops.awaze.client-builder/undef)
     (. bean3481 setSpotPrice (clojure.core/str v3483))))
   (clojure.core/let
    [v3483
     (:block-device-mappings
      m3482
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3483 :com.palletops.awaze.client-builder/undef)
     (.
      bean3481
      setBlockDeviceMappings
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg3552]
  (autoscaling/block-device-mapping arg3552))
 v3483))))
   (clojure.core/let
    [v3483
     (:key-name m3482 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3483 :com.palletops.awaze.client-builder/undef)
     (. bean3481 setKeyName (clojure.core/str v3483))))
   (clojure.core/let
    [v3483
     (:associate-public-ip-address
      m3482
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3483 :com.palletops.awaze.client-builder/undef)
     (.
      bean3481
      setAssociatePublicIpAddress
      (clojure.core/boolean v3483))))
   (clojure.core/let
    [v3483
     (:launch-configuration-name
      m3482
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3483 :com.palletops.awaze.client-builder/undef)
     (. bean3481 setLaunchConfigurationName (clojure.core/str v3483))))
   (clojure.core/let
    [v3483
     (:instance-type m3482 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3483 :com.palletops.awaze.client-builder/undef)
     (. bean3481 setInstanceType (clojure.core/str v3483))))
   (clojure.core/let
    [v3483
     (:instance-id m3482 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3483 :com.palletops.awaze.client-builder/undef)
     (. bean3481 setInstanceId (clojure.core/str v3483))))
   (clojure.core/let
    [v3483
     (:ebs-optimized m3482 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3483 :com.palletops.awaze.client-builder/undef)
     (. bean3481 setEbsOptimized (clojure.core/boolean v3483))))
   (clojure.core/let
    [v3483
     (:image-id m3482 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3483 :com.palletops.awaze.client-builder/undef)
     (. bean3481 setImageId (clojure.core/str v3483))))
   (clojure.core/let
    [v3483
     (:ramdisk-id m3482 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3483 :com.palletops.awaze.client-builder/undef)
     (. bean3481 setRamdiskId (clojure.core/str v3483))))
   (clojure.core/let
    [v3483
     (:security-groups
      m3482
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3483 :com.palletops.awaze.client-builder/undef)
     (.
      bean3481
      setSecurityGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg3553] (clojure.core/str arg3553))
 v3483))))
   (clojure.core/let
    [v3483
     (:user-data m3482 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3483 :com.palletops.awaze.client-builder/undef)
     (. bean3481 setUserData (clojure.core/str v3483))))
   (clojure.core/let
    [v3483
     (:kernel-id m3482 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3483 :com.palletops.awaze.client-builder/undef)
     (. bean3481 setKernelId (clojure.core/str v3483))))
   (clojure.core/let
    [v3483
     (:placement-tenancy
      m3482
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3483 :com.palletops.awaze.client-builder/undef)
     (. bean3481 setPlacementTenancy (clojure.core/str v3483))))
   (clojure.core/let
    [v3483
     (:instance-monitoring
      m3482
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3483 :com.palletops.awaze.client-builder/undef)
     (.
      bean3481
      setInstanceMonitoring
      (autoscaling/instance-monitoring v3483))))
   bean3481))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DescribeTerminationPolicyTypesRequest}
describe-termination-policy-types-request
  [m3485]
  (clojure.core/let
   [bean3484
    (new
     com.amazonaws.services.autoscaling.model.DescribeTerminationPolicyTypesRequest)]
   bean3484))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DescribeScalingActivitiesRequest}
describe-scaling-activities-request
  [m3488]
  (clojure.core/let
   [bean3487
    (new
     com.amazonaws.services.autoscaling.model.DescribeScalingActivitiesRequest)]
   (clojure.core/let
    [v3489
     (:auto-scaling-group-name
      m3488
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3489 :com.palletops.awaze.client-builder/undef)
     (. bean3487 setAutoScalingGroupName (clojure.core/str v3489))))
   (clojure.core/let
    [v3489
     (:activity-ids m3488 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3489 :com.palletops.awaze.client-builder/undef)
     (.
      bean3487
      setActivityIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg3554] (clojure.core/str arg3554))
 v3489))))
   (clojure.core/let
    [v3489
     (:next-token m3488 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3489 :com.palletops.awaze.client-builder/undef)
     (. bean3487 setNextToken (clojure.core/str v3489))))
   (clojure.core/let
    [v3489
     (:max-records m3488 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3489 :com.palletops.awaze.client-builder/undef)
     (. bean3487 setMaxRecords (clojure.core/int v3489))))
   bean3487))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DescribeScheduledActionsRequest}
describe-scheduled-actions-request
  [m3491]
  (clojure.core/let
   [bean3490
    (new
     com.amazonaws.services.autoscaling.model.DescribeScheduledActionsRequest)]
   (clojure.core/let
    [v3492
     (:auto-scaling-group-name
      m3491
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3492 :com.palletops.awaze.client-builder/undef)
     (. bean3490 setAutoScalingGroupName (clojure.core/str v3492))))
   (clojure.core/let
    [v3492
     (:next-token m3491 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3492 :com.palletops.awaze.client-builder/undef)
     (. bean3490 setNextToken (clojure.core/str v3492))))
   (clojure.core/let
    [v3492
     (:scheduled-action-names
      m3491
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3492 :com.palletops.awaze.client-builder/undef)
     (.
      bean3490
      setScheduledActionNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg3555] (clojure.core/str arg3555))
 v3492))))
   (clojure.core/let
    [v3492
     (:max-records m3491 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3492 :com.palletops.awaze.client-builder/undef)
     (. bean3490 setMaxRecords (clojure.core/int v3492))))
   (clojure.core/let
    [v3492
     (:start-time m3491 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3492 :com.palletops.awaze.client-builder/undef)
     (.
      bean3490
      setStartTime
      (com.palletops.awaze.common/to-date v3492))))
   (clojure.core/let
    [v3492
     (:end-time m3491 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3492 :com.palletops.awaze.client-builder/undef)
     (.
      bean3490
      setEndTime
      (com.palletops.awaze.common/to-date v3492))))
   bean3490))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DescribeAdjustmentTypesRequest}
describe-adjustment-types-request
  [m3494]
  (clojure.core/let
   [bean3493
    (new
     com.amazonaws.services.autoscaling.model.DescribeAdjustmentTypesRequest)]
   bean3493))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DescribeTagsRequest}
describe-tags-request
  [m3497]
  (clojure.core/let
   [bean3496
    (new com.amazonaws.services.autoscaling.model.DescribeTagsRequest)]
   (clojure.core/let
    [v3498 (:filters m3497 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3498 :com.palletops.awaze.client-builder/undef)
     (.
      bean3496
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg3556] (autoscaling/filter arg3556))
 v3498))))
   (clojure.core/let
    [v3498
     (:next-token m3497 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3498 :com.palletops.awaze.client-builder/undef)
     (. bean3496 setNextToken (clojure.core/str v3498))))
   (clojure.core/let
    [v3498
     (:max-records m3497 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3498 :com.palletops.awaze.client-builder/undef)
     (. bean3496 setMaxRecords (clojure.core/int v3498))))
   bean3496))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.ResumeProcessesRequest}
resume-processes-request
  [m3500]
  (clojure.core/let
   [bean3499
    (new
     com.amazonaws.services.autoscaling.model.ResumeProcessesRequest)]
   (clojure.core/let
    [v3501
     (:auto-scaling-group-name
      m3500
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3501 :com.palletops.awaze.client-builder/undef)
     (. bean3499 setAutoScalingGroupName (clojure.core/str v3501))))
   (clojure.core/let
    [v3501
     (:scaling-processes
      m3500
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3501 :com.palletops.awaze.client-builder/undef)
     (.
      bean3499
      setScalingProcesses
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg3557] (clojure.core/str arg3557))
 v3501))))
   bean3499))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DeleteLaunchConfigurationRequest}
delete-launch-configuration-request
  [m3503]
  (clojure.core/let
   [bean3502
    (new
     com.amazonaws.services.autoscaling.model.DeleteLaunchConfigurationRequest)]
   (clojure.core/let
    [v3504
     (:launch-configuration-name
      m3503
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3504 :com.palletops.awaze.client-builder/undef)
     (. bean3502 setLaunchConfigurationName (clojure.core/str v3504))))
   bean3502))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DisableMetricsCollectionRequest}
disable-metrics-collection-request
  [m3506]
  (clojure.core/let
   [bean3505
    (new
     com.amazonaws.services.autoscaling.model.DisableMetricsCollectionRequest)]
   (clojure.core/let
    [v3507
     (:auto-scaling-group-name
      m3506
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3507 :com.palletops.awaze.client-builder/undef)
     (. bean3505 setAutoScalingGroupName (clojure.core/str v3507))))
   (clojure.core/let
    [v3507 (:metrics m3506 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3507 :com.palletops.awaze.client-builder/undef)
     (.
      bean3505
      setMetrics
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg3558] (clojure.core/str arg3558))
 v3507))))
   bean3505))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.PutScheduledUpdateGroupActionRequest}
put-scheduled-update-group-action-request
  [m3509]
  (clojure.core/let
   [bean3508
    (new
     com.amazonaws.services.autoscaling.model.PutScheduledUpdateGroupActionRequest)]
   (clojure.core/let
    [v3510
     (:max-size m3509 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3510 :com.palletops.awaze.client-builder/undef)
     (. bean3508 setMaxSize (clojure.core/int v3510))))
   (clojure.core/let
    [v3510
     (:end-time m3509 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3510 :com.palletops.awaze.client-builder/undef)
     (.
      bean3508
      setEndTime
      (com.palletops.awaze.common/to-date v3510))))
   (clojure.core/let
    [v3510
     (:scheduled-action-name
      m3509
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3510 :com.palletops.awaze.client-builder/undef)
     (. bean3508 setScheduledActionName (clojure.core/str v3510))))
   (clojure.core/let
    [v3510
     (:start-time m3509 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3510 :com.palletops.awaze.client-builder/undef)
     (.
      bean3508
      setStartTime
      (com.palletops.awaze.common/to-date v3510))))
   (clojure.core/let
    [v3510 (:time m3509 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3510 :com.palletops.awaze.client-builder/undef)
     (. bean3508 setTime (com.palletops.awaze.common/to-date v3510))))
   (clojure.core/let
    [v3510
     (:min-size m3509 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3510 :com.palletops.awaze.client-builder/undef)
     (. bean3508 setMinSize (clojure.core/int v3510))))
   (clojure.core/let
    [v3510
     (:desired-capacity
      m3509
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3510 :com.palletops.awaze.client-builder/undef)
     (. bean3508 setDesiredCapacity (clojure.core/int v3510))))
   (clojure.core/let
    [v3510
     (:recurrence m3509 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3510 :com.palletops.awaze.client-builder/undef)
     (. bean3508 setRecurrence (clojure.core/str v3510))))
   (clojure.core/let
    [v3510
     (:auto-scaling-group-name
      m3509
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3510 :com.palletops.awaze.client-builder/undef)
     (. bean3508 setAutoScalingGroupName (clojure.core/str v3510))))
   bean3508))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DescribeScalingProcessTypesRequest}
describe-scaling-process-types-request
  [m3512]
  (clojure.core/let
   [bean3511
    (new
     com.amazonaws.services.autoscaling.model.DescribeScalingProcessTypesRequest)]
   bean3511))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DescribeMetricCollectionTypesRequest}
describe-metric-collection-types-request
  [m3515]
  (clojure.core/let
   [bean3514
    (new
     com.amazonaws.services.autoscaling.model.DescribeMetricCollectionTypesRequest)]
   bean3514))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DeleteScheduledActionRequest}
delete-scheduled-action-request
  [m3518]
  (clojure.core/let
   [bean3517
    (new
     com.amazonaws.services.autoscaling.model.DeleteScheduledActionRequest)]
   (clojure.core/let
    [v3519
     (:auto-scaling-group-name
      m3518
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3519 :com.palletops.awaze.client-builder/undef)
     (. bean3517 setAutoScalingGroupName (clojure.core/str v3519))))
   (clojure.core/let
    [v3519
     (:scheduled-action-name
      m3518
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3519 :com.palletops.awaze.client-builder/undef)
     (. bean3517 setScheduledActionName (clojure.core/str v3519))))
   bean3517))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.UpdateAutoScalingGroupRequest}
update-auto-scaling-group-request
  [m3521]
  (clojure.core/let
   [bean3520
    (new
     com.amazonaws.services.autoscaling.model.UpdateAutoScalingGroupRequest)]
   (clojure.core/let
    [v3522
     (:max-size m3521 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3522 :com.palletops.awaze.client-builder/undef)
     (. bean3520 setMaxSize (clojure.core/int v3522))))
   (clojure.core/let
    [v3522
     (:health-check-type
      m3521
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3522 :com.palletops.awaze.client-builder/undef)
     (. bean3520 setHealthCheckType (clojure.core/str v3522))))
   (clojure.core/let
    [v3522
     (:default-cooldown
      m3521
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3522 :com.palletops.awaze.client-builder/undef)
     (. bean3520 setDefaultCooldown (clojure.core/int v3522))))
   (clojure.core/let
    [v3522
     (:availability-zones
      m3521
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3522 :com.palletops.awaze.client-builder/undef)
     (.
      bean3520
      setAvailabilityZones
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg3559] (clojure.core/str arg3559))
 v3522))))
   (clojure.core/let
    [v3522
     (:launch-configuration-name
      m3521
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3522 :com.palletops.awaze.client-builder/undef)
     (. bean3520 setLaunchConfigurationName (clojure.core/str v3522))))
   (clojure.core/let
    [v3522
     (:health-check-grace-period
      m3521
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3522 :com.palletops.awaze.client-builder/undef)
     (. bean3520 setHealthCheckGracePeriod (clojure.core/int v3522))))
   (clojure.core/let
    [v3522
     (:min-size m3521 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3522 :com.palletops.awaze.client-builder/undef)
     (. bean3520 setMinSize (clojure.core/int v3522))))
   (clojure.core/let
    [v3522
     (:desired-capacity
      m3521
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3522 :com.palletops.awaze.client-builder/undef)
     (. bean3520 setDesiredCapacity (clojure.core/int v3522))))
   (clojure.core/let
    [v3522
     (:termination-policies
      m3521
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3522 :com.palletops.awaze.client-builder/undef)
     (.
      bean3520
      setTerminationPolicies
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg3560] (clojure.core/str arg3560))
 v3522))))
   (clojure.core/let
    [v3522
     (:auto-scaling-group-name
      m3521
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3522 :com.palletops.awaze.client-builder/undef)
     (. bean3520 setAutoScalingGroupName (clojure.core/str v3522))))
   (clojure.core/let
    [v3522
     (:vpczone-identifier
      m3521
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3522 :com.palletops.awaze.client-builder/undef)
     (. bean3520 setVPCZoneIdentifier (clojure.core/str v3522))))
   (clojure.core/let
    [v3522
     (:placement-group
      m3521
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3522 :com.palletops.awaze.client-builder/undef)
     (. bean3520 setPlacementGroup (clojure.core/str v3522))))
   bean3520))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.AttachInstancesRequest}
attach-instances-request
  [m3524]
  (clojure.core/let
   [bean3523
    (new
     com.amazonaws.services.autoscaling.model.AttachInstancesRequest)]
   (clojure.core/let
    [v3525
     (:instance-ids m3524 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3525 :com.palletops.awaze.client-builder/undef)
     (.
      bean3523
      setInstanceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg3561] (clojure.core/str arg3561))
 v3525))))
   (clojure.core/let
    [v3525
     (:auto-scaling-group-name
      m3524
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3525 :com.palletops.awaze.client-builder/undef)
     (. bean3523 setAutoScalingGroupName (clojure.core/str v3525))))
   bean3523))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DeleteNotificationConfigurationRequest}
delete-notification-configuration-request
  [m3527]
  (clojure.core/let
   [bean3526
    (new
     com.amazonaws.services.autoscaling.model.DeleteNotificationConfigurationRequest)]
   (clojure.core/let
    [v3528
     (:auto-scaling-group-name
      m3527
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3528 :com.palletops.awaze.client-builder/undef)
     (. bean3526 setAutoScalingGroupName (clojure.core/str v3528))))
   (clojure.core/let
    [v3528
     (:topic-arn m3527 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3528 :com.palletops.awaze.client-builder/undef)
     (. bean3526 setTopicARN (clojure.core/str v3528))))
   bean3526))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.TerminateInstanceInAutoScalingGroupRequest}
terminate-instance-in-auto-scaling-group-request
  [m3530]
  (clojure.core/let
   [bean3529
    (new
     com.amazonaws.services.autoscaling.model.TerminateInstanceInAutoScalingGroupRequest)]
   (clojure.core/let
    [v3531
     (:instance-id m3530 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3531 :com.palletops.awaze.client-builder/undef)
     (. bean3529 setInstanceId (clojure.core/str v3531))))
   (clojure.core/let
    [v3531
     (:should-decrement-desired-capacity
      m3530
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3531 :com.palletops.awaze.client-builder/undef)
     (.
      bean3529
      setShouldDecrementDesiredCapacity
      (clojure.core/boolean v3531))))
   bean3529))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.DeleteAutoScalingGroupRequest}
delete-auto-scaling-group-request
  [m3533]
  (clojure.core/let
   [bean3532
    (new
     com.amazonaws.services.autoscaling.model.DeleteAutoScalingGroupRequest)]
   (clojure.core/let
    [v3534
     (:auto-scaling-group-name
      m3533
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3534 :com.palletops.awaze.client-builder/undef)
     (. bean3532 setAutoScalingGroupName (clojure.core/str v3534))))
   (clojure.core/let
    [v3534
     (:force-delete m3533 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3534 :com.palletops.awaze.client-builder/undef)
     (. bean3532 setForceDelete (clojure.core/boolean v3534))))
   bean3532))
 (clojure.core/defn
^{:tag com.amazonaws.services.autoscaling.model.CreateOrUpdateTagsRequest}
create-or-update-tags-request
  [m3536]
  (clojure.core/let
   [bean3535
    (new
     com.amazonaws.services.autoscaling.model.CreateOrUpdateTagsRequest)]
   (clojure.core/let
    [v3537 (:tags m3536 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3537 :com.palletops.awaze.client-builder/undef)
     (.
      bean3535
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg3562] (autoscaling/tag arg3562))
 v3537))))
   bean3535))
 (clojure.core/defmulti
  autoscaling
  (clojure.core/fn
   autoscaling
   [m__1683__auto__]
   (:fn m__1683__auto__)))
 (do
  (clojure.core/defmethod
   autoscaling
   :set-desired-capacity
   [m3563]
   (clojure.core/let
    [credentials3564 (:credentials m3563) args3565 (:args m3563)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client3566
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3564)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3566
       setDesiredCapacity
       (autoscaling/set-desired-capacity-request
        (clojure.core/nth args3565 0)))))))
  (clojure.core/defn
   set-desired-capacity-map
   {:arglists (quote
               [[credentials
                 {:keys [honor-cooldown
                         general-progress-listener
                         desired-capacity
                         auto-scaling-group-name]}]]),
    :doc "Generate map for setDesiredCapacity"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :set-desired-capacity,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   set-desired-capacity
   {:arglists (quote
               [[credentials
                 {:keys [honor-cooldown
                         general-progress-listener
                         desired-capacity
                         auto-scaling-group-name]}]]),
    :doc "Call setDesiredCapacity"}
   [credentials3568 & args3569]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client3570
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3568)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3570
      setDesiredCapacity
      (autoscaling/set-desired-capacity-request
       (clojure.core/nth args3569 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :enable-metrics-collection
   [m3571]
   (clojure.core/let
    [credentials3572 (:credentials m3571) args3573 (:args m3571)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client3574
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3572)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3574
       enableMetricsCollection
       (autoscaling/enable-metrics-collection-request
        (clojure.core/nth args3573 0)))))))
  (clojure.core/defn
   enable-metrics-collection-map
   {:arglists (quote
               [[credentials
                 {:keys [metrics
                         granularity
                         general-progress-listener
                         auto-scaling-group-name]}]]),
    :doc "Generate map for enableMetricsCollection"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :enable-metrics-collection,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   enable-metrics-collection
   {:arglists (quote
               [[credentials
                 {:keys [metrics
                         granularity
                         general-progress-listener
                         auto-scaling-group-name]}]]),
    :doc "Call enableMetricsCollection"}
   [credentials3576 & args3577]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client3578
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3576)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3578
      enableMetricsCollection
      (autoscaling/enable-metrics-collection-request
       (clojure.core/nth args3577 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :delete-policy
   [m3579]
   (clojure.core/let
    [credentials3580 (:credentials m3579) args3581 (:args m3579)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client3582
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3580)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3582
       deletePolicy
       (autoscaling/delete-policy-request
        (clojure.core/nth args3581 0)))))))
  (clojure.core/defn
   delete-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [policy-name
                         general-progress-listener
                         auto-scaling-group-name]}]]),
    :doc "Generate map for deletePolicy"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :delete-policy,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-policy
   {:arglists (quote
               [[credentials
                 {:keys [policy-name
                         general-progress-listener
                         auto-scaling-group-name]}]]),
    :doc "Call deletePolicy"}
   [credentials3584 & args3585]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client3586
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3584)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3586
      deletePolicy
      (autoscaling/delete-policy-request
       (clojure.core/nth args3585 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :set-instance-health
   [m3587]
   (clojure.core/let
    [credentials3588 (:credentials m3587) args3589 (:args m3587)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client3590
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3588)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3590
       setInstanceHealth
       (autoscaling/set-instance-health-request
        (clojure.core/nth args3589 0)))))))
  (clojure.core/defn
   set-instance-health-map
   {:arglists (quote
               [[credentials
                 {:keys [should-respect-grace-period
                         instance-id
                         health-status
                         general-progress-listener]}]]),
    :doc "Generate map for setInstanceHealth"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :set-instance-health,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   set-instance-health
   {:arglists (quote
               [[credentials
                 {:keys [should-respect-grace-period
                         instance-id
                         health-status
                         general-progress-listener]}]]),
    :doc "Call setInstanceHealth"}
   [credentials3592 & args3593]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client3594
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3592)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3594
      setInstanceHealth
      (autoscaling/set-instance-health-request
       (clojure.core/nth args3593 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-launch-configurations
   [m3595]
   (clojure.core/let
    [credentials3596 (:credentials m3595) args3597 (:args m3595)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client3598
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3596)]
     (clojure.core/case
      (clojure.core/count args3597)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3598
        describeLaunchConfigurations))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3598
        describeLaunchConfigurations
        (autoscaling/describe-launch-configurations-request
         (clojure.core/nth args3597 0))))))))
  (clojure.core/defn
   describe-launch-configurations-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [next-token
                         max-records
                         launch-configuration-names
                         general-progress-listener]}]]),
    :doc "Generate map for describeLaunchConfigurations, describeLaunchConfigurations"}
   ([credentials__1651__auto__]
    {:args [],
     :client :autoscaling,
     :fn :describe-launch-configurations,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :describe-launch-configurations,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-launch-configurations
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [next-token
                         max-records
                         launch-configuration-names
                         general-progress-listener]}]]),
    :doc "Call describeLaunchConfigurations, describeLaunchConfigurations"}
   [credentials3600 & args3601]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client3602
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3600)]
    (clojure.core/case
     (clojure.core/count args3601)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3602
       describeLaunchConfigurations))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3602
       describeLaunchConfigurations
       (autoscaling/describe-launch-configurations-request
        (clojure.core/nth args3601 0))))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :delete-tags
   [m3603]
   (clojure.core/let
    [credentials3604 (:credentials m3603) args3605 (:args m3603)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client3606
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3604)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3606
       deleteTags
       (autoscaling/delete-tags-request (clojure.core/nth args3605 0)))))))
  (clojure.core/defn
   delete-tags-map
   {:arglists (quote
               [[credentials {:keys [tags general-progress-listener]}]]),
    :doc "Generate map for deleteTags"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :delete-tags,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-tags
   {:arglists (quote
               [[credentials {:keys [tags general-progress-listener]}]]),
    :doc "Call deleteTags"}
   [credentials3608 & args3609]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client3610
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3608)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3610
      deleteTags
      (autoscaling/delete-tags-request (clojure.core/nth args3609 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-auto-scaling-instances
   [m3611]
   (clojure.core/let
    [credentials3612 (:credentials m3611) args3613 (:args m3611)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client3614
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3612)]
     (clojure.core/case
      (clojure.core/count args3613)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3614
        describeAutoScalingInstances))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3614
        describeAutoScalingInstances
        (autoscaling/describe-auto-scaling-instances-request
         (clojure.core/nth args3613 0))))))))
  (clojure.core/defn
   describe-auto-scaling-instances-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [next-token
                         max-records
                         instance-ids
                         general-progress-listener]}]]),
    :doc "Generate map for describeAutoScalingInstances, describeAutoScalingInstances"}
   ([credentials__1651__auto__]
    {:args [],
     :client :autoscaling,
     :fn :describe-auto-scaling-instances,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :describe-auto-scaling-instances,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-auto-scaling-instances
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [next-token
                         max-records
                         instance-ids
                         general-progress-listener]}]]),
    :doc "Call describeAutoScalingInstances, describeAutoScalingInstances"}
   [credentials3616 & args3617]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client3618
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3616)]
    (clojure.core/case
     (clojure.core/count args3617)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3618
       describeAutoScalingInstances))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3618
       describeAutoScalingInstances
       (autoscaling/describe-auto-scaling-instances-request
        (clojure.core/nth args3617 0))))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-account-limits
   [m3619]
   (clojure.core/let
    [credentials3620 (:credentials m3619) args3621 (:args m3619)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client3622
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3620)]
     (clojure.core/case
      (clojure.core/count args3621)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3622
        describeAccountLimits))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3622
        describeAccountLimits
        (autoscaling/describe-account-limits-request
         (clojure.core/nth args3621 0))))))))
  (clojure.core/defn
   describe-account-limits-map
   {:arglists (quote
               [[credentials]
                [credentials {:keys [general-progress-listener]}]]),
    :doc "Generate map for describeAccountLimits, describeAccountLimits"}
   ([credentials__1651__auto__]
    {:args [],
     :client :autoscaling,
     :fn :describe-account-limits,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :describe-account-limits,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-account-limits
   {:arglists (quote
               [[credentials]
                [credentials {:keys [general-progress-listener]}]]),
    :doc "Call describeAccountLimits, describeAccountLimits"}
   [credentials3624 & args3625]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client3626
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3624)]
    (clojure.core/case
     (clojure.core/count args3625)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3626
       describeAccountLimits))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3626
       describeAccountLimits
       (autoscaling/describe-account-limits-request
        (clojure.core/nth args3625 0))))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-notification-configurations
   [m3627]
   (clojure.core/let
    [credentials3628 (:credentials m3627) args3629 (:args m3627)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client3630
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3628)]
     (clojure.core/case
      (clojure.core/count args3629)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3630
        describeNotificationConfigurations))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3630
        describeNotificationConfigurations
        (autoscaling/describe-notification-configurations-request
         (clojure.core/nth args3629 0))))))))
  (clojure.core/defn
   describe-notification-configurations-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [next-token
                         max-records
                         general-progress-listener
                         auto-scaling-group-names]}]]),
    :doc "Generate map for describeNotificationConfigurations, describeNotificationConfigurations"}
   ([credentials__1651__auto__]
    {:args [],
     :client :autoscaling,
     :fn :describe-notification-configurations,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :describe-notification-configurations,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-notification-configurations
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [next-token
                         max-records
                         general-progress-listener
                         auto-scaling-group-names]}]]),
    :doc "Call describeNotificationConfigurations, describeNotificationConfigurations"}
   [credentials3632 & args3633]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client3634
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3632)]
    (clojure.core/case
     (clojure.core/count args3633)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3634
       describeNotificationConfigurations))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3634
       describeNotificationConfigurations
       (autoscaling/describe-notification-configurations-request
        (clojure.core/nth args3633 0))))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-auto-scaling-notification-types
   [m3635]
   (clojure.core/let
    [credentials3636 (:credentials m3635) args3637 (:args m3635)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client3638
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3636)]
     (clojure.core/case
      (clojure.core/count args3637)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3638
        describeAutoScalingNotificationTypes))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3638
        describeAutoScalingNotificationTypes
        (autoscaling/describe-auto-scaling-notification-types-request
         (clojure.core/nth args3637 0))))))))
  (clojure.core/defn
   describe-auto-scaling-notification-types-map
   {:arglists (quote
               [[credentials]
                [credentials {:keys [general-progress-listener]}]]),
    :doc "Generate map for describeAutoScalingNotificationTypes, describeAutoScalingNotificationTypes"}
   ([credentials__1651__auto__]
    {:args [],
     :client :autoscaling,
     :fn :describe-auto-scaling-notification-types,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :describe-auto-scaling-notification-types,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-auto-scaling-notification-types
   {:arglists (quote
               [[credentials]
                [credentials {:keys [general-progress-listener]}]]),
    :doc "Call describeAutoScalingNotificationTypes, describeAutoScalingNotificationTypes"}
   [credentials3640 & args3641]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client3642
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3640)]
    (clojure.core/case
     (clojure.core/count args3641)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3642
       describeAutoScalingNotificationTypes))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3642
       describeAutoScalingNotificationTypes
       (autoscaling/describe-auto-scaling-notification-types-request
        (clojure.core/nth args3641 0))))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :put-notification-configuration
   [m3643]
   (clojure.core/let
    [credentials3644 (:credentials m3643) args3645 (:args m3643)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client3646
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3644)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3646
       putNotificationConfiguration
       (autoscaling/put-notification-configuration-request
        (clojure.core/nth args3645 0)))))))
  (clojure.core/defn
   put-notification-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [topic-arn
                         notification-types
                         general-progress-listener
                         auto-scaling-group-name]}]]),
    :doc "Generate map for putNotificationConfiguration"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :put-notification-configuration,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   put-notification-configuration
   {:arglists (quote
               [[credentials
                 {:keys [topic-arn
                         notification-types
                         general-progress-listener
                         auto-scaling-group-name]}]]),
    :doc "Call putNotificationConfiguration"}
   [credentials3648 & args3649]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client3650
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3648)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3650
      putNotificationConfiguration
      (autoscaling/put-notification-configuration-request
       (clojure.core/nth args3649 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-policies
   [m3651]
   (clojure.core/let
    [credentials3652 (:credentials m3651) args3653 (:args m3651)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client3654
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3652)]
     (clojure.core/case
      (clojure.core/count args3653)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3654
        describePolicies))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3654
        describePolicies
        (autoscaling/describe-policies-request
         (clojure.core/nth args3653 0))))))))
  (clojure.core/defn
   describe-policies-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [policy-names
                         next-token
                         max-records
                         general-progress-listener
                         auto-scaling-group-name]}]]),
    :doc "Generate map for describePolicies, describePolicies"}
   ([credentials__1651__auto__]
    {:args [],
     :client :autoscaling,
     :fn :describe-policies,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :describe-policies,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-policies
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [policy-names
                         next-token
                         max-records
                         general-progress-listener
                         auto-scaling-group-name]}]]),
    :doc "Call describePolicies, describePolicies"}
   [credentials3656 & args3657]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client3658
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3656)]
    (clojure.core/case
     (clojure.core/count args3657)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3658
       describePolicies))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3658
       describePolicies
       (autoscaling/describe-policies-request
        (clojure.core/nth args3657 0))))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :suspend-processes
   [m3659]
   (clojure.core/let
    [credentials3660 (:credentials m3659) args3661 (:args m3659)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client3662
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3660)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3662
       suspendProcesses
       (autoscaling/suspend-processes-request
        (clojure.core/nth args3661 0)))))))
  (clojure.core/defn
   suspend-processes-map
   {:arglists (quote
               [[credentials
                 {:keys [scaling-processes
                         general-progress-listener
                         auto-scaling-group-name]}]]),
    :doc "Generate map for suspendProcesses"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :suspend-processes,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   suspend-processes
   {:arglists (quote
               [[credentials
                 {:keys [scaling-processes
                         general-progress-listener
                         auto-scaling-group-name]}]]),
    :doc "Call suspendProcesses"}
   [credentials3664 & args3665]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client3666
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3664)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3666
      suspendProcesses
      (autoscaling/suspend-processes-request
       (clojure.core/nth args3665 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :create-auto-scaling-group
   [m3667]
   (clojure.core/let
    [credentials3668 (:credentials m3667) args3669 (:args m3667)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client3670
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3668)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3670
       createAutoScalingGroup
       (autoscaling/create-auto-scaling-group-request
        (clojure.core/nth args3669 0)))))))
  (clojure.core/defn
   create-auto-scaling-group-map
   {:arglists (quote
               [[credentials
                 {:keys [load-balancer-names
                         health-check-grace-period
                         placement-group
                         general-progress-listener
                         launch-configuration-name
                         termination-policies
                         vpczone-identifier
                         desired-capacity
                         availability-zones
                         min-size
                         instance-id
                         default-cooldown
                         max-size
                         health-check-type
                         auto-scaling-group-name
                         tags]}]]),
    :doc "Generate map for createAutoScalingGroup"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :create-auto-scaling-group,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-auto-scaling-group
   {:arglists (quote
               [[credentials
                 {:keys [load-balancer-names
                         health-check-grace-period
                         placement-group
                         general-progress-listener
                         launch-configuration-name
                         termination-policies
                         vpczone-identifier
                         desired-capacity
                         availability-zones
                         min-size
                         instance-id
                         default-cooldown
                         max-size
                         health-check-type
                         auto-scaling-group-name
                         tags]}]]),
    :doc "Call createAutoScalingGroup"}
   [credentials3672 & args3673]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client3674
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3672)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3674
      createAutoScalingGroup
      (autoscaling/create-auto-scaling-group-request
       (clojure.core/nth args3673 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-auto-scaling-groups
   [m3675]
   (clojure.core/let
    [credentials3676 (:credentials m3675) args3677 (:args m3675)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client3678
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3676)]
     (clojure.core/case
      (clojure.core/count args3677)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3678
        describeAutoScalingGroups
        (autoscaling/describe-auto-scaling-groups-request
         (clojure.core/nth args3677 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3678
        describeAutoScalingGroups))))))
  (clojure.core/defn
   describe-auto-scaling-groups-map
   {:arglists (quote
               [[credentials
                 {:keys [next-token
                         max-records
                         general-progress-listener
                         auto-scaling-group-names]}]
                [credentials]]),
    :doc "Generate map for describeAutoScalingGroups, describeAutoScalingGroups"}
   ([credentials__1651__auto__]
    {:args [],
     :client :autoscaling,
     :fn :describe-auto-scaling-groups,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :describe-auto-scaling-groups,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-auto-scaling-groups
   {:arglists (quote
               [[credentials
                 {:keys [next-token
                         max-records
                         general-progress-listener
                         auto-scaling-group-names]}]
                [credentials]]),
    :doc "Call describeAutoScalingGroups, describeAutoScalingGroups"}
   [credentials3680 & args3681]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client3682
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3680)]
    (clojure.core/case
     (clojure.core/count args3681)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3682
       describeAutoScalingGroups
       (autoscaling/describe-auto-scaling-groups-request
        (clojure.core/nth args3681 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3682
       describeAutoScalingGroups))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :put-scaling-policy
   [m3683]
   (clojure.core/let
    [credentials3684 (:credentials m3683) args3685 (:args m3683)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client3686
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3684)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3686
       putScalingPolicy
       (autoscaling/put-scaling-policy-request
        (clojure.core/nth args3685 0)))))))
  (clojure.core/defn
   put-scaling-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         policy-name
                         min-adjustment-step
                         cooldown
                         auto-scaling-group-name
                         adjustment-type
                         scaling-adjustment]}]]),
    :doc "Generate map for putScalingPolicy"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :put-scaling-policy,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   put-scaling-policy
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         policy-name
                         min-adjustment-step
                         cooldown
                         auto-scaling-group-name
                         adjustment-type
                         scaling-adjustment]}]]),
    :doc "Call putScalingPolicy"}
   [credentials3688 & args3689]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client3690
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3688)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3690
      putScalingPolicy
      (autoscaling/put-scaling-policy-request
       (clojure.core/nth args3689 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :execute-policy
   [m3691]
   (clojure.core/let
    [credentials3692 (:credentials m3691) args3693 (:args m3691)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client3694
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3692)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3694
       executePolicy
       (autoscaling/execute-policy-request
        (clojure.core/nth args3693 0)))))))
  (clojure.core/defn
   execute-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [policy-name
                         honor-cooldown
                         general-progress-listener
                         auto-scaling-group-name]}]]),
    :doc "Generate map for executePolicy"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :execute-policy,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   execute-policy
   {:arglists (quote
               [[credentials
                 {:keys [policy-name
                         honor-cooldown
                         general-progress-listener
                         auto-scaling-group-name]}]]),
    :doc "Call executePolicy"}
   [credentials3696 & args3697]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client3698
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3696)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3698
      executePolicy
      (autoscaling/execute-policy-request
       (clojure.core/nth args3697 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :create-launch-configuration
   [m3699]
   (clojure.core/let
    [credentials3700 (:credentials m3699) args3701 (:args m3699)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client3702
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3700)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3702
       createLaunchConfiguration
       (autoscaling/create-launch-configuration-request
        (clojure.core/nth args3701 0)))))))
  (clojure.core/defn
   create-launch-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [placement-tenancy
                         instance-type
                         kernel-id
                         associate-public-ip-address
                         general-progress-listener
                         launch-configuration-name
                         ebs-optimized
                         block-device-mappings
                         spot-price
                         user-data
                         security-groups
                         ramdisk-id
                         instance-monitoring
                         iam-instance-profile
                         instance-id
                         key-name
                         image-id]}]]),
    :doc "Generate map for createLaunchConfiguration"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :create-launch-configuration,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-launch-configuration
   {:arglists (quote
               [[credentials
                 {:keys [placement-tenancy
                         instance-type
                         kernel-id
                         associate-public-ip-address
                         general-progress-listener
                         launch-configuration-name
                         ebs-optimized
                         block-device-mappings
                         spot-price
                         user-data
                         security-groups
                         ramdisk-id
                         instance-monitoring
                         iam-instance-profile
                         instance-id
                         key-name
                         image-id]}]]),
    :doc "Call createLaunchConfiguration"}
   [credentials3704 & args3705]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client3706
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3704)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3706
      createLaunchConfiguration
      (autoscaling/create-launch-configuration-request
       (clojure.core/nth args3705 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-termination-policy-types
   [m3707]
   (clojure.core/let
    [credentials3708 (:credentials m3707) args3709 (:args m3707)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client3710
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3708)]
     (clojure.core/case
      (clojure.core/count args3709)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3710
        describeTerminationPolicyTypes))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3710
        describeTerminationPolicyTypes
        (autoscaling/describe-termination-policy-types-request
         (clojure.core/nth args3709 0))))))))
  (clojure.core/defn
   describe-termination-policy-types-map
   {:arglists (quote
               [[credentials]
                [credentials {:keys [general-progress-listener]}]]),
    :doc "Generate map for describeTerminationPolicyTypes, describeTerminationPolicyTypes"}
   ([credentials__1651__auto__]
    {:args [],
     :client :autoscaling,
     :fn :describe-termination-policy-types,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :describe-termination-policy-types,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-termination-policy-types
   {:arglists (quote
               [[credentials]
                [credentials {:keys [general-progress-listener]}]]),
    :doc "Call describeTerminationPolicyTypes, describeTerminationPolicyTypes"}
   [credentials3712 & args3713]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client3714
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3712)]
    (clojure.core/case
     (clojure.core/count args3713)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3714
       describeTerminationPolicyTypes))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3714
       describeTerminationPolicyTypes
       (autoscaling/describe-termination-policy-types-request
        (clojure.core/nth args3713 0))))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-scaling-activities
   [m3715]
   (clojure.core/let
    [credentials3716 (:credentials m3715) args3717 (:args m3715)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client3718
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3716)]
     (clojure.core/case
      (clojure.core/count args3717)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3718
        describeScalingActivities
        (autoscaling/describe-scaling-activities-request
         (clojure.core/nth args3717 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3718
        describeScalingActivities))))))
  (clojure.core/defn
   describe-scaling-activities-map
   {:arglists (quote
               [[credentials
                 {:keys [next-token
                         max-records
                         general-progress-listener
                         auto-scaling-group-name
                         activity-ids]}]
                [credentials]]),
    :doc "Generate map for describeScalingActivities, describeScalingActivities"}
   ([credentials__1651__auto__]
    {:args [],
     :client :autoscaling,
     :fn :describe-scaling-activities,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :describe-scaling-activities,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-scaling-activities
   {:arglists (quote
               [[credentials
                 {:keys [next-token
                         max-records
                         general-progress-listener
                         auto-scaling-group-name
                         activity-ids]}]
                [credentials]]),
    :doc "Call describeScalingActivities, describeScalingActivities"}
   [credentials3720 & args3721]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client3722
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3720)]
    (clojure.core/case
     (clojure.core/count args3721)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3722
       describeScalingActivities
       (autoscaling/describe-scaling-activities-request
        (clojure.core/nth args3721 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3722
       describeScalingActivities))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-scheduled-actions
   [m3723]
   (clojure.core/let
    [credentials3724 (:credentials m3723) args3725 (:args m3723)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client3726
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3724)]
     (clojure.core/case
      (clojure.core/count args3725)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3726
        describeScheduledActions
        (autoscaling/describe-scheduled-actions-request
         (clojure.core/nth args3725 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3726
        describeScheduledActions))))))
  (clojure.core/defn
   describe-scheduled-actions-map
   {:arglists (quote
               [[credentials
                 {:keys [end-time
                         general-progress-listener
                         scheduled-action-names
                         max-records
                         start-time
                         next-token
                         auto-scaling-group-name]}]
                [credentials]]),
    :doc "Generate map for describeScheduledActions, describeScheduledActions"}
   ([credentials__1651__auto__]
    {:args [],
     :client :autoscaling,
     :fn :describe-scheduled-actions,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :describe-scheduled-actions,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-scheduled-actions
   {:arglists (quote
               [[credentials
                 {:keys [end-time
                         general-progress-listener
                         scheduled-action-names
                         max-records
                         start-time
                         next-token
                         auto-scaling-group-name]}]
                [credentials]]),
    :doc "Call describeScheduledActions, describeScheduledActions"}
   [credentials3728 & args3729]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client3730
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3728)]
    (clojure.core/case
     (clojure.core/count args3729)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3730
       describeScheduledActions
       (autoscaling/describe-scheduled-actions-request
        (clojure.core/nth args3729 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3730
       describeScheduledActions))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-adjustment-types
   [m3731]
   (clojure.core/let
    [credentials3732 (:credentials m3731) args3733 (:args m3731)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client3734
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3732)]
     (clojure.core/case
      (clojure.core/count args3733)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3734
        describeAdjustmentTypes))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3734
        describeAdjustmentTypes
        (autoscaling/describe-adjustment-types-request
         (clojure.core/nth args3733 0))))))))
  (clojure.core/defn
   describe-adjustment-types-map
   {:arglists (quote
               [[credentials]
                [credentials {:keys [general-progress-listener]}]]),
    :doc "Generate map for describeAdjustmentTypes, describeAdjustmentTypes"}
   ([credentials__1651__auto__]
    {:args [],
     :client :autoscaling,
     :fn :describe-adjustment-types,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :describe-adjustment-types,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-adjustment-types
   {:arglists (quote
               [[credentials]
                [credentials {:keys [general-progress-listener]}]]),
    :doc "Call describeAdjustmentTypes, describeAdjustmentTypes"}
   [credentials3736 & args3737]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client3738
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3736)]
    (clojure.core/case
     (clojure.core/count args3737)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3738
       describeAdjustmentTypes))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3738
       describeAdjustmentTypes
       (autoscaling/describe-adjustment-types-request
        (clojure.core/nth args3737 0))))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-tags
   [m3739]
   (clojure.core/let
    [credentials3740 (:credentials m3739) args3741 (:args m3739)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client3742
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3740)]
     (clojure.core/case
      (clojure.core/count args3741)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3742
        describeTags))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3742
        describeTags
        (autoscaling/describe-tags-request
         (clojure.core/nth args3741 0))))))))
  (clojure.core/defn
   describe-tags-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [next-token
                         max-records
                         general-progress-listener
                         filters]}]]),
    :doc "Generate map for describeTags, describeTags"}
   ([credentials__1651__auto__]
    {:args [],
     :client :autoscaling,
     :fn :describe-tags,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :describe-tags,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-tags
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [next-token
                         max-records
                         general-progress-listener
                         filters]}]]),
    :doc "Call describeTags, describeTags"}
   [credentials3744 & args3745]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client3746
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3744)]
    (clojure.core/case
     (clojure.core/count args3745)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3746
       describeTags))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3746
       describeTags
       (autoscaling/describe-tags-request
        (clojure.core/nth args3745 0))))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :resume-processes
   [m3747]
   (clojure.core/let
    [credentials3748 (:credentials m3747) args3749 (:args m3747)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client3750
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3748)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3750
       resumeProcesses
       (autoscaling/resume-processes-request
        (clojure.core/nth args3749 0)))))))
  (clojure.core/defn
   resume-processes-map
   {:arglists (quote
               [[credentials
                 {:keys [scaling-processes
                         general-progress-listener
                         auto-scaling-group-name]}]]),
    :doc "Generate map for resumeProcesses"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :resume-processes,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   resume-processes
   {:arglists (quote
               [[credentials
                 {:keys [scaling-processes
                         general-progress-listener
                         auto-scaling-group-name]}]]),
    :doc "Call resumeProcesses"}
   [credentials3752 & args3753]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client3754
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3752)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3754
      resumeProcesses
      (autoscaling/resume-processes-request
       (clojure.core/nth args3753 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :delete-launch-configuration
   [m3755]
   (clojure.core/let
    [credentials3756 (:credentials m3755) args3757 (:args m3755)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client3758
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3756)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3758
       deleteLaunchConfiguration
       (autoscaling/delete-launch-configuration-request
        (clojure.core/nth args3757 0)))))))
  (clojure.core/defn
   delete-launch-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [launch-configuration-name
                         general-progress-listener]}]]),
    :doc "Generate map for deleteLaunchConfiguration"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :delete-launch-configuration,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-launch-configuration
   {:arglists (quote
               [[credentials
                 {:keys [launch-configuration-name
                         general-progress-listener]}]]),
    :doc "Call deleteLaunchConfiguration"}
   [credentials3760 & args3761]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client3762
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3760)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3762
      deleteLaunchConfiguration
      (autoscaling/delete-launch-configuration-request
       (clojure.core/nth args3761 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :disable-metrics-collection
   [m3763]
   (clojure.core/let
    [credentials3764 (:credentials m3763) args3765 (:args m3763)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client3766
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3764)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3766
       disableMetricsCollection
       (autoscaling/disable-metrics-collection-request
        (clojure.core/nth args3765 0)))))))
  (clojure.core/defn
   disable-metrics-collection-map
   {:arglists (quote
               [[credentials
                 {:keys [metrics
                         general-progress-listener
                         auto-scaling-group-name]}]]),
    :doc "Generate map for disableMetricsCollection"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :disable-metrics-collection,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   disable-metrics-collection
   {:arglists (quote
               [[credentials
                 {:keys [metrics
                         general-progress-listener
                         auto-scaling-group-name]}]]),
    :doc "Call disableMetricsCollection"}
   [credentials3768 & args3769]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client3770
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3768)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3770
      disableMetricsCollection
      (autoscaling/disable-metrics-collection-request
       (clojure.core/nth args3769 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :put-scheduled-update-group-action
   [m3771]
   (clojure.core/let
    [credentials3772 (:credentials m3771) args3773 (:args m3771)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client3774
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3772)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3774
       putScheduledUpdateGroupAction
       (autoscaling/put-scheduled-update-group-action-request
        (clojure.core/nth args3773 0)))))))
  (clojure.core/defn
   put-scheduled-update-group-action-map
   {:arglists (quote
               [[credentials
                 {:keys [end-time
                         general-progress-listener
                         desired-capacity
                         recurrence
                         start-time
                         min-size
                         time
                         max-size
                         scheduled-action-name
                         auto-scaling-group-name]}]]),
    :doc "Generate map for putScheduledUpdateGroupAction"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :put-scheduled-update-group-action,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   put-scheduled-update-group-action
   {:arglists (quote
               [[credentials
                 {:keys [end-time
                         general-progress-listener
                         desired-capacity
                         recurrence
                         start-time
                         min-size
                         time
                         max-size
                         scheduled-action-name
                         auto-scaling-group-name]}]]),
    :doc "Call putScheduledUpdateGroupAction"}
   [credentials3776 & args3777]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client3778
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3776)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3778
      putScheduledUpdateGroupAction
      (autoscaling/put-scheduled-update-group-action-request
       (clojure.core/nth args3777 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-scaling-process-types
   [m3779]
   (clojure.core/let
    [credentials3780 (:credentials m3779) args3781 (:args m3779)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client3782
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3780)]
     (clojure.core/case
      (clojure.core/count args3781)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3782
        describeScalingProcessTypes))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3782
        describeScalingProcessTypes
        (autoscaling/describe-scaling-process-types-request
         (clojure.core/nth args3781 0))))))))
  (clojure.core/defn
   describe-scaling-process-types-map
   {:arglists (quote
               [[credentials]
                [credentials {:keys [general-progress-listener]}]]),
    :doc "Generate map for describeScalingProcessTypes, describeScalingProcessTypes"}
   ([credentials__1651__auto__]
    {:args [],
     :client :autoscaling,
     :fn :describe-scaling-process-types,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :describe-scaling-process-types,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-scaling-process-types
   {:arglists (quote
               [[credentials]
                [credentials {:keys [general-progress-listener]}]]),
    :doc "Call describeScalingProcessTypes, describeScalingProcessTypes"}
   [credentials3784 & args3785]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client3786
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3784)]
    (clojure.core/case
     (clojure.core/count args3785)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3786
       describeScalingProcessTypes))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3786
       describeScalingProcessTypes
       (autoscaling/describe-scaling-process-types-request
        (clojure.core/nth args3785 0))))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :describe-metric-collection-types
   [m3787]
   (clojure.core/let
    [credentials3788 (:credentials m3787) args3789 (:args m3787)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client3790
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3788)]
     (clojure.core/case
      (clojure.core/count args3789)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3790
        describeMetricCollectionTypes))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3790
        describeMetricCollectionTypes
        (autoscaling/describe-metric-collection-types-request
         (clojure.core/nth args3789 0))))))))
  (clojure.core/defn
   describe-metric-collection-types-map
   {:arglists (quote
               [[credentials]
                [credentials {:keys [general-progress-listener]}]]),
    :doc "Generate map for describeMetricCollectionTypes, describeMetricCollectionTypes"}
   ([credentials__1651__auto__]
    {:args [],
     :client :autoscaling,
     :fn :describe-metric-collection-types,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :describe-metric-collection-types,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-metric-collection-types
   {:arglists (quote
               [[credentials]
                [credentials {:keys [general-progress-listener]}]]),
    :doc "Call describeMetricCollectionTypes, describeMetricCollectionTypes"}
   [credentials3792 & args3793]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client3794
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3792)]
    (clojure.core/case
     (clojure.core/count args3793)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3794
       describeMetricCollectionTypes))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3794
       describeMetricCollectionTypes
       (autoscaling/describe-metric-collection-types-request
        (clojure.core/nth args3793 0))))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :delete-scheduled-action
   [m3795]
   (clojure.core/let
    [credentials3796 (:credentials m3795) args3797 (:args m3795)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client3798
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3796)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3798
       deleteScheduledAction
       (autoscaling/delete-scheduled-action-request
        (clojure.core/nth args3797 0)))))))
  (clojure.core/defn
   delete-scheduled-action-map
   {:arglists (quote
               [[credentials
                 {:keys [scheduled-action-name
                         general-progress-listener
                         auto-scaling-group-name]}]]),
    :doc "Generate map for deleteScheduledAction"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :delete-scheduled-action,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-scheduled-action
   {:arglists (quote
               [[credentials
                 {:keys [scheduled-action-name
                         general-progress-listener
                         auto-scaling-group-name]}]]),
    :doc "Call deleteScheduledAction"}
   [credentials3800 & args3801]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client3802
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3800)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3802
      deleteScheduledAction
      (autoscaling/delete-scheduled-action-request
       (clojure.core/nth args3801 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :update-auto-scaling-group
   [m3803]
   (clojure.core/let
    [credentials3804 (:credentials m3803) args3805 (:args m3803)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client3806
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3804)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3806
       updateAutoScalingGroup
       (autoscaling/update-auto-scaling-group-request
        (clojure.core/nth args3805 0)))))))
  (clojure.core/defn
   update-auto-scaling-group-map
   {:arglists (quote
               [[credentials
                 {:keys [health-check-grace-period
                         placement-group
                         general-progress-listener
                         launch-configuration-name
                         termination-policies
                         vpczone-identifier
                         desired-capacity
                         availability-zones
                         min-size
                         default-cooldown
                         max-size
                         health-check-type
                         auto-scaling-group-name]}]]),
    :doc "Generate map for updateAutoScalingGroup"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :update-auto-scaling-group,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   update-auto-scaling-group
   {:arglists (quote
               [[credentials
                 {:keys [health-check-grace-period
                         placement-group
                         general-progress-listener
                         launch-configuration-name
                         termination-policies
                         vpczone-identifier
                         desired-capacity
                         availability-zones
                         min-size
                         default-cooldown
                         max-size
                         health-check-type
                         auto-scaling-group-name]}]]),
    :doc "Call updateAutoScalingGroup"}
   [credentials3808 & args3809]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client3810
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3808)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3810
      updateAutoScalingGroup
      (autoscaling/update-auto-scaling-group-request
       (clojure.core/nth args3809 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :attach-instances
   [m3811]
   (clojure.core/let
    [credentials3812 (:credentials m3811) args3813 (:args m3811)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client3814
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3812)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3814
       attachInstances
       (autoscaling/attach-instances-request
        (clojure.core/nth args3813 0)))))))
  (clojure.core/defn
   attach-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [instance-ids
                         general-progress-listener
                         auto-scaling-group-name]}]]),
    :doc "Generate map for attachInstances"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :attach-instances,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   attach-instances
   {:arglists (quote
               [[credentials
                 {:keys [instance-ids
                         general-progress-listener
                         auto-scaling-group-name]}]]),
    :doc "Call attachInstances"}
   [credentials3816 & args3817]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client3818
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3816)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3818
      attachInstances
      (autoscaling/attach-instances-request
       (clojure.core/nth args3817 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :delete-notification-configuration
   [m3819]
   (clojure.core/let
    [credentials3820 (:credentials m3819) args3821 (:args m3819)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client3822
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3820)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3822
       deleteNotificationConfiguration
       (autoscaling/delete-notification-configuration-request
        (clojure.core/nth args3821 0)))))))
  (clojure.core/defn
   delete-notification-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [topic-arn
                         general-progress-listener
                         auto-scaling-group-name]}]]),
    :doc "Generate map for deleteNotificationConfiguration"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :delete-notification-configuration,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-notification-configuration
   {:arglists (quote
               [[credentials
                 {:keys [topic-arn
                         general-progress-listener
                         auto-scaling-group-name]}]]),
    :doc "Call deleteNotificationConfiguration"}
   [credentials3824 & args3825]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client3826
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3824)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3826
      deleteNotificationConfiguration
      (autoscaling/delete-notification-configuration-request
       (clojure.core/nth args3825 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :terminate-instance-in-auto-scaling-group
   [m3827]
   (clojure.core/let
    [credentials3828 (:credentials m3827) args3829 (:args m3827)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client3830
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3828)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3830
       terminateInstanceInAutoScalingGroup
       (autoscaling/terminate-instance-in-auto-scaling-group-request
        (clojure.core/nth args3829 0)))))))
  (clojure.core/defn
   terminate-instance-in-auto-scaling-group-map
   {:arglists (quote
               [[credentials
                 {:keys [should-decrement-desired-capacity
                         instance-id
                         general-progress-listener]}]]),
    :doc "Generate map for terminateInstanceInAutoScalingGroup"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :terminate-instance-in-auto-scaling-group,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   terminate-instance-in-auto-scaling-group
   {:arglists (quote
               [[credentials
                 {:keys [should-decrement-desired-capacity
                         instance-id
                         general-progress-listener]}]]),
    :doc "Call terminateInstanceInAutoScalingGroup"}
   [credentials3832 & args3833]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client3834
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3832)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3834
      terminateInstanceInAutoScalingGroup
      (autoscaling/terminate-instance-in-auto-scaling-group-request
       (clojure.core/nth args3833 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :delete-auto-scaling-group
   [m3835]
   (clojure.core/let
    [credentials3836 (:credentials m3835) args3837 (:args m3835)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client3838
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3836)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3838
       deleteAutoScalingGroup
       (autoscaling/delete-auto-scaling-group-request
        (clojure.core/nth args3837 0)))))))
  (clojure.core/defn
   delete-auto-scaling-group-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         force-delete
                         auto-scaling-group-name]}]]),
    :doc "Generate map for deleteAutoScalingGroup"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :delete-auto-scaling-group,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-auto-scaling-group
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         force-delete
                         auto-scaling-group-name]}]]),
    :doc "Call deleteAutoScalingGroup"}
   [credentials3840 & args3841]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client3842
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3840)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3842
      deleteAutoScalingGroup
      (autoscaling/delete-auto-scaling-group-request
       (clojure.core/nth args3841 0)))))))
 (do
  (clojure.core/defmethod
   autoscaling
   :create-or-update-tags
   [m3843]
   (clojure.core/let
    [credentials3844 (:credentials m3843) args3845 (:args m3843)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
      client3846
      (com.palletops.awaze.common/aws-client
       :autoscaling
       credentials3844)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3846
       createOrUpdateTags
       (autoscaling/create-or-update-tags-request
        (clojure.core/nth args3845 0)))))))
  (clojure.core/defn
   create-or-update-tags-map
   {:arglists (quote
               [[credentials {:keys [tags general-progress-listener]}]]),
    :doc "Generate map for createOrUpdateTags"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :autoscaling,
     :fn :create-or-update-tags,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-or-update-tags
   {:arglists (quote
               [[credentials {:keys [tags general-progress-listener]}]]),
    :doc "Call createOrUpdateTags"}
   [credentials3848 & args3849]
   (clojure.core/let
    [^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
     client3850
     (com.palletops.awaze.common/aws-client
      :autoscaling
      credentials3848)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.autoscaling.AmazonAutoScalingClient}
client3850
      createOrUpdateTags
      (autoscaling/create-or-update-tags-request
       (clojure.core/nth args3849 0))))))))
