(ns
 com.palletops.awaze.cloudformation
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.cloudformation :as cloudformation]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :cloudformation
  [___1600__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1601__auto__]
  (new
   com.amazonaws.services.cloudformation.AmazonCloudFormationClient
   credentials__1601__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.Parameter}
parameter
  [m8731]
  (clojure.core/let
   [bean8730
    (new com.amazonaws.services.cloudformation.model.Parameter)]
   (clojure.core/let
    [v8732
     (:parameter-value
      m8731
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8732 :com.palletops.awaze.client-builder/undef)
     (. bean8730 setParameterValue (clojure.core/str v8732))))
   (clojure.core/let
    [v8732
     (:parameter-key m8731 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8732 :com.palletops.awaze.client-builder/undef)
     (. bean8730 setParameterKey (clojure.core/str v8732))))
   (clojure.core/let
    [v8732
     (:use-previous-value
      m8731
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8732 :com.palletops.awaze.client-builder/undef)
     (. bean8730 setUsePreviousValue (clojure.core/boolean v8732))))
   bean8730))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.OnFailure}
on-failure
  [m8734]
  (.
   com.amazonaws.services.cloudformation.model.OnFailure
   fromValue
   (clojure.core/name m8734)))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.Tag}
tag
  [m8737]
  (clojure.core/let
   [bean8736 (new com.amazonaws.services.cloudformation.model.Tag)]
   (clojure.core/let
    [v8738 (:value m8737 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8738 :com.palletops.awaze.client-builder/undef)
     (. bean8736 setValue (clojure.core/str v8738))))
   (clojure.core/let
    [v8738 (:key m8737 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8738 :com.palletops.awaze.client-builder/undef)
     (. bean8736 setKey (clojure.core/str v8738))))
   bean8736))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.DescribeStackEventsRequest}
describe-stack-events-request
  [m8740]
  (clojure.core/let
   [bean8739
    (new
     com.amazonaws.services.cloudformation.model.DescribeStackEventsRequest)]
   (clojure.core/let
    [v8741
     (:next-token m8740 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8741 :com.palletops.awaze.client-builder/undef)
     (. bean8739 setNextToken (clojure.core/str v8741))))
   (clojure.core/let
    [v8741
     (:stack-name m8740 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8741 :com.palletops.awaze.client-builder/undef)
     (. bean8739 setStackName (clojure.core/str v8741))))
   bean8739))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.DescribeStacksRequest}
describe-stacks-request
  [m8743]
  (clojure.core/let
   [bean8742
    (new
     com.amazonaws.services.cloudformation.model.DescribeStacksRequest)]
   (clojure.core/let
    [v8744
     (:next-token m8743 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8744 :com.palletops.awaze.client-builder/undef)
     (. bean8742 setNextToken (clojure.core/str v8744))))
   (clojure.core/let
    [v8744
     (:stack-name m8743 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8744 :com.palletops.awaze.client-builder/undef)
     (. bean8742 setStackName (clojure.core/str v8744))))
   bean8742))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.GetStackPolicyRequest}
get-stack-policy-request
  [m8746]
  (clojure.core/let
   [bean8745
    (new
     com.amazonaws.services.cloudformation.model.GetStackPolicyRequest)]
   (clojure.core/let
    [v8747
     (:stack-name m8746 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8747 :com.palletops.awaze.client-builder/undef)
     (. bean8745 setStackName (clojure.core/str v8747))))
   bean8745))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.GetTemplateRequest}
get-template-request
  [m8749]
  (clojure.core/let
   [bean8748
    (new
     com.amazonaws.services.cloudformation.model.GetTemplateRequest)]
   (clojure.core/let
    [v8750
     (:stack-name m8749 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8750 :com.palletops.awaze.client-builder/undef)
     (. bean8748 setStackName (clojure.core/str v8750))))
   bean8748))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.ListStacksRequest}
list-stacks-request
  [m8752]
  (clojure.core/let
   [bean8751
    (new
     com.amazonaws.services.cloudformation.model.ListStacksRequest)]
   (clojure.core/let
    [v8753
     (:next-token m8752 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8753 :com.palletops.awaze.client-builder/undef)
     (. bean8751 setNextToken (clojure.core/str v8753))))
   (clojure.core/let
    [v8753
     (:stack-status-filters
      m8752
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8753 :com.palletops.awaze.client-builder/undef)
     (.
      bean8751
      setStackStatusFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8784] (clojure.core/str arg8784))
 v8753))))
   bean8751))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.DeleteStackRequest}
delete-stack-request
  [m8755]
  (clojure.core/let
   [bean8754
    (new
     com.amazonaws.services.cloudformation.model.DeleteStackRequest)]
   (clojure.core/let
    [v8756
     (:stack-name m8755 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8756 :com.palletops.awaze.client-builder/undef)
     (. bean8754 setStackName (clojure.core/str v8756))))
   bean8754))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.EstimateTemplateCostRequest}
estimate-template-cost-request
  [m8758]
  (clojure.core/let
   [bean8757
    (new
     com.amazonaws.services.cloudformation.model.EstimateTemplateCostRequest)]
   (clojure.core/let
    [v8759
     (:parameters m8758 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8759 :com.palletops.awaze.client-builder/undef)
     (.
      bean8757
      setParameters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8785] (cloudformation/parameter arg8785))
 v8759))))
   (clojure.core/let
    [v8759
     (:template-body m8758 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8759 :com.palletops.awaze.client-builder/undef)
     (. bean8757 setTemplateBody (clojure.core/str v8759))))
   (clojure.core/let
    [v8759
     (:template-url m8758 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8759 :com.palletops.awaze.client-builder/undef)
     (. bean8757 setTemplateURL (clojure.core/str v8759))))
   bean8757))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.ValidateTemplateRequest}
validate-template-request
  [m8761]
  (clojure.core/let
   [bean8760
    (new
     com.amazonaws.services.cloudformation.model.ValidateTemplateRequest)]
   (clojure.core/let
    [v8762
     (:template-body m8761 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8762 :com.palletops.awaze.client-builder/undef)
     (. bean8760 setTemplateBody (clojure.core/str v8762))))
   (clojure.core/let
    [v8762
     (:template-url m8761 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8762 :com.palletops.awaze.client-builder/undef)
     (. bean8760 setTemplateURL (clojure.core/str v8762))))
   bean8760))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.UpdateStackRequest}
update-stack-request
  [m8764]
  (clojure.core/let
   [bean8763
    (new
     com.amazonaws.services.cloudformation.model.UpdateStackRequest)]
   (clojure.core/let
    [v8765
     (:notification-arns
      m8764
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8765 :com.palletops.awaze.client-builder/undef)
     (.
      bean8763
      setNotificationARNs
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8786] (clojure.core/str arg8786))
 v8765))))
   (clojure.core/let
    [v8765
     (:stack-policy-during-update-body
      m8764
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8765 :com.palletops.awaze.client-builder/undef)
     (.
      bean8763
      setStackPolicyDuringUpdateBody
      (clojure.core/str v8765))))
   (clojure.core/let
    [v8765
     (:parameters m8764 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8765 :com.palletops.awaze.client-builder/undef)
     (.
      bean8763
      setParameters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8787] (cloudformation/parameter arg8787))
 v8765))))
   (clojure.core/let
    [v8765
     (:stack-policy-during-update-url
      m8764
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8765 :com.palletops.awaze.client-builder/undef)
     (.
      bean8763
      setStackPolicyDuringUpdateURL
      (clojure.core/str v8765))))
   (clojure.core/let
    [v8765
     (:stack-name m8764 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8765 :com.palletops.awaze.client-builder/undef)
     (. bean8763 setStackName (clojure.core/str v8765))))
   (clojure.core/let
    [v8765
     (:template-url m8764 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8765 :com.palletops.awaze.client-builder/undef)
     (. bean8763 setTemplateURL (clojure.core/str v8765))))
   (clojure.core/let
    [v8765
     (:use-previous-template
      m8764
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8765 :com.palletops.awaze.client-builder/undef)
     (. bean8763 setUsePreviousTemplate (clojure.core/boolean v8765))))
   (clojure.core/let
    [v8765
     (:stack-policy-url
      m8764
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8765 :com.palletops.awaze.client-builder/undef)
     (. bean8763 setStackPolicyURL (clojure.core/str v8765))))
   (clojure.core/let
    [v8765
     (:capabilities m8764 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8765 :com.palletops.awaze.client-builder/undef)
     (.
      bean8763
      setCapabilities
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8788] (clojure.core/str arg8788))
 v8765))))
   (clojure.core/let
    [v8765
     (:stack-policy-body
      m8764
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8765 :com.palletops.awaze.client-builder/undef)
     (. bean8763 setStackPolicyBody (clojure.core/str v8765))))
   (clojure.core/let
    [v8765
     (:template-body m8764 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8765 :com.palletops.awaze.client-builder/undef)
     (. bean8763 setTemplateBody (clojure.core/str v8765))))
   bean8763))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.DescribeStackResourcesRequest}
describe-stack-resources-request
  [m8767]
  (clojure.core/let
   [bean8766
    (new
     com.amazonaws.services.cloudformation.model.DescribeStackResourcesRequest)]
   (clojure.core/let
    [v8768
     (:stack-name m8767 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8768 :com.palletops.awaze.client-builder/undef)
     (. bean8766 setStackName (clojure.core/str v8768))))
   (clojure.core/let
    [v8768
     (:logical-resource-id
      m8767
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8768 :com.palletops.awaze.client-builder/undef)
     (. bean8766 setLogicalResourceId (clojure.core/str v8768))))
   (clojure.core/let
    [v8768
     (:physical-resource-id
      m8767
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8768 :com.palletops.awaze.client-builder/undef)
     (. bean8766 setPhysicalResourceId (clojure.core/str v8768))))
   bean8766))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.CancelUpdateStackRequest}
cancel-update-stack-request
  [m8770]
  (clojure.core/let
   [bean8769
    (new
     com.amazonaws.services.cloudformation.model.CancelUpdateStackRequest)]
   (clojure.core/let
    [v8771
     (:stack-name m8770 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8771 :com.palletops.awaze.client-builder/undef)
     (. bean8769 setStackName (clojure.core/str v8771))))
   bean8769))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.CreateStackRequest}
create-stack-request
  [m8773]
  (clojure.core/let
   [bean8772
    (new
     com.amazonaws.services.cloudformation.model.CreateStackRequest)]
   (clojure.core/let
    [v8774
     (:notification-arns
      m8773
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8774 :com.palletops.awaze.client-builder/undef)
     (.
      bean8772
      setNotificationARNs
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8789] (clojure.core/str arg8789))
 v8774))))
   (clojure.core/let
    [v8774
     (:on-failure m8773 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8774 :com.palletops.awaze.client-builder/undef)
     (. bean8772 setOnFailure (cloudformation/on-failure v8774))))
   (clojure.core/let
    [v8774
     (:disable-rollback
      m8773
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8774 :com.palletops.awaze.client-builder/undef)
     (. bean8772 setDisableRollback (clojure.core/boolean v8774))))
   (clojure.core/let
    [v8774
     (:parameters m8773 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8774 :com.palletops.awaze.client-builder/undef)
     (.
      bean8772
      setParameters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8790] (cloudformation/parameter arg8790))
 v8774))))
   (clojure.core/let
    [v8774
     (:stack-name m8773 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8774 :com.palletops.awaze.client-builder/undef)
     (. bean8772 setStackName (clojure.core/str v8774))))
   (clojure.core/let
    [v8774
     (:template-url m8773 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8774 :com.palletops.awaze.client-builder/undef)
     (. bean8772 setTemplateURL (clojure.core/str v8774))))
   (clojure.core/let
    [v8774
     (:stack-policy-url
      m8773
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8774 :com.palletops.awaze.client-builder/undef)
     (. bean8772 setStackPolicyURL (clojure.core/str v8774))))
   (clojure.core/let
    [v8774
     (:capabilities m8773 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8774 :com.palletops.awaze.client-builder/undef)
     (.
      bean8772
      setCapabilities
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8791] (clojure.core/str arg8791))
 v8774))))
   (clojure.core/let
    [v8774
     (:stack-policy-body
      m8773
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8774 :com.palletops.awaze.client-builder/undef)
     (. bean8772 setStackPolicyBody (clojure.core/str v8774))))
   (clojure.core/let
    [v8774
     (:timeout-in-minutes
      m8773
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8774 :com.palletops.awaze.client-builder/undef)
     (. bean8772 setTimeoutInMinutes (clojure.core/int v8774))))
   (clojure.core/let
    [v8774 (:tags m8773 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8774 :com.palletops.awaze.client-builder/undef)
     (.
      bean8772
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8792] (cloudformation/tag arg8792))
 v8774))))
   (clojure.core/let
    [v8774
     (:template-body m8773 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8774 :com.palletops.awaze.client-builder/undef)
     (. bean8772 setTemplateBody (clojure.core/str v8774))))
   bean8772))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.SetStackPolicyRequest}
set-stack-policy-request
  [m8776]
  (clojure.core/let
   [bean8775
    (new
     com.amazonaws.services.cloudformation.model.SetStackPolicyRequest)]
   (clojure.core/let
    [v8777
     (:stack-name m8776 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8777 :com.palletops.awaze.client-builder/undef)
     (. bean8775 setStackName (clojure.core/str v8777))))
   (clojure.core/let
    [v8777
     (:stack-policy-body
      m8776
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8777 :com.palletops.awaze.client-builder/undef)
     (. bean8775 setStackPolicyBody (clojure.core/str v8777))))
   (clojure.core/let
    [v8777
     (:stack-policy-url
      m8776
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8777 :com.palletops.awaze.client-builder/undef)
     (. bean8775 setStackPolicyURL (clojure.core/str v8777))))
   bean8775))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.DescribeStackResourceRequest}
describe-stack-resource-request
  [m8779]
  (clojure.core/let
   [bean8778
    (new
     com.amazonaws.services.cloudformation.model.DescribeStackResourceRequest)]
   (clojure.core/let
    [v8780
     (:stack-name m8779 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8780 :com.palletops.awaze.client-builder/undef)
     (. bean8778 setStackName (clojure.core/str v8780))))
   (clojure.core/let
    [v8780
     (:logical-resource-id
      m8779
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8780 :com.palletops.awaze.client-builder/undef)
     (. bean8778 setLogicalResourceId (clojure.core/str v8780))))
   bean8778))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.ListStackResourcesRequest}
list-stack-resources-request
  [m8782]
  (clojure.core/let
   [bean8781
    (new
     com.amazonaws.services.cloudformation.model.ListStackResourcesRequest)]
   (clojure.core/let
    [v8783
     (:next-token m8782 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8783 :com.palletops.awaze.client-builder/undef)
     (. bean8781 setNextToken (clojure.core/str v8783))))
   (clojure.core/let
    [v8783
     (:stack-name m8782 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8783 :com.palletops.awaze.client-builder/undef)
     (. bean8781 setStackName (clojure.core/str v8783))))
   bean8781))
 (clojure.core/defmulti
  cloudformation
  (clojure.core/fn
   cloudformation
   [m__1683__auto__]
   (:fn m__1683__auto__)))
 (do
  (clojure.core/defmethod
   cloudformation
   :describe-stack-events
   [m8793]
   (clojure.core/let
    [credentials8794 (:credentials m8793) args8795 (:args m8793)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client8796
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials8794)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client8796
       describeStackEvents
       (cloudformation/describe-stack-events-request
        (clojure.core/nth args8795 0)))))))
  (clojure.core/defn
   describe-stack-events-map
   {:arglists (quote
               [[credentials
                 {:keys [stack-name
                         next-token
                         general-progress-listener]}]]),
    :doc "Generate map for describeStackEvents"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :cloudformation,
     :fn :describe-stack-events,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-stack-events
   {:arglists (quote
               [[credentials
                 {:keys [stack-name
                         next-token
                         general-progress-listener]}]]),
    :doc "Call describeStackEvents"}
   [credentials8798 & args8799]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client8800
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials8798)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client8800
      describeStackEvents
      (cloudformation/describe-stack-events-request
       (clojure.core/nth args8799 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :describe-stacks
   [m8801]
   (clojure.core/let
    [credentials8802 (:credentials m8801) args8803 (:args m8801)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client8804
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials8802)]
     (clojure.core/case
      (clojure.core/count args8803)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client8804
        describeStacks
        (cloudformation/describe-stacks-request
         (clojure.core/nth args8803 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client8804
        describeStacks))))))
  (clojure.core/defn
   describe-stacks-map
   {:arglists (quote
               [[credentials
                 {:keys [stack-name
                         next-token
                         general-progress-listener]}]
                [credentials]]),
    :doc "Generate map for describeStacks, describeStacks"}
   ([credentials__1651__auto__]
    {:args [],
     :client :cloudformation,
     :fn :describe-stacks,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :cloudformation,
     :fn :describe-stacks,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-stacks
   {:arglists (quote
               [[credentials
                 {:keys [stack-name
                         next-token
                         general-progress-listener]}]
                [credentials]]),
    :doc "Call describeStacks, describeStacks"}
   [credentials8806 & args8807]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client8808
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials8806)]
    (clojure.core/case
     (clojure.core/count args8807)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client8808
       describeStacks
       (cloudformation/describe-stacks-request
        (clojure.core/nth args8807 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client8808
       describeStacks))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :get-stack-policy
   [m8809]
   (clojure.core/let
    [credentials8810 (:credentials m8809) args8811 (:args m8809)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client8812
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials8810)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client8812
       getStackPolicy
       (cloudformation/get-stack-policy-request
        (clojure.core/nth args8811 0)))))))
  (clojure.core/defn
   get-stack-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [stack-name general-progress-listener]}]]),
    :doc "Generate map for getStackPolicy"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :cloudformation,
     :fn :get-stack-policy,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   get-stack-policy
   {:arglists (quote
               [[credentials
                 {:keys [stack-name general-progress-listener]}]]),
    :doc "Call getStackPolicy"}
   [credentials8814 & args8815]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client8816
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials8814)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client8816
      getStackPolicy
      (cloudformation/get-stack-policy-request
       (clojure.core/nth args8815 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :get-template
   [m8817]
   (clojure.core/let
    [credentials8818 (:credentials m8817) args8819 (:args m8817)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client8820
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials8818)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client8820
       getTemplate
       (cloudformation/get-template-request
        (clojure.core/nth args8819 0)))))))
  (clojure.core/defn
   get-template-map
   {:arglists (quote
               [[credentials
                 {:keys [stack-name general-progress-listener]}]]),
    :doc "Generate map for getTemplate"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :cloudformation,
     :fn :get-template,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   get-template
   {:arglists (quote
               [[credentials
                 {:keys [stack-name general-progress-listener]}]]),
    :doc "Call getTemplate"}
   [credentials8822 & args8823]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client8824
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials8822)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client8824
      getTemplate
      (cloudformation/get-template-request
       (clojure.core/nth args8823 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :list-stacks
   [m8825]
   (clojure.core/let
    [credentials8826 (:credentials m8825) args8827 (:args m8825)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client8828
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials8826)]
     (clojure.core/case
      (clojure.core/count args8827)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client8828
        listStacks))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client8828
        listStacks
        (cloudformation/list-stacks-request
         (clojure.core/nth args8827 0))))))))
  (clojure.core/defn
   list-stacks-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [stack-status-filters
                         next-token
                         general-progress-listener]}]]),
    :doc "Generate map for listStacks, listStacks"}
   ([credentials__1651__auto__]
    {:args [],
     :client :cloudformation,
     :fn :list-stacks,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :cloudformation,
     :fn :list-stacks,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   list-stacks
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [stack-status-filters
                         next-token
                         general-progress-listener]}]]),
    :doc "Call listStacks, listStacks"}
   [credentials8830 & args8831]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client8832
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials8830)]
    (clojure.core/case
     (clojure.core/count args8831)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client8832
       listStacks))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client8832
       listStacks
       (cloudformation/list-stacks-request
        (clojure.core/nth args8831 0))))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :delete-stack
   [m8833]
   (clojure.core/let
    [credentials8834 (:credentials m8833) args8835 (:args m8833)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client8836
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials8834)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client8836
       deleteStack
       (cloudformation/delete-stack-request
        (clojure.core/nth args8835 0)))))))
  (clojure.core/defn
   delete-stack-map
   {:arglists (quote
               [[credentials
                 {:keys [stack-name general-progress-listener]}]]),
    :doc "Generate map for deleteStack"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :cloudformation,
     :fn :delete-stack,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-stack
   {:arglists (quote
               [[credentials
                 {:keys [stack-name general-progress-listener]}]]),
    :doc "Call deleteStack"}
   [credentials8838 & args8839]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client8840
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials8838)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client8840
      deleteStack
      (cloudformation/delete-stack-request
       (clojure.core/nth args8839 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :estimate-template-cost
   [m8841]
   (clojure.core/let
    [credentials8842 (:credentials m8841) args8843 (:args m8841)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client8844
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials8842)]
     (clojure.core/case
      (clojure.core/count args8843)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client8844
        estimateTemplateCost
        (cloudformation/estimate-template-cost-request
         (clojure.core/nth args8843 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client8844
        estimateTemplateCost))))))
  (clojure.core/defn
   estimate-template-cost-map
   {:arglists (quote
               [[credentials
                 {:keys [template-url
                         template-body
                         parameters
                         general-progress-listener]}]
                [credentials]]),
    :doc "Generate map for estimateTemplateCost, estimateTemplateCost"}
   ([credentials__1651__auto__]
    {:args [],
     :client :cloudformation,
     :fn :estimate-template-cost,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :cloudformation,
     :fn :estimate-template-cost,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   estimate-template-cost
   {:arglists (quote
               [[credentials
                 {:keys [template-url
                         template-body
                         parameters
                         general-progress-listener]}]
                [credentials]]),
    :doc "Call estimateTemplateCost, estimateTemplateCost"}
   [credentials8846 & args8847]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client8848
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials8846)]
    (clojure.core/case
     (clojure.core/count args8847)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client8848
       estimateTemplateCost
       (cloudformation/estimate-template-cost-request
        (clojure.core/nth args8847 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client8848
       estimateTemplateCost))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :validate-template
   [m8849]
   (clojure.core/let
    [credentials8850 (:credentials m8849) args8851 (:args m8849)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client8852
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials8850)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client8852
       validateTemplate
       (cloudformation/validate-template-request
        (clojure.core/nth args8851 0)))))))
  (clojure.core/defn
   validate-template-map
   {:arglists (quote
               [[credentials
                 {:keys [template-url
                         template-body
                         general-progress-listener]}]]),
    :doc "Generate map for validateTemplate"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :cloudformation,
     :fn :validate-template,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   validate-template
   {:arglists (quote
               [[credentials
                 {:keys [template-url
                         template-body
                         general-progress-listener]}]]),
    :doc "Call validateTemplate"}
   [credentials8854 & args8855]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client8856
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials8854)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client8856
      validateTemplate
      (cloudformation/validate-template-request
       (clojure.core/nth args8855 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :update-stack
   [m8857]
   (clojure.core/let
    [credentials8858 (:credentials m8857) args8859 (:args m8857)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client8860
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials8858)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client8860
       updateStack
       (cloudformation/update-stack-request
        (clojure.core/nth args8859 0)))))))
  (clojure.core/defn
   update-stack-map
   {:arglists (quote
               [[credentials
                 {:keys [stack-policy-body
                         stack-policy-during-update-url
                         template-body
                         general-progress-listener
                         stack-policy-during-update-body
                         capabilities
                         stack-name
                         notification-arns
                         parameters
                         template-url
                         stack-policy-url
                         use-previous-template]}]]),
    :doc "Generate map for updateStack"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :cloudformation,
     :fn :update-stack,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   update-stack
   {:arglists (quote
               [[credentials
                 {:keys [stack-policy-body
                         stack-policy-during-update-url
                         template-body
                         general-progress-listener
                         stack-policy-during-update-body
                         capabilities
                         stack-name
                         notification-arns
                         parameters
                         template-url
                         stack-policy-url
                         use-previous-template]}]]),
    :doc "Call updateStack"}
   [credentials8862 & args8863]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client8864
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials8862)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client8864
      updateStack
      (cloudformation/update-stack-request
       (clojure.core/nth args8863 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :describe-stack-resources
   [m8865]
   (clojure.core/let
    [credentials8866 (:credentials m8865) args8867 (:args m8865)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client8868
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials8866)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client8868
       describeStackResources
       (cloudformation/describe-stack-resources-request
        (clojure.core/nth args8867 0)))))))
  (clojure.core/defn
   describe-stack-resources-map
   {:arglists (quote
               [[credentials
                 {:keys [stack-name
                         physical-resource-id
                         logical-resource-id
                         general-progress-listener]}]]),
    :doc "Generate map for describeStackResources"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :cloudformation,
     :fn :describe-stack-resources,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-stack-resources
   {:arglists (quote
               [[credentials
                 {:keys [stack-name
                         physical-resource-id
                         logical-resource-id
                         general-progress-listener]}]]),
    :doc "Call describeStackResources"}
   [credentials8870 & args8871]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client8872
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials8870)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client8872
      describeStackResources
      (cloudformation/describe-stack-resources-request
       (clojure.core/nth args8871 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :cancel-update-stack
   [m8873]
   (clojure.core/let
    [credentials8874 (:credentials m8873) args8875 (:args m8873)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client8876
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials8874)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client8876
       cancelUpdateStack
       (cloudformation/cancel-update-stack-request
        (clojure.core/nth args8875 0)))))))
  (clojure.core/defn
   cancel-update-stack-map
   {:arglists (quote
               [[credentials
                 {:keys [stack-name general-progress-listener]}]]),
    :doc "Generate map for cancelUpdateStack"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :cloudformation,
     :fn :cancel-update-stack,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   cancel-update-stack
   {:arglists (quote
               [[credentials
                 {:keys [stack-name general-progress-listener]}]]),
    :doc "Call cancelUpdateStack"}
   [credentials8878 & args8879]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client8880
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials8878)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client8880
      cancelUpdateStack
      (cloudformation/cancel-update-stack-request
       (clojure.core/nth args8879 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :create-stack
   [m8881]
   (clojure.core/let
    [credentials8882 (:credentials m8881) args8883 (:args m8881)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client8884
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials8882)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client8884
       createStack
       (cloudformation/create-stack-request
        (clojure.core/nth args8883 0)))))))
  (clojure.core/defn
   create-stack-map
   {:arglists (quote
               [[credentials
                 {:keys [stack-policy-body
                         disable-rollback
                         template-body
                         general-progress-listener
                         capabilities
                         stack-name
                         notification-arns
                         parameters
                         template-url
                         on-failure
                         stack-policy-url
                         timeout-in-minutes
                         tags]}]]),
    :doc "Generate map for createStack"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :cloudformation,
     :fn :create-stack,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-stack
   {:arglists (quote
               [[credentials
                 {:keys [stack-policy-body
                         disable-rollback
                         template-body
                         general-progress-listener
                         capabilities
                         stack-name
                         notification-arns
                         parameters
                         template-url
                         on-failure
                         stack-policy-url
                         timeout-in-minutes
                         tags]}]]),
    :doc "Call createStack"}
   [credentials8886 & args8887]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client8888
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials8886)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client8888
      createStack
      (cloudformation/create-stack-request
       (clojure.core/nth args8887 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :set-stack-policy
   [m8889]
   (clojure.core/let
    [credentials8890 (:credentials m8889) args8891 (:args m8889)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client8892
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials8890)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client8892
       setStackPolicy
       (cloudformation/set-stack-policy-request
        (clojure.core/nth args8891 0)))))))
  (clojure.core/defn
   set-stack-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [stack-policy-url
                         stack-policy-body
                         stack-name
                         general-progress-listener]}]]),
    :doc "Generate map for setStackPolicy"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :cloudformation,
     :fn :set-stack-policy,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   set-stack-policy
   {:arglists (quote
               [[credentials
                 {:keys [stack-policy-url
                         stack-policy-body
                         stack-name
                         general-progress-listener]}]]),
    :doc "Call setStackPolicy"}
   [credentials8894 & args8895]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client8896
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials8894)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client8896
      setStackPolicy
      (cloudformation/set-stack-policy-request
       (clojure.core/nth args8895 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :describe-stack-resource
   [m8897]
   (clojure.core/let
    [credentials8898 (:credentials m8897) args8899 (:args m8897)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client8900
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials8898)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client8900
       describeStackResource
       (cloudformation/describe-stack-resource-request
        (clojure.core/nth args8899 0)))))))
  (clojure.core/defn
   describe-stack-resource-map
   {:arglists (quote
               [[credentials
                 {:keys [stack-name
                         logical-resource-id
                         general-progress-listener]}]]),
    :doc "Generate map for describeStackResource"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :cloudformation,
     :fn :describe-stack-resource,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-stack-resource
   {:arglists (quote
               [[credentials
                 {:keys [stack-name
                         logical-resource-id
                         general-progress-listener]}]]),
    :doc "Call describeStackResource"}
   [credentials8902 & args8903]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client8904
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials8902)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client8904
      describeStackResource
      (cloudformation/describe-stack-resource-request
       (clojure.core/nth args8903 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :list-stack-resources
   [m8905]
   (clojure.core/let
    [credentials8906 (:credentials m8905) args8907 (:args m8905)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client8908
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials8906)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client8908
       listStackResources
       (cloudformation/list-stack-resources-request
        (clojure.core/nth args8907 0)))))))
  (clojure.core/defn
   list-stack-resources-map
   {:arglists (quote
               [[credentials
                 {:keys [stack-name
                         next-token
                         general-progress-listener]}]]),
    :doc "Generate map for listStackResources"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :cloudformation,
     :fn :list-stack-resources,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   list-stack-resources
   {:arglists (quote
               [[credentials
                 {:keys [stack-name
                         next-token
                         general-progress-listener]}]]),
    :doc "Call listStackResources"}
   [credentials8910 & args8911]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client8912
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials8910)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client8912
      listStackResources
      (cloudformation/list-stack-resources-request
       (clojure.core/nth args8911 0))))))))
