(ns
 com.palletops.awaze.cloudfront
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.cloudfront :as cloudfront]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :cloudfront
  [___1600__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1601__auto__]
  (new
   com.amazonaws.services.cloudfront.AmazonCloudFrontClient
   credentials__1601__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.CookieNames}
cookie-names
  [m1980]
  (clojure.core/let
   [bean1979
    (new com.amazonaws.services.cloudfront.model.CookieNames)]
   (clojure.core/let
    [v1981 (:items m1980 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1981 :com.palletops.awaze.client-builder/undef)
     (.
      bean1979
      setItems
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2129] (clojure.core/str arg2129))
 v1981))))
   (clojure.core/let
    [v1981
     (:quantity m1980 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1981 :com.palletops.awaze.client-builder/undef)
     (. bean1979 setQuantity (clojure.core/int v1981))))
   bean1979))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.CookiePreference}
cookie-preference
  [m1983]
  (clojure.core/let
   [bean1982
    (new com.amazonaws.services.cloudfront.model.CookiePreference)]
   (clojure.core/let
    [v1984 (:forward m1983 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1984 :com.palletops.awaze.client-builder/undef)
     (. bean1982 setForward (clojure.core/str v1984))))
   (clojure.core/let
    [v1984
     (:whitelisted-names
      m1983
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1984 :com.palletops.awaze.client-builder/undef)
     (. bean1982 setWhitelistedNames (cloudfront/cookie-names v1984))))
   bean1982))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.Headers}
headers
  [m1986]
  (clojure.core/let
   [bean1985 (new com.amazonaws.services.cloudfront.model.Headers)]
   (clojure.core/let
    [v1987 (:items m1986 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1987 :com.palletops.awaze.client-builder/undef)
     (.
      bean1985
      setItems
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2130] (clojure.core/str arg2130))
 v1987))))
   (clojure.core/let
    [v1987
     (:quantity m1986 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1987 :com.palletops.awaze.client-builder/undef)
     (. bean1985 setQuantity (clojure.core/int v1987))))
   bean1985))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.TrustedSigners}
trusted-signers
  [m1989]
  (clojure.core/let
   [bean1988
    (new com.amazonaws.services.cloudfront.model.TrustedSigners)]
   (clojure.core/let
    [v1990 (:enabled m1989 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1990 :com.palletops.awaze.client-builder/undef)
     (. bean1988 setEnabled (clojure.core/boolean v1990))))
   (clojure.core/let
    [v1990 (:items m1989 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1990 :com.palletops.awaze.client-builder/undef)
     (.
      bean1988
      setItems
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2131] (clojure.core/str arg2131))
 v1990))))
   (clojure.core/let
    [v1990
     (:quantity m1989 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1990 :com.palletops.awaze.client-builder/undef)
     (. bean1988 setQuantity (clojure.core/int v1990))))
   bean1988))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.ForwardedValues}
forwarded-values
  [m1992]
  (clojure.core/let
   [bean1991
    (new com.amazonaws.services.cloudfront.model.ForwardedValues)]
   (clojure.core/let
    [v1993
     (:query-string m1992 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1993 :com.palletops.awaze.client-builder/undef)
     (. bean1991 setQueryString (clojure.core/boolean v1993))))
   (clojure.core/let
    [v1993 (:cookies m1992 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1993 :com.palletops.awaze.client-builder/undef)
     (. bean1991 setCookies (cloudfront/cookie-preference v1993))))
   (clojure.core/let
    [v1993 (:headers m1992 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1993 :com.palletops.awaze.client-builder/undef)
     (. bean1991 setHeaders (cloudfront/headers v1993))))
   bean1991))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.AllowedMethods}
allowed-methods
  [m1995]
  (clojure.core/let
   [bean1994
    (new com.amazonaws.services.cloudfront.model.AllowedMethods)]
   (clojure.core/let
    [v1996 (:items m1995 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1996 :com.palletops.awaze.client-builder/undef)
     (.
      bean1994
      setItems
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2132] (clojure.core/str arg2132))
 v1996))))
   (clojure.core/let
    [v1996
     (:quantity m1995 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1996 :com.palletops.awaze.client-builder/undef)
     (. bean1994 setQuantity (clojure.core/int v1996))))
   bean1994))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.S3OriginConfig}
s3origin-config
  [m1998]
  (clojure.core/let
   [bean1997
    (new com.amazonaws.services.cloudfront.model.S3OriginConfig)]
   (clojure.core/let
    [v1999
     (:origin-access-identity
      m1998
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v1999 :com.palletops.awaze.client-builder/undef)
     (. bean1997 setOriginAccessIdentity (clojure.core/str v1999))))
   bean1997))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.CustomOriginConfig}
custom-origin-config
  [m2001]
  (clojure.core/let
   [bean2000
    (new com.amazonaws.services.cloudfront.model.CustomOriginConfig)]
   (clojure.core/let
    [v2002
     (:httpport m2001 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2002 :com.palletops.awaze.client-builder/undef)
     (. bean2000 setHTTPPort (clojure.core/int v2002))))
   (clojure.core/let
    [v2002
     (:httpsport m2001 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2002 :com.palletops.awaze.client-builder/undef)
     (. bean2000 setHTTPSPort (clojure.core/int v2002))))
   (clojure.core/let
    [v2002
     (:origin-protocol-policy
      m2001
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2002 :com.palletops.awaze.client-builder/undef)
     (. bean2000 setOriginProtocolPolicy (clojure.core/str v2002))))
   bean2000))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.CacheBehavior}
cache-behavior
  [m2004]
  (clojure.core/let
   [bean2003
    (new com.amazonaws.services.cloudfront.model.CacheBehavior)]
   (clojure.core/let
    [v2005
     (:trusted-signers
      m2004
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2005 :com.palletops.awaze.client-builder/undef)
     (. bean2003 setTrustedSigners (cloudfront/trusted-signers v2005))))
   (clojure.core/let
    [v2005
     (:target-origin-id
      m2004
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2005 :com.palletops.awaze.client-builder/undef)
     (. bean2003 setTargetOriginId (clojure.core/str v2005))))
   (clojure.core/let
    [v2005
     (:forwarded-values
      m2004
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2005 :com.palletops.awaze.client-builder/undef)
     (.
      bean2003
      setForwardedValues
      (cloudfront/forwarded-values v2005))))
   (clojure.core/let
    [v2005
     (:viewer-protocol-policy
      m2004
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2005 :com.palletops.awaze.client-builder/undef)
     (. bean2003 setViewerProtocolPolicy (clojure.core/str v2005))))
   (clojure.core/let
    [v2005 (:min-ttl m2004 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2005 :com.palletops.awaze.client-builder/undef)
     (. bean2003 setMinTTL (clojure.core/long v2005))))
   (clojure.core/let
    [v2005
     (:allowed-methods
      m2004
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2005 :com.palletops.awaze.client-builder/undef)
     (. bean2003 setAllowedMethods (cloudfront/allowed-methods v2005))))
   (clojure.core/let
    [v2005
     (:smooth-streaming
      m2004
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2005 :com.palletops.awaze.client-builder/undef)
     (. bean2003 setSmoothStreaming (clojure.core/boolean v2005))))
   (clojure.core/let
    [v2005
     (:path-pattern m2004 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2005 :com.palletops.awaze.client-builder/undef)
     (. bean2003 setPathPattern (clojure.core/str v2005))))
   bean2003))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.GeoRestriction}
geo-restriction
  [m2007]
  (clojure.core/let
   [bean2006
    (new com.amazonaws.services.cloudfront.model.GeoRestriction)]
   (clojure.core/let
    [v2008
     (:restriction-type
      m2007
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2008 :com.palletops.awaze.client-builder/undef)
     (. bean2006 setRestrictionType (clojure.core/str v2008))))
   (clojure.core/let
    [v2008 (:items m2007 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2008 :com.palletops.awaze.client-builder/undef)
     (.
      bean2006
      setItems
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2133] (clojure.core/str arg2133))
 v2008))))
   (clojure.core/let
    [v2008
     (:quantity m2007 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2008 :com.palletops.awaze.client-builder/undef)
     (. bean2006 setQuantity (clojure.core/int v2008))))
   bean2006))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.Origin}
origin
  [m2010]
  (clojure.core/let
   [bean2009 (new com.amazonaws.services.cloudfront.model.Origin)]
   (clojure.core/let
    [v2011 (:id m2010 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2011 :com.palletops.awaze.client-builder/undef)
     (. bean2009 setId (clojure.core/str v2011))))
   (clojure.core/let
    [v2011
     (:domain-name m2010 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2011 :com.palletops.awaze.client-builder/undef)
     (. bean2009 setDomainName (clojure.core/str v2011))))
   (clojure.core/let
    [v2011
     (:s3origin-config
      m2010
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2011 :com.palletops.awaze.client-builder/undef)
     (. bean2009 setS3OriginConfig (cloudfront/s3origin-config v2011))))
   (clojure.core/let
    [v2011
     (:custom-origin-config
      m2010
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2011 :com.palletops.awaze.client-builder/undef)
     (.
      bean2009
      setCustomOriginConfig
      (cloudfront/custom-origin-config v2011))))
   bean2009))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.ViewerProtocolPolicy}
viewer-protocol-policy
  [m2013]
  (.
   com.amazonaws.services.cloudfront.model.ViewerProtocolPolicy
   fromValue
   (clojure.core/name m2013)))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.CustomErrorResponse}
custom-error-response
  [m2016]
  (clojure.core/let
   [bean2015
    (new com.amazonaws.services.cloudfront.model.CustomErrorResponse)]
   (clojure.core/let
    [v2017
     (:response-page-path
      m2016
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2017 :com.palletops.awaze.client-builder/undef)
     (. bean2015 setResponsePagePath (clojure.core/str v2017))))
   (clojure.core/let
    [v2017
     (:response-code m2016 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2017 :com.palletops.awaze.client-builder/undef)
     (. bean2015 setResponseCode (clojure.core/str v2017))))
   (clojure.core/let
    [v2017
     (:error-caching-min-ttl
      m2016
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2017 :com.palletops.awaze.client-builder/undef)
     (. bean2015 setErrorCachingMinTTL (clojure.core/long v2017))))
   (clojure.core/let
    [v2017
     (:error-code m2016 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2017 :com.palletops.awaze.client-builder/undef)
     (. bean2015 setErrorCode (clojure.core/int v2017))))
   bean2015))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.S3Origin}
s3origin
  [m2019]
  (clojure.core/let
   [bean2018 (new com.amazonaws.services.cloudfront.model.S3Origin)]
   (clojure.core/let
    [v2020
     (:domain-name m2019 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2020 :com.palletops.awaze.client-builder/undef)
     (. bean2018 setDomainName (clojure.core/str v2020))))
   (clojure.core/let
    [v2020
     (:origin-access-identity
      m2019
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2020 :com.palletops.awaze.client-builder/undef)
     (. bean2018 setOriginAccessIdentity (clojure.core/str v2020))))
   bean2018))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.Aliases}
aliases
  [m2022]
  (clojure.core/let
   [bean2021 (new com.amazonaws.services.cloudfront.model.Aliases)]
   (clojure.core/let
    [v2023 (:items m2022 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2023 :com.palletops.awaze.client-builder/undef)
     (.
      bean2021
      setItems
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2134] (clojure.core/str arg2134))
 v2023))))
   (clojure.core/let
    [v2023
     (:quantity m2022 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2023 :com.palletops.awaze.client-builder/undef)
     (. bean2021 setQuantity (clojure.core/int v2023))))
   bean2021))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.StreamingLoggingConfig}
streaming-logging-config
  [m2025]
  (clojure.core/let
   [bean2024
    (new
     com.amazonaws.services.cloudfront.model.StreamingLoggingConfig)]
   (clojure.core/let
    [v2026 (:enabled m2025 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2026 :com.palletops.awaze.client-builder/undef)
     (. bean2024 setEnabled (clojure.core/boolean v2026))))
   (clojure.core/let
    [v2026 (:bucket m2025 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2026 :com.palletops.awaze.client-builder/undef)
     (. bean2024 setBucket (clojure.core/str v2026))))
   (clojure.core/let
    [v2026 (:prefix m2025 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2026 :com.palletops.awaze.client-builder/undef)
     (. bean2024 setPrefix (clojure.core/str v2026))))
   bean2024))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.PriceClass}
price-class
  [m2028]
  (.
   com.amazonaws.services.cloudfront.model.PriceClass
   fromValue
   (clojure.core/name m2028)))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.CacheBehaviors}
cache-behaviors
  [m2031]
  (clojure.core/let
   [bean2030
    (new com.amazonaws.services.cloudfront.model.CacheBehaviors)]
   (clojure.core/let
    [v2032 (:items m2031 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2032 :com.palletops.awaze.client-builder/undef)
     (.
      bean2030
      setItems
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2135] (cloudfront/cache-behavior arg2135))
 v2032))))
   (clojure.core/let
    [v2032
     (:quantity m2031 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2032 :com.palletops.awaze.client-builder/undef)
     (. bean2030 setQuantity (clojure.core/int v2032))))
   bean2030))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.ViewerCertificate}
viewer-certificate
  [m2034]
  (clojure.core/let
   [bean2033
    (new com.amazonaws.services.cloudfront.model.ViewerCertificate)]
   (clojure.core/let
    [v2035
     (:iamcertificate-id
      m2034
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2035 :com.palletops.awaze.client-builder/undef)
     (. bean2033 setIAMCertificateId (clojure.core/str v2035))))
   (clojure.core/let
    [v2035
     (:cloud-front-default-certificate
      m2034
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2035 :com.palletops.awaze.client-builder/undef)
     (.
      bean2033
      setCloudFrontDefaultCertificate
      (clojure.core/boolean v2035))))
   (clojure.core/let
    [v2035
     (:sslsupport-method
      m2034
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2035 :com.palletops.awaze.client-builder/undef)
     (. bean2033 setSSLSupportMethod (clojure.core/str v2035))))
   bean2033))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.Restrictions}
restrictions
  [m2037]
  (clojure.core/let
   [bean2036
    (new com.amazonaws.services.cloudfront.model.Restrictions)]
   (clojure.core/let
    [v2038
     (:geo-restriction
      m2037
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2038 :com.palletops.awaze.client-builder/undef)
     (. bean2036 setGeoRestriction (cloudfront/geo-restriction v2038))))
   bean2036))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.Origins}
origins
  [m2040]
  (clojure.core/let
   [bean2039 (new com.amazonaws.services.cloudfront.model.Origins)]
   (clojure.core/let
    [v2041 (:items m2040 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2041 :com.palletops.awaze.client-builder/undef)
     (.
      bean2039
      setItems
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2136] (cloudfront/origin arg2136))
 v2041))))
   (clojure.core/let
    [v2041
     (:quantity m2040 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2041 :com.palletops.awaze.client-builder/undef)
     (. bean2039 setQuantity (clojure.core/int v2041))))
   bean2039))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.DefaultCacheBehavior}
default-cache-behavior
  [m2043]
  (clojure.core/let
   [bean2042
    (new com.amazonaws.services.cloudfront.model.DefaultCacheBehavior)]
   (clojure.core/let
    [v2044
     (:trusted-signers
      m2043
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2044 :com.palletops.awaze.client-builder/undef)
     (. bean2042 setTrustedSigners (cloudfront/trusted-signers v2044))))
   (clojure.core/let
    [v2044
     (:target-origin-id
      m2043
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2044 :com.palletops.awaze.client-builder/undef)
     (. bean2042 setTargetOriginId (clojure.core/str v2044))))
   (clojure.core/let
    [v2044
     (:forwarded-values
      m2043
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2044 :com.palletops.awaze.client-builder/undef)
     (.
      bean2042
      setForwardedValues
      (cloudfront/forwarded-values v2044))))
   (clojure.core/let
    [v2044
     (:viewer-protocol-policy
      m2043
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2044 :com.palletops.awaze.client-builder/undef)
     (.
      bean2042
      setViewerProtocolPolicy
      (cloudfront/viewer-protocol-policy v2044))))
   (clojure.core/let
    [v2044 (:min-ttl m2043 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2044 :com.palletops.awaze.client-builder/undef)
     (. bean2042 setMinTTL (clojure.core/long v2044))))
   (clojure.core/let
    [v2044
     (:allowed-methods
      m2043
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2044 :com.palletops.awaze.client-builder/undef)
     (. bean2042 setAllowedMethods (cloudfront/allowed-methods v2044))))
   (clojure.core/let
    [v2044
     (:smooth-streaming
      m2043
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2044 :com.palletops.awaze.client-builder/undef)
     (. bean2042 setSmoothStreaming (clojure.core/boolean v2044))))
   bean2042))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.CustomErrorResponses}
custom-error-responses
  [m2046]
  (clojure.core/let
   [bean2045
    (new com.amazonaws.services.cloudfront.model.CustomErrorResponses)]
   (clojure.core/let
    [v2047 (:items m2046 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2047 :com.palletops.awaze.client-builder/undef)
     (.
      bean2045
      setItems
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg2137]
  (cloudfront/custom-error-response arg2137))
 v2047))))
   (clojure.core/let
    [v2047
     (:quantity m2046 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2047 :com.palletops.awaze.client-builder/undef)
     (. bean2045 setQuantity (clojure.core/int v2047))))
   bean2045))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.LoggingConfig}
logging-config
  [m2049]
  (clojure.core/let
   [bean2048
    (new com.amazonaws.services.cloudfront.model.LoggingConfig)]
   (clojure.core/let
    [v2050 (:enabled m2049 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2050 :com.palletops.awaze.client-builder/undef)
     (. bean2048 setEnabled (clojure.core/boolean v2050))))
   (clojure.core/let
    [v2050 (:bucket m2049 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2050 :com.palletops.awaze.client-builder/undef)
     (. bean2048 setBucket (clojure.core/str v2050))))
   (clojure.core/let
    [v2050
     (:include-cookies
      m2049
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2050 :com.palletops.awaze.client-builder/undef)
     (. bean2048 setIncludeCookies (clojure.core/boolean v2050))))
   (clojure.core/let
    [v2050 (:prefix m2049 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2050 :com.palletops.awaze.client-builder/undef)
     (. bean2048 setPrefix (clojure.core/str v2050))))
   bean2048))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.Paths}
paths
  [m2052]
  (clojure.core/let
   [bean2051 (new com.amazonaws.services.cloudfront.model.Paths)]
   (clojure.core/let
    [v2053 (:items m2052 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2053 :com.palletops.awaze.client-builder/undef)
     (.
      bean2051
      setItems
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg2138] (clojure.core/str arg2138))
 v2053))))
   (clojure.core/let
    [v2053
     (:quantity m2052 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2053 :com.palletops.awaze.client-builder/undef)
     (. bean2051 setQuantity (clojure.core/int v2053))))
   bean2051))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.StreamingDistributionConfig}
streaming-distribution-config
  [m2055]
  (clojure.core/let
   [bean2054
    (new
     com.amazonaws.services.cloudfront.model.StreamingDistributionConfig)]
   (clojure.core/let
    [v2056
     (:caller-reference
      m2055
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2056 :com.palletops.awaze.client-builder/undef)
     (. bean2054 setCallerReference (clojure.core/str v2056))))
   (clojure.core/let
    [v2056
     (:s3origin m2055 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2056 :com.palletops.awaze.client-builder/undef)
     (. bean2054 setS3Origin (cloudfront/s3origin v2056))))
   (clojure.core/let
    [v2056 (:aliases m2055 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2056 :com.palletops.awaze.client-builder/undef)
     (. bean2054 setAliases (cloudfront/aliases v2056))))
   (clojure.core/let
    [v2056 (:logging m2055 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2056 :com.palletops.awaze.client-builder/undef)
     (.
      bean2054
      setLogging
      (cloudfront/streaming-logging-config v2056))))
   (clojure.core/let
    [v2056
     (:trusted-signers
      m2055
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2056 :com.palletops.awaze.client-builder/undef)
     (. bean2054 setTrustedSigners (cloudfront/trusted-signers v2056))))
   (clojure.core/let
    [v2056
     (:price-class m2055 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2056 :com.palletops.awaze.client-builder/undef)
     (. bean2054 setPriceClass (cloudfront/price-class v2056))))
   (clojure.core/let
    [v2056 (:enabled m2055 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2056 :com.palletops.awaze.client-builder/undef)
     (. bean2054 setEnabled (clojure.core/boolean v2056))))
   (clojure.core/let
    [v2056 (:comment m2055 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2056 :com.palletops.awaze.client-builder/undef)
     (. bean2054 setComment (clojure.core/str v2056))))
   bean2054))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.CloudFrontOriginAccessIdentityConfig}
cloud-front-origin-access-identity-config
  [m2058]
  (clojure.core/let
   [bean2057
    (new
     com.amazonaws.services.cloudfront.model.CloudFrontOriginAccessIdentityConfig)]
   (clojure.core/let
    [v2059
     (:caller-reference
      m2058
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2059 :com.palletops.awaze.client-builder/undef)
     (. bean2057 setCallerReference (clojure.core/str v2059))))
   (clojure.core/let
    [v2059 (:comment m2058 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2059 :com.palletops.awaze.client-builder/undef)
     (. bean2057 setComment (clojure.core/str v2059))))
   bean2057))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.DistributionConfig}
distribution-config
  [m2061]
  (clojure.core/let
   [bean2060
    (new com.amazonaws.services.cloudfront.model.DistributionConfig)]
   (clojure.core/let
    [v2062
     (:default-root-object
      m2061
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2062 :com.palletops.awaze.client-builder/undef)
     (. bean2060 setDefaultRootObject (clojure.core/str v2062))))
   (clojure.core/let
    [v2062
     (:cache-behaviors
      m2061
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2062 :com.palletops.awaze.client-builder/undef)
     (. bean2060 setCacheBehaviors (cloudfront/cache-behaviors v2062))))
   (clojure.core/let
    [v2062
     (:viewer-certificate
      m2061
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2062 :com.palletops.awaze.client-builder/undef)
     (.
      bean2060
      setViewerCertificate
      (cloudfront/viewer-certificate v2062))))
   (clojure.core/let
    [v2062
     (:restrictions m2061 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2062 :com.palletops.awaze.client-builder/undef)
     (. bean2060 setRestrictions (cloudfront/restrictions v2062))))
   (clojure.core/let
    [v2062 (:origins m2061 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2062 :com.palletops.awaze.client-builder/undef)
     (. bean2060 setOrigins (cloudfront/origins v2062))))
   (clojure.core/let
    [v2062
     (:price-class m2061 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2062 :com.palletops.awaze.client-builder/undef)
     (. bean2060 setPriceClass (cloudfront/price-class v2062))))
   (clojure.core/let
    [v2062
     (:default-cache-behavior
      m2061
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2062 :com.palletops.awaze.client-builder/undef)
     (.
      bean2060
      setDefaultCacheBehavior
      (cloudfront/default-cache-behavior v2062))))
   (clojure.core/let
    [v2062 (:aliases m2061 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2062 :com.palletops.awaze.client-builder/undef)
     (. bean2060 setAliases (cloudfront/aliases v2062))))
   (clojure.core/let
    [v2062
     (:custom-error-responses
      m2061
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2062 :com.palletops.awaze.client-builder/undef)
     (.
      bean2060
      setCustomErrorResponses
      (cloudfront/custom-error-responses v2062))))
   (clojure.core/let
    [v2062 (:logging m2061 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2062 :com.palletops.awaze.client-builder/undef)
     (. bean2060 setLogging (cloudfront/logging-config v2062))))
   (clojure.core/let
    [v2062 (:comment m2061 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2062 :com.palletops.awaze.client-builder/undef)
     (. bean2060 setComment (clojure.core/str v2062))))
   (clojure.core/let
    [v2062
     (:caller-reference
      m2061
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2062 :com.palletops.awaze.client-builder/undef)
     (. bean2060 setCallerReference (clojure.core/str v2062))))
   (clojure.core/let
    [v2062 (:enabled m2061 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2062 :com.palletops.awaze.client-builder/undef)
     (. bean2060 setEnabled (clojure.core/boolean v2062))))
   bean2060))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.InvalidationBatch}
invalidation-batch
  [m2064]
  (clojure.core/let
   [bean2063
    (new com.amazonaws.services.cloudfront.model.InvalidationBatch)]
   (clojure.core/let
    [v2065
     (:caller-reference
      m2064
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2065 :com.palletops.awaze.client-builder/undef)
     (. bean2063 setCallerReference (clojure.core/str v2065))))
   (clojure.core/let
    [v2065 (:paths m2064 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2065 :com.palletops.awaze.client-builder/undef)
     (. bean2063 setPaths (cloudfront/paths v2065))))
   bean2063))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.ListStreamingDistributionsRequest}
list-streaming-distributions-request
  [m2067]
  (clojure.core/let
   [bean2066
    (new
     com.amazonaws.services.cloudfront.model.ListStreamingDistributionsRequest)]
   (clojure.core/let
    [v2068
     (:max-items m2067 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2068 :com.palletops.awaze.client-builder/undef)
     (. bean2066 setMaxItems (clojure.core/str v2068))))
   (clojure.core/let
    [v2068 (:marker m2067 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2068 :com.palletops.awaze.client-builder/undef)
     (. bean2066 setMarker (clojure.core/str v2068))))
   bean2066))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.GetCloudFrontOriginAccessIdentityConfigRequest}
get-cloud-front-origin-access-identity-config-request
  [m2070]
  (clojure.core/let
   [bean2069
    (new
     com.amazonaws.services.cloudfront.model.GetCloudFrontOriginAccessIdentityConfigRequest)]
   (clojure.core/let
    [v2071 (:id m2070 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2071 :com.palletops.awaze.client-builder/undef)
     (. bean2069 setId (clojure.core/str v2071))))
   bean2069))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.UpdateStreamingDistributionRequest}
update-streaming-distribution-request
  [m2073]
  (clojure.core/let
   [bean2072
    (new
     com.amazonaws.services.cloudfront.model.UpdateStreamingDistributionRequest)]
   (clojure.core/let
    [v2074 (:id m2073 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2074 :com.palletops.awaze.client-builder/undef)
     (. bean2072 setId (clojure.core/str v2074))))
   (clojure.core/let
    [v2074
     (:if-match m2073 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2074 :com.palletops.awaze.client-builder/undef)
     (. bean2072 setIfMatch (clojure.core/str v2074))))
   (clojure.core/let
    [v2074
     (:streaming-distribution-config
      m2073
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2074 :com.palletops.awaze.client-builder/undef)
     (.
      bean2072
      setStreamingDistributionConfig
      (cloudfront/streaming-distribution-config v2074))))
   bean2072))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.CreateCloudFrontOriginAccessIdentityRequest}
create-cloud-front-origin-access-identity-request
  [m2076]
  (clojure.core/let
   [bean2075
    (new
     com.amazonaws.services.cloudfront.model.CreateCloudFrontOriginAccessIdentityRequest)]
   (clojure.core/let
    [v2077
     (:cloud-front-origin-access-identity-config
      m2076
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2077 :com.palletops.awaze.client-builder/undef)
     (.
      bean2075
      setCloudFrontOriginAccessIdentityConfig
      (cloudfront/cloud-front-origin-access-identity-config v2077))))
   bean2075))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.ListCloudFrontOriginAccessIdentitiesRequest}
list-cloud-front-origin-access-identities-request
  [m2079]
  (clojure.core/let
   [bean2078
    (new
     com.amazonaws.services.cloudfront.model.ListCloudFrontOriginAccessIdentitiesRequest)]
   (clojure.core/let
    [v2080
     (:max-items m2079 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2080 :com.palletops.awaze.client-builder/undef)
     (. bean2078 setMaxItems (clojure.core/str v2080))))
   (clojure.core/let
    [v2080 (:marker m2079 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2080 :com.palletops.awaze.client-builder/undef)
     (. bean2078 setMarker (clojure.core/str v2080))))
   bean2078))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.GetDistributionConfigRequest}
get-distribution-config-request
  [m2082]
  (clojure.core/let
   [bean2081
    (new
     com.amazonaws.services.cloudfront.model.GetDistributionConfigRequest)]
   (clojure.core/let
    [v2083 (:id m2082 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2083 :com.palletops.awaze.client-builder/undef)
     (. bean2081 setId (clojure.core/str v2083))))
   bean2081))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.GetStreamingDistributionConfigRequest}
get-streaming-distribution-config-request
  [m2085]
  (clojure.core/let
   [bean2084
    (new
     com.amazonaws.services.cloudfront.model.GetStreamingDistributionConfigRequest)]
   (clojure.core/let
    [v2086 (:id m2085 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2086 :com.palletops.awaze.client-builder/undef)
     (. bean2084 setId (clojure.core/str v2086))))
   bean2084))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.CreateDistributionRequest}
create-distribution-request
  [m2088]
  (clojure.core/let
   [bean2087
    (new
     com.amazonaws.services.cloudfront.model.CreateDistributionRequest)]
   (clojure.core/let
    [v2089
     (:distribution-config
      m2088
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2089 :com.palletops.awaze.client-builder/undef)
     (.
      bean2087
      setDistributionConfig
      (cloudfront/distribution-config v2089))))
   bean2087))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.CreateInvalidationRequest}
create-invalidation-request
  [m2091]
  (clojure.core/let
   [bean2090
    (new
     com.amazonaws.services.cloudfront.model.CreateInvalidationRequest)]
   (clojure.core/let
    [v2092
     (:distribution-id
      m2091
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2092 :com.palletops.awaze.client-builder/undef)
     (. bean2090 setDistributionId (clojure.core/str v2092))))
   (clojure.core/let
    [v2092
     (:invalidation-batch
      m2091
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2092 :com.palletops.awaze.client-builder/undef)
     (.
      bean2090
      setInvalidationBatch
      (cloudfront/invalidation-batch v2092))))
   bean2090))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.UpdateDistributionRequest}
update-distribution-request
  [m2094]
  (clojure.core/let
   [bean2093
    (new
     com.amazonaws.services.cloudfront.model.UpdateDistributionRequest)]
   (clojure.core/let
    [v2095 (:id m2094 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2095 :com.palletops.awaze.client-builder/undef)
     (. bean2093 setId (clojure.core/str v2095))))
   (clojure.core/let
    [v2095
     (:if-match m2094 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2095 :com.palletops.awaze.client-builder/undef)
     (. bean2093 setIfMatch (clojure.core/str v2095))))
   (clojure.core/let
    [v2095
     (:distribution-config
      m2094
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2095 :com.palletops.awaze.client-builder/undef)
     (.
      bean2093
      setDistributionConfig
      (cloudfront/distribution-config v2095))))
   bean2093))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.GetStreamingDistributionRequest}
get-streaming-distribution-request
  [m2097]
  (clojure.core/let
   [bean2096
    (new
     com.amazonaws.services.cloudfront.model.GetStreamingDistributionRequest)]
   (clojure.core/let
    [v2098 (:id m2097 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2098 :com.palletops.awaze.client-builder/undef)
     (. bean2096 setId (clojure.core/str v2098))))
   bean2096))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.ListInvalidationsRequest}
list-invalidations-request
  [m2100]
  (clojure.core/let
   [bean2099
    (new
     com.amazonaws.services.cloudfront.model.ListInvalidationsRequest)]
   (clojure.core/let
    [v2101
     (:distribution-id
      m2100
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2101 :com.palletops.awaze.client-builder/undef)
     (. bean2099 setDistributionId (clojure.core/str v2101))))
   (clojure.core/let
    [v2101
     (:max-items m2100 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2101 :com.palletops.awaze.client-builder/undef)
     (. bean2099 setMaxItems (clojure.core/str v2101))))
   (clojure.core/let
    [v2101 (:marker m2100 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2101 :com.palletops.awaze.client-builder/undef)
     (. bean2099 setMarker (clojure.core/str v2101))))
   bean2099))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.DeleteDistributionRequest}
delete-distribution-request
  [m2103]
  (clojure.core/let
   [bean2102
    (new
     com.amazonaws.services.cloudfront.model.DeleteDistributionRequest)]
   (clojure.core/let
    [v2104 (:id m2103 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2104 :com.palletops.awaze.client-builder/undef)
     (. bean2102 setId (clojure.core/str v2104))))
   (clojure.core/let
    [v2104
     (:if-match m2103 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2104 :com.palletops.awaze.client-builder/undef)
     (. bean2102 setIfMatch (clojure.core/str v2104))))
   bean2102))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.CreateStreamingDistributionRequest}
create-streaming-distribution-request
  [m2106]
  (clojure.core/let
   [bean2105
    (new
     com.amazonaws.services.cloudfront.model.CreateStreamingDistributionRequest)]
   (clojure.core/let
    [v2107
     (:streaming-distribution-config
      m2106
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2107 :com.palletops.awaze.client-builder/undef)
     (.
      bean2105
      setStreamingDistributionConfig
      (cloudfront/streaming-distribution-config v2107))))
   bean2105))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.ListDistributionsRequest}
list-distributions-request
  [m2109]
  (clojure.core/let
   [bean2108
    (new
     com.amazonaws.services.cloudfront.model.ListDistributionsRequest)]
   (clojure.core/let
    [v2110
     (:max-items m2109 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2110 :com.palletops.awaze.client-builder/undef)
     (. bean2108 setMaxItems (clojure.core/str v2110))))
   (clojure.core/let
    [v2110 (:marker m2109 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2110 :com.palletops.awaze.client-builder/undef)
     (. bean2108 setMarker (clojure.core/str v2110))))
   bean2108))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.UpdateCloudFrontOriginAccessIdentityRequest}
update-cloud-front-origin-access-identity-request
  [m2112]
  (clojure.core/let
   [bean2111
    (new
     com.amazonaws.services.cloudfront.model.UpdateCloudFrontOriginAccessIdentityRequest)]
   (clojure.core/let
    [v2113 (:id m2112 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2113 :com.palletops.awaze.client-builder/undef)
     (. bean2111 setId (clojure.core/str v2113))))
   (clojure.core/let
    [v2113
     (:if-match m2112 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2113 :com.palletops.awaze.client-builder/undef)
     (. bean2111 setIfMatch (clojure.core/str v2113))))
   (clojure.core/let
    [v2113
     (:cloud-front-origin-access-identity-config
      m2112
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2113 :com.palletops.awaze.client-builder/undef)
     (.
      bean2111
      setCloudFrontOriginAccessIdentityConfig
      (cloudfront/cloud-front-origin-access-identity-config v2113))))
   bean2111))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.GetInvalidationRequest}
get-invalidation-request
  [m2115]
  (clojure.core/let
   [bean2114
    (new
     com.amazonaws.services.cloudfront.model.GetInvalidationRequest)]
   (clojure.core/let
    [v2116 (:id m2115 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2116 :com.palletops.awaze.client-builder/undef)
     (. bean2114 setId (clojure.core/str v2116))))
   (clojure.core/let
    [v2116
     (:distribution-id
      m2115
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2116 :com.palletops.awaze.client-builder/undef)
     (. bean2114 setDistributionId (clojure.core/str v2116))))
   bean2114))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.DeleteStreamingDistributionRequest}
delete-streaming-distribution-request
  [m2118]
  (clojure.core/let
   [bean2117
    (new
     com.amazonaws.services.cloudfront.model.DeleteStreamingDistributionRequest)]
   (clojure.core/let
    [v2119 (:id m2118 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2119 :com.palletops.awaze.client-builder/undef)
     (. bean2117 setId (clojure.core/str v2119))))
   (clojure.core/let
    [v2119
     (:if-match m2118 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2119 :com.palletops.awaze.client-builder/undef)
     (. bean2117 setIfMatch (clojure.core/str v2119))))
   bean2117))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.GetDistributionRequest}
get-distribution-request
  [m2121]
  (clojure.core/let
   [bean2120
    (new
     com.amazonaws.services.cloudfront.model.GetDistributionRequest)]
   (clojure.core/let
    [v2122 (:id m2121 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2122 :com.palletops.awaze.client-builder/undef)
     (. bean2120 setId (clojure.core/str v2122))))
   bean2120))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.DeleteCloudFrontOriginAccessIdentityRequest}
delete-cloud-front-origin-access-identity-request
  [m2124]
  (clojure.core/let
   [bean2123
    (new
     com.amazonaws.services.cloudfront.model.DeleteCloudFrontOriginAccessIdentityRequest)]
   (clojure.core/let
    [v2125 (:id m2124 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2125 :com.palletops.awaze.client-builder/undef)
     (. bean2123 setId (clojure.core/str v2125))))
   (clojure.core/let
    [v2125
     (:if-match m2124 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2125 :com.palletops.awaze.client-builder/undef)
     (. bean2123 setIfMatch (clojure.core/str v2125))))
   bean2123))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.GetCloudFrontOriginAccessIdentityRequest}
get-cloud-front-origin-access-identity-request
  [m2127]
  (clojure.core/let
   [bean2126
    (new
     com.amazonaws.services.cloudfront.model.GetCloudFrontOriginAccessIdentityRequest)]
   (clojure.core/let
    [v2128 (:id m2127 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v2128 :com.palletops.awaze.client-builder/undef)
     (. bean2126 setId (clojure.core/str v2128))))
   bean2126))
 (clojure.core/defmulti
  cloudfront
  (clojure.core/fn cloudfront [m__1683__auto__] (:fn m__1683__auto__)))
 (do
  (clojure.core/defmethod
   cloudfront
   :list-streaming-distributions
   [m2139]
   (clojure.core/let
    [credentials2140 (:credentials m2139) args2141 (:args m2139)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client2142
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials2140)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client2142
       listStreamingDistributions
       (cloudfront/list-streaming-distributions-request
        (clojure.core/nth args2141 0)))))))
  (clojure.core/defn
   list-streaming-distributions-map
   {:arglists (quote
               [[credentials
                 {:keys [max-items marker general-progress-listener]}]]),
    :doc "Generate map for listStreamingDistributions"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :cloudfront,
     :fn :list-streaming-distributions,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   list-streaming-distributions
   {:arglists (quote
               [[credentials
                 {:keys [max-items marker general-progress-listener]}]]),
    :doc "Call listStreamingDistributions"}
   [credentials2144 & args2145]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client2146
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials2144)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client2146
      listStreamingDistributions
      (cloudfront/list-streaming-distributions-request
       (clojure.core/nth args2145 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :get-cloud-front-origin-access-identity-config
   [m2147]
   (clojure.core/let
    [credentials2148 (:credentials m2147) args2149 (:args m2147)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client2150
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials2148)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client2150
       getCloudFrontOriginAccessIdentityConfig
       (cloudfront/get-cloud-front-origin-access-identity-config-request
        (clojure.core/nth args2149 0)))))))
  (clojure.core/defn
   get-cloud-front-origin-access-identity-config-map
   {:arglists (quote
               [[credentials {:keys [id general-progress-listener]}]]),
    :doc "Generate map for getCloudFrontOriginAccessIdentityConfig"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :cloudfront,
     :fn :get-cloud-front-origin-access-identity-config,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   get-cloud-front-origin-access-identity-config
   {:arglists (quote
               [[credentials {:keys [id general-progress-listener]}]]),
    :doc "Call getCloudFrontOriginAccessIdentityConfig"}
   [credentials2152 & args2153]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client2154
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials2152)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client2154
      getCloudFrontOriginAccessIdentityConfig
      (cloudfront/get-cloud-front-origin-access-identity-config-request
       (clojure.core/nth args2153 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :update-streaming-distribution
   [m2155]
   (clojure.core/let
    [credentials2156 (:credentials m2155) args2157 (:args m2155)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client2158
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials2156)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client2158
       updateStreamingDistribution
       (cloudfront/update-streaming-distribution-request
        (clojure.core/nth args2157 0)))))))
  (clojure.core/defn
   update-streaming-distribution-map
   {:arglists (quote
               [[credentials
                 {:keys [streaming-distribution-config
                         if-match
                         id
                         general-progress-listener]}]]),
    :doc "Generate map for updateStreamingDistribution"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :cloudfront,
     :fn :update-streaming-distribution,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   update-streaming-distribution
   {:arglists (quote
               [[credentials
                 {:keys [streaming-distribution-config
                         if-match
                         id
                         general-progress-listener]}]]),
    :doc "Call updateStreamingDistribution"}
   [credentials2160 & args2161]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client2162
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials2160)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client2162
      updateStreamingDistribution
      (cloudfront/update-streaming-distribution-request
       (clojure.core/nth args2161 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :create-cloud-front-origin-access-identity
   [m2163]
   (clojure.core/let
    [credentials2164 (:credentials m2163) args2165 (:args m2163)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client2166
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials2164)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client2166
       createCloudFrontOriginAccessIdentity
       (cloudfront/create-cloud-front-origin-access-identity-request
        (clojure.core/nth args2165 0)))))))
  (clojure.core/defn
   create-cloud-front-origin-access-identity-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         cloud-front-origin-access-identity-config]}]]),
    :doc "Generate map for createCloudFrontOriginAccessIdentity"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :cloudfront,
     :fn :create-cloud-front-origin-access-identity,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-cloud-front-origin-access-identity
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         cloud-front-origin-access-identity-config]}]]),
    :doc "Call createCloudFrontOriginAccessIdentity"}
   [credentials2168 & args2169]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client2170
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials2168)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client2170
      createCloudFrontOriginAccessIdentity
      (cloudfront/create-cloud-front-origin-access-identity-request
       (clojure.core/nth args2169 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :list-cloud-front-origin-access-identities
   [m2171]
   (clojure.core/let
    [credentials2172 (:credentials m2171) args2173 (:args m2171)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client2174
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials2172)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client2174
       listCloudFrontOriginAccessIdentities
       (cloudfront/list-cloud-front-origin-access-identities-request
        (clojure.core/nth args2173 0)))))))
  (clojure.core/defn
   list-cloud-front-origin-access-identities-map
   {:arglists (quote
               [[credentials
                 {:keys [max-items marker general-progress-listener]}]]),
    :doc "Generate map for listCloudFrontOriginAccessIdentities"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :cloudfront,
     :fn :list-cloud-front-origin-access-identities,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   list-cloud-front-origin-access-identities
   {:arglists (quote
               [[credentials
                 {:keys [max-items marker general-progress-listener]}]]),
    :doc "Call listCloudFrontOriginAccessIdentities"}
   [credentials2176 & args2177]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client2178
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials2176)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client2178
      listCloudFrontOriginAccessIdentities
      (cloudfront/list-cloud-front-origin-access-identities-request
       (clojure.core/nth args2177 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :get-distribution-config
   [m2179]
   (clojure.core/let
    [credentials2180 (:credentials m2179) args2181 (:args m2179)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client2182
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials2180)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client2182
       getDistributionConfig
       (cloudfront/get-distribution-config-request
        (clojure.core/nth args2181 0)))))))
  (clojure.core/defn
   get-distribution-config-map
   {:arglists (quote
               [[credentials {:keys [id general-progress-listener]}]]),
    :doc "Generate map for getDistributionConfig"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :cloudfront,
     :fn :get-distribution-config,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   get-distribution-config
   {:arglists (quote
               [[credentials {:keys [id general-progress-listener]}]]),
    :doc "Call getDistributionConfig"}
   [credentials2184 & args2185]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client2186
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials2184)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client2186
      getDistributionConfig
      (cloudfront/get-distribution-config-request
       (clojure.core/nth args2185 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :get-streaming-distribution-config
   [m2187]
   (clojure.core/let
    [credentials2188 (:credentials m2187) args2189 (:args m2187)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client2190
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials2188)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client2190
       getStreamingDistributionConfig
       (cloudfront/get-streaming-distribution-config-request
        (clojure.core/nth args2189 0)))))))
  (clojure.core/defn
   get-streaming-distribution-config-map
   {:arglists (quote
               [[credentials {:keys [id general-progress-listener]}]]),
    :doc "Generate map for getStreamingDistributionConfig"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :cloudfront,
     :fn :get-streaming-distribution-config,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   get-streaming-distribution-config
   {:arglists (quote
               [[credentials {:keys [id general-progress-listener]}]]),
    :doc "Call getStreamingDistributionConfig"}
   [credentials2192 & args2193]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client2194
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials2192)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client2194
      getStreamingDistributionConfig
      (cloudfront/get-streaming-distribution-config-request
       (clojure.core/nth args2193 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :create-distribution
   [m2195]
   (clojure.core/let
    [credentials2196 (:credentials m2195) args2197 (:args m2195)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client2198
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials2196)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client2198
       createDistribution
       (cloudfront/create-distribution-request
        (clojure.core/nth args2197 0)))))))
  (clojure.core/defn
   create-distribution-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         distribution-config]}]]),
    :doc "Generate map for createDistribution"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :cloudfront,
     :fn :create-distribution,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-distribution
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         distribution-config]}]]),
    :doc "Call createDistribution"}
   [credentials2200 & args2201]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client2202
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials2200)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client2202
      createDistribution
      (cloudfront/create-distribution-request
       (clojure.core/nth args2201 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :create-invalidation
   [m2203]
   (clojure.core/let
    [credentials2204 (:credentials m2203) args2205 (:args m2203)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client2206
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials2204)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client2206
       createInvalidation
       (cloudfront/create-invalidation-request
        (clojure.core/nth args2205 0)))))))
  (clojure.core/defn
   create-invalidation-map
   {:arglists (quote
               [[credentials
                 {:keys [invalidation-batch
                         general-progress-listener
                         distribution-id]}]]),
    :doc "Generate map for createInvalidation"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :cloudfront,
     :fn :create-invalidation,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-invalidation
   {:arglists (quote
               [[credentials
                 {:keys [invalidation-batch
                         general-progress-listener
                         distribution-id]}]]),
    :doc "Call createInvalidation"}
   [credentials2208 & args2209]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client2210
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials2208)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client2210
      createInvalidation
      (cloudfront/create-invalidation-request
       (clojure.core/nth args2209 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :update-distribution
   [m2211]
   (clojure.core/let
    [credentials2212 (:credentials m2211) args2213 (:args m2211)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client2214
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials2212)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client2214
       updateDistribution
       (cloudfront/update-distribution-request
        (clojure.core/nth args2213 0)))))))
  (clojure.core/defn
   update-distribution-map
   {:arglists (quote
               [[credentials
                 {:keys [if-match
                         id
                         general-progress-listener
                         distribution-config]}]]),
    :doc "Generate map for updateDistribution"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :cloudfront,
     :fn :update-distribution,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   update-distribution
   {:arglists (quote
               [[credentials
                 {:keys [if-match
                         id
                         general-progress-listener
                         distribution-config]}]]),
    :doc "Call updateDistribution"}
   [credentials2216 & args2217]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client2218
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials2216)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client2218
      updateDistribution
      (cloudfront/update-distribution-request
       (clojure.core/nth args2217 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :get-streaming-distribution
   [m2219]
   (clojure.core/let
    [credentials2220 (:credentials m2219) args2221 (:args m2219)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client2222
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials2220)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client2222
       getStreamingDistribution
       (cloudfront/get-streaming-distribution-request
        (clojure.core/nth args2221 0)))))))
  (clojure.core/defn
   get-streaming-distribution-map
   {:arglists (quote
               [[credentials {:keys [id general-progress-listener]}]]),
    :doc "Generate map for getStreamingDistribution"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :cloudfront,
     :fn :get-streaming-distribution,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   get-streaming-distribution
   {:arglists (quote
               [[credentials {:keys [id general-progress-listener]}]]),
    :doc "Call getStreamingDistribution"}
   [credentials2224 & args2225]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client2226
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials2224)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client2226
      getStreamingDistribution
      (cloudfront/get-streaming-distribution-request
       (clojure.core/nth args2225 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :list-invalidations
   [m2227]
   (clojure.core/let
    [credentials2228 (:credentials m2227) args2229 (:args m2227)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client2230
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials2228)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client2230
       listInvalidations
       (cloudfront/list-invalidations-request
        (clojure.core/nth args2229 0)))))))
  (clojure.core/defn
   list-invalidations-map
   {:arglists (quote
               [[credentials
                 {:keys [max-items
                         marker
                         general-progress-listener
                         distribution-id]}]]),
    :doc "Generate map for listInvalidations"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :cloudfront,
     :fn :list-invalidations,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   list-invalidations
   {:arglists (quote
               [[credentials
                 {:keys [max-items
                         marker
                         general-progress-listener
                         distribution-id]}]]),
    :doc "Call listInvalidations"}
   [credentials2232 & args2233]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client2234
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials2232)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client2234
      listInvalidations
      (cloudfront/list-invalidations-request
       (clojure.core/nth args2233 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :delete-distribution
   [m2235]
   (clojure.core/let
    [credentials2236 (:credentials m2235) args2237 (:args m2235)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client2238
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials2236)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client2238
       deleteDistribution
       (cloudfront/delete-distribution-request
        (clojure.core/nth args2237 0)))))))
  (clojure.core/defn
   delete-distribution-map
   {:arglists (quote
               [[credentials
                 {:keys [if-match id general-progress-listener]}]]),
    :doc "Generate map for deleteDistribution"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :cloudfront,
     :fn :delete-distribution,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-distribution
   {:arglists (quote
               [[credentials
                 {:keys [if-match id general-progress-listener]}]]),
    :doc "Call deleteDistribution"}
   [credentials2240 & args2241]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client2242
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials2240)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client2242
      deleteDistribution
      (cloudfront/delete-distribution-request
       (clojure.core/nth args2241 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :create-streaming-distribution
   [m2243]
   (clojure.core/let
    [credentials2244 (:credentials m2243) args2245 (:args m2243)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client2246
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials2244)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client2246
       createStreamingDistribution
       (cloudfront/create-streaming-distribution-request
        (clojure.core/nth args2245 0)))))))
  (clojure.core/defn
   create-streaming-distribution-map
   {:arglists (quote
               [[credentials
                 {:keys [streaming-distribution-config
                         general-progress-listener]}]]),
    :doc "Generate map for createStreamingDistribution"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :cloudfront,
     :fn :create-streaming-distribution,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-streaming-distribution
   {:arglists (quote
               [[credentials
                 {:keys [streaming-distribution-config
                         general-progress-listener]}]]),
    :doc "Call createStreamingDistribution"}
   [credentials2248 & args2249]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client2250
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials2248)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client2250
      createStreamingDistribution
      (cloudfront/create-streaming-distribution-request
       (clojure.core/nth args2249 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :list-distributions
   [m2251]
   (clojure.core/let
    [credentials2252 (:credentials m2251) args2253 (:args m2251)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client2254
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials2252)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client2254
       listDistributions
       (cloudfront/list-distributions-request
        (clojure.core/nth args2253 0)))))))
  (clojure.core/defn
   list-distributions-map
   {:arglists (quote
               [[credentials
                 {:keys [max-items marker general-progress-listener]}]]),
    :doc "Generate map for listDistributions"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :cloudfront,
     :fn :list-distributions,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   list-distributions
   {:arglists (quote
               [[credentials
                 {:keys [max-items marker general-progress-listener]}]]),
    :doc "Call listDistributions"}
   [credentials2256 & args2257]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client2258
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials2256)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client2258
      listDistributions
      (cloudfront/list-distributions-request
       (clojure.core/nth args2257 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :update-cloud-front-origin-access-identity
   [m2259]
   (clojure.core/let
    [credentials2260 (:credentials m2259) args2261 (:args m2259)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client2262
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials2260)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client2262
       updateCloudFrontOriginAccessIdentity
       (cloudfront/update-cloud-front-origin-access-identity-request
        (clojure.core/nth args2261 0)))))))
  (clojure.core/defn
   update-cloud-front-origin-access-identity-map
   {:arglists (quote
               [[credentials
                 {:keys [if-match
                         id
                         general-progress-listener
                         cloud-front-origin-access-identity-config]}]]),
    :doc "Generate map for updateCloudFrontOriginAccessIdentity"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :cloudfront,
     :fn :update-cloud-front-origin-access-identity,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   update-cloud-front-origin-access-identity
   {:arglists (quote
               [[credentials
                 {:keys [if-match
                         id
                         general-progress-listener
                         cloud-front-origin-access-identity-config]}]]),
    :doc "Call updateCloudFrontOriginAccessIdentity"}
   [credentials2264 & args2265]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client2266
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials2264)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client2266
      updateCloudFrontOriginAccessIdentity
      (cloudfront/update-cloud-front-origin-access-identity-request
       (clojure.core/nth args2265 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :get-invalidation
   [m2267]
   (clojure.core/let
    [credentials2268 (:credentials m2267) args2269 (:args m2267)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client2270
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials2268)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client2270
       getInvalidation
       (cloudfront/get-invalidation-request
        (clojure.core/nth args2269 0)))))))
  (clojure.core/defn
   get-invalidation-map
   {:arglists (quote
               [[credentials
                 {:keys [id general-progress-listener distribution-id]}]]),
    :doc "Generate map for getInvalidation"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :cloudfront,
     :fn :get-invalidation,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   get-invalidation
   {:arglists (quote
               [[credentials
                 {:keys [id general-progress-listener distribution-id]}]]),
    :doc "Call getInvalidation"}
   [credentials2272 & args2273]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client2274
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials2272)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client2274
      getInvalidation
      (cloudfront/get-invalidation-request
       (clojure.core/nth args2273 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :delete-streaming-distribution
   [m2275]
   (clojure.core/let
    [credentials2276 (:credentials m2275) args2277 (:args m2275)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client2278
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials2276)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client2278
       deleteStreamingDistribution
       (cloudfront/delete-streaming-distribution-request
        (clojure.core/nth args2277 0)))))))
  (clojure.core/defn
   delete-streaming-distribution-map
   {:arglists (quote
               [[credentials
                 {:keys [if-match id general-progress-listener]}]]),
    :doc "Generate map for deleteStreamingDistribution"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :cloudfront,
     :fn :delete-streaming-distribution,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-streaming-distribution
   {:arglists (quote
               [[credentials
                 {:keys [if-match id general-progress-listener]}]]),
    :doc "Call deleteStreamingDistribution"}
   [credentials2280 & args2281]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client2282
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials2280)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client2282
      deleteStreamingDistribution
      (cloudfront/delete-streaming-distribution-request
       (clojure.core/nth args2281 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :get-distribution
   [m2283]
   (clojure.core/let
    [credentials2284 (:credentials m2283) args2285 (:args m2283)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client2286
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials2284)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client2286
       getDistribution
       (cloudfront/get-distribution-request
        (clojure.core/nth args2285 0)))))))
  (clojure.core/defn
   get-distribution-map
   {:arglists (quote
               [[credentials {:keys [id general-progress-listener]}]]),
    :doc "Generate map for getDistribution"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :cloudfront,
     :fn :get-distribution,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   get-distribution
   {:arglists (quote
               [[credentials {:keys [id general-progress-listener]}]]),
    :doc "Call getDistribution"}
   [credentials2288 & args2289]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client2290
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials2288)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client2290
      getDistribution
      (cloudfront/get-distribution-request
       (clojure.core/nth args2289 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :delete-cloud-front-origin-access-identity
   [m2291]
   (clojure.core/let
    [credentials2292 (:credentials m2291) args2293 (:args m2291)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client2294
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials2292)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client2294
       deleteCloudFrontOriginAccessIdentity
       (cloudfront/delete-cloud-front-origin-access-identity-request
        (clojure.core/nth args2293 0)))))))
  (clojure.core/defn
   delete-cloud-front-origin-access-identity-map
   {:arglists (quote
               [[credentials
                 {:keys [if-match id general-progress-listener]}]]),
    :doc "Generate map for deleteCloudFrontOriginAccessIdentity"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :cloudfront,
     :fn :delete-cloud-front-origin-access-identity,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-cloud-front-origin-access-identity
   {:arglists (quote
               [[credentials
                 {:keys [if-match id general-progress-listener]}]]),
    :doc "Call deleteCloudFrontOriginAccessIdentity"}
   [credentials2296 & args2297]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client2298
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials2296)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client2298
      deleteCloudFrontOriginAccessIdentity
      (cloudfront/delete-cloud-front-origin-access-identity-request
       (clojure.core/nth args2297 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :get-cloud-front-origin-access-identity
   [m2299]
   (clojure.core/let
    [credentials2300 (:credentials m2299) args2301 (:args m2299)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client2302
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials2300)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client2302
       getCloudFrontOriginAccessIdentity
       (cloudfront/get-cloud-front-origin-access-identity-request
        (clojure.core/nth args2301 0)))))))
  (clojure.core/defn
   get-cloud-front-origin-access-identity-map
   {:arglists (quote
               [[credentials {:keys [id general-progress-listener]}]]),
    :doc "Generate map for getCloudFrontOriginAccessIdentity"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :cloudfront,
     :fn :get-cloud-front-origin-access-identity,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   get-cloud-front-origin-access-identity
   {:arglists (quote
               [[credentials {:keys [id general-progress-listener]}]]),
    :doc "Call getCloudFrontOriginAccessIdentity"}
   [credentials2304 & args2305]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client2306
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials2304)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client2306
      getCloudFrontOriginAccessIdentity
      (cloudfront/get-cloud-front-origin-access-identity-request
       (clojure.core/nth args2305 0))))))))
