(ns
 com.palletops.awaze.elasticache
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.elasticache :as elasticache]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :elasticache
  [___1600__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1601__auto__]
  (new
   com.amazonaws.services.elasticache.AmazonElastiCacheClient
   credentials__1601__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.ParameterNameValue}
parameter-name-value
  [m10898]
  (clojure.core/let
   [bean10897
    (new com.amazonaws.services.elasticache.model.ParameterNameValue)]
   (clojure.core/let
    [v10899
     (:parameter-name
      m10898
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10899 :com.palletops.awaze.client-builder/undef)
     (. bean10897 setParameterName (clojure.core/str v10899))))
   (clojure.core/let
    [v10899
     (:parameter-value
      m10898
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10899 :com.palletops.awaze.client-builder/undef)
     (. bean10897 setParameterValue (clojure.core/str v10899))))
   bean10897))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DescribeCacheParameterGroupsRequest}
describe-cache-parameter-groups-request
  [m10901]
  (clojure.core/let
   [bean10900
    (new
     com.amazonaws.services.elasticache.model.DescribeCacheParameterGroupsRequest)]
   (clojure.core/let
    [v10902
     (:cache-parameter-group-name
      m10901
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10902 :com.palletops.awaze.client-builder/undef)
     (.
      bean10900
      setCacheParameterGroupName
      (clojure.core/str v10902))))
   (clojure.core/let
    [v10902
     (:marker m10901 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10902 :com.palletops.awaze.client-builder/undef)
     (. bean10900 setMarker (clojure.core/str v10902))))
   (clojure.core/let
    [v10902
     (:max-records m10901 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10902 :com.palletops.awaze.client-builder/undef)
     (. bean10900 setMaxRecords (clojure.core/int v10902))))
   bean10900))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.CreateCacheParameterGroupRequest}
create-cache-parameter-group-request
  [m10904]
  (clojure.core/let
   [bean10903
    (new
     com.amazonaws.services.elasticache.model.CreateCacheParameterGroupRequest)]
   (clojure.core/let
    [v10905
     (:cache-parameter-group-name
      m10904
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10905 :com.palletops.awaze.client-builder/undef)
     (.
      bean10903
      setCacheParameterGroupName
      (clojure.core/str v10905))))
   (clojure.core/let
    [v10905
     (:cache-parameter-group-family
      m10904
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10905 :com.palletops.awaze.client-builder/undef)
     (.
      bean10903
      setCacheParameterGroupFamily
      (clojure.core/str v10905))))
   (clojure.core/let
    [v10905
     (:description m10904 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10905 :com.palletops.awaze.client-builder/undef)
     (. bean10903 setDescription (clojure.core/str v10905))))
   bean10903))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.RevokeCacheSecurityGroupIngressRequest}
revoke-cache-security-group-ingress-request
  [m10907]
  (clojure.core/let
   [bean10906
    (new
     com.amazonaws.services.elasticache.model.RevokeCacheSecurityGroupIngressRequest)]
   (clojure.core/let
    [v10908
     (:cache-security-group-name
      m10907
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10908 :com.palletops.awaze.client-builder/undef)
     (. bean10906 setCacheSecurityGroupName (clojure.core/str v10908))))
   (clojure.core/let
    [v10908
     (:ec2security-group-name
      m10907
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10908 :com.palletops.awaze.client-builder/undef)
     (. bean10906 setEC2SecurityGroupName (clojure.core/str v10908))))
   (clojure.core/let
    [v10908
     (:ec2security-group-owner-id
      m10907
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10908 :com.palletops.awaze.client-builder/undef)
     (.
      bean10906
      setEC2SecurityGroupOwnerId
      (clojure.core/str v10908))))
   bean10906))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.CreateReplicationGroupRequest}
create-replication-group-request
  [m10910]
  (clojure.core/let
   [bean10909
    (new
     com.amazonaws.services.elasticache.model.CreateReplicationGroupRequest)]
   (clojure.core/let
    [v10911
     (:replication-group-id
      m10910
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10911 :com.palletops.awaze.client-builder/undef)
     (. bean10909 setReplicationGroupId (clojure.core/str v10911))))
   (clojure.core/let
    [v10911
     (:replication-group-description
      m10910
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10911 :com.palletops.awaze.client-builder/undef)
     (.
      bean10909
      setReplicationGroupDescription
      (clojure.core/str v10911))))
   (clojure.core/let
    [v10911
     (:primary-cluster-id
      m10910
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10911 :com.palletops.awaze.client-builder/undef)
     (. bean10909 setPrimaryClusterId (clojure.core/str v10911))))
   bean10909))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DescribeSnapshotsRequest}
describe-snapshots-request
  [m10913]
  (clojure.core/let
   [bean10912
    (new
     com.amazonaws.services.elasticache.model.DescribeSnapshotsRequest)]
   (clojure.core/let
    [v10914
     (:marker m10913 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10914 :com.palletops.awaze.client-builder/undef)
     (. bean10912 setMarker (clojure.core/str v10914))))
   (clojure.core/let
    [v10914
     (:max-records m10913 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10914 :com.palletops.awaze.client-builder/undef)
     (. bean10912 setMaxRecords (clojure.core/int v10914))))
   (clojure.core/let
    [v10914
     (:cache-cluster-id
      m10913
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10914 :com.palletops.awaze.client-builder/undef)
     (. bean10912 setCacheClusterId (clojure.core/str v10914))))
   (clojure.core/let
    [v10914
     (:snapshot-name m10913 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10914 :com.palletops.awaze.client-builder/undef)
     (. bean10912 setSnapshotName (clojure.core/str v10914))))
   (clojure.core/let
    [v10914
     (:snapshot-source
      m10913
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10914 :com.palletops.awaze.client-builder/undef)
     (. bean10912 setSnapshotSource (clojure.core/str v10914))))
   bean10912))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.AuthorizeCacheSecurityGroupIngressRequest}
authorize-cache-security-group-ingress-request
  [m10916]
  (clojure.core/let
   [bean10915
    (new
     com.amazonaws.services.elasticache.model.AuthorizeCacheSecurityGroupIngressRequest)]
   (clojure.core/let
    [v10917
     (:cache-security-group-name
      m10916
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10917 :com.palletops.awaze.client-builder/undef)
     (. bean10915 setCacheSecurityGroupName (clojure.core/str v10917))))
   (clojure.core/let
    [v10917
     (:ec2security-group-name
      m10916
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10917 :com.palletops.awaze.client-builder/undef)
     (. bean10915 setEC2SecurityGroupName (clojure.core/str v10917))))
   (clojure.core/let
    [v10917
     (:ec2security-group-owner-id
      m10916
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10917 :com.palletops.awaze.client-builder/undef)
     (.
      bean10915
      setEC2SecurityGroupOwnerId
      (clojure.core/str v10917))))
   bean10915))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DescribeReservedCacheNodesRequest}
describe-reserved-cache-nodes-request
  [m10919]
  (clojure.core/let
   [bean10918
    (new
     com.amazonaws.services.elasticache.model.DescribeReservedCacheNodesRequest)]
   (clojure.core/let
    [v10920
     (:marker m10919 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10920 :com.palletops.awaze.client-builder/undef)
     (. bean10918 setMarker (clojure.core/str v10920))))
   (clojure.core/let
    [v10920
     (:product-description
      m10919
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10920 :com.palletops.awaze.client-builder/undef)
     (. bean10918 setProductDescription (clojure.core/str v10920))))
   (clojure.core/let
    [v10920
     (:max-records m10919 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10920 :com.palletops.awaze.client-builder/undef)
     (. bean10918 setMaxRecords (clojure.core/int v10920))))
   (clojure.core/let
    [v10920
     (:duration m10919 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10920 :com.palletops.awaze.client-builder/undef)
     (. bean10918 setDuration (clojure.core/str v10920))))
   (clojure.core/let
    [v10920
     (:offering-type m10919 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10920 :com.palletops.awaze.client-builder/undef)
     (. bean10918 setOfferingType (clojure.core/str v10920))))
   (clojure.core/let
    [v10920
     (:reserved-cache-nodes-offering-id
      m10919
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10920 :com.palletops.awaze.client-builder/undef)
     (.
      bean10918
      setReservedCacheNodesOfferingId
      (clojure.core/str v10920))))
   (clojure.core/let
    [v10920
     (:cache-node-type
      m10919
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10920 :com.palletops.awaze.client-builder/undef)
     (. bean10918 setCacheNodeType (clojure.core/str v10920))))
   (clojure.core/let
    [v10920
     (:reserved-cache-node-id
      m10919
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10920 :com.palletops.awaze.client-builder/undef)
     (. bean10918 setReservedCacheNodeId (clojure.core/str v10920))))
   bean10918))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.ModifyCacheClusterRequest}
modify-cache-cluster-request
  [m10922]
  (clojure.core/let
   [bean10921
    (new
     com.amazonaws.services.elasticache.model.ModifyCacheClusterRequest)]
   (clojure.core/let
    [v10923
     (:cache-parameter-group-name
      m10922
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10923 :com.palletops.awaze.client-builder/undef)
     (.
      bean10921
      setCacheParameterGroupName
      (clojure.core/str v10923))))
   (clojure.core/let
    [v10923
     (:snapshot-retention-limit
      m10922
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10923 :com.palletops.awaze.client-builder/undef)
     (. bean10921 setSnapshotRetentionLimit (clojure.core/int v10923))))
   (clojure.core/let
    [v10923
     (:preferred-maintenance-window
      m10922
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10923 :com.palletops.awaze.client-builder/undef)
     (.
      bean10921
      setPreferredMaintenanceWindow
      (clojure.core/str v10923))))
   (clojure.core/let
    [v10923
     (:auto-minor-version-upgrade
      m10922
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10923 :com.palletops.awaze.client-builder/undef)
     (.
      bean10921
      setAutoMinorVersionUpgrade
      (clojure.core/boolean v10923))))
   (clojure.core/let
    [v10923
     (:cache-security-group-names
      m10922
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10923 :com.palletops.awaze.client-builder/undef)
     (.
      bean10921
      setCacheSecurityGroupNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg11002] (clojure.core/str arg11002))
 v10923))))
   (clojure.core/let
    [v10923
     (:apply-immediately
      m10922
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10923 :com.palletops.awaze.client-builder/undef)
     (. bean10921 setApplyImmediately (clojure.core/boolean v10923))))
   (clojure.core/let
    [v10923
     (:num-cache-nodes
      m10922
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10923 :com.palletops.awaze.client-builder/undef)
     (. bean10921 setNumCacheNodes (clojure.core/int v10923))))
   (clojure.core/let
    [v10923
     (:notification-topic-status
      m10922
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10923 :com.palletops.awaze.client-builder/undef)
     (.
      bean10921
      setNotificationTopicStatus
      (clojure.core/str v10923))))
   (clojure.core/let
    [v10923
     (:engine-version
      m10922
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10923 :com.palletops.awaze.client-builder/undef)
     (. bean10921 setEngineVersion (clojure.core/str v10923))))
   (clojure.core/let
    [v10923
     (:cache-cluster-id
      m10922
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10923 :com.palletops.awaze.client-builder/undef)
     (. bean10921 setCacheClusterId (clojure.core/str v10923))))
   (clojure.core/let
    [v10923
     (:cache-node-ids-to-remove
      m10922
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10923 :com.palletops.awaze.client-builder/undef)
     (.
      bean10921
      setCacheNodeIdsToRemove
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg11003] (clojure.core/str arg11003))
 v10923))))
   (clojure.core/let
    [v10923
     (:snapshot-window
      m10922
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10923 :com.palletops.awaze.client-builder/undef)
     (. bean10921 setSnapshotWindow (clojure.core/str v10923))))
   (clojure.core/let
    [v10923
     (:notification-topic-arn
      m10922
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10923 :com.palletops.awaze.client-builder/undef)
     (. bean10921 setNotificationTopicArn (clojure.core/str v10923))))
   (clojure.core/let
    [v10923
     (:security-group-ids
      m10922
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10923 :com.palletops.awaze.client-builder/undef)
     (.
      bean10921
      setSecurityGroupIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg11004] (clojure.core/str arg11004))
 v10923))))
   bean10921))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DeleteCacheSubnetGroupRequest}
delete-cache-subnet-group-request
  [m10925]
  (clojure.core/let
   [bean10924
    (new
     com.amazonaws.services.elasticache.model.DeleteCacheSubnetGroupRequest)]
   (clojure.core/let
    [v10926
     (:cache-subnet-group-name
      m10925
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10926 :com.palletops.awaze.client-builder/undef)
     (. bean10924 setCacheSubnetGroupName (clojure.core/str v10926))))
   bean10924))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DescribeCacheEngineVersionsRequest}
describe-cache-engine-versions-request
  [m10928]
  (clojure.core/let
   [bean10927
    (new
     com.amazonaws.services.elasticache.model.DescribeCacheEngineVersionsRequest)]
   (clojure.core/let
    [v10929
     (:cache-parameter-group-family
      m10928
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10929 :com.palletops.awaze.client-builder/undef)
     (.
      bean10927
      setCacheParameterGroupFamily
      (clojure.core/str v10929))))
   (clojure.core/let
    [v10929
     (:marker m10928 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10929 :com.palletops.awaze.client-builder/undef)
     (. bean10927 setMarker (clojure.core/str v10929))))
   (clojure.core/let
    [v10929
     (:engine m10928 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10929 :com.palletops.awaze.client-builder/undef)
     (. bean10927 setEngine (clojure.core/str v10929))))
   (clojure.core/let
    [v10929
     (:engine-version
      m10928
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10929 :com.palletops.awaze.client-builder/undef)
     (. bean10927 setEngineVersion (clojure.core/str v10929))))
   (clojure.core/let
    [v10929
     (:default-only m10928 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10929 :com.palletops.awaze.client-builder/undef)
     (. bean10927 setDefaultOnly (clojure.core/boolean v10929))))
   (clojure.core/let
    [v10929
     (:max-records m10928 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10929 :com.palletops.awaze.client-builder/undef)
     (. bean10927 setMaxRecords (clojure.core/int v10929))))
   bean10927))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.ResetCacheParameterGroupRequest}
reset-cache-parameter-group-request
  [m10931]
  (clojure.core/let
   [bean10930
    (new
     com.amazonaws.services.elasticache.model.ResetCacheParameterGroupRequest)]
   (clojure.core/let
    [v10932
     (:cache-parameter-group-name
      m10931
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10932 :com.palletops.awaze.client-builder/undef)
     (.
      bean10930
      setCacheParameterGroupName
      (clojure.core/str v10932))))
   (clojure.core/let
    [v10932
     (:parameter-name-values
      m10931
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10932 :com.palletops.awaze.client-builder/undef)
     (.
      bean10930
      setParameterNameValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg11005]
  (elasticache/parameter-name-value arg11005))
 v10932))))
   (clojure.core/let
    [v10932
     (:reset-all-parameters
      m10931
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10932 :com.palletops.awaze.client-builder/undef)
     (. bean10930 setResetAllParameters (clojure.core/boolean v10932))))
   bean10930))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DescribeEngineDefaultParametersRequest}
describe-engine-default-parameters-request
  [m10934]
  (clojure.core/let
   [bean10933
    (new
     com.amazonaws.services.elasticache.model.DescribeEngineDefaultParametersRequest)]
   (clojure.core/let
    [v10935
     (:cache-parameter-group-family
      m10934
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10935 :com.palletops.awaze.client-builder/undef)
     (.
      bean10933
      setCacheParameterGroupFamily
      (clojure.core/str v10935))))
   (clojure.core/let
    [v10935
     (:marker m10934 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10935 :com.palletops.awaze.client-builder/undef)
     (. bean10933 setMarker (clojure.core/str v10935))))
   (clojure.core/let
    [v10935
     (:max-records m10934 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10935 :com.palletops.awaze.client-builder/undef)
     (. bean10933 setMaxRecords (clojure.core/int v10935))))
   bean10933))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DeleteCacheClusterRequest}
delete-cache-cluster-request
  [m10937]
  (clojure.core/let
   [bean10936
    (new
     com.amazonaws.services.elasticache.model.DeleteCacheClusterRequest)]
   (clojure.core/let
    [v10938
     (:final-snapshot-identifier
      m10937
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10938 :com.palletops.awaze.client-builder/undef)
     (.
      bean10936
      setFinalSnapshotIdentifier
      (clojure.core/str v10938))))
   (clojure.core/let
    [v10938
     (:cache-cluster-id
      m10937
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10938 :com.palletops.awaze.client-builder/undef)
     (. bean10936 setCacheClusterId (clojure.core/str v10938))))
   bean10936))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DescribeCacheSubnetGroupsRequest}
describe-cache-subnet-groups-request
  [m10940]
  (clojure.core/let
   [bean10939
    (new
     com.amazonaws.services.elasticache.model.DescribeCacheSubnetGroupsRequest)]
   (clojure.core/let
    [v10941
     (:cache-subnet-group-name
      m10940
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10941 :com.palletops.awaze.client-builder/undef)
     (. bean10939 setCacheSubnetGroupName (clojure.core/str v10941))))
   (clojure.core/let
    [v10941
     (:marker m10940 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10941 :com.palletops.awaze.client-builder/undef)
     (. bean10939 setMarker (clojure.core/str v10941))))
   (clojure.core/let
    [v10941
     (:max-records m10940 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10941 :com.palletops.awaze.client-builder/undef)
     (. bean10939 setMaxRecords (clojure.core/int v10941))))
   bean10939))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DescribeReplicationGroupsRequest}
describe-replication-groups-request
  [m10943]
  (clojure.core/let
   [bean10942
    (new
     com.amazonaws.services.elasticache.model.DescribeReplicationGroupsRequest)]
   (clojure.core/let
    [v10944
     (:replication-group-id
      m10943
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10944 :com.palletops.awaze.client-builder/undef)
     (. bean10942 setReplicationGroupId (clojure.core/str v10944))))
   (clojure.core/let
    [v10944
     (:marker m10943 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10944 :com.palletops.awaze.client-builder/undef)
     (. bean10942 setMarker (clojure.core/str v10944))))
   (clojure.core/let
    [v10944
     (:max-records m10943 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10944 :com.palletops.awaze.client-builder/undef)
     (. bean10942 setMaxRecords (clojure.core/int v10944))))
   bean10942))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DescribeCacheSecurityGroupsRequest}
describe-cache-security-groups-request
  [m10946]
  (clojure.core/let
   [bean10945
    (new
     com.amazonaws.services.elasticache.model.DescribeCacheSecurityGroupsRequest)]
   (clojure.core/let
    [v10947
     (:cache-security-group-name
      m10946
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10947 :com.palletops.awaze.client-builder/undef)
     (. bean10945 setCacheSecurityGroupName (clojure.core/str v10947))))
   (clojure.core/let
    [v10947
     (:marker m10946 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10947 :com.palletops.awaze.client-builder/undef)
     (. bean10945 setMarker (clojure.core/str v10947))))
   (clojure.core/let
    [v10947
     (:max-records m10946 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10947 :com.palletops.awaze.client-builder/undef)
     (. bean10945 setMaxRecords (clojure.core/int v10947))))
   bean10945))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.CreateCacheSecurityGroupRequest}
create-cache-security-group-request
  [m10949]
  (clojure.core/let
   [bean10948
    (new
     com.amazonaws.services.elasticache.model.CreateCacheSecurityGroupRequest)]
   (clojure.core/let
    [v10950
     (:cache-security-group-name
      m10949
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10950 :com.palletops.awaze.client-builder/undef)
     (. bean10948 setCacheSecurityGroupName (clojure.core/str v10950))))
   (clojure.core/let
    [v10950
     (:description m10949 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10950 :com.palletops.awaze.client-builder/undef)
     (. bean10948 setDescription (clojure.core/str v10950))))
   bean10948))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DescribeCacheClustersRequest}
describe-cache-clusters-request
  [m10952]
  (clojure.core/let
   [bean10951
    (new
     com.amazonaws.services.elasticache.model.DescribeCacheClustersRequest)]
   (clojure.core/let
    [v10953
     (:marker m10952 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10953 :com.palletops.awaze.client-builder/undef)
     (. bean10951 setMarker (clojure.core/str v10953))))
   (clojure.core/let
    [v10953
     (:max-records m10952 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10953 :com.palletops.awaze.client-builder/undef)
     (. bean10951 setMaxRecords (clojure.core/int v10953))))
   (clojure.core/let
    [v10953
     (:cache-cluster-id
      m10952
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10953 :com.palletops.awaze.client-builder/undef)
     (. bean10951 setCacheClusterId (clojure.core/str v10953))))
   (clojure.core/let
    [v10953
     (:show-cache-node-info
      m10952
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10953 :com.palletops.awaze.client-builder/undef)
     (. bean10951 setShowCacheNodeInfo (clojure.core/boolean v10953))))
   bean10951))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DescribeEventsRequest}
describe-events-request
  [m10955]
  (clojure.core/let
   [bean10954
    (new
     com.amazonaws.services.elasticache.model.DescribeEventsRequest)]
   (clojure.core/let
    [v10956
     (:marker m10955 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10956 :com.palletops.awaze.client-builder/undef)
     (. bean10954 setMarker (clojure.core/str v10956))))
   (clojure.core/let
    [v10956
     (:max-records m10955 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10956 :com.palletops.awaze.client-builder/undef)
     (. bean10954 setMaxRecords (clojure.core/int v10956))))
   (clojure.core/let
    [v10956
     (:source-identifier
      m10955
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10956 :com.palletops.awaze.client-builder/undef)
     (. bean10954 setSourceIdentifier (clojure.core/str v10956))))
   (clojure.core/let
    [v10956
     (:source-type m10955 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10956 :com.palletops.awaze.client-builder/undef)
     (. bean10954 setSourceType (clojure.core/str v10956))))
   (clojure.core/let
    [v10956
     (:start-time m10955 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10956 :com.palletops.awaze.client-builder/undef)
     (.
      bean10954
      setStartTime
      (com.palletops.awaze.common/to-date v10956))))
   (clojure.core/let
    [v10956
     (:end-time m10955 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10956 :com.palletops.awaze.client-builder/undef)
     (.
      bean10954
      setEndTime
      (com.palletops.awaze.common/to-date v10956))))
   (clojure.core/let
    [v10956
     (:duration m10955 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10956 :com.palletops.awaze.client-builder/undef)
     (. bean10954 setDuration (clojure.core/int v10956))))
   bean10954))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.ModifyCacheParameterGroupRequest}
modify-cache-parameter-group-request
  [m10958]
  (clojure.core/let
   [bean10957
    (new
     com.amazonaws.services.elasticache.model.ModifyCacheParameterGroupRequest)]
   (clojure.core/let
    [v10959
     (:cache-parameter-group-name
      m10958
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10959 :com.palletops.awaze.client-builder/undef)
     (.
      bean10957
      setCacheParameterGroupName
      (clojure.core/str v10959))))
   (clojure.core/let
    [v10959
     (:parameter-name-values
      m10958
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10959 :com.palletops.awaze.client-builder/undef)
     (.
      bean10957
      setParameterNameValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg11006]
  (elasticache/parameter-name-value arg11006))
 v10959))))
   bean10957))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DeleteCacheSecurityGroupRequest}
delete-cache-security-group-request
  [m10961]
  (clojure.core/let
   [bean10960
    (new
     com.amazonaws.services.elasticache.model.DeleteCacheSecurityGroupRequest)]
   (clojure.core/let
    [v10962
     (:cache-security-group-name
      m10961
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10962 :com.palletops.awaze.client-builder/undef)
     (. bean10960 setCacheSecurityGroupName (clojure.core/str v10962))))
   bean10960))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.CreateCacheSubnetGroupRequest}
create-cache-subnet-group-request
  [m10964]
  (clojure.core/let
   [bean10963
    (new
     com.amazonaws.services.elasticache.model.CreateCacheSubnetGroupRequest)]
   (clojure.core/let
    [v10965
     (:cache-subnet-group-name
      m10964
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10965 :com.palletops.awaze.client-builder/undef)
     (. bean10963 setCacheSubnetGroupName (clojure.core/str v10965))))
   (clojure.core/let
    [v10965
     (:cache-subnet-group-description
      m10964
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10965 :com.palletops.awaze.client-builder/undef)
     (.
      bean10963
      setCacheSubnetGroupDescription
      (clojure.core/str v10965))))
   (clojure.core/let
    [v10965
     (:subnet-ids m10964 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10965 :com.palletops.awaze.client-builder/undef)
     (.
      bean10963
      setSubnetIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg11007] (clojure.core/str arg11007))
 v10965))))
   bean10963))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.ModifyReplicationGroupRequest}
modify-replication-group-request
  [m10967]
  (clojure.core/let
   [bean10966
    (new
     com.amazonaws.services.elasticache.model.ModifyReplicationGroupRequest)]
   (clojure.core/let
    [v10968
     (:cache-parameter-group-name
      m10967
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10968 :com.palletops.awaze.client-builder/undef)
     (.
      bean10966
      setCacheParameterGroupName
      (clojure.core/str v10968))))
   (clojure.core/let
    [v10968
     (:snapshotting-cluster-id
      m10967
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10968 :com.palletops.awaze.client-builder/undef)
     (. bean10966 setSnapshottingClusterId (clojure.core/str v10968))))
   (clojure.core/let
    [v10968
     (:snapshot-retention-limit
      m10967
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10968 :com.palletops.awaze.client-builder/undef)
     (. bean10966 setSnapshotRetentionLimit (clojure.core/int v10968))))
   (clojure.core/let
    [v10968
     (:preferred-maintenance-window
      m10967
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10968 :com.palletops.awaze.client-builder/undef)
     (.
      bean10966
      setPreferredMaintenanceWindow
      (clojure.core/str v10968))))
   (clojure.core/let
    [v10968
     (:replication-group-description
      m10967
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10968 :com.palletops.awaze.client-builder/undef)
     (.
      bean10966
      setReplicationGroupDescription
      (clojure.core/str v10968))))
   (clojure.core/let
    [v10968
     (:auto-minor-version-upgrade
      m10967
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10968 :com.palletops.awaze.client-builder/undef)
     (.
      bean10966
      setAutoMinorVersionUpgrade
      (clojure.core/boolean v10968))))
   (clojure.core/let
    [v10968
     (:cache-security-group-names
      m10967
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10968 :com.palletops.awaze.client-builder/undef)
     (.
      bean10966
      setCacheSecurityGroupNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg11008] (clojure.core/str arg11008))
 v10968))))
   (clojure.core/let
    [v10968
     (:replication-group-id
      m10967
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10968 :com.palletops.awaze.client-builder/undef)
     (. bean10966 setReplicationGroupId (clojure.core/str v10968))))
   (clojure.core/let
    [v10968
     (:apply-immediately
      m10967
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10968 :com.palletops.awaze.client-builder/undef)
     (. bean10966 setApplyImmediately (clojure.core/boolean v10968))))
   (clojure.core/let
    [v10968
     (:notification-topic-status
      m10967
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10968 :com.palletops.awaze.client-builder/undef)
     (.
      bean10966
      setNotificationTopicStatus
      (clojure.core/str v10968))))
   (clojure.core/let
    [v10968
     (:engine-version
      m10967
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10968 :com.palletops.awaze.client-builder/undef)
     (. bean10966 setEngineVersion (clojure.core/str v10968))))
   (clojure.core/let
    [v10968
     (:primary-cluster-id
      m10967
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10968 :com.palletops.awaze.client-builder/undef)
     (. bean10966 setPrimaryClusterId (clojure.core/str v10968))))
   (clojure.core/let
    [v10968
     (:snapshot-window
      m10967
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10968 :com.palletops.awaze.client-builder/undef)
     (. bean10966 setSnapshotWindow (clojure.core/str v10968))))
   (clojure.core/let
    [v10968
     (:notification-topic-arn
      m10967
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10968 :com.palletops.awaze.client-builder/undef)
     (. bean10966 setNotificationTopicArn (clojure.core/str v10968))))
   (clojure.core/let
    [v10968
     (:security-group-ids
      m10967
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10968 :com.palletops.awaze.client-builder/undef)
     (.
      bean10966
      setSecurityGroupIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg11009] (clojure.core/str arg11009))
 v10968))))
   bean10966))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.ModifyCacheSubnetGroupRequest}
modify-cache-subnet-group-request
  [m10970]
  (clojure.core/let
   [bean10969
    (new
     com.amazonaws.services.elasticache.model.ModifyCacheSubnetGroupRequest)]
   (clojure.core/let
    [v10971
     (:cache-subnet-group-name
      m10970
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10971 :com.palletops.awaze.client-builder/undef)
     (. bean10969 setCacheSubnetGroupName (clojure.core/str v10971))))
   (clojure.core/let
    [v10971
     (:cache-subnet-group-description
      m10970
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10971 :com.palletops.awaze.client-builder/undef)
     (.
      bean10969
      setCacheSubnetGroupDescription
      (clojure.core/str v10971))))
   (clojure.core/let
    [v10971
     (:subnet-ids m10970 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10971 :com.palletops.awaze.client-builder/undef)
     (.
      bean10969
      setSubnetIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg11010] (clojure.core/str arg11010))
 v10971))))
   bean10969))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DescribeCacheParametersRequest}
describe-cache-parameters-request
  [m10973]
  (clojure.core/let
   [bean10972
    (new
     com.amazonaws.services.elasticache.model.DescribeCacheParametersRequest)]
   (clojure.core/let
    [v10974
     (:cache-parameter-group-name
      m10973
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10974 :com.palletops.awaze.client-builder/undef)
     (.
      bean10972
      setCacheParameterGroupName
      (clojure.core/str v10974))))
   (clojure.core/let
    [v10974
     (:source m10973 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10974 :com.palletops.awaze.client-builder/undef)
     (. bean10972 setSource (clojure.core/str v10974))))
   (clojure.core/let
    [v10974
     (:marker m10973 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10974 :com.palletops.awaze.client-builder/undef)
     (. bean10972 setMarker (clojure.core/str v10974))))
   (clojure.core/let
    [v10974
     (:max-records m10973 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10974 :com.palletops.awaze.client-builder/undef)
     (. bean10972 setMaxRecords (clojure.core/int v10974))))
   bean10972))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DeleteCacheParameterGroupRequest}
delete-cache-parameter-group-request
  [m10976]
  (clojure.core/let
   [bean10975
    (new
     com.amazonaws.services.elasticache.model.DeleteCacheParameterGroupRequest)]
   (clojure.core/let
    [v10977
     (:cache-parameter-group-name
      m10976
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10977 :com.palletops.awaze.client-builder/undef)
     (.
      bean10975
      setCacheParameterGroupName
      (clojure.core/str v10977))))
   bean10975))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DeleteReplicationGroupRequest}
delete-replication-group-request
  [m10979]
  (clojure.core/let
   [bean10978
    (new
     com.amazonaws.services.elasticache.model.DeleteReplicationGroupRequest)]
   (clojure.core/let
    [v10980
     (:replication-group-id
      m10979
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10980 :com.palletops.awaze.client-builder/undef)
     (. bean10978 setReplicationGroupId (clojure.core/str v10980))))
   (clojure.core/let
    [v10980
     (:retain-primary-cluster
      m10979
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10980 :com.palletops.awaze.client-builder/undef)
     (.
      bean10978
      setRetainPrimaryCluster
      (clojure.core/boolean v10980))))
   (clojure.core/let
    [v10980
     (:final-snapshot-identifier
      m10979
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10980 :com.palletops.awaze.client-builder/undef)
     (.
      bean10978
      setFinalSnapshotIdentifier
      (clojure.core/str v10980))))
   bean10978))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.CopySnapshotRequest}
copy-snapshot-request
  [m10982]
  (clojure.core/let
   [bean10981
    (new com.amazonaws.services.elasticache.model.CopySnapshotRequest)]
   (clojure.core/let
    [v10983
     (:source-snapshot-name
      m10982
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10983 :com.palletops.awaze.client-builder/undef)
     (. bean10981 setSourceSnapshotName (clojure.core/str v10983))))
   (clojure.core/let
    [v10983
     (:target-snapshot-name
      m10982
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10983 :com.palletops.awaze.client-builder/undef)
     (. bean10981 setTargetSnapshotName (clojure.core/str v10983))))
   bean10981))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.PurchaseReservedCacheNodesOfferingRequest}
purchase-reserved-cache-nodes-offering-request
  [m10985]
  (clojure.core/let
   [bean10984
    (new
     com.amazonaws.services.elasticache.model.PurchaseReservedCacheNodesOfferingRequest)]
   (clojure.core/let
    [v10986
     (:reserved-cache-nodes-offering-id
      m10985
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10986 :com.palletops.awaze.client-builder/undef)
     (.
      bean10984
      setReservedCacheNodesOfferingId
      (clojure.core/str v10986))))
   (clojure.core/let
    [v10986
     (:reserved-cache-node-id
      m10985
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10986 :com.palletops.awaze.client-builder/undef)
     (. bean10984 setReservedCacheNodeId (clojure.core/str v10986))))
   (clojure.core/let
    [v10986
     (:cache-node-count
      m10985
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10986 :com.palletops.awaze.client-builder/undef)
     (. bean10984 setCacheNodeCount (clojure.core/int v10986))))
   bean10984))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.RebootCacheClusterRequest}
reboot-cache-cluster-request
  [m10988]
  (clojure.core/let
   [bean10987
    (new
     com.amazonaws.services.elasticache.model.RebootCacheClusterRequest)]
   (clojure.core/let
    [v10989
     (:cache-cluster-id
      m10988
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10989 :com.palletops.awaze.client-builder/undef)
     (. bean10987 setCacheClusterId (clojure.core/str v10989))))
   (clojure.core/let
    [v10989
     (:cache-node-ids-to-reboot
      m10988
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10989 :com.palletops.awaze.client-builder/undef)
     (.
      bean10987
      setCacheNodeIdsToReboot
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg11011] (clojure.core/str arg11011))
 v10989))))
   bean10987))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.CreateCacheClusterRequest}
create-cache-cluster-request
  [m10991]
  (clojure.core/let
   [bean10990
    (new
     com.amazonaws.services.elasticache.model.CreateCacheClusterRequest)]
   (clojure.core/let
    [v10992
     (:cache-parameter-group-name
      m10991
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10992 :com.palletops.awaze.client-builder/undef)
     (.
      bean10990
      setCacheParameterGroupName
      (clojure.core/str v10992))))
   (clojure.core/let
    [v10992 (:port m10991 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10992 :com.palletops.awaze.client-builder/undef)
     (. bean10990 setPort (clojure.core/int v10992))))
   (clojure.core/let
    [v10992
     (:snapshot-retention-limit
      m10991
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10992 :com.palletops.awaze.client-builder/undef)
     (. bean10990 setSnapshotRetentionLimit (clojure.core/int v10992))))
   (clojure.core/let
    [v10992
     (:preferred-maintenance-window
      m10991
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10992 :com.palletops.awaze.client-builder/undef)
     (.
      bean10990
      setPreferredMaintenanceWindow
      (clojure.core/str v10992))))
   (clojure.core/let
    [v10992
     (:engine m10991 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10992 :com.palletops.awaze.client-builder/undef)
     (. bean10990 setEngine (clojure.core/str v10992))))
   (clojure.core/let
    [v10992
     (:preferred-availability-zone
      m10991
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10992 :com.palletops.awaze.client-builder/undef)
     (.
      bean10990
      setPreferredAvailabilityZone
      (clojure.core/str v10992))))
   (clojure.core/let
    [v10992
     (:auto-minor-version-upgrade
      m10991
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10992 :com.palletops.awaze.client-builder/undef)
     (.
      bean10990
      setAutoMinorVersionUpgrade
      (clojure.core/boolean v10992))))
   (clojure.core/let
    [v10992
     (:cache-security-group-names
      m10991
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10992 :com.palletops.awaze.client-builder/undef)
     (.
      bean10990
      setCacheSecurityGroupNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg11012] (clojure.core/str arg11012))
 v10992))))
   (clojure.core/let
    [v10992
     (:cache-subnet-group-name
      m10991
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10992 :com.palletops.awaze.client-builder/undef)
     (. bean10990 setCacheSubnetGroupName (clojure.core/str v10992))))
   (clojure.core/let
    [v10992
     (:replication-group-id
      m10991
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10992 :com.palletops.awaze.client-builder/undef)
     (. bean10990 setReplicationGroupId (clojure.core/str v10992))))
   (clojure.core/let
    [v10992
     (:snapshot-name m10991 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10992 :com.palletops.awaze.client-builder/undef)
     (. bean10990 setSnapshotName (clojure.core/str v10992))))
   (clojure.core/let
    [v10992
     (:num-cache-nodes
      m10991
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10992 :com.palletops.awaze.client-builder/undef)
     (. bean10990 setNumCacheNodes (clojure.core/int v10992))))
   (clojure.core/let
    [v10992
     (:engine-version
      m10991
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10992 :com.palletops.awaze.client-builder/undef)
     (. bean10990 setEngineVersion (clojure.core/str v10992))))
   (clojure.core/let
    [v10992
     (:cache-cluster-id
      m10991
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10992 :com.palletops.awaze.client-builder/undef)
     (. bean10990 setCacheClusterId (clojure.core/str v10992))))
   (clojure.core/let
    [v10992
     (:snapshot-window
      m10991
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10992 :com.palletops.awaze.client-builder/undef)
     (. bean10990 setSnapshotWindow (clojure.core/str v10992))))
   (clojure.core/let
    [v10992
     (:notification-topic-arn
      m10991
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10992 :com.palletops.awaze.client-builder/undef)
     (. bean10990 setNotificationTopicArn (clojure.core/str v10992))))
   (clojure.core/let
    [v10992
     (:security-group-ids
      m10991
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10992 :com.palletops.awaze.client-builder/undef)
     (.
      bean10990
      setSecurityGroupIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg11013] (clojure.core/str arg11013))
 v10992))))
   (clojure.core/let
    [v10992
     (:cache-node-type
      m10991
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10992 :com.palletops.awaze.client-builder/undef)
     (. bean10990 setCacheNodeType (clojure.core/str v10992))))
   (clojure.core/let
    [v10992
     (:snapshot-arns m10991 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10992 :com.palletops.awaze.client-builder/undef)
     (.
      bean10990
      setSnapshotArns
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg11014] (clojure.core/str arg11014))
 v10992))))
   bean10990))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DescribeReservedCacheNodesOfferingsRequest}
describe-reserved-cache-nodes-offerings-request
  [m10994]
  (clojure.core/let
   [bean10993
    (new
     com.amazonaws.services.elasticache.model.DescribeReservedCacheNodesOfferingsRequest)]
   (clojure.core/let
    [v10995
     (:marker m10994 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10995 :com.palletops.awaze.client-builder/undef)
     (. bean10993 setMarker (clojure.core/str v10995))))
   (clojure.core/let
    [v10995
     (:product-description
      m10994
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10995 :com.palletops.awaze.client-builder/undef)
     (. bean10993 setProductDescription (clojure.core/str v10995))))
   (clojure.core/let
    [v10995
     (:max-records m10994 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10995 :com.palletops.awaze.client-builder/undef)
     (. bean10993 setMaxRecords (clojure.core/int v10995))))
   (clojure.core/let
    [v10995
     (:duration m10994 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10995 :com.palletops.awaze.client-builder/undef)
     (. bean10993 setDuration (clojure.core/str v10995))))
   (clojure.core/let
    [v10995
     (:offering-type m10994 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10995 :com.palletops.awaze.client-builder/undef)
     (. bean10993 setOfferingType (clojure.core/str v10995))))
   (clojure.core/let
    [v10995
     (:reserved-cache-nodes-offering-id
      m10994
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10995 :com.palletops.awaze.client-builder/undef)
     (.
      bean10993
      setReservedCacheNodesOfferingId
      (clojure.core/str v10995))))
   (clojure.core/let
    [v10995
     (:cache-node-type
      m10994
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10995 :com.palletops.awaze.client-builder/undef)
     (. bean10993 setCacheNodeType (clojure.core/str v10995))))
   bean10993))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.CreateSnapshotRequest}
create-snapshot-request
  [m10997]
  (clojure.core/let
   [bean10996
    (new
     com.amazonaws.services.elasticache.model.CreateSnapshotRequest)]
   (clojure.core/let
    [v10998
     (:cache-cluster-id
      m10997
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10998 :com.palletops.awaze.client-builder/undef)
     (. bean10996 setCacheClusterId (clojure.core/str v10998))))
   (clojure.core/let
    [v10998
     (:snapshot-name m10997 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10998 :com.palletops.awaze.client-builder/undef)
     (. bean10996 setSnapshotName (clojure.core/str v10998))))
   bean10996))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DeleteSnapshotRequest}
delete-snapshot-request
  [m11000]
  (clojure.core/let
   [bean10999
    (new
     com.amazonaws.services.elasticache.model.DeleteSnapshotRequest)]
   (clojure.core/let
    [v11001
     (:snapshot-name m11000 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11001 :com.palletops.awaze.client-builder/undef)
     (. bean10999 setSnapshotName (clojure.core/str v11001))))
   bean10999))
 (clojure.core/defmulti
  elasticache
  (clojure.core/fn
   elasticache
   [m__1683__auto__]
   (:fn m__1683__auto__)))
 (do
  (clojure.core/defmethod
   elasticache
   :describe-cache-parameter-groups
   [m11015]
   (clojure.core/let
    [credentials11016 (:credentials m11015) args11017 (:args m11015)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client11018
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials11016)]
     (clojure.core/case
      (clojure.core/count args11017)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11018
        describeCacheParameterGroups))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11018
        describeCacheParameterGroups
        (elasticache/describe-cache-parameter-groups-request
         (clojure.core/nth args11017 0))))))))
  (clojure.core/defn
   describe-cache-parameter-groups-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [max-records
                         marker
                         general-progress-listener
                         cache-parameter-group-name]}]]),
    :doc "Generate map for describeCacheParameterGroups, describeCacheParameterGroups"}
   ([credentials__1651__auto__]
    {:args [],
     :client :elasticache,
     :fn :describe-cache-parameter-groups,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :describe-cache-parameter-groups,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-cache-parameter-groups
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [max-records
                         marker
                         general-progress-listener
                         cache-parameter-group-name]}]]),
    :doc "Call describeCacheParameterGroups, describeCacheParameterGroups"}
   [credentials11020 & args11021]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client11022
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials11020)]
    (clojure.core/case
     (clojure.core/count args11021)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11022
       describeCacheParameterGroups))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11022
       describeCacheParameterGroups
       (elasticache/describe-cache-parameter-groups-request
        (clojure.core/nth args11021 0))))))))
 (do
  (clojure.core/defmethod
   elasticache
   :create-cache-parameter-group
   [m11023]
   (clojure.core/let
    [credentials11024 (:credentials m11023) args11025 (:args m11023)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client11026
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials11024)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11026
       createCacheParameterGroup
       (elasticache/create-cache-parameter-group-request
        (clojure.core/nth args11025 0)))))))
  (clojure.core/defn
   create-cache-parameter-group-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         description
                         cache-parameter-group-name
                         cache-parameter-group-family]}]]),
    :doc "Generate map for createCacheParameterGroup"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :create-cache-parameter-group,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-cache-parameter-group
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         description
                         cache-parameter-group-name
                         cache-parameter-group-family]}]]),
    :doc "Call createCacheParameterGroup"}
   [credentials11028 & args11029]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client11030
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials11028)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11030
      createCacheParameterGroup
      (elasticache/create-cache-parameter-group-request
       (clojure.core/nth args11029 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :revoke-cache-security-group-ingress
   [m11031]
   (clojure.core/let
    [credentials11032 (:credentials m11031) args11033 (:args m11031)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client11034
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials11032)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11034
       revokeCacheSecurityGroupIngress
       (elasticache/revoke-cache-security-group-ingress-request
        (clojure.core/nth args11033 0)))))))
  (clojure.core/defn
   revoke-cache-security-group-ingress-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         cache-security-group-name
                         ec2security-group-owner-id
                         ec2security-group-name]}]]),
    :doc "Generate map for revokeCacheSecurityGroupIngress"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :revoke-cache-security-group-ingress,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   revoke-cache-security-group-ingress
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         cache-security-group-name
                         ec2security-group-owner-id
                         ec2security-group-name]}]]),
    :doc "Call revokeCacheSecurityGroupIngress"}
   [credentials11036 & args11037]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client11038
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials11036)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11038
      revokeCacheSecurityGroupIngress
      (elasticache/revoke-cache-security-group-ingress-request
       (clojure.core/nth args11037 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :create-replication-group
   [m11039]
   (clojure.core/let
    [credentials11040 (:credentials m11039) args11041 (:args m11039)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client11042
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials11040)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11042
       createReplicationGroup
       (elasticache/create-replication-group-request
        (clojure.core/nth args11041 0)))))))
  (clojure.core/defn
   create-replication-group-map
   {:arglists (quote
               [[credentials
                 {:keys [replication-group-id
                         replication-group-description
                         primary-cluster-id
                         general-progress-listener]}]]),
    :doc "Generate map for createReplicationGroup"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :create-replication-group,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-replication-group
   {:arglists (quote
               [[credentials
                 {:keys [replication-group-id
                         replication-group-description
                         primary-cluster-id
                         general-progress-listener]}]]),
    :doc "Call createReplicationGroup"}
   [credentials11044 & args11045]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client11046
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials11044)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11046
      createReplicationGroup
      (elasticache/create-replication-group-request
       (clojure.core/nth args11045 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :describe-snapshots
   [m11047]
   (clojure.core/let
    [credentials11048 (:credentials m11047) args11049 (:args m11047)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client11050
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials11048)]
     (clojure.core/case
      (clojure.core/count args11049)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11050
        describeSnapshots
        (elasticache/describe-snapshots-request
         (clojure.core/nth args11049 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11050
        describeSnapshots))))))
  (clojure.core/defn
   describe-snapshots-map
   {:arglists (quote
               [[credentials
                 {:keys [cache-cluster-id
                         marker
                         snapshot-name
                         max-records
                         general-progress-listener
                         snapshot-source]}]
                [credentials]]),
    :doc "Generate map for describeSnapshots, describeSnapshots"}
   ([credentials__1651__auto__]
    {:args [],
     :client :elasticache,
     :fn :describe-snapshots,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :describe-snapshots,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-snapshots
   {:arglists (quote
               [[credentials
                 {:keys [cache-cluster-id
                         marker
                         snapshot-name
                         max-records
                         general-progress-listener
                         snapshot-source]}]
                [credentials]]),
    :doc "Call describeSnapshots, describeSnapshots"}
   [credentials11052 & args11053]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client11054
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials11052)]
    (clojure.core/case
     (clojure.core/count args11053)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11054
       describeSnapshots
       (elasticache/describe-snapshots-request
        (clojure.core/nth args11053 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11054
       describeSnapshots))))))
 (do
  (clojure.core/defmethod
   elasticache
   :authorize-cache-security-group-ingress
   [m11055]
   (clojure.core/let
    [credentials11056 (:credentials m11055) args11057 (:args m11055)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client11058
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials11056)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11058
       authorizeCacheSecurityGroupIngress
       (elasticache/authorize-cache-security-group-ingress-request
        (clojure.core/nth args11057 0)))))))
  (clojure.core/defn
   authorize-cache-security-group-ingress-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         cache-security-group-name
                         ec2security-group-owner-id
                         ec2security-group-name]}]]),
    :doc "Generate map for authorizeCacheSecurityGroupIngress"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :authorize-cache-security-group-ingress,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   authorize-cache-security-group-ingress
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         cache-security-group-name
                         ec2security-group-owner-id
                         ec2security-group-name]}]]),
    :doc "Call authorizeCacheSecurityGroupIngress"}
   [credentials11060 & args11061]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client11062
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials11060)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11062
      authorizeCacheSecurityGroupIngress
      (elasticache/authorize-cache-security-group-ingress-request
       (clojure.core/nth args11061 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :describe-reserved-cache-nodes
   [m11063]
   (clojure.core/let
    [credentials11064 (:credentials m11063) args11065 (:args m11063)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client11066
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials11064)]
     (clojure.core/case
      (clojure.core/count args11065)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11066
        describeReservedCacheNodes))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11066
        describeReservedCacheNodes
        (elasticache/describe-reserved-cache-nodes-request
         (clojure.core/nth args11065 0))))))))
  (clojure.core/defn
   describe-reserved-cache-nodes-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [reserved-cache-node-id
                         duration
                         general-progress-listener
                         max-records
                         marker
                         product-description
                         offering-type
                         reserved-cache-nodes-offering-id
                         cache-node-type]}]]),
    :doc "Generate map for describeReservedCacheNodes, describeReservedCacheNodes"}
   ([credentials__1651__auto__]
    {:args [],
     :client :elasticache,
     :fn :describe-reserved-cache-nodes,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :describe-reserved-cache-nodes,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-reserved-cache-nodes
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [reserved-cache-node-id
                         duration
                         general-progress-listener
                         max-records
                         marker
                         product-description
                         offering-type
                         reserved-cache-nodes-offering-id
                         cache-node-type]}]]),
    :doc "Call describeReservedCacheNodes, describeReservedCacheNodes"}
   [credentials11068 & args11069]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client11070
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials11068)]
    (clojure.core/case
     (clojure.core/count args11069)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11070
       describeReservedCacheNodes))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11070
       describeReservedCacheNodes
       (elasticache/describe-reserved-cache-nodes-request
        (clojure.core/nth args11069 0))))))))
 (do
  (clojure.core/defmethod
   elasticache
   :modify-cache-cluster
   [m11071]
   (clojure.core/let
    [credentials11072 (:credentials m11071) args11073 (:args m11071)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client11074
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials11072)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11074
       modifyCacheCluster
       (elasticache/modify-cache-cluster-request
        (clojure.core/nth args11073 0)))))))
  (clojure.core/defn
   modify-cache-cluster-map
   {:arglists (quote
               [[credentials
                 {:keys [notification-topic-status
                         snapshot-retention-limit
                         cache-parameter-group-name
                         general-progress-listener
                         notification-topic-arn
                         cache-cluster-id
                         num-cache-nodes
                         preferred-maintenance-window
                         cache-node-ids-to-remove
                         cache-security-group-names
                         security-group-ids
                         apply-immediately
                         engine-version
                         auto-minor-version-upgrade
                         snapshot-window]}]]),
    :doc "Generate map for modifyCacheCluster"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :modify-cache-cluster,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   modify-cache-cluster
   {:arglists (quote
               [[credentials
                 {:keys [notification-topic-status
                         snapshot-retention-limit
                         cache-parameter-group-name
                         general-progress-listener
                         notification-topic-arn
                         cache-cluster-id
                         num-cache-nodes
                         preferred-maintenance-window
                         cache-node-ids-to-remove
                         cache-security-group-names
                         security-group-ids
                         apply-immediately
                         engine-version
                         auto-minor-version-upgrade
                         snapshot-window]}]]),
    :doc "Call modifyCacheCluster"}
   [credentials11076 & args11077]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client11078
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials11076)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11078
      modifyCacheCluster
      (elasticache/modify-cache-cluster-request
       (clojure.core/nth args11077 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :delete-cache-subnet-group
   [m11079]
   (clojure.core/let
    [credentials11080 (:credentials m11079) args11081 (:args m11079)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client11082
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials11080)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11082
       deleteCacheSubnetGroup
       (elasticache/delete-cache-subnet-group-request
        (clojure.core/nth args11081 0)))))))
  (clojure.core/defn
   delete-cache-subnet-group-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         cache-subnet-group-name]}]]),
    :doc "Generate map for deleteCacheSubnetGroup"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :delete-cache-subnet-group,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-cache-subnet-group
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         cache-subnet-group-name]}]]),
    :doc "Call deleteCacheSubnetGroup"}
   [credentials11084 & args11085]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client11086
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials11084)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11086
      deleteCacheSubnetGroup
      (elasticache/delete-cache-subnet-group-request
       (clojure.core/nth args11085 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :describe-cache-engine-versions
   [m11087]
   (clojure.core/let
    [credentials11088 (:credentials m11087) args11089 (:args m11087)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client11090
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials11088)]
     (clojure.core/case
      (clojure.core/count args11089)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11090
        describeCacheEngineVersions))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11090
        describeCacheEngineVersions
        (elasticache/describe-cache-engine-versions-request
         (clojure.core/nth args11089 0))))))))
  (clojure.core/defn
   describe-cache-engine-versions-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [cache-parameter-group-family
                         engine
                         general-progress-listener
                         max-records
                         marker
                         default-only
                         engine-version]}]]),
    :doc "Generate map for describeCacheEngineVersions, describeCacheEngineVersions"}
   ([credentials__1651__auto__]
    {:args [],
     :client :elasticache,
     :fn :describe-cache-engine-versions,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :describe-cache-engine-versions,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-cache-engine-versions
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [cache-parameter-group-family
                         engine
                         general-progress-listener
                         max-records
                         marker
                         default-only
                         engine-version]}]]),
    :doc "Call describeCacheEngineVersions, describeCacheEngineVersions"}
   [credentials11092 & args11093]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client11094
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials11092)]
    (clojure.core/case
     (clojure.core/count args11093)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11094
       describeCacheEngineVersions))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11094
       describeCacheEngineVersions
       (elasticache/describe-cache-engine-versions-request
        (clojure.core/nth args11093 0))))))))
 (do
  (clojure.core/defmethod
   elasticache
   :reset-cache-parameter-group
   [m11095]
   (clojure.core/let
    [credentials11096 (:credentials m11095) args11097 (:args m11095)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client11098
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials11096)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11098
       resetCacheParameterGroup
       (elasticache/reset-cache-parameter-group-request
        (clojure.core/nth args11097 0)))))))
  (clojure.core/defn
   reset-cache-parameter-group-map
   {:arglists (quote
               [[credentials
                 {:keys [reset-all-parameters
                         parameter-name-values
                         general-progress-listener
                         cache-parameter-group-name]}]]),
    :doc "Generate map for resetCacheParameterGroup"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :reset-cache-parameter-group,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   reset-cache-parameter-group
   {:arglists (quote
               [[credentials
                 {:keys [reset-all-parameters
                         parameter-name-values
                         general-progress-listener
                         cache-parameter-group-name]}]]),
    :doc "Call resetCacheParameterGroup"}
   [credentials11100 & args11101]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client11102
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials11100)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11102
      resetCacheParameterGroup
      (elasticache/reset-cache-parameter-group-request
       (clojure.core/nth args11101 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :describe-engine-default-parameters
   [m11103]
   (clojure.core/let
    [credentials11104 (:credentials m11103) args11105 (:args m11103)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client11106
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials11104)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11106
       describeEngineDefaultParameters
       (elasticache/describe-engine-default-parameters-request
        (clojure.core/nth args11105 0)))))))
  (clojure.core/defn
   describe-engine-default-parameters-map
   {:arglists (quote
               [[credentials
                 {:keys [max-records
                         marker
                         general-progress-listener
                         cache-parameter-group-family]}]]),
    :doc "Generate map for describeEngineDefaultParameters"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :describe-engine-default-parameters,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-engine-default-parameters
   {:arglists (quote
               [[credentials
                 {:keys [max-records
                         marker
                         general-progress-listener
                         cache-parameter-group-family]}]]),
    :doc "Call describeEngineDefaultParameters"}
   [credentials11108 & args11109]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client11110
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials11108)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11110
      describeEngineDefaultParameters
      (elasticache/describe-engine-default-parameters-request
       (clojure.core/nth args11109 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :delete-cache-cluster
   [m11111]
   (clojure.core/let
    [credentials11112 (:credentials m11111) args11113 (:args m11111)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client11114
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials11112)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11114
       deleteCacheCluster
       (elasticache/delete-cache-cluster-request
        (clojure.core/nth args11113 0)))))))
  (clojure.core/defn
   delete-cache-cluster-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         final-snapshot-identifier
                         cache-cluster-id]}]]),
    :doc "Generate map for deleteCacheCluster"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :delete-cache-cluster,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-cache-cluster
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         final-snapshot-identifier
                         cache-cluster-id]}]]),
    :doc "Call deleteCacheCluster"}
   [credentials11116 & args11117]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client11118
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials11116)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11118
      deleteCacheCluster
      (elasticache/delete-cache-cluster-request
       (clojure.core/nth args11117 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :describe-cache-subnet-groups
   [m11119]
   (clojure.core/let
    [credentials11120 (:credentials m11119) args11121 (:args m11119)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client11122
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials11120)]
     (clojure.core/case
      (clojure.core/count args11121)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11122
        describeCacheSubnetGroups
        (elasticache/describe-cache-subnet-groups-request
         (clojure.core/nth args11121 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11122
        describeCacheSubnetGroups))))))
  (clojure.core/defn
   describe-cache-subnet-groups-map
   {:arglists (quote
               [[credentials
                 {:keys [max-records
                         marker
                         general-progress-listener
                         cache-subnet-group-name]}]
                [credentials]]),
    :doc "Generate map for describeCacheSubnetGroups, describeCacheSubnetGroups"}
   ([credentials__1651__auto__]
    {:args [],
     :client :elasticache,
     :fn :describe-cache-subnet-groups,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :describe-cache-subnet-groups,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-cache-subnet-groups
   {:arglists (quote
               [[credentials
                 {:keys [max-records
                         marker
                         general-progress-listener
                         cache-subnet-group-name]}]
                [credentials]]),
    :doc "Call describeCacheSubnetGroups, describeCacheSubnetGroups"}
   [credentials11124 & args11125]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client11126
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials11124)]
    (clojure.core/case
     (clojure.core/count args11125)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11126
       describeCacheSubnetGroups
       (elasticache/describe-cache-subnet-groups-request
        (clojure.core/nth args11125 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11126
       describeCacheSubnetGroups))))))
 (do
  (clojure.core/defmethod
   elasticache
   :describe-replication-groups
   [m11127]
   (clojure.core/let
    [credentials11128 (:credentials m11127) args11129 (:args m11127)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client11130
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials11128)]
     (clojure.core/case
      (clojure.core/count args11129)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11130
        describeReplicationGroups
        (elasticache/describe-replication-groups-request
         (clojure.core/nth args11129 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11130
        describeReplicationGroups))))))
  (clojure.core/defn
   describe-replication-groups-map
   {:arglists (quote
               [[credentials
                 {:keys [replication-group-id
                         max-records
                         marker
                         general-progress-listener]}]
                [credentials]]),
    :doc "Generate map for describeReplicationGroups, describeReplicationGroups"}
   ([credentials__1651__auto__]
    {:args [],
     :client :elasticache,
     :fn :describe-replication-groups,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :describe-replication-groups,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-replication-groups
   {:arglists (quote
               [[credentials
                 {:keys [replication-group-id
                         max-records
                         marker
                         general-progress-listener]}]
                [credentials]]),
    :doc "Call describeReplicationGroups, describeReplicationGroups"}
   [credentials11132 & args11133]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client11134
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials11132)]
    (clojure.core/case
     (clojure.core/count args11133)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11134
       describeReplicationGroups
       (elasticache/describe-replication-groups-request
        (clojure.core/nth args11133 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11134
       describeReplicationGroups))))))
 (do
  (clojure.core/defmethod
   elasticache
   :describe-cache-security-groups
   [m11135]
   (clojure.core/let
    [credentials11136 (:credentials m11135) args11137 (:args m11135)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client11138
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials11136)]
     (clojure.core/case
      (clojure.core/count args11137)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11138
        describeCacheSecurityGroups))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11138
        describeCacheSecurityGroups
        (elasticache/describe-cache-security-groups-request
         (clojure.core/nth args11137 0))))))))
  (clojure.core/defn
   describe-cache-security-groups-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [max-records
                         marker
                         general-progress-listener
                         cache-security-group-name]}]]),
    :doc "Generate map for describeCacheSecurityGroups, describeCacheSecurityGroups"}
   ([credentials__1651__auto__]
    {:args [],
     :client :elasticache,
     :fn :describe-cache-security-groups,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :describe-cache-security-groups,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-cache-security-groups
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [max-records
                         marker
                         general-progress-listener
                         cache-security-group-name]}]]),
    :doc "Call describeCacheSecurityGroups, describeCacheSecurityGroups"}
   [credentials11140 & args11141]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client11142
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials11140)]
    (clojure.core/case
     (clojure.core/count args11141)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11142
       describeCacheSecurityGroups))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11142
       describeCacheSecurityGroups
       (elasticache/describe-cache-security-groups-request
        (clojure.core/nth args11141 0))))))))
 (do
  (clojure.core/defmethod
   elasticache
   :create-cache-security-group
   [m11143]
   (clojure.core/let
    [credentials11144 (:credentials m11143) args11145 (:args m11143)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client11146
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials11144)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11146
       createCacheSecurityGroup
       (elasticache/create-cache-security-group-request
        (clojure.core/nth args11145 0)))))))
  (clojure.core/defn
   create-cache-security-group-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         description
                         cache-security-group-name]}]]),
    :doc "Generate map for createCacheSecurityGroup"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :create-cache-security-group,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-cache-security-group
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         description
                         cache-security-group-name]}]]),
    :doc "Call createCacheSecurityGroup"}
   [credentials11148 & args11149]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client11150
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials11148)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11150
      createCacheSecurityGroup
      (elasticache/create-cache-security-group-request
       (clojure.core/nth args11149 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :describe-cache-clusters
   [m11151]
   (clojure.core/let
    [credentials11152 (:credentials m11151) args11153 (:args m11151)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client11154
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials11152)]
     (clojure.core/case
      (clojure.core/count args11153)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11154
        describeCacheClusters
        (elasticache/describe-cache-clusters-request
         (clojure.core/nth args11153 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11154
        describeCacheClusters))))))
  (clojure.core/defn
   describe-cache-clusters-map
   {:arglists (quote
               [[credentials
                 {:keys [show-cache-node-info
                         max-records
                         marker
                         general-progress-listener
                         cache-cluster-id]}]
                [credentials]]),
    :doc "Generate map for describeCacheClusters, describeCacheClusters"}
   ([credentials__1651__auto__]
    {:args [],
     :client :elasticache,
     :fn :describe-cache-clusters,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :describe-cache-clusters,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-cache-clusters
   {:arglists (quote
               [[credentials
                 {:keys [show-cache-node-info
                         max-records
                         marker
                         general-progress-listener
                         cache-cluster-id]}]
                [credentials]]),
    :doc "Call describeCacheClusters, describeCacheClusters"}
   [credentials11156 & args11157]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client11158
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials11156)]
    (clojure.core/case
     (clojure.core/count args11157)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11158
       describeCacheClusters
       (elasticache/describe-cache-clusters-request
        (clojure.core/nth args11157 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11158
       describeCacheClusters))))))
 (do
  (clojure.core/defmethod
   elasticache
   :describe-events
   [m11159]
   (clojure.core/let
    [credentials11160 (:credentials m11159) args11161 (:args m11159)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client11162
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials11160)]
     (clojure.core/case
      (clojure.core/count args11161)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11162
        describeEvents
        (elasticache/describe-events-request
         (clojure.core/nth args11161 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11162
        describeEvents))))))
  (clojure.core/defn
   describe-events-map
   {:arglists (quote
               [[credentials
                 {:keys [end-time
                         source-type
                         duration
                         general-progress-listener
                         max-records
                         start-time
                         marker
                         source-identifier]}]
                [credentials]]),
    :doc "Generate map for describeEvents, describeEvents"}
   ([credentials__1651__auto__]
    {:args [],
     :client :elasticache,
     :fn :describe-events,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :describe-events,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-events
   {:arglists (quote
               [[credentials
                 {:keys [end-time
                         source-type
                         duration
                         general-progress-listener
                         max-records
                         start-time
                         marker
                         source-identifier]}]
                [credentials]]),
    :doc "Call describeEvents, describeEvents"}
   [credentials11164 & args11165]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client11166
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials11164)]
    (clojure.core/case
     (clojure.core/count args11165)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11166
       describeEvents
       (elasticache/describe-events-request
        (clojure.core/nth args11165 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11166
       describeEvents))))))
 (do
  (clojure.core/defmethod
   elasticache
   :modify-cache-parameter-group
   [m11167]
   (clojure.core/let
    [credentials11168 (:credentials m11167) args11169 (:args m11167)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client11170
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials11168)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11170
       modifyCacheParameterGroup
       (elasticache/modify-cache-parameter-group-request
        (clojure.core/nth args11169 0)))))))
  (clojure.core/defn
   modify-cache-parameter-group-map
   {:arglists (quote
               [[credentials
                 {:keys [parameter-name-values
                         general-progress-listener
                         cache-parameter-group-name]}]]),
    :doc "Generate map for modifyCacheParameterGroup"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :modify-cache-parameter-group,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   modify-cache-parameter-group
   {:arglists (quote
               [[credentials
                 {:keys [parameter-name-values
                         general-progress-listener
                         cache-parameter-group-name]}]]),
    :doc "Call modifyCacheParameterGroup"}
   [credentials11172 & args11173]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client11174
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials11172)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11174
      modifyCacheParameterGroup
      (elasticache/modify-cache-parameter-group-request
       (clojure.core/nth args11173 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :delete-cache-security-group
   [m11175]
   (clojure.core/let
    [credentials11176 (:credentials m11175) args11177 (:args m11175)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client11178
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials11176)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11178
       deleteCacheSecurityGroup
       (elasticache/delete-cache-security-group-request
        (clojure.core/nth args11177 0)))))))
  (clojure.core/defn
   delete-cache-security-group-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         cache-security-group-name]}]]),
    :doc "Generate map for deleteCacheSecurityGroup"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :delete-cache-security-group,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-cache-security-group
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         cache-security-group-name]}]]),
    :doc "Call deleteCacheSecurityGroup"}
   [credentials11180 & args11181]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client11182
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials11180)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11182
      deleteCacheSecurityGroup
      (elasticache/delete-cache-security-group-request
       (clojure.core/nth args11181 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :create-cache-subnet-group
   [m11183]
   (clojure.core/let
    [credentials11184 (:credentials m11183) args11185 (:args m11183)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client11186
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials11184)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11186
       createCacheSubnetGroup
       (elasticache/create-cache-subnet-group-request
        (clojure.core/nth args11185 0)))))))
  (clojure.core/defn
   create-cache-subnet-group-map
   {:arglists (quote
               [[credentials
                 {:keys [subnet-ids
                         general-progress-listener
                         cache-subnet-group-name
                         cache-subnet-group-description]}]]),
    :doc "Generate map for createCacheSubnetGroup"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :create-cache-subnet-group,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-cache-subnet-group
   {:arglists (quote
               [[credentials
                 {:keys [subnet-ids
                         general-progress-listener
                         cache-subnet-group-name
                         cache-subnet-group-description]}]]),
    :doc "Call createCacheSubnetGroup"}
   [credentials11188 & args11189]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client11190
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials11188)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11190
      createCacheSubnetGroup
      (elasticache/create-cache-subnet-group-request
       (clojure.core/nth args11189 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :modify-replication-group
   [m11191]
   (clojure.core/let
    [credentials11192 (:credentials m11191) args11193 (:args m11191)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client11194
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials11192)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11194
       modifyReplicationGroup
       (elasticache/modify-replication-group-request
        (clojure.core/nth args11193 0)))))))
  (clojure.core/defn
   modify-replication-group-map
   {:arglists (quote
               [[credentials
                 {:keys [notification-topic-status
                         snapshot-retention-limit
                         cache-parameter-group-name
                         general-progress-listener
                         notification-topic-arn
                         primary-cluster-id
                         preferred-maintenance-window
                         replication-group-id
                         cache-security-group-names
                         replication-group-description
                         security-group-ids
                         apply-immediately
                         engine-version
                         snapshotting-cluster-id
                         auto-minor-version-upgrade
                         snapshot-window]}]]),
    :doc "Generate map for modifyReplicationGroup"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :modify-replication-group,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   modify-replication-group
   {:arglists (quote
               [[credentials
                 {:keys [notification-topic-status
                         snapshot-retention-limit
                         cache-parameter-group-name
                         general-progress-listener
                         notification-topic-arn
                         primary-cluster-id
                         preferred-maintenance-window
                         replication-group-id
                         cache-security-group-names
                         replication-group-description
                         security-group-ids
                         apply-immediately
                         engine-version
                         snapshotting-cluster-id
                         auto-minor-version-upgrade
                         snapshot-window]}]]),
    :doc "Call modifyReplicationGroup"}
   [credentials11196 & args11197]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client11198
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials11196)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11198
      modifyReplicationGroup
      (elasticache/modify-replication-group-request
       (clojure.core/nth args11197 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :modify-cache-subnet-group
   [m11199]
   (clojure.core/let
    [credentials11200 (:credentials m11199) args11201 (:args m11199)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client11202
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials11200)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11202
       modifyCacheSubnetGroup
       (elasticache/modify-cache-subnet-group-request
        (clojure.core/nth args11201 0)))))))
  (clojure.core/defn
   modify-cache-subnet-group-map
   {:arglists (quote
               [[credentials
                 {:keys [subnet-ids
                         general-progress-listener
                         cache-subnet-group-name
                         cache-subnet-group-description]}]]),
    :doc "Generate map for modifyCacheSubnetGroup"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :modify-cache-subnet-group,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   modify-cache-subnet-group
   {:arglists (quote
               [[credentials
                 {:keys [subnet-ids
                         general-progress-listener
                         cache-subnet-group-name
                         cache-subnet-group-description]}]]),
    :doc "Call modifyCacheSubnetGroup"}
   [credentials11204 & args11205]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client11206
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials11204)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11206
      modifyCacheSubnetGroup
      (elasticache/modify-cache-subnet-group-request
       (clojure.core/nth args11205 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :describe-cache-parameters
   [m11207]
   (clojure.core/let
    [credentials11208 (:credentials m11207) args11209 (:args m11207)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client11210
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials11208)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11210
       describeCacheParameters
       (elasticache/describe-cache-parameters-request
        (clojure.core/nth args11209 0)))))))
  (clojure.core/defn
   describe-cache-parameters-map
   {:arglists (quote
               [[credentials
                 {:keys [source
                         max-records
                         marker
                         general-progress-listener
                         cache-parameter-group-name]}]]),
    :doc "Generate map for describeCacheParameters"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :describe-cache-parameters,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-cache-parameters
   {:arglists (quote
               [[credentials
                 {:keys [source
                         max-records
                         marker
                         general-progress-listener
                         cache-parameter-group-name]}]]),
    :doc "Call describeCacheParameters"}
   [credentials11212 & args11213]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client11214
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials11212)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11214
      describeCacheParameters
      (elasticache/describe-cache-parameters-request
       (clojure.core/nth args11213 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :delete-cache-parameter-group
   [m11215]
   (clojure.core/let
    [credentials11216 (:credentials m11215) args11217 (:args m11215)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client11218
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials11216)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11218
       deleteCacheParameterGroup
       (elasticache/delete-cache-parameter-group-request
        (clojure.core/nth args11217 0)))))))
  (clojure.core/defn
   delete-cache-parameter-group-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         cache-parameter-group-name]}]]),
    :doc "Generate map for deleteCacheParameterGroup"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :delete-cache-parameter-group,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-cache-parameter-group
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         cache-parameter-group-name]}]]),
    :doc "Call deleteCacheParameterGroup"}
   [credentials11220 & args11221]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client11222
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials11220)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11222
      deleteCacheParameterGroup
      (elasticache/delete-cache-parameter-group-request
       (clojure.core/nth args11221 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :delete-replication-group
   [m11223]
   (clojure.core/let
    [credentials11224 (:credentials m11223) args11225 (:args m11223)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client11226
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials11224)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11226
       deleteReplicationGroup
       (elasticache/delete-replication-group-request
        (clojure.core/nth args11225 0)))))))
  (clojure.core/defn
   delete-replication-group-map
   {:arglists (quote
               [[credentials
                 {:keys [retain-primary-cluster
                         replication-group-id
                         general-progress-listener
                         final-snapshot-identifier]}]]),
    :doc "Generate map for deleteReplicationGroup"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :delete-replication-group,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-replication-group
   {:arglists (quote
               [[credentials
                 {:keys [retain-primary-cluster
                         replication-group-id
                         general-progress-listener
                         final-snapshot-identifier]}]]),
    :doc "Call deleteReplicationGroup"}
   [credentials11228 & args11229]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client11230
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials11228)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11230
      deleteReplicationGroup
      (elasticache/delete-replication-group-request
       (clojure.core/nth args11229 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :copy-snapshot
   [m11231]
   (clojure.core/let
    [credentials11232 (:credentials m11231) args11233 (:args m11231)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client11234
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials11232)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11234
       copySnapshot
       (elasticache/copy-snapshot-request
        (clojure.core/nth args11233 0)))))))
  (clojure.core/defn
   copy-snapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [target-snapshot-name
                         source-snapshot-name
                         general-progress-listener]}]]),
    :doc "Generate map for copySnapshot"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :copy-snapshot,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   copy-snapshot
   {:arglists (quote
               [[credentials
                 {:keys [target-snapshot-name
                         source-snapshot-name
                         general-progress-listener]}]]),
    :doc "Call copySnapshot"}
   [credentials11236 & args11237]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client11238
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials11236)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11238
      copySnapshot
      (elasticache/copy-snapshot-request
       (clojure.core/nth args11237 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :purchase-reserved-cache-nodes-offering
   [m11239]
   (clojure.core/let
    [credentials11240 (:credentials m11239) args11241 (:args m11239)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client11242
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials11240)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11242
       purchaseReservedCacheNodesOffering
       (elasticache/purchase-reserved-cache-nodes-offering-request
        (clojure.core/nth args11241 0)))))))
  (clojure.core/defn
   purchase-reserved-cache-nodes-offering-map
   {:arglists (quote
               [[credentials
                 {:keys [reserved-cache-nodes-offering-id
                         reserved-cache-node-id
                         general-progress-listener
                         cache-node-count]}]]),
    :doc "Generate map for purchaseReservedCacheNodesOffering"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :purchase-reserved-cache-nodes-offering,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   purchase-reserved-cache-nodes-offering
   {:arglists (quote
               [[credentials
                 {:keys [reserved-cache-nodes-offering-id
                         reserved-cache-node-id
                         general-progress-listener
                         cache-node-count]}]]),
    :doc "Call purchaseReservedCacheNodesOffering"}
   [credentials11244 & args11245]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client11246
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials11244)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11246
      purchaseReservedCacheNodesOffering
      (elasticache/purchase-reserved-cache-nodes-offering-request
       (clojure.core/nth args11245 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :reboot-cache-cluster
   [m11247]
   (clojure.core/let
    [credentials11248 (:credentials m11247) args11249 (:args m11247)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client11250
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials11248)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11250
       rebootCacheCluster
       (elasticache/reboot-cache-cluster-request
        (clojure.core/nth args11249 0)))))))
  (clojure.core/defn
   reboot-cache-cluster-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         cache-node-ids-to-reboot
                         cache-cluster-id]}]]),
    :doc "Generate map for rebootCacheCluster"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :reboot-cache-cluster,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   reboot-cache-cluster
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         cache-node-ids-to-reboot
                         cache-cluster-id]}]]),
    :doc "Call rebootCacheCluster"}
   [credentials11252 & args11253]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client11254
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials11252)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11254
      rebootCacheCluster
      (elasticache/reboot-cache-cluster-request
       (clojure.core/nth args11253 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :create-cache-cluster
   [m11255]
   (clojure.core/let
    [credentials11256 (:credentials m11255) args11257 (:args m11255)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client11258
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials11256)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11258
       createCacheCluster
       (elasticache/create-cache-cluster-request
        (clojure.core/nth args11257 0)))))))
  (clojure.core/defn
   create-cache-cluster-map
   {:arglists (quote
               [[credentials
                 {:keys [snapshot-retention-limit
                         engine
                         cache-parameter-group-name
                         general-progress-listener
                         notification-topic-arn
                         cache-cluster-id
                         preferred-availability-zone
                         num-cache-nodes
                         preferred-maintenance-window
                         replication-group-id
                         cache-security-group-names
                         port
                         security-group-ids
                         snapshot-arns
                         engine-version
                         snapshot-name
                         auto-minor-version-upgrade
                         cache-node-type
                         snapshot-window
                         cache-subnet-group-name]}]]),
    :doc "Generate map for createCacheCluster"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :create-cache-cluster,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-cache-cluster
   {:arglists (quote
               [[credentials
                 {:keys [snapshot-retention-limit
                         engine
                         cache-parameter-group-name
                         general-progress-listener
                         notification-topic-arn
                         cache-cluster-id
                         preferred-availability-zone
                         num-cache-nodes
                         preferred-maintenance-window
                         replication-group-id
                         cache-security-group-names
                         port
                         security-group-ids
                         snapshot-arns
                         engine-version
                         snapshot-name
                         auto-minor-version-upgrade
                         cache-node-type
                         snapshot-window
                         cache-subnet-group-name]}]]),
    :doc "Call createCacheCluster"}
   [credentials11260 & args11261]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client11262
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials11260)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11262
      createCacheCluster
      (elasticache/create-cache-cluster-request
       (clojure.core/nth args11261 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :describe-reserved-cache-nodes-offerings
   [m11263]
   (clojure.core/let
    [credentials11264 (:credentials m11263) args11265 (:args m11263)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client11266
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials11264)]
     (clojure.core/case
      (clojure.core/count args11265)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11266
        describeReservedCacheNodesOfferings))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11266
        describeReservedCacheNodesOfferings
        (elasticache/describe-reserved-cache-nodes-offerings-request
         (clojure.core/nth args11265 0))))))))
  (clojure.core/defn
   describe-reserved-cache-nodes-offerings-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [duration
                         general-progress-listener
                         max-records
                         marker
                         product-description
                         offering-type
                         reserved-cache-nodes-offering-id
                         cache-node-type]}]]),
    :doc "Generate map for describeReservedCacheNodesOfferings, describeReservedCacheNodesOfferings"}
   ([credentials__1651__auto__]
    {:args [],
     :client :elasticache,
     :fn :describe-reserved-cache-nodes-offerings,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :describe-reserved-cache-nodes-offerings,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-reserved-cache-nodes-offerings
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [duration
                         general-progress-listener
                         max-records
                         marker
                         product-description
                         offering-type
                         reserved-cache-nodes-offering-id
                         cache-node-type]}]]),
    :doc "Call describeReservedCacheNodesOfferings, describeReservedCacheNodesOfferings"}
   [credentials11268 & args11269]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client11270
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials11268)]
    (clojure.core/case
     (clojure.core/count args11269)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11270
       describeReservedCacheNodesOfferings))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11270
       describeReservedCacheNodesOfferings
       (elasticache/describe-reserved-cache-nodes-offerings-request
        (clojure.core/nth args11269 0))))))))
 (do
  (clojure.core/defmethod
   elasticache
   :create-snapshot
   [m11271]
   (clojure.core/let
    [credentials11272 (:credentials m11271) args11273 (:args m11271)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client11274
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials11272)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11274
       createSnapshot
       (elasticache/create-snapshot-request
        (clojure.core/nth args11273 0)))))))
  (clojure.core/defn
   create-snapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [snapshot-name
                         general-progress-listener
                         cache-cluster-id]}]]),
    :doc "Generate map for createSnapshot"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :create-snapshot,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-snapshot
   {:arglists (quote
               [[credentials
                 {:keys [snapshot-name
                         general-progress-listener
                         cache-cluster-id]}]]),
    :doc "Call createSnapshot"}
   [credentials11276 & args11277]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client11278
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials11276)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11278
      createSnapshot
      (elasticache/create-snapshot-request
       (clojure.core/nth args11277 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :delete-snapshot
   [m11279]
   (clojure.core/let
    [credentials11280 (:credentials m11279) args11281 (:args m11279)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client11282
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials11280)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11282
       deleteSnapshot
       (elasticache/delete-snapshot-request
        (clojure.core/nth args11281 0)))))))
  (clojure.core/defn
   delete-snapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [snapshot-name general-progress-listener]}]]),
    :doc "Generate map for deleteSnapshot"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :elasticache,
     :fn :delete-snapshot,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-snapshot
   {:arglists (quote
               [[credentials
                 {:keys [snapshot-name general-progress-listener]}]]),
    :doc "Call deleteSnapshot"}
   [credentials11284 & args11285]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client11286
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials11284)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client11286
      deleteSnapshot
      (elasticache/delete-snapshot-request
       (clojure.core/nth args11285 0))))))))
