(ns
 com.palletops.awaze.simpledb
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.simpledb :as simpledb]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :simpledb
  [___1600__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1601__auto__]
  (new
   com.amazonaws.services.simpledb.AmazonSimpleDBClient
   credentials__1601__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpledb.model.Attribute}
attribute
  [m4328]
  (clojure.core/let
   [bean4327 (new com.amazonaws.services.simpledb.model.Attribute)]
   (clojure.core/let
    [v4329 (:name m4328 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4329 :com.palletops.awaze.client-builder/undef)
     (. bean4327 setName (clojure.core/str v4329))))
   (clojure.core/let
    [v4329 (:value m4328 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4329 :com.palletops.awaze.client-builder/undef)
     (. bean4327 setValue (clojure.core/str v4329))))
   (clojure.core/let
    [v4329
     (:alternate-name-encoding
      m4328
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4329 :com.palletops.awaze.client-builder/undef)
     (. bean4327 setAlternateNameEncoding (clojure.core/str v4329))))
   (clojure.core/let
    [v4329
     (:alternate-value-encoding
      m4328
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4329 :com.palletops.awaze.client-builder/undef)
     (. bean4327 setAlternateValueEncoding (clojure.core/str v4329))))
   bean4327))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpledb.model.ReplaceableAttribute}
replaceable-attribute
  [m4331]
  (clojure.core/let
   [bean4330
    (new com.amazonaws.services.simpledb.model.ReplaceableAttribute)]
   (clojure.core/let
    [v4332 (:name m4331 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4332 :com.palletops.awaze.client-builder/undef)
     (. bean4330 setName (clojure.core/str v4332))))
   (clojure.core/let
    [v4332 (:value m4331 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4332 :com.palletops.awaze.client-builder/undef)
     (. bean4330 setValue (clojure.core/str v4332))))
   (clojure.core/let
    [v4332 (:replace m4331 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4332 :com.palletops.awaze.client-builder/undef)
     (. bean4330 setReplace (clojure.core/boolean v4332))))
   bean4330))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpledb.model.DeletableItem}
deletable-item
  [m4334]
  (clojure.core/let
   [bean4333
    (new com.amazonaws.services.simpledb.model.DeletableItem)]
   (clojure.core/let
    [v4335 (:name m4334 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4335 :com.palletops.awaze.client-builder/undef)
     (. bean4333 setName (clojure.core/str v4335))))
   (clojure.core/let
    [v4335
     (:attributes m4334 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4335 :com.palletops.awaze.client-builder/undef)
     (.
      bean4333
      setAttributes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4372] (simpledb/attribute arg4372))
 v4335))))
   bean4333))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpledb.model.UpdateCondition}
update-condition
  [m4337]
  (clojure.core/let
   [bean4336
    (new com.amazonaws.services.simpledb.model.UpdateCondition)]
   (clojure.core/let
    [v4338 (:name m4337 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4338 :com.palletops.awaze.client-builder/undef)
     (. bean4336 setName (clojure.core/str v4338))))
   (clojure.core/let
    [v4338 (:value m4337 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4338 :com.palletops.awaze.client-builder/undef)
     (. bean4336 setValue (clojure.core/str v4338))))
   (clojure.core/let
    [v4338 (:exists m4337 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4338 :com.palletops.awaze.client-builder/undef)
     (. bean4336 setExists (clojure.core/boolean v4338))))
   bean4336))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpledb.model.ReplaceableItem}
replaceable-item
  [m4340]
  (clojure.core/let
   [bean4339
    (new com.amazonaws.services.simpledb.model.ReplaceableItem)]
   (clojure.core/let
    [v4341 (:name m4340 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4341 :com.palletops.awaze.client-builder/undef)
     (. bean4339 setName (clojure.core/str v4341))))
   (clojure.core/let
    [v4341
     (:attributes m4340 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4341 :com.palletops.awaze.client-builder/undef)
     (.
      bean4339
      setAttributes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4373] (simpledb/replaceable-attribute arg4373))
 v4341))))
   bean4339))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpledb.model.DomainMetadataRequest}
domain-metadata-request
  [m4343]
  (clojure.core/let
   [bean4342
    (new com.amazonaws.services.simpledb.model.DomainMetadataRequest)]
   (clojure.core/let
    [v4344
     (:domain-name m4343 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4344 :com.palletops.awaze.client-builder/undef)
     (. bean4342 setDomainName (clojure.core/str v4344))))
   bean4342))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpledb.model.GetAttributesRequest}
get-attributes-request
  [m4346]
  (clojure.core/let
   [bean4345
    (new com.amazonaws.services.simpledb.model.GetAttributesRequest)]
   (clojure.core/let
    [v4347
     (:domain-name m4346 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4347 :com.palletops.awaze.client-builder/undef)
     (. bean4345 setDomainName (clojure.core/str v4347))))
   (clojure.core/let
    [v4347
     (:item-name m4346 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4347 :com.palletops.awaze.client-builder/undef)
     (. bean4345 setItemName (clojure.core/str v4347))))
   (clojure.core/let
    [v4347
     (:attribute-names
      m4346
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4347 :com.palletops.awaze.client-builder/undef)
     (.
      bean4345
      setAttributeNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4374] (clojure.core/str arg4374))
 v4347))))
   (clojure.core/let
    [v4347
     (:consistent-read
      m4346
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4347 :com.palletops.awaze.client-builder/undef)
     (. bean4345 setConsistentRead (clojure.core/boolean v4347))))
   bean4345))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpledb.model.CreateDomainRequest}
create-domain-request
  [m4349]
  (clojure.core/let
   [bean4348
    (new com.amazonaws.services.simpledb.model.CreateDomainRequest)]
   (clojure.core/let
    [v4350
     (:domain-name m4349 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4350 :com.palletops.awaze.client-builder/undef)
     (. bean4348 setDomainName (clojure.core/str v4350))))
   bean4348))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpledb.model.BatchDeleteAttributesRequest}
batch-delete-attributes-request
  [m4352]
  (clojure.core/let
   [bean4351
    (new
     com.amazonaws.services.simpledb.model.BatchDeleteAttributesRequest)]
   (clojure.core/let
    [v4353
     (:domain-name m4352 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4353 :com.palletops.awaze.client-builder/undef)
     (. bean4351 setDomainName (clojure.core/str v4353))))
   (clojure.core/let
    [v4353 (:items m4352 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4353 :com.palletops.awaze.client-builder/undef)
     (.
      bean4351
      setItems
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4375] (simpledb/deletable-item arg4375))
 v4353))))
   bean4351))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpledb.model.ListDomainsRequest}
list-domains-request
  [m4355]
  (clojure.core/let
   [bean4354
    (new com.amazonaws.services.simpledb.model.ListDomainsRequest)]
   (clojure.core/let
    [v4356
     (:next-token m4355 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4356 :com.palletops.awaze.client-builder/undef)
     (. bean4354 setNextToken (clojure.core/str v4356))))
   (clojure.core/let
    [v4356
     (:max-number-of-domains
      m4355
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4356 :com.palletops.awaze.client-builder/undef)
     (. bean4354 setMaxNumberOfDomains (clojure.core/int v4356))))
   bean4354))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpledb.model.PutAttributesRequest}
put-attributes-request
  [m4358]
  (clojure.core/let
   [bean4357
    (new com.amazonaws.services.simpledb.model.PutAttributesRequest)]
   (clojure.core/let
    [v4359
     (:domain-name m4358 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4359 :com.palletops.awaze.client-builder/undef)
     (. bean4357 setDomainName (clojure.core/str v4359))))
   (clojure.core/let
    [v4359
     (:item-name m4358 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4359 :com.palletops.awaze.client-builder/undef)
     (. bean4357 setItemName (clojure.core/str v4359))))
   (clojure.core/let
    [v4359
     (:expected m4358 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4359 :com.palletops.awaze.client-builder/undef)
     (. bean4357 setExpected (simpledb/update-condition v4359))))
   (clojure.core/let
    [v4359
     (:attributes m4358 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4359 :com.palletops.awaze.client-builder/undef)
     (.
      bean4357
      setAttributes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4376] (simpledb/replaceable-attribute arg4376))
 v4359))))
   bean4357))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpledb.model.DeleteAttributesRequest}
delete-attributes-request
  [m4361]
  (clojure.core/let
   [bean4360
    (new
     com.amazonaws.services.simpledb.model.DeleteAttributesRequest)]
   (clojure.core/let
    [v4362
     (:domain-name m4361 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4362 :com.palletops.awaze.client-builder/undef)
     (. bean4360 setDomainName (clojure.core/str v4362))))
   (clojure.core/let
    [v4362
     (:item-name m4361 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4362 :com.palletops.awaze.client-builder/undef)
     (. bean4360 setItemName (clojure.core/str v4362))))
   (clojure.core/let
    [v4362
     (:expected m4361 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4362 :com.palletops.awaze.client-builder/undef)
     (. bean4360 setExpected (simpledb/update-condition v4362))))
   (clojure.core/let
    [v4362
     (:attributes m4361 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4362 :com.palletops.awaze.client-builder/undef)
     (.
      bean4360
      setAttributes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4377] (simpledb/attribute arg4377))
 v4362))))
   bean4360))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpledb.model.BatchPutAttributesRequest}
batch-put-attributes-request
  [m4364]
  (clojure.core/let
   [bean4363
    (new
     com.amazonaws.services.simpledb.model.BatchPutAttributesRequest)]
   (clojure.core/let
    [v4365
     (:domain-name m4364 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4365 :com.palletops.awaze.client-builder/undef)
     (. bean4363 setDomainName (clojure.core/str v4365))))
   (clojure.core/let
    [v4365 (:items m4364 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4365 :com.palletops.awaze.client-builder/undef)
     (.
      bean4363
      setItems
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4378] (simpledb/replaceable-item arg4378))
 v4365))))
   bean4363))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpledb.model.DeleteDomainRequest}
delete-domain-request
  [m4367]
  (clojure.core/let
   [bean4366
    (new com.amazonaws.services.simpledb.model.DeleteDomainRequest)]
   (clojure.core/let
    [v4368
     (:domain-name m4367 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4368 :com.palletops.awaze.client-builder/undef)
     (. bean4366 setDomainName (clojure.core/str v4368))))
   bean4366))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpledb.model.SelectRequest}
select-request
  [m4370]
  (clojure.core/let
   [bean4369
    (new com.amazonaws.services.simpledb.model.SelectRequest)]
   (clojure.core/let
    [v4371
     (:next-token m4370 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4371 :com.palletops.awaze.client-builder/undef)
     (. bean4369 setNextToken (clojure.core/str v4371))))
   (clojure.core/let
    [v4371
     (:consistent-read
      m4370
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4371 :com.palletops.awaze.client-builder/undef)
     (. bean4369 setConsistentRead (clojure.core/boolean v4371))))
   (clojure.core/let
    [v4371
     (:select-expression
      m4370
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4371 :com.palletops.awaze.client-builder/undef)
     (. bean4369 setSelectExpression (clojure.core/str v4371))))
   bean4369))
 (clojure.core/defmulti
  simpledb
  (clojure.core/fn simpledb [m__1683__auto__] (:fn m__1683__auto__)))
 (do
  (clojure.core/defmethod
   simpledb
   :domain-metadata
   [m4379]
   (clojure.core/let
    [credentials4380 (:credentials m4379) args4381 (:args m4379)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
      client4382
      (com.palletops.awaze.common/aws-client
       :simpledb
       credentials4380)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client4382
       domainMetadata
       (simpledb/domain-metadata-request
        (clojure.core/nth args4381 0)))))))
  (clojure.core/defn
   domain-metadata-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener domain-name]}]]),
    :doc "Generate map for domainMetadata"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :simpledb,
     :fn :domain-metadata,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   domain-metadata
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener domain-name]}]]),
    :doc "Call domainMetadata"}
   [credentials4384 & args4385]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
     client4386
     (com.palletops.awaze.common/aws-client :simpledb credentials4384)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client4386
      domainMetadata
      (simpledb/domain-metadata-request (clojure.core/nth args4385 0)))))))
 (do
  (clojure.core/defmethod
   simpledb
   :get-attributes
   [m4387]
   (clojure.core/let
    [credentials4388 (:credentials m4387) args4389 (:args m4387)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
      client4390
      (com.palletops.awaze.common/aws-client
       :simpledb
       credentials4388)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client4390
       getAttributes
       (simpledb/get-attributes-request (clojure.core/nth args4389 0)))))))
  (clojure.core/defn
   get-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [item-name
                         general-progress-listener
                         domain-name
                         consistent-read
                         attribute-names]}]]),
    :doc "Generate map for getAttributes"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :simpledb,
     :fn :get-attributes,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   get-attributes
   {:arglists (quote
               [[credentials
                 {:keys [item-name
                         general-progress-listener
                         domain-name
                         consistent-read
                         attribute-names]}]]),
    :doc "Call getAttributes"}
   [credentials4392 & args4393]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
     client4394
     (com.palletops.awaze.common/aws-client :simpledb credentials4392)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client4394
      getAttributes
      (simpledb/get-attributes-request (clojure.core/nth args4393 0)))))))
 (do
  (clojure.core/defmethod
   simpledb
   :create-domain
   [m4395]
   (clojure.core/let
    [credentials4396 (:credentials m4395) args4397 (:args m4395)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
      client4398
      (com.palletops.awaze.common/aws-client
       :simpledb
       credentials4396)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client4398
       createDomain
       (simpledb/create-domain-request (clojure.core/nth args4397 0)))))))
  (clojure.core/defn
   create-domain-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener domain-name]}]]),
    :doc "Generate map for createDomain"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :simpledb,
     :fn :create-domain,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-domain
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener domain-name]}]]),
    :doc "Call createDomain"}
   [credentials4400 & args4401]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
     client4402
     (com.palletops.awaze.common/aws-client :simpledb credentials4400)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client4402
      createDomain
      (simpledb/create-domain-request (clojure.core/nth args4401 0)))))))
 (do
  (clojure.core/defmethod
   simpledb
   :batch-delete-attributes
   [m4403]
   (clojure.core/let
    [credentials4404 (:credentials m4403) args4405 (:args m4403)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
      client4406
      (com.palletops.awaze.common/aws-client
       :simpledb
       credentials4404)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client4406
       batchDeleteAttributes
       (simpledb/batch-delete-attributes-request
        (clojure.core/nth args4405 0)))))))
  (clojure.core/defn
   batch-delete-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [items general-progress-listener domain-name]}]]),
    :doc "Generate map for batchDeleteAttributes"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :simpledb,
     :fn :batch-delete-attributes,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   batch-delete-attributes
   {:arglists (quote
               [[credentials
                 {:keys [items general-progress-listener domain-name]}]]),
    :doc "Call batchDeleteAttributes"}
   [credentials4408 & args4409]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
     client4410
     (com.palletops.awaze.common/aws-client :simpledb credentials4408)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client4410
      batchDeleteAttributes
      (simpledb/batch-delete-attributes-request
       (clojure.core/nth args4409 0)))))))
 (do
  (clojure.core/defmethod
   simpledb
   :list-domains
   [m4411]
   (clojure.core/let
    [credentials4412 (:credentials m4411) args4413 (:args m4411)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
      client4414
      (com.palletops.awaze.common/aws-client
       :simpledb
       credentials4412)]
     (clojure.core/case
      (clojure.core/count args4413)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client4414
        listDomains))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client4414
        listDomains
        (simpledb/list-domains-request (clojure.core/nth args4413 0))))))))
  (clojure.core/defn
   list-domains-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [next-token
                         max-number-of-domains
                         general-progress-listener]}]]),
    :doc "Generate map for listDomains, listDomains"}
   ([credentials__1651__auto__]
    {:args [],
     :client :simpledb,
     :fn :list-domains,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :simpledb,
     :fn :list-domains,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   list-domains
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [next-token
                         max-number-of-domains
                         general-progress-listener]}]]),
    :doc "Call listDomains, listDomains"}
   [credentials4416 & args4417]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
     client4418
     (com.palletops.awaze.common/aws-client :simpledb credentials4416)]
    (clojure.core/case
     (clojure.core/count args4417)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client4418
       listDomains))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client4418
       listDomains
       (simpledb/list-domains-request (clojure.core/nth args4417 0))))))))
 (do
  (clojure.core/defmethod
   simpledb
   :put-attributes
   [m4419]
   (clojure.core/let
    [credentials4420 (:credentials m4419) args4421 (:args m4419)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
      client4422
      (com.palletops.awaze.common/aws-client
       :simpledb
       credentials4420)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client4422
       putAttributes
       (simpledb/put-attributes-request (clojure.core/nth args4421 0)))))))
  (clojure.core/defn
   put-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [item-name
                         general-progress-listener
                         expected
                         domain-name
                         attributes]}]]),
    :doc "Generate map for putAttributes"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :simpledb,
     :fn :put-attributes,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   put-attributes
   {:arglists (quote
               [[credentials
                 {:keys [item-name
                         general-progress-listener
                         expected
                         domain-name
                         attributes]}]]),
    :doc "Call putAttributes"}
   [credentials4424 & args4425]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
     client4426
     (com.palletops.awaze.common/aws-client :simpledb credentials4424)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client4426
      putAttributes
      (simpledb/put-attributes-request (clojure.core/nth args4425 0)))))))
 (do
  (clojure.core/defmethod
   simpledb
   :delete-attributes
   [m4427]
   (clojure.core/let
    [credentials4428 (:credentials m4427) args4429 (:args m4427)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
      client4430
      (com.palletops.awaze.common/aws-client
       :simpledb
       credentials4428)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client4430
       deleteAttributes
       (simpledb/delete-attributes-request
        (clojure.core/nth args4429 0)))))))
  (clojure.core/defn
   delete-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [item-name
                         general-progress-listener
                         expected
                         domain-name
                         attributes]}]]),
    :doc "Generate map for deleteAttributes"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :simpledb,
     :fn :delete-attributes,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-attributes
   {:arglists (quote
               [[credentials
                 {:keys [item-name
                         general-progress-listener
                         expected
                         domain-name
                         attributes]}]]),
    :doc "Call deleteAttributes"}
   [credentials4432 & args4433]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
     client4434
     (com.palletops.awaze.common/aws-client :simpledb credentials4432)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client4434
      deleteAttributes
      (simpledb/delete-attributes-request
       (clojure.core/nth args4433 0)))))))
 (do
  (clojure.core/defmethod
   simpledb
   :batch-put-attributes
   [m4435]
   (clojure.core/let
    [credentials4436 (:credentials m4435) args4437 (:args m4435)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
      client4438
      (com.palletops.awaze.common/aws-client
       :simpledb
       credentials4436)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client4438
       batchPutAttributes
       (simpledb/batch-put-attributes-request
        (clojure.core/nth args4437 0)))))))
  (clojure.core/defn
   batch-put-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [items general-progress-listener domain-name]}]]),
    :doc "Generate map for batchPutAttributes"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :simpledb,
     :fn :batch-put-attributes,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   batch-put-attributes
   {:arglists (quote
               [[credentials
                 {:keys [items general-progress-listener domain-name]}]]),
    :doc "Call batchPutAttributes"}
   [credentials4440 & args4441]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
     client4442
     (com.palletops.awaze.common/aws-client :simpledb credentials4440)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client4442
      batchPutAttributes
      (simpledb/batch-put-attributes-request
       (clojure.core/nth args4441 0)))))))
 (do
  (clojure.core/defmethod
   simpledb
   :delete-domain
   [m4443]
   (clojure.core/let
    [credentials4444 (:credentials m4443) args4445 (:args m4443)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
      client4446
      (com.palletops.awaze.common/aws-client
       :simpledb
       credentials4444)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client4446
       deleteDomain
       (simpledb/delete-domain-request (clojure.core/nth args4445 0)))))))
  (clojure.core/defn
   delete-domain-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener domain-name]}]]),
    :doc "Generate map for deleteDomain"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :simpledb,
     :fn :delete-domain,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-domain
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener domain-name]}]]),
    :doc "Call deleteDomain"}
   [credentials4448 & args4449]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
     client4450
     (com.palletops.awaze.common/aws-client :simpledb credentials4448)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client4450
      deleteDomain
      (simpledb/delete-domain-request (clojure.core/nth args4449 0)))))))
 (do
  (clojure.core/defmethod
   simpledb
   :select
   [m4451]
   (clojure.core/let
    [credentials4452 (:credentials m4451) args4453 (:args m4451)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
      client4454
      (com.palletops.awaze.common/aws-client
       :simpledb
       credentials4452)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client4454
       select
       (simpledb/select-request (clojure.core/nth args4453 0)))))))
  (clojure.core/defn
   select-map
   {:arglists (quote
               [[credentials
                 {:keys [select-expression
                         next-token
                         general-progress-listener
                         consistent-read]}]]),
    :doc "Generate map for select"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :simpledb,
     :fn :select,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   select
   {:arglists (quote
               [[credentials
                 {:keys [select-expression
                         next-token
                         general-progress-listener
                         consistent-read]}]]),
    :doc "Call select"}
   [credentials4456 & args4457]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
     client4458
     (com.palletops.awaze.common/aws-client :simpledb credentials4456)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client4458
      select
      (simpledb/select-request (clojure.core/nth args4457 0))))))))
