(ns
 com.palletops.awaze.sns
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.sns :as sns]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :sns
  [___1600__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1601__auto__]
  (new
   com.amazonaws.services.sns.AmazonSNSClient
   credentials__1601__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.MessageAttributeValue}
message-attribute-value
  [m3127]
  (clojure.core/let
   [bean3126
    (new com.amazonaws.services.sns.model.MessageAttributeValue)]
   (clojure.core/let
    [v3128
     (:data-type m3127 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3128 :com.palletops.awaze.client-builder/undef)
     (. bean3126 setDataType (clojure.core/str v3128))))
   (clojure.core/let
    [v3128
     (:string-value m3127 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3128 :com.palletops.awaze.client-builder/undef)
     (. bean3126 setStringValue (clojure.core/str v3128))))
   (clojure.core/let
    [v3128
     (:binary-value m3127 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3128 :com.palletops.awaze.client-builder/undef)
     (. bean3126 setBinaryValue (clojure.core/identity v3128))))
   bean3126))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.GetEndpointAttributesRequest}
get-endpoint-attributes-request
  [m3130]
  (clojure.core/let
   [bean3129
    (new
     com.amazonaws.services.sns.model.GetEndpointAttributesRequest)]
   (clojure.core/let
    [v3131
     (:endpoint-arn m3130 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3131 :com.palletops.awaze.client-builder/undef)
     (. bean3129 setEndpointArn (clojure.core/str v3131))))
   bean3129))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.GetPlatformApplicationAttributesRequest}
get-platform-application-attributes-request
  [m3133]
  (clojure.core/let
   [bean3132
    (new
     com.amazonaws.services.sns.model.GetPlatformApplicationAttributesRequest)]
   (clojure.core/let
    [v3134
     (:platform-application-arn
      m3133
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3134 :com.palletops.awaze.client-builder/undef)
     (. bean3132 setPlatformApplicationArn (clojure.core/str v3134))))
   bean3132))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.SetTopicAttributesRequest}
set-topic-attributes-request
  [m3136]
  (clojure.core/let
   [bean3135
    (new com.amazonaws.services.sns.model.SetTopicAttributesRequest)]
   (clojure.core/let
    [v3137
     (:topic-arn m3136 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3137 :com.palletops.awaze.client-builder/undef)
     (. bean3135 setTopicArn (clojure.core/str v3137))))
   (clojure.core/let
    [v3137
     (:attribute-name m3136 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3137 :com.palletops.awaze.client-builder/undef)
     (. bean3135 setAttributeName (clojure.core/str v3137))))
   (clojure.core/let
    [v3137
     (:attribute-value
      m3136
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3137 :com.palletops.awaze.client-builder/undef)
     (. bean3135 setAttributeValue (clojure.core/str v3137))))
   bean3135))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.AddPermissionRequest}
add-permission-request
  [m3139]
  (clojure.core/let
   [bean3138
    (new com.amazonaws.services.sns.model.AddPermissionRequest)]
   (clojure.core/let
    [v3140 (:label m3139 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3140 :com.palletops.awaze.client-builder/undef)
     (. bean3138 setLabel (clojure.core/str v3140))))
   (clojure.core/let
    [v3140
     (:topic-arn m3139 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3140 :com.palletops.awaze.client-builder/undef)
     (. bean3138 setTopicArn (clojure.core/str v3140))))
   (clojure.core/let
    [v3140
     (:awsaccount-ids m3139 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3140 :com.palletops.awaze.client-builder/undef)
     (.
      bean3138
      setAWSAccountIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg3204] (clojure.core/str arg3204))
 v3140))))
   (clojure.core/let
    [v3140
     (:action-names m3139 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3140 :com.palletops.awaze.client-builder/undef)
     (.
      bean3138
      setActionNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg3205] (clojure.core/str arg3205))
 v3140))))
   bean3138))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.GetSubscriptionAttributesRequest}
get-subscription-attributes-request
  [m3142]
  (clojure.core/let
   [bean3141
    (new
     com.amazonaws.services.sns.model.GetSubscriptionAttributesRequest)]
   (clojure.core/let
    [v3143
     (:subscription-arn
      m3142
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3143 :com.palletops.awaze.client-builder/undef)
     (. bean3141 setSubscriptionArn (clojure.core/str v3143))))
   bean3141))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.ConfirmSubscriptionRequest}
confirm-subscription-request
  [m3145]
  (clojure.core/let
   [bean3144
    (new com.amazonaws.services.sns.model.ConfirmSubscriptionRequest)]
   (clojure.core/let
    [v3146 (:token m3145 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3146 :com.palletops.awaze.client-builder/undef)
     (. bean3144 setToken (clojure.core/str v3146))))
   (clojure.core/let
    [v3146
     (:topic-arn m3145 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3146 :com.palletops.awaze.client-builder/undef)
     (. bean3144 setTopicArn (clojure.core/str v3146))))
   (clojure.core/let
    [v3146
     (:authenticate-on-unsubscribe
      m3145
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3146 :com.palletops.awaze.client-builder/undef)
     (.
      bean3144
      setAuthenticateOnUnsubscribe
      (clojure.core/str v3146))))
   bean3144))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.DeleteTopicRequest}
delete-topic-request
  [m3148]
  (clojure.core/let
   [bean3147
    (new com.amazonaws.services.sns.model.DeleteTopicRequest)]
   (clojure.core/let
    [v3149
     (:topic-arn m3148 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3149 :com.palletops.awaze.client-builder/undef)
     (. bean3147 setTopicArn (clojure.core/str v3149))))
   bean3147))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.PublishRequest}
publish-request
  [m3151]
  (clojure.core/let
   [bean3150 (new com.amazonaws.services.sns.model.PublishRequest)]
   (clojure.core/let
    [v3152 (:subject m3151 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3152 :com.palletops.awaze.client-builder/undef)
     (. bean3150 setSubject (clojure.core/str v3152))))
   (clojure.core/let
    [v3152
     (:topic-arn m3151 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3152 :com.palletops.awaze.client-builder/undef)
     (. bean3150 setTopicArn (clojure.core/str v3152))))
   (clojure.core/let
    [v3152
     (:target-arn m3151 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3152 :com.palletops.awaze.client-builder/undef)
     (. bean3150 setTargetArn (clojure.core/str v3152))))
   (clojure.core/let
    [v3152
     (:message-structure
      m3151
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3152 :com.palletops.awaze.client-builder/undef)
     (. bean3150 setMessageStructure (clojure.core/str v3152))))
   (clojure.core/let
    [v3152
     (:message-attributes
      m3151
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3152 :com.palletops.awaze.client-builder/undef)
     (.
      bean3150
      setMessageAttributes
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg3206] (clojure.core/str arg3206))
  (clojure.core/keys v3152))
 (clojure.core/map
  (clojure.core/fn [arg3206] (sns/message-attribute-value arg3206))
  (clojure.core/vals v3152))))))
   (clojure.core/let
    [v3152 (:message m3151 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3152 :com.palletops.awaze.client-builder/undef)
     (. bean3150 setMessage (clojure.core/str v3152))))
   bean3150))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.ListTopicsRequest}
list-topics-request
  [m3154]
  (clojure.core/let
   [bean3153 (new com.amazonaws.services.sns.model.ListTopicsRequest)]
   (clojure.core/let
    [v3155
     (:next-token m3154 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3155 :com.palletops.awaze.client-builder/undef)
     (. bean3153 setNextToken (clojure.core/str v3155))))
   bean3153))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.ListSubscriptionsByTopicRequest}
list-subscriptions-by-topic-request
  [m3157]
  (clojure.core/let
   [bean3156
    (new
     com.amazonaws.services.sns.model.ListSubscriptionsByTopicRequest)]
   (clojure.core/let
    [v3158
     (:topic-arn m3157 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3158 :com.palletops.awaze.client-builder/undef)
     (. bean3156 setTopicArn (clojure.core/str v3158))))
   (clojure.core/let
    [v3158
     (:next-token m3157 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3158 :com.palletops.awaze.client-builder/undef)
     (. bean3156 setNextToken (clojure.core/str v3158))))
   bean3156))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.DeletePlatformApplicationRequest}
delete-platform-application-request
  [m3160]
  (clojure.core/let
   [bean3159
    (new
     com.amazonaws.services.sns.model.DeletePlatformApplicationRequest)]
   (clojure.core/let
    [v3161
     (:platform-application-arn
      m3160
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3161 :com.palletops.awaze.client-builder/undef)
     (. bean3159 setPlatformApplicationArn (clojure.core/str v3161))))
   bean3159))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.ListEndpointsByPlatformApplicationRequest}
list-endpoints-by-platform-application-request
  [m3163]
  (clojure.core/let
   [bean3162
    (new
     com.amazonaws.services.sns.model.ListEndpointsByPlatformApplicationRequest)]
   (clojure.core/let
    [v3164
     (:platform-application-arn
      m3163
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3164 :com.palletops.awaze.client-builder/undef)
     (. bean3162 setPlatformApplicationArn (clojure.core/str v3164))))
   (clojure.core/let
    [v3164
     (:next-token m3163 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3164 :com.palletops.awaze.client-builder/undef)
     (. bean3162 setNextToken (clojure.core/str v3164))))
   bean3162))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.UnsubscribeRequest}
unsubscribe-request
  [m3166]
  (clojure.core/let
   [bean3165
    (new com.amazonaws.services.sns.model.UnsubscribeRequest)]
   (clojure.core/let
    [v3167
     (:subscription-arn
      m3166
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3167 :com.palletops.awaze.client-builder/undef)
     (. bean3165 setSubscriptionArn (clojure.core/str v3167))))
   bean3165))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.SetSubscriptionAttributesRequest}
set-subscription-attributes-request
  [m3169]
  (clojure.core/let
   [bean3168
    (new
     com.amazonaws.services.sns.model.SetSubscriptionAttributesRequest)]
   (clojure.core/let
    [v3170
     (:attribute-name m3169 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3170 :com.palletops.awaze.client-builder/undef)
     (. bean3168 setAttributeName (clojure.core/str v3170))))
   (clojure.core/let
    [v3170
     (:attribute-value
      m3169
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3170 :com.palletops.awaze.client-builder/undef)
     (. bean3168 setAttributeValue (clojure.core/str v3170))))
   (clojure.core/let
    [v3170
     (:subscription-arn
      m3169
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3170 :com.palletops.awaze.client-builder/undef)
     (. bean3168 setSubscriptionArn (clojure.core/str v3170))))
   bean3168))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.ListSubscriptionsRequest}
list-subscriptions-request
  [m3172]
  (clojure.core/let
   [bean3171
    (new com.amazonaws.services.sns.model.ListSubscriptionsRequest)]
   (clojure.core/let
    [v3173
     (:next-token m3172 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3173 :com.palletops.awaze.client-builder/undef)
     (. bean3171 setNextToken (clojure.core/str v3173))))
   bean3171))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.CreateTopicRequest}
create-topic-request
  [m3175]
  (clojure.core/let
   [bean3174
    (new com.amazonaws.services.sns.model.CreateTopicRequest)]
   (clojure.core/let
    [v3176 (:name m3175 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3176 :com.palletops.awaze.client-builder/undef)
     (. bean3174 setName (clojure.core/str v3176))))
   bean3174))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.CreatePlatformEndpointRequest}
create-platform-endpoint-request
  [m3178]
  (clojure.core/let
   [bean3177
    (new
     com.amazonaws.services.sns.model.CreatePlatformEndpointRequest)]
   (clojure.core/let
    [v3179 (:token m3178 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3179 :com.palletops.awaze.client-builder/undef)
     (. bean3177 setToken (clojure.core/str v3179))))
   (clojure.core/let
    [v3179
     (:platform-application-arn
      m3178
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3179 :com.palletops.awaze.client-builder/undef)
     (. bean3177 setPlatformApplicationArn (clojure.core/str v3179))))
   (clojure.core/let
    [v3179
     (:custom-user-data
      m3178
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3179 :com.palletops.awaze.client-builder/undef)
     (. bean3177 setCustomUserData (clojure.core/str v3179))))
   (clojure.core/let
    [v3179
     (:attributes m3178 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3179 :com.palletops.awaze.client-builder/undef)
     (.
      bean3177
      setAttributes
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg3207] (clojure.core/str arg3207))
  (clojure.core/keys v3179))
 (clojure.core/map
  (clojure.core/fn [arg3207] (clojure.core/str arg3207))
  (clojure.core/vals v3179))))))
   bean3177))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.RemovePermissionRequest}
remove-permission-request
  [m3181]
  (clojure.core/let
   [bean3180
    (new com.amazonaws.services.sns.model.RemovePermissionRequest)]
   (clojure.core/let
    [v3182 (:label m3181 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3182 :com.palletops.awaze.client-builder/undef)
     (. bean3180 setLabel (clojure.core/str v3182))))
   (clojure.core/let
    [v3182
     (:topic-arn m3181 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3182 :com.palletops.awaze.client-builder/undef)
     (. bean3180 setTopicArn (clojure.core/str v3182))))
   bean3180))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.GetTopicAttributesRequest}
get-topic-attributes-request
  [m3184]
  (clojure.core/let
   [bean3183
    (new com.amazonaws.services.sns.model.GetTopicAttributesRequest)]
   (clojure.core/let
    [v3185
     (:topic-arn m3184 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3185 :com.palletops.awaze.client-builder/undef)
     (. bean3183 setTopicArn (clojure.core/str v3185))))
   bean3183))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.SubscribeRequest}
subscribe-request
  [m3187]
  (clojure.core/let
   [bean3186 (new com.amazonaws.services.sns.model.SubscribeRequest)]
   (clojure.core/let
    [v3188
     (:topic-arn m3187 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3188 :com.palletops.awaze.client-builder/undef)
     (. bean3186 setTopicArn (clojure.core/str v3188))))
   (clojure.core/let
    [v3188
     (:protocol m3187 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3188 :com.palletops.awaze.client-builder/undef)
     (. bean3186 setProtocol (clojure.core/str v3188))))
   (clojure.core/let
    [v3188
     (:endpoint m3187 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3188 :com.palletops.awaze.client-builder/undef)
     (. bean3186 setEndpoint (clojure.core/str v3188))))
   bean3186))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.DeleteEndpointRequest}
delete-endpoint-request
  [m3190]
  (clojure.core/let
   [bean3189
    (new com.amazonaws.services.sns.model.DeleteEndpointRequest)]
   (clojure.core/let
    [v3191
     (:endpoint-arn m3190 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3191 :com.palletops.awaze.client-builder/undef)
     (. bean3189 setEndpointArn (clojure.core/str v3191))))
   bean3189))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.ListPlatformApplicationsRequest}
list-platform-applications-request
  [m3193]
  (clojure.core/let
   [bean3192
    (new
     com.amazonaws.services.sns.model.ListPlatformApplicationsRequest)]
   (clojure.core/let
    [v3194
     (:next-token m3193 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3194 :com.palletops.awaze.client-builder/undef)
     (. bean3192 setNextToken (clojure.core/str v3194))))
   bean3192))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.SetPlatformApplicationAttributesRequest}
set-platform-application-attributes-request
  [m3196]
  (clojure.core/let
   [bean3195
    (new
     com.amazonaws.services.sns.model.SetPlatformApplicationAttributesRequest)]
   (clojure.core/let
    [v3197
     (:platform-application-arn
      m3196
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3197 :com.palletops.awaze.client-builder/undef)
     (. bean3195 setPlatformApplicationArn (clojure.core/str v3197))))
   (clojure.core/let
    [v3197
     (:attributes m3196 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3197 :com.palletops.awaze.client-builder/undef)
     (.
      bean3195
      setAttributes
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg3208] (clojure.core/str arg3208))
  (clojure.core/keys v3197))
 (clojure.core/map
  (clojure.core/fn [arg3208] (clojure.core/str arg3208))
  (clojure.core/vals v3197))))))
   bean3195))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.CreatePlatformApplicationRequest}
create-platform-application-request
  [m3199]
  (clojure.core/let
   [bean3198
    (new
     com.amazonaws.services.sns.model.CreatePlatformApplicationRequest)]
   (clojure.core/let
    [v3200 (:name m3199 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3200 :com.palletops.awaze.client-builder/undef)
     (. bean3198 setName (clojure.core/str v3200))))
   (clojure.core/let
    [v3200
     (:platform m3199 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3200 :com.palletops.awaze.client-builder/undef)
     (. bean3198 setPlatform (clojure.core/str v3200))))
   (clojure.core/let
    [v3200
     (:attributes m3199 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3200 :com.palletops.awaze.client-builder/undef)
     (.
      bean3198
      setAttributes
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg3209] (clojure.core/str arg3209))
  (clojure.core/keys v3200))
 (clojure.core/map
  (clojure.core/fn [arg3209] (clojure.core/str arg3209))
  (clojure.core/vals v3200))))))
   bean3198))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.SetEndpointAttributesRequest}
set-endpoint-attributes-request
  [m3202]
  (clojure.core/let
   [bean3201
    (new
     com.amazonaws.services.sns.model.SetEndpointAttributesRequest)]
   (clojure.core/let
    [v3203
     (:endpoint-arn m3202 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3203 :com.palletops.awaze.client-builder/undef)
     (. bean3201 setEndpointArn (clojure.core/str v3203))))
   (clojure.core/let
    [v3203
     (:attributes m3202 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v3203 :com.palletops.awaze.client-builder/undef)
     (.
      bean3201
      setAttributes
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg3210] (clojure.core/str arg3210))
  (clojure.core/keys v3203))
 (clojure.core/map
  (clojure.core/fn [arg3210] (clojure.core/str arg3210))
  (clojure.core/vals v3203))))))
   bean3201))
 (clojure.core/defmulti
  sns
  (clojure.core/fn sns [m__1683__auto__] (:fn m__1683__auto__)))
 (do
  (clojure.core/defmethod
   sns
   :get-endpoint-attributes
   [m3211]
   (clojure.core/let
    [credentials3212 (:credentials m3211) args3213 (:args m3211)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client3214
      (com.palletops.awaze.common/aws-client :sns credentials3212)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3214
       getEndpointAttributes
       (sns/get-endpoint-attributes-request
        (clojure.core/nth args3213 0)))))))
  (clojure.core/defn
   get-endpoint-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener endpoint-arn]}]]),
    :doc "Generate map for getEndpointAttributes"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :sns,
     :fn :get-endpoint-attributes,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   get-endpoint-attributes
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener endpoint-arn]}]]),
    :doc "Call getEndpointAttributes"}
   [credentials3216 & args3217]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client3218
     (com.palletops.awaze.common/aws-client :sns credentials3216)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3218
      getEndpointAttributes
      (sns/get-endpoint-attributes-request
       (clojure.core/nth args3217 0)))))))
 (do
  (clojure.core/defmethod
   sns
   :get-platform-application-attributes
   [m3219]
   (clojure.core/let
    [credentials3220 (:credentials m3219) args3221 (:args m3219)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client3222
      (com.palletops.awaze.common/aws-client :sns credentials3220)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3222
       getPlatformApplicationAttributes
       (sns/get-platform-application-attributes-request
        (clojure.core/nth args3221 0)))))))
  (clojure.core/defn
   get-platform-application-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [platform-application-arn
                         general-progress-listener]}]]),
    :doc "Generate map for getPlatformApplicationAttributes"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :sns,
     :fn :get-platform-application-attributes,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   get-platform-application-attributes
   {:arglists (quote
               [[credentials
                 {:keys [platform-application-arn
                         general-progress-listener]}]]),
    :doc "Call getPlatformApplicationAttributes"}
   [credentials3224 & args3225]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client3226
     (com.palletops.awaze.common/aws-client :sns credentials3224)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3226
      getPlatformApplicationAttributes
      (sns/get-platform-application-attributes-request
       (clojure.core/nth args3225 0)))))))
 (do
  (clojure.core/defmethod
   sns
   :set-topic-attributes
   [m3227]
   (clojure.core/let
    [credentials3228 (:credentials m3227) args3229 (:args m3227)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client3230
      (com.palletops.awaze.common/aws-client :sns credentials3228)]
     (clojure.core/case
      (clojure.core/count args3229)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3230
        setTopicAttributes
        (sns/set-topic-attributes-request
         (clojure.core/nth args3229 0))))
      3
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3230
        setTopicAttributes
        (clojure.core/str (clojure.core/nth args3229 0))
        (clojure.core/str (clojure.core/nth args3229 1))
        (clojure.core/str (clojure.core/nth args3229 2))))))))
  (clojure.core/defn
   set-topic-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [topic-arn
                         general-progress-listener
                         attribute-value
                         attribute-name]}]
                [credentials string-0 string-1 string-2]]),
    :doc "Generate map for setTopicAttributes, setTopicAttributes"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :sns,
     :fn :set-topic-attributes,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a b c]
    {:args [a b c],
     :client :sns,
     :fn :set-topic-attributes,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   set-topic-attributes
   {:arglists (quote
               [[credentials
                 {:keys [topic-arn
                         general-progress-listener
                         attribute-value
                         attribute-name]}]
                [credentials string-0 string-1 string-2]]),
    :doc "Call setTopicAttributes, setTopicAttributes"}
   [credentials3232 & args3233]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client3234
     (com.palletops.awaze.common/aws-client :sns credentials3232)]
    (clojure.core/case
     (clojure.core/count args3233)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3234
       setTopicAttributes
       (sns/set-topic-attributes-request
        (clojure.core/nth args3233 0))))
     3
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3234
       setTopicAttributes
       (clojure.core/str (clojure.core/nth args3233 0))
       (clojure.core/str (clojure.core/nth args3233 1))
       (clojure.core/str (clojure.core/nth args3233 2))))))))
 (do
  (clojure.core/defmethod
   sns
   :add-permission
   [m3235]
   (clojure.core/let
    [credentials3236 (:credentials m3235) args3237 (:args m3235)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client3238
      (com.palletops.awaze.common/aws-client :sns credentials3236)]
     (clojure.core/case
      (clojure.core/count args3237)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3238
        addPermission
        (sns/add-permission-request (clojure.core/nth args3237 0))))
      4
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3238
        addPermission
        (clojure.core/str (clojure.core/nth args3237 0))
        (clojure.core/str (clojure.core/nth args3237 1))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg3251] (clojure.core/str arg3251))
 (clojure.core/nth args3237 2))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg3252] (clojure.core/str arg3252))
 (clojure.core/nth args3237 3))))))))
  (clojure.core/defn
   add-permission-map
   {:arglists (quote
               [[credentials
                 {:keys [topic-arn
                         label
                         general-progress-listener
                         action-names
                         awsaccount-ids]}]
                [credentials string-0 string-1 list-2 list-3]]),
    :doc "Generate map for addPermission, addPermission"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :sns,
     :fn :add-permission,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a b c d]
    {:args [a b c d],
     :client :sns,
     :fn :add-permission,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   add-permission
   {:arglists (quote
               [[credentials
                 {:keys [topic-arn
                         label
                         general-progress-listener
                         action-names
                         awsaccount-ids]}]
                [credentials string-0 string-1 list-2 list-3]]),
    :doc "Call addPermission, addPermission"}
   [credentials3240 & args3241]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client3242
     (com.palletops.awaze.common/aws-client :sns credentials3240)]
    (clojure.core/case
     (clojure.core/count args3241)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3242
       addPermission
       (sns/add-permission-request (clojure.core/nth args3241 0))))
     4
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3242
       addPermission
       (clojure.core/str (clojure.core/nth args3241 0))
       (clojure.core/str (clojure.core/nth args3241 1))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg3253] (clojure.core/str arg3253))
 (clojure.core/nth args3241 2))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg3254] (clojure.core/str arg3254))
 (clojure.core/nth args3241 3))))))))
 (do
  (clojure.core/defmethod
   sns
   :get-subscription-attributes
   [m3243]
   (clojure.core/let
    [credentials3244 (:credentials m3243) args3245 (:args m3243)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client3246
      (com.palletops.awaze.common/aws-client :sns credentials3244)]
     (clojure.core/case
      (clojure.core/count args3245)
      1
      (clojure.core/let
       [a__1626__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.sns.model.GetSubscriptionAttributesRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.sns.model.GetSubscriptionAttributesRequest
           (clojure.core/nth args3245 0))]
         (clojure.core/reset! a__1626__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3246
           getSubscriptionAttributes
           a)))
        (catch
         java.lang.Exception
         e__1627__auto__
         (if
          (clojure.core/deref a__1626__auto__)
          (throw e__1627__auto__)
          (clojure.core/let
           [a__1626__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args3245 0))]
             (clojure.core/reset! a__1626__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3246
               getSubscriptionAttributes
               a)))
            (catch
             java.lang.Exception
             e__1627__auto__
             (if
              (clojure.core/deref a__1626__auto__)
              (throw e__1627__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "getSubscriptionAttributes")
                {:args args3245}))))))))))))))
  (clojure.core/defn
   get-subscription-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [subscription-arn general-progress-listener]}]
                [credentials string-0]]),
    :doc "Generate map for getSubscriptionAttributes, getSubscriptionAttributes"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :sns,
     :fn :get-subscription-attributes,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   get-subscription-attributes
   {:arglists (quote
               [[credentials
                 {:keys [subscription-arn general-progress-listener]}]
                [credentials string-0]]),
    :doc "Call getSubscriptionAttributes, getSubscriptionAttributes"}
   [credentials3248 & args3249]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client3250
     (com.palletops.awaze.common/aws-client :sns credentials3248)]
    (clojure.core/case
     (clojure.core/count args3249)
     1
     (clojure.core/let
      [a__1626__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.sns.model.GetSubscriptionAttributesRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.sns.model.GetSubscriptionAttributesRequest
          (clojure.core/nth args3249 0))]
        (clojure.core/reset! a__1626__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3250
          getSubscriptionAttributes
          a)))
       (catch
        java.lang.Exception
        e__1627__auto__
        (if
         (clojure.core/deref a__1626__auto__)
         (throw e__1627__auto__)
         (clojure.core/let
          [a__1626__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args3249 0))]
            (clojure.core/reset! a__1626__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3250
              getSubscriptionAttributes
              a)))
           (catch
            java.lang.Exception
            e__1627__auto__
            (if
             (clojure.core/deref a__1626__auto__)
             (throw e__1627__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "getSubscriptionAttributes")
               {:args args3249}))))))))))))))
 (do
  (clojure.core/defmethod
   sns
   :confirm-subscription
   [m3255]
   (clojure.core/let
    [credentials3256 (:credentials m3255) args3257 (:args m3255)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client3258
      (com.palletops.awaze.common/aws-client :sns credentials3256)]
     (clojure.core/case
      (clojure.core/count args3257)
      3
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3258
        confirmSubscription
        (clojure.core/str (clojure.core/nth args3257 0))
        (clojure.core/str (clojure.core/nth args3257 1))
        (clojure.core/str (clojure.core/nth args3257 2))))
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3258
        confirmSubscription
        (clojure.core/str (clojure.core/nth args3257 0))
        (clojure.core/str (clojure.core/nth args3257 1))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3258
        confirmSubscription
        (sns/confirm-subscription-request
         (clojure.core/nth args3257 0))))))))
  (clojure.core/defn
   confirm-subscription-map
   {:arglists (quote
               [[credentials string-0 string-1 string-2]
                [credentials string-0 string-1]
                [credentials
                 {:keys [topic-arn
                         token
                         general-progress-listener
                         authenticate-on-unsubscribe]}]]),
    :doc "Generate map for confirmSubscription, confirmSubscription, confirmSubscription"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :sns,
     :fn :confirm-subscription,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a b]
    {:args [a b],
     :client :sns,
     :fn :confirm-subscription,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a b c]
    {:args [a b c],
     :client :sns,
     :fn :confirm-subscription,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   confirm-subscription
   {:arglists (quote
               [[credentials string-0 string-1 string-2]
                [credentials string-0 string-1]
                [credentials
                 {:keys [topic-arn
                         token
                         general-progress-listener
                         authenticate-on-unsubscribe]}]]),
    :doc "Call confirmSubscription, confirmSubscription, confirmSubscription"}
   [credentials3260 & args3261]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client3262
     (com.palletops.awaze.common/aws-client :sns credentials3260)]
    (clojure.core/case
     (clojure.core/count args3261)
     3
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3262
       confirmSubscription
       (clojure.core/str (clojure.core/nth args3261 0))
       (clojure.core/str (clojure.core/nth args3261 1))
       (clojure.core/str (clojure.core/nth args3261 2))))
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3262
       confirmSubscription
       (clojure.core/str (clojure.core/nth args3261 0))
       (clojure.core/str (clojure.core/nth args3261 1))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3262
       confirmSubscription
       (sns/confirm-subscription-request
        (clojure.core/nth args3261 0))))))))
 (do
  (clojure.core/defmethod
   sns
   :delete-topic
   [m3263]
   (clojure.core/let
    [credentials3264 (:credentials m3263) args3265 (:args m3263)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client3266
      (com.palletops.awaze.common/aws-client :sns credentials3264)]
     (clojure.core/case
      (clojure.core/count args3265)
      1
      (clojure.core/let
       [a__1626__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.sns.model.DeleteTopicRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.sns.model.DeleteTopicRequest
           (clojure.core/nth args3265 0))]
         (clojure.core/reset! a__1626__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3266
           deleteTopic
           a)))
        (catch
         java.lang.Exception
         e__1627__auto__
         (if
          (clojure.core/deref a__1626__auto__)
          (throw e__1627__auto__)
          (clojure.core/let
           [a__1626__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args3265 0))]
             (clojure.core/reset! a__1626__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3266
               deleteTopic
               a)))
            (catch
             java.lang.Exception
             e__1627__auto__
             (if
              (clojure.core/deref a__1626__auto__)
              (throw e__1627__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "deleteTopic")
                {:args args3265}))))))))))))))
  (clojure.core/defn
   delete-topic-map
   {:arglists (quote
               [[credentials
                 {:keys [topic-arn general-progress-listener]}]
                [credentials string-0]]),
    :doc "Generate map for deleteTopic, deleteTopic"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :sns,
     :fn :delete-topic,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-topic
   {:arglists (quote
               [[credentials
                 {:keys [topic-arn general-progress-listener]}]
                [credentials string-0]]),
    :doc "Call deleteTopic, deleteTopic"}
   [credentials3268 & args3269]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client3270
     (com.palletops.awaze.common/aws-client :sns credentials3268)]
    (clojure.core/case
     (clojure.core/count args3269)
     1
     (clojure.core/let
      [a__1626__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.sns.model.DeleteTopicRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.sns.model.DeleteTopicRequest
          (clojure.core/nth args3269 0))]
        (clojure.core/reset! a__1626__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3270
          deleteTopic
          a)))
       (catch
        java.lang.Exception
        e__1627__auto__
        (if
         (clojure.core/deref a__1626__auto__)
         (throw e__1627__auto__)
         (clojure.core/let
          [a__1626__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args3269 0))]
            (clojure.core/reset! a__1626__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3270
              deleteTopic
              a)))
           (catch
            java.lang.Exception
            e__1627__auto__
            (if
             (clojure.core/deref a__1626__auto__)
             (throw e__1627__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "deleteTopic")
               {:args args3269}))))))))))))))
 (do
  (clojure.core/defmethod
   sns
   :publish
   [m3271]
   (clojure.core/let
    [credentials3272 (:credentials m3271) args3273 (:args m3271)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client3274
      (com.palletops.awaze.common/aws-client :sns credentials3272)]
     (clojure.core/case
      (clojure.core/count args3273)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3274
        publish
        (sns/publish-request (clojure.core/nth args3273 0))))
      3
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3274
        publish
        (clojure.core/str (clojure.core/nth args3273 0))
        (clojure.core/str (clojure.core/nth args3273 1))
        (clojure.core/str (clojure.core/nth args3273 2))))
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3274
        publish
        (clojure.core/str (clojure.core/nth args3273 0))
        (clojure.core/str (clojure.core/nth args3273 1))))))))
  (clojure.core/defn
   publish-map
   {:arglists (quote
               [[credentials
                 {:keys [subject
                         message-structure
                         general-progress-listener
                         message-attributes
                         topic-arn
                         message
                         target-arn]}]
                [credentials string-0 string-1 string-2]
                [credentials string-0 string-1]]),
    :doc "Generate map for publish, publish, publish"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :sns,
     :fn :publish,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a b]
    {:args [a b],
     :client :sns,
     :fn :publish,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a b c]
    {:args [a b c],
     :client :sns,
     :fn :publish,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   publish
   {:arglists (quote
               [[credentials
                 {:keys [subject
                         message-structure
                         general-progress-listener
                         message-attributes
                         topic-arn
                         message
                         target-arn]}]
                [credentials string-0 string-1 string-2]
                [credentials string-0 string-1]]),
    :doc "Call publish, publish, publish"}
   [credentials3276 & args3277]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client3278
     (com.palletops.awaze.common/aws-client :sns credentials3276)]
    (clojure.core/case
     (clojure.core/count args3277)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3278
       publish
       (sns/publish-request (clojure.core/nth args3277 0))))
     3
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3278
       publish
       (clojure.core/str (clojure.core/nth args3277 0))
       (clojure.core/str (clojure.core/nth args3277 1))
       (clojure.core/str (clojure.core/nth args3277 2))))
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3278
       publish
       (clojure.core/str (clojure.core/nth args3277 0))
       (clojure.core/str (clojure.core/nth args3277 1))))))))
 (do
  (clojure.core/defmethod
   sns
   :list-topics
   [m3279]
   (clojure.core/let
    [credentials3280 (:credentials m3279) args3281 (:args m3279)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client3282
      (com.palletops.awaze.common/aws-client :sns credentials3280)]
     (clojure.core/case
      (clojure.core/count args3281)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3282
        listTopics))
      1
      (clojure.core/let
       [a__1626__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.sns.model.ListTopicsRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.sns.model.ListTopicsRequest
           (clojure.core/nth args3281 0))]
         (clojure.core/reset! a__1626__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3282
           listTopics
           a)))
        (catch
         java.lang.Exception
         e__1627__auto__
         (if
          (clojure.core/deref a__1626__auto__)
          (throw e__1627__auto__)
          (clojure.core/let
           [a__1626__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args3281 0))]
             (clojure.core/reset! a__1626__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3282
               listTopics
               a)))
            (catch
             java.lang.Exception
             e__1627__auto__
             (if
              (clojure.core/deref a__1626__auto__)
              (throw e__1627__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "listTopics")
                {:args args3281}))))))))))))))
  (clojure.core/defn
   list-topics-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [next-token general-progress-listener]}]
                [credentials string-0]]),
    :doc "Generate map for listTopics, listTopics, listTopics"}
   ([credentials__1651__auto__]
    {:args [],
     :client :sns,
     :fn :list-topics,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :sns,
     :fn :list-topics,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   list-topics
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [next-token general-progress-listener]}]
                [credentials string-0]]),
    :doc "Call listTopics, listTopics, listTopics"}
   [credentials3284 & args3285]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client3286
     (com.palletops.awaze.common/aws-client :sns credentials3284)]
    (clojure.core/case
     (clojure.core/count args3285)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3286
       listTopics))
     1
     (clojure.core/let
      [a__1626__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.sns.model.ListTopicsRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.sns.model.ListTopicsRequest
          (clojure.core/nth args3285 0))]
        (clojure.core/reset! a__1626__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3286
          listTopics
          a)))
       (catch
        java.lang.Exception
        e__1627__auto__
        (if
         (clojure.core/deref a__1626__auto__)
         (throw e__1627__auto__)
         (clojure.core/let
          [a__1626__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args3285 0))]
            (clojure.core/reset! a__1626__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3286
              listTopics
              a)))
           (catch
            java.lang.Exception
            e__1627__auto__
            (if
             (clojure.core/deref a__1626__auto__)
             (throw e__1627__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "listTopics")
               {:args args3285}))))))))))))))
 (do
  (clojure.core/defmethod
   sns
   :list-subscriptions-by-topic
   [m3287]
   (clojure.core/let
    [credentials3288 (:credentials m3287) args3289 (:args m3287)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client3290
      (com.palletops.awaze.common/aws-client :sns credentials3288)]
     (clojure.core/case
      (clojure.core/count args3289)
      1
      (clojure.core/let
       [a__1626__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.sns.model.ListSubscriptionsByTopicRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.sns.model.ListSubscriptionsByTopicRequest
           (clojure.core/nth args3289 0))]
         (clojure.core/reset! a__1626__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3290
           listSubscriptionsByTopic
           a)))
        (catch
         java.lang.Exception
         e__1627__auto__
         (if
          (clojure.core/deref a__1626__auto__)
          (throw e__1627__auto__)
          (clojure.core/let
           [a__1626__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args3289 0))]
             (clojure.core/reset! a__1626__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3290
               listSubscriptionsByTopic
               a)))
            (catch
             java.lang.Exception
             e__1627__auto__
             (if
              (clojure.core/deref a__1626__auto__)
              (throw e__1627__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "listSubscriptionsByTopic")
                {:args args3289}))))))))))
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3290
        listSubscriptionsByTopic
        (clojure.core/str (clojure.core/nth args3289 0))
        (clojure.core/str (clojure.core/nth args3289 1))))))))
  (clojure.core/defn
   list-subscriptions-by-topic-map
   {:arglists (quote
               [[credentials
                 {:keys [topic-arn
                         next-token
                         general-progress-listener]}]
                [credentials string-0 string-1]
                [credentials string-0]]),
    :doc "Generate map for listSubscriptionsByTopic, listSubscriptionsByTopic, listSubscriptionsByTopic"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :sns,
     :fn :list-subscriptions-by-topic,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a b]
    {:args [a b],
     :client :sns,
     :fn :list-subscriptions-by-topic,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   list-subscriptions-by-topic
   {:arglists (quote
               [[credentials
                 {:keys [topic-arn
                         next-token
                         general-progress-listener]}]
                [credentials string-0 string-1]
                [credentials string-0]]),
    :doc "Call listSubscriptionsByTopic, listSubscriptionsByTopic, listSubscriptionsByTopic"}
   [credentials3292 & args3293]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client3294
     (com.palletops.awaze.common/aws-client :sns credentials3292)]
    (clojure.core/case
     (clojure.core/count args3293)
     1
     (clojure.core/let
      [a__1626__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.sns.model.ListSubscriptionsByTopicRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.sns.model.ListSubscriptionsByTopicRequest
          (clojure.core/nth args3293 0))]
        (clojure.core/reset! a__1626__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3294
          listSubscriptionsByTopic
          a)))
       (catch
        java.lang.Exception
        e__1627__auto__
        (if
         (clojure.core/deref a__1626__auto__)
         (throw e__1627__auto__)
         (clojure.core/let
          [a__1626__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args3293 0))]
            (clojure.core/reset! a__1626__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3294
              listSubscriptionsByTopic
              a)))
           (catch
            java.lang.Exception
            e__1627__auto__
            (if
             (clojure.core/deref a__1626__auto__)
             (throw e__1627__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "listSubscriptionsByTopic")
               {:args args3293}))))))))))
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3294
       listSubscriptionsByTopic
       (clojure.core/str (clojure.core/nth args3293 0))
       (clojure.core/str (clojure.core/nth args3293 1))))))))
 (do
  (clojure.core/defmethod
   sns
   :delete-platform-application
   [m3295]
   (clojure.core/let
    [credentials3296 (:credentials m3295) args3297 (:args m3295)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client3298
      (com.palletops.awaze.common/aws-client :sns credentials3296)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3298
       deletePlatformApplication
       (sns/delete-platform-application-request
        (clojure.core/nth args3297 0)))))))
  (clojure.core/defn
   delete-platform-application-map
   {:arglists (quote
               [[credentials
                 {:keys [platform-application-arn
                         general-progress-listener]}]]),
    :doc "Generate map for deletePlatformApplication"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :sns,
     :fn :delete-platform-application,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-platform-application
   {:arglists (quote
               [[credentials
                 {:keys [platform-application-arn
                         general-progress-listener]}]]),
    :doc "Call deletePlatformApplication"}
   [credentials3300 & args3301]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client3302
     (com.palletops.awaze.common/aws-client :sns credentials3300)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3302
      deletePlatformApplication
      (sns/delete-platform-application-request
       (clojure.core/nth args3301 0)))))))
 (do
  (clojure.core/defmethod
   sns
   :list-endpoints-by-platform-application
   [m3303]
   (clojure.core/let
    [credentials3304 (:credentials m3303) args3305 (:args m3303)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client3306
      (com.palletops.awaze.common/aws-client :sns credentials3304)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3306
       listEndpointsByPlatformApplication
       (sns/list-endpoints-by-platform-application-request
        (clojure.core/nth args3305 0)))))))
  (clojure.core/defn
   list-endpoints-by-platform-application-map
   {:arglists (quote
               [[credentials
                 {:keys [platform-application-arn
                         next-token
                         general-progress-listener]}]]),
    :doc "Generate map for listEndpointsByPlatformApplication"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :sns,
     :fn :list-endpoints-by-platform-application,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   list-endpoints-by-platform-application
   {:arglists (quote
               [[credentials
                 {:keys [platform-application-arn
                         next-token
                         general-progress-listener]}]]),
    :doc "Call listEndpointsByPlatformApplication"}
   [credentials3308 & args3309]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client3310
     (com.palletops.awaze.common/aws-client :sns credentials3308)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3310
      listEndpointsByPlatformApplication
      (sns/list-endpoints-by-platform-application-request
       (clojure.core/nth args3309 0)))))))
 (do
  (clojure.core/defmethod
   sns
   :unsubscribe
   [m3311]
   (clojure.core/let
    [credentials3312 (:credentials m3311) args3313 (:args m3311)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client3314
      (com.palletops.awaze.common/aws-client :sns credentials3312)]
     (clojure.core/case
      (clojure.core/count args3313)
      1
      (clojure.core/let
       [a__1626__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args3313 0))]
         (clojure.core/reset! a__1626__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3314
           unsubscribe
           a)))
        (catch
         java.lang.Exception
         e__1627__auto__
         (if
          (clojure.core/deref a__1626__auto__)
          (throw e__1627__auto__)
          (clojure.core/let
           [a__1626__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag com.amazonaws.services.sns.model.UnsubscribeRequest}
              a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.sns.model.UnsubscribeRequest
               (clojure.core/nth args3313 0))]
             (clojure.core/reset! a__1626__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3314
               unsubscribe
               a)))
            (catch
             java.lang.Exception
             e__1627__auto__
             (if
              (clojure.core/deref a__1626__auto__)
              (throw e__1627__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "unsubscribe")
                {:args args3313}))))))))))))))
  (clojure.core/defn
   unsubscribe-map
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [subscription-arn general-progress-listener]}]]),
    :doc "Generate map for unsubscribe, unsubscribe"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :sns,
     :fn :unsubscribe,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   unsubscribe
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [subscription-arn general-progress-listener]}]]),
    :doc "Call unsubscribe, unsubscribe"}
   [credentials3316 & args3317]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client3318
     (com.palletops.awaze.common/aws-client :sns credentials3316)]
    (clojure.core/case
     (clojure.core/count args3317)
     1
     (clojure.core/let
      [a__1626__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args3317 0))]
        (clojure.core/reset! a__1626__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3318
          unsubscribe
          a)))
       (catch
        java.lang.Exception
        e__1627__auto__
        (if
         (clojure.core/deref a__1626__auto__)
         (throw e__1627__auto__)
         (clojure.core/let
          [a__1626__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag com.amazonaws.services.sns.model.UnsubscribeRequest}
             a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.sns.model.UnsubscribeRequest
              (clojure.core/nth args3317 0))]
            (clojure.core/reset! a__1626__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3318
              unsubscribe
              a)))
           (catch
            java.lang.Exception
            e__1627__auto__
            (if
             (clojure.core/deref a__1626__auto__)
             (throw e__1627__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "unsubscribe")
               {:args args3317}))))))))))))))
 (do
  (clojure.core/defmethod
   sns
   :set-subscription-attributes
   [m3319]
   (clojure.core/let
    [credentials3320 (:credentials m3319) args3321 (:args m3319)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client3322
      (com.palletops.awaze.common/aws-client :sns credentials3320)]
     (clojure.core/case
      (clojure.core/count args3321)
      3
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3322
        setSubscriptionAttributes
        (clojure.core/str (clojure.core/nth args3321 0))
        (clojure.core/str (clojure.core/nth args3321 1))
        (clojure.core/str (clojure.core/nth args3321 2))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3322
        setSubscriptionAttributes
        (sns/set-subscription-attributes-request
         (clojure.core/nth args3321 0))))))))
  (clojure.core/defn
   set-subscription-attributes-map
   {:arglists (quote
               [[credentials string-0 string-1 string-2]
                [credentials
                 {:keys [subscription-arn
                         general-progress-listener
                         attribute-value
                         attribute-name]}]]),
    :doc "Generate map for setSubscriptionAttributes, setSubscriptionAttributes"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :sns,
     :fn :set-subscription-attributes,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a b c]
    {:args [a b c],
     :client :sns,
     :fn :set-subscription-attributes,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   set-subscription-attributes
   {:arglists (quote
               [[credentials string-0 string-1 string-2]
                [credentials
                 {:keys [subscription-arn
                         general-progress-listener
                         attribute-value
                         attribute-name]}]]),
    :doc "Call setSubscriptionAttributes, setSubscriptionAttributes"}
   [credentials3324 & args3325]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client3326
     (com.palletops.awaze.common/aws-client :sns credentials3324)]
    (clojure.core/case
     (clojure.core/count args3325)
     3
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3326
       setSubscriptionAttributes
       (clojure.core/str (clojure.core/nth args3325 0))
       (clojure.core/str (clojure.core/nth args3325 1))
       (clojure.core/str (clojure.core/nth args3325 2))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3326
       setSubscriptionAttributes
       (sns/set-subscription-attributes-request
        (clojure.core/nth args3325 0))))))))
 (do
  (clojure.core/defmethod
   sns
   :list-subscriptions
   [m3327]
   (clojure.core/let
    [credentials3328 (:credentials m3327) args3329 (:args m3327)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client3330
      (com.palletops.awaze.common/aws-client :sns credentials3328)]
     (clojure.core/case
      (clojure.core/count args3329)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3330
        listSubscriptions))
      1
      (clojure.core/let
       [a__1626__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args3329 0))]
         (clojure.core/reset! a__1626__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3330
           listSubscriptions
           a)))
        (catch
         java.lang.Exception
         e__1627__auto__
         (if
          (clojure.core/deref a__1626__auto__)
          (throw e__1627__auto__)
          (clojure.core/let
           [a__1626__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag com.amazonaws.services.sns.model.ListSubscriptionsRequest}
              a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.sns.model.ListSubscriptionsRequest
               (clojure.core/nth args3329 0))]
             (clojure.core/reset! a__1626__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3330
               listSubscriptions
               a)))
            (catch
             java.lang.Exception
             e__1627__auto__
             (if
              (clojure.core/deref a__1626__auto__)
              (throw e__1627__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "listSubscriptions")
                {:args args3329}))))))))))))))
  (clojure.core/defn
   list-subscriptions-map
   {:arglists (quote
               [[credentials]
                [credentials string-0]
                [credentials
                 {:keys [next-token general-progress-listener]}]]),
    :doc "Generate map for listSubscriptions, listSubscriptions, listSubscriptions"}
   ([credentials__1651__auto__]
    {:args [],
     :client :sns,
     :fn :list-subscriptions,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :sns,
     :fn :list-subscriptions,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   list-subscriptions
   {:arglists (quote
               [[credentials]
                [credentials string-0]
                [credentials
                 {:keys [next-token general-progress-listener]}]]),
    :doc "Call listSubscriptions, listSubscriptions, listSubscriptions"}
   [credentials3332 & args3333]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client3334
     (com.palletops.awaze.common/aws-client :sns credentials3332)]
    (clojure.core/case
     (clojure.core/count args3333)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3334
       listSubscriptions))
     1
     (clojure.core/let
      [a__1626__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args3333 0))]
        (clojure.core/reset! a__1626__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3334
          listSubscriptions
          a)))
       (catch
        java.lang.Exception
        e__1627__auto__
        (if
         (clojure.core/deref a__1626__auto__)
         (throw e__1627__auto__)
         (clojure.core/let
          [a__1626__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag com.amazonaws.services.sns.model.ListSubscriptionsRequest}
             a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.sns.model.ListSubscriptionsRequest
              (clojure.core/nth args3333 0))]
            (clojure.core/reset! a__1626__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3334
              listSubscriptions
              a)))
           (catch
            java.lang.Exception
            e__1627__auto__
            (if
             (clojure.core/deref a__1626__auto__)
             (throw e__1627__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "listSubscriptions")
               {:args args3333}))))))))))))))
 (do
  (clojure.core/defmethod
   sns
   :create-topic
   [m3335]
   (clojure.core/let
    [credentials3336 (:credentials m3335) args3337 (:args m3335)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client3338
      (com.palletops.awaze.common/aws-client :sns credentials3336)]
     (clojure.core/case
      (clojure.core/count args3337)
      1
      (clojure.core/let
       [a__1626__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.sns.model.CreateTopicRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.sns.model.CreateTopicRequest
           (clojure.core/nth args3337 0))]
         (clojure.core/reset! a__1626__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3338
           createTopic
           a)))
        (catch
         java.lang.Exception
         e__1627__auto__
         (if
          (clojure.core/deref a__1626__auto__)
          (throw e__1627__auto__)
          (clojure.core/let
           [a__1626__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args3337 0))]
             (clojure.core/reset! a__1626__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3338
               createTopic
               a)))
            (catch
             java.lang.Exception
             e__1627__auto__
             (if
              (clojure.core/deref a__1626__auto__)
              (throw e__1627__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "createTopic")
                {:args args3337}))))))))))))))
  (clojure.core/defn
   create-topic-map
   {:arglists (quote
               [[credentials {:keys [name general-progress-listener]}]
                [credentials string-0]]),
    :doc "Generate map for createTopic, createTopic"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :sns,
     :fn :create-topic,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-topic
   {:arglists (quote
               [[credentials {:keys [name general-progress-listener]}]
                [credentials string-0]]),
    :doc "Call createTopic, createTopic"}
   [credentials3340 & args3341]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client3342
     (com.palletops.awaze.common/aws-client :sns credentials3340)]
    (clojure.core/case
     (clojure.core/count args3341)
     1
     (clojure.core/let
      [a__1626__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.sns.model.CreateTopicRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.sns.model.CreateTopicRequest
          (clojure.core/nth args3341 0))]
        (clojure.core/reset! a__1626__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3342
          createTopic
          a)))
       (catch
        java.lang.Exception
        e__1627__auto__
        (if
         (clojure.core/deref a__1626__auto__)
         (throw e__1627__auto__)
         (clojure.core/let
          [a__1626__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args3341 0))]
            (clojure.core/reset! a__1626__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3342
              createTopic
              a)))
           (catch
            java.lang.Exception
            e__1627__auto__
            (if
             (clojure.core/deref a__1626__auto__)
             (throw e__1627__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "createTopic")
               {:args args3341}))))))))))))))
 (do
  (clojure.core/defmethod
   sns
   :create-platform-endpoint
   [m3343]
   (clojure.core/let
    [credentials3344 (:credentials m3343) args3345 (:args m3343)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client3346
      (com.palletops.awaze.common/aws-client :sns credentials3344)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3346
       createPlatformEndpoint
       (sns/create-platform-endpoint-request
        (clojure.core/nth args3345 0)))))))
  (clojure.core/defn
   create-platform-endpoint-map
   {:arglists (quote
               [[credentials
                 {:keys [token
                         platform-application-arn
                         general-progress-listener
                         custom-user-data
                         attributes]}]]),
    :doc "Generate map for createPlatformEndpoint"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :sns,
     :fn :create-platform-endpoint,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-platform-endpoint
   {:arglists (quote
               [[credentials
                 {:keys [token
                         platform-application-arn
                         general-progress-listener
                         custom-user-data
                         attributes]}]]),
    :doc "Call createPlatformEndpoint"}
   [credentials3348 & args3349]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client3350
     (com.palletops.awaze.common/aws-client :sns credentials3348)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3350
      createPlatformEndpoint
      (sns/create-platform-endpoint-request
       (clojure.core/nth args3349 0)))))))
 (do
  (clojure.core/defmethod
   sns
   :remove-permission
   [m3351]
   (clojure.core/let
    [credentials3352 (:credentials m3351) args3353 (:args m3351)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client3354
      (com.palletops.awaze.common/aws-client :sns credentials3352)]
     (clojure.core/case
      (clojure.core/count args3353)
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3354
        removePermission
        (clojure.core/str (clojure.core/nth args3353 0))
        (clojure.core/str (clojure.core/nth args3353 1))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3354
        removePermission
        (sns/remove-permission-request (clojure.core/nth args3353 0))))))))
  (clojure.core/defn
   remove-permission-map
   {:arglists (quote
               [[credentials string-0 string-1]
                [credentials
                 {:keys [topic-arn label general-progress-listener]}]]),
    :doc "Generate map for removePermission, removePermission"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :sns,
     :fn :remove-permission,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a b]
    {:args [a b],
     :client :sns,
     :fn :remove-permission,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   remove-permission
   {:arglists (quote
               [[credentials string-0 string-1]
                [credentials
                 {:keys [topic-arn label general-progress-listener]}]]),
    :doc "Call removePermission, removePermission"}
   [credentials3356 & args3357]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client3358
     (com.palletops.awaze.common/aws-client :sns credentials3356)]
    (clojure.core/case
     (clojure.core/count args3357)
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3358
       removePermission
       (clojure.core/str (clojure.core/nth args3357 0))
       (clojure.core/str (clojure.core/nth args3357 1))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3358
       removePermission
       (sns/remove-permission-request (clojure.core/nth args3357 0))))))))
 (do
  (clojure.core/defmethod
   sns
   :get-topic-attributes
   [m3359]
   (clojure.core/let
    [credentials3360 (:credentials m3359) args3361 (:args m3359)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client3362
      (com.palletops.awaze.common/aws-client :sns credentials3360)]
     (clojure.core/case
      (clojure.core/count args3361)
      1
      (clojure.core/let
       [a__1626__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.sns.model.GetTopicAttributesRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.sns.model.GetTopicAttributesRequest
           (clojure.core/nth args3361 0))]
         (clojure.core/reset! a__1626__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3362
           getTopicAttributes
           a)))
        (catch
         java.lang.Exception
         e__1627__auto__
         (if
          (clojure.core/deref a__1626__auto__)
          (throw e__1627__auto__)
          (clojure.core/let
           [a__1626__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args3361 0))]
             (clojure.core/reset! a__1626__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3362
               getTopicAttributes
               a)))
            (catch
             java.lang.Exception
             e__1627__auto__
             (if
              (clojure.core/deref a__1626__auto__)
              (throw e__1627__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "getTopicAttributes")
                {:args args3361}))))))))))))))
  (clojure.core/defn
   get-topic-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [topic-arn general-progress-listener]}]
                [credentials string-0]]),
    :doc "Generate map for getTopicAttributes, getTopicAttributes"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :sns,
     :fn :get-topic-attributes,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   get-topic-attributes
   {:arglists (quote
               [[credentials
                 {:keys [topic-arn general-progress-listener]}]
                [credentials string-0]]),
    :doc "Call getTopicAttributes, getTopicAttributes"}
   [credentials3364 & args3365]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client3366
     (com.palletops.awaze.common/aws-client :sns credentials3364)]
    (clojure.core/case
     (clojure.core/count args3365)
     1
     (clojure.core/let
      [a__1626__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.sns.model.GetTopicAttributesRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.sns.model.GetTopicAttributesRequest
          (clojure.core/nth args3365 0))]
        (clojure.core/reset! a__1626__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3366
          getTopicAttributes
          a)))
       (catch
        java.lang.Exception
        e__1627__auto__
        (if
         (clojure.core/deref a__1626__auto__)
         (throw e__1627__auto__)
         (clojure.core/let
          [a__1626__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args3365 0))]
            (clojure.core/reset! a__1626__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3366
              getTopicAttributes
              a)))
           (catch
            java.lang.Exception
            e__1627__auto__
            (if
             (clojure.core/deref a__1626__auto__)
             (throw e__1627__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "getTopicAttributes")
               {:args args3365}))))))))))))))
 (do
  (clojure.core/defmethod
   sns
   :subscribe
   [m3367]
   (clojure.core/let
    [credentials3368 (:credentials m3367) args3369 (:args m3367)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client3370
      (com.palletops.awaze.common/aws-client :sns credentials3368)]
     (clojure.core/case
      (clojure.core/count args3369)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3370
        subscribe
        (sns/subscribe-request (clojure.core/nth args3369 0))))
      3
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3370
        subscribe
        (clojure.core/str (clojure.core/nth args3369 0))
        (clojure.core/str (clojure.core/nth args3369 1))
        (clojure.core/str (clojure.core/nth args3369 2))))))))
  (clojure.core/defn
   subscribe-map
   {:arglists (quote
               [[credentials
                 {:keys [topic-arn
                         protocol
                         general-progress-listener
                         endpoint]}]
                [credentials string-0 string-1 string-2]]),
    :doc "Generate map for subscribe, subscribe"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :sns,
     :fn :subscribe,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a b c]
    {:args [a b c],
     :client :sns,
     :fn :subscribe,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   subscribe
   {:arglists (quote
               [[credentials
                 {:keys [topic-arn
                         protocol
                         general-progress-listener
                         endpoint]}]
                [credentials string-0 string-1 string-2]]),
    :doc "Call subscribe, subscribe"}
   [credentials3372 & args3373]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client3374
     (com.palletops.awaze.common/aws-client :sns credentials3372)]
    (clojure.core/case
     (clojure.core/count args3373)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3374
       subscribe
       (sns/subscribe-request (clojure.core/nth args3373 0))))
     3
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3374
       subscribe
       (clojure.core/str (clojure.core/nth args3373 0))
       (clojure.core/str (clojure.core/nth args3373 1))
       (clojure.core/str (clojure.core/nth args3373 2))))))))
 (do
  (clojure.core/defmethod
   sns
   :delete-endpoint
   [m3375]
   (clojure.core/let
    [credentials3376 (:credentials m3375) args3377 (:args m3375)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client3378
      (com.palletops.awaze.common/aws-client :sns credentials3376)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3378
       deleteEndpoint
       (sns/delete-endpoint-request (clojure.core/nth args3377 0)))))))
  (clojure.core/defn
   delete-endpoint-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener endpoint-arn]}]]),
    :doc "Generate map for deleteEndpoint"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :sns,
     :fn :delete-endpoint,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-endpoint
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener endpoint-arn]}]]),
    :doc "Call deleteEndpoint"}
   [credentials3380 & args3381]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client3382
     (com.palletops.awaze.common/aws-client :sns credentials3380)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3382
      deleteEndpoint
      (sns/delete-endpoint-request (clojure.core/nth args3381 0)))))))
 (do
  (clojure.core/defmethod
   sns
   :list-platform-applications
   [m3383]
   (clojure.core/let
    [credentials3384 (:credentials m3383) args3385 (:args m3383)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client3386
      (com.palletops.awaze.common/aws-client :sns credentials3384)]
     (clojure.core/case
      (clojure.core/count args3385)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3386
        listPlatformApplications))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3386
        listPlatformApplications
        (sns/list-platform-applications-request
         (clojure.core/nth args3385 0))))))))
  (clojure.core/defn
   list-platform-applications-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [next-token general-progress-listener]}]]),
    :doc "Generate map for listPlatformApplications, listPlatformApplications"}
   ([credentials__1651__auto__]
    {:args [],
     :client :sns,
     :fn :list-platform-applications,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :sns,
     :fn :list-platform-applications,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   list-platform-applications
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [next-token general-progress-listener]}]]),
    :doc "Call listPlatformApplications, listPlatformApplications"}
   [credentials3388 & args3389]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client3390
     (com.palletops.awaze.common/aws-client :sns credentials3388)]
    (clojure.core/case
     (clojure.core/count args3389)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3390
       listPlatformApplications))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3390
       listPlatformApplications
       (sns/list-platform-applications-request
        (clojure.core/nth args3389 0))))))))
 (do
  (clojure.core/defmethod
   sns
   :set-platform-application-attributes
   [m3391]
   (clojure.core/let
    [credentials3392 (:credentials m3391) args3393 (:args m3391)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client3394
      (com.palletops.awaze.common/aws-client :sns credentials3392)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3394
       setPlatformApplicationAttributes
       (sns/set-platform-application-attributes-request
        (clojure.core/nth args3393 0)))))))
  (clojure.core/defn
   set-platform-application-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [platform-application-arn
                         general-progress-listener
                         attributes]}]]),
    :doc "Generate map for setPlatformApplicationAttributes"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :sns,
     :fn :set-platform-application-attributes,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   set-platform-application-attributes
   {:arglists (quote
               [[credentials
                 {:keys [platform-application-arn
                         general-progress-listener
                         attributes]}]]),
    :doc "Call setPlatformApplicationAttributes"}
   [credentials3396 & args3397]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client3398
     (com.palletops.awaze.common/aws-client :sns credentials3396)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3398
      setPlatformApplicationAttributes
      (sns/set-platform-application-attributes-request
       (clojure.core/nth args3397 0)))))))
 (do
  (clojure.core/defmethod
   sns
   :create-platform-application
   [m3399]
   (clojure.core/let
    [credentials3400 (:credentials m3399) args3401 (:args m3399)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client3402
      (com.palletops.awaze.common/aws-client :sns credentials3400)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3402
       createPlatformApplication
       (sns/create-platform-application-request
        (clojure.core/nth args3401 0)))))))
  (clojure.core/defn
   create-platform-application-map
   {:arglists (quote
               [[credentials
                 {:keys [platform
                         name
                         general-progress-listener
                         attributes]}]]),
    :doc "Generate map for createPlatformApplication"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :sns,
     :fn :create-platform-application,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-platform-application
   {:arglists (quote
               [[credentials
                 {:keys [platform
                         name
                         general-progress-listener
                         attributes]}]]),
    :doc "Call createPlatformApplication"}
   [credentials3404 & args3405]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client3406
     (com.palletops.awaze.common/aws-client :sns credentials3404)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3406
      createPlatformApplication
      (sns/create-platform-application-request
       (clojure.core/nth args3405 0)))))))
 (do
  (clojure.core/defmethod
   sns
   :set-endpoint-attributes
   [m3407]
   (clojure.core/let
    [credentials3408 (:credentials m3407) args3409 (:args m3407)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client3410
      (com.palletops.awaze.common/aws-client :sns credentials3408)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3410
       setEndpointAttributes
       (sns/set-endpoint-attributes-request
        (clojure.core/nth args3409 0)))))))
  (clojure.core/defn
   set-endpoint-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         endpoint-arn
                         attributes]}]]),
    :doc "Generate map for setEndpointAttributes"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :sns,
     :fn :set-endpoint-attributes,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   set-endpoint-attributes
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         endpoint-arn
                         attributes]}]]),
    :doc "Call setEndpointAttributes"}
   [credentials3412 & args3413]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client3414
     (com.palletops.awaze.common/aws-client :sns credentials3412)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client3414
      setEndpointAttributes
      (sns/set-endpoint-attributes-request
       (clojure.core/nth args3413 0))))))))
