(ns
 com.palletops.awaze.storagegateway
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.storagegateway :as storagegateway]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :storagegateway
  [___1600__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1601__auto__]
  (new
   com.amazonaws.services.storagegateway.AWSStorageGatewayClient
   credentials__1601__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DescribeMaintenanceStartTimeRequest}
describe-maintenance-start-time-request
  [m5457]
  (clojure.core/let
   [bean5456
    (new
     com.amazonaws.services.storagegateway.model.DescribeMaintenanceStartTimeRequest)]
   (clojure.core/let
    [v5458
     (:gateway-arn m5457 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5458 :com.palletops.awaze.client-builder/undef)
     (. bean5456 setGatewayARN (clojure.core/str v5458))))
   bean5456))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.UpdateBandwidthRateLimitRequest}
update-bandwidth-rate-limit-request
  [m5460]
  (clojure.core/let
   [bean5459
    (new
     com.amazonaws.services.storagegateway.model.UpdateBandwidthRateLimitRequest)]
   (clojure.core/let
    [v5461
     (:gateway-arn m5460 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5461 :com.palletops.awaze.client-builder/undef)
     (. bean5459 setGatewayARN (clojure.core/str v5461))))
   (clojure.core/let
    [v5461
     (:average-upload-rate-limit-in-bits-per-sec
      m5460
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5461 :com.palletops.awaze.client-builder/undef)
     (.
      bean5459
      setAverageUploadRateLimitInBitsPerSec
      (clojure.core/long v5461))))
   (clojure.core/let
    [v5461
     (:average-download-rate-limit-in-bits-per-sec
      m5460
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5461 :com.palletops.awaze.client-builder/undef)
     (.
      bean5459
      setAverageDownloadRateLimitInBitsPerSec
      (clojure.core/long v5461))))
   bean5459))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DescribeWorkingStorageRequest}
describe-working-storage-request
  [m5463]
  (clojure.core/let
   [bean5462
    (new
     com.amazonaws.services.storagegateway.model.DescribeWorkingStorageRequest)]
   (clojure.core/let
    [v5464
     (:gateway-arn m5463 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5464 :com.palletops.awaze.client-builder/undef)
     (. bean5462 setGatewayARN (clojure.core/str v5464))))
   bean5462))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DeleteTapeArchiveRequest}
delete-tape-archive-request
  [m5466]
  (clojure.core/let
   [bean5465
    (new
     com.amazonaws.services.storagegateway.model.DeleteTapeArchiveRequest)]
   (clojure.core/let
    [v5467
     (:tape-arn m5466 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5467 :com.palletops.awaze.client-builder/undef)
     (. bean5465 setTapeARN (clojure.core/str v5467))))
   bean5465))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DeleteSnapshotScheduleRequest}
delete-snapshot-schedule-request
  [m5469]
  (clojure.core/let
   [bean5468
    (new
     com.amazonaws.services.storagegateway.model.DeleteSnapshotScheduleRequest)]
   (clojure.core/let
    [v5470
     (:volume-arn m5469 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5470 :com.palletops.awaze.client-builder/undef)
     (. bean5468 setVolumeARN (clojure.core/str v5470))))
   bean5468))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DisableGatewayRequest}
disable-gateway-request
  [m5472]
  (clojure.core/let
   [bean5471
    (new
     com.amazonaws.services.storagegateway.model.DisableGatewayRequest)]
   (clojure.core/let
    [v5473
     (:gateway-arn m5472 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5473 :com.palletops.awaze.client-builder/undef)
     (. bean5471 setGatewayARN (clojure.core/str v5473))))
   bean5471))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DescribeChapCredentialsRequest}
describe-chap-credentials-request
  [m5475]
  (clojure.core/let
   [bean5474
    (new
     com.amazonaws.services.storagegateway.model.DescribeChapCredentialsRequest)]
   (clojure.core/let
    [v5476
     (:target-arn m5475 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5476 :com.palletops.awaze.client-builder/undef)
     (. bean5474 setTargetARN (clojure.core/str v5476))))
   bean5474))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DeleteBandwidthRateLimitRequest}
delete-bandwidth-rate-limit-request
  [m5478]
  (clojure.core/let
   [bean5477
    (new
     com.amazonaws.services.storagegateway.model.DeleteBandwidthRateLimitRequest)]
   (clojure.core/let
    [v5479
     (:gateway-arn m5478 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5479 :com.palletops.awaze.client-builder/undef)
     (. bean5477 setGatewayARN (clojure.core/str v5479))))
   (clojure.core/let
    [v5479
     (:bandwidth-type m5478 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5479 :com.palletops.awaze.client-builder/undef)
     (. bean5477 setBandwidthType (clojure.core/str v5479))))
   bean5477))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.CancelArchivalRequest}
cancel-archival-request
  [m5481]
  (clojure.core/let
   [bean5480
    (new
     com.amazonaws.services.storagegateway.model.CancelArchivalRequest)]
   (clojure.core/let
    [v5482
     (:gateway-arn m5481 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5482 :com.palletops.awaze.client-builder/undef)
     (. bean5480 setGatewayARN (clojure.core/str v5482))))
   (clojure.core/let
    [v5482
     (:tape-arn m5481 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5482 :com.palletops.awaze.client-builder/undef)
     (. bean5480 setTapeARN (clojure.core/str v5482))))
   bean5480))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.CreateCachediSCSIVolumeRequest}
create-cachedi-scsivolume-request
  [m5484]
  (clojure.core/let
   [bean5483
    (new
     com.amazonaws.services.storagegateway.model.CreateCachediSCSIVolumeRequest)]
   (clojure.core/let
    [v5485
     (:snapshot-id m5484 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5485 :com.palletops.awaze.client-builder/undef)
     (. bean5483 setSnapshotId (clojure.core/str v5485))))
   (clojure.core/let
    [v5485
     (:gateway-arn m5484 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5485 :com.palletops.awaze.client-builder/undef)
     (. bean5483 setGatewayARN (clojure.core/str v5485))))
   (clojure.core/let
    [v5485
     (:target-name m5484 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5485 :com.palletops.awaze.client-builder/undef)
     (. bean5483 setTargetName (clojure.core/str v5485))))
   (clojure.core/let
    [v5485
     (:network-interface-id
      m5484
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5485 :com.palletops.awaze.client-builder/undef)
     (. bean5483 setNetworkInterfaceId (clojure.core/str v5485))))
   (clojure.core/let
    [v5485
     (:volume-size-in-bytes
      m5484
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5485 :com.palletops.awaze.client-builder/undef)
     (. bean5483 setVolumeSizeInBytes (clojure.core/long v5485))))
   (clojure.core/let
    [v5485
     (:client-token m5484 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5485 :com.palletops.awaze.client-builder/undef)
     (. bean5483 setClientToken (clojure.core/str v5485))))
   bean5483))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.CreateSnapshotFromVolumeRecoveryPointRequest}
create-snapshot-from-volume-recovery-point-request
  [m5487]
  (clojure.core/let
   [bean5486
    (new
     com.amazonaws.services.storagegateway.model.CreateSnapshotFromVolumeRecoveryPointRequest)]
   (clojure.core/let
    [v5488
     (:volume-arn m5487 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5488 :com.palletops.awaze.client-builder/undef)
     (. bean5486 setVolumeARN (clojure.core/str v5488))))
   (clojure.core/let
    [v5488
     (:snapshot-description
      m5487
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5488 :com.palletops.awaze.client-builder/undef)
     (. bean5486 setSnapshotDescription (clojure.core/str v5488))))
   bean5486))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DescribeStorediSCSIVolumesRequest}
describe-storedi-scsivolumes-request
  [m5490]
  (clojure.core/let
   [bean5489
    (new
     com.amazonaws.services.storagegateway.model.DescribeStorediSCSIVolumesRequest)]
   (clojure.core/let
    [v5491
     (:volume-arns m5490 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5491 :com.palletops.awaze.client-builder/undef)
     (.
      bean5489
      setVolumeARNs
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5597] (clojure.core/str arg5597))
 v5491))))
   bean5489))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DescribeUploadBufferRequest}
describe-upload-buffer-request
  [m5493]
  (clojure.core/let
   [bean5492
    (new
     com.amazonaws.services.storagegateway.model.DescribeUploadBufferRequest)]
   (clojure.core/let
    [v5494
     (:gateway-arn m5493 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5494 :com.palletops.awaze.client-builder/undef)
     (. bean5492 setGatewayARN (clojure.core/str v5494))))
   bean5492))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.AddUploadBufferRequest}
add-upload-buffer-request
  [m5496]
  (clojure.core/let
   [bean5495
    (new
     com.amazonaws.services.storagegateway.model.AddUploadBufferRequest)]
   (clojure.core/let
    [v5497
     (:gateway-arn m5496 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5497 :com.palletops.awaze.client-builder/undef)
     (. bean5495 setGatewayARN (clojure.core/str v5497))))
   (clojure.core/let
    [v5497
     (:disk-ids m5496 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5497 :com.palletops.awaze.client-builder/undef)
     (.
      bean5495
      setDiskIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5598] (clojure.core/str arg5598))
 v5497))))
   bean5495))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.RetrieveTapeArchiveRequest}
retrieve-tape-archive-request
  [m5499]
  (clojure.core/let
   [bean5498
    (new
     com.amazonaws.services.storagegateway.model.RetrieveTapeArchiveRequest)]
   (clojure.core/let
    [v5500
     (:gateway-arn m5499 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5500 :com.palletops.awaze.client-builder/undef)
     (. bean5498 setGatewayARN (clojure.core/str v5500))))
   (clojure.core/let
    [v5500
     (:tape-arn m5499 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5500 :com.palletops.awaze.client-builder/undef)
     (. bean5498 setTapeARN (clojure.core/str v5500))))
   bean5498))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DescribeTapesRequest}
describe-tapes-request
  [m5502]
  (clojure.core/let
   [bean5501
    (new
     com.amazonaws.services.storagegateway.model.DescribeTapesRequest)]
   (clojure.core/let
    [v5503
     (:gateway-arn m5502 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5503 :com.palletops.awaze.client-builder/undef)
     (. bean5501 setGatewayARN (clojure.core/str v5503))))
   (clojure.core/let
    [v5503 (:marker m5502 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5503 :com.palletops.awaze.client-builder/undef)
     (. bean5501 setMarker (clojure.core/str v5503))))
   (clojure.core/let
    [v5503 (:limit m5502 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5503 :com.palletops.awaze.client-builder/undef)
     (. bean5501 setLimit (clojure.core/int v5503))))
   (clojure.core/let
    [v5503
     (:tape-arns m5502 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5503 :com.palletops.awaze.client-builder/undef)
     (.
      bean5501
      setTapeARNs
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5599] (clojure.core/str arg5599))
 v5503))))
   bean5501))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.AddWorkingStorageRequest}
add-working-storage-request
  [m5505]
  (clojure.core/let
   [bean5504
    (new
     com.amazonaws.services.storagegateway.model.AddWorkingStorageRequest)]
   (clojure.core/let
    [v5506
     (:gateway-arn m5505 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5506 :com.palletops.awaze.client-builder/undef)
     (. bean5504 setGatewayARN (clojure.core/str v5506))))
   (clojure.core/let
    [v5506
     (:disk-ids m5505 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5506 :com.palletops.awaze.client-builder/undef)
     (.
      bean5504
      setDiskIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5600] (clojure.core/str arg5600))
 v5506))))
   bean5504))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.StartGatewayRequest}
start-gateway-request
  [m5508]
  (clojure.core/let
   [bean5507
    (new
     com.amazonaws.services.storagegateway.model.StartGatewayRequest)]
   (clojure.core/let
    [v5509
     (:gateway-arn m5508 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5509 :com.palletops.awaze.client-builder/undef)
     (. bean5507 setGatewayARN (clojure.core/str v5509))))
   bean5507))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DescribeTapeRecoveryPointsRequest}
describe-tape-recovery-points-request
  [m5511]
  (clojure.core/let
   [bean5510
    (new
     com.amazonaws.services.storagegateway.model.DescribeTapeRecoveryPointsRequest)]
   (clojure.core/let
    [v5512
     (:gateway-arn m5511 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5512 :com.palletops.awaze.client-builder/undef)
     (. bean5510 setGatewayARN (clojure.core/str v5512))))
   (clojure.core/let
    [v5512 (:marker m5511 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5512 :com.palletops.awaze.client-builder/undef)
     (. bean5510 setMarker (clojure.core/str v5512))))
   (clojure.core/let
    [v5512 (:limit m5511 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5512 :com.palletops.awaze.client-builder/undef)
     (. bean5510 setLimit (clojure.core/int v5512))))
   bean5510))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.ListLocalDisksRequest}
list-local-disks-request
  [m5514]
  (clojure.core/let
   [bean5513
    (new
     com.amazonaws.services.storagegateway.model.ListLocalDisksRequest)]
   (clojure.core/let
    [v5515
     (:gateway-arn m5514 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5515 :com.palletops.awaze.client-builder/undef)
     (. bean5513 setGatewayARN (clojure.core/str v5515))))
   bean5513))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DeleteChapCredentialsRequest}
delete-chap-credentials-request
  [m5517]
  (clojure.core/let
   [bean5516
    (new
     com.amazonaws.services.storagegateway.model.DeleteChapCredentialsRequest)]
   (clojure.core/let
    [v5518
     (:target-arn m5517 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5518 :com.palletops.awaze.client-builder/undef)
     (. bean5516 setTargetARN (clojure.core/str v5518))))
   (clojure.core/let
    [v5518
     (:initiator-name m5517 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5518 :com.palletops.awaze.client-builder/undef)
     (. bean5516 setInitiatorName (clojure.core/str v5518))))
   bean5516))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.UpdateMaintenanceStartTimeRequest}
update-maintenance-start-time-request
  [m5520]
  (clojure.core/let
   [bean5519
    (new
     com.amazonaws.services.storagegateway.model.UpdateMaintenanceStartTimeRequest)]
   (clojure.core/let
    [v5521
     (:hour-of-day m5520 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5521 :com.palletops.awaze.client-builder/undef)
     (. bean5519 setHourOfDay (clojure.core/int v5521))))
   (clojure.core/let
    [v5521
     (:minute-of-hour m5520 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5521 :com.palletops.awaze.client-builder/undef)
     (. bean5519 setMinuteOfHour (clojure.core/int v5521))))
   (clojure.core/let
    [v5521
     (:gateway-arn m5520 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5521 :com.palletops.awaze.client-builder/undef)
     (. bean5519 setGatewayARN (clojure.core/str v5521))))
   (clojure.core/let
    [v5521
     (:day-of-week m5520 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5521 :com.palletops.awaze.client-builder/undef)
     (. bean5519 setDayOfWeek (clojure.core/int v5521))))
   bean5519))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.AddCacheRequest}
add-cache-request
  [m5523]
  (clojure.core/let
   [bean5522
    (new com.amazonaws.services.storagegateway.model.AddCacheRequest)]
   (clojure.core/let
    [v5524
     (:gateway-arn m5523 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5524 :com.palletops.awaze.client-builder/undef)
     (. bean5522 setGatewayARN (clojure.core/str v5524))))
   (clojure.core/let
    [v5524
     (:disk-ids m5523 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5524 :com.palletops.awaze.client-builder/undef)
     (.
      bean5522
      setDiskIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5601] (clojure.core/str arg5601))
 v5524))))
   bean5522))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DescribeCachediSCSIVolumesRequest}
describe-cachedi-scsivolumes-request
  [m5526]
  (clojure.core/let
   [bean5525
    (new
     com.amazonaws.services.storagegateway.model.DescribeCachediSCSIVolumesRequest)]
   (clojure.core/let
    [v5527
     (:volume-arns m5526 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5527 :com.palletops.awaze.client-builder/undef)
     (.
      bean5525
      setVolumeARNs
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5602] (clojure.core/str arg5602))
 v5527))))
   bean5525))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DescribeBandwidthRateLimitRequest}
describe-bandwidth-rate-limit-request
  [m5529]
  (clojure.core/let
   [bean5528
    (new
     com.amazonaws.services.storagegateway.model.DescribeBandwidthRateLimitRequest)]
   (clojure.core/let
    [v5530
     (:gateway-arn m5529 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5530 :com.palletops.awaze.client-builder/undef)
     (. bean5528 setGatewayARN (clojure.core/str v5530))))
   bean5528))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.ListVolumesRequest}
list-volumes-request
  [m5532]
  (clojure.core/let
   [bean5531
    (new
     com.amazonaws.services.storagegateway.model.ListVolumesRequest)]
   (clojure.core/let
    [v5533
     (:gateway-arn m5532 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5533 :com.palletops.awaze.client-builder/undef)
     (. bean5531 setGatewayARN (clojure.core/str v5533))))
   (clojure.core/let
    [v5533 (:marker m5532 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5533 :com.palletops.awaze.client-builder/undef)
     (. bean5531 setMarker (clojure.core/str v5533))))
   (clojure.core/let
    [v5533 (:limit m5532 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5533 :com.palletops.awaze.client-builder/undef)
     (. bean5531 setLimit (clojure.core/int v5533))))
   bean5531))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.CreateTapesRequest}
create-tapes-request
  [m5535]
  (clojure.core/let
   [bean5534
    (new
     com.amazonaws.services.storagegateway.model.CreateTapesRequest)]
   (clojure.core/let
    [v5536
     (:gateway-arn m5535 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5536 :com.palletops.awaze.client-builder/undef)
     (. bean5534 setGatewayARN (clojure.core/str v5536))))
   (clojure.core/let
    [v5536
     (:tape-size-in-bytes
      m5535
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5536 :com.palletops.awaze.client-builder/undef)
     (. bean5534 setTapeSizeInBytes (clojure.core/long v5536))))
   (clojure.core/let
    [v5536
     (:client-token m5535 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5536 :com.palletops.awaze.client-builder/undef)
     (. bean5534 setClientToken (clojure.core/str v5536))))
   (clojure.core/let
    [v5536
     (:num-tapes-to-create
      m5535
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5536 :com.palletops.awaze.client-builder/undef)
     (. bean5534 setNumTapesToCreate (clojure.core/int v5536))))
   (clojure.core/let
    [v5536
     (:tape-barcode-prefix
      m5535
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5536 :com.palletops.awaze.client-builder/undef)
     (. bean5534 setTapeBarcodePrefix (clojure.core/str v5536))))
   bean5534))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.ActivateGatewayRequest}
activate-gateway-request
  [m5538]
  (clojure.core/let
   [bean5537
    (new
     com.amazonaws.services.storagegateway.model.ActivateGatewayRequest)]
   (clojure.core/let
    [v5539
     (:activation-key m5538 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5539 :com.palletops.awaze.client-builder/undef)
     (. bean5537 setActivationKey (clojure.core/str v5539))))
   (clojure.core/let
    [v5539
     (:gateway-name m5538 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5539 :com.palletops.awaze.client-builder/undef)
     (. bean5537 setGatewayName (clojure.core/str v5539))))
   (clojure.core/let
    [v5539
     (:gateway-timezone
      m5538
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5539 :com.palletops.awaze.client-builder/undef)
     (. bean5537 setGatewayTimezone (clojure.core/str v5539))))
   (clojure.core/let
    [v5539
     (:gateway-region m5538 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5539 :com.palletops.awaze.client-builder/undef)
     (. bean5537 setGatewayRegion (clojure.core/str v5539))))
   (clojure.core/let
    [v5539
     (:gateway-type m5538 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5539 :com.palletops.awaze.client-builder/undef)
     (. bean5537 setGatewayType (clojure.core/str v5539))))
   (clojure.core/let
    [v5539
     (:tape-drive-type
      m5538
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5539 :com.palletops.awaze.client-builder/undef)
     (. bean5537 setTapeDriveType (clojure.core/str v5539))))
   (clojure.core/let
    [v5539
     (:medium-changer-type
      m5538
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5539 :com.palletops.awaze.client-builder/undef)
     (. bean5537 setMediumChangerType (clojure.core/str v5539))))
   bean5537))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DescribeCacheRequest}
describe-cache-request
  [m5541]
  (clojure.core/let
   [bean5540
    (new
     com.amazonaws.services.storagegateway.model.DescribeCacheRequest)]
   (clojure.core/let
    [v5542
     (:gateway-arn m5541 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5542 :com.palletops.awaze.client-builder/undef)
     (. bean5540 setGatewayARN (clojure.core/str v5542))))
   bean5540))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.UpdateGatewaySoftwareNowRequest}
update-gateway-software-now-request
  [m5544]
  (clojure.core/let
   [bean5543
    (new
     com.amazonaws.services.storagegateway.model.UpdateGatewaySoftwareNowRequest)]
   (clojure.core/let
    [v5545
     (:gateway-arn m5544 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5545 :com.palletops.awaze.client-builder/undef)
     (. bean5543 setGatewayARN (clojure.core/str v5545))))
   bean5543))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.UpdateChapCredentialsRequest}
update-chap-credentials-request
  [m5547]
  (clojure.core/let
   [bean5546
    (new
     com.amazonaws.services.storagegateway.model.UpdateChapCredentialsRequest)]
   (clojure.core/let
    [v5548
     (:target-arn m5547 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5548 :com.palletops.awaze.client-builder/undef)
     (. bean5546 setTargetARN (clojure.core/str v5548))))
   (clojure.core/let
    [v5548
     (:secret-to-authenticate-initiator
      m5547
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5548 :com.palletops.awaze.client-builder/undef)
     (.
      bean5546
      setSecretToAuthenticateInitiator
      (clojure.core/str v5548))))
   (clojure.core/let
    [v5548
     (:initiator-name m5547 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5548 :com.palletops.awaze.client-builder/undef)
     (. bean5546 setInitiatorName (clojure.core/str v5548))))
   (clojure.core/let
    [v5548
     (:secret-to-authenticate-target
      m5547
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5548 :com.palletops.awaze.client-builder/undef)
     (.
      bean5546
      setSecretToAuthenticateTarget
      (clojure.core/str v5548))))
   bean5546))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DescribeTapeArchivesRequest}
describe-tape-archives-request
  [m5550]
  (clojure.core/let
   [bean5549
    (new
     com.amazonaws.services.storagegateway.model.DescribeTapeArchivesRequest)]
   (clojure.core/let
    [v5551 (:marker m5550 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5551 :com.palletops.awaze.client-builder/undef)
     (. bean5549 setMarker (clojure.core/str v5551))))
   (clojure.core/let
    [v5551 (:limit m5550 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5551 :com.palletops.awaze.client-builder/undef)
     (. bean5549 setLimit (clojure.core/int v5551))))
   (clojure.core/let
    [v5551
     (:tape-arns m5550 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5551 :com.palletops.awaze.client-builder/undef)
     (.
      bean5549
      setTapeARNs
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5603] (clojure.core/str arg5603))
 v5551))))
   bean5549))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DeleteTapeRequest}
delete-tape-request
  [m5553]
  (clojure.core/let
   [bean5552
    (new
     com.amazonaws.services.storagegateway.model.DeleteTapeRequest)]
   (clojure.core/let
    [v5554
     (:gateway-arn m5553 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5554 :com.palletops.awaze.client-builder/undef)
     (. bean5552 setGatewayARN (clojure.core/str v5554))))
   (clojure.core/let
    [v5554
     (:tape-arn m5553 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5554 :com.palletops.awaze.client-builder/undef)
     (. bean5552 setTapeARN (clojure.core/str v5554))))
   bean5552))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.RetrieveTapeRecoveryPointRequest}
retrieve-tape-recovery-point-request
  [m5556]
  (clojure.core/let
   [bean5555
    (new
     com.amazonaws.services.storagegateway.model.RetrieveTapeRecoveryPointRequest)]
   (clojure.core/let
    [v5557
     (:gateway-arn m5556 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5557 :com.palletops.awaze.client-builder/undef)
     (. bean5555 setGatewayARN (clojure.core/str v5557))))
   (clojure.core/let
    [v5557
     (:tape-arn m5556 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5557 :com.palletops.awaze.client-builder/undef)
     (. bean5555 setTapeARN (clojure.core/str v5557))))
   bean5555))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.CreateStorediSCSIVolumeRequest}
create-storedi-scsivolume-request
  [m5559]
  (clojure.core/let
   [bean5558
    (new
     com.amazonaws.services.storagegateway.model.CreateStorediSCSIVolumeRequest)]
   (clojure.core/let
    [v5560
     (:snapshot-id m5559 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5560 :com.palletops.awaze.client-builder/undef)
     (. bean5558 setSnapshotId (clojure.core/str v5560))))
   (clojure.core/let
    [v5560
     (:gateway-arn m5559 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5560 :com.palletops.awaze.client-builder/undef)
     (. bean5558 setGatewayARN (clojure.core/str v5560))))
   (clojure.core/let
    [v5560 (:disk-id m5559 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5560 :com.palletops.awaze.client-builder/undef)
     (. bean5558 setDiskId (clojure.core/str v5560))))
   (clojure.core/let
    [v5560
     (:preserve-existing-data
      m5559
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5560 :com.palletops.awaze.client-builder/undef)
     (. bean5558 setPreserveExistingData (clojure.core/boolean v5560))))
   (clojure.core/let
    [v5560
     (:target-name m5559 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5560 :com.palletops.awaze.client-builder/undef)
     (. bean5558 setTargetName (clojure.core/str v5560))))
   (clojure.core/let
    [v5560
     (:network-interface-id
      m5559
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5560 :com.palletops.awaze.client-builder/undef)
     (. bean5558 setNetworkInterfaceId (clojure.core/str v5560))))
   bean5558))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.UpdateGatewayInformationRequest}
update-gateway-information-request
  [m5562]
  (clojure.core/let
   [bean5561
    (new
     com.amazonaws.services.storagegateway.model.UpdateGatewayInformationRequest)]
   (clojure.core/let
    [v5563
     (:gateway-arn m5562 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5563 :com.palletops.awaze.client-builder/undef)
     (. bean5561 setGatewayARN (clojure.core/str v5563))))
   (clojure.core/let
    [v5563
     (:gateway-name m5562 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5563 :com.palletops.awaze.client-builder/undef)
     (. bean5561 setGatewayName (clojure.core/str v5563))))
   (clojure.core/let
    [v5563
     (:gateway-timezone
      m5562
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5563 :com.palletops.awaze.client-builder/undef)
     (. bean5561 setGatewayTimezone (clojure.core/str v5563))))
   bean5561))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.CancelRetrievalRequest}
cancel-retrieval-request
  [m5565]
  (clojure.core/let
   [bean5564
    (new
     com.amazonaws.services.storagegateway.model.CancelRetrievalRequest)]
   (clojure.core/let
    [v5566
     (:gateway-arn m5565 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5566 :com.palletops.awaze.client-builder/undef)
     (. bean5564 setGatewayARN (clojure.core/str v5566))))
   (clojure.core/let
    [v5566
     (:tape-arn m5565 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5566 :com.palletops.awaze.client-builder/undef)
     (. bean5564 setTapeARN (clojure.core/str v5566))))
   bean5564))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DescribeGatewayInformationRequest}
describe-gateway-information-request
  [m5568]
  (clojure.core/let
   [bean5567
    (new
     com.amazonaws.services.storagegateway.model.DescribeGatewayInformationRequest)]
   (clojure.core/let
    [v5569
     (:gateway-arn m5568 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5569 :com.palletops.awaze.client-builder/undef)
     (. bean5567 setGatewayARN (clojure.core/str v5569))))
   bean5567))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.ShutdownGatewayRequest}
shutdown-gateway-request
  [m5571]
  (clojure.core/let
   [bean5570
    (new
     com.amazonaws.services.storagegateway.model.ShutdownGatewayRequest)]
   (clojure.core/let
    [v5572
     (:gateway-arn m5571 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5572 :com.palletops.awaze.client-builder/undef)
     (. bean5570 setGatewayARN (clojure.core/str v5572))))
   bean5570))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.ListVolumeRecoveryPointsRequest}
list-volume-recovery-points-request
  [m5574]
  (clojure.core/let
   [bean5573
    (new
     com.amazonaws.services.storagegateway.model.ListVolumeRecoveryPointsRequest)]
   (clojure.core/let
    [v5575
     (:gateway-arn m5574 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5575 :com.palletops.awaze.client-builder/undef)
     (. bean5573 setGatewayARN (clojure.core/str v5575))))
   bean5573))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DeleteGatewayRequest}
delete-gateway-request
  [m5577]
  (clojure.core/let
   [bean5576
    (new
     com.amazonaws.services.storagegateway.model.DeleteGatewayRequest)]
   (clojure.core/let
    [v5578
     (:gateway-arn m5577 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5578 :com.palletops.awaze.client-builder/undef)
     (. bean5576 setGatewayARN (clojure.core/str v5578))))
   bean5576))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.CreateSnapshotRequest}
create-snapshot-request
  [m5580]
  (clojure.core/let
   [bean5579
    (new
     com.amazonaws.services.storagegateway.model.CreateSnapshotRequest)]
   (clojure.core/let
    [v5581
     (:volume-arn m5580 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5581 :com.palletops.awaze.client-builder/undef)
     (. bean5579 setVolumeARN (clojure.core/str v5581))))
   (clojure.core/let
    [v5581
     (:snapshot-description
      m5580
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5581 :com.palletops.awaze.client-builder/undef)
     (. bean5579 setSnapshotDescription (clojure.core/str v5581))))
   bean5579))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DeleteVolumeRequest}
delete-volume-request
  [m5583]
  (clojure.core/let
   [bean5582
    (new
     com.amazonaws.services.storagegateway.model.DeleteVolumeRequest)]
   (clojure.core/let
    [v5584
     (:volume-arn m5583 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5584 :com.palletops.awaze.client-builder/undef)
     (. bean5582 setVolumeARN (clojure.core/str v5584))))
   bean5582))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DescribeVTLDevicesRequest}
describe-vtldevices-request
  [m5586]
  (clojure.core/let
   [bean5585
    (new
     com.amazonaws.services.storagegateway.model.DescribeVTLDevicesRequest)]
   (clojure.core/let
    [v5587
     (:gateway-arn m5586 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5587 :com.palletops.awaze.client-builder/undef)
     (. bean5585 setGatewayARN (clojure.core/str v5587))))
   (clojure.core/let
    [v5587 (:marker m5586 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5587 :com.palletops.awaze.client-builder/undef)
     (. bean5585 setMarker (clojure.core/str v5587))))
   (clojure.core/let
    [v5587 (:limit m5586 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5587 :com.palletops.awaze.client-builder/undef)
     (. bean5585 setLimit (clojure.core/int v5587))))
   (clojure.core/let
    [v5587
     (:vtldevice-arns m5586 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5587 :com.palletops.awaze.client-builder/undef)
     (.
      bean5585
      setVTLDeviceARNs
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5604] (clojure.core/str arg5604))
 v5587))))
   bean5585))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.UpdateSnapshotScheduleRequest}
update-snapshot-schedule-request
  [m5589]
  (clojure.core/let
   [bean5588
    (new
     com.amazonaws.services.storagegateway.model.UpdateSnapshotScheduleRequest)]
   (clojure.core/let
    [v5590
     (:description m5589 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5590 :com.palletops.awaze.client-builder/undef)
     (. bean5588 setDescription (clojure.core/str v5590))))
   (clojure.core/let
    [v5590
     (:volume-arn m5589 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5590 :com.palletops.awaze.client-builder/undef)
     (. bean5588 setVolumeARN (clojure.core/str v5590))))
   (clojure.core/let
    [v5590
     (:start-at m5589 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5590 :com.palletops.awaze.client-builder/undef)
     (. bean5588 setStartAt (clojure.core/int v5590))))
   (clojure.core/let
    [v5590
     (:recurrence-in-hours
      m5589
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5590 :com.palletops.awaze.client-builder/undef)
     (. bean5588 setRecurrenceInHours (clojure.core/int v5590))))
   bean5588))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.DescribeSnapshotScheduleRequest}
describe-snapshot-schedule-request
  [m5592]
  (clojure.core/let
   [bean5591
    (new
     com.amazonaws.services.storagegateway.model.DescribeSnapshotScheduleRequest)]
   (clojure.core/let
    [v5593
     (:volume-arn m5592 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5593 :com.palletops.awaze.client-builder/undef)
     (. bean5591 setVolumeARN (clojure.core/str v5593))))
   bean5591))
 (clojure.core/defn
^{:tag com.amazonaws.services.storagegateway.model.ListGatewaysRequest}
list-gateways-request
  [m5595]
  (clojure.core/let
   [bean5594
    (new
     com.amazonaws.services.storagegateway.model.ListGatewaysRequest)]
   (clojure.core/let
    [v5596 (:marker m5595 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5596 :com.palletops.awaze.client-builder/undef)
     (. bean5594 setMarker (clojure.core/str v5596))))
   (clojure.core/let
    [v5596 (:limit m5595 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5596 :com.palletops.awaze.client-builder/undef)
     (. bean5594 setLimit (clojure.core/int v5596))))
   bean5594))
 (clojure.core/defmulti
  storagegateway
  (clojure.core/fn
   storagegateway
   [m__1683__auto__]
   (:fn m__1683__auto__)))
 (do
  (clojure.core/defmethod
   storagegateway
   :describe-maintenance-start-time
   [m5605]
   (clojure.core/let
    [credentials5606 (:credentials m5605) args5607 (:args m5605)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5608
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5606)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5608
       describeMaintenanceStartTime
       (storagegateway/describe-maintenance-start-time-request
        (clojure.core/nth args5607 0)))))))
  (clojure.core/defn
   describe-maintenance-start-time-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener gateway-arn]}]]),
    :doc "Generate map for describeMaintenanceStartTime"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :describe-maintenance-start-time,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-maintenance-start-time
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener gateway-arn]}]]),
    :doc "Call describeMaintenanceStartTime"}
   [credentials5610 & args5611]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5612
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5610)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5612
      describeMaintenanceStartTime
      (storagegateway/describe-maintenance-start-time-request
       (clojure.core/nth args5611 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :update-bandwidth-rate-limit
   [m5613]
   (clojure.core/let
    [credentials5614 (:credentials m5613) args5615 (:args m5613)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5616
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5614)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5616
       updateBandwidthRateLimit
       (storagegateway/update-bandwidth-rate-limit-request
        (clojure.core/nth args5615 0)))))))
  (clojure.core/defn
   update-bandwidth-rate-limit-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         gateway-arn
                         average-upload-rate-limit-in-bits-per-sec
                         average-download-rate-limit-in-bits-per-sec]}]]),
    :doc "Generate map for updateBandwidthRateLimit"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :update-bandwidth-rate-limit,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   update-bandwidth-rate-limit
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         gateway-arn
                         average-upload-rate-limit-in-bits-per-sec
                         average-download-rate-limit-in-bits-per-sec]}]]),
    :doc "Call updateBandwidthRateLimit"}
   [credentials5618 & args5619]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5620
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5618)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5620
      updateBandwidthRateLimit
      (storagegateway/update-bandwidth-rate-limit-request
       (clojure.core/nth args5619 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :describe-working-storage
   [m5621]
   (clojure.core/let
    [credentials5622 (:credentials m5621) args5623 (:args m5621)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5624
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5622)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5624
       describeWorkingStorage
       (storagegateway/describe-working-storage-request
        (clojure.core/nth args5623 0)))))))
  (clojure.core/defn
   describe-working-storage-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener gateway-arn]}]]),
    :doc "Generate map for describeWorkingStorage"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :describe-working-storage,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-working-storage
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener gateway-arn]}]]),
    :doc "Call describeWorkingStorage"}
   [credentials5626 & args5627]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5628
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5626)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5628
      describeWorkingStorage
      (storagegateway/describe-working-storage-request
       (clojure.core/nth args5627 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :delete-tape-archive
   [m5629]
   (clojure.core/let
    [credentials5630 (:credentials m5629) args5631 (:args m5629)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5632
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5630)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5632
       deleteTapeArchive
       (storagegateway/delete-tape-archive-request
        (clojure.core/nth args5631 0)))))))
  (clojure.core/defn
   delete-tape-archive-map
   {:arglists (quote
               [[credentials
                 {:keys [tape-arn general-progress-listener]}]]),
    :doc "Generate map for deleteTapeArchive"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :delete-tape-archive,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-tape-archive
   {:arglists (quote
               [[credentials
                 {:keys [tape-arn general-progress-listener]}]]),
    :doc "Call deleteTapeArchive"}
   [credentials5634 & args5635]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5636
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5634)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5636
      deleteTapeArchive
      (storagegateway/delete-tape-archive-request
       (clojure.core/nth args5635 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :delete-snapshot-schedule
   [m5637]
   (clojure.core/let
    [credentials5638 (:credentials m5637) args5639 (:args m5637)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5640
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5638)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5640
       deleteSnapshotSchedule
       (storagegateway/delete-snapshot-schedule-request
        (clojure.core/nth args5639 0)))))))
  (clojure.core/defn
   delete-snapshot-schedule-map
   {:arglists (quote
               [[credentials
                 {:keys [volume-arn general-progress-listener]}]]),
    :doc "Generate map for deleteSnapshotSchedule"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :delete-snapshot-schedule,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-snapshot-schedule
   {:arglists (quote
               [[credentials
                 {:keys [volume-arn general-progress-listener]}]]),
    :doc "Call deleteSnapshotSchedule"}
   [credentials5642 & args5643]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5644
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5642)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5644
      deleteSnapshotSchedule
      (storagegateway/delete-snapshot-schedule-request
       (clojure.core/nth args5643 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :disable-gateway
   [m5645]
   (clojure.core/let
    [credentials5646 (:credentials m5645) args5647 (:args m5645)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5648
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5646)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5648
       disableGateway
       (storagegateway/disable-gateway-request
        (clojure.core/nth args5647 0)))))))
  (clojure.core/defn
   disable-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener gateway-arn]}]]),
    :doc "Generate map for disableGateway"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :disable-gateway,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   disable-gateway
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener gateway-arn]}]]),
    :doc "Call disableGateway"}
   [credentials5650 & args5651]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5652
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5650)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5652
      disableGateway
      (storagegateway/disable-gateway-request
       (clojure.core/nth args5651 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :describe-chap-credentials
   [m5653]
   (clojure.core/let
    [credentials5654 (:credentials m5653) args5655 (:args m5653)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5656
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5654)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5656
       describeChapCredentials
       (storagegateway/describe-chap-credentials-request
        (clojure.core/nth args5655 0)))))))
  (clojure.core/defn
   describe-chap-credentials-map
   {:arglists (quote
               [[credentials
                 {:keys [target-arn general-progress-listener]}]]),
    :doc "Generate map for describeChapCredentials"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :describe-chap-credentials,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-chap-credentials
   {:arglists (quote
               [[credentials
                 {:keys [target-arn general-progress-listener]}]]),
    :doc "Call describeChapCredentials"}
   [credentials5658 & args5659]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5660
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5658)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5660
      describeChapCredentials
      (storagegateway/describe-chap-credentials-request
       (clojure.core/nth args5659 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :delete-bandwidth-rate-limit
   [m5661]
   (clojure.core/let
    [credentials5662 (:credentials m5661) args5663 (:args m5661)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5664
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5662)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5664
       deleteBandwidthRateLimit
       (storagegateway/delete-bandwidth-rate-limit-request
        (clojure.core/nth args5663 0)))))))
  (clojure.core/defn
   delete-bandwidth-rate-limit-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         gateway-arn
                         bandwidth-type]}]]),
    :doc "Generate map for deleteBandwidthRateLimit"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :delete-bandwidth-rate-limit,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-bandwidth-rate-limit
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         gateway-arn
                         bandwidth-type]}]]),
    :doc "Call deleteBandwidthRateLimit"}
   [credentials5666 & args5667]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5668
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5666)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5668
      deleteBandwidthRateLimit
      (storagegateway/delete-bandwidth-rate-limit-request
       (clojure.core/nth args5667 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :cancel-archival
   [m5669]
   (clojure.core/let
    [credentials5670 (:credentials m5669) args5671 (:args m5669)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5672
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5670)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5672
       cancelArchival
       (storagegateway/cancel-archival-request
        (clojure.core/nth args5671 0)))))))
  (clojure.core/defn
   cancel-archival-map
   {:arglists (quote
               [[credentials
                 {:keys [tape-arn
                         general-progress-listener
                         gateway-arn]}]]),
    :doc "Generate map for cancelArchival"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :cancel-archival,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   cancel-archival
   {:arglists (quote
               [[credentials
                 {:keys [tape-arn
                         general-progress-listener
                         gateway-arn]}]]),
    :doc "Call cancelArchival"}
   [credentials5674 & args5675]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5676
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5674)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5676
      cancelArchival
      (storagegateway/cancel-archival-request
       (clojure.core/nth args5675 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :create-cachedi-scsivolume
   [m5677]
   (clojure.core/let
    [credentials5678 (:credentials m5677) args5679 (:args m5677)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5680
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5678)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5680
       createCachediSCSIVolume
       (storagegateway/create-cachedi-scsivolume-request
        (clojure.core/nth args5679 0)))))))
  (clojure.core/defn
   create-cachedi-scsivolume-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         target-name
                         snapshot-id
                         network-interface-id
                         gateway-arn
                         volume-size-in-bytes
                         client-token]}]]),
    :doc "Generate map for createCachediSCSIVolume"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :create-cachedi-scsivolume,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-cachedi-scsivolume
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         target-name
                         snapshot-id
                         network-interface-id
                         gateway-arn
                         volume-size-in-bytes
                         client-token]}]]),
    :doc "Call createCachediSCSIVolume"}
   [credentials5682 & args5683]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5684
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5682)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5684
      createCachediSCSIVolume
      (storagegateway/create-cachedi-scsivolume-request
       (clojure.core/nth args5683 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :create-snapshot-from-volume-recovery-point
   [m5685]
   (clojure.core/let
    [credentials5686 (:credentials m5685) args5687 (:args m5685)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5688
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5686)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5688
       createSnapshotFromVolumeRecoveryPoint
       (storagegateway/create-snapshot-from-volume-recovery-point-request
        (clojure.core/nth args5687 0)))))))
  (clojure.core/defn
   create-snapshot-from-volume-recovery-point-map
   {:arglists (quote
               [[credentials
                 {:keys [volume-arn
                         snapshot-description
                         general-progress-listener]}]]),
    :doc "Generate map for createSnapshotFromVolumeRecoveryPoint"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :create-snapshot-from-volume-recovery-point,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-snapshot-from-volume-recovery-point
   {:arglists (quote
               [[credentials
                 {:keys [volume-arn
                         snapshot-description
                         general-progress-listener]}]]),
    :doc "Call createSnapshotFromVolumeRecoveryPoint"}
   [credentials5690 & args5691]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5692
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5690)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5692
      createSnapshotFromVolumeRecoveryPoint
      (storagegateway/create-snapshot-from-volume-recovery-point-request
       (clojure.core/nth args5691 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :describe-storedi-scsivolumes
   [m5693]
   (clojure.core/let
    [credentials5694 (:credentials m5693) args5695 (:args m5693)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5696
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5694)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5696
       describeStorediSCSIVolumes
       (storagegateway/describe-storedi-scsivolumes-request
        (clojure.core/nth args5695 0)))))))
  (clojure.core/defn
   describe-storedi-scsivolumes-map
   {:arglists (quote
               [[credentials
                 {:keys [volume-arns general-progress-listener]}]]),
    :doc "Generate map for describeStorediSCSIVolumes"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :describe-storedi-scsivolumes,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-storedi-scsivolumes
   {:arglists (quote
               [[credentials
                 {:keys [volume-arns general-progress-listener]}]]),
    :doc "Call describeStorediSCSIVolumes"}
   [credentials5698 & args5699]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5700
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5698)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5700
      describeStorediSCSIVolumes
      (storagegateway/describe-storedi-scsivolumes-request
       (clojure.core/nth args5699 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :describe-upload-buffer
   [m5701]
   (clojure.core/let
    [credentials5702 (:credentials m5701) args5703 (:args m5701)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5704
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5702)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5704
       describeUploadBuffer
       (storagegateway/describe-upload-buffer-request
        (clojure.core/nth args5703 0)))))))
  (clojure.core/defn
   describe-upload-buffer-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener gateway-arn]}]]),
    :doc "Generate map for describeUploadBuffer"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :describe-upload-buffer,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-upload-buffer
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener gateway-arn]}]]),
    :doc "Call describeUploadBuffer"}
   [credentials5706 & args5707]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5708
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5706)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5708
      describeUploadBuffer
      (storagegateway/describe-upload-buffer-request
       (clojure.core/nth args5707 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :add-upload-buffer
   [m5709]
   (clojure.core/let
    [credentials5710 (:credentials m5709) args5711 (:args m5709)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5712
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5710)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5712
       addUploadBuffer
       (storagegateway/add-upload-buffer-request
        (clojure.core/nth args5711 0)))))))
  (clojure.core/defn
   add-upload-buffer-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         gateway-arn
                         disk-ids]}]]),
    :doc "Generate map for addUploadBuffer"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :add-upload-buffer,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   add-upload-buffer
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         gateway-arn
                         disk-ids]}]]),
    :doc "Call addUploadBuffer"}
   [credentials5714 & args5715]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5716
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5714)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5716
      addUploadBuffer
      (storagegateway/add-upload-buffer-request
       (clojure.core/nth args5715 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :retrieve-tape-archive
   [m5717]
   (clojure.core/let
    [credentials5718 (:credentials m5717) args5719 (:args m5717)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5720
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5718)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5720
       retrieveTapeArchive
       (storagegateway/retrieve-tape-archive-request
        (clojure.core/nth args5719 0)))))))
  (clojure.core/defn
   retrieve-tape-archive-map
   {:arglists (quote
               [[credentials
                 {:keys [tape-arn
                         general-progress-listener
                         gateway-arn]}]]),
    :doc "Generate map for retrieveTapeArchive"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :retrieve-tape-archive,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   retrieve-tape-archive
   {:arglists (quote
               [[credentials
                 {:keys [tape-arn
                         general-progress-listener
                         gateway-arn]}]]),
    :doc "Call retrieveTapeArchive"}
   [credentials5722 & args5723]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5724
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5722)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5724
      retrieveTapeArchive
      (storagegateway/retrieve-tape-archive-request
       (clojure.core/nth args5723 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :describe-tapes
   [m5725]
   (clojure.core/let
    [credentials5726 (:credentials m5725) args5727 (:args m5725)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5728
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5726)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5728
       describeTapes
       (storagegateway/describe-tapes-request
        (clojure.core/nth args5727 0)))))))
  (clojure.core/defn
   describe-tapes-map
   {:arglists (quote
               [[credentials
                 {:keys [tape-arns
                         marker
                         limit
                         general-progress-listener
                         gateway-arn]}]]),
    :doc "Generate map for describeTapes"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :describe-tapes,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-tapes
   {:arglists (quote
               [[credentials
                 {:keys [tape-arns
                         marker
                         limit
                         general-progress-listener
                         gateway-arn]}]]),
    :doc "Call describeTapes"}
   [credentials5730 & args5731]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5732
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5730)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5732
      describeTapes
      (storagegateway/describe-tapes-request
       (clojure.core/nth args5731 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :add-working-storage
   [m5733]
   (clojure.core/let
    [credentials5734 (:credentials m5733) args5735 (:args m5733)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5736
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5734)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5736
       addWorkingStorage
       (storagegateway/add-working-storage-request
        (clojure.core/nth args5735 0)))))))
  (clojure.core/defn
   add-working-storage-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         gateway-arn
                         disk-ids]}]]),
    :doc "Generate map for addWorkingStorage"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :add-working-storage,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   add-working-storage
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         gateway-arn
                         disk-ids]}]]),
    :doc "Call addWorkingStorage"}
   [credentials5738 & args5739]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5740
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5738)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5740
      addWorkingStorage
      (storagegateway/add-working-storage-request
       (clojure.core/nth args5739 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :start-gateway
   [m5741]
   (clojure.core/let
    [credentials5742 (:credentials m5741) args5743 (:args m5741)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5744
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5742)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5744
       startGateway
       (storagegateway/start-gateway-request
        (clojure.core/nth args5743 0)))))))
  (clojure.core/defn
   start-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener gateway-arn]}]]),
    :doc "Generate map for startGateway"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :start-gateway,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   start-gateway
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener gateway-arn]}]]),
    :doc "Call startGateway"}
   [credentials5746 & args5747]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5748
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5746)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5748
      startGateway
      (storagegateway/start-gateway-request
       (clojure.core/nth args5747 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :describe-tape-recovery-points
   [m5749]
   (clojure.core/let
    [credentials5750 (:credentials m5749) args5751 (:args m5749)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5752
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5750)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5752
       describeTapeRecoveryPoints
       (storagegateway/describe-tape-recovery-points-request
        (clojure.core/nth args5751 0)))))))
  (clojure.core/defn
   describe-tape-recovery-points-map
   {:arglists (quote
               [[credentials
                 {:keys [marker
                         limit
                         general-progress-listener
                         gateway-arn]}]]),
    :doc "Generate map for describeTapeRecoveryPoints"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :describe-tape-recovery-points,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-tape-recovery-points
   {:arglists (quote
               [[credentials
                 {:keys [marker
                         limit
                         general-progress-listener
                         gateway-arn]}]]),
    :doc "Call describeTapeRecoveryPoints"}
   [credentials5754 & args5755]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5756
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5754)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5756
      describeTapeRecoveryPoints
      (storagegateway/describe-tape-recovery-points-request
       (clojure.core/nth args5755 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :list-local-disks
   [m5757]
   (clojure.core/let
    [credentials5758 (:credentials m5757) args5759 (:args m5757)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5760
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5758)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5760
       listLocalDisks
       (storagegateway/list-local-disks-request
        (clojure.core/nth args5759 0)))))))
  (clojure.core/defn
   list-local-disks-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener gateway-arn]}]]),
    :doc "Generate map for listLocalDisks"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :list-local-disks,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   list-local-disks
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener gateway-arn]}]]),
    :doc "Call listLocalDisks"}
   [credentials5762 & args5763]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5764
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5762)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5764
      listLocalDisks
      (storagegateway/list-local-disks-request
       (clojure.core/nth args5763 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :delete-chap-credentials
   [m5765]
   (clojure.core/let
    [credentials5766 (:credentials m5765) args5767 (:args m5765)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5768
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5766)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5768
       deleteChapCredentials
       (storagegateway/delete-chap-credentials-request
        (clojure.core/nth args5767 0)))))))
  (clojure.core/defn
   delete-chap-credentials-map
   {:arglists (quote
               [[credentials
                 {:keys [target-arn
                         initiator-name
                         general-progress-listener]}]]),
    :doc "Generate map for deleteChapCredentials"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :delete-chap-credentials,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-chap-credentials
   {:arglists (quote
               [[credentials
                 {:keys [target-arn
                         initiator-name
                         general-progress-listener]}]]),
    :doc "Call deleteChapCredentials"}
   [credentials5770 & args5771]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5772
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5770)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5772
      deleteChapCredentials
      (storagegateway/delete-chap-credentials-request
       (clojure.core/nth args5771 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :update-maintenance-start-time
   [m5773]
   (clojure.core/let
    [credentials5774 (:credentials m5773) args5775 (:args m5773)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5776
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5774)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5776
       updateMaintenanceStartTime
       (storagegateway/update-maintenance-start-time-request
        (clojure.core/nth args5775 0)))))))
  (clojure.core/defn
   update-maintenance-start-time-map
   {:arglists (quote
               [[credentials
                 {:keys [minute-of-hour
                         hour-of-day
                         general-progress-listener
                         gateway-arn
                         day-of-week]}]]),
    :doc "Generate map for updateMaintenanceStartTime"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :update-maintenance-start-time,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   update-maintenance-start-time
   {:arglists (quote
               [[credentials
                 {:keys [minute-of-hour
                         hour-of-day
                         general-progress-listener
                         gateway-arn
                         day-of-week]}]]),
    :doc "Call updateMaintenanceStartTime"}
   [credentials5778 & args5779]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5780
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5778)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5780
      updateMaintenanceStartTime
      (storagegateway/update-maintenance-start-time-request
       (clojure.core/nth args5779 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :add-cache
   [m5781]
   (clojure.core/let
    [credentials5782 (:credentials m5781) args5783 (:args m5781)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5784
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5782)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5784
       addCache
       (storagegateway/add-cache-request
        (clojure.core/nth args5783 0)))))))
  (clojure.core/defn
   add-cache-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         gateway-arn
                         disk-ids]}]]),
    :doc "Generate map for addCache"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :add-cache,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   add-cache
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         gateway-arn
                         disk-ids]}]]),
    :doc "Call addCache"}
   [credentials5786 & args5787]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5788
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5786)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5788
      addCache
      (storagegateway/add-cache-request (clojure.core/nth args5787 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :describe-cachedi-scsivolumes
   [m5789]
   (clojure.core/let
    [credentials5790 (:credentials m5789) args5791 (:args m5789)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5792
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5790)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5792
       describeCachediSCSIVolumes
       (storagegateway/describe-cachedi-scsivolumes-request
        (clojure.core/nth args5791 0)))))))
  (clojure.core/defn
   describe-cachedi-scsivolumes-map
   {:arglists (quote
               [[credentials
                 {:keys [volume-arns general-progress-listener]}]]),
    :doc "Generate map for describeCachediSCSIVolumes"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :describe-cachedi-scsivolumes,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-cachedi-scsivolumes
   {:arglists (quote
               [[credentials
                 {:keys [volume-arns general-progress-listener]}]]),
    :doc "Call describeCachediSCSIVolumes"}
   [credentials5794 & args5795]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5796
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5794)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5796
      describeCachediSCSIVolumes
      (storagegateway/describe-cachedi-scsivolumes-request
       (clojure.core/nth args5795 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :describe-bandwidth-rate-limit
   [m5797]
   (clojure.core/let
    [credentials5798 (:credentials m5797) args5799 (:args m5797)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5800
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5798)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5800
       describeBandwidthRateLimit
       (storagegateway/describe-bandwidth-rate-limit-request
        (clojure.core/nth args5799 0)))))))
  (clojure.core/defn
   describe-bandwidth-rate-limit-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener gateway-arn]}]]),
    :doc "Generate map for describeBandwidthRateLimit"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :describe-bandwidth-rate-limit,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-bandwidth-rate-limit
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener gateway-arn]}]]),
    :doc "Call describeBandwidthRateLimit"}
   [credentials5802 & args5803]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5804
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5802)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5804
      describeBandwidthRateLimit
      (storagegateway/describe-bandwidth-rate-limit-request
       (clojure.core/nth args5803 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :list-volumes
   [m5805]
   (clojure.core/let
    [credentials5806 (:credentials m5805) args5807 (:args m5805)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5808
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5806)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5808
       listVolumes
       (storagegateway/list-volumes-request
        (clojure.core/nth args5807 0)))))))
  (clojure.core/defn
   list-volumes-map
   {:arglists (quote
               [[credentials
                 {:keys [marker
                         limit
                         general-progress-listener
                         gateway-arn]}]]),
    :doc "Generate map for listVolumes"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :list-volumes,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   list-volumes
   {:arglists (quote
               [[credentials
                 {:keys [marker
                         limit
                         general-progress-listener
                         gateway-arn]}]]),
    :doc "Call listVolumes"}
   [credentials5810 & args5811]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5812
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5810)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5812
      listVolumes
      (storagegateway/list-volumes-request
       (clojure.core/nth args5811 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :create-tapes
   [m5813]
   (clojure.core/let
    [credentials5814 (:credentials m5813) args5815 (:args m5813)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5816
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5814)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5816
       createTapes
       (storagegateway/create-tapes-request
        (clojure.core/nth args5815 0)))))))
  (clojure.core/defn
   create-tapes-map
   {:arglists (quote
               [[credentials
                 {:keys [num-tapes-to-create
                         tape-size-in-bytes
                         client-token
                         tape-barcode-prefix
                         general-progress-listener
                         gateway-arn]}]]),
    :doc "Generate map for createTapes"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :create-tapes,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-tapes
   {:arglists (quote
               [[credentials
                 {:keys [num-tapes-to-create
                         tape-size-in-bytes
                         client-token
                         tape-barcode-prefix
                         general-progress-listener
                         gateway-arn]}]]),
    :doc "Call createTapes"}
   [credentials5818 & args5819]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5820
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5818)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5820
      createTapes
      (storagegateway/create-tapes-request
       (clojure.core/nth args5819 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :activate-gateway
   [m5821]
   (clojure.core/let
    [credentials5822 (:credentials m5821) args5823 (:args m5821)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5824
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5822)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5824
       activateGateway
       (storagegateway/activate-gateway-request
        (clojure.core/nth args5823 0)))))))
  (clojure.core/defn
   activate-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [activation-key
                         general-progress-listener
                         tape-drive-type
                         gateway-timezone
                         medium-changer-type
                         gateway-region
                         gateway-name
                         gateway-type]}]]),
    :doc "Generate map for activateGateway"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :activate-gateway,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   activate-gateway
   {:arglists (quote
               [[credentials
                 {:keys [activation-key
                         general-progress-listener
                         tape-drive-type
                         gateway-timezone
                         medium-changer-type
                         gateway-region
                         gateway-name
                         gateway-type]}]]),
    :doc "Call activateGateway"}
   [credentials5826 & args5827]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5828
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5826)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5828
      activateGateway
      (storagegateway/activate-gateway-request
       (clojure.core/nth args5827 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :describe-cache
   [m5829]
   (clojure.core/let
    [credentials5830 (:credentials m5829) args5831 (:args m5829)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5832
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5830)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5832
       describeCache
       (storagegateway/describe-cache-request
        (clojure.core/nth args5831 0)))))))
  (clojure.core/defn
   describe-cache-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener gateway-arn]}]]),
    :doc "Generate map for describeCache"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :describe-cache,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-cache
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener gateway-arn]}]]),
    :doc "Call describeCache"}
   [credentials5834 & args5835]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5836
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5834)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5836
      describeCache
      (storagegateway/describe-cache-request
       (clojure.core/nth args5835 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :update-gateway-software-now
   [m5837]
   (clojure.core/let
    [credentials5838 (:credentials m5837) args5839 (:args m5837)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5840
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5838)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5840
       updateGatewaySoftwareNow
       (storagegateway/update-gateway-software-now-request
        (clojure.core/nth args5839 0)))))))
  (clojure.core/defn
   update-gateway-software-now-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener gateway-arn]}]]),
    :doc "Generate map for updateGatewaySoftwareNow"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :update-gateway-software-now,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   update-gateway-software-now
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener gateway-arn]}]]),
    :doc "Call updateGatewaySoftwareNow"}
   [credentials5842 & args5843]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5844
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5842)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5844
      updateGatewaySoftwareNow
      (storagegateway/update-gateway-software-now-request
       (clojure.core/nth args5843 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :update-chap-credentials
   [m5845]
   (clojure.core/let
    [credentials5846 (:credentials m5845) args5847 (:args m5845)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5848
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5846)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5848
       updateChapCredentials
       (storagegateway/update-chap-credentials-request
        (clojure.core/nth args5847 0)))))))
  (clojure.core/defn
   update-chap-credentials-map
   {:arglists (quote
               [[credentials
                 {:keys [target-arn
                         secret-to-authenticate-target
                         secret-to-authenticate-initiator
                         initiator-name
                         general-progress-listener]}]]),
    :doc "Generate map for updateChapCredentials"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :update-chap-credentials,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   update-chap-credentials
   {:arglists (quote
               [[credentials
                 {:keys [target-arn
                         secret-to-authenticate-target
                         secret-to-authenticate-initiator
                         initiator-name
                         general-progress-listener]}]]),
    :doc "Call updateChapCredentials"}
   [credentials5850 & args5851]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5852
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5850)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5852
      updateChapCredentials
      (storagegateway/update-chap-credentials-request
       (clojure.core/nth args5851 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :describe-tape-archives
   [m5853]
   (clojure.core/let
    [credentials5854 (:credentials m5853) args5855 (:args m5853)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5856
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5854)]
     (clojure.core/case
      (clojure.core/count args5855)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5856
        describeTapeArchives))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5856
        describeTapeArchives
        (storagegateway/describe-tape-archives-request
         (clojure.core/nth args5855 0))))))))
  (clojure.core/defn
   describe-tape-archives-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [tape-arns
                         marker
                         limit
                         general-progress-listener]}]]),
    :doc "Generate map for describeTapeArchives, describeTapeArchives"}
   ([credentials__1651__auto__]
    {:args [],
     :client :storagegateway,
     :fn :describe-tape-archives,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :describe-tape-archives,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-tape-archives
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [tape-arns
                         marker
                         limit
                         general-progress-listener]}]]),
    :doc "Call describeTapeArchives, describeTapeArchives"}
   [credentials5858 & args5859]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5860
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5858)]
    (clojure.core/case
     (clojure.core/count args5859)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5860
       describeTapeArchives))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5860
       describeTapeArchives
       (storagegateway/describe-tape-archives-request
        (clojure.core/nth args5859 0))))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :delete-tape
   [m5861]
   (clojure.core/let
    [credentials5862 (:credentials m5861) args5863 (:args m5861)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5864
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5862)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5864
       deleteTape
       (storagegateway/delete-tape-request
        (clojure.core/nth args5863 0)))))))
  (clojure.core/defn
   delete-tape-map
   {:arglists (quote
               [[credentials
                 {:keys [tape-arn
                         general-progress-listener
                         gateway-arn]}]]),
    :doc "Generate map for deleteTape"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :delete-tape,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-tape
   {:arglists (quote
               [[credentials
                 {:keys [tape-arn
                         general-progress-listener
                         gateway-arn]}]]),
    :doc "Call deleteTape"}
   [credentials5866 & args5867]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5868
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5866)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5868
      deleteTape
      (storagegateway/delete-tape-request
       (clojure.core/nth args5867 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :retrieve-tape-recovery-point
   [m5869]
   (clojure.core/let
    [credentials5870 (:credentials m5869) args5871 (:args m5869)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5872
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5870)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5872
       retrieveTapeRecoveryPoint
       (storagegateway/retrieve-tape-recovery-point-request
        (clojure.core/nth args5871 0)))))))
  (clojure.core/defn
   retrieve-tape-recovery-point-map
   {:arglists (quote
               [[credentials
                 {:keys [tape-arn
                         general-progress-listener
                         gateway-arn]}]]),
    :doc "Generate map for retrieveTapeRecoveryPoint"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :retrieve-tape-recovery-point,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   retrieve-tape-recovery-point
   {:arglists (quote
               [[credentials
                 {:keys [tape-arn
                         general-progress-listener
                         gateway-arn]}]]),
    :doc "Call retrieveTapeRecoveryPoint"}
   [credentials5874 & args5875]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5876
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5874)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5876
      retrieveTapeRecoveryPoint
      (storagegateway/retrieve-tape-recovery-point-request
       (clojure.core/nth args5875 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :create-storedi-scsivolume
   [m5877]
   (clojure.core/let
    [credentials5878 (:credentials m5877) args5879 (:args m5877)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5880
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5878)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5880
       createStorediSCSIVolume
       (storagegateway/create-storedi-scsivolume-request
        (clojure.core/nth args5879 0)))))))
  (clojure.core/defn
   create-storedi-scsivolume-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         target-name
                         snapshot-id
                         preserve-existing-data
                         network-interface-id
                         gateway-arn
                         disk-id]}]]),
    :doc "Generate map for createStorediSCSIVolume"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :create-storedi-scsivolume,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-storedi-scsivolume
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         target-name
                         snapshot-id
                         preserve-existing-data
                         network-interface-id
                         gateway-arn
                         disk-id]}]]),
    :doc "Call createStorediSCSIVolume"}
   [credentials5882 & args5883]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5884
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5882)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5884
      createStorediSCSIVolume
      (storagegateway/create-storedi-scsivolume-request
       (clojure.core/nth args5883 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :update-gateway-information
   [m5885]
   (clojure.core/let
    [credentials5886 (:credentials m5885) args5887 (:args m5885)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5888
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5886)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5888
       updateGatewayInformation
       (storagegateway/update-gateway-information-request
        (clojure.core/nth args5887 0)))))))
  (clojure.core/defn
   update-gateway-information-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         gateway-timezone
                         gateway-name
                         gateway-arn]}]]),
    :doc "Generate map for updateGatewayInformation"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :update-gateway-information,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   update-gateway-information
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         gateway-timezone
                         gateway-name
                         gateway-arn]}]]),
    :doc "Call updateGatewayInformation"}
   [credentials5890 & args5891]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5892
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5890)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5892
      updateGatewayInformation
      (storagegateway/update-gateway-information-request
       (clojure.core/nth args5891 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :cancel-retrieval
   [m5893]
   (clojure.core/let
    [credentials5894 (:credentials m5893) args5895 (:args m5893)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5896
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5894)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5896
       cancelRetrieval
       (storagegateway/cancel-retrieval-request
        (clojure.core/nth args5895 0)))))))
  (clojure.core/defn
   cancel-retrieval-map
   {:arglists (quote
               [[credentials
                 {:keys [tape-arn
                         general-progress-listener
                         gateway-arn]}]]),
    :doc "Generate map for cancelRetrieval"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :cancel-retrieval,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   cancel-retrieval
   {:arglists (quote
               [[credentials
                 {:keys [tape-arn
                         general-progress-listener
                         gateway-arn]}]]),
    :doc "Call cancelRetrieval"}
   [credentials5898 & args5899]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5900
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5898)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5900
      cancelRetrieval
      (storagegateway/cancel-retrieval-request
       (clojure.core/nth args5899 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :describe-gateway-information
   [m5901]
   (clojure.core/let
    [credentials5902 (:credentials m5901) args5903 (:args m5901)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5904
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5902)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5904
       describeGatewayInformation
       (storagegateway/describe-gateway-information-request
        (clojure.core/nth args5903 0)))))))
  (clojure.core/defn
   describe-gateway-information-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener gateway-arn]}]]),
    :doc "Generate map for describeGatewayInformation"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :describe-gateway-information,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-gateway-information
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener gateway-arn]}]]),
    :doc "Call describeGatewayInformation"}
   [credentials5906 & args5907]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5908
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5906)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5908
      describeGatewayInformation
      (storagegateway/describe-gateway-information-request
       (clojure.core/nth args5907 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :shutdown-gateway
   [m5909]
   (clojure.core/let
    [credentials5910 (:credentials m5909) args5911 (:args m5909)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5912
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5910)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5912
       shutdownGateway
       (storagegateway/shutdown-gateway-request
        (clojure.core/nth args5911 0)))))))
  (clojure.core/defn
   shutdown-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener gateway-arn]}]]),
    :doc "Generate map for shutdownGateway"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :shutdown-gateway,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   shutdown-gateway
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener gateway-arn]}]]),
    :doc "Call shutdownGateway"}
   [credentials5914 & args5915]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5916
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5914)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5916
      shutdownGateway
      (storagegateway/shutdown-gateway-request
       (clojure.core/nth args5915 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :list-volume-recovery-points
   [m5917]
   (clojure.core/let
    [credentials5918 (:credentials m5917) args5919 (:args m5917)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5920
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5918)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5920
       listVolumeRecoveryPoints
       (storagegateway/list-volume-recovery-points-request
        (clojure.core/nth args5919 0)))))))
  (clojure.core/defn
   list-volume-recovery-points-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener gateway-arn]}]]),
    :doc "Generate map for listVolumeRecoveryPoints"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :list-volume-recovery-points,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   list-volume-recovery-points
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener gateway-arn]}]]),
    :doc "Call listVolumeRecoveryPoints"}
   [credentials5922 & args5923]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5924
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5922)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5924
      listVolumeRecoveryPoints
      (storagegateway/list-volume-recovery-points-request
       (clojure.core/nth args5923 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :delete-gateway
   [m5925]
   (clojure.core/let
    [credentials5926 (:credentials m5925) args5927 (:args m5925)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5928
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5926)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5928
       deleteGateway
       (storagegateway/delete-gateway-request
        (clojure.core/nth args5927 0)))))))
  (clojure.core/defn
   delete-gateway-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener gateway-arn]}]]),
    :doc "Generate map for deleteGateway"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :delete-gateway,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-gateway
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener gateway-arn]}]]),
    :doc "Call deleteGateway"}
   [credentials5930 & args5931]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5932
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5930)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5932
      deleteGateway
      (storagegateway/delete-gateway-request
       (clojure.core/nth args5931 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :create-snapshot
   [m5933]
   (clojure.core/let
    [credentials5934 (:credentials m5933) args5935 (:args m5933)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5936
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5934)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5936
       createSnapshot
       (storagegateway/create-snapshot-request
        (clojure.core/nth args5935 0)))))))
  (clojure.core/defn
   create-snapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [volume-arn
                         snapshot-description
                         general-progress-listener]}]]),
    :doc "Generate map for createSnapshot"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :create-snapshot,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   create-snapshot
   {:arglists (quote
               [[credentials
                 {:keys [volume-arn
                         snapshot-description
                         general-progress-listener]}]]),
    :doc "Call createSnapshot"}
   [credentials5938 & args5939]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5940
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5938)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5940
      createSnapshot
      (storagegateway/create-snapshot-request
       (clojure.core/nth args5939 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :delete-volume
   [m5941]
   (clojure.core/let
    [credentials5942 (:credentials m5941) args5943 (:args m5941)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5944
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5942)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5944
       deleteVolume
       (storagegateway/delete-volume-request
        (clojure.core/nth args5943 0)))))))
  (clojure.core/defn
   delete-volume-map
   {:arglists (quote
               [[credentials
                 {:keys [volume-arn general-progress-listener]}]]),
    :doc "Generate map for deleteVolume"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :delete-volume,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   delete-volume
   {:arglists (quote
               [[credentials
                 {:keys [volume-arn general-progress-listener]}]]),
    :doc "Call deleteVolume"}
   [credentials5946 & args5947]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5948
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5946)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5948
      deleteVolume
      (storagegateway/delete-volume-request
       (clojure.core/nth args5947 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :describe-vtldevices
   [m5949]
   (clojure.core/let
    [credentials5950 (:credentials m5949) args5951 (:args m5949)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5952
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5950)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5952
       describeVTLDevices
       (storagegateway/describe-vtldevices-request
        (clojure.core/nth args5951 0)))))))
  (clojure.core/defn
   describe-vtldevices-map
   {:arglists (quote
               [[credentials
                 {:keys [marker
                         limit
                         general-progress-listener
                         gateway-arn
                         vtldevice-arns]}]]),
    :doc "Generate map for describeVTLDevices"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :describe-vtldevices,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-vtldevices
   {:arglists (quote
               [[credentials
                 {:keys [marker
                         limit
                         general-progress-listener
                         gateway-arn
                         vtldevice-arns]}]]),
    :doc "Call describeVTLDevices"}
   [credentials5954 & args5955]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5956
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5954)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5956
      describeVTLDevices
      (storagegateway/describe-vtldevices-request
       (clojure.core/nth args5955 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :update-snapshot-schedule
   [m5957]
   (clojure.core/let
    [credentials5958 (:credentials m5957) args5959 (:args m5957)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5960
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5958)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5960
       updateSnapshotSchedule
       (storagegateway/update-snapshot-schedule-request
        (clojure.core/nth args5959 0)))))))
  (clojure.core/defn
   update-snapshot-schedule-map
   {:arglists (quote
               [[credentials
                 {:keys [volume-arn
                         start-at
                         recurrence-in-hours
                         general-progress-listener
                         description]}]]),
    :doc "Generate map for updateSnapshotSchedule"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :update-snapshot-schedule,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   update-snapshot-schedule
   {:arglists (quote
               [[credentials
                 {:keys [volume-arn
                         start-at
                         recurrence-in-hours
                         general-progress-listener
                         description]}]]),
    :doc "Call updateSnapshotSchedule"}
   [credentials5962 & args5963]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5964
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5962)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5964
      updateSnapshotSchedule
      (storagegateway/update-snapshot-schedule-request
       (clojure.core/nth args5963 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :describe-snapshot-schedule
   [m5965]
   (clojure.core/let
    [credentials5966 (:credentials m5965) args5967 (:args m5965)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5968
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5966)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5968
       describeSnapshotSchedule
       (storagegateway/describe-snapshot-schedule-request
        (clojure.core/nth args5967 0)))))))
  (clojure.core/defn
   describe-snapshot-schedule-map
   {:arglists (quote
               [[credentials
                 {:keys [volume-arn general-progress-listener]}]]),
    :doc "Generate map for describeSnapshotSchedule"}
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :describe-snapshot-schedule,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   describe-snapshot-schedule
   {:arglists (quote
               [[credentials
                 {:keys [volume-arn general-progress-listener]}]]),
    :doc "Call describeSnapshotSchedule"}
   [credentials5970 & args5971]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5972
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5970)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5972
      describeSnapshotSchedule
      (storagegateway/describe-snapshot-schedule-request
       (clojure.core/nth args5971 0)))))))
 (do
  (clojure.core/defmethod
   storagegateway
   :list-gateways
   [m5973]
   (clojure.core/let
    [credentials5974 (:credentials m5973) args5975 (:args m5973)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
      client5976
      (com.palletops.awaze.common/aws-client
       :storagegateway
       credentials5974)]
     (clojure.core/case
      (clojure.core/count args5975)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5976
        listGateways))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5976
        listGateways
        (storagegateway/list-gateways-request
         (clojure.core/nth args5975 0))))))))
  (clojure.core/defn
   list-gateways-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [marker limit general-progress-listener]}]]),
    :doc "Generate map for listGateways, listGateways"}
   ([credentials__1651__auto__]
    {:args [],
     :client :storagegateway,
     :fn :list-gateways,
     :credentials credentials__1651__auto__})
   ([credentials__1651__auto__ a]
    {:args [a],
     :client :storagegateway,
     :fn :list-gateways,
     :credentials credentials__1651__auto__}))
  (clojure.core/defn
   list-gateways
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [marker limit general-progress-listener]}]]),
    :doc "Call listGateways, listGateways"}
   [credentials5978 & args5979]
   (clojure.core/let
    [^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
     client5980
     (com.palletops.awaze.common/aws-client
      :storagegateway
      credentials5978)]
    (clojure.core/case
     (clojure.core/count args5979)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5980
       listGateways))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.storagegateway.AWSStorageGatewayClient}
client5980
       listGateways
       (storagegateway/list-gateways-request
        (clojure.core/nth args5979 0)))))))))
