(ns
 com.palletops.fleet.v1-alpha
 (:require
  [clj-http.client]
  [com.palletops.api-builder.api]
  [schema.core]))


(def Connection {:endpoint schema.core/Str})


(com.palletops.api-builder.api/defn-api
 connect
 "Return a connection map for the given endpoint"
 {:sig [[schema.core/Str :- Connection]]}
 [endpoint]
 {:endpoint endpoint})


(def
 Machine
 {(schema.core/optional-key :metadata) {schema.core/Keyword schema.core/Str},
  (schema.core/optional-key :primaryIP) schema.core/Str,
  :id schema.core/Str})


(def
 MachinePage
 {(schema.core/optional-key :nextPageToken) schema.core/Str,
  :machines [Machine]})


(def
 UnitOption
 {(schema.core/optional-key :value) schema.core/Str,
  :name schema.core/Str,
  :section schema.core/Str})


(def
 Unit
 {:machineID schema.core/Str,
  :currentState schema.core/Str,
  :desiredState schema.core/Str,
  (schema.core/optional-key :options) [UnitOption],
  :name schema.core/Str})


(def
 UnitPage
 {(schema.core/optional-key :nextPageToken) schema.core/Str,
  :units [Unit]})


(def
 UnitState
 {(schema.core/optional-key :systemdSubState) schema.core/Str,
  (schema.core/optional-key :systemdActiveState) schema.core/Str,
  (schema.core/optional-key :systemdLoadState) schema.core/Str,
  :machineID schema.core/Str,
  :hash schema.core/Str,
  :name schema.core/Str})


(def
 UnitStatePage
 {(schema.core/optional-key :nextPageToken) schema.core/Str,
  :states [UnitState]})


(com.palletops.api-builder.api/defn-api
 machine-list
 "Retrieve a page of Machine objects."
 {:sig [[Connection
         {(schema.core/optional-key :nextPageToken) schema.core/Str}
         :-
         MachinePage]]}
 [connection options]
 (clojure.core/->
  (clj-http.client/get
   (clojure.core/str
    (:endpoint connection)
    "/v1-alpha/"
    (clojure.core/-> "machines"))
   {:as :json})
  :body))


(com.palletops.api-builder.api/defn-api
 unit-list
 "Retrieve a page of Unit objects."
 {:sig [[Connection
         {(schema.core/optional-key :nextPageToken) schema.core/Str}
         :-
         UnitPage]]}
 [connection options]
 (clojure.core/->
  (clj-http.client/get
   (clojure.core/str
    (:endpoint connection)
    "/v1-alpha/"
    (clojure.core/-> "units"))
   {:as :json})
  :body))


(com.palletops.api-builder.api/defn-api
 unit-get
 "Retrieve a single Unit object."
 {:sig [[Connection schema.core/Str {} :- Unit]]}
 [connection unit-name options]
 (clojure.core/->
  (clj-http.client/get
   (clojure.core/str
    (:endpoint connection)
    "/v1-alpha/"
    (clojure.core/->
     "units/{unitName}"
     (clojure.string/replace "{unitName}" unit-name)))
   {:as :json})
  :body))


(com.palletops.api-builder.api/defn-api
 unit-delete
 "Delete the referenced Unit object."
 {:sig [[Connection schema.core/Str {} :- (schema.core/eq nil)]]}
 [connection unit-name options]
 (clojure.core/->
  (clj-http.client/delete
   (clojure.core/str
    (:endpoint connection)
    "/v1-alpha/"
    (clojure.core/->
     "units/{unitName}"
     (clojure.string/replace "{unitName}" unit-name)))
   {:as :json})
  :body))


(com.palletops.api-builder.api/defn-api
 unit-set
 "Create or update a Unit."
 {:sig [[Connection schema.core/Str {} :- (schema.core/eq nil)]]}
 [connection unit-name options]
 (clojure.core/->
  (clj-http.client/put
   (clojure.core/str
    (:endpoint connection)
    "/v1-alpha/"
    (clojure.core/->
     "units/{unitName}"
     (clojure.string/replace "{unitName}" unit-name)))
   {:as :json})
  :body))


(com.palletops.api-builder.api/defn-api
 unit-state-list
 "Retrieve a page of UnitState objects."
 {:sig [[Connection
         {(schema.core/optional-key :machineID) schema.core/Str,
          (schema.core/optional-key :unitName) schema.core/Str,
          (schema.core/optional-key :nextPageToken) schema.core/Str}
         :-
         UnitStatePage]]}
 [connection options]
 (clojure.core/->
  (clj-http.client/get
   (clojure.core/str
    (:endpoint connection)
    "/v1-alpha/"
    (clojure.core/-> "state"))
   {:as :json})
  :body))


